%define name	xine-ui
%define version	0.99.9
%define release	1

%define major   1
%define libname libxine%{major}
%define libvers 1

%define skindir    %{_datadir}/xine/skins
%define deskdir    %{_datadir}/xine/desktop

%define	ginstall install -c

Name:        %{name}
Summary:     A Free Audio/Video Player.
Summary(cs): Voln audio a video pehrďż˝aďż˝
Summary(de): Ein freies Audio- und Video-Abspielprogramm
Version:     %{version}
Release:     %{release}
License:     GPL
Group:       Applications/Multimedia
Source:      http://prdownloads.sourceforge.net/xine/%{name}-%{version}.tar.bz2
URL:         http://www.xine-project.org/
Packager:    Manfred Tremmel <Manfred.Tremmel@iiv.de>
Requires:    %{libname} >= %{libvers}
Requires:    curl
Requires:    readline
BuildPreReq: %{libname}-devel >= %{libvers}
BuildRoot:   %{_tmppath}/%{name}-buildroot

%description
xine is a fully-featured free audio/video player for unix-like systems which
uses libxine for audio/video decoding and playback. For more informations on
what formats are supported, please refer to the libxine documentation.

%description -l cs
xine je víceúčelový volně šiřitelný audio a video přehrávač pro unixovské
systémy, který používá libxine k dekódování zvuku a videa a k přehrávání.
Více informací o tom, jaké formáty jsou podporovány získáte v dokumentaci
od libxine.

%description -l de
xine ist ein freies Audio- und Video-Abspielprogramm für unixartige Systeme
mit umfassenden Funktionen. Zur Audio- und Videodekodierung und Wiedergabe
werden die xine-Bibliotheken aus libxine verwendet. Weitere Informationen
ber die untersttzten Formate entnehmen Sie in der Dokumentation zu libxine.

%prep
%setup -n %{name}-%{version}

%build
export CFLAGS="${RPM_OPT_FLAGS}"
export XINE_DOCPATH="%{_docdir}/xine-ui"

if [ ! -f configure ]; then
   NO_CONFIGURE=1 ./autogen.sh
fi

#
# currently we do not use %%configure as it seems to cause trouble with
# certain automake produced configure scripts - depending on automake version.
#
./configure --build=%{_target_platform} --prefix=%{_prefix} \
	    --exec-prefix=%{_exec_prefix} --bindir=%{_bindir} \
	    --sbindir=%{_sbindir} --sysconfdir=%{_sysconfdir} \
	    --datadir=%{_datadir} --includedir=%{_includedir} \
	    --libdir=%{_libdir} --libexecdir=%{_libexecdir} \
	    --localstatedir=%{_localstatedir} \
	    --sharedstatedir=%{_sharedstatedir} --mandir=%{_mandir} \
	    --infodir=%{_infodir}

%{__make} %{?jobs:-j%{jobs}}

%install
[ "${RPM_BUILD_ROOT}" != "/" ] && %{__rm} -rf ${RPM_BUILD_ROOT}
make DESTDIR=${RPM_BUILD_ROOT} install
%{__rm} -rf ${RPM_BUILD_ROOT}/%{deskdir}

%clean
[ "${RPM_BUILD_ROOT}" != "/" ] && %{__rm} -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%doc %{_docdir}/*
%doc %{_datadir}/doc/xitk/*
%{_bindir}/*
%{skindir}/*
%{_datadir}/pixmaps/*
%{_datadir}/xine/visuals/*
%{_datadir}/xine/oxine/*
%{_datadir}/icons/hicolor/*/apps/xine.png
%{_datadir}/applications/xine.desktop
%{_datadir}/mime/packages/xine-ui.xml
%lang(de) %{_mandir}/de/man1/*
%lang(fr) %{_mandir}/fr/man1/*
%lang(es) %{_mandir}/es/man1/*
%lang(pl) %{_mandir}/pl/man1/*
%{_mandir}/man1/*
%{_datadir}/locale/*

%changelog
* Fri Feb 15 2008 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- rework of the spec-file, also based on the work of Chris Rankin
* Sat Nov 05 2005 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- changed Copyright to License
* Sun Oct 30 2005 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- added icons directory to file list
* Mon Feb 07 2005 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- added oxine directory to the files
* Fri Apr 09 2004 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- removed ugly hack to use the right docdir end set XINE_DOCPATH instead
* Sun Jan 18 2004 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- added readline and curl dependency
* Wed May 14 2003 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Update for > 0.9.20
* Sun Mar 09 2003 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Some more cleanups
- lsf patch included
* Sat Jan 11 2003 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Some cleanups
* Fri Dec 06 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- do post and pre only when install and remove, saves entries at update
* Sat Nov 16 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- replaced cvscompile.sh with autogen.sh
* Sat Nov 09 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Final changes for libxine 1.0alpha1
* Wed Nov 06 2002 Bill Fink <billfink@mindspring.com>
- Some more changes for latest xine version
* Mon Nov 04 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Changes for next xine version
* Sun Oct 27 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Update of the german descriptions.
- fixed some problems with creating kde2 and kde3 menu-entry
* Mon May 27 2002 Matthias Dahl <matthew2k@web.de>
- added passing of build parameter to configure
* Sun May 26 2002 Matthias Dahl <matthew2k@web.de>
- added more kde2 and kde3 fixes by Manfred Tremmel <Manfred.Tremmel@iiv.de>
* Sun May 20 2002 Matthias Dahl <matthew2k@web.de>
- added kde2 bugfix by Manfred Tremmel <Manfred.Tremmel@iiv.de>
- added german description by Manfred Tremmel <Manfred.Tremmel@iiv.de>
* Sun May 20 2002 Matthias Dahl <matthew2k@web.de>
- added kde3 support by Manfred Tremmel <Manfred.Tremmel@iiv.de>
* Sat May 18 2002 Matthias Dahl <matthew2k@web.de>
- added czech translations by Frantisek Dvorak <valtri@atlas.cz>
* Thu May 16 2002 Matthias Dahl <matthew2k@web.de>
- replaced %configure because it was causing trouble on some configurations
* Sat May 11 2002 Matthias Dahl <matthew2k@web.de>
- reworked/revamped spec file, still needs some tuning (BuildPreReq, ...)
* Fri May 03 2002 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- add xitk README file.
* Sun Mar 31 2002 Matthias Dahl <matthew2k@web.de>
- added xine-bugreport and xine-check, including their man pages.
- added german man pages and README_fi.
* Fri Dec 14 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add portuguese brazilian *.mo files: thanks to Miguel Freitas <miguel@cetuc.puc-rio.br> ;-)
* Tue Nov 27 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add spanish *.mo files: thanks to Juan Manuel Garcďż˝ Molina <juanmagm@mail.com>
* Sun Nov 18 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add *.mo files
* Wed Oct 3 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- use DESTDIR for package building and add xineshot, based on patch from Andrew Meredith <andrew@anvil.org>
* Thu Sep 27 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add icons and desktop stuff from patches by Miguel Freitas <miguel@cetuc.puc-rio.br>
* Sun Sep 16 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Merge patch from Josďż˝Carlos Monteiro <jcm@netcabo.pt>:
  - Filelist and other minor updates,
  - Fixed some SuSE compatibility issues,
  - Added Portuguese summary.
* Sun Sep 16 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add missing files.
* Thu Jul 26 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Made AA as separate package.
* Thu Jul 26 2001 Matthias Dahl <matthew2k@web.de>
- updated filelist.
* Tue Jul 03 2001 Matthias Dahl <matthew2k@web.de>
- fixed the "no-skins-in-final-RPM-package" problem (nice explanation *grin*)
* Sun Jun 10 2001 Matthias Dahl <matthew2k@web.de>
- updated filelist and the requirements field
- removed /sbin/ldconfig as post install script
* Thu Mar 28 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- add korean summary, patch from Louis JANG <louis@ns.mizi.com>
* Thu Jan 11 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- patch from Sung-Hyun Nam <namsh@lgic.co.kr> applied.
* Fri Oct 17 2000 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- first spec file.
