# Contributing to Angular-File-Upload

:+1::tada: Welcome in angular-file-upload community :tada::+1:

The following is a set of guidelines for contributing to Angular-File-Upload.
These are just guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request.

Note : this guide is inspired by https://github.com/atom/atom/blob/master/CONTRIBUTING.md 

#### Table Of Contents

[How Can I Contribute?](#how-can-i-contribute)
  * [Reporting Bugs](#reporting-bugs)
  * [Suggesting Enhancements](#suggesting-enhancements)
  * [Pull Requests](#pull-requests)

[Additional Notes](#additional-notes)
  * [Issue and Pull Request Labels](#issue-and-pull-request-labels)
  * [Contributors Communication](#contributors-communication)

## How Can I Contribute?

### Reporting Bugs

This section guides you through submitting a bug report for Angular-File-Upload. Following these guidelines helps maintainers and the community understand your report :pencil:, reproduce the behavior :computer: :computer:, and find related reports :mag_right:.

Fill out [the required template](ISSUE_TEMPLATE.md), the information it asks for helps us resolve issues faster.
* Before Submitting A Bug Report : **Perform a [quick search](https://github.com/nervgh/angular-file-upload/issues)** to see if the problem has already been reported. If it has, add a comment to the existing issue instead of opening a new one.
* When you are creating a bug report, please include as many details as possible, explain the problem and include additional details to help maintainers reproduce the problem:

  * **Use a clear and descriptive title** for the issue to identify the problem.
  * **Describe the exact steps which reproduce the problem** in as many details as possible. For example, start by explaining how you are using Angulare-File-Upload. When listing steps, **don't just say what you did, but explain how you did it**. For example, if you upload a file, explain if you did it by clicking on a button or if you have started the upload programmatically?
  * **Provide specific examples to demonstrate the steps**. Include links to files or GitHub projects, or copy/pasteable snippets, which you use in those examples. If you're providing snippets in the issue, use [Markdown code blocks](https://help.github.com/articles/markdown-basics/#multiple-lines).
  * **Describe the behavior you observed after following the steps** and point out what exactly is the problem with that behavior.
  * **Explain which behavior you expected to see instead and why.**
  * **Include screenshots and animated GIFs** which show you following the described steps and clearly demonstrate the problem. If you use the keyboard while following the steps. You can use [this tool](http://www.cockos.com/licecap/) to record GIFs on macOS and Windows, and [this tool](https://github.com/colinkeenan/silentcast) or [this tool](https://github.com/GNOME/byzanz) on Linux.
  * **If you're reporting that Angular-File-Upload crashed**, include a crash report with a stack trace from the browser stack. On macOS, the crash report will be available and put it in a [gist](https://gist.github.com/) and provide link to that gist.

  Provide more context by answering these questions:

  * **Did the problem start happening recently** (e.g. after updating to a new version of Angular-File-Upload) or was this always a problem?
  * **Can you reliably reproduce the issue?** If not, provide details about how often the problem happens and under which conditions it normally happens.
  * **Does the problem happen for all files or only some?** Does the problem happen only when working with local or remote files (e.g. on network drives), with files of a specific type (e.g. only JavaScript or Python files), with large files or files with very long lines, or with files in a specific encoding? Is there anything else special about the files you are using?

Include details about your configuration and environment:

  * **Which browser are you using?** ?
  * **What's the name and version of the OS you're using**?

### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for Angular-File-Upload, including completely new features and minor improvements to existing functionality. Following these guidelines helps maintainers and the community understand your suggestion :pencil: and find related suggestions :mag_right:.
* Before Submitting An Enhancement : **Perform a [quick search](https://github.com/nervgh/angular-file-upload/issues)** to see if the enhancement has already been suggested. If it has, add a comment to the existing issue instead of opening a new one.

  Enhancement suggestions are tracked as [GitHub issues](https://guides.github.com/features/issues/). Provide the following information:

  * **Use a clear and descriptive title** for the issue to identify the suggestion.
  * **Provide a step-by-step description of the suggested enhancement** in as many details as possible.
  * **Provide specific examples to demonstrate the steps**. Include copy/pasteable snippets which you use in those examples, as [Markdown code blocks](https://help.github.com/articles/markdown-basics/#multiple-lines).
  * **Describe the current behavior** and **explain which behavior you expected to see instead** and why.
  * **Include screenshots and animated GIFs** which help you demonstrate the steps or point out the part of Angular-File-Upload which the suggestion is related to. You can use [this tool](http://www.cockos.com/licecap/) to record GIFs on macOS and Windows, and [this tool](https://github.com/colinkeenan/silentcast) or [this tool](https://github.com/GNOME/byzanz) on Linux.
  * **Explain why this enhancement would be useful** to most Angular-File-Upload users.
  * **List some other uploader libs or usages where this enhancement exists.**

### Pull Requests

* Follow [standardJS](https://github.com/feross/standard) styleguides.
* Include thoughtfully-worded, [protractor](http://www.protractortest.org/#/) tests
* Document new code based using [jsdoc](http://usejsdoc.org/)

## Additional Notes

### Issue and Pull Request Labels

Feel free to grade issues and PRs by tags if it helps you work.
You can create any labels what you need and you can manage project using these labels.

### Contributors Communication

To participate to discussion, please ask access to [nervgh](https://github.com/nervgh) to the telegram group of contributors.
