# CiviCRM 5.68.0

Released December 6, 2023

- **[Synopsis](#synopsis)**
- **[Security advisories](#security)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |


## <a name="features"></a>Features

### Core CiviCRM

- **Allow blank message templates
  ([27806](https://github.com/civicrm/civicrm-core/pull/27806))**

  Makes it so one can have empty message templates.

- **Blank out the text version of the offline receipt template
  ([27733](https://github.com/civicrm/civicrm-core/pull/27733) and
  [27739](https://github.com/civicrm/civicrm-core/pull/27739))**

  Discontinues the text version of the offline event receipt. Instead of having
  the end user enter an html and text version of the same email, the text
  version is now autogenerated based on the html version. Adds a upgrade message
  to warn the end user about this change.

- **Add custom field type Hidden
  ([27235](https://github.com/civicrm/civicrm-core/pull/27235))**

  Adds a "hidden" custom field type which can collect data on forms without
  being seen (e.g. by storing a value from the url or set by javascript)

- **QuickSearch - Add Current Employer option
  ([27766](https://github.com/civicrm/civicrm-core/pull/27766))**

  Adds a "Current Employer" search option to QuickSearch.

- **Feature request: New contact buttons on the API 4 autocomplete widget
  ([dev/core#4484](https://lab.civicrm.org/dev/core/-/issues/4484):
  [27754](https://github.com/civicrm/civicrm-core/pull/27754))**

  Adds the option to include create contact functionality when configuring an
  APIv4 autocomplete widget.

- **Allow to specify API4 job entity in Edit Job form
  ([27849](https://github.com/civicrm/civicrm-core/pull/27849))**

  Changes the edit scheduled job form entity field from a magic field to a text
  field.

- **🔡 SearchKit, add case-sensitive pattern matching search operators using
  REGEXP BINARY and NOT REGEXP BINARY
  ([27511](https://github.com/civicrm/civicrm-core/pull/27511))**

  Makes it so one can use case-sensitive pattern matching search operators in
  SearchKit using REGEXP BINARY and NOT REGEXP BINARY.

- **SearchKit - Optionally remember filter values when user revisits search
  ([27737](https://github.com/civicrm/civicrm-core/pull/27737))**

  Adds a "Remember Filters" SearchKit administrator setting which when checked
  saves end user filter values.

- **SearchKit - Increase date range for in-place edit
  ([27935](https://github.com/civicrm/civicrm-core/pull/27935))**

  Increases min/max datepicker limits in SearchKit.

- **Expose URL for mailing trackable link for filters in FormBuilder
  ([27723](https://github.com/civicrm/civicrm-core/pull/27723))**

  Improves FormBuilder by exposing the mailing trackable link url.

- **ManagedEntity - Replicate multi-domain entities when multisite is enabled
  ([27876](https://github.com/civicrm/civicrm-core/pull/27876))**

  Makes it easier to add menu items from extensions (multisite or not).

- **Setting Admin - Add mixin to autogenerate a settings form
  ([27569](https://github.com/civicrm/civicrm-core/pull/27569))**

  Makes it easier for extension developers to add a settings form to an
  extension.

- **Update civicrm_state_province.tpl
  ([27784](https://github.com/civicrm/civicrm-core/pull/27784) and
  [27799](https://github.com/civicrm/civicrm-core/pull/27799))**

  Updates Norwegian provinces.

- **Add translation tags
  ([27767](https://github.com/civicrm/civicrm-core/pull/27767))**

  Adds translation tags to MessageTemplate.

- **Tags - Add label field, enable tags as Managed Entities
  ([27752](https://github.com/civicrm/civicrm-core/pull/27752))**

  Adds a label field to the tag entity.

- **demo data needs updating for tag changes
 ([dev/core#4710](https://lab.civicrm.org/dev/core/-/issues/4710):
 [27866](https://github.com/civicrm/civicrm-core/pull/27866))**

  Updates tag demo data to have labels.

- **Basic/Advanced search and CiviReport filters showing `name` in tag dropdown
  instead of `label`
  ([dev/core#4727](https://lab.civicrm.org/dev/core/-/issues/4727):
  [27924](https://github.com/civicrm/civicrm-core/pull/27924))**

  Ensures search and report filters show tag label instead of name.

- **Add user_dashboard core extension (alpha)
  ([27792](https://github.com/civicrm/civicrm-core/pull/27792))**

  Adds a `user dashboard` extension. If you enable the new "User Dashboard"
  extension, `civicrm/user` gives you an Afform of configurable Search Displays.

- **Civi-Import change the description
  ([dev/core#4714](https://lab.civicrm.org/dev/core/-/issues/4714):
  [27933](https://github.com/civicrm/civicrm-core/pull/27933))**

  Improves wording of the CiviImport extension description.

### CiviEvent

- **Add event.self_cancel_xfer tokens
  ([27785](https://github.com/civicrm/civicrm-core/pull/27785))**

  Makes `{event.allow_selfcancelxfer}` token available (can be used as
  `{event.allow_selfcancelxfer|boolean}`.

- **SearchKit - Add Event.remaining_participants calculated field
  ([27839](https://github.com/civicrm/civicrm-core/pull/27839))**

  Adds calculated field `Event.remaining_participants` to SearchKit.

### CiviMail

- **CiviMail - Speed up generation of VERP URLs
  ([27652](https://github.com/civicrm/civicrm-core/pull/27652))**

  Performance improvement when generating VERP urls.

### CiviPetition

- **Add label & color to CiviPetition 'Unconfirmed' tag
  ([27979](https://github.com/civicrm/civicrm-core/pull/27979))**

  Adds translation and color to CiviPetition 'Unconfirmed' tag.

- **CRM_Campaign_BAO_Petition::confirmSignature: call pre/post hooks
  ([27978](https://github.com/civicrm/civicrm-core/pull/27978))**

  Makes it so extension developers can hook into the `confirmSignature` process.

### Joomla Integration

- **Remove sidebar (at least for Joomla 4)
  ([dev/joomla#45](https://lab.civicrm.org/dev/joomla/-/issues/45):
  [27252](https://github.com/civicrm/civicrm-core/pull/27252))**

  Makes the Joomla sidebar default to closed.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Number field input validation does not respect decimal separator setting
  ([dev/core#4154](https://lab.civicrm.org/dev/core/-/issues/4154):
  [28371](https://github.com/civicrm/civicrm-core/pull/28371),
  [27958](https://github.com/civicrm/civicrm-core/pull/27958) and
  [27917](https://github.com/civicrm/civicrm-core/pull/27917))**

  Fixes locale-formatted number custom field inputs.

- **Afform: Adding forms to menu is not compatible with Customize Navigation
  Menu (Work Towards
  [dev/core#4364](https://lab.civicrm.org/dev/core/-/issues/4364):
  [27832](https://github.com/civicrm/civicrm-core/pull/27832) and
  [27814](https://github.com/civicrm/civicrm-core/pull/27814))**

  Ensure navigation menu weights don't reset weights when updating a managed
  entity.

- **SearchKit - Fix Search Segments for contact type entities
  ([28396](https://github.com/civicrm/civicrm-core/pull/28396))**
  
- **SearchKit - Fix toolbar display when not using pager
  ([28409](https://github.com/civicrm/civicrm-core/pull/28409))**

- **Searchkit column styles and icons not working properly with all conditionals
  for custom fields
  ([dev/core#4638](https://lab.civicrm.org/dev/core/-/issues/4638):
  [27863](https://github.com/civicrm/civicrm-core/pull/27863))**

- **Custom Field display code assumes option values are numeric
  ([dev/core#4709](https://lab.civicrm.org/dev/core/-/issues/4709):
  [27865](https://github.com/civicrm/civicrm-core/pull/27865))**

- **Menu missing - error in console
  ([dev/core#4729](https://lab.civicrm.org/dev/core/-/issues/4729):
  [27921](https://github.com/civicrm/civicrm-core/pull/27921))and
  [dev/core#4778](https://lab.civicrm.org/dev/core/-/issues/4778):
  [28153](https://github.com/civicrm/civicrm-core/pull/28153))**

- **SearchKit/Form Builder: re-positioning menu links column in table display
  breaks csv download
  ([dev/core#4731](https://lab.civicrm.org/dev/core/-/issues/4731):
  [27943](https://github.com/civicrm/civicrm-core/pull/27943))**

- **New individual popup to create one on-the-fly is popping up the cms user
  account creation form not the usual profile popup
  ([dev/core#4736](https://lab.civicrm.org/dev/core/-/issues/4736):
  [27960](https://github.com/civicrm/civicrm-core/pull/27960))**

- **Activity.getFields crashes
  ([dev/core#4737](https://lab.civicrm.org/dev/core/-/issues/4737):
  [27966](https://github.com/civicrm/civicrm-core/pull/27966))**

  APIv4 getFields crashes with no tags.

- **Ability to assign a tagset tag to a contact has gone missing if label is
  different from name
  ([dev/core#4740](https://lab.civicrm.org/dev/core/-/issues/4740):
  [28145](https://github.com/civicrm/civicrm-core/pull/28145))**

- **Activity type label has gone missing when editing case activity
  ([dev/core#4755](https://lab.civicrm.org/dev/core/-/issues/4755):
  [28036](https://github.com/civicrm/civicrm-core/pull/28036))**

- **Search Preferences -> Autocomplete Contact Search selections not respected
  ([dev/core#4759](https://lab.civicrm.org/dev/core/-/issues/4759):
  [28121](https://github.com/civicrm/civicrm-core/pull/28121))**

  Ensures "Autocomplete Contact Search" preferences are respected in menubar
  quicksearch.

- **ACL revamp causes crashes on many SearchKit queries in 5.67
  ([dev/core#4773](https://lab.civicrm.org/dev/core/-/issues/4773):
  [28124](https://github.com/civicrm/civicrm-core/pull/28124))**

- **SearchKit - Fix field transformation UI to handle number 0
  ([28018](https://github.com/civicrm/civicrm-core/pull/28018))**

- **SearchKit - Fix missing label on group concat distinct dropdown
  ([28187](https://github.com/civicrm/civicrm-core/pull/28187))**

- **APIv4 - Prevent fatal errors when getOptions returns an empty array
  ([27793](https://github.com/civicrm/civicrm-core/pull/27793))**

- **APIv4 - Allow is_active field to default to '0'
  ([27853](https://github.com/civicrm/civicrm-core/pull/27853))**

- **APIv4 - Fix index interfering with HAVING
  ([28137](https://github.com/civicrm/civicrm-core/pull/28137))**

- **APIv4 - Fix missing tag filer on Individual,Organization,Household
  ([28103](https://github.com/civicrm/civicrm-core/pull/28103))**

- **APIv4 - Ensure 'search_fields' defaults to 'label_field' for Entity.get
  ([27993](https://github.com/civicrm/civicrm-core/pull/27993))**

- **APIv4 - Smarter matching params in Managed export action
  ([27942](https://github.com/civicrm/civicrm-core/pull/27942))**

  Does a better job of setting the match param when exporting managed
  entities.

- **Afform - Remove redundant status checks
  ([27927](https://github.com/civicrm/civicrm-core/pull/27927))**

- **Afform - Improve error handling during form submission
  ([27899](https://github.com/civicrm/civicrm-core/pull/27899))**

- **Afform - Add default values to metadata
  ([27861](https://github.com/civicrm/civicrm-core/pull/27861))**

- **Update the parameters passed to the hook_QueueTaskError
  ([28130](https://github.com/civicrm/civicrm-core/pull/28130))**

- **Ensure api/v3/utils.php required before civicrm_api3_create_error 5.68
  ([28079](https://github.com/civicrm/civicrm-core/pull/28079))**

- **Releaser - Only update core extensions for stable versions
  ([27922](https://github.com/civicrm/civicrm-core/pull/27922))**

- **Improve template handling in report
  ([27912](https://github.com/civicrm/civicrm-core/pull/27912))**

  xss bug fix.

- **CustomGroup - Allow increasing max_multiple
  ([27916](https://github.com/civicrm/civicrm-core/pull/27916))**

  Fixes a bug in the CustomGroup form code that wouldn't allow max_mutliple to
  be increased for multi-record custom groups.

- **Switch templates to use correctly named variable
  ([27498](https://github.com/civicrm/civicrm-core/pull/27498))**

- **CRM_Core_DAO::copyValues() deduplicate pseudo-constant fields  
  ([27762](https://github.com/civicrm/civicrm-core/pull/27762))**

- **Use purify over escape for price set fields
  ([27938](https://github.com/civicrm/civicrm-core/pull/27938))**

- **Tweak money/numeric error messages to not mention point (could be a comma)
  ([27881](https://github.com/civicrm/civicrm-core/pull/27881))**

- **Remove discussion about format from html box on email form
  ([27734](https://github.com/civicrm/civicrm-core/pull/27734))**

- **CRM_Core_BAO_Domain - Deprecate unused functions
  ([27875](https://github.com/civicrm/civicrm-core/pull/27875))**

- **SearchUI - Move 'Experimental' menu from top level to underneath 'Search'
  ([27871](https://github.com/civicrm/civicrm-core/pull/27871))**

- **Make civicrm_acl.is_active required and default=1
  ([27846](https://github.com/civicrm/civicrm-core/pull/27846))**

- **ManagedEntities - Recreate deleted records at discretion of update policy
  ([27844](https://github.com/civicrm/civicrm-core/pull/27844))**

- **Remove es6 polyfill
  ([27648](https://github.com/civicrm/civicrm-core/pull/27648))**

- **Move assigning customGroup to offline participant template out of the form
  layer ([27596](https://github.com/civicrm/civicrm-core/pull/27596))**

- **Searchdisplay issue with contact join activity and _ on the end of custom
  field ([27666](https://github.com/civicrm/civicrm-core/pull/27666))**

- **Email attachments with unicode filename get munged
  ([dev/core#4700](https://lab.civicrm.org/dev/core/-/issues/4700):
  [27791](https://github.com/civicrm/civicrm-core/pull/27791))**

- **Update smarty localize for Smarty3
  ([27776](https://github.com/civicrm/civicrm-core/pull/27776))**

- **Trim text emails when checking if empty
  ([27738](https://github.com/civicrm/civicrm-core/pull/27738))**

- **Clarify access of `buildComponentForm`
  ([27845](https://github.com/civicrm/civicrm-core/pull/27845))**

- **Managed - Minor schema fixes
  ([27835](https://github.com/civicrm/civicrm-core/pull/27835))**

- **Stop weird action override on confirm form
  ([27891](https://github.com/civicrm/civicrm-core/pull/27891))**

- **Suppress pay now on user dashboard if none configured
  ([27954](https://github.com/civicrm/civicrm-core/pull/27954))**

- **Fix use of `$form` for `$this` in previously shared, previously static
  function ([27925](https://github.com/civicrm/civicrm-core/pull/27925))**

- **Schedule Job fails with a fatal error if configured with an absolute date
  ([28113](https://github.com/civicrm/civicrm-core/pull/28113))**

- **standaloneusers: remove property type declarations to make php7.3 compat
  ([27992](https://github.com/civicrm/civicrm-core/pull/27992))**

- **QuickSearch - Fix redirect to adv search with prepopulated criteria
  ([28072](https://github.com/civicrm/civicrm-core/pull/28072))**

- **Fix Smarty3 support & Smarty-any notices in pledge search/dashboard
  ([27963](https://github.com/civicrm/civicrm-core/pull/27963))**

- **Smarty3 & php8.x fixes on New Contact (organization)
  ([27951](https://github.com/civicrm/civicrm-core/pull/27951))**

- **Smarty3 compatibilty with Contribution Amount tab
  ([27782](https://github.com/civicrm/civicrm-core/pull/27782))**

- **Standalone Smarty3 support
  ([27778](https://github.com/civicrm/civicrm-core/pull/27778))**

- **Smarty3 - fix space breaking syntax
  ([28002](https://github.com/civicrm/civicrm-core/pull/28002))**

- **PHP 8.x: fix TypeError in config hook
  ([27996](https://github.com/civicrm/civicrm-core/pull/27996))**

- **Php 8.2 notice fix on soft credit report
  ([27887](https://github.com/civicrm/civicrm-core/pull/27887))**

- **do not show disabled financial types in select for manage events
  ([23299](https://github.com/civicrm/civicrm-core/pull/23299))**

- **Replace smarty.get with assigned snippet_type in tpl
  ([27674](https://github.com/civicrm/civicrm-core/pull/27674))**

- **Minor variable consolidation, reduce notices
  ([27901](https://github.com/civicrm/civicrm-core/pull/27901))**

- **Stop assigning ispricelifetime - used in previously shared usage
  ([27890](https://github.com/civicrm/civicrm-core/pull/27890))**

- **Report notice fix - batch id
  ([27885](https://github.com/civicrm/civicrm-core/pull/27885))**

- **Switch to a token for billingName & address
  ([27692](https://github.com/civicrm/civicrm-core/pull/27692))**

- **Extract addOnBehalfFields, ensure variables always assigned
  ([27851](https://github.com/civicrm/civicrm-core/pull/27851))**

- **Fix tax total not showing on thank you
  ([28171](https://github.com/civicrm/civicrm-core/pull/28171))**

- **Fix notice on New Pledge form
  ([27773](https://github.com/civicrm/civicrm-core/pull/27773))**

- **Message templates not always sent
  ([dev/core#4839](https://lab.civicrm.org/dev/core/-/issues/4839):
  [28522](https://github.com/civicrm/civicrm-core/pull/28522))**

- **Fix reference to wrong value
  ([28244](https://github.com/civicrm/civicrm-core/pull/28244))**

- **Sorting of "matching field" dropdown on contact import is messed up for
  "related contact info"
  ([dev/core#4563](https://lab.civicrm.org/dev/core/-/issues/4563):
  [28375](https://github.com/civicrm/civicrm-core/pull/28375))**

- **Autocomplete-Select options not saving/displaying properly
  ([dev/core#4799](https://lab.civicrm.org/dev/core/-/issues/4799):
  [28283](https://github.com/civicrm/civicrm-core/pull/28283))**

- **UserJob - Fix deprecated syntax in addSelectWhereClause
  ([28325](https://github.com/civicrm/civicrm-core/pull/28325))**

- **On Import in Non English Mode do not import field in saved field mapping is
  not correctly set as default when re-using import
  ([dev/core#4726](https://lab.civicrm.org/dev/core/-/issues/4726):
  [28332](https://github.com/civicrm/civicrm-core/pull/28332))**

- **Fix incoming bounce processing
  ([28354](https://github.com/civicrm/civicrm-core/pull/28354))**

- **Contact ID is no longer available in Advanced Search
  ([dev/core#4820](https://lab.civicrm.org/dev/core/-/issues/4820):
  [28378](https://github.com/civicrm/civicrm-core/pull/28378))**

### CiviCase

- **Regression - CiviCase and CiviCRM 5.67.0 - Unable to load any Activities
  ([dev/core#4769](https://lab.civicrm.org/dev/core/-/issues/4769):
  [28133](https://github.com/civicrm/civicrm-core/pull/28133))**

- **Case tagsets showing name not label
  ([dev/core#4730](https://lab.civicrm.org/dev/core/-/issues/4730):
  [27968](https://github.com/civicrm/civicrm-core/pull/27968))**

- **Case Activity: use select2 for Medium field
  ([27879](https://github.com/civicrm/civicrm-core/pull/27879))**

### CiviContribute

- **Contribution fails mid-donation with geocoding, "on behalf of", and no
  state/province
  ([dev/core#4724](https://lab.civicrm.org/dev/core/-/issues/4724):
  [27896](https://github.com/civicrm/civicrm-core/pull/27896))**

- **Geocoding failures kill contributions
  ([dev/core#2929](https://lab.civicrm.org/dev/core/-/issues/2929):
  [27897](https://github.com/civicrm/civicrm-core/pull/27897) and
  [27977](https://github.com/civicrm/civicrm-core/pull/27977))**

- **Supporter Profile is a required field
  ([dev/core#4488](https://lab.civicrm.org/dev/core/-/issues/4488):
  [27059](https://github.com/civicrm/civicrm-core/pull/27059))**

  Ensures when editing contribution pages, if you click on the personal campaign
  tab and save (without changes) you get a warning about supporter profile being
  required field.

- **CiviCRM core exception when trying to import contributions
  ([dev/core#4554](https://lab.civicrm.org/dev/core/-/issues/4554):
  [28051](https://github.com/civicrm/civicrm-core/pull/28051))**

- **Clone/ copy contribution page doesn't work when admin UI is enabled
  ([dev/core#4783](https://lab.civicrm.org/dev/core/-/issues/4783):
  [28189](https://github.com/civicrm/civicrm-core/pull/28189))**

- **E_WARNING for "file" on civicontribute component settings
  ([27969](https://github.com/civicrm/civicrm-core/pull/27969))**

- **Notice fixes on price field options
  ([27984](https://github.com/civicrm/civicrm-core/pull/27984))**

- **Php8.x fixes on Main online contribution page
  ([27836](https://github.com/civicrm/civicrm-core/pull/27836))**

- **php8.2 fix undeclared properties on backoffice contribution form
  ([27829](https://github.com/civicrm/civicrm-core/pull/27829))**

- **Fix message within exception (PayPalIPN)
  ([27759](https://github.com/civicrm/civicrm-core/pull/27759))**

- **Fix source html displaying when editing price option
  ([28090](https://github.com/civicrm/civicrm-core/pull/28090))**

- **Remove one more ref to undefined property `contributeMode`
  ([27884](https://github.com/civicrm/civicrm-core/pull/27884))**

- **Fix online contribution form Confirm page to get text from processor
  ([27848](https://github.com/civicrm/civicrm-core/pull/27848))**

- **Fix offline contribution page handling of money fields
  ([27952](https://github.com/civicrm/civicrm-core/pull/27952))**

- **Fix recursive display of payment_reminders
  ([27774](https://github.com/civicrm/civicrm-core/pull/27774))**

- **Use api to get price set metadata - Online Contribution Page
  ([27902](https://github.com/civicrm/civicrm-core/pull/27902))**

- **Standardise price field metadata  on Main contribution page
  ([27889](https://github.com/civicrm/civicrm-core/pull/27889))**

- **Move financial acl check on Main contribution page to the financial acl
  extension ([27797](https://github.com/civicrm/civicrm-core/pull/27797))**

- **Add ContributionFormTrait
  ([27801](https://github.com/civicrm/civicrm-core/pull/27801))**

- **Add weight to premium config (tab on contribution page edit)
  ([28237](https://github.com/civicrm/civicrm-core/pull/28237))**

- **Contribution date no longer has a time on the form
  ([dev/financial#221](https://lab.civicrm.org/dev/financial/-/issues/221):
  [28243](https://github.com/civicrm/civicrm-core/pull/28243))**

### CiviEvent

- **Event Info displays "registration is closed", but it requires login
  ([dev/core#4704](https://lab.civicrm.org/dev/core/-/issues/4704):
  [27873](https://github.com/civicrm/civicrm-core/pull/27873))**

  Display 'registration is closed' only if users can register.

- **Event self-service transfer always gives "You do not have sufficient
  permission"([dev/core#4768](https://lab.civicrm.org/dev/core/-/issues/4768):
  [28128](https://github.com/civicrm/civicrm-core/pull/28128))**

- **PHP8.2 undefined property fix event summary report
  ([27888](https://github.com/civicrm/civicrm-core/pull/27888))**

- **Add check for deprecated token in event online receipt
  ([28029](https://github.com/civicrm/civicrm-core/pull/28029))**

- **Move participant-form-specific defaults back to participant form
  ([27613](https://github.com/civicrm/civicrm-core/pull/27613))**

- **Switch all participant token listing to TokenProcessor, add deprecation
  ([27543](https://github.com/civicrm/civicrm-core/pull/27543))**

- **event title xss fix
  ([27911](https://github.com/civicrm/civicrm-core/pull/27911))**

- **Participant - Translate untranslated string
  ([27837](https://github.com/civicrm/civicrm-core/pull/27837))**

- **Fix notice (smarty) in Event fee tab
  ([27743](https://github.com/civicrm/civicrm-core/pull/27743))**

- **Multiple Profiles on an Event registration display incorrectly
  ([dev/core#4766](https://lab.civicrm.org/dev/core/-/issues/4766):
  [28246](https://github.com/civicrm/civicrm-core/pull/28246))**

- **Copy event fails with DB Error: already exists; Saving new reminder hangs
  ([dev/core#4761](https://lab.civicrm.org/dev/core/-/issues/4761):
  [28352](https://github.com/civicrm/civicrm-core/pull/28352))**

### CiviGrant

- **Can't view/edit grants
  ([dev/core#4828](https://lab.civicrm.org/dev/core/-/issues/4828):
  [28437](https://github.com/civicrm/civicrm-core/pull/28437))**

### CiviMail

- **when processing bounce emails, don't exit on fatal error if verp unverified
  ([dev/core#4780](https://lab.civicrm.org/dev/core/-/issues/4780):
  [28192](https://github.com/civicrm/civicrm-core/pull/28192))**

- **CiviMail - Update path metadata
  ([27962](https://github.com/civicrm/civicrm-core/pull/27962))**

- **Angular - Always load CiviMail modules if component is enabled
  ([27857](https://github.com/civicrm/civicrm-core/pull/27857))**

- **Add weights to CRM_Mailing_BAO_Mailing::getContactMailingSelector
  ([28085](https://github.com/civicrm/civicrm-core/pull/28085))**

### Drupal Integration

- **Deprecated function: Optional parameter $from declared before required
  parameter $element
  ([dev/core#4695](https://lab.civicrm.org/dev/core/-/issues/4695):
  [675](https://github.com/civicrm/civicrm-drupal/pull/675))**

- **Fix Deprecated  string interpolation issue in civicrm.module
  ([674](https://github.com/civicrm/civicrm-drupal/pull/674))**

## <a name="misc"></a>Miscellany

- **Tag `getSubmittedValue()` as externally supported
  ([27786](https://github.com/civicrm/civicrm-core/pull/27786))**

- **Extend normal form for delete action
  ([27745](https://github.com/civicrm/civicrm-core/pull/27745))**

- **Core/ext - Update releaseDate when setting new version
  ([27914](https://github.com/civicrm/civicrm-core/pull/27914))**

- **Make function private, non static, after universe search
  ([27929](https://github.com/civicrm/civicrm-core/pull/27929))**

- **Move pledge block function back to the only form that calls it
  ([27936](https://github.com/civicrm/civicrm-core/pull/27936))**

- **karma.conf.js - Switch from PhantomJS to ChromeHeadless
  ([27941](https://github.com/civicrm/civicrm-core/pull/27941))**

- **Move the locale default getting from the money() function to the
  getFormatter function
  ([27970](https://github.com/civicrm/civicrm-core/pull/27970))**

- **Provide utility methods for creating an iCal file
  ([26980](https://github.com/civicrm/civicrm-core/pull/26980))**

- **Standardise deprecations
  ([27976](https://github.com/civicrm/civicrm-core/pull/27976))**

- **Afform - Unify 'is_dashlet', 'is_token' & 'contact_summary' as 'placement'
  ([27755](https://github.com/civicrm/civicrm-core/pull/27755))**

- **phpstorm - Generate hints for Civi::paths(), Civi::url(),
  CRM_Utils_System::url()
  ([27779](https://github.com/civicrm/civicrm-core/pull/27779))**

- **APIv4 - Add helper function and type hints
  ([27864](https://github.com/civicrm/civicrm-core/pull/27864))**

- **Preliminary cleanup - remove function overrides that do not override
  ([27886](https://github.com/civicrm/civicrm-core/pull/27886))**

- **Stop passing variable no longer in signature
  ([27765](https://github.com/civicrm/civicrm-core/pull/27765))**

- **PHP8.x Stop sharing EventFee::preProcess from Registration form
  ([27577](https://github.com/civicrm/civicrm-core/pull/27577))**

- **Switch from html2text to soundasleep/html2text
  ([27694](https://github.com/civicrm/civicrm-core/pull/27694))**

- **Unshare form function
  ([27892](https://github.com/civicrm/civicrm-core/pull/27892))**

- **delete one more trackingFields reference
  ([27726](https://github.com/civicrm/civicrm-core/pull/27726))**

- **Remove irrelevant code from previously shared form
  ([27787](https://github.com/civicrm/civicrm-core/pull/27787))**

- **Split shared function with mostly unshared code
  ([27795](https://github.com/civicrm/civicrm-core/pull/27795))**

- **Remove non-variable variables from previously-shared code
  ([27905](https://github.com/civicrm/civicrm-core/pull/27905))**

- **Remove unreachable code from previously shared function
  ([27906](https://github.com/civicrm/civicrm-core/pull/27906))**

- **Remove no-longer-used parameters from function signature
  ([27831](https://github.com/civicrm/civicrm-core/pull/27831))**

- **Remove always-true if
  ([27919](https://github.com/civicrm/civicrm-core/pull/27919))**

- **[PHP 8.2] fix undefined property in CRM_Event_Form_SelfSvcUpdate
  ([27769](https://github.com/civicrm/civicrm-core/pull/27769))**

- **CRM_Utils_Array::value - remove "todo" which we don't actually want to do
  ([27812](https://github.com/civicrm/civicrm-core/pull/27812))**

- **Add @deprecated annotation to CRM_Utils_Array::value
  ([27959](https://github.com/civicrm/civicrm-core/pull/27959))**

- **[REF] CRM/Contribute - Refactor unnecessary uses of CRM_Utils_Array::value
  ([27820](https://github.com/civicrm/civicrm-core/pull/27820))**

- **[REF] CRM/Campaign - Refactor unnecessary uses of CRM_Utils_Array::value
  ([27822](https://github.com/civicrm/civicrm-core/pull/27822))**

- **[REF] CRM/Admin - Refactor unnecessary uses of CRM_Utils_Array::value
  ([27823](https://github.com/civicrm/civicrm-core/pull/27823))**

- **[REF] Civi - Refactor unnecessary uses of CRM_Utils_Array::value
  ([27895](https://github.com/civicrm/civicrm-core/pull/27895))**

- **[REF] Apiv3 - Refactor unnecessary uses of CRM_Utils_Array::value
  ([27898](https://github.com/civicrm/civicrm-core/pull/27898))**

- **[REF] CRM/Report - Refactor unnecessary uses of CRM_Utils_Array::value
  ([27816](https://github.com/civicrm/civicrm-core/pull/27816))**

- **[REF] CRM/Event - Refactor unnecessary uses of CRM_Utils_Array::value
  ([27821](https://github.com/civicrm/civicrm-core/pull/27821))**

- **[REF] Flexmailer - Refactor unnecessary use of CRM_Utils_Array::value
  ([27828](https://github.com/civicrm/civicrm-core/pull/27828))**

- **[REF] CRM/Price - Refactor unnecessary uses of CRM_Utils_Array::value  
  ([27824](https://github.com/civicrm/civicrm-core/pull/27824))**

- **[REF] CRM/Utils - Refactor unnecessary uses of CRM_Utils_Array::value
  ([27819](https://github.com/civicrm/civicrm-core/pull/27819))**

- **[REF] CRM/Core - Refactor unnecessary uses of CRM_Utils_Array::value
  ([27817](https://github.com/civicrm/civicrm-core/pull/27817))**

- **[REF] CRM/Activity - Refactor unnecessary uses of CRM_Utils_Array::value
  ([27825](https://github.com/civicrm/civicrm-core/pull/27825))**

- **[REF] CRM/Mailing - Refactor unnecessary uses of CRM_Utils_Array::value
  ([27826](https://github.com/civicrm/civicrm-core/pull/27826))**

- **[REF] CRM/Contact - Refactor unnecessary uses of CRM_Utils_Array::value
  ([27818](https://github.com/civicrm/civicrm-core/pull/27818))**

- **[REF] CRM/Misc - Refactor unnecessary uses of CRM_Utils_Array::value
  ([27827](https://github.com/civicrm/civicrm-core/pull/27827))**

- **[REF] Unshared processRecurringContribution
  ([27850](https://github.com/civicrm/civicrm-core/pull/27850))**

- **[REF] ParticipantStatusType - Switch to writeRecord
  ([27855](https://github.com/civicrm/civicrm-core/pull/27855))**

- **[REF] Extract add soft credit fields
  ([27847](https://github.com/civicrm/civicrm-core/pull/27847))**

- **[REF] ManagedEntities - Remove unused function
  ([27843](https://github.com/civicrm/civicrm-core/pull/27843))**

- **[REF] civicrm_admin_ui blocks links from oauth-client
  (Work Towards [dev/core#4674](https://lab.civicrm.org/dev/core/-/issues/4674):
  [27869](https://github.com/civicrm/civicrm-core/pull/27869))**

- **[REF] Repeating entity form code cleanup
  ([27328](https://github.com/civicrm/civicrm-core/pull/27328))**

- **[REF] CRM_Core_Pseudoconstant - Cleanup static arrays & functions
  ([27840](https://github.com/civicrm/civicrm-core/pull/27840))**

- **[REF] Remove domain references from managed entities
  ([27915](https://github.com/civicrm/civicrm-core/pull/27915))**

- **[REF] CRM_Event_PseudoConstant - Cleanup redundant caching
  ([27838](https://github.com/civicrm/civicrm-core/pull/27838))**

- **[REF] AngularManager - Skip extra lookups. Document function.
  ([27807](https://github.com/civicrm/civicrm-core/pull/27807))**

- **[REF] AfformScanner - Update code comments & type hints
  ([27808](https://github.com/civicrm/civicrm-core/pull/27808))**

- **[REF] Fix Smarty Notices on Dedupe Rules screen by setting weight
  ([27804](https://github.com/civicrm/civicrm-core/pull/27804))**

- **[REF] testRegexpOperators fails on `max`
  ([dev/core#4747](https://lab.civicrm.org/dev/core/-/issues/4747):
  [27990](https://github.com/civicrm/civicrm-core/pull/27990))**

- **[REF] Fix notice error on undefined array key perm
  ([27796](https://github.com/civicrm/civicrm-core/pull/27796))**

- **[REF] Remove getEmailAddress method which cannot work
  ([27757](https://github.com/civicrm/civicrm-core/pull/27757))**

- **[REF][PHP8.2] Replace dynmaic property with variable
  ([27756](https://github.com/civicrm/civicrm-core/pull/27756))**

- **[REF] Fix up Message template gencode to work with Smarty 3
  ([27727](https://github.com/civicrm/civicrm-core/pull/27727))**

- **[NFC] Docblocks - Remove 'experimental' comments and other copy-edits
  ([27802](https://github.com/civicrm/civicrm-core/pull/27802))**

- **(NFC) MenuXmlTest - Improve debug output. Use richer helpers.
  ([28073](https://github.com/civicrm/civicrm-core/pull/28073))**

- **[NFC] More descriptive deprecation notice for Angular settings
  ([28040](https://github.com/civicrm/civicrm-core/pull/28040))**

- **(NFC) phpunit.xml.dist - Drop stale reference to old suite
  ([27859](https://github.com/civicrm/civicrm-core/pull/27859))**

- **[NFC] Cleanup array syntax in tests directory
  ([27809](https://github.com/civicrm/civicrm-core/pull/27809))**

- **[NFC] Afform - Test cleanup
  ([27803](https://github.com/civicrm/civicrm-core/pull/27803))**

- **[NFC] Make null really null
  ([27758](https://github.com/civicrm/civicrm-core/pull/27758))**

- **[NFC] Remove unused var
  ([27751](https://github.com/civicrm/civicrm-core/pull/27751))**

- **(NFC) setting-admin@1 - Fix the `@since` metadata
  ([28170](https://github.com/civicrm/civicrm-core/pull/28170))**

- **Update the list of required extensions to install during test db populate
  ([27961](https://github.com/civicrm/civicrm-core/pull/27961))**

- **Further fixes to ContributionPageTest
  ([27948](https://github.com/civicrm/civicrm-core/pull/27948))**

- **Smarty3 Clean up test class - remove ref to internal tplParams
  ([27775](https://github.com/civicrm/civicrm-core/pull/27775))**

- **Minor clean up in test class, add initial ContributionFormTrait
  ([27947](https://github.com/civicrm/civicrm-core/pull/27947))**

- **Fix test on secondary membership contribution to use full form flow
  ([27928](https://github.com/civicrm/civicrm-core/pull/27928))**

- **Remove test call to PaypalPro sandbox from tests
  ([27953](https://github.com/civicrm/civicrm-core/pull/27953))**

- **Fix MainTest to test form metadata function, not old unused function
  ([27900](https://github.com/civicrm/civicrm-core/pull/27900))**

- **Declare strict types in CiviUnitTestCase
  ([26002](https://github.com/civicrm/civicrm-core/pull/26002))**

- **Fix Contribution MainTest to set payment processor properties better
  ([27893](https://github.com/civicrm/civicrm-core/pull/27893))**

- **Document and test unique behavior of CRM_Utils_Array::value()
  ([27830](https://github.com/civicrm/civicrm-core/pull/27830))**

- **Move financial acl test to extension
  ([27810](https://github.com/civicrm/civicrm-core/pull/27810))**

- **Stop calling `CRM_Contribute_Form_Contribution::testSubmit()`, quiet
  deprecation ([27811](https://github.com/civicrm/civicrm-core/pull/27811))**

- **Fix Participant form test to correctly test html version
  ([27763](https://github.com/civicrm/civicrm-core/pull/27763))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Agileware - Justin Freeman; Artful Robot - Rich
Lott; ASMAC (American Society of Music Arrangers and Composers) - Jeff Kellem;
BrightMinded Ltd - Bradley Taylor; CiviCoop - Jaap Jansma; CiviCRM - Coleman
Watts, Tim Otten; CiviDesk - Yashodha Chaku; Coop SymbioTIC - Mathieu Lutfy,
Samuel Vanhove; Dave D; Erik Midtsveen; Freeform Solutions - Herb van den Dool;
Fuzion - Jitendra Purohit; Jens Schuppe; JMA Consulting - Monish Deb, Seamus
Lee; Lemniscus - Noah Miller; Lighthouse Consulting and Design - Brian
Shaughnessy; Luna Design - Andrew Wasson; Megaphone Technology Consulting - Jon
Goldberg; MJW Consulting - Matthew Wire; Nicol Wistreich; PHD Computer
Consultants Ltd - Chris Cant; ranjit-git; Reflexive Communications - Sandor
Semsey; Squiffle Consulting - Aidan Saunders; SYSTOPIA - Johannes Franz; Third
Sector Design - Kurund Jalmi; Wikimedia Foundation - Damilare Adedoyin, Eileen
McNaughton; Wildsight - Lars Sander-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Alice Frumin; ALL IN APPLI admin; Andrew Thompson; Benjamin W;
Davis Media Access - Darrick Servis; Francesc Bassas i Bullich; Fuzion - Peter
Davis; Jens Schuppe; OPEN - dewy; Semper IT - Karin Gerritsen; Third Sector
Design - William Mortada; Tom Rosenbloom; WebmasterBouclier;

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
