/* ----- core/wforcesntrup1013, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_wforcesntrup1013_checksums[] = {
  "d4e33f5219277f77ca64411ebcc9ee0c3d5274f5b9ebb9301d5602b2f110d767",
  "336f49eebed9c310480fd766968fdd1ad7bc3f0ba9779486e86244a77f3da07e",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_wforcesntrup1013_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_wforcesntrup1013_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_wforcesntrup1013_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_wforcesntrup1013_CONSTBYTES

static void *storage_core_wforcesntrup1013_h;
static unsigned char *test_core_wforcesntrup1013_h;
static void *storage_core_wforcesntrup1013_n;
static unsigned char *test_core_wforcesntrup1013_n;
static void *storage_core_wforcesntrup1013_k;
static unsigned char *test_core_wforcesntrup1013_k;
static void *storage_core_wforcesntrup1013_c;
static unsigned char *test_core_wforcesntrup1013_c;
static void *storage_core_wforcesntrup1013_h2;
static unsigned char *test_core_wforcesntrup1013_h2;
static void *storage_core_wforcesntrup1013_n2;
static unsigned char *test_core_wforcesntrup1013_n2;
static void *storage_core_wforcesntrup1013_k2;
static unsigned char *test_core_wforcesntrup1013_k2;
static void *storage_core_wforcesntrup1013_c2;
static unsigned char *test_core_wforcesntrup1013_c2;

#define precomputed_core_wforcesntrup1013_NUM 9

static const unsigned char precomputed_core_wforcesntrup1013_h[precomputed_core_wforcesntrup1013_NUM][crypto_core_OUTPUTBYTES] = {
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {0,255,0,1,0,255,0,0,0,0,1,0,0,255,255,0,0,0,255,255,255,1,0,0,1,1,1,0,255,0,255,0,0,255,255,0,0,0,0,0,1,255,0,255,1,0,255,0,0,255,255,1,255,1,0,0,0,1,255,255,0,0,1,0,0,0,0,0,0,1,0,0,0,1,0,0,255,0,0,1,0,0,0,1,0,1,0,255,0,255,0,1,255,255,0,0,255,0,0,1,1,1,0,0,255,0,1,1,0,255,0,255,0,0,255,0,1,0,1,0,0,0,1,0,255,1,0,255,1,1,1,0,0,255,0,0,1,1,255,1,255,255,255,1,0,255,0,1,0,0,0,0,0,0,0,255,0,255,1,0,0,255,255,0,0,0,255,1,0,255,0,0,1,255,0,0,0,0,0,0,1,1,1,255,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,1,255,1,0,0,255,0,0,0,0,255,0,0,1,0,255,0,0,0,1,0,255,0,0,1,0,0,0,1,0,0,0,1,1,0,255,0,255,255,0,0,0,255,0,0,0,0,255,0,255,1,0,0,255,255,0,0,1,0,0,255,255,255,255,0,0,255,1,255,255,255,255,0,255,0,0,0,255,0,0,0,1,255,0,0,0,0,0,0,0,0,0,1,0,255,0,1,1,0,255,0,0,1,255,0,255,255,1,0,0,0,1,255,255,1,1,0,0,255,255,0,1,255,0,1,255,1,1,0,255,0,0,255,255,0,1,0,0,0,1,0,255,255,0,1,0,1,0,0,255,1,0,255,0,1,1,0,1,255,0,0,0,0,255,1,0,0,0,0,1,1,255,255,0,0,0,255,1,255,1,0,1,1,255,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,1,255,0,1,0,0,255,1,1,0,0,0,255,0,0,255,1,255,0,1,0,0,0,0,0,255,1,0,1,255,0,255,0,0,255,255,0,255,255,0,0,0,255,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,255,0,0,255,1,0,0,0,0,0,255,255,0,0,0,0,1,0,0,255,0,0,0,1,0,0,255,0,1,0,0,0,255,0,1,0,255,255,255,0,0,255,255,0,0,1,0,0,0,0,0,0,255,255,1,0,0,0,1,0,0,255,255,1,1,0,0,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,1,255,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,255,0,1,255,0,0,0,255,255,0,0,0,1,0,255,255,255,1,0,1,255,1,1,255,255,0,1,1,0,1,1,0,255,0,255,0,255,255,0,0,255,255,0,1,0,0,255,0,1,1,255,1,0,0,255,0,255,255,1,255,255,0,255,1,255,0,0,1,255,0,0,0,255,0,1,0,1,0,0,0,0,255,255,0,0,255,1,255,0,0,1,255,255,0,1,0,255,255,0,255,1,1,1,0,0,0,1,0,255,0,1,0,0,0,1,1,0,1,1,1,0,1,255,0,0,1,255,0,1,0,255,0,0,255,0,0,0,255,0,255,1,255,0,255,0,0,0,0,255,0,1,1,0,255,0,1,0,0,255,0,255,0,0,0,0,0,0,255,0,255,1,255,255,0,0,0,0,0,0,1,255,1,255,0,1,1,1,0,0,0,255,0,255,255,1,255,0,0,0,1,0,0,1,0,0,0,255,255,1,255,1,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,255,255,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,1,255,0,0,0,255,0,255,255,0,0,0,0,1,0,255,1,255,255,0,255,0,0,0,0,1,0,1,1,255,0,255,0,255,0,255,0,0,1,1,0,1,0,255,0,0,255,255,1,0,0,0,0,0,0,0,1,0,0,0,1,1,0,255,255,255,1,0,255,255,1,1,255,0,1,1,0,1,255,0,0,0,255,255,0,0,255,0,0,0,255,1,0,0,0,0,0,1,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,0,0,1,255,0,1,0,0,255,0,0,0,255,1,255,0,255,255,255,1,1,0,0,0,255,0,0,1,0,0,0,0,0,255,1,0,0,1,255,1,0,0,0,255,1,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,255,0,1,255,0,255,255,255,1,255},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
} ;

static const unsigned char precomputed_core_wforcesntrup1013_n[precomputed_core_wforcesntrup1013_NUM][crypto_core_INPUTBYTES] = {
  {25,27,143,246,234,88,86,174,8,34,215,79,62,194,244,11,6,136,133,117,201,7,241,211,105,156,118,198,83,65,165,243,21,179,147,64,178,3,114,134,216,46,123,209,252,77,47,171,44,224,192,248,134,178,110,34,81,230,110,145,234,159,104,200,140,156,225,78,106,200,47,91,249,95,188,164,33,134,63,173,103,212,78,71,92,89,61,39,12,110,59,26,107,92,218,254,83,248,130,183,80,134,159,156,90,71,227,243,5,49,185,136,77,75,11,155,226,165,8,47,96,144,132,249,166,74,190,117,223,84,216,64,66,109,73,250,195,27,62,11,87,98,163,137,117,129,201,242,46,214,110,20,221,9,232,112,117,246,184,236,249,18,217,74,61,167,99,164,210,107,64,239,85,39,183,67,48,136,128,117,137,42,118,243,52,197,109,58,13,242,237,116,11,33,168,208,20,169,155,239,217,140,235,140,234,11,88,86,171,175,31,249,10,156,61,52,2,108,7,235,211,244,110,148,24,184,176,46,42,67,99,139,132,105,85,178,50,234,119,189,206,148,250,131,42,183,215,22,193,161,179,86,91,107,18,181,232,47,14,144,126,155,173,115,50,163,161,62,194,20,239,238,227,99,239,96,106,127,236,149,118,136,174,200,10,23,109,191,121,154,213,18,7,234,116,173,29,150,185,242,142,233,17,99,99,23,249,205,126,246,9,145,98,231,153,128,196,28,105,10,91,225,165,103,242,118,139,226,164,163,180,0,19,39,252,64,184,254,60,78,43,215,7,126,153,138,108,137,212,106,236,217,134,31,229,185,74,29,242,147,215,119,56,44,29,75,240,158,192,15,188,24,180,72,177,62,62,109,128,206,51,126,10,107,67,67,172,57,11,40,160,58,10,59,193,56,233,185,98,239,16,148,9,162,100,224,150,158,137,23,62,28,103,33,100,207,206,31,62,197,147,130,31,231,120,77,30,114,185,81,222,45,211,23,134,94,236,175,76,10,148,167,245,121,80,223,217,203,209,202,58,135,203,247,101,196,0,213,197,53,137,0,7,137,195,31,222,228,236,89,22,101,227,168,179,17,243,178,7,210,89,111,47,244,147,104,234,135,158,253,108,141,209,186,122,215,221,135,21,212,126,139,241,200,226,130,50,174,75,247,105,218,24,143,162,137,99,178,38,37,151,184,242,210,134,233,114,135,61,11,43,97,192,87,8,149,205,15,250,1,218,100,67,220,63,123,101,12,77,139,232,156,41,129,75,112,146,92,145,78,71,162,121,153,113,212,39,89,3,149,135,87,244,114,63,45,179,89,159,106,211,97,88,126,7,66,77,65,18,142,7,253,234,147,24,234,129,255,1,164,200,147,171,38,183,33,240,197,15,231,213,226,38,166,46,64,111,11,215,233,231,107,222,201,27,216,247,95,23,117,12,227,153,154,231,53,96,154,255,191,164,212,235,88,72,177,12,228,57,75,70,127,181,192,178,118,204,169,151,83,231,21,5,212,56,83,169,140,216,231,218,154,114,205,217,65,129,58,61,140,154,177,100,105,26,216,24,56,224,234,228,130,175,245,2,247,169,31,234,14,182,188,3,177,210,228,210,87,114,221,53,163,87,80,162,101,163,207,144,140,220,35,174,162,104,230,89,245,153,61,33,94,81,178,10,2,146,252,217,179,112,155,241,200,68,121,104,73,165,49,140,170,94,163,30,112,230,232,125,91,17,173,189,101,50,46,236,225,161,160,108,190,85,233,155,250,14,199,234,226,77,135,142,92,174,233,250,81,166,48,155,171,245,34,84,55,125,252,7,139,162,207,66,185,197,105,42,163,49,244,244,49,130,197,195,3,242,69,236,199,254,154,249,238,23,212,145,222,230,107,196,72,25,54,0,131,59,42,226,146,121,149,139,4,246,215,175,132,183,244,123,97,223,249,22,61,140,43,179,73,176,120,56,208,98,222,214,57,60,98,206,150,3,67,179,88,174,82,27,193,23,79,109,117,120,96,89,235,58,55,14,99,90,178,209,11,136,29,224,9,139,110,213,115,218,211,149,250,196,116,212,71,247,31,42,2,41,5,224,169,115,184,94,190,42,178,173,93,20,94,7,241,136,62,10,164,84,61,255,92,191,69,0,139,82,245,145,130,120,17,207,68,27,157,27,147,210,170,132,196,139,63,20,101,182,55,11,178,94,98,247,65,21,60,63,236,30,241,46,236,8,253,102,159,198,159,104,24,101,166,82,126,68,238,249,188,172,176,126,126,37,201,223,44,130,80,92,214,247,248,219,246,118},
  {89,127,42,16,248,28,141,88,128,228,30,92,186,179,101,252,227,227,79,17,253,67,147,106,112,205,152,177,238,251,35,246,136,240,213,179,222,204,105,55,77,33,176,194,83,87,183,105,71,30,67,138,79,248,133,87,29,72,109,31,24,56,191,94,177,82,238,5,126,164,51,230,243,210,243,75,88,158,74,252,254,108,42,162,59,182,254,100,126,196,91,30,63,188,249,106,147,27,87,69,104,255,166,192,49,178,158,143,35,93,19,91,4,54,152,50,225,244,120,81,63,86,27,148,7,99,142,118,94,171,118,77,168,157,94,150,249,129,220,182,49,49,121,14,224,117,109,237,66,231,52,145,220,74,161,184,196,231,126,171,97,32,6,105,140,133,13,118,14,202,30,160,231,104,141,134,74,242,250,97,78,230,87,188,86,243,11,251,165,96,200,16,20,199,68,81,202,11,253,91,35,50,85,218,206,160,203,86,147,32,212,143,150,50,205,231,75,17,117,146,41,159,169,36,205,126,146,161,56,255,154,169,215,76,203,237,70,215,151,70,163,252,188,185,176,175,158,52,15,85,239,250,26,98,143,212,50,193,136,224,188,66,62,18,157,24,60,88,205,24,23,170,201,216,203,201,91,242,45,223,22,231,53,231,190,104,22,148,47,72,180,166,198,2,1,55,158,230,93,90,199,145,187,20,243,185,174,91,140,12,67,234,142,96,183,190,237,190,162,47,203,48,11,73,51,159,19,21,103,50,144,251,182,220,198,57,175,223,59,26,148,233,113,81,51,177,250,125,26,129,231,9,161,230,244,79,111,214,207,111,4,123,190,251,227,250,220,101,18,134,53,88,154,166,200,247,109,47,207,175,193,40,44,86,149,251,174,17,5,159,255,148,173,214,20,164,167,183,248,111,110,252,155,45,151,67,139,36,230,24,199,244,217,78,158,20,165,198,33,127,230,132,52,123,103,167,39,40,60,204,15,191,190,221,146,220,80,79,26,16,224,226,80,195,181,147,1,35,216,220,102,131,202,8,120,33,100,193,76,247,8,251,123,183,237,86,209,235,103,197,139,81,10,5,189,44,10,176,16,11,132,180,123,204,153,5,48,21,13,153,219,229,136,21,245,255,61,117,185,240,186,79,35,132,17,26,177,132,64,143,183,168,192,142,4,180,176,23,114,181,225,234,48,206,74,202,178,15,211,206,55,61,226,26,247,208,48,224,43,43,69,40,32,16,104,195,22,71,21,17,202,249,101,13,115,177,34,159,131,213,246,199,175,242,18,155,137,48,115,187,165,162,128,219,130,18,114,68,107,44,203,190,223,86,127,152,93,217,61,192,68,199,105,237,213,70,101,188,136,153,216,214,218,224,21,241,213,167,14,118,156,69,132,142,245,49,155,74,126,107,86,219,10,171,20,125,75,103,27,225,254,84,125,75,247,252,90,120,3,248,116,196,122,105,200,4,187,194,233,94,73,107,205,218,202,190,181,113,129,151,118,105,106,157,112,4,181,164,71,207,50,165,88,166,50,12,8,171,136,158,220,230,59,250,38,231,56,133,9,7,199,166,15,180,182,92,114,218,184,106,87,144,21,111,162,170,156,123,76,121,105,114,7,169,64,160,114,160,153,60,158,45,40,162,176,97,102,172,61,206,134,20,252,56,29,156,211,153,12,82,218,45,130,50,236,92,92,145,99,185,163,154,233,145,9,229,159,139,144,204,28,82,152,62,127,239,219,165,105,111,210,126,218,56,206,152,194,46,104,235,152,230,196,128,3,175,131,206,224,109,103,113,173,25,54,217,120,116,209,17,121,249,172,208,238,25,91,165,46,187,150,99,138,155,225,60,31,160,119,60,141,138,42,10,198,253,249,131,216,92,86,252,119,192,155,180,56,171,236,84,177,34,22,138,11,210,76,85,138,209,215,210,170,230,23,103,241,239,170,179,45,254,87,16,248,181,224,253,42,38,190,122,190,198,140,160,247,16,12,145,122,59,159,142,43,174,34,96,90,123,194,155,154,40,107,168,108,248,215,183,28,193,198,98,8,98,226,237,138,87,231,16,141,202,25,53,210,198,90,225,169,54,84,229,88,84,139,246,146,250,87,148,151,241,215,96,20,57,225,127,66,139,249,132,115,37,64,125,7,54,28,200,17,82,199,146,184,228,243,117,245,173,172,59,126,127,130,163,219,121,78,192,10,126,88,59,35,135,109,222,129,145,241,158,214,106,241,50,54,39,139,113,242,121,54,245,112,156,209,103,10,245,82,222,162,37,35,95,242,195,179,198,190},
  {193,222,129,63,78,17,235,28,181,241,75,96,112,211,80,94,154,201,60,190,29,192,210,21,71,45,170,191,159,185,196,35,107,201,111,233,2,66,125,15,241,49,199,8,30,24,42,135,190,159,122,250,50,22,44,85,39,9,64,66,80,49,160,87,83,12,92,218,247,56,120,68,7,49,83,250,52,230,149,120,158,150,178,38,6,65,221,40,249,197,153,216,176,2,95,58,214,41,105,215,102,46,31,231,163,5,160,138,46,133,200,190,226,249,155,96,97,6,23,3,212,200,107,64,31,241,110,48,240,252,177,12,99,231,174,85,224,239,34,237,189,157,117,80,19,177,74,54,51,194,122,171,153,87,244,31,69,136,11,140,125,141,91,214,190,222,91,124,243,93,212,178,59,76,137,128,121,87,186,142,151,175,176,234,58,160,227,62,155,247,94,60,131,53,132,120,212,15,172,49,214,39,137,218,178,127,132,206,229,29,140,58,231,179,63,24,142,137,189,70,48,215,136,165,53,10,219,159,124,215,81,177,224,225,149,80,232,158,146,76,252,247,144,144,194,122,172,248,94,98,39,55,62,46,247,151,241,42,27,151,103,14,122,251,70,220,177,32,217,67,147,84,184,190,111,141,230,160,143,233,18,188,195,125,19,198,97,95,163,67,136,129,129,172,21,167,239,141,0,54,143,29,94,183,196,192,219,216,128,114,66,147,196,33,108,231,17,137,43,106,166,144,207,50,130,15,251,137,108,1,254,48,10,40,95,26,16,108,50,202,138,36,189,181,110,11,20,250,111,71,70,17,113,150,77,114,171,134,191,241,33,209,180,195,29,238,195,26,20,255,234,24,44,130,55,64,170,89,214,48,139,220,122,77,227,81,24,243,237,43,250,127,184,172,89,169,193,190,27,197,163,124,201,121,221,119,250,82,107,81,82,51,172,164,82,88,36,8,157,218,60,115,234,5,227,118,51,229,106,18,69,107,106,172,77,246,45,45,145,62,250,189,44,181,225,74,29,7,217,98,82,219,33,90,59,44,220,25,69,176,49,178,127,6,27,89,39,186,167,97,32,244,67,70,41,202,8,202,51,101,218,63,14,101,97,60,173,215,211,203,1,188,131,196,106,179,20,70,98,247,115,243,125,241,130,143,52,122,115,168,25,190,74,4,193,112,224,185,172,21,124,116,239,83,39,166,188,0,38,198,90,232,147,175,212,130,50,63,142,253,28,159,61,75,88,131,31,14,109,139,137,50,92,149,41,205,62,152,94,43,137,72,188,168,65,70,51,252,168,179,51,225,91,47,38,216,197,180,96,201,125,219,221,39,112,186,92,129,182,208,54,105,173,100,85,87,172,192,236,178,109,224,68,124,108,52,224,104,83,109,72,218,192,182,162,187,156,71,208,82,97,43,117,166,32,234,195,163,181,138,185,75,227,227,33,106,11,129,27,240,152,91,211,143,27,139,180,129,239,170,147,244,98,66,27,91,105,159,115,244,7,48,153,113,17,189,81,40,35,149,250,22,107,25,161,122,137,201,74,165,171,150,74,97,54,43,120,38,251,92,249,16,84,125,229,46,213,254,61,28,27,141,203,68,120,77,148,100,226,117,224,45,4,116,201,172,148,197,32,54,10,178,1,79,36,184,188,103,135,136,219,20,185,211,196,27,155,41,21,157,212,5,198,201,130,90,140,163,214,192,126,178,176,134,221,1,59,200,61,30,180,119,113,173,55,206,67,52,53,39,105,149,41,23,238,101,156,204,148,27,8,48,146,24,181,136,240,36,29,160,153,37,39,37,37,252,238,161,110,63,84,27,241,135,252,44,43,106,73,135,85,221,81,38,201,30,195,119,9,95,125,104,89,111,153,235,251,167,144,166,61,232,145,93,212,106,207,42,152,222,248,54,142,213,198,80,214,128,195,193,223,172,56,51,24,78,29,253,36,209,29,87,61,68,116,57,147,98,60,207,107,141,169,164,30,99,165,140,172,156,6,121,75,105,83,113,60,146,48,72,50,215,69,73,8,228,215,65,156,168,237,38,188,54,125,224,248,16,86,124,11,150,148,18,98,136,223,85,89,49,111,66,204,224,228,195,138,96,78,151,32,154,211,75,167,71,38,90,161,235,147,216,157,38,214,111,81,219,255,141,234,66,169,200,177,7,12,143,196,243,247,53,176,116,40,75,14,210,182,94,92,221,54,213,193,114,215,96,71,130,94,40,154,181,42,44,133,193,103,142,112,151,30,40,248,139,181,168,150,118,248,94,82,81,149,200,159,143,31,47,171,197,217},
  {237,118,63,136,186,160,188,79,178,236,143,89,189,64,49,7,172,153,68,134,33,69,93,225,122,14,220,170,75,51,194,199,196,194,67,104,191,101,25,138,14,121,17,175,198,141,127,167,17,226,71,227,147,196,224,32,48,191,213,129,198,6,246,252,118,112,171,17,212,111,50,221,84,91,66,66,189,76,222,194,244,130,98,164,112,124,226,241,166,125,192,153,16,106,206,77,7,231,168,104,147,149,208,223,160,108,39,229,40,145,90,95,72,5,197,178,17,67,38,123,184,149,65,249,207,191,219,14,83,185,196,11,81,155,233,238,172,139,236,76,101,253,97,254,42,115,18,143,196,42,108,115,16,139,36,175,86,12,182,153,150,12,40,216,98,58,145,25,28,165,68,60,111,124,18,64,132,183,167,237,214,196,103,245,211,125,222,164,108,120,223,105,19,98,111,232,24,71,115,63,139,7,113,160,121,57,101,174,223,30,209,118,147,84,220,236,122,7,36,140,106,112,52,58,233,156,3,102,243,26,13,46,157,183,251,97,64,76,97,39,134,200,115,143,91,23,222,107,182,117,133,126,134,140,61,114,3,156,102,205,115,234,102,27,158,1,181,233,153,221,85,45,255,80,189,228,71,11,199,165,190,185,18,3,251,93,177,36,125,226,61,219,69,118,128,247,243,40,40,55,241,185,54,141,89,218,222,208,216,199,178,85,123,198,126,232,103,107,254,4,218,245,4,157,11,3,172,235,91,232,44,202,211,113,60,110,123,181,192,153,116,212,142,140,60,21,172,78,82,233,46,199,34,96,126,76,190,100,55,124,231,64,142,102,23,70,36,79,227,6,216,186,75,142,41,205,75,175,252,123,122,117,25,183,58,6,85,108,149,138,201,215,118,162,15,201,247,62,4,72,252,52,213,110,197,193,113,182,6,201,121,36,122,211,168,52,191,166,35,81,74,129,233,10,141,242,14,37,136,53,114,31,89,148,125,207,149,195,72,254,172,251,254,63,128,24,221,188,232,92,30,182,183,210,162,92,200,170,4,155,128,101,112,208,247,62,192,1,65,2,39,148,13,255,139,213,213,103,153,143,125,101,96,0,0,221,84,121,161,49,24,233,71,99,108,72,120,199,187,199,33,62,20,89,217,95,49,253,55,238,255,38,222,135,66,9,122,93,137,185,27,92,124,126,79,7,29,245,186,48,111,100,227,84,114,68,88,235,78,216,58,133,44,203,53,55,1,58,49,237,113,119,64,19,119,177,25,180,3,245,211,157,53,78,229,175,21,1,255,13,50,207,92,239,114,177,137,2,4,107,185,207,241,10,196,171,122,40,212,52,251,228,126,21,46,69,35,219,166,77,236,188,192,104,196,44,101,231,60,18,62,187,114,161,224,35,168,150,34,65,138,208,57,178,250,12,142,72,33,209,50,70,125,153,90,135,12,176,200,64,12,133,7,163,109,50,151,64,209,87,32,214,158,26,224,204,72,25,146,168,179,42,118,72,60,34,234,154,219,152,235,73,14,255,107,142,219,97,155,80,132,112,158,240,172,83,155,89,171,19,211,171,144,176,72,23,228,255,85,71,139,175,161,163,47,208,26,5,120,209,158,38,203,160,131,14,84,111,27,149,243,1,190,174,125,58,101,79,193,0,60,15,120,147,69,6,9,208,41,111,182,212,152,21,14,106,237,184,99,190,221,145,158,102,92,41,138,195,218,57,32,246,255,192,163,213,0,26,181,48,220,242,153,129,76,69,148,236,134,103,146,60,110,7,104,115,133,126,20,1,14,246,178,204,58,251,174,187,3,245,38,94,247,111,20,94,62,175,240,254,253,45,209,82,164,2,6,194,38,116,6,27,144,200,240,42,171,161,254,172,147,116,251,224,133,126,211,177,234,128,191,211,63,75,74,210,176,53,98,134,135,95,216,249,87,161,215,28,89,142,97,139,254,30,114,12,169,24,219,243,126,79,141,120,202,101,199,141,120,220,5,70,95,21,82,83,186,12,48,60,8,5,224,139,39,87,223,2,28,65,147,118,56,143,166,64,68,101,108,38,74,15,244,240,150,65,89,223,132,115,38,84,172,247,228,223,241,7,229,88,208,127,59,85,119,215,202,146,241,111,11,127,222,10,125,192,121,190,171,124,57,245,24,81,42,140,176,106,198,168,169,15,206,220,150,186,54,66,5,72,116,56,97,116,43,80,36,224,172,54,160,228,169,216,202,190,119,198,114,196,124,225,232,232,206,157,248,111,119,254,134,122,201,10,218,204,99,141,117,68,83,221,38},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
  {0,0,0,0,0,1,255,255,255,255,0,0,1,255,255,0,0,0,0,0,1,1,0,255,0,0,0,255,0,1,0,0,1,0,255,0,255,255,255,255,0,1,0,0,0,0,0,0,255,255,0,1,0,255,0,255,0,255,0,1,0,0,255,0,0,0,255,1,255,0,255,0,0,0,255,0,255,0,255,1,255,0,0,0,0,1,255,0,0,1,1,1,1,0,0,1,255,0,0,0,0,255,255,0,0,0,0,0,255,0,0,0,1,1,255,0,0,0,255,0,0,0,0,0,0,0,0,1,255,255,0,0,0,0,0,0,0,255,1,1,255,1,255,0,0,1,0,0,0,0,255,1,0,1,0,255,0,1,1,0,255,1,1,1,255,255,255,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,0,0,1,0,0,255,0,0,0,0,255,0,255,0,1,255,255,0,0,0,255,0,255,255,0,1,0,1,0,1,0,255,0,0,0,0,0,255,0,0,255,0,255,0,1,0,1,255,255,0,0,0,0,1,0,0,0,0,0,1,0,1,1,1,255,255,0,0,0,1,255,255,0,0,255,0,0,1,1,1,0,0,0,0,0,255,255,0,0,0,0,0,0,0,1,0,0,0,0,0,0,255,255,1,0,0,0,255,255,0,1,0,0,0,0,0,0,0,0,0,0,255,0,0,1,0,0,1,1,0,255,1,1,0,0,0,1,0,1,1,1,255,0,1,0,0,0,0,255,1,0,0,255,255,0,0,1,0,255,0,255,255,1,255,0,0,255,1,0,255,255,255,0,0,0,0,1,0,255,255,1,0,0,0,1,0,0,255,255,1,1,1,255,255,0,0,1,0,0,0,0,1,0,0,0,1,0,255,0,0,255,0,1,1,0,0,255,1,0,255,0,0,0,0,1,255,0,1,0,255,0,0,1,1,0,0,255,0,1,0,255,0,0,0,1,0,1,0,0,255,0,1,0,255,255,1,0,1,255,0,0,255,1,0,255,0,0,1,255,0,0,1,0,0,0,1,0,0,0,1,255,0,1,0,0,255,0,255,255,255,0,0,255,0,0,1,1,0,255,0,255,255,0,0,255,0,255,255,0,255,0,255,0,0,0,0,0,1,255,255,0,0,0,1,255,1,0,255,0,255,0,0,255,0,0,1,255,0,0,255,0,0,1,0,0,1,0,255,1,0,0,1,0,0,255,0,0,0,0,255,1,1,0,1,1,0,0,0,0,1,1,0,255,0,0,0,255,255,0,0,255,0,255,255,0,0,1,0,0,1,1,255,0,255,0,1,0,255,0,1,0,0,1,0,255,0,255,0,255,0,0,1,0,0,0,0,255,0,1,0,1,1,0,1,255,255,0,0,0,255,255,0,0,0,0,0,0,0,255,255,0,255,1,0,1,0,0,0,0,255,0,0,1,0,255,255,1,0,0,0,0,0,255,0,0,255,0,0,0,255,0,1,255,0,0,255,1,1,255,255,0,1,0,0,0,255,0,0,1,0,255,0,255,0,0,0,0,0,0,0,255,1,0,255,1,1,0,0,0,0,0,255,0,0,1,255,1,0,0,0,255,0,0,255,0,1,0,0,0,0,255,0,0,0,0,0,255,0,255,0,0,0,1,0,255,0,0,0,1,0,255,1,255,255,255,255,1,255,0,255,255,255,0,1,255,0,1,1,0,255,0,255,1,0,0,1,1,255,1,0,0,0,0,1,0,255,0,255,0,255,255,255,0,0,0,1,0,255,255,255,1,0,0,255,0,0,255,255,0,1,1,0,0,1,255,255,255,1,255,1,0,255,0,1,0,0,1,0,0,1,0,0,0,1,255,1,0,0,1,0,0,0,0,0,0,0,0,255,1,0,0,255,1,255,255,0,255,255,0,1,255,1,0,0,255,0,0,1,255,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,255,1,0,1,0,0,0,1,255,1,0,1,255,255,0,0,255,0,0,0,0,255,1,255,0,0,0,1,0,0,255,0,0,1,1,255,255,0,255,0,255,255,0,0,255,1,255,1,0,1,0,0,0,255,0,0,0,1,0,0,255,255,1,0,0,255,0,0,0,0,255,1,255,0,255,1,0,0,0,0,0,0,0,0,255,1,0,0,0,255,0,0,0,0,0,1,255,0,0,1,1,255,0,0,0,0,255,1,0,0,0,1,1,0,0,0,0,0,0,0,255,255,1,255,1,255,0,1,0,255,1,1,0,0,0,1,0,1,1,0,0,255,255},
  {0,255,0,1,0,255,0,0,0,0,1,0,0,255,255,0,0,0,255,255,255,1,0,0,1,1,1,0,255,0,255,0,0,255,255,0,0,0,0,0,1,255,0,255,1,0,255,0,0,255,255,1,255,1,0,0,0,1,255,255,0,0,1,0,0,0,0,0,0,1,0,0,0,1,0,0,255,0,0,1,0,0,0,1,0,1,0,255,0,255,0,1,255,255,0,0,255,0,0,1,1,1,0,0,255,0,1,1,0,255,0,255,0,0,255,0,1,0,1,0,0,0,1,0,255,1,0,255,1,1,1,0,0,255,0,0,1,1,255,1,255,255,255,1,0,255,0,1,0,0,0,0,0,0,0,255,0,255,1,0,0,255,255,0,0,0,255,1,0,255,0,0,1,255,0,0,0,0,0,0,1,1,1,255,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,1,255,1,0,0,255,0,0,0,0,255,0,0,1,0,255,0,0,0,1,0,255,0,0,1,0,0,0,1,0,0,0,1,1,0,255,0,255,255,0,0,0,255,0,0,0,0,255,0,255,1,0,0,255,255,0,0,1,0,0,255,255,255,255,0,0,255,1,255,255,255,255,0,255,0,0,0,255,0,0,0,1,255,0,0,0,0,0,0,0,0,0,1,0,255,0,1,1,0,255,0,0,1,255,0,255,255,1,0,0,0,1,255,255,1,1,0,0,255,255,0,1,255,0,1,255,1,1,0,255,0,0,255,255,0,1,0,0,0,1,0,255,255,0,1,0,1,0,0,255,1,0,255,0,1,1,0,1,255,0,0,0,0,255,1,0,0,0,0,1,1,255,255,0,0,0,255,1,255,1,0,1,1,255,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,1,255,0,1,0,0,255,1,1,0,0,0,255,0,0,255,1,255,0,1,0,0,0,0,0,255,1,0,1,255,0,255,0,0,255,255,0,255,255,0,0,0,255,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,255,0,0,255,1,0,0,0,0,0,255,255,0,0,0,0,1,0,0,255,0,0,0,1,0,0,255,0,1,0,0,0,255,0,1,0,255,255,255,0,0,255,255,0,0,1,0,0,0,0,0,0,255,255,1,0,0,0,1,0,0,255,255,1,1,0,0,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,1,255,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,255,0,1,255,0,0,0,255,255,0,0,0,1,0,255,255,255,1,0,1,255,1,1,255,255,0,1,1,0,1,1,0,255,0,255,0,255,255,0,0,255,255,0,1,0,0,255,0,1,1,255,1,0,0,255,0,255,255,1,255,255,0,255,1,255,0,0,1,255,0,0,0,255,0,1,0,1,0,0,0,0,255,255,0,0,255,1,255,0,0,1,255,255,0,1,0,255,255,0,255,1,1,1,0,0,0,1,0,255,0,1,0,0,0,1,1,0,1,1,1,0,1,255,0,0,1,255,0,1,0,255,0,0,255,0,0,0,255,0,255,1,255,0,255,0,0,0,0,255,0,1,1,0,255,0,1,0,0,255,0,255,0,0,0,0,0,0,255,0,255,1,255,255,0,0,0,0,0,0,1,255,1,255,0,1,1,1,0,0,0,255,0,255,255,1,255,0,0,0,1,0,0,1,0,0,0,255,255,1,255,1,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,255,255,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,1,255,0,0,0,255,0,255,255,0,0,0,0,1,0,255,1,255,255,0,255,0,0,0,0,1,0,1,1,255,0,255,0,255,0,255,0,0,1,1,0,1,0,255,0,0,255,255,1,0,0,0,0,0,0,0,1,0,0,0,1,1,0,255,255,255,1,0,255,255,1,1,255,0,1,1,0,1,255,0,0,0,255,255,0,0,255,0,0,0,255,1,0,0,0,0,0,1,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,0,0,1,255,0,1,0,0,255,0,0,0,255,1,255,0,255,255,255,1,1,0,0,0,255,0,0,1,0,0,0,0,0,255,1,0,0,1,255,1,0,0,0,255,1,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,255,0,1,255,0,255,255,255,1,255},
  {0,0,0,255,0,0,0,0,255,0,1,0,1,0,255,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,255,0,0,1,1,255,1,0,0,0,0,1,0,1,255,1,0,1,0,0,255,0,255,1,255,0,0,0,1,0,0,0,0,255,255,255,0,1,0,0,255,1,0,255,0,1,255,255,255,1,0,255,255,0,0,255,0,0,255,255,0,1,255,0,0,1,1,0,0,255,0,0,255,0,0,0,0,0,255,255,255,1,0,0,0,0,1,255,1,255,255,255,1,1,255,255,255,1,0,255,255,255,0,0,0,1,0,0,0,255,0,0,0,0,255,0,0,0,0,0,0,1,255,0,255,1,1,0,0,0,0,1,0,0,0,255,255,255,255,0,1,0,0,255,0,0,255,255,255,255,1,255,1,255,0,255,0,0,0,0,1,0,0,0,255,0,0,255,0,0,255,1,0,0,0,255,0,0,0,1,255,255,255,0,0,0,255,1,0,1,1,1,0,255,0,255,0,1,1,0,0,255,255,1,0,0,0,0,0,0,255,0,255,0,0,0,0,1,1,0,0,0,1,0,1,255,255,0,0,255,0,0,0,0,1,0,0,0,255,0,255,0,0,255,0,0,255,0,1,0,0,0,0,0,1,0,0,0,1,255,0,0,255,1,0,255,1,255,0,1,255,255,0,1,255,0,0,0,255,0,0,0,1,0,0,1,1,0,0,255,255,0,1,0,0,255,1,1,0,0,255,1,255,1,0,0,1,0,1,1,255,1,255,0,0,0,255,0,1,255,0,255,1,1,0,1,255,1,0,255,1,0,0,1,1,0,1,0,0,255,255,0,255,0,0,0,1,0,1,0,255,0,255,255,255,1,0,0,1,1,1,0,0,255,0,1,255,0,1,255,255,0,0,1,0,1,0,0,0,0,0,0,0,1,255,0,0,255,255,255,1,0,1,0,0,0,0,255,255,0,0,0,1,0,1,1,255,255,0,255,0,255,1,1,1,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,1,1,0,255,255,0,0,0,0,0,255,0,255,0,0,0,1,0,0,0,0,1,0,1,0,1,1,0,0,0,1,1,255,0,1,0,255,255,255,0,0,255,0,255,1,1,255,1,0,0,1,255,255,1,1,0,0,1,0,0,0,255,0,0,0,0,0,0,0,0,0,255,1,0,1,1,255,0,1,0,0,1,0,1,0,0,0,255,0,255,255,1,1,255,0,0,255,0,0,0,255,255,0,0,255,0,0,255,1,0,0,0,1,255,1,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,255,255,0,255,0,0,0,0,0,1,0,1,0,0,0,0,255,1,1,255,0,1,0,0,255,0,255,255,255,0,0,255,0,0,0,1,0,1,0,0,0,0,0,0,255,1,1,0,0,1,0,255,0,255,0,1,1,0,255,0,0,0,255,255,0,0,255,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,1,255,0,0,0,1,255,255,0,0,255,0,0,0,1,0,0,1,0,0,255,255,0,0,255,0,1,0,255,255,255,1,1,1,0,0,255,0,0,0,0,255,0,255,255,255,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,255,0,0,0,0,1,1,1,255,1,1,1,0,1,1,255,1,0,0,0,1,0,255,0,1,0,1,255,0,1,1,0,0,1,0,0,0,0,0,255,0,0,0,0,255,0,1,0,255,255,0,0,0,1,255,255,0,0,255,0,0,1,0,255,255,1,0,0,255,255,255,0,0,0,0,255,0,1,255,0,255,0,1,1,1,0,0,0,0,255,255,1,0,1,0,1,0,0,0,0,255,255,1,0,255,0,255,0,1,0,255,0,0,0,0,0,0,1,0,1,255,0,1,0,0,0,1,0,0,0,0,255,0,1,0,1,0,0,1,0,1,0,255,1,0,255,1,0,1,1,0,0,0,0,0,1,0,0,1,0,0,0,255,0,0,0,1,0,255,1,0,0,255,0,0,0,0,0,255,1,0,1,0,1,255,1,0,1,255,0,1,0,0,255,0,0,0,1,0,255,0,0,0,0,1,0,255,0,0,0,255,0,255,0,1,0,1,0,1,0,1,0,255,1,0,255,255,0,0,255,0,255,0,1,255,1,0,0,255,0,0,0,1,255,255,0,255,255,0,0,1,1,255,0,255,1,0,0,0,255,0,0,0},
} ;

static const unsigned char precomputed_core_wforcesntrup1013_k[precomputed_core_wforcesntrup1013_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_wforcesntrup1013_c[precomputed_core_wforcesntrup1013_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
} ;

static void test_core_wforcesntrup1013_impl(long long impl)
{
  unsigned char *h = test_core_wforcesntrup1013_h;
  unsigned char *n = test_core_wforcesntrup1013_n;
  unsigned char *k = test_core_wforcesntrup1013_k;
  unsigned char *c = test_core_wforcesntrup1013_c;
  unsigned char *h2 = test_core_wforcesntrup1013_h2;
  unsigned char *n2 = test_core_wforcesntrup1013_n2;
  unsigned char *k2 = test_core_wforcesntrup1013_k2;
  unsigned char *c2 = test_core_wforcesntrup1013_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_wforcesntrup1013_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_wforcesntrup1013(impl);
    printf("core_wforcesntrup1013 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_wforcesntrup1013_implementation(impl),ntruprime_dispatch_core_wforcesntrup1013_compiler(impl));
  } else {
    crypto_core = ntruprime_core_wforcesntrup1013;
    printf("core_wforcesntrup1013 selected implementation %s compiler %s\n",ntruprime_core_wforcesntrup1013_implementation(),ntruprime_core_wforcesntrup1013_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    {
      long long weight,i,direction;
      for (weight = 0;weight <= nlen;++weight) {
        for (direction = 0;direction < 2;++direction) {
          output_prepare(h2,h,hlen);
          input_prepare(n2,n,nlen);
          input_prepare(k2,k,klen);
          input_prepare(c2,c,clen);
          for (i = 0;i < nlen;++i) {
            n[i] &= ~1;
            if (direction) {
              if (nlen-1-i < weight) n[i] += 1;
            } else {
              if (i < weight) n[i] += 1;
            }
            n2[i] = n[i];
          }
          crypto_core(h,n,k,c);
          checksum(h,hlen);
          output_compare(h2,h,hlen,"crypto_core");
          input_compare(n2,n,nlen,"crypto_core");
          input_compare(k2,k,klen,"crypto_core");
          input_compare(c2,c,clen,"crypto_core");
          double_canary(h2,h,hlen);
          double_canary(n2,n,nlen);
          double_canary(k2,k,klen);
          double_canary(c2,c,clen);
          crypto_core(h2,n2,k2,c2);
          if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic");
        }
      }
    }
    checksum_expected(core_wforcesntrup1013_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_wforcesntrup1013_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_wforcesntrup1013_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_wforcesntrup1013_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_wforcesntrup1013_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_wforcesntrup1013_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_wforcesntrup1013_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_wforcesntrup1013_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_wforcesntrup1013_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_wforcesntrup1013_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_wforcesntrup1013(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"wforcesntrup1013")) return;
  storage_core_wforcesntrup1013_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_wforcesntrup1013_h = aligned(storage_core_wforcesntrup1013_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_wforcesntrup1013_n = callocplus(crypto_core_INPUTBYTES);
  test_core_wforcesntrup1013_n = aligned(storage_core_wforcesntrup1013_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_wforcesntrup1013_k = callocplus(crypto_core_KEYBYTES);
  test_core_wforcesntrup1013_k = aligned(storage_core_wforcesntrup1013_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_wforcesntrup1013_c = callocplus(crypto_core_CONSTBYTES);
  test_core_wforcesntrup1013_c = aligned(storage_core_wforcesntrup1013_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_wforcesntrup1013_h2 = callocplus(maxalloc);
  test_core_wforcesntrup1013_h2 = aligned(storage_core_wforcesntrup1013_h2,crypto_core_OUTPUTBYTES);
  storage_core_wforcesntrup1013_n2 = callocplus(maxalloc);
  test_core_wforcesntrup1013_n2 = aligned(storage_core_wforcesntrup1013_n2,crypto_core_INPUTBYTES);
  storage_core_wforcesntrup1013_k2 = callocplus(maxalloc);
  test_core_wforcesntrup1013_k2 = aligned(storage_core_wforcesntrup1013_k2,crypto_core_KEYBYTES);
  storage_core_wforcesntrup1013_c2 = callocplus(maxalloc);
  test_core_wforcesntrup1013_c2 = aligned(storage_core_wforcesntrup1013_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_wforcesntrup1013 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_wforcesntrup1013();++impl)
      forked(test_core_wforcesntrup1013_impl,impl);
    ++test_core_wforcesntrup1013_h;
    ++test_core_wforcesntrup1013_n;
    ++test_core_wforcesntrup1013_k;
    ++test_core_wforcesntrup1013_c;
    ++test_core_wforcesntrup1013_h2;
    ++test_core_wforcesntrup1013_n2;
    ++test_core_wforcesntrup1013_k2;
    ++test_core_wforcesntrup1013_c2;
  }
  free(storage_core_wforcesntrup1013_c2);
  free(storage_core_wforcesntrup1013_k2);
  free(storage_core_wforcesntrup1013_n2);
  free(storage_core_wforcesntrup1013_h2);
  free(storage_core_wforcesntrup1013_c);
  free(storage_core_wforcesntrup1013_k);
  free(storage_core_wforcesntrup1013_n);
  free(storage_core_wforcesntrup1013_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

