!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_array
!! NAME
!! m_array
!!
!! FUNCTION
!!   This module provides data types that can be used to construct ragged arrays
!!   and helper functions to print/write the array in different formats.
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2018 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

MODULE m_array

 use defs_basis
 use m_profiling_abi
 use m_errors
 use m_nctk
#ifdef HAVE_NETCDF
 use netcdf
#endif

 use m_numeric_tools, only : c2r

 implicit none

 private 
!!***

 public :: farray_ncwrite  ! Write the values to a netcdf file with id ncid (debugging tool)
                           ! Ex: call farray_ncwrite("array_name", array, "ncid). 

 !public :: array_print     ! Print the values of the array (formatted form)

 !interface array_print
 !  module procedure array2_gwpc_print
 !end interface array_print

 !interface array_allgatherv
 !  module procedure 
 !end interface array_allgatherv

 interface farray_ncwrite
   module procedure farr_real_dp1
   module procedure farr_complex_dpc1
 end interface farray_ncwrite                                    


!!****t* m_array/array2_gwpc_type
!! NAME
!! array2_gwpc_type
!! 
!! FUNCTION
!!  A datatype used to construct ragged 2D-arrays with KIND=gwpc
!! 
!! SOURCE

 type,public :: array2_gwpc_t
   complex(gwpc),allocatable :: vals(:,:) 
 end type array2_gwpc_t

 interface array_free
   module procedure array2_gwpc_free
 end interface array_free

 public :: array_free       ! Free memory
!!***

CONTAINS

!!****f* m_array/array2_gwpc_free
!! NAME
!!   array2_gwpc_free
!!
!! FUNCTION
!!   Free memory
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine array2_gwpc_free(Array)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'array2_gwpc_free'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 type(array2_gwpc_t),intent(inout) :: Array

! *********************************************************************

 if (allocated(Array%vals)) then
   ABI_FREE(Array%vals)
 end if

end subroutine array2_gwpc_free
!!***

! Include routines for dumping results in Netcdf format.
! (useful for debugging or quick analysis)
! The include file is automatically generated by the script genarray.py
! Change the python code if you need to support other kinds or types
! then add the new routines to the generic interface *farray_ncwrite*
!
! API Example
! Open the netcdf file and get the NC id 
! ...
! Write data values. Use "array_name" as keyword
! call farray_ncwrite(array, "array_name", ncid)

#include "farray_ncwrite.finc"

END MODULE m_array

