/*  File: rpcace_sp.c
 *  Author: Jean Thierry-Mieg (mieg@kaa.cnrs_mop.fr)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1994
 * -------------------------------------------------------------------
 * Acedb is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * or see the on-line version at http://www.gnu.org/copyleft/gpl.txt
 * -------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@kaa.cnrs-mop.fr
 *
 * Description:
 * Exported functions:
 * HISTORY:
     from a first version by Peter Kocab
     edited by Bigwood & Co
 * Last edited: Jan 10 16:13 1996 (mieg)
 * Created: Fri Nov 18 16:42:20 1994 (mieg)
 *-------------------------------------------------------------------
 */

/* $Id: rpcace_sp.c,v 1.21 2004/08/12 20:24:16 mieg Exp $ */

/* 
 * RPC_SVC_FG prevent forking on solaris
 * affects rpcace_svc.c which is generated by rpcgen during make
 */

#define RPC_SVC_FG

#if defined (ALPHA ) || defined(HP)
#include <stdlib.h>
#include <string.h> /* needed to compile with cc on the alpha - srk */
#endif
#include <rpc/rpc.h>
unsigned long  rpc_port;

#if defined(DARWIN)
#include <rpc/pmap_clnt.h>
#endif


/* before including rpcace_svc.c i have to refddefine the 3 guys
so that i can set them to zero if i am a daemon
*/

static int
 my_RPC_ANYSOCK = RPC_ANYSOCK,
  my_IPPROTO_TCP = IPPROTO_TCP,
  my_IPPROTO_UDP = IPPROTO_UDP ;

#undef IPPROTO_UDP
#undef  IPPROTO_TCP
#undef RPC_ANYSOCK
#define  RPC_ANYSOCK  my_RPC_ANYSOCK
#define IPPROTO_TCP my_IPPROTO_TCP
#define IPPROTO_UDP my_IPPROTO_UDP


#define main     my_run_rpc
#include "rpcace_svc.c"
#undef  main

#include "acedb.h"   /* must come after rpcace_svc.c */

void  wait_for_client (u_long port, BOOL isDaemon)
{ rpc_port = port ;
  if (isDaemon)
    { my_RPC_ANYSOCK = 0;
       my_IPPROTO_TCP =  my_IPPROTO_UDP = 0 ;
    }
  my_run_rpc(0,0) ;
}

void closePortMap(void) {
 svc_unregister(RPC_ACE,RPC_ACE_VERS);
}

/*
** Remote version for "ace_server"
*/

extern Stack processQueries (int *ip, int *magicp, char *cp, int maxBytes, int *enc) ; 

#if defined(LINUX) || defined(OPTERON)
ace_reponse *ace_server_1_svc (ace_data *question, struct svc_req *rqstp)
#else
ace_reponse *ace_server_1 (ace_data *question, struct svc_req *rqstp)
#endif
{ int nn ;
  Stack s ;
  static ace_reponse rr ; 
  int clientId = question->clientId ;
  int magic = question->magic ;
  char *cp ;
  int maxBytes = question->kBytes * 1024; 
  int encore = 0; 

  /* free previous result */
  xdr_free((xdrproc_t )xdr_ace_reponse, (char*)&rr) ;
  memset (&rr,0, sizeof(ace_reponse)) ;
  encore = - question->encore ;  /* sign is inverted to allow overloading */
  s = processQueries (&clientId, &magic, question->question, maxBytes, &encore) ; 

  nn = s && stackMark(s) ? stackMark(s) : 100 ;
   /* stackMrk == 0 happens if we write to a file and are in the encore case */

  cp = malloc (nn + 1) ; 
  if (cp)
    { memset(cp, 0, nn+1) ;
      if (s &&  stackMark(s))
	memcpy (cp, stackText(s,0), nn) ;
      else 
	{ 
	  if (!s)
	    strcpy(cp,"// Sorry, broken connection, possibly due to client time out") ;
	   nn = strlen (cp) ;
	}
    }
  else
     { cp = malloc(300) ;
       sprintf(cp, "%s%d%s\n%s\n",
	       "//! Sorry, the answer is too long (",stackMark (s)," kilobytes),",
	       "//! I can t mallocate a sufficcient buffer." ) ;
       nn = strlen (cp) ;
    }

  rr.ace_reponse_u.res_data.clientId = clientId ;
  rr.ace_reponse_u.res_data.magic = magic ;
  rr.ace_reponse_u.res_data.reponse.reponse_val = cp ;
  rr.ace_reponse_u.res_data.reponse.reponse_len = nn ;
  rr.ace_reponse_u.res_data.question = malloc(5) ; *rr.ace_reponse_u.res_data.question = 0 ;
  rr.ace_reponse_u.res_data.encore = encore; /* DWB - let client know if you have more */
  return &rr ;
}

/********* end of file ********/

