/*
 * This file is part of the Alliance CAD System
 * Copyright (C) Laboratoire LIP6 - Dpartement ASIM
 * Universite Pierre et Marie Curie
 *
 * Home page          : http://www-asim.lip6.fr/alliance/
 * E-mail             : mailto:alliance-users@asim.lip6.fr
 *
 * This progam is  free software; you can redistribute it  and/or modify it
 * under the  terms of the GNU  General Public License as  published by the
 * Free Software Foundation;  either version 2 of the License,  or (at your
 * option) any later version.
 *
 * Alliance VLSI  CAD System  is distributed  in the hope  that it  will be
 * useful, but WITHOUT  ANY WARRANTY; without even the  implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy  of the GNU General Public License along
 * with the GNU C Library; see the  file COPYING. If not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/*
 * Tool    : LooN - pattern matching between cells
 * Date    : 2000
 * Author  : Francois Donnet
 */




#ifndef LIB_MATCHING_H
#define LIB_MATCHING_H

#ifndef __P
# ifdef __STDC__ || __GNUC__
#  define __P(x) x
# else
#  define __P(x) ()
# endif
#endif

/****************************************************************************/
/* Pattern matching between an expr and a pattern. Return true if expr has  */
/* the same operators and in the same order than pattern                    */
/* '1' , '0' , 'd' and 'z' are also checked if matched                      */
/*quite slow comparison                                                     */
/****************************************************************************/
extern int pattern_matching __P ((chain_list* expr, chain_list* pattern));

/****************************************************************************/
/* return 1 if befig1 and befig2 are strictly identical                     */
/****************************************************************************/
extern int compare_befig __P ((befig_list* befig1, befig_list* befig2));

#endif
