# E.6 What is the population myth?

The idea that population growth is the **key** cause of ecological problems is
extremely commonplace. Even individuals associated with such radical green
groups as **Earth First!** have promoted it. It is, however, a gross
distortion of the truth. **Capitalism** is the main cause of both
overpopulation **and** the ecological crisis.

Firstly, we should point out that all the "doomsday" prophets of the
"population bomb" have been proved wrong time and time again. The dire
predictions of Thomas Malthus, the originator of the population myth, have not
come true, yet neo-Malthusians continue to mouth his reactionary ideas. In
fact Malthus wrote his infamous _"Essay on the Principles of Population"_
which inflicted his _"law of population"_ onto the world in response to the
anarchist William Godwin and other social reformers. In other words, it was
explicitly conceived as an attempt to "prove" that social stratification, and
so the status quo, was a "law of nature" and that poverty was the fault of the
poor themselves, not the fault of an unjust and authoritarian socio-economic
system. As such, the "theory" was created with political goals in mind and as
a weapon in the class struggle (as an aside, it should be noted that Darwin
argued his theory of natural selection was _"the doctrine of Malthus applied
to the whole animal and vegetable kingdom."_ [quoted by Peter Marshall,
**Nature's Web**, p. 320] In other words, anarchism, indirectly, inspired the
theory of evolution. Perhaps unsurprisingly, in the form of Social Darwinism
this was also used against working class people and social reform).

As Kropotkin summarised, Malthus work was _"pernicious"_ in its influence. It
_"summed up ideas already current in the minds of the wealth-possessing
minority"_ and arose to combat the _"ideas of equality and liberty"_ awakened
by the French and American revolutions. Malthus asserted against Godwin _"that
no equality is possible; that the poverty of the many is not due to
institutions, but is a natural **law.**"_ This meant he _"thus gave the rich a
kind of scientific argument against the ideas of equality."_ However, it was
simply _"a pseudo-scientific"_ assertion which reflected _"the secret desires
of the wealth-possessing classes"_ and not a scientific hypothesis. This is
obvious as technology has ensured that Malthus's fears are _"groundless"_
while they are continually repeated. [**Fields, Factories and Workshops
Tomorrow**, p. 77, p. 78 and p. 79]

That the theory was fundamentally ideological in nature can be seen from
Malthus himself. It is interesting to note that in contrast, and in direct
contradiction to his population "theory," as an economist Malthus was worried
about the danger of **over-production** within a capitalist economy. He was
keen to defend the landlords from attacks by Ricardo and had to find a reason
for their existence. To do this, he attacked Say's Law (the notion that over-
production was impossible in a free market economy). Utilising the notion of
effective demand, he argued that capitalist saving caused the threat of over-
production and it was the landlords luxury consumption which made up the
deficit in demand this caused and ensured a stable economy. As Marxist David
McNally points out, the _"whole of this argument is completely at odds with
the economic analysis"_ of his essay on population. According to that, the
_"chronic . . . danger which confronts society is **underproduction** of food
relative to people."_ In his economics book, the world _"is threatened by
**overproduction.** Rather than there being too little supply relative to
demand, there is now too little demand relative to supply."_ In fact, Malthus
even went so far as to argue for the poor to be employed in building roads and
public works! No mention of "excess" population there, which indicates well
the ideological nature of his over-population theory. As McNally shows, it was
the utility of Malthus's practical conclusions in his "Essay on the Principles
of Population" for fighting the poor law and the right to subsistence (i.e.
welfare provisions) which explained his popularity: _"he made classical
economics an open enemy of the working class."_ [_"The Malthusian Moment:
Political Economy versus Popular Radicalism"_, pp. 62-103, **Against the
Market**, p. 85 and p. 91]

So it is easy to explain the support Malthus and his assertions got in spite
of the lack of empirical evidence and the self-contradictory utterances of its
inventor. Its support rests simply in its utility as a justification for the
inhuman miseries inflicted upon the British people by "its" ruling class of
aristocrats and industrialists was the only reason why it was given the time
of day. Similarly today, its utility to the ruling class ensures that it keeps
surfacing every so often, until forced to disappear again once the actual
facts of the case are raised. That the population myth, like "genetic"
justifications for race-, class- and gender-based oppression, keeps appearing
over and over again, even after extensive evidence has disproved it, indicates
its usefulness to the ideological guardians of the establishment.

Neo-Malthusianism basically blames the victims of capitalism for their
victimisation, criticising ordinary people for "breeding" or living too long,
thus ignoring (at best) or justifying (usually) **privilege** \-- the social
root of hunger. To put it simply, the hungry are hungry because they are
excluded from the land or cannot earn enough to survive. In Latin America, for
example, 11% of the population was landless in 1961, by 1975 it was 40%.
Approximately 80% of all Third World agricultural land is owned by 3% of
landowners. As anarchist George Bradford stresses, Malthusians _"do not
consider the questions of land ownership, the history of colonialism, and
where social power lies. So when the poor demand their rights, the Malthusians
see 'political instability' growing from population pressure."_ [**Woman's
Freedom: Key to the Population Question**, p. 77] Bookchin makes a similar
critique:

> _ "the most sinister feature about neo-Malthusianism is the extent to which
it actively deflects us from dealing with the social origins of our ecological
problems -- indeed, the extent to which it places the blame for them on the
victims of hunger rather than those who victimise them. Presumably, if there
is a 'population problem' and famine in Africa, it is the ordinary people who
are to blame for having too many children or insisting on living too long --
an argument advanced by Malthus nearly two centuries ago with respect to
England's poor. The viewpoint not only justifies privilege; it fosters
brutalisation and degrades the neo-Malthusians even more than it degrades the
victims of privilege."_ [_"The Population Myth"_, pp. 30-48, **Which Way for
the Ecology Movement?**, p. 34]

Increased population is not the cause of landlessness, it is the result of it.
If a traditional culture, its values, and its sense of identity are destroyed,
population growth rates increase dramatically. As in 17th- and 18th-century
Britain, peasants in the Third World are kicked off their land by the local
ruling elite, who then use the land to produce cash crops for export while
their fellow country people starve. Like Ireland during the Potato Famine, the
Third World nations most affected by famine have also been exporters of food
to the developed nations. Malthusianism is handy for the wealthy, giving them
a "scientific" excuse for the misery they cause so they can enjoy their blood-
money without remorse. It is unwise for greens to repeat such arguments:

> _ "It's a betrayal of the entire message of social ecology to ask the
world's poor to deny themselves access to the necessities of life on grounds
that involve long-range problems of ecological dislocation, the shortcomings
of 'high' technology, and very specious claims of natural shortages in
materials, while saying nothing at all about the artificial scarcity
engineered by corporate capitalism."_ [**The Ecology of Freedom**, p. 350]

In a country that is being introduced to the joys of capitalism by state
intervention (the usual means by which traditional cultures and habits are
destroyed to create a "natural system of liberty"), population soon explodes
as a result of the poor social and economic conditions in which people find
themselves. In the inner-city ghettos of the First World, social and economic
conditions similar to those of the Third World give rise to similarly elevated
birth rates. When ghetto populations are composed mostly of minorities, as in
countries like the US, higher birth rates among the minority poor provides a
convenient extra excuse for racism, "proving" that the affected minorities are
"inferior" because they "lack self-control," are "mere animals obsessed with
procreation," etc. Much the same was said of Irish Catholics in the past and,
needless to say, such an argument ignores the fact that slum dwellers in, for
example, Britain during the Industrial Revolution were virtually all white but
still had high birth rates.

Population growth, far from being the cause of poverty, is in fact a result of
it. There is an inverse relationship between per capita income and the
fertility rate -- as poverty decreases, so do the population rates. When
people are ground into the dirt by poverty, education falls, women's rights
decrease, and contraception is less available. Having children then becomes
virtually the only survival means, with people resting their hopes for a
better future in their offspring. Therefore social conditions have a major
impact on population growth. In countries with higher economic and cultural
levels, population growth soon starts to fall off. Today, for example, much of
Europe has seen birth rates fall beyond the national replacement rate. This is
the case even in Catholic countries, which one would imagine would have
religious factors encouraging large families.

To be clear, we are **not** saying that overpopulation is not a very serious
problem. Obviously, population growth **cannot** be ignored or solutions put
off until capitalism is eliminated. We need to immediately provide better
education and access to contraceptives across the planet as well as raising
cultural levels and increasing women's rights in order to combat
overpopulation **in addition to** fighting for land reform, union organising
and so on. Overpopulation only benefits the elite by keeping the cost of
labour low. This was the position of the likes of Emma Goldman and other
radicals of her time:

> _ "Many working-class radicals accepted the logic that excessive numbers
were what kept the poor in their misery. During the nineteenth century there
were courageous attempts to disseminate birth-control information both to
promote lower population and to make it possible for women to control their
own reproductivity and escape male domination. Birth control was the province
of feminism, radical socialism and anarchism."_ [Bradford, **Op. Cit.**, p.
69]

Unlike many neo-Malthusians Goldman was well aware that **social** reasons
explained why so many people went hungry. As she put it, _"if the masses of
people continue to be poor and the rich grow ever richer, it is not because
the earth is lacking in fertility and richness to supply the need of an
excessive race, but because the earth is monopolised in the hands of the few
to the exclusion of the many."_ She noted that the promotion of large families
had vested interests behind it, although working class people _"have learned
to see in large families a millstone around their necks, deliberately imposed
upon them by the reactionary forces in society because a large family
paralyses the brain and benumbs the muscles of the masses . . . [The worker]
continues in the rut, compromises and cringes before his master, just to earn
barely enough to feed the many little mouths. He dare not join a revolutionary
organisation; he dare not go on strike; he dare not express an opinion."_
[_"The Social Aspects of Birth Control"_, **Anarchy! An Anthology of Emma
Goldman's Mother Earth**, p. 135 and pp. 136-7] This support for birth
control, it should be stressed, resulted in Goldman being arrested. Malthus,
like many of his followers _"opposed contraception as immoral, preferring to
let the poor starve as a 'natural' method of keeping numbers down. For him,
only misery, poverty, famine, disease, and war would keep population from
expanding beyond the carrying capacity of the land."_ [Bradford, **Op. Cit.**,
p. 69]

Unsurprisingly, Goldman linked the issue of birth control to that of women's
liberation arguing that _"I never will acquiesce or submit to authority, nor
will I make peace with a system which degrades woman to a mere incubator and
which fattens on her innocent victims. I now and here declare war upon this
system."_ The key problem was that woman _"has been on her knees before the
altar of duty imposed by God, by Capitalism, by the State, and by Morality"_
for ages. Once that changed, the issue of population would solve itself for
_"[a]fter all it is woman whom is risking her health and sacrificing her youth
in the reproduction of the race. Surely she ought to be in a position to
decide how many children she should bring into world, whether they should be
brought into the world by the man she loves and because she wants the child,
or should be born in hatred and loathing."_ [**Op. Cit.**, p. 140 and p. 136]

Other anarchists have echoed this analysis. George Bradford, for example,
correctly notes that _"the way out of the [ecological] crisis lies in the
practical opening toward freedom of self-expression and selfhood for women
that is the key to the destruction of hierarchy."_ In other words, women's
_"freedom and well-being are at the centre of the resolution to the population
problem, and that can only be faced within the larger social context."_ That
means _"real participation in social decision-making, real health concerns,
access to land, and the overthrow of patriarchal domination."_ [**Op. Cit.**,
p. 68 and p. 82] Bookchin makes the same point, noting that population growth
rates have fallen in developed countries because _"of the **freedom** that
women have acquired over recent decades to transcend the role that patriarchy
assigned to them as mere reproductive factories."_ [_"The Future of the
Ecology Movement,"_ pp. 1-20, **Which Way for the Ecology Movement?**, p. 19]

This means that an **increase** of freedom will solve the population question.
Sadly, many advocates of neo-Malthusianism extend control over people from
women to all. The advocates of the "population myth," as well as getting the
problem wrong, also (usually) suggest very authoritarian "solutions" -- for
example, urging an increase in state power with a "Bureau of Population
Control" to "police" society and ensure that the state enters the bedroom and
our most personal relationships. Luckily for humanity and individual freedom,
since they misconceive the problem, such "Big Brother" solutions are not
required.

So, it must be stressed the "population explosion" is not a neutral theory,
and its invention reflected class interests at the time and continual use
since then is due to its utility to vested interests. We should not be fooled
into thinking that overpopulation is the main cause of the ecological crisis,
as this is a strategy for distracting people from the root-cause of both
ecological destruction and population growth today: namely, the capitalist
economy and the inequalities and hierarchical social relationships it
produces. As such, those who stress the issue of population numbers get it
backward. Poverty causes high birth rates as people gamble on having large
families so that some children will survive in order to look after the parents
in their old age. Eliminate economic insecurity and poverty, then people have
less children.

Some Greens argue that it is impossible for **everyone** to have a high
standard of living, as this would deplete available resources and place too
much pressure on the environment. However, their use of statistics hides a
sleight of hand which invalidates their argument. As Bookchin correctly
argues:

> _ "Consider the issue of population and food supply in terms of mere numbers
and we step on a wild merry-go-round that does not support neo-Malthusian
predictions of a decade ago, much less a generation ago. Such typically neo-
Malthusian stunts as determining the 'per capita consumption' of steel, oil,
paper, chemicals, and the like of a nation by dividing the total tonnage of
the latter by the national population, such that every man, women, and child
is said to 'consume' a resultant quantity, gives us a picture that is
blatantly false and functions as a sheer apologia for the upper classes. The
steel that goes into a battleship, the oil that is used to fuel a tank, and
the paper that is covered by ads hardly depicts the human consumption of
materials. Rather, it is stuff consumed by all the Pentagons of the world that
help keep a 'grow-or-die economy in operation -- goods, I may add, whose
function is to destroy and whose destiny is to be destroyed."_ [_"The
Population Myth"_, pp. 30-48, **Which Way for the Ecology Movement?**, pp.
34-5]

Focusing on averages, in other words, misses out the obvious fact we live in a
highly unequal societies which results in a few people using many resources.
To talk about consumption and not to wonder how many Rolls Royces and mansions
the "average" person uses means producing skewed arguments. Equally, it is
possible to have more just societies with approximately the same living
standards with significantly **less** consumption of resources and **less**
pollution and waste produced. We need only compare America with Europe to see
this. One could point out, for example, that Europeans enjoy more leisure
time, better health, less poverty, less inequality and thus more economic
security, greater intergenerational economic mobility, better access to high-
quality social services like health care and education, and manage to do it
all in a far more environmentally sustainable way (Europe generates about half
the CO2 emissions for the same level of GDP) compared to the US.

In fact, even relatively minor changes in how we work can have significant
impact. For example, two economists at the Center for Economic and Policy
Research produced a paper comparing U.S. and European energy consumption and
related it to hours worked. They concluded that if Americans chose to take
advantage of their high level of productivity by simply shortening the
workweek or taking longer holidays rather than producing more, there would
follow a number of benefits. Specifically, if the U.S. followed Western Europe
in terms of work hours then not only would workers find themselves with seven
additional weeks of time off, the US would consume some 20% less energy and if
this saving was directly translated into lower carbon emissions then it would
have emitted 3% less carbon dioxide in 2002 than in 1990 (this level of
emissions is only 4% above the negotiated target of the Kyoto Protocol). If
Europe following IMF orthodoxy and increased working hours, this would have a
corresponding negative impact on energy use and emissions (not to mention
quality of life). [David Rosnick and Mark Weisbrot, **Are Shorter Work Hours
Good for the Environment?**] Of course, any such choice is influenced by
social institutions and pressures and, as such, part of a wider social
struggle for change.

In other words, we must question the underlying assumption of the neo-
Malthusians that society and technology are static and that the circumstances
that produced historic growth and consumption rates will remain unchanged.
This is obviously false, since humanity is not static. To quote Bookchin
again:

> _ "by reducing us to studies of line graphs, bar graphs, and statistical
tables, the neo-Malthusians literally freeze reality as it is. Their numerical
extrapolations do not construct any reality that is new; they mere extend,
statistic by statistic, what is basically old and given . . . We are taught to
accept society, behaviour, and values as they **are**, not as they should be
or even **could** be. This procedure places us under the tyranny of the status
quo and divests us of any ability to think about radically changing the world.
I have encountered very few books or articles written by neo-Malthusians that
question whether we should live under any kind of money economy at all, any
statist system of society, or be guided by profit oriented behaviour. There
are books and articles aplenty that explain 'how to' become a 'morally
responsible' banker, entrepreneur, landowner, 'developer,' or, for all I know,
arms merchant. But whether the whole system called capitalism (forgive me!),
be it corporate in the west or bureaucratic in the east, must be abandoned if
we are to achieve an ecological society is rarely discussed."_ [**Op. Cit.**,
p. 33]

It is probably true that an "American" living standard is not possible for the
population of the world at its present level (after all, the US consumes 40%
of the world's resources to support only 5% of its population). For the rest
of the world to enjoy that kind of standard of living we would require the
resources of multiple Earths! Ultimately, anything which is not renewable is
exhaustible. The real question is when will it be exhausted? How? Why? And by
whom? As such, it is important to remember that this "standard of living" is a
product of an hierarchical system which produces an alienated society in which
consumption for the sake of consumption is the new god. In a grow-or-die
economy, production and consumption must keep increasing to prevent economic
collapse. This need for growth leads to massive advertising campaigns to
indoctrinate people with the capitalist theology that more and more must be
consumed to find "happiness" (salvation), producing consumerist attitudes that
feed into an already-present tendency to consume in order to compensate for
doing boring, pointless work in a hierarchical workplace. Unless a
transformation of values occurs that recognises the importance of **living**
as opposed to **consuming,** the ecological crisis **will** get worse. It is
impossible to imagine such a radical transformation occurring under capitalism
and so a key aim of eco-anarchists is to encourage people to consider what
they need to live enriched, empowering and happy lives rather than participate
in the rat race capitalism produces (even if you do win, you remain a rat).

Nor it cannot be denied that developments like better health care, nutrition,
and longer lifespans contribute to overpopulation and are made possible by
"industry." But to see such developments as primary causes of population
growth is to ignore the central role played by poverty, the disruption of
cultural patterns, and the need for cheap labour due to capitalism. There are
always elevated birth rates associated with poverty, whether or not medical
science improves significantly (for example, during the early days of
capitalism). "Industrialism" is in fact a term used by liberal Greens (even
when they call themselves "deep") who do not want to admit that the ecological
crisis cannot be solved without the complete overthrow of capitalism,
pretending instead that the system can become "green" through various band-aid
reforms. "Controlling population growth" is always a key item on such
liberals' agendas, taking the place of "eliminating capitalism," which should
be the centrepiece. _"Population control is substituted for social justice,
and the problem is actually aggravated by the Malthusian 'cure',"_ points out
feminist Betsy Hartmann. [quoted by Bradford, **Op. Cit.**, p. 77]

After all, there **is** enough food to feed the world's population but its
distribution reflects inequalities in wealth, power and effective demand (this
is most obviously seen when food is exported from famine areas as there is no
effective demand for it there, a sadly regular occurrence). The _"myth that
population increases in places like the Sudan, for example, result in famine"_
can only survive if we ignore _"the notorious fact that the Sudanese could
easily feed themselves if they were not forced by the American-controlled
World Bank and International Monetary Fund to grow cotton instead of grains."_
[Bookchin, **Remaking Society**, p. 11] Hence the importance of class analysis
and an awareness of hierarchy. We can hardly talk of "our" resources when
those resources are owned by a handful of giant corporations. Equally, we
cannot talk about "our" industrial impact on the planet when the decisions of
industry are made by a bosses and most of us are deliberately excluded from
the decision making process. While it makes sense for the ruling elite to
ignore such key issues, it counter-productive for radicals to do so and blame
"people" or their numbers for social and environmental problems:

> _ "The most striking feature of such way of thinking is not only that it
closely parallels the way of thinking that is found in the corporate world.
What is more serious is that it serves to deflect our attention from the role
society plays in producing ecological breakdown. If 'people' as a **species**
are responsible for environmental dislocations, these dislocations cease to be
the result of **social** dislocations. A mythic 'Humanity' is created --
irrespective of whether we are talking about oppressed minorities, women,
Third World people, or people in the First World -- in which everyone is
brought into complicity with powerful corporate elites in producing
environmental dislocations. In this way, the social roots of ecological
problems are shrewdly obscured . . . [W]e can dismiss or explain away hunger,
misery, or illness as 'natural checks' that are imposed on human beings to
retain the 'balance of nature.' We can comfortably forget that much of the
poverty and hunger that afflicts the world has its origins in the corporate
exploitation of human beings and nature -- in agribusiness and social
oppression."_ [**Op. Cit.**, pp. 9-10]

Looking at population numbers simply misses the point. As Murray Bookchin
argues, this _"arithmetic mentality which disregards the social context of
demographics is incredibly short-sighted. Once we accept without any
reflection or criticism that we live in a 'grow-or-die' capitalistic society
in which accumulation is literally a law of economic survival and competition
is the motor of 'progress,' anything we have to say about population is
basically meaningless. The biosphere will eventually be destroyed whether five
billion or fifty million live on the planet. Competing firms in a 'dog-eat-
dog' market must outproduce each other if they are to remain in existence.
They must plunder the soil, remove the earth's forests, kill off its wildlife,
pollute its air and waterways not because their intentions are necessarily
bad, although they usually are . . . but because they must simply survive.
Only a radical restructuring of society as a whole, including its anti-
ecological sensibilities, can remove this all commanding social compulsion."_
[_"The Population Myth"_, pp. 30-48, **Op. Cit.**, p. 34] A sane society would
not be driven by growth for the sake of growth and would aim to reduce
production by reducing the average working week to ensure both an acceptable
standard of living **plus** time to enjoy it. So it is not a case that the
current industrial system is something we need to keep. Few anarchists
consider a social revolution as simply expropriating current industry and
running it more or less as it is now. While expropriating the means of life is
a necessary first step, it is only the start of a process in which we
transform the way we interact with nature (which, of course, includes people).

To conclude, as Bradford summarises the _"salvation of the marvellous green
planet, our Mother Earth, depends on the liberation of women -- and children,
and men -- from social domination, exploitation and hierarchy. They must go
together."_ [**Op. Cit.**, p. 68] By focusing attention away from the root
causes of ecological and social disruption -- i.e. capitalism and hierarchy --
and onto their victims, the advocates of the "population myth" do a great
favour to the system that creates mindless growth. Hence the population myth
will obviously find favour with ruling elites, and this -- as opposed to any
basis for the myth in scientific fact -- will ensure its continual re-
appearance in the media and education.

[‹ E.5 Can ethical consumerism stop the ecological crisis?](secE5.md "Go to
previous page" ) [up](secEcon.md "Go to parent page" ) [Section F - Is
"anarcho"-capitalism a type of anarchism? ›](secFcon.md "Go to next page" )

