/*
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co., Ltd.
 *
 * Author:     yanghao<yanghao@uniontech.com>
 *
 * Maintainer: zhengyouge<zhengyouge@uniontech.com>
 *             yanghao<yanghao@uniontech.com>
 *             hujianzhong<hujianzhong@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "dfmmasteredmediacrumbcontroller.h"

#include "dfileservices.h"

DFM_BEGIN_NAMESPACE

DFMMasteredMediaCrumbController::DFMMasteredMediaCrumbController(QObject *parent)
    : DFMCrumbInterface(parent)
{

}
DFMMasteredMediaCrumbController::~DFMMasteredMediaCrumbController()
{
}

bool DFMMasteredMediaCrumbController::supportedUrl(DUrl url)
{
    return url.scheme() == BURN_SCHEME;
}

QList<CrumbData> DFMMasteredMediaCrumbController::seprateUrl(const DUrl &url)
{
    QList<CrumbData> ret;
    DUrl cururl(url);
    while (true) {
        DAbstractFileInfoPointer info = DFileService::instance()->createFileInfo(nullptr, cururl);
        if (!info) {
            break;
        }
        QString displayText = info->fileDisplayName();
        ret.push_front(CrumbData(cururl, displayText));
        if (info->parentUrl() == DUrl::fromLocalFile(QDir::homePath())) {
            ret.front().iconName = "media-optical-symbolic";
            break;
        }
        cururl = info->parentUrl();
    }
    return ret;
}

DFM_END_NAMESPACE
