#ifndef GRUBREPAIRWIDGET_H
#define GRUBREPAIRWIDGET_H

#include "../../src/repairtoolsproxy.h"

#include <QWidget>
#include <QPushButton>
#include <QLabel>
#include <QTextEdit>

#include <DSpinner>
#include <dcommandlinkbutton.h>

DWIDGET_USE_NAMESPACE

class GrubRepairWidget : public QWidget
{
    Q_OBJECT

public:
    explicit GrubRepairWidget(QWidget *parent = nullptr);

    void setToolsProxy(RepairToolsProxy *proxy) { m_toolsProxy = proxy; }

protected:
    void showEvent(QShowEvent *e);
    void changeEvent(QEvent* event) override;

private slots:
    void onRepairClicked();
    void onRepairFinished(const bool success);
    void resetUi();
    void showDetail();
    void hideDetail();

private:
    RepairToolsProxy *m_toolsProxy;
    QLabel *m_icon;
    QLabel *m_centerTips;
    QLabel *m_statusTips;
    DSpinner *m_spinner;
    QTextEdit *m_output;
    DCommandLinkButton *m_showDetail;
    DCommandLinkButton *m_hideDetail;
    QPushButton *m_repairButton;
    QPushButton *m_okButton;
    QString m_statusTipsText;
};

#endif // GRUBREPAIRWIDGET_H
