@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#!/usr/bin/perl -w
#line 15
#
# ecaccess-ectrans-restart: Restart an existing ECtrans transfer
#
# Laurent.Gougeon@ecmwf.int - 2010-10-15

use ECMWF::ECaccess;
use Getopt::Long;
use Pod::Usage;

my %opt = (
	gateway         => undef,
	remote          => undef,
	target          => undef,
	mailTo          => undef,
	retryCount      => undef,
	retryFrequency  => undef,
	priority        => undef,
	lifeTime        => undef,
	onSuccess       => undef,
	onFailure       => undef,
	onRetry         => undef,
	keep            => undef,
	reject          => undef,
	append          => undef,
	resume          => undef,
	overwrite       => undef,
	maximumDuration => undef,
	minimumDuration => undef,
	minimumRate     => undef,
	version         => 0,
	help            => 0,
	manual          => 0,
	retry			=> 0,
	debug           => 0
);

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if !GetOptions(
	\%opt,
	qw(
	  gateway=s
	  remote=s
	  target=s
	  mailTo=s
	  retryCount=i
	  retryFrequency=i
	  priority=i
	  lifeTime=s
	  onSuccess
	  onFailure
	  onRetry
	  keep
	  reject
	  append
	  resume
	  overwrite
	  maximumDuration=s
	  minimumDuration=s
	  minimumRate=i
	  version
	  help|?
	  manual
	  retry=i
	  debug
	  )
);

# Display version if requested
die ECMWF::ECaccess->VERSION . "\n" if ( $opt{version} );

my $transferId = $ARGV[0];

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if ( $opt{help} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 2 ) if ( $opt{manual} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "No transfer-id specified!\n" ) if not($transferId);
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "Invalid -retryCount specified (>0)!\n" ) if $opt{retryCount} && not( $opt{retryCount} >= 0 );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "Invalid -retryFrequency specified (>0)!\n" ) if $opt{retryFrequency} && not( $opt{retryFrequency} > 0 );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "Invalid -priority specified (0-99)!\n" ) if $opt{priority} && not( $opt{priority} >= 0 && $opt{priority} <= 99 );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "Incompatible options (-append,-resume)!\n" )    if ( $opt{append} && $opt{resume} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "Incompatible options (-append,-overwrite)!\n" ) if ( $opt{append} && $opt{overwrite} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "Incompatible options (-append,-reject)!\n" )    if ( $opt{append} && $opt{reject} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "Incompatible options!(-resume,-overwrite)\n" )  if ( $opt{resume} && $opt{overwrite} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "Incompatible options!(-resume,-reject)\n" ) if ( $opt{resume} && $opt{reject} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "Incompatible options!(-reject,-overwrite)\n" ) if ( $opt{reject} && $opt{overwrite} );

# Create the ECaccess Controler
my $ecaccess = ECMWF::ECaccess->new( $opt{retry}, $opt{debug});

# Get the Token (using the Certificate in $HOME)
my $token = $ecaccess->getToken();

# Get the Control Channel
my $controlChannel = $ecaccess->getControlChannel();

# Value for "ifTargetFileExists" option
my $ifTargetFileExists = undef;
$ifTargetFileExists = 'reject'    if ( $opt{reject} );
$ifTargetFileExists = 'append'    if ( $opt{append} );
$ifTargetFileExists = 'resume'    if ( $opt{resume} );
$ifTargetFileExists = 'overwrite' if ( $opt{overwrite} );

# Restart the existing ECTrans
$controlChannel->restartTransfer(
	$token,
	SOAP::Data->name(
		"request" => \SOAP::Data->value(
			SOAP::Data->name( 'gatewayName'        => $opt{gateway} ),
			SOAP::Data->name( 'remoteLocation'     => $opt{remote} ),
			SOAP::Data->name( 'targetFileName'     => $opt{target} ),
			SOAP::Data->name( 'retryCount'         => $opt{retryCount} ),
			SOAP::Data->name( 'retryFrequency'     => $opt{retryFrequency} ),
			SOAP::Data->name( 'priority'           => $opt{priority} ),
			SOAP::Data->name( 'lifeTime'           => $opt{lifeTime} ),
			SOAP::Data->name( 'maximumDuration'    => $opt{maximumDuration} ),
			SOAP::Data->name( 'minimumDuration'    => $opt{minimumDuration} ),
			SOAP::Data->name( 'minimumRate'        => $opt{minimumRate} ),
			SOAP::Data->name( 'keepInSpool'        => defined $opt{keep} ? $opt{keep} ? 'true' : 'false' : undef ),
			SOAP::Data->name( 'userMailAddress'    => $opt{mailTo} ),
			SOAP::Data->name( 'sendMailOnSuccess'  => defined $opt{onSuccess} ? $opt{onSuccess} ? 'true' : 'false' : undef ),
			SOAP::Data->name( 'sendMailOnFailure'  => defined $opt{onFailure} ? $opt{onFailure} ? 'true' : 'false' : undef ),
			SOAP::Data->name( 'sendMailOnRetry'    => defined $opt{onRetry} ? $opt{onRetry} ? 'true' : 'false' : undef ),
			SOAP::Data->name( 'ifTargetFileExists' => $ifTargetFileExists )
		)
	),
	$transferId
);

# Logout
$ecaccess->releaseToken($token);

__END__

=head1 NAME

ecaccess-ectrans-restart - Restart an existing ECtrans transfer

=head1 SYNOPSIS

B<ecaccess-ectrans-restart -version|-help|-manual>

B<ecaccess-ectrans-restart [-debug] [-gateway> I<name>B<] [-remote> I<location>B<] [-target> I<file-name>B<] [-retryCount> I<number>B<]
[-retryFrequency> I<frequency>B<] [-priority> I<priority>B<] [-lifeTime> I<duration>B<] [-mailTo> I<email>B<] [-onSuccess] [-onFailure] [-onRetry]
[-keep] [-reject>|B<-append>|B<-resume>|B<-overwrite] [-maximumDuration> I<duration>B<] [-minimumDuration> I<duration>B<] [-minimumRate> I<rate>B<]>
I<ectrans-id>

=head1 DESCRIPTION

Allow restarting the ECtrans transfer with the I<ectrans-id> identifier.

In order to get the list of ECtrans transfers and the corresponding I<ectrans-id> please use the
B<ecaccess-ectrans-list> command. If you want to setup an ECtrans transfer then use the
B<ecaccess-ectrans-request> command which will give you an I<ectrans-id> (this one can be kept
for a later restart).

=head1 ARGUMENTS

=over 8

=item I<ectrans-id>

The identifier of the ECtrans transfer to restart.

=back

=head1 OPTIONS

=over 8

=item B<-gateway> I<name>

Update the I<name> of the ECaccess Gateway.

=item B<-remote> I<location>

Update the target I<location> in the format I<association-name>B<[>I<@protocol>B<]>.

=item B<-target> I<file-name>

Update the target I<file-name>.

=item B<-retryCount> I<number>

Update the I<number> of retries.

=item B<-retryFrequency> I<frequency>

Update the I<frequency> of retries in seconds.

=item B<-priority> I<priority>

Update the transmission I<priority> 0-99.

=item B<-lifeTime> I<duration>

Update the lifetime of the transfer request. The I<duration> is specified
in [w]eeks, [d]ays, [h]ours, [m]inutes or [s]econds (e.g. I<1w> or I<2d>).

=item B<-mailTo> I<email>

Update the target I<email> address.

=item B<-onSuccess>

Allow sending a mail when the transfer is successful.

=item B<-onFailure>

Allow sending a mail when the transfer has failed.

=item B<-onRetry>

Allow sending a mail when the transfer is retried.

=item B<-keep>

Allow keeping the request in the spool until the duration specified in the
B<-lifeTime> option has passed. By default a successful transfer is removed
from the spool.

=item B<-reject>

Allow failing if there is an existing target file.

=item B<-append>

Allow appending if there is an existing target file.

=item B<-resume>

Allow resuming if there is an existing target file.

=item B<-overwrite>

Allow overwriting if there is an existing target file.

=item B<-maximumDuration> I<duration>

Allow updating the maximum transfer I<duration>. The I<duration> is specified in [w]eeks,
[d]ays, [h]ours, [m]inutes or [s]econds (e.g. I<10m> or I<1h>). A value <=0 will deactivate
the feature.

=item B<-minimumDuration> I<duration>

Allow updating the I<duration> before to control a transmission (e.g. for the first 10 minutes
ECtrans don't try to check the transfer rate, which allow not to enforce some minimum transfer
rates for very small files). The I<duration> is specified in [w]eeks, [d]ays, [h]ours, [m]inutes
or [s]econds (e.g. I<30s> or I<10m>). A value <=0 will deactivate the feature.

=item B<-minimumRate> I<rate>

Allow updating the minimum transfer I<rate> for a transmission (expressed in bytes/s). This is an
average value, not the transmission I<rate> at one particular moment in time (e.g. if a big file
is stuck for 5 minutes but then transmit much faster later on then it will not be interrupted
as long as the overall transfer rate is above the minimum). A value <=0 will deactivate the feature.

=item B<-version>

Display version number and exits.

=item B<-help>

Print a brief help message and exits.

=item B<-manual>

Prints the manual page and exits.

=item B<-retry> I<count>

Number of SSL connection retries per 5s to ECMWF. This parameter only apply to the
initial SSL connection initiated by the command to the ECMWF server. It does not
apply to all the subsequent requests made afteward as it is mainly targeting errors
that can happen from time to time during the SSL handshake. Default is no retry.

=item B<-debug>

Display the SOAP and SSL messages exchanged.

=back

=head1 EXAMPLES

B<ecaccess-ectrans-restart> I<124356>

Restart the ECtrans transfer with the identifier I<124356>.

=head1 SEE ALSO

B<ecaccess-ectrans-delete>, B<ecaccess-ectrans-list>, B<ecaccess-ectrans-request> and B<ecaccess>.

=cut

__END__
:endofperl
