 #include <complex.h>
 /*! \brief C old, deprecated interface to create the MPI communicators for ELPA
 *
 * \param mpi_comm_word    MPI global communicator (in)
 * \param my_prow          Row coordinate of the calling process in the process grid (in)
 * \param my_pcol          Column coordinate of the calling process in the process grid (in)
 * \param mpi_comm_rows    Communicator for communicating within rows of processes (out)
 * \result int             integer error value of mpi_comm_split function
 */
 int elpa_get_communicators(int mpi_comm_world, int my_prow, int my_pcol, int *mpi_comm_rows, int *mpi_comm_cols);
 #include <complex.h>
 /*! \brief C interface to create the MPI communicators for ELPA
 *
 * \param mpi_comm_word    MPI global communicator (in)
 * \param my_prow          Row coordinate of the calling process in the process grid (in)
 * \param my_pcol          Column coordinate of the calling process in the process grid (in)
 * \param mpi_comm_rows    Communicator for communicating within rows of processes (out)
 * \result int             integer error value of mpi_comm_split function
 */
 int get_elpa_communicators(int mpi_comm_world, int my_prow, int my_pcol, int *mpi_comm_rows, int *mpi_comm_cols);
  /*! \brief C interface to solve the real eigenvalue problem with 1-stage solver
  *
 *  \param  na                   Order of matrix a
 *  \param  nev                  Number of eigenvalues needed.
 *                               The smallest nev eigenvalues/eigenvectors are calculated.
 *  \param  a                    Distributed matrix for which eigenvalues are to be computed.
 *                               Distribution is like in Scalapack.
 *                               The full matrix must be set (not only one half like in scalapack).
 *  \param lda                   Leading dimension of a
 *  \param ev(na)                On output: eigenvalues of a, every processor gets the complete set
 *  \param q                     On output: Eigenvectors of a
 *                               Distribution is like in Scalapack.
 *                               Must be always dimensioned to the full size (corresponding to (na,na))
 *                               even if only a part of the eigenvalues is needed.
 *  \param ldq                   Leading dimension of q
 *  \param nblk                  blocksize of cyclic distribution, must be the same in both directions!
 *  \param matrixCols           distributed number of matrix columns
 *  \param mpi_comm_rows        MPI-Communicator for rows
 *  \param mpi_comm_cols        MPI-Communicator for columns
 *
 *  \result                     int: 1 if error occured, otherwise 0
*/
 int elpa_solve_evp_real_1stage(int na, int nev, double *a, int lda, double *ev, double *q, int ldq, int nblk, int matrixCols, int mpi_comm_rows, int mpi_comm_cols);
 /*! \brief C interface to solve the complex eigenvalue problem with 1-stage solver
 *
 *  \param  na                   Order of matrix a
 *  \param  nev                  Number of eigenvalues needed.
 *                               The smallest nev eigenvalues/eigenvectors are calculated.
 *  \param  a                    Distributed matrix for which eigenvalues are to be computed.
 *                               Distribution is like in Scalapack.
 *                               The full matrix must be set (not only one half like in scalapack).
 *  \param lda                   Leading dimension of a
 *  \param ev(na)                On output: eigenvalues of a, every processor gets the complete set
 *  \param q                     On output: Eigenvectors of a
 *                               Distribution is like in Scalapack.
 *                               Must be always dimensioned to the full size (corresponding to (na,na))
 *                               even if only a part of the eigenvalues is needed.
 *  \param ldq                   Leading dimension of q
 *  \param nblk                  blocksize of cyclic distribution, must be the same in both directions!
 *  \param matrixCols           distributed number of matrix columns
 *  \param mpi_comm_rows        MPI-Communicator for rows
 *  \param mpi_comm_cols        MPI-Communicator for columns
 *
 *  \result                     int: 1 if error occured, otherwise 0
 */
 int elpa_solve_evp_complex_1stage(int na, int nev, double complex *a, int lda, double *ev, double complex *q, int ldq, int nblk, int matrixCols, int mpi_comm_rows, int mpi_comm_cols);
 /*! \brief C interface to solve the real eigenvalue problem with 2-stage solver
 *
 *  \param  na                        Order of matrix a
 *  \param  nev                       Number of eigenvalues needed.
 *                                    The smallest nev eigenvalues/eigenvectors are calculated.
 *  \param  a                         Distributed matrix for which eigenvalues are to be computed.
 *                                    Distribution is like in Scalapack.
 *                                    The full matrix must be set (not only one half like in scalapack).
 *  \param lda                        Leading dimension of a
 *  \param ev(na)                     On output: eigenvalues of a, every processor gets the complete set
 *  \param q                          On output: Eigenvectors of a
 *                                    Distribution is like in Scalapack.
 *                                    Must be always dimensioned to the full size (corresponding to (na,na))
 *                                    even if only a part of the eigenvalues is needed.
 *  \param ldq                        Leading dimension of q
 *  \param nblk                       blocksize of cyclic distribution, must be the same in both directions!
 *  \param matrixCols                 distributed number of matrix columns
 *  \param mpi_comm_rows              MPI-Communicator for rows
 *  \param mpi_comm_cols              MPI-Communicator for columns
 *  \param mpi_coll_all               MPI communicator for the total processor set
 *  \param THIS_REAL_ELPA_KERNEL_API  specify used ELPA2 kernel via API
 *  \param use_qr                     use QR decomposition 1 = yes, 0 = no
 *
 *  \result                     int: 1 if error occured, otherwise 0
 */
 int elpa_solve_evp_real_2stage(int na, int nev, double *a, int lda, double *ev, double *q, int ldq, int nblk, int matrixCols, int mpi_comm_rows, int mpi_comm_cols, int mpi_comm_all, int THIS_REAL_ELPA_KERNEL_API, int useQR);
 /*! \brief C interface to solve the complex eigenvalue problem with 2-stage solver
 *
 *  \param  na                        Order of matrix a
 *  \param  nev                       Number of eigenvalues needed.
 *                                    The smallest nev eigenvalues/eigenvectors are calculated.
 *  \param  a                         Distributed matrix for which eigenvalues are to be computed.
 *                                    Distribution is like in Scalapack.
 *                                    The full matrix must be set (not only one half like in scalapack).
 *  \param lda                        Leading dimension of a
 *  \param ev(na)                     On output: eigenvalues of a, every processor gets the complete set
 *  \param q                          On output: Eigenvectors of a
 *                                    Distribution is like in Scalapack.
 *                                    Must be always dimensioned to the full size (corresponding to (na,na))
 *                                    even if only a part of the eigenvalues is needed.
 *  \param ldq                        Leading dimension of q
 *  \param nblk                       blocksize of cyclic distribution, must be the same in both directions!
 *  \param matrixCols                 distributed number of matrix columns
 *  \param mpi_comm_rows              MPI-Communicator for rows
 *  \param mpi_comm_cols              MPI-Communicator for columns
 *  \param mpi_coll_all               MPI communicator for the total processor set
 *  \param THIS_REAL_ELPA_KERNEL_API  specify used ELPA2 kernel via API
 *  \param use_qr                     use QR decomposition 1 = yes, 0 = no
 *
 *  \result                     int: 1 if error occured, otherwise 0
 */
 int elpa_solve_evp_complex_2stage(int na, int nev, double complex *a, int lda, double *ev, double complex *q, int ldq, int nblk, int matrixCols, int mpi_comm_rows, int mpi_comm_cols, int mpi_comm_all, int THIS_COMPLEX_ELPA_KERNEL_API);
