/*
 *  Copyright (c) 2005-2009 FAUmachine Team.
 *  Copyright (c) 2003 Fabrice Bellard.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 */

void glue(glue(NAME_(op_ldub), MEMSUFFIX), _T0_A0)(void)
{
    T0(env) = glue(ldub, MEMSUFFIX)(env, A0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_ldsb), MEMSUFFIX), _T0_A0)(void)
{
    T0(env) = glue(ldsb, MEMSUFFIX)(env, A0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_lduw), MEMSUFFIX), _T0_A0)(void)
{
    T0(env) = glue(lduw, MEMSUFFIX)(env, A0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_ldsw), MEMSUFFIX), _T0_A0)(void)
{
    T0(env) = glue(ldsw, MEMSUFFIX)(env, A0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_ldl), MEMSUFFIX), _T0_A0)(void)
{
    T0(env) = (uint32_t)glue(ldl, MEMSUFFIX)(env, A0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_ldub), MEMSUFFIX), _T1_A0)(void)
{
    T1(env) = glue(ldub, MEMSUFFIX)(env, A0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_ldsb), MEMSUFFIX), _T1_A0)(void)
{
    T1(env) = glue(ldsb, MEMSUFFIX)(env, A0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_lduw), MEMSUFFIX), _T1_A0)(void)
{
    T1(env) = glue(lduw, MEMSUFFIX)(env, A0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_ldsw), MEMSUFFIX), _T1_A0)(void)
{
    T1(env) = glue(ldsw, MEMSUFFIX)(env, A0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_ldl), MEMSUFFIX), _T1_A0)(void)
{
    T1(env) = (uint32_t)glue(ldl, MEMSUFFIX)(env, A0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_stb), MEMSUFFIX), _T0_A0)(void)
{
    glue(stb, MEMSUFFIX)(env, A0(env), T0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_stw), MEMSUFFIX), _T0_A0)(void)
{
    glue(stw, MEMSUFFIX)(env, A0(env), T0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_stl), MEMSUFFIX), _T0_A0)(void)
{
    glue(stl, MEMSUFFIX)(env, A0(env), T0(env));
    FORCE_RET();
}

#if 0
void glue(glue(NAME_(op_stb), MEMSUFFIX), _T1_A0)(void)
{
    glue(stb, MEMSUFFIX)(A0(env), T1(env));
    FORCE_RET();
}
#endif

void glue(glue(NAME_(op_stw), MEMSUFFIX), _T1_A0)(void)
{
    glue(stw, MEMSUFFIX)(env, A0(env), T1(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_stl), MEMSUFFIX), _T1_A0)(void)
{
    glue(stl, MEMSUFFIX)(env, A0(env), T1(env));
    FORCE_RET();
}

/* SSE/MMX support */
void glue(glue(NAME_(op_ldq), MEMSUFFIX), _env_A0)(void)
{
    uint64_t *p;
    p = (uint64_t *)((char *)env + PARAM1);
    *p = glue(ldq, MEMSUFFIX)(env, A0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_stq), MEMSUFFIX), _env_A0)(void)
{
    uint64_t *p;
    p = (uint64_t *)((char *)env + PARAM1);
    glue(stq, MEMSUFFIX)(env, A0(env), *p);
    FORCE_RET();
}

void glue(glue(NAME_(op_ldo), MEMSUFFIX), _env_A0)(void)
{
    union XMMReg *p;
    p = (union XMMReg *)((char *)env + PARAM1);
    p->XMM_Q(0) = glue(ldq, MEMSUFFIX)(env, A0(env));
    p->XMM_Q(1) = glue(ldq, MEMSUFFIX)(env, A0(env) + 8);
    FORCE_RET();
}

void glue(glue(NAME_(op_sto), MEMSUFFIX), _env_A0)(void)
{
    union XMMReg *p;
    p = (union XMMReg *)((char *)env + PARAM1);
    glue(stq, MEMSUFFIX)(env, A0(env), p->XMM_Q(0));
    glue(stq, MEMSUFFIX)(env, A0(env) + 8, p->XMM_Q(1));
    FORCE_RET();
}

#if CONFIG_CPU >= 80486 && CONFIG_CPU_LM_SUPPORT
void glue(glue(NAME_(op_ldsl), MEMSUFFIX), _T0_A0)(void)
{
    T0(env) = (int32_t)glue(ldl, MEMSUFFIX)(env, A0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_ldsl), MEMSUFFIX), _T1_A0)(void)
{
    T1(env) = (int32_t)glue(ldl, MEMSUFFIX)(env, A0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_ldq), MEMSUFFIX), _T0_A0)(void)
{
    T0(env) = glue(ldq, MEMSUFFIX)(env, A0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_ldq), MEMSUFFIX), _T1_A0)(void)
{
    T1(env) = glue(ldq, MEMSUFFIX)(env, A0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_stq), MEMSUFFIX), _T0_A0)(void)
{
    glue(stq, MEMSUFFIX)(env, A0(env), T0(env));
    FORCE_RET();
}

void glue(glue(NAME_(op_stq), MEMSUFFIX), _T1_A0)(void)
{
    glue(stq, MEMSUFFIX)(env, A0(env), T1(env));
    FORCE_RET();
}
#endif /* CONFIG_CPU_LM_SUPPORT */

#undef MEMSUFFIX
