/*
 * Copyright (C) 2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef INCLUDE
#endif /* INCLUDE */
#ifdef STATE

struct {
	int state_left;
	int state_right;
	int state_adj;
} NAME;

#endif /* STATE */
#ifdef BEHAVIOR

static void
NAME_(update)(struct cpssp *cpssp)
{
	int mV;
	int mA;

	mV = (int) cpssp->NAME.state_left
		+ ((int) cpssp->NAME.state_right - (int) cpssp->NAME.state_left) * (int) cpssp->NAME.state_adj / 100;
	mA = -1;
	NAME_(mid_out_set)(cpssp, SIG_COMB(mV, mA));
}

static void
NAME_(left_in_set)(struct cpssp *cpssp, unsigned int val)
{
	cpssp->NAME.state_left = SIG_mV(val);
	NAME_(update)(cpssp);
}

static void
NAME_(right_in_set)(struct cpssp *cpssp, unsigned int val)
{
	cpssp->NAME.state_right = SIG_mV(val);
	NAME_(update)(cpssp);
}

static void
NAME_(adj_set)(struct cpssp *cpssp, int val)
{
	cpssp->NAME.state_adj = val;
	NAME_(update)(cpssp);
}

static void
NAME_(create)(struct cpssp *cpssp)
{
	cpssp->NAME.state_left = 0;
	cpssp->NAME.state_right = 0;
	cpssp->NAME.state_adj = 0;
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOUR */
