/*
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_STORAGE_H_INCLUDED
#define __GLUE_STORAGE_H_INCLUDED

#include <inttypes.h>

extern void *
storage_simple_open(const char *filename, int wflag);
extern int
storage_simple_close(void *_s);
extern unsigned long long
storage_simple_size(void *_s);
extern long long
storage_simple_read(void *_s,
		void *buf, unsigned long long buflen, unsigned long long pos);

extern void *
storage_create(const char *name,
	uint64_t size,
	const char *image,
	void *(*conv_open)(const char *, uint64_t),
	int (*conv_close)(void *),
	int64_t (*conv_read)(void *, void *, uint64_t, uint64_t)
);
extern int
storage_destroy(void *_s);

extern int
storage_read(void *_s,
		void *buf, unsigned int buflen, unsigned long long pos);
extern int
storage_write(void *_s,
		const void *buf, unsigned int buflen, unsigned long long pos);

/** print usage information for glue-storage parameters */
extern void
storage_usage(void);

/** handle storage specific command line arguments, removing these
 *  from argv and decrementing argc. Will also look at storage specific
 *  environment variables.
 *  @param argc argument counter.
 *  @param argv argument vector.
 */
extern void
storage_handle_args(int *argc, char **argv);

/** handle storage specific parameters from simsetup.
 */
extern void
storage_handle_simsetup(void);


#endif /* __GLUE_STORAGE_H_INCLUDED */
