%{
#include <ghmm/psequence.h>
%}

/*==========================================================================
  ===== discrete pair sequences ============================================ */

typedef struct ghmm_dpseq {
  /** for each alphabet in model->number_of_alphabets there is one int seq **/
  int** seq;
  /** number of alphabets (same as in model) **/
  int number_of_alphabets;
  /** for each sequence position there are also double values (e.g) Ka **/
  double** d_value;
  /** number of continous sequences **/
  int number_of_d_seqs;
  /** length of the sequence **/
  int length;
} ghmm_dpseq;

extern int ghmm_dpseq_free(ghmm_dpseq *sq);

%extend ghmm_dpseq {
        ghmm_dpseq(int length, int number_alphabets, int number_dseqs)
            {
                ghmm_dpseq* s = ghmm_dpseq_init(length, number_alphabets, number_dseqs);
                return s;
            }
        ~ghmm_dpseq() { ghmm_dpseq_free(self); }

        void set_discrete(int index, int *int_seq);

        void set_continuous(int index, double *d_seq);

        int* get_discrete(int index);

        double* get_continuous(int index);

        ghmm_dpseq* slice(int start, int stop);

        int get_char(int alphabet, int index);

        double get_double(int seq_index, int index);
}