#ifndef _OutputOptions_H
#define _OutputOptions_H

/* Class used to handle processing of command line parameters passed to
 * kdc2tiff and kdc2jpeg.
 * 
 * Written by:  Chris Studholme
 * Last Update: 6-Dec-2003
 * Copyright:   GPL (http://www.fsf.org/copyleft/gpl.html)
 */

#include "KDCFile.h"
#include "GImage.h"
#include "GFile_DC120.h"

#define DEFAULT_JPEG_QUALITY 75

class OutputOptions {
public:
  // input file options
  const char* inputname;
  GFile* srcimage;
  GImage* image;
  bool fastdebayer;

  KDCFile* kdcfile; // this should go away

  // image options
  int contrastenhance;
  float gammacorrection;
  int grainreduction;
  bool squarepixels;
  bool nocrop;
  int rotate;
  int outputwhite;
  int lightwhite;        // 0=no correction, -1=auto

  // temporary variables
  float gammaoffset;

  // output file options
  char* outputname;
  bool overwrite;   // overwrite output file if exists
  int outputwidth;
  int outputheight;
  char* copyright;

  // specific tiff options
  bool outputtiff;
  const char* compresstype;
  int rowsperstrip;

  // specific jpeg options
  bool outputjpeg;
  int quality;
  bool progressive;

public:
  OutputOptions() {
    // defaults
    inputname=0;
    srcimage=0;
    image=0;
    fastdebayer=false;

    kdcfile=0;

    contrastenhance=2;
    gammacorrection=1;
    grainreduction=0;
    squarepixels=true;
    nocrop=false;
    rotate=0;

    gammaoffset=0;

    outputwhite=6500;
    lightwhite=0;

    outputname=0;
    overwrite=false;
    outputwidth=0;
    outputheight=0;
    copyright=0;

    outputtiff=false;
    compresstype=0;
    rowsperstrip=0;

    outputjpeg=false;
    quality=DEFAULT_JPEG_QUALITY;
    progressive=false;
  }

  OutputOptions(OutputOptions& other) {
    // copy from other
    inputname=other.inputname;
    srcimage=other.srcimage;
    image=other.image;
    fastdebayer=other.fastdebayer;

    kdcfile=other.kdcfile;

    contrastenhance=other.contrastenhance;
    gammacorrection=other.gammacorrection;
    grainreduction=other.grainreduction;
    squarepixels=other.squarepixels;
    nocrop=other.nocrop;
    rotate=other.rotate;

    gammaoffset=other.gammaoffset;

    outputwhite=other.outputwhite;
    lightwhite=other.lightwhite;

    outputname=other.outputname;
    //overwrite=other.overwrite;
    overwrite=false;
    outputwidth=other.outputwidth;
    outputheight=other.outputheight;
    copyright=other.copyright;

    outputtiff=other.outputtiff;
    compresstype=other.compresstype;
    rowsperstrip=other.rowsperstrip;

    outputjpeg=other.outputjpeg;
    quality=other.quality;
    progressive=other.progressive;
  }


  void SetOutputParameters();

  void SetOutputFilename();

  void CalculateScanLine(unsigned char* dest, int y);

  /* stops at first non-option, return 0 if error, new argv othersise
   */
  char** ParseOptions(int& argc, char*argv[]);
  
};


#endif
