/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.interceptor;

import alt.jiapi.event.EventInstrumentor;
import alt.jiapi.interceptor.InvocationInterceptor;
import alt.jiapi.reflect.Instruction;
import alt.jiapi.reflect.InstructionFactory;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.reflect.JiapiClass;
import alt.jiapi.reflect.JiapiField;
import alt.jiapi.reflect.JiapiMethod;
import alt.jiapi.reflect.Loader;
import alt.jiapi.reflect.Signature;
import alt.jiapi.reflect.SignatureUtil;
import alt.jiapi.reflect.instruction.Invocation;
import alt.jiapi.reflect.instruction.OpcodeGroups;
import java.lang.reflect.InvocationHandler;
import org.apache.log4j.Category;

class InvocationInstrumentor
extends EventInstrumentor {
    private static Category log = Category.getInstance(InvocationInstrumentor.class);
    private InvocationHandler handler;

    InvocationInstrumentor(InvocationInterceptor ii, InvocationHandler handler) {
        super(ii);
        this.handler = handler;
    }

    public void instrument(JiapiMethod jm) {
        InstructionList il = jm.getInstructionList();
        if ("<clinit>".equals(jm.getName())) {
            return;
        }
        InstructionFactory factory = il.getInstructionFactory();
        JiapiClass ii = this.getEventProducer();
        JiapiMethod invokeMethod = null;
        try {
            invokeMethod = ii.getDeclaredMethod("invokeMethod", new String[]{"java.lang.Object", "java.lang.String", "java.lang.Object[]", "java.lang.String"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int idx = -1;
        while ((idx = il.indexOf(OpcodeGroups.INVOKE_INSTRUCTIONS, idx + 1)) != -1) {
            Invocation ins = (Invocation)il.get(idx);
            if (!this.match(ins.getClassName() + "." + ins.getMethodName()) || ins.getOpcode() != -72 && ins.getOpcode() != -74) continue;
            JiapiField interceptor = this.getEventProducerField();
            InstructionList nList = new InstructionList();
            ArgumentList al = this.createArgumentLists(il, idx);
            InstructionList[] pLists = al.arguments;
            int paramIdx = al.paramIndex;
            short opCode = ins.getOpcode();
            if (opCode == -74 || opCode == -73) {
                --paramIdx;
            }
            switch (opCode) {
                case -74: 
                case -72: {
                    nList.add(factory.getField(interceptor));
                    if (opCode == -72) {
                        this.addClassForNameInstructions(ins.getClassName(), nList);
                    } else {
                        nList.add(il.get(paramIdx));
                    }
                    String mName = ins.getMethodName();
                    nList.add(factory.pushConstant(mName));
                    nList.add(factory.newArray("java.lang.Object", ins.getParameterTypes().length));
                    String[] i_params = ins.getParameterTypes();
                    for (int i = 0; i < pLists.length; ++i) {
                        if ("long".equals(i_params[i])) {
                            nList.add(factory.dup());
                        } else if ("double".equals(i_params[i])) {
                            nList.add(factory.dup());
                        } else {
                            nList.add(factory.dup());
                        }
                        nList.add(factory.pushConstant(i));
                        nList.add(pLists[i]);
                        nList.add(factory.aastore());
                    }
                    nList.add(factory.pushConstant(ins.getClassName() + ins.getMethodName() + ins.getDescriptor()));
                    nList.add(factory.invoke(invokeMethod));
                    this.handleReturnValue(nList, ins);
                    il.replace(paramIdx, idx + 1, nList);
                }
            }
            idx = paramIdx + nList.size() - 1;
        }
    }

    private ArgumentList createArgumentLists(InstructionList il, int invocationIndex) {
        Invocation ins = (Invocation)il.get(invocationIndex);
        String[] paramTypes = ins.getParameterTypes();
        InstructionList[] argList = new InstructionList[paramTypes.length];
        int pIdx = invocationIndex - 1;
        for (int i = argList.length - 1; i >= 0; --i) {
            int stackUsage = ins.stackConsumption();
            InstructionList pList = il.createEmptyList();
            boolean primitive = SignatureUtil.isPrimitive(paramTypes[i]);
            Instruction pr_ins = null;
            if (primitive) {
                pr_ins = this.handlePrimitiveType(paramTypes[i], pList);
            }
            int insertIdx = pList.size();
            while (stackUsage > 0 && ins.getOpcode() == -72 || stackUsage > 1 && ins.getOpcode() == -74) {
                Instruction pIns = il.get(pIdx);
                stackUsage -= pIns.stackUsage();
                pList.insert(insertIdx, pIns);
                --pIdx;
            }
            if (primitive) {
                pList.add(pr_ins);
            }
            argList[i] = pList;
        }
        return new ArgumentList(argList, pIdx + 1);
    }

    private Instruction handlePrimitiveType(String type, InstructionList il) {
        InstructionFactory f = il.getInstructionFactory();
        String cName = null;
        Signature s = new Signature("void", new String[]{type});
        if ("int".equals(type)) {
            cName = "java.lang.Integer";
        } else if ("long".equals(type)) {
            cName = "java.lang.Long";
        } else if ("char".equals(type)) {
            cName = "java.lang.Character";
        } else if ("boolean".equals(type)) {
            cName = "java.lang.Boolean";
        } else if ("byte".equals(type)) {
            cName = "java.lang.Byte";
        } else if ("float".equals(type)) {
            cName = "java.lang.Float";
        } else if ("double".equals(type)) {
            cName = "java.lang.Double";
        }
        il.add(f.newClass(cName));
        il.add(f.dup());
        Instruction ins = f.invoke(1, cName, "<init>", s);
        return ins;
    }

    private void handleReturnValue(InstructionList il, Invocation ins) {
        InstructionFactory factory = il.getInstructionFactory();
        String rType = ins.getReturnType();
        if ("int".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Integer");
                JiapiMethod jm = jc.getDeclaredMethod("intValue", new String[0]);
                il.add(factory.cast("java.lang.Integer"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("long".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Long");
                JiapiMethod jm = jc.getDeclaredMethod("longValue", new String[0]);
                il.add(factory.cast("java.lang.Long"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("char".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Character");
                JiapiMethod jm = jc.getDeclaredMethod("charValue", new String[0]);
                il.add(factory.cast("java.lang.Character"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("boolean".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Boolean");
                JiapiMethod jm = jc.getDeclaredMethod("booleanValue", new String[0]);
                il.add(factory.cast("java.lang.Boolean"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("byte".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Byte");
                JiapiMethod jm = jc.getDeclaredMethod("byteValue", new String[0]);
                il.add(factory.cast("java.lang.Byte"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("float".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Float");
                JiapiMethod jm = jc.getDeclaredMethod("floatValue", new String[0]);
                il.add(factory.cast("java.lang.Float"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("double".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Double");
                JiapiMethod jm = jc.getDeclaredMethod("doubleValue", new String[0]);
                il.add(factory.cast("java.lang.Double"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("void".equals(rType)) {
            il.add(new Instruction(new byte[]{87}));
        } else {
            il.add(factory.cast(ins.getReturnType()));
        }
    }

    private void addClassForNameInstructions(String name, InstructionList il) {
        InstructionFactory f = il.getInstructionFactory();
        InstructionList nl = il.createEmptyList();
        try {
            nl.add(f.pushConstant(name));
            nl.add(f.invoke(8, "java.lang.Class", "forName", new Signature("java.lang.Class", new String[]{"java.lang.String"})));
        }
        catch (Exception e) {
            e.printStackTrace();
            il.add(f.pushNull());
        }
        il.add(nl);
    }

    private class ArgumentList {
        public InstructionList[] arguments;
        public int paramIndex;

        public ArgumentList(InstructionList[] args, int paramIndex) {
            this.arguments = args;
            this.paramIndex = paramIndex;
        }
    }
}

