/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class ASCII85EncodeStream
extends FilterOutputStream {
    private static final int BASE = 85;
    private static final int[] POW_85 = new int[]{52200625, 614125, 7225, 85, 1};
    private static final char[] CHAR_MAP = "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstu".toCharArray();
    private boolean closed;
    private final byte[] data;
    private int dataSize;
    private final byte[] prefixBytes;
    private boolean prefixDone;
    private final byte[] suffixBytes;
    private final byte[] encoded;

    public ASCII85EncodeStream(OutputStream outputStream, String string, String string2) {
        super(outputStream);
        this.prefixBytes = string != null ? string.getBytes() : "".getBytes();
        this.suffixBytes = string2 != null ? string2.getBytes() : "".getBytes();
        this.data = new byte[4];
        this.encoded = new byte[5];
    }

    public ASCII85EncodeStream(OutputStream outputStream) {
        this(outputStream, "", "~>");
    }

    @Override
    public void write(int n) throws IOException {
        if (this.closed) {
            return;
        }
        if (!this.prefixDone) {
            this.out.write(this.prefixBytes);
            this.prefixDone = true;
        }
        if (this.dataSize == this.data.length) {
            this.writeChunk();
            this.dataSize = 0;
        }
        this.data[this.dataSize++] = (byte)(n & 0xFF);
    }

    private void writeChunk() throws IOException {
        if (this.dataSize == 0) {
            return;
        }
        long l = ASCII85EncodeStream.toUInt32(this.data, this.dataSize);
        int n = this.data.length - this.dataSize;
        int n2 = this.encodeChunk(l, n);
        this.out.write(this.encoded, 0, n2);
    }

    private static long toUInt32(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 0; i < 4 && i < n; ++i) {
            l |= (long)((byArray[i] & 0xFF) << (3 - i) * 8);
        }
        return ASCII85EncodeStream.toUnsignedInt(l);
    }

    private static long toUnsignedInt(long l) {
        return l & 0xFFFFFFFFL;
    }

    private int encodeChunk(long l, int n) {
        Arrays.fill(this.encoded, (byte)0);
        if (l == 0L && n == 0) {
            this.encoded[0] = 122;
            return 1;
        }
        int n2 = this.encoded.length - n;
        for (int i = 0; i < n2; ++i) {
            this.encoded[i] = (byte)CHAR_MAP[(int)(l / (long)POW_85[i] % 85L)];
        }
        return n2;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.writeChunk();
        this.out.write(this.suffixBytes);
        super.close();
        this.closed = true;
    }
}

