/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.event.MouseEvent;
import org.jhotdraw.contrib.dnd.DragNDropTool;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.Handle;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.standard.DragTracker;
import org.jhotdraw.standard.HandleTracker;
import org.jhotdraw.standard.SelectAreaTracker;
import org.jhotdraw.util.UndoableHandle;
import org.jhotdraw.util.UndoableTool;

public class SelectionTool
extends AbstractTool {
    private Tool myDelegationTool = null;

    public SelectionTool(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDown(mouseEvent, n, n2);
        if (this.getDelegateTool() != null) {
            return;
        }
        this.view().freezeView();
        Handle handle = this.view().findHandle(mouseEvent.getX(), mouseEvent.getY());
        if (handle != null) {
            this.setDelegateTool(this.createHandleTracker(this.view(), handle));
        } else {
            Figure figure = this.drawing().findFigure(mouseEvent.getX(), mouseEvent.getY());
            if (figure != null) {
                this.setDelegateTool(this.createDragTracker(figure));
            } else {
                if (!mouseEvent.isShiftDown()) {
                    this.view().clearSelection();
                }
                this.setDelegateTool(this.createAreaTracker());
            }
        }
        this.getDelegateTool().activate();
        this.getDelegateTool().mouseDown(mouseEvent, n, n2);
    }

    public void mouseMove(MouseEvent mouseEvent, int n, int n2) {
        if (mouseEvent.getSource() == this.getActiveView()) {
            DragNDropTool.setCursor(mouseEvent.getX(), mouseEvent.getY(), this.getActiveView());
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        if (this.getDelegateTool() != null) {
            this.getDelegateTool().mouseDrag(mouseEvent, n, n2);
        }
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        if (this.getDelegateTool() != null) {
            this.getDelegateTool().mouseUp(mouseEvent, n, n2);
            this.getDelegateTool().deactivate();
            this.setDelegateTool(null);
        }
        if (this.view() != null) {
            this.view().unfreezeView();
            this.editor().figureSelectionChanged(this.view());
        }
    }

    protected Tool createHandleTracker(DrawingView drawingView, Handle handle) {
        return new HandleTracker(this.editor(), new UndoableHandle(handle));
    }

    protected Tool createDragTracker(Figure figure) {
        return new UndoableTool(new DragTracker(this.editor(), figure));
    }

    protected Tool createAreaTracker() {
        return new SelectAreaTracker(this.editor());
    }

    protected Tool getDelegateTool() {
        return this.myDelegationTool;
    }

    protected final void setDelegateTool(Tool tool) {
        this.myDelegationTool = tool;
    }
}

