/*
 * JFrameMain.java
 *
 * Created on 16. Januar 2007, 15:36
 */

package objtomap;

import java.io.IOException;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.table.AbstractTableModel;

/**
 *
 * @author  user
 */
public class JFrameMain extends javax.swing.JFrame {
    
    private Configuration config;
    
    /** Creates new form JFrameMain */
    public JFrameMain(Configuration c) {
        config = c;
        initComponents();
        
        updateForms();
    }
    
    private void updateForms() {
        jTextFieldInputFile.setText(config.objfile);
        jTextFieldOutputFile.setText(config.mapfile);
        jTextFieldScale.setText(Double.toString(config.scale));
        jTextFieldTextureScale.setText(Double.toString(config.texture_scale));
        jTextFieldThickness.setText(Double.toString(config.brush_thickness));
        jCheckDetail.setSelected(config.detail);
        
        jTableTexturing.setModel(new AutoTexturingTableModel(config.autotexturing));
        
        /*try {
            jTableRelations.setDefaultEditor(Class.forName("businesslearner.Letter"), new DefaultCellEditor(comboBoxLetters));
            jTableRelations.setDefaultEditor("".getClass(), new DefaultCellEditor(comboBoxRelations));
        } catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }*/
        
    }
    
    
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPanel1 = new javax.swing.JPanel();
        jTextFieldInputFile = new javax.swing.JTextField();
        jButtonSelectInputFile = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jTextFieldOutputFile = new javax.swing.JTextField();
        jButtonSelectOutputFile = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jCheckDetail = new javax.swing.JCheckBox();
        jTextFieldThickness = new javax.swing.JTextField();
        jTextFieldScale = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        jTextFieldTextureScale = new javax.swing.JTextField();
        jButtonStart = new javax.swing.JButton();
        jPanel4 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTableTexturing = new javax.swing.JTable();
        jButtonAdd = new javax.swing.JButton();
        jButtonDelte = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("ObjToMap");
        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Input File (.obj)"));
        jTextFieldInputFile.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldInputFileFocusLost(evt);
            }
        });

        jButtonSelectInputFile.setText("Select file");
        jButtonSelectInputFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSelectInputFileActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jTextFieldInputFile, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 477, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jButtonSelectInputFile)
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jButtonSelectInputFile)
                    .add(jTextFieldInputFile, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Output File (.map)"));
        jTextFieldOutputFile.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldOutputFileFocusLost(evt);
            }
        });

        jButtonSelectOutputFile.setText("Select file");
        jButtonSelectOutputFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSelectOutputFileActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jTextFieldOutputFile, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 477, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jButtonSelectOutputFile)
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jTextFieldOutputFile, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jButtonSelectOutputFile))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Configuration"));
        jLabel1.setText("Brush thickness:");

        jLabel2.setText("Model scale:");

        jCheckDetail.setText("Make generated brushes detail");
        jCheckDetail.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckDetail.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jCheckDetail.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckDetailActionPerformed(evt);
            }
        });

        jTextFieldThickness.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldThicknessFocusLost(evt);
            }
        });

        jTextFieldScale.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldScaleFocusLost(evt);
            }
        });

        jLabel3.setText("Texture scale:");

        jTextFieldTextureScale.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldTextureScaleFocusLost(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel3Layout = new org.jdesktop.layout.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel3Layout.createSequentialGroup()
                        .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(jLabel2)
                            .add(jLabel1))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                            .add(jTextFieldScale)
                            .add(jTextFieldThickness, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 56, Short.MAX_VALUE))
                        .add(29, 29, 29)
                        .add(jLabel3)
                        .add(12, 12, 12)
                        .add(jTextFieldTextureScale, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 58, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jCheckDetail))
                .addContainerGap(234, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(jTextFieldThickness, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel3)
                    .add(jTextFieldTextureScale, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(jTextFieldScale, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 19, Short.MAX_VALUE)
                .add(jCheckDetail)
                .addContainerGap())
        );

        jButtonStart.setText("Start conversion");
        jButtonStart.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonStartActionPerformed(evt);
            }
        });

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("Auto-texturing"));
        jTableTexturing.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane1.setViewportView(jTableTexturing);

        jButtonAdd.setText("New");
        jButtonAdd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAddActionPerformed(evt);
            }
        });

        jButtonDelte.setText("Remove");
        jButtonDelte.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDelteActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel4Layout = new org.jdesktop.layout.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 473, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(jButtonAdd, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(jButtonDelte, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 104, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel4Layout.createSequentialGroup()
                .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel4Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jButtonAdd)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jButtonDelte))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 167, Short.MAX_VALUE))
                .addContainerGap())
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel4, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(jButtonStart))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel4, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jButtonStart)
                .addContainerGap())
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonDelteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDelteActionPerformed
        int index = jTableTexturing.getSelectedRow();
        if(index < 0) return;
        config.autotexturing.remove(index);
        updateForms();
    }//GEN-LAST:event_jButtonDelteActionPerformed

    private void jButtonAddActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAddActionPerformed
        config.autotexturing.add(new AutoTexturingEntry());
        updateForms();
    }//GEN-LAST:event_jButtonAddActionPerformed
    
    private void jTextFieldOutputFileFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jTextFieldOutputFileFocusLost
        config.mapfile = jTextFieldOutputFile.getText();
        updateForms();
    }//GEN-LAST:event_jTextFieldOutputFileFocusLost
    
    private void jTextFieldInputFileFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jTextFieldInputFileFocusLost
        config.objfile = jTextFieldInputFile.getText();
        updateForms();
    }//GEN-LAST:event_jTextFieldInputFileFocusLost
    
    private void jTextFieldTextureScaleFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jTextFieldTextureScaleFocusLost
        try {
            config.texture_scale = Double.parseDouble(jTextFieldTextureScale.getText());
        } catch(Exception e) {}
        updateForms();
    }//GEN-LAST:event_jTextFieldTextureScaleFocusLost
    
    private void jButtonSelectOutputFileActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSelectOutputFileActionPerformed
        JFileChooser fc = new JFileChooser();
        int returnval = fc.showSaveDialog(this);
        if(returnval == JFileChooser.APPROVE_OPTION) {
            config.mapfile = fc.getSelectedFile().getPath();
        }
        updateForms();
    }//GEN-LAST:event_jButtonSelectOutputFileActionPerformed
    
    private void jButtonSelectInputFileActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSelectInputFileActionPerformed
        JFileChooser fc = new JFileChooser();
        int returnval = fc.showOpenDialog(this);
        if(returnval == JFileChooser.APPROVE_OPTION) {
            config.objfile = fc.getSelectedFile().getPath();
        }
        updateForms();
    }//GEN-LAST:event_jButtonSelectInputFileActionPerformed
    
    private void jButtonStartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonStartActionPerformed
        config.objfile = jTextFieldInputFile.getText();
        config.mapfile = jTextFieldOutputFile.getText();
        
        ObjToMap converter = new ObjToMap(config);
        try {
            converter.parseOBJ();
            converter.writeMap();
        } catch(Exception e) {
            e.printStackTrace();
        }
    }//GEN-LAST:event_jButtonStartActionPerformed
    
    private void jCheckDetailActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckDetailActionPerformed
        config.detail = jCheckDetail.isSelected();
        updateForms();
    }//GEN-LAST:event_jCheckDetailActionPerformed
    
    private void jTextFieldScaleFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jTextFieldScaleFocusLost
        try {
            config.scale = Double.parseDouble(jTextFieldScale.getText());
        } catch(Exception e) {}
        updateForms();
    }//GEN-LAST:event_jTextFieldScaleFocusLost
    
    private void jTextFieldThicknessFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jTextFieldThicknessFocusLost
        try {
            config.brush_thickness = Double.parseDouble(jTextFieldThickness.getText());
        } catch(Exception e) {}
        updateForms();
    }//GEN-LAST:event_jTextFieldThicknessFocusLost
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAdd;
    private javax.swing.JButton jButtonDelte;
    private javax.swing.JButton jButtonSelectInputFile;
    private javax.swing.JButton jButtonSelectOutputFile;
    private javax.swing.JButton jButtonStart;
    private javax.swing.JCheckBox jCheckDetail;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTableTexturing;
    private javax.swing.JTextField jTextFieldInputFile;
    private javax.swing.JTextField jTextFieldOutputFile;
    private javax.swing.JTextField jTextFieldScale;
    private javax.swing.JTextField jTextFieldTextureScale;
    private javax.swing.JTextField jTextFieldThickness;
    // End of variables declaration//GEN-END:variables
    
    private class AutoTexturingTableModel extends AbstractTableModel {
        
        Vector texturing;
        
        public AutoTexturingTableModel(Vector t) {
            texturing = t;
        }
        
        private String[] columnNames = {"Starting angle (against xy plane)","Texture name"};
        
        
        public int getColumnCount() {
            return 2;
        }
        
        public int getRowCount() {
            return texturing.size();
        }
        
        public String getColumnName(int col) {
            return columnNames[col];
        }
        
        public Object getValueAt(int row, int col) {
            if(row < 0 | row > texturing.size()) return null;
            
            AutoTexturingEntry e = (AutoTexturingEntry)texturing.get(row);
            if(col == 0)
                return new Double(e.angle);
            else
                return e.texturename;
        }
        
        public Class getColumnClass(int c) {
            return getValueAt(0, c).getClass();
        }
        
        public boolean isCellEditable(int row, int col) {
            return true;
        }
        
        public void setValueAt(Object value, int row, int col) {
            
            AutoTexturingEntry e = (AutoTexturingEntry)texturing.get(row);
            
            if(col == 0) {
                Double angle = (Double)value;
                e.angle = angle.doubleValue();
            } else {
                e.texturename = (String)value;
            }
            
            fireTableCellUpdated(row, col);
        }
    }
    
}
