<?php

final class PhabricatorPHDConfigOptions
  extends PhabricatorApplicationConfigOptions {

  public function getName() {
    return pht('Daemons');
  }

  public function getDescription() {
    return pht('Options relating to PHD (daemons).');
  }

  public function getIcon() {
    return 'fa-pied-piper-alt';
  }

  public function getGroup() {
    return 'core';
  }

  public function getOptions() {
    return array(
      $this->newOption('phd.pid-directory', 'string', '/var/tmp/phd/pid')
        ->setLocked(true)
        ->setDescription(
          pht('Directory that phd should use to track running daemons.')),
      $this->newOption('phd.log-directory', 'string', '/var/tmp/phd/log')
        ->setLocked(true)
        ->setDescription(
          pht('Directory that the daemons should use to store log files.')),
      $this->newOption('phd.taskmasters', 'int', 4)
        ->setLocked(true)
        ->setSummary(pht('Maximum taskmaster daemon pool size.'))
        ->setDescription(
          pht(
            "Maximum number of taskmaster daemons to run at once. Raising ".
            "this can increase the maximum throughput of the task queue. The ".
            "pool will automatically scale down when unutilized.".
            "\n\n".
            "If you are running a cluster, this limit applies separately ".
            "to each instance of `phd`. For example, if this limit is set ".
            "to `4` and you have three hosts running daemons, the effective ".
            "global limit will be 12.")),
      $this->newOption('phd.verbose', 'bool', false)
        ->setLocked(true)
        ->setBoolOptions(
          array(
            pht('Verbose mode'),
            pht('Normal mode'),
          ))
        ->setSummary(pht("Launch daemons in 'verbose' mode by default."))
        ->setDescription(
          pht(
            "Launch daemons in 'verbose' mode by default. This creates a lot ".
            "of output, but can help debug issues. Daemons launched in debug ".
            "mode with '%s' are always launched in verbose mode. ".
            "See also '%s'.",
            'phd debug',
            'phd.trace')),
      $this->newOption('phd.user', 'string', null)
        ->setLocked(true)
        ->setSummary(pht('System user to run daemons as.'))
        ->setDescription(
          pht(
            'Specify a system user to run the daemons as. Primarily, this '.
            'user will own the working copies of any repositories that '.
            'Phabricator imports or manages. This option is new and '.
            'experimental.')),
      $this->newOption('phd.trace', 'bool', false)
        ->setLocked(true)
        ->setBoolOptions(
          array(
            pht('Trace mode'),
            pht('Normal mode'),
          ))
        ->setSummary(pht("Launch daemons in 'trace' mode by default."))
        ->setDescription(
          pht(
            "Launch daemons in 'trace' mode by default. This creates an ".
            "ENORMOUS amount of output, but can help debug issues. Daemons ".
            "launched in debug mode with '%s' are always launched in ".
            "trace mode. See also '%s'.",
            'phd debug',
            'phd.verbose')),
      $this->newOption('phd.garbage-collection', 'wild', array())
        ->setLocked(true)
        ->setLockedMessage(
          pht(
            'This option can not be edited from the web UI. Use %s to adjust '.
            'garbage collector policies.',
            phutil_tag('tt', array(), 'bin/garbage set-policy')))
        ->setSummary(pht('Retention policies for garbage collection.'))
        ->setDescription(
          pht(
            'Customizes retention policies for garbage collectors.')),
    );
  }

}
