# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class APIError(Model):
    """Error information returned by the API.

    :param error:
    :type error: ~azure.cognitiveservices.vision.contentmoderator.models.Error
    """

    _attribute_map = {
        'error': {'key': 'Error', 'type': 'Error'},
    }

    def __init__(self, error=None):
        super(APIError, self).__init__()
        self.error = error


class APIErrorException(HttpOperationError):
    """Server responsed with exception of type: 'APIError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(APIErrorException, self).__init__(deserialize, response, 'APIError', *args)


class Address(Model):
    """Address details.

    :param text: Detected Address.
    :type text: str
    :param index: Index(Location) of the Address in the input text content.
    :type index: int
    """

    _attribute_map = {
        'text': {'key': 'Text', 'type': 'str'},
        'index': {'key': 'Index', 'type': 'int'},
    }

    def __init__(self, text=None, index=None):
        super(Address, self).__init__()
        self.text = text
        self.index = index


class Body(Model):
    """Body.

    :param name: Name of the list.
    :type name: str
    :param description: Description of the list.
    :type description: str
    :param metadata: Metadata of the list.
    :type metadata:
     ~azure.cognitiveservices.vision.contentmoderator.models.BodyMetadata
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': 'BodyMetadata'},
    }

    def __init__(self, name=None, description=None, metadata=None):
        super(Body, self).__init__()
        self.name = name
        self.description = description
        self.metadata = metadata


class BodyMetadata(Model):
    """Metadata of the list.

    :param key_one: Optional key value pair to describe your list.
    :type key_one: str
    :param key_two: Optional key value pair to describe your list.
    :type key_two: str
    """

    _attribute_map = {
        'key_one': {'key': 'Key One', 'type': 'str'},
        'key_two': {'key': 'Key Two', 'type': 'str'},
    }

    def __init__(self, key_one=None, key_two=None):
        super(BodyMetadata, self).__init__()
        self.key_one = key_one
        self.key_two = key_two


class BodyModel(Model):
    """BodyModel.

    :param data_representation:  Default value: "URL" .
    :type data_representation: str
    :param value:
    :type value: str
    """

    _attribute_map = {
        'data_representation': {'key': 'DataRepresentation', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, data_representation="URL", value=None):
        super(BodyModel, self).__init__()
        self.data_representation = data_representation
        self.value = value


class Candidate(Model):
    """OCR candidate text.

    :param text: The text found.
    :type text: str
    :param confidence: The confidence level.
    :type confidence: float
    """

    _attribute_map = {
        'text': {'key': 'Text', 'type': 'str'},
        'confidence': {'key': 'Confidence', 'type': 'float'},
    }

    def __init__(self, text=None, confidence=None):
        super(Candidate, self).__init__()
        self.text = text
        self.confidence = confidence


class Classification(Model):
    """The classification details of the text.

    :param category1:
    :type category1:
     ~azure.cognitiveservices.vision.contentmoderator.models.Score
    :param category2:
    :type category2:
     ~azure.cognitiveservices.vision.contentmoderator.models.Score
    :param category3:
    :type category3:
     ~azure.cognitiveservices.vision.contentmoderator.models.Score
    :param review_recommended: The review recommended flag.
    :type review_recommended: bool
    """

    _attribute_map = {
        'category1': {'key': 'Category1', 'type': 'Score'},
        'category2': {'key': 'Category2', 'type': 'Score'},
        'category3': {'key': 'Category3', 'type': 'Score'},
        'review_recommended': {'key': 'ReviewRecommended', 'type': 'bool'},
    }

    def __init__(self, category1=None, category2=None, category3=None, review_recommended=None):
        super(Classification, self).__init__()
        self.category1 = category1
        self.category2 = category2
        self.category3 = category3
        self.review_recommended = review_recommended


class Content(Model):
    """Content.

    :param content_value: Content to evaluate for a job.
    :type content_value: str
    """

    _validation = {
        'content_value': {'required': True},
    }

    _attribute_map = {
        'content_value': {'key': 'ContentValue', 'type': 'str'},
    }

    def __init__(self, content_value):
        super(Content, self).__init__()
        self.content_value = content_value


class CreateReviewBodyItem(Model):
    """Schema items of the body.

    :param type: Type of the content. Possible values include: 'Image', 'Text'
    :type type: str or
     ~azure.cognitiveservices.vision.contentmoderator.models.enum
    :param content: Content to review.
    :type content: str
    :param content_id: Content Identifier.
    :type content_id: str
    :param callback_endpoint: Optional CallbackEndpoint.
    :type callback_endpoint: str
    :param metadata: Optional metadata details.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.CreateReviewBodyItemMetadataItem]
    """

    _validation = {
        'type': {'required': True},
        'content': {'required': True},
        'content_id': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
        'content': {'key': 'Content', 'type': 'str'},
        'content_id': {'key': 'ContentId', 'type': 'str'},
        'callback_endpoint': {'key': 'CallbackEndpoint', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': '[CreateReviewBodyItemMetadataItem]'},
    }

    def __init__(self, type, content, content_id, callback_endpoint=None, metadata=None):
        super(CreateReviewBodyItem, self).__init__()
        self.type = type
        self.content = content
        self.content_id = content_id
        self.callback_endpoint = callback_endpoint
        self.metadata = metadata


class CreateReviewBodyItemMetadataItem(Model):
    """CreateReviewBodyItemMetadataItem.

    :param key: Your key parameter.
    :type key: str
    :param value: Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, key, value):
        super(CreateReviewBodyItemMetadataItem, self).__init__()
        self.key = key
        self.value = value


class CreateVideoReviewsBodyItem(Model):
    """Schema items of the body.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param video_frames: Optional metadata details.
    :type video_frames:
     list[~azure.cognitiveservices.vision.contentmoderator.models.CreateVideoReviewsBodyItemVideoFramesItem]
    :param metadata: Optional metadata details.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.CreateVideoReviewsBodyItemMetadataItem]
    :ivar type: Type of the content. Default value: "Video" .
    :vartype type: str
    :param content: Video content url to review.
    :type content: str
    :param content_id: Content Identifier.
    :type content_id: str
    :param status: Status of the video(Complete,Unpublished,Pending). Possible
     values include: 'Complete', 'Unpublished', 'Pending'
    :type status: str or
     ~azure.cognitiveservices.vision.contentmoderator.models.enum
    :param timescale: Timescale of the video.
    :type timescale: int
    :param callback_endpoint: Optional CallbackEndpoint.
    :type callback_endpoint: str
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'content': {'required': True},
        'content_id': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'video_frames': {'key': 'VideoFrames', 'type': '[CreateVideoReviewsBodyItemVideoFramesItem]'},
        'metadata': {'key': 'Metadata', 'type': '[CreateVideoReviewsBodyItemMetadataItem]'},
        'type': {'key': 'Type', 'type': 'str'},
        'content': {'key': 'Content', 'type': 'str'},
        'content_id': {'key': 'ContentId', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'timescale': {'key': 'Timescale', 'type': 'int'},
        'callback_endpoint': {'key': 'CallbackEndpoint', 'type': 'str'},
    }

    type = "Video"

    def __init__(self, content, content_id, status, video_frames=None, metadata=None, timescale=None, callback_endpoint=None):
        super(CreateVideoReviewsBodyItem, self).__init__()
        self.video_frames = video_frames
        self.metadata = metadata
        self.content = content
        self.content_id = content_id
        self.status = status
        self.timescale = timescale
        self.callback_endpoint = callback_endpoint


class CreateVideoReviewsBodyItemMetadataItem(Model):
    """CreateVideoReviewsBodyItemMetadataItem.

    :param key: Your key parameter.
    :type key: str
    :param value: Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, key, value):
        super(CreateVideoReviewsBodyItemMetadataItem, self).__init__()
        self.key = key
        self.value = value


class CreateVideoReviewsBodyItemVideoFramesItem(Model):
    """CreateVideoReviewsBodyItemVideoFramesItem.

    :param id: Id of the frame.
    :type id: str
    :param timestamp: Timestamp of the frame.
    :type timestamp: int
    :param frame_image: Frame image Url.
    :type frame_image: str
    :param reviewer_result_tags:
    :type reviewer_result_tags:
     list[~azure.cognitiveservices.vision.contentmoderator.models.CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem]
    :param metadata: Optional metadata details.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.CreateVideoReviewsBodyItemVideoFramesItemMetadataItem]
    """

    _validation = {
        'id': {'required': True},
        'timestamp': {'required': True},
        'frame_image': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'timestamp': {'key': 'Timestamp', 'type': 'int'},
        'frame_image': {'key': 'FrameImage', 'type': 'str'},
        'reviewer_result_tags': {'key': 'ReviewerResultTags', 'type': '[CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem]'},
        'metadata': {'key': 'Metadata', 'type': '[CreateVideoReviewsBodyItemVideoFramesItemMetadataItem]'},
    }

    def __init__(self, id, timestamp, frame_image, reviewer_result_tags=None, metadata=None):
        super(CreateVideoReviewsBodyItemVideoFramesItem, self).__init__()
        self.id = id
        self.timestamp = timestamp
        self.frame_image = frame_image
        self.reviewer_result_tags = reviewer_result_tags
        self.metadata = metadata


class CreateVideoReviewsBodyItemVideoFramesItemMetadataItem(Model):
    """CreateVideoReviewsBodyItemVideoFramesItemMetadataItem.

    :param key: Your key parameter.
    :type key: str
    :param value: Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, key, value):
        super(CreateVideoReviewsBodyItemVideoFramesItemMetadataItem, self).__init__()
        self.key = key
        self.value = value


class CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem(Model):
    """CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem.

    :param key: Your key parameter.
    :type key: str
    :param value: Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, key, value):
        super(CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem, self).__init__()
        self.key = key
        self.value = value


class DetectedLanguage(Model):
    """Detect language result.

    :param detected_language: The detected language.
    :type detected_language: str
    :param status: The detect language status
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: The tracking id.
    :type tracking_id: str
    """

    _attribute_map = {
        'detected_language': {'key': 'DetectedLanguage', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, detected_language=None, status=None, tracking_id=None):
        super(DetectedLanguage, self).__init__()
        self.detected_language = detected_language
        self.status = status
        self.tracking_id = tracking_id


class DetectedTerms(Model):
    """Detected Terms details.

    :param index: Index(Location) of the detected profanity term in the input
     text content.
    :type index: int
    :param original_index: Original Index(Location) of the detected profanity
     term in the input text content.
    :type original_index: int
    :param list_id: Matched Terms list Id.
    :type list_id: int
    :param term: Detected profanity term.
    :type term: str
    """

    _attribute_map = {
        'index': {'key': 'Index', 'type': 'int'},
        'original_index': {'key': 'OriginalIndex', 'type': 'int'},
        'list_id': {'key': 'ListId', 'type': 'int'},
        'term': {'key': 'Term', 'type': 'str'},
    }

    def __init__(self, index=None, original_index=None, list_id=None, term=None):
        super(DetectedTerms, self).__init__()
        self.index = index
        self.original_index = original_index
        self.list_id = list_id
        self.term = term


class Email(Model):
    """Email Address details.

    :param detected: Detected Email Address from the input text content.
    :type detected: str
    :param sub_type: Subtype of the detected Email Address.
    :type sub_type: str
    :param text: Email Address in the input text content.
    :type text: str
    :param index: Index(Location) of the Email address in the input text
     content.
    :type index: int
    """

    _attribute_map = {
        'detected': {'key': 'Detected', 'type': 'str'},
        'sub_type': {'key': 'SubType', 'type': 'str'},
        'text': {'key': 'Text', 'type': 'str'},
        'index': {'key': 'Index', 'type': 'int'},
    }

    def __init__(self, detected=None, sub_type=None, text=None, index=None):
        super(Email, self).__init__()
        self.detected = detected
        self.sub_type = sub_type
        self.text = text
        self.index = index


class Error(Model):
    """Error body.

    :param code:
    :type code: str
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'Code', 'type': 'str'},
        'message': {'key': 'Message', 'type': 'str'},
    }

    def __init__(self, code=None, message=None):
        super(Error, self).__init__()
        self.code = code
        self.message = message


class Evaluate(Model):
    """Evaluate response object.

    :param cache_id: The cache id.
    :type cache_id: str
    :param result: Evaluate result.
    :type result: bool
    :param tracking_id: The tracking id.
    :type tracking_id: str
    :param adult_classification_score: The adult classification score.
    :type adult_classification_score: float
    :param is_image_adult_classified: Indicates if an image is classified as
     adult.
    :type is_image_adult_classified: bool
    :param racy_classification_score: The racy classication score.
    :type racy_classification_score: float
    :param is_image_racy_classified: Indicates if the image is classified as
     racy.
    :type is_image_racy_classified: bool
    :param advanced_info: The advanced info.
    :type advanced_info:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param status: The evaluate status
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    """

    _attribute_map = {
        'cache_id': {'key': 'CacheID', 'type': 'str'},
        'result': {'key': 'Result', 'type': 'bool'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
        'adult_classification_score': {'key': 'AdultClassificationScore', 'type': 'float'},
        'is_image_adult_classified': {'key': 'IsImageAdultClassified', 'type': 'bool'},
        'racy_classification_score': {'key': 'RacyClassificationScore', 'type': 'float'},
        'is_image_racy_classified': {'key': 'IsImageRacyClassified', 'type': 'bool'},
        'advanced_info': {'key': 'AdvancedInfo', 'type': '[KeyValuePair]'},
        'status': {'key': 'Status', 'type': 'Status'},
    }

    def __init__(self, cache_id=None, result=None, tracking_id=None, adult_classification_score=None, is_image_adult_classified=None, racy_classification_score=None, is_image_racy_classified=None, advanced_info=None, status=None):
        super(Evaluate, self).__init__()
        self.cache_id = cache_id
        self.result = result
        self.tracking_id = tracking_id
        self.adult_classification_score = adult_classification_score
        self.is_image_adult_classified = is_image_adult_classified
        self.racy_classification_score = racy_classification_score
        self.is_image_racy_classified = is_image_racy_classified
        self.advanced_info = advanced_info
        self.status = status


class Face(Model):
    """Coordinates to the found face.

    :param bottom: The bottom coordinate.
    :type bottom: int
    :param left: The left coordinate.
    :type left: int
    :param right: The right coordinate.
    :type right: int
    :param top: The top coordinate.
    :type top: int
    """

    _attribute_map = {
        'bottom': {'key': 'Bottom', 'type': 'int'},
        'left': {'key': 'Left', 'type': 'int'},
        'right': {'key': 'Right', 'type': 'int'},
        'top': {'key': 'Top', 'type': 'int'},
    }

    def __init__(self, bottom=None, left=None, right=None, top=None):
        super(Face, self).__init__()
        self.bottom = bottom
        self.left = left
        self.right = right
        self.top = top


class FoundFaces(Model):
    """Request object the contains found faces.

    :param status: The evaluate status
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: The tracking id.
    :type tracking_id: str
    :param cache_id: The cache id.
    :type cache_id: str
    :param result: True if result was found.
    :type result: bool
    :param count: Number of faces found.
    :type count: int
    :param advanced_info: The advanced info.
    :type advanced_info:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param faces: The list of faces.
    :type faces:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Face]
    """

    _attribute_map = {
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
        'cache_id': {'key': 'CacheId', 'type': 'str'},
        'result': {'key': 'Result', 'type': 'bool'},
        'count': {'key': 'Count', 'type': 'int'},
        'advanced_info': {'key': 'AdvancedInfo', 'type': '[KeyValuePair]'},
        'faces': {'key': 'Faces', 'type': '[Face]'},
    }

    def __init__(self, status=None, tracking_id=None, cache_id=None, result=None, count=None, advanced_info=None, faces=None):
        super(FoundFaces, self).__init__()
        self.status = status
        self.tracking_id = tracking_id
        self.cache_id = cache_id
        self.result = result
        self.count = count
        self.advanced_info = advanced_info
        self.faces = faces


class Frame(Model):
    """Video frame property details.

    :param timestamp: Timestamp of the frame.
    :type timestamp: str
    :param frame_image: Frame image.
    :type frame_image: str
    :param metadata: Array of KeyValue.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param reviewer_result_tags: Reviewer result tags.
    :type reviewer_result_tags:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Tag]
    """

    _attribute_map = {
        'timestamp': {'key': 'Timestamp', 'type': 'str'},
        'frame_image': {'key': 'FrameImage', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': '[KeyValuePair]'},
        'reviewer_result_tags': {'key': 'ReviewerResultTags', 'type': '[Tag]'},
    }

    def __init__(self, timestamp=None, frame_image=None, metadata=None, reviewer_result_tags=None):
        super(Frame, self).__init__()
        self.timestamp = timestamp
        self.frame_image = frame_image
        self.metadata = metadata
        self.reviewer_result_tags = reviewer_result_tags


class Frames(Model):
    """The response for a Get Frames request.

    :param review_id: Id of the review.
    :type review_id: str
    :param video_frames:
    :type video_frames:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Frame]
    """

    _attribute_map = {
        'review_id': {'key': 'ReviewId', 'type': 'str'},
        'video_frames': {'key': 'VideoFrames', 'type': '[Frame]'},
    }

    def __init__(self, review_id=None, video_frames=None):
        super(Frames, self).__init__()
        self.review_id = review_id
        self.video_frames = video_frames


class IPA(Model):
    """IP Address details.

    :param sub_type: Subtype of the detected IP Address.
    :type sub_type: str
    :param text: Detected IP Address.
    :type text: str
    :param index: Index(Location) of the IP Address in the input text content.
    :type index: int
    """

    _attribute_map = {
        'sub_type': {'key': 'SubType', 'type': 'str'},
        'text': {'key': 'Text', 'type': 'str'},
        'index': {'key': 'Index', 'type': 'int'},
    }

    def __init__(self, sub_type=None, text=None, index=None):
        super(IPA, self).__init__()
        self.sub_type = sub_type
        self.text = text
        self.index = index


class Image(Model):
    """Image Properties.

    :param content_id: Content Id.
    :type content_id: str
    :param additional_info: Advanced info list.
    :type additional_info:
     list[~azure.cognitiveservices.vision.contentmoderator.models.ImageAdditionalInfoItem]
    :param status: Status details.
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: Tracking Id.
    :type tracking_id: str
    """

    _attribute_map = {
        'content_id': {'key': 'ContentId', 'type': 'str'},
        'additional_info': {'key': 'AdditionalInfo', 'type': '[ImageAdditionalInfoItem]'},
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, content_id=None, additional_info=None, status=None, tracking_id=None):
        super(Image, self).__init__()
        self.content_id = content_id
        self.additional_info = additional_info
        self.status = status
        self.tracking_id = tracking_id


class ImageAdditionalInfoItem(Model):
    """ImageAdditionalInfoItem.

    :param key: Key parameter.
    :type key: str
    :param value: Value parameter.
    :type value: str
    """

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, key=None, value=None):
        super(ImageAdditionalInfoItem, self).__init__()
        self.key = key
        self.value = value


class ImageIds(Model):
    """Image Id properties.

    :param content_source: Source of the content.
    :type content_source: str
    :param content_ids: Id of the contents.
    :type content_ids: list[int]
    :param status: Get Image status.
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: Tracking Id.
    :type tracking_id: str
    """

    _attribute_map = {
        'content_source': {'key': 'ContentSource', 'type': 'str'},
        'content_ids': {'key': 'ContentIds', 'type': '[int]'},
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, content_source=None, content_ids=None, status=None, tracking_id=None):
        super(ImageIds, self).__init__()
        self.content_source = content_source
        self.content_ids = content_ids
        self.status = status
        self.tracking_id = tracking_id


class ImageList(Model):
    """Image List Properties.

    :param id: Image List Id.
    :type id: int
    :param name: Image List Name.
    :type name: str
    :param description: Description for image list.
    :type description: str
    :param metadata: Image List Metadata.
    :type metadata:
     ~azure.cognitiveservices.vision.contentmoderator.models.ImageListMetadata
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'int'},
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': 'ImageListMetadata'},
    }

    def __init__(self, id=None, name=None, description=None, metadata=None):
        super(ImageList, self).__init__()
        self.id = id
        self.name = name
        self.description = description
        self.metadata = metadata


class ImageListMetadata(Model):
    """Image List Metadata.

    :param key_one: Optional Key value pair to describe your list.
    :type key_one: str
    :param key_two: Optional Key value pair to describe your list.
    :type key_two: str
    """

    _attribute_map = {
        'key_one': {'key': 'Key One', 'type': 'str'},
        'key_two': {'key': 'Key Two', 'type': 'str'},
    }

    def __init__(self, key_one=None, key_two=None):
        super(ImageListMetadata, self).__init__()
        self.key_one = key_one
        self.key_two = key_two


class Job(Model):
    """The Job object.

    :param id: The job id.
    :type id: str
    :param team_name: The team name associated with the job.
    :type team_name: str
    :param status: The status string (<Pending, Failed, Completed>).
    :type status: str
    :param workflow_id: The Id of the workflow.
    :type workflow_id: str
    :param type: Type of the content.
    :type type: str
    :param call_back_endpoint: The callback endpoint.
    :type call_back_endpoint: str
    :param review_id: Review Id if one is created.
    :type review_id: str
    :param result_meta_data: Array of KeyValue pairs.
    :type result_meta_data:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param job_execution_report: Job execution report- Array of KeyValue pairs
     object.
    :type job_execution_report:
     list[~azure.cognitiveservices.vision.contentmoderator.models.JobExecutionReportDetails]
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'team_name': {'key': 'TeamName', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'workflow_id': {'key': 'WorkflowId', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'call_back_endpoint': {'key': 'CallBackEndpoint', 'type': 'str'},
        'review_id': {'key': 'ReviewId', 'type': 'str'},
        'result_meta_data': {'key': 'ResultMetaData', 'type': '[KeyValuePair]'},
        'job_execution_report': {'key': 'JobExecutionReport', 'type': '[JobExecutionReportDetails]'},
    }

    def __init__(self, id=None, team_name=None, status=None, workflow_id=None, type=None, call_back_endpoint=None, review_id=None, result_meta_data=None, job_execution_report=None):
        super(Job, self).__init__()
        self.id = id
        self.team_name = team_name
        self.status = status
        self.workflow_id = workflow_id
        self.type = type
        self.call_back_endpoint = call_back_endpoint
        self.review_id = review_id
        self.result_meta_data = result_meta_data
        self.job_execution_report = job_execution_report


class JobExecutionReportDetails(Model):
    """Job Execution Report Values.

    :param ts: Time details.
    :type ts: str
    :param msg: Message details.
    :type msg: str
    """

    _attribute_map = {
        'ts': {'key': 'Ts', 'type': 'str'},
        'msg': {'key': 'Msg', 'type': 'str'},
    }

    def __init__(self, ts=None, msg=None):
        super(JobExecutionReportDetails, self).__init__()
        self.ts = ts
        self.msg = msg


class JobId(Model):
    """JobId.

    :param job_id: Id of the created job.
    :type job_id: str
    """

    _attribute_map = {
        'job_id': {'key': 'JobId', 'type': 'str'},
    }

    def __init__(self, job_id=None):
        super(JobId, self).__init__()
        self.job_id = job_id


class JobListResult(Model):
    """The list of job ids.

    :param value: The job id.
    :type value: list[str]
    """

    _attribute_map = {
        'value': {'key': 'Value', 'type': '[str]'},
    }

    def __init__(self, value=None):
        super(JobListResult, self).__init__()
        self.value = value


class KeyValuePair(Model):
    """The key value pair object properties.

    :param key: The key parameter.
    :type key: str
    :param value: The value parameter.
    :type value: str
    """

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, key=None, value=None):
        super(KeyValuePair, self).__init__()
        self.key = key
        self.value = value


class Match(Model):
    """The match details.

    :param score: Confidence score of the image match.
    :type score: float
    :param match_id: The match id.
    :type match_id: int
    :param source: The source.
    :type source: str
    :param tags: The tags for match details.
    :type tags: list[int]
    :param label: The label.
    :type label: str
    """

    _attribute_map = {
        'score': {'key': 'Score', 'type': 'float'},
        'match_id': {'key': 'MatchId', 'type': 'int'},
        'source': {'key': 'Source', 'type': 'str'},
        'tags': {'key': 'Tags', 'type': '[int]'},
        'label': {'key': 'Label', 'type': 'str'},
    }

    def __init__(self, score=None, match_id=None, source=None, tags=None, label=None):
        super(Match, self).__init__()
        self.score = score
        self.match_id = match_id
        self.source = source
        self.tags = tags
        self.label = label


class MatchResponse(Model):
    """The response for a Match request.

    :param tracking_id: The tracking id.
    :type tracking_id: str
    :param cache_id: The cache id.
    :type cache_id: str
    :param is_match: Indicates if there is a match.
    :type is_match: bool
    :param matches: The match details.
    :type matches:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Match]
    :param status: The evaluate status
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    """

    _attribute_map = {
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
        'cache_id': {'key': 'CacheID', 'type': 'str'},
        'is_match': {'key': 'IsMatch', 'type': 'bool'},
        'matches': {'key': 'Matches', 'type': '[Match]'},
        'status': {'key': 'Status', 'type': 'Status'},
    }

    def __init__(self, tracking_id=None, cache_id=None, is_match=None, matches=None, status=None):
        super(MatchResponse, self).__init__()
        self.tracking_id = tracking_id
        self.cache_id = cache_id
        self.is_match = is_match
        self.matches = matches
        self.status = status


class OCR(Model):
    """Contains the text found in image for the language specified.

    :param status: The evaluate status
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param metadata: Array of KeyValue.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param tracking_id: The tracking id.
    :type tracking_id: str
    :param cache_id: The cache id.
    :type cache_id: str
    :param language: The ISO 639-3 code.
    :type language: str
    :param text: The found text.
    :type text: str
    :param candidates: The list of candidate text.
    :type candidates:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Candidate]
    """

    _attribute_map = {
        'status': {'key': 'Status', 'type': 'Status'},
        'metadata': {'key': 'Metadata', 'type': '[KeyValuePair]'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
        'cache_id': {'key': 'CacheId', 'type': 'str'},
        'language': {'key': 'Language', 'type': 'str'},
        'text': {'key': 'Text', 'type': 'str'},
        'candidates': {'key': 'Candidates', 'type': '[Candidate]'},
    }

    def __init__(self, status=None, metadata=None, tracking_id=None, cache_id=None, language=None, text=None, candidates=None):
        super(OCR, self).__init__()
        self.status = status
        self.metadata = metadata
        self.tracking_id = tracking_id
        self.cache_id = cache_id
        self.language = language
        self.text = text
        self.candidates = candidates


class PII(Model):
    """Personal Identifier Information details.

    :param email:
    :type email:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Email]
    :param ipa:
    :type ipa:
     list[~azure.cognitiveservices.vision.contentmoderator.models.IPA]
    :param phone:
    :type phone:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Phone]
    :param address:
    :type address:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Address]
    """

    _attribute_map = {
        'email': {'key': 'Email', 'type': '[Email]'},
        'ipa': {'key': 'IPA', 'type': '[IPA]'},
        'phone': {'key': 'Phone', 'type': '[Phone]'},
        'address': {'key': 'Address', 'type': '[Address]'},
    }

    def __init__(self, email=None, ipa=None, phone=None, address=None):
        super(PII, self).__init__()
        self.email = email
        self.ipa = ipa
        self.phone = phone
        self.address = address


class Phone(Model):
    """Phone Property details.

    :param country_code: CountryCode of the detected Phone number.
    :type country_code: str
    :param text: Detected Phone number.
    :type text: str
    :param index: Index(Location) of the Phone number in the input text
     content.
    :type index: int
    """

    _attribute_map = {
        'country_code': {'key': 'CountryCode', 'type': 'str'},
        'text': {'key': 'Text', 'type': 'str'},
        'index': {'key': 'Index', 'type': 'int'},
    }

    def __init__(self, country_code=None, text=None, index=None):
        super(Phone, self).__init__()
        self.country_code = country_code
        self.text = text
        self.index = index


class RefreshIndex(Model):
    """Refresh Index Response.

    :param content_source_id: Content source Id.
    :type content_source_id: str
    :param is_update_success: Update success status.
    :type is_update_success: bool
    :param advanced_info: Advanced info list.
    :type advanced_info:
     list[~azure.cognitiveservices.vision.contentmoderator.models.RefreshIndexAdvancedInfoItem]
    :param status: Refresh index status.
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: Tracking Id.
    :type tracking_id: str
    """

    _attribute_map = {
        'content_source_id': {'key': 'ContentSourceId', 'type': 'str'},
        'is_update_success': {'key': 'IsUpdateSuccess', 'type': 'bool'},
        'advanced_info': {'key': 'AdvancedInfo', 'type': '[RefreshIndexAdvancedInfoItem]'},
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, content_source_id=None, is_update_success=None, advanced_info=None, status=None, tracking_id=None):
        super(RefreshIndex, self).__init__()
        self.content_source_id = content_source_id
        self.is_update_success = is_update_success
        self.advanced_info = advanced_info
        self.status = status
        self.tracking_id = tracking_id


class RefreshIndexAdvancedInfoItem(Model):
    """RefreshIndexAdvancedInfoItem.

    :param key_one: Key parameter to describe advanced info.
    :type key_one: str
    :param key_two: Key parameter to describe advanced info.
    :type key_two: str
    """

    _attribute_map = {
        'key_one': {'key': 'Key One', 'type': 'str'},
        'key_two': {'key': 'Key Two', 'type': 'str'},
    }

    def __init__(self, key_one=None, key_two=None):
        super(RefreshIndexAdvancedInfoItem, self).__init__()
        self.key_one = key_one
        self.key_two = key_two


class Review(Model):
    """The Review object.

    :param review_id: Id of the review.
    :type review_id: str
    :param sub_team: Name of the subteam.
    :type sub_team: str
    :param status: The status string (<Pending, Complete>).
    :type status: str
    :param reviewer_result_tags: Array of KeyValue with Reviewer set Tags.
    :type reviewer_result_tags:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param created_by: The reviewer name.
    :type created_by: str
    :param metadata: Array of KeyValue.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param type: The type of content.
    :type type: str
    :param content: The content value.
    :type content: str
    :param content_id: Id of the content.
    :type content_id: str
    :param callback_endpoint: The callback endpoint.
    :type callback_endpoint: str
    """

    _attribute_map = {
        'review_id': {'key': 'ReviewId', 'type': 'str'},
        'sub_team': {'key': 'SubTeam', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'reviewer_result_tags': {'key': 'ReviewerResultTags', 'type': '[KeyValuePair]'},
        'created_by': {'key': 'CreatedBy', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': '[KeyValuePair]'},
        'type': {'key': 'Type', 'type': 'str'},
        'content': {'key': 'Content', 'type': 'str'},
        'content_id': {'key': 'ContentId', 'type': 'str'},
        'callback_endpoint': {'key': 'CallbackEndpoint', 'type': 'str'},
    }

    def __init__(self, review_id=None, sub_team=None, status=None, reviewer_result_tags=None, created_by=None, metadata=None, type=None, content=None, content_id=None, callback_endpoint=None):
        super(Review, self).__init__()
        self.review_id = review_id
        self.sub_team = sub_team
        self.status = status
        self.reviewer_result_tags = reviewer_result_tags
        self.created_by = created_by
        self.metadata = metadata
        self.type = type
        self.content = content
        self.content_id = content_id
        self.callback_endpoint = callback_endpoint


class Score(Model):
    """The classification score details of the text. <a
    href="https://aka.ms/textClassifyCategories">Click here</a> for more
    details on category classification.

    :param score: The category score.
    :type score: float
    """

    _attribute_map = {
        'score': {'key': 'Score', 'type': 'float'},
    }

    def __init__(self, score=None):
        super(Score, self).__init__()
        self.score = score


class Screen(Model):
    """The response for a Screen text request.

    :param original_text: The original text.
    :type original_text: str
    :param normalized_text: The normalized text.
    :type normalized_text: str
    :param auto_corrected_text: The autocorrected text
    :type auto_corrected_text: str
    :param misrepresentation: The misrepresentation text.
    :type misrepresentation: list[str]
    :param classification: The classification details of the text.
    :type classification:
     ~azure.cognitiveservices.vision.contentmoderator.models.Classification
    :param status: The evaluate status.
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param pii: Personal Identifier Information details.
    :type pii: ~azure.cognitiveservices.vision.contentmoderator.models.PII
    :param language: Language of the input text content.
    :type language: str
    :param terms:
    :type terms:
     list[~azure.cognitiveservices.vision.contentmoderator.models.DetectedTerms]
    :param tracking_id: Unique Content Moderator transaction Id.
    :type tracking_id: str
    """

    _attribute_map = {
        'original_text': {'key': 'OriginalText', 'type': 'str'},
        'normalized_text': {'key': 'NormalizedText', 'type': 'str'},
        'auto_corrected_text': {'key': 'AutoCorrectedText', 'type': 'str'},
        'misrepresentation': {'key': 'Misrepresentation', 'type': '[str]'},
        'classification': {'key': 'Classification', 'type': 'Classification'},
        'status': {'key': 'Status', 'type': 'Status'},
        'pii': {'key': 'PII', 'type': 'PII'},
        'language': {'key': 'Language', 'type': 'str'},
        'terms': {'key': 'Terms', 'type': '[DetectedTerms]'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, original_text=None, normalized_text=None, auto_corrected_text=None, misrepresentation=None, classification=None, status=None, pii=None, language=None, terms=None, tracking_id=None):
        super(Screen, self).__init__()
        self.original_text = original_text
        self.normalized_text = normalized_text
        self.auto_corrected_text = auto_corrected_text
        self.misrepresentation = misrepresentation
        self.classification = classification
        self.status = status
        self.pii = pii
        self.language = language
        self.terms = terms
        self.tracking_id = tracking_id


class Status(Model):
    """Status properties.

    :param code: Status code.
    :type code: int
    :param description: Status description.
    :type description: str
    :param exception: Exception status.
    :type exception: str
    """

    _attribute_map = {
        'code': {'key': 'Code', 'type': 'int'},
        'description': {'key': 'Description', 'type': 'str'},
        'exception': {'key': 'Exception', 'type': 'str'},
    }

    def __init__(self, code=None, description=None, exception=None):
        super(Status, self).__init__()
        self.code = code
        self.description = description
        self.exception = exception


class Tag(Model):
    """Tag details.

    :param key: The key parameter.
    :type key: str
    :param value: The value parameter.
    :type value: str
    """

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, key=None, value=None):
        super(Tag, self).__init__()
        self.key = key
        self.value = value


class TermList(Model):
    """Term List  Properties.

    :param id: Term list Id.
    :type id: int
    :param name: Term list name.
    :type name: str
    :param description: Description for term list.
    :type description: str
    :param metadata: Term list metadata.
    :type metadata:
     ~azure.cognitiveservices.vision.contentmoderator.models.TermListMetadata
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'int'},
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': 'TermListMetadata'},
    }

    def __init__(self, id=None, name=None, description=None, metadata=None):
        super(TermList, self).__init__()
        self.id = id
        self.name = name
        self.description = description
        self.metadata = metadata


class TermListMetadata(Model):
    """Term list metadata.

    :param key_one: Optional Key value pair to describe your list.
    :type key_one: str
    :param key_two: Optional Key value pair to describe your list.
    :type key_two: str
    """

    _attribute_map = {
        'key_one': {'key': 'Key One', 'type': 'str'},
        'key_two': {'key': 'Key Two', 'type': 'str'},
    }

    def __init__(self, key_one=None, key_two=None):
        super(TermListMetadata, self).__init__()
        self.key_one = key_one
        self.key_two = key_two


class Terms(Model):
    """Terms properties.

    :param data: Term data details.
    :type data:
     ~azure.cognitiveservices.vision.contentmoderator.models.TermsData
    :param paging: Paging details.
    :type paging:
     ~azure.cognitiveservices.vision.contentmoderator.models.TermsPaging
    """

    _attribute_map = {
        'data': {'key': 'Data', 'type': 'TermsData'},
        'paging': {'key': 'Paging', 'type': 'TermsPaging'},
    }

    def __init__(self, data=None, paging=None):
        super(Terms, self).__init__()
        self.data = data
        self.paging = paging


class TermsData(Model):
    """All term Id response properties.

    :param language: Language of the terms.
    :type language: str
    :param terms: List of terms.
    :type terms:
     list[~azure.cognitiveservices.vision.contentmoderator.models.TermsInList]
    :param status: Term Status.
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: Tracking Id.
    :type tracking_id: str
    """

    _attribute_map = {
        'language': {'key': 'Language', 'type': 'str'},
        'terms': {'key': 'Terms', 'type': '[TermsInList]'},
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, language=None, terms=None, status=None, tracking_id=None):
        super(TermsData, self).__init__()
        self.language = language
        self.terms = terms
        self.status = status
        self.tracking_id = tracking_id


class TermsInList(Model):
    """Terms in list Id passed.

    :param term: Added term details.
    :type term: str
    """

    _attribute_map = {
        'term': {'key': 'Term', 'type': 'str'},
    }

    def __init__(self, term=None):
        super(TermsInList, self).__init__()
        self.term = term


class TermsPaging(Model):
    """Paging details.

    :param total: Total details.
    :type total: int
    :param limit: Limit details.
    :type limit: int
    :param offset: Offset details.
    :type offset: int
    :param returned: Returned text details.
    :type returned: int
    """

    _attribute_map = {
        'total': {'key': 'Total', 'type': 'int'},
        'limit': {'key': 'Limit', 'type': 'int'},
        'offset': {'key': 'Offset', 'type': 'int'},
        'returned': {'key': 'Returned', 'type': 'int'},
    }

    def __init__(self, total=None, limit=None, offset=None, returned=None):
        super(TermsPaging, self).__init__()
        self.total = total
        self.limit = limit
        self.offset = offset
        self.returned = returned


class TranscriptModerationBodyItem(Model):
    """Schema items of the body.

    :param timestamp: Timestamp of the image.
    :type timestamp: str
    :param terms: Optional metadata details.
    :type terms:
     list[~azure.cognitiveservices.vision.contentmoderator.models.TranscriptModerationBodyItemTermsItem]
    """

    _validation = {
        'timestamp': {'required': True},
        'terms': {'required': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'Timestamp', 'type': 'str'},
        'terms': {'key': 'Terms', 'type': '[TranscriptModerationBodyItemTermsItem]'},
    }

    def __init__(self, timestamp, terms):
        super(TranscriptModerationBodyItem, self).__init__()
        self.timestamp = timestamp
        self.terms = terms


class TranscriptModerationBodyItemTermsItem(Model):
    """TranscriptModerationBodyItemTermsItem.

    :param index: Index of the word
    :type index: int
    :param term: Detected word.
    :type term: str
    """

    _validation = {
        'index': {'required': True},
        'term': {'required': True},
    }

    _attribute_map = {
        'index': {'key': 'Index', 'type': 'int'},
        'term': {'key': 'Term', 'type': 'str'},
    }

    def __init__(self, index, term):
        super(TranscriptModerationBodyItemTermsItem, self).__init__()
        self.index = index
        self.term = term


class VideoFrameBodyItem(Model):
    """Schema items of the body.

    :param timestamp: Timestamp of the frame.
    :type timestamp: str
    :param frame_image: Content to review.
    :type frame_image: str
    :param reviewer_result_tags:
    :type reviewer_result_tags:
     list[~azure.cognitiveservices.vision.contentmoderator.models.VideoFrameBodyItemReviewerResultTagsItem]
    :param metadata: Optional metadata details.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.VideoFrameBodyItemMetadataItem]
    """

    _validation = {
        'timestamp': {'required': True},
        'frame_image': {'required': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'Timestamp', 'type': 'str'},
        'frame_image': {'key': 'FrameImage', 'type': 'str'},
        'reviewer_result_tags': {'key': 'ReviewerResultTags', 'type': '[VideoFrameBodyItemReviewerResultTagsItem]'},
        'metadata': {'key': 'Metadata', 'type': '[VideoFrameBodyItemMetadataItem]'},
    }

    def __init__(self, timestamp, frame_image, reviewer_result_tags=None, metadata=None):
        super(VideoFrameBodyItem, self).__init__()
        self.timestamp = timestamp
        self.frame_image = frame_image
        self.reviewer_result_tags = reviewer_result_tags
        self.metadata = metadata


class VideoFrameBodyItemMetadataItem(Model):
    """VideoFrameBodyItemMetadataItem.

    :param key: Your key parameter.
    :type key: str
    :param value: Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, key, value):
        super(VideoFrameBodyItemMetadataItem, self).__init__()
        self.key = key
        self.value = value


class VideoFrameBodyItemReviewerResultTagsItem(Model):
    """VideoFrameBodyItemReviewerResultTagsItem.

    :param key: Your key parameter.
    :type key: str
    :param value: Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, key, value):
        super(VideoFrameBodyItemReviewerResultTagsItem, self).__init__()
        self.key = key
        self.value = value
