# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EdifactEnvelopeSettings(Model):
    """The Edifact agreement envelope settings.

    All required parameters must be populated in order to send to Azure.

    :param group_association_assigned_code: The group association assigned
     code.
    :type group_association_assigned_code: str
    :param communication_agreement_id: The communication agreement id.
    :type communication_agreement_id: str
    :param apply_delimiter_string_advice: Required. The value indicating
     whether to apply delimiter string advice.
    :type apply_delimiter_string_advice: bool
    :param create_grouping_segments: Required. The value indicating whether to
     create grouping segments.
    :type create_grouping_segments: bool
    :param enable_default_group_headers: Required. The value indicating
     whether to enable default group headers.
    :type enable_default_group_headers: bool
    :param recipient_reference_password_value: The recipient reference
     password value.
    :type recipient_reference_password_value: str
    :param recipient_reference_password_qualifier: The recipient reference
     password qualifier.
    :type recipient_reference_password_qualifier: str
    :param application_reference_id: The application reference id.
    :type application_reference_id: str
    :param processing_priority_code: The processing priority code.
    :type processing_priority_code: str
    :param interchange_control_number_lower_bound: Required. The interchange
     control number lower bound.
    :type interchange_control_number_lower_bound: long
    :param interchange_control_number_upper_bound: Required. The interchange
     control number upper bound.
    :type interchange_control_number_upper_bound: long
    :param rollover_interchange_control_number: Required. The value indicating
     whether to rollover interchange control number.
    :type rollover_interchange_control_number: bool
    :param interchange_control_number_prefix: The interchange control number
     prefix.
    :type interchange_control_number_prefix: str
    :param interchange_control_number_suffix: The interchange control number
     suffix.
    :type interchange_control_number_suffix: str
    :param sender_reverse_routing_address: The sender reverse routing address.
    :type sender_reverse_routing_address: str
    :param receiver_reverse_routing_address: The receiver reverse routing
     address.
    :type receiver_reverse_routing_address: str
    :param functional_group_id: The functional group id.
    :type functional_group_id: str
    :param group_controlling_agency_code: The group controlling agency code.
    :type group_controlling_agency_code: str
    :param group_message_version: The group message version.
    :type group_message_version: str
    :param group_message_release: The group message release.
    :type group_message_release: str
    :param group_control_number_lower_bound: Required. The group control
     number lower bound.
    :type group_control_number_lower_bound: long
    :param group_control_number_upper_bound: Required. The group control
     number upper bound.
    :type group_control_number_upper_bound: long
    :param rollover_group_control_number: Required. The value indicating
     whether to rollover group control number.
    :type rollover_group_control_number: bool
    :param group_control_number_prefix: The group control number prefix.
    :type group_control_number_prefix: str
    :param group_control_number_suffix: The group control number suffix.
    :type group_control_number_suffix: str
    :param group_application_receiver_qualifier: The group application
     receiver qualifier.
    :type group_application_receiver_qualifier: str
    :param group_application_receiver_id: The group application receiver id.
    :type group_application_receiver_id: str
    :param group_application_sender_qualifier: The group application sender
     qualifier.
    :type group_application_sender_qualifier: str
    :param group_application_sender_id: The group application sender id.
    :type group_application_sender_id: str
    :param group_application_password: The group application password.
    :type group_application_password: str
    :param overwrite_existing_transaction_set_control_number: Required. The
     value indicating whether to overwrite existing transaction set control
     number.
    :type overwrite_existing_transaction_set_control_number: bool
    :param transaction_set_control_number_prefix: The transaction set control
     number prefix.
    :type transaction_set_control_number_prefix: str
    :param transaction_set_control_number_suffix: The transaction set control
     number suffix.
    :type transaction_set_control_number_suffix: str
    :param transaction_set_control_number_lower_bound: Required. The
     transaction set control number lower bound.
    :type transaction_set_control_number_lower_bound: long
    :param transaction_set_control_number_upper_bound: Required. The
     transaction set control number upper bound.
    :type transaction_set_control_number_upper_bound: long
    :param rollover_transaction_set_control_number: Required. The value
     indicating whether to rollover transaction set control number.
    :type rollover_transaction_set_control_number: bool
    :param is_test_interchange: Required. The value indicating whether the
     message is a test interchange.
    :type is_test_interchange: bool
    :param sender_internal_identification: The sender internal identification.
    :type sender_internal_identification: str
    :param sender_internal_sub_identification: The sender internal sub
     identification.
    :type sender_internal_sub_identification: str
    :param receiver_internal_identification: The receiver internal
     identification.
    :type receiver_internal_identification: str
    :param receiver_internal_sub_identification: The receiver internal sub
     identification.
    :type receiver_internal_sub_identification: str
    """

    _validation = {
        'apply_delimiter_string_advice': {'required': True},
        'create_grouping_segments': {'required': True},
        'enable_default_group_headers': {'required': True},
        'interchange_control_number_lower_bound': {'required': True},
        'interchange_control_number_upper_bound': {'required': True},
        'rollover_interchange_control_number': {'required': True},
        'group_control_number_lower_bound': {'required': True},
        'group_control_number_upper_bound': {'required': True},
        'rollover_group_control_number': {'required': True},
        'overwrite_existing_transaction_set_control_number': {'required': True},
        'transaction_set_control_number_lower_bound': {'required': True},
        'transaction_set_control_number_upper_bound': {'required': True},
        'rollover_transaction_set_control_number': {'required': True},
        'is_test_interchange': {'required': True},
    }

    _attribute_map = {
        'group_association_assigned_code': {'key': 'groupAssociationAssignedCode', 'type': 'str'},
        'communication_agreement_id': {'key': 'communicationAgreementId', 'type': 'str'},
        'apply_delimiter_string_advice': {'key': 'applyDelimiterStringAdvice', 'type': 'bool'},
        'create_grouping_segments': {'key': 'createGroupingSegments', 'type': 'bool'},
        'enable_default_group_headers': {'key': 'enableDefaultGroupHeaders', 'type': 'bool'},
        'recipient_reference_password_value': {'key': 'recipientReferencePasswordValue', 'type': 'str'},
        'recipient_reference_password_qualifier': {'key': 'recipientReferencePasswordQualifier', 'type': 'str'},
        'application_reference_id': {'key': 'applicationReferenceId', 'type': 'str'},
        'processing_priority_code': {'key': 'processingPriorityCode', 'type': 'str'},
        'interchange_control_number_lower_bound': {'key': 'interchangeControlNumberLowerBound', 'type': 'long'},
        'interchange_control_number_upper_bound': {'key': 'interchangeControlNumberUpperBound', 'type': 'long'},
        'rollover_interchange_control_number': {'key': 'rolloverInterchangeControlNumber', 'type': 'bool'},
        'interchange_control_number_prefix': {'key': 'interchangeControlNumberPrefix', 'type': 'str'},
        'interchange_control_number_suffix': {'key': 'interchangeControlNumberSuffix', 'type': 'str'},
        'sender_reverse_routing_address': {'key': 'senderReverseRoutingAddress', 'type': 'str'},
        'receiver_reverse_routing_address': {'key': 'receiverReverseRoutingAddress', 'type': 'str'},
        'functional_group_id': {'key': 'functionalGroupId', 'type': 'str'},
        'group_controlling_agency_code': {'key': 'groupControllingAgencyCode', 'type': 'str'},
        'group_message_version': {'key': 'groupMessageVersion', 'type': 'str'},
        'group_message_release': {'key': 'groupMessageRelease', 'type': 'str'},
        'group_control_number_lower_bound': {'key': 'groupControlNumberLowerBound', 'type': 'long'},
        'group_control_number_upper_bound': {'key': 'groupControlNumberUpperBound', 'type': 'long'},
        'rollover_group_control_number': {'key': 'rolloverGroupControlNumber', 'type': 'bool'},
        'group_control_number_prefix': {'key': 'groupControlNumberPrefix', 'type': 'str'},
        'group_control_number_suffix': {'key': 'groupControlNumberSuffix', 'type': 'str'},
        'group_application_receiver_qualifier': {'key': 'groupApplicationReceiverQualifier', 'type': 'str'},
        'group_application_receiver_id': {'key': 'groupApplicationReceiverId', 'type': 'str'},
        'group_application_sender_qualifier': {'key': 'groupApplicationSenderQualifier', 'type': 'str'},
        'group_application_sender_id': {'key': 'groupApplicationSenderId', 'type': 'str'},
        'group_application_password': {'key': 'groupApplicationPassword', 'type': 'str'},
        'overwrite_existing_transaction_set_control_number': {'key': 'overwriteExistingTransactionSetControlNumber', 'type': 'bool'},
        'transaction_set_control_number_prefix': {'key': 'transactionSetControlNumberPrefix', 'type': 'str'},
        'transaction_set_control_number_suffix': {'key': 'transactionSetControlNumberSuffix', 'type': 'str'},
        'transaction_set_control_number_lower_bound': {'key': 'transactionSetControlNumberLowerBound', 'type': 'long'},
        'transaction_set_control_number_upper_bound': {'key': 'transactionSetControlNumberUpperBound', 'type': 'long'},
        'rollover_transaction_set_control_number': {'key': 'rolloverTransactionSetControlNumber', 'type': 'bool'},
        'is_test_interchange': {'key': 'isTestInterchange', 'type': 'bool'},
        'sender_internal_identification': {'key': 'senderInternalIdentification', 'type': 'str'},
        'sender_internal_sub_identification': {'key': 'senderInternalSubIdentification', 'type': 'str'},
        'receiver_internal_identification': {'key': 'receiverInternalIdentification', 'type': 'str'},
        'receiver_internal_sub_identification': {'key': 'receiverInternalSubIdentification', 'type': 'str'},
    }

    def __init__(self, *, apply_delimiter_string_advice: bool, create_grouping_segments: bool, enable_default_group_headers: bool, interchange_control_number_lower_bound: int, interchange_control_number_upper_bound: int, rollover_interchange_control_number: bool, group_control_number_lower_bound: int, group_control_number_upper_bound: int, rollover_group_control_number: bool, overwrite_existing_transaction_set_control_number: bool, transaction_set_control_number_lower_bound: int, transaction_set_control_number_upper_bound: int, rollover_transaction_set_control_number: bool, is_test_interchange: bool, group_association_assigned_code: str=None, communication_agreement_id: str=None, recipient_reference_password_value: str=None, recipient_reference_password_qualifier: str=None, application_reference_id: str=None, processing_priority_code: str=None, interchange_control_number_prefix: str=None, interchange_control_number_suffix: str=None, sender_reverse_routing_address: str=None, receiver_reverse_routing_address: str=None, functional_group_id: str=None, group_controlling_agency_code: str=None, group_message_version: str=None, group_message_release: str=None, group_control_number_prefix: str=None, group_control_number_suffix: str=None, group_application_receiver_qualifier: str=None, group_application_receiver_id: str=None, group_application_sender_qualifier: str=None, group_application_sender_id: str=None, group_application_password: str=None, transaction_set_control_number_prefix: str=None, transaction_set_control_number_suffix: str=None, sender_internal_identification: str=None, sender_internal_sub_identification: str=None, receiver_internal_identification: str=None, receiver_internal_sub_identification: str=None, **kwargs) -> None:
        super(EdifactEnvelopeSettings, self).__init__(**kwargs)
        self.group_association_assigned_code = group_association_assigned_code
        self.communication_agreement_id = communication_agreement_id
        self.apply_delimiter_string_advice = apply_delimiter_string_advice
        self.create_grouping_segments = create_grouping_segments
        self.enable_default_group_headers = enable_default_group_headers
        self.recipient_reference_password_value = recipient_reference_password_value
        self.recipient_reference_password_qualifier = recipient_reference_password_qualifier
        self.application_reference_id = application_reference_id
        self.processing_priority_code = processing_priority_code
        self.interchange_control_number_lower_bound = interchange_control_number_lower_bound
        self.interchange_control_number_upper_bound = interchange_control_number_upper_bound
        self.rollover_interchange_control_number = rollover_interchange_control_number
        self.interchange_control_number_prefix = interchange_control_number_prefix
        self.interchange_control_number_suffix = interchange_control_number_suffix
        self.sender_reverse_routing_address = sender_reverse_routing_address
        self.receiver_reverse_routing_address = receiver_reverse_routing_address
        self.functional_group_id = functional_group_id
        self.group_controlling_agency_code = group_controlling_agency_code
        self.group_message_version = group_message_version
        self.group_message_release = group_message_release
        self.group_control_number_lower_bound = group_control_number_lower_bound
        self.group_control_number_upper_bound = group_control_number_upper_bound
        self.rollover_group_control_number = rollover_group_control_number
        self.group_control_number_prefix = group_control_number_prefix
        self.group_control_number_suffix = group_control_number_suffix
        self.group_application_receiver_qualifier = group_application_receiver_qualifier
        self.group_application_receiver_id = group_application_receiver_id
        self.group_application_sender_qualifier = group_application_sender_qualifier
        self.group_application_sender_id = group_application_sender_id
        self.group_application_password = group_application_password
        self.overwrite_existing_transaction_set_control_number = overwrite_existing_transaction_set_control_number
        self.transaction_set_control_number_prefix = transaction_set_control_number_prefix
        self.transaction_set_control_number_suffix = transaction_set_control_number_suffix
        self.transaction_set_control_number_lower_bound = transaction_set_control_number_lower_bound
        self.transaction_set_control_number_upper_bound = transaction_set_control_number_upper_bound
        self.rollover_transaction_set_control_number = rollover_transaction_set_control_number
        self.is_test_interchange = is_test_interchange
        self.sender_internal_identification = sender_internal_identification
        self.sender_internal_sub_identification = sender_internal_sub_identification
        self.receiver_internal_identification = receiver_internal_identification
        self.receiver_internal_sub_identification = receiver_internal_sub_identification
