# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TrafficFlow(Model):
    """Class representing a Traffic Manager HeatMap traffic flow properties.

    :param source_ip: The IP address that this query experience originated
     from.
    :type source_ip: str
    :param latitude: The approximate latitude that these queries originated
     from.
    :type latitude: float
    :param longitude: The approximate longitude that these queries originated
     from.
    :type longitude: float
    :param query_experiences: The query experiences produced in this HeatMap
     calculation.
    :type query_experiences:
     list[~azure.mgmt.trafficmanager.models.QueryExperience]
    """

    _attribute_map = {
        'source_ip': {'key': 'sourceIp', 'type': 'str'},
        'latitude': {'key': 'latitude', 'type': 'float'},
        'longitude': {'key': 'longitude', 'type': 'float'},
        'query_experiences': {'key': 'queryExperiences', 'type': '[QueryExperience]'},
    }

    def __init__(self, *, source_ip: str=None, latitude: float=None, longitude: float=None, query_experiences=None, **kwargs) -> None:
        super(TrafficFlow, self).__init__(**kwargs)
        self.source_ip = source_ip
        self.latitude = latitude
        self.longitude = longitude
        self.query_experiences = query_experiences
