/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SPEECH_SYNTHESIS)

#include "JSTestCallback.h"

#include "DOMStringList.h"
#include "JSDOMConstructor.h"
#include "JSDOMStringList.h"
#include "JSTestNode.h"
#include "ScriptExecutionContext.h"
#include "SerializedScriptValue.h"
#include "TestNode.h"
#include "URL.h"
#include <runtime/FunctionPrototype.h>
#include <runtime/JSLock.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

JSTestCallback::JSTestCallback(JSObject* callback, JSDOMGlobalObject* globalObject)
    : TestCallback()
    , ActiveDOMCallback(globalObject->scriptExecutionContext())
    , m_data(new JSCallbackDataStrong(callback, this))
{
}

JSTestCallback::~JSTestCallback()
{
    ScriptExecutionContext* context = scriptExecutionContext();
    // When the context is destroyed, all tasks with a reference to a callback
    // should be deleted. So if the context is 0, we are on the context thread.
    if (!context || context->isContextThread())
        delete m_data;
    else
        context->postTask(DeleteCallbackDataTask(m_data));
#ifndef NDEBUG
    m_data = nullptr;
#endif
}

typedef JSDOMConstructorNotConstructable<JSTestCallback> JSTestCallbackConstructor;

/* Hash table for constructor */

static const HashTableValue JSTestCallbackConstructorTableValues[] =
{
    { "CONSTANT1", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CONSTANT2", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
};


COMPILE_ASSERT(1 == TestCallback::CONSTANT1, TestCallbackEnumCONSTANT1IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == TestCallback::CONSTANT2, TestCallbackEnumCONSTANT2IsWrongUseDoNotCheckConstants);

template<> JSValue JSTestCallbackConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTestCallbackConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(globalObject);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("TestCallback"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSTestCallbackConstructorTableValues, *this);
}

template<> const ClassInfo JSTestCallbackConstructor::s_info = { "TestCallback", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTestCallbackConstructor) };

JSValue JSTestCallback::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTestCallbackConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}


// Functions

bool JSTestCallback::callbackWithNoParam()
{
    if (!canInvokeCallback())
        return true;

    Ref<JSTestCallback> protect(*this);

    JSLockHolder lock(m_data->globalObject()->vm());

    ExecState* state = m_data->globalObject()->globalExec();
    MarkedArgumentBuffer args;

    NakedPtr<Exception> returnedException;
    m_data->invokeCallback(args, JSCallbackData::CallbackType::Object, Identifier::fromString(state, "callbackWithNoParam"), returnedException);
    if (returnedException)
        reportException(state, returnedException);
    return !returnedException;
}

bool JSTestCallback::callbackWithArrayParam(RefPtr<Float32Array> arrayParam)
{
    if (!canInvokeCallback())
        return true;

    Ref<JSTestCallback> protect(*this);

    JSLockHolder lock(m_data->globalObject()->vm());

    ExecState* state = m_data->globalObject()->globalExec();
    MarkedArgumentBuffer args;
    args.append(toJS(state, m_data->globalObject(), WTF::getPtr(arrayParam)));

    NakedPtr<Exception> returnedException;
    m_data->invokeCallback(args, JSCallbackData::CallbackType::Object, Identifier::fromString(state, "callbackWithArrayParam"), returnedException);
    if (returnedException)
        reportException(state, returnedException);
    return !returnedException;
}

bool JSTestCallback::callbackWithSerializedScriptValueParam(PassRefPtr<SerializedScriptValue> srzParam, const String& strArg)
{
    if (!canInvokeCallback())
        return true;

    Ref<JSTestCallback> protect(*this);

    JSLockHolder lock(m_data->globalObject()->vm());

    ExecState* state = m_data->globalObject()->globalExec();
    MarkedArgumentBuffer args;
    args.append(srzParam ? srzParam->deserialize(state, castedThis->globalObject(), 0) : jsNull());
    args.append(jsStringWithCache(state, strArg));

    NakedPtr<Exception> returnedException;
    m_data->invokeCallback(args, JSCallbackData::CallbackType::Object, Identifier::fromString(state, "callbackWithSerializedScriptValueParam"), returnedException);
    if (returnedException)
        reportException(state, returnedException);
    return !returnedException;
}

bool JSTestCallback::callbackWithStringList(PassRefPtr<DOMStringList> listParam)
{
    if (!canInvokeCallback())
        return true;

    Ref<JSTestCallback> protect(*this);

    JSLockHolder lock(m_data->globalObject()->vm());

    ExecState* state = m_data->globalObject()->globalExec();
    MarkedArgumentBuffer args;
    args.append(toJS(state, m_data->globalObject(), WTF::getPtr(listParam)));

    NakedPtr<Exception> returnedException;
    m_data->invokeCallback(args, JSCallbackData::CallbackType::Object, Identifier::fromString(state, "callbackWithStringList"), returnedException);
    if (returnedException)
        reportException(state, returnedException);
    return !returnedException;
}

bool JSTestCallback::callbackWithBoolean(bool boolParam)
{
    if (!canInvokeCallback())
        return true;

    Ref<JSTestCallback> protect(*this);

    JSLockHolder lock(m_data->globalObject()->vm());

    ExecState* state = m_data->globalObject()->globalExec();
    MarkedArgumentBuffer args;
    args.append(jsBoolean(boolParam));

    NakedPtr<Exception> returnedException;
    m_data->invokeCallback(args, JSCallbackData::CallbackType::Object, Identifier::fromString(state, "callbackWithBoolean"), returnedException);
    if (returnedException)
        reportException(state, returnedException);
    return !returnedException;
}

bool JSTestCallback::callbackRequiresThisToPass(int longParam, TestNode* testNodeParam)
{
    if (!canInvokeCallback())
        return true;

    Ref<JSTestCallback> protect(*this);

    JSLockHolder lock(m_data->globalObject()->vm());

    ExecState* state = m_data->globalObject()->globalExec();
    MarkedArgumentBuffer args;
    args.append(jsNumber(longParam));
    args.append(toJS(state, m_data->globalObject(), WTF::getPtr(testNodeParam)));

    NakedPtr<Exception> returnedException;
    m_data->invokeCallback(args, JSCallbackData::CallbackType::Object, Identifier::fromString(state, "callbackRequiresThisToPass"), returnedException);
    if (returnedException)
        reportException(state, returnedException);
    return !returnedException;
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, TestCallback* impl)
{
    if (!impl || !static_cast<JSTestCallback&>(*impl).callbackData())
        return jsNull();

    return static_cast<JSTestCallback&>(*impl).callbackData()->callback();

}

}

#endif // ENABLE(SPEECH_SYNTHESIS)
