% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_Kars2008.R
\name{calc_Kars2008}
\alias{calc_Kars2008}
\title{Apply the Kars et al. (2008) model (deprecated)}
\usage{
calc_Kars2008(fit.method = "EXP", ...)
}
\arguments{
\item{fit.method}{\link{character} (\emph{with default}):
Fit function of the dose response curve. Can either be \code{EXP} (the default)
or \code{GOK}. Note that \code{EXP} (single saturating exponential) is the original
function the model after Huntley (2006) and Kars et al. (2008) was
designed to use. The use of a general-order kinetics function (\code{GOK})
is an experimental adaption of the model and should only be used
with great care.}

\item{...}{Parameters passed to \link{calc_Huntley2006}.}
}
\value{
An \linkS4class{RLum.Results} object is returned:
}
\description{
A function to calculate the expected sample specific fraction of saturation
following Kars et al. (2008) and Huntley (2006). This function is deprecated
and will eventually be removed. Please use \code{calc_Huntley2006()} instead.
}
\details{
This function applies the approach described in Kars et al. (2008),
developed from the model of Huntley (2006) to calculate the expected sample
specific fraction of saturation of a feldspar and also to calculate fading
corrected age using this model. \eqn{\rho}' (\code{rhop}), the density of recombination
centres, is a crucial parameter of this model and must be determined
separately from a fading measurement. The function \link{analyse_FadingMeasurement}
can be used to calculate the sample specific \eqn{\rho}' value.
}
\note{
\strong{This function is deprecated and will eventually be removed from the package.}
\strong{Please use the function \code{\link[=calc_Huntley2006]{calc_Huntley2006()}} instead}
\strong{(use \code{fit.method = "EXP"} to apply the model after Kars et al., 2008).}
}
\section{Function version}{
 0.4.0 (2018-03-09 09:04:33)
}

\examples{

## Load example data (sample UNIL/NB123, see ?ExampleData.Fading)
data("ExampleData.Fading", envir = environment())

## (1) Set all relevant parameters
# a. fading measurement data (IR50)
fading_data <- ExampleData.Fading$fading.data$IR50

# b. Dose response curve data
data <- ExampleData.Fading$equivalentDose.data$IR50

## (2) Define required function parameters
ddot <- c(7.00, 0.004)
readerDdot <- c(0.134, 0.0067)

# Analyse fading measurement and get an estimate of rho'.
# Note that the RLum.Results object can be directly used for further processing.
# The number of MC runs is reduced for this example
rhop <- analyse_FadingMeasurement(fading_data, plot = TRUE, verbose = FALSE, n.MC = 10)

## (3) Apply the Kars et al. (2008) model to the data
kars <- suppressWarnings(
  calc_Kars2008(data = data,
                rhop = rhop,
                ddot = ddot,
                readerDdot = readerDdot,
                n.MC = 25)
)

} 

\section{How to cite}{
King, G.E., Burow, C. (2018). calc_Kars2008(): Apply the Kars et al. (2008) model (deprecated). Function version 0.4.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2018). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.8.6. https://CRAN.R-project.org/package=Luminescence
}

\references{
Kars, R.H., Wallinga, J., Cohen, K.M., 2008. A new approach towards anomalous fading correction for feldspar
IRSL dating-tests on samples in field saturation. Radiation Measurements 43, 786-790. doi:10.1016/j.radmeas.2008.01.021

Huntley, D.J., 2006. An explanation of the power-law decay of luminescence.
Journal of Physics: Condensed Matter 18, 1359-1365. doi:10.1088/0953-8984/18/4/020

King, G.E., Herman, F., Lambert, R., Valla, P.G., Guralnik, B., 2016.
Multi-OSL-thermochronometry of feldspar. Quaternary Geochronology 33, 76-87. doi:10.1016/j.quageo.2016.01.004

\strong{Further reading}

Morthekai, P., Jain, M., Cunha, P.P., Azevedo, J.M., Singhvi, A.K., 2011. An attempt to correct
for the fading in million year old basaltic rocks. Geochronometria 38(3), 223-230.
}
\author{
Georgina E. King, University of Bern (Switzerland) \cr
Christoph Burow, University of Cologne (Germany)
\cr R Luminescence Package Team}
\keyword{datagen}
