#ifndef _RHEOLEF_SOLVER_CHOLMOD_H
#define _RHEOLEF_SOLVER_CHOLMOD_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// solver implementation: interface
//

#include "rheolef/config.h"

#ifdef _RHEOLEF_HAVE_CHOLMOD

#include "rheolef/solver.h"
extern "C" {
#include <cholmod.h>
#include <cholmod_internal.h>
}
namespace rheolef {

// =======================================================================
// rep
// =======================================================================
template<class T, class M>
class solver_cholmod_rep : public solver_abstract_rep<T,M> {
public:
// typedef:

  typedef typename csr<T,M>::size_type size_type;

// allocator:

  solver_cholmod_rep();
  explicit solver_cholmod_rep (const csr<T,M>& a, const solver_option& opt = solver_option());
  void update_values (const csr<T,M>& a);
  ~solver_cholmod_rep ();

// accessors:

  vec<T,M> trans_solve (const vec<T,M>& rhs) const;
  vec<T,M> solve       (const vec<T,M>& rhs) const;

protected:
  void _init();
// data:
  mutable cholmod_common  common;
  mutable cholmod_factor* l_chol;
  mutable cholmod_dense*  y_work;
  mutable cholmod_dense*  e_work;
};

} // namespace rheolef
#endif // _RHEOLEF_HAVE_CHOLMOD
#endif // _RHEOLEF_SOLVER_CHOLMOD_H
