/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [reg_exp.h]           Regular Expression Evaluation                      */
/*                                                                          */
/* Copyright (c) 1999 by D\olle, Manns                                      */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef reg_exp_INCL
#define reg_exp_INCL


#include "standard.h"


#ifdef __cplusplus
extern "C" {
#endif


/* 
  <p>[reg_exp] implements a regular expression evaluator based on the
  following regular expression syntax.

  <p><b>Literal</b>
  <ul>
  <li>printable extended ascii character without quotes
      ( quotes = { "'`\ } )
  <li>\ quote
  <li>\r, \n, \t
  <li>\ hexdigit hexdigit
      ( single byte character )
  <li>\ (x|X) hexdigit hexdigit hexdigit hexdigit hexdigit hexdigit hexdigit hexdigit
      ( ucs4 character )
  </ul>
  <p><b>Construction</b>

  <table noborder cellspacing=10>
  <tr><td><b>Character set</b></td><td>' Literal ... '</td></tr>
  <tr><td><b>String</b></td><td>" Literal ... "</td></tr>
  <tr><td><b>Any character</b></td><td>.</td></tr>
  <tr><td><b>Character range</b></td>
      <td>Expression .. Expression <br>( single character expressions )</td></tr>
  <tr><td><b>Subexpression</b></td><td>( Expression )</td></tr>
  <tr><td><b>Option</b></td><td>[ Expression ]</td></tr>
  <tr><td>&nbsp;</td><td>Expression ?</td></tr>
  <tr><td><b>Iteration ( 0.. )</b></td><td>{ Expression }</td></tr>
  <tr><td>&nbsp;</td><td>Expression *</td></tr>
  <tr><td><b>Iteration ( 1.. )</b></td><td>Expression +</td></tr>
  <tr><td><b>Iteration ( n )</b></td><td>Expression Number</td></tr>
  <tr><td><b>Iteration ( n..m )</b></td><td>Expression Number, Number</td></tr>
  <tr><td><b>Union</b></td><td>Expression | Expression</td></tr>
  <tr><td><b>Difference</b></td><td>Expression - Expression</td></tr>
  <tr><td><b>Concatenation</b></td><td>Expression Expression</td></tr>
  </table>
*/

/* -------------------- Types ------------------------------------------- */

AbstractType(Reg_T) // Abstract regular expression evaluation type
;

/* -------------------- Creating & Disposing ---------------------------- */

void REG_drop(Reg_T pReg);   /* removes regular expression evaluator 'pReg' */

Reg_T REG_create
      (
        c_string szRegExp,  long   lLen,
        c_string szCharSet, c_bool bIgnCase
      )
#define REG_CREATE(exp)  REG_create((exp),-1,(c_string)NULL,C_False)
#define IREG_CREATE(exp) REG_create((exp),-1,(c_string)NULL,C_True)
/* creates a regular expression evaluator from string 'szRegExp'
   'lLen'     : -1 or string size in bytes, incl. terminating bytes
   'szCharSet': NULL,"" or character set name
                ( UCS4, UTF-8, MS:CodePage / GNU:iconv-based )
   'szCharSet' = NULL,"" --> single byte string
   'lLen' = -1 --> null-terminated single byte or utf8 string
   RC: evaluator or NULL
*/
;

c_bool REG_recreate
       (
         Reg_T    pReg,      c_string szRegExp, long lLen,
         c_string szCharSet, c_bool   bIgnCase
       )
#define REG_RECREATE(reg,exp)  REG_recreate((reg),(exp),-1,(c_string)NULL,C_False)
#define IREG_RECREATE(reg,exp) REG_recreate((reg),(exp),-1,(c_string)NULL,C_True)
/* updates regular expression evaluator 'pReg'
   from string 'szRegExp'
   ( 'lLen', 'szCharSet' --> see function 'REG_create' )
   RC: true <--> OK
*/
;


/* ------------------------- Evaluation --------------------------------- */

c_string REG_match
         (
           Reg_T    pReg,
           c_string szTxt,  long lTxtLen, c_string szCharSet,
           long*    lPatLen
         )
#define REG_MATCH(reg,txt,len) REG_match((reg),(txt),-1,(c_string)NULL,(len))
/* applies regular expression evaluator 'pReg' to string 'szTxt'
   ( 'lTxtLen', 'szCharSet' --> see function 'REG_create' )
   RC: start postion of first matched value in 'szTxt' or NULL
   'lPatLen' != NULL --> length of first matched value in bytes
*/
;



#ifdef __cplusplus
}
#endif

#endif
