/* http.c generated by valac 0.42.2, the Vala compiler
 * generated from http.vala, do not modify */

/*
 *    Copyright (C) 1999, 2000,
 *    Dirk-Jan C. Binnema <djcb@dds.nl>,
 *    Arjan Scherpenisse <acscherp@wins.uva.nl>
 *    Copyright (C) 2016 Colin Watson <cjwatson@debian.org>
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */
/* HTTP fetches. */


#include <glib.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TG_TYPE_GUI (tg_gui_get_type ())
#define TG_GUI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_GUI, TgGui))
#define TG_GUI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_GUI, TgGuiClass))
#define TG_IS_GUI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_GUI))
#define TG_IS_GUI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_GUI))
#define TG_GUI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_GUI, TgGuiClass))

typedef struct _TgGui TgGui;
typedef struct _TgGuiClass TgGuiClass;

#define TG_TYPE_CHANNEL (tg_channel_get_type ())
#define TG_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_CHANNEL, TgChannel))
#define TG_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_CHANNEL, TgChannelClass))
#define TG_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_CHANNEL))
#define TG_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_CHANNEL))
#define TG_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_CHANNEL, TgChannelClass))

typedef struct _TgChannel TgChannel;
typedef struct _TgChannelClass TgChannelClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	TG_HTTP_ERROR_PIXBUF,
	TG_HTTP_ERROR_VFS,
	TG_HTTP_ERROR_HTTPQUERY
} TgHttpError;
#define TG_HTTP_ERROR tg_http_error_quark ()


GQuark tg_http_error_quark (void);
GType tg_gui_get_type (void) G_GNUC_CONST;
GdkPixbuf* tg_http_get_image (TgGui* gui,
                              GError** error);
GType tg_channel_get_type (void) G_GNUC_CONST;
TgChannel* tg_gui_get_current_channel (TgGui* self);
gint tg_gui_get_subpage_number (TgGui* self);
const gchar* tg_channel_get_subpage_url (TgChannel* self);
gint tg_gui_get_page_number (TgGui* self);
const gchar* tg_channel_get_page_url (TgChannel* self);


GQuark
tg_http_error_quark (void)
{
	return g_quark_from_static_string ("tg_http_error-quark");
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


GdkPixbuf*
tg_http_get_image (TgGui* gui,
                   GError** error)
{
	GdkPixbuf* result = NULL;
	TgChannel* channel = NULL;
	TgChannel* _tmp0_;
	TgChannel* _tmp1_;
	TgChannel* _tmp2_;
	gchar* url = NULL;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	gboolean _tmp32_ = FALSE;
	const gchar* _tmp33_;
	GFile* http_file = NULL;
	const gchar* _tmp36_;
	GFile* _tmp37_;
	GFileInputStream* http_input = NULL;
	GdkPixbufLoader* loader = NULL;
	GdkPixbufLoader* _tmp47_;
	guint8* buf = NULL;
	guint8* _tmp48_;
	gint buf_length1;
	gint _buf_size_;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbufLoader* _tmp76_;
	GdkPixbuf* _tmp77_;
	GdkPixbuf* _tmp78_;
	GdkPixbuf* _tmp79_;
	GdkPixbuf* _tmp82_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (gui != NULL, NULL);
	_tmp0_ = tg_gui_get_current_channel (gui);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	channel = _tmp2_;
	url = NULL;
	_tmp3_ = tg_gui_get_subpage_number (gui);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		gchar* subpage_url = NULL;
		TgChannel* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		_tmp5_ = channel;
		_tmp6_ = tg_channel_get_subpage_url (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup (_tmp7_);
		subpage_url = _tmp8_;
		_tmp10_ = subpage_url;
		if (_tmp10_ != NULL) {
			const gchar* _tmp11_;
			_tmp11_ = subpage_url;
			_tmp9_ = g_strcmp0 (_tmp11_, "") != 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			const gchar* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gchar* _tmp17_;
			_tmp12_ = subpage_url;
			_tmp13_ = tg_gui_get_page_number (gui);
			_tmp14_ = _tmp13_;
			_tmp15_ = tg_gui_get_subpage_number (gui);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strdup_printf (_tmp12_, _tmp14_, _tmp16_);
			_g_free0 (url);
			url = _tmp17_;
		}
		_g_free0 (subpage_url);
	}
	_tmp19_ = url;
	if (_tmp19_ == NULL) {
		_tmp18_ = TRUE;
	} else {
		const gchar* _tmp20_;
		_tmp20_ = url;
		_tmp18_ = g_strcmp0 (_tmp20_, "") == 0;
	}
	if (_tmp18_) {
		gchar* page_url = NULL;
		TgChannel* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gboolean _tmp25_ = FALSE;
		const gchar* _tmp26_;
		_tmp21_ = channel;
		_tmp22_ = tg_channel_get_page_url (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strdup (_tmp23_);
		page_url = _tmp24_;
		_tmp26_ = page_url;
		if (_tmp26_ != NULL) {
			const gchar* _tmp27_;
			_tmp27_ = page_url;
			_tmp25_ = g_strcmp0 (_tmp27_, "") != 0;
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			const gchar* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gchar* _tmp31_;
			_tmp28_ = page_url;
			_tmp29_ = tg_gui_get_page_number (gui);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strdup_printf (_tmp28_, _tmp30_);
			_g_free0 (url);
			url = _tmp31_;
		}
		_g_free0 (page_url);
	}
	_tmp33_ = url;
	if (_tmp33_ == NULL) {
		_tmp32_ = TRUE;
	} else {
		const gchar* _tmp34_;
		_tmp34_ = url;
		_tmp32_ = g_strcmp0 (_tmp34_, "") == 0;
	}
	if (_tmp32_) {
		GError* _tmp35_;
		_tmp35_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_HTTPQUERY, "");
		_inner_error_ = _tmp35_;
		if (_inner_error_->domain == TG_HTTP_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (url);
			_g_object_unref0 (channel);
			return NULL;
		} else {
			_g_free0 (url);
			_g_object_unref0 (channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp36_ = url;
	_tmp37_ = g_file_new_for_uri (_tmp36_);
	http_file = _tmp37_;
	{
		GFileInputStream* _tmp38_ = NULL;
		GFileInputStream* _tmp39_;
		GFileInputStream* _tmp40_;
		_tmp39_ = g_file_read (http_file, NULL, &_inner_error_);
		_tmp38_ = _tmp39_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		_tmp40_ = _tmp38_;
		_tmp38_ = NULL;
		_g_object_unref0 (http_input);
		http_input = _tmp40_;
		_g_object_unref0 (_tmp38_);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp41_;
		GError* _tmp42_;
		const gchar* _tmp43_;
		GError* _tmp44_;
		const gchar* _tmp45_;
		GError* _tmp46_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp41_ = url;
		_tmp42_ = e;
		_tmp43_ = _tmp42_->message;
		g_warning ("http.vala:62: Unable to fetch '%s': %s", _tmp41_, _tmp43_);
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		_tmp46_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_VFS, _tmp45_);
		_inner_error_ = _tmp46_;
		_g_error_free0 (e);
		goto __finally6;
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == TG_HTTP_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			return NULL;
		} else {
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp47_ = gdk_pixbuf_loader_new ();
	loader = _tmp47_;
	_tmp48_ = g_new0 (guint8, 4096);
	buf = _tmp48_;
	buf_length1 = 4096;
	_buf_size_ = buf_length1;
	{
		gboolean _tmp49_ = FALSE;
		_tmp49_ = TRUE;
		while (TRUE) {
			gssize bytes_read = 0L;
			if (!_tmp49_) {
			}
			_tmp49_ = FALSE;
			{
				gssize _tmp50_ = 0L;
				GFileInputStream* _tmp51_;
				guint8* _tmp52_;
				gint _tmp52__length1;
				gssize _tmp53_;
				_tmp51_ = http_input;
				_tmp52_ = buf;
				_tmp52__length1 = buf_length1;
				_tmp50_ = g_input_stream_read ((GInputStream*) _tmp51_, _tmp52_, (gsize) _tmp52__length1, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == G_IO_ERROR) {
						goto __catch7_g_io_error;
					}
					buf = (g_free (buf), NULL);
					_g_object_unref0 (loader);
					_g_object_unref0 (http_input);
					_g_object_unref0 (http_file);
					_g_free0 (url);
					_g_object_unref0 (channel);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				bytes_read = _tmp50_;
				_tmp53_ = bytes_read;
				if (_tmp53_ == ((gssize) 0)) {
					break;
				}
			}
			goto __finally7;
			__catch7_g_io_error:
			{
				GError* e = NULL;
				const gchar* _tmp54_;
				GError* _tmp55_;
				const gchar* _tmp56_;
				GError* _tmp57_;
				const gchar* _tmp58_;
				GError* _tmp59_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp54_ = url;
				_tmp55_ = e;
				_tmp56_ = _tmp55_->message;
				g_warning ("http.vala:75: Unable to read data from '%s': %s", _tmp54_, _tmp56_);
				_tmp57_ = e;
				_tmp58_ = _tmp57_->message;
				_tmp59_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_VFS, _tmp58_);
				_inner_error_ = _tmp59_;
				_g_error_free0 (e);
				goto __finally7;
			}
			__finally7:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == TG_HTTP_ERROR) {
					g_propagate_error (error, _inner_error_);
					buf = (g_free (buf), NULL);
					_g_object_unref0 (loader);
					_g_object_unref0 (http_input);
					_g_object_unref0 (http_file);
					_g_free0 (url);
					_g_object_unref0 (channel);
					return NULL;
				} else {
					buf = (g_free (buf), NULL);
					_g_object_unref0 (loader);
					_g_object_unref0 (http_input);
					_g_object_unref0 (http_file);
					_g_free0 (url);
					_g_object_unref0 (channel);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			{
				GdkPixbufLoader* _tmp60_;
				guint8* _tmp61_;
				gint _tmp61__length1;
				gssize _tmp62_;
				_tmp60_ = loader;
				_tmp61_ = buf;
				_tmp61__length1 = buf_length1;
				_tmp62_ = bytes_read;
				gdk_pixbuf_loader_write (_tmp60_, _tmp61_ + 0, (gsize) (((gint) _tmp62_) - 0), &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch8_g_error;
				}
			}
			goto __finally8;
			__catch8_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp63_;
				GError* _tmp64_;
				const gchar* _tmp65_;
				GError* _tmp66_;
				const gchar* _tmp67_;
				GError* _tmp68_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp63_ = url;
				_tmp64_ = e;
				_tmp65_ = _tmp64_->message;
				g_warning ("http.vala:82: Unable to parse image from '%s': %s", _tmp63_, _tmp65_);
				_tmp66_ = e;
				_tmp67_ = _tmp66_->message;
				_tmp68_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_PIXBUF, _tmp67_);
				_inner_error_ = _tmp68_;
				_g_error_free0 (e);
				goto __finally8;
			}
			__finally8:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == TG_HTTP_ERROR) {
					g_propagate_error (error, _inner_error_);
					buf = (g_free (buf), NULL);
					_g_object_unref0 (loader);
					_g_object_unref0 (http_input);
					_g_object_unref0 (http_file);
					_g_free0 (url);
					_g_object_unref0 (channel);
					return NULL;
				} else {
					buf = (g_free (buf), NULL);
					_g_object_unref0 (loader);
					_g_object_unref0 (http_input);
					_g_object_unref0 (http_file);
					_g_free0 (url);
					_g_object_unref0 (channel);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	{
		GdkPixbufLoader* _tmp69_;
		_tmp69_ = loader;
		gdk_pixbuf_loader_close (_tmp69_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp70_;
		GError* _tmp71_;
		const gchar* _tmp72_;
		GError* _tmp73_;
		const gchar* _tmp74_;
		GError* _tmp75_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp70_ = url;
		_tmp71_ = e;
		_tmp72_ = _tmp71_->message;
		g_warning ("http.vala:90: Unable to parse image from '%s': %s", _tmp70_, _tmp72_);
		_tmp73_ = e;
		_tmp74_ = _tmp73_->message;
		_tmp75_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_PIXBUF, _tmp74_);
		_inner_error_ = _tmp75_;
		_g_error_free0 (e);
		goto __finally9;
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == TG_HTTP_ERROR) {
			g_propagate_error (error, _inner_error_);
			buf = (g_free (buf), NULL);
			_g_object_unref0 (loader);
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			return NULL;
		} else {
			buf = (g_free (buf), NULL);
			_g_object_unref0 (loader);
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp76_ = loader;
	_tmp77_ = gdk_pixbuf_loader_get_pixbuf (_tmp76_);
	_tmp78_ = _g_object_ref0 (_tmp77_);
	pixbuf = _tmp78_;
	_tmp79_ = pixbuf;
	if (_tmp79_ == NULL) {
		const gchar* _tmp80_;
		GError* _tmp81_;
		_tmp80_ = url;
		g_warning ("http.vala:97: Pixbuf loader did not create a pixbuf from '%s'", _tmp80_);
		_tmp81_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_PIXBUF, "");
		_inner_error_ = _tmp81_;
		if (_inner_error_->domain == TG_HTTP_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (pixbuf);
			buf = (g_free (buf), NULL);
			_g_object_unref0 (loader);
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			return NULL;
		} else {
			_g_object_unref0 (pixbuf);
			buf = (g_free (buf), NULL);
			_g_object_unref0 (loader);
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp82_ = pixbuf;
	pixbuf = NULL;
	result = _tmp82_;
	_g_object_unref0 (pixbuf);
	buf = (g_free (buf), NULL);
	_g_object_unref0 (loader);
	_g_object_unref0 (http_input);
	_g_object_unref0 (http_file);
	_g_free0 (url);
	_g_object_unref0 (channel);
	return result;
}



