// Tralics, a LaTeX to XML translator
// Copyright INRIA/apics/marelle (Jose Grimm) 2002, 2004, 2007-2011

// This software is governed by the CeCILL license under French law and
// abiding by the rules of distribution of free software.  You can  use, 
// modify and/ or redistribute the software under the terms of the CeCILL
// license as circulated by CEA, CNRS and INRIA at the following URL
// "http://www.cecill.info". 
// (See the file COPYING in the main directory for details)



#include "tralics.h"
const char* txtoken2_rcsid=
  "$Id: txtoken2.C,v 2.7 2011/06/28 08:15:25 grimm Exp $";


void Hashtab::boot_etex()
{
  primitive("TeXXeTstate",assign_int_cmd,TeXXetstate_code);
  primitive("tracingassigns",assign_int_cmd,tracingassigns_code);
  primitive("tracinggroups",assign_int_cmd,tracinggroups_code);
  primitive("tracingifs",assign_int_cmd,tracingifs_code);
  primitive("tracingscantokens",assign_int_cmd,tracingscantokens_code);
  primitive("tracingnesting",assign_int_cmd,tracingnesting_code);
  primitive("predisplaydirection",assign_int_cmd,predisplaydirection_code);
  primitive("lastlinefit",assign_int_cmd, lastlinefit_code);
  primitive("savingdiscards",assign_int_cmd, savingdiscards_code);
  primitive("savinghyphcodes",assign_int_cmd, savinghyphcodes_code);
  primitive("currentgrouplevel",last_item_cmd,currentgrouplevel_code);
  primitive("currentgrouptype",last_item_cmd,currentgrouptype_code);
  primitive("currentiflevel",last_item_cmd,currentiflevel_code);
  primitive("currentiftype",last_item_cmd,currentiftype_code);
  primitive("currentifbranch",last_item_cmd,currentifbranch_code);
  primitive("eTeXversion",last_item_cmd,etexversion_code);
  primitive("lastnodetype",last_item_cmd,lastnodetype_code);
  primitive("fontcharwd",last_item_cmd,fontcharwd_code);
  primitive("fontcharht",last_item_cmd,fontcharht_code);
  primitive("fontchardp",last_item_cmd,fontchardp_code);
  primitive("fontcharic",last_item_cmd,fontcharic_code);
  primitive("parshapelength",last_item_cmd,parshapelength_code);
  primitive("parshapeindent",last_item_cmd,parshapeindent_code);
  primitive("parshapedimen",last_item_cmd,parshapedimen_code);
  primitive("numexpr",last_item_cmd,numexpr_code);
  primitive("dimexpr",last_item_cmd,dimexpr_code);
  primitive("glueexpr",last_item_cmd,glueexpr_code);
  primitive("muexpr",last_item_cmd,muexpr_code);
  primitive("gluestretchorder",last_item_cmd,gluestretchorder_code);
  primitive("glueshrinkorder",last_item_cmd,glueshrinkorder_code);
  primitive("gluestretch",last_item_cmd,gluestretch_code);
  primitive("glueshrink",last_item_cmd,glueshrink_code);
  primitive("gluetomu",last_item_cmd,gluetomu_code);
  primitive("mutoglue",last_item_cmd,mutoglue_code);
  primitive("eTeXrevision",convert_cmd,etexrevision_code);
  primitive("ifcsname",if_test_cmd,if_csname_code);
  primitive("ifdefined",if_test_cmd,if_defined_code);
  primitive("iffontchar",if_test_cmd,if_fontchar_code);
  primitive("unless",expandafter_cmd,one_code);
  primitive("unexpanded",the_cmd,unexpanded_code);
  primitive("detokenize",the_cmd,detokenize_code);
  primitive("scantokens",input_cmd,scantokens_code);
  primitive("showgroups",xray_cmd,showgroups_code);
  primitive("showtokens",xray_cmd,showtokens_code);
  primitive("showifs",xray_cmd,showifs_code);
  primitive("interactionmode",set_page_int_cmd,interactionmode_code);
  primitive("pagediscards",ignore_cmd,pagediscards_code);
  primitive("splitdiscards",ignore_cmd,splitdiscards_code);
  primitive("endL",ignore_cmd,endL_code);
  primitive("endR",ignore_cmd,endR_code);
  primitive("beginL",ignore_cmd,beginL_code);
  primitive("beginR",ignore_cmd,beginR_code);
  primitive("readline",read_to_cs_cmd, one_code);
  primitive("topmarks",top_bot_mark_cmd,topmarks_code);
  primitive("firstmarks",top_bot_mark_cmd,firstmarks_code);
  primitive("botmarks",top_bot_mark_cmd,botmarks_code);
  primitive("splitfirstmarks",top_bot_mark_cmd,splitfirstmarks_code);
  primitive("splitbotmarks",top_bot_mark_cmd,splitbotmarks_code);
  primitive("everyeof",assign_toks_cmd,everyeof_code);
  primitive("protected",prefix_cmd,protected_code);
  primitive("middle",etex_cmd,subtypes(18));
  primitive("marks",specimp_cmd,marks_code);
  primitive("interlinepenalties",set_shape_cmd,interlinepenalties_code);
  primitive("clubpenalties",set_shape_cmd,clubpenalties_code);
  primitive("widowpenalties",set_shape_cmd,widowpenalties_code);
  primitive("displaywidowpenalties",set_shape_cmd,displaywidowpenalties_code);
}

void Hashtab::boot_keyval()
{
  static bool booted = false;
  if(booted) return;
  booted = true;
  primitive("define@key",xkeyval_cmd,xdefinekey_code);
  primitive("define@cmdkey",xkeyval_cmd,define_cmdkey_code);
  primitive("define@cmdkeys",xkeyval_cmd,define_cmdkeys_code);
  primitive("define@boolkey",xkeyval_cmd,define_boolkey_code);
  primitive("define@boolkeys",xkeyval_cmd,define_boolkeys_code);
  primitive("define@choicekey",xkeyval_cmd,define_choicekey_code);
  xkv_cc_token= primitive("XKV@cc",xkeyval_cmd,define_cc_code);
  primitive("key@ifundefined",xkeyval_cmd,key_ifundefined_code);
  primitive("disable@keys",xkeyval_cmd,disable_keys_code);
  primitive("presetkeys",xkeyval_cmd,preset_keys_code);  
  primitive("gpresetkeys",xkeyval_cmd,gpreset_keys_code);  
  primitive("unpresetkeys",xkeyval_cmd,unpreset_keys_code);  
  primitive("gunpresetkeys",xkeyval_cmd,gunpreset_keys_code);  
  primitive("delpresetkeys",xkeyval_cmd,delpreset_keys_code);  
  primitive("gdelpresetkeys",xkeyval_cmd,gdelpreset_keys_code);  
  primitive("savekeys",xkeyval_cmd,save_keys_code);  
  primitive("gsavekeys",xkeyval_cmd,gsave_keys_code);  
  primitive("unsavekeys",xkeyval_cmd,unsave_keys_code);  
  primitive("gunsavekeys",xkeyval_cmd,gunsave_keys_code);  
  primitive("delsavekeys",xkeyval_cmd,delsave_keys_code);  
  primitive("gdelsavekeys",xkeyval_cmd,gdelsave_keys_code);  
  primitive("setkeys",xkeyval_cmd,setkeys_code);  
  primitive("setrmkeys",xkeyval_cmd,setrmkeys_code);  
  primitive("DeclareOptionX",xkeyval_cmd,declare_optionsX_code);
  primitive("ExecuteOptionsX",xkeyval_cmd,execute_optionsX_code);
  primitive("ProcessOptionsX",xkeyval_cmd,process_optionsX_code);
  usevalue_token = locate("usevalue");
  savevalue_token = locate("savevalue");
  gsavevalue_token  = locate("gsavevalue");
  xkv_resa_token = locate("XKV@resa");
  xkv_warn_token = locate("XKV@warn");  
  xkv_prefix_token = locate("XKV@prefix");
  xkv_fams_token = locate("XKV@fams");
  xkv_na_token = locate("XKV@na");
  xkv_rm_token = locate("XKV@rm"); 
  xkv_tfam_token = locate("XKV@tfam");
  xkv_header_token = locate("XKV@header"); 
  xkv_tkey_token = locate("XKV@tkey");
}



// This is the BIG function.  
// It enters all primitives in the hash table.
Hashtab::Hashtab()
{
  hash_used = hash_size;
  hash_usage = 0;
  for(int k = 0; k<eqtb_size;k++)
    eqtb[k].reset();
  frozen_undef_token = nohash_primitive("undefined",CmdChr(undef_cmd,zero_code));
  temp_token = nohash_primitive("temp",CmdChr(undef_cmd,zero_code));
  endv_token = nohash_primitive("endv", CmdChr(endv_cmd,zero_code));
  frozen_protection = nohash_primitive("frozen_cs",CmdChr(undef_cmd,zero_code));
  frozen_endcsname = nohash_primitive("endcsname",CmdChr(endcsname_cmd,zero_code));

  iterate_token =  nohash_primitive("iterate",CmdChr(undef_cmd,zero_code));
  frozen_relax_token = nohash_primitive("relax",CmdChr(relax_cmd,relax_code));
  Token* T = my_mathfont_table;
  T[0] = primitive("mml@font@normal",mathfont_cmd,math_f_normal); 
  T[1] = primitive("mml@font@upright",mathfont_cmd,math_f_upright); 
  T[2] = primitive("mml@font@bold",mathfont_cmd,math_f_bold); 
  T[3] = primitive("mml@font@italic",mathfont_cmd,math_f_italic); 
  T[4] = primitive("mml@font@bolditalic",mathfont_cmd,math_f_bold_italic); 
  T[5] = primitive("mml@font@script",mathfont_cmd,math_f_script); 
  T[6] = primitive("mml@font@boldscript",mathfont_cmd,math_f_bold_script); 
  T[7] = primitive("mml@font@fraktur",mathfont_cmd,math_f_fraktur); 
  T[8] = primitive("mml@font@doublestruck",mathfont_cmd,math_f_doublestruck); 
  T[9] = primitive("mml@font@boldfraktur",mathfont_cmd,math_f_bold_fraktur); 
  T[10] = primitive("mml@font@sansserif",mathfont_cmd,math_f_sansserif); 
  T[11] = primitive("mml@font@boldsansserif",mathfont_cmd,math_f_bold_sansserif); 
  T[12] = primitive("mml@font@sansserifitalic",mathfont_cmd,math_f_sansserif_italic); 
  T[13] = primitive("mml@font@sansserifbolditalic",mathfont_cmd,math_f_sansserif_bold_italic); 
  T[14] = primitive("mml@font@monospace",mathfont_cmd,math_f_monospace); 


  // now all tokens, in the order of their command codes.
  primitive("part", section_cmd,part_code);
  primitive("chapter",section_cmd,chapter_code);
  primitive("endsec",section_cmd,endsec_code);
  primitive("section",section_cmd,section_code);
  primitive("subsection",section_cmd,subsection_code);
  primitive("subsubsection",section_cmd,subsubsection_code);
  primitive("paragraph",section_cmd,paragraph_code);
  primitive("subparagraph",section_cmd,subparagraph_code);
  primitive("toplevelsection",section_cmd,toplevel_sec_code);
  label_token = primitive("label",label_cmd);
  primitive("anchor",label_cmd,one_code);
  ref_token = primitive("ref",ref_cmd);
  primitive("pageref",ref_cmd, one_code);
  primitive("XMLref",eqref_cmd);
  par_token = primitive("par",par_cmd);
  noindent_token = primitive("noindent",start_par_cmd,zero_code);
  primitive("indent",start_par_cmd,one_code);
  endcsname_token= primitive("endcsname",endcsname_cmd);
  primitive("multicolumn",multicolumn_cmd);
  frozen_dont_expand =
    nohash_primitive("notexpanded:",CmdChr(dont_expand_cmd,zero_code));
  atbd_token=  primitive("AtBeginDocument",atdocument_cmd,zero_code);
  primitive("AtEndDocument",atdocument_cmd,one_code);
  primitive("fvset",fvset_cmd);
  calc_token=  primitive("calc ",calc_cmd); // command name ends with space
  primitive("bibliography",biblio_cmd);
  primitive("aparaitre",aparaitre_cmd);
  primitive("toappear",aparaitre_cmd);
  primitive("citation",citation_cmd);
  primitive("endcitation",end_citation_cmd);
  primitive("thebibliography",thebibliography_cmd);
  primitive("endthebibliography",end_thebibliography_cmd);
  primitive("bpers",bpers_cmd);
  primitive("cititem",cititem_cmd);
  primitive("bibitem",bibitem_cmd);
  primitive("bibitem@empty",bibitem_cmd,one_code);
  primitive("cite", cite_cmd,cite_code);
  primitive("XMLsolvecite", solvecite_cmd);
  primitive("footcite", cite_cmd,footcite_code);
  primitive("refercite", cite_cmd,refercite_code);
  primitive("yearcite", cite_cmd,yearcite_code);
  primitive("nocite", cite_cmd,nocite_code);
  primitive("natcite", cite_cmd,natcite_code);
  citeone_token = primitive("cite@one", cite_one_cmd);
  citesimple_token = primitive("cite@simple", cite_one_cmd,one_code);
  end_natcite_token = nohash_primitive("endnatcite", CmdChr(cite_cmd,natcite_e_code));
  primitive("bauthors",bib_cmd,zero_code);
  primitive("beditors",bib_cmd,one_code);
  backslash_token=  primitive("\\", backslash_cmd);
  primitive("newline", backslash_cmd,one_code); // idem
  primitive("hline",hline_cmd);
  primitive("cline",hline_cmd,one_code);
  primitive("smallskip",skip_cmd,smallskip_code);
  primitive("medskip",skip_cmd,medskip_code);
  primitive("bigskip",skip_cmd,bigskip_code);
  primitive("hfil",hfill_cmd,hfil_code);
  primitive("hfill",hfill_cmd,hfill_code);
  primitive("vfil",vfill_cmd,vfil_code);
  primitive("vfill",vfill_cmd,vfill_code);
  primitive("hfilneg",hfill_cmd,hfilneg_code);
  primitive("vss",vfill_cmd,vss_code);
  primitive("vfilneg",vfill_cmd,vfilneg_code);
  primitive("hss",hfill_cmd,hss_code);
  primitive("rm",oldfont_cmd,rm_family_code);
  primitive("sf",oldfont_cmd,sf_family_code);
  tt_token = primitive("tt",oldfont_cmd,tt_family_code);
  primitive("bf",oldfont_cmd,bf_series_code);
  primitive("it",oldfont_cmd,it_shape_code);
  primitive("sc",oldfont_cmd,sc_shape_code);
  primitive("sl",oldfont_cmd,sl_shape_code);

  primitive("textrm",argfont_cmd,rm_family_code);
  primitive("textsf",argfont_cmd,sf_family_code);
  primitive("texttt",argfont_cmd,tt_family_code);
  primitive("textmd",argfont_cmd,md_series_code);
  textbf_token =   primitive("textbf",argfont_cmd,bf_series_code);
  primitive("textup",argfont_cmd,up_shape_code);
  primitive("textit",argfont_cmd,it_shape_code);
  primitive("textsl",argfont_cmd,sl_shape_code);
  primitive("textsc",argfont_cmd,sc_shape_code);
  primitive("emph",argfont_cmd,em_code);
  primitive("textnormal",argfont_cmd,normalfont_code);

  primitive("rmfamily",noargfont_cmd,rm_family_code);
  primitive("sffamily",noargfont_cmd,sf_family_code);
  primitive("ttfamily",noargfont_cmd,tt_family_code);
  primitive("mdseries",noargfont_cmd,md_series_code);
  primitive("bfseries",noargfont_cmd,bf_series_code);
  primitive("upshape",noargfont_cmd,up_shape_code);
  primitive("itshape",noargfont_cmd,it_shape_code);
  primitive("slshape",noargfont_cmd,sl_shape_code);
  primitive("scshape",noargfont_cmd,sc_shape_code);
  primitive("em",noargfont_cmd,em_code);
  primitive("normalfont",noargfont_cmd,normalfont_code);
  primitive("Tiny",fontsize_cmd, Tiny_code);
  primitive("tiny",fontsize_cmd, tiny_code);
  primitive("SMALL",fontsize_cmd,scriptsize_code);
  primitive("scriptsize",fontsize_cmd,scriptsize_code);
  primitive("footnotesize",fontsize_cmd,footnotesize_code);
  primitive("Small",fontsize_cmd,footnotesize_code);
  small_token =  primitive("small",fontsize_cmd,small_code);
  primitive("normalsize",fontsize_cmd,normalsize_code);
  primitive("large",fontsize_cmd,large_code);
  primitive("Large",fontsize_cmd,Large_code);
  primitive("LARGE",fontsize_cmd,LARGE_code);
  primitive("huge",fontsize_cmd,huge_code);
  primitive("Huge",fontsize_cmd,Huge_code);
  primitive("item", item_cmd);
  primitive("@@item", item_cmd);
  primitive("@item", item_cmd,one_code);
  primitive("tralics@find@config", get_config_cmd);
  primitive("tralics@get@config", get_config_cmd,one_code);
  primitive("documentclass", doc_class_cmd);
  primitive("LoadClass", doc_class_cmd,one_code);
  primitive("@ifclassloaded",if_package_loaded_cmd,zero_code);
  primitive("@ifpackageloaded",if_package_loaded_cmd,one_code);
  primitive("@ifclasslater",if_package_later_cmd,zero_code);
  primitive("@ifpackagelater",if_package_later_cmd,one_code);
  primitive("@ifclasswith",if_package_with_cmd,zero_code);
  primitive("@ifpackagewith",if_package_with_cmd,one_code);
  primitive("ProvidesFile",provides_package_cmd,zero_code);
  primitive("ProvidesPackage",provides_package_cmd,one_code);
  primitive("ProvidesClass",provides_package_cmd,two_code);
  primitive("PassOptionsToClass",pass_options_cmd,zero_code);
  primitive("PassOptionsToPackage",pass_options_cmd,one_code);
  primitive("DeclareOption",declare_options_cmd);
  primitive("OptionNotUsed",options_not_used_cmd);
  primitive("ProcessOptions",process_options_cmd);
  primitive("ExecuteOptions",execute_options_cmd);
  primitive("AtEndOfPackage",at_end_of_class_cmd,one_code);
  primitive("AtEndOfClass",at_end_of_class_cmd,zero_code);
  primitive("LoadClassWithOptions",load_with_options_cmd,zero_code);
  primitive("RequirePackageWithOptions",load_with_options_cmd,one_code);
  primitive("InputClass", inputclass_cmd);   // hack
  primitive("usepackage", package_cmd);  
  primitive("RequirePackage", package_cmd);  
  primitive("NeedsTeXFormat",needs_format_cmd);
  primitive("subfigure", subfigure_cmd);  
  primitive("pop@stack", pop_stack_cmd);  
  primitive("mbox",box_cmd,mbox_code);
  primitive("makebox",box_cmd,makebox_code);
  primitive("text",box_cmd,text_code);
  primitive("textsuperscript",sub_cmd,zero_code);
  primitive("textsubscript",sub_cmd,one_code);
  primitive("oldstylenums",sub_cmd,two_code);
  primitive("soul@caps",soul_cmd,soul_caps_code);
  primitive("soul@hl",soul_cmd,soul_hl_code);
  primitive("soul@so",soul_cmd,soul_so_code);
  primitive("soul@st",soul_cmd,soul_st_code);
  primitive("soul@ul",soul_cmd,soul_ul_code);
  primitive("mathord",math_comp_cmd,ord_noad);
  mathop_token= primitive("mathop",math_comp_cmd,op_noad);
  primitive("mathbin",math_comp_cmd,bin_noad);
  primitive("mathrel",math_comp_cmd,rel_noad);
  primitive("mathopen",math_comp_cmd,open_noad);
  primitive("mathclose",math_comp_cmd,close_noad);
  primitive("mathpunct",math_comp_cmd,punct_noad);
  primitive("mathinner",math_comp_cmd,inner_noad);
  primitive("mathbetween",math_comp_cmd,between_noad);
  primitive("big", big_cmd,big_code);
  primitive("Big", big_cmd,Big_code);
  primitive("bigg", big_cmd,bigg_code);
  primitive("Bigg", big_cmd,Bigg_code);
  primitive("bigl", big_cmd,bigl_code);
  primitive("Bigl", big_cmd,Bigl_code);
  primitive("biggl", big_cmd,biggl_code);
  primitive("Biggl", big_cmd,Biggl_code);
  primitive("bigr", big_cmd,bigr_code);
  primitive("Bigr", big_cmd,Bigr_code);
  primitive("biggr", big_cmd,biggr_code);
  primitive("Biggr", big_cmd,Biggr_code);
  primitive("bigm", big_cmd,bigm_code);
  primitive("Bigm", big_cmd,Bigm_code);
  primitive("biggm", big_cmd,biggm_code);
  primitive("Biggm", big_cmd,Biggm_code);
  genfrac_mode[0] =  
    primitive("displaystyle", style_cmd,displaystyle_code);
  genfrac_mode[1] =  
    primitive("textstyle", style_cmd,textstyle_code);
  genfrac_mode[2] =  
    primitive("scriptstyle", style_cmd,scriptstyle_code);
  genfrac_mode[3] =  
    primitive("scriptscriptstyle", style_cmd,scriptscriptstyle_code);
  primitive("displaylimits",limits_cmd);
  limits_token = primitive("limits",limits_cmd,two_code);
  primitive("nolimits",limits_cmd,one_code);
  ensuremath_token = primitive("ensuremath",ensuremath_cmd);
  primitive("nonumber",nonumber_cmd);
  primitive("linebreak",linebreak_cmd,linebreak_code);
  primitive("nolinebreak",linebreak_cmd,nolinebreak_code);
  primitive("pagebreak",linebreak_cmd,pagebreak_code);
  primitive("nopagebreak",linebreak_cmd,nopagebreak_code);
  primitive("url",url_cmd);
  primitive("rrrt",url_cmd,one_code);
  primitive("Href",hanl_cmd,zero_code);
  primitive("@@href@foot",hanl_cmd,one_code);
  primitive("href",hanl_cmd,two_code);
  primitive("@href",hanl_cmd,two_code);
  primitive("AddAttToCurrent",addatt_cmd,addatt_to_cur_code);
  primitive("AddAttToLast",addatt_cmd,addatt_to_last_code);
  primitive("addattributestodocument",addatt_cmd,addatt_to_doc_code);
  primitive("addattributetodocument",addatt_cmd,addatt_to_doc_code);
  primitive("AddAttToDocument",addatt_cmd,addatt_to_doc_code);
  primitive("XMLaddatt",addatt_cmd,addatt_to_code);
  primitive("addattributetoindex",addatt_cmd,addatt_to_index_code);
  primitive("AddAttToIndex",addatt_cmd,addatt_to_index_code);
  primitive("above",over_cmd,above_code);
  primitive("over",over_cmd,over_code);
  primitive("atop",over_cmd,atop_code);
  primitive("abovewithdelims",over_cmd,abovewithdelims_code);
  primitive("overwithdelims",over_cmd,overwithdelims_code);
  primitive("atopwithdelims",over_cmd,atopwithdelims_code);
  begingroup_token =
    primitive("begingroup",begingroup_cmd,zero_code);
  endgroup_token =
    primitive("endgroup",begingroup_cmd,one_code);
  sendgroup_token =  primitive("end group",begingroup_cmd,subtypes(2));
  footnote_token =primitive("footnote",footnote_cmd);
  primitive("tralics@fnhack",fnhack_cmd);
  primitive("tralics@pop@module",popmodule_cmd);
  primitive("tralics@push@module",pushmodule_cmd);
  primitive("tralics@interpret@rc",interpret_rc_cmd);
  primitive("thanks",footnote_cmd);
  primitive("caption",caption_cmd);
  primitive("centering",centering_cmd,center_code);
  primitive("nocentering",centering_cmd,zero_code);
  primitive("raggedleft", centering_cmd, flushright_code);
  primitive("raggedright", centering_cmd, flushleft_code);
  primitive("sbox", save_box_cmd,zero_code);
  primitive("savebox", save_box_cmd,one_code);
  primitive("fbox", fbox_cmd,fbox_code);
  primitive("framebox", fbox_cmd,framebox_code);
  primitive("rotatebox", fbox_cmd,rotatebox_code);
  primitive("scalebox", fbox_cmd,scalebox_code);
  primitive("raisebox", fbox_cmd,raisebox_code);
  hspace_token = primitive("hspace",hspace_cmd,zero_code);
  vspace_token = primitive("vspace",hspace_cmd,one_code);
  primitive("includegraphics",includegraphics_cmd,zero_code);
  primitive("psfig",includegraphics_cmd,one_code);
  error_token = primitive("error", error_cmd);
  notprerr_token = primitive("@notprerr", error_cmd,one_code);
  primitive("@glo",glo_cmd);
  primitive("@reevaluate",reevaluate_cmd);
  primitive("xmllatex",xmllatex_cmd);
  primitive("ignorespaces",specimp_cmd,ignorespaces_code);
  primitive("mark",specimp_cmd,mark_code);
  primitive("penalty",specimp_cmd,penalty_code);
  //  unimplemented...
  primitive("accent",unimp_cmd,accent_code);
  primitive("delimiter",unimp_cmd,delimiter_code);
  primitive("halign",unimp_cmd,halign_code);
  primitive("insert",unimp_cmd,insert_code);
  primitive("mathattribute", special_math_cmd,math_attribute_code);
  primitive("rowattribute", special_math_cmd,row_attribute_code);
  primitive("cellattribute", special_math_cmd,cell_attribute_code);
  primitive("formulaattribute", special_math_cmd,formula_attribute_code);
  primitive("tableattribute", special_math_cmd,table_attribute_code);
  primitive("thismathattribute", special_math_cmd,thismath_attribute_code);
  primitive("mathmi", special_math_cmd,mathmi_code);
  primitive("mathmn", special_math_cmd,mathmn_code);
  primitive("mathmo", special_math_cmd,mathmo_code);
  primitive("mathci", special_math_cmd,mathci_code);
  primitive("mathcn", special_math_cmd,mathcn_code);
  primitive("mathcsymbol", special_math_cmd,mathcsymbol_code);
  mmlmultiscripts_token 
    = primitive("mmlmultiscripts", special_math_cmd,multiscripts_code);
  primitive("mathcnothing", special_math_cmd,mathnothing_code);
  primitive("mathaccent",unimp_cmd,mathaccent_code);
  primitive("mathchar",unimp_cmd,mathchar_code);
  primitive("noalign",unimp_cmd,noalign_code);
  primitive("noboundary",unimp_cmd,noboundary_code);
  primitive("nonscript",nonscript_cmd);
  primitive("tag",tag_cmd);
  xtag_token = primitive("@xtag",tag_cmd,one_code);
  ytag_token = primitive("@ytag",tag_cmd,two_code);
  xtag1_token = locate("x@tag");
  ytag1_token = locate("y@tag");
  primitive("omit",unimp_cmd,omit_code);
  primitive("radical",unimp_cmd,radical_code);
  primitive("vadjust",unimp_cmd,vadjust_code);
  primitive("valign",unimp_cmd,valign_code);
  primitive("vcenter",unimp_cmd,vcenter_code);
  primitive("span",unimp_cmd,span_code);
  primitive("cr",cr_cmd,cr_code);
  cr_token = primitive("cr ",cr_cmd,mycr_code);
  primitive("crcr",cr_cmd,crcr_code);
  crwithargs_token = primitive("cr withargs",cr_cmd,crwithargs_code);
  primitive("dump",unimp_cmd,dump_code);
  primitive("@@end",specimp_cmd,atatend_code);
  primitive("tralics@abort",specimp_cmd,abort_code);
  primitive("tralics@sleep",specimp_cmd,sleep_code);
  primitive("tralics@prompt",specimp_cmd,prompt_code);
  primitive("tralics@random",random_cmd);
  primitive("stop",specimp_cmd,atatend_code);
  primitive("eqno",eqno_cmd,eqno_code);
  primitive("leqno",eqno_cmd,leqno_code);
  primitive("message",specimp_cmd,message_code);
  primitive("errmessage",specimp_cmd,errmessage_code);
  primitive("widthof",unimp_cmd,widthof_code);
  primitive("heightof",unimp_cmd,heightof_code);
  primitive("depthof",unimp_cmd,depthof_code);
  primitive("frontmatter", matter_cmd, frontmatter_code);
  primitive("backmatter", matter_cmd, backmatter_code);
  primitive("mainmatter", matter_cmd, mainmatter_code);
  primitive("cgloss@gll", gloss_cmd, zero_code);
  primitive("cgloss@glll", gloss_cmd, one_code);
  primitive("@newindex", index_cmd, newindex_code);
  primitive("index", index_cmd, index_code);
  primitive("glossary", index_cmd, glossary_code);
  primitive("@onlypreamble", only_preamble_cmd);
  primitive("tableofcontents", toc_cmd);
  primitive("listoftables", toc_cmd,one_code);
  primitive("listoffigures", toc_cmd,two_code);
  primitive("mathversion", mathversion_cmd);
  primitive("printindex", index_cmd, printindex_code);
  primitive("printglossary", index_cmd, printglossary_code);
  primitive("makeindex", index_cmd, makeindex_code);
  primitive("makeglossary", index_cmd, makeglossary_code);
  primitive("node", trees_cmd,node_code); 
  primitive("nodepoint", trees_cmd,nodepoint_code); 
  primitive("nodeconnect", trees_cmd,nodeconnect_code); 
  primitive("anodeconnect", trees_cmd,anodeconnect_code); 
  primitive("nodecurve", trees_cmd,nodecurve_code); 
  primitive("anodecurve", trees_cmd,anodecurve_code); 
  primitive("nodebox", trees_cmd,nodebox_code); 
  primitive("nodeoval", trees_cmd,nodeoval_code); 
  primitive("nodetriangle", trees_cmd,nodetriangle_code); 
  primitive("nodecircle", trees_cmd,nodecircle_code); 
  primitive("barnodeconnect", trees_cmd,barnodeconnect_code); 
  primitive("abarnodeconnect", trees_cmd,abarnodeconnect_code); 
  primitive("hskip",scan_glue_cmd,hskip_code);
  primitive("vskip",scan_glue_cmd,vskip_code);
  primitive("mskip",scan_glue_cmd,mskip_code);
  primitive("lowercase",case_shift_cmd,zero_code);
  primitive("uppercase",case_shift_cmd,one_code);
  primitive("MakeLowercase",case_shift_cmd,subtypes(2));
  primitive("MakeUppercase",case_shift_cmd,subtypes(3));
  primitive("@@MakeTextLowercase",case_shift_cmd,subtypes(4));
  primitive("@@MakeTextUppercase",case_shift_cmd,subtypes(5));
  primitive("kern",kern_cmd,zero_code);
  primitive("mkern",kern_cmd,one_code);
  primitive("box",make_box_cmd,box_code);
  primitive("copy",make_box_cmd,copy_code);
  primitive("usebox",make_box_cmd,usebox_code);
  primitive("lastbox",make_box_cmd,lastbox_code);
  primitive("vsplit",make_box_cmd,vsplit_code);
  primitive("vtop",make_box_cmd,vtop_code);
  primitive("vbox",make_box_cmd,vbox_code);
  primitive("hbox",make_box_cmd,hbox_code);
  primitive("xbox",make_box_cmd,xbox_code);
  primitive("parbox",make_box_cmd,parbox_code);
  primitive("marginpar",make_box_cmd,marginpar_code);
  primitive("char",char_num_cmd,zero_code);
  // constants  (non math)
  tilda_token= primitive("nobreakspace",nobreakspace_cmd);
  primitive("textasciicircum",specchar_cmd, subtypes(0x2303));
  primitive("og",cst_cmd,guillemet_og_code);
  primitive("fg",cst_cmd,guillemet_fg_code);

  textvisiblespace_token = 
    primitive("textvisiblespace",specchar_cmd,subtypes(0x2423));

  primitive("textquotestraightbase",unimp_cmd,textquotestraightbase_code);
  primitive("textquotestraightdblbase",unimp_cmd,textquotestraightdblbase_code);
  primitive("textlbrackdbl",unimp_cmd,textlbrackdbl_code);
  primitive("textrbrackdbl",unimp_cmd,textrbrackdbl_code);
  primitive("textcompwordmark",unimp_cmd,textcompwordkmark_code);
  primitive("texttildelow",unimp_cmd,texttildelow_code);
  primitive("textcentoldstyle",unimp_cmd,textcentoldstyle_code);
  primitive("textdollaroldstyle",unimp_cmd,textdollaroldstyle_code);
  primitive("textcopyleft",unimp_cmd,textcopyleft_code);
  primitive("textzerooldstyle",unimp_cmd,textzerooldstyle_code);
  primitive("textoneoldstyle",unimp_cmd,textoneoldstyle_code);
  primitive("texttwooldstyle",unimp_cmd,texttwooldstyle_code);
  primitive("textthreeoldstyle",unimp_cmd,textthreeoldstyle_code);
  primitive("textfouroldstyle",unimp_cmd,textfouroldstyle_code);
  primitive("textfiveoldstyle",unimp_cmd,textfiveoldstyle_code);
  primitive("textsixoldstyle",unimp_cmd,textsixoldstyle_code);
  primitive("textsevenoldstyle",unimp_cmd,textsevenoldstyle_code);
  primitive("texteightoldstyle",unimp_cmd,texteightoldstyle_code);
  primitive("textnineoldstyle",unimp_cmd,textnineoldstyle_code);

  primitive("textcapitalcompwordmark",unimp_cmd,textcapitalcompwordmark_code);
  primitive("textguarani",unimp_cmd,textguarani_code);
  primitive("textleaf",unimp_cmd,textleaf_code);
  primitive("textdied",unimp_cmd,textdied_code);
  primitive("textdivorced",unimp_cmd,textdivorced_code);
  primitive("textblank",unimp_cmd,textblank_code);
  primitive("textborn",unimp_cmd,textborn_code);
  primitive("textmarried",unimp_cmd,textmarried_code);
  primitive("textdblhyphen",unimp_cmd,textdblhyphen_code);
  primitive("textascendercompwordmark",unimp_cmd,textascendercompwordmark_code);
  primitive("textinterrobangdown",unimp_cmd,textinterrobangdown_code);
  primitive("textdiscount",unimp_cmd,textdiscount_code);
  primitive("textquotesingle",char_given_cmd,subtypes('\''));
  apostrophe_token = primitive("apostrophe",char_given_cmd,subtypes(0xB4));
  primitive("textless",specchar_cmd,subtypes('<'));
  primitive("textgreater",specchar_cmd,subtypes('>'));
  primitive("DeclareTextCommand", unimp_font_cmd,DeclareTextCommand_code);
  primitive("ProvideTextCommand", unimp_font_cmd,ProvideTextCommand_code);
  primitive("ProvideTextCommandDefault", unimp_font_cmd,ProvideTextCommandDefault_code);
  primitive("DeclareTextCompositeCommand", unimp_font_cmd, DeclareTextCompositeCommand_code);
  primitive("DeclareTextComposite", unimp_font_cmd, DeclareTextComposite_code);
  primitive("DeclareTextAccent", unimp_font_cmd, DeclareTextAccent_code);
  primitive("UseTextAccent", unimp_font_cmd, UseTextAccent_code);
  primitive("DeclareTextCommandDefault", unimp_font_cmd, DeclareTextCommandDefault_code);
  primitive("ProvideTextCommandDefault", unimp_font_cmd, ProvideTextCommandDefault_code);
  primitive("TextSymbolUnavailable", unimp_font_cmd, TextSymbolUnavailable_code);
  primitive("DeclareTextSymbol", unimp_font_cmd, DeclareTextSymbol_code);
  primitive("DeclareTextSymbolDefault", unimp_font_cmd, DeclareTextSymbolDefault_code);
  primitive("UseTextSymbol", unimp_font_cmd, UseTextSymbol_code);
  primitive("UndeclareTextCommand", unimp_font_cmd, UndeclareTextCommand_code);
  primitive("DeclareFontShape", unimp_font_cmd, DeclareFontShape_code);
  primitive("DeclareFixedFont", unimp_font_cmd, DeclareFixedFont_code);
  primitive("DeclareFontFamily", unimp_font_cmd, DeclareFontFamily_code);
  primitive("DeclareFontEncoding", unimp_font_cmd, DeclareFontEncoding_code);
  primitive("DeclareFontSubstitution", unimp_font_cmd, DeclareFontSubstitution_code);
  primitive("DeclareFontEncodingDefaults", unimp_font_cmd, DeclareFontEncodingDefaults_code);
  primitive("DeclarePreloadSizes", unimp_font_cmd, DeclarePreloadSizes_code);
  primitive("DeclareMathSizes", unimp_font_cmd, DeclareMathSizes_code);
  primitive("DeclareErrorFont", unimp_font_cmd, DeclareErrorFont_code);
  primitive("DeclareSizeFunction", unimp_font_cmd, DeclareSizeFunction_code);
  primitive("DeclareMathVersion",unimp_font_cmd, DeclareMathVersion_code);
  primitive("DeclareSymbolFont",unimp_font_cmd, DeclareSymbolFont_code);
  primitive("SetSymbolFont",unimp_font_cmd, SetSymbolFont_code);
  primitive("DeclareMathAlphabet",unimp_font_cmd, DeclareMathAlphabet_code);
  primitive("SetMathAlphabet",unimp_font_cmd, SetMathAlphabet_code);
  primitive("DeclareMathAccent",unimp_font_cmd, DeclareMathAccent_code);
  primitive("DeclareMathSymbol",unimp_font_cmd, DeclareMathSymbol_code);
  primitive("DeclareMathDelimiter",unimp_font_cmd, DeclareMathDelimiter_code);
  primitive("DeclareMathRadical",unimp_font_cmd, DeclareMathRadical_code);
  primitive("DeclareSymbolFontAlphabet",unimp_font_cmd, DeclareSymbolFontAlphabet_code);
  primitive("DeclareTextFontCommand",unimp_font_cmd, DeclareTextFontCommand_code);
  primitive("DeclareOldFontCommand",unimp_font_cmd, DeclareOldFontCommand_code);
  primitive("@setsize",unimp_font_cmd,setsize_code);
  // Moved here and added 2006-10-07
  primitive("textbar",specchar_cmd,subtypes('|'));
  primitive("textunderscore",specchar_cmd,subtypes(0x5F));
  primitive("textbraceleft",specchar_cmd,subtypes(0x7B));
  primitive("textbraceright",specchar_cmd,subtypes(0x7D));
  primitive("textasciitilde",specchar_cmd,subtypes(0x7E));
  primitive("textexclamdown",specchar_cmd,subtypes(0xA1));
  primitive("textcent",specchar_cmd,subtypes(0xA2));
  primitive("textsterling",specchar_cmd,subtypes(0xA3));
  primitive("textcurrency",specchar_cmd,subtypes(0xA4));
  primitive("textyen",specchar_cmd,subtypes(0xA5));
  primitive("textbrokenbar",specchar_cmd,subtypes(0xA6));
  primitive("S",char_given_cmd,subtypes(0xA7));
  primitive("textsection",specchar_cmd,subtypes(0xA7));
  primitive("textasciidieresis",specchar_cmd,subtypes(0xA8));
  primitive("textcopyright",specchar_cmd,subtypes(0xA9));
  primitive("copyright",specchar_cmd,subtypes(0xA9));
  primitive("textordfeminine",specchar_cmd,subtypes(0xAA));
  primitive("guillemotleft",specchar_cmd,subtypes(0xAB));
  primitive("textlnot",specchar_cmd,subtypes(0xAC));
  primitive("textsofthyphen",specchar_cmd,subtypes(0xAD));
  primitive("textregistered",specchar_cmd,subtypes(0xAE));
  primitive("textasciimacron",specchar_cmd,subtypes(0xAF));
  primitive("textdegree",specchar_cmd,subtypes(0xB0));
  primitive("textpm",specchar_cmd,subtypes(0xB1));
  primitive("texttwosuperior",specchar_cmd,subtypes(0xB2));
  primitive("textthreesuperior",specchar_cmd,subtypes(0xB3));
  primitive("textasciiacute",char_given_cmd,subtypes(0xB4));
  primitive("textmu",specchar_cmd,subtypes(0xB5));
  primitive("P",char_given_cmd,subtypes(0xB6));
  primitive("textparagraph",specchar_cmd,subtypes(0xB6));
  primitive("textpilcrow",specchar_cmd,subtypes(0xB6));
  primitive("textperiodcentered",specchar_cmd,subtypes(0xB7));
  primitive("textasciicedilla",specchar_cmd,subtypes(0xB8));
  primitive("textonesuperior",specchar_cmd,subtypes(0xB9));
  primitive("textordmasculine",specchar_cmd,subtypes(0xBA));
  primitive("guillemotright",specchar_cmd,subtypes(0xBB));
  primitive("textonequarter",specchar_cmd,subtypes(0xBC));
  primitive("textonehalf",specchar_cmd,subtypes(0xBD));
  primitive("textthreequarters",specchar_cmd,subtypes(0xBE));
  primitive("textquestiondown",specchar_cmd,subtypes(0xBF));
  primitive("AA",specchar_cmd,subtypes(0xC5));
  primitive("AE",specchar_cmd,subtypes(0xC6));
  primitive("DH",specchar_cmd,subtypes(0xD0));
  primitive("texttimes",specchar_cmd,subtypes(0xD7));
  primitive("TH",specchar_cmd,subtypes(0xDE));
  primitive("aa",specchar_cmd,subtypes(0xE5));
  primitive("ae",specchar_cmd,subtypes(0xE6));
  primitive("dh",specchar_cmd,subtypes(0xF0));
  primitive("textdiv",specchar_cmd,subtypes(0xF7));
  primitive("th",specchar_cmd,subtypes(0xFE));
  primitive("o",specchar_cmd,subtypes(0xF8));
  primitive("O",specchar_cmd,subtypes(0xD8));
  primitive("DJ",specchar_cmd,subtypes(0x110));
  primitive("dj",specchar_cmd,subtypes(0x111));
  primitive("textflorin",specchar_cmd,subtypes(0x192));
  primitive("textasciibreve",specchar_cmd,subtypes(0x306));
  primitive("textasciicaron",specchar_cmd,subtypes(0x30C));
  primitive("textbaht",specchar_cmd,subtypes(0xE3F));
  primitive("textendash",specchar_cmd,subtypes(0x2013));
  primitive("textemdash",specchar_cmd,subtypes(0x2014));
  primitive("textbardbl",specchar_cmd,subtypes(0x2016));
  primitive("textquoteleft",specchar_cmd,subtypes(0x2018));
  primitive("textquoteright",specchar_cmd,subtypes(0x2019));
  primitive("textquotedblleft",specchar_cmd,subtypes(0x201C));
  primitive("textquotedblright",specchar_cmd,subtypes(0x201D));
  primitive("textdagger",specchar_cmd,subtypes(0x2020));
  primitive("textdaggerdbl",specchar_cmd,subtypes(0x2021));
  primitive("textbullet",specchar_cmd,subtypes(0x2022));
  primitive("textellipsis",specchar_cmd,subtypes(0x2026));
  primitive("textperthousand",specchar_cmd,subtypes(0x2030));
  primitive("textpertenthousand",specchar_cmd,subtypes(0x2031));
  primitive("textacutedbl",specchar_cmd,subtypes(0x2033));
  primitive("textgravedbl",specchar_cmd,subtypes(0x2036));
  primitive("textreferencemark",specchar_cmd,subtypes(0x203B));
  primitive("textinterrobang",specchar_cmd,subtypes(0x203D));
  primitive("textlquill",specchar_cmd,subtypes(0x2045));
  primitive("textrquill",specchar_cmd,subtypes(0x2046));
  primitive("textfractionsolidus",specchar_cmd,subtypes(0x2044));
  primitive("textasteriskcentered",specchar_cmd,subtypes(0x204E));
  primitive("textcolonmonetary", specchar_cmd, subtypes(0x20A1));
  primitive("textfrenchfranc", specchar_cmd, subtypes(0x20A3));
  primitive("textlira", specchar_cmd, subtypes(0x20A4));
  primitive("textnaira", specchar_cmd, subtypes(0x20A6));
  primitive("textwon", specchar_cmd, subtypes(0x20A9));
  primitive("textdong", specchar_cmd, subtypes(0x20AB));
  primitive("texteuro",specchar_cmd, subtypes(0x20AC));
  primitive("textpeso",specchar_cmd, subtypes(0x20B1));
  primitive("textcelsius", specchar_cmd, subtypes(0x2103));
  primitive("textnumero",specchar_cmd,subtypes(0x2116));
  primitive("textcircledP",specchar_cmd,subtypes(0x2117));
  primitive("textrecipe",specchar_cmd,subtypes(0x211E));
  primitive("textservicemark",specchar_cmd,subtypes(0x2120));
  primitive("texttrademark",specchar_cmd,subtypes(0x2122));
  primitive("textohm",specchar_cmd,subtypes(0x2126));
  primitive("textmho",specchar_cmd,subtypes(0x2127));
  primitive("textestimated",specchar_cmd,subtypes(0x212E));
  primitive("textleftarrow",specchar_cmd,subtypes(0x2190));
  primitive("textuparrow",specchar_cmd,subtypes(0x2191));
  primitive("textrightarrow",specchar_cmd,subtypes(0x2192));
  primitive("textdownarrow",specchar_cmd,subtypes(0x2193));
  primitive("textsurd",specchar_cmd,subtypes(0x221A));
  primitive("textopenbullet",specchar_cmd,subtypes(0x25E6));
  primitive("textmusicalnote",specchar_cmd,subtypes(0x266A));
  primitive("textbigcircle",specchar_cmd,subtypes(0x25EF));
  primitive("textrangle",specchar_cmd,subtypes(0x3009));
  primitive("textlangle",specchar_cmd,subtypes(0x3008));
 

  // constants math and non math
  primitive("i",cst1_cmd,i_code);
  primitive("j",cst1_cmd,j_code);
  primitive("$",cst1_cmd,dollar_code);
  primitive("textdollar",cst_cmd,dollar_code);
  primitive(",",cst1_cmd,comma_code);
  primitive("thinspace",cst1_cmd,comma_code);
  primitive("_",cst1_cmd,underscore_code);
  primitive("&",cst1_cmd,amp_code);
  text_OB_token = primitive("{",cst1_cmd,lbrace_chr);
  text_CB_token = primitive("}",cst1_cmd,rbrace_chr);
  primitive("%",cst1_cmd,percent_code);
  primitive(" ",cst1_cmd,space_code);
  primitive("\n",cst1_cmd,space_code);
  primitive("\r",cst1_cmd,space_code);
  primitive("\t",cst1_cmd,space_code);
  primitive("!",cst1_cmd,exclam_code);
  primitive("quad",cst1_cmd,quad_code);
  primitive("qquad",cst1_cmd,qquad_code);
  primitive("dots",cst1_cmd,dots_code);
  primitive("ldots",cst1_cmd,ldots_code);
  primitive("#",cst1_cmd,sharp_code);
  primitive("sharp", cst1_cmd, msharp_code);
  primitive("natural", cst1_cmd, natural_code);
  primitive("flat", cst1_cmd, flat_code);
  primitive("textasciigrave",specchar_cmd,subtypes(0x2035));
  primitive("textasciiacutex",cst_cmd,textasciiacutex_code);
  primitive("dag",cst1_cmd, tdagger_code);
  primitive("ddag",cst1_cmd, tddagger_code);
  primitive("-",cst_cmd,dash_code);
  primitive("SS",cst_cmd,SS_code);
  primitive("numero", cst2_cmd,numero_code);
  primitive("Numero",cst2_cmd,Numero_code);
  primitive("No",cst2_cmd,Numero_code);
  primitive("no",cst2_cmd,numero_code);
  primitive("ier",cst2_cmd,ier_code);
  primitive("iere",cst2_cmd,iere_code);
  primitive("iers",cst2_cmd,iers_code);
  primitive("ieres",cst2_cmd,ieres_code);
  primitive("ieme",cst2_cmd, ieme_code);
  primitive("iemes",cst2_cmd,iemes_code);
  primitive("textnospace",specchar_cmd,subtypes(0x200B));
  primitive("LaTeX",cst_cmd,LaTeX_code);
  primitive("TeX",cst_cmd,TeX_code);
  primitive("ss",cst_cmd,ss_code);
  primitive("slash",cst_cmd,slash_code);
  primitive("textbackslash",cst_cmd,textbackslash_code);
  //  primitive("null",cst_cmd,null_code);
  primitive("IfFileExists",file_cmd,ifexists_code);
  primitive("InputIfFileExists",file_cmd,inputifexists_code);
  primitive("input",input_cmd,input_code);
  primitive("Input",input_cmd,Input_code);
  primitive("include",input_cmd,include_code);
  primitive("readxml",input_cmd,subtypes(scantokens_code+1));
  primitive("endinput",input_cmd,endinput_code);
  primitive("openin",file_cmd,openin_code);
  primitive("closein",file_cmd,closein_code);
  primitive("xmlelt",xmlelt_cmd,zero_code);
  primitive("xmlemptyelt",xmlelt_cmd,one_code);
  primitive("newcolumntype",newcolumntype_cmd);
  primitive("lsc",arg_font_cmd,lsc_code);
  primitive("fsc",arg_font_cmd,fsc_code);
  primitive("hrule",rule_cmd,hrule_code);
  primitive("vrule",rule_cmd,vrule_code);
  primitive("rule",rule_cmd,rule_code);
  primitive("ding",ding_cmd);
  primitive("dates@checkdate",check_date_cmd);
  primitive("dates@countdays",check_date_cmd,one_code);
  primitive("dates@nextdate",check_date_cmd,two_code);
  primitive("dates@prevdate",check_date_cmd,three_code);
  primitive("dates@datebynumber",check_date_cmd,subtypes(4));
  primitive("@monthnamefrench", month_day_cmd,md_frenchm_code);
  primitive("@daynamefrench", month_day_cmd,md_frenchd_code);
  primitive("@monthnamegerman", month_day_cmd,md_germanm_code);
  primitive("@daynamegerman", month_day_cmd,md_germand_code);
  primitive("@monthnameenglish", month_day_cmd,md_englishm_code);
  primitive("@daynameenglish", month_day_cmd,md_englishd_code);
  primitive("@monthnamespanish", month_day_cmd,md_spanishm_code);
  primitive("@daynamespanish", month_day_cmd,md_spanishd_code);
  // environments
  primitive("document",document_cmd);
  primitive("motscle",keywords_cmd);
  //  primitive("keywords",keywords_cmd);
  primitive("center",center_cmd,center_code);
  primitive("verse",center_cmd,verse_code);
  primitive("quote",center_cmd,quote_code);
  primitive("quotation",center_cmd,quotation_code);
  primitive("flushleft",center_cmd,flushleft_code);
  primitive("flushright",center_cmd,flushright_code);
  primitive("@float",float_cmd,subtypes(0));
  primitive("@dblfloat",float_cmd,subtypes(1));
  primitive("float@end",float_cmd,subtypes(2));
  primitive("float@dblend",float_cmd,subtypes(3));
  primitive("figure",figure_cmd,zero_code);
  primitive("wrapfigure",figure_cmd,two_code);
  primitive("figure*",figure_cmd,one_code);
  primitive("table",table_cmd,zero_code);
  primitive("table*",table_cmd,one_code);
  primitive("wraptable",table_cmd,two_code);
  primitive("@glossaire",glossaire_cmd);
  primitive("usecounter", usecounter_cmd);
  primitive("itemize", itemize_cmd);
  primitive("list", list_cmd);
  primitive("enumerate",enumerate_cmd);
  primitive("description",description_cmd);
  primitive("latexonly",ignore_env_cmd,latexonly_code);
  primitive("xmlonly",ignore_env_cmd,xmlonly_code);
  primitive("subequations",ignore_env_cmd,subequations_code); // is this OK ??
  //  primitive("htmlonly",ignore_content_cmd,htmlonly_code);
  primitive("comment",ignore_content_cmd,comment_code);
  // primitive("rawhtml",ignore_content_cmd,rawhtml_code);
  primitive("LaTeXonly",ignore_content_cmd,LaTeXonly_code);
  primitive("rawxml",raw_env_cmd);
  primitive("eqnarray",math_env_cmd,eqnarray_code);
  primitive("eqnarray*",math_env_cmd,eqnarray_star_code);
  primitive("Beqnarray",math_env_cmd,Beqnarray_code);
  primitive("Beqnarray*",math_env_cmd,Beqnarray_star_code);
  primitive("multline",math_env_cmd,multline_code);
  primitive("multline*",math_env_cmd,multline_star_code);
  primitive("gather",math_env_cmd,gather_code);
  primitive("gather*",math_env_cmd,gather_star_code);
  at_align_token=primitive("@align",math_env_cmd,align_code);
  primitive("@align*",math_env_cmd,align_star_code);
  primitive("split",math_env_cmd,split_code);
  primitive("aligned",math_env_cmd,aligned_code);
  primitive("equation",math_env_cmd,equation_code);
  primitive("equation*",math_env_cmd,equation_star_code);
  primitive("math",math_env_cmd,math_code);
  primitive("displaymath",math_env_cmd,displaymath_code);
  primitive("tralics@push@section",RAsection_env_cmd);
  primitive("tabular",tabular_env_cmd,zero_code);
  primitive("tabular*",tabular_env_cmd,one_code);
  primitive("verbatim",verbatim_env_cmd,zero_code);
  primitive("Verbatim",Verbatim_env_cmd,zero_code);
  primitive("minipage",minipage_cmd);
  primitive("picture",picture_env_cmd);
  primitive("xmlelement",xmlelement_env_cmd);
  primitive("xmlelement*",xmlelement_env_cmd,one_code);
  primitive("xmlelement+",xmlelement_env_cmd,two_code);
  primitive("filecontents",filecontents_env_cmd);
  primitive("filecontents*",filecontents_env_cmd,one_code);
  primitive("filecontents+",filecontents_env_cmd,two_code);
  primitive("filecontents-",filecontents_env_cmd,three_code);
  primitive("enddocument",end_document_cmd);
  real_end_token = 
    primitive("real end of document",end_document_cmd, one_code);
  primitive("endmotscle",end_keywords_cmd);
  primitive("endcenter",end_center_cmd, center_code);
  primitive("endverse",end_center_cmd, verse_code);
  primitive("endquote",end_center_cmd, quote_code);
  primitive("endquotation",end_center_cmd, quotation_code);
  primitive("endflushleft",end_center_cmd, flushleft_code);
  primitive("endflushright",end_center_cmd, flushright_code);
  primitive("endfigure",end_figure_cmd,zero_code);
  primitive("endwrapfigure",end_figure_cmd,two_code);
  primitive("endfigure*",end_figure_cmd,one_code);
  primitive("endtable",end_table_cmd,zero_code);
  primitive("endwraptable",end_table_cmd,two_code);
  primitive("endtable*",end_table_cmd,one_code);
  primitive("end@glossaire",end_glossaire_cmd);
  primitive("enditemize", end_itemize_cmd);
  primitive("endlist", end_list_cmd);
  primitive("endenumerate",end_enumerate_cmd);
  primitive("enddescription",end_description_cmd);
  primitive("endlatexonly",end_ignore_env_cmd,latexonly_code);
  primitive("endxmlonly",end_ignore_env_cmd,xmlonly_code);
  primitive("endsubequations",end_ignore_env_cmd,subequations_code); // is this OK ??
  //  primitive("endhtmlonly",end_ignore_content_cmd,htmlonly_code);
  //  primitive("endcomment",end_ignore_content_cmd,comment_code);
  //  primitive("endrawhtml",end_ignore_content_cmd,rawhtml_code);
  primitive("endLaTeXonly",end_ignore_content_cmd,LaTeXonly_code);
  primitive("endrawxml",end_raw_env_cmd);
  primitive("endeqnarray",end_math_env_cmd,eqnarray_code);
  primitive("endeqnarray*",end_math_env_cmd,eqnarray_star_code);
  primitive("endBeqnarray",end_math_env_cmd,Beqnarray_code);
  primitive("endBeqnarray*",end_math_env_cmd,Beqnarray_star_code);
  primitive("endmultline",end_math_env_cmd,multline_code);
  primitive("endmultline*",end_math_env_cmd,multline_star_code);
  primitive("endgather",end_math_env_cmd,gather_code);
  primitive("endgather*",end_math_env_cmd, gather_star_code);
  primitive("@endalign",end_math_env_cmd,align_code);
  primitive("endsplit",end_math_env_cmd,split_code);
  primitive("endaligned",end_math_env_cmd,aligned_code);
  primitive("endequation",end_math_env_cmd,equation_code);
  primitive("endequation*",end_math_env_cmd,equation_star_code);
  primitive("endmath",end_math_env_cmd,math_code);
  primitive("enddisplaymath",end_math_env_cmd,displaymath_code);
  primitive("tralics@pop@section",end_RAsection_env_cmd);
  primitive("endtabular",end_tabular_env_cmd,zero_code);
  primitive("endtabular*",end_tabular_env_cmd,one_code);
  primitive("endverbatim",end_verbatim_env_cmd,zero_code);
  primitive("endVerbatim",end_Verbatim_env_cmd,zero_code);
  primitive("endminipage",end_minipage_cmd);
  primitive("endpicture",end_picture_env_cmd);
  primitive("endfilecontents",end_filecontents_env_cmd);
  primitive("endfilecontents*",end_filecontents_env_cmd,one_code);
  primitive("endxmlelement",end_xmlelement_env_cmd);
  primitive("endxmlelement*",end_xmlelement_env_cmd,one_code);
  primitive("endxmlelement+",end_xmlelement_env_cmd,two_code);
  begin_token = primitive("begin",begin_cmd);
  end_token = primitive("end",end_cmd);
  primitive("cal",math_font_cmd,cal_code);
  primitive("mathtt",math_font_cmd,mathtt_code);
  primitive("mathcal",math_font_cmd,mathcal_code);
  primitive("mathbf",math_font_cmd,mathbf_code);
  primitive("mathrm",math_font_cmd,mathrm_code);
  primitive("mathit",math_font_cmd,mathit_code);
  primitive("mathbb",math_font_cmd,mathbb_code);
  primitive("mathsf",math_font_cmd,mathsf_code);
  primitive("mathfrak",math_font_cmd,mathfrak_code);
  primitive("mathnormal",math_font_cmd,mathnormal_code);
  primitive("left",left_cmd);
  primitive("right",right_cmd);

  primitive("leavevmode",leave_v_mode_cmd);
  primitive("epsfbox",epsfbox_cmd,zero_code);
  primitive("put",put_cmd,put_code);
  primitive("line",put_cmd,line_code);
  primitive("vector",put_cmd,vector_code);
  primitive("oval",put_cmd,oval_code);
  primitive("multiput",put_cmd,multiput_code);
  primitive("frame",put_cmd,frame_code);
  primitive("dashbox",fbox_cmd,dashbox_code);
  // From curves.plt
  primitive("curves@arc",curves_cmd, arc_code);
  primitive("curves@bezier",bezier_cmd,zero_code);
  primitive("curves@bigcircle",curves_cmd, bigcircle_code);
  primitive("curves@closecurve",curves_cmd,closecurve_code);
  primitive("curves@curve",curves_cmd, curve_code);
  primitive("curves@tagcurve",curves_cmd, tagcurve_code);
  primitive("curves@scaleput",put_cmd,scaleput_code);
  // other commands
  primitive("qbezier",bezier_cmd,one_code);
  primitive("dashline",dashline_cmd,dashline_code);
  primitive("drawline",dashline_cmd,drawline_code);
  primitive("dottedline",dashline_cmd,dottedline_code);
  primitive("circle",dashline_cmd,circle_code);
  primitive("thicklines",thickness_cmd,thicklines_code);
  primitive("thinlines",thickness_cmd,thinlines_code);
  primitive("linethickness",thickness_cmd,linethickness_code);
  primitive("sloppy",ignore_cmd,sloppy_code);
  primitive("fussy",ignore_cmd,fussy_code);
  primitive("subitem",ignore_cmd,subitem_code);
  //  primitive("htmlimage",ignore_cmd,htmlimage_code);
  primitive("immediate",ignore_cmd,immediate_code);
  primitive("unpenalty",ignore_cmd,unpenalty_code);
  primitive("unkern",ignore_cmd,unkern_code);
  primitive("unskip",ignore_cmd,unskip_code);
  primitive("@addnl",ignore_cmd,addnl_code);
  primitive("@",ignore_cmd,atsign_code);
  primitive("/",ignore_cmd,italiccorr_code);
  primitive("newpage",ignoreA_cmd,newpage_code);
  primitive("hrulefill",ignoreA_cmd,hrulefill_code);
  primitive("dotfill",ignoreA_cmd,dotfill_code);
  primitive("samepage",ignoreA_cmd,samepage_code);
  primitive("clearpage",ignoreA_cmd,clearpage_code);
  primitive("cleardoublepage",ignoreA_cmd,cleardoublepage_code);
  primitive("break", ignore_cmd, break_code);
  primitive("nobreak", ignore_cmd, nobreak_code);
  allowbreak_token = primitive("allowbreak", specimp_cmd, allowbreak_code);
  primitive("filbreak", ignorep_cmd, fillbreak_code);
  primitive("goodbreak", ignorep_cmd, goodbreak_code);
  primitive("eject", ignorep_cmd, eject_code);
  primitive("smallbreak", ignorep_cmd, smallbreak_code);
  primitive("medbreak", ignorep_cmd, medbreak_code);
  primitive("bigbreak", ignorep_cmd, bigbreak_code);
  primitive("nointerlineskip", ignore_cmd, nointerlineskip_code);
  primitive("offinterlineskip", ignore_cmd, offinterlineskip_code);
  primitive("frenchspacing", ignore_cmd, frenchspacing_code);
  primitive("nonfrenchspacing", ignore_cmd, nonfrenchspacing_code);
  primitive("showoverfull", ignore_cmd, showoverfull_code);
  primitive("loggingoutput", ignore_cmd, loggingoutput_code);
  primitive("showoutput", ignore_cmd, showoutput_code);
  primitive("nofiles", ignore_cmd, nofiles_code);
  primitive("raggedbottom", ignore_cmd,raggedbottom_code);
  primitive("flushbottom", ignore_cmd,flushbottom_code);
  primitive("onecolumn", ignore_cmd,onecolumn_code);
  primitive("twocolumn", ignore_cmd,twocolumn_code);
  primitive("normalmarginpar", ignore_cmd,normalmarginpar_code);
  primitive("reversemarginpar", ignore_cmd,reversemarginpar_code);
  primitive("normalbaselines", ignore_cmd,normalbaselines_code);
  primitive("removelastskip", ignore_cmd,removelastskip_code);
  primitive("vglue",vglue_cmd);
  primitive("hglue",vglue_cmd,one_code);
  primitive("zap@space",zapspace_cmd);
  primitive("zap@fl@space",zapspace_cmd,one_code);
  primitive("strip@prefix",stripprefix_cmd);
  primitive("hexnumber@",hexnumber_cmd);
  primitive("selectfont", selectfont_cmd);
  primitive("usefont", usefont_cmd);
  primitive("in@", isin_cmd);
  primitive("multispan",multispan_cmd);
  primitive("listfiles",listfiles_cmd);
  primitive("leftline",line_cmd,leftline_code);
  primitive("rightline",line_cmd,rightline_code);
  primitive("centerline",line_cmd,centerline_code);
  primitive("llap",line_cmd,llap_code);
  primitive("rlap",line_cmd,rlap_code);
  relax_token = primitive("relax",relax_cmd,relax_code);
  genfrac_mode[4] = relax_token;
  primitive("bibliographystyle",bibliographystyle_cmd);
  primitive("insertbibliohere",insertbibliohere_cmd);
  primitive("syntaxonly",inhibit_xml_cmd);
  primitive("footcitepre",footcitepre_cmd);
  primitive("RAlabel",ignore_one_argument_cmd,RAlabel_code);
  primitive("hyphenation",ignore_one_argument_cmd,hyphenation_code);
  primitive("patterns",ignore_one_argument_cmd,patterns_code);
  primitive("special",ignore_one_argument_cmd,special_code);
  primitive("includeonly",ignore_one_argument_cmd,includeonly_code);
  primitive("showhyphens",ignore_one_argument_cmd,showhyphens_code);
  //  primitive("HTMLset",ignore_two_argument_cmd,HTMLset_code);
  primitive("fontsize",ignore_two_argument_cmd,fontsize_code);
  primitive("fontencoding",ltfont_cmd,fontencoding_code);
  primitive("fontfamily",ltfont_cmd,fontfamily_code);
  primitive("fontseries",ltfont_cmd,fontseries_code);
  primitive("fontshape",ltfont_cmd,fontshape_code);
  primitive("discretionary",specimp_cmd,discretionary_code);
  primitive("DefineVerbatimEnvironment",defineverbatimenv_cmd);
  primitive("SaveVerb",saveverb_cmd);
  primitive("define@key",xkeyval_cmd,definekey_code);
  primitive("KVO@family@set",kvo_family_cmd,kvo_fam_set_code);
  primitive("KVO@family",kvo_family_cmd,kvo_fam_get_code);
  primitive("KVO@prefix@set",kvo_family_cmd,kvo_pre_set_code);
  primitive("KVO@prefix",kvo_family_cmd,kvo_pre_get_code);
  primitive("KVO@boolkey",kvo_family_cmd,kvo_boolkey_code);
  primitive("KVO@voidkey",kvo_family_cmd,kvo_voidkey_code);
  primitive("DeclareDefaultOption",kvo_family_cmd,kvo_decdef_code);
  primitive("ProcessKeyvalOptions",kvo_family_cmd,kvo_process_code);
  primitive("DeclareBoolOption",kvo_family_cmd,kvo_bool_opt_code);
  primitive("DeclareStringOption",kvo_family_cmd,kvo_string_opt_code);
  primitive("DeclareVoidOption",kvo_family_cmd,kvo_void_opt_code);
  primitive("DeclareComplementaryOption",kvo_family_cmd,kvo_comp_opt_code);
  primitive("tralics@boot@keyval",xkeyval_cmd,boot_keyval_code);
  primitive("makeatletter",makeatletter_cmd);
  primitive("makeatother",makeatother_cmd);
  primitive("numberedverbatim", numberedverbatim_cmd);
  primitive("unnumberedverbatim",unnumberedverbatim_cmd);
  primitive("afterassignment",after_assignment_cmd);
  primitive("unhbox",un_box_cmd,unhbox_code);
  primitive("unhcopy",un_box_cmd,unhcopy_code);
  primitive("unvbox",un_box_cmd,unvbox_code);
  primitive("unvcopy",un_box_cmd,unvcopy_code);

  primitive("openout",extension_cmd,openout_code);
  primitive("write",extension_cmd,write_code); 
  primitive("closeout",extension_cmd,closeout_code);
  primitive("setlanguage",setlanguage_cmd);
  primitive("show",xray_cmd,show_code);
  primitive("showbox",xray_cmd,showbox_code);
  primitive("showthe",xray_cmd,showthe_code);
  primitive("showlists",xray_cmd,showlists_code);
  primitive("moveleft",move_cmd,moveleft_code);
  primitive("moveright",move_cmd,moveright_code);
  primitive("raise",move_cmd,raise_code);
  primitive("lower",move_cmd,lower_code);
  primitive("shipout",leader_ship_cmd,shipout_code);
  primitive("leaders",leader_ship_cmd,leaders_code);
  primitive("cleaders",leader_ship_cmd,cleaders_code);
  primitive("xleaders",leader_ship_cmd,xleaders_code);
  primitive("tracingall",tracingall_cmd);
  primitive("loggingall",tracingall_cmd);
  primitive("newif",newif_cmd);
  primitive("newcount",newcount_cmd,newcount_code);
  primitive("newtoks",newcount_cmd,newtoks_code);
  primitive("newbox",newcount_cmd,newbox_code);
  primitive("newdimen",newcount_cmd,newdimen_code);
  primitive("newlength",newcount_cmd,newlength_code);
  primitive("newskip",newcount_cmd,newlength_code);
  primitive("newmuskip",newcount_cmd,newmuskip_code);
  primitive("newread",newcount_cmd,newread_code);
  primitive("newwrite",newcount_cmd,newwrite_code);
  primitive("newlanguage",newcount_cmd,newlanguage_code);

  primitive("newcounter",newcounter_cmd);
  primitive("newboolean",newboolean_cmd,zero_code);
  primitive("provideboolean",newboolean_cmd,one_code);
  primitive("setboolean",setboolean_cmd);
  primitive("ifthenelse",ifthenelse_cmd);
  primitive("whiledo",whiledo_cmd);
  primitive("DefineShortVerb", shortverb_cmd,zero_code);
  primitive("UndefineShortVerb", shortverb_cmd,one_code);
  primitive("aftergroup",aftergroup_cmd);
  arabic_token = primitive("arabic",latex_ctr_cmd,arabic_code);
  roman_token=primitive("roman",latex_ctr_cmd,roman_code);
  Roman_token=primitive("Roman",latex_ctr_cmd,Roman_code);
  alph_token= primitive("alph",latex_ctr_cmd,alph_code);
  Alph_token=primitive("Alph",latex_ctr_cmd,Alph_code);
  primitive("fnsymbol",latex_ctr_cmd,fnsymbol_code);
  atalph_token=  primitive("@alph",latex_ctr_cmd,at_alph_code);
  atAlph_token=  primitive("@Alph",latex_ctr_cmd,at_Alph_code);
  fnsymbol_token= primitive("@fnsymbol",latex_ctr_cmd,at_fnsymbol_code);
  primitive("@ifundefined", ifundefined_cmd);
  primitive("tralics@ifundefined", ifundefined_cmd,one_code);
  primitive("@ifstar", ifstar_cmd);
  primitive("@ifnextchar", ifnextchar_cmd);
  primitive("@ifnextcharacter", ifnextchar_cmd,one_code);
  primitive("@iftempty", ifempty_cmd,zero_code);
  primitive("@ifbempty", ifempty_cmd,one_code);
  primitive("typeout", typeout_cmd,zero_code);
  primitive("wlog", typeout_cmd,one_code);
  // min_internal here...
  primitive("lastpenalty",last_item_cmd,lastpenalty_code);
  primitive("lastkern",last_item_cmd,lastkern_code);
  primitive("lastskip",last_item_cmd,lastskip_code);
  primitive("inputlineno",last_item_cmd,inputlineno_code);
  primitive("badness",last_item_cmd,badness_code);
  // max_non_prefixed here
  primitive("toks",toks_register_cmd);
  primitive("output",assign_toks_cmd,output_code);
  primitive("everybibitem",assign_toks_cmd,everybibitem_code);
  primitive("everypar",assign_toks_cmd,everypar_code);
  primitive("everymath",assign_toks_cmd,everymath_code);
  primitive("everydisplay",assign_toks_cmd,everydisplay_code);
  primitive("everyhbox",assign_toks_cmd,everyhbox_code);
  primitive("everyvbox",assign_toks_cmd,everyvbox_code);
  primitive("everyjob",assign_toks_cmd,everyjob_code);
  primitive("everycr",assign_toks_cmd,everycr_code);
  primitive("everyxbox",assign_toks_cmd,everyxbox_code);
  primitive("errhelp",assign_toks_cmd,errhelp_code);
  primitive("pretolerance",assign_int_cmd,pretolerance_code);
  primitive("tolerance",assign_int_cmd,tolerance_code);
  primitive("hbadness",assign_int_cmd,hbadness_code);
  primitive("vbadness",assign_int_cmd,vbadness_code);
  primitive("linepenalty",assign_int_cmd,linepenalty_code);
  primitive("hyphenpenalty",assign_int_cmd,hyphenpenalty_code);
  primitive("exhyphenpenalty",assign_int_cmd,exhyphenpenalty_code);
  primitive("binoppenalty",assign_int_cmd,binoppenalty_code);
  primitive("relpenalty",assign_int_cmd,relpenalty_code);
  primitive("clubpenalty",assign_int_cmd,clubpenalty_code);
  primitive("widowpenalty",assign_int_cmd,widowpenalty_code);
  primitive("displaywidowpenalty", assign_int_cmd,displaywidowpenalty_code);
  primitive("brokenpenalty",assign_int_cmd,brokenpenalty_code);
  primitive("predisplaypenalty",assign_int_cmd,predisplaypenalty_code);
  primitive("postdisplaypenalty",assign_int_cmd,postdisplaypenalty_code);
  primitive("interlinepenalty",assign_int_cmd,interlinepenalty_code);
  primitive("floatingpenalty",assign_int_cmd,floatingpenalty_code);
  primitive("outputpenalty",assign_int_cmd,outputpenalty_code);
  primitive("doublehyphendemerits",  assign_int_cmd,doublehyphendemerits_code);
  primitive("finalhyphendemerits",  assign_int_cmd,finalhyphendemerits_code);
  primitive("adjdemerits",assign_int_cmd,adjdemerits_code);
  primitive("looseness",assign_int_cmd,looseness_code);
  primitive("pausing",assign_int_cmd,pausing_code);
  primitive("holdinginserts",assign_int_cmd,holdinginserts_code);
  primitive("tracingonline",assign_int_cmd,tracingonline_code);
  primitive("tracingmacros",assign_int_cmd,tracingmacros_code);
  primitive("tracingstats",assign_int_cmd,tracingstats_code);
  primitive("tracingparagraphs",assign_int_cmd,tracingparagraphs_code);
  primitive("tracingpages",assign_int_cmd,tracingpages_code);
  primitive("tracingoutput",assign_int_cmd,tracingoutput_code);
  primitive("tracinglostchars",assign_int_cmd,tracinglostchars_code);
  primitive("tracingcommands",assign_int_cmd,tracingcommands_code);
  primitive("tracingrestores",assign_int_cmd,tracingrestores_code);
  primitive("tracingmath",assign_int_cmd,tracingmath_code);
  primitive("language",assign_int_cmd,language_code);
  primitive("uchyph",assign_int_cmd,uchyph_code);
  primitive("lefthyphenmin",assign_int_cmd,lefthyphenmin_code);
  primitive("righthyphenmin",assign_int_cmd,righthyphenmin_code);
  primitive("globaldefs",assign_int_cmd,globaldefs_code);
  primitive("defaulthyphenchar",assign_int_cmd,defaulthyphenchar_code);
  primitive("defaultskewchar",assign_int_cmd,defaultskewchar_code);
  primitive("escapechar",assign_int_cmd,escapechar_code);
  primitive("endlinechar",assign_int_cmd,endlinechar_code);
  primitive("newlinechar",assign_int_cmd,newlinechar_code);
  primitive("maxdeadcycles",assign_int_cmd,maxdeadcycles_code);
  primitive("hangafter",assign_int_cmd,hangafter_code);
  primitive("fam",assign_int_cmd,fam_code);
  primitive("mag",assign_int_cmd,mag_code);
  primitive("delimiterfactor",assign_int_cmd,delimiterfactor_code);
  primitive("time",assign_int_cmd,time_code);
  primitive("day",assign_int_cmd,day_code);
  primitive("month",assign_int_cmd,month_code);
  primitive("year",assign_int_cmd,year_code);
  primitive("@nomathml",assign_int_cmd,nomath_code);
  primitive("@curmathfont",assign_int_cmd,math_font_pos);
  primitive("notrivialmath",assign_int_cmd,notrivialmath_code);
  primitive("showboxbreadth",assign_int_cmd,showboxbreadth_code);
  primitive("showboxdepth",assign_int_cmd,showboxdepth_code);
  mathversion_token =
    primitive("@mathversion",assign_int_cmd,atmathversion_code);
  primitive("tralics@use@subfigure",assign_int_cmd,use_subfigure_code);
  primitive("XMLlastid",last_item_cmd,xmllastid_code);
  primitive("XMLcurrentid",last_item_cmd,xmlcurrentid_code);
  primitive("errorcontextlines",assign_int_cmd,errorcontextlines_code);
  primitive("hfuzz",assign_dimen_cmd,hfuzz_code);
  primitive("vfuzz",assign_dimen_cmd,vfuzz_code);
  primitive("overfullrule",assign_dimen_cmd,overfullrule_code);
  primitive("emergencystretch",assign_dimen_cmd,emergencystretch_code);
  primitive("hsize",assign_dimen_cmd,hsize_code);
  primitive("vsize",assign_dimen_cmd,vsize_code);
  primitive("maxdepth",assign_dimen_cmd,maxdepth_code);
  primitive("splitmaxdepth",assign_dimen_cmd,splitmaxdepth_code);
  primitive("boxmaxdepth",assign_dimen_cmd,boxmaxdepth_code);
  primitive("lineskiplimit",assign_dimen_cmd,lineskiplimit_code);
  primitive("delimitershortfall", assign_dimen_cmd,delimitershortfall_code);
  primitive("nulldelimiterspace",  assign_dimen_cmd,nulldelimiterspace_code);
  primitive("scriptspace",assign_dimen_cmd,scriptspace_code);
  primitive("mathsurround",assign_dimen_cmd,mathsurround_code);
  primitive("predisplaysize",assign_dimen_cmd,predisplaysize_code);
  primitive("displaywidth",assign_dimen_cmd,displaywidth_code);
  primitive("displayindent",assign_dimen_cmd,displayindent_code);
  primitive("parindent",assign_dimen_cmd,parindent_code);
  primitive("hangindent",assign_dimen_cmd,hangindent_code);
  primitive("hoffset",assign_dimen_cmd,hoffset_code);
  primitive("voffset",assign_dimen_cmd,voffset_code);
  unitlength_token = 
    primitive("unitlength",assign_dimen_cmd,unitlength_code);
  primitive("textheight",assign_dimen_cmd,textheight_code);
  primitive("textwidth",assign_dimen_cmd,textwidth_code);
  primitive("linewidth",assign_dimen_cmd,linewidth_code);
  primitive("columnwidth",assign_dimen_cmd,columnwidth_code);

  primitive("lineskip",assign_glue_cmd,lineskip_code);
  primitive("baselineskip",assign_glue_cmd,baselineskip_code);
  primitive("parskip",assign_glue_cmd,parskip_code);
  primitive("abovedisplayskip",assign_glue_cmd,abovedisplayskip_code);
  primitive("belowdisplayskip",assign_glue_cmd,belowdisplayskip_code);
  primitive("abovedisplayshortskip",assign_glue_cmd,abovedisplayshortskip_code);
  primitive("belowdisplayshortskip", assign_glue_cmd,belowdisplayshortskip_code);
  primitive("leftskip",assign_glue_cmd,leftskip_code);
  primitive("rightskip",assign_glue_cmd,rightskip_code);
  primitive("topskip",assign_glue_cmd,topskip_code);
  primitive("splittopskip",assign_glue_cmd,splittopskip_code);
  primitive("tabskip",assign_glue_cmd,tabskip_code);
  primitive("spaceskip",assign_glue_cmd,spaceskip_code);
  primitive("xspaceskip",assign_glue_cmd,xspaceskip_code);
  primitive("parfillskip",assign_glue_cmd,parfillskip_code);
  primitive("thinmuskip",assign_mu_glue_cmd,thinmuskip_code);
  primitive("medmuskip",assign_mu_glue_cmd,medmuskip_code);
  primitive("thickmuskip",assign_mu_glue_cmd,thickmuskip_code);
  primitive("fontdimen",assign_font_dimen_cmd,subtypes(0));
  primitive("hyphenchar",assign_font_int_cmd,subtypes(0));
  primitive("input@encoding@val",assign_enc_char_cmd);
  primitive("skewchar",assign_font_int_cmd,subtypes(1));
  primitive("spacefactor",set_aux_cmd,subtypes(0));
  primitive("prevdepth",set_aux_cmd,subtypes(1));
  primitive("input@encoding",set_aux_cmd,subtypes(2));
  primitive("input@encoding@default",set_aux_cmd,subtypes(3));
  primitive("@xfontsize", set_aux_cmd,subtypes(4));
  primitive("prevgraf",set_prev_graf_cmd);
  primitive("pagegoal",set_page_dimen_cmd,pagegoal_code);
  primitive("pagetotal",set_page_dimen_cmd,pagetotal_code);
  primitive("pagestretch",set_page_dimen_cmd,pagestretch_code);
  primitive("pagefilstretch",set_page_dimen_cmd,pagefilstretch_code);
  primitive("pagefillstretch",set_page_dimen_cmd,pagefillstretch_code);
  primitive("pagefilllstretch",set_page_dimen_cmd,pagefilllstretch_code);
  primitive("pageshrink",set_page_dimen_cmd,pageshrink_code);
  primitive("pagedepth",set_page_dimen_cmd,pagedepth_code);
  primitive("deadcycles",set_page_int_cmd,deadcycles_code);
  primitive("insertpenalties",set_page_int_cmd,insertpenalties_code);
  primitive("wd",set_box_dimen_cmd,wd_code);
  primitive("ht",set_box_dimen_cmd,ht_code);
  primitive("dp",set_box_dimen_cmd,dp_code);
  primitive("parshape",set_shape_cmd,parshape_code);
  primitive("catcode",def_code_cmd,subtypes(0));
  primitive("mathcode",def_code_cmd,math_code_offset);
  primitive("lccode",def_code_cmd,lc_code_offset);
  primitive("uccode",def_code_cmd,uc_code_offset);
  primitive("sfcode",def_code_cmd,sf_code_offset);
  primitive("delcode",def_code_cmd,del_code_offset);
  primitive("textfont",def_family_cmd,textfont_code);
  primitive("scriptfont",def_family_cmd,scriptfont_code);
  primitive("scriptscriptfont",def_family_cmd,scriptscriptfont_code);
  primitive("nullfont",set_font_cmd);
  primitive("font",def_font_cmd);
  primitive("mathfontproperty",set_mathprop_cmd);
  primitive("setmathchar",set_mathchar_cmd);
  primitive("count",register_cmd,subtypes(it_int));
  primitive("dimen",register_cmd,subtypes(it_dimen));
  primitive("skip",register_cmd,subtypes(it_glue));
  primitive("muskip",register_cmd,subtypes(it_mu));

  // max_internal
  advance_token=  primitive("advance",advance_cmd);
  primitive("multiply",multiply_cmd);
  primitive("divide",divide_cmd);
  global_token=  primitive("global",prefix_cmd,global_code);
  primitive("long",prefix_cmd,long_code);
  primitive("outer",prefix_cmd,outer_code);
  let_token=  primitive("let", let_cmd,let_code);
  primitive("futurelet", let_cmd,futurelet_code);
  primitive("chardef",shorthand_def_cmd,char_def_code);
  primitive("mathchardef",shorthand_def_cmd,math_char_def_code);
  primitive("countdef",shorthand_def_cmd,count_def_code);
  primitive("dimendef",shorthand_def_cmd,dimen_def_code);
  primitive("skipdef",shorthand_def_cmd,skip_def_code);
  primitive("muskipdef",shorthand_def_cmd,mu_skip_def_code);
  primitive("toksdef",shorthand_def_cmd,toks_def_code);
  primitive("read",read_to_cs_cmd, zero_code);
  primitive("xdef", def_cmd,xdef_code);
  def_token = primitive("def", def_cmd,def_code);
  primitive("gdef", def_cmd,gdef_code);
  primitive("edef", def_cmd,edef_code);
  primitive("newcommand", def_cmd,newcommand_code);
  primitive("CheckCommand", def_cmd,checkcommand_code);
  primitive("newtheorem", def_cmd,newthm_code);
  primitive("newenvironment", def_cmd,newenv_code);
  primitive("renewenvironment", def_cmd,renewenv_code);
  primitive("renewcommand", def_cmd,renew_code);
  primitive("providecommand", def_cmd,provide_code);
  primitive("DeclareMathOperator", def_cmd,declare_math_operator_code);
  primitive("DeclareRobustCommand", def_cmd,provide_code);
  primitive("setbox",set_box_cmd);
  primitive("@setmode",setmode_cmd);
  primitive("theoremstyle",thm_aux_cmd,theorem_style_code);
  primitive("theorembodyfont",thm_aux_cmd,theorem_bodyfont_code);
  primitive("theoremheaderfont",thm_aux_cmd,theorem_headerfont_code);
  bth_token = primitive("@begintheorem",start_thm_cmd,zero_code);
  primitive("@ybegintheorem",start_thm_cmd,zero_code);
  primitive("@xbegintheorem",start_thm_cmd,one_code);
  eth_token = primitive("@endtheorem",start_thm_cmd,two_code);
  primitive("batchmode",set_interaction_cmd,batchmode_code);
  primitive("nonstopmode",set_interaction_cmd,nonstopmode_code);
  primitive("scrollmode",set_interaction_cmd,scrollmode_code);
  primitive("errorstopmode",set_interaction_cmd,errorstopmode_code);
  primitive("@car",car_cmd,zero_code);
  primitive("@cdr",car_cmd,one_code);
  primitive("@testopt",testopt_cmd);
  primitive("@cons",cons_cmd);
  primitive("@afterfi",afterfi_cmd);
  primitive("@afterelsefi",afterelsefi_cmd);
  primitive("typein",typein_cmd);
  primitive("@gobble",gobble_cmd, subtypes(1));
  primitive("@gobbletwo",gobble_cmd, subtypes(2));
  primitive("@gobblefour",gobble_cmd, subtypes(4));
  // maxcommand
  primitive("xspace",xspace_cmd);
  primitive("the",the_cmd,the_code);
  primitive("strip@pt",strippt_cmd,the_code);
  number_token =  primitive("number",convert_cmd,number_code);
  primitive("two@digits",convert_cmd,twodigits_code);
  primitive("@arabic",convert_cmd,at_arabic_code);
  roman_numeral_token = 
    primitive("romannumeral",convert_cmd,romannumeral_code);
  Roman_numeral_token = 
    primitive("Romannumeral",convert_cmd,Romannumeral_code);
  primitive("string",convert_cmd,string_code);
  primitive("meaning",convert_cmd,meaning_code);
  primitive("fontname",convert_cmd,fontname_code);
  primitive("jobname",convert_cmd,jobname_code);
  primitive("XMLgetatt",convert_cmd,attributeval_code);
  primitive("ra@jobname",convert_cmd,ra_jobname_code);
  primitive("tralicsversion",convert_cmd,tralicsversion_code);
  primitive("ra@year",convert_cmd,rayear_code);
  primitive("@onelevel@sanitize",convert_cmd,sanitize_code);
  primitive("[",obracket_cmd);
  primitive("]",obracket_cmd,one_code);
  primitive("(",oparen_cmd);
  primitive(")",oparen_cmd,one_code);
  csname_token = primitive("csname",csname_cmd);
  expandafter_token=  primitive("expandafter",expandafter_cmd);
  primitive("noexpand", noexpand_cmd); 
  primitive("@scanupdown", scanupdown_cmd);
  primitive("sideset", sideset_cmd);
  primitive("tralics@split", split_cmd);
  primitive("a",a_cmd);
  primitive("'", accent_cmd,subtypes('\''));
  primitive("`",accent_cmd,subtypes('`'));
  primitive("\"",accent_cmd,subtypes('"'));
  primitive("^",accent_cmd,subtypes('^'));
  primitive("~",accent_cmd,subtypes('~'));
  primitive("k",accent_cmd,subtypes('k'));
  primitive("H",accent_cmd,subtypes('H'));
  primitive("v",accent_cmd,subtypes('v'));
  primitive("b",accent_cmd,subtypes('b'));
  primitive("d",accent_cmd,subtypes('d'));
  primitive("u",accent_cmd,subtypes('u'));
  primitive("C",accent_cmd,subtypes('C'));
  primitive("f",accent_cmd,subtypes('f'));
  primitive("c",accent_cmd,subtypes('c'));
  primitive(".",accent_cmd,subtypes('.'));
  primitive("=",accent_cmd,subtypes('='));
  primitive("r",accent_cmd,subtypes('r'));
  primitive("T",accent_cmd,subtypes('T'));
  primitive("V",accent_cmd,subtypes('V'));
  primitive("D",accent_cmd,subtypes('D'));
  primitive("h",accent_cmd,subtypes('h'));
  // Other accent
  primitive("IJ",specchar_cmd,subtypes(0x132));
  primitive("ij",specchar_cmd,subtypes(0x133));
  primitive("l",specchar_cmd,subtypes(0x142));
  primitive("L",specchar_cmd,subtypes(0x141));
  primitive("ng",specchar_cmd,subtypes(0x14B));
  primitive("NG",specchar_cmd,subtypes(0x14A));
  primitive("OE",specchar_cmd,subtypes(0x152));
  primitive("oe",specchar_cmd,subtypes(0x153));

  primitive("loop",loop_cmd);
  killcounter_token =  primitive("@stpelt",counter_cmd,killcounter_code);
  stepcounter_token=primitive("stepcounter",counter_cmd,stepcounter_code);
  primitive("addtocounter",counter_cmd,addtocounter_code);
  primitive("setcounter",counter_cmd,setcounter_code);
  primitive("value",counter_cmd,value_code);
  primitive("@addtoreset",counter_cmd,addtoreset_code);
  primitive("setlength",setlength_cmd,zero_code);
  primitive("addtolength",setlength_cmd,one_code);
  primitive("UseVerb",useverb_cmd);
  primitive("@firstofone",first_of_one_cmd);
  primitive("@firstoftwo",first_of_two_cmd,one_code);
  primitive("@secondoftwo",first_of_two_cmd,two_code);
  composite_token = primitive("@unicode@composite",first_of_one_cmd);
  primitive("tipa@star",ipa_cmd,subtypes(0));
  primitive("tipa@semi",ipa_cmd,subtypes(1));
  primitive("tipa@colon",ipa_cmd,subtypes(2));
  primitive("tipa@exclam",ipa_cmd,subtypes(3));
  primitive("tipa@normal",ipa_cmd,subtypes(4));
  primitive("tipa@syllabic",ipa_cmd,subtypes(5));
  primitive("tipa@subumlaut",ipa_cmd,subtypes(6));
  primitive("tipa@subtilde",ipa_cmd,subtypes(7));
  primitive("tipa@subring",ipa_cmd,subtypes(8));
  primitive("tipa@dotacute",ipa_cmd,subtypes(9));
  primitive("tipa@gravedot",ipa_cmd,subtypes(10));
  primitive("tipa@acutemacron",ipa_cmd,subtypes(11));
  primitive("tipa@circumdot",ipa_cmd,subtypes(12));
  primitive("tipa@tildedot",ipa_cmd,subtypes(13));
  primitive("tipa@brevemacro",ipa_cmd,subtypes(14));


  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  primitive("@whilenum",while_cmd,zero_code);
  primitive("@whiledim",while_cmd,one_code);
  primitive("@whilesw",while_cmd,two_code);
  iwhilenum_token = primitive("@iwhilenum",iwhile_cmd,zero_code);
  iwhiledim_token = primitive("@iwhiledim",iwhile_cmd,one_code);
  iwhilesw_token = primitive("@iwhilesw",iwhile_cmd,two_code);
  do_token = locate("do");
  doubleat_token = locate("@@");

  primitive("if",if_test_cmd,if_char_code);
  primitive("ifcat",if_test_cmd,if_cat_code);
  ifnum_token = primitive("ifnum",if_test_cmd,if_int_code);
  ifdim_token = primitive("ifdim",if_test_cmd,if_dim_code);
  primitive("ifodd",if_test_cmd,if_odd_code);
  primitive("ifvmode",if_test_cmd,if_vmode_code);
  primitive("ifhmode",if_test_cmd,if_hmode_code);
  primitive("ifmmode",if_test_cmd,if_mmode_code);
  primitive("ifinner",if_test_cmd,if_inner_code);
  primitive("ifvoid",if_test_cmd,if_void_code);
  primitive("ifhbox",if_test_cmd,if_hbox_code);
  primitive("ifvbox",if_test_cmd,if_vbox_code);
  primitive("ifx",if_test_cmd,ifx_code);
  primitive("ifeof",if_test_cmd,if_eof_code);
  primitive("ifleapyear",if_test_cmd,if_leapyear_code);
  iftrue_token =  primitive("iftrue",if_test_cmd,if_true_code);
  iffalse_token =  primitive("iffalse",if_test_cmd,if_false_code);
  primitive("ifcase",if_test_cmd,if_case_code);
  fi_token =  primitive("fi",fi_or_else_cmd,fi_code);
  repeat_token=  primitive("repeat",fi_or_else_cmd,fi_code);
  or_token=  primitive("or",fi_or_else_cmd,or_code);
  else_token=  primitive("else",fi_or_else_cmd,else_code);
  primitive("ChangeElementName",change_element_name_cmd);
  primitive("verb",verb_cmd);
  verb_token = primitive(" verb",verb_cmd,one_code);
  primitive("topmark",top_bot_mark_cmd,topmark_code);
  primitive("firstmark",top_bot_mark_cmd,firstmark_code);
  primitive("botmark",top_bot_mark_cmd,botmark_code);
  primitive("splitfirstmark",top_bot_mark_cmd,splitfirstmark_code);
  primitive("splitbotmark",top_bot_mark_cmd,splitbotmark_code);
  primitive("ClassError",latex_error_cmd,classerror_code);
  primitive("ClassWarning",latex_error_cmd,classwarning_code);
  primitive("ClassWarningNoLine",latex_error_cmd,classwarningnoline_code);
  primitive("ClassInfo",latex_error_cmd,classinfo_code);
  primitive("PackageError",latex_error_cmd,packageerror_code);
  primitive("PackageWarning",latex_error_cmd,packagewarning_code);
  primitive("PackageWarningNoLine",latex_error_cmd,packagewarningnoline_code);
  primitive("PackageInfo",latex_error_cmd,packageinfo_code);
  primitive("GenericError",latex_error_cmd,genericerror_code);
  primitive("GenericInfo",latex_error_cmd,genericinfo_code);
  primitive("GenericWarning",latex_error_cmd,genericwarning_code);
  primitive("MessageBreak",latex_error_cmd,messagebreak_code);
  primitive("@latex@error",latex_error_cmd,latexerror_code);
  primitive("@latex@warning",latex_error_cmd,latexwarning_code);
  primitive("@latex@warning@no@line",latex_error_cmd,latexwarningnoline_code);
  primitive("@latex@info",latex_error_cmd,latexinfo_code);
  primitive("@latex@info@no@line",latex_error_cmd,latexinfonoline_code);
  primitive("formatdate",formatdate_cmd);
  primitive("numberwithin",numberwithin_cmd);
  primitive("@ifdefinable", ifdefinable_cmd);
  dblarg_token = primitive("@dblarg",dblarg_cmd);
  refstepcounter_token = primitive("refstepcounter",refstepcounter_cmd);
  makelabel_token=primitive("tralics@makelabel", makelabel_cmd);
  nomathsw0_token = primitive("@nomathswi",nomath_cmd,zero_code);
  nomathsw1_token = primitive("@nomathswii",nomath_cmd,one_code);
  primitive("@nomathsws",nomath_cmd,two_code);
  primitive("@nomathswm",nomath_cmd,three_code);
  primitive("@nomathswe",nomath_cmd,subtypes(4));

  // xkeyval
  primitive("tralics@addtolist@n",add_to_macro_cmd,zero_code);
  primitive("tralics@addtolist@o",add_to_macro_cmd,one_code);
  primitive("@expandtwoargs",expandtwoargs_cmd);
  primitive("@removeelement",removeelement_cmd);
  primitive("tralics@for@n", for_cmd,xkv_for_n_code); 
  primitive("tralics@for@en", for_cmd,xkv_for_en_code); 
  primitive("@for",for_cmd,for_code);
  primitive("@tfor",for_cmd,tfor_code);
  forloop_token=primitive("@forloop", for_cmd,forloop_code);
  iforloop_token=primitive("@iforloop", for_cmd,iforloop_code);
  tforloop_token=primitive("@tforloop", for_cmd,tforloop_code);
  primitive("@break@tfor",for_cmd,breaktfor_code); 
  primitive("tralics@for@break",for_cmd,xkv_breaktfor_code); 
  xkv_for_i_token=primitive("tralics@for@i", for_cmd,xkv_for_i_code);
  primitive("tralics@for@o", for_cmd,xkv_for_o_code);
  primitive("tralics@for@eo", for_cmd,xkv_for_eo_code);
  primitive("@selective@sanitize",selective_sanitize_cmd);
  primitive("definecolor", color_cmd, definecolor_code);
  primitive("normalcolor", color_cmd, normalcolor_code);
  primitive("color", color_cmd, color_code);
  primitive("pagecolor", color_cmd, pagecolor_code);
  primitive("colorbox", color_cmd, colorbox_code);
  primitive("fcolorbox", color_cmd, fcolorbox_code);
  
  isodd_token = locate("isodd");
  verb_prefix_token = locate("verbprefix");
  verbatim_prefix_token = locate("verbatimprefix");
  isundefined_token = locate("isundefined");
  urlfont_token = locate("urlfont");
  lengthtest_token = locate("lengthtest");
  boolean_token = locate("boolean");
  equal_token = locate("equal");
  not_token = locate("not");
  and_token = locate("and");
  NOT_token = locate("NOT");
  AND_token = locate("AND");
  OR_token = locate("OR");
  ratio_token = locate("ratio");
  real_token = locate("real");
  prime_token = locate("prime");
  operatorname_token = locate("operatorname");
  elt_token = locate("@elt");
  nil_token = locate("@nil");
  dagger_token = locate("dagger");
  ddagger_token = locate("ddagger");
  vbar_token = locate("|");
  of_token = primitive("of",self_insert_cmd);
  verbatim_font = locate("verbatimfont");
  verbatim_number_font = locate("verbatimnumberfont");
  gobble_token = locate("@gobble");
  gobbletwo_token = locate("@gobbletwo");
  xscale_token = locate("xscale");
  yscale_token = locate("yscale");
  xscaley_token = locate("xscaley");
  yscalex_token = locate("yscalex");
  refname_token = locate("refname");
  footcite_sep_token = locate("footcitesep");
  footcite_pre_token = locate("footcitepre");
  cite_punct_token = locate("citepunct");
  itemlabel_token = locate("@itemlabel");
  cite_type_token = locate("cite@@type");
  cite_prenote_token = locate("cite@prenote");
  headercr_token = locate("@headercr");
  lbrace_token = locate("lbrace");
  rbrace_token = locate("rbrace");
  tag_token = locate("@tag");
  qquad_token = locate("qquad");
  nocase_e_token=locate("NoCaseChange");
  nocase_i_token=locate("@NoCaseChange");
  cite_e_token=locate("cite");
  cite_i_token=locate("@tc@cite");
  ref_i_token=locate("@tc@ref");
  ensuremath_i_token=locate("@tc@ensuremath");
  label_i_token=locate("@tc@label");
  intrue_token = locate("in@true");
  infalse_token = locate("in@false");
  CurrentOption_token=locate("CurrentOption");
  CurrentOptionKey_token=locate("CurrentOptionKey");
  CurrentOptionValue_token=locate("CurrentOptionValue");
  increqnum_token = locate("incr@eqnum");
  at_zero_token = locate("z@");
  at_one_token = locate("@ne");
}
