/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "uossocket.h"

#define BUFFSIZE	8192

gint uos_sock_init(void){
    return sock_init();
}

gint uos_sock_cleanup(void){
    return sock_cleanup();
}

gint uos_sock_set_io_timeout(guint sec){
    return sock_set_io_timeout(sec);
}

SockInfo *uos_sock_new(const gchar *hostname, gushort port){
    return sock_new(hostname, port);
}

gint uos_sock_set_nonblocking_mode(UosSockInfo *sock, gboolean nonblock){
    return sock_set_nonblocking_mode(sock, nonblock);
}

gboolean uos_sock_is_nonblocking_mode(UosSockInfo *sock){
    return sock_is_nonblocking_mode(sock);
}

gboolean uos_sock_has_read_data(UosSockInfo *sock){
    return sock_has_read_data(sock);
}

guint uos_sock_add_watch(UosSockInfo *sock, GIOCondition condition,
                         UosSockFunc func, gpointer data){
    return sock_add_watch(sock, condition,func, data);
}

guint uos_sock_add_watch_poll(UosSockInfo *sock, GIOCondition condition,
                              UosSockFunc func, gpointer data){
    return sock_add_watch_poll(sock, condition,func, data);
}

struct hostent *uos_my_gethostbyname(const gchar *hostname, gchar **errorchar){
    return my_gethostbyname(hostname, errorchar);
}


UosSockInfo *uos_sock_connect(const gchar *hostname, gushort port, gchar **errorchar){
    return sock_connect(hostname, port, errorchar);
}

#ifdef G_OS_UNIX
gint uos_sock_connect_async(const gchar *hostname, gushort port,
                            UosSockConnectFunc func, gpointer data){
    return sock_connect_async(hostname, port,func, data);
}

gint uos_sock_connect_async_cancel(gint id){
    return sock_connect_async_cancel(id);
}

#endif
#if USE_THREADS
gint uos_sock_connect_async_thread(const gchar *hostname, gushort port){
    return sock_connect_async_thread(hostname, port);
}

gint uos_sock_connect_async_thread_wait(gint id, UosSockInfo **sock){
    return sock_connect_async_thread_wait(id, sock);
}

#endif

gint uos_sock_info_connect(UosSockInfo *sock, gchar **errorchar){
    return sock_info_connect(sock, errorchar);
}

#ifdef G_OS_UNIX
gint uos_sock_info_connect_async(UosSockInfo *sock,
                                 UosSockConnectFunc func, gpointer data){
    return sock_info_connect_async(sock,func, data);
}

#endif
#if USE_THREADS
gint uos_sock_info_connect_async_thread(UosSockInfo *sock){
    return sock_info_connect_async_thread(sock);
}

gint uos_sock_info_connect_async_thread_wait(gint id, UosSockInfo **sock){
    return sock_info_connect_async_thread_wait(id, sock);
}

#endif

/* Basic I/O functions */
gint uos_sock_printf(UosSockInfo *sock, const gchar *format, ...)
{
    va_list args;
    gchar *buf = g_malloc0(BUFFSIZE * sizeof(gchar));
    va_start(args, format);
    g_vsnprintf(buf, BUFFSIZE * sizeof(gchar), format, args);
    va_end(args);
    gint re=sock_printf(sock, "%s", buf);
    g_free(buf);
    return re;
}

gint uos_sock_read(UosSockInfo *sock, gchar *buf, gint len, gchar **errorchar){
    return sock_read(sock, buf, len, errorchar);
}

gint uos_sock_write(UosSockInfo *sock, const gchar *buf, gint len){
    return sock_write(sock, buf, len);
}

gint uos_sock_write_all(UosSockInfo *sock, const gchar *buf, gint len, char **errorchar){
    return sock_write_all(sock, buf, len, errorchar);
}

gint uos_sock_gets(UosSockInfo *sock, gchar *buf, gint len){
    return sock_gets(sock, buf, len);
}

gint uos_sock_getline(UosSockInfo *sock, gchar **line){
    return sock_getline(sock, line);
}

gint uos_sock_puts(UosSockInfo *sock, const gchar *buf){
    return sock_puts(sock, buf);
}

gint uos_sock_peek(UosSockInfo *sock, gchar *buf, gint len){
    return sock_peek(sock, buf, len);
}

gint uos_sock_close(UosSockInfo *sock){
    return sock_close(sock);
}

/* Functions to directly work on FD.  They are needed for pipes */
gint uos_fd_connect_inet(gushort port){
    return fd_connect_inet(port);
}

gint uos_fd_open_inet(gushort port){
    return fd_open_inet(port);
}

gint uos_fd_connect_unix(const gchar *path){
    return fd_connect_unix(path);
}

gint uos_fd_open_unix(const gchar *path){
    return fd_open_unix(path);
}

gint uos_fd_accept(gint sock){
    return fd_accept(sock);
}

gint uos_fd_read(gint sock, gchar *buf, gint len, gboolean *accneedexit, gboolean canexitimmediately, gchar **errorchar){
    return fd_read(sock, buf, len, accneedexit, canexitimmediately, errorchar);
}

gint uos_fd_write(gint sock, const gchar *buf, gint len, gboolean *accneedexit, gchar **errorchar){
    return fd_write(sock, buf, len, accneedexit, errorchar);
}

gint uos_fd_write_all(gint sock, const gchar *buf, gint len, gboolean *accneedexit, gchar **errorchar){
    return fd_write_all(sock, buf, len, accneedexit, errorchar);
}

gint uos_fd_gets(gint sock, gchar *buf, gint len, gboolean *accneedexit, gboolean canexitimediately) {
    return fd_gets(sock, buf, len, accneedexit, canexitimediately);
}

gint uos_fd_gets_canexit(gint sock, gchar *buf, gint len, gboolean canexit, gboolean *accneedexit){
    return fd_gets_canexit(sock, buf, len, canexit, accneedexit);
}

gint uos_fd_getline(gint sock, gchar **line, gboolean *accneedexit){
    return fd_getline(sock, line, accneedexit);
}

gint uos_fd_getline_canexit(gint sock, gchar **line, gboolean canexit, gboolean *accneedexit){
    return fd_getline_canexit(sock, line, canexit, accneedexit);
}

gint uos_fd_close(gint sock){
    return fd_close(sock);
}


/* Functions for SSL */
#if USE_SSL
gint uos_ssl_read(SSL *ssl, gchar *buf, gint len, gboolean *accneedexit, gchar **errorname, gboolean canexitimmediately){
    return ssl_read(ssl, buf, len, accneedexit, errorname, canexitimmediately);
}

gint uos_ssl_write(SSL *ssl, const gchar *buf, gint len, gchar **errorchar){
    return ssl_write(ssl, buf, len, errorchar);
}

gint uos_ssl_write_all(SSL *ssl, const gchar *buf, gint len, gboolean *accneedexit, char **errorchar){
    return ssl_write_all(ssl, buf, len, accneedexit, errorchar);
}

gint uos_ssl_gets(SSL *ssl, gchar *buf, gint len, gboolean *accneedexit, gboolean canexitimmediately){
    return ssl_gets(ssl, buf, len, accneedexit, canexitimmediately);
}

gint uos_ssl_gets_canexit(SSL *ssl, gchar *buf, gint len, gboolean canexit, gboolean *accneedexit){
    return ssl_gets_canexit(ssl, buf, len, canexit, accneedexit);
}

gint uos_ssl_getline(SSL *ssl, gchar **line, gboolean *accneedexit){
    return ssl_getline(ssl, line, accneedexit);
}

gint uos_ssl_getline_canexit(SSL *ssl, gchar **line, gboolean canexit, gboolean *accneedexit){
    return ssl_getline_canexit(ssl, line, canexit, accneedexit);
}

gint uos_ssl_peek(SSL *ssl, gchar *buf, gint len, gboolean *accneedexit, gboolean canexitimmediately){
    return ssl_peek(ssl, buf, len, accneedexit, canexitimmediately);
}

#endif

