// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/cloud/translate/v3beta1/translation_service.proto

package translate

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// State of the job.
type BatchTranslateMetadata_State int32

const (
	// Invalid.
	BatchTranslateMetadata_STATE_UNSPECIFIED BatchTranslateMetadata_State = 0
	// Request is being processed.
	BatchTranslateMetadata_RUNNING BatchTranslateMetadata_State = 1
	// The batch is processed, and at least one item was successfully
	// processed.
	BatchTranslateMetadata_SUCCEEDED BatchTranslateMetadata_State = 2
	// The batch is done and no item was successfully processed.
	BatchTranslateMetadata_FAILED BatchTranslateMetadata_State = 3
	// Request is in the process of being canceled after caller invoked
	// longrunning.Operations.CancelOperation on the request id.
	BatchTranslateMetadata_CANCELLING BatchTranslateMetadata_State = 4
	// The batch is done after the user has called the
	// longrunning.Operations.CancelOperation. Any records processed before the
	// cancel command are output as specified in the request.
	BatchTranslateMetadata_CANCELLED BatchTranslateMetadata_State = 5
)

// Enum value maps for BatchTranslateMetadata_State.
var (
	BatchTranslateMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "SUCCEEDED",
		3: "FAILED",
		4: "CANCELLING",
		5: "CANCELLED",
	}
	BatchTranslateMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"SUCCEEDED":         2,
		"FAILED":            3,
		"CANCELLING":        4,
		"CANCELLED":         5,
	}
)

func (x BatchTranslateMetadata_State) Enum() *BatchTranslateMetadata_State {
	p := new(BatchTranslateMetadata_State)
	*p = x
	return p
}

func (x BatchTranslateMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BatchTranslateMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_translate_v3beta1_translation_service_proto_enumTypes[0].Descriptor()
}

func (BatchTranslateMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_translate_v3beta1_translation_service_proto_enumTypes[0]
}

func (x BatchTranslateMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BatchTranslateMetadata_State.Descriptor instead.
func (BatchTranslateMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{15, 0}
}

// Enumerates the possible states that the creation request can be in.
type CreateGlossaryMetadata_State int32

const (
	// Invalid.
	CreateGlossaryMetadata_STATE_UNSPECIFIED CreateGlossaryMetadata_State = 0
	// Request is being processed.
	CreateGlossaryMetadata_RUNNING CreateGlossaryMetadata_State = 1
	// The glossary was successfully created.
	CreateGlossaryMetadata_SUCCEEDED CreateGlossaryMetadata_State = 2
	// Failed to create the glossary.
	CreateGlossaryMetadata_FAILED CreateGlossaryMetadata_State = 3
	// Request is in the process of being canceled after caller invoked
	// longrunning.Operations.CancelOperation on the request id.
	CreateGlossaryMetadata_CANCELLING CreateGlossaryMetadata_State = 4
	// The glossary creation request was successfully canceled.
	CreateGlossaryMetadata_CANCELLED CreateGlossaryMetadata_State = 5
)

// Enum value maps for CreateGlossaryMetadata_State.
var (
	CreateGlossaryMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "SUCCEEDED",
		3: "FAILED",
		4: "CANCELLING",
		5: "CANCELLED",
	}
	CreateGlossaryMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"SUCCEEDED":         2,
		"FAILED":            3,
		"CANCELLING":        4,
		"CANCELLED":         5,
	}
)

func (x CreateGlossaryMetadata_State) Enum() *CreateGlossaryMetadata_State {
	p := new(CreateGlossaryMetadata_State)
	*p = x
	return p
}

func (x CreateGlossaryMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CreateGlossaryMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_translate_v3beta1_translation_service_proto_enumTypes[1].Descriptor()
}

func (CreateGlossaryMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_translate_v3beta1_translation_service_proto_enumTypes[1]
}

func (x CreateGlossaryMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CreateGlossaryMetadata_State.Descriptor instead.
func (CreateGlossaryMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{24, 0}
}

// Enumerates the possible states that the creation request can be in.
type DeleteGlossaryMetadata_State int32

const (
	// Invalid.
	DeleteGlossaryMetadata_STATE_UNSPECIFIED DeleteGlossaryMetadata_State = 0
	// Request is being processed.
	DeleteGlossaryMetadata_RUNNING DeleteGlossaryMetadata_State = 1
	// The glossary was successfully deleted.
	DeleteGlossaryMetadata_SUCCEEDED DeleteGlossaryMetadata_State = 2
	// Failed to delete the glossary.
	DeleteGlossaryMetadata_FAILED DeleteGlossaryMetadata_State = 3
	// Request is in the process of being canceled after caller invoked
	// longrunning.Operations.CancelOperation on the request id.
	DeleteGlossaryMetadata_CANCELLING DeleteGlossaryMetadata_State = 4
	// The glossary deletion request was successfully canceled.
	DeleteGlossaryMetadata_CANCELLED DeleteGlossaryMetadata_State = 5
)

// Enum value maps for DeleteGlossaryMetadata_State.
var (
	DeleteGlossaryMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "SUCCEEDED",
		3: "FAILED",
		4: "CANCELLING",
		5: "CANCELLED",
	}
	DeleteGlossaryMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"SUCCEEDED":         2,
		"FAILED":            3,
		"CANCELLING":        4,
		"CANCELLED":         5,
	}
)

func (x DeleteGlossaryMetadata_State) Enum() *DeleteGlossaryMetadata_State {
	p := new(DeleteGlossaryMetadata_State)
	*p = x
	return p
}

func (x DeleteGlossaryMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeleteGlossaryMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_translate_v3beta1_translation_service_proto_enumTypes[2].Descriptor()
}

func (DeleteGlossaryMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_translate_v3beta1_translation_service_proto_enumTypes[2]
}

func (x DeleteGlossaryMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeleteGlossaryMetadata_State.Descriptor instead.
func (DeleteGlossaryMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{25, 0}
}

// Configures which glossary should be used for a specific target language,
// and defines options for applying that glossary.
type TranslateTextGlossaryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specifies the glossary used for this translation. Use
	// this format: projects/*/locations/*/glossaries/*
	Glossary string `protobuf:"bytes,1,opt,name=glossary,proto3" json:"glossary,omitempty"`
	// Optional. Indicates match is case-insensitive.
	// Default value is false if missing.
	IgnoreCase bool `protobuf:"varint,2,opt,name=ignore_case,json=ignoreCase,proto3" json:"ignore_case,omitempty"`
}

func (x *TranslateTextGlossaryConfig) Reset() {
	*x = TranslateTextGlossaryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TranslateTextGlossaryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranslateTextGlossaryConfig) ProtoMessage() {}

func (x *TranslateTextGlossaryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranslateTextGlossaryConfig.ProtoReflect.Descriptor instead.
func (*TranslateTextGlossaryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{0}
}

func (x *TranslateTextGlossaryConfig) GetGlossary() string {
	if x != nil {
		return x.Glossary
	}
	return ""
}

func (x *TranslateTextGlossaryConfig) GetIgnoreCase() bool {
	if x != nil {
		return x.IgnoreCase
	}
	return false
}

// The request message for synchronous translation.
type TranslateTextRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The content of the input in string format.
	// We recommend the total content be less than 30k codepoints.
	// Use BatchTranslateText for larger text.
	Contents []string `protobuf:"bytes,1,rep,name=contents,proto3" json:"contents,omitempty"`
	// Optional. The format of the source text, for example, "text/html",
	//  "text/plain". If left blank, the MIME type defaults to "text/html".
	MimeType string `protobuf:"bytes,3,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Optional. The BCP-47 language code of the input text if
	// known, for example, "en-US" or "sr-Latn". Supported language codes are
	// listed in Language Support. If the source language isn't specified, the API
	// attempts to identify the source language automatically and returns the
	// source language within the response.
	SourceLanguageCode string `protobuf:"bytes,4,opt,name=source_language_code,json=sourceLanguageCode,proto3" json:"source_language_code,omitempty"`
	// Required. The BCP-47 language code to use for translation of the input
	// text, set to one of the language codes listed in Language Support.
	TargetLanguageCode string `protobuf:"bytes,5,opt,name=target_language_code,json=targetLanguageCode,proto3" json:"target_language_code,omitempty"`
	// Required. Project or location to make a call. Must refer to a caller's
	// project.
	//
	// Format: `projects/{project-id}` or
	// `projects/{project-id}/locations/{location-id}`.
	//
	// For global calls, use `projects/{project-id}/locations/global` or
	// `projects/{project-id}`.
	//
	// Non-global location is required for requests using AutoML models or
	// custom glossaries.
	//
	// Models and glossaries must be within the same region (have same
	// location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
	Parent string `protobuf:"bytes,8,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The `model` type requested for this translation.
	//
	// The format depends on model type:
	//
	// - AutoML Translation models:
	//   `projects/{project-id}/locations/{location-id}/models/{model-id}`
	//
	// - General (built-in) models:
	//   `projects/{project-id}/locations/{location-id}/models/general/nmt`,
	//   `projects/{project-id}/locations/{location-id}/models/general/base`
	//
	//
	// For global (non-regionalized) requests, use `location-id` `global`.
	// For example,
	// `projects/{project-id}/locations/global/models/general/nmt`.
	//
	// If missing, the system decides which google base model to use.
	Model string `protobuf:"bytes,6,opt,name=model,proto3" json:"model,omitempty"`
	// Optional. Glossary to be applied. The glossary must be
	// within the same region (have the same location-id) as the model, otherwise
	// an INVALID_ARGUMENT (400) error is returned.
	GlossaryConfig *TranslateTextGlossaryConfig `protobuf:"bytes,7,opt,name=glossary_config,json=glossaryConfig,proto3" json:"glossary_config,omitempty"`
	// Optional. The labels with user-defined metadata for the request.
	//
	// Label keys and values can be no longer than 63 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter.
	//
	// See https://cloud.google.com/translate/docs/labels for more information.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *TranslateTextRequest) Reset() {
	*x = TranslateTextRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TranslateTextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranslateTextRequest) ProtoMessage() {}

func (x *TranslateTextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranslateTextRequest.ProtoReflect.Descriptor instead.
func (*TranslateTextRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{1}
}

func (x *TranslateTextRequest) GetContents() []string {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *TranslateTextRequest) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *TranslateTextRequest) GetSourceLanguageCode() string {
	if x != nil {
		return x.SourceLanguageCode
	}
	return ""
}

func (x *TranslateTextRequest) GetTargetLanguageCode() string {
	if x != nil {
		return x.TargetLanguageCode
	}
	return ""
}

func (x *TranslateTextRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *TranslateTextRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *TranslateTextRequest) GetGlossaryConfig() *TranslateTextGlossaryConfig {
	if x != nil {
		return x.GlossaryConfig
	}
	return nil
}

func (x *TranslateTextRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type TranslateTextResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Text translation responses with no glossary applied.
	// This field has the same length as
	// [`contents`][google.cloud.translation.v3beta1.TranslateTextRequest.contents].
	Translations []*Translation `protobuf:"bytes,1,rep,name=translations,proto3" json:"translations,omitempty"`
	// Text translation responses if a glossary is provided in the request.
	// This can be the same as
	// [`translations`][google.cloud.translation.v3beta1.TranslateTextResponse.translations] if no terms apply.
	// This field has the same length as
	// [`contents`][google.cloud.translation.v3beta1.TranslateTextRequest.contents].
	GlossaryTranslations []*Translation `protobuf:"bytes,3,rep,name=glossary_translations,json=glossaryTranslations,proto3" json:"glossary_translations,omitempty"`
}

func (x *TranslateTextResponse) Reset() {
	*x = TranslateTextResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TranslateTextResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranslateTextResponse) ProtoMessage() {}

func (x *TranslateTextResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranslateTextResponse.ProtoReflect.Descriptor instead.
func (*TranslateTextResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{2}
}

func (x *TranslateTextResponse) GetTranslations() []*Translation {
	if x != nil {
		return x.Translations
	}
	return nil
}

func (x *TranslateTextResponse) GetGlossaryTranslations() []*Translation {
	if x != nil {
		return x.GlossaryTranslations
	}
	return nil
}

// A single translation response.
type Translation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Text translated into the target language.
	TranslatedText string `protobuf:"bytes,1,opt,name=translated_text,json=translatedText,proto3" json:"translated_text,omitempty"`
	// Only present when `model` is present in the request.
	// This is same as `model` provided in the request.
	Model string `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
	// The BCP-47 language code of source text in the initial request, detected
	// automatically, if no source language was passed within the initial
	// request. If the source language was passed, auto-detection of the language
	// does not occur and this field is empty.
	DetectedLanguageCode string `protobuf:"bytes,4,opt,name=detected_language_code,json=detectedLanguageCode,proto3" json:"detected_language_code,omitempty"`
	// The `glossary_config` used for this translation.
	GlossaryConfig *TranslateTextGlossaryConfig `protobuf:"bytes,3,opt,name=glossary_config,json=glossaryConfig,proto3" json:"glossary_config,omitempty"`
}

func (x *Translation) Reset() {
	*x = Translation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Translation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Translation) ProtoMessage() {}

func (x *Translation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Translation.ProtoReflect.Descriptor instead.
func (*Translation) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{3}
}

func (x *Translation) GetTranslatedText() string {
	if x != nil {
		return x.TranslatedText
	}
	return ""
}

func (x *Translation) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *Translation) GetDetectedLanguageCode() string {
	if x != nil {
		return x.DetectedLanguageCode
	}
	return ""
}

func (x *Translation) GetGlossaryConfig() *TranslateTextGlossaryConfig {
	if x != nil {
		return x.GlossaryConfig
	}
	return nil
}

// The request message for language detection.
type DetectLanguageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project or location to make a call. Must refer to a caller's
	// project.
	//
	// Format: `projects/{project-id}/locations/{location-id}` or
	// `projects/{project-id}`.
	//
	// For global calls, use `projects/{project-id}/locations/global` or
	// `projects/{project-id}`.
	//
	// Only models within the same region (has same location-id) can be used.
	// Otherwise an INVALID_ARGUMENT (400) error is returned.
	Parent string `protobuf:"bytes,5,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The language detection model to be used.
	//
	// Format:
	// `projects/{project-id}/locations/{location-id}/models/language-detection/{model-id}`
	//
	// Only one language detection model is currently supported:
	// `projects/{project-id}/locations/{location-id}/models/language-detection/default`.
	//
	// If not specified, the default model is used.
	Model string `protobuf:"bytes,4,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The source of the document from which to detect the language.
	//
	// Types that are assignable to Source:
	//	*DetectLanguageRequest_Content
	Source isDetectLanguageRequest_Source `protobuf_oneof:"source"`
	// Optional. The format of the source text, for example, "text/html",
	// "text/plain". If left blank, the MIME type defaults to "text/html".
	MimeType string `protobuf:"bytes,3,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Optional. The labels with user-defined metadata for the request.
	//
	// Label keys and values can be no longer than 63 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter.
	//
	// See https://cloud.google.com/translate/docs/labels for more information.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *DetectLanguageRequest) Reset() {
	*x = DetectLanguageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetectLanguageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetectLanguageRequest) ProtoMessage() {}

func (x *DetectLanguageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetectLanguageRequest.ProtoReflect.Descriptor instead.
func (*DetectLanguageRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{4}
}

func (x *DetectLanguageRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *DetectLanguageRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (m *DetectLanguageRequest) GetSource() isDetectLanguageRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *DetectLanguageRequest) GetContent() string {
	if x, ok := x.GetSource().(*DetectLanguageRequest_Content); ok {
		return x.Content
	}
	return ""
}

func (x *DetectLanguageRequest) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *DetectLanguageRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type isDetectLanguageRequest_Source interface {
	isDetectLanguageRequest_Source()
}

type DetectLanguageRequest_Content struct {
	// The content of the input stored as a string.
	Content string `protobuf:"bytes,1,opt,name=content,proto3,oneof"`
}

func (*DetectLanguageRequest_Content) isDetectLanguageRequest_Source() {}

// The response message for language detection.
type DetectedLanguage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The BCP-47 language code of source content in the request, detected
	// automatically.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The confidence of the detection result for this language.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *DetectedLanguage) Reset() {
	*x = DetectedLanguage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetectedLanguage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetectedLanguage) ProtoMessage() {}

func (x *DetectedLanguage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetectedLanguage.ProtoReflect.Descriptor instead.
func (*DetectedLanguage) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{5}
}

func (x *DetectedLanguage) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *DetectedLanguage) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// The response message for language detection.
type DetectLanguageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of detected languages sorted by detection confidence in descending
	// order. The most probable language first.
	Languages []*DetectedLanguage `protobuf:"bytes,1,rep,name=languages,proto3" json:"languages,omitempty"`
}

func (x *DetectLanguageResponse) Reset() {
	*x = DetectLanguageResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetectLanguageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetectLanguageResponse) ProtoMessage() {}

func (x *DetectLanguageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetectLanguageResponse.ProtoReflect.Descriptor instead.
func (*DetectLanguageResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{6}
}

func (x *DetectLanguageResponse) GetLanguages() []*DetectedLanguage {
	if x != nil {
		return x.Languages
	}
	return nil
}

// The request message for discovering supported languages.
type GetSupportedLanguagesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project or location to make a call. Must refer to a caller's
	// project.
	//
	// Format: `projects/{project-id}` or
	// `projects/{project-id}/locations/{location-id}`.
	//
	// For global calls, use `projects/{project-id}/locations/global` or
	// `projects/{project-id}`.
	//
	// Non-global location is required for AutoML models.
	//
	// Only models within the same region (have same location-id) can be used,
	// otherwise an INVALID_ARGUMENT (400) error is returned.
	Parent string `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The language to use to return localized, human readable names
	// of supported languages. If missing, then display names are not returned
	// in a response.
	DisplayLanguageCode string `protobuf:"bytes,1,opt,name=display_language_code,json=displayLanguageCode,proto3" json:"display_language_code,omitempty"`
	// Optional. Get supported languages of this model.
	//
	// The format depends on model type:
	//
	// - AutoML Translation models:
	//   `projects/{project-id}/locations/{location-id}/models/{model-id}`
	//
	// - General (built-in) models:
	//   `projects/{project-id}/locations/{location-id}/models/general/nmt`,
	//   `projects/{project-id}/locations/{location-id}/models/general/base`
	//
	//
	// Returns languages supported by the specified model.
	// If missing, we get supported languages of Google general base (PBMT) model.
	Model string `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *GetSupportedLanguagesRequest) Reset() {
	*x = GetSupportedLanguagesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSupportedLanguagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSupportedLanguagesRequest) ProtoMessage() {}

func (x *GetSupportedLanguagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSupportedLanguagesRequest.ProtoReflect.Descriptor instead.
func (*GetSupportedLanguagesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{7}
}

func (x *GetSupportedLanguagesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *GetSupportedLanguagesRequest) GetDisplayLanguageCode() string {
	if x != nil {
		return x.DisplayLanguageCode
	}
	return ""
}

func (x *GetSupportedLanguagesRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// The response message for discovering supported languages.
type SupportedLanguages struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of supported language responses. This list contains an entry
	// for each language the Translation API supports.
	Languages []*SupportedLanguage `protobuf:"bytes,1,rep,name=languages,proto3" json:"languages,omitempty"`
}

func (x *SupportedLanguages) Reset() {
	*x = SupportedLanguages{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupportedLanguages) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupportedLanguages) ProtoMessage() {}

func (x *SupportedLanguages) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupportedLanguages.ProtoReflect.Descriptor instead.
func (*SupportedLanguages) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{8}
}

func (x *SupportedLanguages) GetLanguages() []*SupportedLanguage {
	if x != nil {
		return x.Languages
	}
	return nil
}

// A single supported language response corresponds to information related
// to one supported language.
type SupportedLanguage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Supported language code, generally consisting of its ISO 639-1
	// identifier, for example, 'en', 'ja'. In certain cases, BCP-47 codes
	// including language and region identifiers are returned (for example,
	// 'zh-TW' and 'zh-CN')
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Human readable name of the language localized in the display language
	// specified in the request.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Can be used as source language.
	SupportSource bool `protobuf:"varint,3,opt,name=support_source,json=supportSource,proto3" json:"support_source,omitempty"`
	// Can be used as target language.
	SupportTarget bool `protobuf:"varint,4,opt,name=support_target,json=supportTarget,proto3" json:"support_target,omitempty"`
}

func (x *SupportedLanguage) Reset() {
	*x = SupportedLanguage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupportedLanguage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupportedLanguage) ProtoMessage() {}

func (x *SupportedLanguage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupportedLanguage.ProtoReflect.Descriptor instead.
func (*SupportedLanguage) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{9}
}

func (x *SupportedLanguage) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *SupportedLanguage) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *SupportedLanguage) GetSupportSource() bool {
	if x != nil {
		return x.SupportSource
	}
	return false
}

func (x *SupportedLanguage) GetSupportTarget() bool {
	if x != nil {
		return x.SupportTarget
	}
	return false
}

// The Google Cloud Storage location for the input content.
type GcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Source data URI. For example, `gs://my_bucket/my_object`.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
}

func (x *GcsSource) Reset() {
	*x = GcsSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsSource) ProtoMessage() {}

func (x *GcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsSource.ProtoReflect.Descriptor instead.
func (*GcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{10}
}

func (x *GcsSource) GetInputUri() string {
	if x != nil {
		return x.InputUri
	}
	return ""
}

// Input configuration for BatchTranslateText request.
type InputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Can be "text/plain" or "text/html".
	// For `.tsv`, "text/html" is used if mime_type is missing.
	// For `.html`, this field must be "text/html" or empty.
	// For `.txt`, this field must be "text/plain" or empty.
	MimeType string `protobuf:"bytes,1,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Required. Specify the input.
	//
	// Types that are assignable to Source:
	//	*InputConfig_GcsSource
	Source isInputConfig_Source `protobuf_oneof:"source"`
}

func (x *InputConfig) Reset() {
	*x = InputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputConfig) ProtoMessage() {}

func (x *InputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputConfig.ProtoReflect.Descriptor instead.
func (*InputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{11}
}

func (x *InputConfig) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (m *InputConfig) GetSource() isInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *InputConfig) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*InputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

type isInputConfig_Source interface {
	isInputConfig_Source()
}

type InputConfig_GcsSource struct {
	// Required. Google Cloud Storage location for the source input.
	// This can be a single file (for example,
	// `gs://translation-test/input.tsv`) or a wildcard (for example,
	// `gs://translation-test/*`). If a file extension is `.tsv`, it can
	// contain either one or two columns. The first column (optional) is the id
	// of the text request. If the first column is missing, we use the row
	// number (0-based) from the input file as the ID in the output file. The
	// second column is the actual text to be
	//  translated. We recommend each row be <= 10K Unicode codepoints,
	// otherwise an error might be returned.
	// Note that the input tsv must be RFC 4180 compliant.
	//
	// You could use https://github.com/Clever/csvlint to check potential
	// formatting errors in your tsv file.
	// csvlint --delimiter='\t' your_input_file.tsv
	//
	// The other supported file extensions are `.txt` or `.html`, which is
	// treated as a single large chunk of text.
	GcsSource *GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*InputConfig_GcsSource) isInputConfig_Source() {}

// The Google Cloud Storage location for the output content.
type GcsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. There must be no files under 'output_uri_prefix'.
	// 'output_uri_prefix' must end with "/" and start with "gs://", otherwise an
	// INVALID_ARGUMENT (400) error is returned.
	OutputUriPrefix string `protobuf:"bytes,1,opt,name=output_uri_prefix,json=outputUriPrefix,proto3" json:"output_uri_prefix,omitempty"`
}

func (x *GcsDestination) Reset() {
	*x = GcsDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsDestination) ProtoMessage() {}

func (x *GcsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsDestination.ProtoReflect.Descriptor instead.
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{12}
}

func (x *GcsDestination) GetOutputUriPrefix() string {
	if x != nil {
		return x.OutputUriPrefix
	}
	return ""
}

// Output configuration for BatchTranslateText request.
type OutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The destination of output.
	//
	// Types that are assignable to Destination:
	//	*OutputConfig_GcsDestination
	Destination isOutputConfig_Destination `protobuf_oneof:"destination"`
}

func (x *OutputConfig) Reset() {
	*x = OutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputConfig) ProtoMessage() {}

func (x *OutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputConfig.ProtoReflect.Descriptor instead.
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{13}
}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := x.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	// Google Cloud Storage destination for output content.
	// For every single input file (for example, gs://a/b/c.[extension]), we
	// generate at most 2 * n output files. (n is the # of target_language_codes
	// in the BatchTranslateTextRequest).
	//
	// Output files (tsv) generated are compliant with RFC 4180 except that
	// record delimiters are '\n' instead of '\r\n'. We don't provide any way to
	// change record delimiters.
	//
	// While the input files are being processed, we write/update an index file
	// 'index.csv'  under 'output_uri_prefix' (for example,
	// gs://translation-test/index.csv) The index file is generated/updated as
	// new files are being translated. The format is:
	//
	// input_file,target_language_code,translations_file,errors_file,
	// glossary_translations_file,glossary_errors_file
	//
	// input_file is one file we matched using gcs_source.input_uri.
	// target_language_code is provided in the request.
	// translations_file contains the translations. (details provided below)
	// errors_file contains the errors during processing of the file. (details
	// below). Both translations_file and errors_file could be empty
	// strings if we have no content to output.
	// glossary_translations_file and glossary_errors_file are always empty
	// strings if the input_file is tsv. They could also be empty if we have no
	// content to output.
	//
	// Once a row is present in index.csv, the input/output matching never
	// changes. Callers should also expect all the content in input_file are
	// processed and ready to be consumed (that is, no partial output file is
	// written).
	//
	// The format of translations_file (for target language code 'trg') is:
	// `gs://translation_test/a_b_c_'trg'_translations.[extension]`
	//
	// If the input file extension is tsv, the output has the following
	// columns:
	// Column 1: ID of the request provided in the input, if it's not
	// provided in the input, then the input row number is used (0-based).
	// Column 2: source sentence.
	// Column 3: translation without applying a glossary. Empty string if there
	// is an error.
	// Column 4 (only present if a glossary is provided in the request):
	// translation after applying the glossary. Empty string if there is an
	// error applying the glossary. Could be same string as column 3 if there is
	// no glossary applied.
	//
	// If input file extension is a txt or html, the translation is directly
	// written to the output file. If glossary is requested, a separate
	// glossary_translations_file has format of
	// `gs://translation_test/a_b_c_'trg'_glossary_translations.[extension]`
	//
	// The format of errors file (for target language code 'trg') is:
	// `gs://translation_test/a_b_c_'trg'_errors.[extension]`
	//
	// If the input file extension is tsv, errors_file contains the following:
	// Column 1: ID of the request provided in the input, if it's not
	// provided in the input, then the input row number is used (0-based).
	// Column 2: source sentence.
	// Column 3: Error detail for the translation. Could be empty.
	// Column 4 (only present if a glossary is provided in the request):
	// Error when applying the glossary.
	//
	// If the input file extension is txt or html, glossary_error_file will be
	// generated that contains error details. glossary_error_file has format of
	// `gs://translation_test/a_b_c_'trg'_glossary_errors.[extension]`
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

// The batch translation request.
type BatchTranslateTextRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Location to make a call. Must refer to a caller's project.
	//
	// Format: `projects/{project-id}/locations/{location-id}`.
	//
	// The `global` location is not supported for batch translation.
	//
	// Only AutoML Translation models or glossaries within the same region (have
	// the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
	// error is returned.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Source language code.
	SourceLanguageCode string `protobuf:"bytes,2,opt,name=source_language_code,json=sourceLanguageCode,proto3" json:"source_language_code,omitempty"`
	// Required. Specify up to 10 language codes here.
	TargetLanguageCodes []string `protobuf:"bytes,3,rep,name=target_language_codes,json=targetLanguageCodes,proto3" json:"target_language_codes,omitempty"`
	// Optional. The models to use for translation. Map's key is target language
	// code. Map's value is model name. Value can be a built-in general model,
	// or an AutoML Translation model.
	//
	// The value format depends on model type:
	//
	// - AutoML Translation models:
	//   `projects/{project-id}/locations/{location-id}/models/{model-id}`
	//
	// - General (built-in) models:
	//   `projects/{project-id}/locations/{location-id}/models/general/nmt`,
	//   `projects/{project-id}/locations/{location-id}/models/general/base`
	//
	//
	// If the map is empty or a specific model is
	// not requested for a language pair, then default google model (nmt) is used.
	Models map[string]string `protobuf:"bytes,4,rep,name=models,proto3" json:"models,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Input configurations.
	// The total number of files matched should be <= 1000.
	// The total content size should be <= 100M Unicode codepoints.
	// The files must use UTF-8 encoding.
	InputConfigs []*InputConfig `protobuf:"bytes,5,rep,name=input_configs,json=inputConfigs,proto3" json:"input_configs,omitempty"`
	// Required. Output configuration.
	// If 2 input configs match to the same file (that is, same input path),
	// we don't generate output for duplicate inputs.
	OutputConfig *OutputConfig `protobuf:"bytes,6,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// Optional. Glossaries to be applied for translation.
	// It's keyed by target language code.
	Glossaries map[string]*TranslateTextGlossaryConfig `protobuf:"bytes,7,rep,name=glossaries,proto3" json:"glossaries,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The labels with user-defined metadata for the request.
	//
	// Label keys and values can be no longer than 63 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter.
	//
	// See https://cloud.google.com/translate/docs/labels for more information.
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BatchTranslateTextRequest) Reset() {
	*x = BatchTranslateTextRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchTranslateTextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchTranslateTextRequest) ProtoMessage() {}

func (x *BatchTranslateTextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchTranslateTextRequest.ProtoReflect.Descriptor instead.
func (*BatchTranslateTextRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{14}
}

func (x *BatchTranslateTextRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchTranslateTextRequest) GetSourceLanguageCode() string {
	if x != nil {
		return x.SourceLanguageCode
	}
	return ""
}

func (x *BatchTranslateTextRequest) GetTargetLanguageCodes() []string {
	if x != nil {
		return x.TargetLanguageCodes
	}
	return nil
}

func (x *BatchTranslateTextRequest) GetModels() map[string]string {
	if x != nil {
		return x.Models
	}
	return nil
}

func (x *BatchTranslateTextRequest) GetInputConfigs() []*InputConfig {
	if x != nil {
		return x.InputConfigs
	}
	return nil
}

func (x *BatchTranslateTextRequest) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *BatchTranslateTextRequest) GetGlossaries() map[string]*TranslateTextGlossaryConfig {
	if x != nil {
		return x.Glossaries
	}
	return nil
}

func (x *BatchTranslateTextRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// State metadata for the batch translation operation.
type BatchTranslateMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of the operation.
	State BatchTranslateMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.translation.v3beta1.BatchTranslateMetadata_State" json:"state,omitempty"`
	// Number of successfully translated characters so far (Unicode codepoints).
	TranslatedCharacters int64 `protobuf:"varint,2,opt,name=translated_characters,json=translatedCharacters,proto3" json:"translated_characters,omitempty"`
	// Number of characters that have failed to process so far (Unicode
	// codepoints).
	FailedCharacters int64 `protobuf:"varint,3,opt,name=failed_characters,json=failedCharacters,proto3" json:"failed_characters,omitempty"`
	// Total number of characters (Unicode codepoints).
	// This is the total number of codepoints from input files times the number of
	// target languages and appears here shortly after the call is submitted.
	TotalCharacters int64 `protobuf:"varint,4,opt,name=total_characters,json=totalCharacters,proto3" json:"total_characters,omitempty"`
	// Time when the operation was submitted.
	SubmitTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
}

func (x *BatchTranslateMetadata) Reset() {
	*x = BatchTranslateMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchTranslateMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchTranslateMetadata) ProtoMessage() {}

func (x *BatchTranslateMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchTranslateMetadata.ProtoReflect.Descriptor instead.
func (*BatchTranslateMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{15}
}

func (x *BatchTranslateMetadata) GetState() BatchTranslateMetadata_State {
	if x != nil {
		return x.State
	}
	return BatchTranslateMetadata_STATE_UNSPECIFIED
}

func (x *BatchTranslateMetadata) GetTranslatedCharacters() int64 {
	if x != nil {
		return x.TranslatedCharacters
	}
	return 0
}

func (x *BatchTranslateMetadata) GetFailedCharacters() int64 {
	if x != nil {
		return x.FailedCharacters
	}
	return 0
}

func (x *BatchTranslateMetadata) GetTotalCharacters() int64 {
	if x != nil {
		return x.TotalCharacters
	}
	return 0
}

func (x *BatchTranslateMetadata) GetSubmitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SubmitTime
	}
	return nil
}

// Stored in the [google.longrunning.Operation.response][google.longrunning.Operation.response] field returned by
// BatchTranslateText if at least one sentence is translated successfully.
type BatchTranslateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total number of characters (Unicode codepoints).
	TotalCharacters int64 `protobuf:"varint,1,opt,name=total_characters,json=totalCharacters,proto3" json:"total_characters,omitempty"`
	// Number of successfully translated characters (Unicode codepoints).
	TranslatedCharacters int64 `protobuf:"varint,2,opt,name=translated_characters,json=translatedCharacters,proto3" json:"translated_characters,omitempty"`
	// Number of characters that have failed to process (Unicode codepoints).
	FailedCharacters int64 `protobuf:"varint,3,opt,name=failed_characters,json=failedCharacters,proto3" json:"failed_characters,omitempty"`
	// Time when the operation was submitted.
	SubmitTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
	// The time when the operation is finished and
	// [google.longrunning.Operation.done][google.longrunning.Operation.done] is set to true.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *BatchTranslateResponse) Reset() {
	*x = BatchTranslateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchTranslateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchTranslateResponse) ProtoMessage() {}

func (x *BatchTranslateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchTranslateResponse.ProtoReflect.Descriptor instead.
func (*BatchTranslateResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{16}
}

func (x *BatchTranslateResponse) GetTotalCharacters() int64 {
	if x != nil {
		return x.TotalCharacters
	}
	return 0
}

func (x *BatchTranslateResponse) GetTranslatedCharacters() int64 {
	if x != nil {
		return x.TranslatedCharacters
	}
	return 0
}

func (x *BatchTranslateResponse) GetFailedCharacters() int64 {
	if x != nil {
		return x.FailedCharacters
	}
	return 0
}

func (x *BatchTranslateResponse) GetSubmitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SubmitTime
	}
	return nil
}

func (x *BatchTranslateResponse) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Input configuration for glossaries.
type GlossaryInputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specify the input.
	//
	// Types that are assignable to Source:
	//	*GlossaryInputConfig_GcsSource
	Source isGlossaryInputConfig_Source `protobuf_oneof:"source"`
}

func (x *GlossaryInputConfig) Reset() {
	*x = GlossaryInputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GlossaryInputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GlossaryInputConfig) ProtoMessage() {}

func (x *GlossaryInputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GlossaryInputConfig.ProtoReflect.Descriptor instead.
func (*GlossaryInputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{17}
}

func (m *GlossaryInputConfig) GetSource() isGlossaryInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *GlossaryInputConfig) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*GlossaryInputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

type isGlossaryInputConfig_Source interface {
	isGlossaryInputConfig_Source()
}

type GlossaryInputConfig_GcsSource struct {
	// Required. Google Cloud Storage location of glossary data.
	// File format is determined based on the filename extension. API returns
	// [google.rpc.Code.INVALID_ARGUMENT] for unsupported URI-s and file
	// formats. Wildcards are not allowed. This must be a single file in one of
	// the following formats:
	//
	// For unidirectional glossaries:
	//
	// - TSV/CSV (`.tsv`/`.csv`): 2 column file, tab- or comma-separated.
	//   The first column is source text. The second column is target text.
	//   The file must not contain headers. That is, the first row is data, not
	//   column names.
	//
	// - TMX (`.tmx`): TMX file with parallel data defining source/target term
	// pairs.
	//
	// For equivalent term sets glossaries:
	//
	// - CSV (`.csv`): Multi-column CSV file defining equivalent glossary terms
	//   in multiple languages. The format is defined for Google Translation
	//   Toolkit and documented in [Use a
	//   glossary](https://support.google.com/translatortoolkit/answer/6306379?hl=en).
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*GlossaryInputConfig_GcsSource) isGlossaryInputConfig_Source() {}

// Represents a glossary built from user provided data.
type Glossary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the glossary. Glossary names have the form
	// `projects/{project-id}/locations/{location-id}/glossaries/{glossary-id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Languages supported by the glossary.
	//
	// Types that are assignable to Languages:
	//	*Glossary_LanguagePair
	//	*Glossary_LanguageCodesSet_
	Languages isGlossary_Languages `protobuf_oneof:"languages"`
	// Required. Provides examples to build the glossary from.
	// Total glossary must not exceed 10M Unicode codepoints.
	InputConfig *GlossaryInputConfig `protobuf:"bytes,5,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Output only. The number of entries defined in the glossary.
	EntryCount int32 `protobuf:"varint,6,opt,name=entry_count,json=entryCount,proto3" json:"entry_count,omitempty"`
	// Output only. When CreateGlossary was called.
	SubmitTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
	// Output only. When the glossary creation was finished.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *Glossary) Reset() {
	*x = Glossary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Glossary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Glossary) ProtoMessage() {}

func (x *Glossary) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Glossary.ProtoReflect.Descriptor instead.
func (*Glossary) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{18}
}

func (x *Glossary) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *Glossary) GetLanguages() isGlossary_Languages {
	if m != nil {
		return m.Languages
	}
	return nil
}

func (x *Glossary) GetLanguagePair() *Glossary_LanguageCodePair {
	if x, ok := x.GetLanguages().(*Glossary_LanguagePair); ok {
		return x.LanguagePair
	}
	return nil
}

func (x *Glossary) GetLanguageCodesSet() *Glossary_LanguageCodesSet {
	if x, ok := x.GetLanguages().(*Glossary_LanguageCodesSet_); ok {
		return x.LanguageCodesSet
	}
	return nil
}

func (x *Glossary) GetInputConfig() *GlossaryInputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *Glossary) GetEntryCount() int32 {
	if x != nil {
		return x.EntryCount
	}
	return 0
}

func (x *Glossary) GetSubmitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SubmitTime
	}
	return nil
}

func (x *Glossary) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

type isGlossary_Languages interface {
	isGlossary_Languages()
}

type Glossary_LanguagePair struct {
	// Used with unidirectional glossaries.
	LanguagePair *Glossary_LanguageCodePair `protobuf:"bytes,3,opt,name=language_pair,json=languagePair,proto3,oneof"`
}

type Glossary_LanguageCodesSet_ struct {
	// Used with equivalent term set glossaries.
	LanguageCodesSet *Glossary_LanguageCodesSet `protobuf:"bytes,4,opt,name=language_codes_set,json=languageCodesSet,proto3,oneof"`
}

func (*Glossary_LanguagePair) isGlossary_Languages() {}

func (*Glossary_LanguageCodesSet_) isGlossary_Languages() {}

// Request message for CreateGlossary.
type CreateGlossaryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The glossary to create.
	Glossary *Glossary `protobuf:"bytes,2,opt,name=glossary,proto3" json:"glossary,omitempty"`
}

func (x *CreateGlossaryRequest) Reset() {
	*x = CreateGlossaryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateGlossaryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGlossaryRequest) ProtoMessage() {}

func (x *CreateGlossaryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGlossaryRequest.ProtoReflect.Descriptor instead.
func (*CreateGlossaryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{19}
}

func (x *CreateGlossaryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGlossaryRequest) GetGlossary() *Glossary {
	if x != nil {
		return x.Glossary
	}
	return nil
}

// Request message for GetGlossary.
type GetGlossaryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the glossary to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGlossaryRequest) Reset() {
	*x = GetGlossaryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGlossaryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGlossaryRequest) ProtoMessage() {}

func (x *GetGlossaryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGlossaryRequest.ProtoReflect.Descriptor instead.
func (*GetGlossaryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{20}
}

func (x *GetGlossaryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DeleteGlossary.
type DeleteGlossaryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the glossary to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteGlossaryRequest) Reset() {
	*x = DeleteGlossaryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGlossaryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGlossaryRequest) ProtoMessage() {}

func (x *DeleteGlossaryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGlossaryRequest.ProtoReflect.Descriptor instead.
func (*DeleteGlossaryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{21}
}

func (x *DeleteGlossaryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListGlossaries.
type ListGlossariesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project from which to list all of the glossaries.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. The server may return fewer glossaries than
	// requested. If unspecified, the server picks an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	// Typically, this is the value of [ListGlossariesResponse.next_page_token]
	// returned from the previous call to `ListGlossaries` method.
	// The first page is returned if `page_token`is empty or missing.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter specifying constraints of a list operation.
	// Filtering is not supported yet, and the parameter currently has no effect.
	// If missing, no filtering is performed.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListGlossariesRequest) Reset() {
	*x = ListGlossariesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGlossariesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGlossariesRequest) ProtoMessage() {}

func (x *ListGlossariesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGlossariesRequest.ProtoReflect.Descriptor instead.
func (*ListGlossariesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{22}
}

func (x *ListGlossariesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGlossariesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGlossariesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListGlossariesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for ListGlossaries.
type ListGlossariesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of glossaries for a project.
	Glossaries []*Glossary `protobuf:"bytes,1,rep,name=glossaries,proto3" json:"glossaries,omitempty"`
	// A token to retrieve a page of results. Pass this value in the
	// [ListGlossariesRequest.page_token] field in the subsequent call to
	// `ListGlossaries` method to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListGlossariesResponse) Reset() {
	*x = ListGlossariesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGlossariesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGlossariesResponse) ProtoMessage() {}

func (x *ListGlossariesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGlossariesResponse.ProtoReflect.Descriptor instead.
func (*ListGlossariesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{23}
}

func (x *ListGlossariesResponse) GetGlossaries() []*Glossary {
	if x != nil {
		return x.Glossaries
	}
	return nil
}

func (x *ListGlossariesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Stored in the [google.longrunning.Operation.metadata][google.longrunning.Operation.metadata] field returned by
// CreateGlossary.
type CreateGlossaryMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the glossary that is being created.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The current state of the glossary creation operation.
	State CreateGlossaryMetadata_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.translation.v3beta1.CreateGlossaryMetadata_State" json:"state,omitempty"`
	// The time when the operation was submitted to the server.
	SubmitTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
}

func (x *CreateGlossaryMetadata) Reset() {
	*x = CreateGlossaryMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateGlossaryMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGlossaryMetadata) ProtoMessage() {}

func (x *CreateGlossaryMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGlossaryMetadata.ProtoReflect.Descriptor instead.
func (*CreateGlossaryMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{24}
}

func (x *CreateGlossaryMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateGlossaryMetadata) GetState() CreateGlossaryMetadata_State {
	if x != nil {
		return x.State
	}
	return CreateGlossaryMetadata_STATE_UNSPECIFIED
}

func (x *CreateGlossaryMetadata) GetSubmitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SubmitTime
	}
	return nil
}

// Stored in the [google.longrunning.Operation.metadata][google.longrunning.Operation.metadata] field returned by
// DeleteGlossary.
type DeleteGlossaryMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the glossary that is being deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The current state of the glossary deletion operation.
	State DeleteGlossaryMetadata_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.translation.v3beta1.DeleteGlossaryMetadata_State" json:"state,omitempty"`
	// The time when the operation was submitted to the server.
	SubmitTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
}

func (x *DeleteGlossaryMetadata) Reset() {
	*x = DeleteGlossaryMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGlossaryMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGlossaryMetadata) ProtoMessage() {}

func (x *DeleteGlossaryMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGlossaryMetadata.ProtoReflect.Descriptor instead.
func (*DeleteGlossaryMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{25}
}

func (x *DeleteGlossaryMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteGlossaryMetadata) GetState() DeleteGlossaryMetadata_State {
	if x != nil {
		return x.State
	}
	return DeleteGlossaryMetadata_STATE_UNSPECIFIED
}

func (x *DeleteGlossaryMetadata) GetSubmitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SubmitTime
	}
	return nil
}

// Stored in the [google.longrunning.Operation.response][google.longrunning.Operation.response] field returned by
// DeleteGlossary.
type DeleteGlossaryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the deleted glossary.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The time when the operation was submitted to the server.
	SubmitTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
	// The time when the glossary deletion is finished and
	// [google.longrunning.Operation.done][google.longrunning.Operation.done] is set to true.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *DeleteGlossaryResponse) Reset() {
	*x = DeleteGlossaryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGlossaryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGlossaryResponse) ProtoMessage() {}

func (x *DeleteGlossaryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGlossaryResponse.ProtoReflect.Descriptor instead.
func (*DeleteGlossaryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{26}
}

func (x *DeleteGlossaryResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteGlossaryResponse) GetSubmitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SubmitTime
	}
	return nil
}

func (x *DeleteGlossaryResponse) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Used with unidirectional glossaries.
type Glossary_LanguageCodePair struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BCP-47 language code of the input text, for example,
	// "en-US". Expected to be an exact match for GlossaryTerm.language_code.
	SourceLanguageCode string `protobuf:"bytes,1,opt,name=source_language_code,json=sourceLanguageCode,proto3" json:"source_language_code,omitempty"`
	// Required. The BCP-47 language code for translation output, for example,
	// "zh-CN". Expected to be an exact match for GlossaryTerm.language_code.
	TargetLanguageCode string `protobuf:"bytes,2,opt,name=target_language_code,json=targetLanguageCode,proto3" json:"target_language_code,omitempty"`
}

func (x *Glossary_LanguageCodePair) Reset() {
	*x = Glossary_LanguageCodePair{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Glossary_LanguageCodePair) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Glossary_LanguageCodePair) ProtoMessage() {}

func (x *Glossary_LanguageCodePair) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Glossary_LanguageCodePair.ProtoReflect.Descriptor instead.
func (*Glossary_LanguageCodePair) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{18, 0}
}

func (x *Glossary_LanguageCodePair) GetSourceLanguageCode() string {
	if x != nil {
		return x.SourceLanguageCode
	}
	return ""
}

func (x *Glossary_LanguageCodePair) GetTargetLanguageCode() string {
	if x != nil {
		return x.TargetLanguageCode
	}
	return ""
}

// Used with equivalent term set glossaries.
type Glossary_LanguageCodesSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The BCP-47 language code(s) for terms defined in the glossary.
	// All entries are unique. The list contains at least two entries.
	// Expected to be an exact match for GlossaryTerm.language_code.
	LanguageCodes []string `protobuf:"bytes,1,rep,name=language_codes,json=languageCodes,proto3" json:"language_codes,omitempty"`
}

func (x *Glossary_LanguageCodesSet) Reset() {
	*x = Glossary_LanguageCodesSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Glossary_LanguageCodesSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Glossary_LanguageCodesSet) ProtoMessage() {}

func (x *Glossary_LanguageCodesSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Glossary_LanguageCodesSet.ProtoReflect.Descriptor instead.
func (*Glossary_LanguageCodesSet) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP(), []int{18, 1}
}

func (x *Glossary_LanguageCodesSet) GetLanguageCodes() []string {
	if x != nil {
		return x.LanguageCodes
	}
	return nil
}

var File_google_cloud_translate_v3beta1_translation_service_proto protoreflect.FileDescriptor

var file_google_cloud_translate_v3beta1_translation_service_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x64, 0x0a, 0x1b, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x08, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x67, 0x6c, 0x6f,
	0x73, 0x73, 0x61, 0x72, 0x79, 0x12, 0x24, 0x0a, 0x0b, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f,
	0x63, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x43, 0x61, 0x73, 0x65, 0x22, 0xae, 0x04, 0x0a, 0x14,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d,
	0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x35, 0x0a, 0x14, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x35,
	0x0a, 0x14, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x12, 0x6b, 0x0a, 0x0f, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x47, 0x6c, 0x6f,
	0x73, 0x73, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0e, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x5f, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xce, 0x01, 0x0a,
	0x15, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x62, 0x0a, 0x15, 0x67, 0x6c, 0x6f,
	0x73, 0x73, 0x61, 0x72, 0x79, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72,
	0x79, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xea, 0x01,
	0x0a, 0x0b, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a,
	0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x34, 0x0a, 0x16,
	0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x64, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x66, 0x0a, 0x0f, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x47, 0x6c, 0x6f, 0x73,
	0x73, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x67, 0x6c, 0x6f, 0x73,
	0x73, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xd5, 0x02, 0x0a, 0x15, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x12, 0x1a, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x5b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0x57, 0x0a, 0x10, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52,
	0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x6a, 0x0a, 0x16, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x50, 0x0a, 0x09, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x09, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x22, 0xb5, 0x01, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x53,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x15, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x13, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x22,
	0x67, 0x0a, 0x12, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x09, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x09, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x22, 0xa9, 0x01, 0x0a, 0x11, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x25, 0x0a,
	0x0e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x22, 0x2d, 0x0a, 0x09, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x20, 0x0a, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x55, 0x72, 0x69, 0x22, 0x87, 0x01, 0x0a, 0x0b, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d, 0x69, 0x6d,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4c, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x41, 0x0a,
	0x0e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x2f, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x5f, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x22, 0x7a, 0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x5b, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x67,
	0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0d, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb3, 0x07, 0x0a,
	0x19, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54,
	0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x35, 0x0a,
	0x14, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x37, 0x0a, 0x15, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x64, 0x0a,
	0x06, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54,
	0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x12, 0x57, 0x0a, 0x0d, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x58, 0x0a, 0x0d,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x70, 0x0a, 0x0a, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61,
	0x72, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x67, 0x6c,
	0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39,
	0x0a, 0x0b, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x7c, 0x0a, 0x0f, 0x47, 0x6c, 0x6f,
	0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x53,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x47, 0x6c,
	0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x9f, 0x03, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x54, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x33, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x14, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x43, 0x68,
	0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x66, 0x61, 0x69, 0x6c,
	0x65, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x10, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x43, 0x68, 0x61, 0x72, 0x61,
	0x63, 0x74, 0x65, 0x72, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63,
	0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x3b, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x65, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55,
	0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c,
	0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c,
	0x45, 0x44, 0x10, 0x05, 0x22, 0x99, 0x02, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x29, 0x0a, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x12, 0x33, 0x0a, 0x15, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x65, 0x64, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x2b, 0x0a, 0x11, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63,
	0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x66, 0x61, 0x69, 0x6c,
	0x65, 0x64, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x12, 0x3b, 0x0a, 0x0b,
	0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x73,
	0x75, 0x62, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0x6d, 0x0a, 0x13, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47,
	0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22,
	0x99, 0x06, 0x0a, 0x08, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x62, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x70, 0x61, 0x69, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x2e, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x50, 0x61, 0x69, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x50, 0x61, 0x69, 0x72, 0x12, 0x6b, 0x0a, 0x12, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72,
	0x79, 0x2e, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x53,
	0x65, 0x74, 0x48, 0x00, 0x52, 0x10, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x73, 0x53, 0x65, 0x74, 0x12, 0x58, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x24, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x73, 0x75,
	0x62, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x1a, 0x76, 0x0a, 0x10, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x43, 0x6f, 0x64, 0x65, 0x50, 0x61, 0x69, 0x72, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x1a, 0x39, 0x0a, 0x10,
	0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x53, 0x65, 0x74,
	0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x3a, 0x65, 0xea, 0x41, 0x62, 0x0a, 0x21, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x12,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72,
	0x69, 0x65, 0x73, 0x2f, 0x7b, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x7d, 0x42, 0x0b,
	0x0a, 0x09, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x22, 0xa7, 0x01, 0x0a, 0x15,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x08, 0x67, 0x6c, 0x6f, 0x73,
	0x73, 0x61, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x6c,
	0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x67, 0x6c, 0x6f,
	0x73, 0x73, 0x61, 0x72, 0x79, 0x22, 0x53, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x47, 0x6c, 0x6f, 0x73,
	0x73, 0x61, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6c, 0x6f, 0x73,
	0x73, 0x61, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x56, 0x0a, 0x15, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xbd, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73,
	0x61, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x22, 0x8c, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73,
	0x61, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a,
	0x0a, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x52, 0x0a, 0x67,
	0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xa6, 0x02, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73,
	0x73, 0x61, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x54, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72,
	0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x22, 0x65, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x43,
	0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x43,
	0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x22, 0xa6, 0x02, 0x0a, 0x16, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x3b, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x65, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49,
	0x4e, 0x47, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45,
	0x44, 0x10, 0x05, 0x22, 0xa0, 0x01, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6c,
	0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x32, 0x9a, 0x10, 0x0a, 0x12, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xf4, 0x01,
	0x0a, 0x0d, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x12,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x72, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6c, 0x22, 0x36, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74,
	0x3a, 0x01, 0x2a, 0x5a, 0x2f, 0x22, 0x2a, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78,
	0x74, 0x3a, 0x01, 0x2a, 0x12, 0x93, 0x02, 0x0a, 0x0e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x4c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8d, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x6e, 0x22, 0x37, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x3a, 0x01, 0x2a, 0x5a,
	0x30, 0x22, 0x2b, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x3a, 0x01,
	0x2a, 0xda, 0x41, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x2c, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x12, 0xab, 0x02, 0x0a, 0x15, 0x47,
	0x65, 0x74, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x22, 0x9b, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x70, 0x12, 0x3b, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73,
	0x5a, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x73, 0xda, 0x41, 0x22, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x2c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0xeb, 0x01, 0x0a, 0x12, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x12,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x79, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x40, 0x22, 0x3b, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74,
	0x3a, 0x01, 0x2a, 0xca, 0x41, 0x30, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xe6, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x7c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x22, 0x33, 0x2f, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x3a, 0x08,
	0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0xca, 0x41, 0x22, 0x0a, 0x08, 0x47,
	0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x12, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47,
	0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0xd9, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61,
	0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69,
	0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0xda, 0x41, 0x0d, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0xb3, 0x01, 0x0a, 0x0b,
	0x47, 0x65, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x12, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x22, 0x42, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6c, 0x6f,
	0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0xdf, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73,
	0x73, 0x61, 0x72, 0x79, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6c,
	0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x35, 0x2a, 0x33, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6c, 0x6f, 0x73,
	0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0xca, 0x41, 0x30, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73,
	0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x1a, 0x7e, 0xca, 0x41, 0x18, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x60, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0xf1, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x17, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x3b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0xf8, 0x01,
	0x01, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x56, 0x33, 0x42, 0x65, 0x74,
	0x61, 0x31, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x5c, 0x56, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x3a, 0x3a,
	0x56, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_translate_v3beta1_translation_service_proto_rawDescOnce sync.Once
	file_google_cloud_translate_v3beta1_translation_service_proto_rawDescData = file_google_cloud_translate_v3beta1_translation_service_proto_rawDesc
)

func file_google_cloud_translate_v3beta1_translation_service_proto_rawDescGZIP() []byte {
	file_google_cloud_translate_v3beta1_translation_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_translate_v3beta1_translation_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_translate_v3beta1_translation_service_proto_rawDescData)
	})
	return file_google_cloud_translate_v3beta1_translation_service_proto_rawDescData
}

var file_google_cloud_translate_v3beta1_translation_service_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes = make([]protoimpl.MessageInfo, 34)
var file_google_cloud_translate_v3beta1_translation_service_proto_goTypes = []interface{}{
	(BatchTranslateMetadata_State)(0),    // 0: google.cloud.translation.v3beta1.BatchTranslateMetadata.State
	(CreateGlossaryMetadata_State)(0),    // 1: google.cloud.translation.v3beta1.CreateGlossaryMetadata.State
	(DeleteGlossaryMetadata_State)(0),    // 2: google.cloud.translation.v3beta1.DeleteGlossaryMetadata.State
	(*TranslateTextGlossaryConfig)(nil),  // 3: google.cloud.translation.v3beta1.TranslateTextGlossaryConfig
	(*TranslateTextRequest)(nil),         // 4: google.cloud.translation.v3beta1.TranslateTextRequest
	(*TranslateTextResponse)(nil),        // 5: google.cloud.translation.v3beta1.TranslateTextResponse
	(*Translation)(nil),                  // 6: google.cloud.translation.v3beta1.Translation
	(*DetectLanguageRequest)(nil),        // 7: google.cloud.translation.v3beta1.DetectLanguageRequest
	(*DetectedLanguage)(nil),             // 8: google.cloud.translation.v3beta1.DetectedLanguage
	(*DetectLanguageResponse)(nil),       // 9: google.cloud.translation.v3beta1.DetectLanguageResponse
	(*GetSupportedLanguagesRequest)(nil), // 10: google.cloud.translation.v3beta1.GetSupportedLanguagesRequest
	(*SupportedLanguages)(nil),           // 11: google.cloud.translation.v3beta1.SupportedLanguages
	(*SupportedLanguage)(nil),            // 12: google.cloud.translation.v3beta1.SupportedLanguage
	(*GcsSource)(nil),                    // 13: google.cloud.translation.v3beta1.GcsSource
	(*InputConfig)(nil),                  // 14: google.cloud.translation.v3beta1.InputConfig
	(*GcsDestination)(nil),               // 15: google.cloud.translation.v3beta1.GcsDestination
	(*OutputConfig)(nil),                 // 16: google.cloud.translation.v3beta1.OutputConfig
	(*BatchTranslateTextRequest)(nil),    // 17: google.cloud.translation.v3beta1.BatchTranslateTextRequest
	(*BatchTranslateMetadata)(nil),       // 18: google.cloud.translation.v3beta1.BatchTranslateMetadata
	(*BatchTranslateResponse)(nil),       // 19: google.cloud.translation.v3beta1.BatchTranslateResponse
	(*GlossaryInputConfig)(nil),          // 20: google.cloud.translation.v3beta1.GlossaryInputConfig
	(*Glossary)(nil),                     // 21: google.cloud.translation.v3beta1.Glossary
	(*CreateGlossaryRequest)(nil),        // 22: google.cloud.translation.v3beta1.CreateGlossaryRequest
	(*GetGlossaryRequest)(nil),           // 23: google.cloud.translation.v3beta1.GetGlossaryRequest
	(*DeleteGlossaryRequest)(nil),        // 24: google.cloud.translation.v3beta1.DeleteGlossaryRequest
	(*ListGlossariesRequest)(nil),        // 25: google.cloud.translation.v3beta1.ListGlossariesRequest
	(*ListGlossariesResponse)(nil),       // 26: google.cloud.translation.v3beta1.ListGlossariesResponse
	(*CreateGlossaryMetadata)(nil),       // 27: google.cloud.translation.v3beta1.CreateGlossaryMetadata
	(*DeleteGlossaryMetadata)(nil),       // 28: google.cloud.translation.v3beta1.DeleteGlossaryMetadata
	(*DeleteGlossaryResponse)(nil),       // 29: google.cloud.translation.v3beta1.DeleteGlossaryResponse
	nil,                                  // 30: google.cloud.translation.v3beta1.TranslateTextRequest.LabelsEntry
	nil,                                  // 31: google.cloud.translation.v3beta1.DetectLanguageRequest.LabelsEntry
	nil,                                  // 32: google.cloud.translation.v3beta1.BatchTranslateTextRequest.ModelsEntry
	nil,                                  // 33: google.cloud.translation.v3beta1.BatchTranslateTextRequest.GlossariesEntry
	nil,                                  // 34: google.cloud.translation.v3beta1.BatchTranslateTextRequest.LabelsEntry
	(*Glossary_LanguageCodePair)(nil),    // 35: google.cloud.translation.v3beta1.Glossary.LanguageCodePair
	(*Glossary_LanguageCodesSet)(nil),    // 36: google.cloud.translation.v3beta1.Glossary.LanguageCodesSet
	(*timestamppb.Timestamp)(nil),        // 37: google.protobuf.Timestamp
	(*longrunning.Operation)(nil),        // 38: google.longrunning.Operation
}
var file_google_cloud_translate_v3beta1_translation_service_proto_depIdxs = []int32{
	3,  // 0: google.cloud.translation.v3beta1.TranslateTextRequest.glossary_config:type_name -> google.cloud.translation.v3beta1.TranslateTextGlossaryConfig
	30, // 1: google.cloud.translation.v3beta1.TranslateTextRequest.labels:type_name -> google.cloud.translation.v3beta1.TranslateTextRequest.LabelsEntry
	6,  // 2: google.cloud.translation.v3beta1.TranslateTextResponse.translations:type_name -> google.cloud.translation.v3beta1.Translation
	6,  // 3: google.cloud.translation.v3beta1.TranslateTextResponse.glossary_translations:type_name -> google.cloud.translation.v3beta1.Translation
	3,  // 4: google.cloud.translation.v3beta1.Translation.glossary_config:type_name -> google.cloud.translation.v3beta1.TranslateTextGlossaryConfig
	31, // 5: google.cloud.translation.v3beta1.DetectLanguageRequest.labels:type_name -> google.cloud.translation.v3beta1.DetectLanguageRequest.LabelsEntry
	8,  // 6: google.cloud.translation.v3beta1.DetectLanguageResponse.languages:type_name -> google.cloud.translation.v3beta1.DetectedLanguage
	12, // 7: google.cloud.translation.v3beta1.SupportedLanguages.languages:type_name -> google.cloud.translation.v3beta1.SupportedLanguage
	13, // 8: google.cloud.translation.v3beta1.InputConfig.gcs_source:type_name -> google.cloud.translation.v3beta1.GcsSource
	15, // 9: google.cloud.translation.v3beta1.OutputConfig.gcs_destination:type_name -> google.cloud.translation.v3beta1.GcsDestination
	32, // 10: google.cloud.translation.v3beta1.BatchTranslateTextRequest.models:type_name -> google.cloud.translation.v3beta1.BatchTranslateTextRequest.ModelsEntry
	14, // 11: google.cloud.translation.v3beta1.BatchTranslateTextRequest.input_configs:type_name -> google.cloud.translation.v3beta1.InputConfig
	16, // 12: google.cloud.translation.v3beta1.BatchTranslateTextRequest.output_config:type_name -> google.cloud.translation.v3beta1.OutputConfig
	33, // 13: google.cloud.translation.v3beta1.BatchTranslateTextRequest.glossaries:type_name -> google.cloud.translation.v3beta1.BatchTranslateTextRequest.GlossariesEntry
	34, // 14: google.cloud.translation.v3beta1.BatchTranslateTextRequest.labels:type_name -> google.cloud.translation.v3beta1.BatchTranslateTextRequest.LabelsEntry
	0,  // 15: google.cloud.translation.v3beta1.BatchTranslateMetadata.state:type_name -> google.cloud.translation.v3beta1.BatchTranslateMetadata.State
	37, // 16: google.cloud.translation.v3beta1.BatchTranslateMetadata.submit_time:type_name -> google.protobuf.Timestamp
	37, // 17: google.cloud.translation.v3beta1.BatchTranslateResponse.submit_time:type_name -> google.protobuf.Timestamp
	37, // 18: google.cloud.translation.v3beta1.BatchTranslateResponse.end_time:type_name -> google.protobuf.Timestamp
	13, // 19: google.cloud.translation.v3beta1.GlossaryInputConfig.gcs_source:type_name -> google.cloud.translation.v3beta1.GcsSource
	35, // 20: google.cloud.translation.v3beta1.Glossary.language_pair:type_name -> google.cloud.translation.v3beta1.Glossary.LanguageCodePair
	36, // 21: google.cloud.translation.v3beta1.Glossary.language_codes_set:type_name -> google.cloud.translation.v3beta1.Glossary.LanguageCodesSet
	20, // 22: google.cloud.translation.v3beta1.Glossary.input_config:type_name -> google.cloud.translation.v3beta1.GlossaryInputConfig
	37, // 23: google.cloud.translation.v3beta1.Glossary.submit_time:type_name -> google.protobuf.Timestamp
	37, // 24: google.cloud.translation.v3beta1.Glossary.end_time:type_name -> google.protobuf.Timestamp
	21, // 25: google.cloud.translation.v3beta1.CreateGlossaryRequest.glossary:type_name -> google.cloud.translation.v3beta1.Glossary
	21, // 26: google.cloud.translation.v3beta1.ListGlossariesResponse.glossaries:type_name -> google.cloud.translation.v3beta1.Glossary
	1,  // 27: google.cloud.translation.v3beta1.CreateGlossaryMetadata.state:type_name -> google.cloud.translation.v3beta1.CreateGlossaryMetadata.State
	37, // 28: google.cloud.translation.v3beta1.CreateGlossaryMetadata.submit_time:type_name -> google.protobuf.Timestamp
	2,  // 29: google.cloud.translation.v3beta1.DeleteGlossaryMetadata.state:type_name -> google.cloud.translation.v3beta1.DeleteGlossaryMetadata.State
	37, // 30: google.cloud.translation.v3beta1.DeleteGlossaryMetadata.submit_time:type_name -> google.protobuf.Timestamp
	37, // 31: google.cloud.translation.v3beta1.DeleteGlossaryResponse.submit_time:type_name -> google.protobuf.Timestamp
	37, // 32: google.cloud.translation.v3beta1.DeleteGlossaryResponse.end_time:type_name -> google.protobuf.Timestamp
	3,  // 33: google.cloud.translation.v3beta1.BatchTranslateTextRequest.GlossariesEntry.value:type_name -> google.cloud.translation.v3beta1.TranslateTextGlossaryConfig
	4,  // 34: google.cloud.translation.v3beta1.TranslationService.TranslateText:input_type -> google.cloud.translation.v3beta1.TranslateTextRequest
	7,  // 35: google.cloud.translation.v3beta1.TranslationService.DetectLanguage:input_type -> google.cloud.translation.v3beta1.DetectLanguageRequest
	10, // 36: google.cloud.translation.v3beta1.TranslationService.GetSupportedLanguages:input_type -> google.cloud.translation.v3beta1.GetSupportedLanguagesRequest
	17, // 37: google.cloud.translation.v3beta1.TranslationService.BatchTranslateText:input_type -> google.cloud.translation.v3beta1.BatchTranslateTextRequest
	22, // 38: google.cloud.translation.v3beta1.TranslationService.CreateGlossary:input_type -> google.cloud.translation.v3beta1.CreateGlossaryRequest
	25, // 39: google.cloud.translation.v3beta1.TranslationService.ListGlossaries:input_type -> google.cloud.translation.v3beta1.ListGlossariesRequest
	23, // 40: google.cloud.translation.v3beta1.TranslationService.GetGlossary:input_type -> google.cloud.translation.v3beta1.GetGlossaryRequest
	24, // 41: google.cloud.translation.v3beta1.TranslationService.DeleteGlossary:input_type -> google.cloud.translation.v3beta1.DeleteGlossaryRequest
	5,  // 42: google.cloud.translation.v3beta1.TranslationService.TranslateText:output_type -> google.cloud.translation.v3beta1.TranslateTextResponse
	9,  // 43: google.cloud.translation.v3beta1.TranslationService.DetectLanguage:output_type -> google.cloud.translation.v3beta1.DetectLanguageResponse
	11, // 44: google.cloud.translation.v3beta1.TranslationService.GetSupportedLanguages:output_type -> google.cloud.translation.v3beta1.SupportedLanguages
	38, // 45: google.cloud.translation.v3beta1.TranslationService.BatchTranslateText:output_type -> google.longrunning.Operation
	38, // 46: google.cloud.translation.v3beta1.TranslationService.CreateGlossary:output_type -> google.longrunning.Operation
	26, // 47: google.cloud.translation.v3beta1.TranslationService.ListGlossaries:output_type -> google.cloud.translation.v3beta1.ListGlossariesResponse
	21, // 48: google.cloud.translation.v3beta1.TranslationService.GetGlossary:output_type -> google.cloud.translation.v3beta1.Glossary
	38, // 49: google.cloud.translation.v3beta1.TranslationService.DeleteGlossary:output_type -> google.longrunning.Operation
	42, // [42:50] is the sub-list for method output_type
	34, // [34:42] is the sub-list for method input_type
	34, // [34:34] is the sub-list for extension type_name
	34, // [34:34] is the sub-list for extension extendee
	0,  // [0:34] is the sub-list for field type_name
}

func init() { file_google_cloud_translate_v3beta1_translation_service_proto_init() }
func file_google_cloud_translate_v3beta1_translation_service_proto_init() {
	if File_google_cloud_translate_v3beta1_translation_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TranslateTextGlossaryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TranslateTextRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TranslateTextResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Translation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DetectLanguageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DetectedLanguage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DetectLanguageResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSupportedLanguagesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SupportedLanguages); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SupportedLanguage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchTranslateTextRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchTranslateMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchTranslateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GlossaryInputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Glossary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateGlossaryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGlossaryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGlossaryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGlossariesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGlossariesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateGlossaryMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGlossaryMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGlossaryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Glossary_LanguageCodePair); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Glossary_LanguageCodesSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*DetectLanguageRequest_Content)(nil),
	}
	file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*InputConfig_GcsSource)(nil),
	}
	file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*OutputConfig_GcsDestination)(nil),
	}
	file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[17].OneofWrappers = []interface{}{
		(*GlossaryInputConfig_GcsSource)(nil),
	}
	file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes[18].OneofWrappers = []interface{}{
		(*Glossary_LanguagePair)(nil),
		(*Glossary_LanguageCodesSet_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_translate_v3beta1_translation_service_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   34,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_translate_v3beta1_translation_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_translate_v3beta1_translation_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_translate_v3beta1_translation_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_translate_v3beta1_translation_service_proto_msgTypes,
	}.Build()
	File_google_cloud_translate_v3beta1_translation_service_proto = out.File
	file_google_cloud_translate_v3beta1_translation_service_proto_rawDesc = nil
	file_google_cloud_translate_v3beta1_translation_service_proto_goTypes = nil
	file_google_cloud_translate_v3beta1_translation_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TranslationServiceClient is the client API for TranslationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TranslationServiceClient interface {
	// Translates input text and returns translated text.
	TranslateText(ctx context.Context, in *TranslateTextRequest, opts ...grpc.CallOption) (*TranslateTextResponse, error)
	// Detects the language of text within a request.
	DetectLanguage(ctx context.Context, in *DetectLanguageRequest, opts ...grpc.CallOption) (*DetectLanguageResponse, error)
	// Returns a list of supported languages for translation.
	GetSupportedLanguages(ctx context.Context, in *GetSupportedLanguagesRequest, opts ...grpc.CallOption) (*SupportedLanguages, error)
	// Translates a large volume of text in asynchronous batch mode.
	// This function provides real-time output as the inputs are being processed.
	// If caller cancels a request, the partial results (for an input file, it's
	// all or nothing) may still be available on the specified output location.
	//
	// This call returns immediately and you can
	// use google.longrunning.Operation.name to poll the status of the call.
	BatchTranslateText(ctx context.Context, in *BatchTranslateTextRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a glossary and returns the long-running operation. Returns
	// NOT_FOUND, if the project doesn't exist.
	CreateGlossary(ctx context.Context, in *CreateGlossaryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists glossaries in a project. Returns NOT_FOUND, if the project doesn't
	// exist.
	ListGlossaries(ctx context.Context, in *ListGlossariesRequest, opts ...grpc.CallOption) (*ListGlossariesResponse, error)
	// Gets a glossary. Returns NOT_FOUND, if the glossary doesn't
	// exist.
	GetGlossary(ctx context.Context, in *GetGlossaryRequest, opts ...grpc.CallOption) (*Glossary, error)
	// Deletes a glossary, or cancels glossary construction
	// if the glossary isn't created yet.
	// Returns NOT_FOUND, if the glossary doesn't exist.
	DeleteGlossary(ctx context.Context, in *DeleteGlossaryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type translationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewTranslationServiceClient(cc grpc.ClientConnInterface) TranslationServiceClient {
	return &translationServiceClient{cc}
}

func (c *translationServiceClient) TranslateText(ctx context.Context, in *TranslateTextRequest, opts ...grpc.CallOption) (*TranslateTextResponse, error) {
	out := new(TranslateTextResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3beta1.TranslationService/TranslateText", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) DetectLanguage(ctx context.Context, in *DetectLanguageRequest, opts ...grpc.CallOption) (*DetectLanguageResponse, error) {
	out := new(DetectLanguageResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3beta1.TranslationService/DetectLanguage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) GetSupportedLanguages(ctx context.Context, in *GetSupportedLanguagesRequest, opts ...grpc.CallOption) (*SupportedLanguages, error) {
	out := new(SupportedLanguages)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3beta1.TranslationService/GetSupportedLanguages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) BatchTranslateText(ctx context.Context, in *BatchTranslateTextRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3beta1.TranslationService/BatchTranslateText", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) CreateGlossary(ctx context.Context, in *CreateGlossaryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3beta1.TranslationService/CreateGlossary", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ListGlossaries(ctx context.Context, in *ListGlossariesRequest, opts ...grpc.CallOption) (*ListGlossariesResponse, error) {
	out := new(ListGlossariesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3beta1.TranslationService/ListGlossaries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) GetGlossary(ctx context.Context, in *GetGlossaryRequest, opts ...grpc.CallOption) (*Glossary, error) {
	out := new(Glossary)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3beta1.TranslationService/GetGlossary", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) DeleteGlossary(ctx context.Context, in *DeleteGlossaryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3beta1.TranslationService/DeleteGlossary", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TranslationServiceServer is the server API for TranslationService service.
type TranslationServiceServer interface {
	// Translates input text and returns translated text.
	TranslateText(context.Context, *TranslateTextRequest) (*TranslateTextResponse, error)
	// Detects the language of text within a request.
	DetectLanguage(context.Context, *DetectLanguageRequest) (*DetectLanguageResponse, error)
	// Returns a list of supported languages for translation.
	GetSupportedLanguages(context.Context, *GetSupportedLanguagesRequest) (*SupportedLanguages, error)
	// Translates a large volume of text in asynchronous batch mode.
	// This function provides real-time output as the inputs are being processed.
	// If caller cancels a request, the partial results (for an input file, it's
	// all or nothing) may still be available on the specified output location.
	//
	// This call returns immediately and you can
	// use google.longrunning.Operation.name to poll the status of the call.
	BatchTranslateText(context.Context, *BatchTranslateTextRequest) (*longrunning.Operation, error)
	// Creates a glossary and returns the long-running operation. Returns
	// NOT_FOUND, if the project doesn't exist.
	CreateGlossary(context.Context, *CreateGlossaryRequest) (*longrunning.Operation, error)
	// Lists glossaries in a project. Returns NOT_FOUND, if the project doesn't
	// exist.
	ListGlossaries(context.Context, *ListGlossariesRequest) (*ListGlossariesResponse, error)
	// Gets a glossary. Returns NOT_FOUND, if the glossary doesn't
	// exist.
	GetGlossary(context.Context, *GetGlossaryRequest) (*Glossary, error)
	// Deletes a glossary, or cancels glossary construction
	// if the glossary isn't created yet.
	// Returns NOT_FOUND, if the glossary doesn't exist.
	DeleteGlossary(context.Context, *DeleteGlossaryRequest) (*longrunning.Operation, error)
}

// UnimplementedTranslationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedTranslationServiceServer struct {
}

func (*UnimplementedTranslationServiceServer) TranslateText(context.Context, *TranslateTextRequest) (*TranslateTextResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TranslateText not implemented")
}
func (*UnimplementedTranslationServiceServer) DetectLanguage(context.Context, *DetectLanguageRequest) (*DetectLanguageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetectLanguage not implemented")
}
func (*UnimplementedTranslationServiceServer) GetSupportedLanguages(context.Context, *GetSupportedLanguagesRequest) (*SupportedLanguages, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSupportedLanguages not implemented")
}
func (*UnimplementedTranslationServiceServer) BatchTranslateText(context.Context, *BatchTranslateTextRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchTranslateText not implemented")
}
func (*UnimplementedTranslationServiceServer) CreateGlossary(context.Context, *CreateGlossaryRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGlossary not implemented")
}
func (*UnimplementedTranslationServiceServer) ListGlossaries(context.Context, *ListGlossariesRequest) (*ListGlossariesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGlossaries not implemented")
}
func (*UnimplementedTranslationServiceServer) GetGlossary(context.Context, *GetGlossaryRequest) (*Glossary, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGlossary not implemented")
}
func (*UnimplementedTranslationServiceServer) DeleteGlossary(context.Context, *DeleteGlossaryRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGlossary not implemented")
}

func RegisterTranslationServiceServer(s *grpc.Server, srv TranslationServiceServer) {
	s.RegisterService(&_TranslationService_serviceDesc, srv)
}

func _TranslationService_TranslateText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TranslateTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).TranslateText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3beta1.TranslationService/TranslateText",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).TranslateText(ctx, req.(*TranslateTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_DetectLanguage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetectLanguageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).DetectLanguage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3beta1.TranslationService/DetectLanguage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).DetectLanguage(ctx, req.(*DetectLanguageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_GetSupportedLanguages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSupportedLanguagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).GetSupportedLanguages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3beta1.TranslationService/GetSupportedLanguages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).GetSupportedLanguages(ctx, req.(*GetSupportedLanguagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_BatchTranslateText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchTranslateTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).BatchTranslateText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3beta1.TranslationService/BatchTranslateText",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).BatchTranslateText(ctx, req.(*BatchTranslateTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_CreateGlossary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGlossaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).CreateGlossary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3beta1.TranslationService/CreateGlossary",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).CreateGlossary(ctx, req.(*CreateGlossaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ListGlossaries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGlossariesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ListGlossaries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3beta1.TranslationService/ListGlossaries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ListGlossaries(ctx, req.(*ListGlossariesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_GetGlossary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlossaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).GetGlossary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3beta1.TranslationService/GetGlossary",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).GetGlossary(ctx, req.(*GetGlossaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_DeleteGlossary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGlossaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).DeleteGlossary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3beta1.TranslationService/DeleteGlossary",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).DeleteGlossary(ctx, req.(*DeleteGlossaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TranslationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.translation.v3beta1.TranslationService",
	HandlerType: (*TranslationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "TranslateText",
			Handler:    _TranslationService_TranslateText_Handler,
		},
		{
			MethodName: "DetectLanguage",
			Handler:    _TranslationService_DetectLanguage_Handler,
		},
		{
			MethodName: "GetSupportedLanguages",
			Handler:    _TranslationService_GetSupportedLanguages_Handler,
		},
		{
			MethodName: "BatchTranslateText",
			Handler:    _TranslationService_BatchTranslateText_Handler,
		},
		{
			MethodName: "CreateGlossary",
			Handler:    _TranslationService_CreateGlossary_Handler,
		},
		{
			MethodName: "ListGlossaries",
			Handler:    _TranslationService_ListGlossaries_Handler,
		},
		{
			MethodName: "GetGlossary",
			Handler:    _TranslationService_GetGlossary_Handler,
		},
		{
			MethodName: "DeleteGlossary",
			Handler:    _TranslationService_DeleteGlossary_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/translate/v3beta1/translation_service.proto",
}
