// Code generated by ifacemaker; DO NOT EDIT.

package hcloud

import (
	"context"
)

// IZoneClient ...
type IZoneClient interface {
	// GetByID returns a single [Zone].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zones-get-a-zone
	GetByID(ctx context.Context, id int64) (*Zone, *Response, error)
	// GetByName returns a single [Zone].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zones-get-a-zone
	GetByName(ctx context.Context, name string) (*Zone, *Response, error)
	// Get returns a single [Zone].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zones-get-a-zone
	Get(ctx context.Context, idOrName string) (*Zone, *Response, error)
	// List returns a list of [Zone] for a specific page.
	//
	// See https://docs.hetzner.cloud/reference/cloud#zones-list-zones
	List(ctx context.Context, opts ZoneListOpts) ([]*Zone, *Response, error)
	// All returns a list of all [Zone].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zones-list-zones
	All(ctx context.Context) ([]*Zone, error)
	// AllWithOpts returns a list of all [Zone] with the given options.
	//
	// See https://docs.hetzner.cloud/reference/cloud#zones-list-zones
	AllWithOpts(ctx context.Context, opts ZoneListOpts) ([]*Zone, error)
	// Create creates a new [Zone] from the given options.
	//
	// See https://docs.hetzner.cloud/reference/cloud#zones-create-a-zone
	Create(ctx context.Context, opts ZoneCreateOpts) (ZoneCreateResult, *Response, error)
	// Update updates a [Zone] with the given options.
	//
	// See https://docs.hetzner.cloud/reference/cloud#zones-update-a-zone
	Update(ctx context.Context, zone *Zone, opts ZoneUpdateOpts) (*Zone, *Response, error)
	// Delete deletes a [Zone].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zones-delete-a-zone
	Delete(ctx context.Context, zone *Zone) (ZoneDeleteResult, *Response, error)
	// ExportZonefile returns a generated [Zone] file in BIND (RFC 1034/1035) format.
	//
	// See https://docs.hetzner.cloud/reference/cloud#zones-export-a-zone-file
	ExportZonefile(ctx context.Context, zone *Zone) (ZoneExportZonefileResult, *Response, error)
	// ImportZonefile imports a zone file, replacing all resource record sets (RRSets).
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-actions-import-a-zone-file
	ImportZonefile(ctx context.Context, zone *Zone, opts ZoneImportZonefileOpts) (*Action, *Response, error)
	// ChangeProtection changes the protection of a [Zone].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-actions-change-a-zones-protection
	ChangeProtection(ctx context.Context, zone *Zone, opts ZoneChangeProtectionOpts) (*Action, *Response, error)
	// ChangeTTL changes the TTL of a [Zone].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-actions-change-a-zones-default-ttl
	ChangeTTL(ctx context.Context, zone *Zone, opts ZoneChangeTTLOpts) (*Action, *Response, error)
	// ChangePrimaryNameservers changes the primary nameservers of a [Zone].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-actions-change-a-zones-primary-nameservers
	ChangePrimaryNameservers(ctx context.Context, zone *Zone, opts ZoneChangePrimaryNameserversOpts) (*Action, *Response, error)
	// GetRRSetByNameAndType returns a single [ZoneRRSet].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-rrsets-get-an-rrset
	GetRRSetByNameAndType(ctx context.Context, zone *Zone, rrsetName string, rrsetType ZoneRRSetType) (*ZoneRRSet, *Response, error)
	// GetRRSetByID returns a single [ZoneRRSet].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-rrsets-get-an-rrset
	GetRRSetByID(ctx context.Context, zone *Zone, rrsetID string) (*ZoneRRSet, *Response, error)
	// ListRRSets returns a list of [ZoneRRSet] for a specific page.
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-rrsets-list-rrsets
	ListRRSets(ctx context.Context, zone *Zone, opts ZoneRRSetListOpts) ([]*ZoneRRSet, *Response, error)
	// AllRRSetsWithOpts returns a list of all [ZoneRRSet] with the given options.
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-rrsets-list-rrsets
	AllRRSetsWithOpts(ctx context.Context, zone *Zone, opts ZoneRRSetListOpts) ([]*ZoneRRSet, error)
	// AllRRSets returns a list of all [ZoneRRSet].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-rrsets-list-rrsets
	AllRRSets(ctx context.Context, zone *Zone) ([]*ZoneRRSet, error)
	// CreateRRSet creates a new [ZoneRRSet] from the given options.
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-rrsets-create-an-rrset
	CreateRRSet(ctx context.Context, zone *Zone, opts ZoneRRSetCreateOpts) (ZoneRRSetCreateResult, *Response, error)
	// UpdateRRSet updates a [ZoneRRSet] with the given options.
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-rrsets-update-an-rrset
	UpdateRRSet(ctx context.Context, rrset *ZoneRRSet, opts ZoneRRSetUpdateOpts) (*ZoneRRSet, *Response, error)
	// DeleteRRSet deletes a [ZoneRRSet].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-rrsets-delete-an-rrset
	DeleteRRSet(ctx context.Context, rrset *ZoneRRSet) (ZoneRRSetDeleteResult, *Response, error)
	// ChangeRRSetProtection changes the protection of a [ZoneRRSet].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-rrset-actions-change-an-rrsets-protection
	ChangeRRSetProtection(ctx context.Context, rrset *ZoneRRSet, opts ZoneRRSetChangeProtectionOpts) (*Action, *Response, error)
	// ChangeRRSetTTL changes the TTL of a [ZoneRRSet].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-rrset-actions-change-an-rrsets-ttl
	ChangeRRSetTTL(ctx context.Context, rrset *ZoneRRSet, opts ZoneRRSetChangeTTLOpts) (*Action, *Response, error)
	// SetRRSetRecords overwrites the records of a [ZoneRRSet].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-rrset-actions-set-records-of-an-rrset
	SetRRSetRecords(ctx context.Context, rrset *ZoneRRSet, opts ZoneRRSetSetRecordsOpts) (*Action, *Response, error)
	// AddRRSetRecords adds records to a [ZoneRRSet].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-rrset-actions-add-records-to-an-rrset
	AddRRSetRecords(ctx context.Context, rrset *ZoneRRSet, opts ZoneRRSetAddRecordsOpts) (*Action, *Response, error)
	// UpdateRRSetRecords updates records of a [ZoneRRSet].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-rrset-actions-add-records-to-an-rrset
	UpdateRRSetRecords(ctx context.Context, rrset *ZoneRRSet, opts ZoneRRSetUpdateRecordsOpts) (*Action, *Response, error)
	// RemoveRRSetRecords removes records from a [ZoneRRSet].
	//
	// See https://docs.hetzner.cloud/reference/cloud#zone-rrset-actions-remove-records-from-an-rrset
	RemoveRRSetRecords(ctx context.Context, rrset *ZoneRRSet, opts ZoneRRSetRemoveRecordsOpts) (*Action, *Response, error)
}
