      SUBROUTINE DPDIA2(X1,Y1,X2,Y2,X3,Y3,
     1IFIG,
     1ILINPA,ILINCO,PLINTH,
     1AREGBA,
     1IREBLI,IREBCO,PREBTH,
     1IREFSW,IREFCO,
     1IREPTY,IREPLI,IREPCO,PREPTH,PREPSP,
     1PTEXHE,PTEXWI,PTEXVG,PTEXHG)
C
C     PURPOSE--DRAW A DIAMOND
C              WITH ONE END OF THE MAJOR AXIS AT (X1,Y1)
C              WITH ONE END OF THE MINOR AXIS AT (X2,Y2)
C              AND THE OTHER END OF MAJOR AXIS AT (X3,Y3).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--APRIL     1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --JANUARY   1989.  MODIFY CALLS TO DPDRPL (ALAN)
C     UPDATED         --JANUARY   1989.  MODIFY CALL  TO DPFIRE (ALAN)
C
C-----NON-COMMON VARIABLES-------------------------------------
C
      CHARACTER*4 IFIG
      CHARACTER*4 IPATT2
C
      CHARACTER*4 ILINPA
      CHARACTER*4 ILINCO
C
      CHARACTER*4 IREBLI
      CHARACTER*4 IREBCO
      CHARACTER*4 IREFSW
      CHARACTER*4 IREFCO
      CHARACTER*4 IREPTY
      CHARACTER*4 IREPLI
      CHARACTER*4 IREPCO
C
      CHARACTER*4 IPATT
      CHARACTER*4 ICOLF
      CHARACTER*4 ICOLP
      CHARACTER*4 ICOL
      CHARACTER*4 IFLAG
C
      DIMENSION PX(10)
      DIMENSION PY(10)
CCCCC DIMENSION PX3(10)
CCCCC DIMENSION PY3(10)
C
      DIMENSION ILINPA(*)
      DIMENSION ILINCO(*)
      DIMENSION PLINTH(*)
C
      DIMENSION AREGBA(*)
      DIMENSION IREBLI(*)
      DIMENSION IREBCO(*)
      DIMENSION PREBTH(*)
      DIMENSION IREFSW(*)
      DIMENSION IREFCO(*)
      DIMENSION IREPTY(*)
      DIMENSION IREPLI(*)
      DIMENSION IREPCO(*)
      DIMENSION PREPTH(*)
      DIMENSION PREPSP(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DIA2')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPDIA2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)X1,Y1
   53 FORMAT('X1,Y1 = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)X2,Y2
   54 FORMAT('X2,Y2 = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,59)IFIG
   59 FORMAT('IFIG = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)ILINPA(1),ILINCO(1),PLINTH(1)
   61 FORMAT('ILINPA(1),ILINCO(1),PLINTH(1) = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)AREGBA(1)
   62 FORMAT('AREGBA(1) = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,63)IREBLI(1),IREBCO(1),PREBTH(1)
   63 FORMAT('IREBLI(1),IREBCO(1),PREBTH(1) = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,64)IREFSW(1),IREFCO(1)
   64 FORMAT('IREFSW(1),IREFCO(1) = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,65)IREPTY(1),IREPLI(1),IREPCO(1),PREPTH(1),PREPSP(1)
   65 FORMAT('IREPTY(1),IREPLI(1),IREPCO(1),PREPTH(1),PREPSP(1) = ',
     1A4,2X,A4,2X,A4,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,69)PTEXHE,PTEXWI
   69 FORMAT('PTEXHE,PTEXWI= ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,70)PTEXVG,PTEXHG
   70 FORMAT('PTEXVG,PTEXHG= ',2E15.6)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,79)IBUGG4,ISUBG4,IERRG4
   79 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               *********************************
C               **  STEP 1--                   **
C               **  DETERMINE THE COORDINATES  **
C               **  FOR THE DIAMOND            **
C               *********************************
C
      XC=(X1+X3)/2.0
      YC=(Y1+Y3)/2.0
C
      XDEL=XC-X2
      YDEL=YC-Y2
C
      X4=XC+XDEL
      Y4=YC+YDEL
C
      PX(1)=X1
      PY(1)=Y1
C
      PX(2)=X2
      PY(2)=Y2
C
      PX(3)=X3
      PY(3)=Y3
C
      PX(4)=X4
      PY(4)=Y4
C
      PX(5)=X1
      PY(5)=Y1
C
      NP=5
C
C
C               ***********************
C               **  STEP 2--         **
C               **  FILL THE FIGURE  **
C               **  (IF CALLED FOR)  **
C               ***********************
C
      IF(IREFSW(1).EQ.'OFF')GOTO2190
      IPATT=IREPTY(1)
      IPATT2='SOLI'
      PTHICK=PREPTH(1)
      PXGAP=PREPSP(1)
      PYGAP=PREPSP(1)
      ICOLF=IREFCO(1)
      ICOLP=IREPCO(1)
      CALL DPFIRE(PX,PY,NP,
     1IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP,IPATT2)
 2190 CONTINUE
C
C               ***************************
C               **  STEP 3--             **
C               **  DRAW OUT THE FIGURE  **
C               ***************************
C
      IPATT=ILINPA(1)
      PTHICK=PLINTH(1)
      ICOL=ILINCO(1)
      IFLAG='ON'
CCCCC CALL \PDRPL(PX,PY,NP,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DIA2')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPDIA2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)XC,YC,XDEL,YDEL
 9012 FORMAT('XC,YC,XDEL,YDEL = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)NP
 9014 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9015I=1,NP
      WRITE(ICOUT,9016)I,PX(I),PY(I)
 9016 FORMAT('I,PX(I),PY(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
 9015 CONTINUE
      WRITE(ICOUT,9039)IBUGG4,ISUBG4,IERRG4
 9039 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPDIAL(IHARG,IARGT,IARG,NUMARG,
     1IGRASW,PDIAXC,PDIAYC,
     1NUMDEV,
     1IDMANU,IDMODE,IDMOD2,IDMOD3,
     1IDPOWE,IDCONT,IDCOLO,IDNVPP,IDNHPP,IDUNIT,
     1IDNVOF,IDNHOF,
CCCCC ADD FOLLOWING LINE MARCH 1997.
     1IDFONT,
     1IBUGD2,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--SWITCH THE TERMINAL INTO DIALOGUE (= NON-GRAPHICS) MODE
C     INPUT  ARGUMENTS--IHARG  (A  CHARACTER VECTOR)
C                     --IARGT  (A  CHARACTER VECTOR)
C                     --IARG   (AN INTEGER VECTOR)
C                     --NUMARG
C     OUTPUT ARGUMENTS--IFOUND ('YES' OR 'NO')
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 WASHINGTON  D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--85/1
C     ORIGINAL VERSION--NOVEMBER  1984.
C     UPDATED         --MARCH     1997.  SUPPORT FOR DEVICE FONT (ALAN)
C
C-----NON-COMMON VARIABLES----------------------------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IARGT
C
      CHARACTER*4 IGRASW
C
      CHARACTER*4 IDMANU
      CHARACTER*4 IDMODE
      CHARACTER*4 IDMOD2
      CHARACTER*4 IDMOD3
C
      CHARACTER*4 IDPOWE
      CHARACTER*4 IDCONT
      CHARACTER*4 IDCOLO
CCCCC ADD FOLLOWING LINE MARCH 1997.
      CHARACTER*4 IDFONT
C
      CHARACTER*4 IFOUND
      CHARACTER*4 IBUGD2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION IHARG(*)
      DIMENSION IARGT(*)
      DIMENSION IARG(*)
C
      DIMENSION IDMANU(*)
      DIMENSION IDMODE(*)
      DIMENSION IDMOD2(*)
      DIMENSION IDMOD3(*)
C
      DIMENSION IDPOWE(*)
      DIMENSION IDCONT(*)
      DIMENSION IDCOLO(*)
CCCCC ADD FOLLOWING LINE MARCH 1997.
      DIMENSION IDFONT(*)
      DIMENSION IDNVPP(*)
      DIMENSION IDNHPP(*)
      DIMENSION IDUNIT(*)
C
      DIMENSION IDNVOF(*)
      DIMENSION IDNHOF(*)
C
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDI'
      ISUBN2='AL  '
C
      IFOUND='NO'
      IERROR='NO'
C
      IBUGG4=IBUGD2
      ISUBG4=ISUBRO
      IERRG4=IERROR
C
      IF(IBUGD2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('AT THE BEGINNING OF DPDIAL--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IBUGD2,IBUGG4
   53 FORMAT('IBUGD2,IBUGG4 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IFOUND,IERROR
   54 FORMAT('IFOUND,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IGRASW,PDIAXC,PDIAYC
   55 FORMAT('IGRASW,PDIAXC,PDIAYC = ',A4,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,60)NUMARG
   60 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO61I=1,NUMARG
      WRITE(ICOUT,62)I,IHARG(I),IARGT(I),IARG(I)
   62 FORMAT('I,IHARG(I),IARGT(I),IARG(I) = ',
     1I8,2X,A4,2X,A4,2X,I8)
      CALL DPWRST('XXX','BUG ')
   61 CONTINUE
      WRITE(ICOUT,70)NUMDEV
   70 FORMAT('NUMDEV = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO71I=1,NUMDEV
      WRITE(ICOUT,72)I,IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I)
   72 FORMAT('I,IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I) = ',
     1I8,2X,A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,73)I,IDPOWE(I),IDCONT(I),IDCOLO(I)
   73 FORMAT('I,IDPOWE(I),IDCONT(I),IDCOLO(I) = ',
     1I8,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,74)I,IDNVPP(I),IDNHPP(I),IDUNIT(I)
   74 FORMAT('I,IDNVPP(I),IDNHPP(I),IDUNIT(I) = ',
     1I8,2X,I8,2X,I8,2X,I8)
      CALL DPWRST('XXX','BUG ')
   71 CONTINUE
      WRITE(ICOUT,82)IMANUF,IMODEL,IMODE2,IMODE3
   82 FORMAT('IMANUF,IMODEL,IMODE2,IMODE3 = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,83)IGCONT,IGCOLO
   83 FORMAT('IGCONT,IGCOLO = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,84)NUMVPP,NUMHPP,ANUMVP,ANUMHP
   84 FORMAT('NUMVPP,NUMHPP,ANUMVP,ANUMHP = ',2I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               ********************************************************
C               **  STEP 1--                                          **
C               **  EXTRACT NEEDED INFORMATION FROM THE COMMAND LINE  **
C               ********************************************************
C
      IF(NUMARG.LE.0)GOTO1110
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'ON')GOTO1110
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'OFF')GOTO1120
      GOTO1110
C
 1110 CONTINUE
      IGRASW='OFF2'
      IFOUND='YES'
      GOTO1190
C
 1120 CONTINUE
      IGRASW='ON2'
      IFOUND='YES'
      GOTO1190
C
 1190 CONTINUE
C
C               ********************************
C               **  STEP 2--                  **
C               **  STEP THROUGH EACH DEVICE  **
C               ********************************
C
      IF(NUMDEV.LE.0)GOTO9000
      DO8000IDEVIC=1,NUMDEV
C
      IF(IDPOWE(IDEVIC).EQ.'OFF')GOTO8000
C
      IMANUF=IDMANU(IDEVIC)
      IMODEL=IDMODE(IDEVIC)
      IMODE2=IDMOD2(IDEVIC)
      IMODE3=IDMOD3(IDEVIC)
      IGCONT=IDCONT(IDEVIC)
      IGCOLO=IDCOLO(IDEVIC)
CCCCC ADD FOLLOWING LINE MARCH 1997.
      IGFONT=IDFONT(IDEVIC)
      NUMVPP=IDNVPP(IDEVIC)
      NUMHPP=IDNHPP(IDEVIC)
      ANUMVP=NUMVPP
      ANUMHP=NUMHPP
C  AUGUST 1988.  ADD OFFSET VARIABLE
      IOFFSV=IDNVOF(IDEVIC)
      IOFFSH=IDNHOF(IDEVIC)
C
      IGUNIT=IDUNIT(IDEVIC)
C
C               *************************************************
C               **  STEP 2.1--                                 **
C               **  TREAT THE DISCRETE TERMINALS CASE          **
C               *************************************************
C
      ISTEPN='2.1'
      IF(IBUGD2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IGCONT.EQ.'OFF')GOTO8000
C
C               **************************************
C               **  STEP 2.2--                      **
C               **  BRANCH TO THE APPROPRIATE CASE  **
C               **  FOR CONTINUOUS TERMINALS        **
C               **************************************
C
 1200 CONTINUE
      ISTEPN='2.2'
      IF(IBUGD2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IGRASW.EQ.'OFF2')GOTO1300
      GOTO1400
C
C               ****************************************
C               **  STEP 2.3--                        **
C               **  TREAT THE DIALOGUE MODE CASE      **
C               **  FOR CONTINUOUS TERMINALS.         **
C               ****************************************
C
 1300 CONTINUE
      ISTEPN='2.3'
      IF(IBUGD2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IBUGD2.EQ.'ON')WRITE(ICOUT,1305)
 1305 FORMAT('*** FROM DPDIAL--ENTRY INTO DIALOGUE MODE ',
     1'SHOULD TAKE PLACE NOW')
      IF(IBUGD2.EQ.'ON')CALL DPWRST('XXX','BUG ')
C
      CALL GRSEMO(IGRASW,PDIAXC,PDIAYC)
C
      IF(IBUGD2.EQ.'ON')WRITE(ICOUT,1306)
 1306 FORMAT('*** FROM DPDIAL--ENTRY INTO DIALOGUE MODE ',
     1'SHOULD HAVE JUST TAKEN PLACE')
      IF(IBUGD2.EQ.'ON')CALL DPWRST('XXX','BUG ')
C
      GOTO8000
C
C               ****************************************
C               **  STEP 2.4--                        **
C               **  TREAT THE GRAPHICS MODE CASE      **
C               **  FOR CONTINUOUS TERMINALS.         **
C               ****************************************
C
 1400 CONTINUE
      ISTEPN='2.4'
      IF(IBUGD2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IBUGD2.EQ.'ON')WRITE(ICOUT,1405)
 1405 FORMAT('*** FROM DPDIAL--ENTRY INTO GRAPHICS MODE ',
     1'SHOULD TAKE PLACE NOW')
      IF(IBUGD2.EQ.'ON')CALL DPWRST('XXX','BUG ')
C
      CALL GRSEMO(IGRASW,PDIAXC,PDIAYC)
C
      IF(IBUGD2.EQ.'ON')WRITE(ICOUT,1206)
 1206 FORMAT('*** FROM DPDIAL--ENTRY INTO GRAPHICS MODE ',
     1'SHOULD HAVE JUST TAKEN PLACE')
      IF(IBUGD2.EQ.'ON')CALL DPWRST('XXX','BUG ')
C
      GOTO8000
C
 8000 CONTINUE
      IF(IGRASW.EQ.'OFF2')IGRASW='OFF'
      IF(IGRASW.EQ.'ON2')IGRASW='ON'
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGD2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('AT THE END       OF DPDIAL--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IBUGD2,IBUGG4
 9013 FORMAT('IBUGD2,IBUGG4 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IFOUND,IERROR
 9014 FORMAT('IFOUND,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IGRASW,PDIAXC,PDIAYC
 9015 FORMAT('IGRASW,PDIAXC,PDIAYC = ',A4,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9020)NUMARG
 9020 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9021I=1,NUMARG
      WRITE(ICOUT,9022)I,IHARG(I),IARGT(I),IARG(I)
 9022 FORMAT('I,IHARG(I),IARGT(I),IARG(I) = ',
     1I8,2X,A4,2X,A4,2X,I8)
      CALL DPWRST('XXX','BUG ')
 9021 CONTINUE
      WRITE(ICOUT,9030)NUMDEV
 9030 FORMAT('NUMDEV = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9031I=1,NUMDEV
      WRITE(ICOUT,9032)I,IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I)
 9032 FORMAT('I,IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I) = ',
     1I8,2X,A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9033)I,IDPOWE(I),IDCONT(I),IDCOLO(I)
 9033 FORMAT('I,IDPOWE(I),IDCONT(I),IDCOLO(I) = ',
     1I8,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9034)I,IDNVPP(I),IDNHPP(I),IDUNIT(I)
 9034 FORMAT('I,IDNVPP(I),IDNHPP(I),IDUNIT(I) = ',
     1I8,2X,I8,2X,I8,2X,I8)
      CALL DPWRST('XXX','BUG ')
 9031 CONTINUE
      WRITE(ICOUT,9042)IMANUF,IMODEL,IMODE2,IMODE3
 9042 FORMAT('IMANUF,IMODEL,IMODE2,IMODE3 = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9043)IGCONT,IGCOLO
 9043 FORMAT('IGCONT,IGCOLO = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9044)NUMVPP,NUMHPP,ANUMVP,ANUMHP
 9044 FORMAT('NUMVPP,NUMHPP,ANUMVP,ANUMHP = ',2I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPDIAM(IHARG,IARGT,ARG,NUMARG,
     1PXSTAR,PYSTAR,
     1PXEND,PYEND,
     1ILINPA,ILINCO,PLINTH,
     1AREGBA,
     1IREBLI,IREBCO,PREBTH,
     1IREFSW,IREFCO,
     1IREPTY,IREPLI,IREPCO,PREPTH,PREPSP,
     1PTEXHE,PTEXWI,PTEXVG,PTEXHG,
     1IGRASW,IDIASW,
     1PGRAXF,PGRAYF,PDIAXC,PDIAYC,PDIAX2,PDIAY2,
     1PDIAHE,PDIAWI,PDIAVG,PDIAHG,
     1NUMDEV,
     1IDMANU,IDMODE,IDMOD2,IDMOD3,
     1IDPOWE,IDCONT,IDCOLO,IDNVPP,IDNHPP,IDUNIT,
     1IDNVOF,IDNHOF,
CCCCC ADD FOLLOWING LINE MARCH 1997.
     1IDFONT,
CCCCC ADD FOLLOWING LINE JULY 1997.
     1UNITSW,
     1IBUGD2,IFOUND,IERROR)
C
C     PURPOSE--DRAW ONE OR MORE DIAMONDS
C              (DEPENDING ON HOW MANY NUMBERS ARE PROVIDED).
C              THE COORDINATES ARE IN STANDARDIZED UNITS
C              OF 0 TO 100.
C     NOTE--THE INPUT COORDINATES DEFINE 3 SUCCESSIVE POINTS
C           AROUND THE DIAMOND.
C     NOTE-THE USUAL INPUT NUMBER OF COORDINATES IS 3
C          AND THEREFORE THE USUAL INPUT NUMBER OF NUMBERS IS 2*3 = 6.
C     NOTE--IF 4 NUMBERS ARE PROVIDED,
C           THEN THE DRAWN DIAMOND WILL GO
C           FROM THE LAST CURSOR POSITION
C           (ASSUMED TO BE AT ONE END OF MAJOR AXIS)
C           THROUGH THE (X,Y) POINT
C           (EITHER ABSOLUTE OR RELATIVE)
C           AS DEFINED BY THE FIRST AND SECOND NUMBERS
C           (ASSUMED TO BE AT ONE END OF MINOR AXIS),
C           TO THE (X,Y) POINT
C           (EITHER ABSOLUTE OR RELATIVE)
C           AS DEFINED BY THE THIRD AND FOURTH NUMBERS
C           (ASSUMED TO BE AT THE OTHER END OF MAJOR AXIS),
C           AND THEN BACK TO THE OTHER END OF THE MINOR AXIS,
C           AND CONTINUING BACK THE START POINT TO CLOSE THE DIAMOND.
C     NOTE--IF 6 NUMBERS ARE PROVIDED,
C           THEN THE DRAWN DIAMOND WILL GO
C           FROM THE ABSOLUTE (X,Y) POSITION
C           AS RESULTING FORM THE FIRST AND SECOND NUMBERS
C           (ASSUMED TO BE AT ONE END OF MAJOR AXIS),
C           THROUGH THE (X,Y) POINT
C           (EITHER ABSOLUTE OR RELATIVE)
C           AS DEFINED BY THE THIRD AND FOURTH NUMBERS
C           (ASSUMED TO BE AT ONE END OF MINOR AXIS),
C           TO THE (X,Y) POINT
C           (EITHER ABSOLUTE OR RELATIVE)
C           AS DEFINED BY THE FIFTH AND SIXTH NUMBERS
C           (ASSUMED TO BE AT THE OTHER END OF MAJOR AXIS),
C           AND THEN BACK TO THE OTHER END OF THE MINOR AXIS,
C           AND CONTINUING BACK THE START POINT TO CLOSE THE DIAMOND.
C     NOTE--AND SO FORTH FOR 10, 14, 18, ... NUMBERS.
C     INPUT  ARGUMENTS--IHARG
C                     --IARGT
C                     --ARG
C                     --NUMARG
C                     --PXSTAR
C                     --PYSTAR
C     OUTPUT ARGUMENTS--PXEND
C                     --PYEND
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--APRIL     1981.
C     UPDATED         --MARCH     1982.
C     UPDATED         --MAY       1982.
C     UPDATED         --NOVEMBER  1982.
C     UPDATED         --JANUARY   1989.  CALL LIST FOR OFFSET VAR (ALAN)
C     UPDATED         --JANUARY   1989.  SEP. UNITS FOR GR & ALPHA I/O (ALAN)
C     UPDATED         --MARCH     1997.  SUPPORT FOR DEVICE FONT (ALAN)
C     UPDATED         --JULY      1997.  SUPPORT FOR "DATA" UNITS (ALAN)
C
C-----NON-COMMON VARIABLES-----------------------------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IARGT
C
      CHARACTER*4 ILINPA
      CHARACTER*4 ILINCO
C
      CHARACTER*4 IREBLI
      CHARACTER*4 IREBCO
      CHARACTER*4 IREFSW
      CHARACTER*4 IREFCO
      CHARACTER*4 IREPTY
      CHARACTER*4 IREPLI
      CHARACTER*4 IREPCO
C
      CHARACTER*4 IGRASW
      CHARACTER*4 IDIASW
C
      CHARACTER*4 IDMANU
      CHARACTER*4 IDMODE
      CHARACTER*4 IDMOD2
      CHARACTER*4 IDMOD3
      CHARACTER*4 IDPOWE
      CHARACTER*4 IDCONT
      CHARACTER*4 IDCOLO
CCCCC ADD FOLLOWING LINE MARCH 1997.
      CHARACTER*4 IDFONT
CCCCC ADD FOLLOWING LINE JULY 1997.
      CHARACTER*4 UNITSW
C
      CHARACTER*4 IFOUND
      CHARACTER*4 IBUGD2
      CHARACTER*4 IERROR
      CHARACTER*4 ISUBRO
C
      CHARACTER*4 IFIG
      CHARACTER*4 IBELSW
      CHARACTER*4 IERASW
      CHARACTER*4 IBACCO
      CHARACTER*4 ICOPSW
      CHARACTER*4 ITYPEO
C
      DIMENSION IHARG(*)
      DIMENSION IARGT(*)
      DIMENSION ARG(*)
C
      DIMENSION ILINPA(*)
      DIMENSION ILINCO(*)
      DIMENSION PLINTH(*)
C
      DIMENSION AREGBA(*)
      DIMENSION IREBLI(*)
      DIMENSION IREBCO(*)
      DIMENSION PREBTH(*)
      DIMENSION IREFSW(*)
      DIMENSION IREFCO(*)
      DIMENSION IREPTY(*)
      DIMENSION IREPLI(*)
      DIMENSION IREPCO(*)
      DIMENSION PREPTH(*)
      DIMENSION PREPSP(*)
C
      DIMENSION IDMANU(*)
      DIMENSION IDMODE(*)
      DIMENSION IDMOD2(*)
      DIMENSION IDMOD3(*)
      DIMENSION IDPOWE(*)
      DIMENSION IDCONT(*)
      DIMENSION IDCOLO(*)
CCCCC ADD FOLLOWING LINE MARCH 1997.
      DIMENSION IDFONT(*)
      DIMENSION IDNVPP(*)
      DIMENSION IDNHPP(*)
      DIMENSION IDUNIT(*)
C
      DIMENSION IDNVOF(*)
      DIMENSION IDNHOF(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
      IERRG4=IERROR
CCCCC IBUGG4=IBUGD2
CCCCC ISUBG4=ISUBRO
C
      ILOCFN=0
      NUMNUM=0
C
      X1=0.0
      Y1=0.0
      X2=0.0
      Y2=0.0
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DIAM')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPDIAM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)NUMARG
   53 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,NUMARG
      WRITE(ICOUT,56)I,IHARG(I),IARGT(I),ARG(I)
   56 FORMAT('I,IHARG(I),IARGT(I),ARG(I) = ',I8,2X,A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
      WRITE(ICOUT,57)PXSTAR,PYSTAR
   57 FORMAT('PXSTAR,PYSTAR = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,58)PXEND,PYEND
   58 FORMAT('PXEND,PYEND = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)ILINPA(1),ILINCO(1),PLINTH(1)
   61 FORMAT('ILINPA(1),ILINCO(1),PLINTH(1) = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)AREGBA(1)
   62 FORMAT('AREGBA(1) = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,63)IREBLI(1),IREBCO(1),PREBTH(1)
   63 FORMAT('IREBLI(1),IREBCO(1),PREBTH(1) = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,64)IREFSW(1),IREFCO(1)
   64 FORMAT('IREFSW(1),IREFCO(1) = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,65)IREPTY(1),IREPLI(1),IREPCO(1),PREPTH(1),PREPSP(1)
   65 FORMAT('IREPTY(1),IREPLI(1),IREPCO(1),PREPTH(1),PREPSP(1) = ',
     1A4,2X,A4,2X,A4,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,69)PTEXHE,PTEXWI
   69 FORMAT('PTEXHE,PTEXWI= ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,70)PTEXVG,PTEXHG
   70 FORMAT('PTEXVG,PTEXHG= ',2E15.6)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,76)IGRASW,IDIASW
   76 FORMAT('IGRASW,IDIASW = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,77)PGRAXF,PGRAYF,PDIAXC,PDIAYC
   77 FORMAT('PGRAXF,PGRAYF,PDIAXC,PDIAYC = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,78)PDIAHE,PDIAWI,PDIAVG,PDIAHG
   78 FORMAT('PDIAHE,PDIAWI,PDIAVG,PDIAHG = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,80)NUMDEV
   80 FORMAT('NUMDEV= ',I8)
      CALL DPWRST('XXX','BUG ')
      DO81I=1,NUMDEV
      WRITE(ICOUT,82)IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I)
   82 FORMAT('IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I) = ',
     1A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,83)IDPOWE(I),IDCONT(I),IDCOLO(I)
   83 FORMAT('IDPOWE(I),IDCONT(I),IDCOLO(I) = ',
     1A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,84)IDNVPP(I),IDNHPP(I),IDUNIT(I)
   84 FORMAT('IDNVPP(I),IDNHPP(I),IDUNIT(I) = ',
     1I8,I8,I8)
      CALL DPWRST('XXX','BUG ')
   81 CONTINUE
      WRITE(ICOUT,87)IFOUND
   87 FORMAT('IFOUND= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,88)IBUGG4,ISUBG4,IERRG4
   88 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,89)IBUGD2,IERROR
   89 FORMAT('IBUGD2,IERROR= ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      IFIG='DIAM'
      NUMPT=3
      NUMPT2=2*NUMPT
C
C               ********************************
C               **  STEP 0--                  **
C               **  STEP THROUGH EACH DEVICE  **
C               ********************************
C
      IF(NUMDEV.LE.0)GOTO9000
      DO8000IDEVIC=1,NUMDEV
C
      IF(IDPOWE(IDEVIC).EQ.'OFF')GOTO8000
C
      IMANUF=IDMANU(IDEVIC)
      IMODEL=IDMODE(IDEVIC)
      IMODE2=IDMOD2(IDEVIC)
      IMODE3=IDMOD3(IDEVIC)
      IGCONT=IDCONT(IDEVIC)
      IGCOLO=IDCOLO(IDEVIC)
CCCCC ADD FOLLOWING LINE MARCH 1997.
      IGFONT=IDFONT(IDEVIC)
      NUMVPP=IDNVPP(IDEVIC)
      NUMHPP=IDNHPP(IDEVIC)
      ANUMVP=NUMVPP
      ANUMHP=NUMHPP
C  AUGUST 1988.  ADD OFFSET VARIABLE
      IOFFSV=IDNVOF(IDEVIC)
      IOFFSH=IDNHOF(IDEVIC)
C
      IGUNIT=IDUNIT(IDEVIC)
C
C               ************************************
C               **  STEP 1--                      **
C               **  CARRY OUT OPENING OPERATIONS  **
C               **  ON THE GRAPHICS DEVICES       **
C               ************************************
C
      CALL DPOPDE
C
      IBELSW='OFF'
      NUMRIN=0
      IERASW='OFF'
      IBACCO='JUNK'
C
      CALL DPOPPL(IGRASW,
     1IBELSW,NUMRIN,IERASW,
     1IBACCO)
C
C               *****************************************
C               **  STEP 2--                           **
C               **  SEARCH FOR COMMAND SPECIFICATIONS  **
C               *****************************************
C
      IF(NUMARG.GE.2.AND.
     1IARGT(1).EQ.'NUMB'.AND.IARGT(2).EQ.'NUMB')
     1GOTO1111
      IF(NUMARG.GE.3.AND.IHARG(1).EQ.'ABSO'.AND.
     1IARGT(2).EQ.'NUMB'.AND.IARGT(3).EQ.'NUMB')
     1GOTO1112
      IF(NUMARG.GE.3.AND.IHARG(1).EQ.'RELA'.AND.
     1IARGT(2).EQ.'NUMB'.AND.IARGT(3).EQ.'NUMB')
     1GOTO1113
      GOTO1130
C
 1111 CONTINUE
      ITYPEO='ABSO'
      ILOCFN=1
      GOTO1119
C
 1112 CONTINUE
      ITYPEO='ABSO'
      ILOCFN=2
      GOTO1119
C
 1113 CONTINUE
      ITYPEO='RELA'
      ILOCFN=2
      GOTO1119
 1119 CONTINUE
C
      IF(ILOCFN.GT.NUMARG)GOTO1129
      DO1120I=ILOCFN,NUMARG
      IF(IARGT(I).EQ.'NUMB')GOTO1120
      GOTO1129
 1120 CONTINUE
      IFOUND='YES'
      GOTO1149
 1129 CONTINUE
      GOTO1130
C
 1130 CONTINUE
      IERRG4='YES'
      WRITE(ICOUT,1131)
 1131 FORMAT('***** ERROR IN DPDIAM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1132)
 1132 FORMAT('      ILLEGAL FORM FOR DRAW ',
     1'COMMAND.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1134)
 1134 FORMAT('      TEST EXAMPLE TO DEMONSTRATE THE ',
     1'PROPER FORM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1135)
 1135 FORMAT('      SUPPOSE IT IS DESIRED TO DRAW AN DIAMOND ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1136)
 1136 FORMAT('      WITH ONE END OF MAJOR AXIS AT THE POINT 20 20 ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1137)
 1137 FORMAT('      ONE END OF THE MINOR AXIS AT THE POINT 30 10')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1138)
 1138 FORMAT('      AND WITH THE OTHER END OF THE MAJOR AXIS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1139)
 1139 FORMAT('      AT THE POINT 40 20')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1141)
 1141 FORMAT('      THEN THE ALLOWABLE FORMS ARE--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1142)
 1142 FORMAT('      DIAMOND 20 20 30 10 40 20 ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1143)
 1143 FORMAT('      DIAMOND ABSOLUTE 20 20 30 10 40 20 ')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
 1149 CONTINUE
C
C               ****************************
C               **  STEP 3--              **
C               **  DRAW OUT THE LINE(S)  **
C               ****************************
C
      NUMNUM=NUMARG-ILOCFN+1
      IF(NUMNUM.LT.NUMPT2)GOTO1151
      GOTO1152
C
 1151 CONTINUE
      J=ILOCFN-1
      X1=PXSTAR
      Y1=PYSTAR
      GOTO1159
C
 1152 CONTINUE
      J=ILOCFN
      IF(J.GT.NUMARG)GOTO1190
      X1=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1997
      IF(UNITSW.EQ.'DATA')CALL DPCODS('X',X1,X1,IBUGD2,ISUBRO,IERROR)
      J=J+1
      IF(J.GT.NUMARG)GOTO1190
      Y1=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1997
      IF(UNITSW.EQ.'DATA')CALL DPCODS('Y',Y1,Y1,IBUGD2,ISUBRO,IERROR)
      GOTO1159
 1159 CONTINUE
C
 1160 CONTINUE
      J=J+1
      IF(J.GT.NUMARG)GOTO1190
      X2=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1997
      IF(UNITSW.EQ.'DATA')CALL DPCODS('X',X2,X2,IBUGD2,ISUBRO,IERROR)
      IF(ITYPEO.EQ.'RELA')X2=X1+X2
      J=J+1
      IF(J.GT.NUMARG)GOTO1190
      Y2=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1997
      IF(UNITSW.EQ.'DATA')CALL DPCODS('Y',Y2,Y2,IBUGD2,ISUBRO,IERROR)
      IF(ITYPEO.EQ.'RELA')Y2=Y1+Y2
C
 1170 CONTINUE
      J=J+1
      IF(J.GT.NUMARG)GOTO1190
      X3=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1997
      IF(UNITSW.EQ.'DATA')CALL DPCODS('X',X3,X3,IBUGD2,ISUBRO,IERROR)
      IF(ITYPEO.EQ.'RELA')X3=X2+X3
      J=J+1
      IF(J.GT.NUMARG)GOTO1190
      Y3=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1997
      IF(UNITSW.EQ.'DATA')CALL DPCODS('Y',Y3,Y3,IBUGD2,ISUBRO,IERROR)
      IF(ITYPEO.EQ.'RELA')Y3=Y2+Y3
C
      CALL DPDIA2(X1,Y1,X2,Y2,X3,Y3,
     1IFIG,
     1ILINPA,ILINCO,PLINTH,
     1AREGBA,
     1IREBLI,IREBCO,PREBTH,
     1IREFSW,IREFCO,
     1IREPTY,IREPLI,IREPCO,PREPTH,PREPSP,
     1PTEXHE,PTEXWI,PTEXVG,PTEXHG)
C
      X1=X3
      Y1=Y3
C
      GOTO1160
 1190 CONTINUE
C
      PXEND=X3
      PYEND=Y3
C
C               ************************************
C               **  STEP 4--                      **
C               **  CARRY OUT CLOSING OPERATIONS  **
C               **  ON THE GRAPHICS DEVICES       **
C               ************************************
C
      ICOPSW='OFF'
      NUMCOP=0
      CALL DPCLPL(ICOPSW,NUMCOP,
     1PGRAXF,PGRAYF,
     1IGRASW,PDIAXC,PDIAYC,PDIAX2,PDIAY2,
     1PDIAHE,PDIAWI,PDIAVG,PDIAHG)
C
      CALL DPCLDE
C
 8000 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DIAM')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPDIAM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)ILOCFN,NUMNUM
 9012 FORMAT('ILOCFN,NUMNUM = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)X1,Y1,X2,Y2,X3,Y3
 9013 FORMAT('X1,Y1,X2,Y2,X3,Y3 = ',6E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)PXSTAR,PYSTAR
 9015 FORMAT('PXSTAR,PYSTAR = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)PXEND,PYEND
 9016 FORMAT('PXEND,PYEND = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)IFIG
 9017 FORMAT('IFIG = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9027)IFOUND
 9027 FORMAT('IFOUND = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9028)IBUGG4,ISUBG4,IERRG4
 9028 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9029)IBUGD2,IERROR
 9029 FORMAT('IBUGD2,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPDIME(IANS,IHARG,IARGT,IARG,NUMARG,IDEMXN,IDEMXC,
     1IHNAME,IHNAM2,IUSE,IN,IVSTAR,IVSTOP,IVALUE,VALUE,NUMNAM,MAXNAM,
     1V,MAXNK,NUMN,MAXN,MAXNXT,
CCCCC JANUARY 1998.  ADD FOLLOWING LINE.
     1MAXTOM,MAXROM,MAXCOM,MAXOBV,
     1NUMCOL,MAXCOL,IFOUND,IERROR,IBUGS2)
C
C     PURPOSE--DEFINE THE MAXIMUM NUMBER OF ROWS (MAXN)
C              AND COLUMNS (MAXCOL) IN THE INTERNAL DATAPLOT
C              DATA ARRAY.
C              THE MAXIMUM NUMBER OF ROWS WILL BE PLACED
C              IN THE VARIABLE MAXN.
C              THE MAXIMUM NUMBER OF COLUMNS WILL BE PLACED
C              IN THE VARIABLE MAXCOL.
C              NOTE THAT THE PRODUCT OF MAXN AND MAXCOL SHOULD
C              NOT EXCEED THE VALUE OF MAXNK.
C              MAXNK DIFFERS AT DIFFERENT COMPUTER
C              INSTALLATIONS DEPENDENDING ON AVAILABLE MEMORY.
C              A TYPICAL VALUE FOR MAXNK IS 10000    .
C              MAXNK IS DEFINED IN THE SUBROUTINE INITDA.
C     INPUT  ARGUMENTS--IHARG  (A  HOLLERITH VECTOR)
C                     --IARGT  (A  HOLLERITH VECTOR)
C                     --IARG   (A  HOLLERITH VECTOR)
C                     --NUMARG (AN INTEGER VARIABLE)
C                     --IDEMXN (AN INTEGER VARIABLE)
C                     --IDEMXC (AN INTEGER VARIABLE)
C                     --IHNAME (A  HOLLERITH VECTOR)
C                     --IHNAM2 (A  HOLLERITH VECTOR)
C                     --IUSE   (A  HOLLERITH VECTOR)
C                     --IN     (AN INTEGER VECTOR)
C                     --IVSTAR (AN INTEGER VECTOR)
C                     --IVSTOP (AN INTEGER VECTOR)
C                     --IVALUE (AN INTEGER VECTOR)
C                     --VALUE  (A  FLOATING POINT VECTOR)
C                     --NUMNAM (AN INTEGER VARIABLE)
C                     --MAXNAM (AN INTEGER VARIABLE)
C                     --V      (A  FLOATING POINT VECTOR)
C                     --MAXNK  (AN INTEGER VARIABLE)
C                     --NUMN   (AN INTEGER VARIABLE)
C                     --NUMCOL (AN INTEGER VARIABLE)
C     OUTPUT ARGUMENTS--MAXN   (AN INTEGER VARIABLE
C                              WHICH SPECIFIES THE MAXIMUM
C                              NUMBER OF ROWS FOR A GIVEN COLUMN
C                              (THAT IS, THE MAXIMUM NUMBER OF
C                              OBSERVATIONS FOR A GIVEN VARIABLE).
C                     --MAXCOL (AN INTEGER VARIABLE
C                              WHICH SPECIFIES THE MAXIMUM
C                              NUMBER OF COLUMNS
C                              (THAT IS, THE MAXIMUM NUMBER OF
C                              VARIABLES)
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--OCTOBER   1980.
C     UPDATED         --FEBRUARY  1982.
C     UPDATED         --MAY       1982.
C     UPDATED         --APRIL     1985.
C     UPDATED         --JUNE      1989.  ALLOW   FACTOR
C     UPDATED         --JULY      1989.  MAXCP1/2/3/4/5/6
C     UPDATED         --OCTOBER   1991.  MOVE COMMENT LINE
C     UPDATED         --JANUARY   1998.  ADD DIMENSION MATRIX
C                                        <ROWS/COLUMNS> <VALUE>
C     UPDATED         --JULY      1998.  SAVE AS INTERNAL PARAMETERS:
C                                          MAXROWS, MAXCOLS
C                                          MAXROWMT, MAXCOLMT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IANS
      CHARACTER*4 IHARG
      CHARACTER*4 IARGT
      CHARACTER*4 IHNAME
      CHARACTER*4 IHNAM2
      CHARACTER*4 IUSE
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
      CHARACTER*4 IBUGS2
C
      CHARACTER*4 ITRUND
      CHARACTER*4 ITRUNV
      CHARACTER*4 IDONE
C
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 ISUBN0
C
C---------------------------------------------------------------------
C
      DIMENSION IHARG(*)
      DIMENSION IARGT(*)
      DIMENSION IARG(*)
C
      DIMENSION IANS(*)
      DIMENSION IHNAME(*)
      DIMENSION IHNAM2(*)
      DIMENSION IUSE(*)
      DIMENSION IN(*)
      DIMENSION IVSTAR(*)
      DIMENSION IVSTOP(*)
      DIMENSION IVALUE(*)
      DIMENSION VALUE(*)
C
      DIMENSION V(*)
C
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1989
      INCLUDE 'DPCOM2.INC'
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1998
      INCLUDE 'DPCOHO.INC'
 
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='YES'
      IERROR='NO'
C
      ISUBN0='DIME'
      IANS(1)=' '
      IWIDTH=1
C
      ITEMPR=(-999)
      ITEMPC=(-999)
      ITEMRC=(-999)
C
      MINR=MAXNK/MAXNAM
      MAXR=MAXNXT
C
      MINC=MAXNK/MAXNXT
      MAXC=MAXNAM
C
      MINRC=1
      MAXRC=MAXNK
C
      NNEW=0
      IV1NEW=0
      IV2NEW=0
C
      IF(IBUGS2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('AT THE BEGINNING OF DPDIME--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGS2
   52 FORMAT('IBUGS2 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)NUMNAM,MAXNAM
   53 FORMAT('NUMNAM,MAXNAM = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)MAXNK
   54 FORMAT('MAXNK = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)NUMN,MAXN,MAXNXT
   55 FORMAT('NUMN,MAXN,MAXNXT = ',3I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)NUMCOL,MAXCOL
   56 FORMAT('NUMCOL,MAXCOL = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,57)MINR,MAXR,MINC,MAXC,MINRC,MAXRC
   57 FORMAT('MINR,MAXR,MINC,MAXC,MINRC,MAXRC = ',6I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)
   61 FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IN(I),',
     1'IVSTAR(I),IVSTOP(I),IVALUE(I),VALUE(I)')
      CALL DPWRST('XXX','BUG ')
      IF(NUMNAM.LE.0)GOTO64
      DO62I=1,NUMNAM
      WRITE(ICOUT,63)I,IHNAME(I),IHNAM2(I),IUSE(I),IN(I),
     1IVSTAR(I),IVSTOP(I),IVALUE(I),VALUE(I)
   63 FORMAT(I8,2X,A4,2X,A4,2X,A4,4I8,E15.7)
      CALL DPWRST('XXX','BUG ')
   62 CONTINUE
   64 CONTINUE
   90 CONTINUE
C
C               ****************************************
C               **  STEP 11--                         **
C               **  DETERMINE THE DESIRED DIMENSIONS  **
C               ****************************************
C
      IF(NUMARG.LE.1)GOTO1130
C
CCCCC JANUARY 1998.  ADD FOLLOWING FOR MATRIX DIMENSIONS
C
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'MATR')THEN
        IF(NUMARG.GE.2.AND.IHARG(2).EQ.'COLU')THEN
          IF(NUMARG.GE.3.AND.IARGT(3).EQ.'NUMB')THEN
            MAXCOM=IARG(3)
            IF(MAXCOM.GT.SQRT(REAL(MAXTOM)))MAXCOM=SQRT(REAL(MAXTOM))
            IF(MAXCOM.LT.MAXTOM/MAXOBV)MAXCOM=MAXTOM/MAXOBV
            MAXROM=MAXTOM/MAXCOM
            IF(MAXROM.GT.MAXN)MAXROM=MAXN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,901)MAXROM
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,902)MAXCOM
            CALL DPWRST('XXX','BUG ')
            GOTO950
          ELSE
            GOTO990
          ENDIF
        ELSEIF(NUMARG.GE.3.AND.IHARG(3).EQ.'COLU')THEN
          IF(IARGT(2).EQ.'NUMB')THEN
            MAXCOM=IARG(2)
            IF(MAXCOM.GT.SQRT(REAL(MAXTOM)))MAXCOM=SQRT(REAL(MAXTOM))
            IF(MAXCOM.LT.MAXTOM/MAXOBV)MAXCOM=MAXTOM/MAXOBV
            MAXROM=MAXTOM/MAXCOM
            IF(MAXROM.GT.MAXN)MAXROM=MAXN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,901)MAXROM
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,902)MAXCOM
            CALL DPWRST('XXX','BUG ')
            GOTO950
          ELSE
            GOTO990
          ENDIF
        ELSEIF(NUMARG.GE.2.AND.IHARG(2)(1:3).EQ.'ROW')THEN
          IF(NUMARG.GE.3.AND.IARGT(3).EQ.'NUMB')THEN
            MAXROM=IARG(3)
            IF(MAXROM.GT.MAXOBV)MAXROM=MAXOBV
            IF(MAXROM.LT.SQRT(REAL(MAXTOM)))MAXROM=SQRT(REAL(MAXTOM))
            IF(MAXROM.GT.MAXN)MAXROM=MAXN
            MAXCOM=MAXTOM/MAXROM
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,901)MAXROM
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,902)MAXCOM
            CALL DPWRST('XXX','BUG ')
            GOTO950
          ELSE
            GOTO990
          ENDIF
        ELSEIF(NUMARG.GE.3.AND.IHARG(3)(1:3).EQ.'ROW')THEN
          IF(IARGT(2).EQ.'NUMB')THEN
            MAXROM=IARG(2)
            IF(MAXROM.GT.MAXOBV)MAXROM=MAXOBV
            IF(MAXROM.LT.SQRT(REAL(MAXTOM)))MAXROM=SQRT(REAL(MAXTOM))
            IF(MAXROM.GT.MAXN)MAXROM=MAXN
            MAXCOM=MAXTOM/MAXROM
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,901)MAXROM
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,902)MAXCOM
            CALL DPWRST('XXX','BUG ')
            GOTO950
          ELSE
            GOTO990
          ENDIF
        ELSE
          GOTO990
        ENDIF
      ENDIF
      GOTO980
C
  950 CONTINUE
      IH='MAXR'
      IH2='OWMT'
      VALUE0=MAXROM
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGS2,IERROR)
C
      IH='MAXC'
      IH2='OLMT'
      VALUE0=MAXCOM
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGS2,IERROR)
C
      GOTO9000
C
  901 FORMAT('THE MAXIMUM NUMBER OF MAXTRIX ROWS    SET TO ',I5)
  902 FORMAT('THE MAXIMUM NUMBER OF MAXTRIX COLUMNS SET TO ',I5)
C
  980 CONTINUE
      IF(NUMARG.LE.2.AND.IARGT(1).EQ.'NUMB'.AND.
     1IARGT(2).EQ.'NUMB')GOTO1140
      IF(NUMARG.LE.2.AND.IARGT(1).EQ.'NUMB'.AND.
     1IARGT(2).NE.'NUMB')GOTO1150
C
      IF(NUMARG.LE.4.AND.IARGT(1).EQ.'NUMB'.AND.
     1IARGT(2).NE.'NUMB'.AND.IARGT(3).EQ.'NUMB'.AND.
     1IARGT(4).NE.'NUMB')GOTO1160
C
  990 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1111)
 1111 FORMAT('***** ERROR IN DPDIME--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1112)
 1112 FORMAT('      ILLEGAL FORM FOR THE DIMENSION COMMAND.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1113)
 1113 FORMAT('      RECOMMENDED FORMS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1114)
 1114 FORMAT('         DIMENSION 1000 OBSERVATIONS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1115)
 1115 FORMAT('         DIMENSION 10 VARIABLES')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1121)
 1121 FORMAT('      OTHER ALLOWABLE FORMS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1122)
 1122 FORMAT('         DIMENSION 1000 ROWS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1123)
 1123 FORMAT('         DIMENSION 10 COLUMNS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1124)
 1124 FORMAT('         DIMENSION 1000 OBSERVATIONS 10 VARIABLES')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1125)
 1125 FORMAT('         DIMENSION 10 VARIABLES 1000 OBSERVATIONS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1126)
 1126 FORMAT('         DIMENSION 1000 ROWS 10 COLUMNS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1127)
 1127 FORMAT('         DIMENSION 10 COLUMNS 1000 ROWS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1128)
 1128 FORMAT('         DIMENSION 1000 10')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 1130 CONTINUE
      ITEMPR=IDEMXN
      ITEMPC=IDEMXC
      GOTO1190
C
 1140 CONTINUE
      ITEMPR=IARG(1)
      ITEMPC=IARG(2)
      GOTO1190
C
 1150 CONTINUE
      IF(IHARG(2).EQ.'ROW')GOTO1151
      IF(IHARG(2).EQ.'ROWS')GOTO1151
      IF(IHARG(2).EQ.'LINE')GOTO1151
      IF(IHARG(2).EQ.'OBSE')GOTO1151
      IF(IHARG(2).EQ.'COLU')GOTO1152
      IF(IHARG(2).EQ.'VARI')GOTO1152
      GOTO1151
 1151 CONTINUE
      ITEMPR=IARG(1)
      IF(ITEMPR.LE.1)ITEMPR=1
      ITEMPC=MAXNK/ITEMPR
      GOTO1190
 1152 CONTINUE
      ITEMPC=IARG(1)
      IF(ITEMPC.LE.1)ITEMPC=1
      ITEMPR=MAXNK/ITEMPC
      GOTO1190
C
 1160 CONTINUE
      IF(IHARG(2).EQ.'ROW')GOTO1161
      IF(IHARG(2).EQ.'ROWS')GOTO1161
      IF(IHARG(2).EQ.'LINE')GOTO1161
      IF(IHARG(2).EQ.'OBSE')GOTO1161
      IF(IHARG(2).EQ.'COLU')GOTO1162
      IF(IHARG(2).EQ.'VARI')GOTO1162
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1989
      IF(IHARG(2).EQ.'FACT')GOTO1162
      GOTO1161
 1161 CONTINUE
      ITEMPR=IARG(1)
      ITEMPC=IARG(3)
      GOTO1190
 1162 CONTINUE
      ITEMPC=IARG(1)
      ITEMPR=IARG(3)
      GOTO1190
C
 1190 CONTINUE
      ITEMRC=ITEMPR*ITEMPC
C
C               *************************************
C               **  STEP 12--                      **
C               **  DETERMINE IF THE SPECIFIED     **
C               **  OBSERVATIONS(= ROW) DIMENSION  **
C               **  IS TOO SMALL OR LARGE.         **
C               *************************************
C
      IF(MINR.LE.ITEMPR.AND.ITEMPR.LE.MAXR)GOTO1290
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1211)
 1211 FORMAT('***** ERROR IN DPDIME--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1212)
 1212 FORMAT('      THE OBSERVATIONS (= ROW) DIMENSION')
      CALL DPWRST('XXX','BUG ')
      IF(ITEMPR.LT.MINR)
     1WRITE(ICOUT,1213)
 1213 FORMAT('      IS TOO SMALL.')
      IF(ITEMPR.LT.MINR)
     1CALL DPWRST('XXX','BUG ')
      IF(ITEMPR.GT.MAXR)
     1WRITE(ICOUT,1214)
 1214 FORMAT('      IS TOO LARGE.')
      IF(ITEMPR.GT.MAXR)
     1CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1215)MINR,MAXR
 1215 FORMAT('      IT MUST BE BETWEEN ',I8,' & ',I8,' (INCLUSIVE)')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1216)ITEMPR
 1216 FORMAT('      THE SPECIFIED VALUE IS ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1217)
 1217 FORMAT('      NO REDIMENSIONING WAS CARRIED OUT.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 1290 CONTINUE
C
C               *************************************
C               **  STEP 13--                      **
C               **  DETERMINE IF THE SPECIFIED     **
C               **  VARIABLES(= COLUMN) DIMENSION  **
C               **  IS TOO LARGE.                  **
C               *************************************
C
      IF(MINC.LE.ITEMPC.AND.ITEMPC.LE.MAXC)GOTO1390
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1311)
 1311 FORMAT('***** ERROR IN DPDIME--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1312)
 1312 FORMAT('      THE VARIABLES (= COLUMN) DIMENSION')
      CALL DPWRST('XXX','BUG ')
      IF(ITEMPC.LT.MINC)
     1WRITE(ICOUT,1313)
 1313 FORMAT('      IS TOO SMALL.')
      IF(ITEMPC.LT.MINC)
     1CALL DPWRST('XXX','BUG ')
      IF(ITEMPC.GT.MAXC)
     1WRITE(ICOUT,1314)
 1314 FORMAT('      IS TOO LARGE.')
      IF(ITEMPC.GT.MAXC)
     1CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1315)MINC,MAXC
 1315 FORMAT('      IT MUST BE BETWEEN ',I8,' & ',I8,' (INCLUSIVE)')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1316)ITEMPC
 1316 FORMAT('      THE SPECIFIED VALUE IS ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1317)
 1317 FORMAT('      NO REDIMENSIONING WAS CARRIED OUT.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 1390 CONTINUE
C
C               *************************************
C               **  STEP 14--                      **
C               **  DETERMINE IF THE COMBINED     **
C               **  DIMENSION (= ROW X COLUMN)    **
C               **  IS TOO LARGE.                  **
C               *************************************
C
      IF(MINRC.LE.ITEMRC.AND.ITEMRC.LE.MAXRC)GOTO1490
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1411)
 1411 FORMAT('***** ERROR IN DPDIME--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1412)
 1412 FORMAT('      THE JOINT ROW AND COLUMN DIMENSIONS')
      CALL DPWRST('XXX','BUG ')
      IF(ITEMRC.LT.MINRC)
     1WRITE(ICOUT,1413)
 1413 FORMAT('      IS TOO SMALL.')
      IF(ITEMRC.LT.MINRC)
     1CALL DPWRST('XXX','BUG ')
      IF(ITEMRC.GT.MAXRC)
     1WRITE(ICOUT,1414)
 1414 FORMAT('      IS TOO LARGE.')
      IF(ITEMRC.GT.MAXRC)
     1CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1415)
 1415 FORMAT('      THEIR PRODUCT MUST')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1416)MINRC,MAXRC
 1416 FORMAT('      BE BETWEEN ',I8,' & ',I8,' (INCLUSIVE)')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1417)ITEMRC
 1417 FORMAT('      THEIR PRODUCT IS ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1418)
 1418 FORMAT('      NO REDIMENSIONING WAS CARRIED OUT.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 1490 CONTINUE
C
C               *****************************
C               **  STEP 15--              **
C               **  SET THE DIMENSIONS     **
C               **  TO THE DESIRED VALUES  **
C               *****************************
C
      MAXNOL=MAXN
      MAXN=ITEMPR
      MAXCOL=ITEMPC
      MAXNNE=MAXN
C
CCCCC THE FOLLOWING 6 LINES WERE ADDED JULY 1989
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
C               ********************************
C               **  STEP 16--                 **
C               **  PRINT OUT THE DIMENSIONS  **
C               ********************************
C
      IF(IFEEDB.EQ.'OFF')GOTO1619
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1613)
 1613 FORMAT('DIMENSION INFORMATION--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1614)MAXNK
 1614 FORMAT('          MAXIMUM DATA ARRAY SIZE            = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1615)MAXN
 1615 FORMAT('          MAXIMUM NUMBER OBS/VARIABLE (ROWS) = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1616)MAXCOL
 1616 FORMAT('          MAXIMUM NUMBER VARIABLES (COLUMNS) = ',I8)
      CALL DPWRST('XXX','BUG ')
 1619 CONTINUE
C
      IH='MAXR'
      IH2='OWS '
      VALUE0=MAXN
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGS2,IERROR)
C
      IH='MAXC'
      IH2='OLS '
      VALUE0=MAXCOL
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGS2,IERROR)
C
C
C               *************************************
C               **  STEP 13--                      **
C               **  DETERMINE IF ANY OBSERVATIONS  **
C               **  NEED TO BE TRUNCATED           **
C               *************************************
C
      ITRUND='NO'
C
CCCCC THE FOLLOWING LINE WAS COMMENTED OUT   OCTOBER 1991
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
      IF(IBUGS2.EQ.'OFF')GOTO2009
CCCCC THE FOLLOWING LINE WAS ADDED   OCTOBER 1991
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
 2001 FORMAT('FROM THE MIDDLE OF DPDIME--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2002)NUMCOL,NUMNAM,IBUGS2
 2002 FORMAT('NUMCOL,NUMNAM,IBUGS2 = ',I8,I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
 2009 CONTINUE
C
      IF(NUMCOL.LE.0)GOTO2190
      DO2100ICOL=1,NUMCOL
      ICOLTG=ICOL
      IF(MAXNNE.GT.MAXNOL)ICOLTG=NUMCOL-ICOL+1
      IF(IBUGS2.EQ.'ON')WRITE(ICOUT,999)
      IF(IBUGS2.EQ.'ON')CALL DPWRST('XXX','BUG ')
      IF(IBUGS2.EQ.'ON')WRITE(ICOUT,2101)MAXNNE,MAXNOL,ICOL,ICOLTG
 2101 FORMAT('MAXNNE,MAXNOL,ICOL,ICOLTG               = ',4I8)
      IF(IBUGS2.EQ.'ON')CALL DPWRST('XXX','BUG ')
C
      IDONE='NO'
      IF(NUMNAM.LE.0)GOTO2190
      DO2200INAM=1,NUMNAM
      IF(IVALUE(INAM).EQ.ICOLTG.AND.IUSE(INAM).EQ.'V')GOTO2210
      GOTO2200
 2210 CONTINUE
C
      IF(IDONE.EQ.'YES')GOTO2390
      NOLD=IN(INAM)
      IV1OLD=IVSTAR(INAM)
      IV2OLD=IVSTOP(INAM)
C
      IF(NOLD.LE.MAXNNE)NNEW=NOLD
      IF(NOLD.GT.MAXNNE)NNEW=MAXNNE
      IF(NOLD.LE.MAXNNE)GOTO2219
      IF(IFEEDB.EQ.'OFF')GOTO2218
      WRITE(ICOUT,2211)IHNAME(INAM),IHNAM2(INAM),ICOLTG
 2211 FORMAT('    NOTE--VARIABLE ',A4,A4,'  (COLUMN ',I8,')')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2212)NOLD,MAXNNE
 2212 FORMAT('          TRUNCATED FROM ',I8,' TO ',I8,
     1' OBSERVATIONS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2213)
 2213 FORMAT('          IN THE PROCESS OF  REDIMENSIONING')
      CALL DPWRST('XXX','BUG ')
 2218 CONTINUE
      ITRUND='YES'
 2219 CONTINUE
C
      IV1NEW=MAXNNE*(ICOLTG-1)+1
      IV2NEW=MAXNNE*(ICOLTG-1)+NNEW
      IF(IBUGS2.EQ.'ON')WRITE(ICOUT,2221)NOLD,MAXNNE,NNEW
 2221 FORMAT('NOLD,MAXNNE,NNEW                        = ',3I8)
      IF(IBUGS2.EQ.'ON')CALL DPWRST('XXX','BUG ')
      IF(IBUGS2.EQ.'ON')WRITE(ICOUT,2222)IV1OLD,IV2OLD,IV1NEW,IV2NEW
 2222 FORMAT('IV1OLD,IV2OLD,IV1NEW,IV2NEW             = ',4I8)
      IF(IBUGS2.EQ.'ON')CALL DPWRST('XXX','BUG ')
C
      J=IV1OLD-1
      IF(IV1NEW.GT.IV1OLD)GOTO2390
      DO2300I=IV1NEW,IV2NEW
      J=J+1
      V(I)=V(J)
 2300 CONTINUE
 2380 CONTINUE
      IDONE='YES'
 2390 CONTINUE
C
      IVSTAR(INAM)=IV1NEW
      IVSTOP(INAM)=IV2NEW
      IN(INAM)=NNEW
      IF(IBUGS2.EQ.'ON')WRITE(ICOUT,2391)INAM,IVSTAR(INAM),IVSTOP(INAM),
     1IN(INAM)
 2391 FORMAT('INAM,IVSTAR(INAM),IVSTOP(INAM),IN(INAM) = ',4I8)
      IF(IBUGS2.EQ.'ON')CALL DPWRST('XXX','BUG ')
 2200 CONTINUE
C
 2100 CONTINUE
 2190 CONTINUE
C
      IF(ITRUND.EQ.'YES')GOTO2199
      IF(IFEEDB.EQ.'OFF')GOTO2199
      WRITE(ICOUT,2191)
 2191 FORMAT('    NOTE--NO DATA TRUNCATION OCCURRED FOR ANY ',
     1'VARIABLES')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2192)
 2192 FORMAT('          (COLUMNS) IN THE PROCESS OF REDIMENSIONING')
      CALL DPWRST('XXX','BUG ')
 2199 CONTINUE
C
C               **********************************
C               **  STEP 14--                   **
C               **  DETERMINE IF ANY VARIABLES  **
C               **  NEED TO BE TRUNCRATED       **
C               **********************************
C
      ITRUNV='NO'
C
      IF(NUMCOL.LE.MAXCOL)GOTO3190
      NUMCOL=MAXCOL
      IDONE='NO'
C
      IF(NUMNAM.LE.0)GOTO3190
      INAM=0
 3100 CONTINUE
      INAM=INAM+1
      IF(INAM.GT.NUMNAM)GOTO3200
      IF(IUSE(INAM).EQ.'V'.AND.IVALUE(INAM).GT.MAXCOL)GOTO3210
      GOTO3200
C
 3210 CONTINUE
      NUMNAM=NUMNAM-1
      ICOLV=IVALUE(INAM)
      IF(IFEEDB.EQ.'OFF')GOTO3219
      WRITE(ICOUT,3211)IHNAME(INAM),IHNAM2(INAM),ICOLV
 3211 FORMAT('    NOTE--VARIABLE ',A4,A4,'  (COLUMN ',I8,')')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3212)
 3212 FORMAT('          DELETED IN THE PROCESS OF  REDIMENSIONING')
      CALL DPWRST('XXX','BUG ')
 3219 CONTINUE
      ITRUNV='YES'
C
      NUMNM1=NUMNAM-1
      IF(INAM.GT.NUMNM1)GOTO3229
      DO3220I=INAM,NUMNM1
      IP1=I+1
      IHNAME(I)=IHNAME(IP1)
      IHNAM2(I)=IHNAM2(IP1)
      IUSE(I)=IUSE(IP1)
      IN(I)=IN(IP1)
      IVSTAR(I)=IVSTAR(IP1)
      IVSTOP(I)=IVSTOP(IP1)
      IVALUE(I)=IVALUE(IP1)
      VALUE(I)=VALUE(IP1)
 3220 CONTINUE
 3229 CONTINUE
      NUMNAM=NUMNAM-1
C
 3200 CONTINUE
C
 3190 CONTINUE
C
      IF(ITRUNV.EQ.'YES')GOTO3199
      IF(IFEEDB.EQ.'OFF')GOTO3199
      WRITE(ICOUT,3191)
 3191 FORMAT('    NOTE--NO VARIABLES WERE DELETED')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3192)
 3192 FORMAT('          IN THE PROCESS OF REDIMENSIONING')
      CALL DPWRST('XXX','BUG ')
 3199 CONTINUE
C
C               ***************************************
C               **  STEP 15--                        **
C               **  REDEFINE THE COLUMN DESIGNATION  **
C               **  FOR PRED (PREDICTED VALUE)       **
C               **      RES (RESIDUALS)              **
C               **      YPLOT                        **
C               **      XPLOT                        **
C               **      X2PLOT                       **
C               **      TAGPLOT                      **
C               ***************************************
C
      IF(NUMNAM.LE.0)GOTO4900
C
      DO4100I=1,NUMNAM
      I2=I
      IF(IHNAME(I).EQ.'PRED'.AND.IHNAM2(I).EQ.'    ')GOTO4150
 4100 CONTINUE
      GOTO4190
 4150 CONTINUE
      IVALUE(I2)=MAXCOL+1
      VALUE(I2)=IVALUE(I2)
      GOTO4190
 4190 CONTINUE
C
      DO4200I=1,NUMNAM
      I2=I
      IF(IHNAME(I).EQ.'RES '.AND.IHNAM2(I).EQ.'    ')GOTO4250
 4200 CONTINUE
      GOTO4290
 4250 CONTINUE
      IVALUE(I2)=MAXCOL+2
      VALUE(I2)=IVALUE(I2)
      GOTO4290
 4290 CONTINUE
C
      DO4300I=1,NUMNAM
      I2=I
      IF(IHNAME(I).EQ.'YPLO'.AND.IHNAM2(I).EQ.'T   ')GOTO4350
 4300 CONTINUE
      GOTO4390
 4350 CONTINUE
      IVALUE(I2)=MAXCOL+3
      VALUE(I2)=IVALUE(I2)
      GOTO4390
 4390 CONTINUE
C
      DO4400I=1,NUMNAM
      I2=I
      IF(IHNAME(I).EQ.'XPLO'.AND.IHNAM2(I).EQ.'T   ')GOTO4450
 4400 CONTINUE
      GOTO4490
 4450 CONTINUE
      IVALUE(I2)=MAXCOL+4
      VALUE(I2)=IVALUE(I2)
      GOTO4490
 4490 CONTINUE
C
      DO4500I=1,NUMNAM
      I2=I
      IF(IHNAME(I).EQ.'X2PL'.AND.IHNAM2(I).EQ.'OT  ')GOTO4550
 4500 CONTINUE
      GOTO4590
 4550 CONTINUE
      IVALUE(I2)=MAXCOL+5
      VALUE(I2)=IVALUE(I2)
      GOTO4590
 4590 CONTINUE
C
      DO4600I=1,NUMNAM
      I2=I
      IF(IHNAME(I).EQ.'TAGP'.AND.IHNAM2(I).EQ.'LOT ')GOTO4650
 4600 CONTINUE
      GOTO4690
 4650 CONTINUE
      IVALUE(I2)=MAXCOL+6
      VALUE(I2)=IVALUE(I2)
      GOTO4690
 4690 CONTINUE
C
 4900 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGS2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('AT THE END       OF DPDIME--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGS2
 9012 FORMAT('IBUGS2 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)NUMNAM,MAXNAM
 9013 FORMAT('NUMNAM,MAXNAM = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)MAXNK
 9014 FORMAT('MAXNK = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)NUMN,MAXN,MAXNXT
 9015 FORMAT('NUMN,MAXN,MAXNXT = ',3I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)NUMCOL,MAXCOL
 9016 FORMAT('NUMCOL,MAXCOL = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)MINR,MAXR,MINC,MAXC,MINRC,MAXRC
 9017 FORMAT('MINR,MAXR,MINC,MAXC,MINRC,MAXRC = ',6I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9018)ITEMPR,ITEMPC,ITEMRC
 9018 FORMAT('ITEMPR,ITEMPC,ITEMRC = ',3I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)
 9021 FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IN(I),',
     1'IVSTAR(I),IVSTOP(I),IVALUE(I),VALUE(I)')
      CALL DPWRST('XXX','BUG ')
      IF(NUMNAM.LE.0)GOTO9024
      DO9022I=1,NUMNAM
      WRITE(ICOUT,9023)I,IHNAME(I),IHNAM2(I),IUSE(I),IN(I),
     1IVSTAR(I),IVSTOP(I),IVALUE(I),VALUE(I)
 9023 FORMAT(I8,2X,A4,2X,A4,2X,A4,4I8,E15.7)
      CALL DPWRST('XXX','BUG ')
 9022 CONTINUE
 9024 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPDIRE(ICOM,IHARG,NUMARG,
     1IDEFDI,
     1ITEXDI,
     1IBUGD2,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE DIRECTION (HORIZONTAL OR VERTICAL) TYPE FOR
C              THE TEXT COMMAND.  THE DIRECTION (HORIZONTAL OR VERTICAL)
C              FOR THE SCRIPT WILL BE PLACED IN THE CHARACTER VARIABLE
C              ITEXDI.
C     INPUT  ARGUMENTS--IHARG  (A  CHARACTER VECTOR)
C                     --NUMARG
C                     --IDEFDI
C                     --IBUGD2
C     OUTPUT ARGUMENTS--ITEXDI
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/4
C     ORIGINAL VERSION--APRIL     2009.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICOM
      CHARACTER*4 IHARG
      CHARACTER*4 IDEFDI
      CHARACTER*4 ITEXDI
      CHARACTER*4 IBUGD2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
C---------------------------------------------------------------------
C
      DIMENSION IHARG(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      IF(IBUGD2.EQ.'ON' .OR. ISUBRO.EQ.'DIRE')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPDIRE--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)ICOM,NUMARG,IDEFDI
   53   FORMAT('ICOM,NUMARG,IDEFDI = ',A4,2X,I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMARG
          WRITE(ICOUT,56)I,IHARG(I)
   56     FORMAT('I,IHARG(I) = ',I8,2X,A4)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ************************************************
C               **  TREAT THE CASE (UPPER VERSUS LOWER) CASE  **
C               ************************************************
C
      IF(ICOM.EQ.'DIRE')THEN
        IF(NUMARG.LE.0)GOTO1161
        IF(IHARG(NUMARG).EQ.'ON')GOTO1161
        IF(IHARG(NUMARG).EQ.'OFF')GOTO1162
        IF(IHARG(NUMARG).EQ.'AUTO')GOTO1161
        IF(IHARG(NUMARG).EQ.'DEFA')GOTO1165
        IF(IHARG(NUMARG).EQ.'HORI')GOTO1161
        IF(IHARG(NUMARG).EQ.'VERT')GOTO1162
        IF(IHARG(NUMARG).EQ.'?')GOTO8100
        IF(IHARG(NUMARG).EQ.'HELP')GOTO8100
        GOTO1170
      ELSEIF(ICOM.EQ.'HORI')THEN
        IF(NUMARG.LE.0)GOTO9000
        IF(NUMARG.LE.0)GOTO1161
        IF(IHARG(NUMARG).EQ.'DIRE')GOTO1161
        IF(IHARG(NUMARG).EQ.'ON')GOTO1161
        IF(IHARG(NUMARG).EQ.'OFF')GOTO1162
        IF(IHARG(NUMARG).EQ.'AUTO')GOTO1161
        IF(IHARG(NUMARG).EQ.'DEFA')GOTO1165
      ELSEIF(ICOM.EQ.'VERT')THEN
        IF(NUMARG.LE.0)GOTO9000
        IF(IHARG(1).NE.'CASE')GOTO9000
        IF(NUMARG.LE.1)GOTO1162
        IF(IHARG(NUMARG).EQ.'ON')GOTO1162
        IF(IHARG(NUMARG).EQ.'OFF')GOTO1161
        IF(IHARG(NUMARG).EQ.'AUTO')GOTO1162
        IF(IHARG(NUMARG).EQ.'DEFA')GOTO1165
      ENDIF
      GOTO9000
C
 1161 CONTINUE
      ITEXDI='HORI'
      GOTO1180
C
 1162 CONTINUE
      ITEXDI='VERT'
      GOTO1180
C
 1165 CONTINUE
      ITEXDI=IDEFDI
      GOTO1180
C
 1170 CONTINUE
      IERROR='YES'
      WRITE(ICOUT,1171)
 1171 FORMAT('***** ERROR IN DIRECTION COMMAND--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1172)
 1172 FORMAT('      UNKNOWN ENTRY FOR DIRECTION COMMAND. THE DIRECTION')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1173)
 1173 FORMAT('      SHOULD BE EITHER HORIZONTAL OR VERTICAL.  FOR ',
     1       'EXAMPLE:')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1177)
 1177 FORMAT('           DIRECTION HORIZONTAL')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1178)
 1178 FORMAT('           DIRECTION VERTICAL')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
C
 1180 CONTINUE
      IFOUND='YES'
C
      IF(IFEEDB.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1181)
 1181   FORMAT('THE CASE (FOR PLOT SCRIPT AND TEXT) ')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1182)ITEXDI
 1182   FORMAT('HAS JUST BEEN SET TO ',A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
      GOTO9000
C
C               ********************************************
C               **  STEP 81--                             **
C               **  TREAT THE    ?    CASE--              **
C               **  DUMP OUT CURRENT AND DEFAULT VALUES.  **
C               ********************************************
C
 8100 CONTINUE
      IFOUND='YES'
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,8111)ITEXDI
 8111 FORMAT('THE CURRENT DIRECTION IS ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,8112)IDEFDI
 8112 FORMAT('THE DEFAULT DIRECTION IS ',A4)
      CALL DPWRST('XXX','BUG ')
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGD2.EQ.'ON' .OR. ISUBRO.EQ.'DIRE')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDIRE--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGD2,ISUBRO,IFOUND,IERROR
 9012   FORMAT('IBUGD2,ISUBRO,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)ITEXDI,IDEFDI
 9013   FORMAT('ITEXDI,IDEFDI = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDIXO(XTEMP1,MAXNXT,
     1                  ICAPSW,ICASAN,IFORSW,ISEED,
     1                  IBUGA2,IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--PERFORM DIXON TEST FOR UNIVARIATE OUTLIERS (DIXON
C              TEST LOOKS FOR A SINGLE OUTLIER AND ASSUMES THE
C              DATA FOLLOWS AN APPROXIMATELY NORMAL DISRIBUTION).
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORAOTRY
C                 NATIONAL INSTITUTE OF STANDARDS OF TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS OF TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/11
C     ORIGINAL VERSION--NOVEMBER  2009.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASAN
      CHARACTER*4 ICAPSW
      CHARACTER*4 IFORSW
      CHARACTER*4 IBUGA2
      CHARACTER*4 IBUGA3
      CHARACTER*4 IBUGQ
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ICASP2
      CHARACTER*4 IRANSV
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 ICASEQ
      CHARACTER*4 IDATSW
      CHARACTER*4 IHP
      CHARACTER*4 IHP2
C
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 ISUBN0
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 IFLAGU
      LOGICAL IFRST
      LOGICAL ILAST
C
      CHARACTER*4 LOWLTY
      CHARACTER*4 UPPLTY
      CHARACTER*4 IMETHD
      CHARACTER*4 IREPL
      CHARACTER*4 IMULT
      CHARACTER*4 ICTMP1
      CHARACTER*4 ICTMP2
      CHARACTER*4 ICASE
C
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=30)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      CHARACTER*4 IVARID(MAXSPN)
      CHARACTER*4 IVARI2(MAXSPN)
      REAL PVAR(MAXSPN)
      REAL PID(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
C
      DIMENSION Y1(MAXOBV)
      DIMENSION X1(MAXOBV)
      DIMENSION XTEMP1(MAXOBV)
      DIMENSION XTEMP2(MAXOBV)
      DIMENSION XTEMP3(MAXOBV)
      DIMENSION YSTAT(MAXOBV)
C
      DIMENSION XDESGN(MAXOBV,7)
      DIMENSION XIDTEM(MAXOBV)
      DIMENSION XIDTE2(MAXOBV)
      DIMENSION XIDTE3(MAXOBV)
      DIMENSION XIDTE4(MAXOBV)
      DIMENSION XIDTE5(MAXOBV)
      DIMENSION XIDTE6(MAXOBV)
C
      DIMENSION TEMP1(MAXOBV)
      DIMENSION TEMP2(MAXOBV)
C
      INCLUDE 'DPCOZZ.INC'
      INCLUDE 'DPCOZ2.INC'
C
      EQUIVALENCE (GARBAG(IGARB1),Y1(1))
      EQUIVALENCE (GARBAG(IGARB2),X1(1))
      EQUIVALENCE (GARBAG(IGARB4),XTEMP2(1))
      EQUIVALENCE (GARBAG(IGARB5),XTEMP3(1))
      EQUIVALENCE (GARBAG(IGARB6),TEMP1(1))
      EQUIVALENCE (GARBAG(IGARB7),TEMP2(1))
      EQUIVALENCE (GARBAG(IGARB8),XIDTEM(1))
      EQUIVALENCE (GARBAG(IGARB9),XIDTE2(1))
      EQUIVALENCE (GARBAG(IGAR10),XIDTE3(1))
      EQUIVALENCE (GARBAG(IGAR11),XIDTE4(1))
      EQUIVALENCE (GARBAG(JGAR12),XIDTE5(1))
      EQUIVALENCE (GARBAG(JGAR13),XIDTE6(1))
      EQUIVALENCE (GARBAG(JGAR14),YSTAT(1))
      EQUIVALENCE (G2RBAG(IGAR11),XDESGN(1,1))
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOSU.INC'
      INCLUDE 'DPCOS2.INC'
      INCLUDE 'DPCOHO.INC'
      INCLUDE 'DPCOMC.INC'
      INCLUDE 'DPCOST.INC'
      INCLUDE 'DPCOF2.INC'
C
      CHARACTER*4 IOP
C
      COMMON/ISED/ISED1,ISED2,ISED3,ISED4,ISED5,ISED6,
     1            ISED7,ISED8,ISED9,ISED10,ISED11
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='NO'
      ICASAN='    '
      IREPL='OFF'
      IMULT='OFF'
      IRANSV=IRANAL
      IRANAL='FINC'
      ISEESV=ISEED
      ISEED=2503
      ISUBN1='DPDI'
      ISUBN2='XO  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      MINN2=3
C
C               ***************************************************
C               **  TREAT THE GRUBB TEST                CASE     **
C               ***************************************************
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'DIXO')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPDIXO--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)ICASAN
   52   FORMAT('ICASAN = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)IBUGA2,IBUGA3,IBUGQ
   53   FORMAT('IBUGA2,IBUGA3,IBUGQ = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *********************************************************
C               **  STEP 1--                                           **
C               **  EXTRACT THE COMMAND                                **
C               **  LOOK FOR ONE OF THE FOLLOWING COMMANDS:            **
C               **    1) DIXON TEST Y                                  **
C               **    2) DIXON TEST Y LABID                            **
C               **    3) MULTIPLE DIXON TEST Y1 ... YK                 **
C               **    4) REPLICATED DIXON TEST Y X1 ... XK             **
C               **    5) REPLICATED DIXON TEST Y LABID X1 ... XK       **
C               **       REPLICATED DIXON TEST Y X1 ... XK LABID       **
C               *********************************************************
C
      ISTEPN='1'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DIXO')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ILASTC=9999
      ILASTZ=9999
      IFOUND='NO'
      ICASAN='DI2S'
C
      DO100I=0,NUMARG-1
C
        IF(I.EQ.0)THEN
          ICTMP1=ICOM
          ICTMP2=IHARG(I+1)
        ELSE
          ICTMP1=IHARG(I)
          ICTMP2=IHARG(I+1)
        ENDIF
C
        IF(ICTMP1.EQ.'DIXO' .AND. ICTMP2.EQ.'TEST')THEN
          IFOUND='YES'
          ILASTC=I
          ILASTZ=I+1
        ELSEIF(ICTMP1.EQ.'DIXO')THEN
          IFOUND='YES'
          ILASTC=I
          ILASTZ=I
        ELSEIF(ICTMP1.EQ.'TEST')THEN
          ILASTC=I
          ILASTZ=MAX(ILASTZ,I)
        ELSEIF(ICTMP1.EQ.'MINI')THEN
          ICASAN='MINI'
          ILASTC=MIN(ILASTC,I)
          ILASTZ=MAX(ILASTZ,I)
        ELSEIF(ICTMP1.EQ.'MAXI')THEN
          ICASAN='MAXI'
          ILASTC=MIN(ILASTC,I)
          ILASTZ=MAX(ILASTZ,I)
        ELSEIF(ICTMP1.EQ.'REPL')THEN
          IREPL='ON'
          ILASTC=MIN(ILASTC,I)
          ILASTZ=MAX(ILASTZ,I)
        ELSEIF(ICTMP1.EQ.'MULT')THEN
          IMULT='ON'
          ILASTC=MIN(ILASTC,I)
          ILASTZ=MAX(ILASTZ,I)
        ENDIF
  100 CONTINUE
C
      ISHIFT=ILASTZ
      CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1            IBUGA2,IERROR)
C
      IF(IFOUND.EQ.'NO')GOTO9000
      IF(IMULT.EQ.'ON')THEN
        IF(IREPL.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,101)
  101     FORMAT('***** ERROR IN DIXON TEST--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,102)
  102     FORMAT('      YOU CANNOT SPECIFY BOTH "MULTIPLE" AND ',
     1           '"REPLICATION" FOR THE DIXON TEST COMMAND.')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
      ENDIF
C
C               *********************************
C               **  STEP 4--                   **
C               **  EXTRACT THE VARIABLE LIST  **
C               *********************************
C
      ISTEPN='4'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DIXO')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='DIXON TEST FOR OUTLIERS'
      MINNA=1
      MAXNA=100
      MINN2=2
      IFLAGE=1
      IF(IMULT.EQ.'ON')IFLAGE=0
      IFLAGM=1
      IF(IREPL.EQ.'ON')IFLAGM=0
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
      MINNVA=-99
      MAXNVA=-99
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DIXO')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
C               ***********************************************
C               **  STEP 5--                                 **
C               **  DETERMINE:                               **
C               **  1) NUMBER OF REPLICATION VARIABLES (0-6) **
C               **  2) NUMBER OF RESPONSE    VARIABLES (>= 1)**
C               ***********************************************
C
      ISTEPN='5'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DIXO')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NRESP=0
      NREPL=0
      NLABID=0
      IF(IMULT.EQ.'ON')THEN
        NRESP=NUMVAR
      ELSEIF(IREPL.EQ.'ON')THEN
        NRESP=1
        IF(NUMVAR.EQ.2)THEN
          NLABID=0
          NREPL=1
        ELSE
          NLABID=1
          NREPL=NUMVAR-NRESP-NLABID
        ENDIF
        IF(NREPL.LT.1 .OR. NREPL.GT.6)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,101)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,511)
  511     FORMAT('      FOR THE REPLICATION CASE, THE NUMBER OF ',
     1           'REPLICATION VARIABLES')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,513)NREPL
  513     FORMAT('      THE NUMBER OF REPLICATION VARIABLES = ',I5)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
      ELSE
        NRESP=1
        NLABID=NUMVAR-NRESP
        IF(NLABID.GT.1)NLABID=1
      ENDIF
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DIXO')THEN
        WRITE(ICOUT,521)NRESP,NLABID,NREPL
  521   FORMAT('NRESP,NLABID,NREPL = ',3I5)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IOP='OPEN'
      IFLAG1=0
      IFLAG2=1
      IFLAG3=0
      IFLAG4=0
      IFLAG5=0
      CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C
C               ******************************************************
C               **  STEP 6--                                        **
C               **  GENERATE THE DIXON TEST FOR THE VARIOUS CASES  **
C               ******************************************************
C
      ISTEPN='6'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DIXO')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C               *****************************************
C               **  STEP 7A--                          **
C               **  CASE 1: SINGLE RESPONSE VARIABLE   **
C               **          WITH NO REPLICATION        **
C               *****************************************
C
      IF(NRESP.EQ.1 .AND. NREPL.EQ.0)THEN
        ISTEPN='7A'
        IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DIXO')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        PID(1)=CPUMIN
        IVARID(1)=IVARN1(1)
        IVARI2(1)=IVARN2(1)
C
        ICOL=1
        NUMVA2=1
        IF(NLABID.GE.1)NUMVA2=2
        CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1              INAME,IVARN1,IVARN2,IVARTY,
     1              ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1              MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1              MAXCP4,MAXCP5,MAXCP6,
     1              V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1              Y1,X1,XTEMP2,NLOCAL,NLOCA2,NLOCA3,ICASE,
     1              IBUGA3,ISUBRO,IFOUND,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
C       *****************************************************
C       **  STEP 7B--                                      **
C       **  CALL DPDIX2 TO PERFORM THE DIXON TEST.         **
C       *****************************************************
C
C
        IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'DIXO')THEN
          ISTEPN='7B'
          CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,711)
  711     FORMAT('***** FROM THE MIDDLE OF DPDIXO--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,712)ICASAN,NUMVAR,IDATSW,NLOCAL
  712     FORMAT('ICASAN,NUMVAR,IDATSW,NLOCAL = ',
     1           A4,I8,2X,A4,I8)
          CALL DPWRST('XXX','BUG ')
          IF(NLOCAL.GE.1)THEN
            DO715I=1,NLOCAL
              WRITE(ICOUT,716)I,Y1(I),X1(I)
  716         FORMAT('I,Y1(I),X1(I) = ',I8,2F12.5)
              CALL DPWRST('XXX','BUG ')
  715       CONTINUE
          ENDIF
        ENDIF
C
        NCURVE=1
        CALL DPDIX2(Y1,X1,NLOCAL,ICASAN,MAXOBV,
     1              YSTAT,XTEMP1,XTEMP2,XTEMP3,
     1              PID,IVARID,IVARI2,NCURVE,NREPL,NLABID,
     1              IOUNI2,ISEED,
     1              ICAPSW,ICAPTY,IFORSW,IRTFFF,IRTFFP,
     1              STATVA,STATCD,PVAL,
     1              CUT0,CUT25,CUT50,CUT75,CUT80,CUT90,
     1              CUT95,CUT975,CUT99,CUT995,CUT100,
     1              ISUBRO,IBUGA3,IERROR)
C
C               ***************************************
C               **  STEP 7C--                        **
C               **  COMPUTE DIXON     STAT           **
C               **  UPDATE INTERNAL DATAPLOT TABLES  **
C               ***************************************
C
        ISTEPN='7C'
        IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DIXO')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IFLAGU='ON'
        IFRST=.FALSE.
        ILAST=.FALSE.
        CALL DPGRU4(STATVA,STATCD,PVAL,
     1              CUT0,CUT50,CUT75,CUT90,CUT95,CUT975,CUT99,CUT100,
     1              IFLAGU,IFRST,ILAST,ICASP2,
     1              IBUGA2,IBUGA3,ISUBRO,IERROR)
C
C               ******************************************
C               **  STEP 8A--                           **
C               **  CASE 2: MULTIPLE RESPONSE VARIABLES **
C               **          NOTE THAT A LABID VARIABLE  **
C               **          IS NOT SUPPORTED FOR THIS   **
C               **          CASE.                       **
C               ******************************************
C
      ELSEIF(NRESP.GT.1)THEN
        ISTEPN='8A'
        IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DIXO')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C       LOOP THROUGH EACH OF THE RESPONSE VARIABLES
C
        NCURVE=0
        DO810IRESP=1,NRESP
          NCURVE=NCURVE+1
C
          IINDX=ICOLR(IRESP)
          PID(1)=CPUMIN
          IVARID(1)=IVARN1(IRESP)
          IVARI2(1)=IVARN2(IRESP)
C
          IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DIXO')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,811)IRESP,NCURVE
  811       FORMAT('IRESP,NCURVE = ',2I5)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
          ICOL=IRESP
          NUMVA2=1
          CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1                INAME,IVARN1,IVARN2,IVARTY,
     1                ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1                MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1                MAXCP4,MAXCP5,MAXCP6,
     1                V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1                Y1,XTEMP1,XTEMP2,NLOCAL,NLOCA2,NLOCA3,ICASE,
     1                IBUGA3,ISUBRO,IFOUND,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
          DO820I=1,NLOCAL
            X1(I)=REAL(I)
  820     CONTINUE
C
C         *****************************************************
C         **  STEP 8B--                                      **
C         **  CALL DPDIX2 TO PERFORM THE DIXON TEST          **
C         *****************************************************
C
          IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'DIXO')THEN
            ISTEPN='8B'
            CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,822)
  822       FORMAT('***** FROM THE MIDDLE  OF DPDIXO--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,823)ICASAN,NUMVAR,IDATSW,NLOCAL
  823       FORMAT('ICASAN,NUMVAR,IDATSW,NQ = ',
     1             A4,I8,2X,A4,I8)
            CALL DPWRST('XXX','BUG ')
            IF(NLOCAL.GE.1)THEN
              DO825I=1,NLOCAL
                WRITE(ICOUT,826)I,Y1(I),X1(I)
  826           FORMAT('I,Y1(I),X1(I) = ',I8,2F12.5)
                CALL DPWRST('XXX','BUG ')
  825         CONTINUE
            ENDIF
          ENDIF
C
          CALL DPDIX2(Y1,X1,NLOCAL,ICASAN,MAXOBV,
     1                YSTAT,XTEMP1,XTEMP2,XTEMP3,
     1                PID,IVARID,IVARI2,NCURVE,NREPL,NLABID,
     1                IOUNI2,ISEED,
     1                ICAPSW,ICAPTY,IFORSW,IRTFFF,IRTFFP,
     1                STATVA,STATCD,PVAL,
     1                CUT0,CUT25,CUT50,CUT75,CUT80,CUT90,
     1                CUT95,CUT975,CUT99,CUT995,CUT100,
     1                ISUBRO,IBUGA3,IERROR)
C
C               ***************************************
C               **  STEP 8C--                        **
C               **  COMPUTE GRUBB     STAT           **
C               **  UPDATE INTERNAL DATAPLOT TABLES  **
C               ***************************************
C
          ISTEPN='8C'
          IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DIXO')
     1      CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
          IFLAGU='FILE'
          IFRST=.FALSE.
          ILAST=.FALSE.
          IF(IRESP.EQ.1)IFRST=.TRUE.
          IF(IRESP.EQ.NRESP)ILAST=.TRUE.
          IFLAGU='ON'
          IFRST=.FALSE.
          ILAST=.FALSE.
          CALL DPGRU4(STATVA,STATCD,PVAL,
     1                CUT0,CUT50,CUT75,CUT90,CUT95,CUT975,CUT99,CUT100,
     1                IFLAGU,IFRST,ILAST,ICASP2,
     1                IBUGA2,IBUGA3,ISUBRO,IERROR)
C
  810   CONTINUE
C
C               ****************************************************
C               **  STEP 9A--                                     **
C               **  CASE 3: ONE OR MORE REPLICATION VARIABLES.    **
C               **          FOR THIS CASE, THE NUMBER OF RESPONSE **
C               **          VARIABLES MUST BE EXACTLY 1.          **
C               **          FOR THIS CASE, ALL VARIABLES MUST     **
C               **          HAVE THE SAME LENGTH.                 **
C               ****************************************************
C
      ELSEIF(IREPL.EQ.'ON')THEN
        ISTEPN='9A'
        IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DIXO')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        J=0
        IMAX=NRIGHT(1)
        IF(NQ.LT.NRIGHT(1))IMAX=NQ
        DO910I=1,IMAX
          IF(ISUB(I).EQ.0)GOTO910
          J=J+1
C
C         RESPONSE VARIABLE IN Y1
C
          ICOLC=1
          IJ=MAXN*(ICOLR(ICOLC)-1)+I
          IF(ICOLR(ICOLC).LE.MAXCOL)Y1(J)=V(IJ)
          IF(ICOLR(ICOLC).EQ.MAXCP1)Y1(J)=PRED(I)
          IF(ICOLR(ICOLC).EQ.MAXCP2)Y1(J)=RES(I)
          IF(ICOLR(ICOLC).EQ.MAXCP3)Y1(J)=YPLOT(I)
          IF(ICOLR(ICOLC).EQ.MAXCP4)Y1(J)=XPLOT(I)
          IF(ICOLR(ICOLC).EQ.MAXCP5)Y1(J)=X2PLOT(I)
          IF(ICOLR(ICOLC).EQ.MAXCP6)Y1(J)=TAGPLO(I)
C
C         LABID VARIABLE IN X1
C
          IF(NLABID.GE.1)THEN
            ICOLC=ICOLC+1
            ICOLT=ICOLR(ICOLC)
            IJ=MAXN*(ICOLT-1)+I
            IF(ICOLT.LE.MAXCOL)X1(J)=V(IJ)
            IF(ICOLT.EQ.MAXCP1)X1(J)=PRED(I)
            IF(ICOLT.EQ.MAXCP2)X1(J)=RES(I)
            IF(ICOLT.EQ.MAXCP3)X1(J)=YPLOT(I)
            IF(ICOLT.EQ.MAXCP4)X1(J)=XPLOT(I)
            IF(ICOLT.EQ.MAXCP5)X1(J)=X2PLOT(I)
            IF(ICOLT.EQ.MAXCP6)X1(J)=TAGPLO(I)
          ELSE
            X1(J)=REAL(I)
          ENDIF
C
          IF(NREPL.GE.1)THEN
            DO920IR=1,MIN(NREPL,6)
              ICOLC=ICOLC+1
              ICOLT=ICOLR(ICOLC)
              IJ=MAXN*(ICOLT-1)+I
              IF(ICOLT.LE.MAXCOL)XDESGN(J,IR)=V(IJ)
              IF(ICOLT.EQ.MAXCP1)XDESGN(J,IR)=PRED(I)
              IF(ICOLT.EQ.MAXCP2)XDESGN(J,IR)=RES(I)
              IF(ICOLT.EQ.MAXCP3)XDESGN(J,IR)=YPLOT(I)
              IF(ICOLT.EQ.MAXCP4)XDESGN(J,IR)=XPLOT(I)
              IF(ICOLT.EQ.MAXCP5)XDESGN(J,IR)=X2PLOT(I)
              IF(ICOLT.EQ.MAXCP6)XDESGN(J,IR)=TAGPLO(I)
  920       CONTINUE
          ENDIF
C
  910   CONTINUE
        NLOCAL=J
C
        ISTEPN='9B'
        IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DIXO')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C       NOTE: CHECK TO SEE IF X1 HAS ALL UNIQUE ELEMENTS.  IF NOT,
C             THEN INTERPRET THIS AS A REPLICATION VARIABLE.
C
        CALL DISTIN(X1,NLOCAL,IWRITE,XTEMP2,NDIST,IBUGA3,IERROR)
        IF(NLOCAL.NE.NDIST)THEN
          NLABID=0
          IF(NREPL.GT.6)NREPL=6
          IF(NREPL.GE.1)THEN
            DO930J=1,NREPL-1
              DO935I=1,NLOCAL
                XDESGN(I,J+1)=XDESGN(I,J)
  935         CONTINUE
  930       CONTINUE
          ENDIF
          NREPL=NREPL+1
          DO938I=1,NLOCAL
            XDESGN(I,1)=X1(I)
            X1(I)=REAL(I)
  938     CONTINUE
        ENDIF
C
        PID(1)=CPUMIN
        IVARID(1)=IVARN1(1)
        IVARI2(1)=IVARN2(1)
        IF(NLABID.EQ.1)THEN
          PID(2)=CPUMIN
          IVARID(2)=IVARN1(2)
          IVARI2(2)=IVARN2(2)
        ENDIF
        IADD=NRESP+NLABID
        DO940II=1,NREPL
          IVARID(II+IADD)=IVARN1(II+IADD)
          IVARI2(II+IADD)=IVARN2(II+IADD)
  940   CONTINUE
C
C       *****************************************************
C       **  STEP 9B--                                      **
C       **  CALL DPDIX2 TO PERFORM THE DIXON TEST.         **
C       *****************************************************
C
C
        IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'DIXO')THEN
          ISTEPN='9C'
          CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,941)
  941     FORMAT('***** FROM THE MIDDLE  OF DPDIXO--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,942)ICASAN,NUMVAR,IDATSW,NLOCAL,NREPL
  942     FORMAT('ICASAN,NUMVAR,IDATSW,NLOCAL,NREPL = ',
     1           A4,I8,2X,A4,2I8)
          CALL DPWRST('XXX','BUG ')
          IF(NLOCAL.GE.1)THEN
            DO945I=1,NLOCAL
              WRITE(ICOUT,946)I,Y1(I),X1(I),XDESGN(I,1),XDESGN(I,2)
  946         FORMAT('I,Y1(I),X1(I),XDESGN(I,1),XDESGN(I,2) = ',
     1               I8,4F12.5)
              CALL DPWRST('XXX','BUG ')
  945       CONTINUE
          ENDIF
        ENDIF
C
C       *****************************************************
C       **  STEP 9C--                                      **
C       **  FIND THE DISTINCT VALUES IN EACH OF THE        **
C       **  REPLICATION VARIABLES.                         **
C       *****************************************************
C
        CALL DPPP5(XDESGN(1,1),XDESGN(1,2),XDESGN(1,3),
     1             XDESGN(1,4),XDESGN(1,5),XDESGN(1,6),
     1             NREPL,NLOCAL,MAXOBV,
     1             XIDTEM,XIDTE2,XIDTE3,XIDTE4,XIDTE5,XIDTE6,
     1             XTEMP1,XTEMP2,
     1             NUMSE1,NUMSE2,NUMSE3,NUMSE4,NUMSE5,NUMSE6,
     1             IBUGA3,ISUBRO,IERROR)
C
C       *****************************************************
C       **  STEP 9D--                                      **
C       **  NOW LOOP THROUGH THE VARIOUS REPLICATIONS      **
C       *****************************************************
C
        NPLOTP=0
        NCURVE=0
        IF(NREPL.EQ.1)THEN
          J=0
          DO1110ISET1=1,NUMSE1
            K=0
            PID(IADD+1)=XIDTEM(ISET1)
            DO1130I=1,NLOCAL
              IF(XIDTEM(ISET1).EQ.XDESGN(I,1))THEN
                K=K+1
                TEMP1(K)=Y1(I)
                TEMP2(K)=X1(I)
              ENDIF
 1130       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            NPLOT1=NPLOTP
            IF(NTEMP.GT.0)THEN
              CALL DPDIX2(TEMP1,TEMP2,NTEMP,ICASAN,MAXOBV,
     1                    YSTAT,XTEMP1,XTEMP2,XTEMP3,
     1                    PID,IVARID,IVARI2,NCURVE,NREPL,NLABID,
     1                    IOUNI2,ISEED,
     1                    ICAPSW,ICAPTY,IFORSW,IRTFFF,IRTFFP,
     1                    STATVA,STATCD,PVAL,
     1                    CUT0,CUT25,CUT50,CUT75,CUT80,CUT90,
     1                    CUT95,CUT975,CUT99,CUT995,CUT100,
     1                    ISUBRO,IBUGA3,IERROR)
            ENDIF
            NPLOT2=NPLOTP
            IFLAGU='FILE'
            IFRST=.FALSE.
            ILAST=.FALSE.
            IF(NCURVE.EQ.1)IFRST=.TRUE.
            IF(NCURVE.EQ.NUMSE1)ILAST=.TRUE.
            NPTEMP=NPLOT2-NPLOT1
            CALL DPGRU4(STATVA,STATCD,PVAL,
     1                  CUT0,CUT50,CUT75,CUT90,CUT95,
     1                  CUT975,CUT99,CUT100,
     1                  IFLAGU,IFRST,ILAST,ICASP2,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
 1110     CONTINUE
        ELSEIF(NREPL.EQ.2)THEN
          J=0
          NTOT=NUMSE1*NUMSE2
          DO1210ISET1=1,NUMSE1
          DO1220ISET2=1,NUMSE2
            K=0
            PID(1+IADD)=XIDTEM(ISET1)
            PID(2+IADD)=XIDTE2(ISET2)
            DO1290I=1,NLOCAL
              IF(
     1           XIDTEM(ISET1).EQ.XDESGN(I,1) .AND.
     1           XIDTE2(ISET2).EQ.XDESGN(I,2)
     1          )THEN
                K=K+1
                TEMP1(K)=Y1(I)
                TEMP2(K)=X1(I)
              ENDIF
 1290       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            NPLOT1=NPLOTP
            IF(NTEMP.GT.0)THEN
              CALL DPDIX2(TEMP1,TEMP2,NTEMP,ICASAN,MAXOBV,
     1                    YSTAT,XTEMP1,XTEMP2,XTEMP3,
     1                    PID,IVARID,IVARI2,NCURVE,NREPL,NLABID,
     1                    IOUNI2,ISEED,
     1                    ICAPSW,ICAPTY,IFORSW,IRTFFF,IRTFFP,
     1                    STATVA,STATCD,PVAL,
     1                    CUT0,CUT25,CUT50,CUT75,CUT80,CUT90,
     1                    CUT95,CUT975,CUT99,CUT995,CUT100,
     1                    ISUBRO,IBUGA3,IERROR)
            ENDIF
            NPLOT2=NPLOTP
            IFLAGU='FILE'
            IFRST=.FALSE.
            ILAST=.FALSE.
            IF(NCURVE.EQ.1)IFRST=.TRUE.
            IF(NCURVE.EQ.NTOT)ILAST=.TRUE.
            NPTEMP=NPLOT2-NPLOT1
            CALL DPGRU4(STATVA,STATCD,PVAL,
     1                  CUT0,CUT50,CUT75,CUT90,CUT95,
     1                  CUT975,CUT99,CUT100,
     1                  IFLAGU,IFRST,ILAST,ICASP2,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
 1220     CONTINUE
 1210     CONTINUE
        ELSEIF(NREPL.EQ.3)THEN
          J=0
          NTOT=NUMSE1*NUMSE2*NUMSE3
          DO1310ISET1=1,NUMSE1
          DO1320ISET2=1,NUMSE2
          DO1330ISET3=1,NUMSE3
            K=0
            PID(1+IADD)=XIDTEM(ISET1)
            PID(2+IADD)=XIDTE2(ISET2)
            PID(3+IADD)=XIDTE3(ISET3)
            DO1390I=1,NLOCAL
              IF(
     1           XIDTEM(ISET1).EQ.XDESGN(I,1) .AND.
     1           XIDTE2(ISET2).EQ.XDESGN(I,2) .AND.
     1           XIDTE3(ISET3).EQ.XDESGN(I,3)
     1          )THEN
                K=K+1
                TEMP1(K)=Y1(I)
                TEMP2(K)=X1(I)
              ENDIF
 1390       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            NPLOT1=NPLOTP
            IF(NTEMP.GT.0)THEN
              CALL DPDIX2(TEMP1,TEMP2,NTEMP,ICASAN,MAXOBV,
     1                    YSTAT,XTEMP1,XTEMP2,XTEMP3,
     1                    PID,IVARID,IVARI2,NCURVE,NREPL,NLABID,
     1                    IOUNI2,ISEED,
     1                    ICAPSW,ICAPTY,IFORSW,IRTFFF,IRTFFP,
     1                    STATVA,STATCD,PVAL,
     1                    CUT0,CUT25,CUT50,CUT75,CUT80,CUT90,
     1                    CUT95,CUT975,CUT99,CUT995,CUT100,
     1                    ISUBRO,IBUGA3,IERROR)
            ENDIF
            NPLOT2=NPLOTP
            IFLAGU='FILE'
            IFRST=.FALSE.
            ILAST=.FALSE.
            IF(NCURVE.EQ.1)IFRST=.TRUE.
            IF(NCURVE.EQ.NTOT)ILAST=.TRUE.
            NPTEMP=NPLOT2-NPLOT1
            CALL DPGRU4(STATVA,STATCD,PVAL,
     1                  CUT0,CUT50,CUT75,CUT90,CUT95,
     1                  CUT975,CUT99,CUT100,
     1                  IFLAGU,IFRST,ILAST,ICASP2,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
 1330     CONTINUE
 1320     CONTINUE
 1310     CONTINUE
        ELSEIF(NREPL.EQ.4)THEN
          J=0
          NTOT=NUMSE1*NUMSE2*NUMSE3*NUMSE4
          DO1410ISET1=1,NUMSE1
          DO1420ISET2=1,NUMSE2
          DO1430ISET3=1,NUMSE3
          DO1440ISET4=1,NUMSE4
            K=0
            PID(1+IADD)=XIDTEM(ISET1)
            PID(2+IADD)=XIDTE2(ISET2)
            PID(3+IADD)=XIDTE3(ISET3)
            PID(4+IADD)=XIDTE4(ISET4)
            DO1490I=1,NLOCAL
              IF(
     1           XIDTEM(ISET1).EQ.XDESGN(I,1) .AND.
     1           XIDTE2(ISET2).EQ.XDESGN(I,2) .AND.
     1           XIDTE3(ISET3).EQ.XDESGN(I,3) .AND.
     1           XIDTE4(ISET4).EQ.XDESGN(I,4)
     1          )THEN
                K=K+1
                TEMP1(K)=Y1(I)
                TEMP2(K)=X1(I)
              ENDIF
 1490       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            NPLOT1=NPLOTP
            IF(NTEMP.GT.0)THEN
              CALL DPDIX2(TEMP1,TEMP2,NTEMP,ICASAN,MAXOBV,
     1                    YSTAT,XTEMP1,XTEMP2,XTEMP3,
     1                    PID,IVARID,IVARI2,NCURVE,NREPL,NLABID,
     1                    IOUNI2,ISEED,
     1                    ICAPSW,ICAPTY,IFORSW,IRTFFF,IRTFFP,
     1                    STATVA,STATCD,PVAL,
     1                    CUT0,CUT25,CUT50,CUT75,CUT80,CUT90,
     1                    CUT95,CUT975,CUT99,CUT995,CUT100,
     1                    ISUBRO,IBUGA3,IERROR)
            ENDIF
            NPLOT2=NPLOTP
            IFLAGU='FILE'
            IFRST=.FALSE.
            ILAST=.FALSE.
            IF(NCURVE.EQ.1)IFRST=.TRUE.
            IF(NCURVE.EQ.NTOT)ILAST=.TRUE.
            NPTEMP=NPLOT2-NPLOT1
            CALL DPGRU4(STATVA,STATCD,PVAL,
     1                  CUT0,CUT50,CUT75,CUT90,CUT95,
     1                  CUT975,CUT99,CUT100,
     1                  IFLAGU,IFRST,ILAST,ICASP2,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
 1440     CONTINUE
 1430     CONTINUE
 1420     CONTINUE
 1410     CONTINUE
        ELSEIF(NREPL.EQ.5)THEN
          J=0
          NTOT=NUMSE1*NUMSE2*NUMSE3*NUMSE4*NUMSE5
          DO1510ISET1=1,NUMSE1
          DO1520ISET2=1,NUMSE2
          DO1530ISET3=1,NUMSE3
          DO1540ISET4=1,NUMSE4
          DO1550ISET5=1,NUMSE5
            K=0
            PID(1+IADD)=XIDTEM(ISET1)
            PID(2+IADD)=XIDTE2(ISET2)
            PID(3+IADD)=XIDTE3(ISET3)
            PID(4+IADD)=XIDTE4(ISET4)
            PID(5+IADD)=XIDTE5(ISET4)
            DO1590I=1,NLOCAL
              IF(
     1           XIDTEM(ISET1).EQ.XDESGN(I,1) .AND.
     1           XIDTE2(ISET2).EQ.XDESGN(I,2) .AND.
     1           XIDTE3(ISET3).EQ.XDESGN(I,3) .AND.
     1           XIDTE4(ISET4).EQ.XDESGN(I,4) .AND.
     1           XIDTE5(ISET5).EQ.XDESGN(I,5)
     1          )THEN
                K=K+1
                TEMP1(K)=Y1(I)
                TEMP2(K)=X1(I)
              ENDIF
 1590       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            NPLOT1=NPLOTP
            IF(NTEMP.GT.0)THEN
              CALL DPDIX2(TEMP1,TEMP2,NTEMP,ICASAN,MAXOBV,
     1                    YSTAT,XTEMP1,XTEMP2,XTEMP3,
     1                    PID,IVARID,IVARI2,NCURVE,NREPL,NLABID,
     1                    IOUNI2,ISEED,
     1                    ICAPSW,ICAPTY,IFORSW,IRTFFF,IRTFFP,
     1                    STATVA,STATCD,PVAL,
     1                    CUT0,CUT25,CUT50,CUT75,CUT80,CUT90,
     1                    CUT95,CUT975,CUT99,CUT995,CUT100,
     1                    ISUBRO,IBUGA3,IERROR)
            ENDIF
            NPLOT2=NPLOTP
            IFLAGU='FILE'
            IFRST=.FALSE.
            ILAST=.FALSE.
            IF(NCURVE.EQ.1)IFRST=.TRUE.
            IF(NCURVE.EQ.NTOT)ILAST=.TRUE.
            NPTEMP=NPLOT2-NPLOT1
            CALL DPGRU4(STATVA,STATCD,PVAL,
     1                  CUT0,CUT50,CUT75,CUT90,CUT95,
     1                  CUT975,CUT99,CUT100,
     1                  IFLAGU,IFRST,ILAST,ICASP2,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
 1550     CONTINUE
 1540     CONTINUE
 1530     CONTINUE
 1520     CONTINUE
 1510     CONTINUE
        ELSEIF(NREPL.EQ.6)THEN
          J=0
          NTOT=NUMSE1*NUMSE2*NUMSE3*NUMSE4*NUMSE5*NUMSE6
          DO1610ISET1=1,NUMSE1
          DO1620ISET2=1,NUMSE2
          DO1630ISET3=1,NUMSE3
          DO1640ISET4=1,NUMSE4
          DO1650ISET5=1,NUMSE5
          DO1660ISET6=1,NUMSE6
            K=0
            PID(1+IADD)=XIDTEM(ISET1)
            PID(2+IADD)=XIDTE2(ISET2)
            PID(3+IADD)=XIDTE3(ISET3)
            PID(4+IADD)=XIDTE4(ISET4)
            PID(5+IADD)=XIDTE5(ISET4)
            PID(6+IADD)=XIDTE6(ISET4)
            DO1690I=1,NLOCAL
              IF(
     1           XIDTEM(ISET1).EQ.XDESGN(I,1) .AND.
     1           XIDTE2(ISET2).EQ.XDESGN(I,2) .AND.
     1           XIDTE3(ISET3).EQ.XDESGN(I,3) .AND.
     1           XIDTE4(ISET4).EQ.XDESGN(I,4) .AND.
     1           XIDTE5(ISET5).EQ.XDESGN(I,5) .AND.
     1           XIDTE6(ISET6).EQ.XDESGN(I,6)
     1          )THEN
                K=K+1
                TEMP1(K)=Y1(I)
                TEMP2(K)=X1(I)
              ENDIF
 1690       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            NPLOT1=NPLOTP
            IF(NTEMP.GT.0)THEN
              CALL DPDIX2(TEMP1,TEMP2,NTEMP,ICASAN,MAXOBV,
     1                    YSTAT,XTEMP1,XTEMP2,XTEMP3,
     1                    PID,IVARID,IVARI2,NCURVE,NREPL,NLABID,
     1                    IOUNI2,ISEED,
     1                    ICAPSW,ICAPTY,IFORSW,IRTFFF,IRTFFP,
     1                    STATVA,STATCD,PVAL,
     1                    CUT0,CUT25,CUT50,CUT75,CUT80,CUT90,
     1                    CUT95,CUT975,CUT99,CUT995,CUT100,
     1                    ISUBRO,IBUGA3,IERROR)
            ENDIF
            NPLOT2=NPLOTP
            IFLAGU='FILE'
            IFRST=.FALSE.
            ILAST=.FALSE.
            IF(NCURVE.EQ.1)IFRST=.TRUE.
            IF(NCURVE.EQ.NTOT)ILAST=.TRUE.
            NPTEMP=NPLOT2-NPLOT1
            CALL DPGRU4(STATVA,STATCD,PVAL,
     1                  CUT0,CUT50,CUT75,CUT90,CUT95,
     1                  CUT975,CUT99,CUT100,
     1                  IFLAGU,IFRST,ILAST,ICASP2,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
 1660     CONTINUE
 1650     CONTINUE
 1640     CONTINUE
 1630     CONTINUE
 1620     CONTINUE
 1610     CONTINUE
        ENDIF
C
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
C
      IRANAL=IRANSV
      ISEED=ISEESV
C
      IOP='CLOS'
      CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
C
      IF(IERROR.EQ.'YES')THEN
        IF(IWIDTH.GE.1)THEN
          WRITE(ICOUT,9001)(IANS(I),I=1,MIN(100,IWIDTH))
 9001     FORMAT(100A1)
          CALL DPWRST('XXX','BUG ')
        ENDIF
      ENDIF
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'DIXO')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDIXO--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IFOUND,IERROR
 9012   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NPLOTP,NS,ICASAN
 9013   FORMAT('NPLOTP,NS,ICASAN = ',I8,I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDIX2(Y,X,N,ICASAN,MAXNXT,
     1                  YSTAT,TEMP1,TEMP2,TEMP3,
     1                  PID,IVARID,IVARI2,NCURVE,NREPL,NLABID,
     1                  IOUNI2,ISEED,
     1                  ICAPSW,ICAPTY,IFORSW,IRTFFF,IRTFFP,
     1                  STATVA,STATCD,PVAL,
     1                  CUT0,CUT25,CUT50,CUT75,CUT80,CUT90,
     1                  CUT95,CUT975,CUT99,CUT995,CUT100,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE CARRIES OUT THE DIXON TEST FOR UNIVARIATE
C              OUTLIERS (DATA ASSUMED TO FOLLOW AN APPROXIMATELY NORMAL
C              DISTRIBUTION).
C     EXAMPLE--DIXON TEST Y
C     REFERENCES--DIXON (1953), "PROCESSING DATA FOR OUTLIERS",
C                 BIOMETRICS, VOL. 9, NO. 1, PP. 74-89.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/11
C     ORIGINAL VERSION--NOVEMBER  2009.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IVARID(*)
      CHARACTER*4 IVARI2(*)
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IDIR
      CHARACTER*4 ICASAN
C
      CHARACTER*40 IRTFFF
      CHARACTER*40 IRTFFP
C
      CHARACTER*4 IWRITE
      CHARACTER*1 IBASLC
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 IRTFMD
      COMMON/COMRTF/IRTFMD
C
      PARAMETER (NUMALP=11)
      REAL ALPHA(NUMALP)
C
      PARAMETER(NUMCLI=4)
      PARAMETER(MAXLIN=2)
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*60 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      CHARACTER*15 IVALUE(MAXROW,NUMCLI)
      CHARACTER*4  ITYPCO(NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      NCVALU(MAXROW,NUMCLI)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
      LOGICAL IFLAG1
      LOGICAL IFLAG2
      LOGICAL IFLAG3
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION YSTAT(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION PID(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA/
     1 0.0, 25.0, 50.0, 75.0, 80.0, 90.0, 95.0,
     1 97.5, 99.0, 99.5, 100.0/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDI'
      ISUBN2='X2  '
      IERROR='NO'
      STATVA=CPUMIN
      STATCD=CPUMIN
      PVAL=CPUMIN
      CUT0=CPUMIN
      CUT25=CPUMIN
      CUT50=CPUMIN
      CUT75=CPUMIN
      CUT80=CPUMIN
      CUT90=CPUMIN
      CUT95=CPUMIN
      CUT975=CPUMIN
      CUT99=CPUMIN
      CUT995=CPUMIN
      CUT100=CPUMIN
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DIX2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDIX2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)ISUBRO,IBUGA3,ICASAN
   52   FORMAT('ISUBRO,IBUGA3,ICASAN = ',3(A4,2X))
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,MAXNXT
   55   FORMAT('N,MAXNXT = ',2I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),X(I)
   57     FORMAT('I,Y(I),X(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DIX2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(N.LT.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
 1111   FORMAT('***** ERROR IN DIXON OUTLIER TEST--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1113)
 1113   FORMAT('      THE NUMBER OF OBSERVATIONS IS LESS THAN 3.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1114)N
 1114   FORMAT('SAMPLE SIZE = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      HOLD=Y(1)
      DO1135I=2,N
        IF(Y(I).NE.HOLD)GOTO1139
 1135 CONTINUE
 1130 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1111)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1131)HOLD
 1131 FORMAT('      THE RESPONSE VARIABLE HAS ALL ELEMENTS = ',G15.7)
      CALL DPWRST('XXX','WRIT')
      IERROR='YES'
      GOTO9000
 1139 CONTINUE
C
 1290 CONTINUE
C
C               ******************************
C               **  STEP 21--               **
C               **  CARRY OUT CALCULATIONS  **
C               **  FOR DIXON OUTLIER TEST  **
C               ******************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DIX2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IWRITE='OFF'
      CALL MINIM(Y,N,IWRITE,YMIN,IBUGA3,IERROR)
      CALL MAXIM(Y,N,IWRITE,YMAX,IBUGA3,IERROR)
      CALL MEAN(Y,N,IWRITE,YMEAN,IBUGA3,IERROR)
      CALL SD(Y,N,IWRITE,YSD,IBUGA3,IERROR)
      CALL RANGDP(Y,N,IWRITE,YRANGE,IBUGA3,IERROR)
C
      INDMIN=-99
      INDMAX=99
      DO2105I=1,N
        IF(Y(I).EQ.YMIN)INDMIN=I
        IF(Y(I).EQ.YMAX)INDMAX=I
 2105 CONTINUE
C
      CALL DPDIX3(Y,X,N,TEMP1,IWRITE,ICASAN,
     1            STATVA,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DIX2')THEN
        WRITE(ICOUT,2211)STATVA
 2211   FORMAT('STATVA = ',G15.7)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,2213)YMIN,YMAX,YMEAN,YSD
 2213   FORMAT('YMIN,YMAX,YMEAN,YSD = ',4G15.7)
        CALL DPWRST('XXX','BUG')
      ENDIF
C
C               ************************************
C               **  STEP 22--                     **
C               **  COMPUTE CRITICAL VALUES VIA   **
C               **  MONTE-CARLO SIMULATION        **
C               ************************************
C
      ISTEPN='22'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DIX2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
CCCCC NMCSAM=10000
      NMCSAM=25000
      NTEMP=N
      DO2210I=1,NMCSAM
C
        DO2212J=1,NTEMP
          TEMP3(J)=REAL(J)
 2212   CONTINUE
C
        CALL NORRAN(NTEMP,ISEED,TEMP2)
        CALL DPDIX3(TEMP2,TEMP3,NTEMP,TEMP1,IWRITE,ICASAN,
     1              STATV2,
     1              ISUBRO,IBUGA3,IERROR)
        YSTAT(I)=STATV2
        WRITE(IOUNI2,'(3I8,2X,E15.7)')NCURVE,NREPL,I,YSTAT(I)
 2210 CONTINUE
      IDIR='LOWE'
      CALL DPGOF8(YSTAT,NMCSAM,STATVA,PVAL,IDIR,
     1            IBUGA3,ISUBRO,IERROR)
      STATCD=PVAL
      PVAL=1.0 - STATCD
      CUT0=YSTAT(1)
      CUT100=YSTAT(NMCSAM)
      IWRITE='OFF'
      DO2220I=2,NUMALP-1
        P100=ALPHA(I)
        CALL PERCEN(P100,YSTAT,NMCSAM,IWRITE,TEMP1,NMCSAM,
     1              XSTAT,IBUGA3,IERROR)
        IF(I.EQ.2)CUT25=XSTAT
        IF(I.EQ.3)CUT50=XSTAT
        IF(I.EQ.4)CUT75=XSTAT
        IF(I.EQ.5)CUT80=XSTAT
        IF(I.EQ.6)CUT90=XSTAT
        IF(I.EQ.7)CUT95=XSTAT
        IF(I.EQ.8)CUT975=XSTAT
        IF(I.EQ.9)CUT99=XSTAT
        IF(I.EQ.10)CUT995=XSTAT
 2220 CONTINUE
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DIX2')THEN
        WRITE(ICOUT,2231)PVAL,STATCD,CUT0,CUT25,CUT50,CUT75
 2231   FORMAT('PVAL,STATCD,CUT0,CUT25,CUT50,CUT75 = ',6G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2233)CUT80,CUT90,CUT95,CUT975,CUT99,CUT995,CUT100
 2233   FORMAT('CUT80,CUT90,CUT95,CUT975,CUT99,CUT995,CUT100 = ',7G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               *********************************
C               **   STEP 42--                 **
C               **   WRITE OUT EVERYTHING      **
C               **   FOR DIXON TEST            **
C               *********************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DIX2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      IF(ICASAN.EQ.'DI2S')THEN
        ITITLE=
     1  'Dixon Test for a Single Outlier: Two-Sided Case'
        NCTITL=47
      ELSEIF(ICASAN.EQ.'MINI')THEN
        ITITLE='Dixon Test for a Single Outlier: Minimum Case'
        NCTITL=52
      ELSEIF(ICASAN.EQ.'MAXI')THEN
        ITITLE='Dixon Test for a Single Outlier: Maximum Case'
        NCTITL=52
      ENDIF
      ITITLZ='(Assumption: Normality)'
      NCTITZ=23
C
      ICNT=1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Response Variable: '
      WRITE(ITEXT(ICNT)(20:23),'(A4)')IVARID(1)(1:4)
      WRITE(ITEXT(ICNT)(24:27),'(A4)')IVARI2(1)(1:4)
      NCTEXT(ICNT)=27
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      IF(NREPL.GT.0)THEN
        NRESP=1
        IADD=NLABID+NRESP
        DO4101I=1,NREPL
          ICNT=ICNT+1
          ITEMP=I+IADD
          ITEXT(ICNT)='Factor Variable  : '
          WRITE(ITEXT(ICNT)(17:17),'(I1)')I
          WRITE(ITEXT(ICNT)(20:23),'(A4)')IVARID(ITEMP)(1:4)
          WRITE(ITEXT(ICNT)(24:27),'(A4)')IVARI2(ITEMP)(1:4)
          NCTEXT(ICNT)=27
          AVALUE(ICNT)=PID(ITEMP)
          IDIGIT(ICNT)=NUMDIG
 4101   CONTINUE
      ENDIF
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='H0: There are no outliers'
      NCTEXT(ICNT)=25
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
C
      ITEXT(ICNT)=' '
      IF(ICASAN.EQ.'DI2S')THEN
        ITEXT(ICNT)(1:40)='Ha: The most extreme point is an outlier'
        NCTEXT(ICNT)=40
      ELSEIF(ICASAN.EQ.'MINI')THEN
        ITEXT(ICNT)(1:35)='Ha: The minimum point is an outlier'
        NCTEXT(ICNT)=35
      ELSEIF(ICASAN.EQ.'MAXI')THEN
        ITEXT(ICNT)(1:35)='Ha: The maximum point is an outlier'
        NCTEXT(ICNT)=35
      ENDIF
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=YMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='ID for Sample Minimum:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=X(INDMIN)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=YMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='ID for Sample Maximum:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=X(INDMAX)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=YMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample SD:'
      NCTEXT(ICNT)=10
      AVALUE(ICNT)=YSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Range:'
      NCTEXT(ICNT)=13
      AVALUE(ICNT)=YRANGE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Dixon Test Statistic Value:'
      NCTEXT(ICNT)=27
      AVALUE(ICNT)=STATVA
      IDIGIT(ICNT)=NUMDIG
C
      ICNT=ICNT+1
      ITEXT(ICNT)='CDF Value:'
      NCTEXT(ICNT)=10
      AVALUE(ICNT)=STATCD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='P-Value:'
      NCTEXT(ICNT)=7
      AVALUE(ICNT)=PVAL
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO4210I=1,NUMROW
        NTOT(I)=15
 4210 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      ISTEPN='42A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DIX2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ISTEPN='42B'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DIX2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ITITLE=' '
      NCTITL=0
C
      ITITL9=' '
      NCTIT9=0
      ITITLE(1:44)='Percent Points of the Reference Distribution'
      NCTITL=44
      NUMLIN=1
      NUMROW=NUMALP
      NUMCOL=3
      ITITL2(1,1)='Percent Point'
      ITITL2(1,2)=' '
      ITITL2(1,3)='Value'
      NCTIT2(1,1)=13
      NCTIT2(1,2)=1
      NCTIT2(1,3)=5
C
      NMAX=0
      DO4221I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(I.EQ.2)NTOT(I)=5
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
        ITYPCO(I)='NUME'
 4221 CONTINUE
      ITYPCO(2)='ALPH'
      IDIGIT(1)=1
      IDIGIT(3)=3
      DO4223I=1,NUMROW
        DO4225J=1,NUMCOL
          NCVALU(I,J)=0
          IVALUE(I,J)=' '
          NCVALU(I,J)=0
          AMAT(I,J)=0.0
          IF(J.EQ.1)THEN
            AMAT(I,J)=ALPHA(I)
          ELSEIF(J.EQ.2)THEN
            IVALUE(I,J)='='
            NCVALU(I,J)=1
          ELSEIF(J.EQ.3)THEN
            IF(I.EQ.1)THEN
              AMAT(I,J)=RND(CUT0,IDIGIT(J))
            ELSEIF(I.EQ.2)THEN
              AMAT(I,J)=RND(CUT25,IDIGIT(J))
            ELSEIF(I.EQ.3)THEN
              AMAT(I,J)=RND(CUT50,IDIGIT(J))
            ELSEIF(I.EQ.4)THEN
              AMAT(I,J)=RND(CUT75,IDIGIT(J))
            ELSEIF(I.EQ.5)THEN
              AMAT(I,J)=RND(CUT80,IDIGIT(J))
            ELSEIF(I.EQ.6)THEN
              AMAT(I,J)=RND(CUT90,IDIGIT(J))
            ELSEIF(I.EQ.7)THEN
              AMAT(I,J)=RND(CUT95,IDIGIT(J))
            ELSEIF(I.EQ.8)THEN
              AMAT(I,J)=RND(CUT975,IDIGIT(J))
            ELSEIF(I.EQ.9)THEN
              AMAT(I,J)=RND(CUT99,IDIGIT(J))
            ELSEIF(I.EQ.10)THEN
              AMAT(I,J)=RND(CUT995,IDIGIT(J))
            ELSEIF(I.EQ.11)THEN
              AMAT(I,J)=RND(CUT100,IDIGIT(J))
            ENDIF
          ENDIF
 4225   CONTINUE
 4223 CONTINUE
C
      IWHTML(1)=150
      IWHTML(2)=50
      IWHTML(3)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+500
      IWRTF(3)=IWRTF(2)+2000
      IFRST=.TRUE.
      ILAST=.FALSE.
C
      ISTEPN='42C'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DIX2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDTA4(ITITL9,NCTIT9,
     1            ITITLE,NCTITL,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,NUMROW,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ISTEPN='42D'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DIX2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CDF1=CUT90
      CDF2=CUT95
      CDF3=CUT975
      CDF4=CUT99
C
      ITITL9=' '
      NCTIT9=0
      ITITLE='Conclusions (Upper 1-Tailed Test)'
      NCTITL=33
      NUMLIN=1
      NUMROW=4
      NUMCOL=4
      ITITL2(1,1)='Alpha'
      ITITL2(1,2)='CDF'
      ITITL2(1,3)='Critical Value'
      ITITL2(1,4)='Conclusion'
      NCTIT2(1,1)=5
      NCTIT2(1,2)=3
      NCTIT2(1,3)=14
      NCTIT2(1,4)=10
C
      NMAX=0
      DO4321I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(I.EQ.1 .OR. I.EQ.2)NTOT(I)=7
        IF(I.EQ.3)NTOT(I)=17
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=3
        ITYPCO(I)='ALPH'
 4321 CONTINUE
      ITYPCO(3)='NUME'
      IDIGIT(1)=0
      IDIGIT(2)=0
      DO4323I=1,NUMROW
        DO4325J=1,NUMCOL
          NCVALU(I,J)=0
          IVALUE(I,J)=' '
          NCVALU(I,J)=0
          AMAT(I,J)=0.0
 4325   CONTINUE
 4323 CONTINUE
      IVALUE(1,1)='10%'
      IVALUE(2,1)='5%'
      IVALUE(3,1)='2.5%'
      IVALUE(4,1)='1%'
      NCVALU(1,1)=3
      NCVALU(2,1)=2
      NCVALU(3,1)=4
      NCVALU(4,1)=2
      IVALUE(1,2)='90%'
      IVALUE(2,2)='95%'
      IVALUE(3,2)='97.5%'
      IVALUE(4,2)='99%'
      NCVALU(1,2)=3
      NCVALU(2,2)=3
      NCVALU(3,2)=4
      NCVALU(4,2)=3
      IVALUE(1,4)='Accept H0'
      IVALUE(2,4)='Accept H0'
      IVALUE(3,4)='Accept H0'
      IVALUE(4,4)='Accept H0'
      NCVALU(1,4)=9
      NCVALU(2,4)=9
      NCVALU(3,4)=9
      NCVALU(4,4)=9
      IF(STATVA.GT.CDF1)IVALUE(1,4)='Reject H0'
      IF(STATVA.GT.CDF2)IVALUE(2,4)='Reject H0'
      IF(STATVA.GT.CDF3)IVALUE(3,4)='Reject H0'
      IF(STATVA.GT.CDF4)IVALUE(4,4)='Reject H0'
      AMAT(1,3)=RND(CDF1,IDIGIT(3))
      AMAT(2,3)=RND(CDF2,IDIGIT(3))
      AMAT(3,3)=RND(CDF3,IDIGIT(3))
      AMAT(4,3)=RND(CDF4,IDIGIT(3))
C
      IWHTML(1)=150
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWRTF(1)=1500
      IWRTF(2)=IWRTF(1)+1500
      IWRTF(3)=IWRTF(2)+2000
      IWRTF(4)=IWRTF(3)+2000
      IFRST=.FALSE.
C
C     FOR LATEX, WE WANT TO ENSURE THAT TRAILING LINE IS PART
C     OF THE TABLE SO THAT IT WILL BE PRINTED IN THE PROPER PLACE.
C
      IF(ICAPTY.EQ.'LATE')THEN
        ILAST=.FALSE.
      ELSE
        ILAST=.TRUE.
      ENDIF
C
      ISTEPN='42E'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DIX2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDTA4(ITITL9,NCTIT9,
     1            ITITLE,NCTITL,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,NUMROW,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ITITLE(1:26)='*Critical Values Based on '
      WRITE(ITITLE(27:34),'(I8)')NMCSAM
      ITITLE(35:58)=' Monte Carlo Simulations'
      NCTITL=58
C
      IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
        CALL DPHTMV(ITITLE,NCTITL,CPUMIN,NUMDIG)
      ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
        CALL DPLATV(ITITLE,NCTITL,CPUMIN,NUMDIG)
        IFLAG1=.FALSE.
        IFLAG2=.TRUE.
        IFLAG3=.TRUE.
        CALL DPLATZ(IFLAG1,IFLAG2,IFLAG3,NHEAD)
      ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF ')THEN
C
        CALL DPCONA(92,IBASLC)
        IRTFMD='OFF'
        IPTSZ=14
        WRITE(ICOUT,8199)IBASLC,IPTSZ
 8199   FORMAT(A1,'fs',I2)
        CALL DPWRST(ICOUT,'WRIT')
        IF(IRTFFF.EQ.'Courier New')THEN
          ITEMP=1
        ELSEIF(IRTFFF.EQ.'Lucida Console')THEN
          ITEMP=8
        ENDIF 
        WRITE(ICOUT,8301)IBASLC,ITEMP
        CALL DPWRST(ICOUT,'WRIT')
        CALL DPRTFZ(ITITLE,NCTITL,CPUMIN,NUMDIG)
        IF(IRTFFP.EQ.'Times New Roman')THEN
          ITEMP=0
        ELSEIF(IRTFFP.EQ.'Lucida Sans')THEN
          ITEMP=6
        ELSEIF(IRTFFP.EQ.'Arial')THEN
          ITEMP=2
        ELSEIF(IRTFFP.EQ.'Bookman')THEN
          ITEMP=3
        ELSEIF(IRTFFP.EQ.'Georgia')THEN
          ITEMP=4
        ELSEIF(IRTFFP.EQ.'Tahoma')THEN
          ITEMP=5
        ELSEIF(IRTFFP.EQ.'Verdana')THEN
          ITEMP=7
        ENDIF 
        WRITE(ICOUT,8301)IBASLC,ITEMP
 8301   FORMAT(A1,'f',I1)
        CALL DPWRST(ICOUT,'WRIT')
C
C       END TABLE AND RESET "ASIS" MODE
C
        IF(IRTFFF.EQ.'Courier New')THEN
          ITEMP=1
        ELSEIF(IRTFFF.EQ.'Lucida Console')THEN
          ITEMP=8
        ENDIF 
        WRITE(ICOUT,8091)IBASLC,ITEMP
 8091   FORMAT(A1,'f',I1)
        CALL DPWRST(ICOUT,'WRIT')
C
        CALL DPRTF6(NHEAD)
        CALL DPRTF6(NHEAD)
        IRTFMD='VERB'
      ELSE
        WRITE(ICOUT,2589)ITITLE(1:58)
 2589   FORMAT(A60)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DIX2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDIX2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IERROR
 9012   FORMAT('N,IERROR = ',I8,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)STATVA,STATCD,PVAL
 9013   FORMAT('STATVA,STATCD,PVAL = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDIX3(Y,X,N,TEMP1,IWRITE,ICASAN,
     1                  XDIXON,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE DIXON STATISTIC.
C              THE DIXON STATISTIC DETERMINES WHETHER THE
C              MINIMUM (OR MAXIMUM) IS AN OUTLIER.  IT IS ASSUMMED
C              THE UNDERLYING DATA IS APPROXIMATELY NORMAL.  THIS
C              TEST IS PRIMARILY RECOMMNEDED FOR SMALL SAMPLES
C              (SAY N <= 30).
C     REFERENCES--DIXON (1953), "PROCESSING DATA FOR OUTLIERS",
C                 BIOMETRICS, VOL. 9, NO. 1, PP. 74-89.
C     INPUT  ARGUMENTS--Y      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --X      = THE LAB-ID VARIABLE
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR Y.
C                     --ICASAN = SPECIFIES WHETHER MINIMUM OR MAXIMUM
C                                CASE IS DESIRED.
C     OUTPUT ARGUMENTS--XDIXON = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED DIXON STATISTIC.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             DIXON STATISTIC.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--SORT.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009.11
C     ORIGINAL VERSION--NOVEMBER  2009.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ICASAN
      CHARACTER*4 IWRTSV
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDI'
      ISUBN2='X3  '
      IWRTSV=IWRITE
      XDIXON=CPUMIN
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DIX3')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPDIX3--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ICASAN
   52   FORMAT('IBUGA3,ICASAN = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)N
   53   FORMAT('N = ',I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,Y(I),X(I)
   56     FORMAT('I,Y(I),X(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               *******************************
C               **  COMPUTE DIXON STATISTIC  **
C               *******************************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(N.LT.3)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN DIXON STATISTIC--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,112)
  112   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS FOR THE ',
     1         'RESPONSE VARIABLE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,113)
  113   FORMAT('      MUST BE 3 OR LARGER.  SUCH WAS NOT THE CASE ',
     1         'HERE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,117)N
  117   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS = ',I8,
     1         '.')
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      IF(N.GT.30)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,122)
  122   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS FOR THE ',
     1         'RESPONSE VARIABLE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,123)
  123   FORMAT('      MUST BE LESS THAN OR EQUAL TO 30.  SUCH WAS ',
     1         'NOT THE CASE HERE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,127)N
  127   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS = ',I8,
     1         '.')
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C               *****************************************
C               **  STEP 2--                           **
C               **  COMPUTE THE DIXON STATISTIC.       **
C               *****************************************
C
      CALL SORTC(Y,X,N,Y,TEMP1)
      DO130I=1,N
        X(I)=TEMP1(I)
  130 CONTINUE
C
      IF(N.GE.3 .AND. N.LE.7)THEN
C
C       CASE 1: 3 <= N <= 7
C
C               MINIMUM: R = (Y(2) - Y(1))/(Y(N) - Y(1))
C               MAXIMUM: R = (Y(N) - Y(N-1))/(Y(N) - Y(1))
C
        IF(ICASAN.EQ.'MINI')THEN
          ANUM=Y(2) - Y(1)
          ADEN=Y(N) - Y(1)
          IF(ADEN.LE.0.0)GOTO8000
          XDIXON=ANUM/ADEN
        ELSEIF(ICASAN.EQ.'MAXI')THEN
          ANUM=Y(N) - Y(N-1)
          ADEN=Y(N) - Y(1)
          IF(ADEN.LE.0.0)GOTO8000
          XDIXON=ANUM/ADEN
        ELSE
          ANUM=Y(2) - Y(1)
          ADEN=Y(N) - Y(1)
          IF(ADEN.LE.0.0)THEN
            XDIX1=CPUMIN
          ELSE
            XDIX1=ANUM/ADEN
          ENDIF
          ANUM=Y(N) - Y(N-1)
          ADEN=Y(N) - Y(1)
          IF(ADEN.LE.0.0)THEN
            XDIX2=CPUMIN
          ELSE
            XDIX2=ANUM/ADEN
          ENDIF
          XDIXON=MAX(XDIX1,XDIX2)
          IF(XDIXON.EQ.CPUMIN)GOTO8000
        ENDIF
C
      ELSEIF(N.GE.8 .AND. N.LE.10)THEN
C
C       CASE 2: 8 <= N <= 10
C
C               MINIMUM: R = (Y(2) - Y(1))/(Y(N-1) - Y(1))
C               MAXIMUM: R = (Y(N) - Y(N-1))/(Y(N) - Y(2))
C
        IF(ICASAN.EQ.'MINI')THEN
          ANUM=Y(2) - Y(1)
          ADEN=Y(N-1) - Y(1)
          IF(ADEN.LE.0.0)GOTO8000
          XDIXON=ANUM/ADEN
        ELSEIF(ICASAN.EQ.'MAXI')THEN
          ANUM=Y(N) - Y(N-1)
          ADEN=Y(N) - Y(2)
          IF(ADEN.LE.0.0)GOTO8000
          XDIXON=ANUM/ADEN
        ELSE
          ANUM=Y(2) - Y(1)
          ADEN=Y(N) - Y(1)
          IF(ADEN.LE.0.0)THEN
            XDIX1=CPUMIN
          ELSE
            XDIX1=ANUM/ADEN
          ENDIF
          ANUM=Y(N) - Y(N-1)
          ADEN=Y(N) - Y(1)
          IF(ADEN.LE.0.0)THEN
            XDIX2=CPUMIN
          ELSE
            XDIX2=ANUM/ADEN
          ENDIF
          XDIXON=MAX(XDIX1,XDIX2)
          IF(XDIXON.EQ.CPUMIN)GOTO8000
        ENDIF
C
      ELSEIF(N.GE.11 .AND. N.LE.13)THEN
C
C       CASE 3: 11 <= N <= 13
C
C               MINIMUM: R = (Y(3) - Y(1))/(Y(N-1) - Y(1))
C               MAXIMUM: R = (Y(N) - Y(N-2))/(Y(N) - Y(2))
C
        IF(ICASAN.EQ.'MINI')THEN
          ANUM=Y(3) - Y(1)
          ADEN=Y(N-1) - Y(1)
          IF(ADEN.LE.0.0)GOTO8000
          XDIXON=ANUM/ADEN
        ELSEIF(ICASAN.EQ.'MAXI')THEN
          ANUM=Y(N) - Y(N-2)
          ADEN=Y(N) - Y(2)
          IF(ADEN.LE.0.0)GOTO8000
          XDIXON=ANUM/ADEN
        ELSE
          ANUM=Y(3) - Y(1)
          ADEN=Y(N-1) - Y(1)
          IF(ADEN.LE.0.0)THEN
            XDIX1=CPUMIN
          ELSE
            XDIX1=ANUM/ADEN
          ENDIF
          ANUM=Y(N) - Y(N-2)
          ADEN=Y(N) - Y(2)
          IF(ADEN.LE.0.0)THEN
            XDIX2=CPUMIN
          ELSE
            XDIX2=ANUM/ADEN
          ENDIF
          XDIXON=MAX(XDIX1,XDIX2)
        ENDIF
C
      ELSEIF(N.GE.14 .AND. N.LE.30)THEN
C
C       CASE 4: 14 <= N <= 30
C
C               MINIMUM: R = (X(3) - X(1))/(X(N-2) - X(1))
C               MAXIMUM: R = (X(N) - X(N-2))/(X(N) - X(3))
C
        IF(ICASAN.EQ.'MINI')THEN
          ANUM=Y(3) - Y(1)
          ADEN=Y(N-2) - Y(1)
          IF(ADEN.LE.0.0)GOTO8000
          XDIXON=ANUM/ADEN
        ELSEIF(ICASAN.EQ.'MAXI')THEN
          ANUM=Y(N) - Y(N-2)
          ADEN=Y(N) - Y(3)
          IF(ADEN.LE.0.0)GOTO8000
          XDIXON=ANUM/ADEN
        ELSE
          ANUM=Y(3) - Y(1)
          ADEN=Y(N-2) - Y(1)
          IF(ADEN.LE.0.0)THEN
            XDIX1=CPUMIN
          ELSE
            XDIX1=ANUM/ADEN
          ENDIF
          ANUM=Y(N) - Y(N-2)
          ADEN=Y(N) - Y(3)
          IF(ADEN.LE.0.0)THEN
            XDIX2=CPUMIN
          ELSE
            XDIX2=ANUM/ADEN
          ENDIF
          XDIXON=MAX(XDIX1,XDIX2)
        ENDIF
C
      ENDIF
C
      GOTO9000
C
 8000 CONTINUE
      IERROR='YES'
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,111)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,8011)
 8011 FORMAT('      THE DENOMINATOR FOR THE DIXON TEST IS ZERO.  ',
     1       'UNABLE TO')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,8013)
 8013 FORMAT('      TO COMPUTE THE DIXON STATISTIC.')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DIX3')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDIX3--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGA3,IERROR
 9012   FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)N
 9013   FORMAT('N = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)ANUM,ADEN,XDIXON
 9015   FORMAT('ANUM,ADEN,XDIXON = ',3G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)Y(1),Y(2),Y(3)
 9016   FORMAT('Y(1),Y(2),Y(3) = ',3G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9017)Y(N),Y(N-1),Y(N-2)
 9017   FORMAT('Y(N),Y(N-1),Y(N-2) = ',3G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDLPL(NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2,ISEED,
     1ISUBRO,IBUGG2,IBUGG3,IBUGQ,IFOUND,IERROR)
C
C     PURPOSE--GENERATE A DETECTION LIMIT PLOT
C     EXAMPLE--DETECTION LIMIT PLOT IMS MASS VAL1
C              DETECTION LIMIT PLOT IMS MASS VAL1  VAL2
C              NOTE THAT VAL1 AND VAL2 DENOTE VALUES OF THE
C              MASS VARIABLE.  THERE MUST BE AT LEAST ONE VALUE
C              GIVEN AND CURRENTLY UP TO 5 VALUES MAY BE SPECIFIED.
C     REFERENCE--IMPLEMENTS A METHOD SUGGESTED BY
C                MICHAEL VERKOUTEREN OF THE NIST SURFACE AND
C                MICROANALYSIS SCIENCE DIVISION
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATROY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/12
C     ORIGINAL VERSION--DECEMBER  2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IAND1
      CHARACTER*4 IAND2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGG2
      CHARACTER*4 IBUGG3
      CHARACTER*4 IBUGQ
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 ICASEQ
      CHARACTER*4 IDATSW
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
      CHARACTER*4 IHBATC
      CHARACTER*4 IHBAT2
      CHARACTER*4 IERRO4
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 IH41
      CHARACTER*4 IH42
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 IHP
      CHARACTER*4 IHP2
      CHARACTER*4 ISUBN0
C
      REAL MUML
      REAL SDML
      REAL MUMLSE
      REAL SDMLSE
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
C
      DIMENSION Y1(MAXOBV)
      DIMENSION X1(MAXOBV)
      DIMENSION TAG1(MAXOBV)
      DIMENSION XMATCH(MAXOBV)
      DIMENSION TEMP1(MAXOBV)
      DIMENSION TEMP2(MAXOBV)
      DIMENSION TEMP3(MAXOBV)
      DIMENSION TEMP4(MAXOBV)
      DIMENSION TEMP5(MAXOBV)
      DIMENSION QP(MAXOBV)
      DIMENSION XQPHAT(MAXOBV)
      DIMENSION XQPLCL(MAXOBV)
      DIMENSION XQPUCL(MAXOBV)
      INCLUDE 'DPCOZZ.INC'
      EQUIVALENCE (GARBAG(IGARB1),X1(1))
      EQUIVALENCE (GARBAG(IGARB2),Y1(1))
      EQUIVALENCE (GARBAG(IGARB3),TAG1(1))
      EQUIVALENCE (GARBAG(IGARB4),XMATCH(1))
      EQUIVALENCE (GARBAG(IGARB5),TEMP1(1))
      EQUIVALENCE (GARBAG(IGARB6),TEMP2(1))
      EQUIVALENCE (GARBAG(IGARB7),TEMP3(1))
      EQUIVALENCE (GARBAG(IGARB8),TEMP4(1))
      EQUIVALENCE (GARBAG(IGARB9),TEMP5(1))
      EQUIVALENCE (GARBAG(IGARB9),TEMP5(1))
      EQUIVALENCE (GARBAG(IGAR10),QP(1))
      EQUIVALENCE (GARBAG(JGAR11),XQPHAT(1))
      EQUIVALENCE (GARBAG(JGAR12),XQPLCL(1))
      EQUIVALENCE (GARBAG(JGAR13),XQPUCL(1))
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOST.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      ISUBN1='DPDL'
      ISUBN2='PL  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      MAXV2=2
      IF(ICASPL.EQ.'BSPL')MAXV2=3
      MINN2=2
C
      ICOLR=0
C
C               **********************************************
C               **  TREAT THE DETECTION LIMIT PLOT          **
C               **********************************************
C
      IF(IBUGG2.EQ.'ON' .OR. ISUBRO.EQ.'DLPL')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPDLPL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)ICASPL,IAND1,IAND2
   52   FORMAT('ICASPL,IAND1,IAND2 = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)IBUGG2,IBUGG3,IBUGQ
   53   FORMAT('IBUGG2,IBUGG3,IBUGQ = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ***************************
C               **  STEP 1--             **
C               **  EXTRACT THE COMMAND  **
C               ***************************
C
      ISTEPN='1'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DLPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(ICOM.EQ.'DETE'.AND.IHARG(1).EQ.'LIMI'.AND.
     1   IHARG(2).EQ.'PLOT')THEN
        ICASPL='DLPL'
        ILASTC=2
        CALL ADJUST(ILASTC,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
        IFOUND='YES'
      ELSEIF(ICOM.EQ.'NORM'.AND.IHARG(1).EQ.'DETE'.AND.
     1   IHARG(2).EQ.'LIMI'.AND.IHARG(3).EQ.'PLOT')THEN
        ICASPL='DLPL'
        ILASTC=3
        CALL ADJUST(ILASTC,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
        IFOUND='YES'
      ELSE
        IFOUND='NO'
        GOTO9000
      ENDIF
C
C               *******************************************************
C               **  STEP 2--                                         **
C               **  CHECK FOR THE PROPER NUMBER OF INPUT ARGUMENTS.  **
C               *******************************************************
C
      ISTEPN='1'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DLPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      MINNA=3
      MAXNA=100
      CALL CHECKA(NUMARG,MINNA,MAXNA,IANS,IWIDTH,ISUBN1,ISUBN2,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               ********************************************
C               **  STEP 2--                              **
C               **  CHECK THE VALIDITY OF ARGUMENT 1      **
C               **  (THIS WILL BE THE RESPONSE VARIABLE)  **
C               ********************************************
C
      ISTEPN='2'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DLPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHLEFT=IHARG(1)
      IHLEF2=IHARG2(1)
      IHWUSE='V'
      MESSAG='YES'
      CALL CHECKN(IHLEFT,IHLEF2,IHWUSE,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCV,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
      ICOLL=IVALUE(ILOCV)
      NLEFT=IN(ILOCV)
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DLPL')THEN
        WRITE(ICOUT,211)IHLEFT,IHLEF2,ICOLL,NLEFT
  211   FORMAT('IHLEFT,IHLEF2,ICOLL,NLEFT = ',A4,2X,A4,I8,I8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ******************************************************
C               **  STEP 3--                                        **
C               **  CHECK THAT THE INPUT NUMBER OF OBSERVATIONS     **
C               **  (NLEFT) FOR THE RESPONSE VARIABLE IS POSITIVE.  **
C               ******************************************************
C
      ISTEPN='3'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DLPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NLEFT.LT.MINN2)THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,311)
  311   FORMAT('***** ERROR IN DETECTION LIMIT PLOT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,312)
  312   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS FOR WHICH A')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,314)MINN2
  314   FORMAT('      DETECTION LIMIT PLOT WAS TO HAVE BEEN FORMED ',
     1         'MUST BE ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,316)
  316   FORMAT('      OR LARGER;  SUCH WAS NOT THE CASE HERE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,317)
  317   FORMAT('      THE ENTERED COMMAND LINE WAS AS FOLLOWS--')
        CALL DPWRST('XXX','BUG ')
        IF(IWIDTH.GE.1)THEN
          WRITE(ICOUT,318)(IANS(I),I=1,MIN(80,IWIDTH))
  318     FORMAT(80A1)
          CALL DPWRST('XXX','BUG ')
        ENDIF
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               *****************************************
C               **  STEP 4--                           **
C               **  CHECK TO SEE THE TYPE SUBCASE      **
C               **  (BASED ON THE QUALIFIER)--         **
C               **    1) UNQUALIFIED (THAT IS, FULL);  **
C               **    2) SUBSET/EXCEPT; OR             **
C               **    3) FOR.                          **
C               *****************************************
C
      ISTEPN='4'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DLPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ICASEQ='FULL'
      ILOCQ=NUMARG+1
      IF(NUMARG.LT.1)GOTO480
      DO400J=1,NUMARG
      J1=J
      IF(IHARG(J).EQ.'SUBS'.AND.IHARG2(J).EQ.'ET  ') GOTO410
      IF(IHARG(J).EQ.'EXCE'.AND.IHARG2(J).EQ.'PT  ') GOTO410
      IF(IHARG(J).EQ.'FOR '.AND.IHARG2(J).EQ.'    ') GOTO420
  400 CONTINUE
      GOTO490
  410 CONTINUE
      ICASEQ='SUBS'
      ILOCQ=J1
      GOTO490
  420 CONTINUE
      ICASEQ='FOR'
      ILOCQ=J1
      GOTO490
C
  480 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,481)
  481 FORMAT('***** INTERNAL ERROR IN DPDLPL')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,482)
  482 FORMAT('      AT BRANCH POINT 481--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,483)
  483 FORMAT('      NUMARG LESS THAN 1 EVEN THOUGH')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,484)
  484 FORMAT('      NUMARG HAD PREVIOUSLY PASSED THIS TEST')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,485)NUMARG
  485 FORMAT('      ONCE ALREADY.  VALUE OF NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,317)
      CALL DPWRST('XXX','BUG ')
      IF(IWIDTH.GE.1)THEN
        WRITE(ICOUT,318)(IANS(I),I=1,MIN(80,IWIDTH))
        CALL DPWRST('XXX','BUG ')
      ENDIF
      IERROR='YES'
      GOTO9000
C
  490 CONTINUE
      IF(IBUGG2.EQ.'ON' .OR. ISUBRO.EQ.'DLPL')THEN
        WRITE(ICOUT,491)NUMARG,ILOCQ,ICASEQ
  491   FORMAT('NUMARG,ILOCQ,ICASEQ = ',I8,I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ******************************************************
C               **  STEP 5--                                        **
C               **  DETERMINE HOW MANY ARGUMENTS THERE ARE          **
C               **  NOT INCLUDING <SUBSET/EXCEPT/FOR>.  THE         **
C               **  SECOND ARGUMENT MUST BE A VARIABLE WHILE        **
C               **  ARGUMENTS THREE AND ABOVE SHOULD BE             **
C               **  SCALARS.  VARIABLE TWO SHOULD BE THE SAME       **
C               **  SIZE AS VARIABLE ONE.                           **
C               ******************************************************
C
      ISTEPN='5'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DLPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NUMV2=ILOCQ-1
      IF(NUMV2.LT.3)THEN
        WRITE(ICOUT,311)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,501)
  501   FORMAT('      THE NUMBER OF INPUT ARGUMENTS MUST BE AT LEAST')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,502)NUMV2
  502   FORMAT('      THREE.  ONLY ',I5,' ARGUMENTS GIVEN HERE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,317)
        CALL DPWRST('XXX','BUG ')
        IF(IWIDTH.GE.1)THEN
          WRITE(ICOUT,318)(IANS(I),I=1,MIN(80,IWIDTH))
          CALL DPWRST('XXX','BUG ')
        ENDIF
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IHRIGH=IHARG(2)
      IHRIG2=IHARG2(2)
      IHWUSE='V'
      MESSAG='YES'
      CALL CHECKN(IHRIGH,IHRIG2,IHWUSE,
     1            IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,
     1            NUMNAM,MAXNAM,
     1            ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCV,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
      ICOLR=IVALUE(ILOCV)
      NRIGHT=IN(ILOCV)
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DLPL')THEN
        WRITE(ICOUT,511)IHRIGH,IHRIG2,ICOLR,NRIGHT
  511   FORMAT('IHRIGH,IHRIG2,ICOLR,NRIGHT = ',A4,2X,A4,2I8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(NRIGHT.NE.NLEFT)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,311)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,572)
  572   FORMAT('      FOR A DETECTION LIMIT PLOT, WHEN WE HAVE TWO ',
     1         'VARIABLES')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,579)
  579   FORMAT('      SPECIFIED, THE NUMBER OF ELEMENTS IN THE TWO')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,581)
  581   FORMAT('      VARIABLES MUST BE THE SAME;  SUCH WAS NOT ',
     1         'THE CASE HERE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,583)
  583   FORMAT('      THE FIRST  VARIABLE  (FREQUENCIES)--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,584)IHLEFT,IHLEF2,NLEFT
  584   FORMAT('                  ',A4,A4,'  HAS ',I8,' ELEMENTS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,585)
  585   FORMAT('      THE SECOND VARIABLE  (HORIZ. AXIS VALUES)--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,586)IHRIGH,IHRIG2,NRIGHT
  586   FORMAT('                  ',A4,A4,'  HAS ',I8,' ELEMENTS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,317)
        CALL DPWRST('XXX','BUG ')
        IF(IWIDTH.GE.1)THEN
          WRITE(ICOUT,318)(IANS(I),I=1,MIN(80,IWIDTH))
          CALL DPWRST('XXX','BUG ')
        ENDIF
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               ******************************************************
C               **  STEP 6--                                        **
C               **  EXTRACT THE ARGUMENTS 3 AND ABOVE AS SCALARS.   **
C               ******************************************************
C
      NPAR=0
      DO610I=3,NUMV2
        IHWUSE='P'
        MESSAG='YES'
        IHBATC=IHARG(I)
        IHBAT2=IHARG2(I)
        CALL CHECKN(IHBATC,IHBAT2,IHWUSE,
     1              IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,
     1              NUMNAM,MAXNAM,
     1              ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCV,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        NPAR=NPAR+1
        XMATCH(NPAR)=VALUE(ILOCV)
C
        IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DLPL')THEN
          WRITE(ICOUT,611)IHBATC,IHBAT2,NPAR,XMATCH(NPAR)
  611     FORMAT('IHBATCH,IHBAT2,NPAR,XMATCH(NPAR) = ',A4,A4,I8,G15.7)
          CALL DPWRST('XXX','BUG ')
        ENDIF
C
  610 CONTINUE
C
C               *****************************************
C               **  STEP 7--                           **
C               **  BRANCH TO THE APPROPRIATE SUBCASE; **
C               **  (BASED ON THE QUALIFIER)           **
C               **  THEN FORM THE RESPONSE VARIABLE    **
C               **  AND THE FACTORS                    **
C               **  AND CARRY OUT THE PLOTS.           **
C               *****************************************
C
      ISTEPN='7'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DLPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(ICASEQ.EQ.'FULL')GOTO710
      IF(ICASEQ.EQ.'SUBS')GOTO720
      IF(ICASEQ.EQ.'FOR')GOTO730
C
  710 CONTINUE
      DO715I=1,NLEFT
      ISUB(I)=1
  715 CONTINUE
      NQ=NLEFT
      GOTO750
C
  720 CONTINUE
      NIOLD=NLEFT
      CALL DPSUBS(NIOLD,ILOCS,NS,IBUGQ,IERRO4)
      NQ=NIOLD
      GOTO750
C
  730 CONTINUE
      NIOLD=NLEFT
      CALL DPFOR(NIOLD,NFOR,IROW1,IROWN,
     1NLOCAL,ILOCS,NS,IBUGQ,IERROR)
      NQ=NFOR
      GOTO750
C
  750 CONTINUE
C
      J=0
      IMAX=NLEFT
      IF(NQ.LT.NLEFT)IMAX=NQ
      DO810I=1,IMAX
        IF(ISUB(I).EQ.0)GOTO810
        J=J+1
        IJ=MAXN*(ICOLL-1)+I
        IF(ICOLL.LE.MAXCOL)Y1(J)=V(IJ)
        IF(ICOLL.EQ.MAXCP1)Y1(J)=PRED(I)
        IF(ICOLL.EQ.MAXCP2)Y1(J)=RES(I)
        IF(ICOLL.EQ.MAXCP3)Y1(J)=YPLOT(I)
        IF(ICOLL.EQ.MAXCP4)Y1(J)=XPLOT(I)
        IF(ICOLL.EQ.MAXCP5)Y1(J)=X2PLOT(I)
        IF(ICOLL.EQ.MAXCP6)Y1(J)=TAGPLO(I)
C
        IJ=MAXN*(ICOLR-1)+I
        IF(ICOLR.LE.MAXCOL)X1(J)=V(IJ)
        IF(ICOLR.EQ.MAXCP1)X1(J)=PRED(I)
        IF(ICOLR.EQ.MAXCP2)X1(J)=RES(I)
        IF(ICOLR.EQ.MAXCP3)X1(J)=YPLOT(I)
        IF(ICOLR.EQ.MAXCP4)X1(J)=XPLOT(I)
        IF(ICOLR.EQ.MAXCP5)X1(J)=X2PLOT(I)
        IF(ICOLR.EQ.MAXCP6)X1(J)=TAGPLO(I)
C
  810 CONTINUE
      NLOCAL=J
C
C               ******************************************************
C               **  STEP 8B--                                       **
C               **  CHECK TO SEE IF A "PERCENTILES" VARIABLE HAS    **
C               **  BEEN SPECIFIED (VIA THE SET MAXIMIM LIKELIHOOD  **
C               **  PERCENTILES COMMAND).  IF SO, EXTRACT THE NAME. **
C               ******************************************************
C
      ISTEPN='8B'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DLPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IQUAVR.EQ.'NONE')THEN
        NPERC=0
      ELSEIF(IQUAVR.EQ.'DEFAULT')THEN
        QP(1)=0.5
        QP(2)=1.0
        QP(3)=5.0
        QP(4)=10.0
        QP(5)=20.0
        QP(6)=30.0
        QP(7)=40.0
        QP(8)=50.0
        QP(9)=60.0
        QP(10)=70.0
        QP(11)=80.0
        QP(12)=90.0
        QP(13)=95.0
        QP(14)=97.5
        QP(15)=99.0
        QP(16)=99.5
        NPERC=16
      ELSE
        IH41=IQUAVR(1:4)
        IH42=IQUAVR(5:8)
        IHWUSE='V'
        MESSAG='NO'
        CALL CHECKN(IH41,IH42,IHWUSE,
     1              IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1              ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCV,IERROR)
C
        IF(IERROR.EQ.'YES')THEN
          NPERC=0
        ELSE
          ICOLQP=IVALUE(ILOCV)
          NPERC=IN(ILOCV)
          ICNT=0
          DO860I=1,NPERC
            IJ=MAXN*(ICOLQP-1)+I
            ICNT=ICNT+1
            IF(ICOLQP.LE.MAXCOL)QP(ICNT)=V(IJ)
            IF(ICOLQP.EQ.MAXCP1)QP(ICNT)=PRED(I)
            IF(ICOLQP.EQ.MAXCP2)QP(ICNT)=RES(I)
            IF(ICOLQP.EQ.MAXCP3)QP(ICNT)=YPLOT(I)
            IF(ICOLQP.EQ.MAXCP4)QP(ICNT)=XPLOT(I)
            IF(ICOLQP.EQ.MAXCP5)QP(ICNT)=X2PLOT(I)
            IF(ICOLQP.EQ.MAXCP6)QP(ICNT)=TAGPLO(I)
            IF(QP(ICNT).LE.0.0 .OR. QP(ICNT).GE.100.0)THEN
              ICNT=ICNT-1
            ENDIF
  860     CONTINUE
          NPERC=ICNT
C
        ENDIF
      ENDIF
C
      IHP='ALPH'
      IHP2='A   '
      IHWUSE='P'
      MESSAG='NO'
      CALL CHECKN(IHP,IHP2,IHWUSE,
     1            IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1            ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
      ALPHA=0.05
      IF(IERROR.EQ.'NO')ALPHA=VALUE(ILOCP)
      IF(ALPHA.LE.0.0 .OR. ALPHA.GE.1.0)THEN
        ALPHA=0.05
      ELSEIF(ALPHA.GT.0.50)THEN
        ALPHA=1.0-ALPHA
      ENDIF
C
      IHP='THRE'
      IHP2='SHHO'
      IHWUSE='P'
      MESSAG='NO'
      CALL CHECKN(IHP,IHP2,IHWUSE,
     1            IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1            ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
      THRESH=CPUMIN
      IF(IERROR.EQ.'NO')THRESH=VALUE(ILOCP)
C
C               *****************************************************
C               **  STEP 9--                                       **
C               **  FORM THE VERTICAL AND HORIZONTAL AXIS          **
C               **  VALUES Y(.) AND X(.) FOR THE PLOT.             **
C               **  RESET THE VECTOR D(.) TO ALL ONES.             **
C               **  DEFINE THE NUMBER OF PLOT POINTS    (NPLOTP).  **
C               **  DEFINE THE NUMBER OF PLOT VARIABLES (NPLOTV).  **
C               *****************************************************
C
      ISTEPN='9'
      IF(IBUGG2.EQ.'ON' .OR. ISUBRO.EQ.'DLPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDLP2(Y1,X1,NLOCAL,XMATCH,NPAR,
     1            ICASPL,IHLEFT,IHLEF2,IHRIGH,IHRIG2,ALPHA,
     1            TEMP1,TEMP2,TEMP3,TEMP4,TEMP5,
     1            QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1            UPP95,LOW05,CDFTHR,
     1            MUML,SDML,
     1            MUMLSE,SDMLSE,COVSE,ACORR,
     1            NPOS,NZERO,
     1            YMEAN1,YSD1,YMIN1,THRESH,PRZERO,
     1            Y,X,D,NPLOTP,NPLOTV,ISUBRO,IBUGG3,IERROR)
C
C               ***************************************
C               **  STEP 10--                        **
C               **  UPDATE INTERNAL DATAPLOT TABLES  **
C               ***************************************
C
      IH='MUML'
      IH2='    '
      VALUE0=MUML
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='MUML'
      IH2='SE  '
      VALUE0=MUMLSE
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='SDML'
      IH2='    '
      VALUE0=SDML
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='SDML'
      IH2='SE  '
      VALUE0=SDMLSE
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='COVS'
      IH2='E   '
      VALUE0=COVSE
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='CORR'
      IH2='SE  '
      VALUE0=ACORR
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='TRUN'
      IH2='MEAN'
      VALUE0=YMEAN1
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='TRUN'
      IH2='SD  '
      VALUE0=YSD1
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='TRUN'
      IH2='MINI'
      VALUE0=YMIN1
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='PZER'
      IH2='O   '
      VALUE0=PRZERO
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='NUMB'
      IH2='TRUN'
      VALUE0=NZERO
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='NUMB'
      IH2='POSI'
      VALUE0=NPOS
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='THRE'
      IH2='SHOU'
      VALUE0=THRESH
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='UPP9'
      IH2='5CV '
      VALUE0=UPP95
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='LOW0'
      IH2='5CV '
      VALUE0=LOW05
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='CDFT'
      IH2='HRES'
      VALUE0=CDFTHR
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG2.EQ.'ON' .OR. ISUBRO.EQ.'DLPL')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDLPL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IFOUND,IERROR
 9012   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2
 9013   FORMAT('NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2 = ',
     1         I8,I8,I8,2X,A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        IF(NPLOTP.GE.1)THEN
          DO9015I=1,NPLOTP
            WRITE(ICOUT,9016)I,Y(I),X(I),D(I)
 9016       FORMAT('I,Y(I),X(I),D(I) = ',I8,3F12.5)
            CALL DPWRST('XXX','BUG ')
 9015     CONTINUE
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDLP2(Y,X,N,XMATCH,NPAR,
     1                  ICASPL,
     1                  IHLEFT,IHLEF2,IHRIGH,IHRIG2,ALPCV,
     1                  TEMP1,TEMP2,TEMP3,TEMP4,TEMP5,
     1                  QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1                  UPP95,LOW05,CDFTHR,
     1                  MUML,SDML,
     1                  MUMLSE,SDMLSE,COVSE,ACORR,
     1                  NPOS,NZERO,
     1                  YMEAN1,YSD1,YMIN1,THRESH,PRZERO,
     1                  Y2,X2,D2,N2,NPLOTV,ISUBRO,IBUGG3,IERROR)
C
C     PURPOSE--GENERATE A PAIR OF COORDINATE VECTORS
C              THAT WILL DEFINE A DETECTION LIMIT PLOT.
C     REFERENCE--CLIFFORD COHEN (1991), "TRUNCATED AND CENSORED
C                SAMPLES", MARCEL DEKKER INC., CHAPTER 2.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/12
C     ORIGINAL VERSION--DECEMBER  2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGG3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISUBN0
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION XMATCH(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION TEMP4(*)
      DIMENSION TEMP5(*)
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
      DIMENSION Y2(*)
      DIMENSION X2(*)
      DIMENSION D2(*)
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION ALOWLO(NUMALP)
      DIMENSION AUPPLO(NUMALP)
      DIMENSION COV(2,2)
      DIMENSION D(2)
C
      DOUBLE PRECISION DPDF
      DOUBLE PRECISION DPPF
      DOUBLE PRECISION DA
      DOUBLE PRECISION DB
      DOUBLE PRECISION DP
      DOUBLE PRECISION DMU
      DOUBLE PRECISION DSD
      DOUBLE PRECISION DARG1
C
      REAL MUML
      REAL SDML
      REAL MUMLSE
      REAL SDMLSE
      REAL COVSE
      REAL ACORR
      REAL THRESH
      REAL ALPHA
C
      INCLUDE 'DPCOF2.INC'
C
      CHARACTER*80 IFILE1
      CHARACTER*12 ISTAT1
      CHARACTER*12 IFORM1
      CHARACTER*12 IACCE1
      CHARACTER*12 IPROT1
      CHARACTER*12 ICURS1
      CHARACTER*4 IERRF1
      CHARACTER*4 IENDF1
      CHARACTER*4 IREWI1
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
      ISUBN1='DPDL'
      ISUBN2='P2  '
C
      IERROR='NO'
      IWRITE='OFF'
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(N.LE.2)THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
   31   FORMAT('***** ERROR IN DETECTION LIMIT PLOT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,32)
   32   FORMAT('      THE NUMBER OF OBSERVATIONS MUST BE AT LEAST 2.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,33)
   33   FORMAT('      MUST BE AT LEAST 1;')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,34)N
   34   FORMAT('      THE ENTERED NUMBER OF OBSERVATIONS HERE = ',I6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C     CHECK FOR NEGATIVE VALUES IN THE RESPONSE VARIABLE AND
C     DEFINE VALUE OF TEMP1:
C
C       1 - POSITIVE VALUE FOR AN INCLUDED GROUP
C       2 - ZERO VALUE FOR AN INCLUDED GROUP
C       3 - POSITIVE VALUE FOR MEMBER OF EXCLUDED GROUP (USE TO COMPUTE
C           MAXIMUM VALUE FOR THRESHOLD)
C       4 - ZERO VALUE FOR MEMBER OF EXCLUDED GROUP
C
      EPS=0.000001
      DO40I=1,N
        IF(Y(I).LT.0.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,31)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,41)
   41     FORMAT('      A NEGATIVE VALUE WAS ENCOUNTERED IN THE ',
     1           'RESPONSE VARIABLE.')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,999)
          WRITE(ICOUT,43)I,Y(I)
   43     FORMAT('      A NEGATIVE VALUE WAS ENCOUNTERED IN THE ',
     1           'RESPONSE VARIABLE.')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ELSE
          TEMP1(I)=1.0
          AINC=0.0
          IF(ABS(Y(I)).LE.EPS)AINC=1.0
          IFLAG=0
          DO50J=1,NPAR
            IF(X(I).EQ.XMATCH(J))IFLAG=1
   50     CONTINUE
          IF(IFLAG.EQ.0)TEMP1(I)=3.0
          TEMP1(I)=TEMP1(I)+AINC
        ENDIF
   40 CONTINUE
C
      IF(IBUGG3.EQ.'ON' .OR. ISUBRO.EQ.'DLP2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,70)
   70   FORMAT('***** AT THE BEGINNING OF DPDLP2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,71)ICASPL,N,NPAR
   71   FORMAT('ICASPL,N,NPAR = ',A4,2X,2X,2I8)
        CALL DPWRST('XXX','BUG ')
        DO73I=1,N
          WRITE(ICOUT,74)I,Y(I),X(I),TEMP1(I)
   74     FORMAT('I,Y(I),X(I),TEMP1(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
   73   CONTINUE
        DO83I=1,NPAR
          WRITE(ICOUT,84)I,XMATCH(I)
   84     FORMAT('I,XMATCH(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
   83   CONTINUE
      ENDIF
C
C               **********************************************
C               **  STEP 2--                                **
C               **  COMPUTE SUMMARY STATISTICS              **
C               **********************************************
C
C      1 - MEAN OF DATA IN INCLUDED GROUP THAT IS > 0
C      2 - SD OF DATA IN INCLUDED GROUP THAT IS > 0
C      3 - NUMBER OF NON-ZERO VALUES IN INCLUDED GROUP
C      4 - NUMBER OF ZERO VALUES IN INCLUDED GROUP
C      5 - MINIMUM OF NON-ZERO DATA FOR ALL GROUPS
C      6 - ESTIMATED THRESHOLD
C
      NZERO=0
      NPOS=0
      YMIN1=CPUMAX
C
      ICNT=0
      DO1010I=1,N
        IF(TEMP1(I).EQ.1.0)THEN
          NPOS=NPOS+1
          TEMP2(NPOS)=Y(I)
          ICNT=ICNT+1
          TEMP3(ICNT)=Y(I)
          TEMP4(ICNT)=1.0
        ELSEIF(TEMP1(I).EQ.2.0)THEN
          NZERO=NZERO+1
          ICNT=ICNT+1
          TEMP3(ICNT)=Y(I)
          TEMP4(ICNT)=0.0
        ENDIF
        IF(Y(I).GT.0.0 .AND. Y(I).LT.YMIN1)YMIN1=Y(I)
        IF(Y(I).GT.YMIN1 .AND. Y(I).LT.YMIN2)YMIN2=Y(I)
 1010 CONTINUE
      NSAMP=ICNT
C
      YMIN2=CPUMAX
      DO1015I=1,N
        IF(Y(I).GT.YMIN1 .AND. Y(I).LT.YMIN2)YMIN2=Y(I)
 1015 CONTINUE
C
      IF(NPOS.LT.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1021)
 1021   FORMAT('      NO POSITVE VALUES WERE FOUND IN THE ')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1023)
 1023   FORMAT('      INCLUDED GROUP.  NOTHING DONE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      NTOT=NPOS+NZERO
      PRZERO=100.0*REAL(NZERO)/REAL(NTOT)
      CALL MEAN(TEMP2,NPOS,IWRITE,YMEAN1,IBUGG3,IERROR)
      CALL SD(TEMP2,NPOS,IWRITE,YSD1,IBUGG3,IERROR)
      IF(THRESH.EQ.CPUMIN .OR. THRESH.GT.YMIN1)THEN
        THRESH=YMIN1 - (YMIN2-YMIN1)
      ENDIF
C
C               **********************************************
C               **  STEP 3--                                **
C               **  COMPUTE PARAMETER ESTIMATES             **
C               **********************************************
C
      CALL DPDLP3(TEMP3,TEMP4,NSAMP,THRESH,
     1            TEMP5,
     1            MUML,SDML,
     1            MUMLSE,SDMLSE,COVSE,ACORR,
     1            ISUBRO,IBUGG3,IERROR)
C
C               **********************************************
C               **  STEP 4--                                **
C               **  COMPUTE SELECT PERCENTILES              **
C               **********************************************
C
       DP=0.95D0
       DMU=DBLE(MUML)
       DSD=DBLE(SDML)
CCCCC  CALL TNRPPF(DP,DA,DB,DMU,DSD,DPPF)
       CALL NODPPF(DP,DPPF)
       DPPF=DMU + DSD*DPPF
       UPP95=REAL(DPPF)
       DP=0.05D0
       CALL NODPPF(DP,DPPF)
       DPPF=DMU + DSD*DPPF
       LOW05=REAL(DPPF)
       DP=DBLE(THRESH)
       CALL NODPPF(DP,DPPF)
       DPPF=DMU + DSD*DPPF
       CDFTHR=REAL(DPPF)
C
       IF(NPERC.GT.0)THEN
         IOUNI1=IST1NU
         IFILE1=IST1NA
         ISTAT1=IST1ST
         IFORM1=IST1FO
         IACCE1=IST1AC
         IPROT1=IST1PR
         ICURS1=IST1CS
         ISUBN0='DLP2'
         IERRF1='NO'
C
         IREWI1='ON'
         CALL DPOPFI(IOUNI1,IFILE1,ISTAT1,IFORM1,IACCE1,IPROT1,
     1               ICURS1,IREWI1,ISUBN0,IERRF1,
     1               IBUGG3,ISUBRO,IERROR)
         IF(IERRF1.EQ.'YES')GOTO9000
C
         DO1050I=1,NPERC
           DP=DBLE(QP(I)/100.0)
CCCCC      CALL TNRPPF(DP,DA,DB,DMU,DSD,DPPF)
           CALL NODPPF(DP,DPPF)
           DPPF=DMU + DSD*DPPF
           XQPHAT(I)=REAL(DPPF)
           WRITE(IOUNI1,'(2E15.7)')QP(I),XQPHAT(I)
 1050    CONTINUE
C
         IENDF1='OFF'
         IREWI1='ON'
         CALL DPCLFI(IOUNI1,IFILE1,ISTAT1,IFORM1,IACCE1,IPROT1,
     1               ICURS1,IENDF1,IREWI1,ISUBN0,IERRF1,
     1               IBUGG3,ISUBRO,IERROR)
         IF(IERRF1.EQ.'YES')GOTO9000
C
       ENDIF
C
C               **********************************************
C               **  STEP 5--                                **
C               **  GENERATE PLOT OF THE TRUNCATED NORMAL   **
C               **  CURVE BASED ON ESTIMATED PARAMETERS.    **
C               **********************************************
C
      XSTRT=THRESH
      XSTOP=MUML + 3.5*SDML
      DMU=DBLE(MUML)
      DSD=DBLE(SDML)
      ICNT=1
      X2(ICNT)=0.0
      Y2(ICNT)=0.0
      D2(ICNT)=1.0
      ICNT=ICNT+1
      X2(ICNT)=XSTRT
      Y2(ICNT)=0.0
      D2(ICNT)=1.0
      ICNT=ICNT+1
      AUPP=CPUMIN
CCCCC CALL TNRPDF(DBLE(XSTRT),DBLE(THRESH),DBLE(AUPP),DBLE(MUML),
CCCCC1            DBLE(SDML),DPDF)
      DARG1=(DBLE(XSTRT)-DMU)/DSD
      CALL NODPDF(DARG1,DPDF)
      DPDF=DPDF/DSD
      Y2(ICNT)=REAL(DPDF)
      D2(ICNT)=1.0
C
      NP=200
      XINC=(XSTOP-XSTRT)/REAL(NP)
      XVAL=XSTRT
      DO2000I=1,NP
        XVAL=XVAL+XINC
CCCCC   CALL TNRPDF(DBLE(XVAL),DBLE(THRESH),DBLE(AUPP),DBLE(MUML),
CCCCC1            DBLE(SDML),DPDF)
        DARG1=(DBLE(XVAL)-DMU)/DSD
        CALL NODPDF(DARG1,DPDF)
        DPDF=DPDF/DSD
        ICNT=ICNT+1
        X2(ICNT)=XVAL
        Y2(ICNT)=REAL(DPDF)
        D2(ICNT)=1.0
 2000 CONTINUE
C
      ICNT=ICNT+1
      X2(ICNT)=0.0
      Y2(ICNT)=0.0
      D2(ICNT)=2.0
      NP=20
      XINC=XSTRT/REAL(NP)
      XVAL=0.0
      DO2010I=1,NP
        XVAL=XVAL+XINC
CCCCC   CALL TNRPDF(DBLE(XVAL),DBLE(THRESH),DBLE(AUPP),DBLE(MUML),
CCCCC1            DBLE(SDML),DPDF)
        DARG1=(DBLE(XVAL)-DMU)/DSD
        CALL NODPDF(DARG1,DPDF)
        DPDF=DPDF/DSD
        ICNT=ICNT+1
        X2(ICNT)=XVAL
        Y2(ICNT)=REAL(DPDF)
        D2(ICNT)=2.0
 2010 CONTINUE
C
      DO2060I=1,NUMALP
C
        ALP=ALPHA(I)
        P1=ALP/2.0
        P2=1.0-(ALP/2.0)
        CALL NORPPF(P1,APPF1)
        CALL NORPPF(P2,APPF2)
        ALOWLO(I)=0.0
        AUPPLO(I)=0.0
        ALOWSC(I)=0.0
        AUPPSC(I)=0.0
C
        ALOWLO(I)=MUML + APPF1*MUMLSE
        AUPPLO(I)=MUML + APPF2*MUMLSE
        ALOWSC(I)=SDML + APPF1*SDMLSE
        AUPPSC(I)=SDML + APPF2*SDMLSE
 2060 CONTINUE
C
        D(1)=1.0
        ALPHL=ALPCV/2.0
        ALPHU=1.0 - ALPCV/2.0
        CALL NORPPF(ALPHU,ZALPU)
C
        COV(1,1)=MUMLSE**2
        COV(2,2)=SDMLSE**2
        COV(1,2)=COVSE
        COV(2,1)=COV(1,2)
C
        DO2160I=1,NPERC
          QPTEMP=QP(I)/100.0
          CALL NORPPF(QPTEMP,D(2))
          XQPHAT(I)=MUML + SDML*D(2)
          DSUM1=0.0D0
          DO2170II=1,2
            DO2180JJ=1,2
              DSUM1=DSUM1 + D(II)*D(JJ)*COV(II,JJ)
 2180       CONTINUE
 2170     CONTINUE
          XQPSE=SQRT(REAL(DSUM1))
          ATEMP1=XQPHAT(I) - ZALPU*XQPSE
          ATEMP2=XQPHAT(I) + ZALPU*XQPSE
          XQPLCL(I)=MIN(ATEMP1,ATEMP2)
          XQPUCL(I)=MAX(ATEMP1,ATEMP2)
 2160   CONTINUE
C
      N2=ICNT
      NPLOTV=2
C
      IF(IFEEDB.EQ.'ON' .AND. IPRINT.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4001)
 4001   FORMAT(12X,'PROBABILITY OF DETECTION - VERKOUTEREN NORMAL ',
     1          'DATA METHOD')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
C
        WRITE(ICOUT,4011)
 4011   FORMAT('INCLUDED GROUPS:')
        CALL DPWRST('XXX','BUG ')
        DO4012I=1,NPAR
          WRITE(ICOUT,4015)IHRIGH,IHRIG2,XMATCH(I)
 4015     FORMAT(A4,A4,'                                      = ',
     1           G15.7)
          CALL DPWRST('XXX','BUG ')
 4012   CONTINUE
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
C
        WRITE(ICOUT,4021)
 4021   FORMAT('SUMMARY STATISTICS:')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4022)NPOS
 4022   FORMAT('NUMBER OF POSITIVE VALUES IN INCLUDED GROUPS  = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4023)NZERO
 4023   FORMAT('NUMBER OF ZERO     VALUES IN INCLUDED GROUPS  = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4024)YMEAN1
 4024   FORMAT('MEAN OF TRUNCATED DATA                        = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4025)YSD1
 4025   FORMAT('SD OF TRUNCATED DATA                          = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4026)YMIN1
 4026   FORMAT('MINIMUM FOR NON-ZERO DATA                     = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4027)THRESH
 4027   FORMAT('THRESHOLD VALUE                               = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4029)PRZERO
 4029   FORMAT('PERCENTAGE OF ZERO DATA                       = ',G15.7)
        CALL DPWRST('XXX','BUG ')
C
CCCCC   WRITE(ICOUT,999)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,4031)
C4031   FORMAT('MOMENT ESTIMATES (BASED ON THREE MOMENTS):')
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,4032)MUMOME
C4032   FORMAT('ESTIMATE OF MU                                = ',G15.7)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,4034)SDMOME
C4034   FORMAT('ESTIMATE OF SIGMA                             = ',G15.7)
CCCCC   CALL DPWRST('XXX','BUG ')
C
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4041)
 4041   FORMAT('MAXIMUM LIKELIHOOD ESTIMATES:')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4042)MUML
 4042   FORMAT('ESTIMATE OF MU                                = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4044)SDML
 4044   FORMAT('ESTIMATE OF SIGMA                             = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4046)MUMLSE
 4046   FORMAT('STANDARD ERROR OF MU                          = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4048)SDMLSE
 4048   FORMAT('STANDARD ERROR OF SIGMA                       = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4049)COVSE
 4049   FORMAT('COVARIANCE OF MU AND SIGMA                    = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4050)ACORR
 4050   FORMAT('CORRELATION BETWEEN MU AND SIGMA              = ',G15.7)
        CALL DPWRST('XXX','BUG ')
C
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4640)
 4640   FORMAT('CONFIDENCE INTERVAL FOR LOCATION PARAMETER')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4643)
 4643   FORMAT('   CONFIDENCE           LOWER         UPPER')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4645)
 4645   FORMAT('   VALUE (%)            LIMIT         LIMIT')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4646)
 4646   FORMAT('-------------------------------------------')
        CALL DPWRST('XXX','WRIT')
C
        DO4649I=1,NUMALP
          ATEMP=100.0*(1.0 - ALPHA(I))
          WRITE(ICOUT,4647)ATEMP,ALOWLO(I),AUPPLO(I)
 4647     FORMAT('   ',F8.3,9X,G13.6,1X,G13.6)
          CALL DPWRST('XXX','WRIT')
 4649   CONTINUE
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
C
        WRITE(ICOUT,4680)
 4680   FORMAT('CONFIDENCE INTERVAL FOR SCALE PARAMETER')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4643)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4645)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4646)
        CALL DPWRST('XXX','WRIT')
C
        DO4689I=1,NUMALP
          ATEMP=100.0*(1.0 - ALPHA(I))
          WRITE(ICOUT,4647)ATEMP,ALOWSC(I),AUPPSC(I)
          CALL DPWRST('XXX','WRIT')
 4689   CONTINUE
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
C
        IF(NPERC.GT.0)THEN
          WRITE(ICOUT,4911)
 4911     FORMAT('CONFIDENCE LIMITS FOR SELECTED PERCENTILES:')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,4914)
 4914     FORMAT('CENSORED CASE (BASED ON NORMAL APPROXIMATION)')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,4915)ALPCV
 4915     FORMAT('ALPHA = ',F7.4)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,4921)
 4921     FORMAT(15X,'         POINT     ','          LOWER     ',
     1          '         UPPER')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,4922)
 4922     FORMAT('     PERCENTILE','      ESTIMATE    ',
     1           'CONFIDENCE LIMIT ','  CONFIDENCE LIMIT')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,4924)
 4924     FORMAT('---------------','------------------',
     1           '-----------------','------------------')
          CALL DPWRST('XXX','WRIT')
C
          DO4930I=1,NPERC
            WRITE(ICOUT,4932)QP(I),XQPHAT(I),XQPLCL(I),XQPUCL(I)
 4932       FORMAT(F15.3,2X,G15.7,6X,G15.7,4X,G15.7)
            CALL DPWRST('XXX','WRIT')
 4930     CONTINUE
        ENDIF
C
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
      IF(IBUGG3.EQ.'ON' .OR. ISUBRO.EQ.'DLP2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDLP2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)ICASPL,IDATSW,PSTRIN,IERROR,N2
 9012   FORMAT('ICASPL,IDATSW,PSTRIN,IERROR,N2 = ',
     1         A4,2X,A4,2X,G15.7,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,N2
          WRITE(ICOUT,9016)I,Y2(I),X2(I),D2(I)
 9016     FORMAT('I,Y2(I),X2(I),D2(I) = ',I8,2E15.7,F9.2)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDLP3(Y,X,N,T,
     1                  TEMP1,
     1                  MUML,SDML,
     1                  MUMLSE,SDMLSE,COVSE,ACORR,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE ESTIMATES THE PARAMETERS FOR THE
C              "DETECTION LIMIT PLOT" COMMAND.  NOTE THAT THIS
C              IS ACTUALLY A SINGLY LEFT CENSORED PROBLEM (THE
C              DISTINCTION BETWEEN CENSORING AND TRUNCATION IS
C              THAT FOR THE CENSORED CASE WE KNOW HOW MANY
C              MEASUREMENTS ARE RESTRICTED WHILE FOR THE TRUNCATED
C              CASE WE DO NOT).
C
C              THE MAXIMUM LIKELIHOOD ESTIMATES ARE:
C
C                  SIGMAHAT = SQRT{S**2 + lambda(h,alphahat)*(XBAR - T)**2}
C                  MUHAT    = XBAR - lambda(h,alphahat)*(XBAR - T)
C
C              WHERE
C
C                   alphahat = S**2/(XBAR - T)**2
C                   h        = c/N
C                   N        = TOTAL NUMBER OF OBSERVATIONS
C                   n        = NUMBER OF NON-TRUNCATED OBSERVATIONS
C                   c        = NUMBER OF TRUNCATED OBSERVATIONS
C
C               XBAR AND S ARE THE MEAN AND SD OF THE NON-TRUNCATED
C               OBSERVATIONS.
C
C               LAMBDA(H,ALPHAHAT) IS A TABULATED VALUE IN THE
C               COHEN REFERENCE.  HOWEVER, WE DETERMINE IT BY
C               SOLVING THE FUNCTION
C
C                  ((1 - OMEGA(h,XI)*(OMEGA(h,XI) - XI))/
C                  (OMEGA(h,XI) - XI)**2) - S**2/(MU - T)**2
C
C               FOR XI WHERE
C
C                  OMEGA(h,XI) = (h/(1-h))*NORPDF(XI)/NORCDF(XI)
C
C               NOTE THAT XI IS THE STANDARDIZED TRUNCATION
C               POINT.  ONCE WE SOLVE FOR XI, WE PLUG IT INTO
C               THE FUNCTION
C
C                   LAMBDA = OMEGA(h,XI)/(OMEGA(h,XI) - XI)
C
C               NOTE THAT THERE MAY BE TWO SOLUTIONS TO THIS
C               EQUATION.  WE PICK THE ONE THAT RESULTS IN A
C               POSITIVE LAMBDA.
C
C     REFERENCE--CLIFFORD COHEN (1991), "TRUNCATED AND CENSORED
C                SAMPLES", MARCEL DEKKER INC., CHAPTER 2.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/12
C     ORIGINAL VERSION--DECEMBER  2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
C
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DMEAN
      DOUBLE PRECISION DVARI
      DOUBLE PRECISION DT
      DOUBLE PRECISION DNTOT
      DOUBLE PRECISION DNFULL
      DOUBLE PRECISION DC
      DOUBLE PRECISION DPDF
      DOUBLE PRECISION DCDF
      DOUBLE PRECISION DPDF2
      DOUBLE PRECISION DCDF2
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DNUM1
      DOUBLE PRECISION DNUM2
      DOUBLE PRECISION DDENOM
      DOUBLE PRECISION DDENO2
      DOUBLE PRECISION DALPHA
      DOUBLE PRECISION DOMEGA
      DOUBLE PRECISION DLAMB
      DOUBLE PRECISION DQ
      DOUBLE PRECISION DQ2
      DOUBLE PRECISION DPHI11
      DOUBLE PRECISION DPHI12
      DOUBLE PRECISION DPHI22
      DOUBLE PRECISION DU11
      DOUBLE PRECISION DU12
      DOUBLE PRECISION DU22
C
      REAL MUMOME
      REAL SDMOME
      REAL MUML
      REAL SDML
      REAL MUMLSE
      REAL SDMLSE
C
      DOUBLE PRECISION AE
      DOUBLE PRECISION RE
      DOUBLE PRECISION XLOW
      DOUBLE PRECISION XUP
      DOUBLE PRECISION XMID
      DOUBLE PRECISION XI
C
      DOUBLE PRECISION TNRFUN
      EXTERNAL TNRFUN
C
      DOUBLE PRECISION DC1
      DOUBLE PRECISION DH
      COMMON/TNRCOM/DC1,DH
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPTN'
      ISUBN2='S1  '
C
      IERROR='NO'
      IWRITE='OFF'
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(N.LE.2)THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
   31   FORMAT('***** ERROR IN NORMAL SINGLY LEFT CENSORED ',
     1         'PARAMETER ESTIMATION--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,32)
   32   FORMAT('      THE NUMBER OF OBSERVATIONS MUST BE AT LEAST 2.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,34)N
   34   FORMAT('      THE ENTERED NUMBER OF OBSERVATIONS HERE = ',I6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DLP3')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,70)
   70   FORMAT('***** AT THE BEGINNING OF DPDLP3--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,71)N
   71   FORMAT('N = ',I8)
        CALL DPWRST('XXX','BUG ')
        DO73I=1,N
          WRITE(ICOUT,74)I,Y(I),X(I)
   74     FORMAT('I,Y(I),X(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
   73   CONTINUE
      ENDIF
C
C               **********************************************
C               **  STEP 2--                                **
C               **  COMPUTE SUMMARY STATISTICS              **
C               **********************************************
C
      MUML=0.0
      SDML=0.0
C
      NC=0
      NFULL=0
      YMIN=CPUMAX
      DSUM1=0.0D0
C
      DO1010I=1,N
        IF(X(I).GT.0.0)THEN
          NFULL=NFULL+1
          TEMP1(NFULL)=Y(I)
          DSUM1=DSUM1 + DBLE(Y(I))
          IF(Y(I).LT.YMIN)YMIN=Y(I)
        ELSE
          NC=NC+1
        ENDIF
 1010 CONTINUE
      DNFULL=DBLE(NFULL)
      DNC=DBLE(NC)
      DNTOT=DBLE(N)
      DMEAN=DSUM1/DNFULL
      IF(T.GT.CPUMIN .AND. T.LE.YMIN)THEN
        DT=DBLE(T)
      ELSE
        DT=DBLE(YMIN)
      ENDIF
C
      IF(NFULL.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1012)
 1012   FORMAT('      THE NUMBER OF UNCENSORED OBSERVATIONS MUST BE ',
     1         'AT LEAST 2.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1014)NFULL
 1014   FORMAT('      THE NUMBER OF UNCENSORED OBSERVATIONS HERE = ',
     1         I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      DVARI=0.0D0
      DO1020I=1,NFULL
        DVARI=DVARI + (DBLE(TEMP1(I)) - DMEAN)**2/DNFULL
 1020 CONTINUE
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DLP3')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1031)
 1031   FORMAT('***** DPDLP3: AFTER COMPUTE SUMMARY STATISTICS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1032)N,NFULL,NC
 1032   FORMAT('N,NFULL,NC = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1033)DMEAN,DVARI,DT
 1033   FORMAT('DMEAN,DVARI,DT = ',3G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               **********************************************
C               **  STEP 3--                                **
C               **  COMPUTE MAXIMUM LIKELIHOOD ESTIMATES    **
C               **********************************************
C
C     DEFINE SOME CONSTANTS FOR THE FUNCTION SOLVER
C
      DH=DNC/DNTOT
      DC1=DVARI/(DMEAN - DT)**2
C
C     USE DFZERO TO SOLVE THE LAMBDAHAT FUNCTION
C
      AE=1.D-7
      RE=1.D-7
      XLOW=-10.0D0
      XUP=10.0D0
      IF(DMEAN.GT.DT)THEN
        XMID=-1.0D0
      ELSE
        XMID=1.0D0
      ENDIF
      ITER=0
C
 1410 CONTINUE
      CALL DFZERO(TNRFUN,XLOW,XUP,XMID,RE,AE,IFLAG)
      XI=XLOW
C
C     NOW EVALUATE - CHECK FOR POSITIVE RESULT
C
      CALL NODPDF(XI,DPDF)
      CALL NODCDF(XI,DCDF)
      CALL NODPDF(-XI,DPDF2)
      CALL NODCDF(-XI,DCDF2)
      DOMEGA=(DH/(1.0D0-DH))*DPDF/DCDF
      DLAMB=DOMEGA/(DOMEGA - XI)
      IF(DLAMB.LT.0.0D0)THEN
        IF(ITER.EQ.0)THEN
          ITER=1
          XLOW=-10.0D0
          XUP=XI-0.1D0
          XMID=(XLOW+XUP)/2.0D0
          GOTO1410
        ELSEIF(ITER.EQ.1)THEN
          ITER=2
          XLOW=XI+0.1D0
          XUP=10.0D0
          XMID=(XLOW+XUP)/2.0D0
          GOTO1410
        ELSE
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,31)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1413)
 1413     FORMAT('      UNABLE TO DETERMINE MAXIMUM LIKELIHOOD ',
     1           'ESTIMATES.')
          CALL DPWRST('XXX','BUG ')
          GOTO1499
        ENDIF
      ENDIF
C
      SDML=REAL(DSQRT(DVARI + DLAMB*(DMEAN - DT)**2))
      MUML=REAL(DMEAN - DLAMB*(DMEAN - DT))
C
C     NOW COMPUTE STANDARD ERRORS
C
      IF(DCDF.GE.1.0D0 .OR. DCDF2.GE.1.0D0)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1431)
 1431   FORMAT('***** WARNING IN NORMAL SINGLY LEFT CENSORED ',
     1         'PARAMETER ESTIMATION--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1433)
 1433   FORMAT('      UNABLE TO COMPUTE STANDARD ERRORS OF THE ',
     1         'MAXIMUM LIKELIHOOD ESTIMATES.')
        CALL DPWRST('XXX','BUG ')
        GOTO1499
      ENDIF
C
      DQ=DPDF/(1.0D0 - DCDF)
      DQ2=DPDF2/(1.0D0 - DCDF2)
      DPHI11=1.0D0 + DQ*(DQ2 + XI)
      DPHI12=DQ*(1.0D0 + XI*(DQ2 + XI))
      DPHI22=2.0D0 + XI*DPHI12
      DDENOM=DPHI11*DPHI22 - DPHI12**2
      DTERM1=1.0D0/(1.0D0 - DCDF)
      DU11=DTERM1*DPHI22/DDENOM
      DU22=DTERM1*DPHI11/DDENOM
      DU12=-DTERM1*DPHI12/DDENOM
      DTERM2=DBLE(SDML)**2/DNTOT
      MUMLSE=REAL(DSQRT(DTERM2*DU11))
      SDMLSE=REAL(DSQRT(DTERM2*DU22))
      COVSE=REAL(DTERM2*DU12)
      ACORR=REAL(DU12/DSQRT(DU11*DU22))
C
 1499 CONTINUE
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DLP3')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1111)
 1111   FORMAT('***** DPDLP3: AFTER COMPUTE ML ESTIMATES')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1112)DH,XI,DPDF,DCDF,DPDF2,DCDF2
 1112   FORMAT('DH,XI,DPDF,DCDF,DPDF2,DCDF2 = ',6G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1113)DTERM1,DTERM2,DOMEGA,DLAMB
 1113   FORMAT('DTERM1,DTERM2,DOMEGA,DLAMB = ',4G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1114)MUML,SDML
 1114   FORMAT('MUML,SDML = ',2G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1115)DQ,DQ2,DPHI11,DPHI12,DPHI22
 1115   FORMAT('DQ,DQ2,DPHI11,DPHI12,DPHI22 = ',4G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1116)DDENOM,DU11,DU22,DU12
 1116   FORMAT('DDENOM,DU11,DU22,DU12 = ',4G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DLP3')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDLP3--')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDOT(IFOUND,IERROR)
C
C     PURPOSE--THIS IS A SUBROUTINE FOR THE
C              . COMMAND (A NULL COMMAND).
C              THIS CAPABILITY IS USEFUL FOR PROVIDING A VISUAL
C              SEPARATOR BETWEEN SECTIONS OF STORED DATAPLOT
C              CODE ON MASS STORAGE, OR FOR    COMMENTING OUT
C              A GIVEN LINE OF DATAPLOT CODE.
C     INPUT  ARGUMENTS--NONE
C     OUTPUT ARGUMENTS--IFOUND ('YES' OR 'NO')
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--NOVEMBER  1978.
C     UPDATED         --MARCH     1982.
C     UPDATED         --MAY       1982.
C                     --NOVEMBER  1980.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      IFOUND='YES'
      GOTO1199
C
 1199 CONTINUE
      RETURN
      END
      SUBROUTINE DPDOUB(IHARG,NUMARG,IDEFPR,IHMXPR,
     1IPREC,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE PREICSION SWITCH
C              AS DOUBLE PRECISION.
C              THIS IN TURN SPECIFIES THAT SUBSEQUENT
C              CALCULATIONS WILL ALL BE CARRIED OUT
C              IN DOUBLE PRECISION.
C              THE SPECIFIED PRECISION SWITCH SPECIFICATION
C              WILL BE PLACED IN THE HOLLERITH VARIABLE IPREC.
C     INPUT  ARGUMENTS--IHARG  (A  HOLLERITH VECTOR)
C                     --NUMARG (AN INTEGER VARIABLE)
C                     --IDEFPR (A  HOLLERITH VARIABLE)
C                     --IHMXPR (A  HOLLERITH VARIABLE)
C     OUTPUT ARGUMENTS--IPREC  (A HOLLERITH VARIABLE)
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--NOVEMBER  1980.
C     UPDATED         --SEPTEMBER 1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IDEFPR
      CHARACTER*4 IHMXPR
      CHARACTER*4 IPREC
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHOLD
C
C---------------------------------------------------------------------
C
      DIMENSION IHARG(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      IFOUND='YES'
C
 1110 CONTINUE
      IF(NUMARG.LE.0)GOTO1120
      IF(IHARG(NUMARG).EQ.'ON')GOTO1130
      IF(IHARG(NUMARG).EQ.'OFF')GOTO1120
      IF(IHARG(NUMARG).EQ.'AUTO')GOTO1130
      IF(IHARG(NUMARG).EQ.'DEFA')GOTO1120
      GOTO1130
C
 1120 CONTINUE
      IHOLD=IDEFPR
      GOTO1160
C
 1130 CONTINUE
      IHOLD='DOUB'
      GOTO1160
C
 1160 CONTINUE
      IF(IHOLD.EQ.'DOUB'.AND.IHMXPR.EQ.'SING')GOTO1170
      IF(IHOLD.EQ.'TRIP'.AND.IHMXPR.EQ.'SING')GOTO1170
      IF(IHOLD.EQ.'TRIP'.AND.IHMXPR.EQ.'DOUB')GOTO1170
      IF(IHOLD.EQ.'QUAD'.AND.IHMXPR.EQ.'SING')GOTO1170
      IF(IHOLD.EQ.'QUAD'.AND.IHMXPR.EQ.'DOUB')GOTO1170
      IF(IHOLD.EQ.'QUAD'.AND.IHMXPR.EQ.'TRIP')GOTO1170
      GOTO1180
C
 1170 CONTINUE
      IERROR='YES'
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1172)
 1172 FORMAT('***** ERROR IN DPDOUB--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1173)
 1173 FORMAT('      THE DESIRED PRECISION IS HIGHER')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1174)
 1174 FORMAT('      THAN PERMITTED ON THIS COMPUTER.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1175)IHOLD
 1175 FORMAT('      DESIRED PRECISION           = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1176)IHMXPR
 1176 FORMAT('      MAXIMUM ALLOWABLE PRECISION = ',A4)
      CALL DPWRST('XXX','BUG ')
      GOTO1199
C
 1180 CONTINUE
      IPREC=IHOLD
C
      IF(IFEEDB.EQ.'OFF')GOTO1189
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1188)IPREC
 1188 FORMAT('THE PRECISION SWITCH HAS JUST BEEN SET TO ',
     1A4)
      CALL DPWRST('XXX','BUG ')
 1189 CONTINUE
      GOTO1199
C
 1199 CONTINUE
      RETURN
      END
      SUBROUTINE DPDPCL(P1,N1,P2,N2,ALPHA,IWRITE,PDIFF,ALOWLM,AUPPLM,
     1                  IBUGA3,IERROR)
C
C     PURPOSE--FOR A GIVEN P1, N1, P2, N2, AND ALPHA, COMPUTE THE
C              DIFFERENCE OF PROPORTIONS LOWER AND UPPER CONFIDENCE
C              LIMITS.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/8
C     ORIGINAL VERSION--AUGUST    2008.
C     UPDATED         --OCTOBER   2009. USE "BAYESIAN" CORRECTION
C                                       (THIS PRODUCES MEANINGFUL
C                                       INTERVALS FOR "0" AND "1"
C                                       PROBABILITIES)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      REAL P1
      REAL P2
      REAL ALPHA
      REAL ALOWLM
      REAL AUPPLM
      INTEGER N1
      INTEGER N2
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDP'
      ISUBN2='CL  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPDPCL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)P1,N1,P2,N2,ALPHA
   53   FORMAT('P1,N1,P2,N2,ALPHA = ',2(G15.7,I8),G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ********************************
C               **  STEP 1--                  **
C               **  CHECK FOR INPUT ERRORS    **
C               ********************************
C
      ALOWLM=0.0
      AUPPLM=1.0
C
      IF(N1.LT.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,111)
  111   FORMAT('****** ERROR IN DIFFERENCE OF PROPORTION ',
     1         'CONFIDENCE LIMITS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,113)
  113   FORMAT('         THE NUMBER OF OBSERVATIONS FOR THE FIRST ',
     1         'RESPONSE VARIABLE IS LESS THAN 2.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,114)N1
  114   FORMAT('SAMPLE SIZE = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(N2.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,111)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,123)
  123   FORMAT('         THE NUMBER OF OBSERVATIONS FOR THE ',
     1         'SECOND RESPONSE VARIABLE IS LESS THAN 2.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,124)N2
  124   FORMAT('SAMPLE SIZE = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(P1.LT.0.0 .OR. P1.GT.1.0)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,162)
  162   FORMAT('      THE BINOMIAL PROBABILITY OF SUCCESS PARAMETER ',
     1         'FOR THE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,164)
  164   FORMAT('      FIRST RESPONSE VARIABLE IS OUTSIDE THE ',
     1         '(0,1) INTERVAL.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,167)P1
  167   FORMAT('      THE PROBABILITY OF SUCCESS PARAMETER = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      IF(P2.LT.0.0 .OR. P2.GT.1.0)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,162)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,174)
  174   FORMAT('      SECOND RESPONSE VARIABLE IS OUTSIDE THE ',
     1         '(0,1) INTERVAL.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,167)P2
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      ALPHSV=ALPHA
      IF(ALPHA.GT.1.0 .AND. ALPHA.LE.100.0)ALPHA=ALPHA/100.0
      IF(ALPHA.LE.0.0 .OR. ALPHA.GE.1.0)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,182)
  182   FORMAT('      THE VALUE OF ALPHA IS OUTSIDE THE (0,1) ',
     1         'INTERVAL.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,187)ALPHA
  187   FORMAT('      THE VALUE OF ALPHA = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
C     NOTE: IF VALUE OF ALPHA IS < 0.5, THEN ASSUME 1 - ALPHA
C           (I.E., 0.05 SHOULD BE 0.95).
C
      IF(ALPHA.LT.0.5)ALPHA=1.0 - ALPHA
C
C               ********************************************
C               **  STEP 2--                              **
C               **  COMPUTE THE DIFFERENCE OF PROPORTIONS **
C               **  CONFIDENCE INTERVAL.                  **
C               ********************************************
C
C       NOTE: USE   PHAT = (V+0.5)/(N+1) WHERE V IS THE 
C             NUMBER OF SUCCESSES.  THIS IS THE BAYES ESTIMATOR
C             OF P CORRESPONDING TO THE NON-INFORMATIVE
C             (REFERENCE) JEFFREY'S PRIOR DISTRIBUTION.  THIS IS
C             DONE TO BETTER HANDLE THE CASES WHERE P1 OR P2 ARE
C             ZERO OR ONE (WHICH RESULTS IN A STANDARD ERROR OF
C             ZERO).
C
        AN1=REAL(N1)
        AN2=REAL(N2)
        IX1=INT(AN1*P1 + 0.01)
        IX2=INT(AN2*P2 + 0.01)
        AX1=REAL(IX1) + 0.5
        AX2=REAL(IX2) + 0.5
        P1NEW=AX1/REAL(N1+1)
        P2NEW=AX2/REAL(N2+1)
        PDIFF=P1NEW-P2NEW
        PSE=SQRT(P1NEW*(1.0-P1NEW)/REAL(N1)+P2NEW*(1.0-P2NEW)/REAL(N2))
        PCONF=1.0 - ALPHA
        PCONF=PCONF/2.0
        CDF=1.0-PCONF
        CALL NORPPF(CDF,TI)
        AUPPLM=PDIFF+PSE*TI
CCCCC   IF(AUPPLM.GT.1.0)AUPPLM=1.0
        ALOWLM=PDIFF-PSE*TI
CCCCC   IF(ALOWLM.LT.0.0)ALOWLM=0.0
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDPCL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGA3,IERROR
 9012   FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)PDIFF,PSE,PCONF,TI
 9013   FORMAT('PDIFF,PSE,PCONF,TI = ',4(G15.7,2X))
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9014)ALOWLM,AUPPLM
 9014   FORMAT('ALOWLM,AUPPLM = ',G15.7,2X,G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)P1NEW,P2NEW
 9015   FORMAT('P1NEW,P2NEW = ',2(G15.7,2X))
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)IX1,IX2,AX1,AX2
 9016   FORMAT('IX1,IX2,AX1,AX2 = ',2I8,2(G15.7,2X))
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDRA2(X1,Y1,X2,Y2,
     1IFIG,
     1ILINPA,ILINCO,PLINTH,
     1AREGBA,
     1IREBLI,IREBCO,PREBTH,
     1IREFSW,IREFCO,
     1IREPTY,IREPLI,IREPCO,PREPTH,PREPSP,
     1PTEXHE,PTEXWI,PTEXVG,PTEXHG)
C
C     PURPOSE--DRAW A LINE
C              WITH ONE END OF THE LINE AT (X1,Y1)
C              AND THE OTHER END AT (X2,Y2).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--APRIL     1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --JANUARY   1989.  MODIFY CALLS TO DPDRPL (ALAN)
C     UPDATED         --JANUARY   1989.  MODIFY CALL  TO DPFIRE (ALAN)
C
C-----NON-COMMON VARIABLES-------------------------------------
C
      CHARACTER*4 IFIG
      CHARACTER*4 IPATT2
C
      CHARACTER*4 ILINPA
      CHARACTER*4 ILINCO
C
      CHARACTER*4 IREBLI
      CHARACTER*4 IREBCO
      CHARACTER*4 IREFSW
      CHARACTER*4 IREFCO
      CHARACTER*4 IREPTY
      CHARACTER*4 IREPLI
      CHARACTER*4 IREPCO
C
      CHARACTER*4 IPATT
      CHARACTER*4 ICOLF
      CHARACTER*4 ICOLP
      CHARACTER*4 ICOL
      CHARACTER*4 IFLAG
C
      DIMENSION PX(10)
      DIMENSION PY(10)
CCCCC DIMENSION PX3(10)
CCCCC DIMENSION PY3(10)
C
      DIMENSION ILINPA(*)
      DIMENSION ILINCO(*)
      DIMENSION PLINTH(*)
C
      DIMENSION AREGBA(*)
      DIMENSION IREBLI(*)
      DIMENSION IREBCO(*)
      DIMENSION PREBTH(*)
      DIMENSION IREFSW(*)
      DIMENSION IREFCO(*)
      DIMENSION IREPTY(*)
      DIMENSION IREPLI(*)
      DIMENSION IREPCO(*)
      DIMENSION PREPTH(*)
      DIMENSION PREPSP(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRA2')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPDRA2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)X1,Y1
   53 FORMAT('X1,Y1 = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)X2,Y2
   54 FORMAT('X2,Y2 = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,59)IFIG
   59 FORMAT('IFIG = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)ILINPA(1),ILINCO(1),PLINTH(1)
   61 FORMAT('ILINPA(1),ILINCO(1),PLINTH(1) = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)AREGBA(1)
   62 FORMAT('AREGBA(1) = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,63)IREBLI(1),IREBCO(1),PREBTH(1)
   63 FORMAT('IREBLI(1),IREBCO(1),PREBTH(1) = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,64)IREFSW(1),IREFCO(1)
   64 FORMAT('IREFSW(1),IREFCO(1) = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,65)IREPTY(1),IREPLI(1),IREPCO(1),PREPTH(1),PREPSP(1)
   65 FORMAT('IREPTY(1),IREPLI(1),IREPCO(1),PREPTH(1),PREPSP(1) = ',
     1A4,2X,A4,2X,A4,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,69)PTEXHE,PTEXWI
   69 FORMAT('PTEXHE,PTEXWI= ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,70)PTEXVG,PTEXHG
   70 FORMAT('PTEXVG,PTEXHG= ',2E15.6)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,79)IBUGG4,ISUBG4,IERRG4
   79 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               *********************************
C               **  STEP 1--                   **
C               **  DETERMINE THE COORDINATES  **
C               **  FOR THE LINE               **
C               *********************************
C
      PX(1)=X1
      PY(1)=Y1
C
      PX(2)=X2
      PY(2)=Y2
C
      NP=2
C
C
C               ***********************
C               **  STEP 2--         **
C               **  FILL THE FIGURE  **
C               **  (IF CALLED FOR)  **
C               ***********************
C
      IF(IREFSW(1).EQ.'OFF')GOTO2190
      IPATT=IREPTY(1)
      IPATT2='SOLI'
      PTHICK=PREPTH(1)
      PXGAP=PREPSP(1)
      PYGAP=PREPSP(1)
      ICOLF=IREFCO(1)
      ICOLP=IREPCO(1)
      CALL DPFIRE(PX,PY,NP,
     1IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP,IPATT2)
 2190 CONTINUE
C
C               ***************************
C               **  STEP 3--             **
C               **  DRAW OUT THE FIGURE  **
C               ***************************
C
      IPATT=ILINPA(1)
      PTHICK=PLINTH(1)
      ICOL=ILINCO(1)
      IFLAG='ON'
CCCCC CALL DPDRPL(PX,PY,NP,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRA2')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPDRA2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)NP
 9013 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9015I=1,NP
      WRITE(ICOUT,9016)I,PX(I),PY(I)
 9016 FORMAT('I,PX(I),PY(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
 9015 CONTINUE
      WRITE(ICOUT,9039)IBUGG4,ISUBG4,IERRG4
 9039 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPDRAW(IHARG,IARGT,ARG,NUMARG,
     1PXSTAR,PYSTAR,
     1PXEND,PYEND,
     1ILINPA,ILINCO,PLINTH,
     1AREGBA,
     1IREBLI,IREBCO,PREBTH,
     1IREFSW,IREFCO,
     1IREPTY,IREPLI,IREPCO,PREPTH,PREPSP,
     1PTEXHE,PTEXWI,PTEXVG,PTEXHG,
     1IGRASW,IDIASW,
     1PGRAXF,PGRAYF,PDIAXC,PDIAYC,PDIAX2,PDIAY2,
     1PDIAHE,PDIAWI,PDIAVG,PDIAHG,
     1NUMDEV,
     1IDMANU,IDMODE,IDMOD2,IDMOD3,
     1IDPOWE,IDCONT,IDCOLO,IDNVPP,IDNHPP,IDUNIT,
     1IDNVOF,IDNHOF,
CCCCC ADD FOLLOWING LINE MARCH 1997.
     1IDFONT,
CCCCC THE FOLLOWING LINE WAS ADDED SEPTEMBER 1994
CCCCC AND THEN CHANGED             FEBRUARY  1995
CCCCC1UNITSW,
     1X1UNIT,Y1UNIT,X2UNIT,Y2UNIT,
     1IBUGD2,IFOUND,IERROR)
C
C     PURPOSE--DRAW ONE OR MORE LINES
C              (DEPENDING ON HOW MANY NUMBERS ARE PROVIDED).
C              THE COORDINATES ARE IN STANDARDIZED UNITS
C              OF 0 TO 100.
C     NOTE--THE INPUT COORDINATES DEFINE THE ENDS
C           OF THE LINE SEGMENTS.
C     NOTE-THE USUAL INPUT NUMBER OF COORDINATES IS 2
C          AND THEREFORE THE USUAL INPUT NUMBER OF NUMBERS IS 2*2 = 4.
C     NOTE--IF 2 NUMBERS ARE PROVIDED,
C           THEN THE DRAWN LINE WILL GO
C           FROM THE LAST CURSOR POSITION
C           TO THE (X,Y) POINT
C           (EITHER ABSOLUTE OR RELATIVE)
C           AS DEFINED BY THE 2 NUMBERS.
C     NOTE--IF 4 NUMBERS ARE PROVIDED,
C           THEN THE DRAWN LINE WILL GO
C           FROM THE ABSOLUTE (X,Y) POSITION
C           AS DEFINED BY THE FIRST 2 NUMBERS
C           TO THE (X,Y) POINT
C           (EITHER ABSOLUTE OR RELATIVE)
C           AS DEFINED BY THE THIRD AND FOURTH NUMBERS.
C     NOTE--IF 6 NUMBERS ARE PROVIDED,
C           THEN THE DRAWN LINE WILL GO
C           FROM THE (X,Y) POSITION
C           AS RESULTING FROM THE THIRD AND FOURTH NUMBERS
C           TO THE (X,Y) POINT
C           (EITHER ABSOLUTE OR RELATIVE)
C           AS DEFINED BY THE FIFTH AND SIXTH NUMBERS.
C     NOTE--AND SO FORTH FOR 8, 10, 12, ... NUMBERS.
C     INPUT  ARGUMENTS--IHARG
C                     --IARGT
C                     --ARG
C                     --NUMARG
C                     --PXSTAR
C                     --PYSTAR
C     OUTPUT ARGUMENTS--PXEND
C                     --PYEND
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--APRIL     1981.
C     UPDATED         --MARCH     1982.
C     UPDATED         --MAY       1982.
C     UPDATED         --NOVEMBER  1982.
C     UPDATED         --JANUARY   1989.  CALL LIST FOR OFFSET VAR (ALAN)
C     UPDATED         --SEPTEMBER 1994.  UNITS SWITCH (DATA OR SCREEN)
C     UPDATED         --FEBRUARY  1995.  GENERALIZED DRAW.... COMMAND
C     UPDATED         --MARCH     1997.  SUPPORT FOR DEVICE FONT (ALAN)
C
C-----NON-COMMON VARIABLES-----------------------------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IARGT
C
      CHARACTER*4 ILINPA
      CHARACTER*4 ILINCO
C
      CHARACTER*4 IREBLI
      CHARACTER*4 IREBCO
      CHARACTER*4 IREFSW
      CHARACTER*4 IREFCO
      CHARACTER*4 IREPTY
      CHARACTER*4 IREPLI
      CHARACTER*4 IREPCO
C
      CHARACTER*4 IGRASW
      CHARACTER*4 IDIASW
C
      CHARACTER*4 IDMANU
      CHARACTER*4 IDMODE
      CHARACTER*4 IDMOD2
      CHARACTER*4 IDMOD3
      CHARACTER*4 IDPOWE
      CHARACTER*4 IDCONT
      CHARACTER*4 IDCOLO
CCCCC ADD FOLLOWING LINE MARCH 1997.
      CHARACTER*4 IDFONT
C
      CHARACTER*4 IFOUND
      CHARACTER*4 IBUGD2
      CHARACTER*4 IERROR
C
      CHARACTER*4 IFIG
      CHARACTER*4 IBELSW
      CHARACTER*4 IERASW
      CHARACTER*4 IBACCO
      CHARACTER*4 ICOPSW
      CHARACTER*4 ITYPEO
      CHARACTER*4 ISUBRO
C
CCCCC THE FOLLOWING LINE WAS ADDED SEPTEMBER 1994
CCCCC AND THEN CHANGED             FEBRUARY  1995
CCCCC CHARACTER*4 UNITSW
      CHARACTER*4 X1UNIT
      CHARACTER*4 Y1UNIT
      CHARACTER*4 X2UNIT
      CHARACTER*4 Y2UNIT
C
C
      DIMENSION IHARG(*)
      DIMENSION IARGT(*)
      DIMENSION ARG(*)
C
      DIMENSION ILINPA(*)
      DIMENSION ILINCO(*)
      DIMENSION PLINTH(*)
C
      DIMENSION AREGBA(*)
      DIMENSION IREBLI(*)
      DIMENSION IREBCO(*)
      DIMENSION PREBTH(*)
      DIMENSION IREFSW(*)
      DIMENSION IREFCO(*)
      DIMENSION IREPTY(*)
      DIMENSION IREPLI(*)
      DIMENSION IREPCO(*)
      DIMENSION PREPTH(*)
      DIMENSION PREPSP(*)
C
      DIMENSION IDMANU(*)
      DIMENSION IDMODE(*)
      DIMENSION IDMOD2(*)
      DIMENSION IDMOD3(*)
      DIMENSION IDPOWE(*)
      DIMENSION IDCONT(*)
      DIMENSION IDCOLO(*)
CCCCC ADD FOLLOWING LINE MARCH 1997.
      DIMENSION IDFONT(*)
      DIMENSION IDNVPP(*)
      DIMENSION IDNHPP(*)
      DIMENSION IDUNIT(*)
C
      DIMENSION IDNVOF(*)
      DIMENSION IDNHOF(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
      IERRG4=IERROR
CCCCC IBUGG4=IBUGD2
CCCCC ISUBG4=ISUBRO
C
      ILOCFN=0
      NUMNUM=0
C
      X1=0.0
      Y1=0.0
      X2=0.0
      Y2=0.0
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRAW')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPDRAW--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)NUMARG
   53 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,NUMARG
      WRITE(ICOUT,56)I,IHARG(I),IARGT(I),ARG(I)
   56 FORMAT('I,IHARG(I),IARGT(I),ARG(I) = ',I8,2X,A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
      WRITE(ICOUT,57)PXSTAR,PYSTAR
   57 FORMAT('PXSTAR,PYSTAR = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,58)PXEND,PYEND
   58 FORMAT('PXEND,PYEND = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)ILINPA(1),ILINCO(1),PLINTH(1)
   61 FORMAT('ILINPA(1),ILINCO(1),PLINTH(1) = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)AREGBA(1)
   62 FORMAT('AREGBA(1) = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,63)IREBLI(1),IREBCO(1),PREBTH(1)
   63 FORMAT('IREBLI(1),IREBCO(1),PREBTH(1) = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,64)IREFSW(1),IREFCO(1)
   64 FORMAT('IREFSW(1),IREFCO(1) = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,65)IREPTY(1),IREPLI(1),IREPCO(1),PREPTH(1),PREPSP(1)
   65 FORMAT('IREPTY(1),IREPLI(1),IREPCO(1),PREPTH(1),PREPSP(1) = ',
     1A4,2X,A4,2X,A4,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,69)PTEXHE,PTEXWI
   69 FORMAT('PTEXHE,PTEXWI= ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,70)PTEXVG,PTEXHG
   70 FORMAT('PTEXVG,PTEXHG= ',2E15.6)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,76)IGRASW,IDIASW
   76 FORMAT('IGRASW,IDIASW = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,77)PGRAXF,PGRAYF,PDIAXC,PDIAYC
   77 FORMAT('PGRAXF,PGRAYF,PDIAXC,PDIAYC = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,78)PDIAHE,PDIAWI,PDIAVG,PDIAHG
   78 FORMAT('PDIAHE,PDIAWI,PDIAVG,PDIAHG = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,80)NUMDEV
   80 FORMAT('NUMDEV= ',I8)
      CALL DPWRST('XXX','BUG ')
      DO81I=1,NUMDEV
      WRITE(ICOUT,82)IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I)
   82 FORMAT('IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I) = ',
     1A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,83)IDPOWE(I),IDCONT(I),IDCOLO(I)
   83 FORMAT('IDPOWE(I),IDCONT(I),IDCOLO(I) = ',
     1A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,84)IDNVPP(I),IDNHPP(I),IDUNIT(I)
   84 FORMAT('IDNVPP(I),IDNHPP(I),IDUNIT(I) = ',
     1I8,I8,I8)
      CALL DPWRST('XXX','BUG ')
   81 CONTINUE
      WRITE(ICOUT,85)X1UNIT,Y1UNIT,X2UNIT,Y2UNIT
   85 FORMAT('X1UNIT,Y1UNIT,X2UNIT,Y2UNIT= ',4A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,87)IFOUND
   87 FORMAT('IFOUND= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,88)IBUGG4,ISUBG4,IERRG4
   88 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,89)IBUGD2,IERROR
   89 FORMAT('IBUGD2,IERROR= ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      IFIG='LINE'
      NUMPT=2
      NUMPT2=2*NUMPT
C
C               ********************************
C               **  STEP 0--                  **
C               **  STEP THROUGH EACH DEVICE  **
C               ********************************
C
      IF(NUMDEV.LE.0)GOTO9000
      DO8000IDEVIC=1,NUMDEV
C
      IF(IDPOWE(IDEVIC).EQ.'OFF')GOTO8000
C
      IMANUF=IDMANU(IDEVIC)
      IMODEL=IDMODE(IDEVIC)
      IMODE2=IDMOD2(IDEVIC)
      IMODE3=IDMOD3(IDEVIC)
      IGCONT=IDCONT(IDEVIC)
      IGCOLO=IDCOLO(IDEVIC)
CCCCC ADD FOLLOWING LINE MARCH 1997.
      IGFONT=IDFONT(IDEVIC)
      NUMVPP=IDNVPP(IDEVIC)
      NUMHPP=IDNHPP(IDEVIC)
      ANUMVP=NUMVPP
      ANUMHP=NUMHPP
C  AUGUST 1988.  ADD OFFSET VARIABLE
      IOFFSV=IDNVOF(IDEVIC)
      IOFFSH=IDNHOF(IDEVIC)
C
      IGUNIT=IDUNIT(IDEVIC)
C
C               ************************************
C               **  STEP 1--                      **
C               **  CARRY OUT OPENING OPERATIONS  **
C               **  ON THE GRAPHICS DEVICES       **
C               ************************************
C
      CALL DPOPDE
C
      IBELSW='OFF'
      NUMRIN=0
      IERASW='OFF'
      IBACCO='JUNK'
C
      CALL DPOPPL(IGRASW,
     1IBELSW,NUMRIN,IERASW,
     1IBACCO)
C
C               *****************************************
C               **  STEP 2--                           **
C               **  SEARCH FOR COMMAND SPECIFICATIONS  **
C               *****************************************
C
      IF(NUMARG.GE.2.AND.
     1IARGT(1).EQ.'NUMB'.AND.IARGT(2).EQ.'NUMB')
     1GOTO1111
      IF(NUMARG.GE.3.AND.IHARG(1).EQ.'ABSO'.AND.
     1IARGT(2).EQ.'NUMB'.AND.IARGT(3).EQ.'NUMB')
     1GOTO1112
      IF(NUMARG.GE.3.AND.IHARG(1).EQ.'RELA'.AND.
     1IARGT(2).EQ.'NUMB'.AND.IARGT(3).EQ.'NUMB')
     1GOTO1113
      GOTO1130
C
 1111 CONTINUE
      ITYPEO='ABSO'
      ILOCFN=1
      GOTO1119
C
 1112 CONTINUE
      ITYPEO='ABSO'
      ILOCFN=2
      GOTO1119
C
 1113 CONTINUE
      ITYPEO='RELA'
      ILOCFN=2
      GOTO1119
 1119 CONTINUE
C
      IF(ILOCFN.GT.NUMARG)GOTO1129
      DO1120I=ILOCFN,NUMARG
      IF(IARGT(I).EQ.'NUMB')GOTO1120
      GOTO1129
 1120 CONTINUE
      IFOUND='YES'
      GOTO1149
 1129 CONTINUE
      GOTO1130
C
 1130 CONTINUE
      IERRG4='YES'
      WRITE(ICOUT,1131)
 1131 FORMAT('***** ERROR IN DPDRAW--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1132)
 1132 FORMAT('      ILLEGAL FORM FOR DRAW ',
     1'COMMAND.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1134)
 1134 FORMAT('      TEST EXAMPLE TO DEMONSTRATE THE ',
     1'PROPER FORM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1135)
 1135 FORMAT('      SUPPOSE IT IS DESIRED TO DRAW A LINE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1136)
 1136 FORMAT('      WITH ONE END AT THE POINT 20 20 ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1137)
 1137 FORMAT('      AND WITH OPPOSITE END AT THE POINT 40 60')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1141)
 1141 FORMAT('      THEN THE ALLOWABLE FORMS ARE--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1142)
 1142 FORMAT('      DRAW 20 20 40 60 ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1143)
 1143 FORMAT('      DRAW ABSOLUTE 20 20 40 60 ')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
 1149 CONTINUE
C
C               ****************************
C               **  STEP 3--              **
C               **  DRAW OUT THE LINE(S)  **
C               ****************************
C
      NUMNUM=NUMARG-ILOCFN+1
      IF(NUMNUM.LT.NUMPT2)GOTO1151
      GOTO1152
C
 1151 CONTINUE
      J=ILOCFN-1
      X1=PXSTAR
      Y1=PYSTAR
      GOTO1159
C
 1152 CONTINUE
      J=ILOCFN
      IF(J.GT.NUMARG)GOTO1190
      X1=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED SEPTEMBER 1994
CCCCC AND THEN CHANGED             FEBRUARY  1995
CCCCC IF(UNITSW.EQ.'DATA')CALL DPCODS('X',X1,X1,IBUGD2,ISUBRO,IERROR)
      IF(X1UNIT.EQ.'DATA')CALL DPCODS('X',X1,X1,IBUGD2,ISUBRO,IERROR)
      J=J+1
      IF(J.GT.NUMARG)GOTO1190
      Y1=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED SEPTEMBER 1994
CCCCC AND THEN CHANGED             FEBRUARY  1995
CCCCC IF(UNITSW.EQ.'DATA')CALL DPCODS('Y',Y1,Y1,IBUGD2,ISUBRO,IERROR)
      IF(Y1UNIT.EQ.'DATA')CALL DPCODS('Y',Y1,Y1,IBUGD2,ISUBRO,IERROR)
      GOTO1159
 1159 CONTINUE
C
 1160 CONTINUE
      J=J+1
      IF(J.GT.NUMARG)GOTO1190
      X2=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED SEPTEMBER 1994
CCCCC AND THEN CHANGED             FEBRUARY  1995
CCCCC IF(UNITSW.EQ.'DATA')CALL DPCODS('X',X2,X2,IBUGD2,ISUBRO,IERROR)
      IF(X2UNIT.EQ.'DATA')CALL DPCODS('X',X2,X2,IBUGD2,ISUBRO,IERROR)
      IF(ITYPEO.EQ.'RELA')X2=X1+X2
      J=J+1
      IF(J.GT.NUMARG)GOTO1190
      Y2=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED SEPTEMBER 1994
CCCCC AND THEN CHANGED             FEBRUARY  1995
CCCCC IF(UNITSW.EQ.'DATA')CALL DPCODS('Y',Y2,Y2,IBUGD2,ISUBRO,IERROR)
      IF(Y2UNIT.EQ.'DATA')CALL DPCODS('Y',Y2,Y2,IBUGD2,ISUBRO,IERROR)
      IF(ITYPEO.EQ.'RELA')Y2=Y1+Y2
C
 1170 CONTINUE
      CALL DPDRA2(X1,Y1,X2,Y2,
     1IFIG,
     1ILINPA,ILINCO,PLINTH,
     1AREGBA,
     1IREBLI,IREBCO,PREBTH,
     1IREFSW,IREFCO,
     1IREPTY,IREPLI,IREPCO,PREPTH,PREPSP,
     1PTEXHE,PTEXWI,PTEXVG,PTEXHG)
C
      X1=X2
      Y1=Y2
C
      GOTO1160
 1190 CONTINUE
C
      PXEND=X2
      PYEND=Y2
C
C               ************************************
C               **  STEP 4--                      **
C               **  CARRY OUT CLOSING OPERATIONS  **
C               **  ON THE GRAPHICS DEVICES       **
C               ************************************
C
      ICOPSW='OFF'
      NUMCOP=0
      CALL DPCLPL(ICOPSW,NUMCOP,
     1PGRAXF,PGRAYF,
     1IGRASW,PDIAXC,PDIAYC,PDIAX2,PDIAY2,
     1PDIAHE,PDIAWI,PDIAVG,PDIAHG)
C
      CALL DPCLDE
C
 8000 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRAW')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPDRAW--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)ILOCFN,NUMNUM
 9012 FORMAT('ILOCFN,NUMNUM = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)X1,Y1,X2,Y2
 9013 FORMAT('X1,Y1,X2,Y2 = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)PXSTAR,PYSTAR
 9015 FORMAT('PXSTAR,PYSTAR = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)PXEND,PYEND
 9016 FORMAT('PXEND,PYEND = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)IFIG
 9017 FORMAT('IFIG = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9027)IFOUND
 9027 FORMAT('IFOUND = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9028)IBUGG4,ISUBG4,IERRG4
 9028 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9029)IBUGD2,IERROR
 9029 FORMAT('IBUGD2,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPDRBA(Y,X,XHIGH,PY,PX,PZ,NP,
CCCCC SUBROUTINE DPDRBA(Y,X,PY,PX,NP,
     1ICASPL,ICAS3D,
     1ISORSW,
     1IBA2SW,ABA2WI,ABA2BA,
     1IBA2BL,IBA2BC,PBA2BT,
     1IBA2FS,IBA2FC,
     1IBA2PT,IBA2PL,IBA2PC,IBA2TY,IBA2DI,PBA2PS,PBA2PT,
     1XDELMN,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1FX1MIN,FX1MAX,FY1MIN,FY1MAX,
     1IX1TSC,IY1TSC)
C
C     PURPOSE--FOR A GENERAL GRAPHICS DEVICE,
C              AND FOR EACH VALUE IN X(.), DRAW A BAR
C              (= VERTICAL OR HORIZONTAL BAR)
C              FROM THE BASE POINT ABA2BA
C              TO THE POINT Y(.).
C              DO SO FOR A SPECIFIED BAR LINE TYPE,
C              LINES COLOR, AND LINE THICKNESS.
C     NOTE--THE VARIABLES PY(.) AND PX(.) ARE DUMMY VARIABLES
C           WHICH ARE USED IN THE INTERMEDIATE CALCULATIONS
C           AND WHOSE DIMENSIONS ARE DEFINED (FOR EASY OF CHANGE)
C           BACK IN THE MAIN ROUTINE.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--87.5
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C     UPDATED--MAY        1987.
C            --JANUARY    1989.  GLOBAL REPLACE ABA2BA WITH ABA2BA (ALAN)
C     UPDATED--FEBRUARY   1989.  GRDRPL TO DPDRPL (ALAN)
C     UPDATED--FEBRUARY   1989.  EXTRA ARGUMENT IN CALL TO DPFIRE (ALAN)
C     UPDATED--FEBRUARY   1989.  BUG WITH PATTERN ON 1ST BAR ONLY (ALAN)
C     UPDATED--FEBRUARY   1989.  NO SORT IF ICASPL='CONT'
C     UPDATED--FEBRUARY   1989.  RENUMBER
C     UPDATED--JANUARY    2010.  FOR HISTOGRAM, ALLOW FOR UNEQUI-SPACED
C                                CASE (STORE IN XHIGH)
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAS3D
C
      CHARACTER*4 ISORSW
C
      CHARACTER*4 IBA2SW
      CHARACTER*4 IBA2BL
      CHARACTER*4 IBA2BC
      CHARACTER*4 IBA2FS
      CHARACTER*4 IBA2FC
      CHARACTER*4 IBA2PT
      CHARACTER*4 IBA2PL
      CHARACTER*4 IBA2PC
      CHARACTER*4 IBA2TY
      CHARACTER*4 IBA2DI
C
      CHARACTER*4 IX1TSC
      CHARACTER*4 IY1TSC
C
      CHARACTER*4 ITYPE
C
      CHARACTER*4 IFIG
      CHARACTER*4 IPATT
      CHARACTER*4 ICOL
      CHARACTER*4 ICOLF
      CHARACTER*4 ICOLP
      CHARACTER*4 IDIR
C
CCCCC CHARACTER*4 IHORPA
CCCCC CHARACTER*4 IVERPA
CCCCC CHARACTER*4 IDUPPA
CCCCC CHARACTER*4 IDDOPA
C
      CHARACTER*4 IFIGSV
      CHARACTER*4 IFLAG
      CHARACTER*4 IPATT2
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION XHIGH(*)
      DIMENSION PY(*)
      DIMENSION PX(*)
      DIMENSION PZ(*)
C
      DIMENSION PY2(20)
      DIMENSION PX2(20)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      HOLD=1.0
      ABASE=0.0
      PBASE=0.0
      PBASE2=0.0
      PLEFT=0.0
      PRIGHT=0.0
      AWIDTH=0.0
      PWIDTH=0.0
      IFLAGH=0
      IF(ICASPL.EQ.'HIST' .OR. ICASPL.EQ.'CUMH' .OR.
     1   ICASPL.EQ.'CUMR')THEN
        IF(XHIGH(1).NE.CPUMIN)IFLAGH=1
      ENDIF
C
      FXMIN=FX1MIN
      FXMAX=FX1MAX
      FYMIN=FY1MIN
      FYMAX=FY1MAX
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRBA')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPDRBA--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)NP,ICASPL,ICAS3D,ISORSW,XDELM
   53   FORMAT('NP,ICASPL,ICAS3D,ISORSW,XDELM = ',
     1         I8,2X,A4,2X,A4,2X,A4,2X,G15.7)
        CALL DPWRST('XXX','BUG ')
        IF(NP.GT.1)THEN
          DO65I=1,NP
            WRITE(ICOUT,66)I,X(I),Y(I),XHIGH(I)
   66       FORMAT('I,X(I),Y(I),XHIGH(I) = ',I8,3G15.7)
            CALL DPWRST('XXX','BUG ')
   65     CONTINUE
        ENDIF
        WRITE(ICOUT,71)IBA2SW,ABA2WI,ABA2BA
   71   FORMAT('IBA2SW,ABA2WI,ABA2BA = ',A4,2X,2E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,72)IBA2BL,IBA2BC,PBA2BT
   72   FORMAT('IBA2BL,IBA2BC,PBA2BT = ',A4,2X,A4,2X,E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,73)IBA2FS,IBA2FC,IFLAGH
   73   FORMAT('IBA2FS,IBA2FC,IFLAGH = ',A4,2X,A4,2X,I5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,74)IBA2PT,IBA2PL,IBA2PC,IBA2TY,IBA2DI,PBA2PS,PBA2PT
   74   FORMAT('IBA2PT,IBA2PL,IBA2PC,IBA2TY,IBA2DI,PBA2PS,PBA2PT = ',
     1         A4,2X,A4,2X,A4,2X,A4,2X,A4,2X,2E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,84)PXMIN,PXMAX,PYMIN,PYMAX
   84   FORMAT('PXMIN,PXMAX,PYMIN,PYMAX= ',4E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,85)FX1MIN,FX1MAX,FY1MIN,FY1MAX
   85   FORMAT('FX1MIN,FX1MAX,FY1MIN,FY1MAX= ',4E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,86)IX1TSC,IY1TSC
   86   FORMAT('IX1TSC,IY1TSC = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,89)IBUGG4,ISUBG4,IERRG4
   89   FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *************************************************
C               **  STEP 11--                                  **
C               **  IF CALLED FOR, SORT THE DATA               **
C               **  ACCORDING TO THE HORIZONTAL AXIS VARIABLE  **
C               *************************************************
C
      IDIR=IBA2DI
C
      IF(ICASPL.EQ.'TRPL')GOTO9000
C
      IF(ISORSW.EQ.'OFF'  .OR. ICASPL.EQ.'PIEC' .OR.
     1   ICASPL.EQ.'ROSE' .OR. ICASPL.EQ.'ON'   .OR.
     1   ICASPL.EQ.'HIST' .OR. ICASPL.EQ.'CUMH' .OR.
     1   ICASPL.EQ.'CUMR' .OR.
     1   ICASPL.EQ.'CONT')THEN
        DO1160I=1,NP
          PX(I)=X(I)
          PY(I)=Y(I)
 1160   CONTINUE
C
        IF(IFLAGH.EQ.1)THEN
          DO1161I=1,NP
            PZ(I)=XHIGH(I)
            IF(PZ(I).LE.PX(I))THEN
              WRITE(ICOUT,999)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,1251)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,1171)I
 1171         FORMAT('      FOR UNEQUI-SPACED HISTOGRAMS, FOR ROW ',I8)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,1172)
 1172         FORMAT('      THE UPPER INTERVAL IS LESS THAN OR EQUAL ',
     1               'TO THE LOWER INTERVAL.')
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,1173)PX(I)
 1173         FORMAT('      THE VALUE FOR THE LOWER INTERVAL IS ',G15.7)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,1174)PZ(I)
 1174         FORMAT('      THE VALUE FOR THE UPPER INTERVAL IS ',G15.7)
              CALL DPWRST('XXX','BUG ')
              GOTO9000
            ENDIF
 1161     CONTINUE
        ENDIF
      ELSE
        CALL SORTC(X,Y,NP,PX,PY)
      ENDIF
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRBA')THEN
        WRITE(ICOUT,1194)IPR
 1194   FORMAT('IPR=',I4)
        CALL DPWRST('XXX','BUG ')
        IF(IFLAGH.EQ.1)THEN
          DO1198I=1,10
            WRITE(ICOUT,1199) I,PX(I),PY(I),PZ(I)
 1199       FORMAT('I,PX(I),PY(I),PZ(I) =',I8,2X,3G15.7)
            CALL DPWRST('XXX','BUG ')
 1198     CONTINUE
        ELSE
          DO1192I=1,10
            WRITE(ICOUT,1196) I,PX(I),PY(I)
 1196       FORMAT('I,PX(I),PY(I) =',I8,2X,2G15.7)
            CALL DPWRST('XXX','BUG ')
 1192     CONTINUE
        ENDIF
      ENDIF
C
C               ************************************************
C               **  STEP 12--                                 **
C               **  IF A LOG SCALE PLOT IS CALLED FOR,        **
C               **  CHECK THAT ALL DATA POINTS ARE POSITIVE.  **
C               ************************************************
C
      IF(IX1TSC.EQ.'LOG')THEN
        IFLAGN=0
        IF(IDIR.EQ.'H')THEN
          IF(ABA2BA.LE.0.0)HOLD=ABA2BA
          IF(ABA2BA.LE.0.0)IFLAGN=1
          GOTO1239
        ENDIF
C
        IF(ISORSW.EQ.'ON')THEN
          J=1
          IF(PX(J).LE.0.0)IFLAGN=1
        ELSE
          DO1235I=1,NP
            J=I
            IF(PX(J).LE.0.0)THEN
              IFLAGN=1
              GOTO1239
            ELSEIF(IFLAGH.EQ.1 .AND. PZ(J).LE.0.0)THEN
              IFLAGN=1
              GOTO1239
            ENDIF
 1235     CONTINUE
        ENDIF
C
 1239   CONTINUE
        IF(IFLAGN.EQ.1)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1251)
 1251     FORMAT('***** ERROR IN DPDRBA--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1252)
 1252     FORMAT('      THE LOG OF A NON-POSITIVE DATA VALUE WAS')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1253)
 1253     FORMAT('      ENCOUNTERED IN FORMING A PLOT.  DATA MAY NOT')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1255)
 1255     FORMAT('      BE ZERO OR NEGATIVE WHEN A LOG SCALE PLOT ',
     1           'IS USED.')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1256)PX(J)
 1256     FORMAT('      THE VALUE = ',G15.7)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1257)
 1257     FORMAT('      THIS VALUE CAME FROM THE HORIZONTAL AXIS ',
     1           'VARIABLE.')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1259)
 1259     FORMAT('      CORRECTIVE ACTION--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1260)
 1260     FORMAT('      CHANGE DATA OR CHANGE LIMITS.')
          CALL DPWRST('XXX','BUG ')
          IERRG4='YES'
          GOTO9000
        ENDIF
      ENDIF
C
      IF(IY1TSC.EQ.'LOG')THEN
        IFLAGN=0
        IF(IDIR.EQ.'V')THEN
          IF(ABA2BA.LE.0.0)HOLD=ABA2BA
          IF(ABA2BA.LE.0.0)IFLAGN=1
          GOTO1339
        ENDIF
C
        IF(ISORSW.EQ.'ON')THEN
          J=1
          IF(PY(J).LE.0.0)HOLD=PY(J)
          IF(PY(J).LE.0.0)IFLAGN=1
        ELSE
          DO1335I=1,NP
            J=I
            IF(PY(J).LE.0.0)HOLD=PY(J)
            IF(PY(J).LE.0.0)THEN
              IFLAGN=1
              GOTO1339
            ENDIF
 1335     CONTINUE
        ENDIF
C
 1339   CONTINUE
        IF(IFLAGN.EQ.1)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1351)
 1351     FORMAT('***** ERROR IN DPDRBA--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1352)
 1352     FORMAT('      THE LOG OF A NON-POSITIVE DATA VALUE WAS')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1353)
 1353     FORMAT('      ENCOUNTERED IN FORMING A PLOT.  DATA MAY NOT')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1355)
 1355     FORMAT('      BE ZERO OR NEGATIVE.  WHEN A LOG SCALE PLOT ',
     1           'IS USED.')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1356)HOLD
 1356     FORMAT('      THE VALUE = ',E15.7)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1357)
 1357     FORMAT('      THIS VALUE CAME FROM THE VERTICAL AXIS ',
     1           'VARIABLE.')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1259)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1260)
          CALL DPWRST('XXX','BUG ')
          IERRG4='YES'
          GOTO9000
        ENDIF
      ENDIF
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRBA')THEN
        WRITE(ICOUT,1391) 
 1391   FORMAT('AT BRANCH POINT 1390')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ******************************************
C               **  STEP 40--                           **
C               **  IF A LOG SCALE PLOT IS CALLED FOR,  **
C               **  TRANSFORM THE DATA                  **
C               ******************************************
C
      ABASE=ABA2BA
      AWIDTH=ABA2WI
C
      IF(IDIR.EQ.'V')THEN
        IF(AWIDTH.EQ.CPUMIN.AND.XDELMN.LE.0.0)AWIDTH=1.0
        IF(AWIDTH.EQ.CPUMIN.AND.XDELMN.GT.0.0)AWIDTH=XDELMN
      ELSEIF(IDIR.EQ.'H')THEN
        IF(AWIDTH.EQ.CPUMIN.AND.XDELMN.LE.0.0)AWIDTH=1.0
        IF(AWIDTH.EQ.CPUMIN.AND.XDELMN.GT.0.0)AWIDTH=XDELMN
      ENDIF
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRBA')THEN
        WRITE(ICOUT,4008) ABASE,AWIDTH
 4008   FORMAT('ABASE,AWIDTH =',2G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(IX1TSC.EQ.'LOG')THEN
        IF(IDIR.EQ.'H')ABASE=LOG10(ABASE)
        DO4015I=1,NP
          PX(I)=LOG10(PX(I))
 4015   CONTINUE
        IF(IFLAGH.EQ.1)THEN
          DO4016I=1,NP
            PZ(I)=LOG10(PZ(I))
 4016     CONTINUE
        ENDIF
      ENDIF
C
      IF(IY1TSC.EQ.'LOG')THEN
        IF(IDIR.EQ.'V')ABASE=LOG10(ABASE)
        DO4025I=1,NP
          PY(I)=LOG10(PY(I))
 4025   CONTINUE
      ENDIF
C
C               *****************************************************
C               **  STEP 50--                                      **
C               **  TRANSLATE THE DATA POINTS                      **
C               **  INTO STANDARDIZED (0.0 TO 100.0) COORDINATES.  **
C               *****************************************************
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRBA')THEN
        WRITE(ICOUT,4999)
 4999   FORMAT( 'AT 5001 BREAKPOINT')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      FXMIN=FX1MIN
      FXMAX=FX1MAX
      IF(IX1TSC.EQ.'LOG')THEN
        FXMIN=LOG10(FX1MIN)
        FXMAX=LOG10(FX1MAX)
      ENDIF
C
      FYMIN=FY1MIN
      FYMAX=FY1MAX
      IF(IY1TSC.EQ.'LOG')THEN
        FYMIN=LOG10(FY1MIN)
        FYMAX=LOG10(FY1MAX)
      ENDIF
C
      FXRANG=FXMAX-FXMIN
      FYRANG=FYMAX-FYMIN
      PXRANG=PXMAX-PXMIN
      PYRANG=PYMAX-PYMIN
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRBA')THEN
        WRITE(ICOUT,4993) FXMIN,FXMAX,FYMIN,FYMAX
 4993   FORMAT('FXMIN,FXMAX,FYMIN,FYMAX=',4(E15.7,1X))
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4994) FXRANG,FYRANG,PXRANG,PYRANG
 4994   FORMAT('FXRANG,FYRANG,PXRANG,PYRANG=',6(E15.7,1X))
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      DO5000I=1,NP
        FXRATI=(PX(I)-FXMIN)/FXRANG
        FYRATI=(PY(I)-FYMIN)/FYRANG
        PX(I)=PXMIN+FXRATI*PXRANG
        PY(I)=PYMIN+FYRATI*PYRANG
 5000 CONTINUE
C
      IF(IFLAGH.EQ.1)THEN
        DO5002I=1,NP
          FXRAT2=(PZ(I)-FXMIN)/FXRANG
          PZ(I)=PXMIN+FXRAT2*PXRANG
 5002   CONTINUE
      ENDIF
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRBA')THEN
        DO5004I=1,NP
          WRITE(ICOUT,5006) PX(I),PY(I),PZ(I)
 5006     FORMAT('PX(I),PY(I),PZ(I)=',3(E15.7,1X))
          CALL DPWRST('XXX','BUG ')
 5004   CONTINUE
      ENDIF
C
      IF(IDIR.EQ.'V')THEN
        FYRATI=(ABASE-FYMIN)/FYRANG
        PBASE=PYMIN+FYRATI*PYRANG
        PWIDTH=AWIDTH*(PXRANG/FXRANG)
      ELSEIF(IDIR.EQ.'H')THEN
        FXRATI=(ABASE-FXMIN)/FXRANG
        PBASE=PXMIN+FXRATI*PXRANG
        PWIDTH=AWIDTH*(PYRANG/FYRANG)
      ENDIF
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRBA')THEN
        WRITE(ICOUT,5038) FXRATI,PBASE,PWIDTH
 5038   FORMAT('FXRATI,PBASE,PWIDTH=',3(E15.7,1X))
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *******************************
C               **  STEP 70--                **
C               **  PREPARE TO MAKE VARIOUS  **
C               **  LINE SETTINGS            **
C               *******************************
C
      ITYPE='LINE'
C
      IFIG='BOX'
      IF(IBA2TY.EQ.'3')IFIG='CUBE'
      IFIGSV=IFIG
      PBASE2=PBASE
C
      CALL DPSQUE(PX,PY,NP,PXMIN,PXMAX,PYMIN,PYMAX)
C
      IF(IFLAGH.EQ.1)THEN
        CALL DPSQUE(PX,PZ,NP,PXMIN,PXMAX,PYMIN,PYMAX)
      ENDIF
C
C               ***************************************
C               **  STEP 81--                        **
C               **  DRAW OUT ALL VERTICAL BARS       **
C               **  (BUT FILL FIRST, IF CALLED FOR)  **
C               ***************************************
C
      IF(IDIR.EQ.'V')GOTO8100
      GOTO8190
C
 8100 CONTINUE
C  SEPTEMBER, 1987 - MOVE SETTINGS INSIDE THE LOOP
CCCCC IPATT=IBA2PT
CCCCC PTHICK=PBA2PT
CCCCC PXGAP=PBA2PS
CCCCC PYGAP=PBA2PS
CCCCC ICOLF=IBA2FC
CCCCC ICOLP=IBA2PC
C
      IF(PBASE2.LT.PYMIN.AND.(PYMIN-PBASE2).LE.0.0001)PBASE2=PYMIN
      IF(PBASE2.GT.PYMAX.AND.(PBASE2-PYMAX).LE.0.0001)PBASE2=PYMAX
C
      DO8105I=1,NP
C
        IPATT=IBA2PT
        IPATT2=IBA2PL
        PTHICK=PBA2PT
        PXGAP=PBA2PS
        PYGAP=PBA2PS
        ICOLF=IBA2FC
        ICOLP=IBA2PC
C
        IF(IFLAGH.EQ.1)THEN
          PLEFT=PX(I)
          PRIGHT=PZ(I)
        ELSE
          PLEFT=PX(I)-PWIDTH/2.0
          PRIGHT=PX(I)+PWIDTH/2.0
        ENDIF
        IF(PLEFT.LT.PXMIN.AND.(PXMIN-PLEFT).LE.0.0001)PLEFT=PXMIN
        IF(PRIGHT.GT.PXMAX.AND.(PRIGHT-PXMAX).LE.0.0001)PRIGHT=PXMAX
C
        IF(PRIGHT.LT.PXMIN)GOTO8105
        IF(PLEFT.GT.PXMAX)GOTO8105
        IF(PY(I).LT.PYMIN.AND.PBASE2.LT.PYMIN)GOTO8105
        IF(PY(I).GT.PYMAX.AND.PBASE2.GT.PYMAX)GOTO8105
C
        X1=PLEFT
        Y1=PBASE2
        X2=PRIGHT
        Y2=PY(I)
C
        DELX=ABS(X2-X1)
        DELY=ABS(Y2-Y1)
        DELMIN=DELX
CCCCC   IF(DELY.LT.DELX)DELMIN=DELY
        P3D=0.3
        DEL3D=P3D*DELMIN
C
        IF(IBA2FS.EQ.'OFF')GOTO8150
C
        IF(IBA2FS.EQ.'ONS')GOTO8120
        IF(IBA2FS.EQ.'ONST')GOTO8120
        IF(IBA2FS.EQ.'ONTS')GOTO8120
        IF(IBA2FS.EQ.'ONT')GOTO8130
C
        IF(IBA2FS.EQ.'ON'   .OR. IBA2FS.EQ.'ONF'  .OR.
     1     IBA2FS.EQ.'ONFS' .OR. IBA2FS.EQ.'ONSF' .OR.
     1     IBA2FS.EQ.'ONFT' .OR. IBA2FS.EQ.'ONTF')THEN
C
C         FRONT FACE
C
          PX2(1)=X1
          PY2(1)=Y1
C
          PX2(2)=X2
          PY2(2)=Y1
C
          PX2(3)=X2
          PY2(3)=Y2
C
          PX2(4)=X1
          PY2(4)=Y2
C
          PX2(5)=X1
          PY2(5)=Y1
C
          NP2=5
C
          DO8115J=1,NP2
            IF(PX2(J).LT.PXMIN)PX2(J)=PXMIN
            IF(PX2(J).GT.PXMAX)PX2(J)=PXMAX
            IF(PY2(J).LT.PYMIN)PY2(J)=PYMIN
            IF(PY2(J).GT.PYMAX)PY2(J)=PYMAX
 8115     CONTINUE
          CALL DPFIRE(PX2,PY2,NP2,
     1                IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP,
     1                IPATT2)
C
        ENDIF
 8120   CONTINUE
C
        IF(IBA2TY.EQ.'2')GOTO8150
        IF(IBA2FS.EQ.'ONF')GOTO8150
        IF(IBA2FS.EQ.'ONT')GOTO8130
        IF(IBA2FS.EQ.'ONFT')GOTO8130
        IF(IBA2FS.EQ.'ONTF')GOTO8130
C
        IF(IBA2FS.EQ.'ON'   .OR. IBA2FS.EQ.'ONS'  .OR.
     1     IBA2FS.EQ.'ONFS' .OR. IBA2FS.EQ.'ONSF' .OR.
     1     IBA2FS.EQ.'ONST' .OR. IBA2FS.EQ.'ONTS')THEN
C
C         SIDE (= RIGHT) FACE
C
          PX2(1)=X2
          PY2(1)=Y2
C
          PX2(2)=X2+DEL3D
          PY2(2)=Y2+DEL3D
C
          PX2(3)=X2+DEL3D
          PY2(3)=Y1+DEL3D
C
          PX2(4)=X2
          PY2(4)=Y1
C
          PX2(5)=X2
          PY2(5)=Y2
C
          NP2=5
C
          DO8125J=1,NP2
            IF(PX2(J).LT.PXMIN)PX2(J)=PXMIN
            IF(PX2(J).GT.PXMAX)PX2(J)=PXMAX
            IF(PY2(J).LT.PYMIN)PY2(J)=PYMIN
            IF(PY2(J).GT.PYMAX)PY2(J)=PYMAX
 8125     CONTINUE
          CALL DPFIRE(PX2,PY2,NP2,
     1                IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP,
     1                IPATT2)
        ENDIF
C
 8130   CONTINUE
C
        IF(IBA2FS.EQ.'ONF')GOTO8150
        IF(IBA2FS.EQ.'ONS')GOTO8150
        IF(IBA2FS.EQ.'ONFS')GOTO8150
        IF(IBA2FS.EQ.'ONSF')GOTO8150
C
        IF(IBA2FS.EQ.'ON'   .OR. IBA2FS.EQ.'ONT'  .OR.
     1     IBA2FS.EQ.'ONFT' .OR. IBA2FS.EQ.'ONTF' .OR.
     1     IBA2FS.EQ.'ONST' .OR. IBA2FS.EQ.'ONTS')THEN
C
C         TOP FACE
C
          PX2(1)=X1
          PY2(1)=Y2
C
          PX2(2)=X1+DEL3D
          PY2(2)=Y2+DEL3D
C
          PX2(3)=X2+DEL3D
          PY2(3)=Y2+DEL3D
C
          PX2(4)=X2
          PY2(4)=Y2
C
          PX2(5)=X1
          PY2(5)=Y2
C
          NP2=5
C
          DO8135J=1,NP2
            IF(PX2(J).LT.PXMIN)PX2(J)=PXMIN
            IF(PX2(J).GT.PXMAX)PX2(J)=PXMAX
            IF(PY2(J).LT.PYMIN)PY2(J)=PYMIN
            IF(PY2(J).GT.PYMAX)PY2(J)=PYMAX
 8135     CONTINUE
          CALL DPFIRE(PX2,PY2,NP2,
     1                IFIG,IPATT,PTHICK,PX2GAP,PYGAP,ICOLF,ICOLP,
     1                IPATT2)
        ENDIF
C
 8150   CONTINUE
C
C       DRAW OUT THE EDGES OF THE BAR
C
        IPATT=IBA2BL
        PTHICK=PBA2BT
        ICOL=IBA2BC
C
        PX2(1)=X1
        PY2(1)=Y1
C
        PX2(2)=X2
        PY2(2)=Y1
C
        PX2(3)=X2
        PY2(3)=Y2
C
        PX2(4)=X1
        PY2(4)=Y2
C
        PX2(5)=X1
        PY2(5)=Y1
C
        NP2=5
C
        DO8151J=1,NP2
          IF(PX2(J).LT.PXMIN)PX2(J)=PXMIN
          IF(PX2(J).GT.PXMAX)PX2(J)=PXMAX
          IF(PY2(J).LT.PYMIN)PY2(J)=PYMIN
          IF(PY2(J).GT.PYMAX)PY2(J)=PYMAX
 8151   CONTINUE
        IFLAG='ON'
        CALL DPDRPL(PX2,PY2,NP2,
     1              IFIG,IPATT,PTHICK,ICOL,
     1              JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
C
        IF(IBA2TY.EQ.'2')GOTO8105
C
        PX2(1)=X1
        PY2(1)=Y2
C
        PX2(2)=X1+DEL3D
        PY2(2)=Y2+DEL3D
C
        PX2(3)=X2+DEL3D
        PY2(3)=Y2+DEL3D
C
        PX2(4)=X2
        PY2(4)=Y2
C
        NP2=4
C
        DO8152J=1,NP2
          IF(PX2(J).LT.PXMIN)PX2(J)=PXMIN
          IF(PX2(J).GT.PXMAX)PX2(J)=PXMAX
          IF(PY2(J).LT.PYMIN)PY2(J)=PYMIN
          IF(PY2(J).GT.PYMAX)PY2(J)=PYMAX
 8152   CONTINUE
        IFLAG='OFF'
        CALL DPDRPL(PX2,PY2,NP2,
     1              IFIG,IPATT,PTHICK,ICOL,
     1              JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
C
        PX2(1)=X2+DEL3D
        PY2(1)=Y2+DEL3D
C
        PX2(2)=X2+DEL3D
        PY2(2)=Y1+DEL3D
C
        PX2(3)=X2
        PY2(3)=Y1
C
        NP2=3
C
        DO8153J=1,NP2
          IF(PX2(J).LT.PXMIN)PX2(J)=PXMIN
          IF(PX2(J).GT.PXMAX)PX2(J)=PXMAX
          IF(PY2(J).LT.PYMIN)PY2(J)=PYMIN
          IF(PY2(J).GT.PYMAX)PY2(J)=PYMAX
 8153   CONTINUE
        IFLAG='OFF'
        CALL DPDRPL(PX2,PY2,NP2,
     1              IFIG,IPATT,PTHICK,ICOL,
     1              JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
C
 8105 CONTINUE
C
 8190 CONTINUE
C
C               ***************************************
C               **  STEP 82--                        **
C               **  DRAW OUT ALL HORIZONTAL BARS     **
C               **  (BUT FILL FIRST, IF CALLED FOR)  **
C               ***************************************
C
      IF(IDIR.EQ.'H')GOTO8200
      GOTO8290
C
 8200 CONTINUE
C SEPTEMBER, 1987: MOVE INSIDE LOOP
CCCCC IPATT=IBA2PT
CCCCC PTHICK=PBA2PT
CCCCC PXGAP=PBA2PS
CCCCC PYGAP=PBA2PS
CCCCC ICOLF=IBA2FC
CCCCC ICOLP=IBA2PC
C
      IF(PBASE2.LT.PXMIN.AND.(PXMIN-PBASE2).LE.0.0001)PBASE2=PXMIN
      IF(PBASE2.GT.PXMAX.AND.(PBASE2-PXMAX).LE.0.0001)PBASE2=PXMAX
C
      DO8205I=1,NP
C
        IPATT=IBA2PT
        IPATT2=IBA2PL
        PTHICK=PBA2PT
        PXGAP=PBA2PS
        PYGAP=PBA2PS
        ICOLF=IBA2FC
        ICOLP=IBA2PC
C
        IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRBA')THEN
          WRITE(ICOUT,8203) 
 8203     FORMAT('IN 8200 LOOP')
          CALL DPWRST('XXX','BUG ')
        ENDIF
C
        IF(IFLAGH.EQ.1)THEN
          PBOT=PY(I)
          PTOP=PZ(I)
        ELSE
          PBOT=PY(I)-PWIDTH/2.0
          PTOP=PY(I)+PWIDTH/2.0
        ENDIF
        IF(PBOT.LT.PYMIN.AND.(PYMIN-PBOT).LE.0.0001)PBOT=PYMIN
        IF(PTOP.GT.PYMAX.AND.(PTOP-PYMAX).LE.0.0001)PTOP=PYMAX
C
        IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRBA')THEN
          WRITE(ICOUT,8204) PBOT,PTOP
 8204     FORMAT('PBOT,PTOP=',2(E15.7,1X))
          CALL DPWRST('XXX','BUG ')
        ENDIF
C
        IF(PTOP.LT.PYMIN)GOTO8205
        IF(PBOT.GT.PYMAX)GOTO8205
        IF(PX(I).LT.PXMIN.AND.PBASE2.LT.PXMIN)GOTO8205
        IF(PX(I).GT.PXMAX.AND.PBASE2.GT.PXMAX)GOTO8205
C
        X1=PBASE2
        Y1=PBOT
        X2=PX(I)
        Y2=PTOP
C
        DELX=ABS(X2-X1)
        DELY=ABS(Y2-Y1)
        DELMIN=DELY
CCCCC   IF(DELX.LT.DELY)DELMIN=DELX
        P3D=0.3
        DEL3D=P3D*DELMIN
C
        IF(IBA2FS.EQ.'OFF')GOTO8250
        IF(IBA2FS.EQ.'ONS')GOTO8220
        IF(IBA2FS.EQ.'ONST')GOTO8220
        IF(IBA2FS.EQ.'ONTS')GOTO8220
        IF(IBA2FS.EQ.'ONT')GOTO8230
C
        IF(IBA2FS.EQ.'ON'   .OR. IBA2FS.EQ.'ONF'  .OR.
     1     IBA2FS.EQ.'ONFS' .OR. IBA2FS.EQ.'ONSF' .OR.
     1     IBA2FS.EQ.'ONFT' .OR. IBA2FS.EQ.'ONTF')THEN
C
C         FRONT FACE
C
          PX2(1)=X1
          PY2(1)=Y1
C
          PX2(2)=X2
          PY2(2)=Y1
C
          PX2(3)=X2
          PY2(3)=Y2
C
          PX2(4)=X1
          PY2(4)=Y2
C
          PX2(5)=X1
          PY2(5)=Y1
C
          NP2=5
C
          DO8215J=1,NP2
            IF(PX2(J).LT.PXMIN)PX2(J)=PXMIN
            IF(PX2(J).GT.PXMAX)PX2(J)=PXMAX
            IF(PY2(J).LT.PYMIN)PY2(J)=PYMIN
            IF(PY2(J).GT.PYMAX)PY2(J)=PYMAX
 8215     CONTINUE
          CALL DPFIRE(PX2,PY2,NP2,
     1                IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP,
     1                IPATT2)
        ENDIF
C
 8220   CONTINUE
C
        IF(IBA2TY.EQ.'2')GOTO8250
        IF(IBA2FS.EQ.'ONF')GOTO8250
        IF(IBA2FS.EQ.'ONT')GOTO8230
        IF(IBA2FS.EQ.'ONFT')GOTO8230
        IF(IBA2FS.EQ.'ONTF')GOTO8230
C
        IF(IBA2FS.EQ.'ON'   .OR. IBA2FS.EQ.'ONS'  .OR.
     1     IBA2FS.EQ.'ONFS' .OR. IBA2FS.EQ.'ONSF' .OR.
     1     IBA2FS.EQ.'ONST' .OR. IBA2FS.EQ.'ONTS')THEN
C
C         SIDE (= RIGHT) FACE
C
          PX2(1)=X2
          PY2(1)=Y2
C
          PX2(2)=X2+DEL3D
          PY2(2)=Y2+DEL3D
C
          PX2(3)=X2+DEL3D
          PY2(3)=Y1+DEL3D
C
          PX2(4)=X2
          PY2(4)=Y1
C
          PX2(5)=X2
          PY2(5)=Y2
C
          NP2=5
C
          DO8225J=1,NP2
            IF(PX2(J).LT.PXMIN)PX2(J)=PXMIN
            IF(PX2(J).GT.PXMAX)PX2(J)=PXMAX
            IF(PY2(J).LT.PYMIN)PY2(J)=PYMIN
            IF(PY2(J).GT.PYMAX)PY2(J)=PYMAX
 8225     CONTINUE
          CALL DPFIRE(PX2,PY2,NP2,
     1                IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP,
     1                IPATT2)
        ENDIF
C
 8230   CONTINUE
C
        IF(IBA2FS.EQ.'ONF')GOTO8250
        IF(IBA2FS.EQ.'ONS')GOTO8250
        IF(IBA2FS.EQ.'ONFS')GOTO8250
        IF(IBA2FS.EQ.'ONSF')GOTO8250
C
        IF(IBA2FS.EQ.'ON'  .OR. IBA2FS.EQ.'ONT'  .OR.
     1    IBA2FS.EQ.'ONFT' .OR. IBA2FS.EQ.'ONTF' .OR.
     1    IBA2FS.EQ.'ONST' .OR. IBA2FS.EQ.'ONTS')THEN
C
C         TOP FACE
C
          PX2(1)=X1
          PY2(1)=Y2
C
          PX2(2)=X1+DEL3D
          PY2(2)=Y2+DEL3D
C
          PX2(3)=X2+DEL3D
          PY2(3)=Y2+DEL3D
C
          PX2(4)=X2
          PY2(4)=Y2
C
          PX2(5)=X1
          PY2(5)=Y2
C
          NP2=5
C
          DO8235J=1,NP2
            IF(PX2(J).LT.PXMIN)PX2(J)=PXMIN
            IF(PX2(J).GT.PXMAX)PX2(J)=PXMAX
            IF(PY2(J).LT.PYMIN)PY2(J)=PYMIN
            IF(PY2(J).GT.PYMAX)PY2(J)=PYMAX
 8235     CONTINUE
          CALL DPFIRE(PX2,PY2,NP2,
     1                IFIG,IPATT,PTHICK,PX2GAP,PYGAP,ICOLF,ICOLP,
     1                IPATT2)
        ENDIF
C
 8250   CONTINUE
C
C       DRAW OUT THE EDGES OF THE BAR
C
        IPATT=IBA2BL
        PTHICK=PBA2BT
        ICOL=IBA2BC
C
        PX2(1)=X1
        PY2(1)=Y1
C
        PX2(2)=X2
        PY2(2)=Y1
C
        PX2(3)=X2
        PY2(3)=Y2
C
        PX2(4)=X1
        PY2(4)=Y2
C
        PX2(5)=X1
        PY2(5)=Y1
C
        NP2=5
C
        DO8251J=1,NP2
          IF(PX2(J).LT.PXMIN)PX2(J)=PXMIN
          IF(PX2(J).GT.PXMAX)PX2(J)=PXMAX
          IF(PY2(J).LT.PYMIN)PY2(J)=PYMIN
          IF(PY2(J).GT.PYMAX)PY2(J)=PYMAX
 8251   CONTINUE
        IFLAG='ON'
        CALL DPDRPL(PX2,PY2,NP2,
     1              IFIG,IPATT,PTHICK,ICOL,
     1              JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
C
        IF(IBA2TY.EQ.'2')GOTO8205
C
        PX2(1)=X1
        PY2(1)=Y2
C
        PX2(2)=X1+DEL3D
        PY2(2)=Y2+DEL3D
C
        PX2(3)=X2+DEL3D
        PY2(3)=Y2+DEL3D
C
        PX2(4)=X2
        PY2(4)=Y2
C
        NP2=4
C
        DO8252J=1,NP2
          IF(PX2(J).LT.PXMIN)PX2(J)=PXMIN
          IF(PX2(J).GT.PXMAX)PX2(J)=PXMAX
          IF(PY2(J).LT.PYMIN)PY2(J)=PYMIN
          IF(PY2(J).GT.PYMAX)PY2(J)=PYMAX
 8252   CONTINUE
        IFLAG='OFF'
        CALL DPDRPL(PX2,PY2,NP2,
     1              IFIG,IPATT,PTHICK,ICOL,
     1              JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
C
        PX2(1)=X2+DEL3D
        PY2(1)=Y2+DEL3D
C
        PX2(2)=X2+DEL3D
        PY2(2)=Y1+DEL3D
C
        PX2(3)=X2
        PY2(3)=Y1
C
        NP2=3
C
        DO8253J=1,NP2
          IF(PX2(J).LT.PXMIN)PX2(J)=PXMIN
          IF(PX2(J).GT.PXMAX)PX2(J)=PXMAX
          IF(PY2(J).LT.PYMIN)PY2(J)=PYMIN
          IF(PY2(J).GT.PYMAX)PY2(J)=PYMAX
 8253   CONTINUE
        IFLAG='OFF'
        CALL DPDRPL(PX2,PY2,NP2,
     1              IFIG,IPATT,PTHICK,ICOL,
     1              JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
C
 8205 CONTINUE
C
 8290 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRBA')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDRBA--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NP,ICASPL,ICAS3D,ISORSW
 9013   FORMAT('NP,ICASPL,ICAS3D,ISORSW = ',I8,3(2X,A4))
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9014)ABASE,HOLD,PBASE,PBASE2,PLEFT,PRIGHT
 9014   FORMAT('ABASE,HOLD,PBASE,PBASE2,PLEFT,PRIGHT = ',6E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)XDELMN,AWIDTH,PWIDTH
 9015   FORMAT('XDELMN,AWIDTH,PWIDTH = ',3G15.7)
        CALL DPWRST('XXX','BUG ')
        IF(NP.GT.3)THEN
          DO9025I=1,3
            WRITE(ICOUT,9026)I,X(I),Y(I)
 9026       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','BUG ')
 9025     CONTINUE
          NPM2=NP-2
          DO9027I=NPM2,NP
            WRITE(ICOUT,9028)I,X(I),Y(I)
 9028       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','BUG ')
 9027     CONTINUE
        ENDIF
        WRITE(ICOUT,9031)IBA2SW,ABA2WI,ABA2BA
 9031   FORMAT('IBA2SW,ABA2WI,ABA2BA = ',A4,2X,2G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9032)IBA2BL,IBA2BC,PBA2BT
 9032   FORMAT('IBA2BL,IBA2BC,PBA2BT = ',A4,2X,A4,2X,G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9033)IBA2FS,IBA2FC,IBA2PT
 9033   FORMAT('IBA2FS,IBA2FC,IBA2PT = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9034)IBA2PL,IBA2PC,IBA2TY,IBA2DI,PBA2PS,PBA2PT
 9034   FORMAT('IBA2PL,IBA2PC,IBA2TY,IBA2DI,PBA2PS,PBA2PT = ',
     1         A4,2X,A4,2X,A4,2X,A4,2X,2E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9044)PXMIN,PXMAX,PYMIN,PYMAX
 9044   FORMAT('PXMIN,PXMAX,PYMIN,PYMAX= ',4G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9045)FX1MIN,FX1MAX,FY1MIN,FY1MAX
 9045   FORMAT('FX1MIN,FX1MAX,FY1MIN,FY1MAX= ',4G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9046)FXMIN,FXMAX,FYMIN,FYMAX
 9046   FORMAT('FXMIN,FXMAX,FYMIN,FYMAX= ',4G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9047)IX1TSC,IY1TSC
 9047   FORMAT('IX1TSC,IY1TSC = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9052)IFIG,IPATT,JPATT
 9052   FORMAT('IFIG,IPATT,JPATT = ',A4,2X,A4,I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9053)PTHICK,JTHICK,PTHIC2
 9053   FORMAT('PTHICK,JTHICK,PTHIC2 = ',G15.7,I8,G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9054)ICOL,JCOL,IDIR,ITYPE
 9054   FORMAT('ICOL,JCOL,IDIR,ITYPE = ',A4,I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9069)IBUGG4,ISUBG4,IERRG4
 9069   FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDRCH(Y,X,PY,PX,NP,PY2,PX2,NP2,X3D,
     1ICASPL,ICAS3D,
     1ISORSW,
CCCCC THE FOLLOWING ARGUMENT WAS ADDED MAY 1992 (JJF)
     1ARE2BA,
     1ICH2PA,ICH2FO,ICH2CA,ICH2JU,ICH2DI,ACH2AN,ICH2FI,ICH2CO,
     1PCH2HE,PCH2WI,PCH2TH,PCH2HO,PCH2VO,
     1ITEXSP,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1FX1MIN,FX1MAX,FY1MIN,FY1MAX,
     1IX1TSC,IY1TSC,
     1IMPSW2,AMPSCH,AMPSCW)
C
C     PURPOSE--FOR A GENERAL GRAPHICS DEVICE,
C              DRAW A CHARACTER TRACE OF Y(.) VERSUS X(.),
C              THAT IS, DRAW A SPECIFIED MARKER (= CHARACTER) TYPE
C              AT EACH OF THE PLOT POINTS.
C     NOTE--THE VARIABLES PY(.) AND PX(.) ARE DUMMY VARIABLES
C           WHICH ARE USED IN THE INTERMEDIATE CALCULATIONS
C           AND WHOSE DIMENSIONS ARE DEFINED (FOR EASY OF CHANGE)
C           BACK IN THE MAIN ROUTINE.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C     UPDATED         --DECEMBER  1987.  INDEPENDENT CONTROL OF CHAR WIDTH.
C     UPDATED         --SEPTEMBER 1988.  LOG/WEIBULL CHECK AS A SUBROUTINE
C     UPDATED         --SEPTEMBER 1988.  RENUMBER
C     UPDATED         --SEPTEMBER 1988.  IBUGG4 FOR IBUGPL
C     UPDATED         --JUNE      1990.  NORMAL PLOT
C     UPDATED         --MAY       1992.  ADD ARE2BA AS INPUT ARGUMENT
C     UPDATED         --DECEMBER  1996.  SIMPLIFY NORMAL PLOT
C     UPDATED         --SEPTEMBER 1999.  ARGUMENT LIST TO DPCLCH
C     UPDATED         --JANUARY   2000.  ADD X3D TO ARGUEMNT LIST
C     UPDATED         --DECEMBER  2006.  SUPPORT FOR TRILINEAR PLOTS
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAS3D
C
      CHARACTER*4 ISORSW
C
CCCCC CHARACTER*4 ICH2PA
      CHARACTER*16 ICH2PA
      CHARACTER*4 ICH2FO
      CHARACTER*4 ICH2CA
      CHARACTER*4 ICH2JU
      CHARACTER*4 ICH2DI
      CHARACTER*4 ICH2FI
      CHARACTER*4 ICH2CO
C
      CHARACTER*4 ITEXSP
C
      CHARACTER*4 IX1TSC
      CHARACTER*4 IY1TSC
C
      CHARACTER*4 IFIG
      CHARACTER*16 IPATT
      CHARACTER*4 IFONT
      CHARACTER*4 ICASE
      CHARACTER*4 IJUST
      CHARACTER*4 IDIR
      CHARACTER*4 IFILL
      CHARACTER*4 ICOL
C
      CHARACTER*16 ISYMBL
      CHARACTER*4 ISPAC
      CHARACTER*4 IMPSW2
C
      CHARACTER*4 ICASAX
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION X3D(*)
      DIMENSION PY(*)
      DIMENSION PX(*)
      DIMENSION PY2(*)
      DIMENSION PX2(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      FXMIN=FX1MIN
      FXMAX=FX1MAX
      FYMIN=FY1MIN
      FYMAX=FY1MAX
C
      AHUNDR=100.0
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRCH')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPDRCH--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)NP
   52   FORMAT('NP = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)ICASPL,ICAS3D
   53   FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        IF(NP.GT.3)THEN
          DO65I=1,3
          WRITE(ICOUT,66)I,X(I),Y(I),X3D(I)
   66     FORMAT('I,X(I),Y(I),X3D(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
   65   CONTINUE
        NPM2=NP-2
        DO67I=NPM2,NP
          WRITE(ICOUT,68)I,X(I),Y(I),X3D(I)
   68     FORMAT('I,X(I),Y(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
   67   CONTINUE
        ENDIF
        WRITE(ICOUT,70)ISORSW
   70   FORMAT('ISORSW = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,71)ARE2BA
   71   FORMAT('ARE2BA = ',E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,74)ICH2PA,ICH2FO,ICH2JU,ICH2DI
   74   FORMAT('ICH2PA,ICH2FO,ICH2JU,ICH2DI = ',A16,3(A4,1X))
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,79)ICH2FI,ICH2CO
   79   FORMAT('ICH2FI,ICH2CO = ',A4,1X,2X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,78)ACH2AN,PCH2HE,PCH2WI
   78   FORMAT('ACH2AN,PCH2HE,PCH2WI = ',3G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,83)PCH2TH,PCH2VO,PCH2HO
   83   FORMAT('PCH2TH,PCH2VO,PCH2HO= ',3E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,84)ITEXSP
   84   FORMAT('ITEXSP = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,85)PXMIN,PXMAX,PYMIN,PYMAX
   85   FORMAT('PXMIN,PXMAX,PYMIN,PYMAX= ',4E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,86)FX1MIN,FX1MAX,FY1MIN,FY1MAX
   86   FORMAT('FX1MIN,FX1MAX,FY1MIN,FY1MAX= ',4E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,87)IX1TSC,IY1TSC
   87   FORMAT('IX1TSC,IY1TSC = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,89)IBUGG4,ISUBG4,IERRG4
   89   FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *************************************************
C               **  STEP 10--                                  **
C               **  IF CALLED FOR, SORT THE DATA               **
C               **  ACCORDING TO THE HORIZONTAL AXIS VARIABLE  **
C               *************************************************
C
      IF(ISORSW.EQ.'OFF')GOTO1150
      IF(ICASPL.EQ.'PIEC')GOTO1150
      IF(ICASPL.EQ.'ROSE')GOTO1150
      IF(ICAS3D.EQ.'ON')GOTO1150
      IF(ICASPL.EQ.'TRPL')GOTO1150
C
      CALL SORTC(X,Y,NP,PX,PY)
      GOTO1190
C
 1150 CONTINUE
      DO1160I=1,NP
        PX(I)=X(I)
        PY(I)=Y(I)
 1160 CONTINUE
      GOTO1190
C
 1190 CONTINUE
C
C               ******************************************************
C               **  STEP 21--                                       **
C               **  IF A NON-LINEAR SCALE PLOT IS CALLED FOR,       **
C               **  CHECK THAT ALL   HORIZONTAL AXIS DATA POINTS    **
C               **  ARE IN VALID RANGE.                             **
C               **  IF A LOG SCALE PLOT IS CALLED FOR, CHECK THAT   **
C               **  ALL HORIZONTAL  AXIS DATA POINTS ARE > 0.  IF A **
C               **  WEIBULL SCALE PLOT IS CALLED FOR, OR IF A       **
C               **  NORMAL SCALE PLOT IS CALLED FOR,  (JUNE 1990)   **
C               **  CHECK THAT ALL   HORIZ. AXIS DATA POINTS ARE    **
C               **  STRICTLY > 0 AND STRICTLY < 100                 **
C               ******************************************************
C
      IF(IX1TSC.EQ.'LOG')THEN
        ICASAX='2DHO'
        CALL CKLOSC(PX,NP,ISORSW,ICASAX,ISUBG4,IBUGG4,IERRG4)
        IF(IERRG4.EQ.'YES')GOTO9000
      ELSEIF(IX1TSC.EQ.'WEIB' .OR. IX1TSC.EQ.'NORM')THEN
        ICASAX='2DHO'
        CALL CKPRSC(PX,NP,ISORSW,ICASAX,ISUBG4,IBUGG4,IERRG4)
        IF(IERRG4.EQ.'YES')GOTO9000
      ENDIF
C
C               ******************************************************
C               **  STEP 22--                                       **
C               **  IF A NON-LINEAR SCALE PLOT IS CALLED FOR, CHECK **
C               **  THAT ALL VERTICAL AXIS DATA POINTS ARE IN A     **
C               **  VALID RANGE.  IF A LOG SCALE PLOT IS CALLED     **
C               **  FOR, CHECK THAT ALL VERTICAL AXIS DATA POINTS   **
C               **  ARE > 0.  IF A WEIBULL SCALE PLOT IS CALLED     **
C               **  FOR, OR IF A NORMAL SCALE PLOT IS CALLED FOR,   **
C               **  (JUNE 1990)                                     **
C               **  CHECK THAT ALL VERTICAL AXIS DATA POINTS ARE    **
C               **  STRICTLY > 0 AND STRICTLY < 100                 **
C               ******************************************************
C
      IF(IY1TSC.EQ.'LOG')THEN
        ICASAX='2DVE'
        CALL CKLOSC(PY,NP,ISORSW,ICASAX,ISUBG4,IBUGG4,IERRG4)
        IF(IERRG4.EQ.'YES')GOTO9000
      ELSEIF(IY1TSC.EQ.'WEIB' .OR. IY1TSC.EQ.'NORM')THEN
        ICASAX='2DVE'
        CALL CKPRSC(PY,NP,ISORSW,ICASAX,ISUBG4,IBUGG4,IERRG4)
        IF(IERRG4.EQ.'YES')GOTO9000
      ENDIF
C
C               ******************************************
C               **  STEP 41--                           **
C               **  IF A LOG SCALE PLOT IS CALLED FOR,  **
C               **  TRANSFORM THE DATA                  **
C               ******************************************
C
      IF(IX1TSC.EQ.'LOG')THEN
        DO4115I=1,NP
          PX(I)=LOG10(PX(I))
 4115   CONTINUE
      ENDIF
C
      IF(IY1TSC.EQ.'LOG')THEN
        DO4125I=1,NP
          PY(I)=LOG10(PY(I))
 4125   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 42--                           **
C               **  IF A WEIBULL SCALE PLOT IS CALLED   **
C               **  FOR, TRANSFORM THE DATA             **
C               ******************************************
C
      IF(IX1TSC.EQ.'WEIB')THEN
        DO4215I=1,NP
          PX(I)=LOG(LOG(AHUNDR/(AHUNDR-PX(I))))
 4215   CONTINUE
      ENDIF
C
      IF(IY1TSC.EQ.'WEIB')THEN
        DO4225I=1,NP
          PY(I)=LOG(LOG(AHUNDR/(AHUNDR-PY(I))))
 4225   CONTINUE
      ENDIF
C
CCCCC THE FOLLOWING SECTION WAS ADDED JUNE 1990
C               ******************************************
C               **  STEP 43--                           **
C               **  IF A NORMAL SCALE PLOT IS CALLED    **
C               **  FOR, TRANSFORM THE DATA             **
C               ******************************************
C
      IF(IX1TSC.EQ.'NORM')THEN
        DO4315I=1,NP
          ARG=PX(I)/AHUNDR
          CALL NORPPF(ARG,PX(I))
 4315   CONTINUE
      ENDIF
C
      ABASE=ARE2BA
      IF(IY1TSC.EQ.'NORM')THEN
        IF(ABASE.NE.CPUMAX.AND.ABASE.GT.0.0.AND.ABASE.LT.AHUNDR)THEN
          ARG=ABASE/AHUNDR
          CALL NORPPF(ARG,ABASE2)
        ENDIF
        IF(ABASE.NE.CPUMAX.AND.ABASE.LE.0.0)ABASE2=0.1
        IF(ABASE.NE.CPUMAX.AND.ABASE.GE.AHUNDR)ABASE2=0.1
        ABASE=ABASE2
        DO4365I=1,NP
          ARG=PY(I)/AHUNDR
          CALL NORPPF(ARG,PY(I))
 4365   CONTINUE
      ENDIF
C
C               *****************************************************
C               **  STEP 50--                                      **
C               **  TRANSLATE THE DATA POINTS                      **
C               **  INTO STANDARDIZED (0.0 TO 100.0) COORDINATES.  **
C               *****************************************************
C
      FXMIN=FX1MIN
      FXMAX=FX1MAX
      IF(IX1TSC.EQ.'LOG')THEN
        FXMIN=LOG10(FX1MIN)
        FXMAX=LOG10(FX1MAX)
      ELSEIF(IX1TSC.EQ.'WEIB')THEN
        FXMIN=LOG(LOG(AHUNDR/(AHUNDR-FX1MIN)))
        FXMAX=LOG(LOG(AHUNDR/(AHUNDR-FX1MAX)))
      ELSEIF(IX1TSC.EQ.'NORM')THEN
         ARG=FX1MIN/AHUNDR
         CALL NORPPF(ARG,FXMIN)
         ARG=FX1MAX/AHUNDR
         CALL NORPPF(ARG,FXMAX)
      ENDIF
C
      FYMIN=FY1MIN
      FYMAX=FY1MAX
      IF(IY1TSC.EQ.'LOG')THEN
        FYMIN=LOG10(FY1MIN)
        FYMAX=LOG10(FY1MAX)
      ELSEIF(IY1TSC.EQ.'WEIB')THEN
        FYMIN=LOG(LOG(AHUNDR/(AHUNDR-FY1MIN)))
        FYMAX=LOG(LOG(AHUNDR/(AHUNDR-FY1MAX)))
      ELSEIF(IY1TSC.EQ.'NORM')THEN
        ARG=FY1MIN/AHUNDR
        CALL NORPPF(ARG,FYMIN)
        ARG=FY1MAX/AHUNDR
        CALL NORPPF(ARG,FYMAX)
      ENDIF
C
      FXRANG=FXMAX-FXMIN
      FYRANG=FYMAX-FYMIN
      PXRANG=PXMAX-PXMIN
      PYRANG=PYMAX-PYMIN
C
      IF(ICASPL.NE.'TRPL')THEN
        DO5100I=1,NP
          FXRATI=(PX(I)-FXMIN)/FXRANG
          FYRATI=(PY(I)-FYMIN)/FYRANG
          PX(I)=PXMIN+FXRATI*PXRANG+PCH2HO
          PY(I)=PYMIN+FYRATI*PYRANG+PCH2VO
 5100   CONTINUE
      ELSE
        AK2=SQRT(2.0)
        AK6=SQRT(6.0)
        PXHALF=(PXMIN+PXMAX)/2.0
        PYTHRD=PYMIN + (PYMAX-PYMIN)/3.0
C
        ASUM=X(1) + Y(1) + X3D(1)
C
        DO5160I=1,NP
          X1K=X(I)/ASUM
          X2K=Y(I)/ASUM
          X3K=X3D(I)/ASUM
          AH=(1.0/AK2)*(X3K-X2K)
          AV=(1.0/AK6)*(2.0 - 3.0*X2K - 3.0*X3K)
          PX(I)=PXHALF + (PXRANG/(2.0/AK2))*AH
          PY(I)=PYTHRD + (PYRANG/(3.0/AK6))*AV
 5160   CONTINUE
      ENDIF
C
C               ***********************************************
C               **  STEP 60--                                **
C               **  WRITE OUT THE MARKERS (PLOT CHARACTERS)  **
C               **  AT THE PLOT POINTS                       **
C               ***********************************************
C
      IFIG='GENE'
      IPATT=ICH2PA
      IFONT=ICH2FO
      ICASE=ICH2CA
      IJUST=ICH2JU
      IDIR=ICH2DI
      ANGLE=ACH2AN
      IFILL=ICH2FI
      ICOL=ICH2CO
      PHEIGH=PCH2HE
CCCCC PWIDTH=0.5*PHEIGH
CCCCC PWIDTH=PHEIGH*(ANUMVP/ANUMHP)      DECEMBER 1987  TEST
      PWIDTH=PCH2WI
      PVEGAP=PHEIGH/2.0
      PHOGAP=PWIDTH/2.0
      PTHICK=PCH2TH
      ISYMBL=ICH2PA
      ISPAC=ITEXSP
C
CCCCC ADD X3D TO CALL LIST.  JANUARY 2000.
      CALL DPCLCH(PX,PY,NP,PX2,PY2,NP2,X3D,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1ISORSW,
     1IFIG,IPATT,IFONT,ICASE,IJUST,IDIR,ANGLE,IFILL,ICOL,
     1PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1IMPSW2,AMPSCH,AMPSCW,
     1ISYMBL,ISPAC)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRCH')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDRCH--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)NP
 9012   FORMAT('NP = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)ICASPL,ICAS3D
 9013   FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        IF(NP.GE.1)THEN
          DO9025I=1,NP
            WRITE(ICOUT,9026)I,PX(I),PY(I)
 9026       FORMAT('I,PX(I),PY(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','BUG ')
 9025     CONTINUE
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDRFL(PXMIN,PYMIN,PXMAX,PYMAX,
     1ICASPL,ICAS3D,
     1IX1FSW,IX2FSW,IY1FSW,IY2FSW,
     1IX1FPA,IX2FPA,IY1FPA,IY2FPA,
     1IX1FCO,IX2FCO,IY1FCO,IY2FCO,
     1PFRATH)
C     PURPOSE--DRAW THE 4 (IF CALLED FOR) FRAME LINES ON THE SCREEN.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C     UPDATED         --SEPTEMBER 1987.  CALLS TO GRDRPL TO DPDRPL
C     UPDATED         --FEBRUARY  1988.  STAR PLOT
C     UPDATED         --JANUARY   1989.  MODIFY CALLS TO DPDRPL (ALAN)
C     UPDATED         --DECEMBER  2006.  TRILINEAR SCALES
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAS3D
C
      CHARACTER*4 IX1FSW
      CHARACTER*4 IX2FSW
      CHARACTER*4 IY1FSW
      CHARACTER*4 IY2FSW
C
      CHARACTER*4 IX1FPA
      CHARACTER*4 IX2FPA
      CHARACTER*4 IY1FPA
      CHARACTER*4 IY2FPA
C
      CHARACTER*4 IX1FCO
      CHARACTER*4 IX2FCO
      CHARACTER*4 IY1FCO
      CHARACTER*4 IY2FCO
C
      CHARACTER*4 IFIG
      CHARACTER*4 IPATT
      CHARACTER*4 ICOL
      CHARACTER*4 IFLAG
C
      DIMENSION PX(10)
      DIMENSION PY(10)
CCCCC DIMENSION PX3(10)
CCCCC DIMENSION PY3(10)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C
C-----START POINT-----------------------------------------------------
C
      NP=2
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRFL')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPDRFL--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)PXMIN,PYMIN,PXMAX,PYMAX
   52 FORMAT('PXMIN,PYMIN,PXMAX,PYMAX = ',4F10.5)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)ICASPL,ICAS3D
   53 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IX1FSW,IX2FSW,IY1FSW,IY2FSW
   55 FORMAT('IX1FSW,IX2FSW,IY1FSW,IY2FSW = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)IX1FPA,IX2FPA,IY1FPA,IY2FPA
   56 FORMAT('IX1FPA,IX2FPA,IY1FPA,IY2FPA = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,57)IX1FCO,IX2FCO,IY1FCO,IY2FCO
   57 FORMAT('IX1FCO,IX2FCO,IY1FCO,IY2FCO = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,58)PFRATH
   58 FORMAT('PFRATH = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,59)IBUGG4,ISUBG4,IERRG4
   59 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      IF(ICASPL.EQ.'PIEC')GOTO9000
      IF(ICASPL.EQ.'ROSE')GOTO9000
      IF(ICASPL.EQ.'STAR')GOTO9000
      IF(ICAS3D.EQ.'ON')GOTO9000
C
      IFIG='LINE'
      PTHICK=PFRATH
C
C               **************************************
C               **  STEP 1--                        **
C               **  DRAW OUT THE BOTTOM FRAME LINE  **
C               **  (IF CALLED FOR)                 **
C               **************************************
C
      IF(IX1FSW.EQ.'ON')GOTO1100
      GOTO1190
 1100 CONTINUE
      PX(1)=PXMIN
      PY(1)=PYMIN
      PX(2)=PXMAX
      PY(2)=PYMIN
      NP=2
      IPATT=IX1FPA
      ICOL=IX1FCO
      IFLAG='ON'
CCCCC CALL DPDRPL(PX,PY,NP,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 1190 CONTINUE
C
C               *************************************
C               **  STEP 2--                       **
C               **  DRAW OUT THE RIGHT FRAME LINE  **
C               **  (IF CALLED FOR)                **
C               *************************************
C
      IF(IY2FSW.EQ.'ON')GOTO1200
      GOTO1290
 1200 CONTINUE
      IF(ICASPL.EQ.'TRPL')THEN
        PX(1)=PXMAX
        PY(1)=PYMIN
        PX(2)=(PXMIN+PXMAX)/2.0
        PY(2)=PYMAX
      ELSE
        PX(1)=PXMAX
        PY(1)=PYMIN
        PX(2)=PXMAX
        PY(2)=PYMAX
      ENDIF
      NP=2
      IPATT=IY2FPA
      ICOL=IY2FCO
      IFLAG='ON'
CCCCC CALL DPDRPL(PX,PY,NP,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 1290 CONTINUE
C
C               ***********************************
C               **  STEP 3--                     **
C               **  DRAW OUT THE TOP FRAME LINE  **
C               **  (IF CALLED FOR)              **
C               ***********************************
C
      IF(IX2FSW.EQ.'ON')GOTO1300
      GOTO1390
 1300 CONTINUE
      IF(ICASPL.EQ.'TRPL')GOTO1390
      PX(1)=PXMAX
      PY(1)=PYMAX
      PX(2)=PXMIN
      PY(2)=PYMAX
      NP=2
      IPATT=IX2FPA
      ICOL=IX2FCO
      IFLAG='ON'
CCCCC CALL DPDRPL(PX,PY,NP,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 1390 CONTINUE
C
C               *************************************
C               **  STEP 4--                       **
C               **  DRAW OUT THE LEFT  FRAME LINE  **
C               **  (IF CALLED FOR)                **
C               *************************************
C
      IF(IY1FSW.EQ.'ON')GOTO1400
      GOTO1490
 1400 CONTINUE
      IF(ICASPL.EQ.'TRPL')THEN
        PX(1)=PXMIN
        PY(1)=PYMIN
        PX(2)=(PXMAX+PXMIN)/2.0
        PY(2)=PYMAX
      ELSE
        PX(1)=PXMIN
        PY(1)=PYMAX
        PX(2)=PXMIN
        PY(2)=PYMIN
      ENDIF
      NP=2
      IPATT=IY1FPA
      ICOL=IY1FCO
      IFLAG='ON'
CCCCC CALL DPDRPL(PX,PY,NP,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 1490 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRFL')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPDRFL--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)PXMIN,PYMIN,PXMAX,PYMAX
 9012 FORMAT('PXMIN,PYMIN,PXMAX,PYMAX = ',4F10.5)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)ICASPL,ICAS3D
 9013 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IX1FSW,IX2FSW,IY1FSW,IY2FSW
 9015 FORMAT('IX1FSW,IX2FSW,IY1FSW,IY2FSW = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)IX1FPA,IX2FPA,IY1FPA,IY2FPA
 9016 FORMAT('IX1FPA,IX2FPA,IY1FPA,IY2FPA = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)IX1FCO,IX2FCO,IY1FCO,IY2FCO
 9017 FORMAT('IX1FCO,IX2FCO,IY1FCO,IY2FCO = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9018)PFRATH
 9018 FORMAT('PFRATH = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9025)NP
 9025 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9026I=1,NP
      WRITE(ICOUT,9027)PX(I),PY(I)
 9027 FORMAT('PX(I),PY(I) = ',E15.7,E15.7)
      CALL DPWRST('XXX','BUG ')
 9026 CONTINUE
      WRITE(ICOUT,9029)IBUGG4,ISUBG4,IERRG4
 9029 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPDRFR(ICASPL,ICAS3D,
     1IVGMSW,IHGMSW)
C
C     PURPOSE--DRAW FRAME LINES (ALONG WITH TIC MARKS,
C              TIC MARK LABELS, AND GRID LINES
C              FOR A PLOT.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C     MODIFIED      --MAY         1990. ADD OFFSET ARGUMENTS TO DPDRGL
C     MODIFIED      --DECEMBER    2006. SUPPORT FOR TRI-LINEAR SCALES
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAS3D
C
      CHARACTER*4 IVGMSW
      CHARACTER*4 IHGMSW
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOPC.INC'
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRFR')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPDRFR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IMANUF,IMODEL
   52 FORMAT('IMANUF,IMODEL = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)ICASPL,ICAS3D
   53 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IBUGG4,ISUBG4,IERRG4
   55 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               *******************************
C               **  STEP 1--                 **
C               **  FILL  THE MARGIN REGION  **
C               *******************************
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRFR')THEN
        WRITE(ICOUT,8001)
 8001   FORMAT('BEFORE CALL DPFIMA')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(IERASW.EQ.'ON'.AND.IMARCO.NE.IBACCO)
     1CALL DPFIMA(PXMIN,PYMIN,PXMAX,PYMAX,
     1ICASPL,ICAS3D,
     1IMARCO)
C
C               ****************************
C               **  STEP 2--              **
C               **  DRAW THE FRAME LINES  **
C               ****************************
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRFR')THEN
        WRITE(ICOUT,8002)
 8002   FORMAT('BEFORE CALL DPDRFL')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      CALL DPDRFL(PXMIN,PYMIN,PXMAX,PYMAX,
     1ICASPL,ICAS3D,
     1IX1FSW,IX2FSW,IY1FSW,IY2FSW,
     1IX1FPA,IX2FPA,IY1FPA,IY2FPA,
     1IX1FCO,IX2FCO,IY1FCO,IY2FCO,
     1PFRATH)
C
C               **************************
C               **  STEP 3--            **
C               **  DRAW THE TIC MARKS  **
C               **************************
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRFR')THEN
        WRITE(ICOUT,8003)
 8003   FORMAT('BEFORE CALL DPDRTM')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      CALL DPDRTM(PXMIN,PYMIN,PXMAX,PYMAX,
     1FX1MIN,FY1MIN,FX1MAX,FY1MAX,
     1ICASPL,ICAS3D,
     1IX1FSW,IX2FSW,IY1FSW,IY2FSW,
     1IX1TSW,IX2TSW,IY1TSW,IY2TSW,
     1PX1COO,PX2COO,PY1COO,PY2COO,
     1NX1COO,NX2COO,NY1COO,NY2COO,
     1PX1CMN,PX2CMN,PY1CMN,PY2CMN,
     1NX1CMN,NX2CMN,NY1CMN,NY2CMN,
     1PX1TLE,PX2TLE,PY1TLE,PY2TLE,
     1PTICTH,PMNTFA,
     1IX1TJU,IX2TJU,IY1TJU,IY2TJU,
     1IX1TCO,IX2TCO,IY1TCO,IY2TCO)
C
C               *************************************
C               **  STEP 4--                       **
C               **  WRITE OUT THE TIC MARK LABELS  **
C               *************************************
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRFR')THEN
        WRITE(ICOUT,8004)
 8004   FORMAT('BEFORE CALL DPWRTL')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      CALL DPWRTL(ICASPL,ICAS3D)
C
C               ***************************
C               **  STEP 5--             **
C               **  DRAW THE GRID LINES  **
C               ***************************
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRFR')THEN
        WRITE(ICOUT,8005)
 8005   FORMAT('BEFORE CALL DPDRGL')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      CALL DPDRGL(PXMIN,PYMIN,PXMAX,PYMAX,
     1FX1MIN,FY1MIN,FX1MAX,FY1MAX,
     1ICASPL,ICAS3D,
     1IVGRSW,IHGRSW,
     1IVGMSW,IHGMSW,
     1PX1COO,PX2COO,PY1COO,PY2COO,
     1X1COOR,X2COOR,Y1COOR,Y2COOR,
     1NX1COO,NX2COO,NY1COO,NY2COO,
     1PX1CMN,PX2CMN,PY1CMN,PY2CMN,
     1X1COMN,X2COMN,Y1COMN,Y2COMN,
     1NX1CMN,NX2CMN,NY1CMN,NY2CMN,
     1IVGRPA,IHGRPA,IVGRCO,IHGRCO,
     1PVGRTH,PHGRTH,
     1PX1TOL,PX1TOR,PY1TOB,PY1TOT)
CCCC ABOVE LINE ADDED MAY, 1990 (FOR TIC OFFSETS)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRFR')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPDRFR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IMANUF,IMODEL
 9012 FORMAT('IMANUF,IMODEL = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)ICASPL,ICAS3D
 9013 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IBUGG4,ISUBG4,IERRG4
 9015 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPDRGL(PXMIN,PYMIN,PXMAX,PYMAX,
     1FXMIN,FYMIN,FXMAX,FYMAX,
     1ICASPL,ICAS3D,
     1IVGRSW,IHGRSW,
     1IVGMSW,IHGMSW,
     1PX1COO,PX2COO,PY1COO,PY2COO,
     1X1COOR,X2COOR,Y1COOR,Y2COOR,
     1NX1COO,NX2COO,NY1COO,NY2COO,
     1PX1CMN,PX2CMN,PY1CMN,PY2CMN,
     1X1COMN,X2COMN,Y1COMN,Y2COMN,
     1NX1CMN,NX2CMN,NY1CMN,NY2CMN,
     1IVGRPA,IHGRPA,IVGRCO,IHGRCO,
     1PVGRTH,PHGRTH,
     1PX1TOL,PX1TOR,PY1TOB,PY1TOT)
C
C     PURPOSE--DRAW GRID LINES ON A PLOT
C              FOR A GENERAL GRAPHICS DEVICE.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C     UPDATED         --SEPTEMBER 1987. GRDRPL TO DPDRPL
C     UPDATED         --FEBRUARY  1988. STAR PLOT
C     UPDATED         --MAY       1990. TIC OFFSETS
C     UPDATED         --SEPTEMBER 1990. MISSING HORIZ. GRID LINES
C     UPDATED         --DECEMBER  2006. SUPPORT FOR TRILINEAR PLOTS
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAS3D
C
      CHARACTER*4 IVGRSW
      CHARACTER*4 IHGRSW
      CHARACTER*4 IVGMSW
      CHARACTER*4 IHGMSW
      CHARACTER*4 IVGRPA
      CHARACTER*4 IHGRPA
      CHARACTER*4 IVGRCO
      CHARACTER*4 IHGRCO
C
      CHARACTER*4 ITYPE
      CHARACTER*4 IFIG
      CHARACTER*4 IPATT
      CHARACTER*4 ICOL
CCCCC CHARACTER*4 IHORPA
CCCCC CHARACTER*4 IVERPA
CCCCC CHARACTER*4 IDUPPA
CCCCC CHARACTER*4 IDDOPA
      CHARACTER*4 IFLAG
C
      DIMENSION PX1COO(*)
      DIMENSION PX2COO(*)
      DIMENSION PY1COO(*)
      DIMENSION PY2COO(*)
C
      DIMENSION X1COOR(*)
      DIMENSION X2COOR(*)
      DIMENSION Y1COOR(*)
      DIMENSION Y2COOR(*)
C
      DIMENSION PX1CMN(*)
      DIMENSION PX2CMN(*)
      DIMENSION PY1CMN(*)
      DIMENSION PY2CMN(*)
C
      DIMENSION X1COMN(*)
      DIMENSION X2COMN(*)
      DIMENSION Y1COMN(*)
      DIMENSION Y2COMN(*)
C
      DIMENSION PX(100)
      DIMENSION PY(100)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRGL')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPDRGL--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)PXMIN,PYMIN,PXMAX,PYMAX
   52 FORMAT('PXMIN,PYMIN,PXMAX,PYMAX = ',4F10.5)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)ICASPL,ICAS3D
   53 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IVGRSW,IHGRSW,IVGMSW,IHGMSW
   54 FORMAT('IVGRSW,IHGRSW,IVGMSW,IHGMSW = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IVGRPA,IHGRPA
   55 FORMAT('IVGRPA,IHGRPA = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)PVGRTH,PHGRTH
   56 FORMAT('PVGRTH,PHGRTH = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,57)IVGRCO,IHGRCO
   57 FORMAT('IVGRCO,IHGRCO = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,60)NX1COO,NX2COO,NY1COO,NY2COO
   60 FORMAT('NX1COO,NX2COO,NY1COO,NY2COO = ',4I8)
      CALL DPWRST('XXX','BUG ')
C
      IF(NX1COO.LE.0)GOTO69
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      DO61I=1,NX1COO
      WRITE(ICOUT,62)I,PX1COO(I),X1COOR(I)
   62 FORMAT('I,PX1COO(I),X1COOR(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
   61 CONTINUE
   69 CONTINUE
C
      IF(NX2COO.LE.0)GOTO79
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      DO71I=1,NX2COO
      WRITE(ICOUT,72)I,PX2COO(I),X2COOR(I)
   72 FORMAT('I,PX2COO(I),X2COOR(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
   71 CONTINUE
   79 CONTINUE
C
      IF(NY1COO.LE.0)GOTO89
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      DO81I=1,NY1COO
      WRITE(ICOUT,82)I,PY1COO(I),Y1COOR(I)
   82 FORMAT('I,PY1COO(I),Y1COOR(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
   81 CONTINUE
   89 CONTINUE
C
      IF(NY2COO.LE.0)GOTO99
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      DO91I=1,NY2COO
      WRITE(ICOUT,92)I,PY2COO(I),Y2COOR(I)
   92 FORMAT('I,PY2COO(I),Y2COOR(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
   91 CONTINUE
   99 CONTINUE
C
      WRITE(ICOUT,88)IBUGG4,ISUBG4,IERRG4
   88 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
C
   90 CONTINUE
C
      IF(ICASPL.EQ.'PIEC')GOTO9000
      IF(ICASPL.EQ.'ROSE')GOTO9000
      IF(ICASPL.EQ.'STAR')GOTO9000
      IF(ICAS3D.EQ.'ON')GOTO9000
      IF(ICASPL.EQ.'TRPL')GOTO2000
C
      ITYPE='LINE'
C
C               ***************************************************
C               **  STEP 1--                                     **
C               **  TRANSLATE THE VERTICAL GRID LINE LINE PATTERN            **
C               **  INTO A NUMBER WHICH CAN BE UNDERSTOOD        **
C               **  BY THE GRAPHICS DEVICE.                      **
C               ***************************************************
C
      IPATT=IVGRPA
CCCCC CALL GRTRPA(ITYPE,IPATT,PXSPA,PYSPA,
CCCCC1JPATT,IHORPA,IVERPA,IDUPPA,IDDOPA,PXSPA2,PYSPA2)
C
C               **********************************
C               **  STEP 2--                    **
C               **  SET THE LINE PATTERN TO SOLID  **
C               **  ON THE GRAPHICS DEVICE.     **
C               **********************************
C
CCCCC CALL GRSEPA(ITYPE,IPATT,PXSPA,PYSPA,
CCCCC1JPATT,IHORPA,IVERPA,IDUPPA,IDDOPA,PXSPA2,PYSPA2)
C
C               **********************************************
C               **  STEP 3--                                  **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE VERTICAL GRID LINE   COLOR
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      ICOL=IVGRCO
CCCCC CALL GRTRCO(ITYPE,ICOL,JCOL)
C
C               *******************************
C               **  STEP 4--                 **
C               **  SET THE  COLOR       **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
CCCCC CALL GRSECO(ITYPE,ICOL,JCOL)
C
C               **********************************************
C               **  STEP 5--                                **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE VERTICAL GRID LINE THICKNESS                   **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      PTHICK=PVGRTH
CCCCC CALL GRTRTH(ITYPE,PTHICK,JTHICK,PTHIC2)
C
C               *******************************
C               **  STEP 6--                 **
C               **  SET THE LINE THICKNESS   **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
CCCCC CALL GRSETH(ITYPE,PTHICK,JTHICK,PTHIC2)
C
C               **********************************
C               **  STEP 7--                    **
C               **  DRAW VERTICAL   GRID LINES  **
C               **********************************
C
      IFIG='LINE'
      PY(1)=PYMIN
      PY(2)=PYMAX
C
      IF(IVGRSW.EQ.'OFF')GOTO1140
      IF(NX1COO.LE.2)GOTO1140
CCCCC MAY, 1990.  IF TIC OFFSETS ARE NON-ZER0, DRAW THE FIRST AND
CCCCC LAST GRID LINES (WHICH PREVIOUSLY WOULD ALWAYS BE ON THE FRAME.
      EPS=0.000001
      IMIN=2
      IF(ABS(PX1TOL).GE.EPS)IMIN=1
      IMAX=NX1COO-1
      IF(ABS(PX1TOR).GE.EPS)IMAX=NX1COO
      NP=2
CCCCC IMAX=NX1COO-1
      IFLAG='ON'
CCCCC DO1110I=2,IMAX
      DO1110I=IMIN,IMAX
      PX(1)=PX1COO(I)
      PX(2)=PX1COO(I)
CCCCC CALL GRDRPL(PX,PY,NP,
CCCCC1IFIG,IPATT,PTHICK,ICOL,
CCCCC1JPATT,JTHICK,PTHIC2,JCOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
      IFLAG='OFF'
 1110 CONTINUE
 1140 CONTINUE
C
      IF(IVGMSW.EQ.'OFF')GOTO1180
      IF(NX1CMN.LE.2)GOTO1180
      NP=2
      IMAX=NX1CMN
      IFLAG='ON'
      DO1150I=1,IMAX
      PX(1)=PX1CMN(I)
      PX(2)=PX1CMN(I)
CCCCC CALL GRDRPL(PX,PY,NP,
CCCCC1IFIG,IPATT,PTHICK,ICOL,
CCCCC1JPATT,JTHICK,PTHIC2,JCOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
      IFLAG='OFF'
 1150 CONTINUE
 1180 CONTINUE
C
 1190 CONTINUE
C
C               ***************************************************
C               **  STEP 11--                                    **
C               **  TRANSLATE THE HORIZONTAL GRID LINE LINE PATTERN            *
C               **  INTO A NUMBER WHICH CAN BE UNDERSTOOD        **
C               **  BY THE GRAPHICS DEVICE.                      **
C               ***************************************************
C
      IPATT=IHGRPA
CCCCC CALL GRTRPA(ITYPE,IPATT,PXSPA,PYSPA,
CCCCC1JPATT,IHORPA,IVERPA,IDUPPA,IDDOPA,PXSPA2,PYSPA2)
C
C               **********************************
C               **  STEP 12--                    **
C               **  SET THE LINE PATTERN TO SOLID  **
C               **  ON THE GRAPHICS DEVICE.     **
C               **********************************
C
CCCCC CALL GRSEPA(ITYPE,IPATT,PXSPA,PYSPA,
CCCCC1JPATT,IHORPA,IVERPA,IDUPPA,IDDOPA,PXSPA2,PYSPA2)
C
C               **********************************************
C               **  STEP 13--                                  **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE HORIZONTAL GRID LINE   COLOR
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      ICOL=IHGRCO
CCCCC CALL GRTRCO(ITYPE,ICOL,JCOL)
C
C               *******************************
C               **  STEP 14--                **
C               **  SET THE  COLOR       **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
CCCCC CALL GRSECO(ITYPE,ICOL,JCOL)
C
C               **********************************************
C               **  STEP 15--                               **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE HORIZONAL GRID LINE THICKNESS                   **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      PTHICK=PHGRTH
CCCCC CALL GRTRTH(ITYPE,PTHICK,JTHICK,PTHIC2)
C
C               *******************************
C               **  STEP 16--                 **
C               **  SET THE LINE THICKNESS   **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
CCCCC CALL GRSETH(ITYPE,PTHICK,JTHICK,PTHIC2)
C
C               **********************************
C               **  STEP 17--                   **
C               **  DRAW HORIZONTAL GRID LINES  **
C               **********************************
C
      IFIG='LINE'
      PX(1)=PXMIN
      PX(2)=PXMAX
C
      IF(IHGRSW.EQ.'OFF')GOTO1240
      IF(NY1COO.LE.2)GOTO1240
      NP=2
CCCCC MAY, 1990.  IF TIC OFFSETS ARE NON-ZER0, DRAW THE FIRST AND
CCCCC LAST GRID LINES (WHICH PREVIOUSLY WOULD ALWAYS BE ON THE FRAME.
      EPS=0.000001
      IMIN=2
      IF(ABS(PY1TOB).GE.EPS)IMIN=1
CCCCC THE FOLLOWING LINE WAS FIXED SEPTEMBER 1990
CCCCC IMAX=NX1COO-1
      IMAX=NY1COO-1
      IF(ABS(PY1TOT).GE.EPS)IMAX=NY1COO
CCCCC IMAX=NY1COO-1
      IFLAG='ON'
CCCCC DO1210I=2,IMAX
      DO1210I=IMIN,IMAX
      PY(1)=PY1COO(I)
      PY(2)=PY1COO(I)
CCCCC CALL GRDRPL(PX,PY,NP,
CCCCC1IFIG,IPATT,PTHICK,ICOL,
CCCCC1JPATT,JTHICK,PTHIC2,JCOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
      IFLAG='OFF'
 1210 CONTINUE
 1240 CONTINUE
C
      IF(IHGMSW.EQ.'OFF')GOTO1280
      IF(NY1CMN.LE.2)GOTO1280
      NP=2
      IMAX=NY1CMN
      IFLAG='ON'
      DO1250I=1,IMAX
      PY(1)=PY1CMN(I)
      PY(2)=PY1CMN(I)
CCCCC CALL GRDRPL(PX,PY,NP,
CCCCC1IFIG,IPATT,PTHICK,ICOL,
CCCCC1JPATT,JTHICK,PTHIC2,JCOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
      IFLAG='OFF'
 1250 CONTINUE
 1280 CONTINUE
C
 1290 CONTINUE
      GOTO9000
C
 2000 CONTINUE
C
C               *****************************************
C               **  STEP 20--                          **
C               **  DRAW GRID LINES FOR TRILINEAR PLOT **
C               *****************************************
C
      IF(IVGRSW.EQ.'OFF' .OR. IHGRSW.EQ.'OFF')GOTO9000
C
      ITYPE='LINE'
      IPATT=IHGRPA
      ICOL=IHGRCO
      PTHICK=PHGRTH
C
      IFIG='LINE'
C
      AMIN=0.0
CCCCC AMAX=FXMAX
CCCCC GRDINC=(AMAX-AMIN)/REAL(NX1COO-1)
      AMAX=1.0
      GRDINC=(1.0-0.0)/REAL(NX1COO-1)
      PXRANG=PXMAX - PXMIN
      PYRANG=PYMAX - PYMIN
C
C               *****************************************
C               **  STEP 20.A--                        **
C               **  DRAW GRID LINES FOR X1 AXIS        **
C               *****************************************
C
C
      NP2=2
      IFLAG='ON'
      DO2010I=2,NX1COO-1
        XDUMMY=AMIN + (I-1)*GRDINC
        PXSTRT=PXMIN + 0.5*PXRANG*XDUMMY
        PYSTRT=PYMIN + PYRANG*XDUMMY
        PXSTOP=PXMAX - (PXSTRT-PXMIN)
        PYSTOP=PYSTRT
        PX(1)=PXSTRT
        PX(2)=PXSTOP
        PY(1)=PYSTRT
        PY(2)=PYSTOP
        CALL DPDRPL(PX,PY,NP2,
     1              IFIG,IPATT,PTHICK,ICOL,
     1              JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
        IFLAG='OFF'
 2010 CONTINUE
C
C               *****************************************
C               **  STEP 20.B--                        **
C               **  DRAW GRID LINES FOR X2 AXIS        **
C               *****************************************
C
C
      NP2=2
      DO2020I=2,NX1COO-1
        XDUMMY=AMIN + (I-1)*GRDINC
        PXSTRT=PXMAX - PXRANG*XDUMMY
        PYSTRT=PYMIN
        PXSTOP=PXSTRT - 0.5*PXRANG*(AMAX-XDUMMY)
        PYSTOP=PYSTRT + PYRANG*(AMAX-XDUMMY)
        PX(1)=PXSTRT
        PX(2)=PXSTOP
        PY(1)=PYSTRT
        PY(2)=PYSTOP
        CALL DPDRPL(PX,PY,NP2,
     1              IFIG,IPATT,PTHICK,ICOL,
     1              JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 2020 CONTINUE
C
C               *****************************************
C               **  STEP 20.C--                        **
C               **  DRAW GRID LINES FOR X3 AXIS        **
C               *****************************************
C
      NP2=2
      DO2030I=2,NX1COO-1
        XDUMMY=AMIN + (I-1)*GRDINC
        PXSTRT=PXMIN + PXRANG*XDUMMY
        PYSTRT=PYMIN
        PXSTOP=PXSTRT + 0.5*PXRANG*(AMAX-XDUMMY)
        PYSTOP=PYSTRT + PYRANG*(AMAX-XDUMMY)
        PX(1)=PXSTRT
        PX(2)=PXSTOP
        PY(1)=PYSTRT
        PY(2)=PYSTOP
        CALL DPDRPL(PX,PY,NP2,
     1              IFIG,IPATT,PTHICK,ICOL,
     1              JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 2030 CONTINUE
      IFLAG='ON'
C
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRGL')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPDRGL--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)ICASPL,ICAS3D
 9013 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9019)IPATT,JPATT
 9019 FORMAT('IPATT,JPATT = ',A4,2X,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9020)PTHICK,JTHICK,PTHIC2
 9020 FORMAT('PTHICK,JTHICK,PTHIC2 = ',E15.7,2X,A4,2X,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)ICOL,JCOL
 9021 FORMAT('ICOL,JCOL = ',A4,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9022)ITYPE
 9022 FORMAT('ITYPE = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9029)IBUGG4,ISUBG4,IERRG4
 9029 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPDRIM(PX,PY,YRED,YBLUE,YGREEN,YALPHA,NP,
     1ICASCO,PHEIGH)
C
C     PURPOSE--FOR A GENERAL GRAPHICS DEVICE, DRAW AN IMAGE.  THE
C              ARRAYS PX AND PY CONTAIN THE ROW-ID AND COLUMN-ID
C              OF THE IMAGE, RESPECTIVELY.  THE ARRAYS YRED, YBLUE,
C              AND YGREEN CONTAIN THE RED, BLUE, AND GREEN COMPONENTS,
C              RESPECTIVELY, ON A (0,1) SCALE.  THE YALPHA ARRAY IS
C              RESERVED FOR FUTURE DEVELOPMENT (FOR AN ALPHA CHANNEL).
C              THE SCALING FROM (0,1) TO AN APPROPRIATE 8-BIT
C              (I.E., 0 TO 255) OR 16-BIT (I.E., 0 TO 16535) SCALE
C              WILL BE HANDLED FOR SPECIFIC DEVICES IN THE GRDRIM
C              ROUTINE.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008.3
C     ORIGINAL VERSION--MARCH    2008.
C
C-----NON-COMMON VARIABLES (GRAPHICS)-----------------------------------
C
      CHARACTER*4 ICASCO
      CHARACTER*4 IERROR
C
      DIMENSION PX(*)
      DIMENSION PY(*)
      DIMENSION YRED(*)
      DIMENSION YBLUE(*)
      DIMENSION YGREEN(*)
      DIMENSION YALPHA(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOPC.INC'
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='OFF'
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRIM')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPDRIM--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,54)NP
   54   FORMAT('NP = ',I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,MAX(NP,1000)
          WRITE(ICOUT,56)I,PX(I),PY(I),YRED(I),YGREEN(I),YBLUE(I)
   56     FORMAT('I,PX(I),PY(I),YRED(I),YGREEN(I),YBLUE(I) = ',
     1           I8,5F10.5)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        WRITE(ICOUT,57)PHEIGH
   57   FORMAT('PHEIGH = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,59)IBUGG4,ISUBG4,IERRG4
   59   FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *******************************
C               **  STEP 19--                **
C               **  DRAW OUT THE POLYMARKER  **
C               *******************************
C
      CALL GRDRIM(PX,PY,NP,
     1ICASCO,PHEIGH,
     1YRED,YBLUE,YGREEN,YALPHA,
     1PXMIN,PYMIN,PXMAX,PYMAX)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRIM')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDRIM--')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
C  MODIFIED SEPTEMBER, 1987
CCCCC SUBROUTINE DPDRPL(PX,PY,NP,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
C
C     PURPOSE--FOR A GENERAL GRAPHICS DEVICE,
C              DRAW THE POLYLINE WHOSE COORDINATES
C              ARE GIVEN IN (PX(.),PY(.)) ,
C              AND WHICH HAS SPECIFIED
C              PATTERN, THICKNESS, AND COLOR.
C     NOTE--THE COORDINATES IN (PX(.),PY(.)) ARE IN
C           STANDARDIZED (0.0 TO 100.0) UNITS.
C     NOTE--THERE ARE NP SUCH COORDINATE PAIRS.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-921-369011
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C     UPDATED         --JANUARY   1989.  MODIFED CALL LIST (ALAN)
C     UPDATED         --JANUARY   1989.  MODIFIED LINE THICKNESS ALGOR. (ALAN)
C     UPDATED         --MAY       1989.  DEBUG FOR IFLAG
C     UPDATED         --MAY       1995.  USE EQUIVALENCE
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------------
C
      CHARACTER*4 IFIG
      CHARACTER*4 IPATT
      CHARACTER*4 ICOL
C
      CHARACTER*4 ITYPE
      CHARACTER*4 IHORPA
      CHARACTER*4 IVERPA
      CHARACTER*4 IDUPPA
      CHARACTER*4 IDDOPA
C
      CHARACTER*4 IFLAG
C
      DIMENSION PX(*)
      DIMENSION PY(*)
CCCCC DIMENSION PX3(*)
CCCCC DIMENSION PY3(*)
      INCLUDE 'DPCOPA.INC'
      DIMENSION PX3(MAXPOP)
      DIMENSION PY3(MAXPOP)
CCCCC FOLLOWING LINES ADDED JUNE, 1990
      INCLUDE 'DPCOZ2.INC'
CCCCC EQUIVALENCE (G2RBAG(IGAR42),PX3(1))
CCCCC EQUIVALENCE (G2RBAG(IGAR43),PY3(1))
CCCCC END CHANGE
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRPL')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPDRPL--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)MAX(10,NP)
   54 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,NP
      WRITE(ICOUT,56)PX(I),PY(I)
   56 FORMAT('PX(I),PY(I) = ',E15.7,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
      WRITE(ICOUT,58)IFIG,IPATT,PTHICK,ICOL
   58 FORMAT('IFIG,IPATT,PTHICK,ICOL = ',A4,2X,A4,2X,E15.7,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,59)JTHICK,PTHICK,PTHIC2
   59 FORMAT('JTHICK,PTHIC,PTHIC2 = ',I8,2G15.7)
      CALL DPWRST('XXX','BUG ')
CCCCC THE FOLLOWING 2 LINES WERE ADDED MAY 1992
      WRITE(ICOUT,62)IFLAG
   62 FORMAT('IFLAG = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,69)IBUGG4,ISUBG4,IERRG4
   69 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C  SEPTEMMBER, 1987 - SET ATTRIBUTES ACCORDING TO FLAG
      NP3=NP
      IF(IFLAG.EQ.'OFF')GOTO700
C
      ITYPE='LINE'
C
C               **********************************************
C               **  STEP 1--                                **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE LINE PATTERN                     **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      CALL GRTRPA(ITYPE,IPATT,PXSPA,PYSPA,
     1JPATT,IHORPA,IVERPA,IDUPPA,IDDOPA,PXSPA2,PYSPA2)
C
C               *******************************
C               **  STEP 2--                 **
C               **  SET THE LINE PATTERN     **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
      CALL GRSEPA(ITYPE,IPATT,PXSPA,PYSPA,
     1JPATT,IHORPA,IVERPA,IDUPPA,IDDOPA,PXSPA2,PYSPA2)
C
C               **********************************************
C               **  STEP 3--                                **
C               **  TRANSLATE THE  DESIRED                  **
C               **  LINE THICKNESS                          **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      CALL GRTRTH(ITYPE,PTHICK,JTHICK,PTHIC2)
C
C               *******************************
C               **  STEP 4--                 **
C               **  SET THE LINE THICKNESS   **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
      CALL GRSETH(ITYPE,PTHICK,JTHICK,PTHIC2)
C
C               **********************************************
C               **  STEP 901--                                **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE LINE COLOR                       **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      CALL GRTRCO(ITYPE,ICOL,JCOL)
C
C               *******************************
C               **  STEP 6--                 **
C               **  SET THE LINE COLOR       **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
      CALL GRSECO(ITYPE,ICOL,JCOL)
C
C               *****************************
C               **  STEP 7--               **
C               **  DRAW OUT THE POLYLINE  **
C               *****************************
C
  700 CONTINUE
      IF(IFLAG.EQ.'LOOP')GOTO800
      CALL GRDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL)
C
CCCCC PPENTH=0.1
CCCCC NLOOP=((PTHICK/(2.0*PPENTH))-1.0)+0.1
C
CCCCC IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRPL')
CCCCC1WRITE(ICOUT,1510)PPENTH,NLOOP
C1510 FORMAT('PPENTH,NLOOP = ',E15.7,I8)
CCCCC IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRPL')
CCCCC1CALL DPWRST('XXX','BUG ')
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRPL')THEN
        WRITE(ICOUT,1510)PTHIC2,JTHICK
 1510   FORMAT('PTHIC2,JTICK = ',E15.7,I8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
  800 CONTINUE
      NLOOP=JTHICK
      PPENTH=PTHIC2
C
      IF(NLOOP.LE.0)GOTO1590
      DO1520I=1,NLOOP
      AI=I
C
      DEL=PPENTH*AI
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRPL')THEN
        WRITE(ICOUT,1522)I,NLOOP,DEL
 1522   FORMAT('I,NLOOP,DEL = ',2I8,G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
      CALL GRDEPL(PX,PY,NP,DEL,PX3,PY3,NP3)
      CALL GRDRPL(PX3,PY3,NP3,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL)
C
      DEL=(-PPENTH*AI)
      CALL GRDEPL(PX,PY,NP,DEL,PX3,PY3,NP3)
      CALL GRDRPL(PX3,PY3,NP3,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL)
C
 1520 CONTINUE
C
 1590 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRPL')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPDRPL--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)NP
 9014 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9015I=1,MAX(10,NP)
      WRITE(ICOUT,9016)PX(I),PY(I)
 9016 FORMAT('PX(I),PY(I) = ',E15.7,E15.7)
      CALL DPWRST('XXX','BUG ')
 9015 CONTINUE
      WRITE(ICOUT,9018)IFIG
 9018 FORMAT('IFIG = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9019)IPATT,JPATT
 9019 FORMAT('IPATT,JPATT = ',A4,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9020)PTHICK,JTHICK,PTHIC2
 9020 FORMAT('PTHICK,JTHICK,PTHIC2 = ',E15.7,I8,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)ICOL,JCOL
 9021 FORMAT('ICOL,JCOL = ',A4,I8)
      CALL DPWRST('XXX','BUG ')
CCCCC THE FOLLOWING 2 LINES WERE ADDED MAY 1992
      WRITE(ICOUT,9022)IFLAG
 9022 FORMAT('IFLAG = ',A4)
      CALL DPWRST('XXX','BUG ')
 
      WRITE(ICOUT,9023)ITYPE
 9023 FORMAT('ITYPE = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9024)PPENTH,DEL,NLOOP
 9024 FORMAT('PPENTH,DEL,NLOOP = ',2E15.7,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9029)IBUGG4,ISUBG4,IERRG4
 9029 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPDRPM(PX,PY,NP,X3D2,IJUNK2,IROWID,IROWLB,
     1IFIG,IPATT,IFONT,ICASE,IJUST,IDIR,ANGLE,IFILL,ICOL,
     1PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1IMPSW2,AMPSCH,AMPSCW,
     1ISYMBL,ISPAC)
C
C     PURPOSE--FOR A GENERAL GRAPHICS DEVICE,
C              DRAW THE POLYMARKERS WHOSE COORDINATES
C              ARE GIVEN IN (PX(.),PY(.)) ,
C              AND WHICH HAS SPECIFIED
C              MARKER TYPE, SIZE, FONT, JUSTIFICATION, COLOR, ANGLE,
C              AND LINE THICKNESS.
C     NOTE--THE COORDINATES IN (PX(.),PY(.)) ARE IN
C           STANDARDIZED (0.0 TO 100.0) UNITS.
C     NOTE--THERE ARE NP SUCH COORDINATE PAIRS.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C     UPDATED       --NOVEMBER   1995.  SUPPORT FOR CASE ASIS
C     UPDATED       --SEPTEMBER  1999.  GRDRPM ARGUMENT LIST
C     UPDATED       --DECEMBER   1999.  SUPPORT SPECIAL PLOTTING
C                                       (FOR VALUE OF POINT,ETC.)
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------------
C
      CHARACTER*4 ITYPE
C
      CHARACTER*4 IFIG
      CHARACTER*16 IPATT
      CHARACTER*4 IFONT
      CHARACTER*4 ICASE
      CHARACTER*4 IJUST
      CHARACTER*4 IDIR
      CHARACTER*4 IFILL
      CHARACTER*4 ICOL
C
      CHARACTER*16 ISYMBL
      CHARACTER*4 ISPAC
      CHARACTER*4 IMPSW2
C
      CHARACTER*4 IHORPA
      CHARACTER*4 IVERPA
      CHARACTER*4 IDUPPA
      CHARACTER*4 IDDOPA
C
      CHARACTER*4 ITYPSV
C
      CHARACTER*4 ICTEMP
      CHARACTER*4 ICTEXT
      CHARACTER*4 IERROR
C
      CHARACTER*24 IROWLB
C
      DIMENSION ICTEXT(50)
C
      DIMENSION IROWID(*)
      DIMENSION IROWLB(*)
      DIMENSION IJUNK2(*)
      DIMENSION PX(*)
      DIMENSION PY(*)
      DIMENSION X3D2(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='OFF'
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRPM')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPDRPM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)NP
   54 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,NP
      WRITE(ICOUT,56)PX(I),PY(I)
   56 FORMAT('PX(I),PY(I) = ',E15.7,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
      WRITE(ICOUT,58)IFIG,IFONT,IJUST,IFILL,ICOL,IPATT
   58 FORMAT('IFIG,IFONT,IJUST,IFILL,ICOL,IPATT = ',5(A4,1X),A16)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,64)IDIR,ANGLE,PTHICK
   64 FORMAT('IDIR,ANGLE,PTHICK = ',A4,2X,2G15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,67)PHEIGH,PWIDTH,PVEGAP,PHOGAP
   67 FORMAT('PHEIGH,PWIDTH,PVEGAP,PHOGAP = ',4G15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,71)ISYMBL,ISPAC
   71 FORMAT('ISYMBL,ISPAC = ',A16,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,79)IBUGG4,ISUBG4,IERRG4
   79 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
CCCCC DECEMBER 1999.  SUPPORT SPECIAL CASES:
CCCCC 1) XVAL  = X-COORDINATE OF VARIABLE
CCCCC 2) YVAL  = Y-COORDINATE OF VARIABLE
CCCCC 3) XYVA  = (X,Y) OF VARIABLE
CCCCC 4) ROWI  = ROW-ID
CCCCC 5) ROWL  = ROW-LABEL
CCCCC 6) TVAL  = TAG-VALUE (SPECIAL CASE FOR CROSS-TABULATE PLOT,
CCCCC            BUT MAY HAVE OTHER USES AS WELL)
CCCCC 7) ZVAL  = USE VALUE IN X3D2
C
      IF(
     1(ISYMBL(1:1).EQ.'R'.OR.ISYMBL(1:1).EQ.'r').AND.
     1(ISYMBL(2:2).EQ.'O'.OR.ISYMBL(2:2).EQ.'o').AND.
     1(ISYMBL(3:3).EQ.'W'.OR.ISYMBL(3:3).EQ.'w').AND.
     1(ISYMBL(4:4).EQ.'I'.OR.ISYMBL(4:4).EQ.'i')
     1)THEN
        DO1010I=1,NP
          IROW=IROWID(I)
          AROW=REAL(IROW)
          NCTEXT=0
          DO1015J=1,50
            ICTEXT(J)=' '
 1015     CONTINUE
          CALL DPCONH(IROW,AROW,ICTEXT,NH,IBUGG4,IERROR)
          NCTEXT=NH
          PX1=PX(I)
          PY1=PY(I)
          CALL DPWRTE(PX1,PY1,ICTEXT,NCTEXT,
     1                IFONT,ICASE,IJUST,IDIR,ANGLE,IFILL,ICOL,
     1                PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1                ISYMBL,ISPAC,
     1                IMPSW2,AMPSCH,AMPSCW,
     1                PX99,PY99)
 1010   CONTINUE
        GOTO9000
      ELSEIF(
     1(ISYMBL(1:1).EQ.'R'.OR.ISYMBL(1:1).EQ.'r').AND.
     1(ISYMBL(2:2).EQ.'O'.OR.ISYMBL(2:2).EQ.'o').AND.
     1(ISYMBL(3:3).EQ.'W'.OR.ISYMBL(3:3).EQ.'w').AND.
     1(ISYMBL(4:4).EQ.'L'.OR.ISYMBL(4:4).EQ.'l')
     1)THEN
        DO1020I=1,NP
          ITEMP=IROWID(I)
C
C         2012/08: FOR BLANK ROW LABEL, JUST LEAVE BLANK
C
          IF(IROWLB(ITEMP).EQ.' ')THEN
            GOTO9000
CCCCC       IROW=IROWID(I)
CCCCC       AROW=REAL(IROW)
CCCCC       NCTEXT=0
CCCCC       DO1025J=1,50
CCCCC         ICTEXT(J)=' '
C1025       CONTINUE
CCCCC       CALL DPCONH(IROW,AROW,ICTEXT,NH,IBUGG4,IERROR)
CCCCC       NCTEXT=NH
          ELSE
            NCTEXT=1
            DO1026J=24,1,-1
              IF(IROWLB(ITEMP)(J:J).NE.' ')THEN
                NCTEXT=J
                GOTO1027
              ENDIF
 1026       CONTINUE
 1027       CONTINUE
            DO1028J=1,NCTEXT
              ICTEXT(J)=' '
              ICTEXT(J)(1:1)=IROWLB(ITEMP)(J:J)
 1028       CONTINUE
          ENDIF
          PX1=PX(I)
          PY1=PY(I)
          CALL DPWRTE(PX1,PY1,ICTEXT,NCTEXT,
     1                IFONT,ICASE,IJUST,IDIR,ANGLE,IFILL,ICOL,
     1                PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1                ISYMBL,ISPAC,
     1                IMPSW2,AMPSCH,AMPSCW,
     1                PX99,PY99)
 1020   CONTINUE
        GOTO9000
      ELSEIF(
     1(ISYMBL(1:1).EQ.'X'.OR.ISYMBL(1:1).EQ.'x').AND.
     1(ISYMBL(2:2).EQ.'V'.OR.ISYMBL(2:2).EQ.'v').AND.
     1(ISYMBL(3:3).EQ.'A'.OR.ISYMBL(3:3).EQ.'a').AND.
     1(ISYMBL(4:4).EQ.'L'.OR.ISYMBL(4:4).EQ.'l')
     1)THEN
        DO1030I=1,NP
          PX1=PX(I)
          PY1=PY(I)
          AVAL=X(I)
          CONST=0.5
          IF(AVAL.LT.0.0)CONST=-0.5
          IVAL=INT(AVAL+CONST)
          NCTEXT=0
          DO1035J=1,50
            ICTEXT(J)=' '
 1035     CONTINUE
          CALL DPCONH(IVAL,AVAL,ICTEXT,NH,IBUGG4,IERROR)
          NCTEXT=NH
          CALL DPWRTE(PX1,PY1,ICTEXT,NCTEXT,
     1                IFONT,ICASE,IJUST,IDIR,ANGLE,IFILL,ICOL,
     1                PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1                ISYMBL,ISPAC,
     1                IMPSW2,AMPSCH,AMPSCW,
     1                PX99,PY99)
 1030   CONTINUE
        GOTO9000
      ELSEIF(
     1(ISYMBL(1:1).EQ.'Y'.OR.ISYMBL(1:1).EQ.'y').AND.
     1(ISYMBL(2:2).EQ.'V'.OR.ISYMBL(2:2).EQ.'v').AND.
     1(ISYMBL(3:3).EQ.'A'.OR.ISYMBL(3:3).EQ.'a').AND.
     1(ISYMBL(4:4).EQ.'L'.OR.ISYMBL(4:4).EQ.'l')
     1)THEN
        DO1040I=1,NP
          PX1=PX(I)
          PY1=PY(I)
          AVAL=Y(I)
          CONST=0.5
          IF(AVAL.LT.0.0)CONST=-0.5
          IVAL=INT(AVAL+CONST)
          NCTEXT=0
          DO1045J=1,50
            ICTEXT(J)=' '
 1045     CONTINUE
          CALL DPCONH(IVAL,AVAL,ICTEXT,NH,IBUGG4,IERROR)
          NCTEXT=NH
          CALL DPWRTE(PX1,PY1,ICTEXT,NCTEXT,
     1                IFONT,ICASE,IJUST,IDIR,ANGLE,IFILL,ICOL,
     1                PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1                ISYMBL,ISPAC,
     1                IMPSW2,AMPSCH,AMPSCW,
     1                PX99,PY99)
 1040   CONTINUE
        GOTO9000
      ELSEIF(
     1(ISYMBL(1:1).EQ.'X'.OR.ISYMBL(1:1).EQ.'x').AND.
     1(ISYMBL(2:2).EQ.'Y'.OR.ISYMBL(2:2).EQ.'y').AND.
     1(ISYMBL(3:3).EQ.'V'.OR.ISYMBL(3:3).EQ.'v').AND.
     1(ISYMBL(4:4).EQ.'A'.OR.ISYMBL(4:4).EQ.'a')
     1)THEN
        DO1050I=1,NP
          DO1055J=1,50
            ICTEXT(J)=' '
 1055     CONTINUE
          PX1=PX(I)
          PY1=PY(I)
          AVAL=X(I)
          CONST=0.5
          IF(AVAL.LT.0.0)CONST=-0.5
          IVAL=INT(AVAL+CONST)
          NCTEXT=1
          ICTEXT(NCTEXT)(1:1)='('
          NCTEXT=NCTEXT+1
          CALL DPCONH(IVAL,AVAL,ICTEXT(NCTEXT),NH,IBUGG4,IERROR)
          NCTEXT=NCTEXT+NH
          NCTEXT=NCTEXT+1
          ICTEXT(NCTEXT)(1:1)=','
          NCTEXT=NCTEXT+1
          AVAL=Y(I)
          IF(AVAL.LT.0.0)CONST=-0.5
          IVAL=INT(AVAL+CONST)
          CALL DPCONH(IVAL,AVAL,ICTEXT(NCTEXT),NH,IBUGG4,IERROR)
          NCTEXT=NCTEXT+NH
          ICTEXT(NCTEXT)(1:1)=')'
          CALL DPWRTE(PX1,PY1,ICTEXT,NCTEXT,
     1                IFONT,ICASE,IJUST,IDIR,ANGLE,IFILL,ICOL,
     1                PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1                ISYMBL,ISPAC,
     1                IMPSW2,AMPSCH,AMPSCW,
     1                PX99,PY99)
 1050   CONTINUE
        GOTO9000
      ELSEIF(
     1(ISYMBL(1:1).EQ.'T'.OR.ISYMBL(1:1).EQ.'t').AND.
     1(ISYMBL(2:2).EQ.'V'.OR.ISYMBL(2:2).EQ.'v').AND.
     1(ISYMBL(3:3).EQ.'A'.OR.ISYMBL(3:3).EQ.'a').AND.
     1(ISYMBL(4:4).EQ.'L'.OR.ISYMBL(4:4).EQ.'l')
     1)THEN
        DO1060I=1,NP
          PX1=PX(I)
          PY1=PY(I)
          AVAL=D(I)
          CONST=0.5
          IF(AVAL.LT.0.0)CONST=-0.5
          IVAL=INT(AVAL+CONST)
          NCTEXT=0
          DO1065J=1,50
            ICTEXT(J)=' '
 1065     CONTINUE
          CALL DPCONH(IVAL,AVAL,ICTEXT,NH,IBUGG4,IERROR)
          NCTEXT=NH
          CALL DPWRTE(PX1,PY1,ICTEXT,NCTEXT,
     1                IFONT,ICASE,IJUST,IDIR,ANGLE,IFILL,ICOL,
     1                PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1                ISYMBL,ISPAC,
     1                IMPSW2,AMPSCH,AMPSCW,
     1                PX99,PY99)
 1060   CONTINUE
        GOTO9000
      ELSEIF(
     1(ISYMBL(1:1).EQ.'Z'.OR.ISYMBL(1:1).EQ.'z').AND.
     1(ISYMBL(2:2).EQ.'V'.OR.ISYMBL(2:2).EQ.'v').AND.
     1(ISYMBL(3:3).EQ.'A'.OR.ISYMBL(3:3).EQ.'a').AND.
     1(ISYMBL(4:4).EQ.'L'.OR.ISYMBL(4:4).EQ.'l')
     1)THEN
        J=0
        DO1070I=1,MAXPOP
          IF(IJUNK2(I).EQ.0)GOTO1070
          J=J+1
          PX1=PX(J)
          PY1=PY(J)
          AVAL=X3D2(I)
          CONST=0.5
          IF(AVAL.LT.0.0)CONST=-0.5
          IVAL=INT(AVAL+CONST)
          NCTEXT=0
          DO1075JJ=1,50
            ICTEXT(JJ)=' '
 1075     CONTINUE
          CALL DPCONH(IVAL,AVAL,ICTEXT,NH,IBUGG4,IERROR)
          NCTEXT=NH
          CALL DPWRTE(PX1,PY1,ICTEXT,NCTEXT,
     1                IFONT,ICASE,IJUST,IDIR,ANGLE,IFILL,ICOL,
     1                PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1                ISYMBL,ISPAC,
     1                IMPSW2,AMPSCH,AMPSCW,
     1                PX99,PY99)
          IF(J.GE.NP)GOTO1079
 1070   CONTINUE
 1079   CONTINUE
        GOTO9000
      ENDIF
CCCCC NOVEMBER 1995. DO CASE CONVERSION HERE.
CCCCC IF "ASIS" NO ACTION REQUIRED.
CCCCC BE SURE TO TRANSLATE IPATT TO UPPER CASE.
      IF(ICASE.EQ.'LOWE')THEN
        DO100I=1,16
        ICTEMP=ISYMBL(I:I)
        CALL DPCOAN(ICTEMP,IVALT)
        IF(IVALT.GE.65.AND.IVALT.LE.90)IVALT=IVALT+32
        CALL DPCONA(IVALT,ICTEMP)
        ISYMBL(I:I)=ICTEMP
  100   CONTINUE
      ELSEIF(ICASE.EQ.'UPPE')THEN
        DO110I=1,16
        ICTEMP=ISYMBL(I:I)
        CALL DPCOAN(ICTEMP,IVALT)
        IF(IVALT.GE.97.AND.IVALT.LE.122)IVALT=IVALT-32
        CALL DPCONA(IVALT,ICTEMP)
        ISYMBL(I:I)=ICTEMP
  110   CONTINUE
      ELSEIF(ICASE.EQ.'ASIS')THEN
        CONTINUE
      END IF
      DO130I=1,16
      ICTEMP=IPATT(I:I)
      CALL DPCOAN(ICTEMP,IVALT)
      IF(IVALT.GE.97.AND.IVALT.LE.122)IVALT=IVALT-32
      CALL DPCONA(IVALT,ICTEMP)
      IPATT(I:I)=ICTEMP
  130 CONTINUE
C
      ITYPE='MARK'
C
C               **********************************************
C               **  STEP 1--                                **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE MARKER PATTERN (TYPE)            **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      CALL GRTRPA(ITYPE,IPATT(1:4),PXSPA,PYSPA,
     1JPATT,IHORPA,IVERPA,IDUPPA,IDDOPA,PXSPA2,PYSPA2)
C
C               *******************************
C               **  STEP 2--                 **
C               **  SET THE MARKER PATTERN   **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
      CALL GRSEPA(ITYPE,IPATT(1:4),PXSPA,PYSPA,
     1JPATT,IHORPA,IVERPA,IDUPPA,IDDOPA,PXSPA2,PYSPA2)
C
C               **********************************************
C               **  STEP 3--                                **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE MARKER FONT                      **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      CALL GRTRFO(ITYPE,IFONT,JFONT)
C
C               ************************************
C               **  STEP 4--                      **
C               **  SET THE MARKER FONT           **
C               **  ON THE GRAPHICS DEVICE.       **
C               ************************************
C
      CALL GRSEFO(ITYPE,IFONT,JFONT)
C
C               **********************************************
C               **  STEP 5--                                **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE MARKER CASE (UPPER OR LOWER)     **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      CALL GRTRCA(ITYPE,ICASE,JCASE)
C
C               ************************************
C               **  STEP 6--                      **
C               **  SET THE MARKER CASE           **
C               **  ON THE GRAPHICS DEVICE.       **
C               ************************************
C
      CALL GRSECA(ITYPE,ICASE,JCASE)
C
C               **********************************************
C               **  STEP 7--                                **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE MARKER JUSTIFICATION             **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      CALL GRTRJU(ITYPE,IJUST,JJUST)
C
C               ************************************
C               **  STEP 8--                      **
C               **  SET THE MARKER JUSTIFICATION  **
C               **  ON THE GRAPHICS DEVICE.       **
C               ************************************
C
      CALL GRSEJU(ITYPE,IJUST,JJUST)
C
C               **********************************************
C               **  STEP 9--                               **
C               **  TRANSLATE THE CHARACTER REPRESENTATION **
C               **  OF THE MARKER DIRECTION (ANGLE)         **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      CALL GRTRDI(ITYPE,IDIR,ANGLE,JDIR,ANGLE2)
C
C               ************************************
C               **  STEP 10--                    **
C               **  SET THE MARKER DIRECTION     **
C               **  ON THE GRAPHICS DEVICE.       **
C               ************************************
C
      CALL GRSEDI(ITYPE,IDIR,ANGLE,JDIR,ANGLE2)
C
C               **********************************************
C               **  STEP 11--                              **
C               **  TRANSLATE THE CHARACTER REPRESENTATION **
C               **  OF THE MARKER FILL (ON/OFF)                     **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      CALL GRTRFI(ITYPE,IFILL,JFILL)
C
C               *******************************
C               **  STEP 12--                **
C               **  SET THE MARKER FILL      **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
      CALL GRSEFI(ITYPE,IFILL,JFILL)
C
C               **********************************************
C               **  STEP 13--                               **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE MARKER COLOR                     **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      ITYPSV=ITYPE
      IF(IFONT.EQ.'TEKT')ITYPE='TEXT'
      CALL GRTRCO(ITYPE,ICOL,JCOL)
      ITYPE=ITYPSV
C
C               *******************************
C               **  STEP 14--                **
C               **  SET THE MARKER COLOR     **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
      ITYPSV=ITYPE
      IF(IFONT.EQ.'TEKT')ITYPE='TEXT'
      CALL GRSECO(ITYPE,ICOL,JCOL)
      ITYPE=ITYPSV
C
C               **********************************************
C               **  STEP 15--                                **
C               **  TRANSLATE THE CHARACTER REPRESENTATION   **
C               **  OF THE MARKER SIZE                      **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      CALL GRTRSI(ITYPE,IFONT,PHEIGH,PWIDTH,PVEGAP,PHOGAP,
     1JSIZE,
     1JHEIG2,JWIDT2,JVEGA2,JHOGA2,
     1PHEIG2,PWIDT2,PVEGA2,PHOGA2)
C
C               ************************************
C               **  STEP 16--                      **
C               **  SET THE MARKER SIZE            **
C               **  ON THE GRAPHICS DEVICE.       **
C               ************************************
C
      CALL GRSESI(ITYPE,IFONT,PHEIGH,PWIDTH,PVEGAP,PHOGAP,
     1JSIZE,
     1JHEIG2,JWIDT2,JVEGA2,JHOGA2,
     1PHEIG2,PWIDT2,PVEGA2,PHOGA2)
C
C               **********************************************
C               **  STEP 17--                                **
C               **  TRANSLATE THE CHARACTER REPRESENTATION   **
C               **  OF THE MARKER LINE THICKNESS            **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      CALL GRTRTH(ITYPE,PTHICK,JTHICK,PTHIC2)
C
C               ************************************
C               **  STEP 18--                      **
C               **  SET THE MARKER LINE THICKNESS  **
C               **  ON THE GRAPHICS DEVICE.       **
C               ************************************
C
      CALL GRSETH(ITYPE,PTHICK,JTHICK,PTHIC2)
C
C               *******************************
C               **  STEP 19--                **
C               **  DRAW OUT THE POLYMARKER  **
C               *******************************
C
      CALL GRDRPM(PX,PY,NP,
     1IFIG,IPATT,IFONT,ICASE,IJUST,IDIR,ANGLE,IFILL,ICOL,
     1JPATT,JFONT,JCASE,JJUST,JDIR,ANGLE2,JFILL,JCOL,
     1PTHICK,JTHICK,PTHIC2,
     1PHEIGH,PWIDTH,PVEGAP,PHOGAP,
     1PHEIG2,PWIDT2,PVEGA2,PHOGA2,
     1IMPSW2,AMPSCH,AMPSCW,
     1ISYMBL,ISPAC)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRPM')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPDRPM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)NP
 9014 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9015I=1,NP
      WRITE(ICOUT,9016)PX(I),PY(I)
 9016 FORMAT('PX(I),PY(I) = ',E15.7,E15.7)
      CALL DPWRST('XXX','BUG ')
 9015 CONTINUE
      WRITE(ICOUT,9018)IFIG
 9018 FORMAT('IFIG = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9019)IPATT,JPATT
 9019 FORMAT('IPATT,JPATT = ',A4,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9022)IFONT,JFONT
 9022 FORMAT('IFONT,JFONT = ',A4,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9023)IJUST,JJUST
 9023 FORMAT('IJUST,JJUST = ',A4,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9024)IDIR,ANGLE,JDIR,ANGLE2
 9024 FORMAT('IDIR,ANGLE,JDIR,ANGLE2 = ',A4,2X,E15.7,A4,2X,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9025)IFILL,JFILL
 9025 FORMAT('IFILL,JFILL = ',A4,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9026)ICOL,JCOL
 9026 FORMAT('ICOL,JCOL = ',A4,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9027)PHEIGH,PWIDTH,PVEGAP,PHOGAP
 9027 FORMAT('PHEIGH,PWIDTH,PVEGAP,PHOGAP = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9028)PHEIG2,PWIDT2,PVEGA2,PHOGA2
 9028 FORMAT('PHEIG2,PWIDT2,PVEGA2,PHOGA2 = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9029)PTHICK,PTHIC2
 9029 FORMAT('PTHICK,PTHIC2 = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9031)ISYMBL,ISPAC
 9031 FORMAT('ISYMBL,ISPAC = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9039)IBUGG4,ISUBG4,IERRG4
 9039 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPDRSP(Y,X,PY,PX,NP,
     1ICASPL,ICAS3D,
     1ISORSW,
     1ISP2LI,ISP2CO,ISP2DI,PSP2TH,ASP2BA,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1FX1MIN,FX1MAX,FY1MIN,FY1MAX,
     1IX1TSC,IY1TSC)
C
C     PURPOSE--FOR A GENERAL GRAPHICS DEVICE,
C              AND FOR EACH VALUE IN X(.), DRAW A SPIKE
C              (= A VERTICAL OR HORIZONTAL LINE SEGMENT)
C              FROM THE BASE POINT ASP2BA
C              TO THE POINT Y(.).
C              DO SO FOR A SPECIFIED SPIKE LINE TYPE,
C              LINES COLOR, LINE DIRECTION, AND LINE THICKNESS.
C     NOTE--THE VARIABLES PY(.) AND PX(.) ARE DUMMY VARIABLES
C           WHICH ARE USED IN THE INTERMEDIATE CALCULATIONS
C           AND WHOSE DIMENSIONS ARE DEFINED (FOR EASY OF CHANGE)
C           BACK IN THE MAIN ROUTINE.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--87.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C     UPDATED--APRIL     1987.
C     UPDATED         --SEPTEMBER 1988.  RENUMBER
C     UPDATED         --FEBRUARY  1989.  CHANGE CALLS FROM GRDRPL TO DPDRPL (ALA
C     UPDATED         --JULY      1990.  CHARACTER*4 IPATT TO FIX BOMB
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAS3D
C
      CHARACTER*4 ISORSW
C
      CHARACTER*4 ISP2LI
      CHARACTER*4 ISP2CO
      CHARACTER*4 ISP2DI
C
      CHARACTER*4 IX1TSC
      CHARACTER*4 IY1TSC
C
      CHARACTER*4 ITYPE
C
      CHARACTER*4 IFIG
      CHARACTER*4 IPATTT
CCCCC THE FOLLOWING LINE WAS ADDED TO FIX SPIKE BOMB   JULY 1990
      CHARACTER*4 IPATT
      CHARACTER*4 ICOL
      CHARACTER*4 IDIR
C
C     6/23/86
C     HOW COME THE FOLLOWING 4 VARIABLES ARE NOT CARRIED
C     AS INPUT TO THIS SUBROUTINE--NOT NEEDED???
C     CHECK ON THIS.
C
      CHARACTER*4 IHORPA
      CHARACTER*4 IVERPA
      CHARACTER*4 IDUPPA
      CHARACTER*4 IDDOPA
CCCCC THE FOLLOWING LINE WAS ADDED FEBRUARY 1989
      CHARACTER*4 IFLAG
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION PY(*)
      DIMENSION PX(*)
C
      DIMENSION PY2(10)
      DIMENSION PX2(10)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      HOLD=1.0
      ABASE=0.0
      PBASE=0.0
      PBASE2=0.0
C
      FXMIN=FX1MIN
      FXMAX=FX1MAX
      FYMIN=FY1MIN
      FYMAX=FY1MAX
C
CCCCC THE FOLLOWING 2 LINES WERE ADDED TO FIX SPIKE BOMB JULY 1990
      IPATT='JUNK'
      JPATT=(-888)
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRSP')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPDRSP--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)NP
   52 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)ICASPL,ICAS3D
   53 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      IF(NP.LE.3)GOTO69
      DO65I=1,3
      WRITE(ICOUT,66)I,X(I),Y(I)
   66 FORMAT('I,X(I),Y(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
   65 CONTINUE
      NPM2=NP-2
      DO67I=NPM2,NP
      WRITE(ICOUT,68)I,X(I),Y(I)
   68 FORMAT('I,X(I),Y(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
   67 CONTINUE
   69 CONTINUE
      WRITE(ICOUT,70)ISORSW
   70 FORMAT('ISORSW = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,71)ISP2LI
   71 FORMAT('ISP2LI= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,72)ISP2CO,ISP2DI
   72 FORMAT('ISP2CO,ISP2DI= ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,73)PSP2TH
   73 FORMAT('PSP2TH= ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,74)ASP2BA
   74 FORMAT('ASP2BA= ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,84)PXMIN,PXMAX,PYMIN,PYMAX
   84 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,85)FX1MIN,FX1MAX,FY1MIN,FY1MAX
   85 FORMAT('FX1MIN,FX1MAX,FY1MIN,FY1MAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,86)IX1TSC,IY1TSC
   86 FORMAT('IX1TSC,IY1TSC = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,89)IBUGG4,ISUBG4,IERRG4
   89 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               *************************************************
C               **  STEP 11--                                  **
C               **  IF CALLED FOR, SORT THE DATA               **
C               **  ACCORDING TO THE HORIZONTAL AXIS VARIABLE  **
C               *************************************************
C
      IDIR=ISP2DI
C
      IF(ICASPL.EQ.'TRPL')GOTO9000
      IF(ISORSW.EQ.'OFF')GOTO1150
      IF(ICASPL.EQ.'PIEC')GOTO1150
      IF(ICASPL.EQ.'ROSE')GOTO1150
      IF(ICAS3D.EQ.'ON')GOTO1150
      IF(ICASPL.EQ.'CONT')GOTO1150
C
      CALL SORTC(X,Y,NP,PX,PY)
      GOTO1190
C
 1150 CONTINUE
      DO1160I=1,NP
      PX(I)=X(I)
      PY(I)=Y(I)
 1160 CONTINUE
      GOTO1190
C
 1190 CONTINUE
C
C               ************************************************
C               **  STEP 12--                                 **
C               **  IF A LOG SCALE PLOT IS CALLED FOR,        **
C               **  CHECK THAT ALL DATA POINTS ARE POSITIVE.  **
C               ************************************************
C
      IF(IX1TSC.EQ.'LOG')GOTO1210
      GOTO1290
C
 1210 CONTINUE
      IF(IDIR.EQ.'H')GOTO1215
      GOTO1219
 1215 CONTINUE
      IF(ASP2BA.LE.0.0)HOLD=ASP2BA
      IF(ASP2BA.LE.0.0)GOTO1250
 1219 CONTINUE
C
      IF(ISORSW.EQ.'ON')GOTO1220
      GOTO1230
C
 1220 CONTINUE
      J=1
      IF(PX(J).LE.0.0)GOTO1250
      GOTO1290
C
 1230 CONTINUE
      DO1235I=1,NP
      J=I
      IF(PX(J).LE.0.0)GOTO1250
 1235 CONTINUE
      GOTO1290
C
 1250 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1251)
 1251 FORMAT('***** ERROR IN DPDRSP--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1252)
 1252 FORMAT('      THE LOG OF A NON-POSITIVE DATA VALUE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1253)
 1253 FORMAT('      WAS ENCOUNTERED IN FORMING A PLOT.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1254)
 1254 FORMAT('      DATA MAY NOT BE ZERO OR NEGATIVE')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1255)
 1255 FORMAT('      WHEN A LOG SCALE PLOT IS USED.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1256)PX(J)
 1256 FORMAT('      THE VALUE = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1257)
 1257 FORMAT('      THIS VALUE CAME FROM THE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1258)
 1258 FORMAT('      HORIZONTAL AXIS VARIABLE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1259)
 1259 FORMAT('      CORRECTIVE ACTION--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1260)
 1260 FORMAT('      CHANGE DATA OR CHANGE LIMITS.')
      CALL DPWRST('XXX','BUG ')
      IERRG4='YES'
      GOTO9000
C
 1290 CONTINUE
C
      IF(IY1TSC.EQ.'LOG')GOTO1310
      GOTO1390
C
 1310 CONTINUE
      IF(IDIR.EQ.'V')GOTO1315
      GOTO1319
 1315 CONTINUE
      IF(ASP2BA.LE.0.0)HOLD=ASP2BA
      IF(ASP2BA.LE.0.0)GOTO1350
 1319 CONTINUE
C
      IF(ISORSW.EQ.'ON')GOTO1320
      GOTO1330
C
 1320 CONTINUE
      J=1
      IF(PY(J).LE.0.0)HOLD=PY(J)
      IF(PY(J).LE.0.0)GOTO1350
      GOTO1390
C
 1330 CONTINUE
      DO1335I=1,NP
      J=I
      IF(PY(J).LE.0.0)HOLD=PY(J)
      IF(PY(J).LE.0.0)GOTO1350
 1335 CONTINUE
      GOTO1390
C
 1350 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1351)
 1351 FORMAT('***** ERROR IN DPDRSP--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1352)
 1352 FORMAT('      THE LOG OF A NON-POSITIVE DATA VALUE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1353)
 1353 FORMAT('      WAS ENCOUNTERED IN FORMING A PLOT.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1354)
 1354 FORMAT('      DATA MAY NOT BE ZERO OR NEGATIVE')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1355)
 1355 FORMAT('      WHEN A LOG SCALE PLOT IS USED.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1356)HOLD
 1356 FORMAT('      THE VALUE = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1357)
 1357 FORMAT('      THIS VALUE CAME FROM THE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1358)
 1358 FORMAT('      VERTICAL AXIS VARIABLE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1359)
 1359 FORMAT('      CORRECTIVE ACTION--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1360)
 1360 FORMAT('      CHANGE DATA OR CHANGE LIMITS.')
      CALL DPWRST('XXX','BUG ')
      IERRG4='YES'
      GOTO9000
C
 1390 CONTINUE
C
C               ******************************************
C               **  STEP 40--                           **
C               **  IF A LOG SCALE PLOT IS CALLED FOR,  **
C               **  TRANSFORM THE DATA                  **
C               ******************************************
C
      ABASE=ASP2BA
C
      IF(IX1TSC.EQ.'LOG')GOTO4010
      GOTO4019
 4010 CONTINUE
      IF(IDIR.EQ.'H')ABASE=LOG10(ABASE)
      DO4015I=1,NP
      PX(I)=LOG10(PX(I))
 4015 CONTINUE
 4019 CONTINUE
C
      IF(IY1TSC.EQ.'LOG')GOTO4020
      GOTO4029
 4020 CONTINUE
      IF(IDIR.EQ.'V')ABASE=LOG10(ABASE)
      DO4025I=1,NP
      PY(I)=LOG10(PY(I))
 4025 CONTINUE
 4029 CONTINUE
C
C               *****************************************************
C               **  STEP 50--                                      **
C               **  TRANSLATE THE DATA POINTS                      **
C               **  INTO STANDARDIZED (0.0 TO 100.0) COORDINATES.  **
C               *****************************************************
C
      FXMIN=FX1MIN
      FXMAX=FX1MAX
      IF(IX1TSC.EQ.'LOG')FXMIN=LOG10(FX1MIN)
      IF(IX1TSC.EQ.'LOG')FXMAX=LOG10(FX1MAX)
C
      FYMIN=FY1MIN
      FYMAX=FY1MAX
      IF(IY1TSC.EQ.'LOG')FYMIN=LOG10(FY1MIN)
      IF(IY1TSC.EQ.'LOG')FYMAX=LOG10(FY1MAX)
C
      FXRANG=FXMAX-FXMIN
      FYRANG=FYMAX-FYMIN
      PXRANG=PXMAX-PXMIN
      PYRANG=PYMAX-PYMIN
C
      DO5000I=1,NP
      FXRATI=(PX(I)-FXMIN)/FXRANG
      FYRATI=(PY(I)-FYMIN)/FYRANG
      PX(I)=PXMIN+FXRATI*PXRANG
      PY(I)=PYMIN+FYRATI*PYRANG
 5000 CONTINUE
C
      IF(IDIR.EQ.'V')GOTO5010
      GOTO5019
 5010 CONTINUE
      FYRATI=(ABASE-FYMIN)/FYRANG
      PBASE=PYMIN+FYRATI*PYRANG
 5019 CONTINUE
C
      IF(IDIR.EQ.'H')GOTO5020
      GOTO5029
 5020 CONTINUE
      FXRATI=(ABASE-FXMIN)/FXRANG
      PBASE=PXMIN+FXRATI*PXRANG
 5029 CONTINUE
C
C               *******************************
C               **  STEP 70--                **
C               **  PREPARE TO MAKE VARIOUS  **
C               **  LINE SETTINGS            **
C               *******************************
C
      ITYPE='LINE'
C
C               **********************************************
C               **  STEP 71--                               **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE LINE PATTERN                     **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      IPATTT=ISP2LI
      CALL GRTRPA(ITYPE,IPATTT,PXSPA,PYSPA,
     1JPATTT,IHORPA,IVERPA,IDUPPA,IDDOPA,PXSPA2,PYSPA2)
C
C               *******************************
C               **  STEP 72--                **
C               **  SET THE LINE PATTERN     **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
      CALL GRSEPA(ITYPE,IPATTT,PXSPA,PYSPA,
     1JPATTT,IHORPA,IVERPA,IDUPPA,IDDOPA,PXSPA2,PYSPA2)
C
C               **********************************************
C               **  STEP 73--                               **
C               **  TRANSLATE THE  DESIRED                  **
C               **  LINE THICKNESS                          **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      PTHICK=PSP2TH
      CALL GRTRTH(ITYPE,PTHICK,JTHICK,PTHIC2)
C
C               *******************************
C               **  STEP 74--                **
C               **  SET THE LINE THICKNESS   **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
      CALL GRSETH(ITYPE,PTHICK,JTHICK,PTHIC2)
C
C               **********************************************
C               **  STEP 75--                               **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE LINE COLOR                       **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      ICOL=ISP2CO
      CALL GRTRCO(ITYPE,ICOL,JCOL)
C
C               *******************************
C               **  STEP 76--                **
C               **  SET THE LINE COLOR       **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
      CALL GRSECO(ITYPE,ICOL,JCOL)
C
C               **************************************
C               **  STEP 81--                       **
C               **  DRAW OUT ALL SPIKES             **
C               **  (BUT CLIP FIRST, IF NECESSARY)  **
C               **************************************
C
      IFIG='GENE'
C
      CALL DPSQUE(PX,PY,NP,
     1PXMIN,PXMAX,PYMIN,PYMAX)
C
      IF(IDIR.EQ.'V')GOTO7100
      GOTO7190
 7100 CONTINUE
      PBASE2=PBASE
      IF(PBASE2.LT.PYMIN.AND.(PYMIN-PBASE2).LE.0.0001)PBASE2=PYMIN
      IF(PBASE2.GT.PYMAX.AND.(PBASE2-PYMAX).LE.0.0001)PBASE2=PYMAX
C
CCCCC THE FOLLOWING LINE WAS ADDED FEBRUARY 1989
      IFLAG='OFF'
      NP2=2
      DO7110I=1,NP
C
      IF(PX(I).LT.PXMIN)GOTO7110
      IF(PX(I).GT.PXMAX)GOTO7110
      IF(PY(I).LT.PYMIN.AND.PBASE2.LT.PYMIN)GOTO7110
      IF(PY(I).GT.PYMAX.AND.PBASE2.GT.PYMAX)GOTO7110
C
      PX2(1)=PX(I)
      PX2(2)=PX(I)
C
      PY2(1)=PBASE2
      PY2(2)=PY(I)
C
      DO7150J=1,NP2
      IF(PY2(J).LT.PYMIN)PY2(J)=PYMIN
      IF(PY2(J).GT.PYMAX)PY2(J)=PYMAX
 7150 CONTINUE
C
CCCCC THE FOLLOWING 3 LINES WERE COMMENTED OUT FEBRUARY 1989
CCCCC AND REPLACED BY THE SUBSEQUENT 3 LINES (ALAN) FEBRUARY 1989
CCCCC CALL GRDRPL(PX2,PY2,NP2,
CCCCC1IFIG,IPATTT,PTHICK,ICOL,
CCCCC1JPATTT,JTHICK,PTHIC2,JCOL)
      CALL DPDRPL(PX2,PY2,NP2,
     1IFIG,IPATT,PTHICK,ICOL,
CCCCC THE FOLLOWING LINE WAS TEMPORARILY FIXED JULY 9, 1990
CCCCC1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
     1JPATTT,JTHICK,PTHIC2,JCOL,IFLAG)
C
C
 7110 CONTINUE
 7190 CONTINUE
C
      IF(IDIR.EQ.'H')GOTO7200
      GOTO7290
 7200 CONTINUE
CCCCC THE FOLLOWING LINE WAS ADDED FEBRUARY 1989
      IFLAG='OFF'
      PBASE2=PBASE
      IF(PBASE2.LT.PXMIN.AND.(PXMIN-PBASE2).LE.0.0001)PBASE2=PXMIN
      IF(PBASE2.GT.PXMAX.AND.(PBASE2-PXMAX).LE.0.0001)PBASE2=PXMAX
C
      NP2=2
      DO7210I=1,NP
C
      IF(PY(I).LT.PYMIN)GOTO7210
      IF(PY(I).GT.PYMAX)GOTO7210
      IF(PX(I).LT.PXMIN.AND.PBASE2.LT.PXMIN)GOTO7210
      IF(PX(I).GT.PXMAX.AND.PBASE2.GT.PXMAX)GOTO7210
C
      PX2(1)=PBASE2
      PX2(2)=PX(I)
C
      PY2(1)=PY(I)
      PY2(2)=PY(I)
C
      DO7250J=1,NP2
      IF(PX2(J).LT.PXMIN)PX2(J)=PXMIN
      IF(PX2(J).GT.PXMAX)PX2(J)=PXMAX
 7250 CONTINUE
C
CCCCC THE FOLLOWING 3 LINES WERE COMMENTED OUT FEBRUARY 1989
CCCCC AND REPLACED BY THE SUBSEQUENT 3 LINES (ALAN) FEBRUARY 1989
CCCCC CALL GRDRPL(PX2,PY2,NP2,
CCCCC1IFIG,IPATTT,PTHICK,ICOL,
CCCCC1JPATTT,JTHICK,PTHIC2,JCOL)
      CALL DPDRPL(PX2,PY2,NP2,
     1IFIG,IPATT,PTHICK,ICOL,
CCCCC THE FOLLOWING LINE WAS TEMPORARILY FIXED JULY 9, 1990
CCCCC1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
     1JPATTT,JTHICK,PTHIC2,JCOL,IFLAG)
C
 7210 CONTINUE
 7290 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRSP')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPDRSP--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)NP
 9012 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)ICASPL,ICAS3D
 9013 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)HOLD
 9014 FORMAT('HOLD = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)ABASE,PBASE,PBASE2
 9015 FORMAT('ABASE,PBASE,PBASE2 = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      IF(NP.LE.3)GOTO9029
      DO9025I=1,3
      WRITE(ICOUT,9026)I,X(I),Y(I)
 9026 FORMAT('I,X(I),Y(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
 9025 CONTINUE
      NPM2=NP-2
      DO9027I=NPM2,NP
      WRITE(ICOUT,9028)I,X(I),Y(I)
 9028 FORMAT('I,X(I),Y(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
 9027 CONTINUE
 9029 CONTINUE
      WRITE(ICOUT,9030)ISORSW
 9030 FORMAT('ISORSW = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9031)ISP2LI
 9031 FORMAT('ISP2LI= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9032)PSP2TH
 9032 FORMAT('PSP2TH= ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9033)ISP2CO,ISP2DI
 9033 FORMAT('ISP2CO,ISP2DI= ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9044)PXMIN,PXMAX,PYMIN,PYMAX
 9044 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9045)FX1MIN,FX1MAX,FY1MIN,FY1MAX
 9045 FORMAT('FX1MIN,FX1MAX,FY1MIN,FY1MAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9046)FXMIN,FXMAX,FYMIN,FYMAX
 9046 FORMAT('FXMIN,FXMAX,FYMIN,FYMAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9047)IX1TSC,IY1TSC
 9047 FORMAT('IX1TSC,IY1TSC = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9051)IFIG
 9051 FORMAT('IFIG = ',A4)
      CALL DPWRST('XXX','BUG ')
CCCCC THE FOLLOWING 2 LINES WERE AUGMENTED JULY 1990
CCCCC WRITE(ICOUT,9052)IPATTT,JPATTT
C9052 FORMAT('IPATTT,JPATTT = ',A4,I8)
CCCCC CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9052)IPATT,IPATTT,JPATTT
 9052 FORMAT('IPATT,IPATTT,JPATTT = ',A4,2X,A4,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9053)PTHICK,JTHICK,PTHIC2
 9053 FORMAT('PTHICK,JTHICK,PTHIC2 = ',E15.7,I8,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9054)ICOL,JCOL,IDIR
 9054 FORMAT('ICOL,JCOL,IDIR = ',A4,I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9055)ITYPE
 9055 FORMAT('ITYPE = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9069)IBUGG4,ISUBG4,IERRG4
 9069 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPDRTM(PXMIN,PYMIN,PXMAX,PYMAX,
     1FXMIN,FYMIN,FXMAX,FYMAX,
     1ICASPL,ICAS3D,
     1IX1FSW,IX2FSW,IY1FSW,IY2FSW,
     1IX1TSW,IX2TSW,IY1TSW,IY2TSW,
     1PX1COO,PX2COO,PY1COO,PY2COO,
     1NX1COO,NX2COO,NY1COO,NY2COO,
     1PX1CMN,PX2CMN,PY1CMN,PY2CMN,
     1NX1CMN,NX2CMN,NY1CMN,NY2CMN,
     1PX1TLE,PX2TLE,PY1TLE,PY2TLE,
     1PTICTH,PMNTFA,
     1IX1TJU,IX2TJU,IY1TJU,IY2TJU,
     1IX1TCO,IX2TCO,IY1TCO,IY2TCO)
C
C     PURPOSE--DRAW TIC MARKS ON THE FRAME LINES.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C     UPDATED         --FEBRUARY  1988.  STAR PLOT
C     UPDATED         --JANUARY   1989.  CALL DPDRPL RATHER THAN GRDRPL (ALAN)
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAS3D
C
      CHARACTER*4 IX1FSW
      CHARACTER*4 IX2FSW
      CHARACTER*4 IY1FSW
      CHARACTER*4 IY2FSW
C
      CHARACTER*4 IX1TSW
      CHARACTER*4 IX2TSW
      CHARACTER*4 IY1TSW
      CHARACTER*4 IY2TSW
C
      CHARACTER*4 IX1TJU
      CHARACTER*4 IX2TJU
      CHARACTER*4 IY1TJU
      CHARACTER*4 IY2TJU
C
      CHARACTER*4 IX1TCO
      CHARACTER*4 IX2TCO
      CHARACTER*4 IY1TCO
      CHARACTER*4 IY2TCO
C
      CHARACTER*4 ITYPE
      CHARACTER*4 IFIG
      CHARACTER*4 IPATT
      CHARACTER*4 ICOL
      CHARACTER*4 IHORPA
      CHARACTER*4 IVERPA
      CHARACTER*4 IDUPPA
      CHARACTER*4 IDDOPA
C
      CHARACTER*4 IFLAG
C
      DIMENSION PX1COO(*)
      DIMENSION PX2COO(*)
      DIMENSION PY1COO(*)
      DIMENSION PY2COO(*)
C
      DIMENSION PX1CMN(*)
      DIMENSION PX2CMN(*)
      DIMENSION PY1CMN(*)
      DIMENSION PY2CMN(*)
C
      DIMENSION PX(100)
      DIMENSION PY(100)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRTM')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPDRTM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)PXMIN,PYMIN,PXMAX,PYMAX
   52 FORMAT('PXMIN,PYMIN,PXMAX,PYMAX = ',4F10.5)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)ICASPL,ICAS3D
   53 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IX1FSW,IX2FSW,IY1FSW,IY2FSW
   54 FORMAT('IX1FSW,IX2FSW,IY1FSW,IY2FSW = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IX1TSW,IX2TSW,IY1TSW,IY2TSW
   55 FORMAT('IX1TSW,IX2TSW,IY1TSW,IY2TSW = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)PTICTH,PMNTFA
   56 FORMAT('PTICTH,PMNTFA = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,57)IX1TJU,IX2TJU,IY1TJU,IY2TJU
   57 FORMAT('IX1TJU,IX2TJU,IY1TJU,IY2TJU = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,58)IX1TCO,IX2TCO,IY1TCO,IY2TCO
   58 FORMAT('IX1TCO,IX2TCO,IY1TCO,IY2TCO = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,59)NX1COO,NX2COO,NY1COO,NY2COO
   59 FORMAT('NX1COO,NX2COO,NY1COO,NY2COO = ',4I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,60)NX1CMN,NX2CMN,NY1CMN,NY2CMN
   60 FORMAT('NX1CMN,NX2CMN,NY1CMN,NY2CMN = ',4I8)
      CALL DPWRST('XXX','BUG ')
C
      IF(NX1COO.LE.0)GOTO69
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      DO61I=1,NX1COO
      WRITE(ICOUT,62)I,PX1COO(I),PX1CMN(I)
   62 FORMAT('I,PX1COO(I),PX1CMN(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
   61 CONTINUE
   69 CONTINUE
C
      IF(NX2COO.LE.0)GOTO79
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      DO71I=1,NX2COO
      WRITE(ICOUT,72)I,PX2COO(I),PX2CMN(I)
   72 FORMAT('I,PX2COO(I),PX2CMN(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
   71 CONTINUE
   79 CONTINUE
C
      IF(NY1COO.LE.0)GOTO89
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      DO81I=1,NY1COO
      WRITE(ICOUT,82)I,PY1COO(I),PY1CMN(I)
   82 FORMAT('I,PY1COO(I),PY1CMN(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
   81 CONTINUE
   89 CONTINUE
C
      IF(NY2COO.LE.0)GOTO99
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      DO91I=1,NY2COO
      WRITE(ICOUT,92)I,PY2COO(I),PY2CMN(I)
   92 FORMAT('I,PY2COO(I),PY2CMN(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
   91 CONTINUE
   99 CONTINUE
C
      WRITE(ICOUT,88)IBUGG4,ISUBG4,IERRG4
   88 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
C
   90 CONTINUE
C
      IF(ICASPL.EQ.'PIEC')GOTO9000
      IF(ICASPL.EQ.'ROSE')GOTO9000
      IF(ICASPL.EQ.'STAR')GOTO9000
      IF(ICAS3D.EQ.'ON')GOTO9000
      IF(ICASPL.EQ.'TRPL')GOTO2000
C
      ITYPE='LINE'
C
C               ***************************************************
C               **  STEP 1--                                     **
C               **  THE TIC MARKS WILL HAVE SOLID LINE PATTERN.  **
C               **  TRANSLATE THIS SOLID LINE PATTERN            **
C               **  INTO A NUMBER WHICH CAN BE UNDERSTOOD        **
C               **  BY THE GRAPHICS DEVICE.                      **
C               ***************************************************
C
      IFIG='LINE'
      IPATT='SOLI'
      CALL GRTRPA(ITYPE,IPATT,PXSPA,PYSPA,
     1JPATT,IHORPA,IVERPA,IDUPPA,IDDOPA,PXSPA2,PYSPA2)
C
C               **********************************
C               **  STEP 2--                    **
C               **  SET THE LINE TYPE TO SOLID  **
C               **  ON THE GRAPHICS DEVICE.     **
C               **********************************
C
      CALL GRSEPA(ITYPE,IPATT,PXSPA,PYSPA,
     1JPATT,IHORPA,IVERPA,IDUPPA,IDDOPA,PXSPA2,PYSPA2)
C
C               **********************************************
C               **  STEP 3--                                **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE TIC  THICKNESS                   **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      PTHICK=PTICTH
      CALL GRTRTH(ITYPE,PTHICK,JTHICK,PTHIC2)
C
C               *******************************
C               **  STEP 4--                 **
C               **  SET THE LINE THICKNESS   **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
      CALL GRSETH(ITYPE,PTHICK,JTHICK,PTHIC2)
C
C               ******************************************************
C               **  STEP 7--                                        **
C               **  DRAW MAJOR TIC MARKS ON BOTTOM HORIZONTAL AXIS  **
C               **  DRAW MINOR TIC MARKS ON BOTTOM HORIZONTAL AXIS  **
C               ******************************************************
C
      IF(IX1FSW.EQ.'OFF')GOTO1190
      IF(IX1TSW.EQ.'OFF')GOTO1190
C
      ICOL=IX1TCO
      CALL GRTRCO(ITYPE,ICOL,JCOL)
      CALL GRSECO(ITYPE,ICOL,JCOL)
C
      PMJTLE=PX1TLE
C
      PY(1)=PYMIN
      PY(2)=PYMIN
      IF(IX1TJU.EQ.'THRU')PY(1)=PYMIN+PMJTLE/2.0
      IF(IX1TJU.EQ.'THRU')PY(2)=PYMIN-PMJTLE/2.0
      IF(IX1TJU.EQ.'IN')PY(1)=PYMIN+PMJTLE
      IF(IX1TJU.EQ.'INSI')PY(1)=PYMIN+PMJTLE
      IF(IX1TJU.EQ.'OUT')PY(1)=PYMIN-PMJTLE
      IF(IX1TJU.EQ.'OUTS')PY(1)=PYMIN-PMJTLE
C
      IF(NX1COO.LE.0)GOTO1190
      NP=2
      IFLAG='OFF'
      DO1110I=1,NX1COO
      PX(1)=PX1COO(I)
      PX(2)=PX1COO(I)
CCCCC CALL GRDRPL(PX,PY,NP,
CCCCC1IFIG,IPATT,PTHICK,ICOL,
CCCCC1JPATT,JTHICK,PTHIC2,JCOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 1110 CONTINUE
C
      PMNTLE=PMJTLE*PMNTFA
C
      PY(1)=PYMIN
      PY(2)=PYMIN
      IF(IX1TJU.EQ.'THRU')PY(1)=PYMIN+PMNTLE/2.0
      IF(IX1TJU.EQ.'THRU')PY(2)=PYMIN-PMNTLE/2.0
      IF(IX1TJU.EQ.'IN')PY(1)=PYMIN+PMNTLE
      IF(IX1TJU.EQ.'INSI')PY(1)=PYMIN+PMNTLE
      IF(IX1TJU.EQ.'OUT')PY(1)=PYMIN-PMNTLE
      IF(IX1TJU.EQ.'OUTS')PY(1)=PYMIN-PMNTLE
C
      IF(NX1CMN.LE.0)GOTO1190
      NP=2
      IFLAG='OFF'
      DO1120I=1,NX1CMN
      PX(1)=PX1CMN(I)
      PX(2)=PX1CMN(I)
CCCCC CALL GRDRPL(PX,PY,NP,
CCCCC1IFIG,IPATT,PTHICK,ICOL,
CCCCC1JPATT,JTHICK,PTHIC2,JCOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 1120 CONTINUE
C
 1190 CONTINUE
C
C               ******************************************************
C               **  STEP 8--                                        **
C               **  DRAW MAJOR TIC MARKS ON TOP    HORIZONTAL AXIS  **
C               **  DRAW MINOR TIC MARKS ON TOP    HORIZONTAL AXIS  **
C               ******************************************************
C
      IF(IX2FSW.EQ.'OFF')GOTO1290
      IF(IX2TSW.EQ.'OFF')GOTO1290
C
      ICOL=IX2TCO
      CALL GRTRCO(ITYPE,ICOL,JCOL)
      CALL GRSECO(ITYPE,ICOL,JCOL)
C
      PMJTLE=PX2TLE
C
      PY(1)=PYMAX
      PY(2)=PYMAX
      IF(IX2TJU.EQ.'THRU')PY(1)=PYMAX+PMJTLE/2.0
      IF(IX2TJU.EQ.'THRU')PY(2)=PYMAX-PMJTLE/2.0
      IF(IX2TJU.EQ.'IN')PY(1)=PYMAX-PMJTLE
      IF(IX2TJU.EQ.'INSI')PY(1)=PYMAX-PMJTLE
      IF(IX2TJU.EQ.'OUT')PY(1)=PYMAX+PMJTLE
      IF(IX2TJU.EQ.'OUTS')PY(1)=PYMAX+PMJTLE
C
      IF(NX2COO.LE.0)GOTO1290
      NP=2
      IFLAG='OFF'
      DO1210I=1,NX2COO
      PX(1)=PX2COO(I)
      PX(2)=PX2COO(I)
CCCCC CALL GRDRPL(PX,PY,NP,
CCCCC1IFIG,IPATT,PTHICK,ICOL,
CCCCC1JPATT,JTHICK,PTHIC2,JCOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 1210 CONTINUE
C
      PMNTLE=PMJTLE*PMNTFA
C
      PY(1)=PYMAX
      PY(2)=PYMAX
      IF(IX2TJU.EQ.'THRU')PY(1)=PYMAX+PMNTLE/2.0
      IF(IX2TJU.EQ.'THRU')PY(2)=PYMAX-PMNTLE/2.0
      IF(IX2TJU.EQ.'IN')PY(1)=PYMAX-PMNTLE
      IF(IX2TJU.EQ.'INSI')PY(1)=PYMAX-PMNTLE
      IF(IX2TJU.EQ.'OUT')PY(1)=PYMAX+PMNTLE
      IF(IX2TJU.EQ.'OUTS')PY(1)=PYMAX+PMNTLE
C
      IF(NX2CMN.LE.0)GOTO1290
      NP=2
      IFLAG='OFF'
      DO1220I=1,NX2CMN
      PX(1)=PX2CMN(I)
      PX(2)=PX2CMN(I)
CCCCC CALL GRDRPL(PX,PY,NP,
CCCCC1IFIG,IPATT,PTHICK,ICOL,
CCCCC1JPATT,JTHICK,PTHIC2,JCOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 1220 CONTINUE
C
 1290 CONTINUE
C
C               ******************************************************
C               **  STEP 9--                                        **
C               **  DRAW MAJOR TIC MARKS ON LEFT   VERTICAL   AXIS  **
C               **  DRAW MINOR TIC MARKS ON LEFT   VERTICAL   AXIS  **
C               ******************************************************
C
      IF(IY1FSW.EQ.'OFF')GOTO1390
      IF(IY1TSW.EQ.'OFF')GOTO1390
C
      ICOL=IY1TCO
      CALL GRTRCO(ITYPE,ICOL,JCOL)
      CALL GRSECO(ITYPE,ICOL,JCOL)
C
      PMJTLE=PY1TLE*(ANUMVP/ANUMHP)
C
      PX(1)=PXMIN
      PX(2)=PXMIN
      IF(IY1TJU.EQ.'THRU')PX(1)=PXMIN-PMJTLE/2.0
      IF(IY1TJU.EQ.'THRU')PX(2)=PXMIN+PMJTLE/2.0
      IF(IY1TJU.EQ.'IN')PX(1)=PXMIN+PMJTLE
      IF(IY1TJU.EQ.'INSI')PX(1)=PXMIN+PMJTLE
      IF(IY1TJU.EQ.'OUT')PX(1)=PXMIN-PMJTLE
      IF(IY1TJU.EQ.'OUTS')PX(1)=PXMIN-PMJTLE
C
      IF(NY1COO.LE.0)GOTO1390
      NP=2
      IFLAG='OFF'
      DO1310I=1,NY1COO
      PY(1)=PY1COO(I)
      PY(2)=PY1COO(I)
CCCCC CALL GRDRPL(PX,PY,NP,
CCCCC1IFIG,IPATT,PTHICK,ICOL,
CCCCC1JPATT,JTHICK,PTHIC2,JCOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 1310 CONTINUE
C
      PMNTLE=PMJTLE*PMNTFA
C
      PX(1)=PXMIN
      PX(2)=PXMIN
      IF(IY1TJU.EQ.'THRU')PX(1)=PXMIN-PMNTLE/2.0
      IF(IY1TJU.EQ.'THRU')PX(2)=PXMIN+PMNTLE/2.0
      IF(IY1TJU.EQ.'IN')PX(1)=PXMIN+PMNTLE
      IF(IY1TJU.EQ.'INSI')PX(1)=PXMIN+PMNTLE
      IF(IY1TJU.EQ.'OUT')PX(1)=PXMIN-PMNTLE
      IF(IY1TJU.EQ.'OUTS')PX(1)=PXMIN-PMNTLE
C
      IF(NY1CMN.LE.0)GOTO1390
      NP=2
      IFLAG='OFF'
      DO1320I=1,NY1CMN
      PY(1)=PY1CMN(I)
      PY(2)=PY1CMN(I)
CCCCC CALL GRDRPL(PX,PY,NP,
CCCCC1IFIG,IPATT,PTHICK,ICOL,
CCCCC1JPATT,JTHICK,PTHIC2,JCOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 1320 CONTINUE
C
 1390 CONTINUE
C
C               ******************************************************
C               **  STEP 10--                                       **
C               **  DRAW MAJOR TIC MARKS ON RIGHT  VERTICAL   AXIS  **
C               **  DRAW MINOR TIC MARKS ON RIGHT  VERTICAL   AXIS  **
C               ******************************************************
C
      IF(IY2FSW.EQ.'OFF')GOTO1490
      IF(IY2TSW.EQ.'OFF')GOTO1490
C
      ICOL=IY2TCO
      CALL GRTRCO(ITYPE,ICOL,JCOL)
      CALL GRSECO(ITYPE,ICOL,JCOL)
C
      PMJTLE=PY2TLE*(ANUMVP/ANUMHP)
C
      PX(1)=PXMAX
      PX(2)=PXMAX
      IF(IY2TJU.EQ.'THRU')PX(1)=PXMAX-PMJTLE/2.0
      IF(IY2TJU.EQ.'THRU')PX(2)=PXMAX+PMJTLE/2.0
      IF(IY2TJU.EQ.'IN')PX(1)=PXMAX-PMJTLE
      IF(IY2TJU.EQ.'INSI')PX(1)=PXMAX-PMJTLE
      IF(IY2TJU.EQ.'OUT')PX(1)=PXMAX+PMJTLE
      IF(IY2TJU.EQ.'OUTS')PX(1)=PXMAX+PMJTLE
C
      IF(NY2COO.LE.0)GOTO1490
      NP=2
      IFLAG='OFF'
      DO1410I=1,NY2COO
      PY(1)=PY2COO(I)
      PY(2)=PY2COO(I)
CCCCC CALL GRDRPL(PX,PY,NP,
CCCCC1IFIG,IPATT,PTHICK,ICOL,
CCCCC1JPATT,JTHICK,PTHIC2,JCOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 1410 CONTINUE
C
      PMNTLE=PMJTLE*PMNTFA
C
      PX(1)=PXMAX
      PX(2)=PXMAX
      IF(IY2TJU.EQ.'THRU')PX(1)=PXMAX-PMNTLE/2.0
      IF(IY2TJU.EQ.'THRU')PX(2)=PXMAX+PMNTLE/2.0
      IF(IY2TJU.EQ.'IN')PX(1)=PXMAX-PMNTLE
      IF(IY2TJU.EQ.'INSI')PX(1)=PXMAX-PMNTLE
      IF(IY2TJU.EQ.'OUT')PX(1)=PXMAX+PMNTLE
      IF(IY2TJU.EQ.'OUTS')PX(1)=PXMAX+PMNTLE
C
      IF(NY2CMN.LE.0)GOTO1490
      NP=2
      IFLAG='OFF'
      DO1420I=1,NY2CMN
      PY(1)=PY2CMN(I)
      PY(2)=PY2CMN(I)
CCCCC CALL GRDRPL(PX,PY,NP,
CCCCC1IFIG,IPATT,PTHICK,ICOL,
CCCCC1JPATT,JTHICK,PTHIC2,JCOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 1420 CONTINUE
C
 1490 CONTINUE
C
      GOTO9000
C
 2000 CONTINUE
C
C               *****************************************
C               **  STEP 20--                          **
C               **  DRAW TIC MARKS  FOR TRILINEAR PLOT **
C               *****************************************
C
C  NOTE: FOR NOW, SUPPRESS TIC MARKS FOR TRILINEAR SCALES.
C        THE FOLLOWING ISN'T REALLY THE RIGHT WAY TO DO IT.
C
      GOTO9000
C
      IF(IX1FSW.EQ.'OFF')GOTO9000
      IF(IX1TSW.EQ.'OFF')GOTO9000
      IF(NX1COO.LE.0)GOTO9000
C
      ITYPE='LINE'
      IPATT='SOLI'
      ICOL=IX1TCO
      PTHICK=PTICTH
C
      IFIG='LINE'
C
      PMJTLE=PX1TLE
      AMIN=0.0
      AMAX=FXMAX
      GRDINC=(AMAX-AMIN)/REAL(NX1COO-1)
      PXRANG=PXMAX - PXMIN
      PYRANG=PYMAX - PYMIN
C
C               *****************************************
C               **  STEP 20.A--                        **
C               **  DRAW TIC MARKS  FOR X1 AXIS        **
C               *****************************************
C
C
      NP2=2
      IFLAG='ON'
      DO2010I=1,NX1COO
        XDUMMY=AMIN + (I-1)*GRDINC
        PXSTRT=PXMIN + 0.5*PXRANG*XDUMMY
        PYSTRT=PYMIN + PYRANG*XDUMMY
        PX(1)=PXSTRT
        PY(1)=PYSTRT
        PY(2)=PYSTRT
C
        IF(IX1TJU.EQ.'THRU')THEN
          PX(2)=PX(1)+PMJTLE/2.0
          PX(1)=PX(1)-PMJTLE/2.0
        ELSEIF(IX1TJU.EQ.'IN'.OR.IX1TJU.EQ.'INSI')THEN
          PX(2)=PX(1)+PMJTLE
          IF(I.EQ.1 .OR. I.EQ.NX1COO)GOTO2010
        ELSEIF(IX1TJU.EQ.'OUT'.OR.IX1TJU.EQ.'OUTS')THEN
          PX(2)=PX(1)-PMJTLE
        ENDIF
C
        CALL DPDRPL(PX,PY,NP2,
     1              IFIG,IPATT,PTHICK,ICOL,
     1              JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
        IFLAG='OFF'
 2010 CONTINUE
C
C               *****************************************
C               **  STEP 20.B--                        **
C               **  DRAW TIC MARKS  FOR X2 AXIS        **
C               *****************************************
C
C
      NP2=2
      DO2020I=1,NX1COO
        XDUMMY=AMIN + (I-1)*GRDINC
        PXSTRT=PXMAX - PXRANG*XDUMMY
        PYSTRT=PYMIN
        PX(1)=PXSTRT
        PY(1)=PYSTRT
        PX(2)=PX(1)
C
        IF(IX1TJU.EQ.'THRU')THEN
          PY(2)=PY(1)+PMJTLE/2.0
          PY(1)=PY(1)-PMJTLE/2.0
        ELSEIF(IX1TJU.EQ.'IN'.OR.IX1TJU.EQ.'INSI')THEN
          PY(2)=PY(1)+PMJTLE
          IF(I.EQ.1 .OR. I.EQ.NX1COO)GOTO2020
        ELSEIF(IX1TJU.EQ.'OUT'.OR.IX1TJU.EQ.'OUTS')THEN
          PY(2)=PY(1)-PMJTLE
        ENDIF
C
        CALL DPDRPL(PX,PY,NP2,
     1              IFIG,IPATT,PTHICK,ICOL,
     1              JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 2020 CONTINUE
C
C               *****************************************
C               **  STEP 20.C--                        **
C               **  DRAW TIC MARKS  FOR X3 AXIS        **
C               *****************************************
C
      NP2=2
      DO2030I=1,NX1COO
        XDUMMY=AMIN + (I-1)*GRDINC
        PXSTRT=PXMIN + PXRANG*XDUMMY
        PXSTRT=PXSTRT + 0.5*PXRANG*(AMAX-XDUMMY)
        PYSTRT=PYMIN + PYRANG*(AMAX-XDUMMY)
        PX(1)=PXSTRT
        PY(1)=PYSTRT
        PY(2)=PY(1)
C
        IF(IX1TJU.EQ.'THRU')THEN
          PX(2)=PX(1)-PMJTLE/2.0
          PX(1)=PX(1)+PMJTLE/2.0
        ELSEIF(IX1TJU.EQ.'IN'.OR.IX1TJU.EQ.'INSI')THEN
          PX(2)=PX(1)-PMJTLE
          IF(I.EQ.1 .OR. I.EQ.NX1COO)GOTO2030
        ELSEIF(IX1TJU.EQ.'OUT'.OR.IX1TJU.EQ.'OUTS')THEN
          PX(2)=PX(1)+PMJTLE
        ENDIF
C
        CALL DPDRPL(PX,PY,NP2,
     1              IFIG,IPATT,PTHICK,ICOL,
     1              JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 2030 CONTINUE
      IFLAG='ON'
C
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRTM')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPDRTM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)ICASPL,ICAS3D
 9013 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)PTICTH
 9016 FORMAT('PTICTH = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9018)IFIG
 9018 FORMAT('IFIG = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9019)IPATT,JPATT
 9019 FORMAT('IPATT,JPATT = ',A4,2X,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9020)PTHICK,JTHICK,PTHIC2
 9020 FORMAT('PTHICK,JTHICK,PTHIC2 = ',E15.7,2X,A4,2X,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)ICOL,JCOL
 9021 FORMAT('ICOL,JCOL = ',A4,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9022)ITYPE
 9022 FORMAT('ITYPE = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9029)IBUGG4,ISUBG4,IERRG4
 9029 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPDRTR(Y,X,PY,PX,NP,PY2,PX2,NP2,PY3,PX3,NP3,X3D,
     1ICASPL,ICAS3D,
     1ISORSW,
     1ILI2PA,ILI2CO,PLI2TH,
CCCCC OCTOBER 1993.  ADD ARE3BA
CCCCC1ARE2BA,
     1ARE2BA,ARE3BA,
     1IRE2FS,IRE2FC,
     1IRE2PT,IRE2PL,IRE2PC,PRE2PT,PRE2PS,
CCCCC MARCH 1994.  ADD FOLLOWING LINE
     1IREBPL,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1FX1MIN,FX1MAX,FY1MIN,FY1MAX,
     1IX1TSC,IY1TSC)
C
C     PURPOSE--FOR A GENERAL GRAPHICS DEVICE,
C              DRAW A SINGLE TRACE OF Y(.) VERSUS X(.)
C              FOR A SPECIFIED LINE TYPE, COLOR, AND THICKNESS.
C              AND (IF CALLED FOR) FILL IN BELOW/ABOVE THE TRACE
C              TO THE BASE LINE ARE2BA.
C     NOTE--THE VARIABLES PY(.) AND PX(.) ARE DUMMY VARIABLES
C           WHICH ARE USED IN THE INTERMEDIATE CALCULATIONS
C           AND WHOSE DIMENSIONS ARE DEFINED (FOR EASY OF CHANGE)
C           BACK IN THE MAIN ROUTINE.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C     UPDATED         --FEBRUARY 1988.   STAR PLOT
C     UPDATED         --JUNE     1988.   CALLS TO DPFIRE
C     UPDATED         --SEPTEMBER 1988.  LOG/WEIBULL CHECK AS A SUBROUTINE
C     UPDATED         --SEPTEMBER 1988.  RENUMBER
C     UPDATED         --DECEMBER  1988.  IBUGG4 FOR IBUGPL
C     UPDATED         --JUNE      1990.  NORMAL PLOT
C     UPDATED         --OCTOBER   1993.  BAR BASE AUTOMATIC
C     UPDATED         --OCTOBER   1993.  REGION BASE AUTOMATIC
C     UPDATED         --NOVEMBER  1993.  FILL PIE CHART AS "POLYGON"
C     UPDATED         --MARCH     1994   REGION BASE POLYGON
C     UPDATED         --DECEMBER  1996   FIX NORMAL PLOT
C     UPDATED         --DECEMBER  2006   SUPPORT FOR TRILINEAR PLOT
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAS3D
C
      CHARACTER*4 ISORSW
C
      CHARACTER*4 ILI2PA
      CHARACTER*4 ILI2CO
C
      CHARACTER*4 IRE2FS
      CHARACTER*4 IRE2FC
      CHARACTER*4 IRE2PT
      CHARACTER*4 IRE2PL
      CHARACTER*4 IRE2PC
      CHARACTER*4 IREBPL
C
      CHARACTER*4 IX1TSC
      CHARACTER*4 IY1TSC
C
      CHARACTER*4 IFIG
      CHARACTER*4 IPATT
      CHARACTER*4 ICOL
      CHARACTER*4 IPATT2
C
      CHARACTER*4 ICOLF
      CHARACTER*4 ICOLP
C
      CHARACTER*4 ICASAX
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION X3D(*)
      DIMENSION PY(*)
      DIMENSION PX(*)
      DIMENSION PY2(*)
      DIMENSION PX2(*)
      DIMENSION PY3(*)
      DIMENSION PX3(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      HOLD=1.0
      ABASE=0.0
      PBASE=0.0
      PBASE2=0.0
      PLEFT=0.0
      PRIGHT=0.0
      AWIDTH=0.0
      PWIDTH=0.0
      FYRATI=0.0
C
      FXMIN=FX1MIN
      FXMAX=FX1MAX
      FYMIN=FY1MIN
      FYMAX=FY1MAX
C
      AHUNDR=100.0
      ABASE2=0.0
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRTR')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPDRTR--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)NP
   52   FORMAT('NP = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)ICASPL,ICAS3D
   53   FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        IF(NP.GE.1)THEN
          DO65I=1,NP
            WRITE(ICOUT,66)I,X(I),Y(I),X3D(I)
   66       FORMAT('I,X(I),Y(I),X3D(I) = ',I8,3G15.7)
            CALL DPWRST('XXX','BUG ')
   65     CONTINUE
        ENDIF
        WRITE(ICOUT,70)ISORSW
   70   FORMAT('ISORSW = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,71)ILI2PA,ILI2CO,PLI2TH
   71   FORMAT('ILI2PA,ILI2CO,PLI2TH = ',A4,2X,A4,E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,72)ARE2BA
   72   FORMAT('ARE2BA = ',E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,73)IRE2FS,IRE2FC
   73   FORMAT('IRE2FS,IRE2FC = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,74)IRE2PT,IRE2PL,IRE2PC,PRE2PT,PRE2PS
   74   FORMAT('IRE2PT,IRE2PL,IRE2PC,PRE2PT,PRE2PS = ',
     1         A4,2X,A4,2X,A4,2E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,84)PXMIN,PXMAX,PYMIN,PYMAX
   84   FORMAT('PXMIN,PXMAX,PYMIN,PYMAX= ',4E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,85)FX1MIN,FX1MAX,FY1MIN,FY1MAX
   85   FORMAT('FX1MIN,FX1MAX,FY1MIN,FY1MAX= ',4E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,86)IX1TSC,IY1TSC
   86   FORMAT('IX1TSC,IY1TSC = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,89)IBUGG4,ISUBG4,IERRG4
   89   FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *************************************************
C               **  STEP 1--                                   **
C               **  IF CALLED FOR, SORT THE DATA               **
C               **  ACCORDING TO THE HORIZONTAL AXIS VARIABLE  **
C               *************************************************
C
      IF(ISORSW.EQ.'OFF')GOTO1150
      IF(ICASPL.EQ.'PIEC')GOTO1150
      IF(ICASPL.EQ.'ROSE')GOTO1150
      IF(ICASPL.EQ.'STAR')GOTO1150
      IF(ICAS3D.EQ.'ON')GOTO1150
      IF(ICASPL.EQ.'CONT')GOTO1150
CCCCC MARCH 1994.  ADD FOLLOWING LINE
      IF(IREBPL.EQ.'ON')GOTO1150
      IF(ICASPL.EQ.'TRPL')GOTO1150
C
      CALL SORTC(X,Y,NP,PX,PY)
      GOTO1190
C
 1150 CONTINUE
      DO1160I=1,NP
      PX(I)=X(I)
      PY(I)=Y(I)
 1160 CONTINUE
      GOTO1190
C
 1190 CONTINUE
C
C               ******************************************************
C               **  STEP 21--                                       **
C               **  IF A NON-LINEAR SCALE PLOT IS CALLED FOR, CHECK **
C               **  THAT ALL HORIZONTAL AXIS DATA POINTS            **
C               **  ARE IN VALID RANGE.                             **
C               **  IF A LOG SCALE PLOT IS CALLED FOR, CHECK THAT   **
C               **  ALL HORIZONTAL AXIS DATA POINTS ARE > 0.        **
C               **  IF A WEIBULL SCALE PLOT IS CALLED FOR,          **
C               **  CHECK THAT ALL HORIZONTAL AXIS DATA POINTS ARE  **
C               **  STRICTLY > 0 AND STRICTLY < 100                 **
C               ******************************************************
C
      IF(IX1TSC.EQ.'LOG')THEN
        ICASAX='2DHO'
        CALL CKLOSC(PX,NP,ISORSW,ICASAX,ISUBG4,IBUGG4,IERRG4)
        IF(IERRG4.EQ.'YES')GOTO9000
      ELSEIF(IX1TSC.EQ.'WEIB' .OR. IX1TSC.EQ.'NORM')THEN
        ICASAX='2DHO'
CCCCC   CALL CKPRSC(PX,NP,ISORSW,ICASAX,ISUBG4,IBUGG4,IERRG4)
CCCCC   IF(IERRG4.EQ.'YES')GOTO9000
      ENDIF
C
C               ******************************************************
C               **  STEP 22--                                       **
C               **  IF A NON-LINEAR SCALE PLOT IS CALLED FOR, CHECK **
C               **  THAT ALL VERTICAL AXIS DATA POINTS              **
C               **  ARE IN VALID RANGE.                             **
C               **  IF A LOG SCALE PLOT IS CALLED FOR, CHECK THAT   **
C               **  ALL VERTICAL AXIS DATA POINTS ARE > 0.          **
C               **  IF A WEIBULL SCALE PLOT IS CALLED FOR, CHECK    **
C               **  THAT ALL VERTICAL AXIS DATA POINTS ARE          **
C               **  STRICTLY > 0 AND STRICTLY < 100                 **
C               ******************************************************
C
      IF(IY1TSC.EQ.'LOG')THEN
        ICASAX='2DVE'
        CALL CKLOSC(PY,NP,ISORSW,ICASAX,ISUBG4,IBUGG4,IERRG4)
        IF(IERRG4.EQ.'YES')GOTO9000
      ELSEIF(IY1TSC.EQ.'WEIB' .OR. IY1TSC.EQ.'NORM')THEN
        ICASAX='2DVE'
CCCCC   CALL CKPRSC(PY,NP,ISORSW,ICASAX,ISUBG4,IBUGG4,IERRG4)
CCCCC   IF(IERRG4.EQ.'YES')GOTO9000
      ENDIF
C
C               *************************************************
C               **  STEP 4--                                   **
C               **  IF A NON-LINEAR SCALE PLOT IS CALLED FOR,  **
C               **  TRANSFORM THE DATA                         **
C               *************************************************
C
C               ******************************************
C               **  STEP 4.1--                          **
C               **  IF A LOG SCALE PLOT IS CALLED FOR,  **
C               **  TRANSFORM THE DATA                  **
C               ******************************************
C
      IF(IX1TSC.EQ.'LOG')THEN
        DO4115I=1,NP
          PX(I)=LOG10(PX(I))
 4115   CONTINUE
      ENDIF
C
      ABASE=ARE2BA
CCCCC OCTOBER 1993.  ADD FOLLOWING
      ABAS2=ARE3BA
      IF(IY1TSC.EQ.'LOG')THEN
        IF(ABASE.NE.CPUMAX.AND.ABASE.GT.0.0)ABASE=LOG10(ABASE)
        IF(ABASE.NE.CPUMAX.AND.ABASE.LE.0.0)ABASE=1.0
CCCCC OCTOBER 1993.  ADD FOLLOWING
        IF(ABAS2.NE.CPUMAX.AND.ABAS2.GT.0.0)ABAS2=LOG10(ABAS2)
        IF(ABAS2.NE.CPUMAX.AND.ABAS2.LE.0.0)ABAS2=1.0
        DO4165I=1,NP
          PY(I)=LOG10(PY(I))
 4165   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 4.2--                          **
C               **  IF A WEIBULL SCALE PLOT IS CALLED   **
C               **  FOR, TRANSFORM THE DATA             **
C               ******************************************
C
      IF(IX1TSC.EQ.'WEIB')THEN
        DO4215I=1,NP
          PX(I)=LOG(LOG(AHUNDR/(AHUNDR-PX(I))))
 4215   CONTINUE
      ENDIF
C
      ABASE=ARE2BA
CCCCC OCTOBER 1993.  ADD FOLLOWING
      ABAS2=ARE3BA
      IF(IY1TSC.EQ.'WEIB')THEN
        IF(ABASE.NE.CPUMAX.AND.ABASE.GT.0.0.AND.ABASE.LT.AHUNDR)
     1    ABASE2=LOG(LOG(AHUNDR/(AHUNDR-ABASE)))
        IF(ABASE.NE.CPUMAX.AND.ABASE.LE.0.0)ABASE2=0.1
        IF(ABASE.NE.CPUMAX.AND.ABASE.GE.AHUNDR)ABASE2=0.1
        ABASE=ABASE2
CCCCC OCTOBER 1993.  ADD FOLLOWING
        IF(ABAS2.NE.CPUMAX.AND.ABAS2.GT.0.0.AND.ABAS2.LT.AHUNDR)
     1    ABASE2=LOG(LOG(AHUNDR/(AHUNDR-ABAS2)))
        IF(ABAS2.NE.CPUMAX.AND.ABAS2.LE.0.0)ABASE2=0.1
        IF(ABAS2.NE.CPUMAX.AND.ABAS2.GE.AHUNDR)ABASE2=0.1
        ABAS2=ABASE2
        DO4265I=1,NP
          PY(I)=LOG(LOG(AHUNDR/(AHUNDR-PY(I))))
 4265   CONTINUE
      ENDIF
C
CCCCC THE FOLLOWING SECTION WAS ADDED JUNE 1990
C               ******************************************
C               **  STEP 4.3--                          **
C               **  IF A NORMAL SCALE PLOT IS CALLED    **
C               **  FOR, TRANSFORM THE DATA             **
C               ******************************************
C
      IF(IX1TSC.EQ.'NORM')THEN
        DO4315I=1,NP
          ARG=PX(I)/AHUNDR
          CALL NORPPF(ARG,PX(I))
 4315   CONTINUE
      ENDIF
C
      ABASE=ARE2BA
CCCCC OCTOBER 1993.  ADD FOLLOWING
      ABAS2=ARE3BA
      IF(IY1TSC.EQ.'NORM')THEN
        IF(ABASE.NE.CPUMAX.AND.ABASE.GT.0.0.AND.ABASE.LT.AHUNDR)THEN
          ARG=ABASE/AHUNDR
          CALL NORPPF(ARG,ABASE2)
        ENDIF
        IF(ABASE.NE.CPUMAX.AND.ABASE.LE.0.0)ABASE2=0.1
        IF(ABASE.NE.CPUMAX.AND.ABASE.GE.AHUNDR)ABASE2=0.1
        ABASE=ABASE2
CCCCC   OCTOBER 1993.  ADD FOLLOWING
        IF(ABAS2.NE.CPUMAX.AND.ABAS2.GT.0.0.AND.ABAS2.LT.AHUNDR)THEN
          ARG=ABAS2/AHUNDR
          CALL NORPPF(ARG,ABASE2)
        ENDIF
        IF(ABAS2.NE.CPUMAX.AND.ABAS2.LE.0.0)ABASE2=0.1
        IF(ABAS2.NE.CPUMAX.AND.ABAS2.GE.AHUNDR)ABASE2=0.1
        ABAS2=ABASE2
        DO4365I=1,NP
          ARG=PY(I)/AHUNDR
          CALL NORPPF(ARG,PY(I))
 4365   CONTINUE
      ENDIF
C
C               *****************************************************
C               **  STEP 5--                                       **
C               **  TRANSLATE THE DATA POINTS                      **
C               **  INTO STANDARDIZED (0.0 TO 100.0) COORDINATES.  **
C               *****************************************************
C
      FXMIN=FX1MIN
      FXMAX=FX1MAX
      IF(IX1TSC.EQ.'LOG')THEN
        FXMIN=LOG10(FX1MIN)
        FXMAX=LOG10(FX1MAX)
      ELSEIF(IX1TSC.EQ.'WEIB')THEN
        FXMIN=LOG(LOG(AHUNDR/(AHUNDR-FX1MIN)))
        FXMAX=LOG(LOG(AHUNDR/(AHUNDR-FX1MAX)))
      ELSEIF(IX1TSC.EQ.'NORM')THEN
         ARG=FX1MIN/AHUNDR
         CALL NORPPF(ARG,FXMIN)
         ARG=FX1MAX/AHUNDR
         CALL NORPPF(ARG,FXMAX)
      END IF
C
      FYMIN=FY1MIN
      FYMAX=FY1MAX
      IF(IY1TSC.EQ.'LOG')THEN
        FYMIN=LOG10(FY1MIN)
        FYMAX=LOG10(FY1MAX)
      ELSEIF(IY1TSC.EQ.'WEIB')THEN
        FYMIN=LOG(LOG(AHUNDR/(AHUNDR-FY1MIN)))
        FYMAX=LOG(LOG(AHUNDR/(AHUNDR-FY1MAX)))
      ELSEIF(IY1TSC.EQ.'NORM')THEN
         ARG=FY1MIN/AHUNDR
         CALL NORPPF(ARG,FYMIN)
         ARG=FY1MAX/AHUNDR
         CALL NORPPF(ARG,FYMAX)
      ENDIF
C
      FXRANG=FXMAX-FXMIN
      FYRANG=FYMAX-FYMIN
      PXRANG=PXMAX-PXMIN
      PYRANG=PYMAX-PYMIN
C
      IF(ICASPL.NE.'TRPL')THEN
        DO5100I=1,NP
          FXRATI=(PX(I)-FXMIN)/FXRANG
          FYRATI=(PY(I)-FYMIN)/FYRANG
          PX(I)=PXMIN+FXRATI*PXRANG
          PY(I)=PYMIN+FYRATI*PYRANG
 5100   CONTINUE
        IF(ABASE.NE.CPUMAX)THEN
          FYRATI=(ABASE-FYMIN)/FYRANG
          PBASE=PYMIN+FYRATI*PYRANG
        ENDIF
CCCCC OCTOBER 1993.  ADD FOLLOWING
        IF(ABAS2.NE.CPUMAX)THEN
          FYRAT2=(ABAS2-FYMIN)/FYRANG
          PBASE9=PYMIN+FYRAT2*PYRANG
        ENDIF
      ELSE
        AK2=SQRT(2.0)
        AK6=SQRT(6.0)
        PXHALF=(PXMIN+PXMAX)/2.0
        PYTHRD=PYMIN + (PYMAX-PYMIN)/3.0
        ASUM=X(1) + Y(1) + X3D(1)
        DO5160I=1,NP
          X1K=X(I)/ASUM
          X2K=Y(I)/ASUM
          X3K=X3D(I)/ASUM
          AH=(1.0/AK2)*(X3K-X2K)
          AV=(1.0/AK6)*(2.0 - 3.0*X2K - 3.0*X3K)
          PX(I)=PXHALF + (PXRANG/(2.0/AK2))*AH
          PY(I)=PYTHRD + (PYRANG/(3.0/AK6))*AV
 5160   CONTINUE
      ENDIF
C
C               **************************************
C               **  STEP 6--                        **
C               **  IF CALLED FOR,                  **
C               **  FILL OVER/UNDER THE TRACE       **
C               **  (BUT CLIP FIRST, IF NECESSARY)  **
C               **************************************
C
      IF(ICASPL.EQ.'TRPL')GOTO6190
C
      IFIG='GENE'
      IF(ICASPL.EQ.'PIEC')IFIG='POLY'
      IF(ICASPL.EQ.'ROSE')IFIG='POLY'
CCCCC MARCH 1994.  ADD FOLLOWING LINE
      IF(IREBPL.EQ.'ON')IFIG='POLY'
C
      IF(IRE2FS.EQ.'OFF')GOTO6190
      IPATT=IRE2PT
      PTHICK=PRE2PT
      PXGAP=PRE2PS
      PYGAP=PRE2PS
      ICOLF=IRE2FC
      ICOLP=IRE2PC
C
      CALL DPSQUE(PX,PY,NP,
     1PXMIN,PXMAX,PYMIN,PYMAX)
C
CCCCC MARCH 1994.  ADD FOLLOWING LINE
      IF(IREBPL.EQ.'ON')GOTO6110
      IF(ABASE.EQ.CPUMAX)GOTO6110
      GOTO6120
C
 6110 CONTINUE
      DO6115I=1,NP
      PX2(I)=PX(I)
      PY2(I)=PY(I)
 6115 CONTINUE
      NP2=NP+1
      PX2(NP2)=PX(1)
      PY2(NP2)=PY(1)
C
      DO6116J=1,NP2
      IF(PX2(J).LT.PXMIN)PX2(J)=PXMIN
      IF(PX2(J).GT.PXMAX)PX2(J)=PXMAX
      IF(PY2(J).LT.PYMIN)PY2(J)=PYMIN
      IF(PY2(J).GT.PYMAX)PY2(J)=PYMAX
 6116 CONTINUE
C
CCCCC CALL DPFIRE(PX2,PY2,NP2,
CCCCC1IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP)
C JUNE, 1988
      IPATT2=IRE2PL
      CALL DPFIRE(PX2,PY2,NP2,
     1IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP,IPATT2)
C
      GOTO6190
C
 6120 CONTINUE
      PBASE2=PBASE
      IF(PBASE2.LT.PYMIN.AND.(PYMIN-PBASE2).LE.0.0001)PBASE2=PYMIN
      IF(PBASE2.GT.PYMAX.AND.(PBASE2-PYMAX).LE.0.0001)PBASE2=PYMAX
CCCCC OCTOBER 1993.  ADD FOLLOWING
      PBASE8=PBASE9
      IF(PBASE9.LT.PYMIN.AND.(PYMIN-PBASE9).LE.0.0001)PBASE8=PYMIN
      IF(PBASE9.GT.PYMAX.AND.(PBASE9-PYMAX).LE.0.0001)PBASE8=PYMAX
CCCCC OCTOBER 1993.
      IF(NP.GT.2)GOTO6130
C
      NP2=5
      NPM1=NP-1
      IF(NPM1.LE.0)GOTO6190
      DO6125I=1,NPM1
      IP1=I+1
C
      PLEFT=PX(I)
      PRIGHT=PX(IP1)
      IF(PLEFT.LT.PXMIN.AND.(PXMIN-PLEFT).LE.0.0001)PLEFT=PXMIN
      IF(PRIGHT.GT.PXMAX.AND.(PRIGHT-PXMAX).LE.0.0001)PRIGHT=PXMAX
C
      IF(PRIGHT.LT.PXMIN)GOTO6125
      IF(PLEFT.GT.PXMAX)GOTO6125
      IF(PY(I).LT.PYMIN.AND.PBASE2.LT.PYMIN)GOTO6125
      IF(PY(I).GT.PYMAX.AND.PBASE2.GT.PYMAX)GOTO6125
C
      PX2(1)=PLEFT
      PX2(2)=PRIGHT
      PX2(3)=PRIGHT
      PX2(4)=PLEFT
      PX2(5)=PLEFT
C
      PY2(1)=PBASE2
CCCCC OCTOBER 1993.  ADD FOLLOWING
CCCCC PY2(2)=PBASE2
      PY2(2)=PBASE8
CCCCC END CHANGE
      PY2(3)=PY(IP1)
      PY2(4)=PY(I)
      PY2(5)=PBASE2
C
      DO6126J=1,NP2
      IF(PX2(J).LT.PXMIN)PX2(J)=PXMIN
      IF(PX2(J).GT.PXMAX)PX2(J)=PXMAX
      IF(PY2(J).LT.PYMIN)PY2(J)=PYMIN
      IF(PY2(J).GT.PYMAX)PY2(J)=PYMAX
 6126 CONTINUE
C
CCCCC CALL DPFIRE(PX2,PY2,NP2,
CCCCC1IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP)
CCCCC JUNE, 1988.
      IPATT2=IRE2PL
      CALL DPFIRE(PX2,PY2,NP2,
     1IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP,IPATT2)
 6125 CONTINUE
C
      GOTO6190
CCCCC OCTOBER 1993.  TREAT REGION AS SINGLE POLYGON
 6130 CONTINUE
C
      DO6135I=1,NP
C
      PX2(I)=PX(I)
      PY2(I)=PY(I)
      IF(PX2(I).LT.PXMIN)PX2(I)=PXMIN
      IF(PX2(I).GT.PXMAX)PX2(I)=PXMAX
      IF(PY2(I).LT.PYMIN)PY2(I)=PYMIN
      IF(PY2(I).GT.PYMAX)PY2(I)=PYMAX
 6135 CONTINUE
C
      NP2=NP+1
      PX2(NP2)=PX2(NP)
      PY2(NP2)=PBASE2
      NP2=NP2+1
      PX2(NP2)=PX2(1)
      PY2(NP2)=PBASE2
      NP2=NP2+1
      PX2(NP2)=PX2(1)
      PY2(NP2)=PY2(1)
C
      IPATT2=IRE2PL
      CALL DPFIRE(PX2,PY2,NP2,
     1IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP,IPATT2)
C
      GOTO6190
C
 6190 CONTINUE
C
C               *****************************************
C               **  STEP 7--                           **
C               **  DRAW OUT THE TRACE                 **
C               **  (BUT CLIP IT FIRST, IF NECESSARY)  **
C               *****************************************
C
      IFIG='GENE'
      IPATT=ILI2PA
      PTHICK=PLI2TH
      ICOL=ILI2CO
C
CCCCC CALL DPCLTR(PX,PY,NP,PX2,PY2,NP2,PY3,PX3,NP3,
      CALL DPCLTR(PX,PY,NP,PX2,PY2,NP2,PY3TMP,PX3TMP,NP3,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1ISORSW,
     1IFIG,IPATT,PTHICK,ICOL)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DRTR')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDRTR--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)NP
 9012   FORMAT('NP = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)ICASPL,ICAS3D
 9013   FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        IF(NP.GE.1)THEN
          DO9025I=1,NP
            WRITE(ICOUT,9026)I,PX(I),PY(I)
 9026       FORMAT('I,PX(I),PY(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','BUG ')
 9025     CONTINUE
        ENDIF
        WRITE(ICOUT,9030)ISORSW
 9030   FORMAT('ISORSW = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9031)ILI2PA,ILI2CO,PLI2TH
 9031   FORMAT('ILI2PA,ILI2CO,PLI2TH = ',A4,2X,A4,E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9032)ARE2BA
 9032   FORMAT('ARE2BA = ',E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9033)IRE2FS,IRE2FC
 9033   FORMAT('IRE2FS,IRE2FC = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9034)IRE2PT,IRE2PL,IRE2PC,PRE2PT,PRE2PS
 9034   FORMAT('IRE2PT,IRE2PL,IRE2PC,PRE2PT,PRE2PS = ',
     1         A4,2X,A4,2X,A4,2E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9044)PXMIN,PXMAX,PYMIN,PYMAX
 9044   FORMAT('PXMIN,PXMAX,PYMIN,PYMAX= ',4E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9045)FX1MIN,FX1MAX,FY1MIN,FY1MAX
 9045   FORMAT('FX1MIN,FX1MAX,FY1MIN,FY1MAX= ',4E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9046)FXMIN,FXMAX,FYMIN,FYMAX
 9046   FORMAT('FXMIN,FXMAX,FYMIN,FYMAX= ',4E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9047)IX1TSC,IY1TSC
 9047   FORMAT('IX1TSC,IY1TSC = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9049)IBUGG4,ISUBG4,IERRG4
 9049   FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1                  AVALUE,IDIGIT,
     1                  NTOT,NUMROW,
     1                  ICAPSW,ICAPTY,ILAST,IFIRST,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE PRINTS A TWO-COLUMN TABLE, WHERE THE
C              FIRST COLUMN IS TEXT AND THE SECOND COLUMN IS
C              NUMERIC, IN HTML/LATEX/RTF/ASCII FORMATS.
C
C              1) ITITLE CONTAINS AN OVERALL TITLE (TO SKIP,
C                 SET NCTITL = 0)
C                 AN OPTIONAL SECOND LINE FOR THE TITLE MAY BE
C                 GIVEN IN ITITLZ
C              2) THE FIRST ROW OF ITEXT CONTAINS A HEADER
C                 ROW (SET NCTEXT(1) = 0 TO SKIP)
C              3) THE REMAINING ROWS CONTAIN TWO COLUMNS
C                 OF DATA - COLUMN 1 IS A TEXT FIELD AND
C                 COLUMN 2 IS A NUMERIC FIELD.
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/3
C     ORIGINAL VERSION--MARCH     2009.
C     UPDATED         --OCTOBER   2009. ADD ITITLZ FOR SECOND LINE
C                                       OF TITLE
C     UPDATED         --JANUARY   2011. USE DPDTLA TO CHECK FOR
C                                       CERTAIN CHARACTERS THAT NEED
C                                       TO BE ESCAPED FOR LATEX
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*(*) ITITLE
      CHARACTER*(*) ITITLZ
      CHARACTER*(*) ITEXT(*)
      REAL          AVALUE(*)
      INTEGER       IDIGIT(*)
      INTEGER       NCTEXT(*)
      INTEGER       NTOT(*)
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      LOGICAL IFLAG1
      LOGICAL IFLAG2
      LOGICAL IFLAG3
      LOGICAL ILAST
      LOGICAL IFIRST
      LOGICAL IBOLD
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXHED=50)
      INTEGER IWIDTH(MAXHED)
      INTEGER NUMDIG(MAXHED)
      CHARACTER*8 ALIGN(MAXHED)
      CHARACTER*8 VALIGN(MAXHED)
      COMMON/HTML4/IWIDTH,NUMDIG,ALIGN,VALIGN
      CHARACTER*132 IVALUE(2)
      INTEGER NCTEMP(2)
      REAL    AVAL(2)
C
      INTEGER NTOT2(2)
C
      CHARACTER*132 IHEAD
      CHARACTER*132 ITEMPC
C
      CHARACTER*4 IRTFMD
      COMMON/COMRTF/IRTFMD
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='A1  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTA1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDTA1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,53)NCTITL,NUMROW
   53   FORMAT('NCTITL,NUMROW = ',2I8)
        CALL DPWRST('XXX','WRIT')
        IF(NCTITL.GT.0)THEN
          NTEMP=MIN(80,NCTITL)
          WRITE(ICOUT,54)ITITLE(1:NTEMP)
   54     FORMAT('ITITL(1:NCTITL) = ',80A1)
          CALL DPWRST('XXX','WRIT')
        ENDIF
        IF(NUMROW.GT.0)THEN
          DO56I=1,NUMROW
            IF(NCTEXT(I).GT.0)THEN
              WRITE(ICOUT,57)I,ITEXT(I)(1:NCTEXT(I))
   57         FORMAT('I,ITEXT(I) = ',I8,A80)
              CALL DPWRST('XXX','WRIT')
            ENDIF
   56     CONTINUE
        ENDIF
      ENDIF
C
C               *******************************************
C               **   STEP 1--                            **
C               **   WRITE OUT THE TITLE AND HEADER LINE **
C               *******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DTA1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'ON')THEN
C
        CALL DPCONA(92,IBASLC)
C
        IHEAD=' '
        NCHEAD=0
        IF(NCTITZ.GT.0)THEN
          IHEAD(1:NCTITZ)=ITITLZ(1:NCTITZ)
          NCHEAD=NCTITZ
        ENDIF
        NHEAD=2
        IFLAG1=.TRUE.
        IFLAG2=.TRUE.
C
        IVALUE(1)=' '
        IVALUE(1)(1:NCTEXT(1))=ITEXT(1)(1:NCTEXT(1))
        NCTEMP(1)=NCTEXT(1)
        NCTEMP(2)=0
        IWIDTH(1)=0
        VALIGN(1)=' '
        NUMDIG(1)=0
        ALIGN(1) =' '
        IWIDTH(2)=0
        VALIGN(2)=' '
        NUMDIG(2)=0
        ALIGN(2) =' '
C
        IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
          IF(NCTITZ.GT.0)THEN
            ITEMPC(1:NCTITL)=ITITLE(1:NCTITL)
            NSTRT=NCTITL+1
            ITEMPC(NSTRT:NSTRT+3)='<BR>'
            NSTRT=NSTRT+4
            NSTRT2=NSTRT+NCTITZ-1
            ITEMPC(NSTRT:NSTRT2)=ITITLZ(1:NCTITZ)
            NSTRT=NSTRT2
            CALL DPHTM1(ITEMPC,NSTRT,IFLAG1,IFLAG2)
          ELSE
            CALL DPHTM1(ITITLE,NCTITL,IFLAG1,IFLAG2)
          ENDIF
          IWIDTH(1)=400
          VALIGN(1)='BOTTOM'
          ALIGN(1) ='LEFT'
          IVALUE(2)='&nbsp;'
          NCTEMP(2)=6
          IWIDTH(2)=150
          VALIGN(2)='BOTTOM'
          ALIGN(2) ='RIGHT'
          IFLAG1=.FALSE.
          IFLAG2=.FALSE.
          IF(NCTEXT(1).GT.0)THEN
            CALL DPHTM4(IVALUE,NCTEMP,NHEAD,IFLAG1,IFLAG2)
          ENDIF
C
        ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
          IF(IFIRST)THEN
            IFLAG1=.FALSE.
            IFLAG2=.FALSE.
            IFLAG3=.TRUE.
            CALL DPLAT6(IFLAG1,IFLAG2,IFLAG3)
          ENDIF
          IFLAG1=.FALSE.
          IF(IFIRST)IFLAG1=.TRUE.
          IFLAG2=.TRUE.
          CALL DPDTLA(ITITLE,NCTITL,NCT,ISUBRO,IBUGA3,IERROR)
          NCTITL=NCT
          CALL DPLAT1(ITITLE,NCTITL,IHEAD,NCHEAD,IFLAG1)
          NHEAD=2
          VALIGN(1)='b'
          ALIGN(1) ='l'
          VALIGN(2)='b'
          ALIGN(2) ='r'
          IFLAG1=.FALSE.
          IFLAG2=.FALSE.
          IFLAG3=.TRUE.
          CALL DPDTLA(IVALUE(1),NCTEMP(1),NCT,ISUBRO,IBUGA3,IERROR)
          NCTEMP(1)=NCT
          CALL DPLAT4(IVALUE,NCTEMP,NHEAD,IFLAG1,IFLAG2,IFLAG3)
C
        ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF ')THEN
C
 8091     FORMAT(A1,'f',I1)
          IF(IRTFFP.EQ.'Times New Roman')THEN
            ITEMP=0
          ELSEIF(IRTFFP.EQ.'Lucida Sans')THEN
            ITEMP=6
          ELSEIF(IRTFFP.EQ.'Arial')THEN
            ITEMP=2
          ELSEIF(IRTFFP.EQ.'Bookman')THEN
            ITEMP=3
          ELSEIF(IRTFFP.EQ.'Georgia')THEN
            ITEMP=4
          ELSEIF(IRTFFP.EQ.'Tahoma')THEN
            ITEMP=5
          ELSEIF(IRTFFP.EQ.'Verdana')THEN
            ITEMP=7
          ELSE
            ITEMP=0
          ENDIF 
C
          IRTFMD='OFF'
C
          NCHAR=NCTITL+3
          ITEMPC(4:NCHAR)=ITITLE(1:NCTITL)
          ITEMPC(1:3)=' b '
          ITEMPC(1:1)=IBASLC
          IF(NCTITZ.GT.0)THEN
            NCHAR2=NCTITZ+3
            IHEAD(4:NCHAR2)=ITITLZ(1:NCTITZ)
            IHEAD(1:3)=' b '
            IHEAD(1:1)=IBASLC
          ELSE
            NCHAR2=0
          ENDIF
          CALL DPRTF1(ITEMPC,NCHAR,IHEAD,NCHAR2)
C
          NCHAR=NCTEXT(1)+3
          NTEMP=NCTEXT(1)
          IVALUE(1)(4:NCHAR)=ITEXT(1)(1:NTEMP)
          IVALUE(1)(1:3)=' b '
          IVALUE(1)(1:1)=IBASLC
          NCTEMP(1)=NCHAR
          IDEFPS=20
          IFRST=IRTFPS*5500/IDEFPS
          IINC=IRTFPS*1400/IDEFPS
          IWIDTH(1)=IFRST
          VALIGN(1)='b'
          ALIGN(1) ='l'
          IWIDTH(2)=IWIDTH(1) + IINC
          VALIGN(2)='b'
          ALIGN(2) ='r'
          IFLAG1=.FALSE.
          IFLAG2=.FALSE.
          CALL DPRTF4(IVALUE,NCTEMP,NHEAD,IFLAG1,IFLAG2)
C
        ELSE
          IF(NCTITZ.LE.0)THEN
            CALL DPTAB1(ITITLE,NCTITL,IHEAD,NCHEAD,IFLAG1)
          ELSE
            CALL DPTABA(ITITLE,NCTITL,IHEAD,NCHEAD,IFLAG1)
          ENDIF
          IFLAG1=.FALSE.
          IFLAG2=.FALSE.
          NMAX=0
          CALL DPTAB4(IVALUE,NCTEMP,NHEAD,IFLAG1,IFLAG2,NMAX)
C
        ENDIF
C
C               *******************************************
C               **   STEP 2--                            **
C               **   WRITE OUT THE ROWS                  **
C               *******************************************
C
        ISTEPN='2'
        IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DTA1')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C       COMPUTE MAXIMUM SIZE FOR COLUMN 1
C
        NTOTMX=40
        DO210I=2,NUMROW
          NTOTMX=MAX(NTOTMX,NCTEXT(I))
 210    CONTINUE
C
        IF(NUMROW.GE.2)THEN
          NHEAD=1
          DO200I=2,NUMROW
C
            IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DTA1')THEN
              WRITE(ICOUT,999)
              CALL DPWRST('XXX','WRIT')
              WRITE(ICOUT,251)
  251         FORMAT('**** DPDTA1--WRITING ROWS OF TABLE')
              CALL DPWRST('XXX','WRIT')
              WRITE(ICOUT,252)I,IDIGIT(I),AVALUE(I),NCTEXT(I)
  252         FORMAT('I,IDIGIT(I),AVALUE(I),IDIGIT(I),',
     1               'NCTEXT(I) = ',2I5,G15.7,I5)
              CALL DPWRST('XXX','WRIT')
              NTEMP=NCTEXT(I)
              WRITE(ICOUT,253)ITEXT(I)(1:NTEMP)
  253         FORMAT('ITEXT(I) = ',A80)
              CALL DPWRST('XXX','WRIT')
            ENDIF
C
            IF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'HTML')THEN
              IBOLD=.FALSE.
              IWIDTH(1)=300
              VALIGN(1)='BOTTOM'
              ALIGN(1) ='LEFT'
              NUMDIG(1)=IDIGIT(I)
              IWIDTH(2)=150
              VALIGN(2)='BOTTOM'
              ALIGN(2) ='RIGHT'
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              CALL DPHTM5(ITEXT(I),NCTEXT(I),AVALUE(I),NHEAD,IBOLD)
C
            ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'LATE')THEN
              IFLAG1=.FALSE.
              NUMDIG(1)=IDIGIT(I)
              NUMDIG(2)=IDIGIT(I)
              CALL DPDTLA(ITEXT(I),NCTEXT(I),NCT,ISUBRO,IBUGA3,IERROR)
              NCTEXT(I)=NCT
              CALL DPLAT5(ITEXT(I),NCTEXT(I),AVALUE(I),NHEAD,
     1                    IFLAG1)
            ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'RTF')THEN
              IFLAG1=.FALSE.
              VALIGN(1)='b'
              ALIGN(1) ='l'
              NUMDIG(1)=-1
              VALIGN(2)='b'
              ALIGN(2) ='r'
              NUMDIG(2)=IDIGIT(I)
              AVAL(1)=0.0
              AVAL(2)=AVALUE(I)
              NCHAR=NCTEXT(I)+3
              NTEMP=NCTEXT(I)
              ITEMPC(4:NCHAR)=ITEXT(I)(1:NTEMP)
              ITEMPC(1:3)=' b '
              ITEMPC(1:1)=IBASLC
              CALL DPRTF5(ITEMPC,NCHAR,AVAL,NHEAD,IFLAG1)
            ELSE
              IFLAG1=.FALSE.
              NMAX=0
CCCCC         NCTEXT(I)=40
              NUMDIG(1)=IDIGIT(I)
CCCCC         NTOT2(1)=40
              NTOT2(1)=NTOTMX
              NTOT2(2)=NTOT(I)
              CALL DPTAB5(ITEXT(I),NCTEXT(I),AVALUE(I),NHEAD,
     1                    IFLAG1,NMAX,NTOT2)
            ENDIF
  200     CONTINUE
        ENDIF
C
C               *******************************************
C               **   STEP 3--                            **
C               **   TERMINATE THE TABLE                 **
C               *******************************************
C
        ISTEPN='2'
        IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DTA1')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'HTML')THEN
          IFLAG1=.TRUE.
          IFLAG2=.TRUE.
          IFLAG2=.FALSE.
          IF(ILAST)IFLAG2=.TRUE.
          CALL DPHTM2(IFLAG1,IFLAG2,NHEAD)
        ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'LATE')THEN
          IFLAG1=.TRUE.
          IFLAG2=.FALSE.
          IFLAG3=.FALSE.
          IF(ILAST)THEN
            IFLAG2=.TRUE.
            IFLAG3=.TRUE.
          ENDIF
          CALL DPLATZ(IFLAG1,IFLAG2,IFLAG3,NHEAD)
        ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'RTF')THEN
          IF(IRTFFF.EQ.'Courier New')THEN
            ITEMP=1
          ELSEIF(IRTFFF.EQ.'Lucida Console')THEN
            ITEMP=8
          ENDIF 
          WRITE(ICOUT,8091)IBASLC,ITEMP
          CALL DPWRST(ICOUT,'WRIT')
          CALL DPRTF6(NHEAD)
          CALL DPRTF6(NHEAD)
          IF(ILAST)THEN
            IRTFMD='VERB'
          ENDIF
        ELSE
          IF(ILAST)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
          ENDIF
        ENDIF
C
      ENDIF
C
 9000 CONTINUE
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTA1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF DPDTA1--')
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDTA2(ITITL9,NCTIT9,
     1                  IHEAD,NCHEAD,ITITLE,NCTITL,
     1                  MAXLIN,NUMLIN,MAXCOL,NUMCOL,
     1                  ITEXT,NCTEXT,AVAL,MAXROW,NUMROW,
     1                  IDIGIT,NTOT,IWHTML,IWRTF,VALIGZ,ALIGNZ,NMAX,
     1                  ICAPSW,ICAPTY,IFIRST,ILAST,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE PRINTS A MULTI-COLUMN TABLE CONSISTING OF:
C
C              1) AN OPTIONAL OVERALL TITLE
C              2) HEADERS FOR EACH OF THE COLUMNS (THESE HEADERS MAY
C                 CONTAIN MULTIPLE LINES).
C              3) A TABLE OF NUMERIC VALUES.  IT MAY ALSO OPTIONALLY
C                 CONTAIN A CHARACTER FIELD FOR COLUMN ONE.
C
C              ITITL9     => THE OVERALL TITLE
C              IHEAD      => TABLE CAPTION
C              ITITLE     => LINES FOR THE COLUMN HEADERS
C              ITEXT      => CHARACTER ARRAY FOR COLUMN 1
C              AVAL       => MATRIX OF NUMERIC VALUES FOR THE TABLE
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/3
C     ORIGINAL VERSION--MARCH     2009.
C     UPDATED         --APRIL     2009. ADD THE OPTIONAL OVERALL TITLE
C     UPDATED         --APRIL     2009. FOR LATEX, CHECK FOR "%" AND
C                                       REPLACE WITH "\%"
C     UPDATED         --APRIL     2009. IF NUMERIC VALUE IS EQUAL TO
C                                       CPUMIN, SET DIGITS TO -99 AND
C                                       (THIS WILL THEN BE PRINTED
C                                       AS "**")
C     UPDATED         --APRIL     2009. ALLOW CALLING ROUTINE TO
C                                       SPECIFY THE POINT SIZE FOR
C                                       RTF
C     UPDATED         --JANUARY   2011. USE DPDTLA TO CHECK FOR
C                                       CERTAIN CHARACTERS THAT NEED
C                                       TO BE ESCAPED FOR LATEX
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*(*) IHEAD
      CHARACTER*(*) ITITL9
      CHARACTER*(*) ITITLE(MAXLIN,MAXCOL)
      CHARACTER*(*) ITEXT(MAXROW)
      CHARACTER*4   VALIGZ(*)
      CHARACTER*4   ALIGNZ(*)
      INTEGER       NCTITL(MAXLIN,MAXCOL)
      INTEGER       NCTEXT(MAXROW)
      INTEGER       IDIGIT(*)
      INTEGER       NTOT(*)
      INTEGER       IWHTML(*)
      INTEGER       IWRTF(*)
      REAL          AVAL(MAXROW,MAXCOL)
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      LOGICAL IFLAG1
      LOGICAL IFLAG2
      LOGICAL IFLAG3
      LOGICAL IBOLD
      LOGICAL IFIRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXHED=50)
      INTEGER IWIDTH(MAXHED)
      INTEGER NUMDIG(MAXHED)
      CHARACTER*8 ALIGN(MAXHED)
      CHARACTER*8 VALIGN(MAXHED)
      COMMON/HTML4/IWIDTH,NUMDIG,ALIGN,VALIGN
      CHARACTER*60 IVALUE(MAXHED)
      INTEGER      NCTEMP(MAXHED)
      REAL         AVALUE(MAXHED)
C
      CHARACTER*132 ITEMPC
C
      CHARACTER*4 IRTFMD
      COMMON/COMRTF/IRTFMD
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='A2  '
C
      IERROR='NO'
C
      DO40I=1,MAXHED
        IVAlUE(I)=' '
        AVALUE(I)=0.0
        NCTEMP(I)=0
   40 CONTINUE
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTA2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDTA2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,53)MAXLIN,MAXROW,NUMROW,NUMCOL,NUMLIN
   53   FORMAT('MAXLIN,MAXROW,NUMROW,NUMCOL,NUMLIN = ',5I8)
        CALL DPWRST('XXX','WRIT')
        IF(NUMLIN.GT.0)THEN
          DO54I=1,NUMLIN
            DO55J=1,NUMCOL
              IF(I.EQ.1)THEN
                WRITE(ICOUT,58)J,NTOT(J),IDIGIT(J)
   58           FORMAT('J,NTOT(J),IDIGIT(J) = ',3I8)
                CALL DPWRST('XXX','WRIT')
              ENDIF
              IF(NCTITL(I,J).GT.0)THEN
                NTEMP=MIN(80,NCTITL(I,J))
                WRITE(ICOUT,56)I,J,NCTITL(I,J),ITITLE(I,J)(1:NTEMP)
   56           FORMAT('I,J,NCTITL(I,J),ITITL(I,J)(1:NCTITL) = ',
     1                 3I5,2X,A80)
                CALL DPWRST('XXX','WRIT')
              ENDIF
   55       CONTINUE
   54     CONTINUE
        ENDIF
        IF(NUMROW.GT.0)THEN
          DO57I=1,NUMROW
            IF(NCTEXT(I).GT.0)THEN
              WRITE(ICOUT,59)I,ITEXT(I)(1:NCTEXT(I))
   59         FORMAT('I,ITEXT(I) = ',I8,A80)
              CALL DPWRST('XXX','WRIT')
            ENDIF
            WRITE(ICOUT,60)I,(AVAL(I,J),J=1,MIN(5,NUMCOL))
   60       FORMAT('I,(AVAL(I,J),J=1,NUMCOL) = ',I8,5G15.7)
            CALL DPWRST('XXX','WRIT')
   57     CONTINUE
        ENDIF
        WRITE(ICOUT,62)NCHEAD
   62   FORMAT('NCHEAD = ',I5)
        CALL DPWRST('XXX','WRIT')
        IF(NCHEAD.GT.0)THEN
          WRITE(ICOUT,63)IHEAD(1:NCHEAD)
   63     FORMAT('NCHEAD,IHEAD = ',A80)
          CALL DPWRST('XXX','WRIT')
        ENDIF
      ENDIF
C
C               ******************************************
C               **   STEP 1--                           **
C               **   WRITE OUT THE TABLE HEADER.        **
C               **   NOTE THAT THIS MAY CONSIST OF      **
C               **   MULTIPLE LINES.                    **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DTA2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'ON')THEN
C
        CALL DPCONA(92,IBASLC)
C
        NHEAD=NUMCOL
        IF(NCTEXT(1).GT.0)NHEAD=NUMCOL+1
C
        DO100I=1,NHEAD
          IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
            IWIDTH(I)=IWHTML(I)
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='BOTTOM'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='CENTER'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='TOP'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='LEFT'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='CENTER'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='RIGHT'
            ENDIF
C
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='b'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='c'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='t'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='l'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='c'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='r'
            ENDIF
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF')THEN
            IWIDTH(I)=IWRTF(I)
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='b'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='c'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='t'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='l'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='c'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='r'
            ENDIF
          ELSE
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='b'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='c'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='t'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='l'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='c'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='r'
            ENDIF
          ENDIF
  100   CONTINUE
C
C       LOOP THROUGH THE LINES OF THE HEADER
C
        IF(NUMLIN.GE.1)THEN
          DO110I=1,NUMLIN
C
            DO120J=1,NHEAD
              IVALUE(J)=' '
              NCTEMP(J)=0
              IF(NCTITL(I,J).GT.0)THEN
                NCTEMP(J)=NCTITL(I,J)
                IVALUE(J)(1:NCTEMP(J))=ITITLE(I,J)(1:NCTEMP(J))
              ENDIF
C
              IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTA2')THEN
                WRITE(ICOUT,106)I,J,NCTEMP(J),IVALUE(J)
  106           FORMAT('I,J,NCTEMP(J),IVALUE(J) = ',3I8,A80)
                CALL DPWRST('XXX','WRIT')
              ENDIF
C
  120       CONTINUE
C
            IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
              IF(I.EQ.1)THEN
                IFLAG1=.FALSE.
                IF(IFIRST)IFLAG1=.TRUE.
                IFLAG2=.TRUE.
                IF(NCTIT9.LE.0)THEN
                  IF(IFIRST)THEN
                    CALL DPHTM1(IHEAD,NCHEAD,IFLAG1,IFLAG2)
                  ELSE
                    CALL DPHTMA(ITITL9,NCTIT9,IHEAD,NCHEAD,
     1                          IFLAG1,IFLAG2)
                  ENDIF
                ELSE
                  CALL DPHTMA(ITITL9,NCTIT9,IHEAD,NCHEAD,IFLAG1,IFLAG2)
                ENDIF
              ENDIF
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
              CALL DPHTM4(IVALUE,NCTEMP,NHEAD,IFLAG1,IFLAG2)
C
            ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
C
              IF(I.EQ.1)THEN
                IF(IFIRST)THEN
                  IFLAG1=.FALSE.
                  IFLAG2=.FALSE.
                  IFLAG3=.TRUE.
                  CALL DPLAT6(IFLAG1,IFLAG2,IFLAG3)
                ENDIF
                IFLAG1=.FALSE.
                IF(IFIRST)IFLAG1=.TRUE.
                IFLAG2=.TRUE.
C
                CALL DPDTLA(IHEAD,NCHEAD,NCT,ISUBRO,IBUGA3,IERROR)
                NCHEAD=NCT
C
                IF(NCTIT9.LE.0)THEN
                  ITEMPC=' '
                  NCHEA2=0
                  CALL DPLAT1(IHEAD,NCHEAD,ITEMPC,NCHEA2,IFLAG1)
                ELSE
C
                  CALL DPDTLA(ITITL9,NCTIT9,NCT,ISUBRO,IBUGA3,IERROR)
                  NCTIT9=NCT
C
                  CALL DPLAT1(ITITL9,NCTIT9,IHEAD,NCHEAD,IFLAG1)
                ENDIF
              ENDIF
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IFLAG3=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
              IF(I.EQ.1)IFLAG3=.TRUE.
C
              DO6110JJ=1,NHEAD
                NCT=NCTEMP(JJ)
                DO6130II=NCTEMP(JJ),1,-1
                  IF(IVALUE(JJ)(II:II).EQ.'%')THEN
                    DO6140J=NCT,II,-1
                      IVALUE(JJ)(J+1:J+1)=IVALUE(JJ)(J:J)
 6140               CONTINUE
                    NCT=NCT+1
                    IVALUE(JJ)(II:II)=IBASLC
                  ENDIF
 6130           CONTINUE
                NCTEMP(JJ)=NCT
 6110         CONTINUE
C
              CALL DPLAT4(IVALUE,NCTEMP,NHEAD,IFLAG1,IFLAG2,IFLAG3)
C
            ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF ')THEN
C
 8091         FORMAT(A1,'f',I1)
              IF(I.EQ.1)THEN
                IF(IRTFFP.EQ.'Times New Roman')THEN
                  ITEMP=0
                ELSEIF(IRTFFP.EQ.'Lucida Sans')THEN
                  ITEMP=6
                ELSEIF(IRTFFP.EQ.'Arial')THEN
                  ITEMP=2
                ELSEIF(IRTFFP.EQ.'Bookman')THEN
                  ITEMP=3
                ELSEIF(IRTFFP.EQ.'Georgia')THEN
                  ITEMP=4
                ELSEIF(IRTFFP.EQ.'Tahoma')THEN
                  ITEMP=5
                ELSEIF(IRTFFP.EQ.'Verdana')THEN
                  ITEMP=7
                ELSE
                  ITEMP=0
                ENDIF 
C
                IRTFMD='OFF'
C
                IF(NCHEAD.GE.1.AND.I.EQ.1)THEN
                  NCTEM2=NCHEAD+3
                  IHEAD(4:NCTEM2)=IHEAD(1:NCHEAD)
                  IHEAD(1:3)=' b '
                  IHEAD(1:1)=IBASLC
                  IF(NCTIT9.LE.0)THEN
                    ITEMPC=' '
                    NCHEA2=0
                  ELSE
                    NCHEA2=NCTIT9+3
                    ITEMPC(4:NCHEA2)=ITITL9(1:NCTIT9)
                    ITEMPC(1:3)=' b '
                    ITEMPC(1:1)=IBASLC
                  ENDIF
                  CALL DPRTF1(ITEMPC,NCHEA2,IHEAD,NCTEM2)
                ENDIF
              ENDIF
C
              DO130J=1,NHEAD
                NCHAR=NCTEMP(J)+3
                IVALUE(J)(4:NCHAR)=IVALUE(J)(1:NCTEMP(J))
                IVALUE(J)(1:3)=' b '
                IVALUE(J)(1:1)=IBASLC
                NCTEMP(J)=NCHAR
  130         CONTINUE
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
              CALL DPRTF4(IVALUE,NCTEMP,NHEAD,IFLAG1,IFLAG2)
            ELSE
              IF(I.EQ.1)THEN
                IFLAG1=.TRUE.
                CALL DPTAB1(ITITL9,NCTIT9,IHEAD,NCHEAD,IFLAG1)
              ENDIF
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
C
              DO 141 KK=1,NHEAD
                IF(ALIGN(KK).EQ.'l' .AND. NCTEMP(KK).LT.NTOT(KK))THEN
                  DO146JJ=NCTEMP(KK)+1,NTOT(KK)
                    IVALUE(KK)(JJ:JJ)=' '
  146             CONTINUE
                  NCTEMP(KK)=NTOT(KK)
                ELSEIF(ALIGN(KK).EQ.'c'.AND.NCTEMP(KK).LT.NTOT(KK))THEN
                  IVALUE(KK)(NCTEMP(KK):NTOT(KK))=' '
                  IDIFF=(NTOT(KK)-NCTEMP(KK))/2
                  IF(IDIFF.GT.0)THEN
                    DO147JJ=NTOT(KK),IDIFF+1,-1
                      IVALUE(KK)(JJ:JJ)=IVALUE(KK)(JJ-IDIFF:JJ-IDIFF)
  147               CONTINUE
                    IVALUE(KK)(1:IDIFF)=' '
                  ENDIF
                  NCTEMP(KK)=NTOT(KK)
                ELSEIF(ALIGN(KK).EQ.'r'.AND.NCTEMP(KK).LT.NTOT(KK))THEN
C
                  IF(ISUBRO.EQ.'DTA2' .OR. IBUGA3.EQ.'ON')THEN
                    WRITE(ICOUT,157)KK,NCTEMP(KK),NTOT(KK)
  157               FORMAT('BEFORE 148: KK,NCTEMP(KK),NTOT(KK) =',
     1                     3I8)
                    CALL DPWRST('XXX','WRIT')
                    WRITE(ICOUT,153)IVALUE(KK)(1:NCTEMP(KK))
                    CALL DPWRST('XXX','WRIT')
                  ENDIF
C
                  IDIFF=NTOT(KK)-NCTEMP(KK)
                  DO148JJ=NTOT(KK),IDIFF+1,-1
                    IVALUE(KK)(JJ:JJ)=IVALUE(KK)(JJ-IDIFF:JJ-IDIFF)
  148             CONTINUE
                  IVALUE(KK)(1:IDIFF)=' '
                  NCTEMP(KK)=NTOT(KK)
                ENDIF
C
                IF(ISUBRO.EQ.'DTA2' .OR. IBUGA3.EQ.'ON')THEN
                  WRITE(ICOUT,151)KK,IDIFF,NCTEMP(KK),NUMCOL,NMAX
  151             FORMAT('BEFORE CALL DPTAB4: KK,IDIFF,NCTEMP(KK),',
     1                   'NUMCOL,NMAX=',5I8)
                  CALL DPWRST('XXX','WRIT')
                  WRITE(ICOUT,153)IVALUE(KK)(1:NCTEMP(KK))
  153             FORMAT('IVALUE(KK) = ',A80)
                  CALL DPWRST('XXX','WRIT')
                ENDIF
C
  141         CONTINUE
C
              CALL DPTAB4(IVALUE,NCTEMP,NHEAD,IFLAG1,IFLAG2,NMAX)
C
            ENDIF
  110     CONTINUE
        ENDIF
C
C               ******************************************
C               **   STEP 2--                           **
C               **   WRITE OUT THE TABLE ROWS           **
C               ******************************************
C
        MAXLTA=35
        ILINE=0
        IF(NUMROW.GE.1)THEN
          DO200I=1,NUMROW
C
            IFLAG1=.FALSE.
            IF(I.EQ.NUMROW)IFLAG1=.TRUE.
            ISTRT=0
CCCCC       IF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'LATE')ISTRT=1
            IF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'RTF'.AND.
     1        NCTEXT(I).GT.0)ISTRT=1
            DO210J=1,NUMCOL
              AVALUE(ISTRT+J)=AVAL(I,J)
              IF(AVALUE(ISTRT+J).EQ.CPUMIN)THEN
                NUMDIG(ISTRT+J)=-99
              ELSE
                NUMDIG(ISTRT+J)=IDIGIT(J)
              ENDIF
  210       CONTINUE
C
C           FOR HTML, SHIFT DEPENDING ON WHETHER HEADER COLUMN
C           IS GIVEN.
C
            IF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'HTML')THEN
              IBOLD=.FALSE.
              IF(I.EQ.1)THEN
                IF(NCTEXT(1).GT.0)THEN
                  DO211J=1,NUMCOL
                    ALIGN(J)=ALIGN(J)
                    VALIGN(J)=VALIGN(J)
                    IWIDTH(J)=IWIDTH(J)
  211             CONTINUE
                ELSE
                  DO212J=NUMCOL+1,2,-1
                    ALIGN(J)=ALIGN(J-1)
                    VALIGN(J)=VALIGN(J-1)
                    IWIDTH(J)=IWIDTH(J-1)
  212             CONTINUE
                ENDIF
              ENDIF
              CALL DPHTM5(ITEXT(I),NCTEXT(I),AVALUE,NUMCOL,IBOLD)
C
C           FOR LATEX, WE CANNOT EXTEND TABLES BEYOND A SINGLE
C           PAGE, SO PUT A CHECK IN.
C
            ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'LATE')THEN
              CALL DPDTLA(ITEXT(I),NCTEXT(I),NCT,ISUBRO,IBUGA3,IERROR)
              NCTEXT(I)=NCT
              CALL DPLAT5(ITEXT(I),NCTEXT(I),AVALUE,NUMCOL,IFLAG1)
              ILINE=ILINE+1
              IF(ILINE.EQ.MAXLTA .AND. I.NE.NUMROW)THEN
                ILINE=0
                IFLAG1=.TRUE.
                IFLAG2=.FALSE.
                IFLAG3=.TRUE.
                CALL DPLATZ(IFLAG1,IFLAG2,IFLAG3,NHEAD)
                IFLAG1=.FALSE.
                IFLAG2=.FALSE.
                IFLAG3=.TRUE.
                CALL DPLATY(NHEAD)
              ENDIF
            ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'RTF')THEN
              IF(NCTEXT(I).GT.0)THEN
                NCHAR=NCTEXT(I)+3
                ITEXT(I)(4:NCHAR)=ITEXT(I)(1:NCTEXT(I))
                ITEXT(I)(1:3)=' b '
                ITEXT(I)(1:1)=IBASLC
                NCTEXT(I)=NCHAR
              ELSE
                NCHAR=0
              ENDIF
              IFLAG1=.FALSE.
              CALL DPRTF5(ITEXT(I),NCHAR,AVALUE,NUMCOL,IFLAG1)
            ELSE
              IF(NCTEXT(I).EQ.0)ITEXT(I)=' '
C
              IF(ISUBRO.EQ.'DTA2' .OR. IBUGA3.EQ.'ON')THEN
                WRITE(ICOUT,251)I,NUMCOL,NMAX
  251           FORMAT('BEFORE CALL DPTAB5: I,NUMCOL,NMAX = ',3I5)
                CALL DPWRST('XXX','WRIT')
                WRITE(ICOUT,252)NCTEXT(I),ITEXT(I)(1:40)
  252           FORMAT('NCTEXT(I),ITEXT(I)(1:40) = ',I8,A40)
                CALL DPWRST('XXX','WRIT')
                WRITE(ICOUT,253)(AVALUE(JJ),JJ=1,MIN(6,NUMCOL))
  253           FORMAT('AVALUE(J),J=1,...,6 = ',6G15.7)
                CALL DPWRST('XXX','WRIT')
              ENDIF
C
              CALL DPTAB5(ITEXT(I),NCTEXT(I),AVALUE,NUMCOL,IFLAG1,
     1                    NMAX,NTOT)
            ENDIF
  200     CONTINUE
        ENDIF
C
C               *******************************************
C               **   STEP 3--                            **
C               **   TERMINATE THE TABLE                 **
C               *******************************************
C
        ISTEPN='2'
        IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DTA2')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'HTML')THEN
          IFLAG1=.TRUE.
          IFLAG2=.FALSE.
          IF(ILAST)IFLAG2=.TRUE.
          CALL DPHTM2(IFLAG1,IFLAG2,NHEAD)
        ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'LATE')THEN
          IFLAG1=.TRUE.
          IFLAG2=.FALSE.
          IFLAG3=.FALSE.
          IF(ILAST)THEN
            IFLAG2=.TRUE.
            IFLAG3=.TRUE.
          ENDIF
          CALL DPLATZ(IFLAG1,IFLAG2,IFLAG3,NHEAD)
        ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'RTF')THEN
          IF(IRTFFF.EQ.'Courier New')THEN
            ITEMP=1
          ELSEIF(IRTFFF.EQ.'Lucida Console')THEN
            ITEMP=8
          ENDIF 
          WRITE(ICOUT,8091)IBASLC,ITEMP
          CALL DPWRST(ICOUT,'WRIT')
          CALL DPRTF6(NHEAD)
          CALL DPRTF6(NHEAD)
          IF(ILAST)THEN
            IRTFMD='VERB'
          ENDIF
        ELSE
          IF(ILAST)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
          ENDIF
        ENDIF
C
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE DPDTA4(ITITL9,NCTIT9,
     1                  IHEAD,NCHEAD,ITITLE,NCTITL,
     1                  MAXLIN,NUMLIN,MAXCOL,NUMCOL,
     1                  ITEXT,NCTEXT,AVAL,ITYPCO,MAXROW,NUMROW,
     1                  IDIGIT,NTOT,IWHTML,IWRTF,VALIGZ,ALIGNZ,NMAX,
     1                  ICAPSW,ICAPTY,IFIRST,ILAST,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE PRINTS A MULTI-COLUMN TABLE CONSISTING OF:
C
C              1) AN OPTIONAL OVERALL TITLE
C              2) HEADERS FOR EACH OF THE COLUMNS (THESE HEADERS MAY
C                 CONTAIN MULTIPLE LINES).
C              3) A TABLE OF NUMERIC/CHARACTER VALUES.  THIS IS A
C                 VARIANT OF TABLE 2 (WHICH ONLY ALLOWS TEXT FIELDS
C                 FOR THE FIRST COLUMN).
C
C              ITITL9     => THE OVERALL TITLE
C              IHEAD      => TABLE CAPTION
C              ITITLE     => LINES FOR THE COLUMN HEADERS
C              AVAL       => MATRIX OF NUMERIC VALUES FOR THE TABLE
C              ITEXT      => MATRIX OF CHARACTER VALUES FOR THE TABLE
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/9
C     ORIGINAL VERSION--SEPTEMBER 2009.
C     UPDATED         --JANUARY   2011. USE DPDTLA TO CHECK FOR
C                                       CERTAIN CHARACTERS THAT NEED
C                                       TO BE ESCAPED FOR LATEX
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*(*) IHEAD
      CHARACTER*(*) ITITL9
      CHARACTER*(*) ITITLE(MAXLIN,MAXCOL)
      CHARACTER*4   VALIGZ(*)
      CHARACTER*4   ALIGNZ(*)
      INTEGER       NCTITL(MAXLIN,MAXCOL)
      INTEGER       NCTEXT(MAXROW,MAXCOL)
      INTEGER       IDIGIT(*)
      INTEGER       NTOT(*)
      INTEGER       IWHTML(*)
      INTEGER       IWRTF(*)
      REAL          AVAL(MAXROW,MAXCOL)
      CHARACTER*(*) ITEXT(MAXROW,MAXCOL)
      CHARACTER*4   ITYPCO(MAXCOL)
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      LOGICAL IFLAG1
      LOGICAL IFLAG2
      LOGICAL IFLAG3
      LOGICAL IFLAGA
      LOGICAL IFLAGB
      LOGICAL IBOLD
      LOGICAL IFIRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXHED=50)
      INTEGER IWIDTH(MAXHED)
      INTEGER NUMDIG(MAXHED)
      CHARACTER*8 ALIGN(MAXHED)
      CHARACTER*8 VALIGN(MAXHED)
      COMMON/HTML4/IWIDTH,NUMDIG,ALIGN,VALIGN
      CHARACTER*60 IVALUE(MAXHED)
      INTEGER      NCTEMP(MAXHED)
      REAL         AVALUE(MAXHED)
C
      CHARACTER*132 ITEMPC
C
      CHARACTER*4 IRTFMD
      COMMON/COMRTF/IRTFMD
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='A4  '
C
      IERROR='NO'
C
      DO40I=1,MAXHED
        IVALUE(I)=' '
        AVALUE(I)=0.0
        NCTEMP(I)=0
   40 CONTINUE
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTA4')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDTA4--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,53)MAXLIN,MAXROW,NUMROW,NUMCOL,NUMLIN
   53   FORMAT('MAXLIN,MAXROW,NUMROW,NUMCOL,NUMLIN = ',5I8)
        CALL DPWRST('XXX','WRIT')
        IF(NUMLIN.GT.0)THEN
          DO54I=1,NUMLIN
            DO55J=1,NUMCOL
              IF(NCTITL(I,J).GT.0)THEN
                NTEMP=MIN(80,NCTITL(I,J))
                WRITE(ICOUT,56)I,J,NCTITL(I,J),ITITLE(I,J)(1:NTEMP)
   56           FORMAT('I,J,NCTITL(I,J),ITITL(I,J)(1:NCTITL) = ',
     1                 3I5,2X,A80)
                CALL DPWRST('XXX','WRIT')
              ENDIF
   55       CONTINUE
   54     CONTINUE
        ENDIF
        IF(NUMROW.GT.0)THEN
          DO57I=1,NUMROW
            WRITE(ICOUT,60)I,(AVAL(I,J),J=1,MIN(5,NUMCOL))
   60       FORMAT('I,(AVAL(I,J),J=1,NUMCOL) = ',I8,5G15.7)
            CALL DPWRST('XXX','WRIT')
   57     CONTINUE
          DO77I=1,NUMROW
          DO79J=1,NUMCOL
            WRITE(ICOUT,80)I,J,ITEXT(I,J)
   80       FORMAT('I,J,ITEXT(I,J) = ',2I5,2X,A60)
            CALL DPWRST('XXX','WRIT')
   79     CONTINUE
   77     CONTINUE
        ENDIF
        WRITE(ICOUT,62)NCHEAD
   62   FORMAT('NCHEAD = ',I5)
        CALL DPWRST('XXX','WRIT')
        IF(NCHEAD.GT.0)THEN
          WRITE(ICOUT,63)IHEAD(1:NCHEAD)
   63     FORMAT('NCHEAD,IHEAD = ',A80)
          CALL DPWRST('XXX','WRIT')
        ENDIF
      ENDIF
C
C               ******************************************
C               **   STEP 1--                           **
C               **   WRITE OUT THE TABLE HEADER.        **
C               **   NOTE THAT THIS MAY CONSIST OF      **
C               **   MULTIPLE LINES.                    **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DTA4')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'ON')THEN
C
        CALL DPCONA(92,IBASLC)
C
        NHEAD=NUMCOL
C
        DO100I=1,NUMCOL
          IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
            IWIDTH(I)=IWHTML(I)
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='BOTTOM'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='CENTER'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='TOP'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='LEFT'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='CENTER'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='RIGHT'
            ENDIF
C
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='b'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='c'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='t'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='l'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='c'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='r'
            ENDIF
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF')THEN
            IWIDTH(I)=IWRTF(I)
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='b'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='c'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='t'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='l'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='c'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='r'
            ENDIF
          ELSE
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='b'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='c'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='t'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='l'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='c'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='r'
            ENDIF
          ENDIF
  100   CONTINUE
C
C       LOOP THROUGH THE LINES OF THE HEADER
C
        IF(NUMLIN.GE.1)THEN
          DO110I=1,NUMLIN
C
            DO120J=1,NUMCOL
              IVALUE(J)=' '
              NCTEMP(J)=0
              IF(NCTITL(I,J).GT.0)THEN
                NCTEMP(J)=NCTITL(I,J)
                IVALUE(J)(1:NCTEMP(J))=ITITLE(I,J)(1:NCTEMP(J))
              ENDIF
C
              IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTA4')THEN
                WRITE(ICOUT,106)I,J,NCTEMP(J),IVALUE(J)
  106           FORMAT('I,J,NCTEMP(J),IVALUE(J) = ',3I8,A80)
                CALL DPWRST('XXX','WRIT')
              ENDIF
C
  120       CONTINUE
C
            IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
              IF(I.EQ.1)THEN
                IFLAG1=.FALSE.
                IF(IFIRST)IFLAG1=.TRUE.
                IFLAG2=.TRUE.
                IF(NCTIT9.LE.0)THEN
                  IF(IFIRST)THEN
                    CALL DPHTM1(IHEAD,NCHEAD,IFLAG1,IFLAG2)
                  ELSE
                    CALL DPHTMA(ITITL9,NCTIT9,IHEAD,NCHEAD,
     1                          IFLAG1,IFLAG2)
                  ENDIF
                ELSE
                  CALL DPHTMA(ITITL9,NCTIT9,IHEAD,NCHEAD,IFLAG1,IFLAG2)
                ENDIF
              ENDIF
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
              CALL DPHTM4(IVALUE,NCTEMP,NUMCOL,IFLAG1,IFLAG2)
C
            ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
C
              IF(I.EQ.1)THEN
                IF(IFIRST)THEN
                  IFLAG1=.FALSE.
                  IFLAG2=.FALSE.
                  IFLAG3=.TRUE.
                  CALL DPLAT6(IFLAG1,IFLAG2,IFLAG3)
                ENDIF
                IFLAG1=.FALSE.
                IF(IFIRST)IFLAG1=.TRUE.
                IFLAG2=.TRUE.
C
                CALL DPDTLA(IHEAD,NCHEAD,NCT,ISUBRO,IBUGA3,IERROR)
                NCHEAD=NCT
C
                IF(NCTIT9.LE.0)THEN
                  ITEMPC=' '
                  NCHEA2=0
                  CALL DPLAT1(IHEAD,NCHEAD,ITEMPC,NCHEA2,IFLAG1)
                ELSE
C
                NCT=NCTIT9
                DO6030II=NCTIT9,1,-1
                  IF(ITITL9(II:II).EQ.'%')THEN
                    DO6040J=NCT,II,-1
                      ITITL9(J+1:J+1)=ITITL9(J:J)
 6040               CONTINUE
                    NCT=NCT+1
                    ITITL9(II:II)=IBASLC
                  ENDIF
 6030           CONTINUE
                NCTIT9=NCT
C
                  CALL DPLAT1(ITITL9,NCTIT9,IHEAD,NCHEAD,IFLAG1)
                ENDIF
              ENDIF
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IFLAG3=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
              IF(I.EQ.1)IFLAG3=.TRUE.
C
              DO6110JJ=1,NUMCOL
                CALL DPDTLA(IVALUE(JJ),NCTEMP(JJ),NCT,
     1                      ISUBRO,IBUGA3,IERROR)
                NCTEMP(JJ)=NCT
 6110         CONTINUE
C
              CALL DPLAT4(IVALUE,NCTEMP,NUMCOL,IFLAG1,IFLAG2,IFLAG3)
C
            ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF ')THEN
C
 8091         FORMAT(A1,'f',I1)
              IF(I.EQ.1)THEN
                IF(IRTFFP.EQ.'Times New Roman')THEN
                  ITEMP=0
                ELSEIF(IRTFFP.EQ.'Lucida Sans')THEN
                  ITEMP=6
                ELSEIF(IRTFFP.EQ.'Arial')THEN
                  ITEMP=2
                ELSEIF(IRTFFP.EQ.'Bookman')THEN
                  ITEMP=3
                ELSEIF(IRTFFP.EQ.'Georgia')THEN
                  ITEMP=4
                ELSEIF(IRTFFP.EQ.'Tahoma')THEN
                  ITEMP=5
                ELSEIF(IRTFFP.EQ.'Verdana')THEN
                  ITEMP=7
                ELSE
                  ITEMP=0
                ENDIF 
C
                IRTFMD='OFF'
C
                IF(NCHEAD.GE.1.AND.I.EQ.1)THEN
                  NCTEM2=NCHEAD+3
                  IHEAD(4:NCTEM2)=IHEAD(1:NCHEAD)
                  IHEAD(1:3)=' b '
                  IHEAD(1:1)=IBASLC
                  IF(NCTIT9.LE.0)THEN
                    ITEMPC=' '
                    NCHEA2=0
                  ELSE
                    NCHEA2=NCTIT9+3
                    ITEMPC(4:NCHEA2)=ITITL9(1:NCTIT9)
                    ITEMPC(1:3)=' b '
                    ITEMPC(1:1)=IBASLC
                  ENDIF
                  CALL DPRTF1(ITEMPC,NCHEA2,IHEAD,NCTEM2)
                ENDIF
              ENDIF
C
              DO130J=1,NUMCOL
                NCHAR=NCTEMP(J)+3
                IVALUE(J)(4:NCHAR)=IVALUE(J)(1:NCTEMP(J))
                IVALUE(J)(1:3)=' b '
                IVALUE(J)(1:1)=IBASLC
                NCTEMP(J)=NCHAR
  130         CONTINUE
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
              CALL DPRTF4(IVALUE,NCTEMP,NUMCOL,IFLAG1,IFLAG2)
            ELSE
              IF(I.EQ.1)THEN
                IFLAG1=.TRUE.
                CALL DPTAB1(ITITL9,NCTIT9,IHEAD,NCHEAD,IFLAG1)
              ENDIF
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
C
              DO 141 KK=1,NUMCOL
                IF(ALIGN(KK).EQ.'l' .AND. NCTEMP(KK).LT.NTOT(KK))THEN
                  DO146JJ=NCTEMP(KK)+1,NTOT(KK)
                    IVALUE(KK)(JJ:JJ)=' '
  146             CONTINUE
                  NCTEMP(KK)=NTOT(KK)
                ELSEIF(ALIGN(KK).EQ.'c'.AND.NCTEMP(KK).LT.NTOT(KK))THEN
                  IVALUE(KK)(NCTEMP(KK):NTOT(KK))=' '
                  IDIFF=(NTOT(KK)-NCTEMP(KK))/2
                  IF(IDIFF.GT.0)THEN
                    DO147JJ=NTOT(KK),IDIFF+1,-1
                      IVALUE(KK)(JJ:JJ)=IVALUE(KK)(JJ-IDIFF:JJ-IDIFF)
  147               CONTINUE
                    IVALUE(KK)(1:IDIFF)=' '
                  ENDIF
                  NCTEMP(KK)=NTOT(KK)
                ELSEIF(ALIGN(KK).EQ.'r'.AND.NCTEMP(KK).LT.NTOT(KK))THEN
C
                  IF(ISUBRO.EQ.'DTA4' .OR. IBUGA3.EQ.'ON')THEN
                    WRITE(ICOUT,157)KK,NCTEMP(KK),NTOT(KK)
  157               FORMAT('BEFORE 148: KK,NCTEMP(KK),NTOT(KK) =',
     1                     3I8)
                    CALL DPWRST('XXX','WRIT')
                    WRITE(ICOUT,153)IVALUE(KK)(1:NCTEMP(KK))
                    CALL DPWRST('XXX','WRIT')
                  ENDIF
C
                  IDIFF=NTOT(KK)-NCTEMP(KK)
                  DO148JJ=NTOT(KK),IDIFF+1,-1
                    IVALUE(KK)(JJ:JJ)=IVALUE(KK)(JJ-IDIFF:JJ-IDIFF)
  148             CONTINUE
                  IVALUE(KK)(1:IDIFF)=' '
                  NCTEMP(KK)=NTOT(KK)
                ENDIF
C
                IF(ISUBRO.EQ.'DTA4' .OR. IBUGA3.EQ.'ON')THEN
                  WRITE(ICOUT,151)KK,IDIFF,NCTEMP(KK),NUMCOL,NMAX
  151             FORMAT('BEFORE CALL DPTAB4: KK,IDIFF,NCTEMP(KK),',
     1                   'NUMCOL,NMAX=',5I8)
                  CALL DPWRST('XXX','WRIT')
                  WRITE(ICOUT,153)IVALUE(KK)(1:NCTEMP(KK))
  153             FORMAT('IVALUE(KK) = ',A80)
                  CALL DPWRST('XXX','WRIT')
                ENDIF
C
  141         CONTINUE
C
              CALL DPTAB4(IVALUE,NCTEMP,NUMCOL,IFLAG1,IFLAG2,NMAX)
C
            ENDIF
  110     CONTINUE
        ENDIF
C
C               ******************************************
C               **   STEP 2--                           **
C               **   WRITE OUT THE TABLE ROWS           **
C               ******************************************
C
        IFLAGA=.FALSE.
        IFLAGB=.FALSE.
        MAXLTA=35
        ILINE=0
        IF(NUMROW.GE.1)THEN
          DO200I=1,NUMROW
C
            IFLAG1=.FALSE.
            IF(I.EQ.NUMROW)IFLAG1=.TRUE.
            DO210J=1,NUMCOL
              AVALUE(J)=AVAL(I,J)
              IF(AVALUE(J).EQ.CPUMIN)THEN
                NUMDIG(J)=-99
              ELSE
                NUMDIG(J)=IDIGIT(J)
              ENDIF
              IVALUE(J)=' '
              NTEMP=NCTEXT(I,J)
              NCTEMP(J)=NTEMP
              IF(NTEMP.GT.0)THEN
                IVALUE(J)(1:NTEMP)=ITEXT(I,J)(1:NTEMP)
C
                IF(ICAPTY.EQ.'LATE')THEN
                  CALL DPDTLA(IVALUE(J),NTEMP,NCT,ISUBRO,IBUGA3,IERROR)
                  NTEMP=NCT
                ENDIF
C
              ENDIF
C
              IF(ISUBRO.EQ.'DTA4' .OR. IBUGA3.EQ.'ON')THEN
                WRITE(ICOUT,211)I,J,ITYPCO(J),AVALUE(J),IVALUE(J)
  211           FORMAT('I,J,ITYPCO(J),AVALUE(J),IVALUE(J) = ',
     1                 2I8,2X,A4,2X,G15.7,2X,A60)
                CALL DPWRST('XXX','WRIT')
              ENDIF
C
  210       CONTINUE
C
            IF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'HTML')THEN
              CALL DPHTMY(IVALUE,NCTEMP,AVALUE,NUMCOL,ITYPCO,
     1                    IFLAGA,IFLAGB)
C
C           FOR LATEX, WE CANNOT EXTEND TABLES BEYOND A SINGLE
C           PAGE, SO PUT A CHECK IN.
C
            ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'LATE')THEN
              CALL DPLATW(IVALUE,NCTEMP,AVALUE,NUMCOL,ITYPCO,
     1                    IFLAGA,IFLAGB)
              ILINE=ILINE+1
              IF(ILINE.EQ.MAXLTA .AND. I.NE.NUMROW)THEN
                ILINE=0
                IFLAG1=.TRUE.
                IFLAG2=.FALSE.
                IFLAG3=.TRUE.
                CALL DPLATZ(IFLAG1,IFLAG2,IFLAG3,NHEAD)
                IFLAG1=.FALSE.
                IFLAG2=.FALSE.
                IFLAG3=.TRUE.
                CALL DPLATY(NHEAD)
              ENDIF
            ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'RTF')THEN
              CALL DPRTFY(IVALUE,NCTEMP,AVALUE,NUMCOL,ITYPCO,
     1                    IFLAGA,IFLAGB)
            ELSE
C
              IF(ISUBRO.EQ.'DTA4' .OR. IBUGA3.EQ.'ON')THEN
                WRITE(ICOUT,251)I,NUMCOL,NMAX
  251           FORMAT('BEFORE CALL DPTAB8: I,NUMCOL,NMAX = ',
     1                 3I5)
                CALL DPWRST('XXX','WRIT')
              ENDIF
C
              CALL DPTABY(IVALUE,NCTEMP,AVALUE,NUMCOL,ITYPCO,
     1                    IFLAGA,IFLAGB,NMAX,NTOT,IBUGA3,ISUBRO)
            ENDIF
  200     CONTINUE
        ENDIF
C
C               *******************************************
C               **   STEP 3--                            **
C               **   TERMINATE THE TABLE                 **
C               *******************************************
C
        ISTEPN='2'
        IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DTA4')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'HTML')THEN
          IFLAG1=.TRUE.
          IFLAG2=.FALSE.
          IF(ILAST)IFLAG2=.TRUE.
          CALL DPHTM2(IFLAG1,IFLAG2,NHEAD)
        ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'LATE')THEN
          IFLAG1=.TRUE.
          IFLAG2=.FALSE.
          IFLAG3=.FALSE.
          IF(ILAST)THEN
            IFLAG2=.TRUE.
            IFLAG3=.TRUE.
          ENDIF
          CALL DPLATZ(IFLAG1,IFLAG2,IFLAG3,NHEAD)
        ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'RTF')THEN
          IF(IRTFFF.EQ.'Courier New')THEN
            ITEMP=1
          ELSEIF(IRTFFF.EQ.'Lucida Console')THEN
            ITEMP=8
          ENDIF 
          WRITE(ICOUT,8091)IBASLC,ITEMP
          CALL DPWRST(ICOUT,'WRIT')
          CALL DPRTF6(NHEAD)
          CALL DPRTF6(NHEAD)
          IF(ILAST)THEN
            IRTFMD='VERB'
          ENDIF
        ELSE
          IF(ILAST)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
          ENDIF
        ENDIF
C
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE DPDTA5(ITITL9,NCTIT9,
     1                  IHEAD,NCHEAD,ITITLE,NCTITL,
     1                  MAXLIN,NUMLIN,MAXCOL,NUMCOL,
     1                  ITEXT,NCTEXT,AVAL,ITYPCO,MAXROW,NUMROW,
     1                  IDIGIT,NTOT,IWHTML,IWRTF,VALIGZ,ALIGNZ,NMAX,
     1                  ICAPSW,ICAPTY,IFIRST,ILAST,
     1                  IFLAGS,IFLAGE,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE PRINTS A MULTI-COLUMN TABLE CONSISTING OF:
C
C              1) AN OPTIONAL OVERALL TITLE
C              2) HEADERS FOR EACH OF THE COLUMNS (THESE HEADERS MAY
C                 CONTAIN MULTIPLE LINES).
C              3) A TABLE OF NUMERIC/CHARACTER VALUES.  THIS IS A
C                 VARIANT OF TABLE 2 (WHICH ONLY ALLOWS TEXT FIELDS
C                 FOR THE FIRST COLUMN).
C
C              ITITL9     => THE OVERALL TITLE
C              IHEAD      => TABLE CAPTION
C              ITITLE     => LINES FOR THE COLUMN HEADERS
C              AVAL       => MATRIX OF NUMERIC VALUES FOR THE TABLE
C              ITEXT      => MATRIX OF CHARACTER VALUES FOR THE TABLE
C
C              NOTE THAT THIS IS A SLIGHTLY MODIFIED VERSION OF
C              DPDTA4.  IN SOME CASES, THE NUMBER OF ROWS IN THE
C              TABLE MAY NOT BE FIXED (AND IN FACT MAY BE RATHER
C              LARGE).  DPDTA5 ALLOWS THE ROWS OF THE TABLE TO BE
C              SENT IN INCREMENTS.  THE IFLAGS AND IFLAGE SPECIFY
C              WHETHER THE TABLE HEADERS OR TRAILERS ARE TO BE
C              PRINTED, RESPECTIVELY.
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/9
C     ORIGINAL VERSION--SEPTEMBER 2009.
C     UPDATED         --JANUARY   2011. USE DPDTLA TO CHECK FOR
C                                       CERTAIN CHARACTERS THAT NEED
C                                       TO BE ESCAPED FOR LATEX
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*(*) IHEAD
      CHARACTER*(*) ITITL9
      CHARACTER*(*) ITITLE(MAXLIN,MAXCOL)
      CHARACTER*4   VALIGZ(*)
      CHARACTER*4   ALIGNZ(*)
      INTEGER       NCTITL(MAXLIN,MAXCOL)
      INTEGER       NCTEXT(MAXROW,MAXCOL)
      INTEGER       IDIGIT(*)
      INTEGER       NTOT(*)
      INTEGER       IWHTML(*)
      INTEGER       IWRTF(*)
      REAL          AVAL(MAXROW,MAXCOL)
      CHARACTER*(*) ITEXT(MAXROW,MAXCOL)
      CHARACTER*4   ITYPCO(MAXCOL)
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      LOGICAL IFLAG1
      LOGICAL IFLAG2
      LOGICAL IFLAG3
      LOGICAL IFLAGA
      LOGICAL IFLAGB
      LOGICAL IFLAGS
      LOGICAL IFLAGE
      LOGICAL IBOLD
      LOGICAL IFIRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXHED=50)
      INTEGER IWIDTH(MAXHED)
      INTEGER NUMDIG(MAXHED)
      CHARACTER*8 ALIGN(MAXHED)
      CHARACTER*8 VALIGN(MAXHED)
      COMMON/HTML4/IWIDTH,NUMDIG,ALIGN,VALIGN
      CHARACTER*60 IVALUE(MAXHED)
      INTEGER      NCTEMP(MAXHED)
      REAL         AVALUE(MAXHED)
C
      CHARACTER*132 ITEMPC
C
      CHARACTER*4 IRTFMD
      COMMON/COMRTF/IRTFMD
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='A5  '
C
      IERROR='NO'
C
      DO40I=1,MAXHED
        IVALUE(I)=' '
        AVALUE(I)=0.0
        NCTEMP(I)=0
   40 CONTINUE
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTA5')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDTA5--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,53)MAXLIN,MAXROW,NUMROW,NUMCOL,NUMLIN
   53   FORMAT('MAXLIN,MAXROW,NUMROW,NUMCOL,NUMLIN = ',5I8)
        CALL DPWRST('XXX','WRIT')
        IF(NUMLIN.GT.0)THEN
          DO54I=1,NUMLIN
            DO55J=1,NUMCOL
              IF(NCTITL(I,J).GT.0)THEN
                NTEMP=MIN(80,NCTITL(I,J))
                WRITE(ICOUT,56)I,J,NCTITL(I,J),ITITLE(I,J)(1:NTEMP)
   56           FORMAT('I,J,NCTITL(I,J),ITITL(I,J)(1:NCTITL) = ',
     1                 3I5,2X,A80)
                CALL DPWRST('XXX','WRIT')
              ENDIF
   55       CONTINUE
   54     CONTINUE
        ENDIF
        IF(NUMROW.GT.0)THEN
          DO57I=1,NUMROW
            WRITE(ICOUT,60)I,(AVAL(I,J),J=1,MIN(5,NUMCOL))
   60       FORMAT('I,(AVAL(I,J),J=1,NUMCOL) = ',I8,5G15.7)
            CALL DPWRST('XXX','WRIT')
   57     CONTINUE
          DO77I=1,NUMROW
          DO79J=1,NUMCOL
            WRITE(ICOUT,80)I,J,ITEXT(I,J)
   80       FORMAT('I,J,ITEXT(I,J) = ',2I5,2X,A60)
            CALL DPWRST('XXX','WRIT')
   79     CONTINUE
   77     CONTINUE
        ENDIF
        WRITE(ICOUT,62)NCHEAD
   62   FORMAT('NCHEAD = ',I5)
        CALL DPWRST('XXX','WRIT')
        IF(NCHEAD.GT.0)THEN
          WRITE(ICOUT,63)IHEAD(1:NCHEAD)
   63     FORMAT('NCHEAD,IHEAD = ',A80)
          CALL DPWRST('XXX','WRIT')
        ENDIF
      ENDIF
C
C               ******************************************
C               **   STEP 1--                           **
C               **   WRITE OUT THE TABLE HEADER.        **
C               **   NOTE THAT THIS MAY CONSIST OF      **
C               **   MULTIPLE LINES.                    **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DTA5')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'ON')THEN
C
        CALL DPCONA(92,IBASLC)
C
C       SKIP HEADER IF REQUESTED
C
        IF(.NOT.IFLAGS)GOTO199
C
        NHEAD=NUMCOL
C
        DO100I=1,NUMCOL
          IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
            IWIDTH(I)=IWHTML(I)
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='BOTTOM'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='CENTER'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='TOP'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='LEFT'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='CENTER'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='RIGHT'
            ENDIF
C
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='b'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='c'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='t'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='l'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='c'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='r'
            ENDIF
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF')THEN
            IWIDTH(I)=IWRTF(I)
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='b'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='c'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='t'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='l'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='c'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='r'
            ENDIF
          ELSE
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='b'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='c'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='t'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='l'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='c'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='r'
            ENDIF
          ENDIF
  100   CONTINUE
C
C       LOOP THROUGH THE LINES OF THE HEADER
C
        IF(NUMLIN.GE.1)THEN
          DO110I=1,NUMLIN
C
            DO120J=1,NUMCOL
              IVALUE(J)=' '
              NCTEMP(J)=0
              IF(NCTITL(I,J).GT.0)THEN
                NCTEMP(J)=NCTITL(I,J)
                IVALUE(J)(1:NCTEMP(J))=ITITLE(I,J)(1:NCTEMP(J))
              ENDIF
C
              IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTA5')THEN
                WRITE(ICOUT,106)I,J,NCTEMP(J),IVALUE(J)
  106           FORMAT('I,J,NCTEMP(J),IVALUE(J) = ',3I8,A80)
                CALL DPWRST('XXX','WRIT')
              ENDIF
C
  120       CONTINUE
C
            IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
              IF(I.EQ.1)THEN
                IFLAG1=.FALSE.
                IF(IFIRST)IFLAG1=.TRUE.
                IFLAG2=.TRUE.
                IF(NCTIT9.LE.0)THEN
                  IF(IFIRST)THEN
                    CALL DPHTM1(IHEAD,NCHEAD,IFLAG1,IFLAG2)
                  ELSE
                    CALL DPHTMA(ITITL9,NCTIT9,IHEAD,NCHEAD,
     1                          IFLAG1,IFLAG2)
                  ENDIF
                ELSE
                  CALL DPHTMA(ITITL9,NCTIT9,IHEAD,NCHEAD,IFLAG1,IFLAG2)
                ENDIF
              ENDIF
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
              CALL DPHTM4(IVALUE,NCTEMP,NUMCOL,IFLAG1,IFLAG2)
C
            ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
C
              IF(I.EQ.1)THEN
                IF(IFIRST)THEN
                  IFLAG1=.FALSE.
                  IFLAG2=.FALSE.
                  IFLAG3=.TRUE.
                  CALL DPLAT6(IFLAG1,IFLAG2,IFLAG3)
                ENDIF
                IFLAG1=.FALSE.
                IF(IFIRST)IFLAG1=.TRUE.
                IFLAG2=.TRUE.
C
                CALL DPDTLA(IHEAD,NCHEAD,NCT,ISUBRO,IBUGA3,IERROR)
                NCHEAD=NCT
C
                IF(NCTIT9.LE.0)THEN
                  ITEMPC=' '
                  NCHEA2=0
                  CALL DPLAT1(IHEAD,NCHEAD,ITEMPC,NCHEA2,IFLAG1)
                ELSE
                  CALL DPDTLA(ITITL9,NCTIT9,NCT,ISUBRO,IBUGA3,IERROR)
                  NCTIT9=NCT
                  CALL DPLAT1(ITITL9,NCTIT9,IHEAD,NCHEAD,IFLAG1)
                ENDIF
              ENDIF
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IFLAG3=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
              IF(I.EQ.1)IFLAG3=.TRUE.
C
              DO6110JJ=1,NUMCOL
                CALL DPDTLA(IVALUE(JJ),NCTEMP(JJ),NCT,
     1                      ISUBRO,IBUGA3,IERROR)
                NCTEMP(JJ)=NCT
 6110         CONTINUE
C
              CALL DPLAT4(IVALUE,NCTEMP,NUMCOL,IFLAG1,IFLAG2,IFLAG3)
C
            ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF ')THEN
C
 8091         FORMAT(A1,'f',I1)
              IF(I.EQ.1)THEN
                IF(IRTFFP.EQ.'Times New Roman')THEN
                  ITEMP=0
                ELSEIF(IRTFFP.EQ.'Lucida Sans')THEN
                  ITEMP=6
                ELSEIF(IRTFFP.EQ.'Arial')THEN
                  ITEMP=2
                ELSEIF(IRTFFP.EQ.'Bookman')THEN
                  ITEMP=3
                ELSEIF(IRTFFP.EQ.'Georgia')THEN
                  ITEMP=4
                ELSEIF(IRTFFP.EQ.'Tahoma')THEN
                  ITEMP=5
                ELSEIF(IRTFFP.EQ.'Verdana')THEN
                  ITEMP=7
                ELSE
                  ITEMP=0
                ENDIF 
C
                IRTFMD='OFF'
C
                IF(NCTIT9.GE.1.AND.I.EQ.1)THEN
                  IF(NCTIT9.LE.0)THEN
                    ITEMPC=' '
                    NCHEA2=0
                  ELSE
                    NCHEA2=NCTIT9+3
                    ITEMPC(4:NCHEA2)=ITITL9(1:NCTIT9)
                    ITEMPC(1:3)=' b '
                    ITEMPC(1:1)=IBASLC
                  ENDIF
                  IF(NCHEAD.GE.1)THEN
                    NCTEM2=NCHEAD+3
                    IHEAD(4:NCTEM2)=IHEAD(1:NCHEAD)
                    IHEAD(1:3)=' b '
                    IHEAD(1:1)=IBASLC
                  ELSE
                    NCTEM2=0
                  ENDIF
                  CALL DPRTF1(ITEMPC,NCHEA2,IHEAD,NCTEM2)
                ENDIF
              ENDIF
C
              DO130J=1,NUMCOL
                NCHAR=NCTEMP(J)+3
                IVALUE(J)(4:NCHAR)=IVALUE(J)(1:NCTEMP(J))
                IVALUE(J)(1:3)=' b '
                IVALUE(J)(1:1)=IBASLC
                NCTEMP(J)=NCHAR
  130         CONTINUE
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
              CALL DPRTF4(IVALUE,NCTEMP,NUMCOL,IFLAG1,IFLAG2)
            ELSE
              IF(I.EQ.1)THEN
                IFLAG1=.TRUE.
                CALL DPTAB1(ITITL9,NCTIT9,IHEAD,NCHEAD,IFLAG1)
              ENDIF
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
C
              DO 141 KK=1,NUMCOL
                IF(ALIGN(KK).EQ.'l' .AND. NCTEMP(KK).LT.NTOT(KK))THEN
                  DO146JJ=NCTEMP(KK)+1,NTOT(KK)
                    IVALUE(KK)(JJ:JJ)=' '
  146             CONTINUE
                  NCTEMP(KK)=NTOT(KK)
                ELSEIF(ALIGN(KK).EQ.'c'.AND.NCTEMP(KK).LT.NTOT(KK))THEN
                  IVALUE(KK)(NCTEMP(KK):NTOT(KK))=' '
                  IDIFF=(NTOT(KK)-NCTEMP(KK))/2
                  IF(IDIFF.GT.0)THEN
                    DO147JJ=NTOT(KK),IDIFF+1,-1
                      IVALUE(KK)(JJ:JJ)=IVALUE(KK)(JJ-IDIFF:JJ-IDIFF)
  147               CONTINUE
                    IVALUE(KK)(1:IDIFF)=' '
                  ENDIF
                  NCTEMP(KK)=NTOT(KK)
                ELSEIF(ALIGN(KK).EQ.'r'.AND.NCTEMP(KK).LT.NTOT(KK))THEN
C
                  IF(ISUBRO.EQ.'DTA5' .OR. IBUGA3.EQ.'ON')THEN
                    WRITE(ICOUT,157)KK,NCTEMP(KK),NTOT(KK)
  157               FORMAT('BEFORE 148: KK,NCTEMP(KK),NTOT(KK) =',
     1                     3I8)
                    CALL DPWRST('XXX','WRIT')
                    WRITE(ICOUT,153)IVALUE(KK)(1:NCTEMP(KK))
                    CALL DPWRST('XXX','WRIT')
                  ENDIF
C
                  IDIFF=NTOT(KK)-NCTEMP(KK)
                  DO148JJ=NTOT(KK),IDIFF+1,-1
                    IVALUE(KK)(JJ:JJ)=IVALUE(KK)(JJ-IDIFF:JJ-IDIFF)
  148             CONTINUE
                  IVALUE(KK)(1:IDIFF)=' '
                  NCTEMP(KK)=NTOT(KK)
                ENDIF
C
                IF(ISUBRO.EQ.'DTA5' .OR. IBUGA3.EQ.'ON')THEN
                  WRITE(ICOUT,151)KK,IDIFF,NCTEMP(KK),NUMCOL,NMAX
  151             FORMAT('BEFORE CALL DPTAB4: KK,IDIFF,NCTEMP(KK),',
     1                   'NUMCOL,NMAX=',5I8)
                  CALL DPWRST('XXX','WRIT')
                  WRITE(ICOUT,153)IVALUE(KK)(1:NCTEMP(KK))
  153             FORMAT('IVALUE(KK) = ',A80)
                  CALL DPWRST('XXX','WRIT')
                ENDIF
C
  141         CONTINUE
C
              CALL DPTAB4(IVALUE,NCTEMP,NUMCOL,IFLAG1,IFLAG2,NMAX)
C
            ENDIF
  110     CONTINUE
        ENDIF
C
  199   CONTINUE
C
C               ******************************************
C               **   STEP 2--                           **
C               **   WRITE OUT THE TABLE ROWS           **
C               ******************************************
C
        IFLAGA=.FALSE.
        IFLAGB=.FALSE.
        MAXLTA=35
        ILINE=0
        IF(NUMROW.GE.1)THEN
          DO200I=1,NUMROW
C
            IFLAG1=.FALSE.
            IF(I.EQ.NUMROW)IFLAG1=.TRUE.
            DO210J=1,NUMCOL
              AVALUE(J)=AVAL(I,J)
              IF(AVALUE(J).EQ.CPUMIN)THEN
                NUMDIG(J)=-99
              ELSE
                NUMDIG(J)=IDIGIT(J)
              ENDIF
              IVALUE(J)=' '
              NTEMP=NCTEXT(I,J)
              NCTEMP(J)=NTEMP
              IF(NTEMP.GT.0 .AND. ITYPCO(J).EQ.'ALPH')THEN
                IVALUE(J)(1:NTEMP)=ITEXT(I,J)(1:NTEMP)
C
                IF(ICAPTY.EQ.'LATE')THEN
                  CALL DPDTLA(IVALUE(J),NTEMP,NCT,ISUBRO,IBUGA3,IERROR)
                  NTEMP=NCT
                  NCTEMP(J)=NTEMP
                ENDIF
C
              ENDIF
C
              IF(ISUBRO.EQ.'DTA5' .OR. IBUGA3.EQ.'ON')THEN
                WRITE(ICOUT,211)I,J,ITYPCO(J),AVALUE(J),IVALUE(J)
  211           FORMAT('I,J,ITYPCO(J),AVALUE(J),IVALUE(J) = ',
     1                 2I8,2X,A4,2X,G15.7,2X,A60)
                CALL DPWRST('XXX','WRIT')
              ENDIF
C
  210       CONTINUE
C
            IF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'HTML')THEN
              CALL DPHTMY(IVALUE,NCTEMP,AVALUE,NUMCOL,ITYPCO,
     1                    IFLAGA,IFLAGB)
C
C           FOR LATEX, WE CANNOT EXTEND TABLES BEYOND A SINGLE
C           PAGE, SO PUT A CHECK IN.
C
            ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'LATE')THEN
              CALL DPLATW(IVALUE,NCTEMP,AVALUE,NUMCOL,ITYPCO,
     1                    IFLAGA,IFLAGB)
              ILINE=ILINE+1
              IF(ILINE.EQ.MAXLTA .AND. I.NE.NUMROW)THEN
                ILINE=0
                IFLAG1=.TRUE.
                IFLAG2=.FALSE.
                IFLAG3=.TRUE.
                CALL DPLATZ(IFLAG1,IFLAG2,IFLAG3,NHEAD)
                IFLAG1=.FALSE.
                IFLAG2=.FALSE.
                IFLAG3=.TRUE.
                CALL DPLATY(NHEAD)
              ENDIF
            ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'RTF')THEN
              CALL DPRTFY(IVALUE,NCTEMP,AVALUE,NUMCOL,ITYPCO,
     1                    IFLAGA,IFLAGB)
            ELSE
C
              IF(ISUBRO.EQ.'DTA5' .OR. IBUGA3.EQ.'ON')THEN
                WRITE(ICOUT,251)I,NUMCOL,NMAX
  251           FORMAT('BEFORE CALL DPTABY: I,NUMCOL,NMAX = ',
     1                 3I5)
                CALL DPWRST('XXX','WRIT')
              ENDIF
C
              CALL DPTABY(IVALUE,NCTEMP,AVALUE,NUMCOL,ITYPCO,
     1                    IFLAGA,IFLAGB,NMAX,NTOT,IBUGA3,ISUBRO)
            ENDIF
  200     CONTINUE
        ENDIF
C
C               *******************************************
C               **   STEP 3--                            **
C               **   TERMINATE THE TABLE                 **
C               *******************************************
C
        ISTEPN='2'
        IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DTA5')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IF(.NOT.IFLAGE)GOTO399
C
        IF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'HTML')THEN
          IFLAG1=.TRUE.
          IFLAG2=.FALSE.
          IF(ILAST)IFLAG2=.TRUE.
          CALL DPHTM2(IFLAG1,IFLAG2,NHEAD)
        ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'LATE')THEN
          IFLAG1=.TRUE.
          IFLAG2=.FALSE.
          IFLAG3=.FALSE.
          IF(ILAST)THEN
            IFLAG2=.TRUE.
            IFLAG3=.TRUE.
          ENDIF
          CALL DPLATZ(IFLAG1,IFLAG2,IFLAG3,NHEAD)
        ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'RTF')THEN
          IF(IRTFFF.EQ.'Courier New')THEN
            ITEMP=1
          ELSEIF(IRTFFF.EQ.'Lucida Console')THEN
            ITEMP=8
          ENDIF 
          WRITE(ICOUT,8091)IBASLC,ITEMP
          CALL DPWRST(ICOUT,'WRIT')
          CALL DPRTF6(NHEAD)
          CALL DPRTF6(NHEAD)
          IF(ILAST)THEN
            IRTFMD='VERB'
          ENDIF
        ELSE
          IF(ILAST)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
          ENDIF
        ENDIF
C
  399   CONTINUE
C
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE DPDT5B(ITITL9,NCTIT9,
     1                  IHEAD,NCHEAD,ITITLE,NCTITL,
     1                  MAXLIN,NUMLIN,MAXCOL,NUMCOL,
     1                  ITEXT,NCTEXT,AVAL,ITYPCO,MAXROW,NUMROW,
     1                  IDIGIT,NTOT,IWHTML,IWRTF,VALIGZ,ALIGNZ,NMAX,
     1                  ICOLSP,ROWSEP,
     1                  ICAPSW,ICAPTY,IFIRST,ILAST,
     1                  IFLAGS,IFLAGE,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE PRINTS A MULTI-COLUMN TABLE CONSISTING OF:
C
C              1) AN OPTIONAL OVERALL TITLE
C              2) HEADERS FOR EACH OF THE COLUMNS (THESE HEADERS MAY
C                 CONTAIN MULTIPLE LINES).
C              3) A TABLE OF NUMERIC/CHARACTER VALUES.  THIS IS A
C                 VARIANT OF TABLE 2 (WHICH ONLY ALLOWS TEXT FIELDS
C                 FOR THE FIRST COLUMN).
C
C              ITITL9     => THE OVERALL TITLE
C              IHEAD      => TABLE CAPTION
C              ITITLE     => LINES FOR THE COLUMN HEADERS
C              AVAL       => MATRIX OF NUMERIC VALUES FOR THE TABLE
C              ITEXT      => MATRIX OF CHARACTER VALUES FOR THE TABLE
C              ICOLSP     => MATRIX OF COLUMN SPANS FOR THE HEADER
C                            LINES OF THE TABLE.
C
C              IN SOME CASES, THE NUMBER OF ROWS IN THE
C              TABLE MAY NOT BE FIXED (AND IN FACT MAY BE RATHER
C              LARGE).  DPDT5B ALLOWS THE ROWS OF THE TABLE TO BE
C              SENT IN INCREMENTS.  THE IFLAGS AND IFLAGE SPECIFY
C              WHETHER THE TABLE HEADERS OR TRAILERS ARE TO BE
C              PRINTED, RESPECTIVELY.
C
C              THIS IS A VARIATION OF DPDTA5 THAT ALLOWS THE FOLLOWING:
C
C                 1) HEADER TEXT TO SPAN MULTIPLE COLUMNS (COLSPN ARRAY
C                    SPECIFIES NUMBER OF COLUMNS THAT A SPECIFIC COLUMN
C                    COVERS).  NOTE THAT MULTIPLE COLUMN HEADERS WILL
C                    AUTOMATICALLY BE CENTER JUSTIFIED.
C
C                 2) ALLOWS FOR EMPTY CELLS.  TO ACCOMODATE THIS, THE
C                    IDIGIT FIELD IS A MATRIX INSTEAD OF AN ARRAY (I.E.,
C                    NEED TO SET INDIVIDUALLY).
C
C                 3) ALLOW A SEPARATOR LINE TO BE DRAWN AFTER SELECT
C                    ROWS.  FOR EXAMPLE, WE MAY WANT A BORDER FOR A
C                    "ROW TOTALS" ROW.  THE ROWSEP VARIABLE WILL BE
C                    USED TO INDICATE THIS (A VALUE OF 1 SPECIFIES
C                    THAT THE ROW SEPARATOR WILL BE GENERATED).
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2011/1
C     ORIGINAL VERSION--JANUARY   2011.
C     UPDATED         --JANUARY   2011. USE DPDTLA, DPDTRT TO CHECK FOR
C                                       CERTAIN CHARACTERS THAT NEED
C                                       TO BE ESCAPED FOR LATEX, RTF
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*(*) IHEAD
      CHARACTER*(*) ITITL9
      CHARACTER*(*) ITITLE(MAXLIN,MAXCOL)
      CHARACTER*4   VALIGZ(*)
      CHARACTER*4   ALIGNZ(*)
      INTEGER       NCTITL(MAXLIN,MAXCOL)
      INTEGER       NCTEXT(MAXROW,MAXCOL)
      INTEGER       ICOLSP(MAXLIN,MAXCOL)
      INTEGER       IDIGIT(MAXROW,MAXCOL)
      INTEGER       NTOT(*)
      INTEGER       ROWSEP(*)
      INTEGER       IWHTML(*)
      INTEGER       IWRTF(*)
      REAL          AVAL(MAXROW,MAXCOL)
      CHARACTER*(*) ITEXT(MAXROW,MAXCOL)
      CHARACTER*4   ITYPCO(MAXCOL)
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      LOGICAL IFLAG1
      LOGICAL IFLAG2
      LOGICAL IFLAG3
      LOGICAL IFLAGA
      LOGICAL IFLAGB
      LOGICAL IFLAGS
      LOGICAL IFLAGE
      LOGICAL IBOLD
      LOGICAL IFIRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXHED=50)
      INTEGER IWIDTH(MAXHED)
      INTEGER NUMDIG(MAXHED)
      CHARACTER*8 ALIGN(MAXHED)
      CHARACTER*8 VALIGN(MAXHED)
      COMMON/HTML4/IWIDTH,NUMDIG,ALIGN,VALIGN
      CHARACTER*60 IVALUE(MAXHED)
      INTEGER      NCTEMP(MAXHED)
      INTEGER      NCOLSP(MAXHED)
      REAL         AVALUE(MAXHED)
C
      CHARACTER*8 ALIGNT
      CHARACTER*132 ITEMPC
C
      CHARACTER*4 IRTFMD
      COMMON/COMRTF/IRTFMD
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='5B  '
C
      IERROR='NO'
C
      DO40I=1,MAXHED
        IVALUE(I)=' '
        AVALUE(I)=0.0
        NCTEMP(I)=0
        NCOLSP(I)=0
   40 CONTINUE
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT5B')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDT5B--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,53)MAXLIN,MAXROW,NUMROW,NUMCOL,NUMLIN
   53   FORMAT('MAXLIN,MAXROW,NUMROW,NUMCOL,NUMLIN = ',5I8)
        CALL DPWRST('XXX','WRIT')
        IF(NUMLIN.GT.0)THEN
          DO54I=1,NUMLIN
            DO55J=1,NUMCOL
              NTEMP=MIN(80,NCTITL(I,J))
              IF(NTEMP.GT.0)THEN
                WRITE(ICOUT,56)I,J,NCTITL(I,J),ITITLE(I,J)(1:NTEMP)
   56           FORMAT('I,J,NCTITL(I,J),ITITL(I,J)(1:NCTITL) = ',
     1                 3I5,2X,A80)
                CALL DPWRST('XXX','WRIT')
              ELSE
                WRITE(ICOUT,56)I,J,NCTITL(I,J)
                CALL DPWRST('XXX','WRIT')
              ENDIF
   55       CONTINUE
   54     CONTINUE
        ENDIF
        IF(NUMROW.GT.0)THEN
          DO57I=1,NUMROW
            WRITE(ICOUT,60)I,(AVAL(I,J),J=1,MIN(5,NUMCOL))
   60       FORMAT('I,(AVAL(I,J),J=1,NUMCOL) = ',I8,5G15.7)
            CALL DPWRST('XXX','WRIT')
   57     CONTINUE
          DO77I=1,NUMROW
          DO79J=1,NUMCOL
            WRITE(ICOUT,80)I,J,ITEXT(I,J)
   80       FORMAT('I,J,ITEXT(I,J) = ',2I5,2X,A60)
            CALL DPWRST('XXX','WRIT')
   79     CONTINUE
   77     CONTINUE
        ENDIF
        WRITE(ICOUT,62)NCHEAD
   62   FORMAT('NCHEAD = ',I5)
        CALL DPWRST('XXX','WRIT')
        IF(NCHEAD.GT.0)THEN
          WRITE(ICOUT,63)IHEAD(1:NCHEAD)
   63     FORMAT('NCHEAD,IHEAD = ',A80)
          CALL DPWRST('XXX','WRIT')
        ENDIF
        DO91J=1,NUMCOL
          WRITE(ICOUT,93)J,ALIGNZ(J),VALIGZ(J),NTOT(J)
   93     FORMAT('J,ALIGNZ(J),VALIGZ(J),NTOT(J) = ',I5,2(2X,A4),2X,I5)
          CALL DPWRST('XXX','WRIT')
   91   CONTINUE
      ENDIF
C
C               ******************************************
C               **   STEP 1--                           **
C               **   WRITE OUT THE TABLE HEADER.        **
C               **   NOTE THAT THIS MAY CONSIST OF      **
C               **   MULTIPLE LINES.                    **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DT5B')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'ON')THEN
C
        CALL DPCONA(92,IBASLC)
C
C       SKIP HEADER IF REQUESTED
C
        IF(.NOT.IFLAGS)GOTO199
C
        NHEAD=NUMCOL
C
        DO100I=1,NUMCOL
          IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
            IWIDTH(I)=IWHTML(I)
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='BOTTOM'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='CENTER'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='TOP'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='LEFT'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='CENTER'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='RIGHT'
            ENDIF
C
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='b'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='c'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='t'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='l'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='c'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='r'
            ENDIF
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF')THEN
            IWIDTH(I)=IWRTF(I)
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='b'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='c'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='t'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='l'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='c'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='r'
            ENDIF
          ELSE
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='b'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='c'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='t'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='l'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='c'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='r'
            ENDIF
          ENDIF
  100   CONTINUE
C
C       LOOP THROUGH THE LINES OF THE HEADER
C
        IF(NUMLIN.GE.1)THEN
          DO110I=1,NUMLIN
C
            DO120J=1,NUMCOL
              IVALUE(J)=' '
              NCTEMP(J)=0
              NCOLSP(J)=ICOLSP(I,J)
              IF(NCTITL(I,J).GT.0)THEN
                NCTEMP(J)=NCTITL(I,J)
                IVALUE(J)(1:NCTEMP(J))=ITITLE(I,J)(1:NCTEMP(J))
              ENDIF
C
              IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT5B')THEN
                WRITE(ICOUT,106)I,J,NCTEMP(J),IVALUE(J)
  106           FORMAT('I,J,NCTEMP(J),IVALUE(J) = ',3I8,A80)
                CALL DPWRST('XXX','WRIT')
              ENDIF
C
  120       CONTINUE
C
            IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
              IF(NCTIT9.LT.0)NCTIT9=0
              IF(I.EQ.1)THEN
                IFLAG1=.FALSE.
                IF(IFIRST)IFLAG1=.TRUE.
                IFLAG2=.TRUE.
                IF(NCTIT9.LE.0)THEN
                  IF(IFIRST)THEN
                    CALL DPHTM1(IHEAD,NCHEAD,IFLAG1,IFLAG2)
                  ELSE
                    CALL DPHTMA(ITITL9,NCTIT9,IHEAD,NCHEAD,
     1                          IFLAG1,IFLAG2)
                  ENDIF
                ELSE
                  CALL DPHTMA(ITITL9,NCTIT9,IHEAD,NCHEAD,IFLAG1,IFLAG2)
                ENDIF
              ENDIF
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
              CALL DPHT4B(IVALUE,NCTEMP,NUMCOL,NCOLSP,IFLAG1,IFLAG2)
C
            ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
C
              IF(I.EQ.1)THEN
                IF(IFIRST)THEN
                  IFLAG1=.FALSE.
                  IFLAG2=.FALSE.
                  IFLAG3=.TRUE.
                  CALL DPLAT6(IFLAG1,IFLAG2,IFLAG3)
                ENDIF
                IFLAG1=.FALSE.
                IF(IFIRST)IFLAG1=.TRUE.
                IFLAG2=.TRUE.
C
                IF(NCTIT9.LT.0)NCTIT9=0
                CALL DPDTLA(IHEAD,NCHEAD,NCT,ISUBRO,IBUGA3,IERROR)
                NCHEAD=NCT
C
                IF(NCTIT9.LE.0)THEN
                  ITEMPC=' '
                  NCHEA2=0
                  CALL DPLAT1(IHEAD,NCHEAD,ITEMPC,NCHEA2,IFLAG1)
                ELSE
                  CALL DPDTLA(ITITL9,NCTIT9,NCT,ISUBRO,IBUGA3,IERROR)
                  NCTIT9=NCT
                  CALL DPLAT1(ITITL9,NCTIT9,IHEAD,NCHEAD,IFLAG1)
                ENDIF
              ENDIF
C
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IFLAG3=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
              IF(I.EQ.1)IFLAG3=.TRUE.
C
              DO6110JJ=1,NUMCOL
                CALL DPDTLA(IVALUE(JJ),NCTEMP(JJ),NCT,
     1                      ISUBRO,IBUGA3,IERROR)
                NCTEMP(JJ)=NCT
 6110         CONTINUE
C
              CALL DPLA4B(IVALUE,NCTEMP,NUMCOL,NCOLSP,
     1                    IFLAG1,IFLAG2,IFLAG3)
C
            ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF ')THEN
C
 8091         FORMAT(A1,'f',I1)
              IF(I.EQ.1)THEN
                IF(IRTFFP.EQ.'Times New Roman')THEN
                  ITEMP=0
                ELSEIF(IRTFFP.EQ.'Lucida Sans')THEN
                  ITEMP=6
                ELSEIF(IRTFFP.EQ.'Arial')THEN
                  ITEMP=2
                ELSEIF(IRTFFP.EQ.'Bookman')THEN
                  ITEMP=3
                ELSEIF(IRTFFP.EQ.'Georgia')THEN
                  ITEMP=4
                ELSEIF(IRTFFP.EQ.'Tahoma')THEN
                  ITEMP=5
                ELSEIF(IRTFFP.EQ.'Verdana')THEN
                  ITEMP=7
                ELSE
                  ITEMP=0
                ENDIF 
C
                IRTFMD='OFF'
C
                IF(NCTIT9.LT.0)NCTIT9=0
                IF(NCTIT9.GE.1.AND.I.EQ.1)THEN
                  CALL DPDTRT(ITITL9,NCTIT9,NCT,ISUBRO,IBUGA3,IERROR)
                  NCTIT9=NCT
                  IF(NCTIT9.LE.0)THEN
                    ITEMPC=' '
                    NCHEA2=0
                  ELSE
                    NCHEA2=NCTIT9+3
                    ITEMPC(4:NCHEA2)=ITITL9(1:NCTIT9)
                    ITEMPC(1:3)=' b '
                    ITEMPC(1:1)=IBASLC
                  ENDIF
                  IF(NCHEAD.GE.1)THEN
                    CALL DPDTRT(IHEAD,NCHEAD,NCT,ISUBRO,IBUGA3,IERROR)
                    NCHEAD=NCT
                    NCTEM2=NCHEAD+3
                    IHEAD(4:NCTEM2)=IHEAD(1:NCHEAD)
                    IHEAD(1:3)=' b '
                    IHEAD(1:1)=IBASLC
                  ELSE
                    NCTEM2=0
                  ENDIF
                  CALL DPRTF1(ITEMPC,NCHEA2,IHEAD,NCTEM2)
                ENDIF
              ENDIF
C
              DO130J=1,NUMCOL
                CALL DPDTRT(IVALUE(J),NCTEMP(J),NCT,
     1                      ISUBRO,IBUGA3,IERROR)
                NCTEMP(J)=NCT
                NCHAR=NCTEMP(J)+3
                IVALUE(J)(4:NCHAR)=IVALUE(J)(1:NCTEMP(J))
                IVALUE(J)(1:3)=' b '
                IVALUE(J)(1:1)=IBASLC
                NCTEMP(J)=NCHAR
  130         CONTINUE
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
              CALL DPRT4B(IVALUE,NCTEMP,NUMCOL,NCOLSP,IFLAG1,IFLAG2)
            ELSE
              IF(I.EQ.1 .AND. NCTIT9.GE.0)THEN
                IFLAG1=.TRUE.
                CALL DPTAB1(ITITL9,NCTIT9,IHEAD,NCHEAD,IFLAG1)
              ENDIF
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
C
              DO 141 KK=1,NUMCOL
C
                IF(ISUBRO.EQ.'DT5B' .OR. IBUGA3.EQ.'ON')THEN
                  WRITE(ICOUT,142)KK,NCOLSP(KK)
  142             FORMAT('KK,NCOLSP(KK) = ',2I8)
                  CALL DPWRST('XXX','WRIT')
                ENDIF
C
                IF(NCOLSP(KK).LE.0)GOTO141
                NTOTZZ=NTOT(KK)
                ALIGNT=ALIGN(KK)
                IF(NCOLSP(KK).GT.1)THEN
                  DO1141IICOL=KK+1,KK+NCOLSP(KK)-1
                    NTOTZZ=NTOTZZ + NTOT(IICOL)
 1141             CONTINUE
                  ALIGNT='c'
                ENDIF
C
                IF(ISUBRO.EQ.'DT5B' .OR. IBUGA3.EQ.'ON')THEN
                  WRITE(ICOUT,157)KK,NCTEMP(KK),NTOTZZ,ALIGNT
  157             FORMAT('BEFORE 148: KK,NCTEMP(KK),NTOTZZ,ALIGNT =',
     1                   3I8,2X,A4)
                  CALL DPWRST('XXX','WRIT')
                ENDIF
C
                IF(ALIGNT.EQ.'l' .AND. NCTEMP(KK).LT.NTOTZZ)THEN
                  IF(NCTEMP(KK).GT.0)THEN
                    DO146JJ=NCTEMP(KK)+1,NTOTZZ
                      IVALUE(KK)(JJ:JJ)=' '
  146               CONTINUE
                    NCTEMP(KK)=NTOTZZ
                  ELSE
                    IVALUE(KK)(1:NTOTZZ)=' '
                    NCTEMP(KK)=NTOTZZ
                  ENDIF
                ELSEIF(ALIGNT.EQ.'c'.AND.NCTEMP(KK).LT.NTOTZZ)THEN
                  IF(NCTEMP(KK).GT.0)THEN
                    IVALUE(KK)(NCTEMP(KK)+1:NTOTZZ)=' '
                    IDIFF=(NTOTZZ-NCTEMP(KK))/2
                    IF(IDIFF.GT.0)THEN
                      DO147JJ=NTOTZZ,IDIFF+1,-1
                        IVALUE(KK)(JJ:JJ)=IVALUE(KK)(JJ-IDIFF:JJ-IDIFF)
  147                 CONTINUE
                      IVALUE(KK)(1:IDIFF)=' '
                    ENDIF
                    NCTEMP(KK)=NTOTZZ
                  ELSE
                    IVALUE(KK)(1:NTOTZZ)=' '
                    NCTEMP(KK)=NTOTZZ
                  ENDIF
                ELSEIF(ALIGNT.EQ.'r'.AND.NCTEMP(KK).LT.NTOTZZ)THEN
                  IF(NCTEMP(KK).GT.0)THEN
                    IDIFF=NTOTZZ-NCTEMP(KK)
                    DO148JJ=NTOTZZ,IDIFF+1,-1
                      IVALUE(KK)(JJ:JJ)=IVALUE(KK)(JJ-IDIFF:JJ-IDIFF)
  148               CONTINUE
                    IVALUE(KK)(1:IDIFF)=' '
                    NCTEMP(KK)=NTOTZZ
                  ELSE
                    IVALUE(KK)(1:NTOTZZ)=' '
                    NCTEMP(KK)=NTOTZZ
                  ENDIF
                ENDIF
C
                IF(ISUBRO.EQ.'DT5B' .OR. IBUGA3.EQ.'ON')THEN
                  WRITE(ICOUT,1151)NTOTZZ,NCTEMP(KK),IDIFF
 1151             FORMAT('BEFORE CALL DPTA44: NTOTZZ,NCTEMP(KK),',
     1                   'IDIFF = ',3I8)
                  CALL DPWRST('XXX','WRIT')
                  WRITE(ICOUT,151)KK,IDIFF,NCTEMP(KK),NUMCOL,NMAX
  151             FORMAT('KK,IDIFF,NCTEMP(KK),NUMCOL,NMAX=',5I8)
                  CALL DPWRST('XXX','WRIT')
                  WRITE(ICOUT,153)IVALUE(KK)(1:NCTEMP(KK))
  153             FORMAT('IVALUE(KK) = ',A80)
                  CALL DPWRST('XXX','WRIT')
                ENDIF
C
  141         CONTINUE
C
              CALL DPTA44(IVALUE,NCTEMP,NUMCOL,NCOLSP,
     1                    IFLAG1,IFLAG2,NMAX)
C
            ENDIF
  110     CONTINUE
        ENDIF
C
  199   CONTINUE
C
C               ******************************************
C               **   STEP 2--                           **
C               **   WRITE OUT THE TABLE ROWS           **
C               ******************************************
C
        IFLAGA=.FALSE.
        IFLAGB=.FALSE.
        MAXLTA=35
        ILINE=0
        IF(NUMROW.GE.1)THEN
          DO200I=1,NUMROW
C
            IFLAG1=.FALSE.
            IF(I.EQ.NUMROW)IFLAG1=.TRUE.
            IFLAGA=.FALSE.
            IFLAGB=.FALSE.
            IF(ROWSEP(I).EQ.1)THEN
              IFLAGA=.TRUE.
            ELSEIF(ROWSEP(I).EQ.2)THEN
              IFLAGB=.TRUE.
            ELSEIF(ROWSEP(I).EQ.3)THEN
              IFLAGB=.TRUE.
              IFLAGA=.TRUE.
            ENDIF
            DO210J=1,NUMCOL
              AVALUE(J)=AVAL(I,J)
              IF(AVALUE(J).EQ.CPUMIN)THEN
                IF(IDIGIT(I,J).EQ.-1)THEN
                  NUMDIG(J)=-1
                ELSE
                  NUMDIG(J)=-99
                ENDIF
              ELSE
                NUMDIG(J)=IDIGIT(I,J)
              ENDIF
              IVALUE(J)=' '
              NTEMP=NCTEXT(I,J)
              NCTEMP(J)=NTEMP
              IF(NTEMP.GT.0)THEN
                IVALUE(J)(1:NTEMP)=ITEXT(I,J)(1:NTEMP)
C
                IF(ICAPTY.EQ.'LATE')THEN
                  CALL DPDTLA(IVALUE(J),NTEMP,NCT,ISUBRO,IBUGA3,IERROR)
                  NTEMP=NCT
                  NCTEMP(J)=NTEMP
                ELSEIF(ICAPTY.EQ.'RTF')THEN
                  CALL DPDTRT(IVALUE(J),NTEMP,NCT,ISUBRO,IBUGA3,IERROR)
                  NTEMP=NCT
                  NCTEMP(J)=NTEMP
                ENDIF
C
              ENDIF
C
              IF(ISUBRO.EQ.'DT5B' .OR. IBUGA3.EQ.'ON')THEN
                WRITE(ICOUT,211)I,J,ITYPCO(J),AVALUE(J),
     1                          NCTEMP(J),IVALUE(J)
  211           FORMAT('I,J,ITYPCO(J),AVALUE(J),NCTEMP(J),IVALUE(J) = ',
     1                 2I8,2X,A4,2X,G15.7,2X,I5,2X,A60)
                CALL DPWRST('XXX','WRIT')
              ENDIF
C
  210       CONTINUE
C
            IF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'HTML')THEN
              CALL DPHTMY(IVALUE,NCTEMP,AVALUE,NUMCOL,ITYPCO,
     1                    IFLAGA,IFLAGB)
C
C           FOR LATEX, WE CANNOT EXTEND TABLES BEYOND A SINGLE
C           PAGE, SO PUT A CHECK IN.
C
            ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'LATE')THEN
              CALL DPLATW(IVALUE,NCTEMP,AVALUE,NUMCOL,ITYPCO,
     1                    IFLAGA,IFLAGB)
              ILINE=ILINE+1
              IF(ILINE.EQ.MAXLTA .AND. I.NE.NUMROW)THEN
                ILINE=0
                IFLAG1=.TRUE.
                IFLAG2=.FALSE.
                IFLAG3=.TRUE.
                CALL DPLATZ(IFLAG1,IFLAG2,IFLAG3,NHEAD)
                IFLAG1=.FALSE.
                IFLAG2=.FALSE.
                IFLAG3=.TRUE.
                CALL DPLATY(NHEAD)
              ENDIF
            ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'RTF')THEN
              CALL DPRTFY(IVALUE,NCTEMP,AVALUE,NUMCOL,ITYPCO,
     1                    IFLAGA,IFLAGB)
            ELSE
C
              IF(ISUBRO.EQ.'DT5B' .OR. IBUGA3.EQ.'ON')THEN
                WRITE(ICOUT,251)I,NUMCOL,NMAX
  251           FORMAT('BEFORE CALL DPTABY: I,NUMCOL,NMAX = ',
     1                 3I5)
                CALL DPWRST('XXX','WRIT')
              ENDIF
C
              CALL DPTABY(IVALUE,NCTEMP,AVALUE,NUMCOL,ITYPCO,
     1                    IFLAGA,IFLAGB,NMAX,NTOT,IBUGA3,ISUBRO)
            ENDIF
  200     CONTINUE
        ENDIF
C
C               *******************************************
C               **   STEP 3--                            **
C               **   TERMINATE THE TABLE                 **
C               *******************************************
C
        ISTEPN='2'
        IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DT5B')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IF(.NOT.IFLAGE)GOTO399
C
        IF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'HTML')THEN
          IFLAG1=.TRUE.
          IFLAG2=.FALSE.
          IF(ILAST)IFLAG2=.TRUE.
          CALL DPHTM2(IFLAG1,IFLAG2,NHEAD)
        ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'LATE')THEN
          IFLAG1=.TRUE.
          IFLAG2=.FALSE.
          IFLAG3=.FALSE.
          IF(ILAST)THEN
            IFLAG2=.TRUE.
            IFLAG3=.TRUE.
          ENDIF
          CALL DPLATZ(IFLAG1,IFLAG2,IFLAG3,NHEAD)
        ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'RTF')THEN
          IF(IRTFFF.EQ.'Courier New')THEN
            ITEMP=1
          ELSEIF(IRTFFF.EQ.'Lucida Console')THEN
            ITEMP=8
          ENDIF 
          WRITE(ICOUT,8091)IBASLC,ITEMP
          CALL DPWRST(ICOUT,'WRIT')
          CALL DPRTF6(NHEAD)
          CALL DPRTF6(NHEAD)
          IF(ILAST)THEN
            IRTFMD='VERB'
          ENDIF
        ELSE
          IF(ILAST)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
          ENDIF
        ENDIF
C
  399   CONTINUE
C
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE DPDT5C(ITITL9,NCTIT9,
     1                  IHEAD,NCHEAD,ITITLE,NCTITL,
     1                  MAXLIN,NUMLIN,MAXCOL,NUMCOL,
     1                  ITEXT,NCTEXT,AVAL,ITYPCO,MAXROW,NUMROW,
     1                  IDIGIT,NTOT,IWHTML,IWRTF,VALIGZ,ALIGNZ,NMAX,
     1                  ICAPSW,ICAPTY,IFIRST,ILAST,
     1                  IFLAGS,IFLAGE,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE PRINTS A MULTI-COLUMN TABLE CONSISTING OF:
C
C              1) AN OPTIONAL OVERALL TITLE
C              2) HEADERS FOR EACH OF THE COLUMNS (THESE HEADERS MAY
C                 CONTAIN MULTIPLE LINES).
C              3) A TABLE OF NUMERIC/CHARACTER VALUES.  THIS IS A
C                 VARIANT OF TABLE 2 (WHICH ONLY ALLOWS TEXT FIELDS
C                 FOR THE FIRST COLUMN).
C
C              ITITL9     => THE OVERALL TITLE
C              IHEAD      => TABLE CAPTION
C              ITITLE     => LINES FOR THE COLUMN HEADERS
C              AVAL       => MATRIX OF NUMERIC VALUES FOR THE TABLE
C              ITEXT      => MATRIX OF CHARACTER VALUES FOR THE TABLE
C
C              NOTE: THIS IS A VARIANT OF DPDTA5 THAT ALLOWS THE
C                    THE TYPE FOR A COLUMN TO VARY BETWEEN ALPHABETIC
C                    AND NUMERIC FOR DIFFERENT ROWS.
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2012/3
C     ORIGINAL VERSION--MARCH     2012.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*(*) IHEAD
      CHARACTER*(*) ITITL9
      CHARACTER*(*) ITITLE(MAXLIN,MAXCOL)
      CHARACTER*4   VALIGZ(*)
      CHARACTER*4   ALIGNZ(*)
      INTEGER       NCTITL(MAXLIN,MAXCOL)
      INTEGER       NCTEXT(MAXROW,MAXCOL)
      INTEGER       IDIGIT(*)
      INTEGER       NTOT(*)
      INTEGER       IWHTML(*)
      INTEGER       IWRTF(*)
      REAL          AVAL(MAXROW,MAXCOL)
      CHARACTER*(*) ITEXT(MAXROW,MAXCOL)
      CHARACTER*4   ITYPCO(MAXROW,MAXCOL)
      CHARACTER*4   ITYPC2(20)
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      LOGICAL IFLAG1
      LOGICAL IFLAG2
      LOGICAL IFLAG3
      LOGICAL IFLAGA
      LOGICAL IFLAGB
      LOGICAL IFLAGS
      LOGICAL IFLAGE
      LOGICAL IBOLD
      LOGICAL IFIRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXHED=50)
      INTEGER IWIDTH(MAXHED)
      INTEGER NUMDIG(MAXHED)
      CHARACTER*8 ALIGN(MAXHED)
      CHARACTER*8 VALIGN(MAXHED)
      COMMON/HTML4/IWIDTH,NUMDIG,ALIGN,VALIGN
      CHARACTER*60 IVALUE(MAXHED)
      INTEGER      NCTEMP(MAXHED)
      REAL         AVALUE(MAXHED)
C
      CHARACTER*132 ITEMPC
C
      CHARACTER*4 IRTFMD
      COMMON/COMRTF/IRTFMD
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='A5  '
C
      IERROR='NO'
C
      DO40I=1,MAXHED
        IVALUE(I)=' '
        AVALUE(I)=0.0
        NCTEMP(I)=0
   40 CONTINUE
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT5C')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDT5C--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,53)MAXLIN,MAXROW,NUMROW,NUMCOL,NUMLIN
   53   FORMAT('MAXLIN,MAXROW,NUMROW,NUMCOL,NUMLIN = ',5I8)
        CALL DPWRST('XXX','WRIT')
        IF(NUMLIN.GT.0)THEN
          DO54I=1,NUMLIN
            DO55J=1,NUMCOL
              IF(NCTITL(I,J).GT.0)THEN
                NTEMP=MIN(80,NCTITL(I,J))
                WRITE(ICOUT,56)I,J,NCTITL(I,J),ITITLE(I,J)(1:NTEMP)
   56           FORMAT('I,J,NCTITL(I,J),ITITL(I,J)(1:NCTITL) = ',
     1                 3I5,2X,A80)
                CALL DPWRST('XXX','WRIT')
              ENDIF
   55       CONTINUE
   54     CONTINUE
        ENDIF
        IF(NUMROW.GT.0)THEN
          DO57I=1,NUMROW
            WRITE(ICOUT,60)I,(AVAL(I,J),J=1,MIN(5,NUMCOL))
   60       FORMAT('I,(AVAL(I,J),J=1,NUMCOL) = ',I8,5G15.7)
            CALL DPWRST('XXX','WRIT')
   57     CONTINUE
          DO77I=1,NUMROW
          DO79J=1,NUMCOL
            WRITE(ICOUT,80)I,J,ITEXT(I,J)
   80       FORMAT('I,J,ITEXT(I,J) = ',2I5,2X,A60)
            CALL DPWRST('XXX','WRIT')
   79     CONTINUE
   77     CONTINUE
        ENDIF
        WRITE(ICOUT,62)NCHEAD
   62   FORMAT('NCHEAD = ',I5)
        CALL DPWRST('XXX','WRIT')
        IF(NCHEAD.GT.0)THEN
          WRITE(ICOUT,63)IHEAD(1:NCHEAD)
   63     FORMAT('NCHEAD,IHEAD = ',A80)
          CALL DPWRST('XXX','WRIT')
        ENDIF
      ENDIF
C
C               ******************************************
C               **   STEP 1--                           **
C               **   WRITE OUT THE TABLE HEADER.        **
C               **   NOTE THAT THIS MAY CONSIST OF      **
C               **   MULTIPLE LINES.                    **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DT5C')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'ON')THEN
C
        CALL DPCONA(92,IBASLC)
C
C       SKIP HEADER IF REQUESTED
C
        IF(.NOT.IFLAGS)GOTO199
C
        NHEAD=NUMCOL
C
        DO100I=1,NUMCOL
          IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
            IWIDTH(I)=IWHTML(I)
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='BOTTOM'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='CENTER'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='TOP'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='LEFT'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='CENTER'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='RIGHT'
            ENDIF
C
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='b'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='c'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='t'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='l'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='c'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='r'
            ENDIF
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF')THEN
            IWIDTH(I)=IWRTF(I)
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='b'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='c'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='t'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='l'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='c'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='r'
            ENDIF
          ELSE
            IF(VALIGZ(I).EQ.'b')THEN
              VALIGN(I)='b'
            ELSEIF(VALIGZ(I).EQ.'c')THEN
              VALIGN(I)='c'
            ELSEIF(VALIGZ(I).EQ.'t')THEN
              VALIGN(I)='t'
            ENDIF
            IF(ALIGNZ(I).EQ.'l')THEN
              ALIGN(I) ='l'
            ELSEIF(ALIGNZ(I).EQ.'c')THEN
              ALIGN(I) ='c'
            ELSEIF(ALIGNZ(I).EQ.'r')THEN
              ALIGN(I) ='r'
            ENDIF
          ENDIF
  100   CONTINUE
C
C       LOOP THROUGH THE LINES OF THE HEADER
C
        IF(NUMLIN.GE.1)THEN
          DO110I=1,NUMLIN
C
            DO120J=1,NUMCOL
              IVALUE(J)=' '
              NCTEMP(J)=0
              IF(NCTITL(I,J).GT.0)THEN
                NCTEMP(J)=NCTITL(I,J)
                IVALUE(J)(1:NCTEMP(J))=ITITLE(I,J)(1:NCTEMP(J))
              ENDIF
C
              IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT5C')THEN
                WRITE(ICOUT,106)I,J,NCTEMP(J),IVALUE(J)
  106           FORMAT('I,J,NCTEMP(J),IVALUE(J) = ',3I8,A80)
                CALL DPWRST('XXX','WRIT')
              ENDIF
C
  120       CONTINUE
C
            IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
              IF(I.EQ.1)THEN
                IFLAG1=.FALSE.
                IF(IFIRST)IFLAG1=.TRUE.
                IFLAG2=.TRUE.
                IF(NCTIT9.LE.0)THEN
                  IF(IFIRST)THEN
                    CALL DPHTM1(IHEAD,NCHEAD,IFLAG1,IFLAG2)
                  ELSE
                    CALL DPHTMA(ITITL9,NCTIT9,IHEAD,NCHEAD,
     1                          IFLAG1,IFLAG2)
                  ENDIF
                ELSE
                  CALL DPHTMA(ITITL9,NCTIT9,IHEAD,NCHEAD,IFLAG1,IFLAG2)
                ENDIF
              ENDIF
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
              CALL DPHTM4(IVALUE,NCTEMP,NUMCOL,IFLAG1,IFLAG2)
C
            ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
C
              IF(I.EQ.1)THEN
                IF(IFIRST)THEN
                  IFLAG1=.FALSE.
                  IFLAG2=.FALSE.
                  IFLAG3=.TRUE.
                  CALL DPLAT6(IFLAG1,IFLAG2,IFLAG3)
                ENDIF
                IFLAG1=.FALSE.
                IF(IFIRST)IFLAG1=.TRUE.
                IFLAG2=.TRUE.
C
                CALL DPDTLA(IHEAD,NCHEAD,NCT,ISUBRO,IBUGA3,IERROR)
                NCHEAD=NCT
C
                IF(NCTIT9.LE.0)THEN
                  ITEMPC=' '
                  NCHEA2=0
                  CALL DPLAT1(IHEAD,NCHEAD,ITEMPC,NCHEA2,IFLAG1)
                ELSE
                  CALL DPDTLA(ITITL9,NCTIT9,NCT,ISUBRO,IBUGA3,IERROR)
                  NCTIT9=NCT
                  CALL DPLAT1(ITITL9,NCTIT9,IHEAD,NCHEAD,IFLAG1)
                ENDIF
              ENDIF
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IFLAG3=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
              IF(I.EQ.1)IFLAG3=.TRUE.
C
              DO6110JJ=1,NUMCOL
                CALL DPDTLA(IVALUE(JJ),NCTEMP(JJ),NCT,
     1                      ISUBRO,IBUGA3,IERROR)
                NCTEMP(JJ)=NCT
 6110         CONTINUE
C
              CALL DPLAT4(IVALUE,NCTEMP,NUMCOL,IFLAG1,IFLAG2,IFLAG3)
C
            ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF ')THEN
C
 8091         FORMAT(A1,'f',I1)
              IF(I.EQ.1)THEN
                IF(IRTFFP.EQ.'Times New Roman')THEN
                  ITEMP=0
                ELSEIF(IRTFFP.EQ.'Lucida Sans')THEN
                  ITEMP=6
                ELSEIF(IRTFFP.EQ.'Arial')THEN
                  ITEMP=2
                ELSEIF(IRTFFP.EQ.'Bookman')THEN
                  ITEMP=3
                ELSEIF(IRTFFP.EQ.'Georgia')THEN
                  ITEMP=4
                ELSEIF(IRTFFP.EQ.'Tahoma')THEN
                  ITEMP=5
                ELSEIF(IRTFFP.EQ.'Verdana')THEN
                  ITEMP=7
                ELSE
                  ITEMP=0
                ENDIF 
C
                IRTFMD='OFF'
C
                IF(NCTIT9.GE.1.AND.I.EQ.1)THEN
                  IF(NCTIT9.LE.0)THEN
                    ITEMPC=' '
                    NCHEA2=0
                  ELSE
                    NCHEA2=NCTIT9+3
                    ITEMPC(4:NCHEA2)=ITITL9(1:NCTIT9)
                    ITEMPC(1:3)=' b '
                    ITEMPC(1:1)=IBASLC
                  ENDIF
                  IF(NCHEAD.GE.1)THEN
                    NCTEM2=NCHEAD+3
                    IHEAD(4:NCTEM2)=IHEAD(1:NCHEAD)
                    IHEAD(1:3)=' b '
                    IHEAD(1:1)=IBASLC
                  ELSE
                    NCTEM2=0
                  ENDIF
                  CALL DPRTF1(ITEMPC,NCHEA2,IHEAD,NCTEM2)
                ENDIF
              ENDIF
C
              DO130J=1,NUMCOL
                NCHAR=NCTEMP(J)+3
                IVALUE(J)(4:NCHAR)=IVALUE(J)(1:NCTEMP(J))
                IVALUE(J)(1:3)=' b '
                IVALUE(J)(1:1)=IBASLC
                NCTEMP(J)=NCHAR
  130         CONTINUE
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
              CALL DPRTF4(IVALUE,NCTEMP,NUMCOL,IFLAG1,IFLAG2)
            ELSE
              IF(I.EQ.1)THEN
                IFLAG1=.TRUE.
                CALL DPTAB1(ITITL9,NCTIT9,IHEAD,NCHEAD,IFLAG1)
              ENDIF
              IFLAG1=.FALSE.
              IFLAG2=.FALSE.
              IF(I.EQ.1)IFLAG1=.TRUE.
              IF(I.EQ.NUMLIN)IFLAG2=.TRUE.
C
              DO 141 KK=1,NUMCOL
                IF(ALIGN(KK).EQ.'l' .AND. NCTEMP(KK).LT.NTOT(KK))THEN
                  DO146JJ=NCTEMP(KK)+1,NTOT(KK)
                    IVALUE(KK)(JJ:JJ)=' '
  146             CONTINUE
                  NCTEMP(KK)=NTOT(KK)
                ELSEIF(ALIGN(KK).EQ.'c'.AND.NCTEMP(KK).LT.NTOT(KK))THEN
                  IVALUE(KK)(NCTEMP(KK):NTOT(KK))=' '
                  IDIFF=(NTOT(KK)-NCTEMP(KK))/2
                  IF(IDIFF.GT.0)THEN
                    DO147JJ=NTOT(KK),IDIFF+1,-1
                      IVALUE(KK)(JJ:JJ)=IVALUE(KK)(JJ-IDIFF:JJ-IDIFF)
  147               CONTINUE
                    IVALUE(KK)(1:IDIFF)=' '
                  ENDIF
                  NCTEMP(KK)=NTOT(KK)
                ELSEIF(ALIGN(KK).EQ.'r'.AND.NCTEMP(KK).LT.NTOT(KK))THEN
C
                  IF(ISUBRO.EQ.'DT5C' .OR. IBUGA3.EQ.'ON')THEN
                    WRITE(ICOUT,157)KK,NCTEMP(KK),NTOT(KK)
  157               FORMAT('BEFORE 148: KK,NCTEMP(KK),NTOT(KK) =',
     1                     3I8)
                    CALL DPWRST('XXX','WRIT')
                    WRITE(ICOUT,153)IVALUE(KK)(1:NCTEMP(KK))
                    CALL DPWRST('XXX','WRIT')
                  ENDIF
C
                  IDIFF=NTOT(KK)-NCTEMP(KK)
                  DO148JJ=NTOT(KK),IDIFF+1,-1
                    IVALUE(KK)(JJ:JJ)=IVALUE(KK)(JJ-IDIFF:JJ-IDIFF)
  148             CONTINUE
                  IVALUE(KK)(1:IDIFF)=' '
                  NCTEMP(KK)=NTOT(KK)
                ENDIF
C
                IF(ISUBRO.EQ.'DT5C' .OR. IBUGA3.EQ.'ON')THEN
                  WRITE(ICOUT,151)KK,IDIFF,NCTEMP(KK),NUMCOL,NMAX
  151             FORMAT('BEFORE CALL DPTAB4: KK,IDIFF,NCTEMP(KK),',
     1                   'NUMCOL,NMAX=',5I8)
                  CALL DPWRST('XXX','WRIT')
                  WRITE(ICOUT,153)IVALUE(KK)(1:NCTEMP(KK))
  153             FORMAT('IVALUE(KK) = ',A80)
                  CALL DPWRST('XXX','WRIT')
                ENDIF
C
  141         CONTINUE
C
              CALL DPTAB4(IVALUE,NCTEMP,NUMCOL,IFLAG1,IFLAG2,NMAX)
C
            ENDIF
  110     CONTINUE
        ENDIF
C
  199   CONTINUE
C
C               ******************************************
C               **   STEP 2--                           **
C               **   WRITE OUT THE TABLE ROWS           **
C               ******************************************
C
        IFLAGA=.FALSE.
        IFLAGB=.FALSE.
        MAXLTA=35
        ILINE=0
        IF(NUMROW.GE.1)THEN
          DO200I=1,NUMROW
C
            DO201JJ=1,NUMCOL
              ITYPC2(JJ)=ITYPCO(I,JJ)
  201       CONTINUE
C
            IFLAG1=.FALSE.
            IF(I.EQ.NUMROW)IFLAG1=.TRUE.
            DO210J=1,NUMCOL
              AVALUE(J)=AVAL(I,J)
              IF(AVALUE(J).EQ.CPUMIN)THEN
                NUMDIG(J)=-99
              ELSE
                NUMDIG(J)=IDIGIT(J)
              ENDIF
              IVALUE(J)=' '
              NTEMP=NCTEXT(I,J)
              NCTEMP(J)=NTEMP
              IF(NTEMP.GT.0 .AND. ITYPC2(J).EQ.'ALPH')THEN
                IVALUE(J)(1:NTEMP)=ITEXT(I,J)(1:NTEMP)
C
                IF(ICAPTY.EQ.'LATE')THEN
                  CALL DPDTLA(IVALUE(J),NTEMP,NCT,ISUBRO,IBUGA3,IERROR)
                  NTEMP=NCT
                  NCTEMP(J)=NTEMP
                ENDIF
C
              ENDIF
C
              IF(ISUBRO.EQ.'DT5C' .OR. IBUGA3.EQ.'ON')THEN
                WRITE(ICOUT,211)I,J,ITYPC2(J),AVALUE(J),IVALUE(J)
  211           FORMAT('I,J,ITYPC2(J),AVALUE(J),IVALUE(J) = ',
     1                 2I8,2X,A4,2X,G15.7,2X,A60)
                CALL DPWRST('XXX','WRIT')
              ENDIF
C
  210       CONTINUE
C
            IF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'HTML')THEN
              CALL DPHTMY(IVALUE,NCTEMP,AVALUE,NUMCOL,ITYPC2,
     1                    IFLAGA,IFLAGB)
C
C           FOR LATEX, WE CANNOT EXTEND TABLES BEYOND A SINGLE
C           PAGE, SO PUT A CHECK IN.
C
            ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'LATE')THEN
              CALL DPLATW(IVALUE,NCTEMP,AVALUE,NUMCOL,ITYPC2,
     1                    IFLAGA,IFLAGB)
              ILINE=ILINE+1
              IF(ILINE.EQ.MAXLTA .AND. I.NE.NUMROW)THEN
                ILINE=0
                IFLAG1=.TRUE.
                IFLAG2=.FALSE.
                IFLAG3=.TRUE.
                CALL DPLATZ(IFLAG1,IFLAG2,IFLAG3,NHEAD)
                IFLAG1=.FALSE.
                IFLAG2=.FALSE.
                IFLAG3=.TRUE.
                CALL DPLATY(NHEAD)
              ENDIF
            ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'RTF')THEN
              CALL DPRTFY(IVALUE,NCTEMP,AVALUE,NUMCOL,ITYPC2,
     1                    IFLAGA,IFLAGB)
            ELSE
C
              IF(ISUBRO.EQ.'DT5C' .OR. IBUGA3.EQ.'ON')THEN
                WRITE(ICOUT,251)I,NUMCOL,NMAX
  251           FORMAT('BEFORE CALL DPTABY: I,NUMCOL,NMAX = ',
     1                 3I5)
                CALL DPWRST('XXX','WRIT')
              ENDIF
C
              CALL DPTABY(IVALUE,NCTEMP,AVALUE,NUMCOL,ITYPC2,
     1                    IFLAGA,IFLAGB,NMAX,NTOT,IBUGA3,ISUBRO)
            ENDIF
  200     CONTINUE
        ENDIF
C
C               *******************************************
C               **   STEP 3--                            **
C               **   TERMINATE THE TABLE                 **
C               *******************************************
C
        ISTEPN='2'
        IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DT5C')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IF(.NOT.IFLAGE)GOTO399
C
        IF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'HTML')THEN
          IFLAG1=.TRUE.
          IFLAG2=.FALSE.
          IF(ILAST)IFLAG2=.TRUE.
          CALL DPHTM2(IFLAG1,IFLAG2,NHEAD)
        ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'LATE')THEN
          IFLAG1=.TRUE.
          IFLAG2=.FALSE.
          IFLAG3=.FALSE.
          IF(ILAST)THEN
            IFLAG2=.TRUE.
            IFLAG3=.TRUE.
          ENDIF
          CALL DPLATZ(IFLAG1,IFLAG2,IFLAG3,NHEAD)
        ELSEIF(ICAPSW.EQ.'ON'.AND.ICAPTY.EQ.'RTF')THEN
          IF(IRTFFF.EQ.'Courier New')THEN
            ITEMP=1
          ELSEIF(IRTFFF.EQ.'Lucida Console')THEN
            ITEMP=8
          ENDIF 
          WRITE(ICOUT,8091)IBASLC,ITEMP
          CALL DPWRST(ICOUT,'WRIT')
          CALL DPRTF6(NHEAD)
          CALL DPRTF6(NHEAD)
          IF(ILAST)THEN
            IRTFMD='VERB'
          ENDIF
        ELSE
          IF(ILAST)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
          ENDIF
        ENDIF
C
  399   CONTINUE
C
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE DPDTA6(COV,ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALOWSH,AUPPSH,
     1                  ALPHA,NUMALP,
     1                  ICAPSW,ICAPTY,NUMDIG,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--FOR VARIOUS 3-PARAMETER PROBABILITY DISTRIBUTIONS,
C              THIS SUBROUTINE PRINTS THE CONFIDENCE INTERVAL
C              TABLES FOR THE LOCATION, SCALE AND THE SHAPE PARAMETERS.
C              THIS IS CURRENTLY LIMITED TO THE NORMAL APPROXIMATION
C              METHOD.  IN ADDITION, IT WILL PRINT THE PARAMETER
C              VARIANCE-COVARIANCE MATRIX.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/05
C     ORIGINAL VERSION--APRIL     2010
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 ILIKFL
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION COV(3,3)
      DIMENSION ALPHA(*)
      DIMENSION ALOWLO(*)
      DIMENSION AUPPLO(*)
      DIMENSION ALOWSC(*)
      DIMENSION AUPPSC(*)
      DIMENSION ALOWSH(*)
      DIMENSION AUPPSH(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=10)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(NUMALP)
      CHARACTER*4  ALIGN(NUMALP)
      CHARACTER*4  VALIGN(NUMALP)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
C
      PARAMETER(NUMCLI=5)
      PARAMETER(MAXLIN=3)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      IWHTML(NUMALP)
      INTEGER      IWRTF(NUMALP)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='A6  '
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTA6')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDTA6--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMALP
   52   FORMAT('IBUGA3,ISUBRO,NUMALP = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,NUMALP
          WRITE(ICOUT,57)I,ALOWLO(I),AUPPLO(I),ALOWSC(I),AUPPSC(I),
     1                   ALOWSH(I),AUPPSH(I)
   57     FORMAT('I,ALOWLO(I),AUPPLO(I),ALOWSC(I),AUPPSC(I),',
     1           'ALOWSH(I),AUPPSH(I) = ',I8,6G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
      ITITLE(1:42)='Parameter Variance-Covariance Matrix'
      NCTITL=36
      NUMLIN=2
      NUMCOL=3
      NUMROW=3
      ITITL2(1,1)='Location'
      ITITL2(2,1)='Parameter'
      NCTIT2(1,1)=8
      NCTIT2(2,1)=9
      ITITL2(1,2)='Scale'
      ITITL2(2,2)='Parameter'
      NCTIT2(1,2)=5
      NCTIT2(2,2)=9
      ITITL2(1,3)='Shape'
      ITITL2(2,3)='Parameter'
      NCTIT2(1,3)=5
      NCTIT2(2,3)=9
C
      NMAX=0
      DO1121I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 1121 CONTINUE
      DO1123I=1,NUMROW
        NCTEXT(I)=0
        AMAT(I,1)=COV(I,1)
        AMAT(I,2)=COV(I,2)
        AMAT(I,3)=COV(I,3)
 1123 CONTINUE
      IWHTML(1)=150
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+2000
      IWRTF(3)=IWRTF(2)+2000
      ITITL9=' '
      NCTIT9=0
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      CALL DPDTA2(ITITLE,NCTITL,
     1            ITITL9,NCTIT9,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NUMROW,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ITITLE(1:42)='Confidence Interval for Location Parameter'
      NCTITL=42
      NUMLIN=3
      NUMCOL=3
      ITITL2(1,1)=' '
      ITITL2(2,1)='Confidence'
      ITITL2(3,1)='Coefficient'
      NCTIT2(1,1)=0
      NCTIT2(2,1)=10
      NCTIT2(3,1)=11
      ITITL2(1,2)='Normal'
      ITITL2(2,2)='Lower'
      ITITL2(3,2)='Limit'
      NCTIT2(1,2)=6
      NCTIT2(2,2)=5
      NCTIT2(3,2)=5
      ITITL2(1,3)='Approximation'
      ITITL2(2,3)='Upper'
      ITITL2(3,3)='Limit'
      NCTIT2(1,3)=13
      NCTIT2(2,3)=5
      NCTIT2(3,3)=5
C
      NMAX=0
      DO1521I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 1521 CONTINUE
      NTOT(1)=12
      IDIGIT(1)=2
      DO1523I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWLO(I)
        AMAT(I,3)=AUPPLO(I)
 1523 CONTINUE
      IWHTML(1)=150
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+2000
      IWRTF(3)=IWRTF(2)+2000
      ITITL9=' '
      NCTIT9=0
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      CALL DPDTA2(ITITLE,NCTITL,
     1            ITITL9,NCTIT9,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ITITLE(1:39)='Confidence Interval for Scale Parameter'
      NCTITL=39
      NUMLIN=3
      NUMCOL=3
      ITITL2(1,1)=' '
      ITITL2(2,1)='Confidence'
      ITITL2(3,1)='Coefficient'
      NCTIT2(1,1)=0
      NCTIT2(2,1)=10
      NCTIT2(3,1)=11
      ITITL2(1,2)='Normal'
      ITITL2(2,2)='Lower'
      ITITL2(3,2)='Limit'
      NCTIT2(1,2)=6
      NCTIT2(2,2)=5
      NCTIT2(3,2)=5
      ITITL2(1,3)='Approximation'
      ITITL2(2,3)='Upper'
      ITITL2(3,3)='Limit'
      NCTIT2(1,3)=13
      NCTIT2(2,3)=5
      NCTIT2(3,3)=5
C
      NMAX=0
      DO2521I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 2521 CONTINUE
      NTOT(1)=12
      IDIGIT(1)=2
      DO2523I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWSC(I)
        AMAT(I,3)=AUPPSC(I)
 2523 CONTINUE
      IWHTML(1)=150
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+2000
      IWRTF(3)=IWRTF(2)+2000
      ITITL9=' '
      NCTIT9=0
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      CALL DPDTA2(ITITLE,NCTITL,
     1            ITITL9,NCTIT9,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ITITLE(1:39)='Confidence Interval for Shape Parameter'
      NCTITL=39
      DO2533I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWSH(I)
        AMAT(I,3)=AUPPSH(I)
 2533 CONTINUE
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      CALL DPDTA2(ITITLE,NCTITL,
     1            ITITL9,NCTIT9,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTA6')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDTA6--')
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDTA7(ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,NUMALP,
     1                  ICAPSW,ICAPTY,NUMDIG,INORM,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE PRINTS THE CONFIDENCE INTERVAL TABLES
C              FOR THE LOCATION AND SCALE PARAMETERS FOR
C              LOCATION/SCALE PROBABILITY DISTRIBUTIONS.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/02
C     ORIGINAL VERSION--FEBRUARY  2010. EXTRACTED AS DISTINCT SUBROUTINE
C     UPDATED         --JUNE      2010. ADD "NORMAL APPROXIMATION"
C                                       TO TITLE LINE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 INORM
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION ALPHA(*)
      DIMENSION ALOWSC(*)
      DIMENSION AUPPSC(*)
      DIMENSION ALOWLO(*)
      DIMENSION AUPPLO(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=10)
      CHARACTER*70 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMALP)
      CHARACTER*4  VALIGN(NUMALP)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
C
      PARAMETER(NUMCLI=3)
      PARAMETER(MAXLIN=2)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      IWHTML(NUMALP)
      INTEGER      IWRTF(NUMALP)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='A7  '
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTA7')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDTA7--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMALP
   52   FORMAT('IBUGA3,ISUBRO,NUMALP = ',A4,2X,A4,2X,I5)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,NUMALP
          WRITE(ICOUT,57)I,ALOWLO(I),AUPPLO(I),ALOWSC(I),AUPPSC(I)
   57     FORMAT('I,ALOWLO(I),AUPPLO(I),ALOWSC(I),AUPPSC(I) = ',
     1           I8,4G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
      ITITL9=' '
      NCTIT9=0
      ITITLE(1:42)='Confidence Interval for Location Parameter'
      IF(INORM.EQ.'YES')THEN
        ITITLE(43:65)=' (Normal Approximation)'
        NCTITL=65
      ELSE
        NCTITL=42
      ENDIF
      NUMLIN=2
      NUMCOL=3
      ITITL2(1,1)='Confidence'
      ITITL2(2,1)='Coefficient'
      ITITL2(1,2)='Lower'
      ITITL2(2,2)='Limit'
      ITITL2(1,3)='Upper'
      ITITL2(2,3)='Limit'
      NCTIT2(1,1)=10
      NCTIT2(2,1)=11
      NCTIT2(1,2)=5
      NCTIT2(2,2)=5
      NCTIT2(1,3)=5
      NCTIT2(2,3)=5
      NMAX=0
      DO2420I=1,NUMCOL
        VALIGN(I)=' '
        ALIGN(I)=' '
        NTOT(I)=0
        IDIGIT(I)=0
 2420 CONTINUE
      DO2421I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 2421 CONTINUE
      IDIGIT(1)=2
      DO2423I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWLO(I)
        AMAT(I,3)=AUPPLO(I)
 2423 CONTINUE
      IWHTML(1)=150
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+2000
      IWRTF(3)=IWRTF(2)+2000
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      IF(ALOWLO(1).EQ.CPUMIN)GOTO2999
C
      CALL DPDTA2(ITITL9,NCTIT9,
     1            ITITLE,NCTITL,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
 2999 CONTINUE
C
      ITITLE(1:39)='Confidence Interval for Scale Parameter'
      IF(INORM.EQ.'YES')THEN
        ITITLE(40:62)=' (Normal Approximation)'
        NCTITL=62
      ELSE
        NCTITL=39
      ENDIF
      NMAX=0
      DO2521I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 2521 CONTINUE
      IDIGIT(1)=2
      DO2523I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWSC(I)
        AMAT(I,3)=AUPPSC(I)
 2523 CONTINUE
      IWHTML(1)=150
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+2000
      IWRTF(3)=IWRTF(2)+2000
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      CALL DPDTA2(ITITL9,NCTIT9,
     1            ITITLE,NCTITL,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTA7')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDTA7--')
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDT77(ALOWLO,AUPPLO,ALOWSC,AUPPSC,
     1                  ALOWL2,AUPPL2,ALOWS2,AUPPS2,
     1                  ALPHA,NUMALP,
     1                  ICAPSW,ICAPTY,NUMDIG,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE PRINTS THE CONFIDENCE INTERVAL TABLES
C              FOR THE LOCATION AND SCALE PARAMETERS FOR
C              LOCATION/SCALE PROBABILITY DISTRIBUTIONS.
C
C              THIS IS A VARIANT OF DPDTA7 THAT ALLOWS FOR BOTH
C              NORMAL APPROXIMATION AND FOR LIKELIHOOD RATIO
C              METHODS FOR COMPUTING CONFIDENCE INTERVALS.
C
C              IF ALOWLO(1) = CPUMIN, THEN SKIP LOCATION PARAMETER
C              (FOR 1-PARAMETER EXPONENTIAL, ETC.).
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/06
C     ORIGINAL VERSION--JUNE      2010. EXTRACTED AS DISTINCT SUBROUTINE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION ALPHA(*)
      DIMENSION ALOWSC(*)
      DIMENSION AUPPSC(*)
      DIMENSION ALOWLO(*)
      DIMENSION AUPPLO(*)
      DIMENSION ALOWS2(*)
      DIMENSION AUPPS2(*)
      DIMENSION ALOWL2(*)
      DIMENSION AUPPL2(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=10)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMALP)
      CHARACTER*4  VALIGN(NUMALP)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
C
      PARAMETER(NUMCLI=5)
      PARAMETER(MAXLIN=3)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      IWHTML(NUMALP)
      INTEGER      IWRTF(NUMALP)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='A7  '
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT77')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDT77--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMALP
   52   FORMAT('IBUGA3,ISUBRO,NUMALP = ',A4,2X,A4,2X,I5)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,NUMALP
          WRITE(ICOUT,57)I,ALOWLO(I),AUPPLO(I),ALOWSC(I),AUPPSC(I)
   57     FORMAT('I,ALOWLO(I),AUPPLO(I),ALOWSC(I),AUPPSC(I) = ',
     1           I8,4G15.7)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,58)I,ALOWL2(I),AUPPL2(I),ALOWS2(I),AUPPS2(I)
   58     FORMAT('I,ALOWL2(I),AUPPL2(I),ALOWS2(I),AUPPS2(I) = ',
     1           I8,4G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
      ITITL9=' '
      NCTIT9=0
      ITITLE(1:42)='Confidence Interval for Location Parameter'
      NCTITL=42
      NUMLIN=3
      NUMCOL=5
C
      ITITL2(1,1)=' '
      ITITL2(2,1)='Confidence'
      ITITL2(3,1)='Coefficient'
      NCTIT2(1,1)=0
      NCTIT2(2,1)=10
      NCTIT2(3,1)=11
      ITITL2(1,2)='Normal'
      ITITL2(2,2)='Lower'
      ITITL2(3,2)='Limit'
      NCTIT2(1,2)=6
      NCTIT2(2,2)=5
      NCTIT2(3,2)=5
      ITITL2(1,3)='Approximation'
      ITITL2(2,3)='Upper'
      ITITL2(3,3)='Limit'
      NCTIT2(1,3)=13
      NCTIT2(2,3)=5
      NCTIT2(3,3)=5
      ITITL2(1,4)='Likelihood Ratio'
      ITITL2(2,4)='Lower'
      ITITL2(3,4)='Limit'
      NCTIT2(1,4)=16
      NCTIT2(2,4)=5
      NCTIT2(3,4)=5
      ITITL2(1,5)='Approximation'
      ITITL2(2,5)='Upper'
      ITITL2(3,5)='Limit'
      NCTIT2(1,5)=13
      NCTIT2(2,5)=5
      NCTIT2(3,5)=5
C
      NMAX=0
      DO2521I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(I.EQ.1)NTOT(I)=12
        IF(I.EQ.4)NTOT(I)=18
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 2521 CONTINUE
      IDIGIT(1)=2
      DO2523I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWLO(I)
        AMAT(I,3)=AUPPLO(I)
        AMAT(I,4)=ALOWL2(I)
        AMAT(I,5)=AUPPL2(I)
 2523 CONTINUE
      IWHTML(1)=150
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWHTML(5)=150
      IWHTML(6)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+2000
      IWRTF(3)=IWRTF(2)+2000
      IWRTF(4)=IWRTF(3)+2000
      IWRTF(5)=IWRTF(4)+2000
C
      IF(ALOWLO(1).EQ.CPUMIN)GOTO2999
C
      ITITL9=' '
      NCTIT9=0
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA2(ITITL9,NCTIT9,
     1            ITITLE,NCTITL,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
 2999 CONTINUE
C
      IF(ALOWSC(1).EQ.CPUMIN)GOTO3999
C
      ITITLE(1:39)='Confidence Interval for Scale Parameter'
      NCTITL=39
      NMAX=0
      DO3521I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(I.EQ.1)NTOT(I)=12
        IF(I.EQ.4)NTOT(I)=18
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 3521 CONTINUE
      IDIGIT(1)=2
      DO3523I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWSC(I)
        AMAT(I,3)=AUPPSC(I)
        AMAT(I,4)=ALOWS2(I)
        AMAT(I,5)=AUPPS2(I)
 3523 CONTINUE
      IWHTML(1)=150
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWHTML(5)=150
      IWHTML(6)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+2000
      IWRTF(3)=IWRTF(2)+2000
      IWRTF(4)=IWRTF(3)+2000
      IWRTF(5)=IWRTF(4)+2000
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA2(ITITL9,NCTIT9,
     1            ITITLE,NCTITL,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
 3999 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT77')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDT77--')
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDTA8(ALOWSC,AUPPSC,ALOWS2,AUPPS2,
     1                  ALOWSH,AUPPSH,ALOSH2,AUPSH2,ALPHA,NUMALP,
     1                  ICAPSW,ICAPTY,NUMDIG,ILIKFL,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--FOR VARIOUS 2-PARAMETER PROBABILITY DISTRIBUTIONS,
C              THIS SUBROUTINE PRINTS THE CONFIDENCE INTERVAL
C              TABLES FOR BOTH THE SCALE AND THE SHAPE PARAMETERS.
C              FOR SOME DISTRIBUTIONS, WE HAVE ONLY THE NORMAL
C              APPROXIMATION WHILE FOR OTHER DISTRIBUTIONS WE HAVE
C              BOTH THE NORMAL APPROXIMATION AND THE LIKELIHOOD
C              RATIO APPROXIMATION.
C
C              FOR THE LOGNORMAL, SLIGHTY DIFFERENT TABLE
C              HEADER FOR SCALE PARAMETER.  ALSO DIFFERENT
C              HEADER FOR PARETO.
C
C              MAKE SCALE PARAMETER OPTIONAL (E.G., FOR THE
C              POWER AND REFLECTED POWER DISTRIBUTIONS).
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/02
C     ORIGINAL VERSION--FEBRUARY  2010. EXTRACTED AS A DISTINCT
C                                       SUBROUTINE
C     UPDATED         --APRIL     2010. HEADINGS FOR SCALE PARAMETER
C                                       FOR LOGNORMAL CASE
C     UPDATED         --JULY      2010. SLIGHT CORRECTION FOR
C                                       LOGNORMAL CASE
C     UPDATED         --JULY      2010. HEADINGS FOR CENSORED LOGNORMAL
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 ILIKFL
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION ALPHA(*)
      DIMENSION ALOWSC(*)
      DIMENSION AUPPSC(*)
      DIMENSION ALOWS2(*)
      DIMENSION AUPPS2(*)
      DIMENSION ALOWSH(*)
      DIMENSION AUPPSH(*)
      DIMENSION ALOSH2(*)
      DIMENSION AUPSH2(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=10)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(NUMALP)
      INTEGER      NCTEXT(MAXROW)
C
      PARAMETER(NUMCLI=5)
      PARAMETER(MAXLIN=3)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      IWHTML(NUMCLI+1)
      INTEGER      IWRTF(NUMCLI)
      INTEGER      IDIGIT(NUMCLI)
      INTEGER      NTOT(NUMCLI)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='A8  '
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTA8')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDTA8--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMALP
   52   FORMAT('IBUGA3,ISUBRO,NUMALP = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,NUMALP
          WRITE(ICOUT,57)I,ALOWSC(I),AUPPSC(I),ALOWSH(I),AUPPSH(I)
   57     FORMAT('I,ALOWSC(I),AUPPSC(I),ALOWSH(I),AUPPSH(I) = ',
     1            I8,4G15.7)
          CALL DPWRST('XXX','WRIT')
          IF(ILIKFL.EQ.'ON')THEN
            WRITE(ICOUT,58)I,ALOWS2(I),AUPPS2(I),ALOSH2(I),AUPSH2(I)
   58       FORMAT('I,ALOWS2(I),AUPPS2(I),ALOSH2(I),AUPSH2(I) = ',
     1             I8,4G15.7)
            CALL DPWRST('XXX','WRIT')
          ENDIF
   56   CONTINUE
      ENDIF
C
      ITITLE(1:39)='Confidence Interval for Scale Parameter'
      NCTITL=39
      NUMLIN=3
      NUMCOL=5
      ITITL2(1,1)=' '
      ITITL2(2,1)='Confidence'
      ITITL2(3,1)='Coefficient'
      NCTIT2(1,1)=0
      NCTIT2(2,1)=10
      NCTIT2(3,1)=11
      IF(ILIKFL.EQ.'LOGN')THEN
        ITITL2(1,2)='Scale'
        ITITL2(2,2)='Lower'
        ITITL2(3,2)='Limit'
        NCTIT2(1,2)=5
        NCTIT2(2,2)=5
        NCTIT2(3,2)=5
        ITITL2(1,3)='Parameter'
        ITITL2(2,3)='Upper'
        ITITL2(3,3)='Limit'
        NCTIT2(1,3)=9
        NCTIT2(2,3)=5
        NCTIT2(3,3)=5
        ITITL2(1,4)='MU'
        ITITL2(2,4)='Lower'
        ITITL2(3,4)='Limit'
        NCTIT2(1,4)=2
        NCTIT2(2,4)=5
        NCTIT2(3,4)=5
        ITITL2(1,5)='Parameter'
        ITITL2(2,5)='Upper'
        ITITL2(3,5)='Limit'
        NCTIT2(1,5)=9
        NCTIT2(2,5)=5
        NCTIT2(3,5)=5
      ELSE
        ITITL2(1,2)='Normal'
        ITITL2(2,2)='Lower'
        ITITL2(3,2)='Limit'
        NCTIT2(1,2)=6
        NCTIT2(2,2)=5
        NCTIT2(3,2)=5
        ITITL2(1,3)='Approximation'
        ITITL2(2,3)='Upper'
        ITITL2(3,3)='Limit'
        NCTIT2(1,3)=13
        NCTIT2(2,3)=5
        NCTIT2(3,3)=5
        ITITL2(1,4)='Likelihood Ratio'
        ITITL2(2,4)='Lower'
        ITITL2(3,4)='Limit'
        NCTIT2(1,4)=16
        NCTIT2(2,4)=5
        NCTIT2(3,4)=5
        ITITL2(1,5)='Approximation'
        ITITL2(2,5)='Upper'
        ITITL2(3,5)='Limit'
        NCTIT2(1,5)=13
        NCTIT2(2,5)=5
        NCTIT2(3,5)=5
      ENDIF
      IF(ILIKFL.EQ.'OFF')NUMCOL=3
C
      NMAX=0
      DO2521I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(I.EQ.1)NTOT(I)=12
        IF(I.EQ.4)NTOT(I)=18
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 2521 CONTINUE
      IDIGIT(1)=2
      DO2523I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWSC(I)
        AMAT(I,3)=AUPPSC(I)
        AMAT(I,4)=ALOWS2(I)
        AMAT(I,5)=AUPPS2(I)
 2523 CONTINUE
      IWHTML(1)=150
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWHTML(5)=150
      IWHTML(6)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+2000
      IWRTF(3)=IWRTF(2)+2000
      IWRTF(4)=IWRTF(3)+2000
      IWRTF(5)=IWRTF(4)+2000
C
      ITITL9=' '
      NCTIT9=0
      IFRST=.TRUE.
      ILAST=.TRUE.
      IF(ALOWSC(1).NE.CPUMIN)THEN
        CALL DPDTA2(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
      IF(ILIKFL.EQ.'LOGN')NUMCOL=3
      ITITLE(1:39)='Confidence Interval for Shape Parameter'
      NCTITL=39
C
C     ADJUST HEADERS FOR LOGNORMAL
C
      IF(ILIKFL.EQ.'LOGN')THEN
        NUMLIN=2
        NUMCOL=3
        ITITL2(1,1)='Confidence'
        ITITL2(2,1)='Coefficient'
        NCTIT2(1,1)=10
        NCTIT2(2,1)=11
        ITITL2(1,2)='Lower'
        ITITL2(1,2)='Limit'
        NCTIT2(1,2)=5
        NCTIT2(2,2)=5
        ITITL2(1,3)='Upper'
        ITITL2(2,3)='Limit'
        NCTIT2(1,3)=5
        NCTIT2(2,3)=5
      ENDIF
C
      DO2533I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWSH(I)
        AMAT(I,3)=AUPPSH(I)
        AMAT(I,4)=ALOSH2(I)
        AMAT(I,5)=AUPSH2(I)
 2533 CONTINUE
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      CALL DPDTA2(ITITLE,NCTITL,
     1            ITITL9,NCTIT9,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTA8')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDTA8--')
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDT8A(ALOWLO,AUPPLO,ALOWSC,AUPPSC,
     1                  ALO1SH,AUP1SH,AL1SH2,AU1SH2,
     1                  ALO2SH,AUP2SH,AL2SH2,AU2SH2,
     1                  ALPHA,NUMALP,
     1                  ICAPSW,ICAPTY,NUMDIG,
     1                  ILOCFL,ISCAFL,ILIKFL,
     1                  ISHAP1,NCSHA1,ISHAP2,NCSHA2,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--FOR TWO SHAPE PARAMETER DISTRIBUTIONS, PRINT
C              CONFIDENCE INTERVALS FOR:
C
C                 1) LOCATION OR LOWER LIMIT PARAMETER
C                 2) SCALE OR UPPER LIMIT PARAMETER
C                 3) SHAPE ONE PARAMETER
C                 4) SHAPE TWO PARAMETER
C
C              THE LOCATION/SCALE PARAMETERS ARE OPTIONAL.
C              THE SHAPE PARAMETERS CAN OPTIONALLY PRINT
C              NORMAL APPROXIMATIONS AND LIKELIHOOD RATIO
C              APPROXIMATIONS.
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/07
C     ORIGINAL VERSION--JULY      2010. EXTRACTED AS A DISTINCT
C                                       SUBROUTINE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 ILIKFL
      CHARACTER*4 ILOCFL
      CHARACTER*4 ISCAFL
      CHARACTER*8 ISHAP1
      CHARACTER*8 ISHAP2
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION ALPHA(*)
      DIMENSION ALOWLO(*)
      DIMENSION AUPPLO(*)
      DIMENSION ALOWSC(*)
      DIMENSION AUPPSC(*)
      DIMENSION ALO1SH(*)
      DIMENSION AUP1SH(*)
      DIMENSION AL1SH2(*)
      DIMENSION AU1SH2(*)
      DIMENSION ALO2SH(*)
      DIMENSION AUP2SH(*)
      DIMENSION AL2SH2(*)
      DIMENSION AU2SH2(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=10)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(NUMALP)
      CHARACTER*4  ALIGN(NUMALP)
      CHARACTER*4  VALIGN(NUMALP)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
C
      PARAMETER(NUMCLI=5)
      PARAMETER(MAXLIN=3)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      IWHTML(NUMALP)
      INTEGER      IWRTF(NUMALP)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='8A  '
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT8A')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDT8A--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMALP
   52   FORMAT('IBUGA3,ISUBRO,NUMALP = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,53)ILIKFL,ILOCFL,ISCAFL,ISHAP1,ISHAP2
   53   FORMAT('ILIKFL,ILOCFL,ISCAFL,ISHAP1,ISHAP2 = ',3(A4,2X),
     1         A8,2X,A8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,NUMALP
          WRITE(ICOUT,57)I,ALOWLO(I),AUPPLO(I),ALOWSC(I),AUPPSC(I)
   57     FORMAT('I,ALOWLO(I),AUPPLO(I),ALOWSC(I),AUPPSC(I) = ',
     1            I8,4G15.7)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,58)I,ALO1SH(I),AUP1SH(I),AL1SH2(I),AU1SH2(I)
   58     FORMAT('I,ALO1SH(I),AU1PSH(I),AL1SH2(I),AU1SH2(I) = ',
     1           I8,4G15.7)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,59)I,ALO2SH(I),AUP2SH(I),AL2SH2(I),AU2SH2(I)
   59     FORMAT('I,ALO2SH(I),AU2PSH(I),AL2SH2(I),AU2SH2(I) = ',
     1           I8,4G15.7)
   56   CONTINUE
      ENDIF
C
      ITITL9=' '
      NCTIT9=0
C
      IF(ILOCFL.NE.'OFF')THEN
        ITITLE(1:39)='Confidence Interval for Location Parameter'
        NCTITL=42
        NUMLIN=3
        NUMCOL=3
        ITITL2(1,1)=' '
        ITITL2(2,1)='Confidence'
        ITITL2(3,1)='Coefficient'
        NCTIT2(1,1)=0
        NCTIT2(2,1)=10
        NCTIT2(3,1)=11
        ITITL2(1,2)='Normal'
        IF(ILOCFL.NE.'ON')ITITL2(1,2)=' '
        ITITL2(2,2)='Lower'
        ITITL2(3,2)='Limit'
        NCTIT2(1,2)=6
        IF(ILOCFL.NE.'ON')NCTIT2(1,2)=0
        NCTIT2(2,2)=5
        NCTIT2(3,2)=5
        ITITL2(1,3)='Approximation'
        IF(ILOCFL.NE.'ON')ITITL2(1,3)=' '
        ITITL2(2,3)='Upper'
        ITITL2(3,3)='Limit'
        NCTIT2(1,3)=13
        IF(ILOCFL.NE.'ON')NCTIT2(1,3)=0
        NCTIT2(2,3)=5
        NCTIT2(3,3)=5
C
        NMAX=0
        DO1521I=1,NUMCOL
          VALIGN(I)='b'
          ALIGN(I)='r'
          NTOT(I)=15
          IF(I.EQ.1)NTOT(I)=12
          NMAX=NMAX+NTOT(I)
          IDIGIT(I)=NUMDIG
 1521   CONTINUE
        IDIGIT(1)=2
        DO1523I=1,NUMALP
          NCTEXT(I)=0
          AMAT(I,1)=100.0*(1.0 - ALPHA(I))
          AMAT(I,2)=ALOWLO(I)
          AMAT(I,3)=AUPPLO(I)
 1523   CONTINUE
        IWHTML(1)=150
        IWHTML(2)=150
        IWHTML(3)=150
        IWHTML(4)=150
        IWRTF(1)=2000
        IWRTF(2)=IWRTF(1)+2000
        IWRTF(3)=IWRTF(2)+2000
C
        IFRST=.TRUE.
        ILAST=.TRUE.
        CALL DPDTA2(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
      IF(ISCAFL.NE.'OFF')THEN
        ITITLE(1:39)='Confidence Interval for Scale Parameter'
        NCTITL=39
        NUMLIN=3
        NUMCOL=3
        ITITL2(1,1)=' '
        ITITL2(2,1)='Confidence'
        ITITL2(3,1)='Coefficient'
        NCTIT2(1,1)=0
        NCTIT2(2,1)=10
        NCTIT2(3,1)=11
        ITITL2(1,2)='Normal'
        IF(ISCAFL.NE.'ON')ITITL2(1,2)=' '
        ITITL2(2,2)='Lower'
        ITITL2(3,2)='Limit'
        NCTIT2(1,2)=6
        IF(ISCAFL.NE.'ON')NCTIT2(1,2)=0
        NCTIT2(2,2)=5
        NCTIT2(3,2)=5
        ITITL2(1,3)='Approximation'
        IF(ISCAFL.NE.'ON')ITITL2(1,3)=' '
        ITITL2(2,3)='Upper'
        ITITL2(3,3)='Limit'
        NCTIT2(1,3)=13
        IF(ISCAFL.NE.'ON')NCTIT2(1,3)=0
        NCTIT2(2,3)=5
        NCTIT2(3,3)=5
C
        NMAX=0
        DO2521I=1,NUMCOL
          VALIGN(I)='b'
          ALIGN(I)='r'
          NTOT(I)=15
          IF(I.EQ.1)NTOT(I)=12
          NMAX=NMAX+NTOT(I)
          IDIGIT(I)=NUMDIG
 2521   CONTINUE
        IDIGIT(1)=2
        DO2523I=1,NUMALP
          NCTEXT(I)=0
          AMAT(I,1)=100.0*(1.0 - ALPHA(I))
          AMAT(I,2)=ALOWSC(I)
          AMAT(I,3)=AUPPSC(I)
 2523   CONTINUE
        IWHTML(1)=150
        IWHTML(2)=150
        IWHTML(3)=150
        IWHTML(4)=150
        IWRTF(1)=2000
        IWRTF(2)=IWRTF(1)+2000
        IWRTF(3)=IWRTF(2)+2000
C
        IFRST=.TRUE.
        ILAST=.TRUE.
        CALL DPDTA2(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
      ITITLE(1:40)='Confidence Interval for Shape Parameter '
      ITITLE(41:41+NCSHA1-1)=ISHAP1(1:NCSHA1)
      NCTITL=41+NCSHA1-1
      NUMLIN=3
      NUMCOL=5
      IF(ILIKFL.NE.'ON')NUMCOL=3
C
C     IF ILIKFL SET TO 'EXAC', THEN THIS IMPLIES WE HAVE
C     AN "EXACT" (AS OPPOSSED TO A NORMAL APPROXIMATION).
C     IN THIS CASE, WE ONLY USE A 2-LINE HEADER.
C
      ICNT=0
      IF(ILIKFL.NE.'EXAC')THEN
        ICNT=ICNT+1
        ITITL2(ICNT,1)=' '
        NCTIT2(ICNT,1)=0
        ITITL2(ICNT,2)='Normal'
        NCTIT2(ICNT,2)=6
        ITITL2(ICNT,3)='Approximation'
        NCTIT2(ICNT,3)=13
        ITITL2(ICNT,4)='Likelihood Ratio'
        NCTIT2(ICNT,4)=16
        ITITL2(ICNT,5)='Approximation'
        NCTIT2(ICNT,5)=13
      ELSE
        NUMLIN=2
      ENDIF
      ICNT=ICNT+1
      ITITL2(ICNT,1)='Confidence'
      NCTIT2(ICNT,1)=10
      ITITL2(ICNT,2)='Lower'
      NCTIT2(ICNT,2)=5
      ITITL2(ICNT,3)='Upper'
      NCTIT2(ICNT,3)=5
      ITITL2(ICNT,4)='Lower'
      NCTIT2(ICNT,4)=5
      ITITL2(ICNT,5)='Upper'
      NCTIT2(ICNT,5)=5
      ICNT=ICNT+1
      ITITL2(ICNT,1)='Coefficient'
      NCTIT2(ICNT,1)=11
      ITITL2(ICNT,2)='Limit'
      NCTIT2(ICNT,2)=5
      ITITL2(ICNT,3)='Limit'
      NCTIT2(ICNT,3)=5
      ITITL2(ICNT,4)='Limit'
      NCTIT2(ICNT,4)=5
      ITITL2(ICNT,5)='Limit'
      NCTIT2(ICNT,5)=5
C
      NMAX=0
      DO2621I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(I.EQ.1)NTOT(I)=12
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 2621 CONTINUE
      IDIGIT(1)=2
C
      DO2533I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALO1SH(I)
        AMAT(I,3)=AUP1SH(I)
        IF(ILIKFL.EQ.'ON')THEN
          AMAT(I,4)=AL1SH2(I)
          AMAT(I,5)=AU1SH2(I)
        ENDIF
 2533 CONTINUE
      IWHTML(1)=150
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWHTML(5)=150
      IWHTML(6)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+2000
      IWRTF(3)=IWRTF(2)+2000
      IWRTF(4)=IWRTF(3)+2000
      IWRTF(5)=IWRTF(4)+2000
C
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      CALL DPDTA2(ITITLE,NCTITL,
     1            ITITL9,NCTIT9,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ITITLE(1:40)='Confidence Interval for Shape Parameter '
      ITITLE(41:41+NCSHA2-1)=ISHAP2(1:NCSHA2)
      NCTITL=41+NCSHA2-1
C
      DO2543I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALO2SH(I)
        AMAT(I,3)=AUP2SH(I)
        IF(ILIKFL.EQ.'ON')THEN
          AMAT(I,4)=AL2SH2(I)
          AMAT(I,5)=AU2SH2(I)
        ENDIF
 2543 CONTINUE
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      CALL DPDTA2(ITITLE,NCTITL,
     1            ITITL9,NCTIT9,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT8A')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDT88--')
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDT8B(ALOWPA,AUPPPA,ALPHA,NUMALP,
     1                  ICAPSW,ICAPTY,NUMDIG,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--PRINT A PERCENTILE CONFIDENCE LIMIT BASED ON THE
C              BOOTSTRAP SAMPLES.  THIS HANDLES THE CASE WHEN WE
C              ARE A BOOTSTRAPPING A STATISTIC.  A DIFFERENT ROUTINE
C              HANDLES THE CASE WHEN WE ARE BOOTSTRAPPING A
C              DISTRIBUTIONAL MODEL.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/07
C     ORIGINAL VERSION--JULY      2010.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION ALPHA(*)
      DIMENSION ALOWPA(*)
      DIMENSION AUPPPA(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=10)
      CHARACTER*50 ITITLE
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      INTEGER      NCTEXT(MAXROW)
C
      PARAMETER(NUMCLI=3)
      PARAMETER(MAXLIN=2)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      IWHTML(NUMCLI+1)
      INTEGER      IWRTF(NUMCLI)
      INTEGER      IDIGIT(NUMCLI)
      INTEGER      NTOT(NUMCLI)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='8B  '
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT8B')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDT8B--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMALP
   52   FORMAT('IBUGA3,ISUBRO,NUMALP = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,NUMALP
          WRITE(ICOUT,57)I,ALOWPA(I),AUPPPA(I)
   57     FORMAT('I,ALOWSC(I),AUPPSC(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
      ITITLE(1:44)='Percentile Confidence Interval for Statistic'
      NCTITL=44
      NUMLIN=2
      NUMCOL=3
      ITITL2(1,1)='Confidence'
      ITITL2(2,1)='Coefficient'
      NCTIT2(1,1)=10
      NCTIT2(2,1)=11
      ITITL2(1,2)='Lower'
      ITITL2(2,2)='Limit'
      NCTIT2(1,2)=5
      NCTIT2(2,2)=5
      ITITL2(1,3)='Upper'
      ITITL2(2,3)='Limit'
      NCTIT2(1,3)=5
      NCTIT2(2,3)=5
C
      NMAX=0
      DO2521I=1,NUMCLI
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(I.EQ.1)NTOT(1)=12
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 2521 CONTINUE
      IDIGIT(1)=2
      DO2523I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWPA(I)
        AMAT(I,3)=AUPPPA(I)
 2523 CONTINUE
      IWHTML(1)=150
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+2000
      IWRTF(3)=IWRTF(2)+2000
C
      ITITL9=' '
      NCTIT9=0
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA2(ITITLE,NCTITL,
     1            ITITL9,NCTIT9,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT8B')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDT8B--')
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDT8C(ALOWPA,AUPPPA,ALPHA,NUMALP,
     1                  ICAPSW,ICAPTY,NUMDIG,IPAR,NCPAR,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--PRINT A PERCENTILE CONFIDENCE LIMIT BASED ON THE
C              BOOTSTRAP SAMPLES.  THIS HANDLES THE CASE WHEN WE
C              ARE A BOOTSTRAPPING A DISTRIBUTIONAL MODEL.  A DIFFERENT
C              ROUTINE HANDLES THE CASE WHEN WE ARE BOOTSTRAPPING A
C              STATISTIC.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/07
C     ORIGINAL VERSION--JULY      2010.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*(*) IPAR
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION ALPHA(*)
      DIMENSION ALOWPA(*)
      DIMENSION AUPPPA(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=10)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      INTEGER      NCTEXT(MAXROW)
C
      PARAMETER(NUMCLI=3)
      PARAMETER(MAXLIN=2)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      IWHTML(NUMCLI+1)
      INTEGER      IWRTF(NUMCLI)
      INTEGER      IDIGIT(NUMCLI)
      INTEGER      NTOT(NUMCLI)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='8C  '
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT8C')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDT8C--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMALP
   52   FORMAT('IBUGA3,ISUBRO,NUMALP = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,NUMALP
          WRITE(ICOUT,57)I,ALOWPA(I),AUPPPA(I)
   57     FORMAT('I,ALOWSC(I),AUPPSC(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
      ITITLE(1:35)='Percentile Confidence Interval for '
      NSTRT=36
      NCTITL=NSTRT+NCPAR-1
      ITITLE(NSTRT:NCTITL)=IPAR(1:NCPAR)
C
      NUMLIN=2
      NUMCOL=3
      ITITL2(1,1)='Confidence'
      ITITL2(2,1)='Coefficient'
      NCTIT2(1,1)=10
      NCTIT2(2,1)=11
      ITITL2(1,2)='Lower'
      ITITL2(2,2)='Limit'
      NCTIT2(1,2)=5
      NCTIT2(2,2)=5
      ITITL2(1,3)='Upper'
      ITITL2(2,3)='Limit'
      NCTIT2(1,3)=5
      NCTIT2(2,3)=5
C
      NMAX=0
      DO2521I=1,NUMCLI
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(I.EQ.1)NTOT(I)=12
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 2521 CONTINUE
      IDIGIT(1)=2
      DO2523I=1,NUMALP
        NCTEXT(I)=0
        ITEXT(I)=' '
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWPA(I)
        AMAT(I,3)=AUPPPA(I)
 2523 CONTINUE
      IWHTML(1)=150
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+2000
      IWRTF(3)=IWRTF(2)+2000
C
      ITITL9=' '
      NCTIT9=0
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA2(ITITLE,NCTITL,
     1            ITITL9,NCTIT9,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT8C')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDT8C--')
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDT8D(ALOWSC,AUPPSC,ALOWS2,AUPPS2,
     1                  ALOWMU,AUPPMU,ALOWM2,AUPPM2,
     1                  ALOWSH,AUPPSH,ALOSH2,AUPSH2,ALPHA,NUMALP,
     1                  ICAPSW,ICAPTY,NUMDIG,ILIKFL,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS IS A VARIANT OF "DPDTA8" USED FOR THE CENSORED
C              2-PARAMETER LOGNORMAL CASE.  THIS SUBROUTINE PRINTS
C              THE CONFIDENCE INTERVAL TABLES FOR BOTH THE SCALE AND
C              THE SHAPE PARAMETERS.  FOR THE SCALE, WE ALSO GENERATE
C              THE CONFIDENCE INTERVAL FOR MU (=LOG(SCALE)) USING BOTH
C              THE NORMAL APPROXIMATION AND THE LIKELIHOOD RATIO METHOD.
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/07
C     ORIGINAL VERSION--JULY      2010.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 ILIKFL
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION ALPHA(*)
      DIMENSION ALOWSC(*)
      DIMENSION AUPPSC(*)
      DIMENSION ALOWS2(*)
      DIMENSION AUPPS2(*)
      DIMENSION ALOWMU(*)
      DIMENSION AUPPMU(*)
      DIMENSION ALOWM2(*)
      DIMENSION AUPPM2(*)
      DIMENSION ALOWSH(*)
      DIMENSION AUPPSH(*)
      DIMENSION ALOSH2(*)
      DIMENSION AUPSH2(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=10)
      CHARACTER*60 ITITLE
      CHARACTER*40 ITITL9
      CHARACTER*40 ITEXT(NUMALP)
      INTEGER      NCTEXT(MAXROW)
C
      PARAMETER(NUMCLI=5)
      PARAMETER(MAXLIN=3)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      IWHTML(NUMCLI+1)
      INTEGER      IWRTF(NUMCLI)
      INTEGER      IDIGIT(NUMCLI)
      INTEGER      NTOT(NUMCLI)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='A8  '
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT8D')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDT8D--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMALP
   52   FORMAT('IBUGA3,ISUBRO,NUMALP = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,NUMALP
          WRITE(ICOUT,57)I,ALOWSC(I),AUPPSC(I),ALOWS2(I),AUPPS2(I)
   57     FORMAT('I,ALOWSC(I),AUPPSC(I),ALOWSH(I),AUPPSH(I) = ',
     1            I8,4G15.7)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,58)I,ALOWMU(I),AUPPMU(I),ALOWM2(I),AUPPM2(I)
   58     FORMAT('I,ALOWMU(I),AUPPMU(I),ALOWM2(I),AUPPM2(I) = ',
     1            I8,4G15.7)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,59)I,ALOWSH(I),AUPPSH(I),ALOSH2(I),AUPSH2(I)
   59     FORMAT('I,ALOWSH(I),AUPPSH(I),ALOSH2(I),AUPSH2(I) = ',
     1           I8,4G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
      ITITLE(1:39)='Confidence Interval for Scale Parameter'
      NCTITL=39
      ITITL9(1:20)='Normal Approximation'
      NCTIT9=20
      NUMLIN=3
      NUMCOL=5
      ITITL2(1,1)=' '
      ITITL2(2,1)='Confidence'
      ITITL2(3,1)='Coefficient'
      NCTIT2(1,1)=0
      NCTIT2(2,1)=10
      NCTIT2(3,1)=11
      ITITL2(1,2)='Scale'
      ITITL2(2,2)='Lower'
      ITITL2(3,2)='Limit'
      NCTIT2(1,2)=5
      NCTIT2(2,2)=5
      NCTIT2(3,2)=5
      ITITL2(1,3)='Parameter'
      ITITL2(2,3)='Upper'
      ITITL2(3,3)='Limit'
      NCTIT2(1,3)=9
      NCTIT2(2,3)=5
      NCTIT2(3,3)=5
      ITITL2(1,4)='MU'
      ITITL2(2,4)='Lower'
      ITITL2(3,4)='Limit'
      NCTIT2(1,4)=2
      NCTIT2(2,4)=5
      NCTIT2(3,4)=5
      ITITL2(1,5)='Parameter'
      ITITL2(2,5)='Upper'
      ITITL2(3,5)='Limit'
      NCTIT2(1,5)=9
      NCTIT2(2,5)=5
      NCTIT2(3,5)=5
C
      NMAX=0
      DO2521I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(I.EQ.1)NTOT(I)=12
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 2521 CONTINUE
      IDIGIT(1)=2
      DO2523I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWSC(I)
        AMAT(I,3)=AUPPSC(I)
        AMAT(I,4)=ALOWMU(I)
        AMAT(I,5)=AUPPMU(I)
 2523 CONTINUE
      IWHTML(1)=150
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWHTML(5)=150
      IWHTML(6)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+2000
      IWRTF(3)=IWRTF(2)+2000
      IWRTF(4)=IWRTF(3)+2000
      IWRTF(5)=IWRTF(4)+2000
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA2(ITITLE,NCTITL,
     1            ITITL9,NCTIT9,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ITITL9(1:20)='Likelihood Ratio'
      NCTIT9=16
      DO2533I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWS2(I)
        AMAT(I,3)=AUPPS2(I)
        AMAT(I,4)=ALOWM2(I)
        AMAT(I,5)=AUPPM2(I)
 2533 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      CALL DPDTA2(ITITLE,NCTITL,
     1            ITITL9,NCTIT9,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ITITLE(1:39)='Confidence Interval for Shape Parameter'
      NCTITL=39
      ITITL9=' '
      NCTIT9=0
C
      ITITL2(1,2)='Normal'
      ITITL2(2,2)='Lower'
      ITITL2(3,2)='Limit'
      NCTIT2(1,2)=6
      NCTIT2(2,2)=5
      NCTIT2(3,2)=5
      ITITL2(1,3)='Approximation'
      ITITL2(2,3)='Upper'
      ITITL2(3,3)='Limit'
      NCTIT2(1,3)=13
      NCTIT2(2,3)=5
      NCTIT2(3,3)=5
      ITITL2(1,4)='Likelihood Ratio'
      ITITL2(2,4)='Lower'
      ITITL2(3,4)='Limit'
      NCTIT2(1,4)=16
      NCTIT2(2,4)=5
      NCTIT2(3,4)=5
      ITITL2(1,5)='Approximation'
      ITITL2(2,5)='Upper'
      ITITL2(3,5)='Limit'
      NCTIT2(1,5)=13
      NCTIT2(2,5)=5
      NCTIT2(3,5)=5
      IF(ILIKFL.EQ.'OFF')NUMCOL=3
C
      NMAX=0
      DO2541I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(I.EQ.1)NTOT(I)=12
        IF(I.EQ.4)NTOT(I)=18
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 2541 CONTINUE
      IDIGIT(1)=2
C
      DO2543I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWSH(I)
        AMAT(I,3)=AUPPSH(I)
        AMAT(I,4)=ALOSH2(I)
        AMAT(I,5)=AUPSH2(I)
 2543 CONTINUE
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      CALL DPDTA2(ITITLE,NCTITL,
     1            ITITL9,NCTIT9,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT8D')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDT8D--')
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1                  ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--FOR MAXIMUM LIKELIHOOD FOR DISTRIBUTIONS, PRINT
C              THE QUANTILE CONFIDENCE INTERVAL TABLE.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/02
C     ORIGINAL VERSION--FEBRUARY  2010 EXTRACT AS DISTINCT SUBROUTINE
C     UPDATED         --JUNE      2010 ADD ILIKFL TO SPECIFY WHEHTER
C                                      BASED ON NORMAL APPROXIMAITON
C                                      OR LIKELIHOOD RATIO
C     UPDATED         --JUNE      2010 2-PAR EXPONENTIAL ONLY DOES
C                                      LOWER LIMIT.  CHECK TO SEE
C                                      IF UPPER LIMIT SET TO CPUMIN
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 ILIKFL
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      LOGICAL IFLAGU
C
C---------------------------------------------------------------------
C
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPSE(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
C
      PARAMETER(NUMCLI=5)
      PARAMETER(MAXLIN=3)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      IWHTML(MAXROW)
      INTEGER      IWRTF(MAXROW)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='A9  '
      IERROR='NO'
      IFLAGU=.TRUE.
      IF(XQPUCL(1).EQ.CPUMIN)IFLAGU=.FALSE.
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTA9')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDTA9--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NPERC,NUMDIG
   52   FORMAT('IBUGA3,ISUBRO,NPERC,NUMDIT = ',A4,2X,A4,2X,2I5)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,NPERC
          WRITE(ICOUT,57)I,QP(I),XQPHAT(I),XQPLCL(I),XQPUCL(I),XQPSE(I)
   57     FORMAT('I,QP(I),XQPHAT(I),XQPLCL(I),XQPUCL(I),XQPSE(I) = ',
     1           I8,5G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
      IF(NPERC.GT.1)THEN
C
        ITITL9(1:44)='Confidence Intervals for Select Percentiles '
        ITITL9(45:59)='(alpha =      )'
        WRITE(ITITL9(54:58),'(F5.3)')ALPHAP
        NCTIT9=59
        IF(ILIKFL.EQ.'ON')THEN
          ITITLE='(Based on Likelihood Ratio)'
          NCTITL=27
        ELSEIF(ILIKFL.EQ.'EXAC')THEN
          ITITLE=' '
          NCTITL=0
        ELSEIF(ILIKFL.EQ.'PARE')THEN
          ITITLE='(Based on Astrabadi Approximation)'
          NCTITL=34
        ELSE
          ITITLE='(Based on Normal Approximation)'
          NCTITL=31
        ENDIF
        NUMLIN=2
        IF(XQPSE(1).NE.CPUMIN)THEN
          NUMCOL=5
          IFLAGS=1
        ELSE
          NUMCOL=4
          IFLAGS=0
        ENDIF
        IF(.NOT.IFLAGU)NUMCOL=NUMCOL-1
        ITITL2(1,1)=' '
        ITITL2(2,1)='Percentile'
        ITITL2(1,2)='Point'
        ITITL2(2,2)='Estimate'
        NCTIT2(1,1)=0
        NCTIT2(2,1)=10
        NCTIT2(1,2)=5
        NCTIT2(2,2)=8
C
        ICNT2=2
        IF(IFLAGS.EQ.1)THEN
          ICNT2=ICNT2+1
          ITITL2(1,ICNT2)='Standard'
          ITITL2(2,ICNT2)='Error'
          NCTIT2(1,ICNT2)=8
          NCTIT2(2,ICNT2)=5
        ENDIF
C
        ICNT2=ICNT2+1
        ITITL2(1,ICNT2)='Lower'
        ITITL2(2,ICNT2)='Limit'
        NCTIT2(1,ICNT2)=5
        NCTIT2(2,ICNT2)=5
        ICNT2=ICNT2+1
        ITITL2(1,ICNT2)='Upper'
        ITITL2(2,ICNT2)='Limit'
        NCTIT2(1,ICNT2)=5
        NCTIT2(2,ICNT2)=5
C
        NMAX=0
        DO2621I=1,NUMCOL
          VALIGN(I)='b'
          ALIGN(I)='r'
          NTOT(I)=15
          NMAX=NMAX+NTOT(I)
          IDIGIT(I)=NUMDIG
 2621   CONTINUE
        IDIGIT(1)=3
        DO2623I=1,NPERC
          NCTEXT(I)=0
          AMAT(I,1)=QP(I)
          AMAT(I,2)=XQPHAT(I)
          ICNT2=2
          IF(IFLAGS.EQ.1)THEN
            ICNT2=ICNT2+1
            AMAT(I,ICNT2)=XQPSE(I)
          ENDIF
          ICNT2=ICNT2+1
          AMAT(I,ICNT2)=XQPLCL(I)
          ICNT2=ICNT2+1
          AMAT(I,ICNT2)=XQPUCL(I)
 2623   CONTINUE
        IWHTML(1)=150
        IWHTML(2)=150
        IWHTML(3)=150
        IWHTML(4)=150
        IWHTML(5)=150
        IWHTML(6)=150
        AINC=2000
        IF(IFLAGS.EQ.1)AINC=1800
        IWRTF(1)=AINC
        IWRTF(2)=IWRTF(1)+AINC
        IWRTF(3)=IWRTF(2)+AINC
        IWRTF(4)=IWRTF(3)+AINC
        IWRTF(4)=IWRTF(4)+AINC
        IFRST=.TRUE.
        ILAST=.TRUE.
C
        CALL DPDTA2(ITITL9,NCTIT9,
     1              ITITLE,NCTITL,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              ITEXT,NCTEXT,AMAT,MAXROW,NPERC,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTA9')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDTA9--')
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDT9B(QP,XQPHAT,XQPLCL,XQPUCL,NPERC,
     1                  ICAPSW,ICAPTY,NUMDIG,ALPHAP,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--FOR BOOTSTRAP DISTRIBUTIONAL MODELING, PRINT THE
C              QUANTILE CONFIDENCE INTERVAL TABLE.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/07
C     ORIGINAL VERSION--JULY      2010
C     UPDATED         --AUGUST    2011 SUPPORT FOR ONE-SIDED INTERVALS
C                                      (NOTE THESE ARE EQUIVALENT TO
C                                      ONE-SIDED TOLERANCE INTERVALS)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ICASE
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
C
      PARAMETER(NUMCLI=4)
      PARAMETER(MAXLIN=3)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      IWHTML(MAXROW)
      INTEGER      IWRTF(MAXROW)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='9B  '
      IERROR='NO'
      ICASE='TWOS'
      IF(XQPLCL(1).EQ.CPUMIN)THEN
        ICASE='UPPE'
      ELSEIF(XQPUCL(1).EQ.CPUMIN)THEN
        ICASE='LOWE'
      ENDIF
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT9B')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDT9B--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,ICASE,NPERC,NUMDIG
   52   FORMAT('IBUGA3,ISUBRO,ICASE,NPERC,NUMDIG = ',3(A4,2X),2I5)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,NPERC
          WRITE(ICOUT,57)I,QP(I),XQPHAT(I),XQPLCL(I),XQPUCL(I)
   57     FORMAT('I,QP(I),XQPHAT(I),XQPLCL(I),XQPUCL(I) = ',
     1           I8,4G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
      IF(NPERC.GT.1)THEN
C
        ITITL9(1:44)='Confidence Intervals for Select Percentiles '
        ITITL9(45:59)='(alpha =      )'
        WRITE(ITITL9(54:58),'(F5.3)')ALPHAP
        NCTIT9=59
        ITITLE='(Based on Bootstrap Samples)'
        NCTITL=28
        NUMLIN=3
        NUMCOL=4
        IF(ICASE.EQ.'LOWE')NUMCOL=3
        IF(ICASE.EQ.'UPPE')NUMCOL=3
        ITITL2(1,1)=' '
        ITITL2(2,1)=' '
        ITITL2(3,1)='Percentile'
        NCTIT2(1,1)=0
        NCTIT2(2,1)=0
        NCTIT2(3,1)=10
        ITITL2(1,2)='Median'
        ITITL2(2,2)='Point'
        ITITL2(3,2)='Estimate'
        NCTIT2(1,2)=6
        NCTIT2(2,2)=5
        NCTIT2(3,2)=8
        IF(ICASE.EQ.'TWOS')THEN
          ITITL2(1,3)=' '
          ITITL2(2,3)='Lower'
          ITITL2(3,3)='Limit'
          NCTIT2(1,3)=0
          NCTIT2(2,3)=5
          NCTIT2(3,3)=5
          ITITL2(1,4)=' '
          ITITL2(2,4)='Upper'
          ITITL2(3,4)='Limit'
          NCTIT2(1,4)=0
          NCTIT2(2,4)=5
          NCTIT2(3,4)=5
        ELSEIF(ICASE.EQ.'LOWE')THEN
          ITITL2(1,3)=' '
          ITITL2(2,3)='Lower'
          ITITL2(3,3)='Limit'
          NCTIT2(1,3)=0
          NCTIT2(2,3)=5
          NCTIT2(3,3)=5
        ELSEIF(ICASE.EQ.'UPPE')THEN
          ITITL2(1,3)=' '
          ITITL2(2,3)='Upper'
          ITITL2(3,3)='Limit'
          NCTIT2(1,3)=0
          NCTIT2(2,3)=5
          NCTIT2(3,3)=5
        ENDIF
        NMAX=0
        DO2621I=1,NUMCOL
          VALIGN(I)='b'
          ALIGN(I)='r'
          NTOT(I)=15
          NMAX=NMAX+NTOT(I)
          IDIGIT(I)=NUMDIG
 2621   CONTINUE
        IDIGIT(1)=3
        DO2623I=1,NPERC
          NCTEXT(I)=0
          AMAT(I,1)=100.0*QP(I)
          AMAT(I,2)=XQPHAT(I)
          IF(ICASE.EQ.'TWOS')THEN
            AMAT(I,3)=XQPLCL(I)
            AMAT(I,4)=XQPUCL(I)
          ELSEIF(ICASE.EQ.'LOWE')THEN
            AMAT(I,3)=XQPLCL(I)
          ELSEIF(ICASE.EQ.'UPPE')THEN
            AMAT(I,3)=XQPUCL(I)
          ENDIF
 2623   CONTINUE
        IWHTML(1)=150
        IWHTML(2)=150
        IWHTML(3)=150
        IWHTML(4)=150
        IWHTML(5)=150
        IWRTF(1)=2000
        IWRTF(2)=IWRTF(1)+2000
        IWRTF(3)=IWRTF(2)+2000
        IWRTF(4)=IWRTF(3)+2000
        IFRST=.TRUE.
        ILAST=.TRUE.
C
        CALL DPDTA2(ITITL9,NCTIT9,
     1              ITITLE,NCTITL,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              ITEXT,NCTEXT,AMAT,MAXROW,NPERC,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT9B')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDT9B--')
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDTAP(R,NRET,
     1                  ALOC,ASCALE,ALAMB,DG,XR,
     1                  ICAPSW,ICAPTY,NUMDIG,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--GENERATE THE MEAN RECURRENCE INTERVAL TABLE FOR
C              THE PEAKS OVER THRESHOLD PLOT.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/07
C     ORIGINAL VERSION--JULY      2010. EXTRACTED AS A DISTINCT
C                                       SUBROUTINE FROM DPPOT2
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      DOUBLE PRECISION DG
      DOUBLE PRECISION DXR
C
C---------------------------------------------------------------------
C
      DIMENSION R(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=30)
      CHARACTER*1 ITITLE
      CHARACTER*1 ITITLZ
      CHARACTER*1 ITEXT(MAXROW)
C
      PARAMETER(NUMCLI=2)
      PARAMETER(MAXLIN=2)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      IWHTML(NUMCLI+1)
      INTEGER      IWRTF(NUMCLI)
      INTEGER      IDIGIT(NUMCLI)
      INTEGER      NTOT(NUMCLI)
      INTEGER      NCTEXT(MAXROW)
      REAL         AMAT(MAXROW,NUMCLI)
      CHARACTER*4 ALIGN(NUMCLI)
      CHARACTER*4 VALIGN(NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='AP  '
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTAP')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDTAP--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NRET
   52   FORMAT('IBUGA3,ISUBRO,NRET = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,53)ALOC,ASCALE,DG,XR,ALAMB
   53   FORMAT('ALOC,ASCALE,DG,XR,ALAMB = ',5G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,NRET
          WRITE(ICOUT,57)I,R(I)
   57     FORMAT('I,R(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
      NUMLIN=2
      NUMCOL=2
      ITITL2(1,1)='Mean Recurrence'
      ITITL2(2,1)='Interval (R)'
      NCTIT2(1,1)=15
      NCTIT2(2,1)=12
      ITITL2(1,2)=' '
      ITITL2(2,2)='XR'
      NCTIT2(1,2)=0
      NCTIT2(2,2)=2
C
      NMAX=0
      DO2521I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 2521 CONTINUE
      IDIGIT(1)=2
      DO2523I=1,NRET
        NCTEXT(I)=0
        AMAT(I,1)=R(I)
        DXR=DBLE(ALOC) - DBLE(ASCALE)*
     1      (1.0D0 - (DBLE(ALAMB*R(I)))**DG)/DG
        XR=REAL(DXR)
        AMAT(I,2)=REAL(DXR)
 2523 CONTINUE
      IWHTML(1)=200
      IWHTML(2)=200
      IWHTML(3)=200
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+2000
C
      ITITLE=' '
      NCTITL=0
      ITITLZ=' '
      NCTITZ=0
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA2(ITITLE,NCTITL,
     1            ITITLZ,NCTITZ,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NRET,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTAP')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDTAP--')
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDT11(CONF,T,TSDM,ALOWER,AUPPER,
     1                  ICASAN,ICAPSW,ICAPTY,NUMDIG,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE PRINTS THE CONFIDENCE INTERVAL TABLES
C              FOR THE FOLLOWING COMMANDS:
C
C                 1) CONFIDENCE LIMITS FOR THE MEAN
C                 2) CONFIDENCE LIMITS FOR THE DIFFERENCE OF THE MEANS
C                 3) CONFIDENCE LIMITS FOR BIWEIGHT LOCATION
C                 4) CONFIDENCE LIMITS FOR TRIMMED MEAN
C                 5) CONFIDENCE LIMITS FOR MEDIAN/QUANTILES
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/03
C     ORIGINAL VERSION--MARCH     2010. EXTRACTED AS DISTINCT SUBROUTINE
C     UPDATED         --JUNE      2012. SUPPORT FOR CORRELATION COEFFICIENT
C     UPDATED         --APRIL     2013. SUPPORT FOR LOWER/UPPER
C                                       INTERVALS
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASAN
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 ICASA2
C
C---------------------------------------------------------------------
C
      DIMENSION CONF(*)
      DIMENSION T(*)
      DIMENSION TSDM(*)
      DIMENSION ALOWER(*)
      DIMENSION AUPPER(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXCNF=8)
      PARAMETER (MAXROW=10)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITL9
      CHARACTER*4  ALIGN(MAXCNF)
      CHARACTER*4  VALIGN(MAXCNF)
      REAL         AVALUE(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
C
      PARAMETER(NUMCLI=5)
      PARAMETER(MAXLIN=2)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      CHARACTER*15 IVALUE(MAXROW,NUMCLI)
      CHARACTER*4  ITYPCO(NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      NCVALU(MAXROW,NUMCLI)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
C
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='11  '
      IERROR='NO'
C
      ICASA2='TWOS'
      IF(ALOWER(1).EQ.CPUMIN)ICASA2='UPPE'
      IF(AUPPER(1).EQ.CPUMIN)ICASA2='LOWE'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT11')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDT11--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,ICASA2,NCONF
   52   FORMAT('IBUGA3,ISUBRO,ICASA2,NCONF = ',3(A4,2X),I5)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,NCONF
          WRITE(ICOUT,57)I,CONF(I),T(I),TSDM(I),ALOWER(I),AUPPER(I)
   57     FORMAT('I,CONF(I),T(I),TSDM(I),ALOWER(I),AUPPER(I) = ',
     1           I8,5G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
      ITITLE=' '
      NCTITL=0
      ITITL9=' '
      NCTIT9=0
      NUMLIN=2
      NUMROW=8
      NUMCOL=5
C
      IF(ICASAN.EQ.'QUC2')THEN
        ITITL9='Hettmansperger-Sheater Median Confidence Limits'
        NCTIT9=47
        NUMCOL=3
      ELSEIF(ICASAN.EQ.'CORR')THEN
        NUMCOL=4
        NUMROW=7
      ENDIF
      IF(ICASA2.EQ.'LOWE' .OR. ICASA2.EQ.'UPPE')NUMCOL=NUMCOL-1
C
      ICNT=1
      ITITL2(1,ICNT)='Confidence'
      NCTIT2(1,ICNT)=10
      ITITL2(2,ICNT)='Value (%)'
      NCTIT2(2,ICNT)=9
      IF(ICASAN.EQ.'QUCI' .OR. ICASAN.EQ.'MECI')THEN
        ICNT=ICNT+1
        ITITL2(1,ICNT)='Z'
        NCTIT2(1,ICNT)=1
        ITITL2(2,ICNT)='Value'
        NCTIT2(2,ICNT)=5
        ICNT=ICNT+1
        ITITL2(1,ICNT)='Z-Value X'
        NCTIT2(1,ICNT)=9
        ITITL2(2,ICNT)='StdErr'
        NCTIT2(2,ICNT)=6
      ELSEIF(ICASAN.EQ.'CONF' .OR. ICASAN.EQ.'BWCO' .OR.
     1       ICASAN.EQ.'TMCO' .OR. ICASAN.EQ.'CON2')THEN
        ICNT=ICNT+1
        ITITL2(1,ICNT)='t'
        NCTIT2(1,ICNT)=1
        ITITL2(2,ICNT)='Value'
        NCTIT2(2,ICNT)=5
        ICNT=ICNT+1
        ITITL2(1,ICNT)='t-Value X'
        NCTIT2(1,ICNT)=9
        IF(ICASAN.EQ.'CONF')THEN
          ITITL2(2,ICNT)='SD(Mean)'
          NCTIT2(2,ICNT)=8
        ELSE
          ITITL2(2,3)='StdErr'
          NCTIT2(2,3)=6
        ENDIF
      ELSEIF(ICASAN.EQ.'CORR')THEN
        ICNT=ICNT+1
        ITITL2(1,ICNT)='Normal'
        NCTIT2(1,ICNT)=6
        ITITL2(2,ICNT)='Value'
        NCTIT2(2,ICNT)=5
      ENDIF
      IF(ICASA2.EQ.'TWOS' .OR. ICASA2.EQ.'LOWE')THEN
        ICNT=ICNT+1
        ITITL2(1,ICNT)='Lower'
        NCTIT2(1,ICNT)=5
        ITITL2(2,ICNT)='Limit'
        NCTIT2(2,ICNT)=5
      ENDIF
      IF(ICASA2.EQ.'TWOS' .OR. ICASA2.EQ.'UPPE')THEN
        ICNT=ICNT+1
        ITITL2(1,ICNT)='Upper'
        NCTIT2(1,ICNT)=5
        ITITL2(2,ICNT)='Limit'
        NCTIT2(2,ICNT)=5
      ENDIF
C
      NMAX=0
      DO4221I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IDIGIT(I)=NUMDIG
        ITYPCO(I)='NUME'
        IWHTML(I)=150
        IF(I.EQ.1)THEN
          NTOT(I)=12
          IDIGIT(I)=3
          IWHTML(1)=75
        ELSEIF(I.EQ.2)THEN
          NTOT(I)=8
          IDIGIT(I)=3
          IWHTML(I)=75
        ENDIF
        NMAX=NMAX+NTOT(I)
 4221 CONTINUE
      DO4223I=1,NUMROW
        DO4225J=1,NUMCOL
          NCVALU(I,J)=0
          IVALUE(I,J)=' '
          AMAT(I,J)=0.0
 4225   CONTINUE
        JCNT=1
        AMAT(I,JCNT)=CONF(I)
        IF(ICASAN.EQ.'CORR')THEN
          JCNT=JCNT+1
          AMAT(I,JCNT)=T(I)
        ELSEIF(ICASAN.NE.'QUC2')THEN
          JCNT=JCNT+1
          AMAT(I,JCNT)=T(I)
          JCNT=JCNT+1
          AMAT(I,JCNT)=TSDM(I)
        ENDIF
        IF(ICASA2.EQ.'TWOS' .OR. ICASA2.EQ.'LOWE')THEN
          JCNT=JCNT+1
          AMAT(I,JCNT)=ALOWER(I)
        ENDIF
        IF(ICASA2.EQ.'TWOS' .OR. ICASA2.EQ.'UPPE')THEN
          JCNT=JCNT+1
          AMAT(I,JCNT)=AUPPER(I)
        ENDIF
 4223 CONTINUE
C
      IWRTF(1)=800
      IWRTF(2)=IWRTF(1)+800
      IWRTF(3)=IWRTF(2)+2000
      IWRTF(4)=IWRTF(2)+2000
      IWRTF(5)=IWRTF(2)+2000
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      ISTEPN='5C'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CNF2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDTA4(ITITL9,NCTIT9,
     1            ITITLE,NCTITL,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,NUMROW,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DT11')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDT11--')
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDTLA(ISTRIN,NCIN,NCT,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--UTILITY ROUTINE USED BY THE TABLE PRINTING ROUTINES
C              (DPDTA1, DPDTA2, DPDTA4, DPDTA5, DPDT5B).  FOR LATEX
C              OUTPUT, IT CHECKS FOR CERTAIN CHARACTERS AND ADDS
C              APPROPRIATE ESCAPE SEQUENCES.  CURRENTLY, THE
C              CHARACTERS CHECKED ARE:
C
C                 1) %
C                 2) <
C                 3) >
C                 4) !
C                 5) *
C
C              ISTRIN     => INPUT STRING, MAY BE MODIFIED ON OUTPUT
C              NCIN       => NUMBER OF CHARACTERS FOR ISTRIN
C              NCT        => NUMBER OF CHARACTERS ON OUTPUT
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2011/1
C     ORIGINAL VERSION--JANUARY   2011.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*(*) ISTRIN
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*1 IBASLC
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTLA')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDTLA--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,53)NCIN,ISTRIN(1:NCIN)
   53   FORMAT('NCIN,ISTRIN = ',I8,2X,A)
      ENDIF
C
C     FOR LATEX, NEED TO CHECK FOR ANY CHARACTERS THAT
C     NEED TO BE "ESCAPED".
C
C     CHECK FOR <= OR >= AND CONVERT TO LATEX
C     FORMAT (\le or \ge)
C
      CALL DPCONA(92,IBASLC)
      NCT=NCIN
      DO1010II=NCIN,1,-1
        IF(ISTRIN(II:II).EQ.'%')THEN
          DO1020J=NCT,II,-1
            ISTRIN(J+1:J+1)=ISTRIN(J:J)
 1020     CONTINUE
          NCT=NCT+1
          ISTRIN(II:II)=IBASLC
        ELSEIF(ISTRIN(II:II).EQ.'|' .OR.
     1         ISTRIN(II:II).EQ.'*')THEN
          DO1030J=NCT,II+1,-1
            ISTRIN(J+2:J+2)=ISTRIN(J:J)
 1030     CONTINUE
          ISTRIN(II+1:II+1)=ISTRIN(II:II)
          NCT=NCT+2
          ISTRIN(II:II)='$'
          ISTRIN(II+2:II+2)='$'
        ELSEIF(ISTRIN(II:II).EQ.'<' .OR.
     1         ISTRIN(II:II).EQ.'>')THEN
          IF(ISTRIN(II+1:II+1).EQ.'=')THEN
            DO1040J=NCT,II+2,-1
              ISTRIN(J+4:J+4)=ISTRIN(J:J)
 1040       CONTINUE
            IF(ISTRIN(II:II).EQ.'<')THEN
              ISTRIN(II:II+5)='$ le$ '
              ISTRIN(II+1:II+1)=IBASLC
            ELSEIF(ISTRIN(II:II).EQ.'>')THEN
              ISTRIN(II:II+5)='$ ge$ '
              ISTRIN(II+1:II+1)=IBASLC
            ENDIF
            NCT=NCT+4
          ELSE
            DO1050J=NCT,II+1,-1
              ISTRIN(J+2:J+2)=ISTRIN(J:J)
 1050       CONTINUE
            ISTRIN(II+1:II+1)=ISTRIN(II:II)
            NCT=NCT+2
            ISTRIN(II:II)='$'
            ISTRIN(II+2:II+2)='$'
          ENDIF
        ENDIF
 1010 CONTINUE
C
 9000 CONTINUE
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTLA')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9051)
 9051   FORMAT('**** AT THE END OF DPDTLA--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9053)NCT,ISTRIN(1:NCT)
 9053   FORMAT('NCT,ISTRIN = ',I8,2X,A)
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDTRT(ISTRIN,NCIN,NCT,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--UTILITY ROUTINE USED BY THE TABLE PRINTING ROUTINES
C              (DPDTA1, DPDTA2, DPDTA4, DPDTA5, DPDT5B).  FOR RTF
C              OUTPUT, IT CHECKS FOR CERTAIN CHARACTERS AND ADDS
C              APPROPRIATE ESCAPE SEQUENCES.  CURRENTLY, THE
C              CHARACTERS CHECKED ARE:
C
C                 1) |
C
C              ISTRIN     => INPUT STRING, MAY BE MODIFIED ON OUTPUT
C              NCIN       => NUMBER OF CHARACTERS FOR ISTRIN
C              NCT        => NUMBER OF CHARACTERS ON OUTPUT
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2011/1
C     ORIGINAL VERSION--JANUARY   2011.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*(*) ISTRIN
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*1 IBASLC
      CHARACTER*1 IQUOTE
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTRT')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDTRT--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,53)NCIN,ISTRIN(1:NCIN)
   53   FORMAT('NCIN,ISTRIN = ',I8,2X,A)
      ENDIF
C
C     FOR RTF, NEED TO CHECK FOR ANY CHARACTERS THAT
C     NEED TO BE "ESCAPED".
C
C     CURRENTLY, REPLACE "|" WITH "\'7C" (7C IS THE HEXADECIMAL
C     REPRESENTATION FOR A VERTICAL LINE).
C
      CALL DPCONA(92,IBASLC)
      CALL DPCONA(39,IQUOTE)
      NCT=NCIN
      DO1010II=NCIN,1,-1
        IF(ISTRIN(II:II).EQ.'|')THEN
          DO1030J=NCT,II+1,-1
            ISTRIN(J+3:J+3)=ISTRIN(J:J)
 1030     CONTINUE
          NCT=NCT+3
          ISTRIN(II:II)=IBASLC
          ISTRIN(II+1:II+1)=IQUOTE
          ISTRIN(II+2:II+3)='7C'
        ENDIF
 1010 CONTINUE
C
 9000 CONTINUE
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTRT')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9051)
 9051   FORMAT('**** AT THE END OF DPDTRT--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9053)NCT,ISTRIN(1:NCT)
 9053   FORMAT('NCT,ISTRIN = ',I8,2X,A)
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDTXT(ITEXT,NCTEXT,AVALUE,IDIGIT,
     1                  NTOTAL,NBLNK1,NBLNK2,IFLAG1,IFLAG2,ISIZE,
     1                  ICAPSW,ICAPTY,ITYPE,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE PRINTS A TEXT LINE IN HTML/LATEX/RTF/ASCII
C              FORMATS.
C
C              THIS IS USED TO PRINT INDIVIDUAL TEXT LINES (E.G.,
C              A HEADER LINE OR SOME LINES OF TEXT AFTER A TABLE).
C
C              FOR MULTI-LINE CASE, SPECIFY IFLAG1 = TRUE IF FIRST LINE
C              IFLAG2 = TRUE IF LAST LINE.
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2012/1
C     ORIGINAL VERSION--JANUARY   2012.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*(*) ITEXT
      REAL          AVALUE
      INTEGER       IDIGIT
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*20 IFORMT
      CHARACTER*1 IBASLC
C
      LOGICAL IFLAG1
      LOGICAL IFLAG2
      LOGICAL IFLAGA
      LOGICAL IFLAGB
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXHED=50)
      INTEGER IWIDTH(MAXHED)
      INTEGER NUMDIG(MAXHED)
      CHARACTER*8 ALIGN(MAXHED)
      CHARACTER*8 VALIGN(MAXHED)
      COMMON/HTML4/IWIDTH,NUMDIG,ALIGN,VALIGN
      CHARACTER*132 IVALUE(2)
      INTEGER NCTEMP(2)
      REAL    AVAL(2)
C
      INTEGER NTOT2(2)
C
      CHARACTER*132 IHEAD
      CHARACTER*132 ITEMPC
C
      CHARACTER*4 IRTFMD
      COMMON/COMRTF/IRTFMD
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDT'
      ISUBN2='XT  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTXT')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDTXT--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,AVALUE
   52   FORMAT('IBUGA3,ISUBRO,AVALUE = ',2(A4,2X),G15.7)
        CALL DPWRST('XXX','WRIT')
        IF(NCTEXT.GT.0)THEN
          WRITE(ICOUT,57)ITEXT(1:NCTEXT)
   57     FORMAT('ITEXT = ',A80)
          CALL DPWRST('XXX','WRIT')
        ENDIF
      ENDIF
C
C               *******************************************
C               **   STEP 1--                            **
C               **   WRITE OUT THE TITLE AND HEADER LINE **
C               *******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DTXT')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'ON')THEN
C
C       PRELIMINARY CODE IF FIRST LINE
C
        IF(IFLAG1)THEN
          IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
            WRITE(ICOUT,2116)
 2116       FORMAT('</PRE>')
            CALL DPWRST('XXX','WRIT')
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
            IJUNK=92
            CALL DPCONA(IJUNK,IBASLC)
            WRITE(ICOUT,2126)IBASLC
 2126       FORMAT(A1,'end{verbatim}')
            CALL DPWRST('XXX','WRIT')
            IF(ISIZE.EQ.-1)THEN
              WRITE(ICOUT,2127)IBASLC
 2127         FORMAT(A1,'small')
              CALL DPWRST('XXX','WRIT')
            ELSEIF(ISIZE.EQ.-2)THEN
              WRITE(ICOUT,2128)IBASLC
 2128         FORMAT(A1,'tiny')
              CALL DPWRST('XXX','WRIT')
            ELSEIF(ISIZE.EQ.0)THEN
              WRITE(ICOUT,2130)IBASLC
 2130         FORMAT(A1,'normalsize')
              CALL DPWRST('XXX','WRIT')
            ENDIF
            WRITE(ICOUT,2129)IBASLC
 2129       FORMAT(A1,'begin{table}')
            CALL DPWRST('XXX','WRIT')
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF')THEN
          ELSE
          ENDIF
        ENDIF
C
C       CASE 1: A HEADER LINE
C
        IF(ITYPE.EQ.1 .AND. NCTEXT.GT.0)THEN
          IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
            WRITE(ICOUT,1001)
 1001       FORMAT('<CENTER><H2>')
            CALL DPWRST('XXX','WRIT')
            IFORMT=' '
            IFORMT='(A  )'
            WRITE(IFORMT(3:4),'(I2)')NCTEXT
            WRITE(ICOUT,IFORMT)ITEXT(1:NCTEXT)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,1004)
 1004       FORMAT('</H2></CENTER><BR><BR>')
            CALL DPWRST('XXX','WRIT')
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
            IFLAGA=.FALSE.
            IFLAGB=.TRUE.
            CALL DPLAT8(ITEXT,NCTEXT,IFLAGA,IFLAGB)
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF')THEN
            IF(IRTFFP.EQ.'Times New Roman')THEN
              ITEMP=0
            ELSEIF(IRTFFP.EQ.'Lucida Sans')THEN
              ITEMP=6
            ELSEIF(IRTFFP.EQ.'Arial')THEN
              ITEMP=2
            ELSEIF(IRTFFP.EQ.'Bookman')THEN
              ITEMP=3
            ELSEIF(IRTFFP.EQ.'Georgia')THEN
              ITEMP=4
            ELSEIF(IRTFFP.EQ.'Tahoma')THEN
              ITEMP=5
            ELSEIF(IRTFFP.EQ.'Verdana')THEN
              ITEMP=7
            ELSE
              ITEMP=0
            ENDIF 
C
            IRTFMD='OFF'
            IFLAG1=.TRUE.
            CALL DPRTF8(ITEXT,NCTEXT,ITEMP,IFLAG1)
            NHEAD=0
          ELSE
            IF(NBLNK1.GT.0)THEN
              DO1010I=1,NBLNK1
                WRITE(ICOUT,999)
                CALL DPWRST('XXX','WRIT')
 1010         CONTINUE
            ENDIF
            IFORMT=' '
            IFORMT='(6X,A  )'
            WRITE(IFORMT(6:7),'(I2)')NCTEXT
            WRITE(ICOUT,IFORMT)ITEXT(1:NCTEXT)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            IF(NBLNK2.GT.0)THEN
              DO1020I=1,NBLNK2
                WRITE(ICOUT,999)
                CALL DPWRST('XXX','WRIT')
 1020         CONTINUE
            ENDIF
          ENDIF
C
C       CASE 2: SOME TEXT WITH AN OPTIONAL NUMERIC VALUE AT END
C
        ELSEIF(ITYPE.EQ.2 .AND. NCTEXT.GT.0)THEN
          IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
            IF(NBLNK1.GT.0)THEN
              IHEAD=' '
              NCHAR=1
              DO2110I=1,NBLNK1
                CALL DPHTMW(IHEAD,NCHAR,CPUMIN,IDIGIT)
 2110         CONTINUE
            ENDIF
            CALL DPHTMW(ITEXT,NCTEXT,AVALUE,IDIGIT)
            IF(NBLNK2.GT.0)THEN
              IHEAD=' '
              NCHAR=1
              DO2120I=1,NBLNK2
                CALL DPHTMW(IHEAD,NCHAR,CPUMIN,IDIGIT)
 2120         CONTINUE
            ENDIF
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
            IF(NBLNK1.GT.0)THEN
              IHEAD=' '
              NCHAR=1
              DO2210I=1,NBLNK1
                CALL DPLAT7(IHEAD,NCHAR,CPUMIN)
 2210         CONTINUE
            ENDIF
            CALL DPLAT7(ITEXT,NCTEXT,AVALUE)
            IF(NBLNK2.GT.0)THEN
              IHEAD=' '
              NCHAR=1
              DO2220I=1,NBLNK2
                CALL DPLAT7(IHEAD,NCHAR,CPUMIN)
 2220         CONTINUE
            ENDIF
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF')THEN
            IF(NBLNK1.GT.0)THEN
              IHEAD=' '
              NCHAR=1
              DO2310I=1,NBLNK1
                CALL DPRTF7(IHEAD,NCHAR,CPUMIN)
 2310         CONTINUE
            ENDIF
            CALL DPRTF7(ITEXT,NCTEXT,AVALUE)
            IF(NBLNK2.GT.0)THEN
              IHEAD=' '
              NCHAR=1
              DO2320I=1,NBLNK2
                CALL DPRTF7(IHEAD,NCHAR,CPUMIN)
 2320         CONTINUE
            ENDIF
          ELSE
            IF(NBLNK1.GT.0)THEN
              DO2410I=1,NBLNK1
                WRITE(ICOUT,999)
                CALL DPWRST('XXX','WRIT')
 2410         CONTINUE
            ENDIF
C
            IF(AVALUE.EQ.CPUMIN)THEN
              IFORMT=' '
              IFORMT='(A  )'
              WRITE(IFORMT(3:4),'(I2)')NCTEXT
              WRITE(ICOUT,IFORMT)ITEXT(1:NCTEXT)
              CALL DPWRST('XXX','WRIT')
            ELSE
              NBLANK=NTOTAL-NCTEXT
              IF(NBLANK.GT.0)THEN
                IFORMT=' '
                IFORMT='(A  ,  X,G15.7)'
                WRITE(IFORMT(3:4),'(I2)')NCTEXT
                WRITE(IFORMT(6:7),'(I2)')NBLANK
              ELSE
                IFORMT=' '
                IFORMT='(A  ,G15.7)'
                WRITE(IFORMT(3:4),'(I2)')NCTEXT
              ENDIF
              WRITE(ICOUT,IFORMT)ITEXT(1:NCTEXT),AVALUE
              CALL DPWRST('XXX','WRIT')
            ENDIF
C
            IF(NBLNK2.GT.0)THEN
              DO2420I=1,NBLNK2
                WRITE(ICOUT,999)
                CALL DPWRST('XXX','WRIT')
 2420         CONTINUE
            ENDIF
          ENDIF
        ENDIF
C
C       ENDING CODE IF LAST LINE
C
        IF(IFLAG2)THEN
          IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
            WRITE(ICOUT,2516)
 2516       FORMAT('<PRE>')
            CALL DPWRST('XXX','WRIT')
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
            IJUNK=92
            CALL DPCONA(IJUNK,IBASLC)
            WRITE(ICOUT,2518)IBASLC
 2518       FORMAT(A1,'end{table}')
            CALL DPWRST('XXX','WRIT')
C
C           ONLY RESTORE NORMAL SIZE IF THIS NOT A SINGLE LINE
C
            IF(.NOT.IFLAG1)THEN
              IF(ISIZE.EQ.0)THEN
                WRITE(ICOUT,2526)IBASLC
 2526           FORMAT(A1,'normalsize')
                CALL DPWRST('XXX','WRIT')
              ELSEIF(ISIZE.EQ.-1)THEN
                WRITE(ICOUT,2527)IBASLC
 2527           FORMAT(A1,'small')
                CALL DPWRST('XXX','WRIT')
              ELSEIF(ISIZE.EQ.-2)THEN
                WRITE(ICOUT,2528)IBASLC
 2528           FORMAT(A1,'tiny')
                CALL DPWRST('XXX','WRIT')
              ENDIF
            ENDIF
            WRITE(ICOUT,2529)IBASLC
 2529       FORMAT(A1,'begin{verbatim}')
            CALL DPWRST('XXX','WRIT')
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF')THEN
          ELSE
          ENDIF
        ENDIF
C
      ENDIF
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DTXT')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF DPDTXT--')
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDUAN(NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2,
     1                  IBUGG2,IBUGG3,ISUBRO,IBUGQ,IFOUND,IERROR)
C
C     PURPOSE--GENERATE A PAIR OF COORDINATE VECTORS THAT WILL
C              WILL DEFINE A DUANE PLOT (USED IN RELIABILITY)
C              VERTICAL AXIS   = Ti /I
C              HORIZONTAL AXIS = Ti
C              WHERE Ti ARE SORTED FAILURE TIMES
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/5
C     ORIGINAL VERSION--MAY        1998.
C     UPDATED         --APRIL      2011. USE DPPAR AND DPPAR3
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IAND1
      CHARACTER*4 IAND2
      CHARACTER*4 IBUGG2
      CHARACTER*4 IBUGG3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGQ
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 ISUBN0
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ICASE
      PARAMETER (MAXSPN=10)
      CHARACTER*40 INAME
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
C
      DIMENSION Y1(MAXOBV)
      INCLUDE 'DPCOZZ.INC'
      EQUIVALENCE (GARBAG(IGARB1),Y1(1))
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOHO.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      ISUBN1='DPDU'
      ISUBN2='AN  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      IF(IBUGG2.EQ.'ON' .OR. ISUBRO.EQ.'DUAN')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPDUAN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)ICASPL,IAND1,IAND2,MAXCOL
   52   FORMAT('ICASPL,IAND1,IAND2,MAXCOL = ',3(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)IBUGG2,IBUGG3,IBUGQ,ISUBRO
   53   FORMAT('IBUGG2,IBUGG3,IBUGQ,ISUBRO = ',3(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C
C               **********************************
C               **  TREAT THE DUANE PLOT    **
C               **********************************
C
C               *******************************************
C               **  STEP 1--                             **
C               **  SEARCH FOR DUANE PLOT                **
C               *******************************************
C
      ISTEPN='11'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DUAN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.GE.1.AND.
     1   ICOM.EQ.'DUAN'.AND.IHARG(1).EQ.'PLOT')THEN
        ICASPL='DUAN'
        ILASTC=1
      ELSE
        IFOUND='NO'
        GOTO9000
      ENDIF
C
      CALL ADJUST(ILASTC,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
      IFOUND='YES'
C
C               ****************************************
C               **  STEP 2--                          **
C               **  EXTRACT THE VARIABLE LIST         **
C               ****************************************
C
      ISTEPN='2'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DUAN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='DUANE PLOT'
      MINNA=1
      MAXNA=100
      MINN2=2
      IFLAGE=1
      IFLAGM=1
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
      MINNVA=1
      MAXNVA=1
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGG3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DUAN')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
C     EXTRACT THE VARIABLE.
C
      ICOL=1
      CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1            INAME,IVARN1,IVARN2,IVARTY,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVAR,
     1            MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1            MAXCP4,MAXCP5,MAXCP6,
     1            V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1            Y1,Y1,Y1,NS,NS,NS,ICASE,
     1            IBUGG3,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               ********************************************************
C               **  STEP 41--                                         **
C               **  FORM THE VERTICAL AND HORIZONTALAXIS              **
C               **  VARIABLES (Y(.) AND X(.), RESPECTIVELY)FOR THE    **
C               **  PLOT.   FORM THE CURVE DESIGNATION VARIABLED(.) . **
C               **  THIS WILL BE ALL ONES.                            **
C               **  DEFINE THE NUMBER OF PLOT POINTS   (NPLOTP).      **
C               **  DEFINE THE NUMBER OF PLOT VARIABLES(NPLOTV).      **
C               ********************************************************
C
      ISTEPN='41'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DUAN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDUA2(Y1,NS,ICASPL,MAXN,
     1            Y,X,D,NPLOTP,NPLOTV,
     1            ALPHA,BETA,XRESSD,XRESDF,CCXY,SDALPH,SDBETA,CCALBE,
     1            IBUGG3,ISUBRO,IERROR)
C
C               ***************************************
C               **  STEP 61--                        **
C               **  COMPUTE DUANE PLOT STAT          **
C               **  UPDATE INTERNAL DATAPLOT TABLES  **
C               ***************************************
C
      ISTEPN='61'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DUAN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IH='DPCC'
      IH2='    '
      VALUE0=CCXY
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='DPA0'
      IH2='    '
      VALUE0=ALPHA
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='DPA1'
      IH2='    '
      VALUE0=BETA
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='SDDP'
      IH2='A0  '
      VALUE0=SDALPH
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='SDDP'
      IH2='A1  '
      VALUE0=SDBETA
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='DPRE'
      IH2='SSD '
      VALUE0=XRESSD
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='DPRE'
      IH2='SDF '
      VALUE0=XRESDF
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DUAN')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDUAN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IFOUND,IERROR
 9012   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2
 9013   FORMAT('NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2 = ',
     1         3I8,2X,2(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
        IF(NPLOTP.GT.0)THEN
          DO9015I=1,NPLOTP
            WRITE(ICOUT,9016)I,Y(I),X(I),D(I)
 9016       FORMAT('I,Y(I),X(I),D(I) = ',I8,3F12.5)
            CALL DPWRST('XXX','BUG ')
 9015     CONTINUE
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDUA2(Y1,N,ICASPL,MAXN,
     1                  Y,X,D,NPLOTP,NPLOTV,
     1                  ALPHA,BETA,XRESSD,XRESDF,CCXY,
     1                  SDALPH,SDBETA,CCALBE,
     1                  IBUGG3,ISUBRO,IERROR)
C
C     PURPOSE--GENERATE A PAIR OF COORDINATE VECTORS
C              THAT WILL DEFINE A DUANE PLOT
C              VERTICAL AXIS   = Ti/I
C              HORIZONTAL AXIS = Ti
C     INPUT ARGUMENTS--Y1     = THE SINGLE PRECISION VECTOR OF
C                               (UNSORTED) OBSERVATIONS
C                               FOR THE FIRST  VARIABLE.
C                      N      = THE INTEGER NUMBER OF OBSERVATIONS
C                               IN THE VECTOR X.
C     CAUTION--THE INPUT VARIABLE Y1(.) WILL BE CHANGED HEREIN
C              (IT WILL BE SORTED)
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/5
C     ORIGINAL VERSION--MAY       1998.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IBUGG3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN0
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION Y1(*)
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION D(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDU'
      ISUBN2='A2  '
C
      IERROR='NO'
C
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'DUA2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPDUA2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGG3,ISUBRO,IERROR
   52   FORMAT('IBUGG3,ISUBRO,IERROR = ',2(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)N,ICASPL,MAXN
   53   FORMAT('N,ICASPL,MAXN = ',I8,2X,A4,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,Y1(I)
   56     FORMAT('I, Y1(I), = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(N.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN DUANE PLOT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,112)
  112   FORMAT('      THE NUMBER OF OBSERVATIONS MUST BE AT LEAST TWO;')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,114)N
  114   FORMAT('      THE ENTERED NUMBER OF OBSERVATIONS HERE = ',I6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      HOLD=Y1(1)
      DO120I=1,N
      IF(Y1(I).NE.HOLD)GOTO129
  120 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,111)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,122)
  122 FORMAT('      ALL ELEMENTS IN THE THE RESPONSE VARIABLE')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,123)HOLD
  123 FORMAT('      ARE IDENTICALLY EQUAL TO ',G15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
  129 CONTINUE
C
C               ***********************************************
C               **  STEP 12--                                **
C               **  COMPUTE COORDINATES FOR DUANE     PLOT   **
C               **  NOTE--THE LOGGING OF THE 1-F(X) WILL     **
C               **        NOTE BE DONE HEREIN BUT WILL       **
C               **        BE DONE IN THE UNDERLYING          **
C               **        GRAPHICS BY LOG SCALE              **
C               ***********************************************
C
C
      CALL SORT(Y1,N,Y1)
C
      AN=N
      J=0
      DO1100I=1,N
        J=J+1
        X(J)=Y1(I)
        Y(J)=Y1(J)/REAL(J)
        D(J)=1.0
 1100 CONTINUE
      NPLOTP=J
C
C  NOTE: FOR FITTED LINE, NEED TO FIT THE LOGS OF Y AND X
C
      ISUBN0='DPDU'
      DO200I=1,NPLOTP
       Y(I)=LOG(Y(I))
       X(I)=LOG(X(I))
 200  CONTINUE 
      CALL LINFIT(Y,X,NPLOTP,
     1            ALPHA,BETA,XRESSD,XRESDF,CCXY,SDALPH,SDBETA,CCALBE,
     1            ISUBRO,IBUGG3,IERROR)
      DO300I=1,NPLOTP
       Y(I)=EXP(Y(I))
       X(I)=EXP(X(I))
 300  CONTINUE 
      NPLOTP=NPLOTP+1
      X(NPLOTP)=X(1)
      Y(NPLOTP)=EXP(ALPHA+BETA*LOG(X(1)))
      D(NPLOTP)=2.0
      NPLOTP=NPLOTP+1
      X(NPLOTP)=X(N)
      Y(NPLOTP)=EXP(ALPHA+BETA*LOG(X(N)))
      D(NPLOTP)=2.0
C
      NPLOTV=2
      GOTO9000
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'DUA2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDUA2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9021)NPLOTP,NPLOTV
 9021   FORMAT('NPLOTP,NPLOTV = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9022I=1,NPLOTP
          WRITE(ICOUT,9023)I,Y(I),X(I),D(I)
 9023     FORMAT('I,Y(I),X(I),D(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
 9022   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDURB(YTEMP,XTEMP,MAXNXT,
     1                  ICAPSW,IFORSW,
     1                  IBUGA2,IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--CARRY OUT DURBIN TEST NON-PARAMETRIC TWO-WAY ANOVA
C              OF INCOMPLETE BLOCK DESIGNS
C     EXAMPLE--DURBIN TEST Y X1 X2
C     REFERENCE--W. J. CONOVER (1999).  "PRACTICAL NONPARAMETRIC
C                STATISTICS", THIRD EDITION, WILEY, PP. 388-395.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/1
C     ORIGINAL VERSION--JANUARY   2006.
C     UPDATED         --JANUARY   2007. CALL LIST TO DPDUR2
C     UPDATED         --APRIL     2011. USE DPPARS AND DPPARS3
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 IFORSW
      CHARACTER*4 IBUGA2
      CHARACTER*4 IBUGA3
      CHARACTER*4 IBUGQ
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 IHOST1
      CHARACTER*4 ISUBN0
C
      LOGICAL IFRST
      LOGICAL ILAST
      CHARACTER*4 IFLAGU
      CHARACTER*4 ICASE
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=30)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      REAL PID(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
C---------------------------------------------------------------------
C
      DIMENSION YTEMP(*)
      DIMENSION XTEMP(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
C
      DIMENSION XTEMP2(MAXOBV)
      DIMENSION DBLOCK(MAXOBV)
      DIMENSION DTREAT(MAXOBV)
      DIMENSION YRANK(MAXOBV)
      DIMENSION RJ(MAXOBV)
      DIMENSION XTEMP3(MAXOBV)
C
      INCLUDE 'DPCOZZ.INC'
      EQUIVALENCE(GARBAG(IGARB1),XTEMP2(1))
      EQUIVALENCE(GARBAG(IGARB2),DBLOCK(1))
      EQUIVALENCE(GARBAG(IGARB3),DTREAT(1))
      EQUIVALENCE(GARBAG(IGARB4),YRANK(1))
      EQUIVALENCE(GARBAG(IGARB5),RJ(1))
      EQUIVALENCE(GARBAG(IGARB6),XTEMP3(1))
C
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCOSU.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPDU'
      ISUBN2='RB  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      IFOUND='YES'
      IERROR='NO'
C
C               ******************************************
C               **  TREAT THE DURBIN TEST CASE          **
C               ******************************************
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DURB')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPDURB--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA2,IBUGA3,IBUGQ,ISUBRO,MAXNXT
   52   FORMAT('IBUGA2,IBUGA3,IBUBQ,ISUBRO,MAXNXT = ',4(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)ICAPSW,ICAPTY,IFORSW
   53   FORMAT('ICAPSW,ICAPTY,IFORSW = ',2(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *********************************
C               **  STEP 1--                   **
C               **  EXTRACT THE VARIABLE LIST  **
C               *********************************
C
      ISTEPN='1'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DURB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='DURBIN TEST'
      MAXNA=100
      MINNVA=1
      MAXNVA=3
      MINNA=1
      IFLAGE=1
      IFLAGM=0
      MINN2=2
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DURB')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,181)
  181   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,182)NQ,NUMVAR,IMULT
  182   FORMAT('NQ,NUMVAR,IMULT = ',2I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO185I=1,NUMVAR
            WRITE(ICOUT,187)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  187       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  185     CONTINUE
        ENDIF
      ENDIF
C
C               **********************************
C               **  STEP 52--                   **
C               **  CARRY OUT THE DURBIN TEST   **
C               **********************************
C
      ISTEPN='52'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DURB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ICOL=1
      NUMVA2=3
      CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1            INAME,IVARN1,IVARN2,IVARTY,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1            MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1            MAXCP4,MAXCP5,MAXCP6,
     1            V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1            Y,X,XTEMP2,NS1,NS1,NS1,ICASE,
     1            IBUGA3,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'DURB')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,5211)
 5211   FORMAT('***** FROM DPDURB, AS WE ARE ABOUT TO CALL DPDUR2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,5212)NS1
 5212   FORMAT('NS1 = ',I8)
        CALL DPWRST('XXX','BUG ')
        DO5215I=1,NS1
          WRITE(ICOUT,5216)I,Y(I),X(I),XTEMP2(I)
 5216     FORMAT('I,Y(I),X(I),XTEMP2(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
 5215   CONTINUE
      ENDIF
C
      CALL DPDUR2(Y,X,XTEMP2,NS1,IVARN1,IVARN2,
     1            YTEMP,XTEMP,YRANK,RJ,DBLOCK,DTREAT,
     1            XTEMP3,MAXNXT,
     1            STATVA,STATCD,PVAL,
     1            CUT0,CUT50,CUT75,CUT90,CUT95,CUT975,CUT99,CUT999,
     1            ICAPSW,ICAPTY,IFORSW,
     1            IBUGA3,ISUBRO,IERROR)
C
      IFLAGU='ON'
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPFRT5(STATVA,STATCD,PVAL,
     1            CUT0,CUT50,CUT75,CUT90,CUT95,
     1            CUT975,CUT99,CUT999,
     1            IFLAGU,IFRST,ILAST,
     1            IBUGA2,IBUGA3,ISUBRO,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'DUR2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDURB--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)IFOUND,IERROR
 9016   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPDUR2(Y,BLOCK,TREAT,N,IVARID,IVARI2,
     1                  YTEMP,XTEMP,YRANK,RJ,DBLOCK,DTREAT,
     1                  XTEMP2,MAXNXT,
     1                  STATVA,STATCD,PVAL,
     1                  CUT0,CUT50,CUT75,CUT90,CUT95,CUT975,
     1                  CUT99,CUT999,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--THIS ROUTINE CARRIES OUT DURBIN'S TEST
C              NON-PARAMETRIC TWO-WAY ANOVA FOR BALANCED,
C              INCOMPLETE BLOCK DESIGNS
C     EXAMPLE--DURBIN TEST Y BLOCK TREAT
C     REFERENCE--W. J. CONOVER (1999).  "PRACTICAL NONPARAMETRIC
C                STATISTICS", THIRD EDITION, WILEY, PP. 388-395.
c     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/1
C     ORIGINAL VERSION--JANUARY   2006.
C     UPDATED         --OCTOBER   2006. CALL LIST TO TPPF
C     UPDATED         --JANUARY   2007. CALL LIST TO RANK
C     UPDATED         --APRIL     2011. USE DPDTA1 AND DPDTA4 TO
C                                       PRINT TABLES.  THIS ADDS RTF
C                                       SUPPORT AND SPECIFICATION OF
C                                       THE NUMBER OF DIGITS.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
      CHARACTER*4 IVARID(*)
      CHARACTER*4 IVARI2(*)
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN0
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 IOP
C
      CHARACTER*3 IATEMP
C
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION BLOCK(*)
      DIMENSION TREAT(*)
      DIMENSION YRANK(*)
      DIMENSION RJ(*)
      DIMENSION DBLOCK(*)
      DIMENSION DTREAT(*)
      DIMENSION YTEMP(*)
      DIMENSION XTEMP(*)
      DIMENSION XTEMP2(*)
C
      PARAMETER (NUMALP=8)
      REAL ALPHA(NUMALP)
C
      PARAMETER(NUMCLI=6)
      PARAMETER(MAXLIN=2)
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*60 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      CHARACTER*15 IVALUE(MAXROW,NUMCLI)
      CHARACTER*4  ITYPCO(NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      NCVALU(MAXROW,NUMCLI)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
      LOGICAL IFLAG1
      LOGICAL IFLAG2
      LOGICAL IFLAGS
      LOGICAL IFLAGE
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      DATA ALPHA/
     1 0.0, 50.0, 75.0, 90.0, 95.0, 97.5, 99.0, 99.9/
C
      ISUBN1='DPDU'
      ISUBN2='R2  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DUR2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPDUR2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',2(A4,2X),I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,N
          WRITE(ICOUT,57)I,Y(I),BLOCK(I),TREAT(I)
   57     FORMAT('I,Y(I),BLOCK(I),TREAT(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DUR2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      HOLD=Y(1)
      DO1135I=2,N
      IF(Y(I).NE.HOLD)GOTO1139
 1135 CONTINUE
 1130 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1131)
 1131 FORMAT('***** ERROR FROM DURBIN TEST--')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1133)HOLD
 1133 FORMAT('      THE RESPONSE VARIABLE HAS ALL ELEMENTS = ',G15.7)
      CALL DPWRST('XXX','WRIT')
      IERROR='YES'
      GOTO9000
 1139 CONTINUE
C
      HOLD=BLOCK(1)
      DO1235I=2,N
      IF(BLOCK(I).NE.HOLD)GOTO1239
 1235 CONTINUE
 1230 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1131)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1231)HOLD
 1231 FORMAT('      THE FIRST FACTOR VARIABLE HAS ALL ELEMENTS = ',
     1       G15.7)
      CALL DPWRST('XXX','WRIT')
      IERROR='YES'
      GOTO9000
 1239 CONTINUE
C
      HOLD=TREAT(1)
      DO1335I=2,N
      IF(TREAT(I).NE.HOLD)GOTO1339
 1335 CONTINUE
 1330 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1131)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1331)HOLD
 1331 FORMAT('      THE SECOND FACTOR VARIABLE HAS ALL ELEMENTS = ',
     1       G15.7)
      CALL DPWRST('XXX','WRIT')
      GOTO9000
 1339 CONTINUE
C
C               ********************************************
C               **  STEP 12--                             **
C               **  CHECK TO SEE IF A BALANCED DESIGN     **
C               **  WAS ENTERED.                          **
C               **  1) EVERY BLOCK CONTAINS K EXPERIMENTAL**
C               **     UNITS.                             **
C               **  2) EVERY TREATMENT APPEARS IN R       **
C               **     BLOCKS.                            **
C               ********************************************
C
      ISTEPN='12'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DUR2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C  STEP 1: COMPUTE NUMBER OF DISTINCT BLOCKS AND TREATMENTS
C
      CALL DISTIN(BLOCK,N,IWRITE,DBLOCK,NBLOCK,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES' .OR. NBLOCK.LE.0)GOTO9000
      CALL DISTIN(TREAT,N,IWRITE,DTREAT,NTREAT,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES' .OR. NTREAT.LE.0)GOTO9000
C
C  STEP 2: DETERMINE IF EVERY BLOCK CONTAINS K EXPERIMENTAL
C          TREATMENTS
C
      KHOLD=0
      DO1410I=1,NBLOCK
        ABLOCK=BLOCK(I)
        NK=0
        DO1420J=1,N
          IF(BLOCK(J).EQ.ABLOCK)NK=NK+1
 1420   CONTINUE
        IF(KHOLD.EQ.0)THEN
          KHOLD=NK
        ELSE
          IF(NK.NE.KHOLD)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,1131)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,1432)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,1433)I,NK,KHOLD
            CALL DPWRST('XXX','WRIT')
            IERROR='YES'
            GOTO9000
          ENDIF
        ENDIF
 1410 CONTINUE
 1432 FORMAT('      UNEQUAL BLOCK SIZES DETECTED:')
 1433 FORMAT('      BLOCK ',I8,' HAD ',I8,' TREATMENTS WHEN ',
     1       I8,' TREATMENTS WERE EXPECTED.')
C
C  STEP 3: DETERMINE IF EVERY TREATMENT APPEARS IN R BLOCKS
C          (FOR NOW JUST CHECK THAT IT APPEARS R TIMES)
C
      IRHOLD=0
      DO1510I=1,NTREAT
        ATREAT=TREAT(I)
        NR=0
        DO1520J=1,N
          IF(TREAT(J).EQ.ATREAT)NR=NR+1
 1520   CONTINUE
        IF(IRHOLD.EQ.0)THEN
          IRHOLD=NR
        ELSE
          IF(NR.NE.IRHOLD)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,1131)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,1532)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,1533)I,NR,IRHOLD
            CALL DPWRST('XXX','WRIT')
            IERROR='YES'
            GOTO9000
          ENDIF
        ENDIF
 1510 CONTINUE
 1532 FORMAT('      UNEQUAL TREATMENT SIZES DETECTED:')
 1533 FORMAT('      TREATMENT ',I8,' APPEARED ',I8,' TIMES ',
     1       'WHEN ',I8,' OCCURENCES WERE EXPECTED.')
C
C               ******************************
C               **  STEP 21--               **
C               **  CARRY OUT CALCULATIONS  **
C               **  FOR DURBIN TEST         **
C               ******************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DUR2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IWRITE='OFF'
C
C  COMPUTATIONAL ALGORITHM:
C
C  1. X(IJ)     = RESPONSE FOR BLOCK I, TREATMENT J
C  2. R(X(IJ))  = RANK OF X(IJ) WITHIN EACH BLOCK
C  3. R(J)      = SUM[I=1 TO K][R(X(IJ))]
C  4. A         = SUM[I=1 TO B][J=1 TO T][(R(X(IJ)]**2
C  5. C         = B*K(K+1)**2/4
C  6. T1        = (T-1)*{SUM[J=1 TO T][R(J)**2] - R*C]/(A-C)
C
      DSUM1=0.0D0
      DSUM2=0.0D0
      DO4010I=1,MAXNXT
        XTEMP(I)=0.0
        YTEMP(I)=0.0
        YRANK(I)=0.0
        RJ(I)=0.0
 4010 CONTINUE
C
C  EXTRACT THE X(IJ) FOR EACH BLOCK
C
      DO2110I=1,NBLOCK
        HOLD=DBLOCK(I)
        ICOUNT=0
        DO2120J=1,N
          IF(BLOCK(J).EQ.HOLD)THEN
            ICOUNT=ICOUNT+1
            YTEMP(ICOUNT)=Y(J)
          ENDIF
 2120   CONTINUE
        CALL RANK(YTEMP,ICOUNT,IWRITE,XTEMP,XTEMP2,MAXNXT,
     1            IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        ICOUNT=0
        DO2130J=1,N
          IF(BLOCK(J).EQ.HOLD)THEN
            ICOUNT=ICOUNT+1
            YRANK(J)=XTEMP(ICOUNT)
          ENDIF
 2130   CONTINUE
 2110 CONTINUE
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DUR2')THEN
        DO2140I=1,N
          WRITE(ICOUT,2142)I,Y(I),YRANK(I)
 2142     FORMAT('I,Y(I),YRANK(I) = ',I8,G15.7,F12.2)
          CALL DPWRST('XXX','BUG ')
 2140   CONTINUE
      ENDIF
C
C  STEP 3: NOW COMPUTE RANK SUMS FOR EACH TREATMENT
C
      DO2210I=1,NTREAT
        HOLD=DTREAT(I)
        DSUM1=0.0D0
        DO2220J=1,N
          IF(TREAT(J).EQ.HOLD)THEN
            DSUM1=DSUM1 + DBLE(YRANK(J))
          ENDIF
 2220   CONTINUE
        RJ(I)=REAL(DSUM1)
 2210 CONTINUE
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DUR2')THEN
        DO2240I=1,NTREAT
          WRITE(ICOUT,2242)I,RJ(I)
 2242     FORMAT('I,RJ(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
 2240   CONTINUE
      ENDIF
C
C  STEP 4: NOW COMPUTE VARIOUS QUANTITIES BASED ON RJ
C
      DSUM2=0.0D0
      DO2310I=1,N
        DSUM2=DSUM2 + DBLE(YRANK(I))**2
 2310 CONTINUE
      A=REAL(DSUM2)
      B=REAL(NBLOCK)
      T=REAL(NTREAT)
      R=REAL(NR)
      AK=REAL(NK)
      C=B*AK*(AK+1)**2/4.0
      DENOM=A-C
      C1=(T-1.0)
      C2=R*C
C
      DSUM1=0.0D0
      DO2320I=1,NTREAT
        DSUM1=DSUM1 + RJ(I)**2
 2320 CONTINUE
      T1=C1*(REAL(DSUM1)-C2)/DENOM
      T2=(T1/C1)/((B*(AK-1.0) - T1)/(B*AK - B - T + 1.0))
C
      STATVA=T2
      NUMDF1=NTREAT-1
      NUMDF2=INT(B*AK - B - T +1)
      CALL FCDF(STATVA,NUMDF1,NUMDF2,STATCD)
      PVAL=1.0 - STATCD
C
      CUT0=0.0
      CALL FPPF(.50,NUMDF1,NUMDF2,CUT50)
      CALL FPPF(.75,NUMDF1,NUMDF2,CUT75)
      CALL FPPF(.90,NUMDF1,NUMDF2,CUT90)
      CALL FPPF(.95,NUMDF1,NUMDF2,CUT95)
      CALL FPPF(.975,NUMDF1,NUMDF2,CUT975)
      CALL FPPF(.99,NUMDF1,NUMDF2,CUT99)
      CALL FPPF(.999,NUMDF1,NUMDF2,CUT999)
C
      IDF=INT(B*AK - B - T + 1.0)
      CALL TPPF(0.95,REAL(IDF),T95)
      CALL TPPF(0.975,REAL(IDF),T975)
      CALL TPPF(0.995,REAL(IDF),T995)
      TERM1=(A-C)*2.0*R/(B*AK - B - T + 1.0)
      TERM2=1.0 - (T1/(B*(AK - 1.0)))
      CONTRA=SQRT(TERM1*TERM2)
      CONTR1=T95*CONTRA
      CONTR2=T975*CONTRA
      CONTR3=T995*CONTRA
C
      IOP='OPEN'
      IFLG1=1
      IFLG2=1
      IFLG3=0
      IFLG4=0
      IFLG5=0
      CALL DPAUFI(IOP,IFLG1,IFLG2,IFLG3,IFLG4,IFLG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      WRITE(IOUNI1,2405)
 2405 FORMAT(4X,'RESPONSE',13X,'RANK',11X,'BLOCK',8X,'TREATMENT')
      DO2410I=1,N
        WRITE(IOUNI1,2411)Y(I),YRANK(I),BLOCK(I),TREAT(I)
 2411   FORMAT(1X,E15.7,F15.2,F15.2,F15.2)
 2410 CONTINUE
C
      WRITE(IOUNI2,2421)CONTRA
 2421 FORMAT(1X,'Contrast term:          ',E15.7)
      WRITE(IOUNI2,2422)CONTR1
 2422 FORMAT(1X,'Contrast term*t(0.95):  ',E15.7)
      WRITE(IOUNI2,2423)CONTR2
 2423 FORMAT(1X,'Contrast term*t(0.975): ',E15.7)
      WRITE(IOUNI2,2424)CONTR3
 2424 FORMAT(1X,'Contrast term*t(0.995): ',E15.7)
      WRITE(IOUNI2,2425)
 2425 FORMAT(10X,'I',10X,'J',8X,'|R(I)-R(J)|')
C
      DO2430I=1,NTREAT
        DO2439J=1,NTREAT
          IF(I.LT.J)THEN
            ADIFF=ABS(RJ(I)-RJ(J))
            IATEMP='   '
            IF(ABS(ADIFF).GE.CONTR1)IATEMP(1:1)='*'
            IF(ABS(ADIFF).GE.CONTR2)IATEMP(2:2)='*'
            IF(ABS(ADIFF).GE.CONTR3)IATEMP(3:3)='*'
            WRITE(IOUNI2,2437)I,J,ADIFF,IATEMP
 2437       FORMAT(3X,I8,3X,I8,5X,E15.7,A3)
          ENDIF
 2439   CONTINUE
 2430 CONTINUE
C
      IOP='CLOS'
      CALL DPAUFI(IOP,IFLG1,IFLG2,IFLG3,IFLG4,IFLG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
C
C               ******************************
C               **   STEP 43--              **
C               **   WRITE OUT EVERYTHING   **
C               **   FOR DURBIN TEST        **
C               ******************************
C
      ISTEPN='43'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DUR2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Durbin Test for Two-Way Balanced Incomplete Block Designs'
      NCTITL=57
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Response Variable: '
      WRITE(ITEXT(ICNT)(20:23),'(A4)')IVARID(1)(1:4)
      WRITE(ITEXT(ICNT)(24:27),'(A4)')IVARI2(1)(1:4)
      NCTEXT(ICNT)=27
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='First Group-ID Variable: '
      WRITE(ITEXT(ICNT)(26:29),'(A4)')IVARID(2)(1:4)
      WRITE(ITEXT(ICNT)(30:33),'(A4)')IVARI2(2)(1:4)
      NCTEXT(ICNT)=33
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Second Group-ID Variable: '
      WRITE(ITEXT(ICNT)(27:30),'(A4)')IVARID(3)(1:4)
      WRITE(ITEXT(ICNT)(31:34),'(A4)')IVARI2(3)(1:4)
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='H0: Treatments Have Identical Effects'
      NCTEXT(ICNT)=37
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Ha: Treatments Do Not Have Identical Effects'
      NCTEXT(ICNT)=44
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Total Number of Observations:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Blocks:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=REAL(NBLOCK)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Treatments:'
      NCTEXT(ICNT)=21
      AVALUE(ICNT)=REAL(NTREAT)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Blocks for Each Treatment:'
      NCTEXT(ICNT)=36
      AVALUE(ICNT)=REAL(NR)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Test:'
      NCTEXT(ICNT)=5
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Sum of Squares of Ranks (A):'
      NCTEXT(ICNT)=28
      AVALUE(ICNT)=A
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Correction Factor (C):'
      NCTEXT(ICNT)=28
      AVALUE(ICNT)=C
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Durbin Test Statistic (Uncorrected):'
      NCTEXT(ICNT)=36
      AVALUE(ICNT)=T1
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Durbin Test Statistic (Corrected):'
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=STATVA
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='CDF of Test Statistic:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=STATCD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='P-Value:'
      NCTEXT(ICNT)=8
      AVALUE(ICNT)=PVAL
      IDIGIT(ICNT)=NUMDIG
C
      NUMROW=ICNT
      DO4210I=1,NUMROW
        NTOT(I)=15
 4210 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      ISTEPN='42A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DUR2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ITITLE=' '
      NCTITL=0
      ITITL9=' '
      NCTIT9=0
      ITITLE='Percent Points of the F Reference Distribution'
      NCTITL=46
      NUMLIN=1
      NUMROW=8
      NUMCOL=3
      ITITL2(1,1)='Percent Point'
      ITITL2(1,2)=' '
      ITITL2(1,3)='Value'
      NCTIT2(1,1)=13
      NCTIT2(1,2)=1
      NCTIT2(1,3)=5
C
      NMAX=0
      DO4221I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(I.EQ.2)NTOT(I)=5
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
        ITYPCO(I)='NUME'
 4221 CONTINUE
      ITYPCO(2)='ALPH'
      IDIGIT(1)=1
      IDIGIT(3)=3
      DO4223I=1,NUMROW
        DO4225J=1,NUMCOL
          NCVALU(I,J)=0
          IVALUE(I,J)=' '
          NCVALU(I,J)=0
          AMAT(I,J)=0.0
          IF(J.EQ.1)THEN
            AMAT(I,J)=ALPHA(I)
          ELSEIF(J.EQ.2)THEN
            IVALUE(I,J)='='
            NCVALU(I,J)=1
          ELSEIF(J.EQ.3)THEN
            IF(I.EQ.1)THEN
              AMAT(I,J)=RND(CUT0,IDIGIT(J))
            ELSEIF(I.EQ.2)THEN
              AMAT(I,J)=RND(CUT50,IDIGIT(J))
            ELSEIF(I.EQ.3)THEN
              AMAT(I,J)=RND(CUT75,IDIGIT(J))
            ELSEIF(I.EQ.4)THEN
              AMAT(I,J)=RND(CUT90,IDIGIT(J))
            ELSEIF(I.EQ.5)THEN
              AMAT(I,J)=RND(CUT95,IDIGIT(J))
            ELSEIF(I.EQ.6)THEN
              AMAT(I,J)=RND(CUT975,IDIGIT(J))
            ELSEIF(I.EQ.7)THEN
              AMAT(I,J)=RND(CUT99,IDIGIT(J))
            ELSEIF(I.EQ.8)THEN
              AMAT(I,J)=RND(CUT999,IDIGIT(J))
            ENDIF
          ENDIF
 4225   CONTINUE
 4223 CONTINUE
C
      IWHTML(1)=150
      IWHTML(2)=50
      IWHTML(3)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+500
      IWRTF(3)=IWRTF(2)+2000
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      ISTEPN='42C'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DUR2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDTA4(ITITL9,NCTIT9,
     1            ITITLE,NCTITL,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,NUMROW,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
      CDF1=CUT90
      CDF2=CUT95
      CDF3=CUT975
      CDF4=CUT99
C
      ITITL9=' '
      NCTIT9=0
      ITITLE='Conclusions (Upper 1-Tailed Test)'
      NCTITL=33
      NUMLIN=1
      NUMROW=4
      NUMCOL=4
      ITITL2(1,1)='Alpha'
      ITITL2(1,2)='CDF'
      ITITL2(1,3)='Critical Value'
      ITITL2(1,4)='Conclusion'
      NCTIT2(1,1)=5
      NCTIT2(1,2)=3
      NCTIT2(1,3)=14
      NCTIT2(1,4)=10
C
      NMAX=0
      DO4321I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(I.EQ.1 .OR. I.EQ.2)NTOT(I)=7
        IF(I.EQ.3)NTOT(I)=17
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=3
        ITYPCO(I)='ALPH'
 4321 CONTINUE
      ITYPCO(3)='NUME'
      IDIGIT(1)=0
      IDIGIT(2)=0
      DO4323I=1,NUMROW
        DO4325J=1,NUMCOL
          NCVALU(I,J)=0
          IVALUE(I,J)=' '
          NCVALU(I,J)=0
          AMAT(I,J)=0.0
 4325   CONTINUE
 4323 CONTINUE
      IVALUE(1,1)='10%'
      IVALUE(2,1)='5%'
      IVALUE(3,1)='2.5%'
      IVALUE(4,1)='1%'
      IVALUE(1,2)='90%'
      IVALUE(2,2)='95%'
      IVALUE(3,2)='97.5%'
      IVALUE(4,2)='99%'
      NCVALU(1,1)=3
      NCVALU(2,1)=2
      NCVALU(3,1)=4
      NCVALU(4,1)=2
      NCVALU(1,2)=3
      NCVALU(2,2)=3
      NCVALU(3,2)=5
      NCVALU(4,2)=3
      IVALUE(1,4)='Accept H0'
      IVALUE(2,4)='Accept H0'
      IVALUE(3,4)='Accept H0'
      IVALUE(4,4)='Accept H0'
      NCVALU(1,4)=9
      NCVALU(2,4)=9
      NCVALU(3,4)=9
      NCVALU(4,4)=9
      IF(STATVA.GT.CUT90)IVALUE(1,4)='Reject H0'
      IF(STATVA.GT.CUT95)IVALUE(2,4)='Reject H0'
      IF(STATVA.GT.CUT975)IVALUE(3,4)='Reject H0'
      IF(STATVA.GT.CUT99)IVALUE(4,4)='Reject H0'
      AMAT(1,3)=RND(CUT90,IDIGIT(3))
      AMAT(2,3)=RND(CUT95,IDIGIT(3))
      AMAT(3,3)=RND(CUT975,IDIGIT(3))
      AMAT(4,3)=RND(CUT99,IDIGIT(3))
C
      IWHTML(1)=150
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWRTF(1)=1500
      IWRTF(2)=IWRTF(1)+1500
      IWRTF(3)=IWRTF(2)+2000
      IWRTF(4)=IWRTF(3)+2000
      IFRST=.FALSE.
      ILAST=.TRUE.
C
      ISTEPN='42E'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'KRU2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDTA4(ITITL9,NCTIT9,
     1            ITITLE,NCTITL,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,NUMROW,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'DUR2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPDUR2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)STATVA,STATCD,PVAL
 9012   FORMAT('STATVA,STATCD,PVAL = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPEBLL(P,N,ALPHA,IWRITE,ALOWLM,IBUGA3,IERROR)
C
C     PURPOSE--FOR A GIVEN P, N, AND ALPHA, COMPUTE THE
C              EXACT BINOMIAL LOWER BINOMIAL CONFIDENCE
C              LIMIT.  THIS IS USEFUL FOR GENERATING BINOMIAL
C              CONFIDENCE LIMITS WHEN ONLY SUMMARY INFORMATION
C              IS AVAILABLE.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/2
C     ORIGINAL VERSION--FEBRUARY  2007.
C     UPDATED         --MARCH     2007. NEED TO SUBTRACT 1 FROM
C                                       NUMBER OF SUCCESSES FOR
C                                       LOWER BOUND
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      REAL P
      REAL ALPHA
      REAL ALOWLM
      INTEGER N
C
      EXTERNAL BINFUN
      COMMON/BINCOM/XSUCC,CONST,NTEMP
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPEB'
      ISUBN2='LL  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPEBLL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)P,N,ALPHA
   53   FORMAT('P,N,ALPHA = ',G15.7,I8,G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ********************************
C               **  STEP 1--                  **
C               **  CHECK FOR INPUT ERRORS    **
C               ********************************
C
      IF(N.LT.1)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,151)
  151   FORMAT('***** ERROR IN DPEBLL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,152)
  152   FORMAT('      THE INPUT SAMPLE SIZE FOR THE EXACT LOWER')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,154)
  154   FORMAT('      BINOMIAL CONFIDENCE LIMIT IS LESS THAN 1.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,157)N
  157   FORMAT('      THE INPUT SAMPLE SIZE            = ',I8)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      IF(P.LT.0.0 .OR. P.GT.1.0)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,161)
  161   FORMAT('***** ERROR IN DPEBLL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,162)
  162   FORMAT('      THE BINOMIAL PROBABILITY OF SUCCESS PARAMETER')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,164)
  164   FORMAT('      IS OUTSIDE THE (0,1) INTERVAL.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,167)P
  167   FORMAT('      THE PROBABILITY OF SUCCESS PARAMETER = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      ALPHSV=ALPHA
      IF(ALPHA.GT.1.0 .AND. ALPHA.LE.100.0)ALPHA=ALPHA/100.0
      IF(ALPHA.LE.0.0 .OR. ALPHA.GE.1.0)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,171)
  171   FORMAT('***** ERROR IN DPEBLL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,172)
  172   FORMAT('      THE VALUE OF ALPHA IS OUTSIDE THE (0,1) ',
     1         'INTERVAL.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,177)ALPHSV
  177   FORMAT('      THE VALUE OF ALPHA = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
C               ******************************************
C               **  STEP 2--                            **
C               **  COMPUTE THE EXACT LOWER BINOMIAL    **
C               **  CONFIDENCE LIMIT                    **
C               ******************************************
C
      P1=ALPHA
      AN=REAL(N)
      Q=1.0-P
C
      CALL NORPPF(P1,ZALPHA)
      CONST=P1
      PHAT=P
      PLOWLI=0.0
      PUPPLI=PHAT
      IF(PHAT.LE.0.0)THEN
        ALOWLM=0.0
      ELSE
        NTEMP=N
CCCCC   XSUCC=AN*P
        XSUCC=AN*P - 1.0
        AE=1.E-6
        RE=1.E-6
        CALL FZERO(BINFUN,PLOWLI,PUPPLI,PHAT,RE,AE,IFLAG)
        IF(PLOWLI.GT.PHAT)THEN
          ALOWLM=0.0
        ELSE
          ALOWLM=PLOWLI
        ENDIF
        IF(ALOWLM.LT.0.0)ALOWLM=0.0
C
        IF(IFLAG.EQ.2)THEN
C
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2211)
 2211     FORMAT('***** WARNING FROM DPEBLL--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2213)
 2213     FORMAT('      ESTIMATE OF LOWER CONFIDENCE VALUE FOR P ',
     1           'MAY NOT BE COMPUTED TO DESIRED TOLERANCE.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(IFLAG.EQ.3)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2211)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2223)
 2223     FORMAT('      ESTIMATE OF LOWER CONFIDENCE VALUE FOR P ',
     1           'MAY BE NEAR A SINGULAR POINT.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(IFLAG.EQ.4)THEN
CCCCC     WRITE(ICOUT,999)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,2211)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,2233)
C2233     FORMAT('      APPROPRIATE BRACKETING INTERVAL NOT FOUND.')
CCCCC     CALL DPWRST('XXX','BUG ')
        ELSEIF(IFLAG.EQ.5)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2211)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2243)
 2243     FORMAT('      MAXIMUM ITERATIONS EXCEEDED.')
          CALL DPWRST('XXX','BUG ')
        ENDIF
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPEBLL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGA3,IERROR,ALOWLM
 9012   FORMAT('IBUGA3,IERROR,ALOWLM = ',A4,2X,A4,2X,G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPEBUL(P,N,ALPHA,IWRITE,AUPPLM,IBUGA3,IERROR)
C
C     PURPOSE--FOR A GIVEN P, N, AND ALPHA, COMPUTE THE
C              EXACT BINOMIAL UPPER BINOMIAL CONFIDENCE
C              LIMIT.  THIS IS USEFUL FOR GENERATING BINOMIAL
C              CONFIDENCE LIMITS WHEN ONLY SUMMARY INFORMATION
C              IS AVAILABLE.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/2
C     ORIGINAL VERSION--FEBRUARY  2007.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      REAL P
      REAL ALPHA
      REAL AUPPLM
      INTEGER N
C
      EXTERNAL BINFUN
      COMMON/BINCOM/XSUCC,CONST,NTEMP
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPEB'
      ISUBN2='UL  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPEBUL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)P,N,ALPHA
   53   FORMAT('P,N,ALPHA = ',G15.7,I8,G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ********************************
C               **  STEP 1--                  **
C               **  CHECK FOR INPUT ERRORS    **
C               ********************************
C
      IF(N.LT.1)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,151)
  151   FORMAT('***** ERROR IN DPEBUL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,152)
  152   FORMAT('      THE INPUT SAMPLE SIZE FOR THE EXACT UPPER')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,154)
  154   FORMAT('      BINOMIAL CONFIDENCE LIMIT IS LESS THAN 1.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,157)N
  157   FORMAT('      THE INPUT SAMPLE SIZE            = ',I8)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      IF(P.LT.0.0 .OR. P.GT.1.0)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,161)
  161   FORMAT('***** ERROR IN DPEBUL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,162)
  162   FORMAT('      THE BINOMIAL PROBABILITY OF SUCCESS PARAMETER')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,164)
  164   FORMAT('      IS OUTSIDE THE (0,1) INTERVAL.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,167)P
  167   FORMAT('      THE PROBABILITY OF SUCCESS PARAMETER = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      ALPHSV=ALPHA
      IF(ALPHA.GT.1.0 .AND. ALPHA.LE.100.0)ALPHA=ALPHA/100.0
      IF(ALPHA.LE.0.0 .OR. ALPHA.GE.1.0)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,171)
  171   FORMAT('***** ERROR IN DPEBUL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,172)
  172   FORMAT('      THE VALUE OF ALPHA IS OUTSIDE THE (0,1) ',
     1         'INTERVAL.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,177)ALPHSV
  177   FORMAT('      THE VALUE OF ALPHA = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
C               ******************************************
C               **  STEP 2--                            **
C               **  COMPUTE THE EXACT UPPER BINOMIAL    **
C               **  CONFIDENCE LIMIT                    **
C               ******************************************
C
      P2=1.0 - ALPHA
      AN=REAL(N)
      Q=1.0-P
C
      CALL NORPPF(P2,ZALPHA)
      CONST=P2
      PHAT=P
      PLOWLI=PHAT
      PUPPLI=1.0
      IF(PHAT.GE.1.0)THEN
        AUPPLM=1.0
      ELSE
        NTEMP=N
        XSUCC=AN*P
        AE=1.E-6
        RE=1.E-6
        CALL FZERO(BINFUN,PLOWLI,PUPPLI,PHAT,RE,AE,IFLAG)
        IF(PLOWLI.LT.PHAT)THEN
          AUPPLM=PUPPLI
        ELSE
          AUPPLM=PLOWLI
        ENDIF
        IF(AUPPLM.GT.1.0)AUPPLM=1.0
C
        IF(IFLAG.EQ.2)THEN
C
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2211)
 2211     FORMAT('***** WARNING FROM DPEBUL--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2213)
 2213     FORMAT('      ESTIMATE OF UPPER CONFIDENCE VALUE FOR P ',
     1           'MAY NOT BE COMPUTED TO DESIRED TOLERANCE.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(IFLAG.EQ.3)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2211)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2223)
 2223     FORMAT('      ESTIMATE OF UPPER CONFIDENCE VALUE FOR P ',
     1           'MAY BE NEAR A SINGULAR POINT.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(IFLAG.EQ.4)THEN
CCCCC     WRITE(ICOUT,999)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,2211)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,2233)
C2233     FORMAT('      APPROPRIATE BRACKETING INTERVAL NOT FOUND.')
CCCCC     CALL DPWRST('XXX','BUG ')
        ELSEIF(IFLAG.EQ.5)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2211)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2243)
 2243     FORMAT('      MAXIMUM ITERATIONS EXCEEDED.')
          CALL DPWRST('XXX','BUG ')
        ENDIF
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPEBUL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGA3,IERROR,AUPPLM
 9012   FORMAT('IBUGA3,IERROR,AUPPLM = ',A4,2X,A4,2X,G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPECDF(NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2,
     1                  IBUGG2,IBUGG3,ISUBRO,IBUGQ,IFOUND,IERROR)
C
C     PURPOSE--GENERATE A PAIR OF COORDINATE VECTORS
C              THAT WILL DEFINE AN EMPIRICAL CDF PLOT
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/5
C     ORIGINAL VERSION--MAY       1998.
C     UPDATED         --JANUARY   2012. USE DPPARS
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IAND1
      CHARACTER*4 IAND2
      CHARACTER*4 IBUGG2
      CHARACTER*4 IBUGG3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGQ
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ICASE
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=10)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOZZ.INC'
C
      DIMENSION Y1(MAXOBV)
      DIMENSION X1(MAXOBV)
      EQUIVALENCE (GARBAG(IGARB1),Y1(1))
      EQUIVALENCE (GARBAG(IGARB2),X1(1))
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      ISUBN1='DPEC'
      ISUBN2='DF  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'ECDF')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPECDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)ICASPL,IAND1,IAND2,MAXCOL
   52   FORMAT('ICASPL,IAND1,IAND2,MAXCOL = ',3(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)IBUGG2,IBUGG3,IBUGQ,ISUBRO
   53   FORMAT('IBUGG2,IBUGG3,IBUGQ,ISUBRO = ',3(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C
C               ***********************************
C               **  TREAT THE EMPIRICAL CDF PLOT **
C               ***********************************
C
C               *******************************************
C               **  STEP 1--                             **
C               **  SEARCH FOR EMPIRICAL CDF, ECDF       **
C               *******************************************
C
      ISTEPN='11'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'ECDF')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ICASPL='ECDF'
      IF(NUMARG.GE.1.AND.ICOM.EQ.'ECDF'.AND.IHARG(1).EQ.'PLOT')THEN
        ILASTC=1
      ELSEIF(NUMARG.GE.2.AND.ICOM.EQ.'EMPI'.AND.
     1       IHARG(1).EQ.'CDF '.AND.IHARG(2).EQ.'PLOT')THEN
        ILASTC=2
      ELSE
        ICASPL='    '
        IFOUND='NO'
        GOTO9000
      ENDIF
C
      CALL ADJUST(ILASTC,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
      IFOUND='YES'
C
C               ****************************************
C               **  STEP 2--                          **
C               **  EXTRACT THE VARIABLE LIST         **
C               ****************************************
C
      ISTEPN='2'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'ECDF')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='EMPIRICAL CDF PLOT'
      MINNA=1
      MAXNA=100
      MINN2=1
      IFLAGE=1
      IFLAGM=0
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
      MINNVA=1
      MAXNVA=2
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGG3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'ECDF')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
C               *******************************************************
C               **  STEP 41--                                        **
C               **  FORM THE VERTICAL AND HORIZONTAL AXIS            **
C               **  VARIABLES (Y(.) AND X(.), RESPECTIVELY)FOR THE   **
C               **  PLOT FORM THE CURVE DESIGNATION VARIABLED(.)  .  **
C               **  THIS WILL BE ALL ONES.                           **
C               **  DEFINE THE NUMBER OF PLOT POINTS   (NPLOTP).     **
C               **  DEFINE THE NUMBER OF PLOT VARIABLES(NPLOTV).     **
C               *******************************************************
C
      ISTEPN='41'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'ECDF')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ICOL=1
      CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1            INAME,IVARN1,IVARN2,IVARTY,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVAR,
     1            MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1            MAXCP4,MAXCP5,MAXCP6,
     1            V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1            Y1,X1,Y1,NS,NS,NS,ICASE,
     1            IBUGG3,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      CALL DPECD2(Y1,X1,NS,NUMVAR,ICASPL,MAXN,
     1            Y,X,D,NPLOTP,NPLOTV,IBUGG3,ISUBRO,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'ECDF')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPECDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IFOUND,IERROR
 9012   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2
 9013   FORMAT('NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2 = ',3I8,3(2X,A4))
        CALL DPWRST('XXX','BUG ')
        IF(NPLOTP.GT.0)THEN
          DO9015I=1,NPLOTP
            WRITE(ICOUT,9016)I,Y(I),X(I),D(I)
 9016       FORMAT('I,Y(I),X(I),D(I) = ',I8,3F12.5)
            CALL DPWRST('XXX','BUG ')
 9015     CONTINUE
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPECD2(Y1,X1,N,NUMV,ICASPL,MAXN,
     1                  Y,X,D,NPLOTP,NPLOTV,IBUGG3,ISUBRO,IERROR)
C
C     PURPOSE--GENERATE A PAIR OF COORDINATE VECTORS
C              THAT WILL DEFINE AN EMPIRICAL CDF PLOT
C     INPUT ARGUMENTS--Y1     = THE SINGLE PRECISION VECTOR OF
C                               (UNSORTED) OBSERVATIONS
C                               FOR THE FIRST  VARIABLE.
C                               IF X1 IS SPECIFIED, THEN Y1 BECOMES
C                               A FREQUENCY VARIABLE
C                      X1   = IF SPECIFIED, IT REPRESENTS THE
C                             OBSERVATION POINTS (AND Y1 IS THE
C                             FREQUENCY)
C                      N      = THE INTEGER NUMBER OF OBSERVATIONS
C                               IN THE VECTOR X.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/5
C     ORIGINAL VERSION--MAY       1998.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IBUGG3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION Y1(*)
      DIMENSION X1(*)
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION D(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPEC'
      ISUBN2='D2  '
C
      IERROR='NO'
C
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'ECD2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPECD2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGG3,ISUBRO,IERROR
   52   FORMAT('IBUGG3,ISUBRO,IERROR = ',2(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)ICASPL,N,NUMV,MAXN
   53   FORMAT('ICASPL,N,NUMV,MAXN = ',A4,2X,3I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,Y1(I),X1(I)
   56     FORMAT('I, Y1(I), X1(I), = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(N.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN EMPIRICAL CDF PLOT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,112)
  112   FORMAT('      THE NUMBER OF OBSERVATIONS MUST BE AT LEAST 2.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,114)N
  114   FORMAT('      THE ENTERED NUMBER OF OBSERVATIONS HERE = ',I6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      HOLD=Y1(1)
      DO120I=1,N
        IF(Y1(I).NE.HOLD)GOTO129
  120 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,111)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,122)HOLD
  122 FORMAT('      ALL ELEMENTS IN THE RESPONSE VARIABLE ARE ',
     1       'IDENTICALLY EQUAL TO ',G15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
  129 CONTINUE
C
C               *************************************************
C               **  STEP 12--                                  **
C               **  COMPUTE COORDINATES FOR EMPIRICAL CDF PLOT **
C               **  (INCORPORATE STAIR-STEP APPEARANCE)        **
C               *************************************************
C
      IF(NUMV.EQ.1)THEN
        CALL SORT(Y1,N,Y1)
        J=1
        X(J)=Y1(1)
        Y(J)=0.0
        D(J)=1.0
        J=2
        X(J)=Y1(1)
        Y(J)=1.0/REAL(N)
        D(J)=1.0
        DO200I=2,N
          J=J+1
          X(J)=Y1(I)
          Y(J)=REAL(I-1)/REAL(N)
          D(J)=1.0
          J=J+1
          X(J)=Y1(I)
          Y(J)=REAL(I)/REAL(N)
          D(J)=1.0
  200   CONTINUE
      ELSE
C
C       NOTE: THIS SECTION NEEDS TO BE FIXED.
C
        DO300I=1,N
          X1(I)=HOLD
          X1(I)=Y1(I)
          Y1(I)=HOLD
  300   CONTINUE
C
        CALL SORTC(X1,Y1,N,X1,Y1)
        IWRITE='OFF'
        CALL SUMDP(Y1,N,IWRITE,YSUM,IBUGG3,IERROR)
        CALL CUMSUM(Y1,N,IWRITE,Y1,IBUGG3,IERROR)
        J=1
        X(J)=X1(1)
        Y(J)=0.0
        D(J)=1.0
        J=2
        X(J)=X1(1)
        Y(J)=Y1(1)/REAL(YSUM)
        D(J)=1.0
        DO310I=2,N
          J=J+1
          X(J)=X1(I)
          Y(J)=Y1(I-1)/YSUM
          D(J)=1.0
          J=J+1
          X(J)=X1(I)
          Y(J)=Y1(I)/YSUM
          D(J)=1.0
  310   CONTINUE
      ENDIF
C
      NPLOTP=J
      NPLOTV=2
      GOTO9000
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'ECD2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPECD2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGG3,ISUBRO,IERROR
 9012   FORMAT('IBUGG3,ISUBRO,IERROR = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9021)NPLOTP,NPLOTV
 9021   FORMAT('NPLOTP,NPLOTV = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9022I=1,NPLOTP
          WRITE(ICOUT,9023)I,Y(I),X(I),D(I)
 9023     FORMAT('I,Y(I),X(I),D(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
 9022   CONTINUE
      ENDIF
C
      RETURN
      END
