      SUBROUTINE DPSORT(X,N,Y)
C
C     ***** NOTE--THIS SUBROUTINE IS IDENTICAL TO THE SUBROUTINE SORT
C                 AND HAS BEEN REPRODUCED TO FACILITATE EXECUTION EFFICIENCY.
C
C     PURPOSE--THIS SUBROUTINE SORTS (IN ASCENDING ORDER)
C              THE N ELEMENTS OF THE SINGLE PRECISION VECTOR X
C              AND PUTS THE RESULTING N SORTED VALUES INTO THE
C              SINGLE PRECISION VECTOR Y.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                OBSERVATIONS TO BE SORTED.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C     OUTPUT ARGUMENTS--Y      = THE SINGLE PRECISION VECTOR
C                                INTO WHICH THE SORTED DATA VALUES
C                                FROM X WILL BE PLACED.
C     OUTPUT--THE SINGLE PRECISION VECTOR Y
C             CONTAINING THE SORTED
C             (IN ASCENDING ORDER) VALUES
C             OF THE SINGLE PRECISION VECTOR X.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THE DIMENSIONS OF THE VECTORS IL AND IU
C                   (DEFINED AND USED INTERNALLY WITHIN
C                   THIS SUBROUTINE) DICTATE THE MAXIMUM
C                   ALLOWABLE VALUE OF N FOR THIS SUBROUTINE.
C                   IF IL AND IU EACH HAVE DIMENSION K,
C                   THEN N MAY NOT EXCEED 2**(K+1) - 1.
C                   FOR THIS SUBROUTINE AS WRITTEN, THE DIMENSIONS
C                   OF IL AND IU HAVE BEEN SET TO 36,
C                   THUS THE MAXIMUM ALLOWABLE VALUE OF N IS
C                   APPROXIMATELY 137 BILLION.
C                   SINCE THIS EXCEEDS THE MAXIMUM ALLOWABLE
C                   VALUE FOR AN INTEGER VARIABLE IN MANY COMPUTERS,
C                   AND SINCE A SORT OF 137 BILLION ELEMENTS
C                   IS PRESENTLY IMPRACTICAL AND UNLIKELY,
C                   THEN THERE IS NO PRACTICAL RESTRICTION
C                   ON THE MAXIMUM VALUE OF N FOR THIS SUBROUTINE.
C                   (IN LIGHT OF THE ABOVE, NO CHECK OF THE
C                   UPPER LIMIT OF N HAS BEEN INCORPORATED
C                   INTO THIS SUBROUTINE.)
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     COMMENT--THE SMALLEST ELEMENT OF THE VECTOR X
C              WILL BE PLACED IN THE FIRST POSITION
C              OF THE VECTOR Y,
C              THE SECOND SMALLEST ELEMENT IN THE VECTOR X
C              WILL BE PLACED IN THE SECOND POSITION
C              OF THE VECTOR Y, ETC.
C     COMMENT--THE INPUT VECTOR X REMAINS UNALTERED.
C     COMMENT--IF THE ANALYST DESIRES A SORT 'IN PLACE',
C              THIS IS DONE BY HAVING THE SAME
C              OUTPUT VECTOR AS INPUT VECTOR IN THE CALLING SEQUENCE.
C              THUS, FOR EXAMPLE, THE CALLING SEQUENCE
C              CALL DPSORT(X,N,X)
C              IS ALLOWABLE AND WILL RESULT IN
C              THE DESIRED 'IN-PLACE' SORT.
C     COMMENT--THE SORTING ALGORTHM USED HEREIN
C              IS THE  QUICKSORT.
C              THIS ALGORTHIM IS EXTREMELY FAST AS THE
C              FOLLOWING TIME TRIALS INDICATE.
C              THESE TIME TRIALS WERE CARRIED OUT ON THE
C              UNIVAC 1108 EXEC 8 SYSTEM AT NBS
C              IN AUGUST OF 1974.
C              BY WAY OF COMPARISON, THE TIME TRIAL VALUES
C              FOR THE EASY-TO-PROGRAM BUT EXTREMELY
C              INEFFICIENT BUBBLE SORT ALGORITHM HAVE
C              ALSO BEEN INCLUDED--
C              NUMBER OF RANDOM         QUICKSORT       BUBBLE SORT
C               NUMBERS SORTED
C                N = 10                 .002 SEC          .002 SEC
C                N = 100                .011 SEC          .045 SEC
C                N = 1000               .141 SEC         4.332 SEC
C                N = 3000               .476 SEC        37.683 SEC
C                N = 10000             1.887 SEC      NOT COMPUTED
C     REFERENCES--CACM MARCH 1969, PAGE 186 ( QUICKSORT ALGORITHM
C                 BY RICHARD C. SINGLETON).
C               --CACM JANUARY 1970, PAGE 54.
C               --CACM OCTOBER 1970, PAGE 624.
C               --JACM JANUARY 1961, PAGE 41.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION--JUNE      1972.
C     UPDATED         --NOVEMBER  1975.
C     UPDATED         --JUNE      1981.
C     UPDATED         --AUGUST    1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION Y(*)
C
      DIMENSION IU(36)
      DIMENSION IL(36)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPSO'
      ISUBN2='RT  '
C
      IERROR='NO'
      IBUGA3='OFF'
C
      IF(IBUGA3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF SORT--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGA3
   52 FORMAT('IBUGA3 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)N
   53 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,N
      WRITE(ICOUT,56)I,X(I)
   56 FORMAT('I,X(I) = ',I8,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
   90 CONTINUE
C
C               ************************
C               **  SORT THE VALUES.  **
C               ************************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(N.GE.1)GOTO119
      IERROR='YES'
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,111)
  111 FORMAT('***** ERROR IN SORT--',
     1'THE SECOND INPUT ARGUMENT (N) IS SMALLER THAN 1')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,118)N
  118 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
      CALL DPWRST('XXX','BUG ')
      GOTO9000
  119 CONTINUE
C
      IF(N.EQ.1)GOTO120
      GOTO129
  120 CONTINUE
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,121)
  121 FORMAT('***** NON-FATAL DIAGNOSTIC IN SORT--',
     1'THE SECOND INPUT ARGUMENT (N) HAS THE VALUE 1')
CCCCC CALL DPWRST('XXX','BUG ')
      Y(1)=X(1)
      GOTO9000
  129 CONTINUE
C
      HOLD=X(1)
      DO135I=2,N
      IF(X(I).NE.HOLD)GOTO139
  135 CONTINUE
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,136)HOLD
  136 FORMAT('***** NON-FATAL DIAGNOSTIC IN SORT--',
     1'THE FIRST INPUT ARGUMENT (A VECTOR) HAS ALL ELEMENTS = ',E15.7)
CCCCC CALL DPWRST('XXX','BUG ')
      DO137I=1,N
      Y(I)=X(I)
  137 CONTINUE
      GOTO9000
  139 CONTINUE
C
  190 CONTINUE
C
C               *******************************************
C               **  STEP 2--                             **
C               **  COPY THE VECTOR X INTO THE VECTOR Y  **
C               *******************************************
C
      DO200I=1,N
      Y(I)=X(I)
  200 CONTINUE
C
C               **********************************************************
C               **  STEP 3--                                            **
C               **  CHECK TO SEE IF THE INPUT VECTOR IS ALREADY SORTED  **
C               **********************************************************
C
      NM1=N-1
      DO250I=1,NM1
      IP1=I+1
      IF(Y(I).LE.Y(IP1))GOTO250
      GOTO290
  250 CONTINUE
      GOTO9000
  290 CONTINUE
C
C               ***************************
C               **  STEP 4--             **
C               **  CARRY OUT THE SORT.  **
C               ***************************
C
      M=1
      I=1
      J=N
  305 IF(I.GE.J)GOTO370
  310 K=I
      MID=(I+J)/2
      AMED=Y(MID)
      IF(Y(I).LE.AMED)GOTO320
      Y(MID)=Y(I)
      Y(I)=AMED
      AMED=Y(MID)
  320 L=J
      IF(Y(J).GE.AMED)GOTO340
      Y(MID)=Y(J)
      Y(J)=AMED
      AMED=Y(MID)
      IF(Y(I).LE.AMED)GOTO340
      Y(MID)=Y(I)
      Y(I)=AMED
      AMED=Y(MID)
      GOTO340
  330 Y(L)=Y(K)
      Y(K)=TT
  340 L=L-1
      IF(Y(L).GT.AMED)GOTO340
      TT=Y(L)
  350 K=K+1
      IF(Y(K).LT.AMED)GOTO350
      IF(K.LE.L)GOTO330
      LMI=L-I
      JMK=J-K
      IF(LMI.LE.JMK)GOTO360
      IL(M)=I
      IU(M)=L
      I=K
      M=M+1
      GOTO380
  360 IL(M)=K
      IU(M)=J
      J=L
      M=M+1
      GOTO380
  370 M=M-1
      IF(M.EQ.0)GOTO9000
      I=IL(M)
      J=IU(M)
  380 JMI=J-I
      IF(JMI.GE.11)GOTO310
      IF(I.EQ.1)GOTO305
      I=I-1
  390 I=I+1
      IF(I.EQ.J)GOTO370
      AMED=Y(I+1)
      IF(Y(I).LE.AMED)GOTO390
      K=I
  395 Y(K+1)=Y(K)
      K=K-1
      IF(AMED.LT.Y(K))GOTO395
      Y(K+1)=AMED
      GOTO390
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
C
      IF(IBUGA3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF SORT--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGA3,IERROR
 9012 FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)N
 9013 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9015I=1,N
      WRITE(ICOUT,9016)I,X(I),Y(I)
 9016 FORMAT('I,X(I),Y(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
 9015 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPSP(NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2,
CCCCC1TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,MAXNXT,
     1MAXNXT,
CCCCC JULY 2002.  ADD ISEED FOR HODGES-LEHMAN PLOT
     1ISEED,
     1ICONT,ISUBRO,IBUGG2,IBUGG3,IBUGQ,IFOUND,IERROR)
C
C     PURPOSE--GENERATE ONE OF THE FOLLOWING STATISTIC PLOTS--
C                 MEAN STATISTIC PLOT
C                 MIDM STATISTIC PLOT
C                 MEDI STATISTIC PLOT
C                 SD STATISTIC PLOT
C                 REL SD STATISTIC PLOT
C                 COEFFICIENT OF VARIATION STATISTIC PLOT
C                 SD MEAN STATISTIC PLOT
C                 VARI STATISTIC PLOT
C                 REL VARI STATISTIC PLOT
C                 VARI MEAN STATISTIC PLOT
C                 VARIANCE LP LOCATION STATISTIC PLOT
C                 SD LP LOCATION STATISTIC PLOT
C                 RANG STATISTIC PLOT
C                 MINI STATISTIC PLOT
C                 MAXI STATISTIC PLOT
C                 EXTREME STATISTIC PLOT
C                 INDEX MINIMUM STATISTIC PLOT
C                 INDEX MAXIMUM STATISTIC PLOT
C                 INDEX EXTREME STATISTIC PLOT
C                 SKEW STATISTIC PLOT
C                 KURT STATISTIC PLOT
C                 AUCR STATISTIC PLOT
C                 SDM STATISTIC PLOT
C                 AUCV STATISTIC PLOT
C                 RACV STATISTIC PLOT
C                 LOWH STATISTIC PLOT
C                 UPPH STATISTIC PLOT
C                 LOWQ STATISTIC PLOT
C                 UPPQ STATISTIC PLOT
C                 TRIM STATISTIC PLOT
C                 WINM STATISTIC PLOT
C                 MIDQ STATISTIC PLOT
C                 1DEC STATISTIC PLOT
C                 2DEC STATISTIC PLOT
C                 3DEC STATISTIC PLOT
C                 4DEC STATISTIC PLOT
C                 5DEC STATISTIC PLOT
C                 6DEC STATISTIC PLOT
C                 7DEC STATISTIC PLOT
C                 8DEC STATISTIC PLOT
C                 9DEC STATISTIC PLOT
C                 SINE FREQUENCY STATISTIC PLOT
C                 SINE AMPLITUDE STATISTIC PLOT
C                 TAGUCHI SIGNAL-TO-NOISE PLOTS
C                 CP PLOT
C                 CPL PLOT
C                 CPU PLOT
C                 CPK PLOT
C                 CPM PLOT
C                 CC PLOT
C                 CNPK PLOT
C                 PERCENT DEFECTIVE PLOT
C                 EXPECTED LOSS PLOT
C                 NORM PPCC STATISTIC PLOT
C                 AAD PLOT
C                 MAD PLOT
C                 SN PLOT
C                 QN PLOT
C                 PERCENTILE PLOT
C                 GEOMETRIC MEAN PLOT
C                 GEOMETRIC STANDARD DEVIATION PLOT
C                 HARMONIC MEAN PLOT
C                 INTERQUARTILE RANGE PLOT
C                 BIWEIGHT LOCATION PLOT
C                 BIWEIGHT SCALE PLOT
C                 WINSORIZED VARIANCE PLOT
C                 WINSORIZED SD PLOT
C                 BIWEIGHT MIDVARIANCE PLOT
C                 PERCENTAGE BEND MIDVARIANCE PLOT
C                 HODGES LEHMAN PLOT
C                 LP LOCATION PLOT
C                 QUANTILE PLOT
C                 QUANTILE STANDARD ERROR PLOT
C                 TRIMMED MEAN STANDARD ERROR PLOT
C                 TRIMMED STANDARD DEVIATION PLOT
C
C                 BINOMIAL PROBABILITY
C
C                 GRUBB STATISTIC PLOT
C                 GRUBB CDF STATISTIC PLOT
C                 GRUBB DIRECTION STATISTIC PLOT
C                 GRUBB INDEX STATISTIC PLOT
C                 ONE SAMPLE T-TEST STATISTIC PLOT
C                 ONE SAMPLE T-TEST CDF STATISTIC PLOT
C                 CHI-SQUARE SD TEST STATISTIC PLOT
C                 CHI-SQUARE SD TEST CDF STATISTIC PLOT
C                 FREQUENCY STATISTIC PLOT
C                 FREQUENCY CDF STATISTIC PLOT
C                 FREQUENCY WITHIN A BLOCK TEST STATISTIC PLOT
C                 FREQUENCY WITHIN A BLOCK TEST CDF STATISTIC PLOT
C
C                 FOLLOWING REQUIRE TWO RESPONSE VARIABLES
C                 COVARIANCE PLOT
C                 RANK COVARIANCE PLOT
C                 CORRELATION PLOT
C                 RANK CORRELATION PLOT
C                 KENDELL TAU PLOT
C                 COMOVEMENT PLOT
C                 RANK COMOVEMENT PLOT
C                 WINSORIZED COVARIANCE PLOT
C                 WINSORIZED CORRELATION PLOT
C                 BIWEIGHT MIDCOVARIANCE PLOT
C                 BIWEIGHT MIDCORRELATION PLOT
C                 PERCENTAGE BEND CORRELATION PLOT
C                 LINEAR INTERCEPT STATISTIC PLOT
C                 LINEAR SLOPE STATISTIC PLOT
C                 LINEAR RESSD STATISTIC PLOT
C                 LINEAR CORRELATION STATISTIC PLOT
C                 REPEATABILITY SD STATISTIC PLOT
C                 REPRODUCABILITY SD STATISTIC PLOT
C                 WEIGHTED MEAN PLOT
C                 WEIGHTED SD PLOT
C                 WEIGHTED VARIANCE PLOT
C                 WEIGHTED TRIMMED MEAN PLOT
C                 RATIO PLOT
C                 ODDS RATIO PLOT
C                 ODDS RATIO STANDARD ERROR PLOT
C                 LOG ODDS RATIO PLOT
C                 LOG ODDS RATIO STANDARD ERROR PLOT
C                 RELATIVE RISK PLOT
C                 CRAMER CONTINGENCY COEFFICIENT PLOT
C                 PEARSON CONTINGENCY COEFFICIENT PLOT
C                 FALSE POSITIVE PLOT
C                 FALSE NEGATIVE PLOT
C                 TRUE POSITIVE PLOT
C                 TRUE NEGATIVE PLOT
C                 TEST SENSITIVITY PLOT
C                 TEST SPECIFICITY PLOT
C                 POSITIVE PREDICTIVE VALUE PLOT
C                 NEGATIVE PREDICTIVE VALUE PLOT
C
C                 FOLLOWING STATISTICS COMPUTE DIFFERENCE IN
C                 STATISTIC FOR TWO RESPONSE VARIABLES (USED FOR
C                 LOCATION AND SCALE STATISTICS):
C   
C                 LOCATION:
C                 DIFFERENCE OF MEANS PLOT X1 X2
C                 DIFFERENCE OF MIDMEANS PLOT X1 X2
C                 DIFFERENCE OF MEDIANS PLOT X1 X2
C                 DIFFERENCE OF TRIMMED MEANS PLOT X1 X2
C                 DIFFERENCE OF WINSORIZED MEANS PLOT X1 X2
C                 DIFFERENCE OF GEOMETRIC MEANS PLOT X1 X2
C                 DIFFERENCE OF HARMONIC MEANS PLOT X1 X2
C                 DIFFERENCE OF HODGES-LEHMAN PLOT X1 X2
C                 DIFFERENCE OF BIWEIGHT LOCATION PLOT X1 X2
C                 DIFFERENCE OF LP LOCATION PLOT X1 X2
C   
C                 SCALE:
C                 DIFFERENCE OF STANDARD DEVIATIONS PLOT X1 X2
C                 DIFFERENCE OF VARIANCES PLOT X1 X2
C                 DIFFERENCE OF AAD PLOT X1 X2
C                 DIFFERENCE OF MAD PLOT X1 X2
C                 DIFFERENCE OF SN PLOT X1 X2
C                 DIFFERENCE OF QN PLOT X1 X2
C                 DIFFERENCE OF INTERQUARTILE RANGE PLOT X1 X2
C                 DIFFERENCE OF WINSORIZED SD PLOT X1 X2
C                 DIFFERENCE OF WINSORIZED VARIANCE PLOT X1 X2
C                 DIFFERENCE OF BIWEIGHT MIDVARIANCE PLOT X1 X2
C                 DIFFERENCE OF BIWEIGHT SCALE PLOT X1 X2
C                 DIFFERENCE OF PERCENTAGE BEND PLOT X1 X2
C                 DIFFERENCE OF GEOMETRIC SD PLOT X1 X2
C                 DIFFERENCE OF RANGE PLOT X1 X2
C                 DIFFERENCE OF MIDRANGE PLOT X1 X2
C                 DIFFERENCE OF QUANTILE PLOT X1 X2
C                 DIFFERENCE OF SKEWNESS PLOT X1 X2
C                 DIFFERENCE OF KURTOSIS PLOT X1 X2
C                 DIFFERENCE OF RELATIVE SD PLOT X1 X2
C                 DIFFERENCE OF SD OF MEAN PLOT X1 X2
C                 DIFFERENCE OF RELATIVE VARIANCE PLOT X1 X2
C                 DIFFERENCE OF VARIANCE OF THE MEAN PLOT X1 X2
C                 DIFFERENCE OF MINIMUM PLOT X1 X2
C                 DIFFERENCE OF MAXIMUM PLOT X1 X2
C                 DIFFERENCE OF EXTREMES PLOT X1 X2
C                 DIFFERENCE OF COEFFICENT OF VARI PLOT X1 X2
C                 DIFFERENCE OF COUNTS PLOT X1 X2
C                 DIFFERENCE OF SUM PLOT X1 X2
C                 DIFFERENCE OF VARIANCE OF LP LOCATION PLOT X1 X2
C                 DIFFERENCE OF SD OF LP LOCATION PLOT X1 X2
C
C                 MISCELLANEOUS:
C                 DIFFERENCE OF BINOMIAL PROBABILITY PLOT X1 X2
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--88/1
C     ORIGINAL VERSION--JANUARY   1988.
C     UPDATED         --MARCH     1988.  LINEAR INTERCEPT & SLOPE PLOTS
C     UPDATED         --MARCH     1988.  LINEAR RESSD AND CORRELATION PLOTS
C     UPDATED         --AUGUST    1988.  TAGUCHI SIGNAL-TO-NOISE PLOTS
C     UPDATED         --MAY       1989.  CAN OMIT 'TAGUCHI' IN SN.. PLOTS
C     UPDATED         --JUNE      1990. TEMPORARY ARRAYS TO GARBAGE COMMON
C     UPDATED         --SEPTEMBER 1992. FIX DEBUG SECTION AT EXIT
C     UPDATED         --SEPTEMBER 1993. CP PLOT
C     UPDATED         --SEPTEMBER 1993. CPK PLOT
C     UPDATED         --SEPTEMBER 1993. PERCENT DEFECTIVE PLOT
C     UPDATED         --SEPTEMBER 1993. EXPECTED LOSS PLOT
C     UPDATED         --DECEMBER  1993. SYNONYMS FOR TAGUCHI S/N PLOTS
C     UPDATED         --FEBRUARY  1994. CHANGE ICASPL: SDM => SDME
C     UPDATED         --FEBRUARY  1994. CHANGE ICASPL: VM => VAME
C     UPDATED         --FEBRUARY  1994. CHANGE ICASPL: RSD => RESD
C     UPDATED         --FEBRUARY  1994. CHANGE ICASPL: RVAR => REVA
C     UPDATED         --FEBRUARY  1994. ALLOW SD MEAN
C     UPDATED         --FEBRUARY  1994. ADD VARI OF MEAN
C     UPDATED         --FEBRUARY  1994. ADD EXTREME
C     UPDATED         --FEBRUARY  1994. ADD NORMAL PPCC
C     UPDATED         --MARCH     1994. WINSORIZED MEAN AS SYNONYM TO
C                                       WINDSORIZED MEAN.
C     UPDATED         --MARCH     1995. ADD AAD AND MAD
C     UPDATED         --JANUARY   1998. NAME CONFLICT FOR MINIMUM AND
C                                       MAXIMUM WITH BLOCK PLOT
C     UPDATED         --NOVEMBER  1998. ADD PERCENTILE PLOT
C     UPDATED         --NOVEMBER  1998. ADD CPM PLOT, CC PLOT
C     UPDATED         --MARCH     1999. ADD GEOMETRIC MEAN PLOT
C     UPDATED         --MARCH     1999. ADD GEOMETRIC STANDARD DEVIATION PLOT
C     UPDATED         --MARCH     1999. ADD HARMONIC MEAN PLOT
C     UPDATED         --OCTOBER   1999. SAVE INTERNAL PARAMETER
C                                       ALOWHIGH
C     UPDATED         --APRIL     2001. ADD CPL PLOT, CPU PLOT
C     UPDATED         --SEPTEMBER 2001. ADD IQ RANGE PLOT
C     UPDATED         --NOVEMBER  2001. ADD BIWEIGHT LOCATION PLOT
C     UPDATED         --NOVEMBER  2001. ADD BIWEIGHT SCALE PLOT
C     UPDATED         --JULY      2002. ADD WINSORIZED VARIANCE PLOT
C     UPDATED         --JULY      2002. ADD WINSORIZED SD PLOT
C     UPDATED         --JULY      2002. ADD WINSORIZED COVARIANCE PLOT
C     UPDATED         --JULY      2002. ADD WINSORIZED CORRELATION PLOT
C     UPDATED         --JULY      2002. ADD BIWEIGHT MIDVARIANCE PLOT
C     UPDATED         --JULY      2002. ADD BIWEIGHT MIDCOVARIANCE PLOT
C     UPDATED         --JULY      2002. ADD BIWEIGHT MIDCORRELATION PLOT
C     UPDATED         --JULY      2002. ADD PERCENTAGE BEND MIDVARIANCE
C                                           PLOT
C     UPDATED         --JULY      2002. ADD PERCENTAGE BEND CORRELATION
C                                           PLOT
C     UPDATED         --JULY      2002. ADD HODGES LEHMAN PLOT
C     UPDATED         --JULY      2002. ADD QUANTILE PLOT
C     UPDATED         --JULY      2002. ADD QUANTILE STANDARD ERROR PLOT
C     UPDATED         --JULY      2002. ADD TRIMMED MEAN STANDARD ERROR
C                                           PLOT
C     UPDATED         --MARCH     2003. ADD 35 "DIFFERENCE OF" STATISTICS
C     UPDATED         --MARCH     2003. ADD WEIGHTED MEAN, WEIGHTED SD,
C                                       WEIGHTED VARIANCE
C     UPDATED         --APRIL     2003. ADD SN AND QN (AND DIFFERENCE
C                                       OF), REQUIRED ADDITIONAL
C                                       SCRATCH ARRAYS
C     UPDATED         --MAY       2003. ADD WEIGHTED TRIMMED MEAN
C     UPDATED         --OCTOBER   2004. ADD KENDELL TAU
C     UPDATED         --FEBRUARY  2005. ADD REPEATABILITY SD
C     UPDATED         --FEBRUARY  2005. ADD REPRODUCABILITY SD
C     UPDATED         --SEPTEMBER 2005. ADD RATIO (SUM1/SUM2)
C     UPDATED         --MARCH     2007. ADD RELATIVE RISK
C     UPDATED         --MARCH     2007. ADD CRAMER CONTINGENCY COEFFICIENT
C     UPDATED         --MARCH     2007. ADD PEARSON CONTINGENCY COEFFICIENT
C     UPDATED         --MARCH     2007. ADD FALSE POSITIVE
C     UPDATED         --MARCH     2007. ADD FALSE NEGATIVE
C     UPDATED         --MARCH     2007. ADD TRUE POSITIVE
C     UPDATED         --MARCH     2007. ADD TRUE NEGATIVE
C     UPDATED         --MARCH     2007. ADD TEST SENSITIVITY
C     UPDATED         --MARCH     2007. ADD TEST SPECIFICITY
C     UPDATED         --APRIL     2007. ADD POSITIVE PREDICTIVE VALUE
C     UPDATED         --APRIL     2007. ADD NEGATIVE PREDICTIVE VALUE
C     UPDATED         --APRIL     2007. ADD LOG ODDS RATIO
C     UPDATED         --APRIL     2007. ADD LOG ODDS RATIO
C                                           STANDARD ERROR
C     UPDATED         --MAY       2007. ADD TRIMMED STANDARD DEVIATION
C     UPDATED         --AUGUST    2007. MOVE STORAGE OF SEVERAL
C                                       ARRAYS FROM MAINGR TO COMMON
C     UPDATED         --NOVEMBER  2007. DOUBLE PRECISION ARRAYS FOR
C                                       CMPSTA
C     UPDATED         --NOVEMBER  2007. ADD LP LOCATION
C     UPDATED         --NOVEMBER  2007. ADD VARIANCE OF LP LOCATION
C     UPDATED         --NOVEMBER  2007. ADD SD OF LP LOCATION
C     UPDATED         --NOVEMBER  2007. ADD DIFFERENCE OF LP LOCATION
C     UPDATED         --NOVEMBER  2007. ADD DIFFERENCE OF VARIANCE OF
C                                           LP LOCATION
C     UPDATED         --NOVEMBER  2007. ADD DIFFERENCE OF SD OF
C                                           LP LOCATION
C     UPDATED         --SEPTEMBER 2008. ADD BINOMIAL PROBABILITY
C     UPDATED         --SEPTEMBER 2008. ADD DIFFERENCE OF BINOMIAL
C                                           PROBABILITY
C     UPDATED         --FEBRUARY  2009. ADD INDEX MINIMUM
C     UPDATED         --FEBRUARY  2009. ADD INDEX MAXIMUM
C     UPDATED         --FEBRUARY  2009. ADD INDEX EXTREME
C     UPDATED         --FEBRUARY  2009. ADD GRUBB
C     UPDATED         --FEBRUARY  2009. ADD GRUBB CDF
C     UPDATED         --FEBRUARY  2009. ADD GRUBB DIRECTION
C     UPDATED         --FEBRUARY  2009. ADD GRUBB INDEX
C     UPDATED         --FEBRUARY  2009. ADD:
C                                       ONE SAMPLE T-TEST,
C                                       ONE SAMPLE T-TEST CDF,
C                                       CHI-SQUARE SD TEST,
C                                       CHI-SQUARE SD TEST CDF,
C                                       FREQUENCY TEST,
C                                       FREQUENCY TEST CDF,
C                                       FREQUENCY WITHIN A BLOCK TEST,
C                                       FREQUENCY WITHIN A BLOCK TEST CDF
C     UPDATED         --MARCH     2009. SUPPORT FOR MULTIPLE RESPONSE
C                                       VARIABLES
C     UPDATED         --MARCH     2009. UPDATE PARSING:
C                                       1) USE "EXTSTA"
C                                       2) USE DPPARS
C     UPDATED         --MARCH     2009. "Z-SCORE" AND "U-SCORE"
C                                       OPTIONS
C     UPDATED         --JUNE      2010. CMPSTA SUPPORTS 3-VARIABLE
C                                       STATISTICS
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IAND1
      CHARACTER*4 IAND2
      CHARACTER*4 ICONT
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGG2
      CHARACTER*4 IBUGG3
      CHARACTER*4 IBUGQ
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 ICASEQ
      CHARACTER*4 IERRO2
C
      CHARACTER*4 IH
      CHARACTER*4 IH2
C
      PARAMETER (MAXSPN=30)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
      CHARACTER*40 INAME
      CHARACTER*60 ISTANM
      CHARACTER*4  ISTADF
C
      CHARACTER*4 ISUBN0
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
C
      DIMENSION XTEMP3(MAXOBV)
C
      DIMENSION TEMP(MAXOBV)
      DIMENSION TEMP2(MAXOBV)
      DIMENSION TEMP3(MAXOBV)
      DIMENSION TEMP4(MAXOBV)
      DIMENSION XTEMP1(MAXOBV)
      DIMENSION XTEMP2(MAXOBV)
C
      PARAMETER (MAXRES=25)
      DIMENSION Z(MAXOBV,MAXRES)
C
      INCLUDE 'DPCOZ2.INC'
      EQUIVALENCE (G2RBAG(IGAR11),XTEMP3(1))
      EQUIVALENCE (G2RBAG(IGAR12),TEMP(1))
      EQUIVALENCE (G2RBAG(IGAR13),TEMP2(1))
      EQUIVALENCE (G2RBAG(IGAR14),TEMP3(1))
      EQUIVALENCE (G2RBAG(IGAR15),XTEMP1(1))
      EQUIVALENCE (G2RBAG(IGAR16),XTEMP2(1))
      EQUIVALENCE (G2RBAG(IGAR17),TEMP4(1))
      EQUIVALENCE (G2RBAG(IGAR18),Z(1,1))
C
CCCCC JULY 2002. ADD INTEGER ARRAYS FOR HODGES-LEHMAN PLOT.
      INCLUDE 'DPCOZI.INC'
      INCLUDE 'DPCOZD.INC'
C
      INTEGER ITEMP1(MAXOBV)
      INTEGER ITEMP2(MAXOBV)
      INTEGER ITEMP3(MAXOBV)
      INTEGER ITEMP4(MAXOBV)
      INTEGER ITEMP5(MAXOBV)
      INTEGER ITEMP6(MAXOBV)
      EQUIVALENCE (IGARBG(IIGAR1),ITEMP1(1))
      EQUIVALENCE (IGARBG(IIGAR2),ITEMP2(1))
      EQUIVALENCE (IGARBG(IIGAR3),ITEMP3(1))
      EQUIVALENCE (IGARBG(IIGAR4),ITEMP4(1))
      EQUIVALENCE (IGARBG(IIGAR5),ITEMP5(1))
      EQUIVALENCE (IGARBG(IIGAR6),ITEMP6(1))
C
      DOUBLE PRECISION DTEMP1(MAXOBV)
      DOUBLE PRECISION DTEMP2(MAXOBV)
      DOUBLE PRECISION DTEMP3(MAXOBV)
      EQUIVALENCE (DGARBG(IDGAR1),DTEMP1(1))
      EQUIVALENCE (DGARBG(IDGAR2),DTEMP2(1))
      EQUIVALENCE (DGARBG(IDGAR3),DTEMP3(1))
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOHO.INC'
      INCLUDE 'DPCOST.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='NO'
C
      ISUBN1='DPSP'
      ISUBN2='    '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      MINN2=2
C
C               ************************************
C               **  TREAT THE STATISTIC PLOT CASE  **
C               ************************************
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DPSP')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSP--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)ICONT,ISUBRO,IBUGG2,IBUGG3,IBUGQ
   52   FORMAT('ICONT,ISUBRO,IBUGG2,IBUGG3,IBUGQ  = ',
     1         A4,2X,A4,2X,A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)ICASPL,IAND1,IAND2,NUMARG
   53   FORMAT('ICASPL,IAND1,IAND2 = ',A4,2X,A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMARG
          WRITE(ICOUT,57)I,IHARG(I),IHARG2(I)
   57     FORMAT('I,IHARG(I),IHARG2(I) = ',I8,2X,A4,2X,A4)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ***************************
C               **  STEP 1--             **
C               **  EXTRACT THE COMMAND  **
C               ***************************
C
      ISTEPN='1'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DPSP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.1)GOTO9000
C
C     EXTRACT THE DESIRED STATISTIC
C
C       2013/04: CHECK FOR CONFLICT BETWEEN "QUANTILE PLOT" AND
C                "QUANTILE-QUANTILE PLOT".
C
      IF(ICOM.EQ.'QUAN' .AND. IHARG(1).EQ.'QUAN')GOTO9000
C
      JMIN=0
      JMAX=NUMARG
      IFLAGZ=0
      IFLAGU=0
C
      DO200I=1,NUMARG
        IF(IHARG(I).EQ.'PLOT')THEN
          IF(JMAX.EQ.NUMARG)JMAX=I-1
          ILASTC=I
          GOTO209
C
C       2013/01: NOTE THE COMMANDS
C
C                  TUKEY LAMBDA PPCC STATISTIC PLOT
C                  WEIBULL      PPCC STATISTIC PLOT
C
C                NEED TO INCLUDE THE "STATISTIC" IN ORDER TO
C                DISTINGUISH THEM FROM THE STANDARD PPCC PLOT
C                CASE.  SO CHECK FOR THE WORD "PPCC".
C
C       2013/04: CHECK FOR CONFLICT BETWEEN "QUANTILE PLOT" AND
C                "QUANTILE-QUANTILE PLOT".
C
        ELSEIF(I.LT.NUMARG.AND.IHARG(I).EQ.'STAT'.AND.
     1         IHARG(I+1).EQ.'PLOT')THEN
          IF(IHARG(I-1).EQ.'PPCC')THEN
            IF(JMAX.EQ.NUMARG)JMAX=I
          ELSE
            IF(JMAX.EQ.NUMARG)JMAX=I-1
          ENDIF
          ILASTC=I+1
          GOTO209
        ELSEIF(IHARG(I).EQ.'ZSCO')THEN
          JMAX=I-1
          IFLAGZ=1
        ELSEIF(I.LT.NUMARG.AND.IHARG(I).EQ.'Z   '.AND.
     1         IHARG(I+1).EQ.'SCOR')THEN
          JMAX=I-1
          IFLAGZ=1
        ELSEIF(IHARG(I).EQ.'USCO')THEN
          JMAX=I-1
          IFLAGU=1
        ELSEIF(I.LT.NUMARG.AND.IHARG(I).EQ.'U   '.AND.
     1         IHARG(I+1).EQ.'SCOR')THEN
          JMAX=I-1
          IFLAGU=1
        ELSEIF(I.GT.1 .AND. IHARG(I).EQ.'QUAN'.AND.
     1         IHARG(I-1).EQ.'QUAN')THEN
          GOTO9000
        ENDIF
  200 CONTINUE
      GOTO9000
  209 CONTINUE
C
      CALL EXTSTA(ICOM,ICOM2,IHARG,IHARG2,IARGT,ARG,NUMARG,JMIN,JMAX,
     1            ICASPL,ISTANM,ISTANR,ISTADF,IFOUND,ILOCV,
     1            ISUBRO,IBUGG3,IERROR)
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DPSP')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,251)
  251   FORMAT('***** AFTER CALL EXTSTA--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,252)ICASPL,ISTANR,ILOCV,IFOUND
  252   FORMAT('ICASPL,ISTANR,ILOCV,IFOUND = ',A4,2I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(IFOUND.EQ.'NO')GOTO9000
      CALL ADJUST(ILASTC,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
C
C               *********************************
C               **  STEP 2--                   **
C               **  EXTRACT THE VARIABLE LIST  **
C               *********************************
C
      INAME='STATISTIC PLOT'
      MINNA=1
      MAXNA=100
      MINN2=2
      IFLAGE=1
      IFLAGM=0
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
      MINNVA=-99
      MAXNVA=-99
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGG3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DPSP')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
C     NEED FOLLOWING VARIABLES:
C     1) GROUP-ID VARIABLE
C     2) AT LEAST ONE RESPONSE VARIABLE FOR STATISTICS
C        THAT REQUIRE ONE VARIABLE
C     3) AT LEAST TWO RESPONSE VARIABLES FOR STATISTICS
C        THAT REQUIRE TWO VARIABLES
C     4) AT LEAST THREE RESPONSE VARIABLES FOR STATISTICS
C        THAT REQUIRE THREE VARIABLES
C     IF THE PARAMETER "NI" IS SPECIFIED, THEN IF NUMVAR = MINVAR - 1,
C     THEN WE CAN AUTOMATICALLY CREATE THE GROUP-ID VARIABLE.
C
      ISIZE=-99
      MINVAR=1+ISTANR
      IF(NUMVAR.LT.MINVAR)THEN
C
        IF(NUMVAR.EQ.MINVAR-1)THEN
          IH='NI  '
          IH2='    '
          IHWUSE='P'
          MESSAG='NO'
          CALL CHECKN(IH,IH2,IHWUSE,
     1              IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1              ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERRO2)
          IF(IERROR.EQ.'NO')THEN
            ISIZE=VALUE(ILOCP)+0.5
            GOTO219
          ENDIF
        ENDIF
C
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,211)ISTANA
  211   FORMAT('***** ERROR IN ',A60,'PLOT COMMAND--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,212)MINVAR
  212   FORMAT('      AT LEAST ',I5,' VARIABLES REQUIRED, BUT ONLY')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,213)NUMVAR
  213   FORMAT('      ',I8,' VARIABLES WERE GIVEN.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,215)
  215   FORMAT('      THE ENTERED COMMAND LINE WAS AS FOLLOWS--')
        CALL DPWRST('XXX','BUG ')
        IF(IWIDTH.GE.1)THEN
          WRITE(ICOUT,216)(IANS(J),J=1,MIN(80,IWIDTH))
  216     FORMAT('      ',80A1)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
      ENDIF
C
  219 CONTINUE
C
      IF(ISTANR.EQ.2 .AND. MOD(NUMVAR-1,2).EQ.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,211)ISTANA
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,222)
  222   FORMAT('      THE NUMBER OF RESPONSE VARIABLES IS EVEN, BUT')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,223)
  223   FORMAT('      IT SHOULD BE ODD WHEN THE STATISTIC REQUIRES')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,224)
  224   FORMAT('      TWO VARIABLES TO COMPUTE (2*NUMBER OF PAIRS + ',
     1         'GROUP-ID VARIABLE)')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,215)
        CALL DPWRST('XXX','BUG ')
        IF(IWIDTH.GE.1)THEN
          WRITE(ICOUT,216)(IANS(J),J=1,MIN(80,IWIDTH))
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
      ENDIF
C
      IF(ISTANR.EQ.3 .AND. MOD(NUMVAR-1,3).GT.0)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,211)ISTANA
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,232)
  232   FORMAT('      THE NUMBER OF RESPONSE VARIABLES IS NOT')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,233)
  233   FORMAT('      DIVISIBLE BY 3 WHEN THE STATISTIC REQUIRES')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,234)
  234   FORMAT('      THREE VARIABLES TO COMPUTE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,215)
        CALL DPWRST('XXX','BUG ')
        IF(IWIDTH.GE.1)THEN
          WRITE(ICOUT,216)(IANS(J),J=1,MIN(80,IWIDTH))
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
      ENDIF
C               *********************************
C               **  STEP 3--                   **
C               **  EXTRACT THE DATA           **
C               *********************************
C
      NTEMP=NRIGHT(1)
      DO300K=1,NUMVAR
C
        J=0
        IMAX=NTEMP
        IF(NQ.LT.NTEMP)IMAX=NQ
        DO310I=1,IMAX
          IF(ISUB(I).EQ.1)THEN
            J=J+1
            IJ=MAXN*(ICOLR(K)-1)+I
C
            IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DPSP')THEN
              WRITE(ICOUT,311)I,J,MAXN,ICOLR(K),IJ,NRIGHT(I),NQ,IMAX
  311         FORMAT('I,J,MAXN,ICOLR(K),IJ,NRIGHT(I),NQ,IMAX = ',8I8)
              CALL DPWRST('XXX','BUG ')
            ENDIF
C
            IF(ICOLR(K).LE.MAXCOL)Z(J,K)=V(IJ)
            IF(ICOLR(K).EQ.MAXCP1)Z(J,K)=PRED(I)
            IF(ICOLR(K).EQ.MAXCP2)Z(J,K)=RES(I)
            IF(ICOLR(K).EQ.MAXCP3)Z(J,K)=YPLOT(I)
            IF(ICOLR(K).EQ.MAXCP4)Z(J,K)=XPLOT(I)
            IF(ICOLR(K).EQ.MAXCP5)Z(J,K)=X2PLOT(I)
            IF(ICOLR(K).EQ.MAXCP6)Z(J,K)=TAGPLO(I)
          ENDIF
  310   CONTINUE
        IF(K.EQ.1)NLOCAL=J
  300   CONTINUE
C
C               ********************************************************
C               **  STEP 27--                                         **
C               **  CREATE A GROUP-ID VARIABLE BASED ON NI IF NEEDED  **
C               ********************************************************
C
      ISTEPN='3B'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DPSP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(ISIZE.GT.0)THEN
        NUMVAR=NUMVAR+1
        DO360J=1,NLOCAL
          ITEMP=MOD(J,ISIZE)
          IF(ITEMP.EQ.0)ITEMP=ISIZE
          Z(J,NUMVAR)=REAL(ITEMP)
  360   CONTINUE
      ENDIF
C
C               ********************************************************
C               **  STEP 4--                                          **
C               **  COMPUTE THE APPROPRIATE STATISTIC PLOT STATISTIC--**
C               **  (MEAN, STANDARD DEVIATION, RANGE, OR CUSUM).      **
C               **  COMPUTE CONFIDENCE LINES.                         **
C               **  FORM THE VERTICAL AND HORIZONTAL AXIS             **
C               **  VALUES Y(.) AND X(.) FOR THE PLOT.                **
C               **  DEFINE THE VECTOR D(.) TO 1'S, 2'S, AND 3'S       **
C               **  FOR THE PLOTTED VALUE, THE LOWER CONFIDENCE LINE, **
C               **  AND THE UPPER CONFIDENCE LINE.                    **
C               **  DEFINE THE NUMBER OF PLOT POINTS    (NPLOTP).     **
C               **  DEFINE THE NUMBER OF PLOT VARIABLES (NPLOTV).     **
C               ********************************************************
C
      ISTEPN='4'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DPSP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPSP2(Z,MAXOBV,MAXRES,NLOCAL,NUMVAR,ISTANR,IFLAGZ,IFLAGU,
     1ICASPL,ISIZE,ICONT,
     1TEMP,TEMP2,TEMP3,TEMP4,XTEMP1,XTEMP2,XTEMP3,MAXNXT,
     1ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1DTEMP1,DTEMP2,DTEMP3,
     1IQUAME,IQUASE,PSTAMV,ISTAFO,ISTASM,
     1Y,X,D,NPLOTP,NPLOTV,ISUBRO,IBUGG3,IERROR)
C
C
C               *************************************************
C               **  STEP 29--                                  **
C               **  SAVE DIFFERENCE BETWEEN HIGHEST VALUE AND  **
C               **  LOWEST VALUE OF STATISTIC IN INTERNAL      **
C               **  PARAMETER ALOWHIGH                         **
C               *************************************************
      AMINS=CPUMAX
      AMAXS=CPUMIN
      DO2910I=1,NPLOTP
        IF(D(I).NE.1.0)GOTO2910
        IF(Y(I).GT.AMAXS)THEN
          AMAXS=Y(I)
          IMAXIN=I
        ENDIF
        IF(Y(I).LT.AMINS)THEN
          AMINS=Y(I)
          IMININ=I
        ENDIF
 2910 CONTINUE
      ADIFF=AMAXS-AMINS
      IF(IMAXIN.GT.IMININ)ADIFF=-ADIFF
C
      ISUBN0='DPSP'
C
      IH='ALOW'
      IH2='HIGH'
      VALUE0=ADIFF
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
C
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'DPSP')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSP--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)ICONT,ISUBRO,IBUGG2,IBUGG3,IBUGQ
 9012   FORMAT('ICONT,ISUBRO,IBUGG2,IBUGG3,IBUGQ  = ',
     1         A4,2X,A4,2X,A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)IFOUND,IERROR
 9013   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        IF(IFOUND.EQ.'NO')GOTO9099
        WRITE(ICOUT,9014)NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2
 9014   FORMAT('NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2 = ',
     1         I8,I8,I8,2X,A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)NUMVAR,ISIZE
 9016   FORMAT('NUMVAR,ISIZE = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(IFOUND.EQ.'NO'.OR.NPLOTP.LE.0)THEN
          DO9025I=1,NPLOTP
            WRITE(ICOUT,9026)I,Y(I),X(I),D(I)
 9026       FORMAT('I,Y(I),X(I),D(I) = ',I8,3F12.5)
            CALL DPWRST('XXX','BUG ')
 9025     CONTINUE
        ENDIF
      ENDIF
 9099 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPSP2(Z,MAXOBV,MAXRES,N,NUMV2,ISTANR,IFLAGZ,IFLAGU,
     1ICASPL,ISIZE,ICONT,
     1TEMP,TEMPZ,TEMPZ2,XIDTEM,XTEMP1,XTEMP2,XTEMP3,MAXNXT,
CCCCC JULY 2002.  ADD FOLLOWING LINE FOR HODGES-LEHMAN
     1ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1DTEMP1,DTEMP2,DTEMP3,
     1IQUAME,IQUASE,PSTAMV,ISTAFO,ISTASM,
     1Y2,X2,D2,N2,NPLOTV,ISUBRO,IBUGG3,IERROR)
C
C     PURPOSE--GENERATE A PAIR OF COORDINATE VECTORS
C              THAT WILL DEFINE A <STAT> PLOT
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     REFERENCE--ASTM MANUAL STP-15D, PAGES 78-84, 100-105
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--JANUARY   1988.
C     UPDATED         --MARCH     1988.   LINEAR INTERCEPT & SLOPE PLOTS
C     UPDATED         --MARCH     1988.   LINEAR RESSD & CORRELATION PLOTS
C     UPDATED         --AUGUST    1988.   TAGUCHI SIGNAL TO NOISE PLOTS
C     UPDATED         --SEPTEMBER 1988.   4 MISSING CHARACTER*4 STATEMENTS
C     UPDATED         --MAY       1989.   CHANGE TAGUCHI S/N DESIGNATIONS
C     UPDATED         --SEPTEMBER 1993. CP PLOT
C     UPDATED         --SEPTEMBER 1993. CPK PLOT
C     UPDATED         --SEPTEMBER 1993. PERCENT DEFECTIVE PLOT
C     UPDATED         --SEPTEMBER 1993. EXPECTED LOSS PLOT
C     UPDATED         --DECEMBER  1993. LINFIT ARGS
C     UPDATED         --DECEMBER  1993. LINFIT ARGS; PROTECT RESSD/DF
C     UPDATED         --FEBRUARY  1994. IFLAG='ACTU'
C     UPDATED         --FEBRUARY  1994. CHANGE ICASPL: SDM => SDME
C     UPDATED         --FEBRUARY  1994. CHANGE ICASPL: VM => VAME
C     UPDATED         --FEBRUARY  1994. CHANGE ICASPL: RSD => RESD
C     UPDATED         --FEBRUARY  1994. CHANGE ICASPL: RVAR => REVA
C     UPDATED         --FEBRUARY  1994. ALLOW SD MEAN
C     UPDATED         --FEBRUARY  1994. ADD VARI OF MEAN
C     UPDATED         --FEBRUARY  1994. ADD VARI OF MEAN
C     UPDATED         --FEBRUARY  1994. ADD NORMAL PPCC
C     UPDATED         --NOVEMBER  1998. ADD PERCENTILE
C     UPDATED         --NOVEMBER  1998. ADD CPM, CC
C     UPDATED         --MARCH     1999. ADD CNPK
C     UPDATED         --MARCH     1999. ADD GEOMETRIC MEAN
C     UPDATED         --MARCH     1999. ADD GEOMETRIC STANDARD DEVIATION
C     UPDATED         --APRIL     2001. ARGUMENT LIST TO CP, CPK, CPM
C     UPDATED         --SEPTEMBER 2001. ADD IQ RANGE
C     UPDATED         --NOVEMBER  2001. ADD BIWEIGHT LOCATION
C     UPDATED         --NOVEMBER  2001. ADD BIWEIGHT SCALE
C     UPDATED         --JULY      2002. ADD WINSORIZED VARIANCE
C     UPDATED         --JULY      2002. ADD WINSORIZED SD
C     UPDATED         --JULY      2002. ADD WINSORIZED COVARIANCE PLOT
C     UPDATED         --JULY      2002. ADD WINSORIZED CORRELATION PLOT
C     UPDATED         --JULY      2002. ADD BIWEIGHT MIDVARIANCE PLOT
C     UPDATED         --JULY      2002. ADD BIWEIGHT MIDCOVARIANCE PLOT
C     UPDATED         --JULY      2002. ADD BIWEIGHT MIDCORRELATION PLOT
C     UPDATED         --JULY      2002. ADD PERCENTAGE BEND MIDVARIANCE
C                                           PLOT
C     UPDATED         --JULY      2002. ADD PERCENTAGE BEND CoRRELATION
C                                           PLOT
C     UPDATED         --JULY      2002. ADD HODGES LEHMAN PLOT
C     UPDATED         --AUGUST    2002. USE "CMPSTA" TO COMPUTE THE
C                                       STATISTIC
C     UPDATED         --APRIL     2003. ADD SN AND QN (AND DIFFERENCE
C                                       OF), REQUIRED ADDITIONAL
C                                       SCRATCH ARRAY
C     UPDATED         --OCTOBER   2004. ADD KENDELL TAU
C     UPDATED         --FEBRUARY  2005. ADD REPEATABILITY SD
C     UPDATED         --FEBRUARY  2005. ADD REPRODUCABILITY SD
C     UPDATED         --SEPTEMBER 2005. ADD RATIO
C     UPDATED         --MARCH     2007. ADD ODDS RATIO
C     UPDATED         --MARCH     2007. ADD ODDS RATIO STANDARD ERROR
C     UPDATED         --MARCH     2009. SUPPORT FOR MULTIPLE RESPONSE
C                                       VARIABLES
C     UPDATED         --MARCH     2009. ZSCORE/USCORE OPTIONS
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICONT
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGG3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IQUAME
      CHARACTER*4 IQUASE
      CHARACTER*4 ISTAFO
      CHARACTER*4 ISTAFZ
      CHARACTER*4 ISTASM
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Z(MAXOBV,MAXRES)
      DIMENSION Y2(*)
      DIMENSION X2(*)
      DIMENSION D2(*)
C
      DIMENSION TEMP(*)
      DIMENSION TEMPZ(*)
      DIMENSION TEMPZ2(*)
      DIMENSION XIDTEM(*)
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
      DIMENSION XTEMP3(*)
C
      INTEGER ITEMP1(*)
      INTEGER ITEMP2(*)
      INTEGER ITEMP3(*)
      INTEGER ITEMP4(*)
      INTEGER ITEMP5(*)
      INTEGER ITEMP6(*)
C
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION DTEMP2(*)
      DOUBLE PRECISION DTEMP3(*)
C
C-----COMMON----------------------------------------------------------
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPSP'
      ISUBN2='2   '
C
      IWRITE='OFF'
C
      I2=0
      ISIZE2=0
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
   31   FORMAT('***** ERROR IN <STATISTIC> PLOT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,32)
   32   FORMAT('      THE NUMBER OF OBSERVATIONS IS NON-POSITIVE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,34)N
   34   FORMAT('      THE ENTERED NUMBER OF OBSERVATIONS HERE = ',I6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
CCCCC IF(N.GE.2)GOTO49
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,46)
CCC46 FORMAT('***** ERROR IN DPSP2--')
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,47)
CCC47 FORMAT('      THE NUMBER OF OBSERVATIONS')
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,48)
CCC48 FORMAT('      WAS EXACTLY EQUAL TO 1.')
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC IERROR='YES'
CCCCC GOTO9000
CCC49 CONTINUE
C
CCCCC HOLD=Y(1)
CCCCC DO60I=1,N
CCCCC IF(Y(I).NE.HOLD)GOTO69
CCC60 CONTINUE
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,61)
CCC61 FORMAT('***** ERROR IN DPSP2--')
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,62)
CCC62 FORMAT('      ALL RESPONSE VARIABLE ELEMENTS')
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,63)HOLD
CCC63 FORMAT('      ARE IDENTICALLY EQUAL TO ',E15.7)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC IERROR='YES'
CCCCC GOTO9000
CCC69 CONTINUE
C
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'PSP2')THEN
        WRITE(ICOUT,70)
   70   FORMAT('AT THE BEGINNING OF DPSP2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,71)IBUGG3,ISUBRO
   71   FORMAT('IBUGG3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,72)N,ICASPL,NUMV2,ISIZE,ICONT
   72   FORMAT('N,ICASPL,NUMV2,ISIZE,ICONT = ',I8,2X,A4,I8,I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        DO73I=1,N
          WRITE(ICOUT,74)I,(Z(I,J),J=1,NUMV2)
   74     FORMAT('I, (Z(I,J),J=1,NUMV2) = ',I8,25F15.7)
          CALL DPWRST('XXX','BUG ')
   73   CONTINUE
      ENDIF
C
C               ********************************************************
C               **  STEP 1--                                          **
C               **  DETERMINE THE NUMBER OF DISTINCT VALUES           **
C               **  FOR THE GROUP VARIABLE (USUALLY VAR. 2)           **
C               **  IF ALL VALUES ARE DISTINCT, THEN THIS             **
C               **  IMPLIES WE HAVE THE NO REPLICATION CASE           **
C               **  WHICH IS AN ERROR CONDITION FOR A PLOT.           **
C               ********************************************************
C
      ISTEPN='1'
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'PSP2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NUMSET=0
      DO111I=1,N
        IF(NUMSET.GE.1)THEN
          DO112J=1,NUMSET
            IF(Z(I,NUMV2).EQ.XIDTEM(J))GOTO111
  112     CONTINUE
        ENDIF
        NUMSET=NUMSET+1
        XIDTEM(NUMSET)=Z(I,NUMV2)
  111 CONTINUE
      CALL SORT(XIDTEM,NUMSET,XIDTEM)
C
      IF(NUMSET.LT.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,122)
  122   FORMAT('      NUMBER OF SETS    NUMSET = 0 ')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
C
CCCC    JANUARY 2005.  IF NUMBER OF SETS EQUAL NUMBER OF OBSERVATIONS
CCCCC                  (I.E., ALL GROUPS HAVE 1 OBSERVATION), TREAT AS
CCCCC                  A WARNING RATHER THAN AN ERROR.  NOTE THAT SOME
CCCCC                  STATISTICS MAY SUBSEQUENTLY GENERATE AN ERROR
CCCCC                  MESSAGE FOR EACH GROUP.
C
      ELSEIF(NUMSET.EQ.N)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,135)
  135   FORMAT('***** WARNING IN <STAT> PLOT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,136)NUMSET
  136   FORMAT('      THE NUMBER OF SETS ',I8,' IS IDENTICAL TO ')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,137)N
  137   FORMAT('      THE NUMBER OF OBSERVATIONS  ',I8,'.')
        CALL DPWRST('XXX','BUG ')
CCCCC   IERROR='YES'
CCCCC   GOTO9000
      ENDIF
C
      AN=N
      ANUMSE=NUMSET
C
C               ********************************************************
C               **  STEP 1B--                                         **
C               **  SCALE BY Z-SCORE OR U-SCORE IF REQUESTED          **
C               ********************************************************
C
      ISTEPN='1B'
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'PSP2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IFLAGZ.EQ.1)THEN
        DO160K=1,NUMV2-1
          CALL MEAN(Z(1,K),N,IWRITE,XMEAN,IBUGG3,IERROR)
          CALL SD(Z(1,K),N,IWRITE,XSD,IBUGG3,IERROR)
          IF(XSD.GT.0.0)THEN
            DO165I=1,N
              Z(I,K)=(Z(I,K)-XMEAN)/XSD
  165       CONTINUE
          ELSE
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,135)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,166)K
  166       FORMAT('      UNABLE TO STANDARDIZE RESPONSE VARIABLE ',
     1             I8)
            CALL DPWRST('XXX','BUG ')
          ENDIF
  160   CONTINUE
      ELSEIF(IFLAGU.EQ.1)THEN
        DO170K=1,NUMV2-1
          CALL MINIM(Z(1,K),N,IWRITE,XMIN,IBUGG3,IERROR)
          CALL MAXIM(Z(1,K),N,IWRITE,XMAX,IBUGG3,IERROR)
          IF(XMIN.NE.XMAX)THEN
            DO175I=1,N
              Z(I,K)=(Z(I,K)-XMIN)/(XMAX-XMIN)
  175       CONTINUE
          ELSE
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,135)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,176)K
  176       FORMAT('      UNABLE TO STANDARDIZE RESPONSE VARIABLE ',
     1             I8)
            CALL DPWRST('XXX','BUG ')
          ENDIF
  170   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1C--                           **
C               **  COMPUTE THE SPECIFIED STATISTIC     **
C               **  FOR EACH SUBSET OF THE DATA, AND    **
C               **  THEN FOR THE FULL DATA SET          **
C               ******************************************
C
      ISTEPN='1C'
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'PSP2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     MARCH 2009: IF NUMBER OF RESPONSE VARIABLES IS > 1,
C                 THEN CODE THE GROUP-ID VARIABLE.  ALSO,
C                 SUPPORT BOTH AN "OVERLAY" AND A "DEX"
C                 FORMAT FOR MULTIPLE RESPONSE CASE.
C
C                 FOR SUMMARY STATISTIC AND MULTIPLE RESPONSES,
C                 SUPPORT EITHER "GROUP" OR "COLUMNS" OPTION.
C                 COLUMN OPTION SUMMARIZES BY VARIABLE (OVER
C                 ALL GROUPS) WHILE GROUP OPTION SUMMARIZES BY
C                 VALUE OF GROUP-ID VARIABLE.
C
      NCURV=(NUMV2-1)/ISTANR
      IF(NCURV.GT.1)THEN
        CALL CODE(XIDTEM,NUMSET,IWRITE,XTEMP1,XTEMP2,MAXOBV,
     1            IBUGG3,IERROR)
        DO200I=1,N
          HOLD=Z(I,NUMV2)
          DO210J=1,NUMSET
            IF(HOLD.EQ.XIDTEM(J))Z(I,NUMV2)=XTEMP1(J)
  210     CONTINUE
  200   CONTINUE
        DO220I=1,NUMSET
          XIDTEM(I)=XTEMP1(I)
  220   CONTINUE
        ISTAFZ=ISTAFO
      ELSE
        ISTAFZ='OVER'
      ENDIF
C
      IF(NCURV.EQ.1)THEN
        ASTRT=0.0
        AINC=0.0
      ELSE
        ASTRT=0.4
        AINC=0.8/REAL(NCURV-1)
      ENDIF
C
      J2=0
      DO10000KK=1,NCURV
C
        NV1=(KK-1)*ISTANR + 1
        J=0
        ISETMX=NUMSET+1
        IF(NCURV.GT.1 .AND. ISTASM.EQ.'GROU')THEN
          ISETMX=NUMSET
        ENDIF
C
        DO11000ISET=1,ISETMX
C
          IF(ISET.LE.NUMSET)THEN
            K=0
            DO11011I=1,N
              IF(Z(I,NUMV2).EQ.XIDTEM(ISET))THEN
                K=K+1
                TEMP(K)=Z(I,NV1)
                IF(ISTANR.EQ.1)THEN
                  TEMPZ(K)=Z(I,NV1)
                  TEMPZ2(K)=Z(I,NV1)
                ELSEIF(ISTANR.EQ.2)THEN
                  TEMPZ(K)=Z(I,NV1+1)
                  TEMPZ2(K)=Z(I,NV1+1)
                ELSEIF(ISTANR.EQ.3)THEN
                  TEMPZ(K)=Z(I,NV1+1)
                  TEMPZ2(K)=Z(I,NV1+2)
                ENDIF
              ENDIF
11011       CONTINUE
            NS2=K
          ELSE
C
CCCCC       FEBRUARY 2005: FOR REPEATABILITY SD AND REPRODUCABILITY
CCCCC                      SD, OMIT FULL SAMPLE COMPUTATION (SINCE
CCCCC                      FULL SAMPLE STATISTIC IS NOT MEANINGFUL
CCCCC                      AND DISTORTS THE PLOT)
C
            IF(ICASPL.NE.'REPE' .AND. ICASPL.NE.'REPR')THEN
              DO11021I=1,N
                TEMP(I)=Z(I,NV1)
                IF(ISTANR.EQ.1)THEN
                  TEMPZ(I)=Z(I,NV1)
                  TEMPZ2(I)=Z(I,NV1)
                ELSEIF(ISTANR.EQ.2)THEN
                  TEMPZ(I)=Z(I,NV1+1)
                  TEMPZ2(I)=Z(I,NV1+1)
                ELSEIF(ISTANR.EQ.3)THEN
                  TEMPZ(I)=Z(I,NV1+1)
                  TEMPZ2(I)=Z(I,NV1+2)
                ENDIF
11021         CONTINUE
              NS2=N
            ENDIF
          ENDIF
C
          IF(NS2.LT.1)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,11081)
11081       FORMAT('***** INTERNAL ERROR IN DPSP2--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,11082)
11082       FORMAT('NS FOR SOME CLASS = 0')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,11083)ISET,XIDTEM(ISET),NS
11083       FORMAT('ISET,XIDTEM(ISET),NS = ',I8,G15.7,I8)
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
C
CCCCC     AUGUST 2002: USE SUBROUTINE TO COMPUTE THE STATISTIC
CCCCC                  RATHER THAN CODING HERE.
C
          CALL CMPSTA(TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,MAXNXT,
     1                NS2,NS2,NS2,ISTANR,ICASPL,ISEED,
     1                ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1                DTEMP1,DTEMP2,DTEMP3,
CCCCC1                IQUAME,IQUASE,PSTAMV,
     1                RIGHT,
     1                ISUBRO,IBUGG3,IERROR)
C
C         ---------------------------
C
CCCCC     NOTE: FOR DEX MODE, MAKE "OVERALL PLOT" CONTAIN 4
CCCCC           POINTS: AT X = XIDTEM(1) AND X = XIDTEM(NUMSET)
CCCCC           AND AT X = XIDTEM(1) - ASTRT AND
CCCCC           X = XIDTEM(NUMSET) + ASTRT.  THIS IS SO THAT
CCCCC           THE DPDEDL ROUTINE WILL INCLUDE THESE POINTS
CCCCC           WHEN COMPUTING THE DATA/FRAME LIMITS WHEN THE
CCCCC           XLIMITS ARE SET TO X = XIDTEM(1) AND X = XIDTEM(NUMSET)
CCCCC           (WHICH WILL BE FREQUENT FOR THIS COMMAND).
C
          IF(ISET.LE.NUMSET)THEN
            J2=J2+1
            Y2(J2)=RIGHT
            IF(ISTAFZ.EQ.'DEX')THEN
              X2(J2)=XIDTEM(ISET) - ASTRT + REAL(KK-1)*AINC
              D2(J2)=REAL(ISET)
            ELSE
              X2(J2)=XIDTEM(ISET)
              D2(J2)=REAL(KK)
            ENDIF
          ELSE
            IF(ISTAFZ.EQ.'DEX')THEN
              J2=J2+1
              Y2(J2)=RIGHT
              X2(J2)=XIDTEM(1) - ASTRT
              D2(J2)=REAL(NUMSET+KK)
              J2=J2+1
              Y2(J2)=RIGHT
              X2(J2)=XIDTEM(1)
              D2(J2)=REAL(NUMSET+KK)
              J2=J2+1
              Y2(J2)=RIGHT
              X2(J2)=XIDTEM(NUMSET)
              D2(J2)=REAL(NUMSET+KK)
              J2=J2+1
              Y2(J2)=RIGHT
              X2(J2)=XIDTEM(NUMSET) + ASTRT
              D2(J2)=REAL(NUMSET+KK)
            ELSE
              J2=J2+1
              Y2(J2)=RIGHT
              X2(J2)=XIDTEM(1)
              D2(J2)=REAL(NCURV+KK)
              J2=J2+1
              Y2(J2)=RIGHT
              X2(J2)=XIDTEM(NUMSET)
              D2(J2)=REAL(NCURV+KK)
            ENDIF
          ENDIF
C
11000 CONTINUE
10000 CONTINUE
C
C     FOR MULTIPLE RESPONSES, IF "STAT PLOT SUMMARY" = "GROUP",
C     THEN COMPUTE STATISTIC FOR ALL VALUES OF EACH GROUP.
C
      IF(NCURV.GT.1 .AND. ISTASM.EQ.'GROU')THEN
        K=0
        DO2000ISET=1,NUMSET
          DO2100I=1,N
            IF(Z(I,NUMV2).EQ.XIDTEM(ISET))THEN
              DO2200KK=1,NCURV
                NV1=(KK-1)*ISTANR + 1
                K=K+1
                IF(K.LE.MAXOBV)THEN
                  TEMP(K)=Z(I,NV1)
                  IF(ISTANR.EQ.1)THEN
                    TEMPZ(K)=Z(I,NV1)
                    TEMPZ2(K)=Z(I,NV1)
                  ELSEIF(ISTANR.EQ.2)THEN
                    TEMPZ(K)=Z(I,NV1+1)
                    TEMPZ2(K)=Z(I,NV1+1)
                  ELSEIF(ISTANR.EQ.3)THEN
                    TEMPZ(K)=Z(I,NV1+1)
                    TEMPZ2(K)=Z(I,NV1+2)
                  ENDIF
                ELSE
                  WRITE(ICOUT,999)
                  CALL DPWRST('XXX','BUG ')
                  WRITE(ICOUT,2201)
 2201             FORMAT('***** WARNING IN <STAT> PLOT--')
                  CALL DPWRST('XXX','BUG ')
                  WRITE(ICOUT,2203)
 2203             FORMAT('      UNABLE TO GENERATE SUMMARY STATISTICS',
     1                   'FOR GROUPS.')
                  CALL DPWRST('XXX','BUG ')
                  GOTO9000
                ENDIF
 2200         CONTINUE
            ENDIF
 2100     CONTINUE
C
          NS2=K
          CALL CMPSTA(TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,MAXNXT,
     1                NS2,NS2,NS2,ISTANR,ICASPL,ISEED,
     1                ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1                DTEMP1,DTEMP2,DTEMP3,
CCCCC1                IQUAME,IQUASE,PSTAMV,
     1                RIGHT,
     1                ISUBRO,IBUGG3,IERROR)
          IF(ISTAFZ.EQ.'DEX')THEN
            J2=J2+1
            Y2(J2)=RIGHT
            X2(J2)=XIDTEM(ISET) - ASTRT
            D2(J2)=REAL(NUMSET+ISET)
            J2=J2+1
            Y2(J2)=RIGHT
            X2(J2)=XIDTEM(ISET) + ASTRT
            D2(J2)=REAL(NUMSET+ISET)
          ELSE
            J2=J2+1
            Y2(J2)=RIGHT
            X2(J2)=XIDTEM(ISET)
            D2(J2)=REAL(NCURV+1)
            J2=J2+1
            Y2(J2)=RIGHT
            X2(J2)=XIDTEM(ISET)
            D2(J2)=REAL(NCURV+1)
          ENDIF
C
 2000   CONTINUE
      ENDIF
C
      N2=J2
      NPLOTV=3
      GOTO9000
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'PSP2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSP2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGG3,ISUBRO
 9012   FORMAT('IBUGG3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)ICASPL,N,NUMSET,N2,IERROR
 9013   FORMAT('ICASPL,N,NUMSET,N2,IERROR = ',A4,3I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9014)NUMV2,ISIZE
 9014   FORMAT('NUMV2,ISIZE = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9020I=1,N2
          WRITE(ICOUT,9021)I,Y2(I),X2(I),D2(I)
 9021     FORMAT('I,Y2(I),X2(I),D2(I) = ',I8,2E15.7,F9.2)
          CALL DPWRST('XXX','BUG ')
 9020   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSPAC(IHARG,NUMARG,
     1IDEFSP,
     1ITEXSP,
     1IBUGD2,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE SPACING TYPE (FIXED OR PROPORTIONAL) FOR
C              TITLE, LABEL, AND LEGEND SCRIPT
C              ON A PLOT.
C              THE SPACING FOR THE SCRIPT WILL BE PLACED
C              IN THE CHARACTER VARIABLE ITEXSP.
C     INPUT  ARGUMENTS--IHARG  (A  CHARACTER VECTOR)
C                     --NUMARG
C                     --IDEFSP
C                     --IBUGD2
C     OUTPUT ARGUMENTS--ITEXSP
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--SEPTEMBER 1980.
C     UPDATED         --APRIL     1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IDEFSP
      CHARACTER*4 ITEXSP
      CHARACTER*4 IBUGD2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
C---------------------------------------------------------------------
C
      DIMENSION IHARG(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      IF(IBUGD2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPSPAC--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IDEFSP
   53 FORMAT('IDEFSP = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)NUMARG
   54 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,NUMARG
      WRITE(ICOUT,56)I,IHARG(I)
   56 FORMAT('I,IHARG(I) = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
   90 CONTINUE
C
C               ***************************
C               **  TREAT THE SPACING CASE  **
C               ***************************
C
 1110 CONTINUE
      IF(NUMARG.LE.0)GOTO1120
      IF(IHARG(NUMARG).EQ.'ON')GOTO1120
      IF(IHARG(NUMARG).EQ.'OFF')GOTO1120
      IF(IHARG(NUMARG).EQ.'AUTO')GOTO1120
      IF(IHARG(NUMARG).EQ.'DEFA')GOTO1120
      GOTO1140
C
 1120 CONTINUE
      ITEXSP=IDEFSP
      GOTO1180
C
 1140 CONTINUE
      IF(NUMARG.EQ.1.AND.IHARG(1).EQ.'EQUA')GOTO1141
      IF(NUMARG.EQ.1.AND.IHARG(1).EQ.'FIXE')GOTO1141
      IF(NUMARG.EQ.1.AND.IHARG(1).EQ.'PROP')GOTO1142
C
 1130 CONTINUE
      IERROR='YES'
      WRITE(ICOUT,1131)
 1131 FORMAT('***** ERROR IN DPSPAC--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1132)
 1132 FORMAT('      ILLEGAL ENTRY FOR SPACING ',
     1'COMMAND.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1133)
 1133 FORMAT('      TEST EXAMPLE TO DEMONSTRATE THE ',
     1'PROPER FORM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1134)
 1134 FORMAT('      SUPPOSE THE THE ANALYST WISHES ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1135)
 1135 FORMAT('      TO SET THE SPACING TO PROPORTIONAL ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1136)
 1136 FORMAT('      FOR PLOT TITLES, LABELS, ETC.,')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1137)
 1137 FORMAT('      THEN 2 ALLOWABLE FORMS ARE--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1138)
 1138 FORMAT('            SPACING PROPORTIONAL ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1139)
 1139 FORMAT('            SPACING PROP ')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
C
 1141 CONTINUE
      ITEXSP='FIXE'
      GOTO1180
C
 1142 CONTINUE
      ITEXSP='PROP'
      GOTO1180
C
 1180 CONTINUE
      IFOUND='YES'
C
      IF(IFEEDB.EQ.'OFF')GOTO1189
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1181)
 1181 FORMAT('THE SPACING (FIXED OR PROPORTIONAL)')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1182)
 1182 FORMAT('FOR PLOT SCRIPT AND TEXT')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1183)ITEXSP
 1183 FORMAT('HAS JUST BEEN SET TO ',A4)
      CALL DPWRST('XXX','BUG ')
 1189 CONTINUE
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGD2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPSPAC--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGD2,ISUBRO,IFOUND,IERROR
 9012 FORMAT('IBUGD2,ISUBRO,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IDEFSP,ITEXSP
 9013 FORMAT('IDEFSP,ITEXSP = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPSPBA(ADEFSB,MAXSPI,ASPIBA,
CCCCC SUBROUTINE DPSPBA(IHARG,IARGT,ARG,NUMARG,ADEFSB,MAXSPI,ASPIBA,
     1IBUGP2,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE SPIKE BASES.
C              THESE ARE LOCATED IN THE VECTOR ASPIBA(.).
C     INPUT  ARGUMENTS--IHARG  (A  CHARACTER VECTOR)
C                     --IARGT  (A  CHARACTER VECTOR)
C                     --ARG
C                     --NUMARG
C                     --ADEFSB
C                     --MAXSPI
C                     --IBUGP2 ('ON' OR 'OFF' )
C     OUTPUT ARGUMENTS--ASPIBA (A FLOATING POINT VECTOR)
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--DECEMBER  1983.
C     UPDATED         --APRIL     2008. SPIKE BASE AUTOMATIC
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
CCCCC CHARACTER*4 IHARG
CCCCC CHARACTER*4 IARGT
C
      CHARACTER*4 IBUGP2
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHOLD1
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 ICASEQ
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGQ
C
CCCCC DIMENSION IHARG(*)
CCCCC DIMENSION IARGT(*)
CCCCC DIMENSION ARG(*)
      DIMENSION ASPIBA(*)
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      ISUBN1='DPSP'
      ISUBN2='BA  '
C
      NUMSPI=0
      IHOLD1='-999'
      HOLD1=-999.0
      HOLD2=-999.0
C
      IF(IBUGP2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPSPBA--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGP2,IFOUND,IERROR
   52 FORMAT('IBUGP2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)MAXSPI,NUMSPI
   53 FORMAT('MAXSPI,NUMSPI = ',I8,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IHOLD1,HOLD1,HOLD2
   54 FORMAT('IHOLD1,HOLD1,HOLD2 = ',A4,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)ADEFSB
   55 FORMAT('ADEFSB = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,60)NUMARG
   60 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO65I=1,NUMARG
      WRITE(ICOUT,66)IHARG(I),IARGT(I),ARG(I)
   66 FORMAT('IHARG(I),IARGT(I),ARG(I) = ',A4,2X,A4,I8)
      CALL DPWRST('XXX','BUG ')
   65 CONTINUE
      WRITE(ICOUT,70)ASPIBA(1)
   70 FORMAT('ASPIBA(1) = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      DO75I=1,10
      WRITE(ICOUT,76)I,ASPIBA(I)
   76 FORMAT('I,ASPIBA(I) = ',I8,2X,E15.7)
      CALL DPWRST('XXX','BUG ')
   75 CONTINUE
   90 CONTINUE
C
C               **************************************
C               **  STEP 1--                        **
C               **  BRANCH TO THE APPROPRIATE CASE  **
C               **************************************
C
      ISTEPN='1'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.0)GOTO9000
CCCCC APRIL 2008.  ADD SPIKE BASE AUTOMATIC <VAR>
      IF(NUMARG.GE.3.AND.IHARG(2).EQ.'AUTO')GOTO3000
      IF(NUMARG.GE.4.AND.IHARG(3).EQ.'AUTO')GOTO3000
C
      IF(NUMARG.EQ.1)GOTO1110
      IF(NUMARG.EQ.2)GOTO1120
      IF(NUMARG.EQ.3)GOTO1130
      GOTO1140
C
 1110 CONTINUE
      GOTO1200
C
 1120 CONTINUE
      IF(IHARG(2).EQ.'ALL')IHOLD1='    '
      IF(IHARG(2).EQ.'ALL')HOLD1=ADEFSB
      IF(IHARG(2).EQ.'ALL')GOTO1300
      GOTO1200
C
 1130 CONTINUE
      IF(IHARG(2).EQ.'ALL')IHOLD1=IHARG(3)
      IF(IHARG(2).EQ.'ALL')HOLD1=ARG(3)
      IF(IHARG(2).EQ.'ALL')GOTO1300
      IF(IHARG(3).EQ.'ALL')IHOLD1=IHARG(2)
      IF(IHARG(3).EQ.'ALL')HOLD1=ARG(2)
      IF(IHARG(3).EQ.'ALL')GOTO1300
      GOTO1200
C
 1140 CONTINUE
      GOTO1200
C
C               *************************************************
C               **  STEP 2--                                   **
C               **  TREAT THE INDIVIDUAL SPECIFICATIONS CASE  **
C               *************************************************
C
 1200 CONTINUE
      ISTEPN='2'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.1)GOTO1210
      GOTO1220
C
 1210 CONTINUE
      NUMSPI=1
      ASPIBA(1)=ADEFSB
      GOTO1270
C
 1220 CONTINUE
      NUMSPI=NUMARG-1
      IF(NUMSPI.GT.MAXSPI)NUMSPI=MAXSPI
      DO1225I=1,NUMSPI
      J=I+1
      IHOLD1=IHARG(J)
      HOLD1=ARG(J)
      HOLD2=HOLD1
      IF(IHOLD1.EQ.'ON')HOLD2=ADEFSB
      IF(IHOLD1.EQ.'OFF')HOLD2=ADEFSB
      IF(IHOLD1.EQ.'AUTO')HOLD2=ADEFSB
      IF(IHOLD1.EQ.'DEFA')HOLD2=ADEFSB
      ASPIBA(I)=HOLD2
 1225 CONTINUE
      GOTO1270
C
 1270 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO1279
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      DO1278I=1,NUMSPI
      WRITE(ICOUT,1276)I,ASPIBA(I)
 1276 FORMAT('SPIKE BASE ',I6,' HAS JUST BEEN SET TO ',
     1E15.7)
      CALL DPWRST('XXX','BUG ')
 1278 CONTINUE
 1279 CONTINUE
      IFOUND='YES'
      GOTO9000
C
C               **************************
C               **  STEP 2--            **
C               **  TREAT THE ALL CASE  **
C               **************************
C
 1300 CONTINUE
      ISTEPN='3'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NUMSPI=MAXSPI
      HOLD2=HOLD1
      IF(IHOLD1.EQ.'ON')HOLD2=ADEFSB
      IF(IHOLD1.EQ.'OFF')HOLD2=ADEFSB
      IF(IHOLD1.EQ.'AUTO')HOLD2=ADEFSB
      IF(IHOLD1.EQ.'DEFA')HOLD2=ADEFSB
      DO1315I=1,NUMSPI
      ASPIBA(I)=HOLD2
 1315 CONTINUE
      GOTO1370
C
 1370 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO1319
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      I=1
      WRITE(ICOUT,1316)ASPIBA(I)
 1316 FORMAT('ALL SPIKE BASES HAVE JUST BEEN SET TO ',
     1A4)
      CALL DPWRST('XXX','BUG ')
 1319 CONTINUE
      IFOUND='YES'
      GOTO9000
C
C               ******************************************************
C               **  STEP 30--                                       **
C               **  TREAT THE SPIKE BASE AUTOMATIC <VARIABLE>   CASE**
C               ******************************************************
C
 3000 CONTINUE
C
C               **********************************************
C               **  STEP 31--                               **
C               **  CHECK THE VALIDITY OF ARGUMENT 2 (OR 3) **
C               **  (THIS WILL BE THE RESPONSE VARIABLE)    **
C               **********************************************
C
      ISTEPN='31'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHLEFT=IHARG(3)
      IHLEF2=IHARG2(3)
      IF(IHARG(3).EQ.'DIST'.AND.IHARG2(3).EQ.'INCT')THEN
        IHLEFT=IHARG(4)
        IHLEF2=IHARG2(4)
      ENDIF
      IHWUSE='V'
      MESSAG='YES'
      CALL CHECKN(IHLEFT,IHLEF2,IHWUSE,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCV,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
      ICOLL=IVALUE(ILOCV)
      NLEFT=IN(ILOCV)
C
C               *****************************************
C               **  STEP 32--                          **
C               **  CHECK TO SEE THE TYPE CASE--       **
C               **    1) UNQUALIFIED (THAT IS, FULL);  **
C               **    2) SUBSET/EXCEPT; OR             **
C               **    3) FOR.                          **
C               *****************************************
C
      ISTEPN='32'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ICASEQ='FULL'
      ILOCQ=NUMARG+1
      IF(NUMARG.LT.1)GOTO3290
      DO3200J=1,NUMARG
      J1=J
      IF(IHARG(J).EQ.'SUBS'.AND.IHARG2(J).EQ.'ET  ') GOTO3210
      IF(IHARG(J).EQ.'EXCE'.AND.IHARG2(J).EQ.'PT  ') GOTO3210
      IF(IHARG(J).EQ.'FOR '.AND.IHARG2(J).EQ.'    ') GOTO3220
 3200 CONTINUE
      GOTO3290
 3210 CONTINUE
      ICASEQ='SUBS'
      ILOCQ=J1
      GOTO3290
 3220 CONTINUE
      ICASEQ='FOR'
      ILOCQ=J1
      GOTO3290
 3290 CONTINUE
      IF(IBUGP2.EQ.'OFF')GOTO3295
      WRITE(ICOUT,3291)NUMARG,ILOCQ
 3291 FORMAT('NUMARG,ILOCQ = ',2I8)
      CALL DPWRST('XXX','BUG ')
 3295 CONTINUE
C
C               *********************************************
C               **  STEP 33--                              **
C               **  TEMPORARILY FORM THE VARIABLE Y(.)     **
C               **  WHICH WILL HOLD THE RESPONSE VARIABLE. **
C               **  FORM THIS VARIABLE BY                  **
C               **  BRANCHING TO THE APPROPRIATE SUBCASE   **
C               **  (FULL, SUBSET, OR FOR).                **
C               *********************************************
C
      ISTEPN='33'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(ICASEQ.EQ.'FULL')GOTO3310
      IF(ICASEQ.EQ.'SUBS')GOTO3320
      IF(ICASEQ.EQ.'FOR')GOTO3330
C
 3310 CONTINUE
      DO3315I=1,NLEFT
      ISUB(I)=1
 3315 CONTINUE
      NQ=NLEFT
      GOTO3350
C
 3320 CONTINUE
      NIOLD=NLEFT
      CALL DPSUBS(NIOLD,ILOCS,NS,IBUGQ,IERROR)
      NQ=NIOLD
      GOTO3350
C
 3330 CONTINUE
      NIOLD=NLEFT
      CALL DPFOR(NIOLD,NFOR,IROW1,IROWN,
     1NLOCAL,ILOCS,NS,IBUGQ,IERROR)
      NQ=NFOR
      GOTO3350
C
 3350 CONTINUE
      MINN2=1
      IF(NQ.LT.MINN2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3351)
 3351   FORMAT('***** ERROR IN SPIKE BASE AUTOMATIC--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3352)
 3352   FORMAT('      AFTER THE APPROPRIATE SUBSET HAS BEEN ',
     1         'EXTRACTED,')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3353)IHLEFT,IHLEF2
 3353   FORMAT('      THE NUMBER OF OBSERVATIONS REMAINING',
     1         'FROM VARIABLE ',A4,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3354)
 3354   FORMAT('      (FOR WHICH SPIKE BASE DEFINITIONS ')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3355)
 3355   FORMAT('      ARE TO BE GENERATED)')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3356)MINN2
 3356   FORMAT('      MUST BE ',I8,' OR LARGER;')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3357)
 3357   FORMAT('      SUCH WAS NOT THE CASE HERE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3358)
 3358   FORMAT('      THE ENTERED COMMAND LINE WAS AS FOLLOWS--')
        CALL DPWRST('XXX','BUG ')
        IF(IWIDTH.GE.1)THEN
          WRITE(ICOUT,3359)(IANS(I),I=1,MIN(80,IWIDTH))
 3359     FORMAT('      ',80A1)
          CALL DPWRST('XXX','BUG ')
        ENDIF
        IERROR='YES'
      ENDIF
C
 3360 CONTINUE
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
      J=0
      IMAX=NLEFT
      IF(NQ.LT.NLEFT)IMAX=NQ
      DO3370I=1,IMAX
        IF(ISUB(I).EQ.0)GOTO3370
        J=J+1
C
        IJ=MAXN*(ICOLL-1)+I
        IF(ICOLL.LE.MAXCOL)Y(J)=V(IJ)
        IF(ICOLL.EQ.MAXCP1)Y(J)=PRED(I)
        IF(ICOLL.EQ.MAXCP2)Y(J)=RES(I)
        IF(ICOLL.EQ.MAXCP3)Y(J)=YPLOT(I)
        IF(ICOLL.EQ.MAXCP4)Y(J)=XPLOT(I)
        IF(ICOLL.EQ.MAXCP5)Y(J)=X2PLOT(I)
        IF(ICOLL.EQ.MAXCP6)Y(J)=TAGPLO(I)
C
 3370 CONTINUE
      NS=J
      NY=J
C
C               *****************************************
C               **  STEP 34--                          **
C               **  IF HAVE THE FORM--                 **
C               **  SPIKE BASE AUTOMATIC DISTINCT X    **
C               **  EXTRACT THE DISTINCT VALUES        **
C               **  FROM THE TARGET VARIABLE Y(.)   .  **
C               **  STORE THEM IN X(.)   .             **
C               **  IF HAVE THE FORM--                 **
C               **  SPIKE BASE AUTOMATIC X             **
C               **  DO NOTHING                         **
C               *****************************************
C
      IF(IHARG(3).EQ.'DIST'.AND.IHARG2(3).EQ.'INCT')THEN
        IWRITE='OFF'
        CALL DISTIN(Y,NY,IWRITE,X,NX,IBUGP2,IERROR)
      ELSE
        DO3411I=1,NY
          X(I)=Y(I)
 3411   CONTINUE
        NX=NY
      ENDIF
C
C               ******************************************
C               **  STEP 36--                           **
C               **  COPY VALUES IN X(.) TO ASPIBA       **
C               **        MAX NUMBER OF BARS    = 100   **
C               ******************************************
C
      IMAX=NX
      IF(IMAX.GT.MAXBAR)IMAX=MAXBAR
      DO3650I=1,IMAX
      ASPIBA(I)=X(I)
 3650 CONTINUE
C
      IF(IFEEDB.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        DO3675I=1,IMAX
          WRITE(ICOUT,3676)I,ASPIBA(I)
 3676     FORMAT('SPIKE BASE ',I6,' HAS JUST BEEN SET TO ',
     1           G15.7)
          CALL DPWRST('XXX','BUG ')
 3675   CONTINUE
      ENDIF
      IFOUND='YES'
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGP2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPSPBA--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGP2,IFOUND,IERROR
 9012 FORMAT('IBUGP2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)MAXSPI,NUMSPI
 9013 FORMAT('MAXSPI,NUMSPI = ',I8,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IHOLD1,HOLD1,HOLD2
 9014 FORMAT('IHOLD1,HOLD1,HOLD2 = ',A4,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)ADEFSB
 9015 FORMAT('ADEFSB = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9020)NUMARG
 9020 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9025I=1,NUMARG
      WRITE(ICOUT,9026)IHARG(I),IARGT(I),ARG(I)
 9026 FORMAT('IHARG(I),IARGT(I),ARG(I) = ',A4,2X,A4,I8)
      CALL DPWRST('XXX','BUG ')
 9025 CONTINUE
      WRITE(ICOUT,9030)ASPIBA(1)
 9030 FORMAT('ASPIBA(1) = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      DO9035I=1,10
      WRITE(ICOUT,9036)I,ASPIBA(I)
 9036 FORMAT('I,ASPIBA(I) = ',I8,2X,E15.7)
      CALL DPWRST('XXX','BUG ')
 9035 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPSPCO(IHARG,NUMARG,IDEFSC,MAXSPI,ISPICO,
     1IBUGP2,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE SPIKE COLORS.
C              THESE ARE LOCATED IN THE VECTOR ISPICO(.).
C     INPUT  ARGUMENTS--IHARG  (A  CHARACTER VECTOR)
C                     --NUMARG
C                     --IDEFSC
C                     --MAXSPI
C                     --IBUGP2 ('ON' OR 'OFF' )
C     OUTPUT ARGUMENTS--ISPICO (A CHARACTER VECTOR)
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--DECEMBER  1983.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IDEFSC
      CHARACTER*4 ISPICO
C
      CHARACTER*4 IBUGP2
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHOLD1
      CHARACTER*4 IHOLD2
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      DIMENSION IHARG(*)
      DIMENSION ISPICO(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      ISUBN1='DPSP'
      ISUBN2='CO  '
C
      NUMSPI=0
      IHOLD1='-999'
      IHOLD2='-999'
C
      IF(IBUGP2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPSPCO--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGP2,IFOUND,IERROR
   52 FORMAT('IBUGP2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)MAXSPI,NUMSPI
   53 FORMAT('MAXSPI,NUMSPI = ',I8,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IHOLD1,IHOLD2
   54 FORMAT('IHOLD1,IHOLD2 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IDEFSC
   55 FORMAT('IDEFSC = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,60)NUMARG
   60 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO65I=1,NUMARG
      WRITE(ICOUT,66)IHARG(I)
   66 FORMAT('IHARG(I) = ',A4)
      CALL DPWRST('XXX','BUG ')
   65 CONTINUE
      WRITE(ICOUT,70)ISPICO(1)
   70 FORMAT('ISPICO(1) = ',A4)
      CALL DPWRST('XXX','BUG ')
      DO75I=1,10
      WRITE(ICOUT,76)I,ISPICO(I)
   76 FORMAT('I,ISPICO(I) = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
   75 CONTINUE
   90 CONTINUE
C
C               **************************************
C               **  STEP 1--                        **
C               **  BRANCH TO THE APPROPRIATE CASE  **
C               **************************************
C
      ISTEPN='1'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.0)GOTO9000
      IF(NUMARG.EQ.1)GOTO1110
      IF(NUMARG.EQ.2)GOTO1120
      IF(NUMARG.EQ.3)GOTO1130
      GOTO1140
C
 1110 CONTINUE
      GOTO1200
C
 1120 CONTINUE
      IF(IHARG(2).EQ.'ALL')IHOLD1=IDEFSC
      IF(IHARG(2).EQ.'ALL')GOTO1300
      GOTO1200
C
 1130 CONTINUE
      IF(IHARG(2).EQ.'ALL')IHOLD1=IHARG(3)
      IF(IHARG(2).EQ.'ALL')GOTO1300
      IF(IHARG(3).EQ.'ALL')IHOLD1=IHARG(2)
      IF(IHARG(3).EQ.'ALL')GOTO1300
      GOTO1200
C
 1140 CONTINUE
      GOTO1200
C
C               *************************************************
C               **  STEP 2--                                   **
C               **  TREAT THE INDIVIDUAL SPECIFICATIONS CASE  **
C               *************************************************
C
 1200 CONTINUE
      ISTEPN='2'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.1)GOTO1210
      GOTO1220
C
 1210 CONTINUE
      NUMSPI=1
      ISPICO(1)=IDEFSC
      GOTO1270
C
 1220 CONTINUE
      NUMSPI=NUMARG-1
      IF(NUMSPI.GT.MAXSPI)NUMSPI=MAXSPI
      DO1225I=1,NUMSPI
      J=I+1
      IHOLD1=IHARG(J)
      IHOLD2=IHOLD1
      IF(IHOLD1.EQ.'ON')IHOLD2=IDEFSC
      IF(IHOLD1.EQ.'OFF')IHOLD2=IDEFSC
      IF(IHOLD1.EQ.'AUTO')IHOLD2=IDEFSC
      IF(IHOLD1.EQ.'DEFA')IHOLD2=IDEFSC
      ISPICO(I)=IHOLD2
 1225 CONTINUE
      GOTO1270
C
 1270 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO1279
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      DO1278I=1,NUMSPI
      WRITE(ICOUT,1276)I,ISPICO(I)
 1276 FORMAT('SPIKE COLOR ',I6,' HAS JUST BEEN SET TO ',
     1A4)
      CALL DPWRST('XXX','BUG ')
 1278 CONTINUE
 1279 CONTINUE
      IFOUND='YES'
      GOTO9000
C
C               **************************
C               **  STEP 2--            **
C               **  TREAT THE ALL CASE  **
C               **************************
C
 1300 CONTINUE
      ISTEPN='3'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NUMSPI=MAXSPI
      IHOLD2=IHOLD1
      IF(IHOLD1.EQ.'ON')IHOLD2=IDEFSC
      IF(IHOLD1.EQ.'OFF')IHOLD2=IDEFSC
      IF(IHOLD1.EQ.'AUTO')IHOLD2=IDEFSC
      IF(IHOLD1.EQ.'DEFA')IHOLD2=IDEFSC
      DO1315I=1,NUMSPI
      ISPICO(I)=IHOLD2
 1315 CONTINUE
      GOTO1370
C
 1370 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO1319
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      I=1
      WRITE(ICOUT,1316)ISPICO(I)
 1316 FORMAT('ALL SPIKE COLORS HAVE JUST BEEN SET TO ',
     1A4)
      CALL DPWRST('XXX','BUG ')
 1319 CONTINUE
      IFOUND='YES'
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGP2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPSPCO--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGP2,IFOUND,IERROR
 9012 FORMAT('IBUGP2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)MAXSPI,NUMSPI
 9013 FORMAT('MAXSPI,NUMSPI = ',I8,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IHOLD1,IHOLD2
 9014 FORMAT('IHOLD1,IHOLD2 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IDEFSC
 9015 FORMAT('IDEFSC = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9020)NUMARG
 9020 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9025I=1,NUMARG
      WRITE(ICOUT,9026)IHARG(I)
 9026 FORMAT('IHARG(I) = ',A4)
      CALL DPWRST('XXX','BUG ')
 9025 CONTINUE
      WRITE(ICOUT,9030)ISPICO(1)
 9030 FORMAT('ISPICO(1) = ',A4)
      CALL DPWRST('XXX','BUG ')
      DO9035I=1,10
      WRITE(ICOUT,9036)I,ISPICO(I)
 9036 FORMAT('I,ISPICO(I) = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9035 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPSPDI(IHARG,NUMARG,IDEFSD,MAXSPI,ISPIDI,
     1IBUGP2,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE SPIKE DIRECTION--
C              VERT = VERTICAL
C              HORI = HORIZONTAL
C              HOR2 = HORIZONTAL TOWARD X2-X3 PLANE (FOR 3D PLOTS)
C              THESE ARE LOCATED IN THE VECTOR ISPIDI(.).
C     INPUT  ARGUMENTS--IHARG  (A  CHARACTER VECTOR)
C                     --NUMARG
C                     --IDEFSD
C                     --MAXSPI
C                     --IBUGP2 ('ON' OR 'OFF' )
C     OUTPUT ARGUMENTS--ISPIDI (A CHARACTER VECTOR)
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--87/5
C     ORIGINAL VERSION--MAY       1987.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IDEFSD
      CHARACTER*4 ISPIDI
C
      CHARACTER*4 IBUGP2
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHOLD1
      CHARACTER*4 IHOLD2
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      DIMENSION IHARG(*)
      DIMENSION ISPIDI(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      ISUBN1='DPSP'
      ISUBN2='DI  '
C
      NUMSPI=0
      IHOLD1='-999'
      IHOLD2='-999'
C
      IF(IBUGP2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPSPDI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGP2,IFOUND,IERROR
   52 FORMAT('IBUGP2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)MAXSPI,NUMSPI
   53 FORMAT('MAXSPI,NUMSPI = ',I8,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IHOLD1,IHOLD2
   54 FORMAT('IHOLD1,IHOLD2 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IDEFSD
   55 FORMAT('IDEFSD = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,60)NUMARG
   60 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO65I=1,NUMARG
      WRITE(ICOUT,66)IHARG(I)
   66 FORMAT('IHARG(I) = ',A4)
      CALL DPWRST('XXX','BUG ')
   65 CONTINUE
      WRITE(ICOUT,70)ISPIDI(1)
   70 FORMAT('ISPIDI(1) = ',A4)
      CALL DPWRST('XXX','BUG ')
      DO75I=1,10
      WRITE(ICOUT,76)I,ISPIDI(I)
   76 FORMAT('I,ISPIDI(I) = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
   75 CONTINUE
   90 CONTINUE
C
C               **************************************
C               **  STEP 1--                        **
C               **  BRANCH TO THE APPROPRIATE CASE  **
C               **************************************
C
      ISTEPN='1'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.0)GOTO9000
      IF(NUMARG.EQ.1)GOTO1110
      IF(NUMARG.EQ.2)GOTO1120
      IF(NUMARG.EQ.3)GOTO1130
      GOTO1140
C
 1110 CONTINUE
      GOTO1200
C
 1120 CONTINUE
      IF(IHARG(2).EQ.'ALL')IHOLD1='VERT'
      IF(IHARG(2).EQ.'ALL')GOTO1300
      GOTO1200
C
 1130 CONTINUE
      IF(IHARG(2).EQ.'ALL')IHOLD1=IHARG(3)
      IF(IHARG(2).EQ.'ALL')GOTO1300
      IF(IHARG(3).EQ.'ALL')IHOLD1=IHARG(2)
      IF(IHARG(3).EQ.'ALL')GOTO1300
      GOTO1200
C
 1140 CONTINUE
      GOTO1200
C
C               *************************************************
C               **  STEP 2--                                   **
C               **  TREAT THE SINGLE     SPECIFICATION   CASE  **
C               *************************************************
C
 1200 CONTINUE
      ISTEPN='2'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.1)GOTO1210
      GOTO1220
C
 1210 CONTINUE
      NUMSPI=1
      ISPIDI(1)='VERT'
      GOTO1270
C
 1220 CONTINUE
      NUMSPI=NUMARG-1
      IF(NUMSPI.GT.MAXSPI)NUMSPI=MAXSPI
      DO1225I=1,NUMSPI
      J=I+1
      IHOLD1=IHARG(J)
      IHOLD2=IHOLD1
C???? IF(IHOLD1.EQ.'VERT')IHOLD2='VERT'
C???? IF(IHOLD1.EQ.'3')IHOLD2='3'
CCCCC IF(IHOLD1.EQ.'AUTO')IHOLD2=IDEFSD
CCCCC IF(IHOLD1.EQ.'DEFA')IHOLD2=IDEFSD
      ISPIDI(I)=IHOLD2
 1225 CONTINUE
      GOTO1270
C
 1270 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO1279
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      DO1278I=1,NUMSPI
      WRITE(ICOUT,1276)I,ISPIDI(I)
 1276 FORMAT('SPIKE DIRECTION ',I6,
     1' HAS JUST BEEN SET TO ',A4)
      CALL DPWRST('XXX','BUG ')
 1278 CONTINUE
 1279 CONTINUE
      IFOUND='YES'
      GOTO9000
C
C               **************************
C               **  STEP 3--            **
C               **  TREAT THE ALL CASE  **
C               **************************
C
 1300 CONTINUE
      ISTEPN='3'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NUMSPI=MAXSPI
      IHOLD2=IHOLD1
C???? IF(IHOLD1.EQ.'2')IHOLD2='2'
C???? IF(IHOLD1.EQ.'3')IHOLD2='3'
CCCCC IF(IHOLD1.EQ.'AUTO')IHOLD2=IDEFSD
CCCCC IF(IHOLD1.EQ.'DEFA')IHOLD2=IDEFSD
      DO1315I=1,NUMSPI
      ISPIDI(I)=IHOLD2
 1315 CONTINUE
      GOTO1370
C
 1370 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO1319
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      I=1
      WRITE(ICOUT,1316)ISPIDI(I)
 1316 FORMAT('ALL SPIKE DIRECTIONS',
     1'HAVE JUST BEEN SET TO ',A4)
      CALL DPWRST('XXX','BUG ')
 1319 CONTINUE
      IFOUND='YES'
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGP2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPSPDI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGP2,IFOUND,IERROR
 9012 FORMAT('IBUGP2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)MAXSPI,NUMSPI
 9013 FORMAT('MAXSPI,NUMSPI = ',I8,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IHOLD1,IHOLD2
 9014 FORMAT('IHOLD1,IHOLD2 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IDEFSD
 9015 FORMAT('IDEFSD = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9020)NUMARG
 9020 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9025I=1,NUMARG
      WRITE(ICOUT,9026)IHARG(I)
 9026 FORMAT('IHARG(I) = ',A4)
      CALL DPWRST('XXX','BUG ')
 9025 CONTINUE
      WRITE(ICOUT,9030)ISPIDI(1)
 9030 FORMAT('ISPIDI(1) = ',A4)
      CALL DPWRST('XXX','BUG ')
      DO9035I=1,10
      WRITE(ICOUT,9036)I,ISPIDI(I)
 9036 FORMAT('I,ISPIDI(I) = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9035 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPSPE2(Y1,Y2,N,NCURVE,ICASPL,NUMLAG,MAXN,
     1                  COV11,COV22,COV12,COV21,
     1                  Y,X,D,NPLOTP,NPLOTV,IBUGG3,ISUBRO,IERROR)
C
C     PURPOSE--GENERATE A PAIR OF COORDINATE VECTORS
C              THAT WILL DEFINE
C              1) AUTOSPECTRUM
C              2) CO-SPECTRUM;
C              3) QUADRATURE SPECTRUM;
C              4) CROSS-SPECTRUM (CO-SPECTRUM AND CROSS-SPECTRUM);
C              5) COHERENCY DIAGRAM;
C              6) AMPLITUDE DIAGRAM;
C              7) PHASE DIAGRAM;
C              8) GAIN DIAGRAM;
C              9) ARGAND DIAGRAM.
C      NOTE--FOR THE AUTOSPECTRAL PLOT, IN ORDER THAT THE RESULTS OF
C            THE TIME SERIES ANALYSIS BE VALID AND PROPERLY INTERPRETED,
C            THE INPUT DATA IN Y1 SHOULD BE EQUI-SPACED IN TIME
C            (OR WHATEVER VARIABLE CORRESPONDS TO TIME).
C
C              THE HORIZONTAL AXIS OF THE SPECTRA PRODUCED
C              BY THIS SUBROUTINE IS FREQUENCY.
C              THIS FREQUENCY IS MEASURED IN UNITS OF
C              CYCLES PER 'DATA POINT' OR, MORE PRECISELY, IN
C              CYCLES PER UNIT TIME WHERE
C              'UNIT TIME' IS DEFINED AS THE
C              ELAPSED TIME BETWEEN ADJACENT OBSERVATIONS.
C              THE RANGE OF THE FREQUENCY AXIS IS 0.0 TO 0.5.
C
C     INPUT ARGUMENTS--Y1     = THE SINGLE PRECISION VECTOR OF
C                               (UNSORTED) OBSERVATIONS
C                               FOR THE FIRST  VARIABLE.
C                    --Y2     = THE SINGLE PRECISION VECTOR OF
C                               (UNSORTED) OBSERVATIONS.
C                               FOR THE SECOND VARIABLE.
C                      N      = THE INTEGER NUMBER OF OBSERVATIONS
C                               IN THE VECTOR X.
C     PRINTING--YES.
C     RESTRICTIONS--THE SAMPLE SIZE N MUST BE
C                   SMALLER THAN OR EQUAL TO 1000.
C                 --THE SAMPLE SIZE N MUST BE GREATER
C                   THAN OR EQUAL TO 3.
C     OTHER DATAPAC   SUBROUTINES NEEDED--PLOTC0, PLOTSP, AND CHSPPF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--SQRT.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     COMMENT--THE 'FAST FOURIER TRANSFORM' IS NOT USED IN THIS VERSION,
C              BUT MAY BE IMPLEMENTED IN A FUTURE VEERSION.
C            --THE USUAL MAXIMUM NUMBER OF LAGS FOR WHICH THE
C              SPECTRUM IS COMPUTED IS N/4 WHERE N IS THE SAMPLE SIZE.
C              THIS RULE IS OVERRIDDEN IN LARGE DATA SETS AND IS
C              REPLACED BY THE RULE THAT THE MAXIMUM NUMBER OF
C              LAGS = 500.  IF MORE LAGS ARE DESIRED, CHANGE THE VALUE
C              OF THE VARIABLE     MAXLAG   WITHIN THIS SUBROUTINE
C              FROM 500 TO WHATEVER DESIRED, AND ALSO CHANGE THE
C              DIMENSION OF THE VECTOR R FROM ITS PRESENT 500 TO HOWEVER
C              MANY LAGS ARE DESIRED.
C            --IF THE INPUT OBSERVATIONS IN X ARE CONSIDERED
C              TO HAVE BEEN COLLECTED 1 SECOND APART IN TIME,
C              THEN THE FREQUENCY AXIS OF THE RESULTING
C              SPECTRA WOULD BE IN UNITS OF HERTZ
C              (= CYCLES PER SECOND).
C            --THE FREQUENCY OF 0.0 CORRESPONDS TO A CYCLE IN THE DATA
C              OF INFINITE (= 1/(0.0)) LENGTH OR PERIOD.
C              THE FREQUENCY OF 0.5 CORRESPONDS TO A CYCLE
C              IN THE DATA OF LENGTH = 1/(0.5) = 2 DATA POINTS.
C            --ANY EQUI-SPACED TIME SERIES ANALYSIS IS
C              INTRINSICALLY LIMITED TO DETECTING FREQUENCIES
C              NO LARGER THAN 0.5 CYCLES PER DATA POINT;
C              THIS CORRESPONDS TO THE FACT THAT THE
C              SMALLEST DETECTABLE CYCLE IN THE DATA
C              IS 2 DATA POINTS PER CYCLE.
C     REFERENCES--JENKINS AND WATTS, ESPECIALLY PAGE 290.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--MAY       1978.
C     UPDATED         --JULY      1979.
C     UPDATED         --JANUARY   1981.
C     UPDATED         --NOVEMBER  1981.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --MARCH     1982.
C     UPDATED         --MAY       1982.
C     UPDATED         --JANUARY   1988. (SPECTRUM POINTS FROM 120 TO
C                                       N/2 TO 1000
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IBUGG3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION Y1(*)
      DIMENSION Y2(*)
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION D(*)
C
      DIMENSION COV11(*)
      DIMENSION COV22(*)
      DIMENSION COV12(*)
      DIMENSION COV21(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
      DATA PI/3.14159265359/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPSP'
      ISUBN2='E2  '
C
      IERROR='NO'
C
      IF(IBUGG3.EQ.'ON' .OR. ISUBRO.EQ.'SPE2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,70)
   70   FORMAT('***** AT THE BEGINNING OF DPSPE2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,71)ICASPL,N,NUMLAG,MAXN
   71   FORMAT('ICASPL,N,NUMLAG,MAXN = ',A4,2X,3I8)
        CALL DPWRST('XXX','BUG ')
        DO73I=1,N
          WRITE(ICOUT,74)I,Y1(I),Y2(I)
   74     FORMAT('I, Y1(I), Y2(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
   73   CONTINUE
      ENDIF
C
      KMAX=0
      Y2BAR=0.0
      VARBY2=0.0
      COVB12=0.0
      ALK=0.0
      QK=0.0
      AMPLIT=0.0
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(N.LT.3)THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
   31   FORMAT('***** ERROR IN SPECTRAL PLOT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,32)
   32   FORMAT('      THE NUMBER OF OBSERVATIONS MUST BE AT LEAST 2.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,34)N
   34   FORMAT('      THE NUMBER OF OBSERVATIONS = ',I6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      HOLD=Y1(1)
      DO60I=1,N
        IF(Y1(I).NE.HOLD)GOTO69
   60 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,31)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)HOLD
   62 FORMAT('      ALL ELEMENTS IN Y1 ARE IDENTICALLY EQUAL TO ',G15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
   69 CONTINUE
C
C
C               ************************************************
C               **  STEP 1--                                  **
C               **  COMPUTE THE SAMPLE MEAN, VARIANCE AND     **
C               **  SUM OF SQUARED DEVIATIONS.                **
C               ************************************************
C
      AN=N
      SUM=0.0
      DO100I=1,N
       SUM=SUM+Y1(I)
  100 CONTINUE
      Y1BAR=SUM/AN
      SUM=0.0
      DO200I=1,N
        SUM=SUM+(Y1(I)-Y1BAR)*(Y1(I)-Y1BAR)
  200 CONTINUE
      SSQY1=SUM
      VARBY1=SSQY1/AN
      VARY1=SSQY1/(AN-1.0)
      SDY1=0.0
      IF(VARY1.GT.0.0)SDY1=SQRT(VARY1)
C
      IF(ICASPL.NE.'AUSP' .AND. ICASPL.NE.'AUPE')THEN
        SUM=0.0
        DO110I=1,N
          SUM=SUM+Y2(I)
  110   CONTINUE
        Y2BAR=SUM/AN
        SUM=0.0
        DO210I=1,N
          SUM=SUM+(Y2(I)-Y2BAR)*(Y2(I)-Y2BAR)
  210   CONTINUE
        SSQY2=SUM
        VARBY2=SSQY2/AN
        VARY2=SSQY2/(AN-1.0)
        SDY2=0.0
        IF(VARY2.GT.0.0)SDY2=SQRT(VARY2)
C
        SUM=0.0
        DO220I=1,N
          SUM=SUM+(Y1(I)-Y1BAR)*(Y2(I)-Y2BAR)
  220   CONTINUE
        SSQ12=SUM
        COVB12=SSQ12/AN
        COVB21=COVB12
      ENDIF
C
C               *********************************************
C               **  STEP 3--                               **
C               **  IF NECESSARY, COMPUTE THE MAXIMUM LAG  **
C               *********************************************
C
      MAXLAG=MAXN
      IF(NUMLAG.GE.1)KMAX=NUMLAG
      IF(NUMLAG.LE.0)KMAX=N/4
      IF(NUMLAG.LE.0.AND.N.LE.32)KMAX=N/2
      IF(NUMLAG.LE.0.AND.N.LE.16)KMAX=N
      IF(KMAX.GT.MAXLAG)KMAX=MAXLAG
      NM1=N-1
      IF(KMAX.GT.NM1)KMAX=NM1
      KMAXM1=KMAX-1
      AKMAXM=KMAXM1
C
C               *****************************************************
C               **  STEP 3--                                       **
C               **  COMPUTE THE AUTOCORRELATIONS FOR THE Y1 DATA.  **
C               **  REFERENCE--JENKINS AND WATTS, PAGE 382 (9.3.1) **
C               **  IF NECESSRY,                                   **
C               **  COMPUTE THE AUTOCORRELATIONS FOR THE Y2 DATA.  **
C               **  REFERENCE--JENKINS AND WATTS, PAGE 382 (9.3.3) **
C               **  IF NECESSRY,                                   **
C               **  COMPUTE THE SAMPLE CROSS-CORRELATIONS          **
C               **  REFERENCE--JENKINS AND WATTS, PAGE 383 (9.3.5) **
C               *****************************************************
C
      IF(ICASPL.NE.'AUSP' .AND. ICASPL.NE.'AUPE')GOTO399
      COV110=VARBY1
      COV220=VARBY2
      COV120=COVB12
      COV210=COVB12
      DO340K=1,KMAXM1
        SUM11=0.0
        SUM22=0.0
        SUM12=0.0
        SUM21=0.0
        NMK=N-K
        DO350I=1,NMK
          J=I+K
          SUM11=SUM11+(Y1(I)-Y1BAR)*(Y1(J)-Y1BAR)
          IF(ICASPL.NE.'AUSP')THEN
            SUM22=SUM22+(Y2(I)-Y2BAR)*(Y2(J)-Y2BAR)
            SUM12=SUM12+(Y1(I)-Y1BAR)*(Y2(J)-Y2BAR)
            SUM21=SUM21+(Y2(I)-Y2BAR)*(Y1(J)-Y1BAR)
          ENDIF
  350   CONTINUE
        COV11(K)=SUM11/AN
        IF(ICASPL.NE.'AUSP')THEN
          COV22(K)=SUM22/AN
          COV12(K)=SUM12/AN
          COV21(K)=SUM21/AN
        ENDIF
  340 CONTINUE
  399 CONTINUE
C
C
C               **************************************
C               **  STEP 4--                        **
C               **  BRANCH TO THE APPROPRIATE CASE  **
C               **  AND DETERMINE PLOT COORDINATES  **
C               **************************************
C
C               ********************************************************
C               **  STEP 4.1--                                        **
C               **  COMPUTE AUTOSPECTRA FOR Y1                        **
C               **  REFERENCE--JENKINS AND WATTS--PAGES 382 AND 383   **
C               **             (9.3.2 AND 9)                          **
C               ********************************************************
C
      IMAX=(N/2)
      IF(IMAX.LT.120)IMAX=120
      IF(IMAX.GT.1000)IMAX=1000
      AIMAX=IMAX
      NUMFRE=IMAX+1
C
      IF(ICASPL.EQ.'AUSP')THEN
C
        J=0
        DO1110IP1=2,NUMFRE
          J=J+1
          I=IP1-1
          AI=I
          SUM11=0.0
C
          DO1120K=1,KMAXM1
            AK=K
            ARG1=PI*AK/AKMAXM
            ARG2=PI*AI*AK/AIMAX
            WK=0.5*(1.0+COS(ARG1))
            AFACT=WK*COS(ARG2)
            SUM11=SUM11+COV11(K)*AFACT
 1120     CONTINUE
C
          FREQJ=0.5*AI/AIMAX
          SP11J=2.0*(COV110+2.0*SUM11)
          IF(SP11J.LE.0.0)SP11J=0.000001
C
          Y(J+NPLOTP)=SP11J
          X(J+NPLOTP)=FREQJ
          D(J+NPLOTP)=REAL(NCURVE)
C
 1110   CONTINUE
        NPLOTP=NPLOTP+J
        NPLOTV=2
C
C               ******************************************************
C               **  STEP 4.1--                                      **
C               **  COMPUTE AUTOPERIODOGRAM FOR Y1                  **
C               **  REFERENCE--JUNKINS AND WATTS--PAGES 21 AND 22   **
C               **             (2.1.12)                             **
C               ******************************************************
C
      ELSEIF(ICASPL.EQ.'AUPE')THEN
        NHALF=N/2
        NHALFP=NHALF+1
        IMAX=NHALFP
        IF(NHALFP.GT.MAXN)IMAX=MAXN
        IEVODD=N-2*(N/2)
        DEL=(AN+1.0)/2.0
        IF(IEVODD.EQ.0)DEL=(AN+2.0)/2.0
C
        J=0
        DO1610IP1=2,IMAX
          J=J+1
          I=IP1-1
          AI=I
          FREQI=AI/AN
          SUMA=0.0
          SUMB=0.0
C
          DO1620K=1,N
            AK=K
            OMEGA=2.0*PI*(AI/AN)
            SUMA=SUMA+Y1(K)*COS(OMEGA*(AK-DEL))
            SUMB=SUMB+Y1(K)*SIN(OMEGA*(AK-DEL))
            Z=AK-DEL
 1620     CONTINUE
          AICOEF=SUMA/AN
          BICOEF=SUMB/AN
          RSQ=AICOEF*AICOEF+BICOEF*BICOEF
          POWERI=2.0*RSQ
          IF(I.EQ.0)POWERI=POWERI/2.0
          IF(I.EQ.NHALF.AND.IEVODD.EQ.0)POWERI=POWERI/2.0
C
          IF(IBUGG3.EQ.'ON')THEN
            WRITE(ICOUT,1621)J,I,AI,AICOEF,BICOEF,RSQ,POWERI
 1621       FORMAT('J,I,AI,AICOEF,BICOEF,RSQ,POWERI = ',2I8,5G15.7)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
          Y(NPLOTP+J)=POWERI
          X(NPLOTP+J)=FREQI
          D(NPLOTP+J)=REAL(NCURVE)
C
 1610   CONTINUE
        NPLOTP=NPLOTP+J
        NPLOTV=2
      ELSE
C
C               *******************************************************
C               **  COMPUTE COSPECTRUM AND QUADRATURE SPECTRUM.      **
C               **  REFERENCE--JENKINS AND WATTS--PAGE 383           **
C               **             (9.3.8,9.3.9, 9.3.10, 9.3.11)         **
C               **  REFERENCE--GRANGER AND HATANAKA, PAGE 77-79.     **
C               **  COMPUTE COHERENCY PLOT.                          **
C               **  COMPUTE AMPLITUDE PLOT.                          **
C               **  COMPUTE PHASE PLOT.                              **
C               **  COMPUTE GAIN PLOT.                               **
C               **  COMPUTE ARGAND PLOT.                             **
C               *******************************************************
C
        J=0
        JPF=0
        DO2010IP1=1,NUMFRE
          J=J+1
          I=IP1-1
          AI=I
          SUM11=0.0
          SUM22=0.0
          SUM12=0.0
          SUM21=0.0
          AL0=(COV120+COV210)/2.0
          Q0=(COV120-COV210)/2.0
C
          DO2020K=1,KMAXM1
            AK=K
            ARG1=PI*AK/AKMAXM
            ARG2=PI*AI*AK/AIMAX
            WK=0.5*(1.0+COS(ARG1))
            AFACTC=WK*COS(ARG2)
            AFACTS=WK*SIN(ARG2)
            SUM11=SUM11+COV11(K)*AFACTC
            SUM22=SUM22+COV22(K)*AFACTC
            ALK=(COV12(K)+COV21(K))/2.0
            QK=(COV12(K)-COV21(K))/2.0
            SUM12=SUM12+ALK*AFACTC
            SUM21=SUM21+QK*AFACTS
 2020     CONTINUE
C
          FREQJ=0.5*AI/AIMAX
          SP11J=2.0*(COV110+2.0*SUM11)
          SP22J=2.0*(COV220+2.0*SUM22)
          COSPJ=2.0*(AL0+2.0*SUM12)
          QUSPJ=2.0*(Q0+2.0*SUM21)
C
          IF(IBUGG3.EQ.'ON' .OR. ISUBRO.EQ.'SPE2')THEN
            WRITE(ICOUT,2121)J,ALK,QK,SP11J,SP22J,COSPJ,QUSPJ
 2121       FORMAT('I,ALK,QK,SP11J,SP22J,COSPJ,QUSPJ = ',I8,6F10.5)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
          IF(ICASPL.EQ.'COSP')THEN
            Y(NPLOTP+J)=COSPJ
            X(NPLOTP+J)=FREQJ
            D(NPLOTP+J)=REAL(NCURVE)
          ELSEIF(ICASPL.EQ.'QUSP')THEN
            Y(NPLOTP+J)=QUSPJ
            X(NPLOTP+J)=FREQJ
            D(NPLOTP+J)=REAL(NCURVE)
          ELSEIF(ICASPL.EQ.'CRSP')THEN
            Y(NPLOTP+J)=COSPJ
            X(NPLOTP+J)=FREQJ
            IVAL=(NCURVE-1)*2+1
            D(NPLOTP+J)=REAL(IVAL)
            JPF=J+NUMFRE
            Y(JPF)=QUSPJ
            X(JPF)=FREQJ
            D(JPF)=REAL(IVAL+1)
          ELSEIF(ICASPL.EQ.'COHE')THEN
            ARG=(COSPJ**2)+(QUSPJ**2)
            AMPLIT=0.0
            IF(ARG.GT.0.0)AMPLIT=SQRT(ARG)
            Y(NPLOTP+J)=AMPLIT*AMPLIT/(SP11J*SP22J)
            X(NPLOTP+J)=FREQJ
            D(NPLOTP+J)=REAL(NCURVE)
          ELSEIF(ICASPL.EQ.'AMPL')THEN
            ARG=(COSPJ**2)+(QUSPJ**2)
            Y(NPLOTP+J)=0.0
            IF(ARG.GT.0.0)Y(NPLOTP+J)=SQRT(ARG)
            X(NPLOTP+J)=FREQJ
            D(NPLOTP+J)=REAL(NCURVE)
          ELSEIF(ICASPL.EQ.'PHAS')THEN
            ARG=-QUSPJ/COSPJ
            Y(NPLOTP+J)=ATAN(ARG)
            X(NPLOTP+J)=FREQJ
            D(NPLOTP+J)=REAL(NCURVE)
          ELSEIF(ICASPL.EQ.'GAIN')THEN
            ARG=(COSPJ**2)+(QUSPJ**2)
            AMPLIT=0.0
            IF(ARG.GT.0.0)AMPLIT=SQRT(ARG)
            Y(NPLOTP+J)=AMPLIT/SP11J
            X(NPLOTP+J)=FREQJ
            D(NPLOTP+J)=REAL(NCURVE)
          ELSEIF(ICASPL.EQ.'ARGA')THEN
            Y(NPLOTP+J)=COSPJ/SP11J
            X(NPLOTP+J)=QUSPJ/SP22J
            D(NPLOTP+J)=REAL(NCURVE)
          ELSE
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,31)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2312)
 2312       FORMAT('      AT BRANCH POINT 681--ICASPL NOT EQUAL TO')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2314)
 2314       FORMAT('      ONE OF THE ALLOWABLE 9--AUSP, COSP, QUSP,')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2315)
 2315       FORMAT('      CRSP, COHE, AMPL, PHAS, GAIN, ARGA.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2316)ICASPL
 2316       FORMAT('      ICASPL = ',A4)
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
C
 2010   CONTINUE
C
        NPLOTP=J
        IF(ICASPL.EQ.'CRSP')NPLOTP=JPF
        NPLOTV=2
        IF(ICASPL.EQ.'CRSP')NPLOTV=3
      ENDIF
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
      IF(IBUGG3.EQ.'ON' .OR. ISUBRO.EQ.'SPE2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSPE2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)ICASPL,IERROR,NPLOTP,NPLOTV
 9012   FORMAT('ICASPL,IERROR,NPLOTP,NPLOTV = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,NPLOTP
          WRITE(ICOUT,9016)I,Y(I),X(I),D(I)
 9016     FORMAT('I,Y(I),X(I),D(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSPEC(NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2,
     1                  IBUGG2,IBUGG3,IBUGQ,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--FORM
C              1) AUTOSPECTRUM
C              2) CO-SPECTRUM;
C              3) QUADRATURE SPECTRUM;
C              4) CROSS-SPECTRUM (CO-SPECTRUM AND CROSS-SPECTRUM);
C              5) COHERENCY DIAGRAM;
C              6) AMPLITUDE DIAGRAM;
C              7) PHASE DIAGRAM;
C              8) GAIN DIAGRAM;
C              9) ARGAND DIAGRAM.
C             10) PERIODOGRAM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--MAY       1978.
C     UPDATED         --JUNE      1978.
C     UPDATED         --JULY      1979.
C     UPDATED         --JANUARY   1981.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --JUNE      1990. TEMPORARY ARRAYS TO GARBAGE COMMON
C     UPDATED         --JANUARY   2012. USE DPPARS
C     UPDATED         --JANUARY   2012. SUPPORT FOR MULTIPLE AND
C                                       REPLICATION OPTIONS
C     UPDATED         --JANUARY   2012. ADD PERIODOGRAM HERE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IAND1
      CHARACTER*4 IAND2
      CHARACTER*4 IBUGG2
      CHARACTER*4 IBUGG3
      CHARACTER*4 IBUGQ
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 IFOUN1
      CHARACTER*4 IFOUN2
      CHARACTER*4 CARG0
      CHARACTER*4 CARG1
      CHARACTER*4 CARG12
      CHARACTER*4 CARG2
      CHARACTER*4 CARG3
C
      CHARACTER*4 IREPL
      CHARACTER*4 IMULT
      CHARACTER*4 ICASE
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=30)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOZZ.INC'
C
      DIMENSION Y1(MAXOBV)
      DIMENSION Y2(MAXOBV)
      DIMENSION COV11(MAXOBV)
      DIMENSION COV22(MAXOBV)
      DIMENSION COV12(MAXOBV)
      DIMENSION COV21(MAXOBV)
      DIMENSION XIDTEM(MAXOBV)
      DIMENSION XIDTE2(MAXOBV)
      DIMENSION XIDTE3(MAXOBV)
      DIMENSION XTEMP1(MAXOBV)
      DIMENSION XTEMP2(MAXOBV)
      DIMENSION ZY1(MAXOBV)
      DIMENSION ZY2(MAXOBV)
      DIMENSION XDESGN(MAXOBV,2)
C
      EQUIVALENCE (GARBAG(IGARB1),Y1(1))
      EQUIVALENCE (GARBAG(IGARB2),Y2(1))
      EQUIVALENCE (GARBAG(IGARB3),COV11(1))
      EQUIVALENCE (GARBAG(IGARB4),COV22(1))
      EQUIVALENCE (GARBAG(IGARB5),COV12(1))
      EQUIVALENCE (GARBAG(IGARB6),COV21(1))
      EQUIVALENCE (GARBAG(IGARB7),XTEMP1(1))
      EQUIVALENCE (GARBAG(IGARB8),XTEMP2(1))
      EQUIVALENCE (GARBAG(IGARB9),XIDTEM(1))
      EQUIVALENCE (GARBAG(IGAR10),XIDTE2(1))
      EQUIVALENCE (GARBAG(JGAR11),XIDTE3(1))
      EQUIVALENCE (GARBAG(JGAR12),ZY1(1))
      EQUIVALENCE (GARBAG(JGAR13),ZY2(1))
      EQUIVALENCE (GARBAG(JGAR14),XDESGN(1,1))
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
      IMULT='OFF'
      IREPL='OFF'
C
      ISUBN1='DPSP'
      ISUBN2='EC  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
C               *********************************************************
C               **  TREAT THE FOLLOWING CASES--                         *
C               **        1) AUTOSPECTRUM                               *
C               **        2) CO-SPECTRUM;                               *
C               **        3) QUADRATURE SPECTRUM;                       *
C               **        4) CROSS-SPECTRUM (CO-SPECTRUM AND            *
C               **           CROSS-SPECTRUM);                           *
C               **        5) COHERENCY DIAGRAM;                         *
C               **        6) PHASE DIAGRAM;                             *
C               **        7) GAIN DIAGRAM;                              *
C               **        8) ARGAND DIAGRAM.                            *
C               *********************************************************
C
      IF(IBUGG2.EQ.'ON' .OR. ISUBRO.EQ.'SPEC')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSPEC--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)ICASPL,IAND1,IAND2,MAXCOL
   52   FORMAT('ICASPL,IAND1,IAND2,MAXCOL = ',3(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)IBUGG2,IBUGG3,IBUGQ,ISUBRO
   53   FORMAT('IBUGG2,IBUGG3,IBUGQ,ISUBRO = ',3(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ***************************
C               **  STEP 1--             **
C               **  EXTRACT THE COMMAND  **
C               ***************************
C
      ISTEPN='1'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPEC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C               ******************************************************
C               **  STEP 1--                                        **
C               **  EXTRACT THE COMMAND                             **
C               **  LOOK FOR ONE OF THE FOLLOWING COMMANDS:         **
C               **    1) SPECTRAL PLOT Y                            **
C               **    2) MULTIPLE SPECTRAL PLOT Y1 ... YK           **
C               **    3) REPLICATED SPECTAL PLOT Y X1  X2           **
C               ******************************************************
C
C
      ISTEPN='1'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPEC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ILASTC=-9999
      ISTOP=MIN(5,NUMARG-1)
      DO90I=1,NUMARG
        IF(IHARG(I).EQ.'PLOT' .OR. IHARG(1).EQ.'DIAG')THEN
          ISTOP=I
          GOTO99
        ENDIF
   90 CONTINUE
   99 CONTINUE
C
      IFOUND='NO'
      DO100I=0,ISTOP
        IF(I.EQ.0)THEN
          CARG0='    '
          CARG1=ICOM
          CARG12=ICOM2
          CARG2=IHARG(I)
          CARG3=IHARG(I+1)
        ELSE
          IF(I.EQ.1)THEN
            CARG0=ICOM
          ELSE
            CARG0=IHARG(I-1)
          ENDIF
          CARG1=IHARG(I)
          CARG12=IHARG2(I)
          CARG2=IHARG(I+1)
          CARG3=IHARG(I+2)
        ENDIF
C
        IF(IHARG(I).EQ.'=')THEN
          IFOUND='NO'
          GOTO9000
        ELSEIF(CARG1.EQ.'AUTO' .AND. CARG2.EQ.'SPEC')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I+1)
          ICASPL='AUSP'
        ELSEIF(CARG1.EQ.'AUTO' .AND. CARG2.EQ.'PERI')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I+1)
          ICASPL='AUPE'
        ELSEIF(CARG1.EQ.'PERI')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I)
          ICASPL='AUPE'
        ELSEIF(CARG1.EQ.'AUTO')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I)
          ICASPL='AUSP'
        ELSEIF(CARG1.EQ.'CO  ' .AND. CARG2.EQ.'SPEC')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I+1)
          ICASPL='COSP'
        ELSEIF(CARG1.EQ.'COSP')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I)
          ICASPL='COSP'
        ELSEIF(CARG1.EQ.'QUAD' .AND. CARG2.EQ.'SPEC')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I+1)
          ICASPL='QUSP'
        ELSEIF(CARG1.EQ.'QUAD'.AND.CARG12.EQ.'RATU')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I)
          ICASPL='QUSP'
        ELSEIF(CARG1.EQ.'CROS' .AND. CARG2.EQ.'SPEC')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I+1)
          ICASPL='CRSP'
        ELSEIF(CARG1.EQ.'CROS' .AND. CARG12.EQ.'SSPE')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I)
          ICASPL='CRSP'
        ELSEIF(CARG1.EQ.'COHE' .AND. CARG2.EQ.'SPEC')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I+1)
          ICASPL='COHE'
        ELSEIF(CARG1.EQ.'COHE')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I)
          ICASPL='COHE'
        ELSEIF(CARG1.EQ.'AMPL' .AND. CARG2.EQ.'SPEC')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I+1)
          ICASPL='AMPL'
        ELSEIF(CARG1.EQ.'AMPL')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I)
          ICASPL='AMPL'
        ELSEIF(CARG1.EQ.'PHAS' .AND. CARG2.EQ.'SPEC')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I+1)
          ICASPL='PHAS'
        ELSEIF(CARG1.EQ.'PHAS')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I)
          ICASPL='PHAS'
        ELSEIF(CARG1.EQ.'GAIN' .AND. CARG2.EQ.'SPEC')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I+1)
          ICASPL='GAIN'
        ELSEIF(CARG1.EQ.'GAIN')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I)
          ICASPL='GAIN'
        ELSEIF(CARG1.EQ.'ARGA' .AND. CARG2.EQ.'SPEC')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I+1)
          ICASPL='ARGA'
        ELSEIF(CARG1.EQ.'ARGA')THEN
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I)
          ICASPL='ARGA'
        ELSEIF(CARG1.EQ.'SPEC' .AND. CARG0.NE.'CO  ' .AND.
     1         CARG0.NE.'QUAD' .AND. CARG0.NE.'CROS' .AND.
     1         CARG0.NE.'COHE' .AND. CARG0.NE.'AMPL' .AND.
     1         CARG0.NE.'PHAS' .AND. CARG0.NE.'GAIN' .AND.
     1         CARG0.NE.'ARGA')THEN
    
          IFOUN1='YES'
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I)
          ICASPL='AUSP'
        ELSEIF(CARG1.EQ.'PLOT' .OR. CARG1.EQ.'DIAG')THEN
          IFOUN2='YES'
          ILASTC=MAX(ILASTC,I)
        ELSEIF(CARG1.EQ.'REPL')THEN
          IREPL='ON'
        ELSEIF(CARG1.EQ.'MULT')THEN
          IMULT='ON'
        ENDIF
  100 CONTINUE
C
      IF(IFOUN1.EQ.'YES' .AND. IFOUN2.EQ.'YES')IFOUND='YES'
      IF(IFOUND.EQ.'NO')GOTO9000
C
      IF(IMULT.EQ.'ON')THEN
        IF(IREPL.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,101)
  101     FORMAT('***** ERROR IN SPECTRAL/PERIODOGRAM PLOT--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,102)
  102     FORMAT('      YOU CANNOT SPECIFY BOTH "MULTIPLE" AND ',
     1           '"REPLICATION" FOR THE SPECTRAL PLOT.')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
        IF(ICASPL.NE.'AUSP' .AND. ICASPL.NE.'AUPE')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,101)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,107)
  107     FORMAT('      THE "MULTIPLE" OPTION IS ONLY SUPPORTED FOR')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,109)
  109     FORMAT('      AUTO SPECTRAL PLOT.')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
      ENDIF
C
      IF(ILASTC.GE.1)THEN
        CALL ADJUST(ILASTC,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
        ILASTC=0
      ENDIF
C
      IF(IBUGG2.EQ.'ON' .OR. ISUBRO.EQ.'SPEC')THEN
        WRITE(ICOUT,112)ICASPL,IMULT,IREPL
  112   FORMAT('ICASPL,IMULT,IREPL = ',2(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ****************************************
C               **  STEP 2--                          **
C               **  EXTRACT THE VARIABLE LIST         **
C               ****************************************
C
      ISTEPN='2'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPEC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='SPECTRAL PLOT'
      IF(ICASPL.EQ.'AUPE')INAME='PERIODOGRAM'
      MINNA=1
      MAXNA=100
      MINN2=1
      IFLAGE=1
      IF(IMULT.EQ.'ON')IFLAGE=0
      IFLAGM=1
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
      IF(ICASPL.EQ.'AUSP' .OR. ICASPL.EQ.'AUPE')THEN
        MINNVA=1
        MAXNVA=1
      ELSE
        MINNVA=2
        MAXNVA=2
      ENDIF
      IF(IREPL.EQ.'ON')THEN
        MINNVA=MINNVA+1
        MAXNVA=MAXNVA+2
      ELSEIF(IMULT.EQ.'ON')THEN
        MINNVA=1
        MAXNVA=MAXSPN
      ENDIF
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGG3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPEC')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
      NRESP=0
      NREPL=0
      IF(ICASPL.EQ.'AUSP' .OR. ICASPL.EQ.'AUPE')THEN
        IF(IREPL.EQ.'OFF' .AND. NUMVAR.GT.1)IMULT='ON'
      ENDIF
      IF(IMULT.EQ.'ON')THEN
        NRESP=NUMVAR
      ELSEIF(IREPL.EQ.'ON')THEN
        NRESP=1
        NREPL=NUMVAR-NRESP
        IF(NREPL.LT.1 .OR. NREPL.GT.2)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,101)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,511)
  511     FORMAT('      FOR THE REPLICATION CASE, THE NUMBER OF ',
     1           'REPLICATION VARIABLES')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,512)
  512     FORMAT('      MUST BE BETWEEN 1 AND 2;  SUCH WAS NOT THE ',
     1           'CASE HERE.')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,513)NREPL
  513     FORMAT('      THE NUMBER OF REPLICATION VARIABLES = ',I5)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
      ELSE
        NRESP=1
      ENDIF
C
C               **********************************************************
C               **  STEP 3--                                            **
C               **  DETERMINE IF THE ANALYST HAS SPECIFIED THE NUMBER   **
C               **  OF LAGS DESIRED FOR THE CROSS-SPECTRAL ANALYSIS.    **
C               **  SEARCH FOR THE USER DEFINED PARAMETERS LAGS, LAG,   **
C               **  INTERNAL TABLE FOR THE PARAMETER NAMES              **
C               **  OR NUMLAG (WITH THE SEARCH CONDUCTED IN THAT ORDER  **
C               **  AND WITH THE FIRST FIND TERMINATING THE SEARCH.     **
C               **  IF FOUND, USE THE SPECIFIED VALUE (WHICH MUST BE    **
C               **  BETWEEN 1 AND 1000, INCLUSIVE);  IF NOT FOUUND, USE **
C               **  THE DEFAULT VALUE (USUALLY NS/4) WHICH WILL BE      **
C               **  DEFINED IN THE SUBROUTINE DPSPE2.                   **
C               **********************************************************
C
      ISTEPN='3'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPEC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NUMLAG=0
      IF(ICASPL.EQ.'AUPE')GOTO390
C
      IH='LAGS'
      IH2='    '
      IHWUSE='P'
      MESSAG='NO'
      CALL CHECKN(IH,IH2,IHWUSE,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCV,IERROR)
      IF(IERROR.EQ.'NO')THEN
        NUMLAG=VALUE(ILOCV)+0.5
        GOTO390
      ENDIF
C
      IH='LAG '
      IH2='    '
      IHWUSE='P'
      MESSAG='NO'
      CALL CHECKN(IH,IH2,IHWUSE,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCV,IERROR)
      IF(IERROR.EQ.'NO')THEN
        NUMLAG=VALUE(ILOCV)+0.5
        GOTO390
      ENDIF
C
      IH='NUML'
      IH2='AG  '
      IHWUSE='P'
      MESSAG='NO'
      CALL CHECKN(IH,IH2,IHWUSE,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCV,IERROR)
      IF(IERROR.EQ.'NO')NUMLAG=VALUE(ILOCV)+0.5
C
  390 CONTINUE
C
C               ********************************************
C               **  STEP 6--                              **
C               **  GENERATE THE SPECTRAL       PLOTS FOR **
C               **  THE VARIOUS CASES.                    **
C               ********************************************
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPEC')THEN
        ISTEPN='6'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,601)NRESP,NREPL
  601   FORMAT('NRESP,NREPL = ',2I5)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(NREPL.EQ.0)THEN
        ISTEPN='8A'
        IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPEC')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C       LOOP THROUGH EACH OF THE RESPONSE VARIABLES
C
        NPLOTP=0
        DO810IRESP=1,NRESP
          NCURVE=IRESP
C
          IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPEC')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,811)IRESP,NCURVE
  811       FORMAT('IRESP,NCURVE = ',2I5)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
          ICOL=IRESP
          NUMVA2=2
          IF(ICASPL.EQ.'AUSP' .OR. ICASPL.EQ.'AUPE')NUMVA2=1
          CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1                INAME,IVARN1,IVARN2,IVARTY,
     1                ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1                MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1                MAXCP4,MAXCP5,MAXCP6,
     1                V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1                Y1,Y2,XTEMP2,NS,NS,NS,ICASE,
     1                IBUGG3,ISUBRO,IFOUND,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
C
C               *****************************************************
C               **  STEP 8B--                                      **
C               **  FORM THE VERTICAL AND HORIZONTAL AXIS          **
C               **  VALUES Y(.) AND X(.) FOR THE PLOT.             **
C               *****************************************************
C
          CALL DPSPE2(Y1,Y2,NS,NCURVE,ICASPL,NUMLAG,MAXN,
     1                COV11,COV22,COV12,COV21,
     1                Y,X,D,NPLOTP,NPLOTV,IBUGG3,ISUBRO,IERROR)
C
  810   CONTINUE
C
C               *****************************************************
C               **  STEP 9A--                                      **
C               **  CASE 3: ONE OR TWO  REPLICATION VARIABLES.     **
C               **          FOR THIS CASE, THE NUMBER OF RESPONSE  **
C               **          VARIABLES MUST BE EXACTLY 1.           **
C               *****************************************************
C
      ELSEIF(NREPL.GE.1)THEN
        ISTEPN='9A'
        IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPEC')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        J=0
        IMAX=NRIGHT(1)
        IF(NQ.LT.NRIGHT(1))IMAX=NQ
        DO910I=1,IMAX
          IF(ISUB(I).EQ.0)GOTO910
          J=J+1
C
C         RESPONSE VARIABLE IN Y1
C
          IJ=MAXN*(ICOLR(1)-1)+I
          IF(ICOLR(1).LE.MAXCOL)Y1(J)=V(IJ)
          IF(ICOLR(1).EQ.MAXCP1)Y1(J)=PRED(I)
          IF(ICOLR(1).EQ.MAXCP2)Y1(J)=RES(I)
          IF(ICOLR(1).EQ.MAXCP3)Y1(J)=YPLOT(I)
          IF(ICOLR(1).EQ.MAXCP4)Y1(J)=XPLOT(I)
          IF(ICOLR(1).EQ.MAXCP5)Y1(J)=X2PLOT(I)
          IF(ICOLR(1).EQ.MAXCP6)Y1(J)=TAGPLO(I)
          ICOLC=1
C
C         SECOND RESPONSE VARIABLE IN Y2
C
          IF(ICASPL.NE.'AUSP' .AND. ICASPL.NE.'AUPE')THEN
            IJ=MAXN*(ICOLR(2)-1)+I
            IF(ICOLR(2).LE.MAXCOL)Y2(J)=V(IJ)
            IF(ICOLR(2).EQ.MAXCP1)Y2(J)=PRED(I)
            IF(ICOLR(2).EQ.MAXCP2)Y2(J)=RES(I)
            IF(ICOLR(2).EQ.MAXCP3)Y2(J)=YPLOT(I)
            IF(ICOLR(2).EQ.MAXCP4)Y2(J)=XPLOT(I)
            IF(ICOLR(2).EQ.MAXCP5)Y2(J)=X2PLOT(I)
            IF(ICOLR(2).EQ.MAXCP6)Y2(J)=TAGPLO(I)
            ICOLC=2
          ENDIF
C
          DO920IR=1,MIN(NREPL,2)
            ICOLC=ICOLC+1
            ICOLT=ICOLR(ICOLC)
            IJ=MAXN*(ICOLT-1)+I
            IF(ICOLT.LE.MAXCOL)XDESGN(J,IR)=V(IJ)
            IF(ICOLT.EQ.MAXCP1)XDESGN(J,IR)=PRED(I)
            IF(ICOLT.EQ.MAXCP2)XDESGN(J,IR)=RES(I)
            IF(ICOLT.EQ.MAXCP3)XDESGN(J,IR)=YPLOT(I)
            IF(ICOLT.EQ.MAXCP4)XDESGN(J,IR)=XPLOT(I)
            IF(ICOLT.EQ.MAXCP5)XDESGN(J,IR)=X2PLOT(I)
            IF(ICOLT.EQ.MAXCP6)XDESGN(J,IR)=TAGPLO(I)
  920     CONTINUE
C
  910   CONTINUE
        NLOCAL=J
C
C       *****************************************************
C       **  STEP 9B--                                      **
C       **  FORM THE VERTICAL AND HORIZONTAL AXIS          **
C       **  VALUES Y(.) AND X(.) FOR THE PLOT.             **
C       **                                                 **
C       **  FOR THIS CASE, WE NEED TO LOOP THROUGH THE     **
C       **  VARIOUS REPLICATIONS.                          **
C       *****************************************************
C
        ISTEPN='9B'
        IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPEC')THEN
          CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,931)
  931     FORMAT('***** FROM THE MIDDLE  OF DPSPEC--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,932)ICASPL,NUMVAR,NLOCAL
  932     FORMAT('ICASPL,NUMVAR,NQ = ',A4,2I8)
          CALL DPWRST('XXX','BUG ')
          IF(NLOCAL.GE.1)THEN
            DO935I=1,NLOCAL
              WRITE(ICOUT,936)I,Y1(I),XDESGN(I,1),XDESGN(I,2)
  936         FORMAT('I,Y1(I),XDESGN(I,1),XDESGN(I,2) = ',I8,3F12.5)
              CALL DPWRST('XXX','BUG ')
  935       CONTINUE
          ENDIF
        ENDIF
C
C       *****************************************************
C       **  STEP 9C--                                      **
C       **  FIND THE DISTINCT VALUES IN EACH OF THE        **
C       **  REPLICATION VARIABLES.                         **
C       *****************************************************
C
        CALL DPFRE5(XDESGN(1,1),XDESGN(1,2),
     1             NREPL,NLOCAL,MAXOBV,
     1             XIDTEM,XIDTE2,
     1             XTEMP1,XTEMP2,
     1             NUMSE1,NUMSE2,
     1             IBUGG3,ISUBRO,IERROR)
C
C       *****************************************************
C       **  STEP 9D--                                      **
C       **  NOW LOOP THROUGH THE VARIOUS REPLICATIONS      **
C       *****************************************************
C
        NPLOTP=0
        NCURVE=0
        IF(NREPL.EQ.1)THEN
          J=0
          DO1110ISET1=1,NUMSE1
            K=0
            DO1130I=1,NLOCAL
              IF(XIDTEM(ISET1).EQ.XDESGN(I,1))THEN
                K=K+1
                ZY1(K)=Y1(I)
                ZY2(K)=Y2(I)
              ENDIF
 1130       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            IF(NTEMP.GT.0)THEN
              CALL DPSPE2(ZY1,ZY2,NTEMP,NCURVE,ICASPL,NUMLAG,MAXN,
     1                    COV11,COV22,COV12,COV21,
     1                    Y,X,D,NPLOTP,NPLOTV,IBUGG3,ISUBRO,IERROR)
            ENDIF
 1110     CONTINUE
        ELSEIF(NREPL.EQ.2)THEN
          J=0
          NTOT=NUMSE1*NUMSE2
          DO1210ISET1=1,NUMSE1
          DO1220ISET2=1,NUMSE2
            K=0
            DO1290I=1,NLOCAL
              IF(
     1           XIDTEM(ISET1).EQ.XDESGN(I,1) .AND.
     1           XIDTE2(ISET2).EQ.XDESGN(I,2)
     1          )THEN
                K=K+1
                ZY1(K)=Y1(I)
                ZY2(K)=Y2(I)
              ENDIF
 1290       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            IF(NTEMP.GT.0)THEN
              CALL DPSPE2(ZY1,ZY2,NTEMP,NCURVE,ICASPL,NUMLAG,MAXN,
     1                    COV11,COV22,COV12,COV21,
     1                    Y,X,D,NPLOTP,NPLOTV,IBUGG3,ISUBRO,IERROR)
            ENDIF
 1220     CONTINUE
 1210     CONTINUE
        ENDIF
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG2.EQ.'ON' .OR. ISUBRO.EQ.'SPEC')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSPEC--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IFOUND,IERROR,NUMLAG,MAXN
 9012   FORMAT('IFOUND,IERROR,NUMLAG,MAXN = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2
 9013   FORMAT('NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2 = ',3I8,3(2X,A4))
        CALL DPWRST('XXX','BUG ')
        IF(NPLOTP.GE.1)THEN
          DO9015I=1,NPLOTP
            WRITE(ICOUT,9016)I,Y(I),X(I),D(I)
 9016       FORMAT('I,Y(I),X(I),D(I) = ',I8,3F12.5)
            CALL DPWRST('XXX','BUG ')
 9015     CONTINUE
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSPL(IBUGA2,IBUGA3,IBUGQ,ISUBRO,
     1                 ICASAN,ICAPSW,IFORSW,
     1                 IFOUND,IERROR)
C
C     PURPOSE--CARRY OUT A SPLINE FIT
C              (ANY DEGREE FROM 1 TO 10).
C     NOTE--FOR A GIVEN DEGREE, ALL LOW-ORDER
C           DERIVATIVES WILL BE SET SO THAT THE FUNCTION
C           WILL BE SMOOTH AT THE KNOTS.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--DECEMBER  1978.
C     UPDATED         --JUNE      1978.
C     UPDATED         --JULY      1978.
C     UPDATED         --OCTOBER   1978.
C     UPDATED         --NOVEMBER  1978.
C     UPDATED         --MARCH     1981.
C     UPDATED         --JULY      1981.
C     UPDATED         --AUGUST    1981.
C     UPDATED         --SEPTEMBER 1981.
C     UPDATED         --NOVEMBER  1981.
C     UPDATED         --MARCH     1982.
C     UPDATED         --MAY       1982.
C     UPDATED         --MARCH     1988. ADD LOFCDF
C     UPDATED         --JUNE      1990. TEMPORARY ARRAYS TO GARBAGE
C                                       COMMON
C                                       MOVE SOME DIMENSIONS TO DPSPL
C     UPDATED         --MAY       2009. REPLACE USE OF DPSWAP WITH
C                                       BUILT-IN SWAP SPACE
C
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASAN
      CHARACTER*4 ICAPSW
      CHARACTER*4 IFORSW
      CHARACTER*4 IBUGA2
      CHARACTER*4 IBUGA3
      CHARACTER*4 IBUGQ
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 ICASSF
      CHARACTER*4 ICASEQ
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 IH 
      CHARACTER*4 IH2
      CHARACTER*4 IOP
      CHARACTER*4 IREPU
      CHARACTER*4 IRESU
      CHARACTER*4 IBUGJU
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ICASE
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=10)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      REAL PID(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOZZ.INC'
      INCLUDE 'DPCOZ2.INC'
C
      DIMENSION B(100)
      DIMENSION SDB(100)
      DIMENSION B2(100)
      DIMENSION SDB2(100)
      DIMENSION BTEMP(100)
      DIMENSION EKNOT(200)
      DIMENSION XPY(50)
      DIMENSION RIGHT(50)
      DIMENSION XPX(50,50)
      DIMENSION SSQ(50,50)
      DIMENSION A(50,50)
C
      DIMENSION PRED2(MAXOBV)
      DIMENSION RES2(MAXOBV)
      DIMENSION XKNOT(MAXOBV)
      DIMENSION W(MAXOBV)
      DIMENSION VSCRT(10*MAXOBV)
      DIMENSION V1(MAXOBV)
      DIMENSION V2(MAXOBV)
      DIMENSION DUM1(MAXOBV)
      DIMENSION DUM2(MAXOBV)
      DIMENSION AJUNK(MAXOBV)
C
      EQUIVALENCE (XKNOT(1),X3D(1))
      EQUIVALENCE (W(1),D(1))
      EQUIVALENCE (GARBAG(IGARB1),PRED2(1))
      EQUIVALENCE (GARBAG(IGARB2),RES2(1))
      EQUIVALENCE (GARBAG(IGARB3),V1(1))
      EQUIVALENCE (GARBAG(IGARB4),V2(1))
      EQUIVALENCE (GARBAG(IGARB5),DUM1(1))
      EQUIVALENCE (GARBAG(IGARB6),DUM2(1))
      EQUIVALENCE (GARBAG(IGARB7),AJUNK(1))
      EQUIVALENCE (GARBAG(IGARB8),SDB(1))
      EQUIVALENCE (GARBAG(IGARB8+100),SDB2(1))
      EQUIVALENCE (GARBAG(IGARB8+200),B(1))
      EQUIVALENCE (GARBAG(IGARB8+300),B2(1))
      EQUIVALENCE (GARBAG(IGARB8+400),XPY(1))
      EQUIVALENCE (GARBAG(IGARB8+500),RIGHT(1))
      EQUIVALENCE (GARBAG(IGARB8+600),BTEMP(1))
      EQUIVALENCE (GARBAG(IGARB8+700),EKNOT(1))
      EQUIVALENCE (GARBAG(IGARB9),XPX(1,1))
      EQUIVALENCE (GARBAG(IGARB9+5000),SSQ(1,1))
      EQUIVALENCE (GARBAG(IGARB9+10000),A(1,1))
      EQUIVALENCE (G2RBAG(1),VSCRT(1))
CCCCC END CHANGE
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOMC.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCOSU.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOST.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPSP'
      ISUBN2='L   '
C
      IERROR='NO'
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
C               *********************************
C               **  TREAT THE SPLINE FIT CASE  **
C               *********************************
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'PSPL')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSPL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)IBUGA2,IBUGA3,IBUGQ,ISUBRO
   53   FORMAT('IBUGA2,IBUGA3,IBUGQ,ISUBRO = ',3(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ***************************
C               **  STEP 1--             **
C               **  EXTRACT THE COMMAND  **
C               ***************************
C
      ISTEPN='1'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'PSPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C               *********************************
C               **  STEP 1.1--                 **
C               **  SEARCH FOR SPLINE FIT      **
C               **  (WITH UNSPECIFIED DEGREE)  **
C               *********************************
C
C
      IF(ICOM.EQ.'SPLI'.AND.NUMARG.GE.1.AND.IHARG(1).EQ.'FIT')THEN
        ICASSF='SF'
        ILASTC=1
C
C               *********************************************
C               **  STEP 1.21--                            **
C               **  SEARCH FOR 1-ST DEGREE SPLINE FITTING  **
C               *********************************************
C
      ELSEIF(NUMARG.GE.4.AND.
     1       ICOM.EQ.'1'.AND.IHARG(1).EQ.'ST'.AND.
     1       IHARG(2).EQ.'DEGR'.AND.IHARG(3).EQ.'SPLI'.AND.
     1       IHARG(4).EQ.'FIT')THEN
        ICASSF='1SF'
        ILASTC=4
      ELSEIF(NUMARG.GE.3.AND.
     1      (ICOM.EQ.'1ST' .OR. ICOM.EQ.'FIRS' .OR. ICOM.EQ.'1' .OR.
     1       ICOM.EQ.'ONE').AND.
     1       IHARG(1).EQ.'DEGR'.AND.IHARG(2).EQ.'SPLI'.AND.
     1       IHARG(3).EQ.'FIT')THEN
        ICASSF='1SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.3.AND.
     1       ICOM.EQ.'DEGR'.AND.
     1       (IHARG(1).EQ.'1' .OR. IHARG(1).EQ.'ONE').AND.
     1       IHARG(2).EQ.'SPLI'.AND.IHARG(3).EQ.'FIT')THEN
        ICASSF='1SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.2.AND.
     1       ICOM.EQ.'LINE'.AND.IHARG(1).EQ.'SPLI'.AND.
     1       IHARG(2).EQ.'FIT')THEN
        ICASSF='1SF'
        ILASTC=2
C
C               *********************************************
C               **  STEP 1.22--                            **
C               **  SEARCH FOR 2-ND DEGREE SPLINE FITTING  **
C               *********************************************
C
      ELSEIF(NUMARG.GE.4.AND.
     1       ICOM.EQ.'2'.AND.IHARG(1).EQ.'ND'.AND.
     1       IHARG(2).EQ.'DEGR'.AND.IHARG(3).EQ.'SPLI'.AND.
     1       IHARG(4).EQ.'FIT')THEN
        ICASSF='2SF'
        ILASTC=4
      ELSEIF(NUMARG.GE.3.AND.
     1      (ICOM.EQ.'2ND' .OR. ICOM.EQ.'SECO' .OR. ICOM.EQ.'2' .OR.
     1       ICOM.EQ.'TWO').AND.
     1       IHARG(1).EQ.'DEGR'.AND.IHARG(2).EQ.'SPLI'.AND.
     1       IHARG(3).EQ.'FIT')THEN
        ICASSF='2SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.3.AND.
     1       ICOM.EQ.'DEGR'.AND.
     1       (IHARG(1).EQ.'2' .OR. IHARG(1).EQ.'SECO').AND.
     1       IHARG(2).EQ.'SPLI'.AND.IHARG(3).EQ.'FIT')THEN
        ICASSF='2SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.2.AND.
     1       ICOM.EQ.'QUAD'.AND.IHARG(1).EQ.'SPLI'.AND.
     1       IHARG(2).EQ.'FIT')THEN
        ICASSF='2SF'
        ILASTC=2
C
C               *********************************************
C               **  STEP 1.23--                            **
C               **  SEARCH FOR 3-RD DEGREE SPLINE FITTING  **
C               *********************************************
C
C
      ELSEIF(NUMARG.GE.4.AND.
     1       ICOM.EQ.'3'.AND.IHARG(1).EQ.'RD'.AND.
     1       IHARG(2).EQ.'DEGR'.AND.IHARG(3).EQ.'SPLI'.AND.
     1       IHARG(4).EQ.'FIT')THEN
        ICASSF='3SF'
        ILASTC=4
      ELSEIF(NUMARG.GE.3.AND.
     1      (ICOM.EQ.'3RD' .OR. ICOM.EQ.'THIR' .OR. ICOM.EQ.'3' .OR.
     1       ICOM.EQ.'THRE').AND.
     1       IHARG(1).EQ.'DEGR'.AND.IHARG(2).EQ.'SPLI'.AND.
     1       IHARG(3).EQ.'FIT')THEN
        ICASSF='3SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.3.AND.
     1       ICOM.EQ.'DEGR'.AND.
     1       (IHARG(1).EQ.'3' .OR. IHARG(1).EQ.'THIR').AND.
     1       IHARG(2).EQ.'SPLI'.AND.IHARG(3).EQ.'FIT')THEN
        ICASSF='3SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.2.AND.
     1       ICOM.EQ.'CUBI'.AND.IHARG(1).EQ.'SPLI'.AND.
     1       IHARG(2).EQ.'FIT')THEN
        ICASSF='3SF'
        ILASTC=2
C
C               *********************************************
C               **  STEP 1.24--                            **
C               **  SEARCH FOR 4-TH DEGREE SPLINE FITTING  **
C               *********************************************
C
      ELSEIF(NUMARG.GE.4.AND.
     1       ICOM.EQ.'4'.AND.IHARG(1).EQ.'TH'.AND.
     1       IHARG(2).EQ.'DEGR'.AND.IHARG(3).EQ.'SPLI'.AND.
     1       IHARG(4).EQ.'FIT')THEN
        ICASSF='4SF'
        ILASTC=4
      ELSEIF(NUMARG.GE.3.AND.
     1      (ICOM.EQ.'4TH' .OR. ICOM.EQ.'FOUR' .OR. ICOM.EQ.'4').AND.
     1       IHARG(1).EQ.'DEGR'.AND.IHARG(2).EQ.'SPLI'.AND.
     1       IHARG(3).EQ.'FIT')THEN
        ICASSF='4SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.3.AND.
     1       ICOM.EQ.'DEGR'.AND.
     1       (IHARG(1).EQ.'4' .OR. IHARG(1).EQ.'FOUR').AND.
     1       IHARG(2).EQ.'SPLI'.AND.IHARG(3).EQ.'FIT')THEN
        ICASSF='4SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.2.AND.
     1       ICOM.EQ.'QUAR'.AND.IHARG(1).EQ.'SPLI'.AND.
     1       IHARG(2).EQ.'FIT')THEN
        ICASSF='4SF'
        ILASTC=2
C
C               *********************************************
C               **  STEP 1.25--                            **
C               **  SEARCH FOR 5-TH DEGREE SPLINE FITTING  **
C               *********************************************
C
      ELSEIF(NUMARG.GE.4.AND.
     1       ICOM.EQ.'5'.AND.IHARG(1).EQ.'TH'.AND.
     1       IHARG(2).EQ.'DEGR'.AND.IHARG(3).EQ.'SPLI'.AND.
     1       IHARG(4).EQ.'FIT')THEN
        ICASSF='5SF'
        ILASTC=4
      ELSEIF(NUMARG.GE.3.AND.
     1      (ICOM.EQ.'5TH' .OR. ICOM.EQ.'FIVE' .OR. ICOM.EQ.'5').AND.
     1       IHARG(1).EQ.'DEGR'.AND.IHARG(2).EQ.'SPLI'.AND.
     1       IHARG(3).EQ.'FIT')THEN
        ICASSF='5SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.3.AND.
     1       ICOM.EQ.'DEGR'.AND.
     1       (IHARG(1).EQ.'5' .OR. IHARG(1).EQ.'FIVE').AND.
     1       IHARG(2).EQ.'SPLI'.AND.IHARG(3).EQ.'FIT')THEN
        ICASSF='5SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.2.AND.
     1       ICOM.EQ.'QUIN'.AND.IHARG(1).EQ.'SPLI'.AND.
     1       IHARG(2).EQ.'FIT')THEN
        ICASSF='5SF'
        ILASTC=2
C
C               *********************************************
C               **  STEP 1.26--                            **
C               **  SEARCH FOR 6-TH DEGREE SPLINE FITTING  **
C               *********************************************
C
      ELSEIF(NUMARG.GE.4.AND.
     1       ICOM.EQ.'6'.AND.IHARG(1).EQ.'TH'.AND.
     1       IHARG(2).EQ.'DEGR'.AND.IHARG(3).EQ.'SPLI'.AND.
     1       IHARG(4).EQ.'FIT')THEN
        ICASSF='6SF'
        ILASTC=4
      ELSEIF(NUMARG.GE.3.AND.
     1      (ICOM.EQ.'6TH' .OR. ICOM.EQ.'SIX ' .OR. ICOM.EQ.'6').AND.
     1       IHARG(1).EQ.'DEGR'.AND.IHARG(2).EQ.'SPLI'.AND.
     1       IHARG(3).EQ.'FIT')THEN
        ICASSF='6SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.3.AND.
     1       ICOM.EQ.'DEGR'.AND.
     1       (IHARG(1).EQ.'6' .OR. IHARG(1).EQ.'SIX').AND.
     1       IHARG(2).EQ.'SPLI'.AND.IHARG(3).EQ.'FIT')THEN
        ICASSF='6SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.2.AND.
     1       ICOM.EQ.'SEXT'.AND.IHARG(1).EQ.'SPLI'.AND.
     1       IHARG(2).EQ.'FIT')THEN
        ICASSF='6SF'
        ILASTC=2
C
C               *********************************************
C               **  STEP 1.27--                            **
C               **  SEARCH FOR 7-TH DEGREE SPLINE FITTING  **
C               *********************************************
C
      ELSEIF(NUMARG.GE.4.AND.
     1       ICOM.EQ.'7'.AND.IHARG(1).EQ.'TH'.AND.
     1       IHARG(2).EQ.'DEGR'.AND.IHARG(3).EQ.'SPLI'.AND.
     1       IHARG(4).EQ.'FIT')THEN
        ICASSF='7SF'
        ILASTC=4
      ELSEIF(NUMARG.GE.3.AND.
     1      (ICOM.EQ.'7TH' .OR. ICOM.EQ.'SEVE' .OR. ICOM.EQ.'7').AND.
     1       IHARG(1).EQ.'DEGR'.AND.IHARG(2).EQ.'SPLI'.AND.
     1       IHARG(3).EQ.'FIT')THEN
        ICASSF='7SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.3.AND.
     1       ICOM.EQ.'DEGR'.AND.
     1       (IHARG(1).EQ.'7' .OR. IHARG(1).EQ.'SEVE').AND.
     1       IHARG(2).EQ.'SPLI'.AND.IHARG(3).EQ.'FIT')THEN
        ICASSF='7SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.2.AND.
     1       ICOM.EQ.'SEPT'.AND.IHARG(1).EQ.'SPLI'.AND.
     1       IHARG(2).EQ.'FIT')THEN
        ICASSF='7SF'
        ILASTC=2
C
C               *********************************************
C               **  STEP 1.28--                            **
C               **  SEARCH FOR 8-TH DEGREE SPLINE FITTING  **
C               *********************************************
C
      ELSEIF(NUMARG.GE.4.AND.
     1       ICOM.EQ.'8'.AND.IHARG(1).EQ.'TH'.AND.
     1       IHARG(2).EQ.'DEGR'.AND.IHARG(3).EQ.'SPLI'.AND.
     1       IHARG(4).EQ.'FIT')THEN
        ICASSF='8SF'
        ILASTC=4
      ELSEIF(NUMARG.GE.3.AND.
     1      (ICOM.EQ.'8TH' .OR. ICOM.EQ.'EIGH' .OR. ICOM.EQ.'8').AND.
     1       IHARG(1).EQ.'DEGR'.AND.IHARG(2).EQ.'SPLI'.AND.
     1       IHARG(3).EQ.'FIT')THEN
        ICASSF='8SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.3.AND.
     1       ICOM.EQ.'DEGR'.AND.
     1       (IHARG(1).EQ.'8' .OR. IHARG(1).EQ.'EIGH').AND.
     1       IHARG(2).EQ.'SPLI'.AND.IHARG(3).EQ.'FIT')THEN
        ICASSF='8SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.2.AND.
     1       ICOM.EQ.'OCTI'.AND.IHARG(1).EQ.'SPLI'.AND.
     1       IHARG(2).EQ.'FIT')THEN
        ICASSF='8SF'
        ILASTC=2
C
C               *********************************************
C               **  STEP 1.29--                            **
C               **  SEARCH FOR 9-TH DEGREE SPLINE FITTING  **
C               *********************************************
C
      ELSEIF(NUMARG.GE.4.AND.
     1       ICOM.EQ.'9'.AND.IHARG(1).EQ.'TH'.AND.
     1       IHARG(2).EQ.'DEGR'.AND.IHARG(3).EQ.'SPLI'.AND.
     1       IHARG(4).EQ.'FIT')THEN
        ICASSF='9SF'
        ILASTC=4
      ELSEIF(NUMARG.GE.3.AND.
     1      (ICOM.EQ.'9TH' .OR. ICOM.EQ.'NINE' .OR. ICOM.EQ.'9' .OR.
     1       ICOM.EQ.'NINT').AND.
     1       IHARG(1).EQ.'DEGR'.AND.IHARG(2).EQ.'SPLI'.AND.
     1       IHARG(3).EQ.'FIT')THEN
        ICASSF='9SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.3.AND.
     1       ICOM.EQ.'DEGR'.AND.
     1       (IHARG(1).EQ.'9' .OR. IHARG(1).EQ.'NINE').AND.
     1       IHARG(2).EQ.'SPLI'.AND.IHARG(3).EQ.'FIT')THEN
        ICASSF='9SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.2.AND.
     1       ICOM.EQ.'NONI'.AND.IHARG(1).EQ.'SPLI'.AND.
     1       IHARG(2).EQ.'FIT')THEN
        ICASSF='9SF'
        ILASTC=2
C
C               *********************************************
C               **  STEP 1.30--                            **
C               **  SEARCH FOR 10-TH DEGREE SPLINE FITTING **
C               *********************************************
C
      ELSEIF(NUMARG.GE.4.AND.
     1       ICOM.EQ.'10'.AND.IHARG(1).EQ.'TH'.AND.
     1       IHARG(2).EQ.'DEGR'.AND.IHARG(3).EQ.'SPLI'.AND.
     1       IHARG(4).EQ.'FIT')THEN
        ICASSF='10SF'
        ILASTC=4
      ELSEIF(NUMARG.GE.3.AND.
     1      (ICOM.EQ.'10TH' .OR. ICOM.EQ.'TENT' .OR. ICOM.EQ.'10') .AND.
     1       IHARG(1).EQ.'DEGR'.AND.IHARG(2).EQ.'SPLI'.AND.
     1       IHARG(3).EQ.'FIT')THEN
        ICASSF='10SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.3.AND.
     1       ICOM.EQ.'DEGR'.AND.
     1       (IHARG(1).EQ.'10' .OR. IHARG(1).EQ.'TEN ').AND.
     1       IHARG(2).EQ.'SPLI'.AND.IHARG(3).EQ.'FIT')THEN
        ICASSF='10SF'
        ILASTC=3
      ELSEIF(NUMARG.GE.2.AND.
     1       ICOM.EQ.'DEXI'.AND.IHARG(1).EQ.'SPLI'.AND.
     1       IHARG(2).EQ.'FIT')THEN
        ICASSF='10SF'
C
C               ********************************************
C               **  STEP 1.31--                           **
C               **  SINCE VALID COMMAND NOT FOUND, EXIT.  **
C               ********************************************
C
      ELSE
        ICASSF='    '
        IFOUND='NO'
        GOTO9000
      ENDIF
C
      CALL ADJUST(ILASTC,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
      IFOUND='YES'
C
C               *********************************
C               **  STEP 2--                   **
C               **  EXTRACT THE VARIABLE LIST  **
C               *********************************
C
      ISTEPN='2'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'PSPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='SPLINE FIT'
      MINN2=2
      MINNA=1
      MAXNA=100
      MINNVA=2
      MAXNVA=3
      IFLAGE=99
      IFLAGM=0
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'PSPL')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,181)
  181   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,182)IFOUND,IERROR,NQ,NUMVAR
  182   FORMAT('IFOUND,IERROR,NQ,NUMVAR = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO185I=1,NUMVAR
            WRITE(ICOUT,187)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  187       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  185     CONTINUE
        ENDIF
      ENDIF
C
C               **********************************************
C               **  STEP 33--                               **
C               **  FORM THE SUBSETTED VARIABLES            **
C               **       Y(.)                               **
C               **       X(.)                               **
C               **********************************************
C
      ISTEPN='33'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'PSPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ICOL=1
      NUMVA2=2
      CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1            INAME,IVARN1,IVARN2,IVARTY,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1            MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1            MAXCP4,MAXCP5,MAXCP6,
     1            V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1            Y,X,AJUNK,NS,NS,NS,ICASE,
     1            IBUGA3,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      N34=0
      IF(NUMVAR.EQ.3)THEN
        ICOL=3
        NUMVA2=1
        CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1              INAME,IVARN1,IVARN2,IVARTY,
     1              ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1              MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1              MAXCP4,MAXCP5,MAXCP6,
     1              V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1              XKNOT,AJUNK,AJUNK,N34,NTEMP,NTEMP,ICASE,
     1              IBUGA3,ISUBRO,IFOUND,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ELSE
        IF(IKNOT1.NE.'    ')THEN
          IHWUSE='V'
          MESSAG='NO'
          CALL CHECKN(IKNOT1,IKNOT2,IHWUSE,
     1                IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1                ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCV,IERROR)
C
          IF(IERROR.EQ.'NO')THEN
            ICOLT=IVALUE(ILOCV)
            N34=IN(ILOCV)
            ICNT=0
            DO210I=1,N34
              IJ=MAXN*(ICOLT-1)+I
              ICNT=ICNT+1
              IF(ICOLT.LE.MAXCOL)XKNOT(ICNT)=V(IJ)
              IF(ICOLT.EQ.MAXCP1)XKNOT(ICNT)=PRED(I)
              IF(ICOLT.EQ.MAXCP2)XKNOT(ICNT)=RES(I)
              IF(ICOLT.EQ.MAXCP3)XKNOT(ICNT)=YPLOT(I)
              IF(ICOLT.EQ.MAXCP4)XKNOT(ICNT)=XPLOT(I)
              IF(ICOLT.EQ.MAXCP5)XKNOT(ICNT)=X2PLOT(I)
              IF(ICOLT.EQ.MAXCP6)XKNOT(ICNT)=TAGPLO(I)
              ICNT=ICNT-1
  210       CONTINUE
          ENDIF
        ENDIF
C
        IF(N34.LE.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,301)
  301     FORMAT('***** ERROR IN SPLINE FIT--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,303)
  303     FORMAT('      THE KNOTS VARIABLE WAS NOT SPECIFIED ON EITHER')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,305)
  305     FORMAT('      THE SPLINE FIT COMMAND OR THE KNOTS COMMAND.')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
      ENDIF
C
C               ***************************************************
C               **  STEP 7--                                     **
C               **  EXTRACT THE DEGREE OF THE SPLINE FUNCTION.   **
C               **  CHECK THAT THE DEGREE IS IN THE VALID RANGE  **
C               **  (1 TO 10).                                   **
C               ***************************************************
C
      ISTEPN='7'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'PSPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      MINDEG=1
      MAXDEG=10
      IDEGRE=3
      IF(ICASSF.EQ.'SF'.AND.IDEG.GE.MINDEG.AND.IDEG.LE.MAXDEG)
     1IDEGRE=IDEG
      IF(ICASSF.EQ.'0SF')IDEGRE=0
      IF(ICASSF.EQ.'1SF')IDEGRE=1
      IF(ICASSF.EQ.'2SF')IDEGRE=2
      IF(ICASSF.EQ.'3SF')IDEGRE=3
      IF(ICASSF.EQ.'4SF')IDEGRE=4
      IF(ICASSF.EQ.'5SF')IDEGRE=5
      IF(ICASSF.EQ.'6SF')IDEGRE=6
      IF(ICASSF.EQ.'7SF')IDEGRE=7
      IF(ICASSF.EQ.'8SF')IDEGRE=8
      IF(ICASSF.EQ.'9SF')IDEGRE=9
      IF(ICASSF.EQ.'10FI')IDEGRE=10
      IF(ICASSF.EQ.'10SF')IDEGRE=10
C
      IF(IDEGRE.LT.MINDEG .OR. IDEGRE.GT.MAXDEG)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,301)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,703)
  703   FORMAT('      THE DEGREE FOR A SPLINE FIT MUST BE BETWEEN ',
     1         I8,' AND ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,705)
  705   FORMAT('      (INCLUSIVELY);  SUCH WAS NOT THE CASE HERE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,707)IDEGRE
  707   FORMAT('      THE SPECIFIED DEGREE = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,709)
  709   FORMAT('      THE ENTERED COMMAND LINE WAS AS FOLLOWS--')
        CALL DPWRST('XXX','BUG ')
        IF(IWIDTH.GE.1)THEN
          WRITE(ICOUT,711)(IANS(I),I=1,MIN(IWIDTH,80))
  711     FORMAT('      ',80A1)
          CALL DPWRST('XXX','BUG ')
        ENDIF
        IERROR='YES'
        GOTO9000
      ENDIF
C
      NKNOT=N34
      K=IDEGRE+NKNOT+1
C
      IF(NS.LT.K)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,301)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,902)
  902   FORMAT('      FOR A SPLINE FIT, THE NUMBER OF ELEMENTS IN THE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,904)
  904   FORMAT('      FIRST VARIABLE (THAT IS, THE NUMBER OF POINTS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,905)
  905   FORMAT('      TO BE FITTED) MUST BE EQUAL TO OR GREATER THAN')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,906)
  906   FORMAT('      THE NUMBER OF COEFFICIENTS TO BE ESTIMATED')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,907)
  907   FORMAT('      (THAT IS, MUST BE EQUAL TO OR GREATER THAN')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,908)
  908   FORMAT('      (SPLINE DEGREE + NUMBER OF KNOTS + 1));')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,909)
  909   FORMAT('      SUCH WAS NOT THE CASE HERE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,910)NS
  910   FORMAT('      NUMBER OF FIT POINTS FROM FIRST VARIABLE = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,911)K
  911   FORMAT('      NUMBER OF ESTIMATED COEFFICIENTS         = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,912)IDEGRE
  912   FORMAT('      DEGREE OF SPLINE                         = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,913)NKNOT
  913   FORMAT('      NUMBER OF KNOTS                          = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,709)
        CALL DPWRST('XXX','BUG ')
        IF(IWIDTH.GE.1)THEN
          WRITE(ICOUT,711)(IANS(I),I=1,MIN(IWIDTH,80))
          CALL DPWRST('XXX','BUG ')
        ENDIF
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               ******************************************************
C               **  STEP 9--                                        **
C               **  CHECK THAT THE PRODUCT OF THE NUMBER OF POINTS  **
C               **  TO BE FITTED (NS) AND THE NUMBER OF B-SPLINE    **
C               **  COEFFICIENTS TO BE ESTIMATED (K)                **
C               **  DOES NOT EXCEED MAXNK--THUS THE ARRAY Z2(.)     **
C               **  IN THE SUBROUTINE DPSPL2 WILL NOT OVERFLOW.     **
C               ******************************************************
C
      INK=NS*K
      IF(INK.GT.MAXNK)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,301)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,922)
  922   FORMAT('      AN INTERNAL ARRAY WILL OVERFLOW IF THE PRODUCT')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,924)
  924   FORMAT('      OF THE NUMBER OF POINTS TO BE FITTED AND THE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,925)
  925   FORMAT('      NUMBER OF B-SPLINE COEFFICIENTS TO BE ESTIMATED')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,927)MAXNK
  927   FORMAT('      EXCEEDS ',I8,'.  SUCH WOULD BE THE CASE HERE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,928)NS,K,INK
  928   FORMAT('      N = ',I8,' K = ',I8,' N*K = ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               **************************************************
C               **  STEP 10--                                   **
C               **  PREPARE FOR ENTRANCE INTO DPSPL2--          **
C               **  SET THE WEIGHT VECTOR TO UNITY THROUGHOUT.  **
C               **************************************************
C
      ISTEPN='10'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'PSPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO970I=1,NS
        W(I)=1.0
  970 CONTINUE
C
C               *********************
C               **  STEP 12-       **
C               **  ENTER DPSPL2.  **
C               *********************
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'PSPL')THEN
        ISTEPN='12'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,6081)
 6081   FORMAT('***** FROM DPSPL, AS WE ARE ABOUT TO CALL DPSPL2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,6082)MAXN,NS,NKNOT
 6082   FORMAT('NUMCHA,MAXN,NKNOT = ',3I8)
        CALL DPWRST('XXX','BUG ')
        DO6083I=1,NS
          WRITE(ICOUT,6084)I,Y(I),X(I),W(I)
 6084     FORMAT('I,Y(I),X(I),W(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
 6083   CONTINUE
      ENDIF
C
CCCCC JUNE, 1990.  MOVE SOME DIMENSIONS FROM DPSPL2 TO DPSPL
CCCCC CALL DPSPL2(Y,X,W,NS,XKNOT,NKNOT,IDEGRE,V,
      CALL DPSPL2(Y,X,W,NS,XKNOT,NKNOT,IDEGRE,VSCRT,
     1            B,SDB,B2,SDB2,PRED2,RES2,
     1            REPSD,REPDF,RESSD,RESDF,ALFCDF,
     1            V1,V2,DUM1,DUM2,AJUNK,
     1            XPX,SSQ,A,XPY,RIGHT,BTEMP,EKNOT,
     1            ICAPSW,ICAPTY,IFORSW,
     1            IBUGA3,ISUBRO,IERROR)
C
      IF(IERROR.EQ.'YES')GOTO9000
C
C               ***************************************
C               **  STEP 14--                        **
C               **  UPDATE INTERNAL DATAPLOT TABLES  **
C               ***************************************
C
 7000 CONTINUE
C
      ISTEPN='14'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'PSPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ICOLPR=MAXCP1
      ICOLRE=MAXCP2
      IREPU='ON'
      IRESU='ON'
      CALL UPDAPR(ICOLPR,ICOLRE,PRED2,RES2,PRED,RES,ISUB,NS,
     1IREPU,REPSD,REPDF,IRESU,RESSD,RESDF,ALFCDF,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,ILOCN,IBUGA3,IERROR)
C
      ISTEPN='14B'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'PSPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IBUGJU='OFF'
C
      L=0
      IKNMAX=NKNOT+1
      JMAX=IDEGRE+1
      DO7500IKN=1,IKNMAX
        DO7600J=1,JMAX
          L=L+1
          JM1=J-1
          CALL COENAM(IKN,JM1,IH,IH2,IBUGJU,IERROR)
C
          DO7650I=1,NUMNAM
            I2=I
            IF(IH.EQ.IHNAME(I).AND.IH2.EQ.IHNAM2(I).AND.
     1         IUSE(I).EQ.'P')THEN
              VALUE(I2)=B2(L)
              GOTO7600
            ENDIF
 7650     CONTINUE
C
          IF(NUMNAM.GT.MAXNAM)THEN
            WRITE(ICOUT,301)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,7652)
 7652       FORMAT('      THE TOTAL NUMBER OF (VARIABLE + PARAMETER)')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,7653)MAXNAM
 7653       FORMAT('      NAMES MUST BE AT MOST ',I8)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,7654)
 7654       FORMAT('      SUCH WAS NOT THE CASE HERE--THE MAXIMUM')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,7655)
 7655       FORMAT('      ALLOWABLE NUMBER OF NAMES WAS JUST EXCEEDED.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,7657)
 7657       FORMAT('      SUGGESTED ACTION--ENTER  STAT  TO DETERMINE')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,7659)
 7659       FORMAT('      THE IMPORTANT (VERSUS UNIMPORTANT) VARIABLES')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,7660)
 7660       FORMAT('      AND PARAMETERS, AND THEN REUSE SOME OF THE ',
     1             'NAMES.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,709)
            CALL DPWRST('XXX','BUG ')
            IF(IWIDTH.GE.1)THEN
              WRITE(ICOUT,711)(IANS(I),I=1,MIN(IWIDTH,80))
              CALL DPWRST('XXX','BUG ')
            ENDIF
            IERROR='YES'
            GOTO9000
          ELSE
            NUMNAM=NUMNAM+1
            ILOC=NUMNAM
            IHNAME(ILOC)=IH
            IHNAM2(ILOC)=IH2
            IUSE(ILOC)='P'
            VALUE(ILOC)=B2(L)
          ENDIF
C
 7600   CONTINUE
 7500 CONTINUE
C
C               ***************************************
C               **  STEP 15--                        **
C               **  ENTER A NOTE IN MODEL(.)         **
C               **  STATING THAT THE LAST FIT        **
C               **  WAS A SPLINE FIT                 **
C               **  OF WHATEVER DEGREE.              **
C               ***************************************
C
 8000 CONTINUE
C
      ISTEPN='15'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'PSPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO8100I=1,IWIDTH
        MODEL(I)=IANS(I)
 8100 CONTINUE
      NUMCHA=IWIDTH
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'PSPL')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSPL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9014)NS,NKNOT,IDEGRE,ICASSF
 9014   FORMAT('NS,NKNOT,IDEGRE,ICASSF = ',3I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)IFOUND,IERROR
 9016   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSPL2(Y,X,W,N,XKNOT,NKNOT,IDEGRE,Z2,
     1                  B,SDB,B2,SDB2,PRED2,RES2,
     1                  REPSD,REPDF,RESSD,RESDF,ALFCDF,
     1                  V1,V2,DUM1,DUM2,AJUNK,
     1                  XPX,SSQ,A,XPY,RIGHT,BTEMP,EKNOT,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES A LEAST SQUARES SPLINE FIT
C              FOR ANY DEGREE--LINEAR, QUADRATIC, CUBIC, ETC.
C     ALGORITHM USED--B-SPLINES (MODIFIED SO THAT SOME ELEMENTS
C                   SET = 0 RATHER THAN COMPUTED AS 0)
C     REFERENCE--WOLD, TECHNOMETRICS, 1974, PAGE 2
C     INPUT  ARGUMENTS--Y      = SINGLE PRECISION VECTOR OF
C                                RESPONSE DATA (THAT IS, THE
C                                DEPENDENT VARIABLE).
C                       X      = SINGLE PRECISION MATRIX OF
C                                THE DEPENDENT VARIABLE.
C                       W      = THE SINGLE PRECISION VECTOR
C                                OF WEIGHTS FOR THE RESPONSE
C                                VARIABLE.
C                       N      = THE INTEGER VALUE OF THE SAMPLE SIZE.
C                       XKNOT  = THE SINGLE PRECISION VECTOR OF KNOTS.
C                       NKNOT  = THE INTEGER NUMBER OF SPECIFIED KNOTS.
C                       IDEGRE = THE INTEGER DEGREE OF THE SPLINE.
C     OUTPUT ARGUMENTS--B      = THE SINGLE PRECISION VECTOR OF
C                                ESTIMATED REGRESSION COEFFICIENTS.
C                       SDB    = THE SINGLE PRECISION VECTOR OF
C                                ESTIMATED STANDARD DEVIATIONS OF THE
C                                ESTIMATED REGRESSION COEFFICIENTS.
C                       RESSD  = THE ESTIMATED RESIDUAL STANDARD
C                                DEVIATION.
C                       PRED2  = THE SINGLE PRECISION VECTOR OF
C                                PREDICTED VALUES.
C                       RES2   = THE SINGLE PRECISION VECTOR OF
C                                RESIDUALS FROM THE LEAST SQUARES FIT.
C     SUBROUTINES NEEDED--DECOMP, INVXWX, AND DOT.
C     NOTE--CODE MODIFIED SO THAT NUMBER OF KNOTS SHOULD NOT
C           EXCEED 50
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--MARCH     1975.
C     UPDATED         --NOVEMBER  1975.
C     UPDATED         --MAY       1976.
C     UPDATED         --DECEMBER  1978.
C     UPDATED         --AUGUST    1979.
C     UPDATED         --MARCH     1981.
C     UPDATED         --JULY      1981.
C     UPDATED         --AUGUST    1981.
C     UPDATED         --NOVEMBER  1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --MARCH     1988. ADD LOFCDF
C     UPDATED         --JANUARY   1989. DECLARE AJUNK AS ARRAY (DIM. 1) (ALAN)
C     UPDATED         --MAY       1989. INCREACED DIMENSION FOR V1 AND V2
C                                       MOVE SOME DIMENSIONS
C     UPDATED         --FEBRUARY  2012. USE DPDTA1 TO PRINT OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 IREP
      CHARACTER*4 IBUGJU
      CHARACTER*4 IH
      CHARACTER*4 IH2
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION W(*)
      DIMENSION XKNOT(*)
C
      DIMENSION B(*)
      DIMENSION SDB(*)
      DIMENSION PRED2(*)
      DIMENSION RES2(*)
      DIMENSION B2(*)
      DIMENSION SDB2(*)
      DIMENSION Z2(*)
      DIMENSION V1(*)
      DIMENSION V2(*)
      DIMENSION DUM1(*)
      DIMENSION DUM2(*)
      DIMENSION AJUNK(*)
C
      DIMENSION XPX(50,50)
      DIMENSION SSQ(50,50)
      DIMENSION A(50,50)
      DIMENSION XPY(*)
      DIMENSION RIGHT(*)
      DIMENSION BTEMP(*)
      DIMENSION EKNOT(*)
C
      PARAMETER(NUMCLI=4)
      PARAMETER(MAXLIN=3)
      PARAMETER (MAXROW=60)
      CHARACTER*40 IDIST
      CHARACTER*40 ITITLE
      CHARACTER*40 ITITLZ
      CHARACTER*40 ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      IDIGI2(MAXROW,NUMCLI)
      INTEGER      ROWSEP(MAXROW)
      INTEGER      NTOT(MAXROW)
      CHARACTER*40 ITITL2(MAXLIN,NUMCLI)
      CHARACTER*15 IVALUE(MAXROW,NUMCLI)
      CHARACTER*4  ITYPCO(MAXROW,NUMCLI)
      CHARACTER*4  ITYPC2(NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      NCOLSP(MAXLIN,NUMCLI)
      INTEGER      NCVALU(MAXROW,NUMCLI)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
      LOGICAL IFLAGS
      LOGICAL IFLAGE
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPSP'
      ISUBN2='L2  '
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      IERROR='NO'
      K2=0
      DIJ=0.0
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'SPL2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSPL2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NKNOT,IDEGRE
   52   FORMAT('IBUGA3,ISUBRO,N,NKNOT,IDEGRE = ',2(A4,2X),3I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,Y(I),X(I),W(I),XKNOT(I)
   56     FORMAT('I,Y(I),X(I),W(I),XKNOT(I) = ',I8,4G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
      AN=N
      K=NKNOT+IDEGRE+1
      AK=K
      DEG=IDEGRE
      KMAX=50
C
C               ***************************
C               **  STEP 1--             **
C               **  WRITE OUT THE TITLE  **
C               ***************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C               *****************************************
C               **  STEP 2--                           **
C               **  CHECK THE INPUT ARGUMENTS N AND K  **
C               *****************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(K.LT.1 .OR. K.GT.KMAX)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,151)
  151   FORMAT('***** ERROR IN SPLINE FIT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,152)
  152   FORMAT('      THE NUMBER OF SPLINE COEFFICIENTS (K = NDEG+1)')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,153)
  153   FORMAT('      IS NON-POSITIVE OR LARGER THAN ALLOWABLE MAX')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,154)K,KMAX
  154   FORMAT('      K,KMAX = ',I8,I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(K.GT.N)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,151)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,162)
  162   FORMAT('      THE NUMBER OF SPLINE COEFFICIENTS (K = NDEG+1)')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,163)
  163   FORMAT('      IS LARGER THAN THE NUMBER OF DATA POINTS (N).')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,164)K,N
  164   FORMAT('      K,N = ',I8,I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(NKNOT.GT.50)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,151)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,172)NKNOT
  172   FORMAT('      THE NUMBER OF KNOTS (= ',I8,') HAS JUST EXCEEDED')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,174)
  174   FORMAT('      THE ALLOWABLE MAXIMUM (= 50).')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               ********************************************************
C               **  STEP 3--                                          **
C               **  INSPECT THE WEIGHT VECTOR W--IF ALL ELEMENTS ARE  **
C               **  IDENTICAL, THEN RESET ALL ELEMENTS TO 1.0.  THIS  **
C               **  AVOIDS THE PROBLEM OF AN UNDEFINED EMPTY WEIGHT   **
C               **  VECTOR W WHEN IN FACT AN EQUAL WEIGHTING SCHEME   **
C               **  IS DESIRED.                                       **
C               ********************************************************
C
      ISTEPN='3'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IWFLAG=0
      WHOLD=W(1)
      DO600I=1,N
        IF(W(I).EQ.WHOLD)GOTO600
        GOTO850
  600 CONTINUE
      IWFLAG=1
  850 CONTINUE
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'SPL2')THEN
         IF(IWFLAG.EQ.0)THEN
            WRITE(ICOUT,851)
  851       FORMAT('      UNEQUAL WEIGHTS CASE')
            CALL DPWRST('XXX','BUG ')
         ENDIF
         IF(IWFLAG.EQ.1)THEN
            WRITE(ICOUT,852)
  852       FORMAT('      EQUAL WEIGHTS CASE')
            CALL DPWRST('XXX','BUG ')
         ENDIF
      ENDIF
C
C               ********************************************************
C               **  STEP 3.5--                                        **
C               **  CHECK FOR REPLICATION AND IF EXISTENT COMPUTE A   **
C               **  (MODEL-FREE) REPLICATION STANDARD DEVIATION.      **
C               ********************************************************
C
      ISTEPN='3.5'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NUMVAR=1
C
      IREP='NO'
      REPSD=0.0
      REPDF=0.0
      IREPDF=REPDF+0.5
      RESSD=0.0
      RESDF=0.0
      ALFCDF=(-999.99)
      CALL DPREPS(Y,X,AJUNK,AJUNK,AJUNK,AJUNK,N,NUMVAR,DUM1,DUM2,
     1IREP,REPSS,REPMS,REPSD,REPDF,NUMSET,IBUGA3,IERROR)
      IREPDF=REPDF+0.5
C
C               *********************************************************
C               **  STEP 4--                                           **
C               **  FORM THE MATRIX X2 (WHICH CORRESPONDS TO THE USUAL **
C               **  X MATRIX IN THE FIT SUBROUTINE BUT IS HERE CALLED  **
C               **  X2 BECAUSE OF A CONFLICT DUE TO THE INPUT VECTOR   **
C               **  X).  B-SPLINES ARE USED HEREIN.                    **
C               **  REFERENCE--WOLD, TECHNOMETRICS, 1974, PAGE 2.      **
C               *********************************************************
C
      ISTEPN='4'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C               **********************************
C               **  STEP 4.1--                  **
C               **  DETERMINE THE MIN X VALUE.  **
C               **  DETERMINE THE MAX X VALUE.  **
C               **********************************
C
      ISTEPN='4.1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      XMIN=X(1)
      XMAX=X(1)
      DO900I=1,N
        IF(X(I).LT.XMIN)XMIN=X(I)
        IF(X(I).GT.XMAX)XMAX=X(I)
  900 CONTINUE
C
C               ************************************
C               **  STEP 4.2--                    **
C               **  DEFINE EXTENDED KNOTS         **
C               **  (ON EITHER END OF THE DATA).  **
C               **  THE NUMBER OF SUCH KNOTS      **
C               **  ON EACH SIDE WILL BE          **
C               **  DEGREE + 1.                   **
C               ************************************
C
      ISTEPN='4.2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL SORT(XKNOT,NKNOT,XKNOT)
C
      IF(XKNOT(1).EQ.XMIN)THEN
        RANGE=XMAX-XMIN
        DEL=RANGE/100.0
      ELSE
        DEL=XKNOT(1)-XMIN
        DEL=ABS(DEL)
      ENDIF
C
      L=0
C
      IMAX=IDEGRE+1
      DO940I=1,IMAX
        L=L+1
        AIREV=IMAX-I+1
        EKNOT(L)=XKNOT(1)-AIREV*DEL
  940 CONTINUE
C
      DO950I=1,NKNOT
        L=L+1
        EKNOT(L)=XKNOT(I)
  950 CONTINUE
C
      IF(XKNOT(NKNOT).EQ.XMAX)THEN
        RANGE=XMAX-XMIN
        DEL=RANGE/100.0
      ELSE
        DEL=XMAX-XKNOT(NKNOT)
        DEL=ABS(DEL)
      ENDIF
C
      IMAX=IDEGRE+1
      DO990I=1,IMAX
        L=L+1
        AI=I
        EKNOT(L)=XKNOT(NKNOT)+AI*DEL
  990 CONTINUE
C
      NKNOT2=L
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'SPL2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,991)NKNOT,NKNOT2
  991   FORMAT('NKNOT,NKNOT2 = ',2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,992)XMIN,XKNOT(1),XKNOT(NKNOT),XMAX,DEL
  992   FORMAT('XMIN,XKNOT(1),XKNOT(NKNOT),XMAX,DEL = ',5G15.7)
        CALL DPWRST('XXX','BUG ')
        DO993I=1,NKNOT2
          WRITE(ICOUT,994)I,EKNOT(I)
  994     FORMAT('I, EKNOT(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
  993   CONTINUE
      ENDIF
C
C               *******************************************
C               **  STEP 4.4--                           **
C               **  FORM THE LINEAR REGRESSION X MATRIX  **
C               **  (HERE CALLED X2)                     **
C               **  WHICH WILL CONTAIN THE B-SPLINE      **
C               **  REPRESENTATION OF THE SPLINE         **
C               **  PROBLEM.                             **
C               **  NOTE THAT K = THE NUMBER             **
C               **  OF ORIGINAL KNOTS + IDEGRE + 1.      **
C               *******************************************
C
      ISTEPN='4.4'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO1500I=1,N
        DO1600J=1,K
C
          IJ=(I-1)*K+J
          Z2(IJ)=0.0
          LMAX=IDEGRE+J+1
          IF(X(I).LT.EKNOT(J).OR.X(I).GT.EKNOT(LMAX))GOTO1600
C
          SUM=0.0
          DO1700L=J,LMAX
            IF(X(I).LE.EKNOT(L))GOTO1700
            XI=X(I)
            EKNOL=EKNOT(L)
            ANUM=(XI-EKNOL)**DEG
            PROD=1.0
            DO1800M=J,LMAX
              IF(M.EQ.L)GOTO1800
              EKNOL=EKNOT(L)
              EKNOM=EKNOT(M)
              PROD=PROD*(EKNOL-EKNOM)
 1800       CONTINUE
            ADEN=PROD
C
            RATIO=ANUM/ADEN
            SUM=SUM+RATIO
C
            IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'SPL2')THEN
              WRITE(ICOUT,1811)ANUM,ADEN,RATIO,SUM
 1811         FORMAT('ANUM,ADEN,RATIO,SUM = ',4G15.7)
              CALL DPWRST('XXX','BUG ')
            ENDIF
C
 1700     CONTINUE
          IJ=(I-1)*K+J
          Z2(IJ)=SUM
C
          IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'SPL2')THEN
            WRITE(ICOUT,1711)I,J,Z2(IJ)
 1711       FORMAT('I, J, Z2(IJ) = ',2I8,G15.7)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
 1600   CONTINUE
 1500 CONTINUE
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'SPL2')THEN
        WRITE(ICOUT,1901)
 1901   FORMAT('AFTER STEP 4.4 IN DPSPL2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1902)
 1902   FORMAT('Z2(.,.) = ')
        CALL DPWRST('XXX','BUG ')
        DO1910I=1,N
          IJMIN=(I-1)*K+1
          IJMAX=I*K
          WRITE(ICOUT,1911)(Z2(IJ),IJ=IJMIN,IJMAX)
 1911     FORMAT(8G15.7)
          CALL DPWRST('XXX','BUG ')
 1910   CONTINUE
      ENDIF
C
C               *******************************
C               **  STEP 5--                 **
C               **  FORM THE X'X MATRIX      **
C               **  (HERE CALLED XPX)        **
C               **  THIS WILL HAVE K ROWS    **
C               **  AND K COLUMNS            **
C               **  WHERE K = THE NUMBER OF  **
C               **  ORIGINAL KNOTS + 4.      **
C               *******************************
C
      ISTEPN='5'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO2100I=1,K
        DO2200J=1,K
          DO2300L=1,N
            LI=(L-1)*K+I
            V1(L)=Z2(LI)
            LJ=(L-1)*K+J
            V2(L)=Z2(LJ)
 2300     CONTINUE
          CALL DOTPRO(V1,V2,N,RESULT)
          XPX(I,J)=RESULT
          IJ=(I-1)*K+J
  133     FORMAT('I,J,N,Z2(IJ),XPX(I,J) = ',3I6,2E15.8)
 2200   CONTINUE
 2100 CONTINUE
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'SPL2')THEN
        WRITE(ICOUT,2301)
 2301   FORMAT('AFTER STEP 5 IN DPSPL2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2302)
 2302   FORMAT('Z2(.,.) = ')
        CALL DPWRST('XXX','BUG ')
        DO2310I=1,N
          JMIN=(I-1)*K+1
          JMAX=I*K
          WRITE(ICOUT,2311)(Z2(IJ),IJ=JMIN,JMAX)
 2311     FORMAT(8E15.7)
          CALL DPWRST('XXX','BUG ')
 2310   CONTINUE
        WRITE(ICOUT,2342)
 2342   FORMAT('XPX(.,.) = ')
        CALL DPWRST('XXX','BUG ')
        DO2350I=1,N
          WRITE(ICOUT,2351)(XPX(I,J),J=1,K)
 2351     FORMAT(8G15.7)
          CALL DPWRST('XXX','BUG ')
 2350   CONTINUE
      ENDIF
C
C               *****************************************
C               **  STEP 6--                           **
C               **  FORM THE INVERSE MATRIX (X'X)**-1  **
C               **  (HERE CALLED SSQ).                **
C               **  THIS WILL HAVE K ROWS              **
C               **  AND K COLUMNS                      **
C               **  WHERE K = THE NUMBER OF            **
C               **  ORIGINAL KNOTS + 4.                **
C               *****************************************
C
      ISTEPN='6'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')THEN
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        DO2610I=1,K
          DO2620J=1,K
            WRITE(ICOUT,2621)I,J,XPX(I,J)
 2621       FORMAT('I,J,XPX(I,J) = ',2I8,G15.7)
            CALL DPWRST('XXX','BUG ')
 2620     CONTINUE
 2610   CONTINUE
      ENDIF
C
      CALL MATI50(XPX,K,SSQ)
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        DO2710I=1,K
          DO2720J=1,K
            WRITE(ICOUT,2721)I,J,SSQ(I,J)
 2721       FORMAT('I,J,SSQ(I,J) = ',2I8,G15.7)
            CALL DPWRST('XXX','BUG ')
 2720     CONTINUE
 2710   CONTINUE
      ENDIF
C
C               *********************************************
C               **  STEP 7--                               **
C               **  COMPUTE THE K REGRESSION COEFFICIENTS. **
C               *********************************************
C
      ISTEPN='7'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO3100I=1,K
        DO3200L=1,N
          LI=(L-1)*K+I
          V1(L)=Z2(LI)
          V2(L)=Y(L)
 3200   CONTINUE
        CALL DOTPRO(V1,V2,N,XPY(I))
 3100 CONTINUE
C
      DO3600I=1,K
        DO3700L=1,K
          V1(L)=SSQ(L,I)
          V2(L)=XPY(L)
 3700   CONTINUE
        CALL DOTPRO(V1,V2,K,B(I))
 3600 CONTINUE
C
C               *********************************
C               **  STEP 8--                   **
C               **  COMPUTE PREDICTED VALUES.  **
C               **  COMPUTE RESIDUALS.         **
C               *********************************
C
      ISTEPN='8'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO4100I=1,N
        DO4200L=1,K
          IL=(I-1)*K+L
          V1(L)=Z2(IL)
          V2(L)=B(L)
 4200   CONTINUE
        CALL DOTPRO(V1,V2,K,PRED2(I))
 4100 CONTINUE
C
      DO4600I=1,N
        RES2(I)=Y(I)-PRED2(I)
 4600 CONTINUE
C
C               ********************************************
C               **  STEP 9--                              **
C               **  COMPUTE RESIDUAL STANDARD DEVIATION.  **
C               ********************************************
C
      ISTEPN='9'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      SUM=0.0
      DO5100I=1,N
        SUM=SUM+RES2(I)**2
 5100 CONTINUE
      RESSS=SUM
      IRESDF=N-K
      RESDF=IRESDF
      IF(IRESDF.LE.0)THEN
        RESSS=0.0
        RESVAR=0.0
        RESSD=0.0
      ELSE
        RESVAR=RESSS/RESDF
        RESSD=0.0
        IF(RESVAR.GT.0.0)RESSD=SQRT(RESVAR)
      ENDIF
C
C               **************************************
C               **  STEP 10--                       **
C               **  COMPUTE THE COVARIANCE MATRIX   **
C               **  OF THE COEFFICIENTS.            **
C               **  COMPUTE THE CORRELATION MATRIX  **
C               **  OF THE COEFFICIENTS.            **
C               **************************************
C
      ISTEPN='10'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
CCCCC DO6100I=1,K
CCCCC DO6200J=1,K
CCCCC COV(I,J)=SSQ(I,J)*RESSD*RESSD
C6200 CONTINUE
C6100 CONTINUE
C
CCCCC DO6600I=1,K
CCCCC DO6700J=1,K
CCCCC ANUM=SSQ(I,J)
CCCCC ADEN=SQRT(SSQ(I,I)*SSQ(J,J))
CCCCC CORR(I,J)=ANUM/ADEN
C6700 CONTINUE
C6600 CONTINUE
C
C               ***************************************************
C               **  STEP 11--                                    **
C               **  COMPUTE STANDARD DEVIATION OF COEFFICIENTS.  **
C               ***************************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO7100I=1,K
        SDB(I)=0.0
        IF(SSQ(I,I).GT.0.0)SDB(I)=RESSD*SQRT(SSQ(I,I))
 7100 CONTINUE
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'SPL2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,7205)RESSD
 7205   FORMAT('S = ',E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        DO7210I=1,K
          WRITE(ICOUT,7211)I,B(I),SDB(I)
 7211     FORMAT('I, B(I), SDB(I) = ',I8,2E15.7)
          CALL DPWRST('XXX','BUG ')
 7210   CONTINUE
      ENDIF
C
C               ******************************************************
C               **  STEP 12--                                       **
C               **  COMPUTE COEFFICIENTS FOR THE SPLINE POLYNOMIAL  **
C               **  OVER EACH INDIVIDUAL REGION (BETWEEN KNOTS).    **
C               ******************************************************
C
      ISTEPN='12'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C               ******************************************
C               **  STEP 12.1--                         **
C               **  LOOP THROUGH THE NKNOT+1 INTERVALS  **
C               ******************************************
C
      L3=0
      IKNMAX=NKNOT+1
      IMAX=IDEGRE+1
      DO8100IKN=1,IKNMAX
        IKN2=IKN+(IDEGRE+1)
        IKN2M1=IKN2-1
C
C               **************************************************
C               **  STEP 12.2--                                 **
C               **  FOR A GIVEN INTERVAL,                       **
C               **  FORM THE MATRIX OF COEFFICIENTS             **
C               **  FOR THE POLYNOMIALS IN THE INTERVAL         **
C               **  AND FOR THE DERIVATIVES OF THE POLYNOMIALS  **
C               **  WE ARE MERELY EXTRACTING COEFFICIENTS       **
C               **  OF POLYNOMIALS VIA DIFFERENTIATION.         **
C               **  EVALUATE THE DERIVATIVES AT THE MIDPOINTS   **
C               **  BETWEEN KNOTS.                              **
C               **************************************************
C
        DO8200I=1,IMAX
          IM1=I-1
          DO8300J=1,IMAX
            A(I,J)=0.0
            IF(I.GT.J)GOTO8300
            PROD=1.0
            IF(IM1.LT.1)GOTO8450
            AJ=J
            DO8400L=1,IM1
              AL=L
              PROD=PROD*(AJ-AL)
 8400       CONTINUE
C
 8450       CONTINUE
            CIJ=PROD
            XI=(EKNOT(IKN2)+EKNOT(IKN2M1))/2.0
            IF(I.EQ.J)DIJ=1.0
            IF(I.NE.J)DIJ=XI**(J-I)
            A(I,J)=CIJ*DIJ
 8300     CONTINUE
 8200   CONTINUE
C
        IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'SPL2')THEN
          WRITE(ICOUT,8201)IKN
 8201     FORMAT('IN THE MIDDLE OF STEP 12 IN SPLINE. IKN = ',I8)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,8202)
 8202     FORMAT('A(.,.) = ')
          CALL DPWRST('XXX','BUG ')
          IDEGP1=IDEGRE+1
          DO8210I=1,IDEGP1
            WRITE(ICOUT,8211)(A(I,J),J=1,IDEGP1)
 8211       FORMAT(8E15.7)
            CALL DPWRST('XXX','BUG ')
 8210     CONTINUE
        ENDIF
C
        I=IKN
CCCCC   XI=EKNOT(IKN2)
        XI=(EKNOT(IKN2)+EKNOT(IKN2M1))/2.0
C
C       IF I = 1, MAKE ALL EVALUATIONS BETWEEN KNOT 0 AND KNOT 1;
C       IF I = 2, MAKE ALL EVALUATIONS BETWEEN KNOT 1 AND KNOT 2;
C       IF I = 3, MAKE ALL EVALUATIONS BETWEEN KNOT 2 AND KNOT 3; ETC.
C
C               ********************************************************
C               **  STEP 12.3--                                       **
C               **  COMPUTE THE RIGHT SIDE OF THE MATRIX EQUATION.    **
C               **  COMPUTE PREDICTED VALUES AND DERIVATIES OF        **
C               **  PREDICTED VALUES AT SELECTED POINTS (HALF WAY     **
C               **  BETWEEN KNOTS).                                   **
C               ********************************************************
C
        IROWMX=IDEGRE+1
        DO8500IROW=1,IROWMX
C
C         IF IROW = 1, EVALUATE S(X);
C         IF IROW = 2, EVALUATE S'(X);
C         IF IROW = 3, EVALUATE S''(X); ETC.
C         FOR DEGREE K, STOP (INCLUSIVELY) AT THE K-TH DERIVATIVE.
C
          RIGHT(IROW)=0.0
          DO8600J=1,K
C
            LMAX=IDEGRE+J+1
            IF(XI.LT.EKNOT(J).OR.XI.GT.EKNOT(LMAX))GOTO8600
C
            SUM=0.0
            DO8700L=J,LMAX
              IF(XI.LE.EKNOT(L))GOTO8700
              EKNOL=EKNOT(L)
C
              PROD=1.0
              NUMTER=IROW-1
              IF(NUMTER.LT.1)GOTO8770
              DO8760L2=1,NUMTER
                AL2=L2
                PROD=PROD*(DEG-AL2+1.0)
 8760         CONTINUE
 8770       CONTINUE
            CIJ=PROD
            IPOWER=IDEGRE-(IROW-1)
            DPOWER=IPOWER
            DIJ=(XI-EKNOL)**DPOWER
            ANUM=CIJ*DIJ
C
            IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'SPL2')THEN
              WRITE(ICOUT,8771)IROW,DEG,IPOWER,XI,CIJ,DIJ,ANUM
 8771         FORMAT('XI,IROW,DEG,IPOWER,XI,CIJ,DIJ,ANUM = ',I8,E15.7,
     1               I8,4E15.7)
              CALL DPWRST('XXX','BUG ')
            ENDIF
C
            PROD=1.0
            DO8800M=J,LMAX
              IF(M.EQ.L)GOTO8800
              EKNOL=EKNOT(L)
              EKNOM=EKNOT(M)
              PROD=PROD*(EKNOL-EKNOM)
 8800       CONTINUE
            ADEN=PROD
            RATIO=ANUM/ADEN
            SUM=SUM+RATIO
C
            IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'SPL2')THEN
              WRITE(ICOUT,8811)ANUM,ADEN,RATIO,SUM
 8811         FORMAT('ANUM,ADEN,RATIO,SUM = ',4E15.8)
              CALL DPWRST('XXX','BUG ')
            ENDIF
C
 8700     CONTINUE
C
          RIGHT(IROW)=RIGHT(IROW)+B(J)*SUM
C
          IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'SPL2')THEN
            WRITE(ICOUT,8812)IROW,J,RIGHT(IROW),B(J),SUM
 8812       FORMAT('IROW,J,RIGHT(IROW),B(J),SUM = ',2I8,3E15.7)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,8812)IROW,J,RIGHT(IROW),B(J),SUM
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
 8600   CONTINUE
 8500 CONTINUE
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'SPL2')THEN
        WRITE(ICOUT,8901)
 8901   FORMAT('AFTER STEP 12 IN DPSPL2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,8902)
 8902   FORMAT('A(.,.), RIGHT(.) = ')
        CALL DPWRST('XXX','BUG ')
        DO8910I=1,IDEGP1
          WRITE(ICOUT,8911) (A(I,J),J=1,IDEGP1),RIGHT(I)
 8911     FORMAT(8E15.7)
          CALL DPWRST('XXX','BUG ')
 8910   CONTINUE
      ENDIF
C
      IDEGP1=IDEGRE+1
      CALL BACK50(A,IDEGP1,IDEGP1,RIGHT,BTEMP,IBUGA3)
C
      DO8950I=1,IDEGP1
        L3=L3+1
        B2(L3)=BTEMP(I)
 8950 CONTINUE
C
 8100 CONTINUE
      K2=L3
C
C               *********************************************
C               **  STEP 13--                              **
C               **  PRINT OUT GOODNESS OF FIT INFORMATION  **
C               *********************************************
C
      IF(IREP.EQ.'YES')THEN
        FITDF=IFITDF
        FITSS=RESSS-REPSS
        FITMS=FITSS/FITDF
        FSTAT=FITMS/REPMS
        CALL FCDF(FSTAT,IFITDF,IREPDF,CDF)
        CDF2=100.0*CDF
CCCCC   THE FOLLOWING LINE WAS INSERTED MARCH 1988.
        ALFCDF=CDF
      ENDIF
C
      IF(IPRINT.EQ.'ON')THEN
        ITITLE='Least Squares Spline Fit'
        NCTITL=24
        ITITLZ=' '
        NCTITZ=0
C
        ICNT=1
        IF(IDEGRE.EQ.1)THEN
          ITEXT(ICNT)='Model--Linear Spline'
          NCTEXT(ICNT)=20
        ELSEIF(IDEGRE.EQ.2)THEN
          ITEXT(ICNT)='Model--Quadratic Spline'
          NCTEXT(ICNT)=23
        ELSEIF(IDEGRE.EQ.3)THEN
          ITEXT(ICNT)='Model--Cubic Spline'
          NCTEXT(ICNT)=19
        ELSEIF(IDEGRE.EQ.4)THEN
          ITEXT(ICNT)='Model--4-th Degree Spline'
          NCTEXT(ICNT)=25
        ELSEIF(IDEGRE.EQ.5)THEN
          ITEXT(ICNT)='Model--5-th Degree Spline'
          NCTEXT(ICNT)=25
        ELSEIF(IDEGRE.EQ.6)THEN
          ITEXT(ICNT)='Model--6-th Degree Spline'
          NCTEXT(ICNT)=25
        ELSEIF(IDEGRE.EQ.7)THEN
          ITEXT(ICNT)='Model--7-th Degree Spline'
          NCTEXT(ICNT)=25
        ELSEIF(IDEGRE.EQ.8)THEN
          ITEXT(ICNT)='Model--8-th Degree Spline'
          NCTEXT(ICNT)=25
        ELSEIF(IDEGRE.EQ.9)THEN
          ITEXT(ICNT)='Model--9-th Degree Spline'
          NCTEXT(ICNT)=25
        ELSEIF(IDEGRE.EQ.10)THEN
          ITEXT(ICNT)='Model--10-th Degree Spline'
          NCTEXT(ICNT)=26
        ENDIF
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
C
        ICNT=ICNT+1
        ITEXT(ICNT)='Sample Size:'
        NCTEXT(ICNT)=12
        AVALUE(ICNT)=REAL(N)
        IDIGIT(ICNT)=0
        ICNT=ICNT+1
        ITEXT(ICNT)='Number of Knots:'
        NCTEXT(ICNT)=16
        AVALUE(ICNT)=REAL(NKNOT)
        IDIGIT(ICNT)=0
        ICNT=ICNT+1
        ITEXT(ICNT)=' '
        NCTEXT(ICNT)=0
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
C
        ICNT=ICNT+1
        ITEXT(ICNT)='Residual Standard Deviation:'
        NCTEXT(ICNT)=28
        AVALUE(ICNT)=RESSD
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Residual Degrees of Freedom:'
        NCTEXT(ICNT)=28
        AVALUE(ICNT)=REAL(IRESDF)
        IDIGIT(ICNT)=0
C
        IF(IREP.EQ.'NO')THEN
          ICNT=ICNT+1
          ITEXT(ICNT)=' '
          NCTEXT(ICNT)=0
          AVALUE(ICNT)=0.0
          IDIGIT(ICNT)=-1
          ICNT=ICNT+1
          ITEXT(ICNT)='No Replication Case'
          NCTEXT(ICNT)=19
          AVALUE(ICNT)=0.0
          IDIGIT(ICNT)=-1
        ELSEIF(IREP.EQ.'YES')THEN
          ICNT=ICNT+1
          ITEXT(ICNT)='Replication Standard Deviation:'
          NCTEXT(ICNT)=31
          AVALUE(ICNT)=REPSD
          IDIGIT(ICNT)=NUMDIG
          ICNT=ICNT+1
          ITEXT(ICNT)='Replication Degrees of Freedom:'
          NCTEXT(ICNT)=31
          AVALUE(ICNT)=REAL(IREPDF)
          IDIGIT(ICNT)=0
          ICNT=ICNT+1
          ITEXT(ICNT)='Number of Distinct Subsets:'
          NCTEXT(ICNT)=27
          AVALUE(ICNT)=REAL(NUMSET)
          IDIGIT(ICNT)=0
C
          IFITDF=IRESDF-IREPDF
          IF(IFITDF.LT.1)THEN
            ICNT=ICNT+1
            ITEXT(ICNT)='The Lack of Fit F Test cannot be done'
            NCTEXT(ICNT)=37
            AVALUE(ICNT)=0.0
            IDIGIT(ICNT)=-1
            ICNT=ICNT+1
            ITEXT(ICNT)='because there are 0 degrees of freedom'
            NCTEXT(ICNT)=38
            AVALUE(ICNT)=0.0
            IDIGIT(ICNT)=-1
            ICNT=ICNT+1
            ITEXT(ICNT)='in the numerator of the F ratio.  This'
            NCTEXT(ICNT)=38
            AVALUE(ICNT)=0.0
            IDIGIT(ICNT)=-1
            ICNT=ICNT+1
            ITEXT(ICNT)='This happens when the number of'
            NCTEXT(ICNT)=31
            AVALUE(ICNT)=0.0
            IDIGIT(ICNT)=-1
            ICNT=ICNT+1
            ITEXT(ICNT)='parameters fitted is identical to the'
            NCTEXT(ICNT)=37
            AVALUE(ICNT)=0.0
            IDIGIT(ICNT)=-1
            ICNT=ICNT+1
            ITEXT(ICNT)='number of distinct subsets.'
            NCTEXT(ICNT)=27
            AVALUE(ICNT)=0.0
            IDIGIT(ICNT)=-1
          ELSE
            ICNT=ICNT+1
            ITEXT(ICNT)='Lack of Fit F Ratio:'
            NCTEXT(ICNT)=20
            AVALUE(ICNT)=FSTAT
            IDIGIT(ICNT)=NUMDIG
            ICNT=ICNT+1
            ITEXT(ICNT)='Lack of Fit F CDF (%):'
            NCTEXT(ICNT)=22
            AVALUE(ICNT)=CDF2
            IDIGIT(ICNT)=NUMDIG
            ICNT=ICNT+1
            ITEXT(ICNT)='Lack of Fit Degrees of Freedom 1:'
            NCTEXT(ICNT)=33
            AVALUE(ICNT)=REAL(IFITDF)
            IDIGIT(ICNT)=0
            ICNT=ICNT+1
            ITEXT(ICNT)='Lack of Fit Degrees of Freedom 2:'
            NCTEXT(ICNT)=33
            AVALUE(ICNT)=REAL(IREPDF)
            IDIGIT(ICNT)=0
          ENDIF
        ENDIF
C
        NUMROW=ICNT
        DO5410I=1,NUMROW
          NTOT(I)=15
 5410   CONTINUE
C
        IFRST=.TRUE.
        ILAST=.TRUE.
        CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,
     1              NCTEXT,AVALUE,IDIGIT,
     1              NTOT,NUMROW,
     1              ICAPSW,ICAPTY,ILAST,IFRST,
     1              ISUBRO,IBUGA3,IERROR)
C
        ITITLE=' '
        NCTITL=0
        ITITL9='Intervals'
        NCTIT9=9
C
        ITITL2(1,1)=' '
        NCTIT2(1,1)=0
        ITITL2(1,2)=' '
        NCTIT2(1,2)=0
        ITITL2(1,3)=' '
        NCTIT2(1,3)=0
        ITITL2(1,4)='Number of'
        NCTIT2(1,4)=9
C
        ITITL2(2,1)='Interval'
        NCTIT2(2,1)=8
        ITITL2(2,2)='Lower'
        NCTIT2(2,2)=5
        ITITL2(2,3)='Upper'
        NCTIT2(2,3)=5
        ITITL2(2,4)='Observations'
        NCTIT2(2,4)=12
C
        ITITL2(3,1)='Number'
        NCTIT2(3,1)=6
        ITITL2(3,2)='Knot'
        NCTIT2(3,2)=4
        ITITL2(3,3)='Knot'
        NCTIT2(3,3)=4
        ITITL2(3,4)='in Interval'
        NCTIT2(3,4)=11
C
        NMAX=0
        NUMCOL=4
        DO4210I=1,NUMCOL
          VALIGN(I)='b'
          ALIGN(I)='r'
          NTOT(I)=15
          IF(I.EQ.1)NTOT(I)=12
          NMAX=NMAX+NTOT(I)
          DO4211J=1,MAXROW
            ITYPCO(J,I)='NUME'
 4211     CONTINUE
          IDIGIT(I)=NUMDIG
          IF(I.EQ.1)THEN
            IDIGIT(I)=0
          ELSEIF(I.EQ.4)THEN
            IDIGIT(I)=0
          ENDIF
          IWHTML(1)=125
          IWHTML(2)=150
          IWHTML(3)=150
          IWHTML(4)=150
          IINC=1400
          IINC3=2200
          IWRTF(1)=IINC
          IWRTF(2)=IWRTF(1)+IINC3
          IWRTF(3)=IWRTF(2)+IINC3
          IWRTF(4)=IWRTF(3)+IINC3
 4210   CONTINUE
C
        L=1
        ISUM=0
        DO1100I=1,N
          IF(X(I).LT.XKNOT(1))ISUM=ISUM+1
 1100   CONTINUE
C
        ITYPCO(1,2)='ALPH'
        AMAT(L,1)=REAL(L)
        AMAT(L,2)=0.0
        AMAT(L,3)=XKNOT(L)
        AMAT(L,4)=REAL(ISUM)
        IVALUE(L,1)=' '
        NCVALU(L,1)=0
        IVALUE(L,2)='-Infinity'
        NCVALU(L,2)=9
        IVALUE(L,3)=' '
        NCVALU(L,3)=0
        IVALUE(L,4)=' '
        NCVALU(L,4)=0
C
        IF(NKNOT.GE.2)THEN
          DO1200L=2,NKNOT
            LM1=L-1
            ISUM=0
            DO1300I=1,N
              IF(XKNOT(LM1).LE.X(I).AND.X(I).LT.XKNOT(L))ISUM=ISUM+1
 1300       CONTINUE
            ITYPCO(L,2)='NUME'
            AMAT(L,1)=REAL(L)
            AMAT(L,2)=XKNOT(LM1)
            AMAT(L,3)=XKNOT(L)
            AMAT(L,4)=REAL(ISUM)
            IVALUE(L,1)=' '
            NCVALU(L,1)=0
            IVALUE(L,2)=' '
            NCVALU(L,2)=0
            IVALUE(L,3)=' '
            NCVALU(L,3)=0
            IVALUE(L,4)=' '
            NCVALU(L,4)=0
 1200     CONTINUE
        ENDIF
C
        L=NKNOT+1
        ISUM=0
        DO1400I=1,N
          IF(XKNOT(NKNOT).LE.X(I))ISUM=ISUM+1
 1400   CONTINUE
C
        ITYPCO(L,2)='NUME'
        ITYPCO(L,3)='ALPH'
        AMAT(L,1)=REAL(L)
        AMAT(L,2)=XKNOT(NKNOT)
        AMAT(L,3)=0.0
        AMAT(L,4)=REAL(ISUM)
        IVALUE(L,1)=' '
        NCVALU(L,1)=0
        IVALUE(L,2)=' '
        NCVALU(L,2)=0
        IVALUE(L,3)='+Infinity'
        NCVALU(L,3)=9
        IVALUE(L,4)=' '
        NCVALU(L,4)=0
C
        ICNT=L
        NUMLIN=3
        NUMCOL=4
        IFRST=.TRUE.
        ILAST=.TRUE.
        IFLAGS=.TRUE.
        IFLAGE=.TRUE.
        CALL DPDT5C(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              IFLAGS,IFLAGE,
     1              ISUBRO,IBUGA3,IERROR)
C
C       **********************************
C       **  STEP 14--                   **
C       **  WRITE OUT THE COEFFICIENTS  **
C       **********************************
C
        ISTEPN='13'
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SPL2')
     1     CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IBUGJU='OFF'
C
        ITITLE=' '
        NCTITL=0
        ITITL9='Estimation'
        NCTIT9=10
C
        ITITL2(1,1)='Interval'
        NCTIT2(1,1)=8
        NCOLSP(1,1)=1
        ITITL2(1,2)='Parameter'
        NCTIT2(1,2)=9
        NCOLSP(1,2)=1
        ITITL2(1,3)='Estimate'
        NCTIT2(1,3)=8
        NCOLSP(1,3)=1
C
        NMAX=0
        NUMCOL=3
        DO5210I=1,NUMCOL
          VALIGN(I)='b'
          ALIGN(I)='r'
          NTOT(I)=15
          IF(I.EQ.1)NTOT(I)=12
          NMAX=NMAX+NTOT(I)
          ITYPC2(I)='NUME'
          IF(I.EQ.2)ITYPC2(I)='ALPHA'
 5211     CONTINUE
          IWHTML(1)=125
          IWHTML(2)=150
          IWHTML(3)=150
          IINC=1400
          IINC3=2200
          IWRTF(1)=IINC
          IWRTF(2)=IWRTF(1)+IINC3
          IWRTF(3)=IWRTF(2)+IINC3
 5210   CONTINUE
C
        NUMLIN=1
        NUMCOL=3
        ICNT2=0
        L=0
        IKNMAX=NKNOT+1
        JMAX=IDEGRE+1
        DO7500IKN=1,IKNMAX
C
          IF(L+JMAX+1.GT.MAXROW)THEN
            IFRST=.TRUE.
            ILAST=.TRUE.
            IFLAGS=.TRUE.
            IF(ICNT2.GT.0)IFLAGS=.FALSE.
            IFLAGE=.TRUE.
            ICNT=L
            CALL DPDT5B(ITITLE,NCTITL,
     1                  ITITL9,NCTIT9,ITITL2,NCTIT2,
     1                  MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1                  IVALUE,NCVALU,AMAT,ITYPC2,MAXROW,ICNT,
     1                  IDIGI2,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1                  NCOLSP,ROWSEP,
     1                  ICAPSW,ICAPTY,IFRST,ILAST,
     1                  IFLAGS,IFLAGE,
     1                  ISUBRO,IBUGA3,IERROR)
          ENDIF
C
          DO7600J=1,JMAX
            L=L+1
            JM1=J-1
            CALL COENAM(IKN,JM1,IH,IH2,IBUGJU,IERROR)
            AMAT(L,1)=REAL(IKN)
            AMAT(L,2)=0.0
            AMAT(L,3)=B2(L)
            IVALUE(L,1)=' '
            NCVALU(L,1)=0
            IVALUE(L,2)(1:4)=IH(1:4)
            IVALUE(L,2)(5:8)=IH2(1:4)
            NCVALU(L,2)=8
            IVALUE(L,3)=' '
            NCVALU(L,3)=0
            IDIGI2(L,1)=0
            IDIGI2(L,2)=0
            IDIGI2(L,3)=NUMDIG
            ROWSEP(L)=0
 7600     CONTINUE
          L=L+1
          ROWSEP(L)=0
          DO7620JJ=1,3
            AMAT(L,JJ)=0.0
            IVALUE(L,JJ)=' '
            NCVALU(L,JJ)=0
            IDIGI2(L,JJ)=-1
 7620     CONTINUE
 7500   CONTINUE
C
        ICNT=L
        IF(ICNT.GT.0)THEN
          IFRST=.TRUE.
          ILAST=.TRUE.
          IFLAGS=.TRUE.
          IF(ICNT2.GT.0)IFLAGS=.FALSE.
          IFLAGE=.TRUE.
          CALL DPDT5B(ITITLE,NCTITL,
     1                ITITL9,NCTIT9,ITITL2,NCTIT2,
     1                MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1                IVALUE,NCVALU,AMAT,ITYPC2,MAXROW,ICNT,
     1                IDIGI2,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1                NCOLSP,ROWSEP,
     1                ICAPSW,ICAPTY,IFRST,ILAST,
     1                IFLAGS,IFLAGE,
     1                ISUBRO,IBUGA3,IERROR)
        ENDIF
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'SPL2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSPL2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)IERROR,N,NKNOT,IDEGRE,K2
 9013   FORMAT('IERROR,N,NKNOT,IDEGRE,K2 = ',A4,2X,4I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,K2
          WRITE(ICOUT,9016)I,B2(I),SDB2(I)
 9016     FORMAT('I,B2(I),SDB2(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
        WRITE(ICOUT,9021)IREP,NUMVAR
 9021   FORMAT('IREP,NUMVAR = ',A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9023)REPSS,REPMS,REPSD,REPDF,NUMSET
 9023   FORMAT('REPSS,REPMS,REPSD,REPDF,NUMSET = ',4G15.7,I8)
        CALL DPWRST('XXX','BUG ')
        DO9025I=1,N
          WRITE(ICOUT,9026)I,Y(I),X(I),W(I),PRED2(I),RES2(I)
 9026     FORMAT('I,Y(I),X(I),W(I),PRED2(I),RES2(I) = ',I8,5G15.7)
          CALL DPWRST('XXX','BUG ')
 9025   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSPLC(IANS,IWIDTH,ITERCH,
     1IANSV,IWIDSV,IBUGGC,IERROR)
C
C     PURPOSE--SEARCH THE VECTOR IANS(.) FOR THE
C              SEPARATOR CHARACTOR.
C              REFORM IANS(.) AND IWIDTH BY OMITTING
C              FROM IANS(.) ALL CHARACTERS
C              FROM THE FIRST SEPARATOR CHARACTOR TO THE END
C              (THE SEPARATOR CHARACTOR ITSELF WILL BE OMITTED).
C              FORM IANSV(.) AND IWIDSV BY
C              SAVING ALL CHARACTERS IN THE ORIGINAL IANS(.)
C              AFTER THE FIRST SEPARATOR CHARACTOR.
C              THE ORIGINAL COMMAND LINE HAS THUS BEEN SPLIT INTO
C              2 PARTS WITH THE FIRST SEPARATOR CHARACTOR AS THE PARTITION.
C              THE FIRST PART WILL REMAIN IN IANS(.);
C              THE SECOND PART WILL BE SAVED IN IANSV(.).
C     NOTE--IANS AND IWIDTH ARE BOTH INPUT AND OUTPUT ARGUMENTS.
C           THE INPUT ARGUMENTS IANS AND IWIDTH BOTH GET CHANGED
C           DURING THE EXECUTION OF THIS SUBROUTINE.
C     INPUT  ARGUMENTS--IANS   (A  HOLLERITH VECTOR WHOSE
C                              I-TH ELEMENT CONTAINS THE
C                              I-TH CHARACTER OF THE
C                              ORIGINAL INPUT COMMAND LINE.
C                     --IWIDTH (AN INTEGER VARIABLE WHICH
C                              CONTAINS THE NUMBER OF CHARACTERS
C                              IN THE ORIGINAL COMMAND LINE.
C                     --ITERCH (A  HOLLERITH VARIABLE WHICH
C                              CONTAINS THE TERMINATORCHARACTER.
C     OUTPUT ARGUMENTS--IANS   (A  HOLLERITH VECTOR WHOSE
C                              I-TH ELEMENT CONTAINS THE
C                              I-TH CHARACTER OF THE
C                              FIRST PART OF THE ORIGINAL COMMAND LINE
C                              (UP TO BUT EXCLUDING THE TERMINATORCHARACTOR).
C                     --IWIDTH (AN INTEGER VARIABLE WHICH
C                              CONTAINS THE NUMBER OF CHARACTERS
C                              IN THE FIRST PART OF THE ORIGINAL COMMAND LINE.
C                     --IANSV  (A  HOLLERITH VECTOR WHOSE
C                              I-TH ELEMENT CONTAINS THE
C                              I-TH CHARACTER OF THE
C                              SECOND PART OF THE COMMAND LINE
C                              (STARTING WITH THE CHARACTER AFTER
C                              THE TERMINATORCHARACTER).
C                     --IWIDSV (AN INTEGER VARIABLE WHICH
C                              CONTAINS THE NUMBER OF CHARACTERS
C                              IN THE SECOND PART OF THE ORIGINAL COMMAND LINE.
C                     --IBUGGC   (A HOLLERITH VARIABLE
C                              FOR DEBUGGING
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--NOVEMBER  1980.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IANS
      CHARACTER*4 ITERCH
      CHARACTER*4 IANSV
      CHARACTER*4 IBUGGC
      CHARACTER*4 IERROR
C
      CHARACTER*4 IBLANK
C
C---------------------------------------------------------------------
C
      DIMENSION IANS(*)
      DIMENSION IANSV(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='NO'
C
      IF(IBUGGC.EQ.'OFF')GOTO109
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,101)
  101 FORMAT('AT THE BEGINNING OF DPSPLC--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,102)(IANS(I),I=1,IWIDTH)
  102 FORMAT('IANS(.) = ',120A1)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,103)IWIDTH
  103 FORMAT('IWIDTH = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,104)ITERCH
  104 FORMAT('ITERCH = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,105)(IANSV(I),I=1,IWIDSV)
  105 FORMAT('IANSV(.) = ',120A1)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,106)IWIDSV
  106 FORMAT('IWIDSV = ',I8)
      CALL DPWRST('XXX','BUG ')
  109 CONTINUE
C
C               *************************************
C               **  STEP 1--                       **
C               **  TRIM THE VALUE OF IWIDTH       **
C               **  BY IGNORING BLANKS ON THE END  **
C               **  OF IANS(.)                     **
C               *************************************
C
      DO150I=1,IWIDTH
      IREV=IWIDTH-I+1
      IF(IANS(IREV).NE.' ')GOTO160
  150 CONTINUE
      IWIDTH=0
      IWIDSV=0
      GOTO900
  160 CONTINUE
      IWIDTH=IREV
C
C               *************************************
C               **  STEP 2--                       **
C               **  BLANK OUT THE IANSV(.) VECTOR. **
C               **  NOTE THAT THIS NEED ONLY BE    **
C               **  DONE OUT TO IWIDTH ELEMENTS    **
C               **  SINCE IANSV(.) WILL NEVER      **
C               **  BE LARGER THAN IANS(.)         **
C               *************************************
C
      IBLANK=' '
      DO200I=1,IWIDTH
      IANSV(I)=IBLANK
  200 CONTINUE
C
C               **********************************
C               **  STEP 3--                    **
C               **  SCAN THE IANS(.) VECTOR TO  **
C               **  SEARCH FOR THE TERMINATOR   **
C               **********************************
C
      DO300I=1,IWIDTH
      ILOCSP=I
      IF(IANS(I).EQ.ITERCH)GOTO390
  300 CONTINUE
      ILOCSP=IWIDTH+1
  390 CONTINUE
C
C               ***********************************
C               **  STEP 4--                     **
C               **  COMPUTE IANSV(.) AND IWIDSV  **
C               ***********************************
C
      J=0
      IMIN=ILOCSP+1
      IMAX=IWIDTH
      IF(IMIN.GT.IMAX)GOTO450
      DO400I=IMIN,IMAX
      J=J+1
      IANSV(J)=IANS(I)
  400 CONTINUE
  450 CONTINUE
      IWIDSV=J
C
C               *****************************************************
C               **  STEP 5--                                       **
C               **  RECOMPUTE THE VALUE OF IWIDTH--                **
C               **  FIRST BY DEFINING IT TO BE                     **
C               **  IMMEDIATELY BEFORE THE TERMINATOR CHARACTOR,   **
C               **  AND THEN TRIMMING IT FURTHER BY                **
C               **  IGNORING ANY BLANKS AT THE NEW END OF IANS(.)  **
C               *****************************************************
C
  500 CONTINUE
      IWIDTH=ILOCSP-1
C
      DO510I=1,IWIDTH
      IREV=IWIDTH-I+1
      IF(IANS(IREV).NE.' ')GOTO520
  510 CONTINUE
      IREV=0
  520 CONTINUE
      IWIDTH=IREV
C
C               ****************
C               **  STEP 9--  **
C               **  EXIT      **
C               ****************
C
  900 CONTINUE
      IF(IBUGGC.EQ.'OFF')GOTO909
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,901)
  901 FORMAT('AT THE END OF DPSPLC--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,902)(IANS(I),I=1,IWIDTH)
  902 FORMAT('IANS(.) = ',120A1)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,903)IWIDTH
  903 FORMAT('IWIDTH = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,904)ITERCH
  904 FORMAT('ITERCH = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,905)(IANSV(I),I=1,IWIDSV)
  905 FORMAT('IANSV(.) = ',120A1)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,906)IWIDSV
  906 FORMAT('IWIDSV = ',I8)
      CALL DPWRST('XXX','BUG ')
  909 CONTINUE
C
  990 CONTINUE
      RETURN
      END
      SUBROUTINE DPSPLI(IHARG,IHARG2,NUMARG,IDEFSL,MAXSPI,ISPILI,
CCCCC AUGUST 1995.  ADD IHARG2 FOR DASH2, ETC
CCCCC SUBROUTINE DPSPLI(IHARG,NUMARG,IDEFSL,MAXSPI,ISPILI,
     1IBUGP2,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE SPIKE LINE TYPES.
C              THESE ARE LOCATED IN THE VECTOR ISPILI(.).
C     INPUT  ARGUMENTS--IHARG  (A  CHARACTER VECTOR)
C                     --NUMARG
C                     --IDEFSL
C                     --MAXSPI
C                     --IBUGP2 ('ON' OR 'OFF' )
C     OUTPUT ARGUMENTS--ISPILI (A CHARACTER VECTOR)
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--DECEMBER  1983.
C     UPDATED         --AUGUST    1995.  DASH2 BUG
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
CCCCC AUGUST 1995.  ADD FOLLOWING LINE
      CHARACTER*4 IHARG2
      CHARACTER*4 IDEFSL
      CHARACTER*4 ISPILI
C
      CHARACTER*4 IBUGP2
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHOLD1
      CHARACTER*4 IHOLD2
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      DIMENSION IHARG(*)
CCCCC AUGUST 1995.  ADD FOLLOWING LINE
      DIMENSION IHARG2(*)
      DIMENSION ISPILI(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      ISUBN1='DPSP'
      ISUBN2='LI  '
C
      NUMSPI=0
      IHOLD1='-999'
      IHOLD2='-999'
C
      IF(IBUGP2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPSPLI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGP2,IFOUND,IERROR
   52 FORMAT('IBUGP2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)MAXSPI,NUMSPI
   53 FORMAT('MAXSPI,NUMSPI = ',I8,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IHOLD1,IHOLD2
   54 FORMAT('IHOLD1,IHOLD2 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IDEFSL
   55 FORMAT('IDEFSL = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,60)NUMARG
   60 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO65I=1,NUMARG
      WRITE(ICOUT,66)IHARG(I)
   66 FORMAT('IHARG(I) = ',A4)
      CALL DPWRST('XXX','BUG ')
   65 CONTINUE
      WRITE(ICOUT,70)ISPILI(1)
   70 FORMAT('ISPILI(1) = ',A4)
      CALL DPWRST('XXX','BUG ')
      DO75I=1,10
      WRITE(ICOUT,76)I,ISPILI(I)
   76 FORMAT('I,ISPILI(I) = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
   75 CONTINUE
   90 CONTINUE
C
C               **************************************
C               **  STEP 1--                        **
C               **  BRANCH TO THE APPROPRIATE CASE  **
C               **************************************
C
      ISTEPN='1'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.0)GOTO9000
      IF(NUMARG.EQ.1)GOTO1110
      IF(NUMARG.EQ.2)GOTO1120
      IF(NUMARG.EQ.3)GOTO1130
      GOTO1140
C
 1110 CONTINUE
      GOTO1200
C
 1120 CONTINUE
      IF(IHARG(2).EQ.'ALL')IHOLD1='    '
      IF(IHARG(2).EQ.'ALL')GOTO1300
      GOTO1200
C
 1130 CONTINUE
CCCCC IF(IHARG(2).EQ.'ALL')IHOLD1=IHARG(3)
CCCCC IF(IHARG(2).EQ.'ALL')GOTO1300
CCCCC IF(IHARG(3).EQ.'ALL')IHOLD1=IHARG(2)
CCCCC IF(IHARG(3).EQ.'ALL')GOTO1300
CCCCC APRIL 1996.  CHANGE IHOLD TO IHOLD1 BELOW
      IF(IHARG(2).EQ.'ALL')THEN
        IHOLD1=IHARG(3)
        IF(IHOLD1.EQ.'DASH'.AND.IHARG2(3).EQ.'2')IHOLD1='DA2'
        IF(IHOLD1.EQ.'DASH'.AND.IHARG2(3).EQ.'3')IHOLD1='DA3'
        IF(IHOLD1.EQ.'DASH'.AND.IHARG2(3).EQ.'4')IHOLD1='DA4'
        IF(IHOLD1.EQ.'DASH'.AND.IHARG2(3).EQ.'5')IHOLD1='DA5'
        GOTO1300
      ENDIF
      IF(IHARG(3).EQ.'ALL')THEN
        IHOLD1=IHARG(2)
        IF(IHOLD1.EQ.'DASH'.AND.IHARG2(2).EQ.'2')IHOLD1='DA2'
        IF(IHOLD1.EQ.'DASH'.AND.IHARG2(2).EQ.'3')IHOLD1='DA3'
        IF(IHOLD1.EQ.'DASH'.AND.IHARG2(2).EQ.'4')IHOLD1='DA4'
        IF(IHOLD1.EQ.'DASH'.AND.IHARG2(2).EQ.'5')IHOLD1='DA5'
        GOTO1300
      ENDIF
      GOTO1200
C
 1140 CONTINUE
      GOTO1200
C
C               *************************************************
C               **  STEP 2--                                   **
C               **  TREAT THE INDIVIDUAL SPECIFICATIONS CASE  **
C               *************************************************
C
 1200 CONTINUE
      ISTEPN='2'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.1)GOTO1210
      GOTO1220
C
 1210 CONTINUE
      NUMSPI=1
      ISPILI(1)='    '
      GOTO1270
C
 1220 CONTINUE
      NUMSPI=NUMARG-1
      IF(NUMSPI.GT.MAXSPI)NUMSPI=MAXSPI
      DO1225I=1,NUMSPI
      J=I+1
      IHOLD1=IHARG(J)
      IF(IHOLD1.EQ.'DASH'.AND.IHARG2(J).EQ.'2')IHOLD1='DA2'
      IF(IHOLD1.EQ.'DASH'.AND.IHARG2(J).EQ.'3')IHOLD1='DA3'
      IF(IHOLD1.EQ.'DASH'.AND.IHARG2(J).EQ.'4')IHOLD1='DA4'
      IF(IHOLD1.EQ.'DASH'.AND.IHARG2(J).EQ.'5')IHOLD1='DA5'
      IHOLD2=IHOLD1
      IF(IHOLD1.EQ.'ON')IHOLD2='SOLI'
      IF(IHOLD1.EQ.'OFF')IHOLD2='    '
      IF(IHOLD1.EQ.'AUTO')IHOLD2=IDEFSL
      IF(IHOLD1.EQ.'DEFA')IHOLD2=IDEFSL
      ISPILI(I)=IHOLD2
 1225 CONTINUE
      GOTO1270
C
 1270 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO1279
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      DO1278I=1,NUMSPI
      WRITE(ICOUT,1276)I,ISPILI(I)
 1276 FORMAT('SPIKE LINE ',I6,' HAS JUST BEEN SET TO ',
     1A4)
      CALL DPWRST('XXX','BUG ')
 1278 CONTINUE
 1279 CONTINUE
      IFOUND='YES'
      GOTO9000
C
C               **************************
C               **  STEP 2--            **
C               **  TREAT THE ALL CASE  **
C               **************************
C
 1300 CONTINUE
      ISTEPN='3'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NUMSPI=MAXSPI
      IHOLD2=IHOLD1
      IF(IHOLD1.EQ.'ON')IHOLD2='SOLI'
      IF(IHOLD1.EQ.'OFF')IHOLD2='    '
      IF(IHOLD1.EQ.'AUTO')IHOLD2=IDEFSL
      IF(IHOLD1.EQ.'DEFA')IHOLD2=IDEFSL
      DO1315I=1,NUMSPI
      ISPILI(I)=IHOLD2
 1315 CONTINUE
      GOTO1370
C
 1370 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO1319
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      I=1
      WRITE(ICOUT,1316)ISPILI(I)
 1316 FORMAT('ALL SPIKE LINES HAVE JUST BEEN SET TO ',
     1A4)
      CALL DPWRST('XXX','BUG ')
 1319 CONTINUE
      IFOUND='YES'
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGP2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPSPLI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGP2,IFOUND,IERROR
 9012 FORMAT('IBUGP2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)MAXSPI,NUMSPI
 9013 FORMAT('MAXSPI,NUMSPI = ',I8,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IHOLD1,IHOLD2
 9014 FORMAT('IHOLD1,IHOLD2 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IDEFSL
 9015 FORMAT('IDEFSL = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9020)NUMARG
 9020 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9025I=1,NUMARG
      WRITE(ICOUT,9026)IHARG(I)
 9026 FORMAT('IHARG(I) = ',A4)
      CALL DPWRST('XXX','BUG ')
 9025 CONTINUE
      WRITE(ICOUT,9030)ISPILI(1)
 9030 FORMAT('ISPILI(1) = ',A4)
      CALL DPWRST('XXX','BUG ')
      DO9035I=1,10
      WRITE(ICOUT,9036)I,ISPILI(I)
 9036 FORMAT('I,ISPILI(I) = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9035 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPSPMA(NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2,
     1                  IANGLU,MAXNPP,MAXNXT,
     1                  CLLIMI,CLWIDT,
     1                  ICONT,NUMHPP,NUMVPP,IMANUF,
     1                  XMATN,YMATN,XMITN,YMITN,
     1                  ISQUAR,IVGMSW,IHGMSW,
     1                  IMPSW,IMPNR,IMPNC,IMPCO,
     1                  PMXMIN,PMXMAX,PMYMIN,PMYMAX,
CCCCC1                  TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,
     1                  ALOWFR,ALOWDG,IFORSW,ICAPSW,
     1                  ANOPL1,ANOPL2,ISEED,IBOOSS,BARHEF,BARWEF,
     1                  IBUGG2,IBUGG3,IBUGCO,IBUGEV,IBUGQ,
     1                  IBUGUG,IBUGU2,IBUGU3,IBUGU4,ISUBRO,
     1                  IFOUND,IERROR)
C
C     PURPOSE--GENERATE A SCATTER PLOT MATRIX
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--99/9
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--SEPTEMBER 1999.
C     UPDATED--AUGUST      2007. CALL LIST TO MAINGR
C     UPDATED--AUGUST      2011. USE DPPARS TO PARSE COMMAND LINE
C     UPDATED--AUGUST      2011. USE DPAUFI TO OPEN/CLOSE TEMPORARY FILES
C     UPDATED--AUGUST      2011. SAVE/RESTORE PLOT CONTROL SETTINGS
C                                USING DPSPM5
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES---------------
C
      REAL CLLIMI(*)
      REAL CLWIDT(*)
C
      INCLUDE 'DPCOPA.INC'
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICASEQ
      CHARACTER*4 ICONT
      CHARACTER*4 IAND1
      CHARACTER*4 IAND2
      CHARACTER*4 IANGLU
      CHARACTER*4 IFORSW
C
      CHARACTER*4 IBUGG2
      CHARACTER*4 IBUGG3
      CHARACTER*4 IBUGUG
      CHARACTER*4 IBUGU2
      CHARACTER*4 IBUGU3
      CHARACTER*4 IBUGU4
      CHARACTER*4 IBUGCO
      CHARACTER*4 IBUGEV
      CHARACTER*4 IBUGQ
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISQUAR
      CHARACTER*4 IVGMSW
      CHARACTER*4 IHGMSW
      CHARACTER*4 IREPCH
      CHARACTER*4 IMPSW
C
      CHARACTER*4 IPLOTT
      CHARACTER*4 ICT
      CHARACTER*4 IC2T
      CHARACTER*4 IHT(5)
      CHARACTER*4 IH2T(5)
      CHARACTER*4 ICBT
      CHARACTER*4 IC2BT
      CHARACTER*4 IHBT(5)
      CHARACTER*4 IH2BT(5)
C
      CHARACTER*4 ISPMTZ
      CHARACTER*4 ISPMFZ
      CHARACTER*4 ISPMPZ
      CHARACTER*4 ISPMLZ
      CHARACTER*4 ISPML2
      CHARACTER*4 ISPMZT
      CHARACTER*4 ISPMZ2
      CHARACTER*4 ISPMZ3
      CHARACTER*4 ISPMZ4
      CHARACTER*4 ISPMXZ
      CHARACTER*4 ISPMYZ
      CHARACTER*4 ISPMDZ
      CHARACTER*4 ISUBSZ
C
      CHARACTER*4 IFEED9
      CHARACTER*4 IMANUF
      CHARACTER*4 IEMPTY
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
C
      PARAMETER(MAXY=25)
      CHARACTER*40 INAME
      CHARACTER*4 IVARN1(MAXY)
      CHARACTER*4 IVARN2(MAXY)
      CHARACTER*4 IVARTY(MAXY)
      DIMENSION ILIS(MAXY)
      DIMENSION PVAR(MAXY)
      DIMENSION NRIGHT(MAXY)
      DIMENSION ICOLL(MAXY)
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN0
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
      DIMENSION TEMP(MAXOBV)
      DIMENSION TEMP2(MAXOBV)
      DIMENSION TEMP3(MAXOBV)
      DIMENSION XTEMP1(MAXOBV)
      DIMENSION XTEMP2(MAXOBV)
C
C-----COMMON------------------------------------------------------
C
      INCLUDE 'DPCOZ3.INC'
CCCCC INCLUDE 'DPCOZZ.INC'
      INCLUDE 'DPCOPC.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOST.INC'
      INCLUDE 'DPCOSP.INC'
C
      EQUIVALENCE (G3RBAG(KGARB1),TEMP(1))
      EQUIVALENCE (G3RBAG(KGARB2),TEMP2(1))
      EQUIVALENCE (G3RBAG(KGARB3),TEMP3(1))
      EQUIVALENCE (G3RBAG(KGARB4),XTEMP1(1))
      EQUIVALENCE (G3RBAG(KGARB5),XTEMP2(1))
C
C-----COMMON VARIABLES (GENERAL)----------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-------------------------------------------------
C
      IFOUND='YES'
      IERROR='NO'
C
      ISUBN1='DPSPMA'
      ISUBN2='    '
C
      ICASPL='SPMA'
      NDONE=0
C
C               *****************************************
C               **  TREAT THE SCATTER PLOT MATRIX CASE **
C               *****************************************
C
      IF(IBUGG2.EQ.'ON' .OR. ISUBRO.EQ.'SPMA')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSPMA--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)ICASPL,IAND1,IAND2,NUMARG
   52   FORMAT('ICASPL,IAND1,IAND2,NUMARG = ',3(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)IBUGG2,IBUGG3,IBUGQ,ISUBRO
   53   FORMAT('IBUGG2,IBUGG3,IBUGQ,ISUBRO = ',3(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
        IF(NUMARG.GT.0)THEN
          DO61I=1,NUMARG
            WRITE(ICOUT,62)I,IHARG(I),IARGT(I)
   62       FORMAT('I,IHARG(I),IARGT(I) = ',I8,2X,A4,2X,A4)
            CALL DPWRST('XXX','BUG ')
   61     CONTINUE
        ENDIF
      ENDIF
C
C               *******************************************************
C               **  STEP 1--                                         **
C               **  SHIFT COMMAND LINE ARGMENTS                      **
C               *******************************************************
C
      ISTEPN='1'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPMA')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ISHIFT=0
      IF(NUMARG.GE.2.AND.IHARG(1).EQ.'PLOT'.AND.
     1   IHARG(2).EQ.'MATR')THEN
        ISHIFT=2
      ELSEIF(NUMARG.GE.1.AND.IHARG(1).EQ.'PLOT')THEN
        ISHIFT=1
      ELSEIF(NUMARG.GE.2.AND.ICOM.EQ.'YOUD'.AND.IHARG(1).EQ.'MATR'.AND.
     1   IHARG(2).EQ.'PLOT')THEN
        ISHIFT=2
        ISPMPZ=ISPMPT
        ISPMPT='YOUD'
      ELSEIF(NUMARG.GE.2.AND.ICOM.EQ.'DEX '.AND.IHARG(1).EQ.'INTE'.AND.
     1   IHARG2(1).EQ.'RACT'.AND.IHARG(2).EQ.'PLOT')THEN
        ISHIFT=2
        ISPMPZ=ISPMPT
        ISPMPT='DEXI'
        ISPMTZ=ISPMTA
        ISPMTA='OFF'
      ELSEIF(NUMARG.GE.4.AND.ICOM.EQ.'DEX '.AND.IHARG(2).EQ.'INTE'.AND.
     1   IHARG(3).EQ.'EFFE'.AND.IHARG(4).EQ.'PLOT')THEN
        ISHIFT=4
        ISPMPZ=ISPMPT
        ISPMPT='DEXS'
        ISPMTZ=ISPMTA
        ISPMTA='OFF'
        ISPMZT=ISPMST
        ISPMZ2=ISPMS2
        ISPMZ3=ISPMS3
        ISPMZ4=ISPMS4
        ISPMST=IHARG(1)
        ISPMS2=IHARG2(1)
        ISPMS3='    '
        ISPMS4='    '
      ELSEIF(NUMARG.GE.3.AND.ICOM.EQ.'DEX '.AND.IHARG(2).EQ.'INTE'.AND.
     1   IHARG(3).EQ.'PLOT')THEN
        ISHIFT=3
        ISPMPZ=ISPMPT
        ISPMPT='DEXS'
        ISPMTZ=ISPMTA
        ISPMTA='OFF'
        ISPMZT=ISPMST
        ISPMZ2=ISPMS2
        ISPMZ3=ISPMS3
        ISPMZ4=ISPMS4
        ISPMST=IHARG(1)
        ISPMS2=IHARG2(1)
        ISPMS3='    '
        ISPMS4='    '
      ELSEIF(NUMARG.GE.5.AND.ICOM.EQ.'DEX '.AND.IHARG(3).EQ.'INTE'.AND.
     1   IHARG(4).EQ.'EFFE'.AND.IHARG(5).EQ.'PLOT')THEN
        ISHIFT=5
        ISPMPZ=ISPMPT
        ISPMPT='DEXS'
        ISPMTZ=ISPMTA
        ISPMTA='OFF'
        ISPMZT=ISPMST
        ISPMZ2=ISPMS2
        ISPMZ3=ISPMS3
        ISPMZ4=ISPMS4
        ISPMST=IHARG(1)
        ISPMS2=IHARG2(1)
        ISPMS3=IHARG(2)
        ISPMS4=IHARG2(2)
      ELSEIF(NUMARG.GE.4.AND.ICOM.EQ.'DEX '.AND.IHARG(3).EQ.'INTE'.AND.
     1   IHARG(4).EQ.'PLOT')THEN
        ISHIFT=4
        ISPMPZ=ISPMPT
        ISPMPT='DEXS'
        ISPMTZ=ISPMTA
        ISPMTA='OFF'
        ISPMZT=ISPMST
        ISPMZ2=ISPMS2
        ISPMZ3=ISPMS3
        ISPMZ4=ISPMS4
        ISPMST=IHARG(1)
        ISPMS2=IHARG2(1)
        ISPMS3=IHARG(2)
        ISPMS4=IHARG2(2)
      ENDIF
C
      IF(ISHIFT.GT.0)THEN
        CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1              IBUGG2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ENDIF
C
      ICOM='PLOT'
      ICOM2='    '
      IFOUND='YES'
C
C               *******************************************************
C               **  STEP 2--                                         **
C               **  CHECK FOR THE PROPER NUMBER OF INPUT ARGUMENTS.  **
C               *******************************************************
C
      ISTEPN='2'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPMA')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='SCATTER PLOT MATRIX'
      MINNA=1
      MAXNA=100
      MINN2=2
      IFLAGE=1
      IF(ISPMPT.EQ.'BIHI')IFLAGE=0
      IF(ISPMPT.EQ.'QQPL')IFLAGE=0
      IF(ISPMPT.EQ.'DEXC')IFLAGE=99
      IFLAGM=1
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
      MINNVA=2
      MAXNVA=MAXY
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXY,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLL,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGG3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPMA')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLL(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLL(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
C               **************************************************
C               **   STEP 1--                                   **
C               **   SAVE INITIAL SETTINGS                      **
C               **************************************************
C
      ISTEPN='1'
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'SPMA')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IFLAG=1
      CALL DPSPM5(IFLAG,IMPSW,IMPCO,IMPNR,IMPNC,IOUNI5,
     1            IBUGG2,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
      ISPMTZ=ISPMTA
      ISPMFZ=ISPMFR
      ISPMPZ=ISPMPT
      ISPMLZ=ISPMLD
      ISPML2=ISPMLA
      ISPMZT=ISPMST
      ISPMZ2=ISPMS2
      ISPMZ3=ISPMS3
      ISPMZ4=ISPMS4
      ISPMXZ=ISPMXA
      ISPMYZ=ISPMYA
      ISPMDZ=ISPMDI
C
      IF(ISPMLA.EQ.'BOX'.AND.ISPMPT.EQ.'BIHI')ISPMLA='ON'
      IF(ISPMFR.EQ.'USER'.AND.ISPMLA.EQ.'BOX')ISPMLA='ON'
      IF(ISPMFR.EQ.'CONN')ISPMFR='DEFA'
      IF(ISPMLA.EQ.'BOX ')THEN
        ISPMLD='ON'
CCCCC   ISPMXA='BOTT'
CCCCC   ISPMYA='LEFT'
        IF(ISPMDI.EQ.'BLAN')ISPMDI='LINE'
      ENDIF
C
      IOPTN=1
      IDX=0
      IDY=0
      CALL DPSPM4(ICASPL,IOPTN,IDX,IDY,
     1            ISUBNU,ISUBSW,
     1            ASUBXL,ASUBXU,ASUBYL,ASUBYU,
     1            ISUBN9,ISUBSZ,
     1            ASBXL2,ASBXU2,ASBYL2,ASBYU2,
     1            PSPLSL,PSPLSU,PSPLSL,PSPLSU,
     1            IBUGG2,ISUBRO,IERROR)
C
      IFEED9=IFEEDB
C
      IF(ISPMPT.EQ.'YOUD'.OR.ISPMPT.EQ.'DEXC')THEN
        ISPMTA='ON'
      ENDIF
C
      IF(ISPMTA.EQ.'ON')THEN
        ISHIFT=ILOCQ-1
        CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1              IBUGG2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        ISHIFT=NUMVAR-1
        CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1              IBUGG2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        DO1509I=1,NUMVAR-1
          IHARG(I)=IVARN1(I)
          IHARG2(I)=IVARN2(I)
 1509   CONTINUE
        NUMVAR=NUMVAR-1
        IF(NUMVAR.LT.2)GOTO9000
      ENDIF
C
      IMPSW3=IMPSW
      IMPCO2=IMPCO
      IMPNR2=IMPNR
      IMPNC2=IMPNC
      IMPSW='ON'
      IMPCO=1
      IMPCO9=IMPCO
      IMPNR=NUMVAR
      IMPNC=NUMVAR
      NPLOTS=IMPNR*IMPNC
C
C               *************************************
C               **   STEP 21--                     **
C               **   GENERATE THE SCATTER PLOTS    **
C               *************************************
C
 2100 CONTINUE
      ISTEPN='21'
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'DPSPMA')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ISHIFT=NUMVAR
      CALL ADJUST(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
      ISHIFT=2
      CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1IBUGG2,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
      IHARG(1)=IVARN1(1)
      IHARG2(1)=IVARN2(1)
      IHARG(2)=IVARN1(1)
      IHARG2(2)=IVARN2(1)
C
      IF(ISPMLA.EQ.'BOX')THEN
        IMPNR=NUMVAR+1
        IMPNC=NUMVAR+1
      ENDIF
C
      IF(ISPMPT.EQ.'BIHI')THEN
        ICT='RELA'
        IC2T='TIVE'
        IHT(1)='BIHI'
        IH2T(1)='STOG'
        NCCOMM=1
        ICBT='RELA'
        IC2BT='TIVE'
        IHBT(1)='HIST'
        IH2BT(1)='OGRA'
        NCCOM2=1
        IPLOTT='BIHI'
        GOTO5000
      ELSEIF(ISPMPT.EQ.'DEXI')THEN
        ICT='INTE'
        IC2T='RACT'
        NCCOMM=1
        IHT(NCCOMM)='PLOT'
        IH2T(NCCOMM)='    '
        ICBT=ICT
        IC2BT=IC2T
        NCCOM2=NCCOMM
        DO2105II=1,NCCOMM
          IHBT(II)=IHT(II)
          IH2BT(II)=IH2T(II)
 2105   CONTINUE
        IPLOTT='DEXI'
        IRESP=1
        GOTO6599
      ELSEIF(ISPMPT.EQ.'DEXS')THEN
        IF(ISPMST.NE.'    ')THEN
          ICT=ISPMST
          IC2T=ISPMS2
          NCCOMM=0
          IF(ISPMS3.NE.'    ')THEN
            IHT(1)=ISPMS3
            IH2T(1)=ISPMS4
            NCCOMM=1
          ENDIF
        ELSE
          ICT='MEAN'
          IC2T='    '
          NCCOMM=0
        ENDIF
        NCCOMM=NCCOMM+1
        IHT(NCCOMM)='INTE'
        IH2T(NCCOMM)='RACT'
        NCCOMM=NCCOMM+1
        IHT(NCCOMM)='PLOT'
        IH2T(NCCOMM)='    '
        ICBT=ICT
        IC2BT=IC2T
        NCCOM2=NCCOMM
        DO2108II=1,NCCOMM
          IHBT(II)=IHT(II)
          IH2BT(II)=IH2T(II)
 2108   CONTINUE
        IPLOTT='DEXS'
        IRESP=1
        GOTO6599
      ELSEIF(ISPMPT.EQ.'CROS')THEN
        IF(ISPMST.NE.'    ')THEN
          ICT='CROS'
          IC2T='S   '
          IHT(1)='TABU'
          IH2T(1)='LATE'
          IHT(2)=ISPMST
          IH2T(2)=ISPMS2
          NCCOMM=2
          IF(ISPMS3.NE.'    ')THEN
            IHT(3)=ISPMS3
            IH2T(3)=ISPMS4
            NCCOMM=3
          ENDIF
          NCCOMM=NCCOMM+1
          IHT(NCCOMM)='PLOT'
          IH2T(NCCOMM)='    '
          ICBT=ISPMST
          IC2BT=ISPMS2
          NCCOM2=0
          IF(ISPMS3.NE.'    ')THEN
            IHT(1)=ISPMS3
            IH2T(1)=ISPMS4
            NCCOM2=1
          ENDIF
          NCCOM2=NCCOM2+1
          IHBT(NCCOM2)='PLOT'
          IH2BT(NCCOM2)='    '
          IPLOTT='CRO2'
          IRESP=1
        ELSE
          ICT='CROS'
          IC2T='S   '
          IHT(1)='TABU'
          IH2T(1)='LATE'
          IHT(2)='PLOT'
          IH2T(2)='    '
          NCCOMM=2
          ICBT='PLOT'
          IC2BT='    '
          NCCOM2=0
          IPLOTT='CROS'
          IRESP=0
        ENDIF
        GOTO6599
      ELSEIF(ISPMPT.EQ.'DEXC')THEN
        ICT='DEX '
        IC2T='    '
        IHT(1)='CONT'
        IH2T(1)='OUR '
        IHT(2)='PLOT'
        IH2T(2)='    '
        NCCOMM=2
        ICBT='DEX '
        IC2BT='    '
        IHBT(1)='CONT'
        IH2BT(1)='OUR '
        IHBT(2)='PLOT'
        IH2BT(2)='    '
        NCCOM2=2
        IPLOTT='DEXC'
        IRESP=1
        GOTO6599
      ELSEIF(ISPMPT.EQ.'QQPL')THEN
        ICT='QUAN'
        IC2T='TILE'
        IHT(1)='QUAN'
        IH2T(1)='TILE'
        IHT(2)='PLOT'
        IH2T(2)='    '
        NCCOMM=2
        ICBT='PERC'
        IC2BT='ENT '
        IHBT(1)='POIN'
        IH2BT(1)='    '
        IHBT(2)='PLOT'
        IH2BT(2)='    '
        NCCOM2=2
        IPLOTT='QQSP'
        IPPTBI='UNBI'
        GOTO5000
      ELSEIF(ISPMPT.EQ.'CORR')THEN
        ICT='CROS'
        IC2T='S   '
        IHT(1)='CORR'
        IH2T(1)='ELAT'
        IHT(2)='PLOT'
        IH2T(2)='    '
        NCCOMM=2
        ICBT='AUTO'
        IC2BT='CORR'
        IHBT(1)='PLOT'
        IH2BT(1)='    '
        NCCOM2=1
        IPLOTT='CCOR'
        GX1MIN=0.0
        IX1MIN='FIXE'
        GOTO5000
      ELSEIF(ISPMPT.EQ.'SPEC')THEN
        ICT='CROS'
        IC2T='S   '
        IHT(1)='SPEC'
        IH2T(1)='TRAL'
        IHT(2)='PLOT'
        IH2T(2)='    '
        NCCOMM=2
        ICBT='SPEC'
        IC2BT='TRAL'
        IHBT(1)='PLOT'
        IH2BT(1)='    '
        NCCOM2=1
        IPLOTT='CSPE'
        ISPMFZ=ISPMFR
        IF(IY1MIN.NE.'FIXE'.OR.IY1MAX.NE.'FIXE'.OR.
     1     IY2MIN.NE.'FIXE'.OR.IY2MAX.NE.'FIXE')THEN
           ISPMFR='USER'
        ENDIF
        GOTO5000
      ELSEIF(ISPMPT.EQ.'LAG ')THEN
        ICT='CROS'
        IC2T='S   '
        IHT(1)='LAG '
        IH2T(1)='    '
        IHT(2)='PLOT'
        IH2T(2)='    '
        NCCOMM=2
        ICBT='LAG '
        IC2BT='    '
        IHBT(1)='PLOT'
        IH2BT(1)='    '
        NCCOM2=1
        IPLOTT='CLAG'
        GOTO5000
      ENDIF
C
C               *************************************
C               **   SCATTER PLOT CASE             **
C               *************************************
C
      IF(ISPMTA.EQ.'ON')THEN
        ISHIFT=1
        CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1              IBUGG2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IHARG(3)=IVARN1(NUMVAR+1)
        IHARG2(3)=IVARN2(NUMVAR+1)
      ENDIF
C
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'DPSPMA')THEN
        WRITE(ICOUT,1720)NUMVAR
 1720 FORMAT('      NUMVAR = ',I8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      NARGT=NUMARG
      DO3000IROW=1,IMPNR
        DO4000ITEMP1=1,IMPNC
C
          IF(IROW.LE.NUMVAR)THEN
            IHARG(1)=IVARN1(IROW)
            IHARG2(1)=IVARN2(IROW)
            IDX=IROW
          ELSE
            IHARG(1)=IVARN1(NUMVAR)
            IHARG2(1)=IVARN2(NUMVAR)
            IDX=NUMVAR
          ENDIF
          ICOL=ITEMP1
          IEMPTY='NO'
          IF(ISPMLA.EQ.'BOX')THEN
            ICOL=ITEMP1-1
            IF(ICOL.EQ.0)IEMPTY='YES'
            IF(IROW.EQ.IMPNR)IEMPTY='YES'
          ENDIF
C
          IF(IROW.GT.ICOL.AND.ISPMLD.EQ.'OFF')THEN
            IMPCO=IMPCO+1
            GOTO4000
          ENDIF
C
          IF(ICOL.EQ.0)THEN
            IHARG(2)=IVARN1(1)
            IHARG2(2)=IVARN2(1)
            IDY=1
          ELSE
            IHARG(2)=IVARN1(ICOL)
            IHARG2(2)=IVARN2(ICOL)
            IDY=ICOL
          ENDIF
C
          IF(IEMPTY.EQ.'YES')THEN
            DO3104I=1,MAXSUB
              ISU2SW(I)=ISUBSW(I)
              ISUBSW(I)='OFF'
 3104       CONTINUE
          ENDIF
          IOPTN=3
          CALL DPSPM4(ICASPL,IOPTN,IDX,IDY,
     1                ISUBNU,ISUBSW,
     1                ASUBXL,ASUBXU,ASUBYL,ASUBYU,
     1                ISUBN9,ISUBSZ,
     1                ASBXL2,ASBXU2,ASBYL2,ASBYU2,
     1                PSPLSL,PSPLSU,PSPLSL,PSPLSU,
     1                IBUGG2,ISUBRO,IERROR)
C
          ICASPL='SPMA'
          CALL DPSPM1(ICASPL,IVARN1,IVARN2,ICOLL,
     1                IMPNR,IMPNC,IROW,ICOL,IROW,ICOL,IPLOT,
     1                NPLOTS,NUMVAR,
     1                ICHAP2,ILINP2,
     1                GY1MNS,GY1MXS,GY2MNS,GY2MXS,
     1                GX1MNS,GX1MXS,GX2MNS,GX2MXS,
     1                IY1MNS,IY1MXS,IY2MNS,IY2MXS,
     1                IX1MNS,IX1MXS,IX2MNS,IX2MXS,
     1                IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1                IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1                PX1LD2,PX2LD2,
     1                IY1LJ2,IY1LD2,PY1LD2,PY1LA2,
     1                IX1LT2,IX2LT2,IY1LT2,IY2LT2,
     1                NCX1L2,NCX2L2,NCY1L2,NCY2L2,
     1                PSPLLL,PSPLUL,PSPLLL,PSPLUL,ICOL,
     1                ISPMLA,ISPMLD,ISPMPT,ISPMFR,ISPMXA,ISPMYA,
     1                ISPMDI,
     1                ISPMTD,PSPMTD,IVNMEX,
     1                IBUGG2,ISUBRO)
          IERROR='NO'
C
          IF(IEMPTY.EQ.'YES')THEN
            DO3106I=1,100
              ICHAPA(I)='BLAN'
              ILINPA(I)='BLAN'
              ISPISW(I)='OFF'
              IBARSW(I)='OFF'
 3106        CONTINUE
             CALL MAINGR(ANOPL1,ANOPL2,NPLOTV,NPLOTP,NS,ICASPL,
     1                   MAXNPP,ISEED,IBOOSS,
     1                   IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1                   IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1                   BARHEF,BARWEF,
     1                   IRHSTG,IHSTCW,IHSTEB,IHSTOU,IASHWT,
     1                   ICAPSW,IFORSW,
     1                   IGUIFL,IERRFA,
     1                   IAND1,IAND2,ICONT,NUMHPP,NUMVPP,
CCCCC1                   TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,MAXNXT,
     1                   MAXNXT,
     1                   ISUBRO,IFOUND,IERROR)
             GOTO4089
          ENDIF
C
          IF(IROW.EQ.ICOL)THEN
            IF(ISPMDI.NE.'LINE')THEN
               DO3110I=1,100
                 ICHAPA(I)='BLAN'
                 ILINPA(I)='BLAN'
                 ISPISW(I)='OFF'
                 IBARSW(I)='OFF'
 3110          CONTINUE
            ENDIF
            CALL MAINGR(ANOPL1,ANOPL2,NPLOTV,NPLOTP,NS,ICASPL,
     1                   MAXNPP,ISEED,IBOOSS,
     1                   IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1                   IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1                   BARHEF,BARWEF,
     1                   IRHSTG,IHSTCW,IHSTEB,IHSTOU,IASHWT,
     1                   ICAPSW,IFORSW,
     1                   IGUIFL,IERRFA,
     1                   IAND1,IAND2,ICONT,NUMHPP,NUMVPP,
CCCCC1                   TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,MAXNXT,
     1                   MAXNXT,
     1                   ISUBRO,IFOUND,IERROR)
            IF(IERROR.EQ.'YES')GOTO4000
            ICONT=IDCONT(1)
            NUMHPP=IDNHPP(1)
            IMPARG=2
            CALL DPGRAP(Y,X,X3D,D,N,NPLOTP,ICASPL,ICONT,NUMHPP,
     1                  XMATN,YMATN,XMITN,YMITN,
     1                  ISQUAR,
     1                  IVGMSW,IHGMSW,
     1                  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,
     1                  IVSTAR,IVSTOP,IFUNC,NUMCHF,IREPCH,
     1                  YPLOT,XPLOT,X2PLOT,TAGPLO,
     1                  IMPSW,IMPNR,IMPNC,IMPCO,IMPCO9,
     1                  IMPARG,
     1                  PMXMIN,PMXMAX,PMYMIN,PMYMAX,
     1                  MAXCOL,
     1                  DSIZE,DSYMB,DCOLOR,DFILL,
     1                  ICAPSW,
     1                  IBUGUG,IBUGU2,IBUGU3,IBUGU4,ISUBRO,
     1                  IERROR)
            IF(IERROR.EQ.'NO')IAND1=IAND2
            DO3120I=1,100
              ICHAPA(I)=ICHAP2(I)
              ILINPA(I)=ILINP2(I)
              ISPISW(I)=ISPIS2(I)
              IBARSW(I)=IBARS2(I)
 3120       CONTINUE
            IERASW='OFF'
            IF(ISPMDI.EQ.'LINE'.OR.ISPMDI.EQ.'BLAN')GOTO4000
            IX1TSW='OFF'
            IX1ZSW='OFF'
            IX2TSW='OFF'
            IX2ZSW='OFF'
            IY1TSW='OFF'
            IY1ZSW='OFF'
            IY2TSW='OFF'
            IY2ZSW='OFF'
C
            IF(ISPMDI.EQ.'BOXP'.AND.ISPMTA.EQ.'ON')THEN
              IMPCO=IMPCO-1
              DO3130I=1,100
                ICHAPA(I)='BLAN'
                ILINPA(I)='BLAN'
                IBARSW(I)='OFF'
                ISPISW(I)='OFF'
 3130         CONTINUE
              ICHAPA(1)='X'
              ICHAPA(4)='X'
              ICHAPA(7)='X'
              ICHAPA(21)='CIRC'
              ICHAPA(22)='CIRC'
              ICHAPA(23)='CIRC'
              ICHAPA(24)='CIRC'
              ILINPA(8)='SOLI'
              ILINPA(13)='SOLI'
              ILINPA(14)='SOLI'
              ILINPA(15)='SOLI'
              ILINPA(16)='SOLI'
              ILINPA(20)='SOLI'
              IFENSW='ON'
              GY1MIN=FY1MNZ
              GY1MAX=FY1MXZ
              GY2MIN=GY1MIN
              GY2MAX=GY1MAX
              IY1MIN='FIXE'
              IY1MAX='FIXE'
              IY2MIN='FIXE'
              IY2MAX='FIXE'
              IX1MIN='FLOA'
              IX1MAX='FLOA'
              IX2MIN='FLOA'
              IX2MAX='FLOA'
              IX1TSW='OFF'
              IX1ZSW='OFF'
              IX2TSW='OFF'
              IX2ZSW='OFF'
              IY1TSW='OFF'
              IY1ZSW='OFF'
              IY2TSW='OFF'
              IY2ZSW='OFF'
              ICOM='BOX '
              ICOM2='    '
              IHARG(1)='PLOT'
              IHARG2(1)='    '
              IHARG(2)=IVARN1(IROW)
              IHARG2(2)=IVARN2(IROW)
              IHARG(3)=IVARN1(NUMVAR+1)
              IHARG2(3)=IVARN2(NUMVAR+1)
              CALL MAINGR(ANOPL1,ANOPL2,NPLOTV,NPLOTP,NS,ICASPL,
     1                   MAXNPP,ISEED,IBOOSS,
     1                   IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1                   IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1                   BARHEF,BARWEF,
     1                   IRHSTG,IHSTCW,IHSTEB,IHSTOU,IASHWT,
     1                   ICAPSW,IFORSW,
     1                   IGUIFL,IERRFA,
     1                   IAND1,IAND2,ICONT,NUMHPP,NUMVPP,
CCCCC1                   TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,MAXNXT,
     1                   MAXNXT,
     1                   ISUBRO,IFOUND,IERROR)
              ISHIFT=1
              CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                    IBUGG2,IERROR)
              ICOM='PLOT'
              ICOM2='    '
              IHARG(1)=IVARN1(IROW)
              IHARG2(1)=IVARN2(IROW)
              IHARG(2)=IVARN1(ICOL)
              IHARG2(2)=IVARN2(ICOL)
              IHARG(3)=IVARN1(NUMVAR+1)
              IHARG2(3)=IVARN2(NUMVAR+1)
              GOTO4089
            ELSEIF(ISPMDI.EQ.'HIST')THEN
              IMPCO=IMPCO-1
              ICOM='HIST'
              ICOM2='    '
              ISHIFT=1
              IF(ISPMTA.EQ.'ON')ISHIFT=2
              CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                    IBUGG2,IERROR)
              IHARG(1)=IVARN1(IROW)
              IHARG2(1)=IVARN2(IROW)
              CALL MAINGR(ANOPL1,ANOPL2,NPLOTV,NPLOTP,NS,ICASPL,
     1                   MAXNPP,ISEED,IBOOSS,
     1                   IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1                   IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1                   BARHEF,BARWEF,
     1                   IRHSTG,IHSTCW,IHSTEB,IHSTOU,IASHWT,
     1                   ICAPSW,IFORSW,
     1                   IGUIFL,IERRFA,
     1                   IAND1,IAND2,ICONT,NUMHPP,NUMVPP,
CCCCC1                   TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,MAXNXT,
     1                   MAXNXT,
     1                   ISUBRO,IFOUND,IERROR)
              ISHIFT=1
              IF(ISPMTA.EQ.'ON')ISHIFT=2
              CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                    IBUGG2,IERROR)
              ICOM='PLOT'
              ICOM2='    '
              IHARG(1)=IVARN1(ICOL)
              IHARG2(1)=IVARN2(ICOL)
              IHARG(2)=IVARN1(ICOL)
              IHARG2(2)=IVARN2(ICOL)
              IF(ISPMTA.EQ.'ON')THEN
                IHARG(3)=IVARN1(NUMVAR+1)
                IHARG2(3)=IVARN2(NUMVAR+1)
              ENDIF
              IY1MIN='FLOA'
              IY1MAX='FLOA'
              IY2MIN='FLOA'
              IY2MAX='FLOA'
              IX1MIN='FLOA'
              IX1MAX='FLOA'
              IX2MIN='FLOA'
              IX2MAX='FLOA'
              GOTO4089
            ENDIF
            GOTO4000
          ENDIF 
C
          CALL MAINGR(ANOPL1,ANOPL2,NPLOTV,NPLOTP,NS,ICASPL,
     1                   MAXNPP,ISEED,IBOOSS,
     1                   IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1                   IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1                   BARHEF,BARWEF,
     1                   IRHSTG,IHSTCW,IHSTEB,IHSTOU,IASHWT,
     1                   ICAPSW,IFORSW,
     1                   IGUIFL,IERRFA,
     1                   IAND1,IAND2,ICONT,NUMHPP,NUMVPP,
CCCCC1                   TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,MAXNXT,
     1                   MAXNXT,
     1                   ISUBRO,IFOUND,IERROR)
          IF(IEMPTY.EQ.'NO')THEN
            IF(
     1       (IROW.NE.ICOL.AND.(ISPX2L.EQ.'CORR'.OR.ISPX2L.EQ.'PCOR'))
     1       .OR.ISPX2L.EQ.'PACC'.OR.
     1       ISPX2L.EQ.'NACC'.OR.ISPX2L.EQ.'ATP '.OR.
     1       ISPX2L.EQ.'AT  ')
     1       CALL DPSPM3(ICASPL,IOUNI5,
     1                   IROW,ICOL,
     1                   PX2LD2,NPLOTP,
     1                   IFORSW,
     1                   ISPX2L,ISPX2P,ISPX2S,
     1                   IHRIGH,IHRIG2,IHWUSE,
     1                   ISUBN1,ISUBN2,MESSAG,
     1                   IBUGG2,ISUBRO,IERROR)
          ENDIF
C
          IF(IERROR.EQ.'YES')THEN
            IMPCO=IMPCO+1
            GOTO4000
          ENDIF
C
 4089     CONTINUE
          ICONT=IDCONT(1)
          NUMHPP=IDNHPP(1)
          IMPARG=2
          CALL DPGRAP(Y,X,X3D,D,N,NPLOTP,ICASPL,ICONT,NUMHPP,
     1                XMATN,YMATN,XMITN,YMITN,
     1                ISQUAR,
     1                IVGMSW,IHGMSW,
     1                IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,
     1                IVSTAR,IVSTOP,IFUNC,NUMCHF,IREPCH,
     1                YPLOT,XPLOT,X2PLOT,TAGPLO,
     1                IMPSW,IMPNR,IMPNC,IMPCO,IMPCO9,
     1                IMPARG,
     1                PMXMIN,PMXMAX,PMYMIN,PMYMAX,
     1                MAXCOL,
     1                DSIZE,DSYMB,DCOLOR,DFILL,
     1                ICAPSW,
     1                IBUGUG,IBUGU2,IBUGU3,IBUGU4,ISUBRO,
     1                IERROR)
          IF(IERROR.EQ.'NO')IAND1=IAND2
          IF(ISPMFI.EQ.'NONE')GOTO4090
          IF(IEMPTY.EQ.'YES')GOTO4090
          IF(IROW.EQ.ICOL)GOTO4090
          IMPCO=IMPCO-1
          IF(IMPCO.LE.1)IERASW='OFF'
          IF(IERROR.EQ.'YES')GOTO4000
C
          CALL DPSPM2(ICASPL,IVARN1,IVARN2,ICOLL,NUMVAR,NPLOTP,
     1                IROW,ICOL,
     1                TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,MAXNXT,
     1                ALOWFR,ALOWDG,
     1                IANGLU,MAXNPP,IAND1,IAND2,
     1                ISPMFI,ISPMTA,
     1                XMATN,YMATN,XMITN,YMITN,
     1                ISQUAR,
     1                IVGMSW,IHGMSW,
     1                IMPSW,IMPNR,IMPNC,IMPCO,IMPCO9,
     1                IREPCH,
     1                PMXMIN,PMXMAX,PMYMIN,PMYMAX,
     1                IBUGG2,IBUGG3,IBUGCO,IBUGEV,IBUGQ,
     1                IBUGUG,IBUGU2,IBUGU3,IBUGU4,
     1                ISUBRO,IFOUND,IERROR)
C
 4090     CONTINUE
          PX1LDS=PX1LD2
          GX1MIN=GX1MNS
          GX1MAX=GX1MXS
          GX2MIN=GX2MNS
          GX2MAX=GX2MXS
          GY1MIN=GY1MNS
          GY1MAX=GY1MXS
          GY2MIN=GY2MNS
          GY2MAX=GY2MXS
          IX1MIN=IX1MNS
          IX1MAX=IX1MXS
          IX2MIN=IX2MNS
          IX2MAX=IX2MXS
          IY1MIN=IY1MNS
          IY1MAX=IY1MXS
          IY2MIN=IY2MNS
          IY2MAX=IY2MXS
          PX1ZDS=PX1ZD2
          PX2ZDS=PX2ZD2
          PY1ZDS=PY1ZD2
          PY2ZDS=PY2ZD2
          IF(IEMPTY.EQ.'YES')THEN
            DO4907I=1,MAXSUB
              ISUBSW(I)=ISU2SW(I)
 4907       CONTINUE
          ENDIF
          DO4098I=1,100
            ICHAPA(I)=ICHAP2(I)
            ILINPA(I)=ILINP2(I)
            ISPISW(I)=ISPIS2(I)
            IBARSW(I)=IBARS2(I)
 4098     CONTINUE
          ISHIFT=NARGT-NUMARG
          IF(ISHIFT.GT.0)THEN
            CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                IBUGG2,IERROR)
          ELSEIF(ISHIFT.LT.0)THEN
            ISHIFT=-ISHIFT
            CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                IBUGG2,IERROR)
          ENDIF
          ICOM='PLOT'
          ICOM2='    '
          IHARG(1)=IVARN1(ICOL)
          IHARG2(1)=IVARN2(ICOL)
          IHARG(2)=IVARN1(ICOL)
          IHARG2(2)=IVARN2(ICOL)
          IF(ISPMTA.EQ.'ON')THEN
            IHARG(3)=IVARN1(NUMVAR+1)
            IHARG2(3)=IVARN2(NUMVAR+1)
          ENDIF
C
 4000   CONTINUE
 3000 CONTINUE
      GOTO8000
C
C               *********************************************
C               **   BIHISTOGRAM           CASE            **
C               **   QUANTILE-QUANTILE     CASE            **
C               **   CROSS-CORRELATION     CASE            **
C               **   CROSS-SPECTRUM        CASE            **
C               **   CROSS-LAG             CASE            **
C               **   FOLLOWING ALL USE A SIMILAR STRUCTURE **
C               *********************************************
 5000 CONTINUE
      NARGT=NUMARG
      DO5100IROW=1,IMPNR
        DO5200ITEMP1=1,IMPNC
C
          ICOL=ITEMP1
          IEMPTY='NO'
          IF(ISPMLA.EQ.'BOX')THEN
            ICOL=ITEMP1-1
            IF(ICOL.EQ.0)IEMPTY='YES'
            IF(IROW.EQ.IMPNR)IEMPTY='YES'
          ENDIF
C
          IF(IROW.GT.ICOL.AND.ISPMLD.EQ.'OFF')THEN
            IMPCO=IMPCO+1
            GOTO5200
          ENDIF
C
          IF(IROW.LE.NUMVAR)THEN
            IHARG(1)=IVARN1(IROW)
            IHARG2(1)=IVARN2(IROW)
            IDX=IROW
          ELSE
            IHARG(1)=IVARN1(NUMVAR)
            IHARG2(1)=IVARN2(NUMVAR)
            IDX=NUMVAR
          ENDIF
          IF(ICOL.EQ.0)THEN
            IHARG(2)=IVARN1(1)
            IHARG2(2)=IVARN2(1)
            IDY=1
          ELSE
            IHARG(2)=IVARN1(ICOL)
            IHARG2(2)=IVARN2(ICOL)
            IDY=ICOL
          ENDIF
C
          IF(IEMPTY.EQ.'YES')THEN
            DO5104I=1,MAXSUB
              ISU2SW(I)=ISUBSW(I)
              ISUBSW(I)='OFF'
 5104       CONTINUE
          ENDIF
          IOPTN=3
          CALL DPSPM4(ICASPL,IOPTN,IDX,IDY,
     1                ISUBNU,ISUBSW,
     1                ASUBXL,ASUBXU,ASUBYL,ASUBYU,
     1                ISUBN9,ISUBSZ,
     1                ASBXL2,ASBXU2,ASBYL2,ASBYU2,
     1                PSPLSL,PSPLSU,PSPLSL,PSPLSU,
     1                IBUGG2,ISUBRO,IERROR)
C
          ICASPL='SPMA'
          CALL DPSPM1(ICASPL,IVARN1,IVARN2,ICOLL,
     1                IMPNR,IMPNC,IROW,ICOL,IROW,ICOL,IPLOT,
     1                NPLOTS,NUMVAR,
     1                ICHAP2,ILINP2,
     1                GY1MNS,GY1MXS,GY2MNS,GY2MXS,
     1                GX1MNS,GX1MXS,GX2MNS,GX2MXS,
     1                IY1MNS,IY1MXS,IY2MNS,IY2MXS,
     1                IX1MNS,IX1MXS,IX2MNS,IX2MXS,
     1                IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1                IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1                PX1LD2,PX2LD2,
     1                IY1LJ2,IY1LD2,PY1LD2,PY1LA2,
     1                IX1LT2,IX2LT2,IY1LT2,IY2LT2,
     1                NCX1L2,NCX2L2,NCY1L2,NCY2L2,
     1                PSPLLL,PSPLUL,PSPLLL,PSPLUL,ICOL,
     1                ISPMLA,ISPMLD,IPLOTT,ISPMFR,ISPMXA,ISPMYA,
     1                ISPMDI,
     1                ISPMTD,PSPMTD,IVNMEX,
     1                IBUGG2,ISUBRO)
C
          IF(IEMPTY.EQ.'YES')THEN
            DO5106I=1,100
              ICHAPA(I)='BLAN'
              ILINPA(I)='BLAN'
              ISPISW(I)='OFF'
              IBARSW(I)='OFF'
 5106       CONTINUE
          ENDIF
          IF(IROW.EQ.ICOL)THEN
            ISHIFT=1
            CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                  IBUGG2,IERROR)
            ISHIFT=NCCOM2
            IF(NCCOM2.GT.0)
     1      CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                  IBUGG2,IERROR)
            ICOM=ICBT
            ICOM2=IC2BT
            IF(NCCOM2.GT.0)THEN
              DO5120II=1,NCCOM2
                IHARG(II)=IHBT(II)
                IHARG2(II)=IH2BT(II)
 5120         CONTINUE
            ENDIF
          ELSE
            ISHIFT=NCCOMM
            IF(NCCOMM.GT.0)
     1      CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                  IBUGG2,IERROR)
            ICOM=ICT
            ICOM2=IC2T
            IF(NCCOMM.GT.0)THEN
              DO5130II=1,NCCOMM
                IHARG(II)=IHT(II)
                IHARG2(II)=IH2T(II)
 5130         CONTINUE
            ENDIF
          ENDIF
          CALL MAINGR(ANOPL1,ANOPL2,NPLOTV,NPLOTP,NS,ICASPL,
     1                MAXNPP,ISEED,IBOOSS,
     1                IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1                IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1                BARHEF,BARWEF,
     1                IRHSTG,IHSTCW,IHSTEB,IHSTOU,IASHWT,
     1                ICAPSW,IFORSW,
     1                IGUIFL,IERRFA,
     1                IAND1,IAND2,ICONT,NUMHPP,NUMVPP,
CCCCC1                TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,MAXNXT,
     1                MAXNXT,
     1                ISUBRO,IFOUND,IERROR)
          IF(IEMPTY.EQ.'NO')THEN
            IF(
     1         ISPX2L.EQ.'PACC'.OR.
     1         ISPX2L.EQ.'NACC'.OR.ISPX2L.EQ.'ATP '.OR.
     1         ISPX2L.EQ.'AT  ')
     1         CALL DPSPM3(ICASPL,IOUNI5,
     1                     IROW,ICOL,
     1                     PX2LD2,NPLOTP,
     1                     IFORSW,
     1                     ISPX2L,ISPX2P,ISPX2S,
     1                     IHRIGH,IHRIG2,IHWUSE,
     1                     ISUBN1,ISUBN2,MESSAG,
     1                     IBUGG2,ISUBRO,IERROR)
          ENDIF
C
          ISHIFT=NARGT-NUMARG
          IF(ISHIFT.GT.0)THEN
            CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                IBUGG2,IERROR)
          ELSEIF(ISHIFT.LT.0)THEN
            ISHIFT=-ISHIFT
            CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                IBUGG2,IERROR)
          ENDIF
          ICOM='PLOT'
          ICOM2='    '
          IHARG(1)=IVARN1(ICOL)
          IHARG2(1)=IVARN2(ICOL)
          IHARG(2)=IVARN1(ICOL)
          IHARG2(2)=IVARN2(ICOL)
C
C               **************************************************
C               **   STEP 25--                                  **
C               **   PLOT THE CURRENT PLOT                      **
C               **************************************************
 5190     CONTINUE
          ICONT=IDCONT(1)
          NUMHPP=IDNHPP(1)
          IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'SPMA')THEN
            WRITE(ICOUT,5107)IMANUF,NUMDEV,IDMANU(1)
 5107       FORMAT('IMANUF,NUMDEV,IDMANU(1) = ',A4,I8,2X,A4)
            CALL DPWRST('XXX','BUG ')
          ENDIF
          IMPARG=2
          CALL DPGRAP(Y,X,X3D,D,N,NPLOTP,ICASPL,ICONT,NUMHPP,
     1                XMATN,YMATN,XMITN,YMITN,
     1                ISQUAR,
     1                IVGMSW,IHGMSW,
     1                IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,
     1                IVSTAR,IVSTOP,IFUNC,NUMCHF,IREPCH,
     1                YPLOT,XPLOT,X2PLOT,TAGPLO,
     1                IMPSW,IMPNR,IMPNC,IMPCO,IMPCO9,
     1                IMPARG,
     1                PMXMIN,PMXMAX,PMYMIN,PMYMAX,
     1                MAXCOL,
     1                DSIZE,DSYMB,DCOLOR,DFILL,
     1                ICAPSW,
     1                IBUGUG,IBUGU2,IBUGU3,IBUGU4,ISUBRO,
     1                IERROR)
          IF(IERROR.EQ.'NO')IAND1=IAND2
          IF(IEMPTY.EQ.'YES')THEN
            DO5207I=1,MAXSUB
              ISUBSW(I)=ISU2SW(I)
 5207       CONTINUE
          ENDIF
          PX1LDS=PX1LD2
          GX1MIN=GX1MNS
          GX1MAX=GX1MXS
          GX2MIN=GX2MNS
          GX2MAX=GX2MXS
          GY1MIN=GY1MNS
          GY1MAX=GY1MXS
          GY2MIN=GY2MNS
          GY2MAX=GY2MXS
          IX1MIN=IX1MNS
          IX1MAX=IX1MXS
          IX2MIN=IX2MNS
          IX2MAX=IX2MXS
          IY1MIN=IY1MNS
          IY1MAX=IY1MXS
          IY2MIN=IY2MNS
          IY2MAX=IY2MXS
          PX1ZDS=PX1ZD2
          PX2ZDS=PX2ZD2
          PY1ZDS=PY1ZD2
          PY2ZDS=PY2ZD2
C
 5200   CONTINUE
 5100 CONTINUE
      GOTO8000
C
C               *********************************************
C               **   CROSS TABULATE <STAT> PLOTS  CASE     **
C               **   DEX <STAT> PLOTS             CASE     **
C               **   DEX <STAT> INTERACTION PLOTS CASE     **
C               **   3D-PLOT                PLOTS CASE     **
C               **   DEX CONTOUR            PLOTS CASE     **
C               **   ALL OF THESE USE SIMILAR STRUCTURE    **
C               *********************************************
C
 6599 CONTINUE
C
      IF(IRESP.EQ.1)THEN
        ISHIFT=1
        CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1              IBUGG2,IERROR)
        IHARG(1)=IVARN1(1)
        IHARG2(1)=IVARN2(1)
        IMPNR=IMPNR-1
        IMPNC=IMPNC-1
      ENDIF
C
      IF(ISPMPT.EQ.'DEXC')THEN
        GY1MIN=-2.0
        GY1MAX=2.0
        GY2MIN=-2.0
        GY2MAX=2.0
        IY1MIN='FIXE'
        IY1MAX='FIXE'
        IY2MIN='FIXE'
        IY2MAX='FIXE'
        GX1MIN=-2.0
        GX1MAX=2.0
        GX2MIN=-2.0
        GX2MAX=2.0
        IX1MIN='FIXE'
        IX1MAX='FIXE'
        IX2MIN='FIXE'
        IX2MAX='FIXE'
        ISHIFT=1
        CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1              IBUGG2,IERROR)
        IHARG(4)=IVARN1(NUMVAR+1)
        IHARG2(4)=IVARN2(NUMVAR+1)
        IF(IERROR.EQ.'YES')GOTO9000
      ENDIF
C
      NARGT=NUMARG
C
      NPLOTS=IMPNR
      NPLOT2=IMPNR*IMPNC
      DO6600IROW=1,NPLOTS
        DO6700ITEMP1=1,NPLOTS
C
          ICOL=ITEMP1
          IFACT=ICOL+IRESP
          IEMPTY='NO'
          IF(ISPMLA.EQ.'BOX')THEN
            ICOL=ITEMP1-1
            IF(ICOL.EQ.0)IEMPTY='YES'
            IF(IROW.EQ.IMPNR)IEMPTY='YES'
          ENDIF
C
          IF(IROW.EQ.ICOL.AND.ISPMPT.NE.'DEXC')THEN
            ISHIFT=1
            CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                  IBUGG2,IERROR)
          ENDIF
C
          IFRST=0
          IF(IRESP.EQ.1)THEN
            IHARG(1)=IVARN1(1)
            IHARG2(1)=IVARN2(1)
            IFRST=1
          ENDIF
C
          IRES=IROW+IRESP
          IFRST=IFRST+1
          IF(IRES.LE.NUMVAR)THEN
            IHARG(IFRST)=IVARN1(IRES)
            IHARG2(IFRST)=IVARN2(IRES)
          ELSE
            IHARG(IFRST)=IVARN1(NUMVAR)
            IHARG2(IFRST)=IVARN2(NUMVAR)
          ENDIF
C
          IF(IROW.GT.ICOL.AND.ISPMLD.EQ.'OFF')THEN
            IMPCO=IMPCO+1
            GOTO6700
          ENDIF
C
          IF(IROW.NE.ICOL.OR.ISPMPT.EQ.'DEXC')THEN
            IFRST=IFRST+1
            IF(ICOL.EQ.0)THEN
              IHARG(IFRST)=IVARN1(2)
              IHARG2(IFRST)=IVARN2(2)
            ELSE
              IHARG(IFRST)=IVARN1(IFACT)
              IHARG2(IFRST)=IVARN2(IFACT)
            ENDIF
          ENDIF
C
          IF(ISPMPT.EQ.'DEXC')THEN
            IFRST=IFRST+1
            IHARG(IFRST)=IVARN1(NUMVAR+1)
            IHARG2(IFRST)=IVARN2(NUMVAR+1)
          ENDIF
C
          IF(ISPMPT.EQ.'DEXC'.AND.IROW.EQ.ICOL)IEMPTY='YES'
          IF(IEMPTY.EQ.'YES')THEN
            DO6604I=1,MAXSUB
              ISU2SW(I)=ISUBSW(I)
              ISUBSW(I)='OFF'
 6604       CONTINUE
          ENDIF
          IOPTN=3
          IDY=1
          IDX=2
          CALL DPSPM4(ICASPL,IOPTN,IDX,IDY,
     1                ISUBNU,ISUBSW,
     1                ASUBXL,ASUBXU,ASUBYL,ASUBYU,
     1                ISUBN9,ISUBSZ,
     1                ASBXL2,ASBXU2,ASBYL2,ASBYU2,
     1                PSPLSL,PSPLSU,PSPLSL,PSPLSU,
     1                IBUGG2,ISUBRO,IERROR)
C
          CALL DPSPM1(ICASPL,IVARN1,IVARN2,ICOLL,
     1                IMPNR,IMPNC,IROW,ICOL,IRES,IFACT,IPLOT,
     1                NPLOT2,NUMVAR,
     1                ICHAP2,ILINP2,
     1                GY1MNS,GY1MXS,GY2MNS,GY2MXS,
     1                GX1MNS,GX1MXS,GX2MNS,GX2MXS,
     1                IY1MNS,IY1MXS,IY2MNS,IY2MXS,
     1                IX1MNS,IX1MXS,IX2MNS,IX2MXS,
     1                IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1                IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1                PX1LD2,PX2LD2,
     1                IY1LJ2,IY1LD2,PY1LD2,PY1LA2,
     1                IX1LT2,IX2LT2,IY1LT2,IY2LT2,
     1                NCX1L2,NCX2L2,NCY1L2,NCY2L2,
     1                PSPLLL,PSPLUL,PSPLLL,PSPLUL,ICOL,
     1                ISPMLA,ISPMLD,IPLOTT,ISPMFR,ISPMXA,ISPMYA,
     1                ISPMDI,
     1                ISPMTD,PSPMTD,IVNMEX,
     1                IBUGG2,ISUBRO)
C
          IF(IEMPTY.EQ.'YES')THEN
            DO6606I=1,100
              ICHAPA(I)='BLAN'
              ILINPA(I)='BLAN'
              ISPISW(I)='OFF'
              IBARSW(I)='OFF'
 6606        CONTINUE
          ENDIF
          IF(IROW.EQ.ICOL.AND.ISPMPT.EQ.'CROS'.AND.ISPMST.EQ.'    ')
     1    THEN
            ILINPA(1)='BLAN'
            ICHAPA(1)='BLAN'
            ISPISW(1)='OFF'
            IBARSW(1)='OFF'
          ENDIF
          IF(IROW.EQ.ICOL)THEN
            ISHIFT=NCCOM2
            IF(NCCOM2.GT.0)
     1      CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                  IBUGG2,IERROR)
            ICOM=ICBT
            ICOM2=IC2BT
            IF(NCCOM2.GT.0)THEN
              DO6620II=1,NCCOM2
                IHARG(II)=IHBT(II)
                IHARG2(II)=IH2BT(II)
 6620         CONTINUE
            ENDIF
          ELSE
            ISHIFT=NCCOMM
            IF(NCCOMM.GT.0)
     1      CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                  IBUGG2,IERROR)
            ICOM=ICT
            ICOM2=IC2T
            IF(NCCOMM.GT.0)THEN
              DO6630II=1,NCCOMM
                IHARG(II)=IHT(II)
                IHARG2(II)=IH2T(II)
 6630         CONTINUE
            ENDIF
          ENDIF
          IF(IEMPTY.EQ.'YES'.AND.ISPMPT.EQ.'DEXC')THEN
            ISHIFT=NUMARG-2
            IF(ISHIFT.GT.0)THEN
              CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                    IBUGG2,IERROR)
            ENDIF
            ICOM='PLOT'
            ICOM2='    '
            IHARG(1)=IVARN1(IRES)
            IHARG2(1)=IVARN2(IRES)
            IHARG(2)=IVARN1(IFACT)
            IHARG2(2)=IVARN2(IFACT)
          ENDIF
          CALL MAINGR(ANOPL1,ANOPL2,NPLOTV,NPLOTP,NS,ICASPL,
     1                MAXNPP,ISEED,IBOOSS,
     1                IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1                IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1                BARHEF,BARWEF,
     1                IRHSTG,IHSTCW,IHSTEB,IHSTOU,IASHWT,
     1                ICAPSW,IFORSW,
     1                IGUIFL,IERRFA,
     1                IAND1,IAND2,ICONT,NUMHPP,NUMVPP,
CCCCC1                TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,MAXNXT,
     1                MAXNXT,
     1                ISUBRO,IFOUND,IERROR)
          IF(IEMPTY.EQ.'NO')THEN
            CALL DPSPM3(ICASPL,IOUNI5,
     1                  IROW,ICOL,
     1                  PX2LD2,NPLOTP,
     1                  IFORSW,
     1                  ISPX2L,ISPX2P,ISPX2S,
     1                  IHRIGH,IHRIG2,IHWUSE,
     1                  ISUBN1,ISUBN2,MESSAG,
     1                  IBUGG2,ISUBRO,IERROR)
          ENDIF
C
          ISHIFT=NARGT-NUMARG
          IF(ISHIFT.GT.0)THEN
            CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                IBUGG2,IERROR)
          ELSEIF(ISHIFT.LT.0)THEN
            ISHIFT=-ISHIFT
            CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                IBUGG2,IERROR)
          ENDIF
          IF(IERROR.EQ.'YES')GOTO6699
          ICOM='PLOT'
          ICOM2='    '
          IF(IRESP.EQ.0)THEN
            IHARG(1)=IVARN1(ICOL)
            IHARG2(1)=IVARN2(ICOL)
            IHARG(2)=IVARN1(ICOL)
            IHARG2(2)=IVARN2(ICOL)
          ELSE
            IHARG(1)=IVARN1(1)
            IHARG2(1)=IVARN2(1)
            IHARG(2)=IVARN1(ICOL)
            IHARG2(2)=IVARN2(ICOL)
            IHARG(3)=IVARN1(ICOL)
            IHARG2(3)=IVARN2(ICOL)
          ENDIF
          IF(ISPMPT.EQ.'DEXC')THEN
            IHARG(4)=IVARN1(NUMVAR+1)
            IHARG2(4)=IVARN2(NUMVAR+1)
          ENDIF
          GOTO6690
C
 6690     CONTINUE
          ICONT=IDCONT(1)
          NUMHPP=IDNHPP(1)
          IMPARG=2
          CALL DPGRAP(Y,X,X3D,D,N,NPLOTP,ICASPL,ICONT,NUMHPP,
     1                XMATN,YMATN,XMITN,YMITN,
     1                ISQUAR,
     1                IVGMSW,IHGMSW,
     1                IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,
     1                IVSTAR,IVSTOP,IFUNC,NUMCHF,IREPCH,
     1                YPLOT,XPLOT,X2PLOT,TAGPLO,
     1                IMPSW,IMPNR,IMPNC,IMPCO,IMPCO9,
     1                IMPARG,
     1                PMXMIN,PMXMAX,PMYMIN,PMYMAX,
     1                MAXCOL,
     1                DSIZE,DSYMB,DCOLOR,DFILL,
     1                ICAPSW,
     1                IBUGUG,IBUGU2,IBUGU3,IBUGU4,ISUBRO,
     1                IERROR)
 6699     CONTINUE
          IF(IERROR.EQ.'NO')IAND1=IAND2
          IF(IEMPTY.EQ.'YES')THEN
            DO6207I=1,MAXSUB
              ISUBSW(I)=ISU2SW(I)
 6207       CONTINUE
          ENDIF
          PX1LDS=PX1LD2
          GX1MIN=GX1MNS
          GX1MAX=GX1MXS
          GX2MIN=GX2MNS
          GX2MAX=GX2MXS
          GY1MIN=GY1MNS
          GY1MAX=GY1MXS
          GY2MIN=GY2MNS
          GY2MAX=GY2MXS
          IX1MIN=IX1MNS
          IX1MAX=IX1MXS
          IX2MIN=IX2MNS
          IX2MAX=IX2MXS
          IY1MIN=IY1MNS
          IY1MAX=IY1MXS
          IY2MIN=IY2MNS
          IY2MAX=IY2MXS
          PX1ZDS=PX1ZD2
          PX2ZDS=PX2ZD2
          PY1ZDS=PY1ZD2
          PY2ZDS=PY2ZD2
C
 6700   CONTINUE
 6600 CONTINUE
      GOTO8000
C
C               **************************************************
C               **   STEP 25--                                  **
C               **   PLOT THE CURRENT PLOT                      **
C               **************************************************
 7890     CONTINUE
          ICONT=IDCONT(1)
          NUMHPP=IDNHPP(1)
          IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'SPMA')THEN
            WRITE(ICOUT,7907)IMANUF,NUMDEV,IDMANU(1)
 7907       FORMAT('IMANUF,NUMDEV,IDMANU(1) = ',A4,I8,2X,A4)
            CALL DPWRST('XXX','BUG ')
          ENDIF
          IMPARG=2
          CALL DPGRAP(Y,X,X3D,D,N,NPLOTP,ICASPL,ICONT,NUMHPP,
     1                XMATN,YMATN,XMITN,YMITN,
     1                ISQUAR,
     1                IVGMSW,IHGMSW,
     1                IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,
     1                IVSTAR,IVSTOP,IFUNC,NUMCHF,IREPCH,
     1                YPLOT,XPLOT,X2PLOT,TAGPLO,
     1                IMPSW,IMPNR,IMPNC,IMPCO,IMPCO9,
     1                IMPARG,
     1                PMXMIN,PMXMAX,PMYMIN,PMYMAX,
     1                MAXCOL,
     1                DSIZE,DSYMB,DCOLOR,DFILL,
     1                ICAPSW,
     1                IBUGUG,IBUGU2,IBUGU3,IBUGU4,ISUBRO,
     1                IERROR)
          IF(IERROR.EQ.'NO')IAND1=IAND2
          IF(IERROR.EQ.'YES')GOTO7900
          PX1LDS=PX1LD2
          GX1MIN=GX1MNS
          GX1MAX=GX1MXS
          GX2MIN=GX2MNS
          GX2MAX=GX2MXS
          GY1MIN=GY1MNS
          GY1MAX=GY1MXS
          GY2MIN=GY2MNS
          GY2MAX=GY2MXS
          IX1MIN=IX1MNS
          IX1MAX=IX1MXS
          IX2MIN=IX2MNS
          IX2MAX=IX2MXS
          IY1MIN=IY1MNS
          IY1MAX=IY1MXS
          IY2MIN=IY2MNS
          IY2MAX=IY2MXS
          PX1ZDS=PX1ZD2
          PX2ZDS=PX2ZD2
          PY1ZDS=PY1ZD2
          PY2ZDS=PY2ZD2
C
 7900   CONTINUE
 7800 CONTINUE
      ISPMFR=ISPMFZ
      GOTO8000
C
C
C               **************************************************
C               **   STEP 28--                                  **
C               **   REINSTATE INITIAL SETTINGS                 **
C               **************************************************
C
 8000 CONTINUE
 2800 CONTINUE
C
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'4PLO')THEN
        ISTEPN='28'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,8807)IMANUF,NUMDEV,IDMANU(1)
 8807   FORMAT('IMANUF,NUMDEV,IDMANU(1) = ',A4,I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IFLAG=2
      CALL DPSPM5(IFLAG,IMPSW,IMPCO,IMPNR,IMPNC,IOUNI5,
     1            IBUGG2,ISUBRO,IFOUND,IERROR)
      ISPMTA=ISPMTZ
      ISPMFR=ISPMFZ
      ISPMPT=ISPMPZ
      ISPMLD=ISPMLZ
      ISPMLA=ISPML2
      ISPMXA=ISPMXZ
      ISPMYA=ISPMYZ
      ISPMDI=ISPMDZ
      ISPMST=ISPMZT
      ISPMS2=ISPMZ2
      ISPMS3=ISPMZ3
      ISPMS4=ISPMZ4
C
      IOPTN=2
      IDX=0
      IDY=0
      CALL DPSPM4(ICASPL,IOPTN,IDX,IDY,
     1            ISUBNU,
     1            ISUBSW,
     1            ASUBXL,ASUBXU,ASUBYL,ASUBYU,
     1            ISUBN9,
     1            ISUBSZ,
     1            ASBXL2,ASBXU2,ASBYL2,ASBYU2,
     1            PSPLSL,PSPLSU,PSPLSL,PSPLSU,
     1            IBUGG2,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IFEEDB=IFEED9
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG2.EQ.'ON' .OR. ISUBRO.EQ.'SPMA')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSPMA--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IFOUND,IERROR
 9012   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2
 9013   FORMAT('NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2 = ',3I8,3(2X,A4))
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSPM1(ICASPL,IVARN1,IVARN2,ICOLL,
     1                  IMPNR,IMPNC,IROW,ICOL,IRES,
     1                  IFACT,IPLOT,NPLOTS,NUMVAR,
     1                  ICHAP2,ILINP2,
     1                  GY1MNS,GY1MXS,GY2MNS,GY2MXS,
     1                  GX1MNS,GX1MXS,GX2MNS,GX2MXS,
     1                  IY1MNS,IY1MXS,IY2MNS,IY2MXS,
     1                  IX1MNS,IX1MXS,IX2MNS,IX2MXS,
     1                  IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1                  IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1                  PX1LD2,PX2LD2,
     1                  IY1LJ2,IY1LD2,PY1LD2,PY1LA2,
     1                  IX1LT2,IX2LT2,IY1LT2,IY2LT2,
     1                  NCX1L2,NCX2L2,NCY1L2,NCY2L2,
     1                  PSPXLL,PSPXUL,PSPYLL,PSPYUL,IXLIST,
     1                  ISPMLA,ISPMLD,ISPMPT,ISPMFR,ISPMXA,
     1                  ISPMYA,ISPMDI,
     1                  ISPMTD,PSPMTD,IVNMEX,
     1                  IBUGG2,ISUBRO)
C
C     PURPOSE--UTILTY ROUTINE FOR SCATTER PLOT MATRIX.  GENERATE
C              TIC MARKS, TIC MARK LABELS, AXIS LABELS.  ALSO
C              USED BY FACTOR AND CONDITIONING PLOTS.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--99/11
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--NOVEMBER 1999.
C     UPDATED       --JUNE       2002.  UPDATES FOR PARTIAL REGRESSION
C     UPDATED       --JUNE       2002.  UPDATES FOR PARTIAL RESIDUAL
C     UPDATED       --JUNE       2002.  UPDATES FOR PARTIAL LEVERAGE
C     UPDATED       --MAY        2007.  UPDATES FOR BINARY TABULATION
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES---------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOPC.INC'
      INCLUDE 'DPCOHK.INC'
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IBUGG2
C
      CHARACTER*4 ISUBRO
C
      CHARACTER*4 ISPMLA
      CHARACTER*4 ISPMLD
      CHARACTER*4 ISPMPT
      CHARACTER*4 ISPMFR
      CHARACTER*4 ISPMXA
      CHARACTER*4 ISPMYA
      CHARACTER*4 ISPMDI
      CHARACTER*4 ISPMTD
      CHARACTER*4 IVNMEX
C
      CHARACTER*105 IXT
      CHARACTER*52 IX2T
      CHARACTER*52 IY1T
      CHARACTER*4 IXLABT(52)
      CHARACTER*4 IXLAB2(52)
      CHARACTER*4 IYLABT(52)
C
      CHARACTER*16 ICHAP2(100)
      CHARACTER*4 ILINP2(100)
      CHARACTER*4 IY1MNS
      CHARACTER*4 IY1MXS
      CHARACTER*4 IY2MNS
      CHARACTER*4 IY2MXS
      CHARACTER*4 IY1LJ2
      CHARACTER*4 IY1LD2
      CHARACTER*4 IX1MNS
      CHARACTER*4 IX1MXS
      CHARACTER*4 IX2MNS
      CHARACTER*4 IX2MXS
      CHARACTER*4 IX1TSV
      CHARACTER*4 IX2TSV
      CHARACTER*4 IY1TSV
      CHARACTER*4 IY2TSV
      CHARACTER*4 IX1ZSV
      CHARACTER*4 IX2ZSV
      CHARACTER*4 IY1ZSV
      CHARACTER*4 IY2ZSV
      CHARACTER*4 IX1LT2(*)
      CHARACTER*4 IX2LT2(*)
      CHARACTER*4 IY1LT2(*)
      CHARACTER*4 IY2LT2(*)
C
      CHARACTER*4 IVARN1
      CHARACTER*4 IVARN2
C
      DIMENSION ICOLL(*)
      DIMENSION IVARN1(*)
      DIMENSION IVARN2(*)
      DIMENSION PSPXLL(*)
      DIMENSION PSPXUL(*)
      DIMENSION PSPYLL(*)
      DIMENSION PSPYUL(*)
C
C-----COMMON------------------------------------------------------
C
C-----COMMON VARIABLES (GENERAL)----------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-------------------------------------------------
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPM1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1011)
 1011   FORMAT('***** AT THE END       OF DPSPM1--')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C               ***************************************
C               **  STEP 1--                         **
C               **  TURN EVERYTHING OFF IF DATAPLOT  **
C               **  DETERMINES AXIS APPEARANCE AND   **
C               **  RESET DEFAULTS WHERE APPROPRIATE **
C               ***************************************
C
C
      DO10I=1,52
        IXLABT(I)=' '
        IXLAB2(I)=' '
        IYLABT(I)=' '
   10 CONTINUE
      DO15I=1,MAXCH
        IX1LTE(I)=IX1LT2(I)
        IX2LTE(I)=IX2LT2(I)
        IY1LTE(I)=IY1LT2(I)
        IY2LTE(I)=IY2LT2(I)
   15 CONTINUE
      IXT=' '
      IX2T=' '
      IY1T=' '
      NCX1LA=NCX1L2
      NCX2LA=NCX2L2
      NCY1LA=NCY1L2
      NCY2LA=NCY2L2
C
      IF(ISPMFR.EQ.'DEFA')THEN
        IX1TSW='OFF'
        IX1ZSW='OFF'
        IX2TSW='OFF'
        IX2ZSW='OFF'
        IY1TSW='OFF'
        IY1ZSW='OFF'
        IY2TSW='OFF'
        IY2ZSW='OFF'
        DO105I=1,MAXCH
          IX1LTE(I)='    '
          IX2LTE(I)='    '
          IY1LTE(I)='    '
          IY2LTE(I)='    '
  105   CONTINUE
        NCX1LA=0
        NCY1LA=0
        NCY2LA=0
        PX1LDS=PX1LD2
        PY1LDS=PY1LD2
        PY1LAN=PY1LA2
        IY1LJU=IY1LJ2
        IY1LDI=IY1LD2
      ELSE
        IX1TSW=IX1TSV
        IX1ZSW=IX1ZSV
        IX2TSW=IX2TSV
        IX2ZSW=IX2ZSV
        IY1TSW=IY1TSV
        IY1ZSW=IY1ZSV
        IY2TSW=IY2TSV
        IY2ZSW=IY2ZSV
      ENDIF
C
      DO110I=1,100
        ICHAPA(I)=ICHAP2(I)
        ILINPA(I)=ILINP2(I)
  110 CONTINUE
C
C               ***************************************
C               **  STEP 2--                         **
C               **  DETERMINE Y AXIS LIMITS (I.E.,   **
C               **  DEFAULT OR USER SPECIFIED)       **
C               ***************************************
C
      IF(IRES.GT.0)THEN
        YLOWL=PSPYLL(IRES)
        YUPPL=PSPYUL(IRES)
      ELSE
        YLOWL=CPUMIN
        YUPPL=CPUMIN
      ENDIF
      IF(IXLIST.GT.0)THEN
        XLOWL=PSPXLL(IXLIST)
        XUPPL=PSPXUL(IXLIST)
      ELSE
        XLOWL=CPUMIN
        XUPPL=CPUMIN
      ENDIF
      IF(YLOWL.NE.CPUMIN.AND.YUPPL.NE.CPUMIN)THEN
        GY1MIN=YLOWL
        GY1MAX=YUPPL
        GY2MIN=YLOWL
        GY2MAX=YUPPL
        IY1MIN='FIXE'
        IY1MAX='FIXE'
        IY2MIN='FIXE'
        IY2MAX='FIXE'
      ELSE
        IF(IY1MIN.NE.'FIXE')GY1MIN=GY1MNS
        IF(IY2MIN.NE.'FIXE')GY2MIN=GY2MNS
        IF(IY1MAX.NE.'FIXE')GY1MAX=GY1MXS
        IF(IY2MAX.NE.'FIXE')GY2MAX=GY2MXS
      ENDIF
C
C               ***************************************
C               **  STEP 3--                         **
C               **  DETERMINE X AXIS LIMITS (I.E.,   **
C               **  DEFAULT OR USER SPECIFIED)       **
C               ***************************************
C
      IF(XLOWL.NE.CPUMIN.AND.XUPPL.NE.CPUMIN)THEN
        GX1MIN=XLOWL
        GX1MAX=XUPPL
        GX2MIN=XLOWL
        GX2MAX=XUPPL
        IX1MIN='FIXE'
        IX1MAX='FIXE'
        IX2MIN='FIXE'
        IX2MAX='FIXE'
      ELSE
        IF(IX1MIN.NE.'FIXE')GX1MIN=GX1MNS
        IF(IX2MIN.NE.'FIXE')GX2MIN=GX2MNS
        IF(IX1MAX.NE.'FIXE')GX1MAX=GX1MXS
        IF(IX2MAX.NE.'FIXE')GX2MAX=GX2MXS
      ENDIF
C
C               ***************************************
C               **  STEP 4--                         **
C               **  DETERMINE TEXT FOR X AND Y AXIS  **
C               **  LABELS.  DO ONCE HERE TO SIMPLIFY**
C               **  CODE BELOW.                      **
C               ***************************************
C
      IF(ISPMLA.EQ.'OFF')GOTO9000
CCCCC IF(ISPMLA.EQ.'ROSE')GOTO9000
CCCCC IF(ISPMLA.EQ.'ROS2')GOTO9000
C
      IF(ISPMPT.EQ.'PLOT'.OR.ISPMPT.EQ.'QQSP'.OR.ISPMPT.EQ.'CROS')THEN
        IXT=' '
        NX1=-1
        IX1DS=1
        IX2T=' '
        NX2=0
        IX2DS=0
        IY1T=' '
        NY1=-1
      ELSEIF(ISPMPT.EQ.'BITA' .OR. ISPMPT.EQ.'BIPL')THEN
        IXT=' '
        NX1=0
        IX1DS=0
        IX2T=' '
        NX2=0
        IX2DS=0
        IY1T=' '
        NY1=0
      ELSEIF(ISPMPT.EQ.'PREG')THEN
        IXT=' '
        IXT='Res: '
        NX1=5
        NX1=NX1+1
        IXT(NX1:NX1+3)=IVARN1(IPLOT+1)(1:4)
        IXT(NX1+4:NX1+7)=IVARN2(IPLOT+1)(1:4)
        DO140I=NX1+7,NX1,-1
          NXTEMP=I
          IF(IXT(I:I).NE.'    ')GOTO145
  140   CONTINUE
  145   CONTINUE
        NX1=NXTEMP
        NX1=NX1+1
        NXTEMP=NX1+14
        IXT(NX1:NXTEMP)=' versus other X'
        NX1=NXTEMP
C
        IX1DS=1
        IX2T=' '
        NX2=0
        IX2DS=0
C
        NY1=5
        IY1T(1:NY1)='Res: '
        NY1=NY1+1
        IY1T(NY1:NY1+3)=IVARN1(IPLOT+1)(1:4)
        IY1T(NY1+4:NY1+7)=IVARN2(IPLOT+1)(1:4)
        DO130I=NY1+7,NY1,-1
          NYTEMP=I
          IF(IY1T(I:I).NE.'    ')GOTO135
  130   CONTINUE
  135   CONTINUE
        NY1=NYTEMP
        NY1=NY1+1
        NYTEMP=NY1+7
        IY1T(NY1:NYTEMP)=' Removed'
        NY1=NYTEMP
      ELSEIF(ISPMPT.EQ.'PLEV')THEN
        IXT=' '
        NX1=5
        IXT(1:NX1)='Index'
C
        IX1DS=1
        IX2T=' '
        NX2=0
        IX2DS=0
C
        IY1T=' '
        IY1T='Partial Leverage: '
        NY1=18
        NY1=NY1+1
        IY1T(NY1:NY1+3)=IVARN1(IPLOT+1)(1:4)
        IY1T(NY1+4:NY1+7)=IVARN2(IPLOT+1)(1:4)
        DO170I=NY1+7,NY1,-1
          NYTEMP=I
          IF(IY1T(I:I).NE.'    ')GOTO175
  170   CONTINUE
  175   CONTINUE
        NY1=NYTEMP
      ELSEIF(ISPMPT.EQ.'PRES'.OR.ISPMPT.EQ.'CCPR')THEN
        NX1=1
        IXT(NX1:NX1+3)=IVARN1(IPLOT+1)(1:4)
        IXT(NX1+4:NX1+7)=IVARN2(IPLOT+1)(1:4)
        DO150I=NX1+7,NX1,-1
          NXTEMP=I
          IF(IXT(I:I).NE.'    ')GOTO155
  150   CONTINUE
  155   CONTINUE
        NX1=NXTEMP
C
        IX1DS=1
        IX2T=' '
        NX2=0
        IX2DS=0
C
        IY1T=' '
        IY1T='Residuals + A'
        NY1=13
        IF(IPLOT.LE.9)THEN
          NY1=NY1+1
          WRITE(IY1T(NY1:NY1),'(I1)')IPLOT
        ELSE
          NY1=NY1+1
          NYTEMP=NY1+1
          WRITE(IY1T(NY1:NYTEMP),'(I2)')IPLOT
          NY1=NYTEMP
        ENDIF
        NY1=NY1+1
        IY1T(NY1:NY1)='*'
        NY1=NY1+1
        IY1T(NY1:NY1+3)=IVARN1(IPLOT+1)(1:4)
        IY1T(NY1+4:NY1+7)=IVARN2(IPLOT+1)(1:4)
        DO160I=NY1+7,NY1,-1
          NYTEMP=I
          IF(IY1T(I:I).NE.'    ')GOTO165
  160   CONTINUE
  165   CONTINUE
        NY1=NYTEMP
      ELSEIF(ISPMPT.EQ.'DEXS'.OR.ISPMPT.EQ.'DEXI'.OR.
     1       ISPMPT.EQ.'CRO2')THEN
        IXT=' '
        NX1=-2
        IX1DS=-1
        IX2T=' '
        NX2=0
        IX2DS=0
        IY1T=' '
        NY1=-1
      ELSEIF(ISPMPT.EQ.'DEXC')THEN
        IXT=' '
        NX1=-2
        IX1DS=-1
        IX2T=' '
        NX2=0
        IX2DS=0
        IY1T=' '
        NY1=0
      ELSEIF(ISPMPT.EQ.'BIHI')THEN
        IXT=' '
        NX1=-1
        IX1DS=-1
        IX2T=' '
        NX2=-1
        IX2DS=-2
        IY1T='Frequency'
        NY1=9
      ELSEIF(ISPMPT.EQ.'CCOR')THEN
        IXT='Lag'
        NX1=3
        IX1DS=1
        IX2T=' '
        NX2=-2
        IX2DS=-1
        IY1T='Correlation'
        NY1=11
      ELSEIF(ISPMPT.EQ.'CSPE')THEN
        IXT='Frequency'
        NX1=9
        IX1DS=1
        IX2T=' '
        NX2=-2
        IX2DS=-1
        IY1T='Power'
        NY1=5
      ELSEIF(ISPMPT.EQ.'CLAG')THEN
        IXT='I+1'
        NX1=3
        IX1DS=1
        IX2T=' '
        NX2=-2
        IX2DS=-1
        IY1T='I'
        NY1=1
      ELSEIF(ISPMPT.EQ.'FPLO'.OR.ISPMPT.EQ.'QQFP'.OR.
     1       ISPMPT.EQ.'STAT')THEN
        IXT=' '
        NX1=-1
        IX1DS=-1
        IX2T=' '
        NX2=0
        IX2DS=0
        IY1T=' '
        NY1=-1
      ELSEIF(ISPMPT.EQ.'BOXC')THEN
        IXT='Alpha'
        NX1=5
        IX1DS=1
        IX2T=' '
        NX2=-1
        IX2DS=-1
        IY1T='Correlation'
        NY1=11
      ELSEIF(ISPMPT.EQ.'CBXC')THEN
        IXT='Alpha'
        NX1=5
        IX1DS=1
        IX2T=' '
        NX2=-2
        IX2DS=-1
        IY1T='Correlation'
        NY1=11
      ELSEIF(ISPMPT.EQ.'HIST')THEN
        IXT=' '
        NX1=-1
        IX1DS=-1
        IX2T=' '
        NX2=0
        IX2DS=-1
        IY1T='Frequency'
        NY1=9
      ELSEIF(ISPMPT.EQ.'CDEN' .OR. ISPMPT.EQ.'KERN')THEN
        IXT=' '
        NX1=-1
        IX1DS=-1
        IX2T=' '
        NX2=0
        IX2DS=-1
        IY1T='Density'
        NY1=7
      ELSEIF(ISPMPT.EQ.'RUNS')THEN
        IXT='Sequence'
        NX1=8
        IX1DS=1
        IX2T=' '
        NX2=-1
        IX2DS=-1
        IY1T=' '
        NY1=0
      ELSEIF(ISPMPT.EQ.'LAG ')THEN
        IXT='I+1'
        NX1=3
        IX1DS=1
        IX2T=' '
        NX2=0
        IX2DS=-1
        IY1T='I'
        NY1=1
      ELSEIF(ISPMPT.EQ.'PERC')THEN
        IXT='Percentile'
        NX1=10
        IX1DS=1
        IX2T=' '
        NX2=-1
        IX2DS=-1
        IY1T=' '
        NY1=0
      ELSEIF(ISPMPT.EQ.'CPER')THEN
        IXT='Percentile'
        NX1=10
        IX1DS=1
        IX2T=' '
        NX2=0
        IX2DS=-1
        IY1T=' '
        NY1=-1
      ELSEIF(ISPMPT.EQ.'AUTO')THEN
        IXT='Lag'
        NX1=3
        IX1DS=1
        IX2T=' '
        NX2=-1
        IX2DS=-1
        IY1T='Frequency'
        NY1=9
      ELSEIF(ISPMPT.EQ.'SPEC')THEN
        IXT='Frequency'
        NX1=9
        IX1DS=1
        IX2T=' '
        NX2=-1
        IX2DS=-1
        IY1T='Power'
        NY1=5
      ELSEIF(ISPMPT.EQ.'PROB')THEN
        IXT='Theoretical'
        NX1=11
        IX1DS=1
        IX2T=' '
        NX2=-1
        IX2DS=-1
        IY1T='Data'
        NY1=4
      ELSEIF(ISPMPT.EQ.'PPCC')THEN
        IXT='Parameter'
        NX1=9
        IX1DS=1
        IX2T=' '
        NX2=-1
        IX2DS=-1
        IY1T='Correlation'
        NY1=11
      ELSEIF(ISPMPT.EQ.'ROSE' .OR. ISPMPT.EQ.'ROS2')THEN
        IXT=' '
        NX1=1
        IX1DS=1
        IX2T=' '
        NX2=1
        IX2DS=-1
        IY1T=' '
        NY1=1
      ELSE
        IXT=' '
        NX1=-1
        IX1DS=1
        IX2T=' '
        NX2=0
        IX2DS=0
        IY1T=' '
        NY1=1
      ENDIF
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPM1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1012)
 1012   FORMAT('***** FINISH SECTION 1--')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C  X1LABEL
C
C  1) IF NX1 > 0, USE USER SPECIFIED LABEL IF ALREADY DEFINED,
C     OTHERWISE, DEFAULT TO A DATAPLOT SPECIFIED LABEL.
C  2) IF NX1 = 0, USE USER SPECIFIED LABEL IF ALREADY DEFINED,
C     BUT NO DEFAULT PROVIDED.
C  3) IF NX1 = -1, USE VARIABLE NAME (AND SUBSTITUTE VARIABLE
C     LABEL IF PROVIDED).
C  4) IF NX1 = -2, USE: VARIABLE1 * VARIABLE2 (AND SUBSTITUTE
C     VARIABLE LABEL IF PROVIDED).
C
      IF(ICOL.EQ.0)THEN
        NCXLA=0
        GOTO299
      ENDIF
C
      IF(NX1.GE.0)THEN
        IF(NCX1L2.GT.0)THEN
          DO210I=1,NCX1L2
            IXLABT(I)=IX1LT2(I)
  210     CONTINUE
          NCXLA=NCX1L2
        ELSE
          NCXLA=0
          IF(NX1.GT.0)THEN
            DO220I=1,NX1
              IXLABT(I)(1:1)=IXT(I:I)
  220       CONTINUE
            NCXLA=NX1
          ENDIF
        ENDIF
      ELSEIF(NX1.LT.0)THEN
        ITEMP=IFACT
        IF(NX1.EQ.-2 .OR. NX2.EQ.-2)ITEMP=IRES
        IF(ISPMPT.EQ.'BIHI')ITEMP=IRES
        ICOLID=ICOLL(ITEMP)
        IF(IVARLB(ICOLID).EQ.' '.OR.IVNMEX.EQ.'OFF')THEN
          DO230I=1,4
            IXLABT(I)=IVARN1(ITEMP)(I:I)
            IXLABT(I+4)=IVARN2(ITEMP)(I:I)
  230     CONTINUE
          NCXLA=8
          DO240I=8,1,-1
            NCXLA=I
            IF(IXLABT(I).NE.'    ')GOTO245
  240     CONTINUE
  245     CONTINUE
        ELSE
          ILAST=40
          DO250I=40,1,-1
            IF(IVARLB(ICOLID)(I:I).NE.' ')THEN
              ILAST=I
              GOTO259
            ENDIF
  250     CONTINUE
  259     CONTINUE
          DO270I=1,ILAST
            IXLABT(I)(1:1)=IVARLB(ICOLID)(I:I)
  270     CONTINUE
          NCXLA=ILAST
        ENDIF
        IF(NX1.EQ.-1 .OR. IRES.EQ.IFACT)GOTO299
        NCXLA=NCXLA+1
        IXLABT(NCXLA)='*'
        ITEMP=IFACT
        ICOLID=ICOLL(ITEMP)
        IF(IVARLB(ICOLID).EQ.' ')THEN
          DO280I=1,4
            IXLABT(NCXLA+I)=IVARN1(ITEMP)(I:I)
            IXLABT(NCXLA+I+4)=IVARN2(ITEMP)(I:I)
  280     CONTINUE
          ILAST=NCXLA+8
          DO285I=ILAST,1,-1
            NCXLA=I
            IF(IXLABT(I).NE.'    ')GOTO288
  285     CONTINUE
  288     CONTINUE
        ELSE
          ILAST=40
          DO290I=40,1,-1
            IF(IVARLB(ICOLID)(I:I).NE.' ')THEN
              ILAST=I
              GOTO293
            ENDIF
  290     CONTINUE
  293     CONTINUE
          DO295I=1,ILAST
            NCXLA=NCXLA+1
            IXLABT(NCXLA)(1:1)=IVARLB(ICOLID)(I:I)
  295     CONTINUE
        ENDIF
      ENDIF
  299 CONTINUE
C
C  X2LABEL
C
C  1) IF NX2 > 0, USE USER SPECIFIED LABEL IF ALREADY DEFINED,
C     OTHERWISE, DEFAULT TO A DATAPLOT SPECIFIED LABEL.
C  2) IF NX2 = 0, USE USER SPECIFIED LABEL IF ALREADY DEFINED,
C     BUT NO DEFAULT PROVIDED.
C  3) IF NX2 = -1, USE VARIABLE NAME (AND SUBSTITUTE VARIABLE
C     LABEL IF PROVIDED).
C  4) IF NX2 = -2, USE: VARIABLE1 * VARIABLE2 (AND SUBSTITUTE
C     VARIABLE LABEL IF PROVIDED).
C
      IF(ICOL.EQ.0)THEN
        NCXLA2=0
        GOTO399
      ENDIF
C
      IF((NX1.EQ.-1.AND.NX2.EQ.-1).AND.IRES.EQ.IFACT)THEN
         NCXLA2=0
         GOTO399
      ENDIF
      IF(NX2.GE.0)THEN
        IF(NCX2L2.GT.0)THEN
          DO310I=1,NCX2L2
            IXLAB2(I)=IX2LT2(I)
  310     CONTINUE
          NCXLA2=NCX2L2
        ELSE
          NCXLA2=0
          IF(NX2.GT.0)THEN
            DO320I=1,NX2
              IXLAB2(I)(1:1)=IX2T(I:I)
  320       CONTINUE
            NCXLA2=NX2
          ENDIF
        ENDIF
      ELSEIF(NX2.LT.0)THEN
        ITEMP=IFACT
        IF(NX2.EQ.-2)ITEMP=IRES
        IF(ISPMPT.EQ.'BIHI')ITEMP=IFACT
        ICOLID=ICOLL(ITEMP)
        IF(IVARLB(ICOLID).EQ.' '.OR.IVNMEX.EQ.'OFF')THEN
          DO330I=1,4
            IXLAB2(I)=IVARN1(ITEMP)(I:I)
            IXLAB2(I+4)=IVARN2(ITEMP)(I:I)
  330     CONTINUE
          NCXLA2=8
          DO340I=8,1,-1
            NCXLA2=I
            IF(IXLAB2(I).NE.'    ')GOTO345
  340     CONTINUE
  345     CONTINUE
        ELSE
          ILAST=40
          DO350I=40,1,-1
            IF(IVARLB(ICOLID)(I:I).NE.' ')THEN
              ILAST=I
              GOTO359
            ENDIF
  350     CONTINUE
  359     CONTINUE
          DO370I=1,ILAST
            IXLAB2(I)(1:1)=IVARLB(ICOLID)(I:I)
  370     CONTINUE
          NCXLA2=ILAST
        ENDIF
        IF(NX2.EQ.-1.OR.IRES.EQ.IFACT)GOTO399
        NCXLA2=NCXLA2+1
        IXLAB2(NCXLA2)='*'
        ITEMP=IFACT
        ICOLID=ICOLL(ITEMP)
        IF(IVARLB(ICOLID).EQ.' ')THEN
          DO380I=1,4
            IXLAB2(NCXLA2+I)=IVARN1(ITEMP)(I:I)
            IXLAB2(NCXLA2+I+4)=IVARN2(ITEMP)(I:I)
  380     CONTINUE
          ILAST=NCXLA2+8
          DO385I=ILAST,1,-1
            NCXLA2=I
            IF(IXLAB2(I).NE.'    ')GOTO388
  385     CONTINUE
  388     CONTINUE
        ELSE
          ILAST=40
          DO390I=40,1,-1
            IF(IVARLB(ICOLID)(I:I).NE.' ')THEN
              ILAST=I
              GOTO393
            ENDIF
  390     CONTINUE
  393     CONTINUE
          DO395I=1,ILAST
            NCXLA2=NCXLA2+1
            IXLAB2(NCXLA2)(1:1)=IVARLB(ICOLID)(I:I)
  395     CONTINUE
        ENDIF
      ENDIF
  399 CONTINUE
C
C  Y1LABEL
C
C  1) IF NY1 > 0, USE USER SPECIFIED LABEL IF ALREADY DEFINED,
C     OTHERWISE, DEFAULT TO A DATAPLOT SPECIFIED LABEL.
C  2) IF NY1 = 0, USE USER SPECIFIED LABEL IF ALREADY DEFINED,
C     BUT NO DEFAULT PROVIDED.
C  3) IF NY1 = -1, USE VARIABLE NAME (AND SUBSTITUTE VARIABLE
C     LABEL IF PROVIDED).
C
      IF(ISPMLA.EQ.'BOX'.AND.IROW.EQ.IMPNR)THEN
        NCYLA=0
        GOTO599
      ENDIF
C
      IF(NY1.GE.0)THEN
        IF(NCY1L2.GT.0)THEN
          DO510I=1,NCY1L2
            IYLABT(I)=IY1LT2(I)
  510     CONTINUE
          NCYLA=NCY1L2
        ELSE
          NCYLA=0
          IF(NY1.GT.0)THEN
            DO520I=1,NY1
              IYLABT(I)(1:1)=IY1T(I:I)
  520       CONTINUE
            NCYLA=NY1
          ENDIF
        ENDIF
      ELSEIF(NY1.LT.0)THEN
        ITEMP=IRES
        IF(ISPMPT.EQ.'DEXI'.OR.ISPMPT.EQ.'DEXS')ITEMP=1
        ICOLID=ICOLL(ITEMP)
        IF(IVARLB(ICOLID).EQ.' '.OR.IVNMEX.EQ.'OFF')THEN
          DO530I=1,4
            IYLABT(I)=IVARN1(ITEMP)(I:I)
            IYLABT(I+4)=IVARN2(ITEMP)(I:I)
  530     CONTINUE
          NCYLA=8
          DO540I=8,1,-1
            NCYLA=I
            IF(IYLABT(I).NE.'    ')GOTO545
  540     CONTINUE
  545     CONTINUE
        ELSE
          ILAST=40
          DO560I=40,1,-1
            IF(IVARLB(ICOLID)(I:I).NE.' ')THEN
              ILAST=I
              GOTO569
            ENDIF
  560     CONTINUE
  569     CONTINUE
          DO570I=1,ILAST
            IYLABT(I)(1:1)=IVARLB(ICOLID)(I:I)
  570     CONTINUE
          NCYLA=ILAST
        ENDIF
      ENDIF
  599 CONTINUE
C
C               ***************************************
C               **  STEP 5--                         **
C               **  USER SPECIFIES AXIS ATTRIBUTES,  **
C               **  BUT DATAPLOT MAY SUBSTITUTE      **
C               **  VARIABLE NAME (OR LABEL) FOR     **
C               **  X1LABEL AND Y1LABEL              **
C               ***************************************
C
 1000 CONTINUE
      IF(ISPMFR.EQ.'USER')THEN
        NCX1LA=NCXLA
        IF(NCX1LA.LE.0)GOTO1119
        DO1110I=1,NCX1LA
          IX1LTE(I)=IXLABT(I)
 1110   CONTINUE
 1119   CONTINUE
        IF(IX1DS.LT.0)PX1LDS=-((PYMAX-PYMIN)-PX1LD2)
        NCY1LA=NCYLA
        IF(NCY1LA.LE.0)GOTO1129
        DO1120I=1,NCY1LA
          IY1LTE(I)=IYLABT(I)
 1120   CONTINUE
 1129   CONTINUE
        NCX2LA=NCXLA2
        IF(NCX2LA.LE.0)GOTO1139
        DO1130I=1,NCX2LA
          IX2LTE(I)=IXLAB2(I)
 1130   CONTINUE
        PX2LDS=-((PYMAX-PYMIN)-PX2LD2)
        IF(IX2DS.EQ.-2)PX2LDS=-PX2LD2
 1139   CONTINUE
C
C               *******************************************
C               **  STEP 6--                             **
C               **  DATAPLOT SPECIFIES AXIS ATTRIBUTES   **
C               *******************************************
C
      ELSEIF(ISPMFR.EQ.'DEFA')THEN
C
        ITEMP1=MOD(ICOL,2)
        ITEMP2=MOD(IROW,2)
        IROWL=IMPNR
        IF(ISPMLA.EQ.'BOX'.AND.ICASPL.EQ.'SPMA')IROWL=NUMVAR+1
        ICOLF=1
        IF(ISPMLA.EQ.'BOX')ICOLF=0
C
C  IX1DS < 0 OR IX2DS < 0 SPECIFIES THAT THIS LABEL IS DRAWN
C  ON ALL PLOTS (AND DISPLACEMENT IS DISTANCE FROM TOP FRAME)
C
        IF(IX1DS.LT.0.AND.ISPMLA.NE.'BOX')THEN
          NCX1LA=NCXLA
          IF(NCX1LA.GT.0)THEN
            DO1505I=1,NCX1LA
              IX1LTE(I)=IXLABT(I)
 1505       CONTINUE
          ENDIF
          PX1LDS=-((PYMAX-PYMIN)-PX1LD2)
        ENDIF
        IF(IX2DS.LT.0.AND.ISPMLA.NE.'BOX')THEN
          NCX2LA=NCXLA2
          IF(NCX2LA.GT.0)THEN
            DO1508I=1,NCX2LA
              IX2LTE(I)=IXLAB2(I)
 1508       CONTINUE
          ENDIF
          PX2LDS=-((PYMAX-PYMIN)-PX2LD2)
          IF(IX2DS.EQ.-2)PX2LDS=-PX1LD2
        ENDIF
C
        IF(ISPMXA.EQ.'YON')GOTO1499
        IF(ISPMXA.EQ.'ALTE')THEN
          IF((IROW.EQ.IROWL.AND.ITEMP1.EQ.1).OR.
     1       (ISPMLD.EQ.'OFF'.AND.ITEMP1.EQ.1.AND.IROW.EQ.ICOL).OR.
     1       (IROW.EQ.IMPNR-1.AND.ICOL.EQ.IMPNC.AND.ITEMP.EQ.1.AND.
     1       NPLOTS.LT.IMPNR*IMPNC).OR.
     1       (ISPMLA.EQ.'BOX'.AND.IROW.EQ.IROWL)
     1       )THEN
            IF(ISPMLA.EQ.'BOX'.AND.ICOL.EQ.0)GOTO1519
            IF(ISPMLA.EQ.'BOX'.AND.ITEMP1.EQ.0)GOTO1512
            IF(ISPMLA.EQ.'YON')THEN
              IX1TSW='OFF'
              IX1ZSW='OFF'
            ELSE
              IX1TSW='ON'
              IX1ZSW='ON'
            ENDIF
            IX2TSW='OFF'
            IX2ZSW='OFF'
 1512       CONTINUE
            IFLAG=0
            IF(ICASPL.EQ.'SPMA'.AND.ISPMPT.EQ.'PLOT'.AND.
     1        ISPMDI.EQ.'BLAN')IFLAG=1
            IF(IX1DS.LT.0.AND.ISPMLA.NE.'BOX')IFLAG=1
            IFLAG2=0
            IF(IX2DS.LT.0.AND.ISPMLA.NE.'BOX')IFLAG2=1
            IF(IFLAG.EQ.0)THEN
              NCX1LA=NCXLA
              IF(NCX1LA.GT.0)THEN
                DO1510I=1,NCX1LA
                IX1LTE(I)=IXLABT(I)
 1510           CONTINUE
              ENDIF
            ENDIF
            IF(IFLAG2.EQ.0)THEN
              NCX2LA=NCXLA2
              IF(NCX2LA.GT.0)THEN
                DO1516I=1,NCX2LA
                IX2LTE(I)=IXLAB2(I)
 1516           CONTINUE
              ENDIF
            ENDIF
 1519       CONTINUE
            IF(ISPMLA.EQ.'BOX')PX1LDS=-((PYMAX-PYMIN)/2.0)
          ENDIF
C
          IF(IROW.EQ.1.AND.ITEMP1.EQ.0)THEN
            IF(ISPMLA.EQ.'BOX'.AND.ICOL.EQ.0)GOTO1529
            IX1TSW='OFF'
            IX1ZSW='OFF'
            IF(ISPMLA.EQ.'YON')THEN
              IX2TSW='OFF'
              IX2ZSW='OFF'
            ELSE
              IX2TSW='ON'
              IX2ZSW='ON'
            ENDIF
            IFLAG=0
            IF(ISPMLA.EQ.'BOX')IFLAG=1
            IF(ICASPL.EQ.'SPMA'.AND.ISPMPT.EQ.'PLOT'.AND.
     1        ISPMDI.EQ.'BLAN')IFLAG=1
            IF(IX1DS.LT.0)IFLAG=1
            IFLAG2=0
            IF(IX2DS.LT.0)IFLAG2=1
            IF(IFLAG.EQ.0)THEN
              NCX1LA=NCXLA
              IF(NCX1LA.GT.0)THEN
                DO1520I=1,NCX1LA
                IX1LTE(I)=IXLABT(I)
 1520           CONTINUE
              ENDIF
            ENDIF
            IF(IFLAG2.EQ.0)THEN
              NCX2LA=NCXLA2
              IF(NCX2LA.GT.0)THEN
                DO1526I=1,NCX2LA
                IX2LTE(I)=IXLAB2(I)
 1526           CONTINUE
              ENDIF
            ENDIF
 1529       CONTINUE
            IF(IX1DS.GT.0)PX1LDS=-((PYMAX-PYMIN)+PX1LD2)
            IF(ISPMLA.EQ.'BOX')PX1LDS=-((PYMAX-PYMIN)/2.0)
          ENDIF
        ELSEIF(ISPMXA.EQ.'BOTT')THEN
          IF(IROW.EQ.IROWL.OR.(ISPMLD.EQ.'OFF'.AND.IROW.EQ.ICOL))THEN
            IF(ISPMLA.EQ.'BOX'.AND.ICOL.EQ.0)GOTO1619
            IF(ISPMLA.EQ.'YON')THEN
              IX1TSW='OFF'
              IX1ZSW='OFF'
            ELSE
              IX1TSW='ON'
              IX1ZSW='ON'
            ENDIF
            IF(ISPMTD.EQ.'STAG'.AND.ITEMP1.EQ.0)PX1ZDS=PSPMTD
            IX2TSW='OFF'
            IX2ZSW='OFF'
            IFLAG=0
            IF(ICASPL.EQ.'SPMA'.AND.ISPMPT.EQ.'PLOT'.AND.
     1        ISPMDI.EQ.'BLAN')IFLAG=1
            IF(IX1DS.LT.0.AND.ISPMLA.NE.'BOX')IFLAG=1
            IFLAG2=0
            IF(IX2DS.LT.0.AND.ISPMLA.NE.'BOX')IFLAG2=1
            IF(IFLAG.EQ.0)THEN
              NCX1LA=NCXLA
              IF(NCX1LA.GT.0)THEN
                DO1610I=1,NCX1LA
                IX1LTE(I)=IXLABT(I)
 1610           CONTINUE
              ENDIF
            ENDIF
            IF(IFLAG2.EQ.0)THEN
              NCX2LA=NCXLA2
              IF(NCX2LA.GT.0)THEN
                DO1616I=1,NCX2LA
                IX2LTE(I)=IXLAB2(I)
 1616           CONTINUE
              ENDIF
            ENDIF
 1619       CONTINUE
            IF(ISPMLA.EQ.'BOX')PX1LDS=-((PYMAX-PYMIN)/2.0)
          ENDIF
        ELSEIF(ISPMXA.EQ.'TOP')THEN
          IF(IROW.EQ.1)THEN
            IF(ISPMLA.EQ.'BOX'.AND.ICOL.EQ.0)GOTO1719
            IX1TSW='OFF'
            IX1ZSW='OFF'
            IF(ISPMLA.EQ.'YON')THEN
              IX2TSW='OFF'
              IX2ZSW='OFF'
            ELSE
              IX2TSW='ON'
              IX2ZSW='ON'
            ENDIF
            IF(ISPMTD.EQ.'STAG'.AND.ITEMP1.EQ.0)PX2ZDS=PSPMTD
            IFLAG=0
            IF(ICASPL.EQ.'SPMA'.AND.ISPMPT.EQ.'PLOT'.AND.
     1        ISPMDI.EQ.'BLAN')IFLAG=1
            IF(IX1DS.LT.0)IFLAG=1
            IF(ISPMLA.EQ.'BOX')GOTO1719
            IFLAG2=0
            IF(IX2DS.LT.0)IFLAG2=1
            IF(IFLAG.EQ.0)THEN
              NCX1LA=NCXLA
              IF(NCX1LA.GT.0)THEN
                DO1710I=1,NCX1LA
                IX1LTE(I)=IXLABT(I)
 1710           CONTINUE
              ENDIF
            ENDIF
            IF(IFLAG2.EQ.0)THEN
              NCX2LA=NCXLA2
              IF(NCX2LA.GT.0)THEN
                DO1716I=1,NCX2LA
                IX2LTE(I)=IXLAB2(I)
 1716           CONTINUE
              ENDIF
            ENDIF
 1719       CONTINUE
            PX1LDS=-(100.0+PX1LD2)
          ENDIF
C
          IF(ISPMLA.EQ.'BOX'.AND.IROW.EQ.IROWL.AND.ICOL.GT.0)THEN
            IFLAG=0
            IF(ICASPL.EQ.'SPMA'.AND.ISPMPT.EQ.'PLOT'.AND.
     1        ISPMDI.EQ.'BLAN')IFLAG=1
            IF(IX1DS.LT.0.AND.ISPMLA.NE.'BOX')IFLAG=1
            IFLAG2=0
            IF(IX2DS.LT.0.AND.ISPMLA.NE.'BOX')IFLAG2=1
            IF(IFLAG.EQ.0)THEN
              NCX1LA=NCXLA
              IF(NCX1LA.GT.0)THEN
                DO1720I=1,NCX1LA
                IX1LTE(I)=IXLABT(I)
 1720           CONTINUE
              ENDIF
            ENDIF
            PX1LDS=-(100.0+PX1LD2)
          ENDIF
        ENDIF
C
 1499   CONTINUE
        IF(ISPMYA.EQ.'OFF')GOTO1699
        IF(ISPMYA.EQ.'ALTE')THEN
          IF((ICOL.EQ.IMPNC.AND.ITEMP2.EQ.0).OR.
     1       (ISPMLA.EQ.'BOX'.AND.ICOL.EQ.IMPNC-1.AND.ITEMP2.EQ.0).OR.
     1       (IPLOT.EQ.NPLOTS.AND.ITEMP2.EQ.0))THEN
            IY1TSW='OFF'
            IY1ZSW='OFF'
            IF(ISPMLA.EQ.'XON')THEN
              IY2TSW='OFF'
              IY2ZSW='OFF'
            ELSE
              IY2TSW='ON'
              IY2ZSW='ON'
            ENDIF
            IFLAG=0
            IF(ICASPL.EQ.'SPMA'.AND.ISPMPT.EQ.'PLOT'.AND.
     1        ISPMDI.EQ.'BLAN')IFLAG=1
            IF(ISPMLA.EQ.'BOX')IFLAG=1
            IF(IFLAG.EQ.0)THEN
              NCY2LA=NCYLA
              IF(NCY2LA.LE.0)GOTO1539
              DO1530I=1,NCY2LA
                IY2LTE(I)=IYLABT(I)
 1530         CONTINUE
 1539         CONTINUE
            ENDIF
          ENDIF
C
          IF(ICOL.EQ.ICOLF.AND.ITEMP2.EQ.1.OR.
     1      (ISPMLA.EQ.'BOX'.AND.ICOL.EQ.ICOLF).OR.
     1      (ISPMLD.EQ.'OFF'.AND.ITEMP2.EQ.1.AND.IROW.EQ.ICOL))THEN
            IF(ISPMLA.EQ.'BOX'.AND.IROW.EQ.IROWL)GOTO1549
            IF(ISPMLA.EQ.'BOX'.AND.ITEMP2.EQ.0)GOTO1542
            IF(ISPMLA.EQ.'XON')THEN
              IY1TSW='OFF'
              IY1ZSW='OFF'
            ELSE
              IY1TSW='ON'
              IY1ZSW='ON'
            ENDIF
            IY2TSW='OFF'
            IY2ZSW='OFF'
 1542       CONTINUE
            IFLAG=0
            IF(ICASPL.EQ.'SPMA'.AND.ISPMPT.EQ.'PLOT'.AND.
     1        ISPMDI.EQ.'BLAN')IFLAG=1
            IF(IFLAG.EQ.0)THEN
              NCY1LA=NCYLA
              IF(NCY1LA.LE.0)GOTO1549
              DO1540I=1,NCY1LA
                IY1LTE(I)=IYLABT(I)
 1540         CONTINUE
            ENDIF
            IF(ISPMLA.EQ.'BOX')THEN
              IY1LJU='CENT'
              PY1LDS=-((PXMAX-PXMIN)/2.0)
              PY1LAN=0.0
              IY1LDI='HORI'
            ENDIF
 1549       CONTINUE
          ENDIF
        ELSEIF(ISPMYA.EQ.'LEFT')THEN
          IF(ICOL.EQ.ICOLF.OR.(ISPMLD.EQ.'OFF'.AND.IROW.EQ.ICOL))THEN
            IF(ISPMLA.EQ.'BOX'.AND.IROW.EQ.IROWL)GOTO1649
            IF(ISPMLA.EQ.'XON')THEN
              IY1TSW='OFF'
              IY1ZSW='OFF'
            ELSE
              IY1TSW='ON'
              IY1ZSW='ON'
            ENDIF
            IF(ISPMTD.EQ.'STAG'.AND.ITEMP2.EQ.0)PY1ZDS=PSPMTD
            IY2TSW='OFF'
            IY2ZSW='OFF'
            IFLAG=0
            IF(ICASPL.EQ.'SPMA'.AND.ISPMPT.EQ.'PLOT'.AND.
     1        ISPMDI.EQ.'BLAN')IFLAG=1
            IF(IFLAG.EQ.0)THEN
              NCY1LA=NCYLA
              IF(NCY1LA.LE.0)GOTO1649
              DO1640I=1,NCY1LA
                IY1LTE(I)=IYLABT(I)
 1640         CONTINUE
            ENDIF
 1649       CONTINUE
            IF(ISPMLA.EQ.'BOX')THEN
              IY1LJU='CENT'
              PY1LDS=-((PXMAX-PXMIN)/2.0)
              PY1LAN=0.0
              IY1LDI='HORI'
            ENDIF
          ENDIF
        ELSEIF(ISPMYA.EQ.'RIGH')THEN
          IF(ICOL.EQ.IMPNC)THEN
            IF(ISPMLA.EQ.'BOX'.AND.IROW.EQ.IROWL)GOTO1839
            IY1TSW='OFF'
            IY1ZSW='OFF'
            IF(ISPMLA.EQ.'XON')THEN
              IY2TSW='OFF'
              IY2ZSW='OFF'
            ELSE
              IY2TSW='ON'
              IY2ZSW='ON'
            ENDIF
            IF(ISPMTD.EQ.'STAG'.AND.ITEMP2.EQ.0)PY2ZDS=PSPMTD
            IFLAG=0
            IF(ICASPL.EQ.'SPMA'.AND.ISPMPT.EQ.'PLOT'.AND.
     1        ISPMDI.EQ.'BLAN')IFLAG=1
            IF(ISPMLA.EQ.'BOX')IFLAG=1
            IF(IFLAG.EQ.0)THEN
              NCY2LA=NCYLA
              IF(NCY2LA.LE.0)GOTO1839
              DO1830I=1,NCY2LA
                IY2LTE(I)=IYLABT(I)
 1830         CONTINUE
            ENDIF
 1839       CONTINUE
          ENDIF
C
          IF(ISPMLA.EQ.'BOX'.AND.ICOL.EQ.ICOLF.AND.IROW.LT.IROWL)THEN
            IFLAG=0
            IF(ICASPL.EQ.'SPMA'.AND.ISPMPT.EQ.'PLOT'.AND.
     1        ISPMDI.EQ.'BLAN')IFLAG=1
            IF(IFLAG.EQ.0)THEN
              NCY1LA=NCYLA
              IF(NCY1LA.LE.0)GOTO1849
              DO1840I=1,NCY1LA
                IY1LTE(I)=IYLABT(I)
 1840         CONTINUE
            ENDIF
 1849       CONTINUE
          ENDIF
        ENDIF
C
        IF(ICASPL.EQ.'SPMA'.AND.ISPMPT.EQ.'PLOT'.AND.
     1    ISPMDI.EQ.'BLAN'.AND.IROW.EQ.ICOL)THEN
          NCX1LA=NCXLA
          NCY1LA=0
          NCY2LA=0
          IF(NCX1LA.LE.0)GOTO1919
          DO1910I=1,NCX1LA
            IX1LTE(I)=IXLABT(I)
 1910     CONTINUE
 1919     CONTINUE
          PX1LDS=-((PYMAX-PYMIN)/2.0)
        ENDIF
 1699   CONTINUE
C
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPM1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSPM1--')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSPM2(ICASPL,IVARN1,IVARN2,ICOLL,NUMVAR,NPLOTP,
     1                  IROW,ICOL,
     1                  TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,MAXNXT,
     1                  ALOWFR,ALOWDG,
     1                  IANGLU,MAXNPP,IAND1,IAND2,
     1                  ISPMFI,ISPMTA,
     1                  XMATN,YMATN,XMITN,YMITN,
     1                  ISQUAR,
     1                  IVGMSW,IHGMSW,
     1                  IMPSW,IMPNR,IMPNC,IMPCO,IMPCO9,
     1                  IREPCH,
     1                  PMXMIN,PMXMAX,PMYMIN,PMYMAX,
     1                  IBUGG2,IBUGG3,IBUGCO,IBUGEV,IBUGQ,
     1                  IBUGUG,IBUGU2,IBUGU3,IBUGU4,
     1                  ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--UTILTY ROUTINE FOR SCATTER PLOT MATRIX.  GENERATE
C              OVERLAID SMOOTH OR FITTED CURVE ON PLOT.  ALSO
C              USED BY FACTOR AND CONDITIONING PLOTS.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--99/11
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--NOVEMBERR 1999.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES---------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOPC.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOSP.INC'
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICASAN
      CHARACTER*4 IANGLU
      CHARACTER*4 IMPSW
      CHARACTER*4 IREPCH
      CHARACTER*4 ISQUAR
      CHARACTER*4 IVGMSW
      CHARACTER*4 IHGMSW
      CHARACTER*4 IAND1
      CHARACTER*4 IAND2
      CHARACTER*4 IFTEXP
      CHARACTER*4 IFTORD
      CHARACTER*4 IOPTME
      CHARACTER*4 IOPTHE
C
      CHARACTER*4 IBUGG2
      CHARACTER*4 IBUGG3
      CHARACTER*4 IBUGUG
      CHARACTER*4 IBUGU2
      CHARACTER*4 IBUGU3
      CHARACTER*4 IBUGU4
      CHARACTER*4 IBUGCO
      CHARACTER*4 IBUGEV
      CHARACTER*4 IBUGQ
C
      CHARACTER*4 ICONT
      CHARACTER*4 IWRITE
      CHARACTER*4 IFOUND
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISPMFI
      CHARACTER*4 ISPMTA
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICASP2
      CHARACTER*4 IFORSW
      CHARACTER*4 ICOMT
      CHARACTER*4 ICOM2T
C
      CHARACTER*4 IVARN1
      CHARACTER*4 IVARN2
C
      DIMENSION ICOLL(*)
      DIMENSION IVARN1(*)
      DIMENSION IVARN2(*)
C
      DIMENSION TEMP(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
C
      PARAMETER (MAXART=20)
      CHARACTER*4 ITHARG
      CHARACTER*4 ITHAR2
      CHARACTER*4 ITARGT
      CHARACTER*4 IANST
      DIMENSION ITHARG(MAXART)
      DIMENSION ITHAR2(MAXART)
      DIMENSION ITARG(MAXART)
      DIMENSION TARG(MAXART)
      DIMENSION ITARGT(MAXART)
      DIMENSION IANST(MAXSTR)
C
C-----COMMON VARIABLES (GENERAL)----------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-------------------------------------------------
C
CCCCC IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPM2')THEN
CCCCC ENDIF
C
CCCCC NOTE: CURRENTLY, LOWESS (AND OTHER) TYPE FITS ONLY
CCCCC       USED FOR "PLOT Y X" TYPE COMMANDS.  NOTE THAT
CCCCC       SOME OF THE LOGIC OF THIS ROUTINE WILL NEED TO
CCCCC       BE UPDATED IF THIS CAPABILITY IS EXTENDED TO
CCCCC       ADDITIONAL PLOT TYPES (I.E., SOME CARE NEEDS TO BE 
CCCCC       TAKEN TO ENSURE THAT SUBSET CLAUSES ARE CARRIED 
CCCCC       ALONG PROPERLY).
C
C               ***************************************
C               **  STEP 1--                         **
C               ***************************************
C
      ICAPSW='OFF'
      IFORSW='-7'
      IERROR='NO'
C
C     PARTIAL REGRESSION, PARTIAL RESIDUAL, AND PARTIAL
C     LEVERAGE PLOT ALLOW FITTED CURVE TO OVERLAID.
C
      IF(ICASPL.EQ.'PREG' .OR. ICASPL.EQ.'PRES' .OR.
     1   ICASPL.EQ.'PLEV')THEN
        ICASP2='PLOT'
      ELSE
        IF(ICOM.NE.'PLOT')GOTO9000
      ENDIF
C
      ICOMT=ICOM
      ICOM2T=ICOM2
      ICASP2=ICASPL
      NUMART=NUMARG
      DO100I=1,NUMARG
        ITHARG(I)=IHARG(I)
        ITHAR2(I)=IHARG2(I)
        ITARG(I)=IARG(I)
        TARG(I)=ARG(I)
        ITARGT(I)=IARGT(I)
  100 CONTINUE
      DO102I=1,MAXSTR
        IANST(I)=IANS(I)
  102 CONTINUE
      IWIDT=IWIDTH
C
      IFLAG=3
      IOUNI5=-99
      CALL DPSPM5(IFLAG,IMPSW,IMPCO,IMPNR,IMPNC,IOUNI5,
     1            IBUGG2,ISUBRO,IFOUND,IERROR)
C
      IF(ISPMTA.EQ.'ON')THEN
        ISHIFT=1
        CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1              IBUGG2,IERROR)
        ITAGCO=3
        DO119I=1,NUMARG
          IF(I.EQ.ITAGCO)GOTO119
          IHARG(I)=ITHARG(I)
          IHARG2(I)=ITHAR2(I)
          IARG(I)=ITARG(I)
          ARG(I)=TARG(I)
          IARGT(I)=ITARGT(I)
  119   CONTINUE
      ENDIF
C
      IF(ICASPL.EQ.'PREG' .OR. ICASPL.EQ.'PRES' .OR.
     1   ICASPL.EQ.'PLEV')THEN
         NUMARG=2
         ICOM='PLOT'
         ICOM2='    '
         IHARG(1)='YPLO'
         IHARG2(1)='T   '
         IHARG(2)='XPLO'
         IHARG2(2)='T   '
      ENDIF
C
      IF(ISPMFI.EQ.'LOES')THEN
        ICOM='LOWE'
        ICOM2='SS  '
        CALL DPLOW(ALOWFR,ALOWDG,ICAPSW,IFORSW,
     1             TEMP,TEMP2,XTEMP1,XTEMP2,MAXNXT,
     1             IBUGG2,IBUGG3,IBUGQ,ISUBRO,IFOUND,IERROR)
      ELSEIF(ISPMFI.EQ.'LINE')THEN
        ICOM='FIT '
        ICOM2='    '
        ICASAN='FIT'
        CALL DPFIT(ICAPSW,IFORSW,
     1             IBUGG2,IBUGG3,IBUGCO,IBUGEV,IBUGQ,ISUBRO,
     1             IFOUND,IERROR)
      ELSEIF(ISPMFI.EQ.'QUAD')THEN
        ISHIFT=1
        CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1              IBUGG2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        ICOM='QUAD'
        ICOM2='RATI'
        IHARG(1)='FIT '
        IHARG2(1)='    '
        ICASAN='FIT'
        CALL DPFIT(ICAPSW,IFORSW,
     1             IBUGG2,IBUGG3,IBUGCO,IBUGEV,IBUGQ,ISUBRO,
     1             IFOUND,IERROR)
      ELSEIF(ISPMFI.EQ.'SMOO')THEN
        ICOM='SMOO'
        ICOM2='TH  '
        ICASAN='SMOO'
        CALL DPSMOO(IBUGG2,IBUGG3,IBUGQ,IFOUND,IERROR)
      ENDIF
C
      ICOM='PLOT'
      ICOM2='    '
      ISHIFT=1
      IF(ISHIFT.GT.0)THEN
        CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1            IBUGG2,IERROR)
      ELSEIF(ISHIFT.LT.0)THEN
        CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1            IBUGG2,IERROR)
      ENDIF
      IF(ISPMTA.EQ.'OFF')THEN
        ITEMP=2
      ELSE
        IWRITE='OFF'
        CALL MAXIM(TAGPLO,NPLOTP,IWRITE,XMAX,IBUGG3,IERROR)
        ITEMP=1+INT(XMAX)
        IF(ITEMP.LT.1.OR.ITEMP.GT.100)ITEMP=2
      ENDIF
C
      IF(ICASPL.EQ.'PREG' .OR. ICASPL.EQ.'PRES' .OR.
     1   ICASPL.EQ.'PLEV')THEN
        NUMARG=3
        ICOM='LET '
        ICOM2='    '
        IHARG(1)='XTEM'
        IHARG2(1)='P   '
        IHARG(2)='=   '
        IHARG2(2)='    '
        IHARG(3)='XPLO'
        IHARG2(3)='T   '
        IANS(1)='L   '
        IANS(2)='E   '
        IANS(3)='T   '
        IANS(4)='    '
        IANS(5)='X   '
        IANS(6)='T   '
        IANS(7)='E   '
        IANS(8)='M   '
        IANS(9)='P   '
        IANS(10)='    '
        IANS(11)='=   '
        IANS(12)='    '
        IANS(13)='X   '
        IANS(14)='P   '
        IANS(15)='L   '
        IANS(16)='O   '
        IANS(17)='T   '
        IWIDTH=17
        CALL DPLET(IANGLU,ISEED,IBUGG2,IBUGG3,IBUGCO,IBUGEV,IBUGQ,
     1             TEMP,TEMP2,XTEMP1,XTEMP2,MAXNXT,
     1             IFTEXP,IFTORD,
     1             ROOTAC,OPTACC,IOPTME,IOPTHE,
     1             ISUBRO,IFOUND,IERROR)
C
        IF(IERROR.EQ.'YES')GOTO9000
        ICOM='PLOT'
        ICOM2='    '
        IHARG(1)='PRED'
        IHARG2(1)='    '
        IHARG(2)='VS  '
        IHARG2(2)='    '
        IHARG(3)='XTEM'
        IHARG2(3)='P   '
      ELSE
        IHARG(1)='PRED'
        IHARG2(1)='    '
        IHARG(2)='VS  '
        IHARG2(2)='    '
        IHARG(3)=IVARN1(ICOL)
        IHARG2(3)=IVARN2(ICOL)
      ENDIF
      CALL DPPLOT(NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2,
     1            IANGLU,MAXNPP,
     1            IBUGG2,IBUGG3,IBUGCO,IBUGEV,IBUGQ,ISUBRO,
     1            IFOUND,IERROR)
      ICASPL=ICASP2
C
C
C               **************************************************
C               **   STEP 25--                                  **
C               **   PLOT THE CURRENT PLOT                      **
C               **************************************************
C
      ICONT=IDCONT(1)
      NUMHPP=IDNHPP(1)
      IMPARG=2
      CALL DPGRAP(Y,X,X3D,D,N,NPLOTP,ICASPL,ICONT,NUMHPP,
     1            XMATN,YMATN,XMITN,YMITN,
     1            ISQUAR,
     1            IVGMSW,IHGMSW,
     1            IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,
     1            IVSTAR,IVSTOP,IFUNC,NUMCHF,IREPCH,
     1            YPLOT,XPLOT,X2PLOT,TAGPLO,
     1            IMPSW,IMPNR,IMPNC,IMPCO,IMPCO9,
     1            IMPARG,
     1            PMXMIN,PMXMAX,PMYMIN,PMYMAX,
     1            MAXCOL,
     1            DSIZE,DSYMB,DCOLOR,DFILL,
     1            ICAPSW,
     1            IBUGUG,IBUGU2,IBUGU3,IBUGU4,ISUBRO,
     1            IERROR)
      IF(IERROR.EQ.'NO')IAND1=IAND2
      IERROR='NO'
C
      NUMARG=NUMART
      ICOM=ICOMT
      ICOM2=ICOM2T
      DO900I=1,NUMARG
        IHARG(I)=ITHARG(I)
        IHARG2(I)=ITHAR2(I)
        IARG(I)=ITARG(I)
        ARG(I)=TARG(I)
        IARGT(I)=ITARGT(I)
  900 CONTINUE
      DO902I=1,MAXSTR
        IANS(I)=IANST(I)
  902 CONTINUE
      IWIDTH=IWIDT
C
      IFLAG=4
      CALL DPSPM5(IFLAG,IMPSW,IMPCO,IMPNR,IMPNC,IOUNI2,
     1            IBUGG2,ISUBRO,IFOUND,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPM2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSPM2--')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSPM3(ICASPL,IOUNI5,
     1                  IROW,ICOL,
     1                  PX2LD2,NPLOTP,
     1                  IFORSW,
     1                  ISPX2L,ISPX2P,ISPX2S,
     1                  IHRIGH,IHRIG2,IHWUSE,
     1                  ISUBN1,ISUBN2,MESSAG,
     1                  IBUGG2,ISUBRO,IERROR)
C
C     PURPOSE--UTILTY ROUTINE FOR SCATTER PLOT MATRIX.  GENERATE
C              AN X2LABEL BASED ON CORRELATION, EFFECT SIZE, OR
C              NUMBER OF DEFECTIVES.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--99/11
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--NOVEMBERR 1999.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES---------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOPC.INC'
      INCLUDE 'DPCOHK.INC'
C
      CHARACTER*4 IBUGG2
      CHARACTER*4 ICASPL
C
      CHARACTER*4 IFORSW
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISPX2L
      CHARACTER*16 ISPX2P
      CHARACTER*16 ISPX2S
C
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
      CHARACTER*4 IHWUSE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 MESSAG
C
C-----COMMON VARIABLES (GENERAL)----------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-------------------------------------------------
C
C               ***************************************
C               **  STEP 1--                         **
C               ***************************************
C
      IERROR='NO'
      IF(ISPX2L.EQ.'OFF ')GOTO9000
      IF(ISPX2L.EQ.'NONE')GOTO9000
      IF(ISPX2L.EQ.'BLAN')GOTO9000
C
      ALOWH=0.0
      ACORR=0.0
      NACC=0
      NREJ=0
C
      IHRIGH='ALOW'
      IHRIG2='HIGH'
      IHWUSE='P'
      MESSAG='NO'
      CALL CHECKN(IHRIGH,IHRIG2,IHWUSE,
     1            IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1            ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
      IF(IERROR.EQ.'NO')ALOWH=VALUE(ILOCP)
C
      IHRIGH='PLOT'
      IHRIG2='CORR'
      IHWUSE='P'
      MESSAG='NO'
      CALL CHECKN(IHRIGH,IHRIG2,IHWUSE,
     1            IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1            ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
      IF(IERROR.EQ.'NO')ACORR=VALUE(ILOCP)
C
      IHRIGH='NACC'
      IHRIG2='EPT '
      IHWUSE='P'
      MESSAG='NO'
      CALL CHECKN(IHRIGH,IHRIG2,IHWUSE,
     1            IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1            ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
      IF(IERROR.EQ.'NO')NACC=INT(VALUE(ILOCP)+0.5)
C
      IHRIGH='NREJ'
      IHRIG2='ECT '
      IHWUSE='P'
      MESSAG='NO'
      CALL CHECKN(IHRIGH,IHRIG2,IHWUSE,
     1             IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1             ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
      IERROR='NO'
C
      NUMDIG=-1
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'10')NUMDIG=10
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      IF(ISPX2L.EQ.'CORR'.OR.ISPX2L.EQ.'PCOR')THEN
        IWRITE='OFF'
        IF(ISPX2P.EQ.'DEFAULT')THEN
          IX2LTE(1)='C'
          IX2LTE(2)='O'
          IX2LTE(3)='R'
          IX2LTE(4)='R'
          IX2LTE(5)=' '
          IX2LTE(6)='='
          IX2LTE(7)=' '
          NCX2LA=7
        ELSEIF(ISPX2P.EQ.' ')THEN
          NCX2LA=0
        ELSE
          DO110I=16,1,-1
            IF(ISPX2P(I:I).NE.' ')THEN
              NCX2LA=I
              DO120J=1,NCX2LA
                IX2LTE(J)(1:1)=ISPX2P(J:J)
  120         CONTINUE
              GOTO129
            ENDIF
  110     CONTINUE
  129     CONTINUE
        ENDIF
        CONST=0.5
        IF(ACORR.LT.0.0)CONST=-0.5
        IF(ISPX2L.EQ.'PCOR')ACORR=100.0*ACORR
        IF(IOUNI5.GT.0)WRITE(IOUNI5,'(G15.7)')ACORR
        NDEF=3
        IF(ISPX2L.EQ.'PCOR')NDEF=1
        IF(NUMDIG.LT.0)THEN
          ICORR=INT(ACORR*10**NDEF + CONST)
          ACORR=REAL(ICORR)/(10**NDEF)
        ELSE
          ICORR=INT(ACORR*10**NUMDIG + CONST)
          ACORR=REAL(ICORR)/(10**NUMDIG)
        ENDIF
        NCX2LA=NCX2LA+1
        CALL DPCONH(ICORR,ACORR,IX2LTE(NCX2LA),NH,IBUGG2,IERROR)
        NCX2LA=NCX2LA+NH
        IF(ISPX2S.EQ.'DEFAULT')THEN
          IF(ISPX2L.EQ.'PCOR')THEN
            NCX2LA=NCX2LA+1
            IX2LTE(NCX2LA)='%'
          ENDIF
        ELSEIF(ISPX2S.NE.' ')THEN
          DO210I=16,1,-1
            IF(ISPX2S(I:I).NE.' ')THEN
              NTEMP=I
              DO220J=1,NTEMP
                NCX2LA=NCX2LA+1
                IX2LTE(NCX2LA)(1:1)=ISPX2S(J:J)
  220         CONTINUE
              GOTO229
            ENDIF
  210     CONTINUE
  229     CONTINUE
        ENDIF
        CONST=0.5
        PX2LDS=-((PYMAX-PYMIN)-PX2LD2)
      ELSEIF(ISPX2L.EQ.'PACC')THEN
        IF(ISPX2P.EQ.'DEFAULT')THEN
          NCX2LA=0
        ELSEIF(ISPX2P.EQ.' ')THEN
          NCX2LA=0
        ELSE
          DO310I=16,1,-1
            IF(ISPX2P(I:I).NE.' ')THEN
              NCX2LA=I
              DO320J=1,NCX2LA
                IX2LTE(J)(1:1)=ISPX2P(J:J)
  320         CONTINUE
              GOTO329
            ENDIF
  310     CONTINUE
  329     CONTINUE
        ENDIF
        CONST=0.5
        AV=REAL(NACC)/REAL(NACC+NREJ)
        AV=100.0*AV
        IF(IOUNI5.GT.0)WRITE(IOUNI5,'(G15.7)')AV
        IF(AV.LT.0.0)CONST=-0.5
        IF(NUMDIG.GE.0)THEN
          IVAL=INT(AV*10**NUMDIG + CONST)
          AV=REAL(IVAL)/(10**NUMDIG)
        ENDIF
        NCX2LA=NCX2LA+1
        CALL DPCONH(IVAL,AV,IX2LTE(NCX2LA),NH,IBUGG2,IERROR)
        NCX2LA=NCX2LA+NH
        IF(ISPX2S.EQ.'DEFAULT')THEN
          CONTINUE
        ELSEIF(ISPX2P.NE.' ')THEN
          DO360I=16,1,-1
            IF(ISPX2S(I:I).NE.' ')THEN
              NTEMP=I
              DO370J=1,NTEMP
                NCX2LA=NCX2LA+1
                IX2LTE(NCX2LA)(1:1)=ISPX2P(J:J)
  370         CONTINUE
              GOTO379
            ENDIF
  360     CONTINUE
  379     CONTINUE
        ENDIF
        CONST=0.5
        PX2LDS=-((PYMAX-PYMIN)-PX2LD2)
C
      ELSEIF(ISPX2L.EQ.'NACC')THEN
        IF(ISPX2P.EQ.'DEFAULT')THEN
          NCX2LA=0
        ELSEIF(ISPX2P.EQ.' ')THEN
          NCX2LA=0
        ELSE
          DO410I=16,1,-1
            IF(ISPX2P(I:I).NE.' ')THEN
              NCX2LA=I
              DO420J=1,NCX2LA
                IX2LTE(J)(1:1)=ISPX2P(J:J)
  420         CONTINUE
              GOTO429
            ENDIF
  410     CONTINUE
  429     CONTINUE
        ENDIF
        CONST=0.5
        AV=REAL(NACC)
        IF(IOUNI5.GT.0)WRITE(IOUNI5,'(G15.7)')AV
        IF(AV.LT.0.0)CONST=-0.5
        IF(NUMDIG.GE.0)THEN
          IVAL=INT(AV*10**NUMDIG + CONST)
          AV=REAL(IVAL)/(10**NUMDIG)
        ENDIF
        NCX2LA=NCX2LA+1
        CALL DPCONH(IVAL,AV,IX2LTE(NCX2LA),NH,IBUGG2,IERROR)
        NCX2LA=NCX2LA+NH
        IF(ISPX2S.EQ.'DEFAULT')THEN
          CONTINUE
        ELSEIF(ISPX2P.NE.' ')THEN
          DO460I=16,1,-1
            IF(ISPX2S(I:I).NE.' ')THEN
              NTEMP=I
              DO470J=1,NTEMP
                NCX2LA=NCX2LA+1
                IX2LTE(NCX2LA)(1:1)=ISPX2P(J:J)
  470         CONTINUE
              GOTO479
            ENDIF
  460     CONTINUE
  479     CONTINUE
        ENDIF
        CONST=0.5
        PX2LDS=-((PYMAX-PYMIN)-PX2LD2)
C
      ELSEIF(ISPX2L.EQ.'AT  ')THEN
        IF(ISPX2P.EQ.'DEFAULT')THEN
          NCX2LA=0
        ELSEIF(ISPX2P.EQ.' ')THEN
          NCX2LA=0
        ELSE
          DO810I=16,1,-1
            IF(ISPX2P(I:I).NE.' ')THEN
              NCX2LA=I
              DO820J=1,NCX2LA
                IX2LTE(J)(1:1)=ISPX2P(J:J)
  820         CONTINUE
              GOTO829
            ENDIF
  810     CONTINUE
  829     CONTINUE
        ENDIF
        CONST=0.5
        AV=REAL(NACC)
        AV1=AV
        IF(AV.LT.0.0)CONST=-0.5
        IF(NUMDIG.GE.0)THEN
          IVAL=INT(AV*10**NUMDIG + CONST)
          AV=REAL(IVAL)/(10**NUMDIG)
        ENDIF
        NCX2LA=NCX2LA+1
        CALL DPCONH(IVAL,AV,IX2LTE(NCX2LA),NH,IBUGG2,IERROR)
        NCX2LA=NCX2LA+NH
        NCX2LA=NCX2LA+1
        IX2LTE(NCX2LA)(1:1)='/'
        AV=REAL(NACC+NREJ)
        IF(IOUNI5.GT.0)WRITE(IOUNI5,'(2G15.7)')AV1,AV
        IF(AV.LT.0.0)CONST=-0.5
        IF(NUMDIG.GE.0)THEN
          IVAL=INT(AV*10**NUMDIG + CONST)
          AV=REAL(IVAL)/(10**NUMDIG)
        ENDIF
        NCX2LA=NCX2LA+1
        CALL DPCONH(IVAL,AV,IX2LTE(NCX2LA),NH,IBUGG2,IERROR)
        NCX2LA=NCX2LA+NH
        IF(ISPX2S.EQ.'DEFAULT')THEN
          CONTINUE
        ELSEIF(ISPX2P.NE.' ')THEN
          DO860I=16,1,-1
            IF(ISPX2S(I:I).NE.' ')THEN
              NTEMP=I
              DO870J=1,NTEMP
                NCX2LA=NCX2LA+1
                IX2LTE(NCX2LA)(1:1)=ISPX2P(J:J)
  870         CONTINUE
              GOTO879
            ENDIF
  860     CONTINUE
  879     CONTINUE
        ENDIF
        CONST=0.5
        PX2LDS=-((PYMAX-PYMIN)-PX2LD2)
C
      ELSEIF(ISPX2L.EQ.'ATP ')THEN
        IF(ISPX2P.EQ.'DEFAULT')THEN
          NCX2LA=0
        ELSEIF(ISPX2P.EQ.' ')THEN
          NCX2LA=0
        ELSE
          DO710I=16,1,-1
            IF(ISPX2P(I:I).NE.' ')THEN
              NCX2LA=I
              DO720J=1,NCX2LA
                IX2LTE(J)(1:1)=ISPX2P(J:J)
  720         CONTINUE
              GOTO729
            ENDIF
  710     CONTINUE
  729     CONTINUE
        ENDIF
        CONST=0.5
        AV=REAL(NACC)
        AV1=AV
        IF(AV.LT.0.0)CONST=-0.5
        IF(NUMDIG.GE.0)THEN
          IVAL=INT(AV*10**NUMDIG + CONST)
          AV=REAL(IVAL)/(10**NUMDIG)
        ENDIF
        NCX2LA=NCX2LA+1
        CALL DPCONH(IVAL,AV,IX2LTE(NCX2LA),NH,IBUGG2,IERROR)
        NCX2LA=NCX2LA+NH
        NCX2LA=NCX2LA+1
        IX2LTE(NCX2LA)(1:1)='/'
        AV=REAL(NACC+NREJ)
        AV2=AV
        IF(AV.LT.0.0)CONST=-0.5
        IF(NUMDIG.GE.0)THEN
          IVAL=INT(AV*10**NUMDIG + CONST)
          AV=REAL(IVAL)/(10**NUMDIG)
        ENDIF
        NCX2LA=NCX2LA+1
        CALL DPCONH(IVAL,AV,IX2LTE(NCX2LA),NH,IBUGG2,IERROR)
        NCX2LA=NCX2LA+NH
        NCX2LA=NCX2LA+1
        IX2LTE(NCX2LA)(1:1)=' '
        NCX2LA=NCX2LA+1
        IX2LTE(NCX2LA)(1:1)='='
        NCX2LA=NCX2LA+1
        IX2LTE(NCX2LA)(1:1)=' '
        AV=REAL(NACC)/REAL(NACC+NREJ)
        AV=100.0*AV
        IF(IOUNI5.GT.0)WRITE(IOUNI5,'(3G15.7)')AV1,AV2,AV
        IF(AV.LT.0.0)CONST=-0.5
        IF(NUMDIG.GE.0)THEN
          IVAL=INT(AV*10**NUMDIG + CONST)
          AV=REAL(IVAL)/(10**NUMDIG)
        ENDIF
        NCX2LA=NCX2LA+1
        CALL DPCONH(IVAL,AV,IX2LTE(NCX2LA),NH,IBUGG2,IERROR)
        NCX2LA=NCX2LA+NH
        IF(ISPX2S.EQ.'DEFAULT')THEN
          CONTINUE
        ELSEIF(ISPX2P.NE.' ')THEN
          DO760I=16,1,-1
            IF(ISPX2S(I:I).NE.' ')THEN
              NTEMP=I
              DO770J=1,NTEMP
                NCX2LA=NCX2LA+1
                IX2LTE(NCX2LA)(1:1)=ISPX2P(J:J)
  770         CONTINUE
              GOTO779
            ENDIF
  760     CONTINUE
  779     CONTINUE
        ENDIF
        CONST=0.5
        PX2LDS=-((PYMAX-PYMIN)-PX2LD2)
C
      ELSEIF(ISPX2L.EQ.'EFFE')THEN
        IF(ISPX2P.EQ.'DEFAULT')THEN
          IX2LTE(1)='E'
          IX2LTE(2)='F'
          IX2LTE(3)='F'
          IX2LTE(4)='E'
          IX2LTE(5)='C'
          IX2LTE(6)='T'
          IX2LTE(7)=' '
          IX2LTE(8)='='
          IX2LTE(9)=' '
          NCX2LA=9
        ELSEIF(ISPX2P.EQ.' ')THEN
          NCX2LA=0
        ELSE
          DO610I=16,1,-1
            IF(ISPX2P(I:I).NE.' ')THEN
              NCX2LA=I
              DO620J=1,NCX2LA
                IX2LTE(J)(1:1)=ISPX2P(J:J)
  620         CONTINUE
              GOTO629
            ENDIF
  610     CONTINUE
  629     CONTINUE
        ENDIF
        CONST=0.5
        AVAL=ALOWH
        IF(IOUNI5.GT.0)WRITE(IOUNI5,'(G15.7)')AVAL
        IF(AVAL.LT.0.0)CONST=-0.5
        IF(NUMDIG.GE.0)THEN
          IVAL=INT(AVAL*10**NUMDIG + CONST)
          AVAL=REAL(IVAL)/(10**NUMDIG)
        ENDIF
        NCX2LA=NCX2LA+1
        CALL DPCONH(IVAL,AVAL,IX2LTE(NCX2LA),NH,IBUGG2,IERROR)
        NCX2LA=NCX2LA+NH
        IF(ISPX2S.EQ.'DEFAULT')THEN
          CONTINUE
        ELSEIF(ISPX2P.NE.' ')THEN
          DO660I=16,1,-1
            IF(ISPX2S(I:I).NE.' ')THEN
              NTEMP=I
              DO670J=1,NTEMP
                NCX2LA=NCX2LA+1
                IX2LTE(NCX2LA)(1:1)=ISPX2P(J:J)
  670         CONTINUE
              GOTO679
            ENDIF
  660     CONTINUE
  679     CONTINUE
        ENDIF
        CONST=0.5
        PX2LDS=-((PYMAX-PYMIN)-PX2LD2)
C
      ELSEIF(ISPX2L.EQ.'FILL')THEN
        NCX2LA=0
        IF(IROW.LE.9)THEN
          NCX2LA=NCX2LA+1
          WRITE(IX2LTE(J)(NCX2LA:NCX2LA),'(I1)')IROW
        ELSEIF(IROW.LE.99)THEN
          NCX2LA=NCX2LA+1
          WRITE(IX2LTE(J)(NCX2LA:NCX2LA+1),'(I2)')IROW
          NCX2LA=NCX2LA+1
        ENDIF
        IF(IROW.NE.ICOL)THEN
          IF(ICOL.LE.9)THEN
            NCX2LA=NCX2LA+1
            WRITE(IX2LTE(J)(NCX2LA:NCX2LA),'(I1)')ICOL
          ELSEIF(ICOL.LE.99)THEN
            NCX2LA=NCX2LA+1
            WRITE(IX2LTE(J)(NCX2LA:NCX2LA+1),'(I2)')IROW
            NCX2LA=NCX2LA+1
          ENDIF
        ENDIF
        NCX2LA=NCX2LA+1
        IX2LTE(J)(NCX2LA:NCX2LA+1)=': '
        NCX2LA=NCX2LA+1
        CONST=0.5
        AVAL=ALOWH
        IF(IOUNI5.GT.0)WRITE(IOUNI5,'(G15.7)')AVAL
        IF(AVAL.LT.0.0)CONST=-0.5
        IF(NUMDIG.GE.0)THEN
          IVAL=INT(AVAL*10**NUMDIG + CONST)
          AVAL=REAL(IVAL)/(10**NUMDIG)
        ENDIF
        NCX2LA=NCX2LA+1
        CALL DPCONH(IVAL,AVAL,IX2LTE(NCX2LA),NH,IBUGG2,IERROR)
        NCX2LA=NCX2LA+NH
        CONST=0.5
        PX2LDS=-((PYMAX-PYMIN)-PX2LD2)
C
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPM3')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSPM3--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)J,NCX2LA,PX2LDS
 9013   FORMAT('J,NCX2LA,PX2LDS = ',2I8,G15.7)
        CALL DPWRST('XXX','BUG ')
        IF(NCX2LA.GT.0)THEN
          WRITE(ICOUT,9015)IX2LTE(J)(1:NCX2LA)
 9015     FORMAT('IX2LTE(J)(1:NCX2LA) = ',A80)
          CALL DPWRST('XXX','BUG ')
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSPM4(ICASPL,IOPTN,IDX,IDY,
     1                  ISUBNU,
     1                  ISUBSW,
     1                  ASUBXL,ASUBXU,ASUBYL,ASUBYU,
     1                  ISUBN9,
     1                  ISUBSZ,
     1                  ASBXL2,ASBXU2,ASBYL2,ASBYU2,
     1                  PSPXSL,PSPXSU,PSPYSL,PSPYSU,
     1                  IBUGG2,ISUBRO,IERROR)
C
C     PURPOSE--UTILTY ROUTINE FOR SCATTER PLOT MATRIX.  SET SUBREGION
C              LIMITS (IF SPECIFIED BY USER).
C              IOPTN = 1  - SAVE CURENT SETTINGS
C              IOPTN = 2  - RESTORE CURENT SETTINGS
C              IOPTN = 3  - SET SUBREGION LIMITS FOR GIVEN Y, X
C                           PAIR OF VARIABLES.  NOTE IF LIMIT SET TO
C                           CPUMIN OR CPUMAX, THEN NOTHING SET.
C                           ALSO, MATRIX PLOTS ONLY RESET FIRST
C                           SUBREGION (OTHERS ARE LEFT AS IS)
C              IDX   = SETTING OF PSPXSL, PSPXSU TO USE
C              IDY   = SETTING OF PSPYSL, PSPYSU TO USE
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--99/12
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--DECEMBER  1999.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES---------------
C
      CHARACTER*4 IBUGG2
      CHARACTER*4 ICASPL
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBSW
      CHARACTER*4 ISUBSZ
C
      DIMENSION ISUBSW(*)
      DIMENSION ASUBXL(*)
      DIMENSION ASUBXU(*)
      DIMENSION ASUBYL(*)
      DIMENSION ASUBYU(*)
      DIMENSION PSPXSL(*)
      DIMENSION PSPXSU(*)
      DIMENSION PSPYSL(*)
      DIMENSION PSPYSU(*)
C
C-----COMMON VARIABLES (GENERAL)----------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-------------------------------------------------
C
CCCCC IF(ISUBRO.EQ.'SPM4')THEN
CCCCC ENDIF
C               ***************************************
C               **  STEP 1--SAVE INITIAL SETTINGS    **
C               ***************************************
C
      IF(IOPTN.EQ.1)THEN
        ISUBSZ=ISUBSW(1)
        ASBXL2=ASUBXL(1)
        ASBXU2=ASUBXU(1)
        ASBYL2=ASUBYL(1)
        ASBYU2=ASUBYU(1)
        ISUBN9=ISUBNU
      ELSEIF(IOPTN.EQ.2)THEN
        ISUBSW(1)=ISUBSZ
        ASUBXL(1)=ASBXL2
        ASUBXU(1)=ASBXU2
        ASUBYL(1)=ASBYL2
        ASUBYU(1)=ASBYU2
        ISUBNU=ISUBN9
      ELSEIF(IOPTN.EQ.3)THEN
        IF(PSPXSL(IDX).NE.CPUMIN .AND. PSPXSU(IDX).NE.CPUMIN)THEN
          ISUBSW(1)='ON'
          IF(ISUBNU.EQ.0)ISUBNU=1
          ASUBXL(1)=PSPXSL(IDX)
          ASUBXU(1)=PSPXSU(IDX)
        ENDIF
        IF(PSPYSL(IDY).NE.CPUMIN .AND. PSPYSU(IDY).NE.CPUMIN)THEN
          ISUBSW(1)='ON'
          IF(ISUBNU.EQ.0)ISUBNU=1
          ASUBYL(1)=PSPYSL(IDY)
          ASUBYU(1)=PSPYSU(IDY)
        ENDIF
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPM4')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSPM4--')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSPM5(IFLAG,IMPSW,IMPCO,IMPNR,IMPNC,
     1                  IOUNI5,
     1                  IBUGG2,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--UTILTY ROUTINE FOR SCATTER PLOT MATRIX.  DO ONE OF THE
C              FOLLOWING:
C                 1) SAVE CURRENT PLOT CONTROL SETTINGS FOR PLOT
C                 2) RESTORE CURRENT PLOT CONTROL SETTINGS FOR PLOT
C                 3) SAVE CURRENT PLOT CONTROL SETTINGS FOR OVERLAID FIT
C                 4) RESTORE CURRENT PLOT CONTROL SETTINGS FOR OVERLAID FIT
C               ALSO USED BY CONDITION PLOT AND FACTOR PLOT
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2011/7
C     ORIGINAL VERSION--JULY 2011.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES---------------
C
      CHARACTER*4 IMPSW
      CHARACTER*4 IBUGG2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IOP
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOPC.INC'
      INCLUDE 'DPCOST.INC'
      INCLUDE 'DPCOSP.INC'
      INCLUDE 'DPCOF2.INC'
C
C-----COMMON VARIABLES (GENERAL)----------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-------------------------------------------------
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPM5')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSPM5--')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               **********************************************************
C               **  STEP 0--SAVE/RESTORE PLOT CONTROL SETTINGS THAT ARE **
C               **          COMMON TO BOTH CASES.                       **
C               **********************************************************
C
      IF(IFLAG.EQ.1 .OR. IFLAG.EQ.3)THEN
C
        IOP='OPEN'
        IFLAG1=0
        IFLAG2=0
        IFLAG3=0
        IFLAG4=0
        IFLAG5=1
        IF(IOUNI5.GE.1)THEN
          CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1                IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1                IBUGG2,ISUBRO,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
        ENDIF
C
        GY1MNS=GY1MIN
        GY1MXS=GY1MAX
        GY2MNS=GY2MIN
        GY2MXS=GY2MAX
        GX1MNS=GX1MIN
        GX1MXS=GX1MAX
        GX2MNS=GX2MIN
        GX2MXS=GX2MAX
C
        IY1MNS=IY1MIN
        IY1MXS=IY1MAX
        IY2MNS=IY2MIN
        IY2MXS=IY2MAX
        IX1MNS=IX1MIN
        IX1MXS=IX1MAX
        IX2MNS=IX2MIN
        IX2MXS=IX2MAX
C
C           **********************************************************
C           **  STEP 1--SAVE PLOT CONTROL SETTINGS FOR INITIAL PLOT **
C           **********************************************************
C
        IF(IFLAG.EQ.1)THEN
C
          PXMN2=PXMIN
          PXMX2=PXMAX
          PYMN2=PYMIN
          PYMX2=PYMAX
          PWXMN2=PWXMIN
          PWXMX2=PWXMAX
          PWYMN2=PWYMIN
          PWYMX2=PWYMAX
          IF(ISPMFR.EQ.'DEFA')THEN
            PXMIN=0.0
            PXMAX=100.0
            PYMIN=0.0
            PYMAX=100.0
          ENDIF
C
          IFENC2=IFENSW
          IERAS2=IERASW
          IPPTB2=IPPTBI
          ISORS2=ISORSW
C
          IX1TSV=IX1TSW
          IX2TSV=IX2TSW
          IY1TSV=IY1TSW
          IY2TSV=IY2TSW
          IX1ZSV=IX1ZSW
          IX2ZSV=IX2ZSW
          IY1ZSV=IY1ZSW
          IY2ZSV=IY2ZSW
          PX1LD2=PX1LDS
          PX2LD2=PX2LDS
          PY1LD2=PY1LDS
          PY1LA2=PY1LAN
          IY1LJ2=IY1LJU
          IY1LD2=IY1LDI
          IX1FSV=IX1FSW
          IX2FSV=IX2FSW
          IY1FSV=IY1FSW
          IY2FSV=IY2FSW
          PX1ZD2=PX1ZDS
          PX2ZD2=PX2ZDS
          PY1ZD2=PY1ZDS
          PY2ZD2=PY2ZDS
          DO1010I=1,100
            ICHAP2(I)=ICHAPA(I)
            ILINP2(I)=ILINPA(I)
            IBARS2(I)=IBARSW(I)
            ISPIS2(I)=ISPISW(I)
 1010     CONTINUE
C
          DO1020I=1,MAXCH
            IX1LT2(I)=IX1LTE(I)
            IX2LT2(I)=IX2LTE(I)
            IY1LT2(I)=IY1LTE(I)
            IY2LT2(I)=IY2LTE(I)
 1020     CONTINUE
          NCX1L2=NCX1LA
          NCX2L2=NCX2LA
          NCY1L2=NCY1LA
          NCY2L2=NCY2LA
C
          DO1030I=1,MAXCH
            ITITSV(I)=ITITTE(I)
 1030     CONTINUE
          NCTITS=NCTITL
          PTITDZ=PTITDS
C
C           **********************************************************
C           **  STEP 3--SAVE PLOT CONTROL SETTINGS FOR OVERLAID PLOT *
C           **********************************************************
C
        ELSEIF(IFLAG.EQ.3)THEN
C
          DO3010I=1,MAXSUB
            ISU2SW(I)=ISUBSW(I)
            ISUBSW(I)='OFF'
 3010     CONTINUE
C
          DO3020I=1,100
            ILI2CO(I)=ILINCO(I)
            PLI2TH(I)=PLINTH(I)
            ICH2PO(I)=ICHAPO(I)
            ICH2FO(I)=ICHAFO(I)
            ICH2CA(I)=ICHACA(I)
            ICH2JU(I)=ICHAJU(I)
            ICH2DI(I)=ICHADI(I)
            ICH2FI(I)=ICHAFI(I)
            ICH2CO(I)=ICHACO(I)
            PCH2HE(I)=PCHAHE(I)
            PCH2WI(I)=PCHAWI(I)
            PCH2VG(I)=PCHAVG(I)
            PCH2HG(I)=PCHAHG(I)
            PCH2HO(I)=PCHAHO(I)
            PCH2VO(I)=PCHAVO(I)
            ACH2AN(I)=ACHAAN(I)
 3020     CONTINUE
C
          GY1MIN=FY1MNZ
          GY1MAX=FY1MXZ
          GY2MIN=GY1MIN
          GY2MAX=GY1MAX
          GX1MIN=FX1MNZ
          GX1MAX=FX1MXZ
          GX2MIN=GX1MIN
          GX2MAX=GX1MAX
          IY1MIN='FIXE'
          IY1MAX='FIXE'
          IY2MIN='FIXE'
          IY2MAX='FIXE'
          IX1MIN='FIXE'
          IX1MAX='FIXE'
          IX2MIN='FIXE'
          IX2MAX='FIXE'
          IX1TSW='OFF'
          IX1ZSW='OFF'
          IX2TSW='OFF'
          IX2ZSW='OFF'
          IY1TSW='OFF'
          IY1ZSW='OFF'
          IY2TSW='OFF'
          IY2ZSW='OFF'
C
          ICHAPA(1)=ICHAP2(ITEMP)
          ILINPA(1)=ILINP2(ITEMP)
          ILINCO(1)=ILI2CO(ITEMP)
          PLINTH(1)=PLI2TH(ITEMP)
          ICHAPO(1)=ICH2PO(ITEMP)
          ICHAFO(1)=ICH2FO(ITEMP)
          ICHACA(1)=ICH2CA(ITEMP)
          ICHAJU(1)=ICH2JU(ITEMP)
          ICHADI(1)=ICH2DI(ITEMP)
          ICHAFI(1)=ICH2FI(ITEMP)
          ICHACO(1)=ICH2CO(ITEMP)
          PCHAHE(1)=PCH2HE(ITEMP)
          PCHAWI(1)=PCH2WI(ITEMP)
          PCHAVG(1)=PCH2VG(ITEMP)
          PCHAHG(1)=PCH2HG(ITEMP)
          PCHAHO(1)=PCH2HO(ITEMP)
          PCHAVO(1)=PCH2VO(ITEMP)
          ACHAAN(1)=ACH2AN(ITEMP)
        ENDIF
      ELSEIF(IFLAG.EQ.2 .OR. IFLAG.EQ.4)THEN
C
        IOP='CLOS'
        IFLAG1=0
        IFLAG2=0
        IFLAG3=0
        IFLAG4=0
        IFLAG5=1
        IF(IOUNI5.GE.1)THEN
          CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1                IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1                IBUGG2,ISUBRO,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
        ENDIF
C
        GX1MIN=GX1MNS
        GX1MAX=GX1MXS
        GX2MIN=GX2MNS
        GX2MAX=GX2MXS
        GY1MIN=GY1MNS
        GY1MAX=GY1MXS
        GY2MIN=GY2MNS
        GY2MAX=GY2MXS
C
        IX1MIN=IX1MNS
        IX1MAX=IX1MXS
        IX2MIN=IX2MNS
        IX2MAX=IX2MXS
        IY1MIN=IY1MNS
        IY1MAX=IY1MXS
        IY2MIN=IY2MNS
        IY2MAX=IY2MXS
C
C         *********************************************************
C         **  STEP 2--RESTORE PLOT CONTROL SETTINGS FOR INITIAL  **
C         **          PLOT                                       **
C         *********************************************************
C
        IF(IFLAG.EQ.2)THEN
C
          PWXMIN=PWXMN2
          PWXMAX=PWXMX2
          PWYMIN=PWYMN2
          PWYMAX=PWYMX2
          PXMIN=PXMN2
          PXMAX=PXMX2
          PYMIN=PYMN2
          PYMAX=PYMX2
C
          IERASW=IERAS2
          IFENSW=IFENC2
          ISORSW=ISORS2
          IPPTBI=IPPTB2
C
          IX1TSW=IX1TSV
          IX2TSW=IX2TSV
          IY1TSW=IY1TSV
          IY2TSW=IY2TSV
          IX1ZSW=IX1ZSV
          IX2ZSW=IX2ZSV
          IY1ZSW=IY1ZSV
          IY2ZSW=IY2ZSV
          PX1LDS=PX1LD2
          PX2LDS=PX2LD2
          PY1LDS=PY1LD2
          PY1LAN=PY1LA2
          IY1LJU=IY1LJ2
          IY1LDI=IY1LD2
          PX1ZDS=PX1ZD2
          PX2ZDS=PX2ZD2
          PY1ZDS=PY1ZD2
          PY2ZDS=PY2ZD2
C
          DO2010I=1,100
            ICHAPA(I)=ICHAP2(I)
            ILINPA(I)=ILINP2(I)
            IBARSW(I)=IBARS2(I)
            ISPISW(I)=ISPIS2(I)
 2010   CONTINUE
C
          IMPSW='OFF'
          IMPCO=1
          IMPNR=IMPNR2
          IMPNC=IMPNC2
C
          DO2020I=1,MAXCH
            IX1LTE(I)=IX1LT2(I)
            IX2LTE(I)=IX2LT2(I)
            IY1LTE(I)=IY1LT2(I)
            IY2LTE(I)=IY2LT2(I)
 2020   CONTINUE
          NCX1LA=NCX1L2
          NCX2LA=NCX2L2
          NCY1LA=NCY1L2
          NCY2LA=NCY2L2
          DO2030I=1,MAXCH
            ITITTE(I)=ITITSV(I)
 2030     CONTINUE
          NCTITL=NCTITS
          PTITDS=PTITDZ
C
C           **********************************************************
C           **  STEP 4--RESTORE PLOT CONTROL SETTINGS FOR OVERLAID  **
C           **          PLOT                                        **
C           **********************************************************
C
        ELSEIF(IFLAG.EQ.4)THEN
C
          DO4010I=1,100
            ILINCO(I)=ILI2CO(I)
            PLINTH(I)=PLI2TH(I)
            ICHAPO(I)=ICH2PO(I)
            ICHAFO(I)=ICH2FO(I)
            ICHACA(I)=ICH2CA(I)
            ICHAJU(I)=ICH2JU(I)
            ICHADI(I)=ICH2DI(I)
            ICHAFI(I)=ICH2FI(I)
            ICHACO(I)=ICH2CO(I)
            PCHAHE(I)=PCH2HE(I)
            PCHAWI(I)=PCH2WI(I)
            PCHAVG(I)=PCH2VG(I)
            PCHAHG(I)=PCH2HG(I)
            PCHAHO(I)=PCH2HO(I)
            PCHAVO(I)=PCH2VO(I)
            ACHAAN(I)=ACH2AN(I)
 4010     CONTINUE
        ENDIF
C
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'SPM2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSPM5--')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSPPA(IHARG,IHARG2,NUMARG,IDEFSL,MAXSPI,ISPILI,
CCCCC AUGUST 1995.  ADD IHARG2 FOR DASH2, ETC
CCCCC SUBROUTINE DPSPPA(IHARG,NUMARG,IDEFSL,MAXSPI,ISPILI,
     1IBUGP2,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE SPIKE LINE PATTERNS.
C              THESE ARE LOCATED IN THE VECTOR ISPILI(.).
C     INPUT  ARGUMENTS--IHARG  (A  CHARACTER VECTOR)
C                     --NUMARG
C                     --IDEFSL
C                     --MAXSPI
C                     --IBUGP2 ('ON' OR 'OFF' )
C     OUTPUT ARGUMENTS--ISPILI (A CHARACTER VECTOR)
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--DECEMBER  1983.
C     UPDATED         --AUGUST    1995.  DASH2 BUG
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
CCCCC AUGUST 1995.  ADD FOLLOWING LINE
      CHARACTER*4 IHARG2
      CHARACTER*4 IDEFSL
      CHARACTER*4 ISPILI
C
      CHARACTER*4 IBUGP2
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHOLD1
      CHARACTER*4 IHOLD2
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      DIMENSION IHARG(*)
CCCCC AUGUST 1995.  ADD FOLLOWING LINE
      DIMENSION IHARG2(*)
      DIMENSION ISPILI(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      ISUBN1='DPSP'
      ISUBN2='PA  '
C
      NUMSPI=0
      IHOLD1='-999'
      IHOLD2='-999'
C
      IF(IBUGP2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPSPPA--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGP2,IFOUND,IERROR
   52 FORMAT('IBUGP2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)MAXSPI,NUMSPI
   53 FORMAT('MAXSPI,NUMSPI = ',I8,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IHOLD1,IHOLD2
   54 FORMAT('IHOLD1,IHOLD2 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IDEFSL
   55 FORMAT('IDEFSL = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,60)NUMARG
   60 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO65I=1,NUMARG
      WRITE(ICOUT,66)IHARG(I)
   66 FORMAT('IHARG(I) = ',A4)
      CALL DPWRST('XXX','BUG ')
   65 CONTINUE
      WRITE(ICOUT,70)ISPILI(1)
   70 FORMAT('ISPILI(1) = ',A4)
      CALL DPWRST('XXX','BUG ')
      DO75I=1,10
      WRITE(ICOUT,76)I,ISPILI(I)
   76 FORMAT('I,ISPILI(I) = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
   75 CONTINUE
   90 CONTINUE
C
C               **************************************
C               **  STEP 1--                        **
C               **  BRANCH TO THE APPROPRIATE CASE  **
C               **************************************
C
      ISTEPN='1'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.0)GOTO1100
      IF(NUMARG.EQ.1)GOTO1110
      IF(NUMARG.EQ.2)GOTO1120
      GOTO1130
C
 1100 CONTINUE
      GOTO1200
C
 1110 CONTINUE
      IF(IHARG(1).EQ.'ALL')IHOLD1='    '
      IF(IHARG(1).EQ.'ALL')GOTO1300
      GOTO1200
C
 1120 CONTINUE
CCCCC IF(IHARG(1).EQ.'ALL')IHOLD1=IHARG(2)
CCCCC IF(IHARG(1).EQ.'ALL')GOTO1300
CCCCC IF(IHARG(2).EQ.'ALL')IHOLD1=IHARG(1)
CCCCC IF(IHARG(2).EQ.'ALL')GOTO1300
CCCCC APRIL 1996.  CHANGE IHOLD TO IHOLD1 BELOW
      IF(IHARG(1).EQ.'ALL')THEN
        IHOLD1=IHARG(2)
        IF(IHOLD1.EQ.'DASH'.AND.IHARG2(2).EQ.'2')IHOLD1='DA2'
        IF(IHOLD1.EQ.'DASH'.AND.IHARG2(2).EQ.'3')IHOLD1='DA3'
        IF(IHOLD1.EQ.'DASH'.AND.IHARG2(2).EQ.'4')IHOLD1='DA4'
        IF(IHOLD1.EQ.'DASH'.AND.IHARG2(2).EQ.'5')IHOLD1='DA5'
        GOTO1300
      ENDIF
      IF(IHARG(2).EQ.'ALL')THEN
        IHOLD1=IHARG(1)
        IF(IHOLD1.EQ.'DASH'.AND.IHARG2(1).EQ.'2')IHOLD1='DA2'
        IF(IHOLD1.EQ.'DASH'.AND.IHARG2(1).EQ.'3')IHOLD1='DA3'
        IF(IHOLD1.EQ.'DASH'.AND.IHARG2(1).EQ.'4')IHOLD1='DA4'
        IF(IHOLD1.EQ.'DASH'.AND.IHARG2(1).EQ.'5')IHOLD1='DA5'
        GOTO1300
      ENDIF
      GOTO1200
C
 1130 CONTINUE
      GOTO1200
C
C               *************************************************
C               **  STEP 2--                                   **
C               **  TREAT THE INDIVIDUAL SPECIFICATIONS CASE  **
C               *************************************************
C
 1200 CONTINUE
      ISTEPN='2'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.0)GOTO1210
      GOTO1220
C
 1210 CONTINUE
      NUMSPI=1
      ISPILI(1)='    '
      GOTO1270
C
 1220 CONTINUE
      NUMSPI=NUMARG
      IF(NUMSPI.GT.MAXSPI)NUMSPI=MAXSPI
      DO1225I=1,NUMSPI
      J=I
      IHOLD1=IHARG(J)
      IF(IHOLD1.EQ.'DASH'.AND.IHARG2(J).EQ.'2')IHOLD1='DA2'
      IF(IHOLD1.EQ.'DASH'.AND.IHARG2(J).EQ.'3')IHOLD1='DA3'
      IF(IHOLD1.EQ.'DASH'.AND.IHARG2(J).EQ.'4')IHOLD1='DA4'
      IF(IHOLD1.EQ.'DASH'.AND.IHARG2(J).EQ.'5')IHOLD1='DA5'
      IHOLD2=IHOLD1
      IF(IHOLD1.EQ.'ON')IHOLD2='SOLI'
      IF(IHOLD1.EQ.'OFF')IHOLD2='    '
      IF(IHOLD1.EQ.'AUTO')IHOLD2=IDEFSL
      IF(IHOLD1.EQ.'DEFA')IHOLD2=IDEFSL
      ISPILI(I)=IHOLD2
 1225 CONTINUE
      GOTO1270
C
 1270 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO1279
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      DO1278I=1,NUMSPI
      WRITE(ICOUT,1276)I,ISPILI(I)
 1276 FORMAT('SPIKE ',I6,' HAS JUST BEEN SET TO ',
     1A4)
      CALL DPWRST('XXX','BUG ')
 1278 CONTINUE
 1279 CONTINUE
      IFOUND='YES'
      GOTO9000
C
C               **************************
C               **  STEP 2--            **
C               **  TREAT THE ALL CASE  **
C               **************************
C
 1300 CONTINUE
      ISTEPN='3'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NUMSPI=MAXSPI
      IHOLD2=IHOLD1
      IF(IHOLD1.EQ.'ON')IHOLD2='SOLI'
      IF(IHOLD1.EQ.'OFF')IHOLD2='    '
      IF(IHOLD1.EQ.'AUTO')IHOLD2=IDEFSL
      IF(IHOLD1.EQ.'DEFA')IHOLD2=IDEFSL
      DO1315I=1,NUMSPI
      ISPILI(I)=IHOLD2
 1315 CONTINUE
      GOTO1370
C
 1370 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO1319
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      I=1
      WRITE(ICOUT,1316)ISPILI(I)
 1316 FORMAT('ALL SPIKES HAVE JUST BEEN SET TO ',
     1A4)
      CALL DPWRST('XXX','BUG ')
 1319 CONTINUE
      IFOUND='YES'
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGP2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPSPPA--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGP2,IFOUND,IERROR
 9012 FORMAT('IBUGP2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)MAXSPI,NUMSPI
 9013 FORMAT('MAXSPI,NUMSPI = ',I8,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IHOLD1,IHOLD2
 9014 FORMAT('IHOLD1,IHOLD2 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IDEFSL
 9015 FORMAT('IDEFSL = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9020)NUMARG
 9020 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9025I=1,NUMARG
      WRITE(ICOUT,9026)IHARG(I)
 9026 FORMAT('IHARG(I) = ',A4)
      CALL DPWRST('XXX','BUG ')
 9025 CONTINUE
      WRITE(ICOUT,9030)ISPILI(1)
 9030 FORMAT('ISPILI(1) = ',A4)
      CALL DPWRST('XXX','BUG ')
      DO9035I=1,10
      WRITE(ICOUT,9036)I,ISPILI(I)
 9036 FORMAT('I,ISPILI(I) = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9035 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPSPSM(X,N,XS,ICHANG,IBUGG3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE TAKES THE DATA IN THE VECTOR X,
C              DETERMINES THE VARIOUS MESAS,
C              AND APPLIES A 3-TERM MEDIAN SMOOTH TO THE DATA
C              BETWEEN EACH MESA.
C     OUTPUT ARGUMENTS--XS     = THE SINGLE PRECISION VECTOR
C                                CONTAINING SMOOTHED VALUES.
C                     --ICHANG = THE CHARACTER VARIABLE
C                                CONTAINING EITHER YES OR NO
C                                DEPENDING ON WHETHER OR NOT THE
C                                SMOOTHED DATA IS CHANGED OR NOT
C                                FROM THE ORIGINAL DATA.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VECTOR
C             OF SMOOTHED VALUES.
C     NOTE--THE VECTOR X REMAINS UNCHANGED.
C     ASSUMPTION--THE VECTOR X HAS AT LEAST 3 VALUES.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--MCNEIL, INTERACTIVE DATA ANALYSIS
C                 1977, PAGE 146
C                 (= SOURCE OF ALGORITHM).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION--JULY      1983.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICHANG
C
      CHARACTER*4 IBUGG3
      CHARACTER*4 IERROR
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION XS(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='NO'
C
      IF(IBUGG3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPSPSM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGG3
   52 FORMAT('IBUGG3 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)N
   53 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,N
      WRITE(ICOUT,56)I,X(I)
   56 FORMAT('I,X(I) = ',I8,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
   90 CONTINUE
C
C               *********************************************
C               **  SPLIT THE DATA AT EACH MESA            **
C               **  AND THEN APPLY A 3-TERM MEDIAN SMOOTH  **
C               **  TO THE SUBSET OF THE DATA              **
C               **  BETWEEN EACH MESA.                     **
C               *********************************************
C
C               ****************************************
C               **  STEP 1--                          **
C               **  COPY THE DATA FROM X(.) TO XS(.)  **
C               ****************************************
C
      DO1100I=1,N
      XS(I)=X(I)
 1100 CONTINUE
C
C               ********************************
C               **  STEP 2--                  **
C               **  SEARCH FOR A MESA IN THE  **
C               **  FIRST 3 OBSERVATIONS      **
C               ********************************
C
      IF(X(2).NE.X(3))GOTO1290
      IF(X(1).LE.X(2).AND.X(3).LE.X(4))GOTO1290
      IF(X(1).GE.X(2).AND.X(3).GE.X(4))GOTO1290
      XS(2)=X(1)
      ARG1=X(3)
      ARG2=X(4)
      ARG3=3*X(4)-2*X(5)
      CALL DPMED3(ARG1,ARG2,ARG3,XMED3,IBUGG3,IERROR)
      XS(3)=XMED3
 1290 CONTINUE
C
C               ***********************************
C               **  STEP 3--                     **
C               **  SEARCH FOR MESAS             **
C               **  IN THE MIDDLE OF THE SERIES  **
C               ***********************************
C
      NM2=N-2
      IF(3.GT.NM2)GOTO1390
      DO1300I=3,NM2
C
      IM2=I-2
      IM1=I-1
      IP1=I+1
      IP2=I+2
      IP3=I+3
C
      IF(X(I).NE.X(IP1))GOTO1300
      IF(X(IM1).LE.X(I).AND.X(IP1).LE.X(IP2))GOTO1300
      IF(X(IM1).GE.X(I).AND.X(IP1).GE.X(IP2))GOTO1300
C
      ARG1=X(I)
      ARG2=X(IM1)
      ARG3=3*X(IM1)-2*X(IM2)
      CALL DPMED3(ARG1,ARG2,ARG3,XMED3,IBUGG3,IERROR)
      XS(I)=XMED3
C
      ARG1=X(IP1)
      ARG2=X(IP2)
      ARG3=3*X(IP2)-2*X(IP3)
      CALL DPMED3(ARG1,ARG2,ARG3,XMED3,IBUGG3,IERROR)
      XS(IP1)=XMED3
C
 1300 CONTINUE
 1390 CONTINUE
C
C               ********************************
C               **  STEP 4--                  **
C               **  SEARCH FOR A MESA IN THE  **
C               **  LAST  3 OBSERVATIONS      **
C               ********************************
C
      NM1=N-1
      NM2=N-2
      NM3=N-3
      NM4=N-4
      IF(X(NM1).NE.X(NM2))GOTO1490
      IF(X(N).LE.X(NM1).AND.X(NM2).LE.X(NM3))GOTO1490
      IF(X(N).GE.X(NM1).AND.X(NM2).GE.X(NM3))GOTO1490
      XS(NM1)=X(N)
      ARG1=X(NM2)
      ARG2=X(NM3)
      ARG3=3*X(NM3)-2*X(NM4)
      CALL DPMED3(ARG1,ARG2,ARG3,XMED3,IBUGG3,IERROR)
      XS(NM2)=XMED3
 1490 CONTINUE
C               *********************************************
C               **  STEP 5--                               **
C               **  CHECK TO SEE IF A CHANGE HAS OCCURRED  **
C               **  BETWEEN THE RAW DATA AND               **
C               **  THE SPLIT & SMOOTHED DATA.             **
C               *********************************************
C
      ICHANG='NO'
      DO1500I=1,N
      IF(XS(I).NE.X(I))GOTO1510
 1500 CONTINUE
      GOTO1590
 1510 CONTINUE
      ICHANG='YES'
 1590 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPSPSM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGG3
 9012 FORMAT('IBUGG3 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)ICHANG
 9013 FORMAT('ICHANG = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)N
 9014 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9015I=1,N
      WRITE(ICOUT,9016)I,X(I),XS(I)
 9016 FORMAT('I,X(I),XS(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
 9015 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPSPSW(IHARG,NUMARG,IDEFSS,MAXSPI,ISPISW,
     1IBUGP2,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE SPIKE SWITCHES.
C              THESE ARE LOCATED IN THE VECTOR ISPISW(.).
C     INPUT  ARGUMENTS--IHARG  (A  CHARACTER VECTOR)
C                     --NUMARG
C                     --IDEFSS
C                     --MAXSPI
C                     --IBUGP2 ('ON' OR 'OFF' )
C     OUTPUT ARGUMENTS--ISPISW (A CHARACTER VECTOR)
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--DECEMBER  1983.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IDEFSS
      CHARACTER*4 ISPISW
C
      CHARACTER*4 IBUGP2
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHOLD1
      CHARACTER*4 IHOLD2
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      DIMENSION IHARG(*)
      DIMENSION ISPISW(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      ISUBN1='DPSP'
      ISUBN2='SW  '
C
      NUMSPI=0
      IHOLD1='-999'
      IHOLD2='-999'
C
      IF(IBUGP2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPSPSW--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGP2,IFOUND,IERROR
   52 FORMAT('IBUGP2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)MAXSPI,NUMSPI
   53 FORMAT('MAXSPI,NUMSPI = ',I8,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IHOLD1,IHOLD2
   54 FORMAT('IHOLD1,IHOLD2 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IDEFSS
   55 FORMAT('IDEFSS = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,60)NUMARG
   60 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO65I=1,NUMARG
      WRITE(ICOUT,66)IHARG(I)
   66 FORMAT('IHARG(I) = ',A4)
      CALL DPWRST('XXX','BUG ')
   65 CONTINUE
      WRITE(ICOUT,70)ISPISW(1)
   70 FORMAT('ISPISW(1) = ',A4)
      CALL DPWRST('XXX','BUG ')
      DO75I=1,10
      WRITE(ICOUT,76)I,ISPISW(I)
   76 FORMAT('I,ISPISW(I) = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
   75 CONTINUE
   90 CONTINUE
C
C               **************************************
C               **  STEP 1--                        **
C               **  BRANCH TO THE APPROPRIATE CASE  **
C               **************************************
C
      ISTEPN='1'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.0)GOTO1100
      IF(NUMARG.EQ.1)GOTO1110
      IF(NUMARG.EQ.2)GOTO1120
      GOTO1130
C
 1100 CONTINUE
      GOTO1200
C
 1110 CONTINUE
      IF(IHARG(1).EQ.'ALL')IHOLD1='OFF'
      IF(IHARG(1).EQ.'ALL')GOTO1300
      GOTO1200
C
 1120 CONTINUE
      IF(IHARG(1).EQ.'ALL')IHOLD1=IHARG(2)
      IF(IHARG(1).EQ.'ALL')GOTO1300
      IF(IHARG(2).EQ.'ALL')IHOLD1=IHARG(1)
      IF(IHARG(2).EQ.'ALL')GOTO1300
      GOTO1200
C
 1130 CONTINUE
      GOTO1200
C
C               *************************************************
C               **  STEP 2--                                   **
C               **  TREAT THE INDIVIDUAL SPECIFICATIONS CASE  **
C               *************************************************
C
 1200 CONTINUE
      ISTEPN='2'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.0)GOTO1210
      GOTO1220
C
 1210 CONTINUE
      NUMSPI=1
      ISPISW(1)='ON'
      GOTO1270
C
 1220 CONTINUE
      NUMSPI=NUMARG
      IF(NUMSPI.GT.MAXSPI)NUMSPI=MAXSPI
      DO1225I=1,NUMSPI
      J=I
      IHOLD1=IHARG(J)
      IHOLD2=IHOLD1
      IF(IHOLD1.EQ.'ON')IHOLD2='ON'
      IF(IHOLD1.EQ.'OFF')IHOLD2='OFF'
CCCCC IF(IHOLD1.EQ.'AUTO')IHOLD2=IDEFSS
CCCCC IF(IHOLD1.EQ.'DEFA')IHOLD2=IDEFSS
      ISPISW(I)=IHOLD2
 1225 CONTINUE
      GOTO1270
C
 1270 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO1279
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      DO1278I=1,NUMSPI
      WRITE(ICOUT,1276)I,ISPISW(I)
 1276 FORMAT('SPIKE ',I6,' HAS JUST BEEN SET TO ',
     1A4)
      CALL DPWRST('XXX','BUG ')
 1278 CONTINUE
 1279 CONTINUE
      IFOUND='YES'
      GOTO9000
C
C               **************************
C               **  STEP 2--            **
C               **  TREAT THE ALL CASE  **
C               **************************
C
 1300 CONTINUE
      ISTEPN='3'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NUMSPI=MAXSPI
      IHOLD2=IHOLD1
      IF(IHOLD1.EQ.'ON')IHOLD2='ON'
      IF(IHOLD1.EQ.'OFF')IHOLD2='OFF'
CCCCC IF(IHOLD1.EQ.'AUTO')IHOLD2=IDEFSS
CCCCC IF(IHOLD1.EQ.'DEFA')IHOLD2=IDEFSS
      DO1315I=1,NUMSPI
      ISPISW(I)=IHOLD2
 1315 CONTINUE
      GOTO1370
C
 1370 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO1319
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      I=1
      WRITE(ICOUT,1316)ISPISW(I)
 1316 FORMAT('ALL SPIKES HAVE JUST BEEN SET TO ',
     1A4)
      CALL DPWRST('XXX','BUG ')
 1319 CONTINUE
      IFOUND='YES'
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGP2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPSPSW--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGP2,IFOUND,IERROR
 9012 FORMAT('IBUGP2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)MAXSPI,NUMSPI
 9013 FORMAT('MAXSPI,NUMSPI = ',I8,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IHOLD1,IHOLD2
 9014 FORMAT('IHOLD1,IHOLD2 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IDEFSS
 9015 FORMAT('IDEFSS = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9020)NUMARG
 9020 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9025I=1,NUMARG
      WRITE(ICOUT,9026)IHARG(I)
 9026 FORMAT('IHARG(I) = ',A4)
      CALL DPWRST('XXX','BUG ')
 9025 CONTINUE
      WRITE(ICOUT,9030)ISPISW(1)
 9030 FORMAT('ISPISW(1) = ',A4)
      CALL DPWRST('XXX','BUG ')
      DO9035I=1,10
      WRITE(ICOUT,9036)I,ISPISW(I)
 9036 FORMAT('I,ISPISW(I) = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9035 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPSPTH(IHARG,IARGT,ARG,NUMARG,PDEFST,MAXSPI,PSPITH,
     1IBUGP2,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE SPIKE THICKNESSES.
C              THESE ARE LOCATED IN THE VECTOR PSPITH(.).
C     INPUT  ARGUMENTS--IHARG  (A  CHARACTER VECTOR)
C                     --IARGT  (A  CHARACTER VECTOR)
C                     --ARG
C                     --NUMARG
C                     --PDEFST
C                     --MAXSPI
C                     --IBUGP2 ('ON' OR 'OFF' )
C     OUTPUT ARGUMENTS--PSPITH (A FLOATING POINT VECTOR)
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--DECEMBER  1983.
C     UPDATED         --JANUARY   1989.  ERROR IN FORMAT STATEMENT (ALAN)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IARGT
C
      CHARACTER*4 IBUGP2
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHOLD1
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      DIMENSION IHARG(*)
      DIMENSION IARGT(*)
      DIMENSION ARG(*)
      DIMENSION PSPITH(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      ISUBN1='DPSP'
      ISUBN2='TH  '
C
      NUMSPI=0
      IHOLD1='-999'
      HOLD1=-999.0
      HOLD2=-999.0
C
      IF(IBUGP2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPSPTH--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGP2,IFOUND,IERROR
   52 FORMAT('IBUGP2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)MAXSPI,NUMSPI
   53 FORMAT('MAXSPI,NUMSPI = ',I8,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IHOLD1,HOLD1,HOLD2
   54 FORMAT('IHOLD1,HOLD1,HOLD2 = ',A4,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)PDEFST
   55 FORMAT('PDEFST = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,60)NUMARG
   60 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO65I=1,NUMARG
      WRITE(ICOUT,66)IHARG(I),IARGT(I),ARG(I)
   66 FORMAT('IHARG(I),IARGT(I),ARG(I) = ',A4,2X,A4,I8)
      CALL DPWRST('XXX','BUG ')
   65 CONTINUE
      WRITE(ICOUT,70)PSPITH(1)
   70 FORMAT('PSPITH(1) = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      DO75I=1,10
      WRITE(ICOUT,76)I,PSPITH(I)
   76 FORMAT('I,PSPITH(I) = ',I8,2X,E15.7)
      CALL DPWRST('XXX','BUG ')
   75 CONTINUE
   90 CONTINUE
C
C               **************************************
C               **  STEP 1--                        **
C               **  BRANCH TO THE APPROPRIATE CASE  **
C               **************************************
C
      ISTEPN='1'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.0)GOTO9000
      IF(NUMARG.EQ.1)GOTO1110
      IF(NUMARG.EQ.2)GOTO1120
      IF(NUMARG.EQ.3)GOTO1130
      GOTO1140
C
 1110 CONTINUE
      GOTO1200
C
 1120 CONTINUE
      IF(IHARG(2).EQ.'ALL')IHOLD1='    '
      IF(IHARG(2).EQ.'ALL')HOLD1=PDEFST
      IF(IHARG(2).EQ.'ALL')GOTO1300
      GOTO1200
C
 1130 CONTINUE
      IF(IHARG(2).EQ.'ALL')IHOLD1=IHARG(3)
      IF(IHARG(2).EQ.'ALL')HOLD1=ARG(3)
      IF(IHARG(2).EQ.'ALL')GOTO1300
      IF(IHARG(3).EQ.'ALL')IHOLD1=IHARG(2)
      IF(IHARG(3).EQ.'ALL')HOLD1=ARG(2)
      IF(IHARG(3).EQ.'ALL')GOTO1300
      GOTO1200
C
 1140 CONTINUE
      GOTO1200
C
C               *************************************************
C               **  STEP 2--                                   **
C               **  TREAT THE INDIVIDUAL SPECIFICATIONS CASE  **
C               *************************************************
C
 1200 CONTINUE
      ISTEPN='2'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.1)GOTO1210
      GOTO1220
C
 1210 CONTINUE
      NUMSPI=1
      PSPITH(1)=PDEFST
      GOTO1270
C
 1220 CONTINUE
      NUMSPI=NUMARG-1
      IF(NUMSPI.GT.MAXSPI)NUMSPI=MAXSPI
      DO1225I=1,NUMSPI
      J=I+1
      IHOLD1=IHARG(J)
      HOLD1=ARG(J)
      HOLD2=HOLD1
      IF(IHOLD1.EQ.'ON')HOLD2=PDEFST
      IF(IHOLD1.EQ.'OFF')HOLD2=PDEFST
      IF(IHOLD1.EQ.'AUTO')HOLD2=PDEFST
      IF(IHOLD1.EQ.'DEFA')HOLD2=PDEFST
      PSPITH(I)=HOLD2
 1225 CONTINUE
      GOTO1270
C
 1270 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO1279
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      DO1278I=1,NUMSPI
      WRITE(ICOUT,1276)I,PSPITH(I)
 1276 FORMAT('SPIKE THICKNESS ',I6,' HAS JUST BEEN SET TO ',
     1E15.7)
      CALL DPWRST('XXX','BUG ')
 1278 CONTINUE
 1279 CONTINUE
      IFOUND='YES'
      GOTO9000
C
C               **************************
C               **  STEP 2--            **
C               **  TREAT THE ALL CASE  **
C               **************************
C
 1300 CONTINUE
      ISTEPN='3'
      IF(IBUGP2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NUMSPI=MAXSPI
      HOLD2=HOLD1
      IF(IHOLD1.EQ.'ON')HOLD2=PDEFST
      IF(IHOLD1.EQ.'OFF')HOLD2=PDEFST
      IF(IHOLD1.EQ.'AUTO')HOLD2=PDEFST
      IF(IHOLD1.EQ.'DEFA')HOLD2=PDEFST
      DO1315I=1,NUMSPI
      PSPITH(I)=HOLD2
 1315 CONTINUE
      GOTO1370
C
 1370 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO1319
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      I=1
      WRITE(ICOUT,1316)PSPITH(I)
 1316 FORMAT('ALL SPIKE THICKNESSES HAVE JUST BEEN SET TO ',
     1E15.7)
      CALL DPWRST('XXX','BUG ')
 1319 CONTINUE
      IFOUND='YES'
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGP2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPSPTH--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGP2,IFOUND,IERROR
 9012 FORMAT('IBUGP2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)MAXSPI,NUMSPI
 9013 FORMAT('MAXSPI,NUMSPI = ',I8,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IHOLD1,HOLD1,HOLD2
 9014 FORMAT('IHOLD1,HOLD1,HOLD2 = ',A4,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)PDEFST
 9015 FORMAT('PDEFST = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9020)NUMARG
 9020 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9025I=1,NUMARG
      WRITE(ICOUT,9026)IHARG(I),IARGT(I),ARG(I)
 9026 FORMAT('IHARG(I),IARGT(I),ARG(I) = ',A4,2X,A4,I8)
      CALL DPWRST('XXX','BUG ')
 9025 CONTINUE
      WRITE(ICOUT,9030)PSPITH(1)
 9030 FORMAT('PSPITH(1) = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      DO9035I=1,10
      WRITE(ICOUT,9036)I,PSPITH(I)
 9036 FORMAT('I,PSPITH(I) = ',I8,2X,E15.7)
      CALL DPWRST('XXX','BUG ')
 9035 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPSQRA(YTEMP,XTEMP,MAXNXT,
     1                  ICAPSW,IFORSW,
     1                  ISUBRO,IBUGA2,IBUGA3,IBUGQ,IFOUND,IERROR)
C
C     PURPOSE--CARRY OUT NONPARAMETRIC SQUARED RANKS TEST TO TEST FOR
C              EQUAL VARIANCES AMONG K GROUPS.
C     EXAMPLE--SQUARED RANKS TEST Y X
C     REFERENCE--CONOVER (1999), "PRACTICAL NONPARAMETRIC STATISTICS",
C                THIRD EDITION, WILEY, PP. 300-310.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2011/6
C     ORIGINAL VERSION--JUNE      2011.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA2
      CHARACTER*4 IBUGA3
      CHARACTER*4 IBUGQ
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IMULT
      CHARACTER*4 ICASAN
      CHARACTER*4 ICASA2
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 ICASE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ICTMP1
      CHARACTER*4 ICTMP2
      CHARACTER*4 ICTMP3
      CHARACTER*4 IFLAGU
      LOGICAL IFRST
      LOGICAL ILAST
C
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 IHOST1
      CHARACTER*4 ISUBN0
C
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=30)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      REAL PID(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
C---------------------------------------------------------------------
C
      DIMENSION YTEMP(*)
      DIMENSION XTEMP(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOZZ.INC'
      INCLUDE 'DPCOZD.INC'
C
      DIMENSION TEMP1(MAXOBV)
      DIMENSION TEMP2(MAXOBV)
      DIMENSION TEMP3(MAXOBV)
      DIMENSION TEMP4(MAXOBV)
      DOUBLE PRECISION DTEMP1(MAXOBV)
      DOUBLE PRECISION DTEMP2(MAXOBV)
C
      EQUIVALENCE(GARBAG(IGARB1),TEMP1(1))
      EQUIVALENCE(GARBAG(IGARB2),TEMP2(1))
      EQUIVALENCE(GARBAG(IGARB3),TEMP3(1))
      EQUIVALENCE(GARBAG(IGARB4),TEMP4(1))
      EQUIVALENCE(DGARBG(IDGAR1),DTEMP1(1))
      EQUIVALENCE(DGARBG(IDGAR2),DTEMP2(1))
C
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCOSU.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOST.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPSQ'
      ISUBN2='RA  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      IFOUND='YES'
      IERROR='NO'
C
C               ******************************************
C               **  TREAT THE SQUARED RANKS TEST CASE  **
C               ******************************************
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'SQRA')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSQRA--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA2,IBUGA3,IBUGQ,ISUBRO
   52   FORMAT('IBUGA2,IBUGA3,IBUGQ,ISUBRO = ',3(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,55)IMULT,IKRUGS,MAXNXT
   55   FORMAT('IMULT,IKRUGS,MAXNXT = ',2(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *********************************************************
C               **  STEP 1--                                           **
C               **  EXTRACT THE COMMAND                                **
C               *********************************************************
C
      ISTEPN='1'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'SQRA')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ILASTZ=9999
      ICASAN='SQRA'
      ICASA2='TWOT'
      IMULT='OFF'
C
C     LOOK FOR:
C
C          SQUARED RANKS TEST
C          LOWER TAILED
C          UPPER TAILED
C          MULTIPLE
C
      DO100I=0,NUMARG-1
C
        IF(I.EQ.0)THEN
          ICTMP1=ICOM
        ELSE
          ICTMP1=IHARG(I)
        ENDIF
        ICTMP2=IHARG(I+1)
        ICTMP3=IHARG(I+2)
C
        IF(ICTMP1.EQ.'=')THEN
          IFOUND='NO'
          GOTO9000
        ELSEIF(ICTMP1.EQ.'SQUA' .AND. ICTMP2.EQ.'RANK' .AND.
     1         ICTMP3.EQ.'TEST')THEN
          IFOUND='YES'
          ICASAN='SQRA'
          ILASTZ=I+2
        ELSEIF(ICTMP1.EQ.'SQUA' .AND. ICTMP2.EQ.'RANK')THEN
          IFOUND='YES'
          ICASAN='SQRA'
          ILASTZ=I+1
        ELSEIF(ICTMP1.EQ.'LOWE' .AND. ICTMP2.EQ.'TAIL')THEN
          ICASA2='LOWE'
          ILASTZ=MAX(ILASTZ,I+1)
        ELSEIF(ICTMP1.EQ.'UPPE' .AND. ICTMP2.EQ.'TAIL')THEN
          ICASA2='UPPE'
          ILASTZ=MAX(ILASTZ,I+1)
        ELSEIF(ICTMP1.EQ.'MULT')THEN
          IMULT='ON'
          ILASTZ=MAX(ILASTZ,I+1)
        ENDIF
  100 CONTINUE
C
      IF(IFOUND.EQ.'NO')GOTO9000
C
      ISHIFT=ILASTZ
      CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1            IBUGA2,IERROR)
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'SQRA')THEN
        WRITE(ICOUT,91)ICASAN,ICASA2,IMULT,ISHIFT
   91   FORMAT('DPSQRA: ICASAN,ICASA2,IMULT,ISHIFT = ',
     1         3(A4,2X),I5)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *********************************
C               **  STEP 2--                   **
C               **  EXTRACT THE VARIABLE LIST  **
C               *********************************
C
      ISTEPN='2'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'SQRA')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='SQARED RANK TEST'
      MAXNA=100
      MINNVA=2
      MAXNVA=MAXSPN
      MINNA=1
      IFLAGE=1
      IFLAGM=0
      IF(IMULT.EQ.'ON')THEN
        IFLAGE=0
        IFLAGM=1
        MAXNVA=MAXSPN
      ENDIF
      MINN2=2
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'SQRA')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,181)
  181   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,182)NQ,NUMVAR,IMULT
  182   FORMAT('NQ,NUMVAR,IMULT = ',2I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO185I=1,NUMVAR
            WRITE(ICOUT,187)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  187       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  185     CONTINUE
        ENDIF
      ENDIF
C
C               *******************************************************
C               **  STEP 3--                                         **
C               **  GENERATE THE SQUARED RANK   TEST FOR THE VARIOUS **
C               **  CASES                                            **
C               *******************************************************
C
      ISTEPN='3'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'SQRA')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C               *****************************************
C               **  STEP 3A--                          **
C               **  CASE 1: TWO RESPONSE VARIABLES     **
C               **          WITH NO REPLICATION        **
C               *****************************************
C
      IF(IMULT.EQ.'OFF')THEN
        ISTEPN='3A'
        IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'SQRA')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        ICOL=1
        NUMVA2=2
        CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1              INAME,IVARN1,IVARN2,IVARTY,
     1              ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1              MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1              MAXCP4,MAXCP5,MAXCP6,
     1              V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1              Y,X,X,NLOCAL,NLOCA2,NLOCA2,ICASE,
     1              IBUGA3,ISUBRO,IFOUND,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
C
C               ******************************************************
C               **  STEP 3B--
C               **  PREPARE FOR ENTRANCE INTO DPSQR2--
C               ******************************************************
C
        ISTEPN='3B'
        IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'SQRA')THEN
          CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,331)
  331     FORMAT('***** FROM DPSQRA, AS WE ARE ABOUT TO CALL DPSQR2--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,332)NLOCAL
  332     FORMAT('NLOCAL = ',I8)
          CALL DPWRST('XXX','BUG ')
          DO335I=1,NLOCAL
            WRITE(ICOUT,336)I,Y(I),X(I)
  336       FORMAT('I,Y(I),X(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','BUG ')
  335     CONTINUE
        ENDIF
C
        CALL DPSQR2(Y,X,NLOCAL,IVARN1,IVARN2,ICASA2,MAXNXT,
     1              TEMP1,TEMP2,TEMP3,TEMP4,DTEMP1,DTEMP2,
     1              STATVA,STATCD,PVAL,PVALLT,PVALUT,NDIST,
     1              CUT0,CUT50,CUT75,CUT90,CUT95,CUT975,
     1              CUT99,CUT999,
     1              CTL001,CTL005,CTL010,CTL025,CTL050,CTL100,
     1              CTL200,CTL500,
     1              CTU999,CTU995,CTU990,CT975,CTU950,CTU900,
     1              CTU800,CTU500,
     1              ICAPSW,ICAPTY,IFORSW,IMULT,IKRUGS,
     1              ISUBRO,IBUGA3,IERROR)
C
C               ***************************************
C               **  STEP 8C--                        **
C               **  UPDATE INTERNAL DATAPLOT TABLES  **
C               ***************************************
C
          ISTEPN='8C'
          IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'SQRA')
     1      CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
          IFLAGU='ON'
          IFRST=.TRUE.
          ILAST=.TRUE.
          IF(NDIST.EQ.2)THEN
            CALL DPMNN5(ICASA2,
     1                  STATVA,STATCD,
     1                  PVAL2T,PVALLT,PVALUT,
     1                  CTL001,CTL005,CTL010,CTL025,CTL050,CTL100,
     1                  CTU999,CTU995,CTU990,CT975,CTU950,CTU900,
     1                  IFLAGU,IFRST,ILAST,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
          ELSEIF(NDIST.GE.3)THEN
            CALL DPFRT5(STATVA,STATCD,PVAL,
     1                  CUT0,CUT50,CUT75,CUT90,CUT95,
     1                  CUT975,CUT99,CUT999,
     1                  IFLAGU,IFRST,ILAST,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
          ENDIF
C
C               *******************************************************
C               **  STEP 4A--                                        **
C               **  CASE 2: MULTIPLE RESPONSE VARIABLES.  NOTE THAT  **
C               **          FOR SQUARED RANKS TEST, THE MULTIPLE     **
C               **          LABS ARE CONVERTED INTO A "Y X" STACKED  **
C               **          PAIR WHERE "X" IS THE LAB-ID VARIABLE.   **
C               *******************************************************
C
      ELSEIF(IMULT.EQ.'ON')THEN
        ISTEPN='4A'
        IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'SQRA')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        ICOL=1
        NUMVA2=NUMVAR
        CALL DPPAR8(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1              INAME,IVARN1,IVARN2,IVARTY,
     1              ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1              MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1              MAXCP4,MAXCP5,MAXCP6,
     1              V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1              TEMP1,Y,X,NLOCAL,ICASE,
     1              IBUGA3,ISUBRO,IFOUND,IERROR)
        NUMVAR=2
        IF(IERROR.EQ.'YES')GOTO9000
C
        IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'SQRA')THEN
          ISTEPN='4B'
          CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,442)
  442     FORMAT('***** FROM THE MIDDLE  OF DPSQRA--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,443)ICASAN,NUMVAR,NLOCAL
  443     FORMAT('ICASAN,NUMVAR,NLOCAL = ',A4,2I8)
          CALL DPWRST('XXX','BUG ')
          IF(NLOCAL.GE.1)THEN
            DO445I=1,NLOCAL
              WRITE(ICOUT,446)I,Y(I),X(I)
  446         FORMAT('I,Y(I),X(I) = ',I8,2G15.7)
              CALL DPWRST('XXX','BUG ')
  445       CONTINUE
          ENDIF
        ENDIF
C
        CALL DPSQR2(Y,X,NLOCAL,IVARN1,IVARN2,ICASA2,MAXNXT,
     1              TEMP1,TEMP2,TEMP3,TEMP4,DTEMP1,DTEMP2,
     1              STATVA,STATCD,PVAL,PVALLT,PVALUT,NDIST,
     1              CUT0,CUT50,CUT75,CUT90,CUT95,CUT975,
     1              CUT99,CUT999,
     1              CTL001,CTL005,CTL010,CTL025,CTL050,CTL100,
     1              CTL200,CTL500,
     1              CTU999,CTU995,CTU990,CT975,CTU950,CTU900,
     1              CTU800,CTU500,
     1              ICAPSW,ICAPTY,IFORSW,IMULT,IKRUGS,
     1              ISUBRO,IBUGA3,IERROR)
C
C         ***************************************
C         **  STEP 8C--                        **
C         **  UPDATE INTERNAL DATAPLOT TABLES  **
C         ***************************************
C
          ISTEPN='8C'
          IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'SQRA')
     1      CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
          IFLAGU='ON'
          IFRST=.TRUE.
          ILAST=.TRUE.
          IF(NDIST.EQ.2)THEN
            CALL DPMNN5(ICASA2,
     1                  STATVA,STATCD,
     1                  PVAL2T,PVALLT,PVALUT,
     1                  CTL001,CTL005,CTL010,CTL025,CTL050,CTL100,
     1                  CTU999,CTU995,CTU990,CT975,CTU950,CTU900,
     1                  IFLAGU,IFRST,ILAST,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
          ELSEIF(NDIST.GE.3)THEN
            CALL DPFRT5(STATVA,STATCD,PVAL,
     1                  CUT0,CUT50,CUT75,CUT90,CUT95,
     1                  CUT975,CUT99,CUT999,
     1                  IFLAGU,IFRST,ILAST,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
          ENDIF
C
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'SQRA')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSQRA--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9014)NLOCAL,STATVA,STATCD
 9014   FORMAT('NLOCAL,STATVA,STATCD = ',I8,2G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)IFOUND,IERROR
 9016   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSQR2(Y,TAG,N,IVARID,IVARI2,ICASAN,MAXNXT,
     1                  TEMP1,TEMP2,TEMP3,TEMP4,DSUMSQ,DN,
     1                  STATVA,STATCD,PVAL,PVALLT,PVALUT,NDIST,
     1                  CUT0,CUT50,CUT75,CUT90,CUT95,CUT975,
     1                  CUT99,CUT999,
     1                  CTL001,CTL005,CTL010,CTL025,CTL050,CTL100,
     1                  CTL200,CTL500,
     1                  CTU999,CTU995,CTU990,CT975,CTU950,CTU900,
     1                  CTU800,CTU500,
     1                  ICAPSW,ICAPTY,IFORSW,IMULT,IKRUGS,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE CARRIES OUT A NONPARAMETRIC SQUARED RANKS
C              TEST FOR EQUAL VARIANCES
C     EXAMPLE--SQUARED RANK TEST Y TAG
C     REFERENCE--W. J. CONOVER, "PRACTICAL NONPARAMETRIC
C                STATISTICS", THIRD EDITION, 1999, WILEY,
C                PP. 300-310.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2011/6
C     ORIGINAL VERSION--JUNE      2011.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASAN
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IMULT
      CHARACTER*4 IKRUGS
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IVARID(*)
      CHARACTER*4 IVARI2(*)
C
      CHARACTER*4 IWRITE
      CHARACTER*3 IATEMP
      CHARACTER*4 ISUBN0
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 IOP
C
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DNTOT
      DOUBLE PRECISION D2
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION TAG(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION TEMP4(*)
C
      DOUBLE PRECISION DSUMSQ(*)
      DOUBLE PRECISION DN(*)
C
C---------------------------------------------------------------------
C
      PARAMETER (NUMALP=8)
      PARAMETER (NUMAL2=4)
      REAL ALPHA(NUMALP)
      REAL ALPHA2(NUMAL2)
C
      PARAMETER(NUMCLI=6)
      PARAMETER(MAXLIN=3)
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*60 ITITL9
      CHARACTER*60 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      CHARACTER*15 IVALUE(MAXROW,NUMCLI)
      CHARACTER*4  ITYPCO(NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      NCVALU(MAXROW,NUMCLI)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
      LOGICAL IFLAG1
      LOGICAL IFLAG2
      LOGICAL IFLAGS
      LOGICAL IFLAGE
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      DATA ALPHA/
     1 0.0, 50.0, 75.0, 90.0, 95.0, 97.5, 99.0, 99.9/
      DATA ALPHA2/0.80, 0.90, 0.95, 0.99/
C
      ISUBN1='DPSQ'
      ISUBN2='R2  '
      ISUBN0='    '
C
      IWRITE='OFF'
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'SQR2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPSQR2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,N
          WRITE(ICOUT,57)I,Y(I),TAG(I)
   57     FORMAT('I,Y(I),TAG(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ****************************************************
C               **  STEP 1--                                      **
C               **  CARRY OUT CALCULATIONS FOR SQUARED RANK TEST  **
C               **  (COMPUTATIONS PERFORMED IN DPSQR3)            **
C               ****************************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SQR2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPSQR3(Y,TAG,N,
     1            TEMP1,TEMP2,TEMP3,TEMP4,MAXNXT,
     1            DSUMSQ,DN,
     1            STATVA,STATCD,PVAL2P,PVALLP,PVALUP,
     1            IDF,NDIST,D2,
     1            IBUGA3,ISUBRO,IERROR)
C
      IF(NDIST.GE.3)THEN
        CUT0=0.0
        CALL CHSPPF(.50,IDF,CUT50)
        CALL CHSPPF(.75,IDF,CUT75)
        CALL CHSPPF(.90,IDF,CUT90)
        CALL CHSPPF(.95,IDF,CUT95)
        CALL CHSPPF(.975,IDF,CUT975)
        CALL CHSPPF(.99,IDF,CUT99)
        CALL CHSPPF(.999,IDF,CUT999)
        ALPHAT=0.05
        CALL TPPF(1.0-ALPHAT/2.0,REAL(IDF),AT95)
        ALPHAT=0.10
        CALL TPPF(1.0-ALPHAT/2.0,REAL(IDF),AT90)
        ALPHAT=0.01
        CALL TPPF(1.0-ALPHAT/2.0,REAL(IDF),AT99)
        DNTOT=DBLE(N)
        AFACT2=REAL(DSQRT(D2*(DNTOT-1.0D0-STATVA)/DBLE(N-NDIST)))
C
      ELSEIF(NDIST.EQ.2)THEN
        CALL NORPPF(.005,CTL005)
        CALL NORPPF(.010,CTL010)
        CALL NORPPF(.025,CTL025)
        CALL NORPPF(.050,CTL050)
        CALL NORPPF(.100,CTL100)
        CALL NORPPF(.200,CTL200)
        CALL NORPPF(.500,CTL500)
        CALL NORPPF(.500,CTU500)
        CALL NORPPF(.800,CTU800)
        CALL NORPPF(.900,CTU900)
        CALL NORPPF(.950,CTU950)
        CALL NORPPF(.975,CTU975)
        CALL NORPPF(.990,CTU990)
        CALL NORPPF(.995,CTU995)
      ENDIF
C
      IF(NDIST.GE.3)THEN
        IOP='OPEN'
        IFLG1=1
        IFLG2=0
        IFLG3=0
        IFLG4=0
        IFLG5=0
        CALL DPAUFI(IOP,IFLG1,IFLG2,IFLG3,IFLG4,IFLG5,
     1              IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1              IBUGA3,ISUBRO,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        WRITE(IOUNI1,2305)
 2305   FORMAT('     I       J    ',
     1       '|Si/Ni-Sj/nj|      ',
     1       '90% CV        ',
     1       '95% CV        ',
     1       '99% CV        ')
C
        DO2330I=1,NDIST
          DO2339J=1,NDIST
            IF(I.LT.J)THEN
              AFACT3=REAL(DSQRT((1.0D0/DN(I)) + (1.0D0/DN(J))))
              ADIFF=REAL(DABS((DSUMSQ(I)/DN(I)) - (DSUMSQ(J)/DN(J))))
              ACV90=AT90*AFACT2*AFACT3
              ACV95=AT95*AFACT2*AFACT3
              ACV99=AT99*AFACT2*AFACT3
              IATEMP='   '
              IF(ADIFF.GE.ACV90)IATEMP(1:1)='*'
              IF(ADIFF.GE.ACV95)IATEMP(2:2)='*'
              IF(ADIFF.GE.ACV99)IATEMP(3:3)='*'
              WRITE(IOUNI1,2337)I,J,ADIFF,ACV90,ACV95,ACV99,IATEMP
 2337         FORMAT(I6,2X,I6,2X,4E15.7,A3)
C
              IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SQR2')THEN
                WRITE(ICOUT,2341)I,J,DN(I),DN(J),DSUMSQ(I),DSUMSQ(J)
 2341           FORMAT('I,J,DN(I),DN(J),DSUMSQ(I),DSUMSQ(J) = ',
     1                 2I8,4G15.7)
                CALL DPWRST('XXX','WRIT')
                WRITE(ICOUT,2343)AFACT2,AFACT3,ADIFF
 2343           FORMAT('AFACT2,AFACT3,ADIFF = ',3G15.7)
                CALL DPWRST('XXX','WRIT')
              ENDIF
C
            ENDIF
 2339     CONTINUE
 2330   CONTINUE
C
        IOP='CLOS'
        CALL DPAUFI(IOP,IFLG1,IFLG2,IFLG3,IFLG4,IFLG5,
     1              IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1              IBUGA3,ISUBRO,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ENDIF
C
C               ********************************
C               **   STEP 42--                **
C               **   WRITE OUT EVERYTHING     **
C               **   FOR SQUARED RANKS TEST   **
C               ********************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SQR2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Squared Ranks Test'
      NCTITL=18
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      IF(IMULT.EQ.'OFF')THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Response Variable: '
        WRITE(ITEXT(ICNT)(20:23),'(A4)')IVARID(1)(1:4)
        WRITE(ITEXT(ICNT)(24:27),'(A4)')IVARI2(1)(1:4)
        NCTEXT(ICNT)=27
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
C
        ICNT=ICNT+1
        ITEXT(ICNT)='Group-ID Variable: '
        WRITE(ITEXT(ICNT)(20:23),'(A4)')IVARID(2)(1:4)
        WRITE(ITEXT(ICNT)(24:27),'(A4)')IVARI2(2)(1:4)
        NCTEXT(ICNT)=27
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
      ENDIF
C
C     IF REQUESTED, PRINT OUT GROUP INFORMATION.  SINCE NUMBER
C     OF GROUPS IS UNKNOWN (AND POTENTIALLY LARGE, PRINT EACH
C     GROUP AS A SEPARATE TABLE.
C
      IF(IKRUGS.EQ.'ON')THEN
C
        DO2060I=1,NUMDIS
C
          NUMROW=ICNT
          DO2065II=1,NUMROW
            NTOT(II)=15
 2065     CONTINUE
C
          IFRST=.TRUE.
          ILAST=.TRUE.
C
          CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1                AVALUE,IDIGIT,
     1                NTOT,NUMROW,
     1                ICAPSW,ICAPTY,ILAST,IFRST,
     1                ISUBRO,IBUGA3,IERROR)
          ICNT=0
          ITITLE=' '
          NCTITL=0
          ITITLZ=' '
          NCTITZ=0
C
          ICNT=ICNT+1
          ITEXT(ICNT)=' '
          NCTEXT(ICNT)=1
          AVALUE(ICNT)=0.0
          IDIGIT(ICNT)=-1
C
          IF(IMULT.EQ.'ON')THEN
            ICNT=ICNT+1
            ITEXT(ICNT)='Group Variable: '
            WRITE(ITEXT(ICNT)(17:20),'(A4)')IVARID(I)(1:4)
            WRITE(ITEXT(ICNT)(21:24),'(A4)')IVARI2(I)(1:4)
            NCTEXT(ICNT)=24
            AVALUE(ICNT)=0.0
            IDIGIT(ICNT)=-1
          ELSE
            ICNT=ICNT+1
            ITEXT(ICNT)='Group    '
            WRITE(ITEXT(ICNT)(7:9),'(I3)')I
            NCTEXT(ICNT)=9
            AVALUE(ICNT)=0.0
            IDIGIT(ICNT)=-1
          ENDIF
          ICNT=ICNT+1
          ITEXT(ICNT)='Number of Observations:'
          NCTEXT(ICNT)=23
          AVALUE(ICNT)=REAL(DN(I))
          IDIGIT(ICNT)=0
          ICNT=ICNT+1
          ITEXT(ICNT)='Sum of Squared Ranks:'
          NCTEXT(ICNT)=21
          AVALUE(ICNT)=REAL(DSUMSQ(I))
          IDIGIT(ICNT)=NUMDIG
 2060   CONTINUE
C
        IF(ICNT.GT.0)THEN
          NUMROW=ICNT
          DO2068II=1,NUMROW
            NTOT(II)=15
 2068     CONTINUE
C
          IFRST=.TRUE.
          ILAST=.TRUE.
C
          CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1                AVALUE,IDIGIT,
     1                NTOT,NUMROW,
     1                ICAPSW,ICAPTY,ILAST,IFRST,
     1                ISUBRO,IBUGA3,IERROR)
          ICNT=0
        ENDIF
      ENDIF
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='H0: Samples Have Equal Variability'
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Ha: Samples Do Not Have Equal Variability'
      NCTEXT(ICNT)=41
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Total Number of Observations:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Groups:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=REAL(NDIST)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Squared Ranks Test Statistic Value:'
      NCTEXT(ICNT)=35
      AVALUE(ICNT)=STATVA
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='CDF of Test Statistic:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=STATCD
      IDIGIT(ICNT)=NUMDIG
      IF(NDIST.GE.3)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='P-Value:'
        NCTEXT(ICNT)=8
        AVALUE(ICNT)=PVAL2P
        IDIGIT(ICNT)=NUMDIG
      ELSE
        ICNT=ICNT+1
        ITEXT(ICNT)='Two-Tailed P-Value:'
        NCTEXT(ICNT)=19
        AVALUE(ICNT)=PVAL2P
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Lower Tailed P-Value:'
        NCTEXT(ICNT)=21
        AVALUE(ICNT)=PVALLP
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Upper Tailed P-Value:'
        NCTEXT(ICNT)=21
        AVALUE(ICNT)=PVALUP
        IDIGIT(ICNT)=NUMDIG
      ENDIF
C
      NUMROW=ICNT
      DO4210I=1,NUMROW
        NTOT(I)=15
 4210 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      ISTEPN='42A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SQR2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(NDIST.EQ.2)GOTO5000
C
      ITITLE=' '
      NCTITL=0
      ITITL9=' '
      NCTIT9=0
      ITITLE(1:55)=
     1'Percent Points of the Chi-Square Reference Distribution'
      NCTITL=55
      NUMLIN=1
      NUMROW=8
      NUMCOL=3
      ITITL2(1,1)='Percent Point'
      ITITL2(1,2)=' '
      ITITL2(1,3)='Value'
      NCTIT2(1,1)=13
      NCTIT2(1,2)=1
      NCTIT2(1,3)=5
C
      NMAX=0
      DO4221I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(I.EQ.2)NTOT(I)=5
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
        ITYPCO(I)='NUME'
 4221 CONTINUE
      ITYPCO(2)='ALPH'
      IDIGIT(1)=1
      IDIGIT(3)=3
      DO4223I=1,NUMROW
        DO4225J=1,NUMCOL
          NCVALU(I,J)=0
          IVALUE(I,J)=' '
          NCVALU(I,J)=0
          AMAT(I,J)=0.0
          IF(J.EQ.1)THEN
            AMAT(I,J)=ALPHA(I)
          ELSEIF(J.EQ.2)THEN
            IVALUE(I,J)='='
            NCVALU(I,J)=1
          ELSEIF(J.EQ.3)THEN
            IF(I.EQ.1)THEN
              AMAT(I,J)=RND(CUT0,IDIGIT(J))
            ELSEIF(I.EQ.2)THEN
              AMAT(I,J)=RND(CUT50,IDIGIT(J))
            ELSEIF(I.EQ.3)THEN
              AMAT(I,J)=RND(CUT75,IDIGIT(J))
            ELSEIF(I.EQ.4)THEN
              AMAT(I,J)=RND(CUT90,IDIGIT(J))
            ELSEIF(I.EQ.5)THEN
              AMAT(I,J)=RND(CUT95,IDIGIT(J))
            ELSEIF(I.EQ.6)THEN
              AMAT(I,J)=RND(CUT975,IDIGIT(J))
            ELSEIF(I.EQ.7)THEN
              AMAT(I,J)=RND(CUT99,IDIGIT(J))
            ELSEIF(I.EQ.8)THEN
              AMAT(I,J)=RND(CUT999,IDIGIT(J))
            ENDIF
          ENDIF
 4225   CONTINUE
 4223 CONTINUE
C
      IWHTML(1)=150
      IWHTML(2)=50
      IWHTML(3)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+500
      IWRTF(3)=IWRTF(2)+2000
      IFRST=.TRUE.
      ILAST=.FALSE.
C
      ISTEPN='42C'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SQR2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDTA4(ITITL9,NCTIT9,
     1            ITITLE,NCTITL,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,NUMROW,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ISTEPN='42D'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SQR2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ITITLE='Upper-Tailed Test: Chi-Square Approximation'
      NCTITL=43
      ITITL9='H0: Variances Are Equal; Ha: Variance Are Not Equal'
      NCTIT9=51
C
      DO2130J=1,NUMCLI
        DO2140I=1,MAXLIN
          ITITL2(I,J)=' '
          NCTIT2(I,J)=0
 2140   CONTINUE
 2130 CONTINUE
C
      NUMCOL=4
      ITITL2(2,1)='Significance'
      NCTIT2(2,1)=12
      ITITL2(3,1)='Level'
      NCTIT2(3,1)=5
C
      ITITL2(2,2)='Test '
      NCTIT2(2,2)=4
      ITITL2(3,2)='Statistic'
      NCTIT2(3,2)=9
C
      ITITL2(2,3)='Critical'
      NCTIT2(2,3)=8
      ITITL2(3,3)='Value (>)'
      NCTIT2(3,3)=9
C
      ITITL2(1,4)='Null'
      NCTIT2(1,4)=4
      ITITL2(2,4)='Hypothesis'
      NCTIT2(2,4)=10
      ITITL2(3,4)='Conclusion'
      NCTIT2(3,4)=10
C
      NMAX=0
      DO2150I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
        ITYPCO(I)='NUME'
        IDIGIT(I)=NUMDIG
        IF(I.EQ.1 .OR. I.EQ.4)THEN
          ITYPCO(I)='ALPH'
        ENDIF
 2150 CONTINUE
C
      IWHTML(1)=125
      IWHTML(2)=175
      IWHTML(3)=175
      IWHTML(4)=175
      IINC=1800
      IINC2=1400
      IWRTF(1)=IINC
      IWRTF(2)=IWRTF(1)+IINC
      IWRTF(3)=IWRTF(2)+IINC
      IWRTF(4)=IWRTF(3)+IINC
C
      ICNT=NUMAL2
      DO2160J=1,NUMAL2
C
        AMAT(J,2)=STATVA
        ALPHAT=ALPHA(J)
        ATEMP=ALPHAT/100.0
        CALL CHSPPF(ATEMP,IDF,CUTTMP)
        AMAT(J,3)=CUTTMP
        IVALUE(J,4)(1:6)='REJECT'
        IF(ABS(STATVA).LT.AMAT(J,3))THEN
          IVALUE(J,4)(1:6)='ACCEPT'
        ENDIF
        NCVALU(J,4)=6
C
        WRITE(IVALUE(J,1)(1:4),'(F4.1)')ALPHAT
        IVALUE(J,1)(5:5)='%'
        NCVALU(J,1)=5
 2160 CONTINUE
C
      NUMLIN=3
      IFRST=.TRUE.
      ILAST=.TRUE.
      IFLAGS=.TRUE.
      IFLAGE=.TRUE.
C
      CALL DPDTA5(ITITLE,NCTITL,
     1            ITITL9,NCTIT9,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            IFLAGS,IFLAGE,
     1            ISUBRO,IBUGA3,IERROR)
C
      ITITLE(1:26)='Multiple Comparisons Table'
      NCTITL=26
      ITITL9=' '
      NCTIT9=0
C
      ITITL2(1,1)='I'
      NCTIT2(1,1)=1
      ITITL2(1,2)='J'
      NCTIT2(1,2)=1
      ITITL2(1,3)='|Si/Ni - Sj/Nj|'
      NCTIT2(1,3)=15
      ITITL2(1,4)='90% CV'
      NCTIT2(1,4)=6
      ITITL2(1,5)='95% CV'
      NCTIT2(1,5)=6
      ITITL2(1,6)='99% CV'
      NCTIT2(1,6)=6
C
      NMAX=0
      NUMCOL=6
      DO4010I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        ITYPCO(I)='NUME'
        IDIGIT(I)=NUMDIG
        NTOT(I)=15
        IF(I.EQ.1 .OR. I.EQ.2)THEN
          NTOT(I)=5
          IDIGIT(I)=0
        ELSEIF(I.EQ.3)THEN
          NTOT(I)=17
        ENDIF
        NMAX=NMAX+NTOT(I)
 4010 CONTINUE
      IWHTML(1)=50
      IWHTML(2)=50
      IWHTML(3)=150
      IWHTML(4)=150
      IWHTML(5)=150
      IWHTML(6)=150
      IINC=1600
      IINC2=200
      IINC3=1000
      IWRTF(1)=IINC2
      IWRTF(2)=IWRTF(1)+IINC2
      IWRTF(3)=IWRTF(2)+IINC
      IWRTF(4)=IWRTF(3)+IINC
      IWRTF(5)=IWRTF(4)+IINC
      IWRTF(6)=IWRTF(5)+IINC
C
      ICNT=0
      DO4081I=1,NDIST
        DO4083J=1,NDIST
          IF(I.LT.J)THEN
C
            AFACT3=REAL(DSQRT((1.0D0/DN(I)) + (1.0D0/DN(J))))
            ADIFF=REAL(DABS((DSUMSQ(I)/DN(I)) - (DSUMSQ(J)/DN(J))))
            ACV90=AT90*AFACT2*AFACT3
            ACV95=AT95*AFACT2*AFACT3
            ACV99=AT99*AFACT2*AFACT3
            IATEMP='   '
            IF(ADIFF.GE.ACV90)IATEMP(1:1)='*'
            IF(ADIFF.GE.ACV95)IATEMP(2:2)='*'
            IF(ADIFF.GE.ACV99)IATEMP(3:3)='*'
C
            IF(ICNT.GE.MAXROW)THEN
              NUMLIN=1
              IFRST=.TRUE.
              ILAST=.TRUE.
              IFLAGS=.TRUE.
              IFLAGE=.TRUE.
              CALL DPDTA5(ITITLE,NCTITL,
     1                    ITITL9,NCTIT9,ITITL2,NCTIT2,
     1                    MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1                    IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1                    IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1                    ICAPSW,ICAPTY,IFRST,ILAST,
     1                    IFLAGS,IFLAGE,
     1                    ISUBRO,IBUGA3,IERROR)
              ICNT=0
            ENDIF
C
            ICNT=ICNT+1
            IVALUE(ICNT,1)=' '
            NCVALU(ICNT,1)=0
            AMAT(ICNT,1)=REAL(I)
            IVALUE(ICNT,2)=' '
            NCVALU(ICNT,2)=0
            AMAT(ICNT,2)=REAL(J)
            IVALUE(ICNT,3)=' '
            NCVALU(ICNT,3)=0
            AMAT(ICNT,3)=ADIFF
            IVALUE(ICNT,4)=' '
            NCVALU(ICNT,4)=0
            AMAT(ICNT,4)=ACV90
            IVALUE(ICNT,5)=' '
            NCVALU(ICNT,5)=0
            AMAT(ICNT,5)=ACV95
            IVALUE(ICNT,6)=' '
            NCVALU(ICNT,6)=0
            AMAT(ICNT,6)=ACV99
          ENDIF
 4083   CONTINUE
 4081 CONTINUE
C
      IF(ICNT.GE.1)THEN
        NUMLIN=1
        IFRST=.TRUE.
        ILAST=.TRUE.
        IFLAGS=.TRUE.
        IFLAGE=.TRUE.
        CALL DPDTA5(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              IFLAGS,IFLAGE,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
      GOTO9000
C
 5000 CONTINUE
C
      ITITLE='Two-Tailed Test: Normal Approximation'
      NCTITL=37
      ITITL9='H0: Var(Y1) = Var(Y2); Ha: Var(Y1) <> Var(Y2)'
      NCTIT9=45
C
      DO5130J=1,NUMCLI
        DO5140I=1,MAXLIN
          ITITL2(I,J)=' '
          NCTIT2(I,J)=0
 5140   CONTINUE
 5130 CONTINUE
C
      NUMCOL=4
      ITITL2(2,1)='Significance'
      NCTIT2(2,1)=12
      ITITL2(3,1)='Level'
      NCTIT2(3,1)=5
C
      ITITL2(2,2)='Test '
      NCTIT2(2,2)=4
      ITITL2(3,2)='Statistic'
      NCTIT2(3,2)=9
C
      ITITL2(2,3)='Critical'
      NCTIT2(2,3)=8
      ITITL2(3,3)='Value (+/-)'
      NCTIT2(3,3)=11
C
      ITITL2(1,4)='Null'
      NCTIT2(1,4)=4
      ITITL2(2,4)='Hypothesis'
      NCTIT2(2,4)=10
      ITITL2(3,4)='Conclusion'
      NCTIT2(3,4)=10
C
      NMAX=0
      DO5150I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
        ITYPCO(I)='NUME'
        IDIGIT(I)=NUMDIG
        IF(I.EQ.1 .OR. I.EQ.4)THEN
          ITYPCO(I)='ALPH'
        ENDIF
 5150 CONTINUE
C
      IWHTML(1)=125
      IWHTML(2)=175
      IWHTML(3)=175
      IWHTML(4)=175
      IINC=1800
      IINC2=1400
      IWRTF(1)=IINC
      IWRTF(2)=IWRTF(1)+IINC
      IWRTF(3)=IWRTF(2)+IINC
      IWRTF(4)=IWRTF(3)+IINC
C
      ICNT=NUMAL2
      DO5160J=1,NUMAL2
C
        AMAT(J,2)=STATVA
        ALPHAT=ALPHA2(J)
        ATEMP=(1.0 - ALPHAT)/2.0
        ATEMP=1.0 - ATEMP
        CALL NORPPF(ATEMP,CUTTMP)
        AMAT(J,3)=CUTTMP
        IVALUE(J,4)(1:6)='REJECT'
        IF(ABS(STATVA).LT.AMAT(J,3))THEN
          IVALUE(J,4)(1:6)='ACCEPT'
        ENDIF
        NCVALU(J,4)=6
C
        WRITE(IVALUE(J,1)(1:4),'(F4.1)')100.0*ALPHAT
        IVALUE(J,1)(5:5)='%'
        NCVALU(J,1)=5
 5160 CONTINUE
C
      NUMLIN=3
      IFRST=.TRUE.
      ILAST=.TRUE.
      IFLAGS=.TRUE.
      IFLAGE=.TRUE.
C
      IF(ICASAN.EQ.'TWOT')THEN
        CALL DPDTA5(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              IFLAGS,IFLAGE,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
      IF(ICASAN.EQ.'LOWE')THEN
C
        ITITLE='Lower-Tailed Test: Normal Approximation'
        NCTITL=39
        ITITL9='H0: Var(Y1) = Var(Y2); Ha: Var(Y1) < Var(Y2)'
        NCTIT9=44
C
        ITITL2(2,3)='Critical'
        NCTIT2(2,3)=8
        ITITL2(3,3)='Value (<)'
        NCTIT2(3,3)=9
        NUMCOL=4
C
        NMAX=0
        DO5250I=1,NUMCOL
          NTOT(I)=15
          NMAX=NMAX+NTOT(I)
 5250   CONTINUE
C
        ICNT=NUMALP
        DO5260J=1,NUMALP
C
          AMAT(J,2)=STATVA
          ALPHAT=ALPHA(J)
          ATEMP=(1.0 - ALPHAT)
          CALL NORPPF(ATEMP,CUTTMP)
          AMAT(J,3)=CUTTMP
          IVALUE(J,4)(1:6)='ACCEPT'
          IF(ABS(STATVA).LT.AMAT(J,3))THEN
            IVALUE(J,4)(1:6)='REJECT'
          ENDIF
          NCVALU(J,4)=6
          WRITE(IVALUE(J,1)(1:4),'(F4.1)')100.0*ALPHAT
          IVALUE(J,1)(5:5)='%'
          NCVALU(J,1)=5
 5260   CONTINUE
C
        NUMLIN=3
        IFRST=.TRUE.
        ILAST=.TRUE.
        IFLAGS=.TRUE.
        IFLAGE=.TRUE.
        CALL DPDTA5(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              IFLAGS,IFLAGE,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
      IF(ICASAN.EQ.'UPPE')THEN
C
        ITITLE='Upper-Tailed Test: Normal Approximation'
        NCTITL=39
        ITITL9='H0: Var(Y1) = Var(Y2); Ha: Var(Y1) > Var(Y2)'
        NCTIT9=44
C
        ITITL2(2,3)='Critical'
        NCTIT2(2,3)=8
        ITITL2(3,3)='Value (>)'
        NCTIT2(3,3)=9
        NUMCOL=4
C
        NMAX=0
        DO5350I=1,NUMCOL
          NTOT(I)=15
          NMAX=NMAX+NTOT(I)
 5350   CONTINUE
C
        ICNT=NUMALP
        DO5360J=1,NUMALP
C
          AMAT(J,2)=STATVA
          ALPHAT=ALPHA(J)
          ATEMP=ALPHAT
          CALL NORPPF(ATEMP,CUTTMP)
          AMAT(J,3)=CUTTMP
          IVALUE(J,4)(1:6)='ACCEPT'
          IF(ABS(STATVA).GT.AMAT(J,3))THEN
            IVALUE(J,4)(1:6)='REJECT'
          ENDIF
          NCVALU(J,4)=6
          WRITE(IVALUE(J,1)(1:4),'(F4.1)')100.0*ALPHAT
          IVALUE(J,1)(5:5)='%'
          NCVALU(J,1)=5
 5360   CONTINUE
C
        NUMLIN=3
        IFRST=.TRUE.
        ILAST=.TRUE.
        IFLAGS=.TRUE.
        IFLAGE=.TRUE.
        CALL DPDTA5(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              IFLAGS,IFLAGE,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'SQR2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSQR2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9025)STATVA,STATCD
 9025   FORMAT('STATVA,STATCD = ',2G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSQR3(Y,X,N,
     1                  TEMP1,TEMP2,YRANK,XIDTEM,MAXNXT,
     1                  DSUMSQ,DN,
     1                  STATVA,STATCD,PVALUE,PVALLT,PVALUT,
     1                  IDF,NDIST,D2,
     1                  IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE SQUARED RANKS K-SAMPLE TEST
C              STATISTIC FOR EQUAL VARIANCES AND ASSOCIATED CDF AND
C              P-VALUES.
C
C              THIS PART IS EXTRACTED FROM DPSQR2 IN ORDER TO
C              ALLOW IT TO BE COMPUTED FROM THE "STATISTICS" ROUTINES
C              (E.G., STATISTIC PLOT, BOOTSTRAP).
C
C     EXAMPLE--SQUARED RANKS TEST Y X
C     REFERENCE--CONOVER (1999), "PRACTICAL NONPARAMETRIC STATISTICS",
C                THIRD EDITION, WILEY, PP. 300 - 310.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2011/6
C     ORIGINAL VERSION--JUNE      2011.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DSUM3
      DOUBLE PRECISION DSUM4
      DOUBLE PRECISION D2
      DOUBLE PRECISION SBAR
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DNUM
      DOUBLE PRECISION DENOM
      DOUBLE PRECISION C1
      DOUBLE PRECISION C2
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION YRANK(*)
      DIMENSION XIDTEM(*)
C
      DOUBLE PRECISION DSUMSQ(*)
      DOUBLE PRECISION DN(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPSQ'
      ISUBN2='R3  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      STATVA=CPUMIN
      STATCD=CPUMIN
      PVALUE=CPUMIN
      IDF=-99
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SQR3')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPSQR3--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',2(A4,2X),I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,N
          WRITE(ICOUT,57)I,Y(I),X(I)
   57     FORMAT('I,Y(I),X(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 01--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='01'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SQR3')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(N.LE.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,101)
  101   FORMAT('***** ERROR IN SQUARED RANKS TEST--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,112)
  112   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS FOR THE ',
     1         'RESPONSE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,113)
  113   FORMAT('      VARIABLES MUST BE 2 OR LARGER.  SUCH WAS NOT ',
     1         'THE CASE HERE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,117)N
  117   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS   = ',I8,'.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      HOLD=Y(1)
      DO135I=2,N
        IF(Y(I).NE.HOLD)GOTO139
  135 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,101)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,131)HOLD
  131 FORMAT('      THE RESPONSE VARIABLE HAS ALL ELEMENTS = ',G15.7)
      CALL DPWRST('XXX','WRIT')
      IERROR='YES'
      GOTO9000
  139 CONTINUE
C
      HOLD=X(1)
      DO145I=2,N
        IF(X(I).NE.HOLD)GOTO149
  145 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,101)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,141)HOLD
  141 FORMAT('      THE GROUP-ID VARIABLE HAS ALL ELEMENTS = ',G15.7)
      CALL DPWRST('XXX','WRIT')
      IERROR='YES'
      GOTO9000
  149 CONTINUE
C
C               *************************************
C               **   STEP 11--                     **
C               **   COMPUTE SQUARED RANKS   TEST  **
C               *************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SQR3')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     DETERMINE DISTINCT VALUES OF GROUP-ID VARIABLE.  SUBTRACT
C     GROUP MEANS FROM VARIABLE.
C
      CALL DISTIN(X,N,IWRITE,XIDTEM,NDIST,IBUGA3,IERROR)
      DO1010K=1,NDIST
        HOLD=XIDTEM(K)
        NTEMP=0
        DO1020I=1,N
          IF(X(I).EQ.HOLD)THEN
            NTEMP=NTEMP+1
            TEMP2(NTEMP)=Y(I)
          ENDIF
 1020   CONTINUE
        CALL MEAN(TEMP2,NTEMP,IWRITE,YMEAN,IBUGA3,IERROR)
        YRANK(K)=YMEAN
 1010 CONTINUE
C
      DO1030I=1,N
        DO1040K=1,NDIST
          IF(XIDTEM(K).EQ.X(I))THEN
            TEMP1(I)=ABS(Y(I) - REAL(YRANK(K)))
            GOTO1049
          ENDIF
 1040   CONTINUE
 1049   CONTINUE
 1030 CONTINUE
C
C     COMPUTE RANKS, BUT SUBTRACT MEANS FROM DATA FIRST
C
      CALL RANK(TEMP1,N,IWRITE,YRANK,TEMP2,MAXNXT,IBUGA3,IERROR)
C
      DSUM1=0.0D0
      DSUM2=0.0D0
      DSUM4=0.0D0
      DO1050I=1,N
        DSUM1=DSUM1 + YRANK(I)**2
        DSUM2=DSUM2 + DBLE(YRANK(I))**4
        IF(X(I).EQ.XIDTEM(1))DSUM4=DSUM4 + DBLE(YRANK(I))**2
 1050 CONTINUE
      SBAR=DSUM1/DBLE(N)
C
      DSUM1=0.0D0
      DO1060K=1,NDIST
        HOLD=XIDTEM(K)
        NTEMP=0
        DSUM3=0.0D0
        DO1070I=1,N
          IF(XIDTEM(K).EQ.X(I))THEN
            NTEMP=NTEMP+1
            DSUM3=DSUM3 + DBLE(YRANK(I))**2
          ENDIF
 1070   CONTINUE
        DSUM1=DSUM1 + DSUM3**2/DBLE(NTEMP)
        DSUMSQ(K)=DSUM3
        DN(K)=DBLE(NTEMP)
 1060 CONTINUE
C
C     COMPUTE SQUARED RANKS TEST STATISTIC:
C
C         T = (1/D**2)*{SUM[i=1 to k][S(i)**2/n(i)] - N*SBAR**2}
C
C     WHERE
C
C         S(i) = SUM OF SQUARE RANKS IN SUBSAMPLE i
C         n(i) = NUMBER OF OBSERVATIONS IN SUBSAMPLE i
C         D**2 = (1/(N-1))*{SUM[i=1 to N][R(i)**4] - N*SBAR**2}
C         SBAR = (1/N)*SUM[j=1 to k][S(k)]
C              = (1/N)*SUM[i=1 to N][S(k)]
C
C     FOR 2-SAMPLE CASE, THE FORMULA IS
C
C        T1 = {T - N1*SBAR**2}/
C             SQRT{(N1*N2)/(N*(N-1))}*SUM[i=1 to N][R(i)**4] -
C             (N1*N2/(N-1))*(SBAR)**2}
C
      ISTEPN='12'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SQR3')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NDIST.GT.2)THEN
        D2=(DSUM2 - DBLE(N)*SBAR**2)/DBLE(N-1)
        DTERM1=(DSUM1 - DBLE(N)*SBAR**2)/D2
        STATVA=REAL(DTERM1)
C
C       CDF AND P-VALUES COMPUTED FROM CHI-SQUARE APPROXIMATION
C
        IDF=NDIST-1
        CALL CHSCDF(STATVA,IDF,STATCD)
        PVALUE=1.0 - STATCD
        PVALLT=CPUMIN
        PVALUT=CPUMIN
      ELSE
        DNUM=DSUM4 - DN(1)*SBAR
        C1=DN(1)*DN(2)/(DBLE(N)*DBLE(N-1))
        C2=DN(1)*DN(2)/DBLE(N-1)
        DENOM=DSQRT(C1*DSUM2 - C2*SBAR**2)
        STATVA=REAL(DNUM/DENOM)
        CALL NORCDF(STATVA,STATCD)
        PVALLT=STATCD
        PVALUT=1.0 - STATCD
        PVALUE=2.0*MIN(PVALLT,PVALUT)
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'SQR3')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSQR3--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)STATVA,STATCD,PVALUE,IDF
 9013   FORMAT('STATVA,STATCD,PVALUE,IDF = ',3G15.7,I8)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9014)SBAR,D2,DSUM1,DSUM2,DSUM3
 9014   FORMAT('SBAR,D2,DSUM1,DSUM2,DSUM3 = ',5G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSQUE(PX,PY,NP,
     1PXMIN,PXMAX,PYMIN,PYMAX)
C
C     PURPOSE--SCAN EACH VALUE OF PX(.) AND
C              COMPARE IT TO (PXMIN,PXMAX).
C              IF ONLY SLIGHTLY SMALLER THAN PXMIN,
C              THEN CHANGE PX(I) TO PXMAX.
C              IF ONLY SLIGHTLY LARGER THAN PXMAX,
C              THEN CHANGE PX(I) TO PXMAX.
C              SIMILARLY, SCAN EACH VALUE OF PY(.) AND
C              COMPARE IT TO (PYMIN,PYMAX).
C              IF ONLY SLIGHTLY SMALLER THAN PYMIN,
C              THEN CHANGE PY(I) TO PYMAX.
C              IF ONLY SLIGHTLY LARGER THAN PYMAX,
C              THEN CHANGE PY(I) TO PYMAX.
C     NOTE--THIS SUBROUTINE COUNTERACTS INCORRECT
C           COORDINATE CALCULATIONS FOR P WHICH ARE
C           INCORRECT DUE TO ROUNDOFF ERROR
C           AND SQUEEZES THEM BACK TO THEIR PROPER VALUE.
C     DANGER--PX(.) AND PY(.) SERVE AS BOTH INPUT AND
C             OUTPUT ARGUMENTS IN THIS SUBROUTINE.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C
C--------------------------------------------------------
C
      DIMENSION PX(*)
      DIMENSION PY(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'SQUE')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPSQUE--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)PXMIN,PXMAX,PYMIN,PYMAX
   52 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)NP
   54 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,NP
      DELXMN=PXMIN-PX(I)
      DELXMX=PX(I)-PXMAX
      DELYMN=PYMIN-PY(I)
      DELYMX=PY(I)-PYMAX
      WRITE(ICOUT,56)I,PX(I),PY(I)
   56 FORMAT('I,PX(I),PY(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,57)DELXMN,DELXMX,DELYMN,DELYMN
   57 FORMAT('DELXMN,DELXMX,DELYMN,DELYMN = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
      WRITE(ICOUT,59)IBUGG4,ISUBG4,IERRG4
   59 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               *************************************************
C               **  STEP 1--                                   **
C               **  CHECK TO SEE IF PX(.) NEAR PXMIN OR PXMAX  **
C               *************************************************
C
      IF(NP.LE.0)GOTO1190
      DO1100I=1,NP
C
      IF(PX(I).LT.PXMIN)GOTO1110
      IF(PX(I).GT.PXMAX)GOTO1120
      GOTO1100
C
 1110 CONTINUE
      DELMIN=PXMIN-PX(I)
      IF(DELMIN.LE.0.0001)PX(I)=PXMIN
      GOTO1100
C
 1120 CONTINUE
      DELMAX=PX(I)-PXMAX
      IF(DELMAX.LE.0.0001)PX(I)=PXMAX
      GOTO1100
C
 1100 CONTINUE
 1190 CONTINUE
C
C               *************************************************
C               **  STEP 2--                                   **
C               **  CHECK TO SEE IF PY(.) NEAR PYMIN OR PYMAX  **
C               *************************************************
C
      IF(NP.LE.0)GOTO1290
      DO1200I=1,NP
C
      IF(PY(I).LT.PYMIN)GOTO1210
      IF(PY(I).GT.PYMAX)GOTO1220
      GOTO1200
C
 1210 CONTINUE
      DELMIN=PYMIN-PY(I)
      IF(DELMIN.LE.0.0001)PY(I)=PYMIN
      GOTO1200
C
 1220 CONTINUE
      DELMAX=PY(I)-PYMAX
      IF(DELMAX.LE.0.0001)PY(I)=PYMAX
      GOTO1200
C
 1200 CONTINUE
 1290 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'SQUE')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPSQUE--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)PXMIN,PXMAX,PYMIN,PYMAX
 9012 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)NP
 9014 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9015I=1,NP
      DELXMN=PXMIN-PX(I)
      DELXMX=PX(I)-PXMAX
      DELYMN=PYMIN-PY(I)
      DELYMX=PY(I)-PYMAX
      WRITE(ICOUT,9016)I,PX(I),PY(I)
 9016 FORMAT('I,PX(I),PY(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)DELXMN,DELXMX,DELYMN,DELYMN
 9017 FORMAT('DELXMN,DELXMX,DELYMN,DELYMN = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
 9015 CONTINUE
      WRITE(ICOUT,9019)IBUGG4,ISUBG4,IERRG4
 9019 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPSTAC(ICASL8,ILOCV,ISTANR,
     1IFOUNZ,IBEGIN,IEND,ITYPE,IHOL,IHOL2,INT1,FLOAT1,IERRO1,
     1TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,XTEMP3,MAXNXT,
CCCCC JULY 2002.  ADD ISEED FOR HODHES-LEHMAN
     1ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1DTEMP1,DTEMP2,DTEMP3,
     1IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--TREAT THE TYPE 8 LET CASE--
C              COMPUTE ELEMENTARY STATISTICS (MOSTLY).
C                      LET A = NUMBER X
C                      LET A = SIZE X
C                      LET A = COUNT X
C
C                      LET A = SUM X
C                      LET A = PRODUCT X
C                      LET A = INTEGRAL X
C                      LET A = RATIO X1 X2
C                      LET A = ODDS RATIO X1 X2
C                      LET A = ODDS RATIO STANDARD ERROR X1 X2
C                      LET A = LOG ODDS RATIO X1 X2
C                      LET A = LOG ODDS RATIO STANDARD ERROR X1 X2
C                      LET A = RELATIVE RISK X1 X2
C                      LET A = CRAMER CONTINGENCY COEFFICIENT X1 X2
C                      LET A = PEARSON CONTINGENCY COEFFICIENT X1 X2
C                      LET A = FALSE POSITIVE X1 X2
C                      LET A = FALSE NEGATIVE X1 X2
C                      LET A = TRUE POSITIVE X1 X2
C                      LET A = TRUE NEGATIVE X1 X2
C                      LET A = TEST SENSITIVITY X1 X2
C                      LET A = TEST SPECIFICITY X1 X2
C                      LET A = POSITIVE PREDICTIVE VALUE X1 X2
C                      LET A = NEGATIVE PREDICTIVE VALUE X1 X2
C
C                      LET A = MIDRANGE X
C                      LET A = MEAN X
C                      LET A = AVERAGE X
C                      LET A = MIDMEAN X
C                      LET A = MEDIAN X
C                      LET A = TRIMMED MEAN X
C                      LET A = WINDSORIZED MEAN X
C                      LET A = HODGES LEHMAN X
C                      LET A = LP LOCATION X
C                      LET A = STANDARD DEVIATION X
C                      LET A = VARIANCE X
C                      LET A = COEFFICIENT OF VARIATION X
C                      LET A = RELATIVE STANDARD DEVIATION X
C                      LET A = RELATIVE VARIANCE X
C                      LET A = AVERAGE ABSOLUTE DEVIATION X
C                      LET A = RANGE X
C                      LET A = MINIMUM X
C                      LET A = MIN X
C                      LET A = MAXIMUM X
C                      LET A = MAX X
C                      LET A = EXTREME X
C                      LET A = STANDARDIZED THIRD CENTRAL MOMENT X
C                      LET A = SKEWNESS X
C                      LET A = STANDARDIZED FOURTH CENTRAL MOMENT X
C                      LET A = KURTOSIS X
C                      LET A = AUTOCORRELATION X
C                      LET A = COVARIANCE X Y
C                      LET A = CORRELATION X Y
C                      LET A = RANK CORRELATION X Y
C                      LET A = KENDELLS TAU X Y
C                      LET A = COMOVEMENT X Y (LEIGH-PEARLMAN)
C                      LET A = RANK COMOVEMENT X Y
C                      LET A = STANDARD DEVIATION OF MEAN X
C                      LET A = VARIANCE OF MEAN X
C                      LET A = STANDARD DEVIATION OF THE MEAN X
C                      LET A = STANDARD DEVIATION MEAN X
C                      LET A = VARIANCE OF LP LOCATION X
C                      LET A = STANDARD DEVIATION OF LP LOCATION X
C
C                      LET A = WEIGHTED MEAN X W
C                      LET A = WEIGHTED MEDIAN X W
C                      LET A = WEIGHTED STANDARD DEVIATION X W
C                      LET A = WEIGHTED VARIANCE X W
C                      LET A = WEIGHTED TRIMMED MEAN X W
C
C                      LET A = CP X
C                      LET A = CPL X
C                      LET A = CPU X
C                      LET A = CPK X
C                      LET A = CNPK X
C                      LET A = CPM X
C                      LET A = CC X
C                      LET A = PERCENT DEFECTIVE X
C                      LET A = EXPECTED LOSS X
C
C                      LET A = NORMAL PPCC X
C
C                      LET A = LINEAR INTERCEPT Y X
C                      LET A = LINEAR SLOPE Y X
C                      LET A = LINEAR RESSD Y X
C                      LET A = LINEAR CORRELATION Y X
C                      LET A = REPEATABILITY SD Y X
C                      LET A = REPRODUCABILITY SD Y X
C
C                      LET A = (TAGUCHI) SN- X
C                      LET A = (TAGUCHI) SN0 X
C                      LET A = (TAGUCHI) SN+ X
C                      LET A = (TAGUCHI) SN00 X
C
C                      LET A = MEDIAN ABSOLUTE DEVIATION X
C                      LET A = MAD X
C                      LET A = SN X
C                      LET A = QN X
C                      LET A = 95 PERCENTILE X
C
C                      LET A = GEOMETRIC MEAN X W
C                      LET A = GEOMETRIC STANDARD DEVIATION X W
C
C                      LET A = COMMON DIGITS X
C                      LET A = NUMBER OF COMMON DIGITS X
C
C                      LET A = INTERQUARTILE RANGE X
C
C                      LET A = BIWEIGHT LOCATION X
C                      LET A = BIWEIGHT SCALE X
C
C                      LET A = WINSORIZED VARIANCE X
C                      LET A = WINSORIZED SD X
C                      LET A = WINSORIZED COVARIANCE X Y
C                      LET A = WINSORIZED CORRELATION X Y
C                      LET A = PERCENTAGE BEND MIDVARIANCE X
C                      LET A = PERCENTAGE BEND CORRELATION X1 X2
C                      LET A = HODGES LEHMAN X
C                      LET A = BIWEIGHT MIDVARIANCE X
C                      LET A = BIWEIGHT MIDCOVARIANCE X Y
C                      LET A = BIWEIGHT MIDCORRELATION X Y
C                      LET A = TRIMMED MEAN STANDARD ERROR X
C                      LET A = TRIMMED STANDARD DEVIATION X
C                      LET A = ... QUANTILE X
C                      LET A = ... QUANTILE STANDARD ERROR X
C
C                      LET A = BINOMIAL PROBABILITY X
C
C              FOLLOWING STATISTICS COMPUTE DIFFERENCE IN
C              STATISTIC FOR TWO RESPONSE VARIABLES (USED FOR
C              LOCATION AND SCALE STATISTICS):
C
C              LOCATION:
C                      LET A = DIFFERENCE OF MEANS X1 X2
C                      LET A = DIFFERENCE OF MIDMEANS X1 X2
C                      LET A = DIFFERENCE OF MEDIANS X1 X2
C                      LET A = DIFFERENCE OF TRIMMED MEANS X1 X2
C                      LET A = DIFFERENCE OF WINSORIZED MEANS X1 X2
C                      LET A = DIFFERENCE OF GEOMETRIC MEANS X1 X2
C                      LET A = DIFFERENCE OF HARMONIC MEANS X1 X2
C                      LET A = DIFFERENCE OF HODGES-LEHMAN X1 X2
C                      LET A = DIFFERENCE OF BIWEIGHT LOCATION X1 X2
C                      LET A = DIFFERENCE OF LP LOCATION X1 X2
C
C              SCALE:
C                      LET A = DIFFERENCE OF STANDARD DEVIATIONS X1 X2
C                      LET A = DIFFERENCE OF VARIANCES X1 X2
C                      LET A = DIFFERENCE OF AAD X1 X2
C                      LET A = DIFFERENCE OF MAD X1 X2
C                      LET A = DIFFERENCE OF SN X1 X2
C                      LET A = DIFFERENCE OF QN X1 X2
C                      LET A = DIFFERENCE OF INTERQUARTILE RANGE X1 X2
C                      LET A = DIFFERENCE OF WINSORIZED SD X1 X2
C                      LET A = DIFFERENCE OF WINSORIZED VARIANCE X1 X2
C                      LET A = DIFFERENCE OF BIWEIGHT MIDVARIANCE X1 X2
C                      LET A = DIFFERENCE OF BIWEIGHT SCALE X1 X2
C                      LET A = DIFFERENCE OF PERCENTAGE BEND X1 X2
C                      LET A = DIFFERENCE OF GEOMETRIC SD X1 X2
C                      LET A = DIFFERENCE OF RANGE X1 X2
C                      LET A = DIFFERENCE OF MIDRANGE X1 X2
C                      LET A = DIFFERENCE OF QUANTILE X1 X2
C                      LET A = DIFFERENCE OF SKEWNESS X1 X2
C                      LET A = DIFFERENCE OF KURTOSIS X1 X2
C                      LET A = DIFFERENCE OF RELATIVE SD X1 X2
C                      LET A = DIFFERENCE OF SD OF MEAN X1 X2
C                      LET A = DIFFERENCE OF RELATIVE VARIANCE X1 X2
C                      LET A = DIFFERENCE OF VARIANCE OF THE MEAN X1 X2
C                      LET A = DIFFERENCE OF MINIMUM X1 X2
C                      LET A = DIFFERENCE OF MAXIMUM X1 X2
C                      LET A = DIFFERENCE OF EXTREMES X1 X2
C                      LET A = DIFFERENCE OF COEFFICENT OF VARI X1 X2
C                      LET A = DIFFERENCE OF COUNTS X1 X2
C                      LET A = DIFFERENCE OF SUM X1 X2
C                      LET A = DIFFERENCE OF VARI OF LP LOCATION X1 X2
C                      LET A = DIFFERENCE OF SD OF LP LOCATION X1 X2
C                      LET A = DIFFERENCE OF BINOMIAL PROBABILITY X1 X2
C
C     NOTE--THIS SUBROUTINE OPERATES ON A VECTOR
C           AND PRODUCES A PARAMETER (= A SCALAR);
C           THIS IS TO BE CONTRASTED WITH DPLET7 WHICH
C           OPERATES ON A VECTOR
C           BUT PRODUCES A VECTOR.
C     NOTE-INPUT WILL NECESSARILY BE A VECTOR (OR 2 VECTORS).
C          OUTPUT WILL NECESSARILY BE A SCALAR--
C               1) PARAMETER, OR
C               2) ELEMENT OF A VECTOR.
C          THE STATISTICS CAN BE CALCULATED ON A FULL VARIABLE
C          OR ON A PARTIAL VARIABLE.
C     EXAMPLE--LET A    = MEAN X                      (A FULL VARIABLE)
C            --LET Y(4) = MEAN X                      (A FULL VARIABLE)
C            --LET A    = MEAN X   SUBSET 2 3 5       (A PARTIAL VAR.)
C            --LET Y(4) = MEAN X   SUBSET 2 3 5       (A PARTIAL VAR.)
C            --LET A    = MEAN X   FOR I = 1 2 10     (A PARTIAL VAR.)
C            --LET Y(4) = MEAN X   FOR I = 1 2 10     (A PARTIAL VAR.)
C            --LET A    = CORRELATION X Y              (A FULL VARIABLE
C            --LET Y(4) = CORRELATION X Y              (A FULL VARIABLE
C            --LET A    = CORRELATION X Y  SUBSET 2 3 5     (A PARTIAL
C            --LET Y(4) = CORRELATION X Y  SUBSET 2 3 5     (A PARTIAL
C            --LET A    = CORRELATION X Y  FOR I = 1 2 10   (A PARTIAL
C            --LET Y(4) = CORRELATION X Y  FOR I = 1 2 10   (A PARTIAL
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION (AS A PART OF DPLET)--DECEMBER 1977.
C     UPDATED         --MAY       1982.
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MARCH 1978.
C     UPDATED         --JULY      1978.
C     UPDATED         --NOVEMBER  1978.
C     UPDATED         --MARCH     1979.
C     UPDATED         --APRIL     1979.
C     UPDATED         --JULY      1979.
C     UPDATED         --JUNE      1981.
C     UPDATED         --SEPTEMBER 1981.
C     UPDATED         --OCTOBER   1981.
C     UPDATED         --NOVEMBER  1981.
C     UPDATED         --NOVEMBER  1987.  (EXIT OUT IF ERROR)
C     UPDATED         --AUGUST    1988.  (WEIGHTED MEAN, MEDIAN, SD, VARIANCE)
C     UPDATED         --DECEMBER  1988.  LET Y(K) = MEAN X INSIDE LOOP
C     UPDATED         --JANUARY   1989.  TRY TO REUSE A PARAM. AS A VAR.
C     UPDATED         --FEBRUARY  1989.  AVERAGE ABSOLUTE DEVIATION (ALAN)
C     UPDATED         --APRIL     1990.  EXTREME
C     UPDATED         --SEPTEMBER 1990.  CP, CPK, % DEF, EXP. LOSS
C     UPDATED         --AUGUST    1991.  COMOVEMENT
C     UPDATED         --FEBRUARY  1994.  CHANGE ICASL8: RSD => RESD
C     UPDATED         --FEBRUARY  1994.  CHANGE ICASL8: SDM => SDME
C     UPDATED         --FEBRUARY  1994.  RELATIVE VARIANCE
C     UPDATED         --FEBRUARY  1994.  VARIANCE OF THE MEAN
C     UPDATED         --FEBRUARY  1994.  NORMAL PPCC
C     UPDATED         --FEBRUARY  1994.  TAGUCHI SN- SN0 SN+ SN00
C     UPDATED         --NOVEMBER  1994.  DISTINGUISH RELATIVE SD AND
C                                        COEF OF VARIATION CASES.
C     UPDATED         --MARCH     1995.  MAD
C     UPDATED         --NOVEMBER  1998.  <VALUE> PERCENTILE
C     UPDATED         --NOVEMBER  1998.  CPM, CC
C     UPDATED         --MARCH     1999.  CNPK
C     UPDATED         --MARCH     1999.  GEOMETRIC MEAN
C     UPDATED         --MARCH     1999.  GEOMETRIC STANDARD DEVIATION
C     UPDATED         --APRIL     2001.  ARGUMENT LIST TO CP, CPK, CPM
C     UPDATED         --APRIL     2001.  CPL, CPU
C     UPDATED         --AUGUST    2001.  COMMON DIGITS
C     UPDATED         --AUGUST    2001.  NUMBER OF COMMON DIGITS
C     UPDATED         --SEPTEMBER 2001.  IQ RANGE
C     UPDATED         --NOVEMBER  2001.  BIWEIGHT LOCATION
C     UPDATED         --NOVEMBER  2001.  BIWEIGHT SCALE
C     UPDATED         --JULY      2002.  WINSORIZED VARIANCE
C     UPDATED         --JULY      2002.  WINSORIZED SD
C     UPDATED         --JULY      2002.  WINSORIZED COVARIANCE
C     UPDATED         --JULY      2002.  WINSORIZED CORRELATION
C     UPDATED         --JULY      2002.  HODGES LEHMAN
C     UPDATED         --JULY      2002.  PERCENTAGE BEND MIDVARIANCE
C     UPDATED         --JULY      2002.  PERCENTAGE BEND CORRELATION
C     UPDATED         --JULY      2002.  BIWEIGHT MIDVARIANCE
C     UPDATED         --JULY      2002.  BIWEIGHT MIDCOVARIANCE
C     UPDATED         --JULY      2002.  BIWEIGHT MIDCORRELATION
C     UPDATED         --JULY      2002.  TRIMMED MEAN STANDARD ERROR
C     UPDATED         --JULY      2002.  QUANTILE STANDARD ERROR
C     UPDATED         --JULY      2002.  QUANTILE
C     UPDATED         --MARCH     2003.  ADD 32 "DIFFERENCE OF"
C                                        STATISTICS
C     UPDATED         --APRIL     2003.  ADD SN AND QN (AND DIFFERENCE
C                                        OF).  REQUIRED ADDITIONAL
C                                        SCRATCH ARRAYS.
C     UPDATED         --MAY       2003.  ADD WEIGHTED TRIMMED MEAN
C     UPDATED         --DECEMBER  2003.  BUG IN INTEGRAL (DETERMINE
C                                        WHETHER 1 OR 2 VARIABLES
C                                        SPECIFIED)
C     UPDATED         --OCTOBER   2004.  KENDELLS TAU
C     UPDATED         --FEBRUARY  2005.  REPEATABILITY SD
C     UPDATED         --FEBRUARY  2005.  REPRODUCABILITY SD
C     UPDATED         --SEPTEMBER 2005.  RATIO
C     UPDATED         --MARCH     2007.  RELATIVE RISK
C     UPDATED         --MARCH     2007.  CRAMER CONTINGENCY COEFFICENT
C     UPDATED         --MARCH     2007.  PEARSON CONTINGENCY COEFFICENT
C     UPDATED         --APRIL     2007.  POSITIVE PREDICTIVE VALUE
C     UPDATED         --APRIL     2007.  NEGATIVE PREDICTIVE VALUE
C     UPDATED         --APRIL     2007.  ODDS RATIO
C     UPDATED         --APRIL     2007.  STANDARD ERROR ODDS RATIO
C     UPDATED         --APRIL     2007.  LOG ODDS RATIO
C     UPDATED         --APRIL     2007.  LOG STANDARD ERROR ODDS RATIO
C     UPDATED         --MAY       2007.  TRIMMED STANDARD DEVIATION
C     UPDATED         --NOVEMBER  2007.  DOUBLE PRECISION ARRAYS FOR
C                                        CMPSTA
C     UPDATED         --NOVEMBER  2007.  LP LOCATION
C     UPDATED         --NOVEMBER  2007.  VARIANCE OF LP LOCATION
C     UPDATED         --NOVEMBER  2007.  SD OF LP LOCATION
C     UPDATED         --NOVEMBER  2007.  DIFFERENCE OF LP LOCATION
C     UPDATED         --NOVEMBER  2007.  DIFFERENCE OF VARI LP LOCATION
C     UPDATED         --NOVEMBER  2007.  DIFFERENCE OF SD LP LOCATION
C     UPDATED         --SEPTEMBER 2008.  BINOMIAL PROBABILITY
C     UPDATED         --SEPTEMBER 2008.  DIFFERENCE OF BINOMIAL PROB
C     UPDATED         --JANUARY   2010.  PASS ISTANR ARGUMENT
C     UPDATED         --JUNE      2010.  CALL LIST TO CMPSTA
C     UPDATED         --JUNE      2011.  ACCEPT MATRIX ARGUMENTS
C     UPDATED         --JANUARY   2012.  ACCEPT PARAMETER ARGUMENTS
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASL8
      CHARACTER*4 IFOUNZ
      CHARACTER*4 ITYPE
      CHARACTER*4 IHOL
      CHARACTER*4 IHOL2
      CHARACTER*4 IERRO1
      CHARACTER*4 IBUGA3
      CHARACTER*4 IBUGQ
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 NEWNAM
      CHARACTER*4 NEWCOL
      CHARACTER*4 ICASEL
      CHARACTER*4 ICASEQ
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 IWRITE
      CHARACTER*4 IHARG3
      CHARACTER*4 IHARG4
      CHARACTER*4 IHARG5
      CHARACTER*4 IHARG6
      CHARACTER*4 ILEFT
      CHARACTER*4 ILEFT2
      CHARACTER*4 ISUBSF
      CHARACTER*4 IFORF
      CHARACTER*4 IARG4T
      CHARACTER*4 IARG4F
      CHARACTER*4 IHSET
      CHARACTER*4 IHSET2
      CHARACTER*4 IH
      CHARACTER*4 IH2
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 IFLAGD
C
C---------------------------------------------------------------------
C
      DIMENSION IFOUNZ(*)
      DIMENSION IBEGIN(*)
      DIMENSION IEND(*)
      DIMENSION ITYPE(*)
      DIMENSION IHOL(*)
      DIMENSION IHOL2(*)
      DIMENSION INT1(*)
      DIMENSION FLOAT1(*)
      DIMENSION IERRO1(*)
C
      DIMENSION TEMP(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
C
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
      DIMENSION XTEMP3(*)
C
      DIMENSION ITEMP1(*)
      DIMENSION ITEMP2(*)
      DIMENSION ITEMP3(*)
      DIMENSION ITEMP4(*)
      DIMENSION ITEMP5(*)
      DIMENSION ITEMP6(*)
C
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION DTEMP2(*)
      DOUBLE PRECISION DTEMP3(*)
C
C---------------------------------------------------------------------
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
      INCLUDE 'DPCOST.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='AC  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      IFOUND='NO'
      IERROR='NO'
C
      ICOLL=0
      ICOL2=0
      NIRIG2=0
      ILOCSV=0
CCCCC FEBRUARY 1998.  ADD FOLLOWING LINE.  CAUSED A PROBLEM IN
CCCCC SOME CASES (RS_6000 COMPILED WITH f2c)
      NIOLD=0
C
      ICASEL='UNKN'
C
C               **********************************************************
C               **  TREAT THE SUBCASE OF CALCULATING CERTAIN            **
C               **  ELEMENTARY STATISTICS (MEAN, SD, ETC.)              **
C               **       1) FOR A FULL VARIABLE, OR                     **
C               **       2) FOR PART OF A VARIABLE.                     **
C               **********************************************************
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STAC')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTAC--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,IBUGQ
   52   FORMAT('IBUGA3,IBUGQ = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)ICASL8,ILOCV,ISTANR
   53   FORMAT('ICASL8,ILOCV,ISTANR = ',A4,2X,2I8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               **********************************
C               **  STEP 1--                    **
C               **  INITIALIZE SOME VARIABLES.  **
C               **********************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NEWNAM='NO'
      NEWCOL='NO'
      IFLAGD='OFF'
C
C               *********************************************************
C               **  STEP 2--                                            *
C               **  EXAMINE THE LEFT-HAND SIDE--                        *
C               **  IS THE PARAMETER OR VARIABLE NAME TO LEFT OF = SIGN *
C               **  ALREADY IN THE NAME LIST?                           *
C               **  NOTE THAT     ILEFT     IS THE NAME OF THE VARIABLE *
C               **  ON THE LEFT.                                        *
C               **  NOTE THAT     ILISTL    IS THE LINE IN THE TABLE    *
C               **  OF THE NAME ON THE LEFT.                            *
C               **  NOTE THAT     ICOLL    IS THE DATA COLUMN (1 TO 12) *
C               **  FOR THE NAME OF THE LEFT.                           *
C               *********************************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
CCCCC CALL DPTYP8(IANS,IWIDTH,IHNAME,IHNAM2,NUMNAM,MAXNAM,IBUGA3,
CCCCC1                  IFOUNZ,ITYPE,IHOL,IHOL2,INT1,FLOAT1,IERRO1)
      ILEFT=IHOL(2)
      ILEFT2=IHOL2(2)
      DO200I=1,NUMNAM
        I2=I
        IF(ILEFT.EQ.IHNAME(I).AND.ILEFT2.EQ.IHNAM2(I).AND.
     1    IUSE(I).EQ.'P')THEN
          ILISTL=I2
CCCCC     THE FOLLOWING LINE WAS COMMENTED OUT (JANUARY 1989)
CCCCC     AND REPLACED BY THE SUCCEEDING 12 LINES (JANUARY 1989)
CCCCC     TO FIX PROBLEM OF REUSING A PARAMETER AS A VARIABLE
CCCCC     (JANUARY 1989)
CCCCC     GOTO290
          IF(IFOUNZ(4).EQ.'NO')GOTO290
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,221)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,217)IHOL(2),IHOL2(2)
  217     FORMAT('      AN ATTEMPT WAS MADE TO USE ',A4,A4,' AS A ',
     1           'VARIABLE')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,218)
  218     FORMAT('      EVEN THOUGH IT ALREADY EXISTS AS A PARAMETER.')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ELSEIF(ILEFT.EQ.IHNAME(I).AND.ILEFT2.EQ.IHNAM2(I).AND.
     1    IUSE(I).EQ.'V')THEN
          ILISTL=I2
          ICOLL=IVALUE(ILISTL)
          NIOLD=IN(ILISTL)
          GOTO290
        ENDIF
  200 CONTINUE
C
      ISTEPN='2B'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NEWNAM='YES'
      ILISTL=NUMNAM+1
      IF(ILISTL.GT.MAXNAM)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,221)
  221   FORMAT('***** ERROR IN DPSTAC--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,222)
  222   FORMAT('      THE NUMBER OF VARIABLE AND/OR PARAMETER NAMES ',
     1         'HAS JUST')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,223)MAXNAM
  223   FORMAT('      EXCEEDED THE MAX ALLOWABLE ',I8,'  .  ',
     1         'SUGGESTED ACTION--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,225)
  225   FORMAT('      ENTER      STATUS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,226)
  226   FORMAT('      TO FIND OUT THE FULL LIST OF USED NAMES, AND')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,227)
  227   FORMAT('      THEN REDEFINE (REUSE) SOME OF THE ALREADY-USED',
     1         'NAMES')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO19000
      ENDIF
C
      ISTEPN='2C'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IARG4F=IFOUNZ(4)
      ISUBSF=IFOUNZ(11)
      IFORF=IFOUNZ(21)
      IF(IARG4F.EQ.'NO')GOTO290
      NIOLD=0
      ICOLL=NUMCOL+1
C
      IF(ICOLL.GT.MAXCOL)THEN
        WRITE(ICOUT,221)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,242)
  242   FORMAT('      THE NUMBER OF DATA COLUMNS HAS JUST EXCEEDED THE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,243)MAXCOL
  243   FORMAT('      MAX ALLOWABLE ',I8,'  .  SUGGESTED ACTION--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,245)
  245   FORMAT('      ENTER      STATUS VARIABLES')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,246)
  246   FORMAT('      TO FIND OUT THE FULL LIST OF USED COLUMNS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,247)
  247   FORMAT('      AND THEN OVERWRITE SOME COLUMNS.   EXAMPLE--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,248)
  248   FORMAT('      IF (E.G.)   LET Y(3) = MEAN X          FAILED')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,249)
  249   FORMAT('      THEN ONE MIGHT ENTER     NAME Y 7')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,250)
  250   FORMAT('      (THEREBY EQUATING THE NAME Y WITH COLUMN 7')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,251)
  251   FORMAT('      FOLLOWED BY              LET Y(3) = MEAN X ')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,252)
  252   FORMAT('      (WHICH WILL ACTUALLY OVERWRITE ROW 3 ',
     1         'OF COLUMN 7')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,253)
  253   FORMAT('      WITH THE CALCULATED MEAN OF VARIABLE X)')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO19000
      ENDIF
C
      ISTEPN='2D'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      MAXNI=0
      DO235I=1,12
        IF(IUSE(I).EQ.'V')THEN
          IF(IN(I).GT.MAXNI)MAXNI=IN(I)
        ENDIF
  235 CONTINUE
      IF(MAXNI.EQ.0)MAXNI=MAXN
C
  290 CONTINUE
C
      ISTEPN='2E'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C               *********************************************************
C               **  STEP 3--                                            *
C               **  EXAMINE THE RIGHT-HAND SIDE--                       *
C               **  HAS THE VARIABLE OR COLUMN ON THE RIGHT             *
C               **  ALREADY BEEN DEFINED?                               *
C               **  NOTE THAT     IRIGHT    IS THE NAME OF THE VARIABLE *
C               **  ON THE RIGHT.                                       *
C               **  NOTE THAT     ILISTR    IS THE LINE IN THE TABLE    *
C               **  OF THE VARIABLE OR COLUMN ON THE RIGHT.             *
C               **  NOTE THAT     ICOLR    IS THE DATA COLUMN (1 TO 12) *
C               **  FOR THE VARIABLE OR COLUMN ON THE RIGHT.            *
C               *********************************************************
C
C
C               ********************************************
C               **  STEP 4--                              **
C               **  BRANCH BETWEEN 1-VARIABLE STATISTICS  **
C               **  (E.G., MEAN, SD, MIN, ETC.)           **
C               **  AND 2-VARIABLE STATISTICS             **
C               **  (CORRELATION AND RANK CORRELATION).   **
C               ********************************************
C
      ISTEPN='4'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NUMVIN=1
      IF(ICASL8.EQ.'WEME' .OR. ICASL8.EQ.'WEMD' .OR.
     1   ICASL8.EQ.'WESD' .OR. ICASL8.EQ.'WEVA' .OR.
     1   ICASL8.EQ.'WETM' .OR. ICASL8.EQ.'INTE')THEN
        ILOCVP=ILOCV+1
        IH=IHARG(ILOCVP)
        IH2=IHARG2(ILOCVP)
        IF(ILOCVP.GT.NUMARG)THEN
          NUMVIN=1
        ELSEIF(IH.EQ.'SUBS'.AND.IH2.EQ.'ET  ')THEN
          NUMVIN=1
        ELSEIF(IH.EQ.'EXCE'.AND.IH2.EQ.'PT  ')THEN
          NUMVIN=1
        ELSEIF(IH.EQ.'FOR '.AND.IH2.EQ.'    ')THEN
          NUMVIN=1
        ELSE
          NUMVIN=2
        ENDIF
      ELSEIF(ISTANR.EQ.2)THEN
        NUMVIN=2
      ELSEIF(ISTANR.EQ.3)THEN
        NUMVIN=3
      ELSE
        NUMVIN=1
      ENDIF
C
C
C               ***************************************
C               **  STEP 5--                         **
C               **  EXTRACT THE FIRST VARIABLE       **
C               ***************************************
C
      ISTEPN='5'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IFLGP1=0
      IFLGP2=0
      IFLGP3=0
      NUMVAR=1
C
      IH=IHARG(ILOCV)
      IH2=IHARG2(ILOCV)
      DO1110I=1,NUMNAM
        I2=I
        IF(IH.EQ.IHNAME(I).AND.IH2.EQ.IHNAM2(I).AND.
     1    IUSE(I).EQ.'V')THEN
          ILISTR=I2
          ICOLR=IVALUE(ILISTR)
          NIRIGH=IN(ILISTR)
          ICOLR2=-99
          GOTO2000
        ELSEIF(IH.EQ.IHNAME(I).AND.IH2.EQ.IHNAM2(I).AND.
     1    IUSE(I).EQ.'M')THEN
          ILISTR=I2
          ICOLR=IVALUE(ILISTR)
          ICOLR2=IVALU2(ILISTR)
          NIRIGH=IN(ILISTR)
          NCOL=(ICOLR2 - ICOLR) + 1
          GOTO2000
        ELSEIF(IH.EQ.IHNAME(I).AND.IH2.EQ.IHNAM2(I).AND.
     1    IUSE(I).EQ.'P')THEN
          IFLGP1=1
          ILISTR=I2
          AVAL1=VALUE(ILISTR)
          NIRIGH=1
          GOTO2000
CCCCC     WRITE(ICOUT,999)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,221)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,1152)
C1152     FORMAT('      THE SPECIFIED ARGUMENT (VARIABLE NAME OR ',
CCCCC1           'COLUMN')
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,1154)
C1154     FORMAT('      NUMBER) ON THE RIGHT OF THE = SIGN WAS FOUND')
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,1155)
C1155     FORMAT('      IN THE INTERNAL NAME LIST, BUT AS A PARAMETER')
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,1157)
C1157     FORMAT('      AND NOT AS A VARIABLE AS IT SHOULD BE HERE.')
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,1158)
 1158     FORMAT('      THE COMMAND LINE WAS AS FOLLOWS--')
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,1159)(IANS(II),II=1,MIN(80,IWIDTH))
 1159     FORMAT(80A1)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     IERROR='YES'
CCCCC     GOTO19000
        ENDIF
 1110 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,221)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1112)
 1112 FORMAT('      THE SPECIFIED ARGUMENT (VARIABLE NAME OR COLUMN')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1114)
 1114 FORMAT('      NUMBER) ON THE RIGHT OF THE = SIGN WAS NOT FOUND')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1115)
 1115 FORMAT('      IN THE INTERNAL NAME LIST.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1158)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1159)(IANS(I),I=1,MIN(80,IWIDTH))
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO19000
C
C               ************************************************
C               **  STEP 6.2--                                **
C               **  EXTRACT THE SECOND VARIABLE               **
C               ************************************************
C
 2000 CONTINUE
C
      ISTEPN='6.2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMVIN.LT.2)GOTO700
C
      NUMVAR=2
      ILOCVP=ILOCV+1
      IF(ILOCVP.GT.NUMARG)THEN
        WRITE(ICOUT,221)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2302)
 2302   FORMAT('      NO SECOND VARIABLE NAME OR COLUMN NUMBER WAS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2303)
 2303   FORMAT('      WAS GIVEN AFTER THE STATISTIC CALCULATION')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1158)
        CALL DPWRST('XXX','BUG ')
        IF(IWIDTH.GE.1)THEN
          WRITE(ICOUT,1159)(IANS(I),I=1,MIN(80,IWIDTH))
          CALL DPWRST('XXX','BUG ')
        ENDIF
        IERROR='YES'
        GOTO19000
      ENDIF
C
      IHARG3=IHARG(ILOCVP)
      IHARG4=IHARG2(ILOCVP)
      DO2310I=1,NUMNAM
        I2=I
        IF(IHARG3.EQ.IHNAME(I).AND.IHARG4.EQ.IHNAM2(I).AND.
     1    IUSE(I).EQ.'V')THEN
          ILIST2=I2
          ICOL2=IVALUE(ILIST2)
          NIRIG2=IN(ILIST2)
          ICOL22=-99
          GOTO2390
        ELSEIF(IHARG3.EQ.IHNAME(I).AND.IHARG4.EQ.IHNAM2(I).AND.
     1    IUSE(I).EQ.'M')THEN
          ILIST2=I2
          ICOL2=IVALUE(ILIST2)
          ICOL22=IVALU2(ILIST2)
          NIRIG2=IN(ILIST2)
          NCOL2=(ICOL22 - ICOL2) + 1
          GOTO2390
        ELSEIF(IHARG3.EQ.IHNAME(I).AND.IHARG4.EQ.IHNAM2(I).AND.
     1    IUSE(I).EQ.'P')THEN
          IFLGP2=1
          ILIST2=I2
          AVAL2=VALUE(ILIST2)
          NIRIG2=1
          GOTO2390
CCCCC     WRITE(ICOUT,999)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,221)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,2322)
C2322     FORMAT('      THE SPECIFIED SECOND ARGUMENT VARIABLE NAME OR')
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,2324)
C2324     FORMAT('      COLUMN NUMBER) ON THE RIGHT OF THE = SIGN ',
CCCCC1           'WAS FOUND')
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,2325)
C2325     FORMAT('      IN THE INTERNAL NAME LIST, BUT AS A PARAMETER')
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,2327)
C2327     FORMAT('      AND NOT AS A VARIABLE AS IT SHOULD BE HERE.')
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,1158)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     IF(IWIDTH.GE.1)THEN
CCCCC       WRITE(ICOUT,1159)(IANS(II),II=1,MIN(80,IWIDTH))
CCCCC       CALL DPWRST('XXX','BUG ')
CCCCC     ENDIF
CCCCC     IERROR='YES'
CCCCC     GOTO19000
        ENDIF
 2310 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,221)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2312)
 2312 FORMAT('      THE SPECIFIED SECOND ARGUMENT (VARIABLE NAME OR')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2314)
 2314 FORMAT('      COLUMN NUMBER) ON THE RIGHT OF THE = SIGN')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2315)
 2315 FORMAT('      WAS NOT FOUND IN THE INTERNAL NAME LIST.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1158)
      CALL DPWRST('XXX','BUG ')
      IF(IWIDTH.GE.1)THEN
        WRITE(ICOUT,1159)(IANS(I),I=1,MIN(80,IWIDTH))
        CALL DPWRST('XXX','BUG ')
      ENDIF
      IERROR='YES'
      GOTO19000
C
 2390 CONTINUE
C
C
C               ******************************************************
C               **  STEP 6.4--                                      **
C               **  CHECK THAT THE 2 VARIABLES HAVE THE SAME        **
C               **  NUMBER OF ELEMENTS.                             **
C               ******************************************************
C
      ISTEPN='6.4'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     "DIFFERENCE OF" STATISTICS DO NOT REQUIRE EQUAL SAMPLE
C     SIZES
C
      IF(ICASL8.EQ.'DMEA')IFLAGD='ON'
      IF(ICASL8.EQ.'DMDM')IFLAGD='ON'
      IF(ICASL8.EQ.'DMED')IFLAGD='ON'
      IF(ICASL8.EQ.'DTRM')IFLAGD='ON'
      IF(ICASL8.EQ.'DWNM')IFLAGD='ON'
      IF(ICASL8.EQ.'DGEO')IFLAGD='ON'
      IF(ICASL8.EQ.'DHAR')IFLAGD='ON'
      IF(ICASL8.EQ.'DHDL')IFLAGD='ON'
      IF(ICASL8.EQ.'DBIW')IFLAGD='ON'
      IF(ICASL8.EQ.'DSD ')IFLAGD='ON'
      IF(ICASL8.EQ.'DRMS ')IFLAGD='ON'
      IF(ICASL8.EQ.'DVAR')IFLAGD='ON'
      IF(ICASL8.EQ.'DAAD')IFLAGD='ON'
      IF(ICASL8.EQ.'DMAD')IFLAGD='ON'
      IF(ICASL8.EQ.'DIQR')IFLAGD='ON'
      IF(ICASL8.EQ.'DWSD')IFLAGD='ON'
      IF(ICASL8.EQ.'DWVA')IFLAGD='ON'
      IF(ICASL8.EQ.'DBIM')IFLAGD='ON'
      IF(ICASL8.EQ.'DBIS')IFLAGD='ON'
      IF(ICASL8.EQ.'DPBN')IFLAGD='ON'
      IF(ICASL8.EQ.'DGSD')IFLAGD='ON'
      IF(ICASL8.EQ.'DRAN')IFLAGD='ON'
      IF(ICASL8.EQ.'DMDR')IFLAGD='ON'
      IF(ICASL8.EQ.'DQSE')IFLAGD='ON'
      IF(ICASL8.EQ.'DQUA')IFLAGD='ON'
      IF(ICASL8.EQ.'DSKE')IFLAGD='ON'
      IF(ICASL8.EQ.'DKUR')IFLAGD='ON'
      IF(ICASL8.EQ.'DRSD')IFLAGD='ON'
      IF(ICASL8.EQ.'DSDM')IFLAGD='ON'
      IF(ICASL8.EQ.'DRVA')IFLAGD='ON'
      IF(ICASL8.EQ.'DVAM')IFLAGD='ON'
      IF(ICASL8.EQ.'DMIN')IFLAGD='ON'
      IF(ICASL8.EQ.'DMAX')IFLAGD='ON'
      IF(ICASL8.EQ.'DEXT')IFLAGD='ON'
      IF(ICASL8.EQ.'DCVA')IFLAGD='ON'
      IF(ICASL8.EQ.'DCOU')IFLAGD='ON'
      IF(ICASL8.EQ.'DSUM')IFLAGD='ON'
      IF(ICASL8.EQ.'DPRO')IFLAGD='ON'
      IF(ICASL8.EQ.'DSN')IFLAGD='ON'
      IF(ICASL8.EQ.'DQN')IFLAGD='ON'
      IF(ICASL8.EQ.'DLPL')IFLAGD='ON'
      IF(ICASL8.EQ.'DLPV')IFLAGD='ON'
      IF(ICASL8.EQ.'DLPS')IFLAGD='ON'
      IF(ICASL8.EQ.'DBPR')IFLAGD='ON'
      IF(ICASL8.EQ.'DTSD')IFLAGD='ON'
      IF(ICASL8.EQ.'DPER')IFLAGD='ON'
      IF(ICASL8.EQ.'D1DE')IFLAGD='ON'
      IF(ICASL8.EQ.'D2DE')IFLAGD='ON'
      IF(ICASL8.EQ.'D3DE')IFLAGD='ON'
      IF(ICASL8.EQ.'D4DE')IFLAGD='ON'
      IF(ICASL8.EQ.'D5DE')IFLAGD='ON'
      IF(ICASL8.EQ.'D6DE')IFLAGD='ON'
      IF(ICASL8.EQ.'D7DE')IFLAGD='ON'
      IF(ICASL8.EQ.'D8DE')IFLAGD='ON'
      IF(ICASL8.EQ.'D9DE')IFLAGD='ON'
      IF(ICASL8.EQ.'DLHI')IFLAGD='ON'
      IF(ICASL8.EQ.'DUHI')IFLAGD='ON'
      IF(ICASL8.EQ.'DLQU')IFLAGD='ON'
      IF(ICASL8.EQ.'DUQU')IFLAGD='ON'
      IF(ICASL8.EQ.'DSSQ')IFLAGD='ON'
      IF(ICASL8.EQ.'DRSC')IFLAGD='ON'
      IF(ICASL8.EQ.'DQQR')IFLAGD='ON'
      IF(ICASL8.EQ.'10LD')IFLAGD='ON'
      IF(ICASL8.EQ.'KS2S')IFLAGD='ON'
      IF(ICASL8.EQ.'KSCV')IFLAGD='ON'
      IF(ICASL8.EQ.'CS2S')IFLAGD='ON'
      IF(ICASL8.EQ.'CC2S')IFLAGD='ON'
      IF(ICASL8.EQ.'CP2S')IFLAGD='ON'
      IF(ICASL8.EQ.'FTES')IFLAGD='ON'
      IF(ICASL8.EQ.'FTPV')IFLAGD='ON'
      IF(ICASL8.EQ.'FTCD')IFLAGD='ON'
      IF(ICASL8.EQ.'2TTE')IFLAGD='ON'
      IF(ICASL8.EQ.'2TCD')IFLAGD='ON'
      IF(ICASL8.EQ.'2T2P')IFLAGD='ON'
      IF(ICASL8.EQ.'2TLP')IFLAGD='ON'
      IF(ICASL8.EQ.'2TUP')IFLAGD='ON'
      IF(ICASL8.EQ.'PTTE')IFLAGD='ON'
      IF(ICASL8.EQ.'PTCD')IFLAGD='ON'
      IF(ICASL8.EQ.'PT2P')IFLAGD='ON'
      IF(ICASL8.EQ.'PTLP')IFLAGD='ON'
      IF(ICASL8.EQ.'PTUP')IFLAGD='ON'
      IF(ICASL8.EQ.'2STE')IFLAGD='ON'
      IF(ICASL8.EQ.'2SCD')IFLAGD='ON'
      IF(ICASL8.EQ.'2S2P')IFLAGD='ON'
      IF(ICASL8.EQ.'2SLP')IFLAGD='ON'
      IF(ICASL8.EQ.'2SUP')IFLAGD='ON'
      IF(ICASL8.EQ.'MWUS')IFLAGD='ON'
      IF(ICASL8.EQ.'MWTE')IFLAGD='ON'
      IF(ICASL8.EQ.'MWCD')IFLAGD='ON'
      IF(ICASL8.EQ.'MW2P')IFLAGD='ON'
      IF(ICASL8.EQ.'MWLP')IFLAGD='ON'
      IF(ICASL8.EQ.'MWUP')IFLAGD='ON'
      IF(ICASL8.EQ.'KLTE')IFLAGD='ON'
      IF(ICASL8.EQ.'KLCD')IFLAGD='ON'
      IF(ICASL8.EQ.'KL2P')IFLAGD='ON'
      IF(ICASL8.EQ.'KLLP')IFLAGD='ON'
      IF(ICASL8.EQ.'KLUP')IFLAGD='ON'
      IF(ICASL8.EQ.'SRTE')IFLAGD='ON'
      IF(ICASL8.EQ.'SRCD')IFLAGD='ON'
      IF(ICASL8.EQ.'SR2P')IFLAGD='ON'
      IF(ICASL8.EQ.'SRLP')IFLAGD='ON'
      IF(ICASL8.EQ.'SRUP')IFLAGD='ON'
      IF(ICASL8.EQ.'METE')IFLAGD='ON'
      IF(ICASL8.EQ.'MECD')IFLAGD='ON'
      IF(ICASL8.EQ.'ME2P')IFLAGD='ON'
      IF(ICASL8.EQ.'2SFR')IFLAGD='ON'
      IF(ICASL8.EQ.'2F2P')IFLAGD='ON'
      IF(ICASL8.EQ.'1LNT')IFLAGD='ON'
      IF(ICASL8.EQ.'1UNT')IFLAGD='ON'
      IF(ICASL8.EQ.'1KNT')IFLAGD='ON'
      IF(ICASL8.EQ.'2LNT')IFLAGD='ON'
      IF(ICASL8.EQ.'2UNT')IFLAGD='ON'
      IF(ICASL8.EQ.'2KNT')IFLAGD='ON'
      IF(ICASL8.EQ.'FMAT')IFLAGD='ON'
      IF(ICASL8.EQ.'LMAT')IFLAGD='ON'
      IF(ICASL8.EQ.'FNOM')IFLAGD='ON'
      IF(ICASL8.EQ.'LNOM')IFLAGD='ON'
C
      IF(NIRIG2.NE.NIRIGH .AND. IFLAGD.NE.'ON')THEN
        WRITE(ICOUT,221)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2412)
 2412   FORMAT('      FOR A 2-VARIABLE STATISTIC CALCULATION, THE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2413)
 2413   FORMAT('      NUMBER OF OBSERVATIONS IN EACH VARIABLE MUST BE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2415)
 2415   FORMAT('      THE SAME;  SUCH WAS NOT THE CASE HERE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2416)IH,IH2,NIRIGH
 2416   FORMAT('           VARIABLE ',A4,A4,' HAS ',I8,' OBSERVATIONS;')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2417)IHARG3,IHARG4,NIRIG2
 2417   FORMAT('           VARIABLE ',A4,A4,' HAS ',I8,' OBSERVATIONS.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1158)
        CALL DPWRST('XXX','BUG ')
        IF(IWIDTH.GE.1)THEN
          WRITE(ICOUT,1159)(IANS(I),I=1,MIN(80,IWIDTH))
          CALL DPWRST('XXX','BUG ')
        ENDIF
        IERROR='YES'
        GOTO19000
      ENDIF
C
C               ************************************************
C               **  STEP 6.5--                                **
C               **  EXTRACT THE THIRD  VARIABLE               **
C               ************************************************
C
 3000 CONTINUE
      ISTEPN='6.5'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMVIN.LT.3)GOTO700
C
      NUMVAR=3
      ILOCVP=ILOCV+2
      IF(ILOCVP.GT.NUMARG)THEN
        WRITE(ICOUT,221)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3302)
 3302   FORMAT('      NO THIRD VARIABLE NAME OR COLUMN NUMBER WAS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2303)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1158)
        CALL DPWRST('XXX','BUG ')
        IF(IWIDTH.GE.1)THEN
          WRITE(ICOUT,1159)(IANS(I),I=1,MIN(80,IWIDTH))
          CALL DPWRST('XXX','BUG ')
        ENDIF
        IERROR='YES'
        GOTO19000
      ENDIF
C
      IHARG5=IHARG(ILOCVP)
      IHARG6=IHARG2(ILOCVP)
      DO3310I=1,NUMNAM
        I2=I
        IF(IHARG5.EQ.IHNAME(I).AND.IHARG6.EQ.IHNAM2(I).AND.
     1    IUSE(I).EQ.'V')THEN
          ILIST3=I2
          ICOL3=IVALUE(ILIST3)
          NIRIG3=IN(ILIST3)
          ICOL32=-99
          GOTO3390
        ELSEIF(IHARG5.EQ.IHNAME(I).AND.IHARG6.EQ.IHNAM2(I).AND.
     1    IUSE(I).EQ.'M')THEN
          ILIST3=I2
          ICOL3=IVALUE(ILIST3)
          ICOL32=IVALU2(ILIST3)
          NIRIG3=IN(ILIST3)
          NCOL3=(ICOL32 - ICOL3) + 1
          GOTO3390
        ELSEIF(IHARG5.EQ.IHNAME(I).AND.IHARG6.EQ.IHNAM2(I).AND.
     1    IUSE(I).EQ.'P')THEN
          IFLGP3=1
          ILIST3=I2
          AVAL3=VALUE(ILIST3)
          NIRIG3=1
          GOTO3390
CCCCC     WRITE(ICOUT,999)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,221)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,3322)
C3322     FORMAT('      THE SPECIFIED THIRD ARGUMENT VARIABLE NAME OR')
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,2324)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,2325)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,2327)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,1158)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     IF(IWIDTH.GE.1)THEN
CCCCC       WRITE(ICOUT,1159)(IANS(II),II=1,MIN(80,IWIDTH))
CCCCC       CALL DPWRST('XXX','BUG ')
CCCCC     ENDIF
CCCCC     IERROR='YES'
CCCCC     GOTO19000
        ENDIF
 3310 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,221)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3312)
 3312 FORMAT('      THE SPECIFIED THIRD ARGUMENT (VARIABLE NAME OR')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2314)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2315)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1158)
      CALL DPWRST('XXX','BUG ')
      IF(IWIDTH.GE.1)THEN
        WRITE(ICOUT,1159)(IANS(I),I=1,MIN(80,IWIDTH))
        CALL DPWRST('XXX','BUG ')
      ENDIF
      IERROR='YES'
      GOTO19000
C
 3390 CONTINUE
C
C
C               ******************************************************
C               **  STEP 6.6--                                      **
C               **  CHECK THAT THE 3 VARIABLES HAVE THE SAME        **
C               **  NUMBER OF ELEMENTS.                             **
C               ******************************************************
C
      ISTEPN='6.6'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NIRIG3.NE.NIRIGH .AND. IFLAGD.NE.'ON')THEN
        WRITE(ICOUT,221)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3412)
 3412   FORMAT('      FOR A 3-VARIABLE STATISTIC CALCULATION, THE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2413)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2415)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3416)IH,IH2,NIRIGH
 3416   FORMAT('           VARIABLE ',A4,A4,' HAS ',I8,' OBSERVATIONS;')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3417)IHARG5,IHARG6,NIRIG3
 3417   FORMAT('           VARIABLE ',A4,A4,' HAS ',I8,' OBSERVATIONS.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1158)
        CALL DPWRST('XXX','BUG ')
        IF(IWIDTH.GE.1)THEN
          WRITE(ICOUT,1159)(IANS(II),II=1,MIN(80,IWIDTH))
          CALL DPWRST('XXX','BUG ')
        ENDIF
        IERROR='YES'
        GOTO19000
      ENDIF
C
C               *******************************
C               **  STEP 7--                 **
C               **  DETERMINE THE SUBCASE    **
C               **  AND BRANCH ACCORDINGLY.  **
C               *******************************
C
  700 CONTINUE
      ISTEPN='7'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IARG4F=IFOUNZ(4)
      IARG4T=ITYPE(4)
C
      ICASEL='UNKN'
      IF(IARG4F.EQ.'NO')ICASEL='PARA'
      IF(IARG4F.EQ.'YES'.AND.IARG4T.EQ.'NUMB')ICASEL='ELEM'
CCCCC THE FOLLOWING LINE WAS REPLACED                   (DECEMBER 1988)
CCCCC BY THE SUCCEEDING LINE                            (DECEMBER 1988)
CCCCC TO ALLOW    LET X(K) = MEAN ETC.  INSIDE LOOP     (DECEMBER 1988)
CCCCC IF(IARG4F.EQ.'YES'.AND.IARG4T.EQ.'WORD')ICASEL='VAR'
      IF(IARG4F.EQ.'YES'.AND.IARG4T.EQ.'WORD')ICASEL='ELEM'
      IF(ICASEL.EQ.'UNKN'.OR.ICASEL.EQ.'VAR')GOTO710
      GOTO729
C
  710 CONTINUE
      WRITE(ICOUT,221)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,712)
  712 FORMAT('      UNKNOWN VARIABLE/PARAMETER EXPRESSION')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,713)
  713 FORMAT('      TO THE LEFT OF THE EQUAL SIGN.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1158)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1159)(IANS(I),I=1,MIN(80,IWIDTH))
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO19000
C
  729 CONTINUE
C
      ICASEQ='UNKN'
      IMIN=ILOCV+1
      IF(IMIN.GT.NUMARG)GOTO741
      DO740I=IMIN,NUMARG
      IF(IHARG(I).EQ.'SUBS'.AND.IHARG2(I).EQ.'ET  ')GOTO742
      IF(IHARG(I).EQ.'EXCE'.AND.IHARG2(I).EQ.'PT  ')GOTO742
      IF(IHARG(I).EQ.'FOR '.AND.IHARG2(I).EQ.'    ')GOTO743
  740 CONTINUE
  741 CONTINUE
      ICASEQ='FULL'
      GOTO749
  742 CONTINUE
      ICASEQ='SUBS'
      GOTO749
  743 CONTINUE
      ICASEQ='FOR'
      GOTO749
  749 CONTINUE
      IF(ICASEQ.EQ.'UNKN')GOTO750
C
      IF(ICASEQ.EQ.'FULL')GOTO8000
      IF(ICASEQ.EQ.'SUBS')GOTO9000
      IF(ICASEQ.EQ.'FOR')GOTO10000
C
  750 CONTINUE
      WRITE(ICOUT,751)
  751 FORMAT('***** INTERNAL ERROR IN DPSTAC--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,752)
  752 FORMAT('      UNKNOWN QUALIFIER TYPE FOR LET COMMAND')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1158)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1159)(IANS(I),I=1,MIN(80,IWIDTH))
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO19000
C
C               ************************************************
C               **  STEP 8--                                  **
C               **  TREAT THE FULL VARIABLE CASE.             **
C               **  EXAMPLE--LET Y = SORT(X)                  **
C               **         --LET Y(I) = SORT(X)               **
C               **  JUMP TO STEP NUMBER 11 BELOW              **
C               **  FOR THE ACTUAL STATISTICAL CALCULATION,   **
C               **  FOR THE LIST UPDATING, AND                **
C               **  FOR SOME INFORMATIVE PRINTING.            **
C               ************************************************
C
 8000 CONTINUE
      ISTEPN='8'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NIOLD=NIRIGH
      IF(NUMVAR.GE.2.AND.NIRIG2.GT.NIOLD)NIOLD=NIRIG2
      NINEW=NIOLD
      DO8100I=1,NINEW
        ISUB(I)=1
 8100 CONTINUE
      GOTO11000
C
C               ****************************************************
C               **  STEP 9--                                       *
C               **  TREAT THE PARTIAL VARIABLE SUBSET CASE.        *
C               **  EXAMPLE--LET Y = SORT(X)    SUBSET 2 3 5       *
C               **         --LET Y(I) = SORT(X) SUBSET 2 3 5       *
C               **  JUMP TO STEP NUMBER 11 BELOW                   *
C               **  FOR THE ACTUAL STATISTICAL CALCULATION,        *
C               **  FOR THE LIST UPDATING, AND                     *
C               **  FOR SOME INFORMATIVE PRINTING.                 *
C               ****************************************************
C
 9000 CONTINUE
      ISTEPN='9'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMVAR.EQ.1)ILOCSV=ILOCV+2
      IF(NUMVAR.EQ.2)ILOCSV=ILOCV+3
      IF(NUMVAR.EQ.3)ILOCSV=ILOCV+4
      IHSET=IHARG(ILOCSV)
      IHSET2=IHARG2(ILOCSV)
      IHWUSE='V'
      MESSAG='YES'
      CALL CHECKN(IHSET,IHSET2,IHWUSE,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOC,IERROR)
      IF(IERROR.EQ.'YES')GOTO19000
      NIOLD=IN(ILOC)
      CALL DPSUBS(NIOLD,ILOCS,NS,IBUGQ,IERROR)
      NINEW=NIOLD
      GOTO11000
C
C               *****************************************************
C               **  STEP 10--                                       *
C               **  TREAT THE PARTIAL VARIABLE FOR CASE.            *
C               **  EXAMPLE--LET Y = SORT(X)    FOR I = 1 2 10      *
C               **         --LET Y(I) = SORT(X) FOR I = 1 2 10      *
C               **  JUMP TO STEP NUMBER 11 BELOW                    *
C               **  FOR THE ACTUAL STATISTICAL CALCULATION,         *
C               **  FOR THE LIST UPDATING, AND                      *
C              **  FOR SOME INFORMATIVE PRINTING.                   *
C               *****************************************************
C
10000 CONTINUE
      ISTEPN='10'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPFOR(NIOLD,NINEW,IROW1,IROWN,
     1NLOCAL,ILOCS,NS,IBUGQ,IERROR)
      NIFOR=NINEW
      GOTO11000
C
C               *******************************************
C               **  STEP 11--                            **
C               **  CARRY OUT THE                        **
C               **  ACTUAL STATISTICAL CALCULATION,      ZZ
C               **  THE LIST UPDATING, AND               **
C               **  GENERATE THE INFORMATIVE PRINTING    **
C               **  FOR STEP NUMBERS 7, 8, AND 9 ABOVE.  **
C               *******************************************
C
11000 CONTINUE
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NS2=0
      NS3=0
      NS4=0
C
C     EXTRACT DATA VARIABLE ONE.  HANDLE VARIABLE AND MATRIX
C     CASES DIFFERENTLY.
C
      IF(IFLGP1.EQ.1)THEN
        NS2=1
        TEMP(NS2)=AVAL1
      ELSEIF(ICOLR2.LE.0)THEN
        DO11100I=1,NINEW
          IF(ISUB(I).EQ.0)GOTO11100
          IF(I.GT.NIRIGH)GOTO11109
          NS2=NS2+1
C
          IJ=MAXN*(ICOLR-1)+I
          IF(ICOLR.LE.MAXCOL)TEMP(NS2)=V(IJ)
          IF(ICOLR.EQ.MAXCP1)TEMP(NS2)=PRED(I)
          IF(ICOLR.EQ.MAXCP2)TEMP(NS2)=RES(I)
          IF(ICOLR.EQ.MAXCP3)TEMP(NS2)=YPLOT(I)
          IF(ICOLR.EQ.MAXCP4)TEMP(NS2)=XPLOT(I)
          IF(ICOLR.EQ.MAXCP5)TEMP(NS2)=X2PLOT(I)
          IF(ICOLR.EQ.MAXCP6)TEMP(NS2)=TAGPLO(I)
C
11100   CONTINUE
11109   CONTINUE
      ELSE
        NLOOP=NCOL
        IF(NLOOP.LT.1)NLOOP=1
        NS2=0
        DO11101JLOOP=1,NLOOP
          DO11103I=1,NINEW
            IF(ISUB(I).EQ.0)GOTO11103
            IF(I.GT.NIRIGH)GOTO11105
            NS2=NS2+1
            IF(NS2.GT.MAXOBV)THEN
              WRITE(ICOUT,999)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,221)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,11106)
11106         FORMAT('      FOR THE MATRIX CASE, THE MAXIMUM NUMBER')
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,11107)
11107         FORMAT('      OF OBSERVATIONS HAS BEEN EXCEEDED.')
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,11108)MAXOBV
11108         FORMAT('      THE MAXIMUM NUMBER OF OBSERVATIONS = ',I10)
              CALL DPWRST('XXX','BUG ')
              IERROR='YES'
              GOTO9000
            ENDIF
            ICOLT=ICOLR+JLOOP-1
            IJ=MAXN*(ICOLT-1)+I
            IF(ICOLT.LE.MAXCOL)TEMP(NS2)=V(IJ)
            IF(ICOLT.EQ.MAXCP1)TEMP(NS2)=PRED(I)
            IF(ICOLT.EQ.MAXCP2)TEMP(NS2)=RES(I)
            IF(ICOLT.EQ.MAXCP3)TEMP(NS2)=YPLOT(I)
            IF(ICOLT.EQ.MAXCP4)TEMP(NS2)=XPLOT(I)
            IF(ICOLT.EQ.MAXCP5)TEMP(NS2)=X2PLOT(I)
            IF(ICOLT.EQ.MAXCP6)TEMP(NS2)=TAGPLO(I)
11103     CONTINUE
11105     CONTINUE
11101   CONTINUE
      ENDIF
C
      IF(NUMVAR.GE.2)THEN
        IF(IFLGP2.EQ.1)THEN
          NS3=1
          TEMP2(NS3)=AVAL2
        ELSEIF(ICOL22.LE.0)THEN
          DO11200I=1,NINEW
            IF(ISUB(I).EQ.0)GOTO11200
            IF(I.GT.NIRIG2)GOTO11209
            NS3=NS3+1
C
            IJ=MAXN*(ICOL2-1)+I
            IF(ICOL2.LE.MAXCOL)TEMP2(NS3)=V(IJ)
            IF(ICOL2.EQ.MAXCP1)TEMP2(NS3)=PRED(I)
            IF(ICOL2.EQ.MAXCP2)TEMP2(NS3)=RES(I)
            IF(ICOL2.EQ.MAXCP3)TEMP2(NS3)=YPLOT(I)
            IF(ICOL2.EQ.MAXCP4)TEMP2(NS3)=XPLOT(I)
            IF(ICOL2.EQ.MAXCP5)TEMP2(NS3)=X2PLOT(I)
            IF(ICOL2.EQ.MAXCP6)TEMP2(NS3)=TAGPLO(I)
C
11200     CONTINUE
11209     CONTINUE
        ELSE
          NLOOP=NCOL2
          IF(NLOOP.LT.1)NLOOP=1
          NS3=0
          DO11201JLOOP=1,NLOOP
            DO11203I=1,NINEW
              IF(ISUB(I).EQ.0)GOTO11203
              IF(I.GT.NIRIG2)GOTO11205
              NS3=NS3+1
              IF(NS3.GT.MAXOBV)THEN
                WRITE(ICOUT,999)
                CALL DPWRST('XXX','BUG ')
                WRITE(ICOUT,221)
                CALL DPWRST('XXX','BUG ')
                WRITE(ICOUT,11106)
                CALL DPWRST('XXX','BUG ')
                WRITE(ICOUT,11107)
                CALL DPWRST('XXX','BUG ')
                WRITE(ICOUT,11108)MAXOBV
                CALL DPWRST('XXX','BUG ')
                IERROR='YES'
                GOTO9000
              ENDIF
              ICOLT=ICOL2+JLOOP-1
              IJ=MAXN*(ICOLT-1)+I
              IF(ICOLT.LE.MAXCOL)TEMP2(NS3)=V(IJ)
              IF(ICOLT.EQ.MAXCP1)TEMP2(NS3)=PRED(I)
              IF(ICOLT.EQ.MAXCP2)TEMP2(NS3)=RES(I)
              IF(ICOLT.EQ.MAXCP3)TEMP2(NS3)=YPLOT(I)
              IF(ICOLT.EQ.MAXCP4)TEMP2(NS3)=XPLOT(I)
              IF(ICOLT.EQ.MAXCP5)TEMP2(NS3)=X2PLOT(I)
              IF(ICOLT.EQ.MAXCP6)TEMP2(NS3)=TAGPLO(I)
11203       CONTINUE
11205       CONTINUE
11201     CONTINUE
        ENDIF
      ENDIF
C
      IF(NUMVAR.GE.3)THEN
        IF(IFLGP3.EQ.1)THEN
          NS4=1
          TEMP3(NS4)=AVAL3
        ELSEIF(ICOL32.LE.0)THEN
          DO11300I=1,NINEW
            IF(ISUB(I).EQ.0)GOTO11300
            IF(I.GT.NIRIG3)GOTO11309
            NS4=NS4+1
C
            IJ=MAXN*(ICOL3-1)+I
            IF(ICOL3.LE.MAXCOL)TEMP3(NS4)=V(IJ)
            IF(ICOL3.EQ.MAXCP1)TEMP3(NS4)=PRED(I)
            IF(ICOL3.EQ.MAXCP2)TEMP3(NS4)=RES(I)
            IF(ICOL3.EQ.MAXCP3)TEMP3(NS4)=YPLOT(I)
            IF(ICOL3.EQ.MAXCP4)TEMP3(NS4)=XPLOT(I)
            IF(ICOL3.EQ.MAXCP5)TEMP3(NS4)=X2PLOT(I)
            IF(ICOL3.EQ.MAXCP6)TEMP3(NS4)=TAGPLO(I)
C
11300     CONTINUE
11309     CONTINUE
        ELSE
          NLOOP=NCOL3
          IF(NLOOP.LT.1)NLOOP=1
          NS4=0
          DO11301JLOOP=1,NLOOP
            DO11303I=1,NINEW
              IF(ISUB(I).EQ.0)GOTO11303
              IF(I.GT.NIRIG3)GOTO11305
              NS4=NS4+1
              IF(NS4.GT.MAXOBV)THEN
                WRITE(ICOUT,999)
                CALL DPWRST('XXX','BUG ')
                WRITE(ICOUT,221)
                CALL DPWRST('XXX','BUG ')
                WRITE(ICOUT,11106)
                CALL DPWRST('XXX','BUG ')
                WRITE(ICOUT,11107)
                CALL DPWRST('XXX','BUG ')
                WRITE(ICOUT,11108)MAXOBV
                CALL DPWRST('XXX','BUG ')
                IERROR='YES'
                GOTO9000
              ENDIF
              ICOLT=ICOL3+JLOOP-1
              IJ=MAXN*(ICOLT-1)+I
              IF(ICOLT.LE.MAXCOL)TEMP3(NS4)=V(IJ)
              IF(ICOLT.EQ.MAXCP1)TEMP3(NS4)=PRED(I)
              IF(ICOLT.EQ.MAXCP2)TEMP3(NS4)=RES(I)
              IF(ICOLT.EQ.MAXCP3)TEMP3(NS4)=YPLOT(I)
              IF(ICOLT.EQ.MAXCP4)TEMP3(NS4)=XPLOT(I)
              IF(ICOLT.EQ.MAXCP5)TEMP3(NS4)=X2PLOT(I)
              IF(ICOLT.EQ.MAXCP6)TEMP3(NS4)=TAGPLO(I)
11303       CONTINUE
11305       CONTINUE
11301     CONTINUE
        ENDIF
      ENDIF
C
      IF(NS2.LE.0)THEN
        IF(ICASL8.EQ.'NUMB')THEN
          RIGHT=0
          IFOUND='YES'
          IERROR='NO'
          IF(ICASEL.EQ.'PARA')GOTO15000
          IF(ICASEL.EQ.'ELEM')GOTO16000
        ELSE
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,12111)ICASL8
12111     FORMAT('****** ERROR--AFTER SUBSET/FOR/EXCEPT CLAUSE ',
     1           'APPLIED FOR STATISTIC ',A4,',')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,12113)
12113     FORMAT('       THE RESPONSE VARIABLE IS EMPTY.  THE ',
     1           'STATISTIC WAS NOT COMPUTED.')
          CALL DPWRST('XXX','BUG ')
          IFOUND='YES'
          IERROR='YES'
          GOTO19000
        ENDIF
      ENDIF
C
      IWRITE='ON'
      IF(IPRINT.EQ.'OFF')IWRITE='OFF'
      IF(IFEEDB.EQ.'OFF')IWRITE='OFF'
C
CCCCC MARCH 2003: CALL CMPSTA TO COMPUTE THE STATISTIC.
C
      ISTEPN='12'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL CMPSTA(
     1     TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,XTEMP3,
     1     MAXNXT,NS2,NS3,NS4,NUMVAR,ICASL8,
     1     ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1     DTEMP1,DTEMP2,DTEMP3,
CCCCC1     IQUAME,IQUASE,PSTAMV,
     1     RIGHT,
     1     ISUBRO,IBUGA3,IERROR)
C
      GOTO11900
C
11900 CONTINUE
      ISTEPN='13'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IFOUND='YES'
      IF(IERROR.EQ.'YES')GOTO19000
      IF(ICASEL.EQ.'PARA')GOTO15000
      IF(ICASEL.EQ.'ELEM')GOTO16000
C
C               *****************************************************
C               **  STEP 15--                                      **
C               **  TREAT THE PARAMETER CASE.                      **
C               **  EXAMPLE--LET A = MEAN X                        **
C               **           WHERE A WAS PREVIOUSLY UNDEFINED      **
C               **           OR WHERE A WAS PREVIOUSLY A PARAMETER.**
C               **  CARRY OUT THE LIST UPDATING  AND               **
C               **  GENERATE THE INFORMATIVE PRINTING.             **
C               **  THEN EXIT.                                     **
C               *****************************************************
C
15000 CONTINUE
      ISTEPN='15'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHNAME(ILISTL)=ILEFT
      IHNAM2(ILISTL)=ILEFT2
      IUSE(ILISTL)='P'
      VALUE(ILISTL)=RIGHT
C     ***** THE FOLLOWING LINE WAS ADDED 7/83 *****
      IVALUE(ILISTL)=VALUE(ILISTL)+0.5
      IN(ILISTL)=1
      IF(NEWNAM.EQ.'YES')NUMNAM=NUMNAM+1
C
      IF(IPRINT.EQ.'OFF')GOTO15119
      IF(IFEEDB.EQ.'OFF')GOTO15119
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,15111)ILEFT,ILEFT2,RIGHT
15111 FORMAT('THE COMPUTED VALUE OF THE CONSTANT ',
     1A4,A4,'      = ',G15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
15119 CONTINUE
      GOTO19000
C
C               *********************************************
C               **  STEP 16--                              **
C               **  TREAT THE ELEMENT SPECIFICATION CASE.  **
C               **  EXAMPLE--LET Y(4)=MEAN X               **
C              **  ALSO, CARRY OUT THE LIST UPDATING AND  **
C               **  GENERATE THE INFORMATIVE PRINTING.     **
C               *********************************************
C
16000 CONTINUE
      ISTEPN='16'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STAC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IARGL=INT1(4)
      IF(1.LE.IARGL.AND.IARGL.LE.MAXN)GOTO16100
      WRITE(ICOUT,221)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,16002)IARGL,ILEFT
16002 FORMAT('      THE SPECIFIED ROW (',I8,') OF VARIABLE ',A4,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,16003)RIGHT
16003 FORMAT('      (THAT WAS TO BE SET = ',G15.7,')')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,16004)
16004 FORMAT('      WAS LESS THAN 1 OR')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,16005)MAXN
16005 FORMAT('      GREATER THAN THE MAX ALLOWABLE ',I8)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO19000
C
16100 CONTINUE
CCCCC THE FOLLOWING 2 LINES WERE ADDED     (DECEMBER 1988)
CCCCC TO FIX PROBLEM OF LET Y(K) = MEAN X  (DECEMBER 1988)
CCCCC INSIDE A LOOP                        (DECEMBER 1988)
      IF(NEWNAM.EQ.'NO')NIOLD=IN(ILISTL)
      IF(NEWNAM.EQ.'YES')NIOLD=1
      NINEW=NIOLD
      IF(IARGL.GT.NINEW)NINEW=IARGL
      NS2=1
C
      IJ=MAXN*(ICOLL-1)+IARGL
      IF(ICOLL.LE.MAXCOL)V(IJ)=RIGHT
      IF(ICOLL.EQ.MAXCP1)PRED(IARGL)=RIGHT
      IF(ICOLL.EQ.MAXCP2)RES(IARGL)=RIGHT
      IF(ICOLL.EQ.MAXCP3)YPLOT(IARGL)=RIGHT
      IF(ICOLL.EQ.MAXCP4)XPLOT(IARGL)=RIGHT
      IF(ICOLL.EQ.MAXCP5)X2PLOT(IARGL)=RIGHT
      IF(ICOLL.EQ.MAXCP6)TAGPLO(IARGL)=RIGHT
C
      IHNAME(ILISTL)=ILEFT
      IHNAM2(ILISTL)=ILEFT2
      IUSE(ILISTL)='V'
      IVALUE(ILISTL)=ICOLL
      VALUE(ILISTL)=ICOLL
      IN(ILISTL)=NINEW
C
CCCCC IUSE(ICOLL)='V'
CCCCC IVALUE(ICOLL)=ICOLL
CCCCC VALUE(ICOLL)=ICOLL
CCCCC IN(ICOLL)=NINEW
C
      IF(NEWNAM.EQ.'YES')NUMNAM=NUMNAM+1
      IF(NEWNAM.EQ.'YES')NUMCOL=NUMCOL+1
C
      DO16200J4=1,NUMNAM
      IF(IUSE(J4).EQ.'V'.AND.IVALUE(J4).EQ.ICOLL)GOTO16205
      GOTO16200
16205 CONTINUE
      IUSE(J4)='V'
      IVALUE(J4)=ICOLL
      VALUE(J4)=ICOLL
      IN(J4)=NINEW
16200 CONTINUE
C
      IF(IPRINT.EQ.'OFF')GOTO16119
      IF(IFEEDB.EQ.'OFF')GOTO16119
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,16111)ILEFT,ILEFT2,IARGL,RIGHT
16111 FORMAT('THE COMPUTED VALUE OF ',
     1A4,A4,'(',I6,')      = ',G15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
16119 CONTINUE
      GOTO19000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
19000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STAC')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,19011)
19011   FORMAT('***** AT THE END       OF DPSTAC--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,19012)IFOUND,IERROR
19012   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)IBUGA3,IBUGQ
 9013   FORMAT('IBUGA3,IBUGQ = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9014)ICASL8,ILOCV,IWRITE,IFLAGD
 9014   FORMAT('ICASL8,ILOCV,IWRITE,IFLAGD = ',A4,2X,I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,19015)NS2,NS3,NS4
19015   FORMAT('NS2,NS3,NS4 = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,19017)ICASEL,RIGHT
19017   FORMAT('ICASEL,RIGHT = ',A4,E15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTAR(NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2,
     1                  IBUGG2,IBUGG3,IBUGQ,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--GENERATE A STAR PLOT--
C              A MULTIVARIATE TECHNICQUE WHICH PLOTS A SEQUENCE
C              OF RADIAL SPOKES AT EQUAL ANGLES AROUND A CIRCLE.
C              EACH RADIAL SPOKE REPRESENTS A SEPARATE VARIABLE.
C              THE LENGTH OF EACH RADIAL SPOKE IS PROPORTIONAL
C              TO THE RELATIVE SIZE OF THE RESPONSE.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--88/2
C     ORIGINAL VERSION--FEBRUARY  1988.
C     UPDATED         --JUNE      1990. TEMPORARY ARRAYS TO GARBAGE COMMON
C     UPDATED         --MARCH     2011. USE DPPARS
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IAND1
      CHARACTER*4 IAND2
      CHARACTER*4 IBUGG2
      CHARACTER*4 IBUGG3
      CHARACTER*4 IBUGQ
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=50)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
C
      DIMENSION Z1(MAXOBV)
      DIMENSION Z2(MAXOBV)
      DIMENSION Z3(MAXOBV)
      DIMENSION YSUB(MAXOBV)
      DIMENSION YFULL(MAXOBV)
      DIMENSION XTEMP(MAXOBV)
CCCCC FOLLOWING LINES ADDED JUNE, 1990
      INCLUDE 'DPCOZZ.INC'
      EQUIVALENCE (GARBAG(IGARB1),Z1(1))
      EQUIVALENCE (GARBAG(IGARB2),Z2(1))
      EQUIVALENCE (GARBAG(IGARB3),Z3(1))
      EQUIVALENCE (GARBAG(IGARB4),YSUB(1))
      EQUIVALENCE (GARBAG(IGARB5),YFULL(1))
      EQUIVALENCE (GARBAG(IGARB6),XTEMP(1))
CCCCC END CHANGE
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='NO'
C
      ISUBN1='DPST'
      ISUBN2='AR  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
C               ***********************************
C               **  TREAT THE STAR PLOT CASE     **
C               ***********************************
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'STAR')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTAR--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGG2,IBUGG3,IBUGQ,ISUBRO
   52   FORMAT('IBUGG2,IBUGG3,IBUGQ,ISUBRO = ',3(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)ICASPL,IAND1,IAND2
   53   FORMAT('ICASPL,IAND1,IAND2 = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ***************************
C               **  STEP 1--             **
C               **  EXTRACT THE COMMAND  **
C               ***************************
C
      ISTEPN='11'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'STAR')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ICASPL='STAR'
C
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'PLOT')THEN
        IFOUND='YES'
        ILASTC=1
        CALL ADJUST(ILASTC,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
      ELSE
        IFOUND='NO'
        GOTO9000
      ENDIF
C
C               ****************************************
C               **  STEP 2--                          **
C               **  EXTRACT THE VARIABLE LIST         **
C               ****************************************
C
      ISTEPN='2'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'STAR')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='STAR PLOT'
      MINNA=1
      MAXNA=100
      MINN2=1
      IFLAGE=1
      IFLAGM=0
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
      MINNVA=1
      MAXNVA=MAXSPN
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGG3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'STAR')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I),IVARTY(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I),IVARTY(I) = ',I8,2X,A4,A4,2X,3I8,2X,A4)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
      IWRITE='OFF'
      DO2200K=1,NUMVAR
        JF=0
        JS=0
        IMAX=NRIGHT(K)
        IF(NQ.LT.NRIGHT(1))IMAX=NQ
        DO2210I=1,IMAX
C
C         CREATE THE "FULL" VARIABLE
C
          JF=JF+1
          IJ=MAXN*(ICOLR(K)-1)+I
          IF(ICOLR(K).LE.MAXCOL)YFULL(JF)=V(IJ)
          IF(ICOLR(K).EQ.MAXCP1)YFULL(JF)=PRED(I)
          IF(ICOLR(K).EQ.MAXCP2)YFULL(JF)=RES(I)
          IF(ICOLR(K).EQ.MAXCP3)YFULL(JF)=YPLOT(I)
          IF(ICOLR(K).EQ.MAXCP4)YFULL(JF)=XPLOT(I)
          IF(ICOLR(K).EQ.MAXCP5)YFULL(JF)=X2PLOT(I)
          IF(ICOLR(K).EQ.MAXCP6)YFULL(JF)=TAGPLO(I)
 2210   CONTINUE
        NFULL=JF
        CALL MINIM(YFULL,NFULL,IWRITE,XMIN,IBUGG3,IERROR)
        CALL MAXIM(YFULL,NFULL,IWRITE,XMAX,IBUGG3,IERROR)
        Z2(K)=XMIN
        Z3(K)=XMAX
C
C       CREATE THE "SUBSET" VARIABLE
C
        DO2240I=1,IMAX
          IF(ISUB(I).EQ.0)GOTO2240
          JS=JS+1
          IJ=MAXN*(ICOLR(K)-1)+I
C
          IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'STAR')THEN
             WRITE(ICOUT,2241)I,JS,MAXN,ICOLR(I),IJ,NRIGHT(I),NQ,IMAX
 2241        FORMAT('I,JS,MAXN,ICOLR(I),IJ,NRIGHT(I),NQ,IMAX = ',8I8)
             CALL DPWRST('XXX','BUG ')
          ENDIF
C
          IF(ICOLR(K).LE.MAXCOL)YSUB(JS)=V(IJ)
          IF(ICOLR(K).EQ.MAXCP1)YSUB(JS)=PRED(I)
          IF(ICOLR(K).EQ.MAXCP2)YSUB(JS)=RES(I)
          IF(ICOLR(K).EQ.MAXCP3)YSUB(JS)=YPLOT(I)
          IF(ICOLR(K).EQ.MAXCP4)YSUB(JS)=XPLOT(I)
          IF(ICOLR(K).EQ.MAXCP5)YSUB(JS)=X2PLOT(I)
          IF(ICOLR(K).EQ.MAXCP6)YSUB(JS)=TAGPLO(I)
C
 2240   CONTINUE
        NSUB=JS
C
        CALL MEDIAN(YSUB,NSUB,IWRITE,XTEMP,MAXN,XMED,IBUGG3,IERROR)
        Z1(K)=XMED
C
 2200 CONTINUE
      NZ=NUMVAR
C
C               ********************************************************
C               **  STEP 31--                                         **
C               **  FORM THE VERTICAL AND HORIZONTAL AXIS             **
C               **  VALUES Y(.) AND X(.) FOR THE PLOT.                **
C               **  DEFINE THE VECTOR D(.) TO 1'S, 2'S, AND 3'S       **
C               **  FOR THE PLOTTED VALUE, THE LOWER CONFIDENCE LINE, **
C               **  AND THE UPPER CONFIDENCE LINE.                    **
C               **  DEFINE THE NUMBER OF PLOT POINTS    (NPLOTP).     **
C               **  DEFINE THE NUMBER OF PLOT VARIABLES (NPLOTV).     **
C               ********************************************************
C
      ISTEPN='8'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'STAR')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPSTA2(Z1,Z2,Z3,NZ,ICASPL,
     1            Y,X,D,NPLOTP,NPLOTV,
     1            IBUGG3,ISUBRO,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'STAR')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPPROF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)IFOUND,IERROR
 9013   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9014)NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2
 9014   FORMAT('NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2 = ',
     1         I8,I8,I8,2X,A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9021)NSUB,NFULL,NZ,NPLOTP
 9021   FORMAT('NSUB,NFULL,NZ,NPLOTP = ',4I8)
        CALL DPWRST('XXX','BUG ')
        IF(NSUB.GT.0)THEN
          DO9022I=1,NSUB
            WRITE(ICOUT,9023)I,YSUB(I)
 9023       FORMAT('I,YSUB(I) = ',I8,E15.7)
            CALL DPWRST('XXX','BUG ')
 9022     CONTINUE
        ENDIF
        IF(NFULL.GT.0)THEN
          DO9032I=1,NFULL
            WRITE(ICOUT,9033)I,YFULL(I)
 9033       FORMAT('I,YFULL(I) = ',I8,E15.7)
            CALL DPWRST('XXX','BUG ')
 9032     CONTINUE
        ENDIF
        IF(NZ.GT.0)THEN
          DO9042I=1,NZ
            WRITE(ICOUT,9043)I,Z1(I),Z2(I),Z3(I)
 9043       FORMAT('I,Z1(I),Z2(I),Z3(I) = ',I8,3G15.7)
            CALL DPWRST('XXX','BUG ')
 9042     CONTINUE
 9044   ENDIF
        IF(NPLOTP.GT.0)THEN
          DO9052I=1,NPLOTP
            WRITE(ICOUT,9053)I,Y(I),X(I),D(I)
 9053       FORMAT('I,Y(I),X(I),D(I) = ',I8,3F12.5)
            CALL DPWRST('XXX','BUG ')
 9052     CONTINUE
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTAT(
     1IFOUND,IERROR)
C
C     PURPOSE--WRITE OUT A STATUS LISTING OF PARAMETERS,
C              VARIABLES, AND PLOT SPECIFICATIONS.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--DECEMBER  1977.
C     UPDATED         --APRIL     1978.
C     UPDATED         --JULY      1978.
C     UPDATED         --DECEMBER  1978.
C     UPDATED         --MARCH     1979.
C     UPDATED         --JULY      1979.
C     UPDATED         --NOVEMBER  1980.
C     UPDATED         --MARCH     1981.
C     UPDATED         --SEPTEMBER 1981.
C     UPDATED         --MARCH     1982.
C     UPDATED         --MAY       1982.
C     UPDATED         --DECEMBER  1991. DIME, VARI, PARA, ETC. ARGS
C     UPDATED         --DECEMBER  1991. VARI/PARAM FORMAT STATEMENTS
C     UPDATED         --SEPTEMBER 1993. WRITE MESSAGE IF NO VAR.,
C                                       PAR. FUNC., ETC.
C     UPDATED         --JANUARY   2007. CRASH ON "STATUS LEGEND".
C                                       ADD SOME DIMENSION CHECKS TO
C                                       AVOID THESE.
C     UPDATED         --JULY      2009. FOR "STATUS VARIABLES", PRINT
C                                       IN SORTED ORDER
C     UPDATED         --SEPTEMBER 2010. LS IS SYNONYM FOR STATUS
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IJUNK
      CHARACTER*4 IJUNK2
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*1 CTEMP
C
C---------------------------------------------------------------------
C
      DIMENSION IJUNK(100)
      DIMENSION IJUNK2(100)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOMC.INC'
      INCLUDE 'DPCODB.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCOPC.INC'
      INCLUDE 'DPCOSU.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOHO.INC'
      INCLUDE 'DPCOF2.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='AT  '
C
      IFOUND='NO'
      IERROR='NO'
C
      NI=0
      NUMELE=0
      KMAX=0
C
      IF(IBUGS2.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('AT THE BEGINNING OF DPSTAT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)IBUGS2
   53   FORMAT('IBUGS2 = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,54)IPR,NUMARG,NUMNAM
   54   FORMAT('IPR,NUMARG,NUMNAM = ',3I10)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,56)IHARG(1)
   56   FORMAT('IHARG(1) = ',A4)
        CALL DPWRST('XXX','BUG ')
        DO69I=1,NUMNAM
          WRITE(ICOUT,62)I,IHNAME(I),IHNAM2(I),IUSE(I)
   62     FORMAT('I,IHNAME,IHNAM2,IUSE   = ',I4,3(A4,1X))
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,63)IN(I),IVALUE(I),IVALU2(I)
   63     FORMAT('IN,IVALUE,IVALU2  = ',3I8)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,64)IVSTAR(I),IVSTOP(I),VALUE(I)
   64     FORMAT('IVSTAR,IVSTOP,VALUE     = ',2I8,E15.7)
          CALL DPWRST('XXX','BUG ')
   69   CONTINUE
      ENDIF
C
C               *****************************
C               **  TREAT THE STATUS CASE  **
C               *****************************
C
      IFOUND='YES'
C
C               *********************************************
C               **  STEP 10--                               **
C               **  PRINT OUT DETAILED STATUS INFORMATION  **
C               *********************************************
C
C               ****************************************
C               **  STEP 11--                         **
C               **  TREAT THE MACHINE CONSTANTS CASE  **
C               ****************************************
C
      IF(IHARG(1).EQ.'MACH')GOTO1100
      IF(IHARG(1).EQ.'COMP')GOTO1100
      IF(IHARG(1).EQ.'SITE')GOTO1100
      IF(IHARG(1).EQ.'HOST')GOTO1100
      GOTO1190
C
 1100 CONTINUE
      ISTEPN='11'
      IF(IBUGS2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1111)
 1111 FORMAT('STATUS OF MACHINE CONSTANTS--')
      CALL DPWRST('XXX','WRIT')
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1112)IHOST1,IHOST2
 1112 FORMAT('IHOST1,IHOST2  (HOST) = ',A4,2X,A4)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1113)IHMOD1,IHMOD2
 1113 FORMAT('IHMOD1,IHMOD2 (MODEL) = ',A4,2X,A4)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1114)IOPSY1,IOPSY2
 1114 FORMAT('IOPSY1,IOPSY2 (OPERATING SYSTEM) = ',A4,2X,A4)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1115)ICOMPI
 1115 FORMAT('ICOMPI        (COMPILER) = ',A4)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1116)ISITE
 1116 FORMAT('ISITE         (SITE) = ',A4)
      CALL DPWRST('XXX','WRIT')
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1123)IPR,IRD,CPUMIN,CPUMAX
 1123 FORMAT('IPR,IRD,CPUMIN,CPUMAX = ',2I6,2E15.7)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1124)NUMBPC,NUMCPW,NUMBPW
 1124 FORMAT('NUMBPC,NUMCPW,NUMBPW = ',3I6)
      CALL DPWRST('XXX','WRIT')
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      DO1130I=1,16
      IF(NUMBPW.LT.32)WRITE(ICOUT,1131)I,I1MACH(I)
 1131 FORMAT('I,I1MACH(I) = ',I8,2X,I8)
      IF(NUMBPW.LT.32)CALL DPWRST('XXX','WRIT')
      IF(NUMBPW.EQ.32)WRITE(ICOUT,1132)I,I1MACH(I)
 1132 FORMAT('I,I1MACH(I) = ',I8,2X,I11)
      IF(NUMBPW.EQ.32)CALL DPWRST('XXX','WRIT')
      IF(NUMBPW.EQ.36)WRITE(ICOUT,1133)I,I1MACH(I)
 1133 FORMAT('I,I1MACH(I) = ',I8,2X,I12)
      IF(NUMBPW.EQ.36)CALL DPWRST('XXX','WRIT')
      IF(NUMBPW.EQ.48)WRITE(ICOUT,1134)I,I1MACH(I)
 1134 FORMAT('I,I1MACH(I) = ',I8,2X,I16)
      IF(NUMBPW.EQ.48)CALL DPWRST('XXX','WRIT')
      IF(NUMBPW.GE.60)WRITE(ICOUT,1135)I,I1MACH(I)
 1135 FORMAT('I,I1MACH(I) = ',I8,2X,I20)
      IF(NUMBPW.GE.60)CALL DPWRST('XXX','WRIT')
      IF(NUMBPW.GT.32.AND.NUMBPW.NE.36.AND.
     1   NUMBPW.NE.48.AND.NUMBPW.NE.60)WRITE(ICOUT,1136)I,I1MACH(I)
 1136 FORMAT('I,I1MACH(I) = ',I8,2X,I8)
      IF(NUMBPW.GT.32.AND.NUMBPW.NE.36.AND.
     1   NUMBPW.NE.48.AND.NUMBPW.NE.60)CALL DPWRST('XXX','WRIT')
 1130 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      DO1140I=1,5
      WRITE(ICOUT,1141)I,R1MACH(I)
 1141 FORMAT('I,R1MACH(I)  = ',I8,2X,E15.7)
      CALL DPWRST('XXX','WRIT')
 1140 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      DO1150I=1,5
      WRITE(ICOUT,1151)I,D1MACH(I)
 1151 FORMAT('I,D1MACH(I)  = ',I8,2X,D15.7)
      CALL DPWRST('XXX','WRIT')
 1150 CONTINUE
      GOTO9000
C
 1190 CONTINUE
C
C               ***************************
C               **  STEP 12--            **
C               **  TREAT THE FILE CASE  **
C               ***************************
C
      IF(IHARG(1).EQ.'FILE')GOTO1200
      IF(IHARG(1).EQ.'I/O')GOTO1200
      GOTO1290
C
 1200 CONTINUE
      ISTEPN='12'
      IF(IBUGS2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1211)
 1211 FORMAT('STATUS OF FILES--')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1253)IPR,IRD,CPUMIN,CPUMAX
 1253 FORMAT('IPR,IRD,CPUMIN,CPUMAX = ',2I6,2E15.7)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1254)NUMBPC,NUMCPW,NUMBPW
 1254 FORMAT('NUMBPC,NUMCPW,NUMBPW = ',3I6)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1261)IMESNU,IMESST,IMESNA
 1261 FORMAT('IMESNU,IMESST,IMESNA = ',I8,2X,A12,2X,A80)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1262)INEWNU,INEWST,INEWNA
 1262 FORMAT('INEWNU,INEWST,INEWNA = ',I8,2X,A12,2X,A80)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1264)IHELNU,IHELST,IHELNA
 1264 FORMAT('IHELNU,IHELST,IHELNA = ',I8,2X,A12,2X,A80)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1265)IBUGNU,IBUGST,IBUGNA
 1265 FORMAT('IBUGNU,IBUGST,IBUGNA = ',I8,2X,A12,2X,A80)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1267)ISYSNU,ISYSST,ISYSNA
 1267 FORMAT('ISYSNU,ISYSST,ISYSNA = ',I8,2X,A12,2X,A80)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1268)ILOGNU,ILOGST,ILOGNA
 1268 FORMAT('ILOGNU,ILOGST,ILOGNA = ',I8,2X,A12,2X,A80)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1271)IREANU,IREAST,IREANA
 1271 FORMAT('IREANU,IREAST,IREANA = ',I8,2X,A12,2X,A80)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1272)IWRINU,IWRIST,IWRINA
 1272 FORMAT('IWRINU,IWRIST,IWRINA = ',I8,2X,A12,2X,A80)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1273)ISAVNU,ISAVST,ISAVNA
 1273 FORMAT('ISAVNU,ISAVST,ISAVNA = ',I8,2X,A12,2X,A80)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1274)ICRENU,ICREST,ICRENA
 1274 FORMAT('ICRENU,ICREST,ICRENA = ',I8,2X,A12,2X,A80)
      CALL DPWRST('XXX','WRIT')
CCCCC WRITE(ICOUT,1275)IMACNU,IMACST,IMACNA
C1275 FORMAT('IMACNU,IMACST,IMACNA = ',I8,2X,A12,2X,A80)
CCCCC CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1276)ISCRNU,ISCRST,ISCRNA
 1276 FORMAT('ISCRNU,ISCRST,ISCRNA = ',I8,2X,A12,2X,A80)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1277)IDATNU,IDATST,IDATNA
 1277 FORMAT('IDATNU,IDATST,IDATNA = ',I8,2X,A12,2X,A80)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1278)IPL1NU,IPL1ST,IPL1NA
 1278 FORMAT('IPL1NU,IPL1ST,IPL1NA = ',I8,2X,A12,2X,A80)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1279)IPL2NU,IPL2ST,IPL2NA
 1279 FORMAT('IPL2NU,IPL2ST,IPL2NA = ',I8,2X,A12,2X,A80)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1280)IPRONU,IPROST,IPRONA
 1280 FORMAT('IPRONU,IPROST,IPRONA = ',I8,2X,A12,2X,A80)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1281)ICONNU,ICONST,ICONNA
 1281 FORMAT('ICONNU,ICONST,ICONNA = ',I8,2X,A12,2X,A80)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      GOTO9000
C
 1290 CONTINUE
C
C               *****************************
C               **  STEP 21--              **
C               **  TREAT THE ARROWS CASE  **
C               *****************************
C
      IF(IHARG(1).EQ.'ARRO')GOTO2100
      GOTO2190
C
 2100 CONTINUE
      ISTEPN='21'
      IF(IBUGS2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,2111)
 2111 FORMAT('STATUS OF ARROWS--')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,2112)NUMARR
 2112 FORMAT('       NUMBER OF ARROWS = ',I8)
      CALL DPWRST('XXX','WRIT')
C
CCCCC THE FOLLOWING LINE WAS CHANGED    SEPTEMBER 1993
CCCCC IF(NUMARR.LE.0)GOTO2180
      IF(NUMARR.LE.0)THEN
         WRITE(ICOUT,999)
         CALL DPWRST('XXX','WRIT')
         WRITE(ICOUT,2105)
 2105    FORMAT('NO ARROWS DEFINED')
         CALL DPWRST('XXX','WRIT')
         GOTO2180
      ENDIF
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      DO2115I=1,NUMARR
      IF(PARRXC(I,1).LT.0.0.OR.PARRXC(I,1).GT.100.0)GOTO2115
      IF(PARRYC(I,1).LT.0.0.OR.PARRYC(I,1).GT.100.0)GOTO2115
      IF(PARRXC(I,2).LT.0.0.OR.PARRXC(I,2).GT.100.0)GOTO2115
      IF(PARRYC(I,2).LT.0.0.OR.PARRYC(I,2).GT.100.0)GOTO2115
      WRITE(ICOUT,2116)I,PARRXC(I,1),PARRYC(I,1),PARRXC(I,2),PARRYC(I,2)
 2116 FORMAT('       ARROW   ',I8,' COORDINATES       --',4F10.4)
      CALL DPWRST('XXX','WRIT')
 2115 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      DO2125I=1,NUMARR
      WRITE(ICOUT,2126)I,IARRCO(I)
 2126 FORMAT('       ARROW   ',I8,' COLOR             --',A4)
      CALL DPWRST('XXX','WRIT')
 2125 CONTINUE
C
 2180 CONTINUE
      GOTO9000
C
 2190 CONTINUE
C
C               *******************************
C               **  STEP 22--                **
C               **  TREAT THE SEGMENTS CASE  **
C               *******************************
C
      IF(IHARG(1).EQ.'SEGM')GOTO2200
      GOTO2290
C
 2200 CONTINUE
      ISTEPN='22'
      IF(IBUGS2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,2211)
 2211 FORMAT('STATUS OF SEGMENTS--')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,2212)NUMSEG
 2212 FORMAT('       NUMBER OF SEGMENTS = ',I8)
      CALL DPWRST('XXX','WRIT')
C
CCCCC THE FOLLOWING LINE WAS CHANGED    SEPTEMBER 1993
CCCCC IF(NUMSEG.LE.0)GOTO2280
      IF(NUMSEG.LE.0)THEN
         WRITE(ICOUT,999)
         CALL DPWRST('XXX','WRIT')
         WRITE(ICOUT,2205)
 2205    FORMAT('NO SEGMENTS DEFINED')
         CALL DPWRST('XXX','WRIT')
         GOTO2280
      ENDIF
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      DO2215I=1,NUMSEG
      IF(PSEGXC(I,1).LT.0.0.OR.PSEGXC(I,1).GT.100.0)GOTO2215
      IF(PSEGYC(I,1).LT.0.0.OR.PSEGYC(I,1).GT.100.0)GOTO2215
      IF(PSEGXC(I,2).LT.0.0.OR.PSEGXC(I,2).GT.100.0)GOTO2215
      IF(PSEGYC(I,2).LT.0.0.OR.PSEGYC(I,2).GT.100.0)GOTO2215
      WRITE(ICOUT,2216)I,PSEGXC(I,1),PSEGYC(I,1),PSEGXC(I,2),PSEGYC(I,2)
 2216 FORMAT('       SEGMENT ',I8,' COORDINATES       --',4F10.4)
      CALL DPWRST('XXX','WRIT')
 2215 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      DO2225I=1,NUMSEG
      WRITE(ICOUT,2226)I,ISEGCO(I)
 2226 FORMAT('       SEGMENT ',I8,' COLOR             --',A4)
      CALL DPWRST('XXX','WRIT')
 2225 CONTINUE
C
 2280 CONTINUE
      GOTO9000
C
 2290 CONTINUE
C
C               ******************************
C               **  STEP 23--               **
C               **  TREAT THE LEGENDS CASE  **
C               ******************************
C
      IF(IHARG(1).EQ.'LEGE')GOTO2300
      GOTO2390
C
 2300 CONTINUE
      ISTEPN='23'
      IF(IBUGS2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,2311)
 2311 FORMAT('STATUS OF LEGENDS--')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,2312)NUMLEG
 2312 FORMAT('       NUMBER OF LEGENDS = ',I8)
      CALL DPWRST('XXX','WRIT')
C
CCCCC THE FOLLOWING LINE WAS CHANGED    SEPTEMBER 1993
CCCCC IF(NUMLEG.LE.0)GOTO2380
      IF(NUMLEG.LE.0)THEN
         WRITE(ICOUT,999)
         CALL DPWRST('XXX','WRIT')
         WRITE(ICOUT,2305)
 2305    FORMAT('NO LEGENDS DEFINED')
         CALL DPWRST('XXX','WRIT')
         GOTO2380
      ENDIF
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      DO2315I=1,NUMLEG
      JMIN=ILEGST(I)
      JMAX=ILEGSP(I)
      JLENGT=JMAX-JMIN+1
      IF(JLENGT.LE.100)THEN
        JSTOP=JMAX
      ELSE
        JSTOP=JMIN+99
      ENDIF
      IF(JSTOP.GE.JMIN)THEN
        WRITE(ICOUT,2316)I,(ILEGTE(J),J=JMIN,JSTOP)
 2316   FORMAT('       LEGEND  ',I8,'--',100A1)
        CALL DPWRST('XXX','WRIT')
      ENDIF
 2315 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      DO2325I=1,NUMLEG
      IF(PLEGXC(I).LT.0.0.OR.PLEGXC(I).GT.100.0)GOTO2325
      IF(PLEGYC(I).LT.0.0.OR.PLEGYC(I).GT.100.0)GOTO2325
      WRITE(ICOUT,2326)I,PLEGXC(I),PLEGYC(I)
 2326 FORMAT('       LEGEND  ',I8,' COORDINATES       --',2F10.4)
      CALL DPWRST('XXX','WRIT')
 2325 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      DO2335I=1,NUMLEG
      WRITE(ICOUT,2336)I,ILEGCO(I)
 2336 FORMAT('       LEGEND  ',I8,' COLOR             --',A4)
      CALL DPWRST('XXX','WRIT')
 2335 CONTINUE
C
 2380 CONTINUE
      GOTO9000
C
 2390 CONTINUE
C
C               ****************************
C               **  STEP 24--             **
C               **  TREAT THE BOXES CASE  **
C               ****************************
C
      IF(IHARG(1).EQ.'BOXE')GOTO2400
      IF(IHARG(1).EQ.'BOX')GOTO2400
      GOTO2490
C
 2400 CONTINUE
      ISTEPN='24'
      IF(IBUGS2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,2411)
 2411 FORMAT('STATUS OF BOXES--')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,2412)NUMBOX
 2412 FORMAT('       NUMBER OF BOXES = ',I8)
      CALL DPWRST('XXX','WRIT')
C
CCCCC THE FOLLOWING LINE WAS CHANGED    SEPTEMBER 1993
CCCCC IF(NUMBOX.LE.0)GOTO2480
      IF(NUMBOX.LE.0)THEN
         WRITE(ICOUT,999)
         CALL DPWRST('XXX','WRIT')
         WRITE(ICOUT,2405)
 2405    FORMAT('NO BOXES DEFINED')
         CALL DPWRST('XXX','WRIT')
         GOTO2480
      ENDIF
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      DO2415I=1,NUMBOX
      IF(PBOXXC(I,1).LT.0.0.OR.PBOXXC(I,1).GT.100.0)GOTO2415
      IF(PBOXYC(I,1).LT.0.0.OR.PBOXYC(I,1).GT.100.0)GOTO2415
      IF(PBOXXC(I,2).LT.0.0.OR.PBOXXC(I,2).GT.100.0)GOTO2415
      IF(PBOXYC(I,2).LT.0.0.OR.PBOXYC(I,2).GT.100.0)GOTO2415
      WRITE(ICOUT,2416)I,PBOXXC(I,1),PBOXYC(I,1),PBOXXC(I,2),PBOXYC(I,2)
 2416 FORMAT('       BOX     ',I8,' CORNER COORDINATES--',4F10.4)
      CALL DPWRST('XXX','WRIT')
 2415 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      DO2425I=1,NUMBOX
      WRITE(ICOUT,2426)I,IBOPCO(I)
 2426 FORMAT('       BOX     ',I8,' COLOR             --',A4)
      CALL DPWRST('XXX','WRIT')
 2425 CONTINUE
C
 2480 CONTINUE
      GOTO9000
C
 2490 CONTINUE
C
C               ****************************
C               **  STEP 31--             **
C               **  TREAT THE SPIKE CASE  **
C               ****************************
C
      IF(IHARG(1).EQ.'SPIK')GOTO3100
CCCCC THE FOLLOWING LINE WAS ADDED   JULY 1993
      IF(IHARG(1).EQ.'S   ')GOTO3100
      GOTO3190
C
 3100 CONTINUE
      ISTEPN='31'
      IF(IBUGS2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,3111)
 3111 FORMAT('STATUS OF SPIKE SETTINGS--')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,3112)
 3112 FORMAT('   SET       SPIKE     SPIKE     SPIKE     SPIKE  ',
     1'    SPIKE  ')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,3113)
 3113 FORMAT('  INDEX     SWITCH     LINE      COLOR   THICKNESS',
     1'    BASE   ')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      IMAX=10
CCCCC IF(NUMSET.GT.IMAX)IMAX=NUMSET
      DO3120I=1,IMAX
      WRITE(ICOUT,3121)I,ISPISW(I),ISPILI(I),ISPICO(I),PSPITH(I),
     1ASPIBA(I)
 3121 FORMAT(I5,8X,A4,6X,A4,6X,A4,6X,F7.3,3X,E15.7)
      CALL DPWRST('XXX','WRIT')
 3120 CONTINUE
      WRITE(ICOUT,3122)IDEFSS,IDEFSL,IDEFSC,PDEFST,ADEFSB
 3122 FORMAT('DEFAULT',6X,A4,6X,A4,6X,A4,6X,F7.3,3X,E15.7)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
C
 3190 CONTINUE
C
C               ****************************
C               **  STEP 32--             **
C               **  TREAT THE BAR   CASE  **
C               ****************************
C
      IF(IHARG(1).EQ.'BAR ')GOTO3200
CCCCC THE FOLLOWING LINE WAS ADDED   SEPTEMBER 1993
      IF(IHARG(1).EQ.'BARS')GOTO3200
CCCCC THE FOLLOWING LINE WAS ADDED   JULY 1993
      IF(IHARG(1).EQ.'B   ')GOTO3200
      GOTO3290
C
 3200 CONTINUE
      ISTEPN='32'
      IF(IBUGS2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,3211)
 3211 FORMAT('STATUS OF BAR SETTINGS--')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,3212)
 3212 FORMAT('   SET       BAR       BAR       BAR       BAR   ',
     1'        BAR   ')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,3213)
 3213 FORMAT('  INDEX     SWITCH     FILL   DIMENSION  PATTERN',
     1'         BASE ')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      IMAX=10
CCCCC IF(NUMSET.GT.IMAX)IMAX=NUMSET
      DO3220I=1,IMAX
      WRITE(ICOUT,3221)I,IBARSW(I),IBAFSW(I),IBARTY(I),IBAPTY(I),
     1ABARBA(I)
 3221 FORMAT(I5,8X,A4,6X,A4,6X,A4,6X,A4,6X,E15.7)
      CALL DPWRST('XXX','WRIT')
 3220 CONTINUE
      WRITE(ICOUT,3222)IDEBSW,IDEBFS,IDEBTY,IDEBPT,ADEBBA
 3222 FORMAT('DEFAULT',6X,A4,6X,A4,6X,A4,6X,A4,6X,E15.7)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
C
 3290 CONTINUE
C
C               *************************************
C               **  STEP 70--                      **
C               **  TREAT THE GENERAL STATUS CASE  **
C               *************************************
C
C               *****************************
C               **  STEP 70.1--            **
C               **  PRINT OUT A            **
C               **  STORAGE SUMMARY TABLE  **
C               *****************************
C
  100 CONTINUE
C
      ISTEPN='70.1'
      IF(IBUGS2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
CCCCC THE FOLLOWING 4 LINES WERE ADDED     DECEMBER 1991
      IF(NUMARG.LE.0)GOTO109
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'DIME')GOTO109
CCCCC THE FOLLOWING LINE WAS ADDED   JULY 1993
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'D   ')GOTO109
      GOTO149
  109 CONTINUE
C
      NUMN=0
      DO110I=1,NUMNAM
      IF(IHNAME(I).EQ.'PRED')GOTO110
      IF(IHNAME(I).EQ.'RES')GOTO110
      IF(IHNAME(I).EQ.'YPLO')GOTO110
      IF(IHNAME(I).EQ.'XPLO')GOTO110
      IF(IHNAME(I).EQ.'X2PL')GOTO110
      IF(IHNAME(I).EQ.'TAGP')GOTO110
      IF(IUSE(I).EQ.'V')NI=IN(I)
      IF(NI.GT.NUMN)NUMN=NI
  110 CONTINUE
C
      NUMNK=MAXN*NUMCOL
      IDELCO=MAXCOL-NUMCOL
      IDELN=MAXN-NUMN
      IDELNK=MAXNK-NUMNK
      IDELCF=MAXCHF-NUMCHF
      IDELNA=MAXNAM-NUMNAM
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,131)
  131 FORMAT('****************************************************')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,132)
  132 FORMAT('*               STORAGE INFORMATION                *')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,131)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,133)
  133 FORMAT('* NUMBER OF ...      * MAXIMUM * UNUSED  *   USED  *')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,131)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,141)MAXCOL,IDELCO,NUMCOL
  141 FORMAT('* VARIABLES (COLUMNS)*',I7,'  *',I7,'  *',I7,'  *')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,142)MAXN,IDELN,NUMN
  142 FORMAT('* OBS PER VARIABLE   *',I7,'  *',I7,'  *',I7,'  *')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,143)MAXNK,IDELNK,NUMNK
  143 FORMAT('* OBS (TOTAL)        *',I7,'  *',I7,'  *',I7,'  *')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,144)MAXCHF,IDELCF,NUMCHF
  144 FORMAT('* FUNC CHAR (TOTAL)  *',I7,'  *',I7,'  *',I7,'  *')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,145)MAXNAM,IDELNA,NUMNAM
  145 FORMAT('* VAR/PAR/FUNC NAMES *',I7,'  *',I7,'  *',I7,'  *')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,131)
      CALL DPWRST('XXX','WRIT')
CCCCC THE FOLLOWING LINE WAS ADDED    DECEMBER 1991
  149 CONTINUE
C
C               *******************************
C               **  STEP 70.2--              **
C               **  PRINT OUT PLOT LINE,     **
C               **  PLOT CHARACTER, AND      **
C               **  PLOT LIMITS INFORMATION  **
C               *******************************
C
      ISTEPN='70.2'
      IF(IBUGS2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
CCCCC THE FOLLOWING 4 LINES WERE ADDED     DECEMBER 1991
      IF(NUMARG.LE.0)GOTO209
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'CHAR')GOTO209
CCCCC THE FOLLOWING LINE WAS ADDED   JULY 1993
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'C   ')GOTO209
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'LINE')GOTO209
CCCCC THE FOLLOWING LINE WAS ADDED   JULY 1993
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'L   ')GOTO209
      GOTO239
  209 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,211)
  211 FORMAT('   SET       PLOT      PLOT      PLOT      PLOT   ',
     1'    PLOT  ')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,212)
  212 FORMAT('  INDEX      LINE      LINE    CHARACTER CHARACTER',
     1' CHARACTER')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,213)
  213 FORMAT('             TYPE      COLOR     TYPE      COLOR  ',
     1'    SIZE  ')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      IMAX=10
CCCCC IF(NUMSET.GT.IMAX)IMAX=NUMSET
      DO220I=1,IMAX
      WRITE(ICOUT,221)I,ILINPA(I),ILINCO(I),ICHAPA(I),ICHACO(I),
     1PCHAHE(I)
  221 FORMAT(I5,8X,A4,6X,A4,6X,A16,6X,A4,4X,F7.3)
      CALL DPWRST('XXX','WRIT')
  220 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,231)FX1MIN
  231 FORMAT('X-AXIS PLOT MINIMUM = ',E15.8)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,232)FX1MAX
  232 FORMAT('X-AXIS PLOT MAXIMUM = ',E15.8)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,233)FY1MIN
  233 FORMAT('Y-AXIS PLOT MINIMUM = ',E15.8)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,234)FY1MAX
  234 FORMAT('Y-AXIS PLOT MAXIMUM = ',E15.8)
      CALL DPWRST('XXX','WRIT')
CCCCC THE FOLLOWING LINE WAS INSERTED    DECEMBER 1991
  239 CONTINUE
C
C               ***************************************
C               **  STEP 70.3--                      **
C               **  PRINT OUT VARIABLES INFORMATION  **
C               ***************************************
C
      ISTEPN='70.3'
      IF(IBUGS2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.0)GOTO379
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'VARI')GOTO379
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'VAR ')GOTO379
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'V   ')GOTO379
      GOTO399
  379 CONTINUE
C
      CTEMP(1:1)=' '
      IF(NUMARG.GE.2)THEN
        CTEMP(1:1)=IHARG(2)(1:1)
      ENDIF
C
CCCCC THE FOLLOWING LINE WAS CHANGED    SEPTEMBER 1993
CCCCC IF(NUMCOL.LE.0)GOTO399
      IF(NUMCOL.LE.0)THEN
         WRITE(ICOUT,999)
         CALL DPWRST('XXX','WRIT')
         WRITE(ICOUT,355)
  355    FORMAT('NO VARIABLES  (= VECTORS) DEFINED')
         CALL DPWRST('XXX','WRIT')
         GOTO399
      ENDIF
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      DO390I=1,NUMCOL
        NJUNK=0
        DO391J=1,NUMNAM
          IF(I.EQ.IVALUE(J).AND.IUSE(J).EQ.'V')THEN
            IF(CTEMP.EQ.' ')THEN
              NJUNK=NJUNK+1
              IJUNK(NJUNK)=IHNAME(J)
              IJUNK2(NJUNK)=IHNAM2(J)
              NUMELE=IN(J)
            ELSEIF(IHNAME(J)(1:1).EQ.CTEMP)THEN
              NJUNK=NJUNK+1
              IJUNK(NJUNK)=IHNAME(J)
              IJUNK2(NJUNK)=IHNAM2(J)
              NUMELE=IN(J)
            ENDIF
          ENDIF
  391   CONTINUE
        IF(NJUNK.GE.1)THEN
          WRITE(ICOUT,397)I,NUMELE,(IJUNK(K),IJUNK2(K),K=1,NJUNK)
  397     FORMAT('VARIABLE ',I5,' (',I8,' ELEMENTS) ',
     1           'IS: ',10A4)
          CALL DPWRST('XXX','WRIT')
        ENDIF
  390 CONTINUE
  399 CONTINUE
C
CCCCC THE FOLLOWING SECTION WAS CHANGED    SEPTEMBER 1993
C               ****************************
C               **  STEP 70.4--           **
C               **  PRINT OUT PARAMETERS  **
C               ****************************
C
      ISTEPN='70.4'
      IF(IBUGS2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.0)GOTO429
      IF(NUMARG.LE.1)THEN
         IF(IHARG(1).EQ.'PARA')GOTO429
         IF(IHARG(1).EQ.'PAR ')GOTO429
         IF(IHARG(1).EQ.'P   ')GOTO429
      ENDIF
      GOTO490
  429 CONTINUE
C
      NUMPAR=0
      IF(NUMNAM.LE.0)GOTO480
C
      DO430J=1,NUMNAM
         IF(IUSE(J).EQ.'P')THEN
            NUMPAR=NUMPAR+1
            IF(NUMPAR.LE.1)THEN
               WRITE(ICOUT,999)
               CALL DPWRST('XXX','WRIT')
               WRITE(ICOUT,999)
               CALL DPWRST('XXX','WRIT')
            ENDIF
            WRITE(ICOUT,436)IHNAME(J),IHNAM2(J),VALUE(J)
            CALL DPWRST('XXX','WRIT')
  436       FORMAT('PARAMETER ',2A4,'  HAS THE VALUE:   ',E15.7)
         ENDIF
  430 CONTINUE
C
  480 CONTINUE
      IF(NUMPAR.LE.0)THEN
         WRITE(ICOUT,999)
         CALL DPWRST('XXX','WRIT')
         WRITE(ICOUT,481)
  481    FORMAT('NO PARAMETERS (= SCALARS) DEFINED')
         CALL DPWRST('XXX','WRIT')
      ENDIF
C
  490 CONTINUE
C
C
CCCCC THE FOLLOWING SECTION WAS CHANGED    SEPTEMBER 1993
C               ****************************
C               **  STEP 70.5--           **
C               **  PRINT OUT FUNCTIONS   **
C               ****************************
C
      ISTEPN='70.5'
      IF(IBUGS2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.0)GOTO529
      IF(NUMARG.LE.1)THEN
         IF(IHARG(1).EQ.'FUNC')GOTO529
         IF(IHARG(1).EQ.'FUN ')GOTO529
         IF(IHARG(1).EQ.'F   ')GOTO529
      ENDIF
      GOTO590
  529 CONTINUE
C
      NUMFUN=0
      IF(NUMNAM.LE.0)GOTO580
C
      DO530J=1,NUMNAM
         IF(IUSE(J).EQ.'F')THEN
            NUMFUN=NUMFUN+1
            IF(NUMFUN.LE.1)THEN
               WRITE(ICOUT,999)
               CALL DPWRST('XXX','WRIT')
               WRITE(ICOUT,999)
               CALL DPWRST('XXX','WRIT')
            ENDIF
            IMIN=IVSTAR(J)
            IMAX=IVSTOP(J)
            IDEL=IMAX-IMIN+1
            NUMLIN=((IDEL-1)/100)+1
C
            IF(NUMLIN.LE.0)GOTO530
            DO540KLINE=1,NUMLIN
               IF(KLINE.EQ.1)THEN
                  KMIN=IMIN
                  KMAX=KMIN+100-1
                  IF(KMAX.GT.IMAX)KMAX=IMAX
                  WRITE(ICOUT,552)IHNAME(J),IHNAM2(J),
     1            (IFUNC(K),K=KMIN,KMAX)
  552             FORMAT('FUNCTION  ',2A4,'--',100A1)
                  CALL DPWRST('XXX','WRIT')
               ENDIF
C
               IF(KLINE.GE.2)THEN
                  KMIN=KMAX+1
                  KMAX=KMIN+100-1
                  IF(KMAX.GT.IMAX)KMAX=IMAX
                  WRITE(ICOUT,562)(IFUNC(K),K=KMIN,KMAX)
  562             FORMAT(18X,100A1)
                  CALL DPWRST('XXX','WRIT')
               ENDIF
  540       CONTINUE
C
         ENDIF
  530 CONTINUE
C
  580 CONTINUE
      IF(NUMFUN.LE.0)THEN
         WRITE(ICOUT,999)
         CALL DPWRST('XXX','WRIT')
         WRITE(ICOUT,581)
  581    FORMAT('NO FUNCTIONS (= STRINGS) DEFINED')
         CALL DPWRST('XXX','WRIT')
      ENDIF
C
  590 CONTINUE
C
C               ***************************************
C               **  STEP 70.6--                     **
C               **  PRINT OUT MATRIX    INFORMATION  **
C               ***************************************
C
      ISTEPN='70.6'
      IF(IBUGS2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
CCCCC THE FOLLOWING 4 LINES WERE ADDED     DECEMBER 1991
      IF(NUMARG.LE.0)GOTO629
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'MATR')GOTO629
CCCCC THE FOLLOWING LINE WAS ADDED   JULY 1993
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'M   ')GOTO629
      GOTO639
  629 CONTINUE
C
CCCCC THE FOLLOWING LINE WAS CHANGED    SEPTEMBER 1993
CCCCC IF(NUMNAM.LE.0)GOTO619
      IF(NUMNAM.LE.0)THEN
         WRITE(ICOUT,999)
         CALL DPWRST('XXX','WRIT')
         WRITE(ICOUT,605)
  605    FORMAT('NO MATRICES               DEFINED')
         CALL DPWRST('XXX','WRIT')
         GOTO619
      ENDIF
C
      IPASS=0
      DO610J=1,NUMNAM
      IF(IUSE(J).EQ.'M')GOTO615
      GOTO610
C
  615 CONTINUE
      IPASS=IPASS+1
      IF(IPASS.EQ.1)WRITE(ICOUT,999)
      IF(IPASS.EQ.1)CALL DPWRST('XXX','WRIT')
      IF(IPASS.EQ.1)WRITE(ICOUT,999)
      IF(IPASS.EQ.1)CALL DPWRST('XXX','WRIT')
      NR1=IN(J)
      NC1=IVALU2(J)-IVALUE(J)+1
      WRITE(ICOUT,616)IHNAME(J),IHNAM2(J),NR1,NC1,IVALUE(J)
  616 FORMAT('MATRIX ',2A4,' HAS ',I8,' ROWS AND ',I8,' COLUMNS ',
     1'(AND STARTS IN COLUMN ',I8,')')
      CALL DPWRST('XXX','WRIT')
  610 CONTINUE
  619 CONTINUE
  639 CONTINUE
C
C               **************************
C               **  STEP 70.7--         **
C               **  PRINT OUT THE LAST  **
C               **  MODEL FITTED        **
C               **************************
C
      ISTEPN='70.7'
      IF(IBUGS2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
CCCCC THE FOLLOWING 4 LINES WERE ADDED     DECEMBER 1991
      IF(NUMARG.LE.0)GOTO729
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'MODE')GOTO729
      GOTO749
  729 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      IF(NUMCHM.EQ.0)THEN
        WRITE(ICOUT,731)
  731   FORMAT('MODEL--NO MODEL YET DEFINED')
        CALL DPWRST('XXX','WRIT')
        GOTO749
      ENDIF
      DO740I=1,20
        I2=I
        IF(MODEL(I).NE.' ')GOTO748
  740 CONTINUE
  748 CONTINUE
      IF(NUMCHM.GE.I2)THEN
        ISTOP=MIN(NUMCHM,I2+119)
CCCCC   WRITE(ICOUT,741)(MODEL(I),I=I2,NUMCHM)
        WRITE(ICOUT,741)(MODEL(I),I=I2,ISTOP)
  741   FORMAT('MODEL--',120A1)
        CALL DPWRST('XXX','WRIT')
      ENDIF
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
  749 CONTINUE
C
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGS2.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('AT THE END       OF DPSTAT--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)IBUGS2,IFOUND,IERROR
 9013   FORMAT('IBUGS2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTA2(Z1,Z2,Z3,NZ,ICASPL,
     1                  Y2,X2,D2,N2,NPLOTV,
     1                  IBUGG3,ISUBRO,IERROR)
C
C     PURPOSE--GENERATE A PAIR OF COORDINATE VECTORS
C              THAT WILL DEFINE
C              A STAR PLOT
C              (USEFUL FOR MULTIVARIATE ANALYSIS).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--88/2
C     ORIGINAL VERSION--JANUARY   1988.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IBUGG3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION Z1(*)
      DIMENSION Z2(*)
      DIMENSION Z3(*)
C
      DIMENSION Y2(*)
      DIMENSION X2(*)
      DIMENSION D2(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='A2  '
C
      IERROR='NO'
C
      TWOPI=2.0*3.1415926
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(NZ.LT.1)THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
   31   FORMAT('***** ERROR IN STAR PLOT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,32)
   32   FORMAT('      THE NUMBER OF OBSERVATIONS IS NON-POSITIVE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,34)NZ
   34   FORMAT('      THE ENTERED NUMBER OF OBSERVATIONS HERE = ',I6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'STA2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,71)
   71   FORMAT('***** AT THE BEGINNING OF DPPRO2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,72)ICASPL,NZ,N2,NPLOTV
   72   FORMAT('ICASPL,NZ,N2,NPLOTV = ',A4,2X,3I8)
        CALL DPWRST('XXX','BUG ')
        IF(NZ.GT.0)THEN
          DO81I=1,NZ
            WRITE(ICOUT,82)I,Z1(I),Z2(I),Z3(I)
   82       FORMAT('I,Z1(I),Z2(I),Z3(I) = ',I8,3F15.7)
            CALL DPWRST('XXX','BUG ')
   81     CONTINUE
        ENDIF
      ENDIF
C
C               ****************************************
C               **  STEP 11--                         **
C               **  DETERMINE PLOT COORDINATES        **
C               ****************************************
C
      ANZ=NZ
C
      J=0
      K=1
      DO1100I=1,NZ
        AI=I
        ANUM=Z1(I)-Z2(I)
        ADEN=Z3(I)-Z2(I)
        P=0.0
        IF(ADEN.GT.0.0)P=ANUM/ADEN
        THETA=((AI-1.0)/ANZ)*TWOPI
        J=J+1
        Y2(J)=P*SIN(THETA)
        X2(J)=P*COS(THETA)
        D2(J)=K
 1100 CONTINUE
      J=J+1
      Y2(J)=Y2(1)
      X2(J)=X2(1)
      D2(J)=D2(1)
C
      DO1200I=1,NZ
        AI=I
        THETA=((AI-1.0)/ANZ)*TWOPI
        J=J+1
        K=K+1
        Y2(J)=0.0
        X2(J)=0.0
        D2(J)=K
        J=J+1
        Y2(J)=SIN(THETA)
        X2(J)=COS(THETA)
        D2(J)=K
 1200 CONTINUE
C
      N2=J
      NPLOTV=3
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'STA2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTA2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9031)N2,NPLOTV
 9031   FORMAT('N2,NPLOTV = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9035I=1,N2
          WRITE(ICOUT,9036)I,Y2(I),X2(I),D2(I)
 9036     FORMAT('I,Y2(I),X2(I),D2(I) = ',I8,2G15.7,F9.2)
          CALL DPWRST('XXX','BUG ')
 9035   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTCH(ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--CONVERT AN ARRAY OF NUMBERS TO A STRING THAT
C              CONTAINS THE ASCII CHARACTERS CORRESPONDING TO
C              THE NUMBERS.
C     EXAMPLE--LET SOUT = CHARACTER IVAL
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/11
C     ORIGINAL VERSION--NOVEMBER  2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 NEWNAM
      CHARACTER*4 NEWCOL
      CHARACTER*4 ICASEL
      CHARACTER*4 ICASER
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
C
      CHARACTER*1 IC
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ILAB(10)
C
C---------------------------------------------------------------------
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='CH  '
C
      IERROR='NO'
C
      ILOC3=0
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STCH')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTCH--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMNAM
   52   FORMAT('IBUGA3,ISUBRO,NUMNAM = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMNAM
          WRITE(ICOUT,56)I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),
     1                   IVSTOP(I)
   56     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        WRITE(ICOUT,57)NUMCHF,MAXCHF
   57   FORMAT('NUMCHF,MAXCHF = ',2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,60)(IFUNC(I),I=1,MIN(120,MAXCHF))
   60   FORMAT('IFUNC(.)  = ',120A1)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               **********************************
C               **  STEP 1--                    **
C               **  INITIALIZE SOME VARIABLES.  **
C               **********************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STCH')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NEWNAM='NO'
      NEWCOL='NO'
      ICASEL='UNKN'
      NIOLD1=0
      ICOLL=0
C
C               ******************************************************
C               **  STEP 2--                                         *
C               **  EXAMINE THE ARGUMENT ON THE                      *
C               **  LEFT-HAND SIDE--                                 *
C               **  IF THIS IS A PREVIOUSLY DEFINED NAME, IT SHOULD  *
C               **  BE A STRING    (IF NOT, REPORT AN ERROR).        *
C               ******************************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STCH')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHLEFT=IHARG(1)
      IHLEF2=IHARG2(1)
C
      DO2000I=1,NUMNAM
        I2=I
        IF(IHLEFT.EQ.IHNAME(I).AND.IHLEF2.EQ.IHNAM2(I))THEN
          IF(IUSE(I2).EQ.'F')THEN
            ICASEL='STRI'
            ILISTL=I2
            GOTO2299
          ELSE
            WRITE(ICOUT,999)
  999       FORMAT(1X)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
 2001       FORMAT('***** ERROR IN CHARACTER--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2003)IHLEFT,IHLEF2
 2003       FORMAT('      THE FIRST NAME ON THE LEFT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2005)
 2005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
        ENDIF
 2000 CONTINUE
C
      NEWNAM='YES'
      IF(ICASEL.EQ.'UNKN')ICASEL='STRI'
C
      ILISTL=NUMNAM+1
      IF(ILISTL.GT.MAXNAM)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2202)
 2202   FORMAT('      THE NUMBER OF VARIABLE, PARAMETER, AND ',
     1         'FUNCTION')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2203)MAXNAM
 2203   FORMAT('      NAMES HAS JUST EXCEEDED THE ALLOWABLE ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2204)
 2204   FORMAT('      ENTER      STATUS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2205)
 2205   FORMAT('      TO FIND OUT THE FULL LIST OF USED NAMES, AND')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2206)
 2206   FORMAT('      THEN REDEFINE OR DELETE SOME OF THE ALREADY ',
     1         'USED NAMES.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
 2299 CONTINUE
C
C               *****************************************************
C               **  STEP 3--                                       **
C               **  EXTRACT THE FIRST NAME ON THE RIGHT HAND SIDE  **
C               *****************************************************
C
      ISTEPN='3A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STCH')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRIGH=IHARG(4)
      IHRIG2=IHARG2(4)
      DO3000I=1,NUMNAM
        I4=I
        IF(IHRIGH.EQ.IHNAME(I).AND.IHRIG2.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).EQ.'P')THEN
            ICASER='PARA'
            ILISTR=I4
            IVAL=IVALUE(ILISTR)
            NIOLD=1
            GOTO3099
          ELSEIF(IUSE(I4).EQ.'V')THEN
            ICASER='VARI'
            ILISTR=I4
            ICOLR=IVALUE(ILISTR)
            NIOLD=IN(ILISTR)
            GOTO3099
          ELSE
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRIGH,IHRIG2
 3003       FORMAT('      THE NAME ON THE RIGHT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3005)
 3005       FORMAT('      ALREADY EXISTS, BUT NOT AS A PARAMETER ',
     1             'OR A VARIABLE.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
        ENDIF
 3000 CONTINUE
C
      IF(NUMARG.GE.4)THEN
        IF(IARGT(4).EQ.'NUMB')THEN
          IVAL=IARG(4)
          ICASER='PARA'
          GOTO3099
        ENDIF
      ENDIF
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRIGH,IHRIG2
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
 3015 FORMAT('      WAS NOT FOUND IN THE CURRENT NAME LIST.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3099 CONTINUE
C
C               *****************************************************
C               **  STEP 4--                                       **
C               **  CREATE THE STRING                              **
C               *****************************************************
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STCH')THEN
        ISTEPN='4'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,4011)ILISTR,NIOLD
 4011   FORMAT('ILISTR,NIOLD = ',2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4013)ICASEL,ICASER
 4013   FORMAT('ICASEL,ICASER = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(ICASER.EQ.'PARA')THEN
C
        IF(IVAL.LT.0 .OR. IVAL.GT.255)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2001)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,4021)
 4021     FORMAT('      THE PARAMETER ON THE RIGHT HAND SIDE IS')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,4023)
 4023     FORMAT('      OUTSIDE THE (0,255) INTERVAL.')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,4025)IVAL
 4025     FORMAT('      THE VALUE OF THE PARAMETER IS ',I8)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
C
        ICNT=1
        IFUNC2(ICNT)=' '
        CALL DPCONA(IVAL,IC)
        IFUNC2(ICNT)(1:1)=IC
      ELSEIF(ICASER.EQ.'VARI')THEN
        ICNT=0
        DO4110I=1,NIOLD
          IJ=MAXN*(ICOLR-1)+I
          IF(ICOLR.LE.MAXCOL)AVAL=V(IJ)
          IF(ICOLR.EQ.MAXCP1)AVAL=PRED(I)
          IF(ICOLR.EQ.MAXCP2)AVAL=RES(I)
          IF(ICOLR.EQ.MAXCP3)AVAL=YPLOT(I)
          IF(ICOLR.EQ.MAXCP4)AVAL=XPLOT(I)
          IF(ICOLR.EQ.MAXCP5)AVAL=X2PLOT(I)
          IF(ICOLR.EQ.MAXCP6)AVAL=TAGPLO(I)
          IVAL=INT(AVAL+0.5)
C
          IF(IVAL.LT.0 .OR. IVAL.GT.255)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,4121)I
 4121       FORMAT('      ROW ',I8,' OF THE VARIABLE ON THE RIGHT ',
     1             'HAND SIDE IS')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,4123)
 4123       FORMAT('      OUTSIDE THE (0,255) INTERVAL.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,4125)IVAL
 4125       FORMAT('      THE VALUE OF THE ROW ELEMENT IS ',I8)
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
C
          ICNT=ICNT+1
          IFUNC2(ICNT)=' '
          CALL DPCONA(IVAL,IC)
          IFUNC2(ICNT)(1:1)=IC
C
 4110   CONTINUE
      ELSE
        IERROR='YES'
        GOTO9000
      ENDIF
C
 4199 CONTINUE
C
C               *****************************************************
C               **  STEP 5--                                       **
C               **  SAVE STRING AND PRINT FEEDBACK MESSAGE         **
C               *****************************************************
C
C
      IF(ICASEL.EQ.'STRI')THEN
C
        ISTEPN='5'
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STCH')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        CALL DPINFU(IFUNC2,ICNT,IHNAME,IHNAM2,IUSE,IVSTAR,IVSTOP,
     1              NUMNAM,IANS,IWIDTH,IHLEFT,IHLEF2,ILISTL,
     1              NEWNAM,MAXN3,
     1              IFUNC,NUMCHF,MAXCHF,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IF(IFEEDB.EQ.'ON' .AND. IPRINT.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,6606)IHLEFT,IHLEF2
 6606     FORMAT('THE NAME ',A4,A4,' HAS JUST BEEN EQUIVALENCED ')
          CALL DPWRST('XXX','BUG ')
          ILAB(1)='TO T'
          ILAB(2)='HE F'
          ILAB(3)='UNCT'
          ILAB(4)='ION '
          ILAB(5)='    '
          ILAB(6)=' -- '
          NUMWDL=6
          CALL DPPRIF(ILAB,NUMWDL,IFUNC2,ICNT,IBUGA3)
C
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
C
        ENDIF
C
      ENDIF
C
C
C               ****************
C               **  STEP 90-- **
C               **  EXIT.     **
C               ****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STCH')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTCH--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMNAM
 9013   FORMAT('NUMNAM,IVALUE = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,NUMNAM
          WRITE(ICOUT,9016)I,IHNAME(I),IHNAM2(I),IUSE(I),
     1                     IVSTAR(I),IVSTOP(I)
 9016     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTCM(ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--COMPARE TWO STRINGS AND RETURN A 1 IF THEY ARE
C              IDENTICAL AND A 0 IF THEY ARE NOT.
C     EXAMPLE--LET IFLAG = STRING COMPARE S1 S2
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2011/1
C     ORIGINAL VERSION--JANUARY   2011.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 NEWNAM
      CHARACTER*4 NEWCOL
      CHARACTER*4 ICASEL
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*132 ISTR
C
      CHARACTER*4 ILAB(10)
C
C---------------------------------------------------------------------
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='CM  '
C
      IERROR='NO'
C
      ILOC3=0
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STCM')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTCM--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMNAM
   52   FORMAT('IBUGA3,ISUBRO,NUMNAM = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMNAM
          WRITE(ICOUT,56)I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),
     1                   IVSTOP(I)
   56     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        WRITE(ICOUT,57)NUMCHF,MAXCHF
   57   FORMAT('NUMCHF,MAXCHF = ',2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,60)(IFUNC(I),I=1,MIN(120,MAXCHF))
   60   FORMAT('IFUNC(.)  = ',120A1)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               **********************************
C               **  STEP 1--                    **
C               **  INITIALIZE SOME VARIABLES.  **
C               **********************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STCM')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NEWNAM='NO'
      NEWCOL='NO'
      ICASEL='UNKN'
      NIOLD1=0
      ICOLL=0
C
C               ******************************************************
C               **  STEP 2--                                         *
C               **  EXAMINE THE ARGUMENT ON THE                      *
C               **  LEFT-HAND SIDE--                                 *
C               **  IF THIS IS A PREVIOUSLY DEFINED NAME, IT SHOULD  *
C               **  BE A PARAMETER (IF NOT, REPORT AN ERROR).        *
C               ******************************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STCM')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHLEFT=IHARG(1)
      IHLEF2=IHARG2(1)
C
      DO2000I=1,NUMNAM
        I2=I
        IF(IHLEFT.EQ.IHNAME(I).AND.IHLEF2.EQ.IHNAM2(I))THEN
          IF(IUSE(I2).EQ.'P')THEN
            ICASEL='PARA'
            ILISTL=I2
            GOTO2299
          ELSE
            WRITE(ICOUT,999)
  999       FORMAT(1X)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
 2001       FORMAT('***** ERROR IN STRING COMPARE--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2003)IHLEFT,IHLEF2
 2003       FORMAT('      THE NAME ON THE LEFT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2005)
 2005       FORMAT('      ALREADY EXISTS, BUT NOT AS A PARAMETER.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
        ENDIF
 2000 CONTINUE
C
      NEWNAM='YES'
      IF(ICASEL.EQ.'UNKN')ICASEL='PARA'
C
      ILISTL=NUMNAM+1
      IF(ILISTL.GT.MAXNAM)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2202)
 2202   FORMAT('      THE NUMBER OF VARIABLE, PARAMETER, AND ',
     1         'FUNCTION')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2203)MAXNAM
 2203   FORMAT('      NAMES HAS JUST EXCEEDED THE ALLOWABLE ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2204)
 2204   FORMAT('      ENTER      STATUS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2205)
 2205   FORMAT('      TO FIND OUT THE FULL LIST OF USED NAMES, AND')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2206)
 2206   FORMAT('      THEN REDEFINE OR DELETE SOME OF THE ALREADY ',
     1         'USED NAMES.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
 2299 CONTINUE
C
C               *****************************************************
C               **  STEP 3--                                       **
C               **  LOOP THROUGH THE NAMES ON THE RIGHT HAND SIDE  **
C               *****************************************************
C
      ISTEPN='3A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STCM')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LT.5)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3003)
 3003   FORMAT('      THERE ARE NO STRINGS SPECIFIED ON THE RIGHT ',
     1         'HAND SIDE.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(NUMARG.GT.6)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3013)
 3013   FORMAT('      THERE ARE MORE THAN TWO STRINGS SPECIFIED ON ',
     1         'THE RIGHT HAND SIDE.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      ICNT=0
      DO3000I=5,NUMARG
C
        IHRIGH=IHARG(I)
        IHRIG2=IHARG2(I)
C
        DO3100J=1,NUMNAM
          I4=J
          IF(IHRIGH.EQ.IHNAME(J).AND.IHRIG2.EQ.IHNAM2(J))THEN
            IF(IUSE(I4).NE.'F')THEN
              WRITE(ICOUT,999)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,2001)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,3103)IHRIGH,IHRIG2
 3103         FORMAT('      THE NAME ON THE RIGHT HAND SIDE (',
     1               A4,A4,')')
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,3105)
 3105         FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
              CALL DPWRST('XXX','BUG ')
              IERROR='YES'
              GOTO9000
            ELSE
              IF(I.EQ.5)THEN
                ISTRT1=IVSTAR(I4)
                ISTOP1=IVSTOP(I4)
                NLEN1=ISTOP1-ISTRT1+1
              ELSE
                ISTRT2=IVSTAR(I4)
                ISTOP2=IVSTOP(I4)
                NLEN2=ISTOP2-ISTRT2+1
              ENDIF
              GOTO3199
            ENDIF
          ENDIF
 3100   CONTINUE
C
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3103)IHRIGH,IHRIG2
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3115)
 3115   FORMAT('      WAS NOT FOUND IN THE CURRENT NAME LIST.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
C
 3199   CONTINUE
C
C
C               *****************************************************
C               **  STEP 4--                                       **
C               **  DETERMINE IF STRINGS ARE THE SAME              **
C               *****************************************************
C
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STCM')THEN
          ISTEPN='3B'
          CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
          WRITE(ICOUT,3211)I,ISTART,ISTOP,NLEN
 3211     FORMAT('I,ISTART,ISTOP,NLEN = ',4I8)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,3214)ICASEL
 3214     FORMAT('ICASEL = ',A4)
          CALL DPWRST('XXX','BUG ')
        ENDIF
C
        IVAL=1
        IF(NLEN1.NE.NLEN2)THEN
          IVAL=0
        ELSE
          DO3310II=1,NLEN1
            IINDX1=ISTRT1+II
            IINDX2=ISTRT2+II
            IF(IFUNC(IINDX1).NE.IFUNC(IINDX2))THEN
              IVAL=0
              GOTO3319
            ENDIF
 3310     CONTINUE
 3319     CONTINUE
        ENDIF
C
 3000 CONTINUE
C
C               *****************************************************
C               **  STEP 5--                                       **
C               **  SAVE PARAMETER                                 **
C               *****************************************************
C
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STCM')THEN
        ISTEPN='4'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,4011)ISTRT1,ISTOP1,ISTRT2,ISTOP2
 4011   FORMAT('ISTRT1,ISTOP1,ISTRT2,ISTOP2 = ',4I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4013)ICASEL
 4013   FORMAT('ICASEL = ',A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(ICASEL.EQ.'PARA')THEN
C
        ISTEPN='4A'
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STCM')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IHNAME(ILISTL)=IHLEFT
        IHNAM2(ILISTL)=IHLEF2
        IUSE(ILISTL)='P'
        VALUE(ILISTL)=REAL(IVAL)
        IVALUE(ILISTL)=VALUE(ILISTL)+0.5
        IN(ILISTL)=1
        IF(NEWNAM.EQ.'YES')NUMNAM=NUMNAM+1
C
        IF(IPRINT.EQ.'ON' .AND. IFEEDB.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,15111)IHLEFT,IHLEF2,IVAL
15111     FORMAT(A4,A4,' CONTAINS THE VALUE ',I4)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
        ENDIF
      ELSEIF(ICASEL.EQ.'ELEM')THEN
C
C       SEARCH IANS STRING FOR "(xx) =".  IF NO PARENTHESIS
C       FOUND BEFORE "=", THEN DO NOT KNOW WHAT ROW OF THE
C       VARIABLE TO SAVE.  TREAT THIS AS AN ERROR.
C
        NLEFT=-1
        NRIGHT=-1
        NEQUAL=-1
        DO16001I=1,IWIDTH
          IF(IANS(I)(1:1).EQ.'(' .AND. NLEFT.LT.0)THEN
            NLEFT=I
          ELSEIF(IANS(I)(1:1).EQ.')' .AND. NRIGHT.LT.0)THEN
            NRIGHT=I
          ELSEIF(IANS(I)(1:1).EQ.'=' .AND. NEQUAL.LT.0)THEN
            NEQUAL=I
          ENDIF
16001   CONTINUE
C
C       NEED  NLEFT < NRIGHT < NEQUAL
C
        NSTRT=NLEFT+1
        NSTOP=NRIGHT-1
        NLEN=NSTOP-NSTRT+1
        IF(NLEFT.GT.NRIGHT .OR. NRIGHT.GT.NEQUAL .OR.
     1     NSTRT.GT.NSTOP .OR. NLEN.GT.8) THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2001)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,16011)
16011     FORMAT('      UNRECOGNIZED SYNTAX FOR VARIABLE ELEMENT ON')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,16013)
16013     FORMAT('      LEFT HAND SIDE EQUAL SIGN.')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ELSE
          ISTR=' '
          DO16020I=1,NLEN
            ISTR(I:I)=IANS(NSTRT+I-1)(1:1)
16020     CONTINUE
          READ(ISTR,'(I8)',ERR=16029)IARGL
          GOTO16049
C
16029     CONTINUE
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2001)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,16011)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,16013)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
C
16049     CONTINUE
        ENDIF
C
        IF(IARGL.LT.1 .OR. IARGL.GT.MAXN)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2001)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,16052)IARGL,ILEFT
16052     FORMAT('      THE SPECIFIED ROW (',I8,') OF VARIABLE ',A4,A4)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,16054)
16054     FORMAT('      WAS LESS THAN 1 OR GREATER THAN THE')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,16055)MAXN
16055     FORMAT('      MAXIMUM ALLOWABLE ',I8)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
C
        IF(NEWNAM.EQ.'YES')THEN
          NIOLD=1
        ENDIF
        NINEW=NIOLD
        IF(IARGL.GT.NINEW)NINEW=IARGL
        NS2=1
C
        RIGHT=REAL(IVAL)
        IJ=MAXN*(ICOLL-1)+IARGL
        IF(ICOLL.LE.MAXCOL)V(IJ)=RIGHT
        IF(ICOLL.EQ.MAXCP1)PRED(IARGL)=RIGHT
        IF(ICOLL.EQ.MAXCP2)RES(IARGL)=RIGHT
        IF(ICOLL.EQ.MAXCP3)YPLOT(IARGL)=RIGHT
        IF(ICOLL.EQ.MAXCP4)XPLOT(IARGL)=RIGHT
        IF(ICOLL.EQ.MAXCP5)X2PLOT(IARGL)=RIGHT
        IF(ICOLL.EQ.MAXCP6)TAGPLO(IARGL)=RIGHT
C
        IHNAME(ILISTL)=IHLEFT
        IHNAM2(ILISTL)=IHLEF2
        IUSE(ILISTL)='V'
        IVALUE(ILISTL)=ICOLL
        VALUE(ILISTL)=ICOLL
        IN(ILISTL)=NINEW
C
        IF(NEWNAM.EQ.'YES')THEN
          NUMNAM=NUMNAM+1
          NUMCOL=NUMCOL+1
        ENDIF
C
        DO16200J4=1,NUMNAM
          IF(IUSE(J4).EQ.'V'.AND.IVALUE(J4).EQ.ICOLL)THEN
            IUSE(J4)='V'
            IVALUE(J4)=ICOLL
            VALUE(J4)=ICOLL
            IN(J4)=NINEW
            GOTO16209
          ENDIF
16200   CONTINUE
16209   CONTINUE
C
        IF(IPRINT.EQ.'ON' .AND. IFEEDB.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,16211)IVAL
16211     FORMAT('THE RESULT OF THE STRING COMPARISON  = ',I4)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
        ENDIF
      ENDIF
      GOTO9000
C
C
C               ****************
C               **  STEP 90-- **
C               **  EXIT.     **
C               ****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STCM')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTCM--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMNAM
 9013   FORMAT('NUMNAM,IVALUE = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,NUMNAM
          WRITE(ICOUT,9016)I,IHNAME(I),IHNAM2(I),IUSE(I),
     1                     IVSTAR(I),IVSTOP(I)
 9016     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTCN(ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--CONCATENATE ONE OR MORE STRINGS.
C     EXAMPLE--LET SOUT = STRING CONCATENATE S1 S2 S3 S4
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/11
C     ORIGINAL VERSION--NOVEMBER  2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 NEWNAM
      CHARACTER*4 NEWCOL
      CHARACTER*4 ICASEL
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ILAB(10)
C
C---------------------------------------------------------------------
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='CN  '
C
      IERROR='NO'
C
      ILOC3=0
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STCN')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTCN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMNAM
   52   FORMAT('IBUGA3,ISUBRO,NUMNAM = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMNAM
          WRITE(ICOUT,56)I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),
     1                   IVSTOP(I)
   56     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        WRITE(ICOUT,57)NUMCHF,MAXCHF
   57   FORMAT('NUMCHF,MAXCHF = ',2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,60)(IFUNC(I),I=1,MIN(120,MAXCHF))
   60   FORMAT('IFUNC(.)  = ',120A1)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               **********************************
C               **  STEP 1--                    **
C               **  INITIALIZE SOME VARIABLES.  **
C               **********************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STCN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NEWNAM='NO'
      NEWCOL='NO'
      ICASEL='UNKN'
      NIOLD1=0
      ICOLL=0
C
C               ******************************************************
C               **  STEP 2--                                         *
C               **  EXAMINE THE ARGUMENT ON THE                      *
C               **  LEFT-HAND SIDE--                                 *
C               **  IF THIS IS A PREVIOUSLY DEFINED NAME, IT SHOULD  *
C               **  BE A STRING    (IF NOT, REPORT AN ERROR).        *
C               ******************************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STCN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHLEFT=IHARG(1)
      IHLEF2=IHARG2(1)
C
      DO2000I=1,NUMNAM
        I2=I
        IF(IHLEFT.EQ.IHNAME(I).AND.IHLEF2.EQ.IHNAM2(I))THEN
          IF(IUSE(I2).EQ.'F')THEN
            ICASEL='STRI'
            ILISTL=I2
            GOTO2299
          ELSE
            WRITE(ICOUT,999)
  999       FORMAT(1X)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
 2001       FORMAT('***** ERROR IN STRING CONCATENATE--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2003)IHLEFT,IHLEF2
 2003       FORMAT('      THE NAME ON THE LEFT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2005)
 2005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
        ENDIF
 2000 CONTINUE
C
      NEWNAM='YES'
      IF(ICASEL.EQ.'UNKN')ICASEL='STRI'
C
      ILISTL=NUMNAM+1
      IF(ILISTL.GT.MAXNAM)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2202)
 2202   FORMAT('      THE NUMBER OF VARIABLE, PARAMETER, AND ',
     1         'FUNCTION')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2203)MAXNAM
 2203   FORMAT('      NAMES HAS JUST EXCEEDED THE ALLOWABLE ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2204)
 2204   FORMAT('      ENTER      STATUS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2205)
 2205   FORMAT('      TO FIND OUT THE FULL LIST OF USED NAMES, AND')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2206)
 2206   FORMAT('      THEN REDEFINE OR DELETE SOME OF THE ALREADY ',
     1         'USED NAMES.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
 2299 CONTINUE
C
C               *****************************************************
C               **  STEP 3--                                       **
C               **  LOOP THROUGH THE NAMES ON THE RIGHT HAND SIDE  **
C               *****************************************************
C
      ISTEPN='3A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STCN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LT.5)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3003)
 3003   FORMAT('      THERE ARE NO STRINGS SPECIFIED ON THE RIGHT ',
     1         'HAND SIDE')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      ICNT=0
      DO3000I=5,NUMARG
C
        IHRIGH=IHARG(I)
        IHRIG2=IHARG2(I)
C
        DO3100J=1,NUMNAM
          I4=J
          IF(IHRIGH.EQ.IHNAME(J).AND.IHRIG2.EQ.IHNAM2(J))THEN
            IF(IUSE(I4).NE.'F')THEN
              WRITE(ICOUT,999)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,2001)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,3103)IHRIGH,IHRIG2
 3103         FORMAT('      THE NAME ON THE RIGHT HAND SIDE (',
     1               A4,A4,')')
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,3105)
 3105         FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
              CALL DPWRST('XXX','BUG ')
              IERROR='YES'
              GOTO9000
            ELSE
              ISTART=IVSTAR(I4)
              ISTOP=IVSTOP(I4)
              NLEN=ISTOP-ISTART+1
              GOTO3199
            ENDIF
          ENDIF
 3100   CONTINUE
C
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3103)IHRIGH,IHRIG2
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3115)
 3115   FORMAT('      WAS NOT FOUND IN THE CURRENT NAME LIST.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
C
 3199   CONTINUE
C
C
C               *****************************************************
C               **  STEP 4--                                       **
C               **  ADD THE CURRENT STRING                         **
C               *****************************************************
C
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STCN')THEN
          ISTEPN='3B'
          CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
          WRITE(ICOUT,3211)I,ISTART,ISTOP,NLEN
 3211     FORMAT('I,ISTART,ISTOP,NLEN = ',4I8)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,3214)ICASEL
 3214     FORMAT('ICASEL = ',A4)
          CALL DPWRST('XXX','BUG ')
        ENDIF
C
        IF(NLEN.GE.1)THEN
          DO3310II=ISTART,ISTOP
            ICNT=ICNT+1
            IFUNC2(ICNT)=IFUNC(II)
 3310     CONTINUE
        ENDIF
C
 3000 CONTINUE
C
C               *****************************************************
C               **  STEP 4--                                       **
C               **  SAVE STRING AND PRINT FEEDBACK MESSAGE         **
C               *****************************************************
C
C
      IF(ICASEL.EQ.'STRI')THEN
C
        ISTEPN='4'
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STCN')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        CALL DPINFU(IFUNC2,ICNT,IHNAME,IHNAM2,IUSE,IVSTAR,IVSTOP,
     1              NUMNAM,IANS,IWIDTH,IHLEFT,IHLEF2,ILISTL,
     1              NEWNAM,MAXN3,
     1              IFUNC,NUMCHF,MAXCHF,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IF(IFEEDB.EQ.'ON' .AND. IPRINT.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,6606)IHLEFT,IHLEF2
 6606     FORMAT('THE NAME ',A4,A4,' HAS JUST BEEN EQUIVALENCED ')
          CALL DPWRST('XXX','BUG ')
          ILAB(1)='TO T'
          ILAB(2)='HE F'
          ILAB(3)='UNCT'
          ILAB(4)='ION '
          ILAB(5)='    '
          ILAB(6)=' -- '
          NUMWDL=6
          CALL DPPRIF(ILAB,NUMWDL,IFUNC2,ICNT,IBUGA3)
C
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
C
        ENDIF
C
      ENDIF
C
C
C               ****************
C               **  STEP 90-- **
C               **  EXIT.     **
C               ****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STCN')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTCN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMNAM
 9013   FORMAT('NUMNAM,IVALUE = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,NUMNAM
          WRITE(ICOUT,9016)I,IHNAME(I),IHNAM2(I),IUSE(I),
     1                     IVSTAR(I),IVSTOP(I)
 9016     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTED(ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--EDIT A PREVIOUSLY DEFINED STRING
C     EXAMPLE--LET SOUT = STRING EDIT SORG SOLD SNEW
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/11
C     ORIGINAL VERSION--NOVEMBER  2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 NEWNAM
      CHARACTER*4 NEWNA2
      CHARACTER*4 NEWCOL
      CHARACTER*4 NEWCO2
      CHARACTER*4 ICASEL
      CHARACTER*4 ICASE2
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
      CHARACTER*4 IHRI21
      CHARACTER*4 IHRI22
      CHARACTER*4 IHRI31
      CHARACTER*4 IHRI32
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ILAB(10)
C
C---------------------------------------------------------------------
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='ED  '
C
      IERROR='NO'
C
      ILOC3=0
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STED')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTED--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMNAM
   52   FORMAT('IBUGA3,ISUBRO,NUMNAM = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMNAM
          WRITE(ICOUT,56)I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),
     1                   IVSTOP(I)
   56     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        WRITE(ICOUT,57)NUMCHF,MAXCHF
   57   FORMAT('NUMCHF,MAXCHF = ',2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,60)(IFUNC(I),I=1,MIN(120,MAXCHF))
   60   FORMAT('IFUNC(.)  = ',120A1)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               **********************************
C               **  STEP 1--                    **
C               **  INITIALIZE SOME VARIABLES.  **
C               **********************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STED')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NEWNAM='NO'
      NEWNA2='NO'
      NEWCOL='NO'
      NEWCO2='NO'
      ICASEL='UNKN'
      ICASE2='UNKN'
      NIOLD1=0
      NIOLD2=0
      ICOLL=0
      ICOL2=0
C
C               ******************************************************
C               **  STEP 2--                                         *
C               **  EXAMINE THE ARGUMENT ON THE                      *
C               **  LEFT-HAND SIDE--                                 *
C               **  IF THIS IS A PREVIOUSLY DEFINED NAME, IT SHOULD  *
C               **  BE A STRING    (IF NOT, REPORT AN ERROR).        *
C               ******************************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STED')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHLEFT=IHARG(1)
      IHLEF2=IHARG2(1)
C
      DO2000I=1,NUMNAM
        I2=I
        IF(IHLEFT.EQ.IHNAME(I).AND.IHLEF2.EQ.IHNAM2(I))THEN
          IF(IUSE(I2).EQ.'F')THEN
            ICASEL='STRI'
            ILISTL=I2
            GOTO2299
          ELSE
            WRITE(ICOUT,999)
  999       FORMAT(1X)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
 2001       FORMAT('***** ERROR IN STRING EDIT--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2003)IHLEFT,IHLEF2
 2003       FORMAT('      THE FIRST NAME ON THE LEFT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2005)
 2005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
        ENDIF
 2000 CONTINUE
C
      NEWNAM='YES'
      IF(ICASEL.EQ.'UNKN')ICASEL='STRI'
C
      ILISTL=NUMNAM+1
      IF(ILISTL.GT.MAXNAM)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2202)
 2202   FORMAT('      THE NUMBER OF VARIABLE, PARAMETER, AND ',
     1         'FUNCTION')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2203)MAXNAM
 2203   FORMAT('      NAMES HAS JUST EXCEEDED THE ALLOWABLE ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2204)
 2204   FORMAT('      ENTER      STATUS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2205)
 2205   FORMAT('      TO FIND OUT THE FULL LIST OF USED NAMES, AND')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2206)
 2206   FORMAT('      THEN REDEFINE OR DELETE SOME OF THE ALREADY ',
     1         'USED NAMES.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
 2299 CONTINUE
C
C               *****************************************************
C               **  STEP 3--                                       **
C               **  EXTRACT THE FIRST NAME ON THE RIGHT HAND SIDE  **
C               *****************************************************
C
      ISTEPN='3A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STED')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRIGH=IHARG(5)
      IHRIG2=IHARG2(5)
      DO3000I=1,NUMNAM
        I4=I
        IF(IHRIGH.EQ.IHNAME(I).AND.IHRIG2.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'F')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRIGH,IHRIG2
 3003       FORMAT('      THE NAME ON THE RIGHT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3005)
 3005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ISTRT1=IVSTAR(I4)
            ISTOP1=IVSTOP(I4)
            NLEN1=ISTOP1-ISTRT1+1
            GOTO3099
          ENDIF
        ENDIF
 3000 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRIGH,IHRIG2
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
 3015 FORMAT('      WAS NOT FOUND IN THE CURRENT NAME LIST.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3099 CONTINUE
C
C               *****************************************************
C               **  STEP 3B-                                       **
C               **  EXTRACT THE SECOND NAME ON THE RIGHT HAND SIDE **
C               *****************************************************
C
      ISTEPN='3B'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STED')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRI21=IHARG(6)
      IHRI22=IHARG2(6)
      DO3100I=1,NUMNAM
        I4=I
        IF(IHRI21.EQ.IHNAME(I).AND.IHRI22.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'F')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRI21,IHRI22
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3005)
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ISTRT2=IVSTAR(I4)
            ISTOP2=IVSTOP(I4)
            NLEN2=ISTOP2-ISTRT2+1
            GOTO3199
          ENDIF
        ENDIF
 3100 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRI21,IHRI22
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3199 CONTINUE
C
C               *****************************************************
C               **  STEP 3C-                                       **
C               **  EXTRACT THE THIRD  NAME ON THE RIGHT HAND SIDE **
C               *****************************************************
C
      ISTEPN='3C'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STED')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRI31=IHARG(7)
      IHRI32=IHARG2(7)
      DO3200I=1,NUMNAM
        I4=I
        IF(IHRI31.EQ.IHNAME(I).AND.IHRI32.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'F')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRI31,IHRI32
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3005)
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ISTRT3=IVSTAR(I4)
            ISTOP3=IVSTOP(I4)
            NLEN3=ISTOP3-ISTRT3+1
            GOTO3299
          ENDIF
        ENDIF
 3200 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRI31,IHRI32
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3299 CONTINUE
C
C               *****************************************************
C               **  STEP 4--                                       **
C               **  PERFORM THE STRING EDIT                        **
C               *****************************************************
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STED')THEN
        ISTEPN='4A'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,4011)ISTRT1,ISTOP1,NLEN1
 4011   FORMAT('ISTRT1,ISTOP1,NLEN1 = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4012)ISTRT2,ISTOP2,NLEN2
 4012   FORMAT('ISTRT2,ISTOP2,NLEN2 = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4013)ISTRT3,ISTOP3,NLEN3
 4013   FORMAT('ISTRT3,ISTOP3,NLEN3 = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4014)ICASEL
 4014   FORMAT('ICASEL = ',A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C     CHECK TO SEE IF A MATCH FOUND
C
      IMATCH=0
      NLAST=ISTOP1-NLEN2+1
      IF(NLAST.GE.ISTRT1)THEN
        DO4100I=ISTRT1,NLAST
          ICNT=0
          DO4110J=I,I+NLEN2-1
            ICNT=ICNT+1
            IINDX=ISTRT2+ICNT-1
            IF(IFUNC(J)(1:1).NE.IFUNC(IINDX)(1:1))GOTO4100
 4110     CONTINUE
          IMATCH=1
          NSTART=I
          GOTO4199
 4100   CONTINUE
 4199   CONTINUE
C
        IF(IMATCH.EQ.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2001)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,4191)IHRI21,IHRI22,IHRIGH,IHRIG2
 4191     FORMAT('       NO MATCH FOR STRING ',A4,A4,' FOUND IN ',
     1           'STRING ',A4,A4)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
      ENDIF
C
C     IF MATCH FOUND, PERFORM THE EDIT
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STED')THEN
        ISTEPN='4B'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,4196)IMATCH,NSTART
 4196   FORMAT('IMATCH,NSTART = ',2I8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C     COPY THE PORTION OF THE STRING UP TO THE EDIT POINT
C
      ICNT=0
      IF(NSTART.GT.1)THEN
        DO4210I=ISTRT1,NSTART-1
          ICNT=ICNT+1
          IFUNC2(ICNT)=IFUNC(I)
 4210   CONTINUE
      ENDIF
C
C     NOW INSERT THE "NEW" STRING
C
      IF(NLEN3.GE.1)THEN
        DO4120I=1,NLEN2
          ICNT=ICNT+1
          IINDX=I+ISTRT3-1
          IFUNC2(ICNT)=IFUNC(IINDX)
 4120   CONTINUE
      ENDIF
C
C     NOW INSERT THE PART OF THE ORIGINAL STRING AFTER THE EDIT POINT
C
      NTEMP=NSTART+NLEN2
      IF(NTEMP.LE.ISTOP1)THEN
        DO4130I=NTEMP,ISTOP1
          ICNT=ICNT+1
          IFUNC2(ICNT)=IFUNC(I)
 4130   CONTINUE
      ENDIF
C
C               *****************************************************
C               **  STEP 5--                                       **
C               **  SAVE STRING AND PRINT FEEDBACK MESSAGE         **
C               *****************************************************
C
C
      IF(ICASEL.EQ.'STRI')THEN
C
        ISTEPN='5'
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STED')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        CALL DPINFU(IFUNC2,ICNT,IHNAME,IHNAM2,IUSE,IVSTAR,IVSTOP,
     1              NUMNAM,IANS,IWIDTH,IHLEFT,IHLEF2,ILISTL,
     1              NEWNAM,MAXN3,
     1              IFUNC,NUMCHF,MAXCHF,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IF(IFEEDB.EQ.'ON' .AND. IPRINT.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,6606)IHLEFT,IHLEF2
 6606     FORMAT('THE NAME ',A4,A4,' HAS JUST BEEN EQUIVALENCED ')
          CALL DPWRST('XXX','BUG ')
          ILAB(1)='TO T'
          ILAB(2)='HE F'
          ILAB(3)='UNCT'
          ILAB(4)='ION '
          ILAB(5)='    '
          ILAB(6)=' -- '
          NUMWDL=6
          CALL DPPRIF(ILAB,NUMWDL,IFUNC2,ICNT,IBUGA3)
C
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
C
        ENDIF
C
      ENDIF
C
C
C               ****************
C               **  STEP 90-- **
C               **  EXIT.     **
C               ****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STED')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTED--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMNAM
 9013   FORMAT('NUMNAM,IVALUE = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,NUMNAM
          WRITE(ICOUT,9016)I,IHNAME(I),IHNAM2(I),IUSE(I),
     1                     IVSTAR(I),IVSTOP(I)
 9016     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTE2(Y,W,N,YS,MAXN,IBUGG3,ISUBRO,IERROR)
C
C     PURPOSE--FORM A STEM AND LEAF DIAGRAM
C     OUTPUT--A STEM AND LEAF DIAGRAM
C             OF SMOOTHED VALUES.
C     NOTE--THE VECTOR Y REMAINS UNCHANGED.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--MCNEIL, INTERACTIVE DATA ANALYSIS
C                 1977, PAGE 23
C                 (= SOURCE OF ALGORITHM).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION--JULY      1983.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IBUGG3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*1 IA
      CHARACTER*1 M
      CHARACTER*1 IOUT
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION W(*)
      DIMENSION YS(*)
C
      DIMENSION IOUT(132)
      DIMENSION IA(20)
      DIMENSION M(4)
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
      DATA IA(1)/'0'/
      DATA IA(2)/'1'/
      DATA IA(3)/'2'/
      DATA IA(4)/'3'/
      DATA IA(5)/'4'/
      DATA IA(6)/'5'/
      DATA IA(7)/'6'/
      DATA IA(8)/'7'/
      DATA IA(9)/'8'/
      DATA IA(10)/'9'/
      DATA IA(11)/'0'/
      DATA IA(12)/'1'/
      DATA IA(13)/'2'/
      DATA IA(14)/'3'/
      DATA IA(15)/'4'/
      DATA IA(16)/'5'/
      DATA IA(17)/'6'/
      DATA IA(18)/'7'/
      DATA IA(19)/'8'/
      DATA IA(20)/'9'/
C
      DATA M(1)/'-'/
      DATA M(2)/' '/
      DATA M(3)/':'/
      DATA M(4)/'+'/
C
C-----START POINT-----------------------------------------------------
C
      IERROR='NO'
C
      IWIDTH=50
      SCALE=1.0
      EPS=0.00000001
C
      IF(IBUGG3.EQ.'ON' .OR. ISUBRO.EQ.'STE2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTE2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGG3,ISUBRO,N
   52   FORMAT('IBUGG3,ISUBRO,N = ',2(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,Y(I)
   56     FORMAT('I,Y(I) = ',I8,E15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ************************************
C               **  FORM A STEM-AND-LEAF DIAGRAM  **
C               ************************************
C
      IF(N.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN STEM AND LEAF PLOT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,112)
  112   FORMAT('     NUMBER OF OBSERVATIONS IS LESS THAN TWO.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,113)N
  113   FORMAT('NUMBER OF OBSERVATIONS = ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C
C               *********************
C               **  STEP 1--       **
C               **  SORT THE DATA  **
C               *********************
C
      CALL SORT(Y,N,YS)
C
C     STEP 2--
C     DEFINE C
C
      RANGE=YS(N)-YS(1)
      R=EPS+RANGE/SCALE
C
      C=10.0**(11-INT(LOG10(R)+10.0))
      ARG1=INT(R*C/25.0)
      ARG2=0
      MAX=ARG1
      IF(ARG2.GT.ARG1)MAX=ARG2
C
      ARG1=2
      ARG2=MAX
      MM=ARG1
      IF(ARG2.LT.ARG1)MM=ARG2
C
      K=3*MM+2-150/(N+50)
      IPROD=(K-1)*(K-2)*(K-5)
      IF(IPROD.EQ.0)C=C*10
C
C     STEP 3--
C     DEFINE MU
C
      MU=10
      IPROD=K*(K-4)*(K-8)
      IF(IPROD.EQ.0)MU=5
      IPROD=(K-1)*(K-5)*(K-6)
      IF(IPROD.EQ.0)MU=20
C
      I=1
      IF(YS(1).GE.0)I=2
      I2=1
      TERM=INT(YS(I2)*C/MU)+I-2
      D=MU*TERM/10.0
C
C               *****************************************
C               **  STEP XX--                          **
C               **  SET UP A LOOP IN WHICH             **
C               **  EACH ITERATION OF THE LOOP         **
C               **  WILL FORM A NEW LINE (ROW) OF THE  **
C               **  STEM AND LEAF DIAGRAM              **
C               *****************************************
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
 1000 CONTINUE
C
C               *****************************************************
C               **  STEP XX--                                      **
C               **  FORM THE NEXT OUTPUT LINE OF THE STEM AND LEAF **
C               **  DIAGRAM.  FILL THE OUTPUT LINE WITH BLANKS.    **
C               *****************************************************
C
      DO1100K=1,IWIDTH
      IOUT(K)=' '
 1100 CONTINUE
C
      IF(I.EQ.2.OR.D.LE.0)GOTO1290
      I=2
      D=D-MU/10.0
 1290 CONTINUE
C
      ICOL=0
 1300 CONTINUE
      ICOL=ICOL+1
      TERM1=YS(I2)*C-10*INT(D)
      IY=INT(0.5+ABS(TERM1))
      IF(YS(I2)*C-10*D.GE.0.5+(MU-1)*(I-1))GOTO1390
      IF(ICOL.LE.IWIDTH)IOUT(ICOL)=IA(1+IY)
      I2=I2+1
      IF(I2.GT.N)GOTO1390
      GOTO1300
 1390 CONTINUE
C
      ID=MOD(IABS(INT(D)),100)
      K1=1+ID/10
      K2=1+ID-10*(K1-1)
      IF(ICOL.LE.IWIDTH+1)GOTO1490
      IOUT(IWIDTH-2)='+'
      IOUT(IWIDTH-1)=IA(1+(ICOL-IWIDTH+2)/10)
      IOUT(IWIDTH)=IA(ICOL-IWIDTH+3-10*((ICOL-IWIDTH+2)/10))
 1490 CONTINUE
C
C               **********************************************
C               **  STEP XX--                               **
C               **  WRITE OUT THE OUTPUT LINE FOR THIS ROW  **
C               **********************************************
C
      K=IWIDTH
      IF(ICOL.LT.IWIDTH)K=ICOL
      WRITE(ICOUT,1510)M(I),IA(K1),IA(K2),M(2),M(3),M(2),
     1(IOUT(ICOL),ICOL=1,K)
 1510 FORMAT(132A1)
      CALL DPWRST('XXX','BUG ')
C
C               *****************************************************
C               **  STEP XX--                                      **
C               **  JUMP BACK TO THE BEGINNING OF THE LOOP         **
C               **  TO WORK ON THE NEXT LINE (ROW) OF THE DIAGRAM  **
C               *****************************************************
C
      IF(I2.GT.N)GOTO9000
      D=D+MU/10.0
      GOTO1000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'STE2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTE2--')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTEM(IBUGA2,IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--GENERATE A STEM AND LEAF DIAGRAM.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83/7
C     ORIGINAL VERSION--JULY      1983.
C     UPDATED         --JUNE      1990. TEMPORARY ARRAYS TO GARBAGE COMMON
C     UPDATED         --MARCH     2011. USE DPPARS AND DPPAR3
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IBUGA2
      CHARACTER*4 IBUGA3
      CHARACTER*4 IBUGQ
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ICASE
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=10)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
C
      DIMENSION TEMP(MAXOBV)
C
      DIMENSION W(MAXOBV)
CCCCC FOLLOWING LINES ADDED JUNE, 1990
      INCLUDE 'DPCOZZ.INC'
      EQUIVALENCE (GARBAG(IGARB1),W(1))
      EQUIVALENCE (GARBAG(IGARB2),TEMP(1))
CCCCC END CHANGE
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCOSU.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPSU'
      ISUBN2='MM  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      IFOUND='NO'
      IERROR='NO'
C
C               ************************************
C               **  TREAT THE STEM AND LEAF CASE  **
C               ************************************
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'STEM')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTEM--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA2,IBUGA3,IBUGQ,ISUBRO
   52   FORMAT('IBUGA2,IBUGA3,IBUGQ,ISUBRO = ',3(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ***************************
C               **  STEP 1--             **
C               **  EXTRACT THE COMMAND  **
C               ***************************
C
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'PLOT')THEN
        ISHIFT=1
      ELSEIF(NUMARG.GE.1.AND.
     1       IHARG(1).EQ.'DIAG'.AND.IHARG2(1).EQ.'RAM')THEN
        ISHIFT=1
      ELSEIF(NUMARG.GE.2.AND.
     1       IHARG(1).EQ.'AND'.AND.IHARG(2).EQ.'PLOT')THEN
        ISHIFT=2
      ELSEIF(NUMARG.GE.2.AND.
     1       IHARG(2).EQ.'AND'.AND.IHARG(2).EQ.'DIAG'.AND.
     1       IHARG2(2).EQ.'RAM')THEN
        ISHIFT=2
      ELSEIF(NUMARG.GE.2.AND.
     1       IHARG(1).EQ.'LEAF'.AND.IHARG(2).EQ.'PLOT')THEN
        ISHIFT=2
      ELSEIF(NUMARG.GE.2.AND.
     1       IHARG(2).EQ.'LEAF'.AND.
     1       IHARG(2).EQ.'DIAG'.AND.IHARG2(2).EQ.'RAM')THEN
        ISHIFT=2
      ELSEIF(NUMARG.GE.3.AND.
     1       IHARG(1).EQ.'AND'.AND.IHARG(2).EQ.'LEAF'.AND.
     1       IHARG(3).EQ.'PLOT')THEN
        ISHIFT=3
      ELSEIF(NUMARG.GE.3.AND.
     1       IHARG(1).EQ.'AND'.AND.IHARG(2).EQ.'LEAF'.AND.
     1       IHARG(3).EQ.'DIAG'.AND.IHARG2(3).EQ.'RAM')THEN
        ISHIFT=3
      ELSEIF(NUMARG.GE.3.AND.
     1       IHARG(1).EQ.'AND'.AND.IHARG(2).EQ.'LEAF')THEN
        ISHIFT=2
      ELSE
        GOTO9000
      ENDIF
C
      IFOUND='YES'
      CALL ADJUST(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
C
C               ****************************************
C               **  STEP 2--                          **
C               **  EXTRACT THE VARIABLE LIST         **
C               ****************************************
C
      ISTEPN='2'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'STEM')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='STEM AND LEAF PLOT'
      MINNA=1
      MAXNA=100
      MINN2=2
      IFLAGE=1
      IFLAGM=1
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
      MINNVA=1
      MAXNVA=1
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGA2,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'STEM')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I),IVARTY(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I),IVARTY(I) = ',I8,2X,A4,A4,2X,3I8,2X,A4)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
      ICOL=1
      CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1            INAME,IVARN1,IVARN2,IVARTY,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVAR,
     1            MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1            MAXCP4,MAXCP5,MAXCP6,
     1            V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1            Y,Y,Y,NS,NLOCA2,NLOCA3,ICASE,
     1            IBUGA3,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               ****************************************************
C               **  STEP 8--                                      **
C               **  PREPARE FOR ENTRANCE INTO DPSTE2--            **
C               **  SET THE WEIGHT VECTOR TO UNITY THROUGHOUT.    **
C               ****************************************************
C
      ISTEPN='8'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'STEM')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO1110I=1,NS
      W(I)=1.0
 1110 CONTINUE
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'STEM')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1211)
 1211   FORMAT('***** FROM DPSTEM, AS WE ARE ABOUT TO CALL DPSTE2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1212)NS
 1212   FORMAT('NS = ',I8)
        CALL DPWRST('XXX','BUG ')
        DO1215I=1,NS
          WRITE(ICOUT,1216)I,Y(I),W(I)
 1216     FORMAT('I,Y(I),W(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
 1215   CONTINUE
      ENDIF
C
      CALL DPSTE2(Y,W,NS,TEMP,MAXN,IBUGA3,ISUBRO,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'STEM')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTEM--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)IFOUND,IERROR
 9016   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTGL(ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--EXTRACT GROUP LABELS TO STRING
C     EXAMPLE--LET STEMP = GROUP LABEL TO STRINGS IG
C
C              SO IF THE GROUP LABEL VARIABLE "IG" HAS 10 LABELS,
C              THEN THESE WILL BE EXTRACTED TO STRINGS STEMP1, STEMP2,
C              ..., STEMP10
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2011/10
C     ORIGINAL VERSION--OCTOBER   2011.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 NEWNAM
      CHARACTER*4 NEWCOL
      CHARACTER*4 ICASEL
      CHARACTER*8 IHLEFT
      CHARACTER*8 ISTRIN
      CHARACTER*4 IHLEF3
      CHARACTER*4 IHLEF4
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
C
      CHARACTER*40 ISTRZZ
      CHARACTER*4  ISTRZ2(40)
C
      CHARACTER*4 ISUBN0
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCOHO.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='GL  '
C
      IERROR='NO'
C
      ILOC3=0
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STGL')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTGL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMNAM
   52   FORMAT('IBUGA3,ISUBRO,NUMNAM = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMNAM
          WRITE(ICOUT,56)I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),
     1                   IVSTOP(I)
   56     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        WRITE(ICOUT,57)NUMCHF,MAXCHF
   57   FORMAT('NUMCHF,MAXCHF = ',2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,60)(IFUNC(I),I=1,MIN(120,MAXCHF))
   60   FORMAT('IFUNC(.)  = ',120A1)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               **********************************
C               **  STEP 1--                    **
C               **  CHECK IF VARIABLE ON RHS IS **
C               **  A GROUP LABEL VARIABLE.     **
C               **********************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STGL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IGVAR=0
      IHRIGH=IHARG(7)
      IHRIG2=IHARG2(7)
C
      DO110I=1,MAXGRP
        IF(IHRIGH(1:4).EQ.IGRPVN(I)(1:4) .AND.
     1     IHRIG2(1:4).EQ.IGRPVN(I)(5:8))THEN
            IGVAR=I
            GOTO119
        ENDIF
  110 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,121)
  121 FORMAT('***** ERROR IN GROUP LABEL TO STRINGS COMMAND--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,123)IHRIGH,IHRIG2
  123 FORMAT('      ',A4,A4,' NOT RECOGNIZED AS A PREVIOUSLY DEFINED ',
     1       'GROUP LABEL VARIABLE.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
  119 CONTINUE
C
C               **********************************
C               **  STEP 2--                    **
C               **  DETERMINE NUMBER OF STRINGS **
C               **  TO CREATE (LOOK FOR FIRST   **
C               **  BLANK LABEL).               **
C               **********************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STGL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NSTR=200
      DO210I=1,MAXGLA
        IF(IGRPLA(I,IGVAR).EQ.' ')THEN
          NSTR=I-1
          GOTO219
        ENDIF
  210 CONTINUE
  219 CONTINUE
      IF(NSTR.GT.999)NSTR=999
      IF(NSTR.LT.1)GOTO9000
C
C               *************************************************
C               **  STEP 3--                                   **
C               **  EXTRACT THE BASE NAME ON THE LHS OF THE    **
C               **  EQUAL SIGN AND THEN LOOP THROUGH THE       **
C               **  NUMBER OF STRINGS TO CREATE.               **
C               *************************************************
C
      ISTEPN='3'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STGL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHLEFT(1:4)=IHARG(1)
      IHLEFT(5:8)=IHARG2(1)
      NBASE=1
      DO310I=8,1,-1
        IF(IHLEFT(I:I).NE.' ')THEN
          NBASE=I
          GOTO319
        ENDIF
  310 CONTINUE
  319 CONTINUE
C
      IF(NSTR.LE.9)THEN
        IF(NBASE.GT.7)NBASE=7
      ELSEIF(NSTR.LE.99)THEN
        IF(NBASE.GT.6)NBASE=6
      ELSE
        IF(NBASE.GT.5)NBASE=5
      ENDIF
C
      ISTEPN='4'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STGL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO410I=1,NSTR
C
        ISTRZZ=' '
        ISTRIN=' '
        ISTRIN(1:NBASE)=IHLEFT(1:NBASE)
        IF(I.LE.9)THEN
          WRITE(ISTRIN(NBASE+1:NBASE+1),'(I1)')I
        ELSEIF(I.LE.99)THEN
          WRITE(ISTRIN(NBASE+1:NBASE+2),'(I2)')I
        ELSE
          WRITE(ISTRIN(NBASE+1:NBASE+3),'(I3)')I
        ENDIF
C
        NCHAR=40
        DO420J=40,1,-1
          IF(IGRPLA(I,IGVAR)(J:J).NE.' ')THEN
            NCHAR=J
            GOTO429
          ENDIF
  420   CONTINUE
        NCHAR=1
  429   CONTINUE
C
        ISTRZZ(1:NCHAR)=IGRPLA(I,IGVAR)(1:NCHAR)
C
        NEWNAM='NO'
        NEWCOL='NO'
        ICASEL='UNKN'
        NIOLD1=0
        ICOLL=0
C
C               ******************************************************
C               **  STEP 5--                                         *
C               **  EXAMINE THE CURRENT STRING--                     *
C               **  IF THIS IS A PREVIOUSLY DEFINED NAME, IT SHOULD  *
C               **  BE A STRING    (IF NOT, REPORT AN ERROR).        *
C               ******************************************************
C
        ISTEPN='5'
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STGL')
     1     CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        DO510II=1,NUMNAM
          I2=II
          IF(ISTRIN(1:4).EQ.IHNAME(I2).AND.
     1       ISTRIN(5:8).EQ.IHNAM2(I2))THEN
            IF(IUSE(I2).EQ.'F')THEN
              ICASEL='STRI'
              ILISTL=I2
              GOTO519
            ELSE
              WRITE(ICOUT,999)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,121)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,513)ISTRIN
  513         FORMAT('      THE NAME ',A8,' ALREADY EXISTS, BUT NOT ',
     1               'AS A STRING.')
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,515)
  515         FORMAT('      THIS STRING WILL NOT BE CREATED.')
              CALL DPWRST('XXX','BUG ')
              GOTO9000
            ENDIF
          ENDIF
  510   CONTINUE
  519   CONTINUE
C
        NEWNAM='YES'
        ICASEL='STRI'
C
        ILISTL=NUMNAM+1
        IF(ILISTL.GT.MAXNAM)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,121)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,522)
  522     FORMAT('      THE NUMBER OF VARIABLE, PARAMETER, AND ',
     1           'FUNCTION')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,524)MAXNAM
  524     FORMAT('      NAMES HAS JUST EXCEEDED THE ALLOWABLE ',I8)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
C
C               *****************************************************
C               **  STEP 6--                                       **
C               **  ADD THE CURRENT STRING                         **
C               *****************************************************
C
        ISTEPN='6'
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STGL')
     1     CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IHLEF3=ISTRIN(1:4)
        IHLEF4=ISTRIN(5:8)
        DO411J=1,NCHAR
          ISTRZ2(J)=' '
          ISTRZ2(J)(1:1)=ISTRZZ(J:J)
  411   CONTINUE
C
        CALL DPINFU(ISTRZ2,NCHAR,IHNAME,IHNAM2,IUSE,IVSTAR,IVSTOP,
     1              NUMNAM,IANS,IWIDTH,IHLEF3,IHLEF4,ILISTL,
     1              NEWNAM,MAXN3,
     1              IFUNC,NUMCHF,MAXCHF,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
  410 CONTINUE
C
C               *****************************************************
C               **  STEP 7--                                       **
C               **  PRINT FEEDBACK MESSAGE                         **
C               *****************************************************
C
      ISTEPN='4'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STGL')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IFEEDB.EQ.'ON' .AND. IPRINT.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,710)NSTR
  710   FORMAT(I5,' STRINGS HAVE BEEN CREATED FROM THE GROUP LABELS.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IHLEF3='NUMS'
      IHLEF4='TRIN'
      VALUE0=REAL(NSTR)
      CALL DPADDP(IHLEF3,IHLEF4,VALUE0,IHOST1,ISUBN0,
     1            IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1            IANS,IWIDTH,IBUGA3,IERROR)
C
C               ****************
C               **  STEP 90-- **
C               **  EXIT.     **
C               ****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STGL')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTGL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMNAM
 9013   FORMAT('NUMNAM,IVALUE = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,NUMNAM
          WRITE(ICOUT,9016)I,IHNAME(I),IHNAM2(I),IUSE(I),
     1                     IVSTAR(I),IVSTOP(I)
 9016     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTIN(ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--RETURN THE START AND STOP POSITIONS OF A SUBSTRING
C              OF A PREVIOUSLY DEFINED STRING.
C     EXAMPLE--LET NSTART NSTOP = STRING INDEX STRING SUBSTRING
C     NOTE--THE FOLLOWING SYNTAX IS NOT SUPPORTED FOR THIS COMMAND:
C              LET Y(2) Y(8) = STRING INDEX S  SUBSTRING
C           ALSO, THE STRINGS ON THE RIGHT HAND SIDE MUST BOTH BE
C           PREVIOUSLY DEFINED.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/11
C     ORIGINAL VERSION--NOVEMBER  2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 NEWNAM
      CHARACTER*4 NEWNA2
      CHARACTER*4 NEWCOL
      CHARACTER*4 NEWCO2
      CHARACTER*4 ICASEL
      CHARACTER*4 ICASE2
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHLE21
      CHARACTER*4 IHLE22
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
      CHARACTER*4 IHRI21
      CHARACTER*4 IHRI22
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*8 ISTR
C
C---------------------------------------------------------------------
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='IN  '
C
      IERROR='NO'
C
      ILOC3=0
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STIN')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTIN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMNAM
   52   FORMAT('IBUGA3,ISUBRO,NUMNAM = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMNAM
          WRITE(ICOUT,56)I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),
     1                   IVSTOP(I)
   56     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        WRITE(ICOUT,57)NUMCHF,MAXCHF
   57   FORMAT('NUMCHF,MAXCHF = ',2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,60)(IFUNC(I),I=1,MIN(120,MAXCHF))
   60   FORMAT('IFUNC(.)  = ',120A1)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               **********************************
C               **  STEP 1--                    **
C               **  INITIALIZE SOME VARIABLES.  **
C               **********************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STIN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NEWNAM='NO'
      NEWNA2='NO'
      NEWCOL='NO'
      NEWCO2='NO'
      ICASEL='UNKN'
      ICASE2='UNKN'
      NIOLD1=0
      NIOLD2=0
      ICOLL=0
      ICOL2=0
C
C               ******************************************************
C               **  STEP 2--                                         *
C               **  EXAMINE THE FIRST ARGUMENT ON THE                *
C               **  LEFT-HAND SIDE--                                 *
C               **  IF THIS IS A PREVIOUSLY DEFINED NAME, IT SHOULD  *
C               **  BE A PARAMETER (IF NOT, REPORT AN ERROR).        *
C               ******************************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STIN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHLEFT=IHARG(1)
      IHLEF2=IHARG2(1)
C
      DO2000I=1,NUMNAM
        I2=I
        IF(IHLEFT.EQ.IHNAME(I).AND.IHLEF2.EQ.IHNAM2(I))THEN
          IF(IUSE(I2).EQ.'P')THEN
            ICASEL='PARA'
            ILISTL=I2
            NUMTMP=NUMNAM
            GOTO2299
          ELSE
            WRITE(ICOUT,999)
  999       FORMAT(1X)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
 2001       FORMAT('***** ERROR IN STRING INDEX--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2003)IHLEFT,IHLEF2
 2003       FORMAT('      THE FIRST NAME ON THE LEFT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2005)
 2005       FORMAT('      ALREADY EXISTS, BUT NOT AS A PARAMETER.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
        ENDIF
 2000 CONTINUE
C
      NEWNAM='YES'
      IF(ICASEL.EQ.'UNKN')ICASEL='PARA'
C
      ILISTL=NUMNAM+1
      NUMTMP=NUMNAM+1
      IF(ILISTL.GT.MAXNAM)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2202)
 2202   FORMAT('      THE NUMBER OF VARIABLE, PARAMETER, AND ',
     1         'FUNCTION')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2203)MAXNAM
 2203   FORMAT('      NAMES HAS JUST EXCEEDED THE ALLOWABLE ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2204)
 2204   FORMAT('      ENTER      STATUS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2205)
 2205   FORMAT('      TO FIND OUT THE FULL LIST OF USED NAMES, AND')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2206)
 2206   FORMAT('      THEN REDEFINE OR DELETE SOME OF THE ALREADY ',
     1         'USED NAMES.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
 2299 CONTINUE
C
C               ******************************************************
C               **  STEP 2B-                                         *
C               **  EXAMINE THE SECOND ARGUMENT ON THE               *
C               **  LEFT-HAND SIDE--                                 *
C               **  IF THIS IS A PREVIOUSLY DEFINED NAME, IT SHOULD  *
C               **  BE A PARAMETER (IF NOT, REPORT AN ERROR).        *
C               ******************************************************
C
      ISTEPN='2B'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STIN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHLE21=IHARG(2)
      IHLE22=IHARG2(2)
C
      DO2300I=1,NUMNAM
        I2=I
        IF(IHLEFT.EQ.IHNAME(I).AND.IHLEF2.EQ.IHNAM2(I))THEN
          IF(IUSE(I2).EQ.'P')THEN
            ICASE2='PARA'
            ILISTL=I2
            GOTO2399
          ELSE
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2303)IHLEFT,IHLEF2
 2303       FORMAT('      THE SECOND NAME ON THE LEFT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2005)
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
        ENDIF
 2300 CONTINUE
C
      NEWNA2='YES'
      IF(ICASE2.EQ.'UNKN')ICASE2='PARA'
C
      ILIST2=NUMTMP+1
      IF(ILIST2.GT.MAXNAM)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2202)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2203)MAXNAM
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2204)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2205)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2206)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
 2399 CONTINUE
C
C               *****************************************************
C               **  STEP 3--                                       **
C               **  EXTRACT THE FIRST NAME ON THE RIGHT HAND SIDE  **
C               *****************************************************
C
      ISTEPN='3A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STIN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRIGH=IHARG(6)
      IHRIG2=IHARG2(6)
      DO3000I=1,NUMNAM
        I4=I
        IF(IHRIGH.EQ.IHNAME(I).AND.IHRIG2.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'F')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRIGH,IHRIG2
 3003       FORMAT('      THE NAME ON THE RIGHT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3005)
 3005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ISTRT1=IVSTAR(I4)
            ISTOP1=IVSTOP(I4)
            NLEN1=ISTOP1-ISTRT1+1
            GOTO3099
          ENDIF
        ENDIF
 3000 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRIGH,IHRIG2
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
 3015 FORMAT('      WAS NOT FOUND IN THE CURRENT NAME LIST.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3099 CONTINUE
C
C               *****************************************************
C               **  STEP 3B-                                       **
C               **  EXTRACT THE SECOND NAME ON THE RIGHT HAND SIDE **
C               *****************************************************
C
      ISTEPN='3B'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STIN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRI21=IHARG(7)
      IHRI22=IHARG2(7)
      DO3100I=1,NUMNAM
        I4=I
        IF(IHRI21.EQ.IHNAME(I).AND.IHRI22.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'F')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRI21,IHRI22
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3005)
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ISTRT2=IVSTAR(I4)
            ISTOP2=IVSTOP(I4)
            NLEN2=ISTOP2-ISTRT2+1
            GOTO3199
          ENDIF
        ENDIF
 3100 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRI21,IHRI22
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3199 CONTINUE
C
C               *****************************************************
C               **  STEP 4--                                       **
C               **  CHECK FOR MATCHING STRINGS                     **
C               *****************************************************
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STIN')THEN
        ISTEPN='4'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,4011)ISTRT1,ISTOP1,NLEN1
 4011   FORMAT('ISTRT1,ISTOP1,NLEN1 = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4012)ISTRT2,ISTOP2,NLEN2
 4012   FORMAT('ISTART,ISTOP,NLEN2 = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4013)ICASEL,ICASE2
 4013   FORMAT('ICASEL,ICASE2 = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      NTEMP=ISTOP1-NLEN2+1
      IMATCH=0
      IF(ISTRT1.GT.NTEMP)GOTO4199
      DO4100I=ISTRT1,NTEMP
        NSTRT=I
        NSTOP=NSTRT+NLEN2-1
        ICNT=0
C
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STIN')THEN
          WRITE(ICOUT,4801)I,NSTRT,NSTOP
 4801     FORMAT('I,NSTRT,NSTOP = ',3I8)
          CALL DPWRST('XXX','BUG ')
        ENDIF
C
        DO4110J=NSTRT,NSTOP
          IF(IFUNC(J)(1:1).NE.IFUNC(ISTRT2+ICNT)(1:1))GOTO4100
          ICNT=ICNT+1
 4110   CONTINUE
        IMATCH=1
        GOTO4199
 4100 CONTINUE
C
 4199 CONTINUE
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STIN')THEN
        ISTEPN='4B'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,4901)NSTRT,NSTOP,IMATCH
 4901   FORMAT('NSTRT,NSTOP,IMATCH = ',3I8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************************************************
C               **  STEP 5--                                       **
C               **  SAVE PARAMETERS                                **
C               *****************************************************
C
C
      IF(IMATCH.EQ.0)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,5001)IHRI21,IHRI22,IHRIGH,IHRIG2
 5001   FORMAT('STRING  ',A4,A4,'  WAS NOT MATCHED IN STRING ',A4,A4)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSE
        NSTRT=NSTRT-ISTRT1+1
        NSTOP=NSTOP-ISTRT1+1
      ENDIF
C
      IF(ICASEL.EQ.'PARA' .AND. ICASE2.EQ.'PARA')THEN
C
        ISTEPN='5'
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STIN')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IHNAME(ILISTL)=IHLEFT
        IHNAM2(ILISTL)=IHLEF2
        IUSE(ILISTL)='P'
        VALUE(ILISTL)=REAL(NSTRT)
        IVALUE(ILISTL)=VALUE(ILISTL)+0.5
        IN(ILISTL)=1
        IF(NEWNAM.EQ.'YES')NUMNAM=NUMNAM+1
C
        IHNAME(ILIST2)=IHLE21
        IHNAM2(ILIST2)=IHLE22
        IUSE(ILIST2)='P'
        VALUE(ILIST2)=REAL(NSTOP)
        IVALUE(ILISTL)=VALUE(ILISTL)+0.5
        IN(ILISTL)=1
        IF(NEWNAM.EQ.'YES')NUMNAM=NUMNAM+1
C
        IF(IPRINT.EQ.'ON' .AND. IFEEDB.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,5011)IHLEFT,IHLEF2,NSTRT
5011      FORMAT(A4,A4,' (START OF SUBSTRING) = ',I8)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,5013)IHLE21,IHLE22,NSTOP
5013      FORMAT(A4,A4,' (END OF SUBSTRING)   = ',I8)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
        ENDIF
      ENDIF
C
C
C               ****************
C               **  STEP 90-- **
C               **  EXIT.     **
C               ****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STIN')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTIN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMNAM
 9013   FORMAT('NUMNAM,IVALUE = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,NUMNAM
          WRITE(ICOUT,9016)I,IHNAME(I),IHNAM2(I),IUSE(I),
     1                     IVSTAR(I),IVSTOP(I)
 9016     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTLC(ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--CONVERT A STRING TO LOWER CASE
C     EXAMPLE--LET SOUT = LOWER CASE SOLD
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/11
C     ORIGINAL VERSION--NOVEMBER  2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 NEWNAM
      CHARACTER*4 NEWCOL
      CHARACTER*4 ICASEL
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
C
      CHARACTER*1 IC
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ILAB(10)
C
C---------------------------------------------------------------------
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='LC  '
C
      IERROR='NO'
C
      ILOC3=0
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STLC')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTLC--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMNAM
   52   FORMAT('IBUGA3,ISUBRO,NUMNAM = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMNAM
          WRITE(ICOUT,56)I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),
     1                   IVSTOP(I)
   56     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        WRITE(ICOUT,57)NUMCHF,MAXCHF
   57   FORMAT('NUMCHF,MAXCHF = ',2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,60)(IFUNC(I),I=1,MIN(120,MAXCHF))
   60   FORMAT('IFUNC(.)  = ',120A1)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               **********************************
C               **  STEP 1--                    **
C               **  INITIALIZE SOME VARIABLES.  **
C               **********************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STLC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NEWNAM='NO'
      NEWCOL='NO'
      ICASEL='UNKN'
      ICOLL=0
C
C               ******************************************************
C               **  STEP 2--                                         *
C               **  EXAMINE THE ARGUMENT ON THE                      *
C               **  LEFT-HAND SIDE--                                 *
C               **  IF THIS IS A PREVIOUSLY DEFINED NAME, IT SHOULD  *
C               **  BE A STRING    (IF NOT, REPORT AN ERROR).        *
C               ******************************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STLC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHLEFT=IHARG(1)
      IHLEF2=IHARG2(1)
C
      DO2000I=1,NUMNAM
        I2=I
        IF(IHLEFT.EQ.IHNAME(I).AND.IHLEF2.EQ.IHNAM2(I))THEN
          IF(IUSE(I2).EQ.'F')THEN
            ICASEL='STRI'
            ILISTL=I2
            GOTO2299
          ELSE
            WRITE(ICOUT,999)
  999       FORMAT(1X)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
 2001       FORMAT('***** ERROR IN LOWER CASE--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2003)IHLEFT,IHLEF2
 2003       FORMAT('      THE FIRST NAME ON THE LEFT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2005)
 2005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
        ENDIF
 2000 CONTINUE
C
      NEWNAM='YES'
      IF(ICASEL.EQ.'UNKN')ICASEL='STRI'
C
      ILISTL=NUMNAM+1
      IF(ILISTL.GT.MAXNAM)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2202)
 2202   FORMAT('      THE NUMBER OF VARIABLE, PARAMETER, AND ',
     1         'FUNCTION')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2203)MAXNAM
 2203   FORMAT('      NAMES HAS JUST EXCEEDED THE ALLOWABLE ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2204)
 2204   FORMAT('      ENTER      STATUS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2205)
 2205   FORMAT('      TO FIND OUT THE FULL LIST OF USED NAMES, AND')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2206)
 2206   FORMAT('      THEN REDEFINE OR DELETE SOME OF THE ALREADY ',
     1         'USED NAMES.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
 2299 CONTINUE
C
C               *****************************************************
C               **  STEP 3--                                       **
C               **  EXTRACT THE FIRST NAME ON THE RIGHT HAND SIDE  **
C               *****************************************************
C
      ISTEPN='3A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STLC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRIGH=IHARG(5)
      IHRIG2=IHARG2(5)
      DO3000I=1,NUMNAM
        I4=I
        IF(IHRIGH.EQ.IHNAME(I).AND.IHRIG2.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'F')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRIGH,IHRIG2
 3003       FORMAT('      THE NAME ON THE RIGHT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3005)
 3005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ISTRT1=IVSTAR(I4)
            ISTOP1=IVSTOP(I4)
            NLEN1=ISTOP1-ISTRT1+1
            GOTO3099
          ENDIF
        ENDIF
 3000 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRIGH,IHRIG2
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
 3015 FORMAT('      WAS NOT FOUND IN THE CURRENT NAME LIST.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3099 CONTINUE
C
C               *****************************************************
C               **  STEP 4--                                       **
C               **  PERFORM THE CASE CONVERSION                    **
C               *****************************************************
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STLC')THEN
        ISTEPN='4A'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,4011)ISTRT1,ISTOP1,NLEN1
 4011   FORMAT('ISTRT1,ISTOP1,NLEN1 = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4014)ICASEL
 4014   FORMAT('ICASEL = ',A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(NLEN1.GE.1)THEN
        ICNT=0
        DO4100I=ISTRT1,ISTOP1
          ICNT=ICNT+1
          IC=IFUNC(I)(1:1)
          CALL DPCOAN(IC,IJUNK)
          IF(IJUNK.GE.65 .AND. IJUNK.LE.90)THEN
            IJUNK=IJUNK+32
          ENDIF
          CALL DPCONA(IJUNK,IC)
          IFUNC2(ICNT)=' '
          IFUNC2(ICNT)(1:1)=IC
 4100   CONTINUE
      ENDIF
C
C               *****************************************************
C               **  STEP 5--                                       **
C               **  SAVE STRING AND PRINT FEEDBACK MESSAGE         **
C               *****************************************************
C
C
      IF(ICASEL.EQ.'STRI')THEN
C
        ISTEPN='5'
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STLC')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        CALL DPINFU(IFUNC2,ICNT,IHNAME,IHNAM2,IUSE,IVSTAR,IVSTOP,
     1              NUMNAM,IANS,IWIDTH,IHLEFT,IHLEF2,ILISTL,
     1              NEWNAM,MAXN3,
     1              IFUNC,NUMCHF,MAXCHF,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IF(IFEEDB.EQ.'ON' .AND. IPRINT.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,6606)IHLEFT,IHLEF2
 6606     FORMAT('THE NAME ',A4,A4,' HAS JUST BEEN EQUIVALENCED ')
          CALL DPWRST('XXX','BUG ')
          ILAB(1)='TO T'
          ILAB(2)='HE F'
          ILAB(3)='UNCT'
          ILAB(4)='ION '
          ILAB(5)='    '
          ILAB(6)=' -- '
          NUMWDL=6
          CALL DPPRIF(ILAB,NUMWDL,IFUNC2,ICNT,IBUGA3)
C
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
C
        ENDIF
C
      ENDIF
C
C
C               ****************
C               **  STEP 90-- **
C               **  EXIT.     **
C               ****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STLC')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTLC--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMNAM
 9013   FORMAT('NUMNAM,IVALUE = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,NUMNAM
          WRITE(ICOUT,9016)I,IHNAME(I),IHNAM2(I),IUSE(I),
     1                     IVSTAR(I),IVSTOP(I)
 9016     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTLN(ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--RETURN THE NUMBER OF CHARACTERS IN A PREVIOUSLY
C              DEFINED STRING.
C     EXAMPLE--LET NLEN = STRING LENGTH S
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/11
C     ORIGINAL VERSION--NOVEMBER  2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 NEWNAM
      CHARACTER*4 NEWCOL
      CHARACTER*4 ICASEL
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*8 ISTR
C
C---------------------------------------------------------------------
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='LN  '
C
      IERROR='NO'
C
      ILOC3=0
C
C               *****************************************************
C               **  TREAT THE SUBCASE OF THE LET FUNCTION COMMAND  **
C               **  WHICH DEFINES A FUNCTION                       **
C               *****************************************************
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STLN')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTLN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMNAM
   52   FORMAT('IBUGA3,ISUBRO,NUMNAM = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMNAM
          WRITE(ICOUT,56)I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),
     1                   IVSTOP(I)
   56     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        WRITE(ICOUT,57)NUMCHF,MAXCHF
   57   FORMAT('NUMCHF,MAXCHF = ',2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,60)(IFUNC(I),I=1,MIN(120,MAXCHF))
   60   FORMAT('IFUNC(.)  = ',120A1)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               **********************************
C               **  STEP 1--                    **
C               **  INITIALIZE SOME VARIABLES.  **
C               **********************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STLN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NEWNAM='NO'
      NEWCOL='NO'
      ICASEL='UNKN'
      NIOLD=0
      ICOLL=0
      ICOL2=0
C
C               ******************************************************
C               **  STEP 2--                                         *
C               **  EXAMINE THE LEFT-HAND SIDE--                     *
C               **  IF THIS IS A PREVIOUSLY DEFINED NAME, IT SHOULD  *
C               **  BE A PARAMETER (IF NOT, REPORT AN ERROR).        *
C               ******************************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STLN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHLEFT=IHARG(1)
      IHLEF2=IHARG2(1)
C
      DO1910I=1,4
        IF(IHLEFT(I:I).EQ.'(')THEN
          IHLEFT(I:4)=' '
          IHLEF2=' '
          ICASEL='ELEM'
          GOTO1999
        ENDIF
 1910 CONTINUE
      DO1920I=1,4
        IF(IHLEF2(I:I).EQ.'(')THEN
          IHLEF2(I:4)=' '
          ICASEL='ELEM'
          GOTO1999
        ENDIF
 1920 CONTINUE
 1999 CONTINUE
C
      DO2000I=1,NUMNAM
        I2=I
        IF(IHLEFT.EQ.IHNAME(I).AND.IHLEF2.EQ.IHNAM2(I))THEN
          IF(IUSE(I2).EQ.'P')THEN
            ICASEL='PARA'
            ILISTL=I2
            GOTO2900
          ELSEIF(IUSE(I2).EQ.'V')THEN
            ICASEL='ELEM'
            ILISTL=I2
            ICOLL=IVALUE(ILISTL)
            NIOLD=IN(ILISTL)
            GOTO2900
          ELSE
            WRITE(ICOUT,999)
  999       FORMAT(1X)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
 2001       FORMAT('***** ERROR IN STRING LENGTH--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2003)IHLEFT,IHLEF2
 2003       FORMAT('      THE NAME ON THE LEFT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2005)
 2005       FORMAT('      ALREADY EXISTS, BUT NOT AS A PARAMETER.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
        ENDIF
 2000 CONTINUE
C
      NEWNAM='YES'
      IF(ICASEL.EQ.'UNKN')ICASEL='PARA'
C
      ILISTL=NUMNAM+1
      IF(ILISTL.GT.MAXNAM)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2202)
 2202   FORMAT('      THE NUMBER OF VARIABLE, PARAMETER, AND ',
     1         'FUNCTION')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2203)MAXNAM
 2203   FORMAT('      NAMES HAS JUST EXCEEDED THE ALLOWABLE ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2204)
 2204   FORMAT('      ENTER      STATUS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2205)
 2205   FORMAT('      TO FIND OUT THE FULL LIST OF USED NAMES, AND')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2206)
 2206   FORMAT('      THEN REDEFINE OR DELETE SOME OF THE ALREADY ',
     1         'USED NAMES.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
 2900 CONTINUE
C
C               *****************************************************
C               **  STEP 3--                                       **
C               **  EXTRACT THE NAME ON THE RIGHT HAND SIDE        **
C               *****************************************************
C
      ISTEPN='3'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STLN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRIGH=IHARG(5)
      IHRIG2=IHARG2(5)
      DO3000I=1,NUMNAM
        I4=I
        IF(IHRIGH.EQ.IHNAME(I).AND.IHRIG2.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'F')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRIGH,IHRIG2
 3003       FORMAT('      THE NAME ON THE RIGHT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3005)
 3005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ISTART=IVSTAR(I4)
            ISTOP=IVSTOP(I4)
            IVAL=ISTOP-ISTART+1
            GOTO3900
          ENDIF
        ENDIF
 3000 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRIGH,IHRIG2
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
 3015 FORMAT('      WAS NOT FOUND IN THE CURRENT NAME LIST.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3900 CONTINUE
C
C               *****************************************************
C               **  STEP 4--                                       **
C               **  SAVE PARAMETER                                 **
C               *****************************************************
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STLN')THEN
        ISTEPN='4'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,4011)ISTART,ISTOP,IVAL
 4011   FORMAT('ISTART,ISTOP,IVAL = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4013)ICASEL
 4013   FORMAT('ICASEL = ',A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(ICASEL.EQ.'PARA')THEN
C
        ISTEPN='4A'
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STLN')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IHNAME(ILISTL)=IHLEFT
        IHNAM2(ILISTL)=IHLEF2
        IUSE(ILISTL)='P'
        VALUE(ILISTL)=REAL(IVAL)
        IVALUE(ILISTL)=VALUE(ILISTL)+0.5
        IN(ILISTL)=1
        IF(NEWNAM.EQ.'YES')NUMNAM=NUMNAM+1
C
        IF(IPRINT.EQ.'ON' .AND. IFEEDB.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,15111)IHLEFT,IHLEF2,IHRIGH,IHRIG2,IVAL
15111     FORMAT(A4,A4,' CONTAINS THE LENGTH OF STRING ',A4,A4,
     1           ' = ',I8)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
        ENDIF
      ELSEIF(ICASEL.EQ.'ELEM')THEN
C
C       SEARCH IANS STRING FOR "(xx) =".  IF NO PARENTHESIS
C       FOUND BEFORE "=", THEN DO NOT KNOW WHAT ROW OF THE
C       VARIABLE TO SAVE.  TREAT THIS AS AN ERROR.
C
        NLEFT=-1
        NRIGHT=-1
        NEQUAL=-1
        DO16001I=1,IWIDTH
          IF(IANS(I)(1:1).EQ.'(' .AND. NLEFT.LT.0)THEN
            NLEFT=I
          ELSEIF(IANS(I)(1:1).EQ.')' .AND. NRIGHT.LT.0)THEN
            NRIGHT=I
          ELSEIF(IANS(I)(1:1).EQ.'=' .AND. NEQUAL.LT.0)THEN
            NEQUAL=I
          ENDIF
16001   CONTINUE
C
C       NEED  NLEFT < NRIGHT < NEQUAL
C
        NSTRT=NLEFT+1
        NSTOP=NRIGHT-1
        NLEN=NSTOP-NSTRT+1
        IF(NLEFT.GT.NRIGHT .OR. NRIGHT.GT.NEQUAL .OR.
     1     NSTRT.GT.NSTOP .OR. NLEN.GT.8) THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2001)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,16011)
16011     FORMAT('      UNRECOGNIZED SYNTAX FOR VARIABLE ELEMENT ON')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,16013)
16013     FORMAT('      LEFT HAND SIDE EQUAL SIGN.')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ELSE
          ISTR=' '
          DO16020I=1,NLEN
            ISTR(I:I)=IANS(NSTRT+I-1)(1:1)
16020     CONTINUE
          READ(ISTR,'(I8)',ERR=16029)IARGL
          GOTO16049
C
16029     CONTINUE
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2001)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,16011)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,16013)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
C
16049     CONTINUE
        ENDIF
C
        IF(IARGL.LT.1 .OR. IARGL.GT.MAXN)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2001)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,16052)IARGL,ILEFT
16052     FORMAT('      THE SPECIFIED ROW (',I8,') OF VARIABLE ',A4,A4)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,16054)
16054     FORMAT('      WAS LESS THAN 1 OR GREATER THAN THE')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,16055)MAXN
16055     FORMAT('      MAXIMUM ALLOWABLE ',I8)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
C
        IF(NEWNAM.EQ.'YES')THEN
          NIOLD=1
        ENDIF
        NINEW=NIOLD
        IF(IARGL.GT.NINEW)NINEW=IARGL
        NS2=1
C
        RIGHT=REAL(IVAL)
        IJ=MAXN*(ICOLL-1)+IARGL
        IF(ICOLL.LE.MAXCOL)V(IJ)=RIGHT
        IF(ICOLL.EQ.MAXCP1)PRED(IARGL)=RIGHT
        IF(ICOLL.EQ.MAXCP2)RES(IARGL)=RIGHT
        IF(ICOLL.EQ.MAXCP3)YPLOT(IARGL)=RIGHT
        IF(ICOLL.EQ.MAXCP4)XPLOT(IARGL)=RIGHT
        IF(ICOLL.EQ.MAXCP5)X2PLOT(IARGL)=RIGHT
        IF(ICOLL.EQ.MAXCP6)TAGPLO(IARGL)=RIGHT
C
        IHNAME(ILISTL)=IHLEFT
        IHNAM2(ILISTL)=IHLEF2
        IUSE(ILISTL)='V'
        IVALUE(ILISTL)=ICOLL
        VALUE(ILISTL)=ICOLL
        IN(ILISTL)=NINEW
C
        IF(NEWNAM.EQ.'YES')THEN
          NUMNAM=NUMNAM+1
          NUMCOL=NUMCOL+1
        ENDIF
C
        DO16200J4=1,NUMNAM
          IF(IUSE(J4).EQ.'V'.AND.IVALUE(J4).EQ.ICOLL)THEN
            IUSE(J4)='V'
            IVALUE(J4)=ICOLL
            VALUE(J4)=ICOLL
            IN(J4)=NINEW
            GOTO16209
          ENDIF
16200   CONTINUE
16209   CONTINUE
C
        IF(IPRINT.EQ.'ON' .AND. IFEEDB.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,16211)IHRIGH,IHRIG2,IVAL
16211     FORMAT('THE LENGTH OF STRING ',A4,A4,' = ',I8)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
        ENDIF
      ENDIF
      GOTO9000
C
C
C               ****************
C               **  STEP 90-- **
C               **  EXIT.     **
C               ****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STLN')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTLN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMNAM
 9013   FORMAT('NUMNAM,IVALUE = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,NUMNAM
          WRITE(ICOUT,9016)I,IHNAME(I),IHNAM2(I),IUSE(I),
     1                     IVSTAR(I),IVSTOP(I)
 9016     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTMR(ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--INSERT A STRING INTO A PREVIOUSLY DEFINED STRING
C     EXAMPLE--LET SOUT = STRING MERGE SOLD SNEW START
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/11
C     ORIGINAL VERSION--NOVEMBER  2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 NEWNAM
      CHARACTER*4 NEWNA2
      CHARACTER*4 NEWCOL
      CHARACTER*4 NEWCO2
      CHARACTER*4 ICASEL
      CHARACTER*4 ICASE2
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
      CHARACTER*4 IHRI21
      CHARACTER*4 IHRI22
      CHARACTER*4 IHRI31
      CHARACTER*4 IHRI32
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ILAB(10)
C
C---------------------------------------------------------------------
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='MR  '
C
      IERROR='NO'
C
      ILOC3=0
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STMR')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTMR--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMNAM
   52   FORMAT('IBUGA3,ISUBRO,NUMNAM = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMNAM
          WRITE(ICOUT,56)I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),
     1                   IVSTOP(I)
   56     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        WRITE(ICOUT,57)NUMCHF,MAXCHF
   57   FORMAT('NUMCHF,MAXCHF = ',2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,60)(IFUNC(I),I=1,MIN(120,MAXCHF))
   60   FORMAT('IFUNC(.)  = ',120A1)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               **********************************
C               **  STEP 1--                    **
C               **  INITIALIZE SOME VARIABLES.  **
C               **********************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STMR')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NEWNAM='NO'
      NEWNA2='NO'
      NEWCOL='NO'
      NEWCO2='NO'
      ICASEL='UNKN'
      ICASE2='UNKN'
      NIOLD1=0
      NIOLD2=0
      ICOLL=0
      ICOL2=0
C
C               ******************************************************
C               **  STEP 2--                                         *
C               **  EXAMINE THE ARGUMENT ON THE                      *
C               **  LEFT-HAND SIDE--                                 *
C               **  IF THIS IS A PREVIOUSLY DEFINED NAME, IT SHOULD  *
C               **  BE A STRING    (IF NOT, REPORT AN ERROR).        *
C               ******************************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STMR')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHLEFT=IHARG(1)
      IHLEF2=IHARG2(1)
C
      DO2000I=1,NUMNAM
        I2=I
        IF(IHLEFT.EQ.IHNAME(I).AND.IHLEF2.EQ.IHNAM2(I))THEN
          IF(IUSE(I2).EQ.'F')THEN
            ICASEL='STRI'
            ILISTL=I2
            GOTO2299
          ELSE
            WRITE(ICOUT,999)
  999       FORMAT(1X)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
 2001       FORMAT('***** ERROR IN STRING MERGE--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2003)IHLEFT,IHLEF2
 2003       FORMAT('      THE FIRST NAME ON THE LEFT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2005)
 2005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
        ENDIF
 2000 CONTINUE
C
      NEWNAM='YES'
      IF(ICASEL.EQ.'UNKN')ICASEL='STRI'
C
      ILISTL=NUMNAM+1
      IF(ILISTL.GT.MAXNAM)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2202)
 2202   FORMAT('      THE NUMBER OF VARIABLE, PARAMETER, AND ',
     1         'FUNCTION')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2203)MAXNAM
 2203   FORMAT('      NAMES HAS JUST EXCEEDED THE ALLOWABLE ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2204)
 2204   FORMAT('      ENTER      STATUS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2205)
 2205   FORMAT('      TO FIND OUT THE FULL LIST OF USED NAMES, AND')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2206)
 2206   FORMAT('      THEN REDEFINE OR DELETE SOME OF THE ALREADY ',
     1         'USED NAMES.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
 2299 CONTINUE
C
C               *****************************************************
C               **  STEP 3--                                       **
C               **  EXTRACT THE FIRST NAME ON THE RIGHT HAND SIDE  **
C               *****************************************************
C
      ISTEPN='3A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STMR')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRIGH=IHARG(5)
      IHRIG2=IHARG2(5)
      DO3000I=1,NUMNAM
        I4=I
        IF(IHRIGH.EQ.IHNAME(I).AND.IHRIG2.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'F')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRIGH,IHRIG2
 3003       FORMAT('      THE NAME ON THE RIGHT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3005)
 3005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ISTRT1=IVSTAR(I4)
            ISTOP1=IVSTOP(I4)
            NLEN1=ISTOP1-ISTRT1+1
            GOTO3099
          ENDIF
        ENDIF
 3000 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRIGH,IHRIG2
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
 3015 FORMAT('      WAS NOT FOUND IN THE CURRENT NAME LIST.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3099 CONTINUE
C
C               *****************************************************
C               **  STEP 3B-                                       **
C               **  EXTRACT THE SECOND NAME ON THE RIGHT HAND SIDE **
C               *****************************************************
C
      ISTEPN='3B'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STMR')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRI21=IHARG(6)
      IHRI22=IHARG2(6)
      DO3100I=1,NUMNAM
        I4=I
        IF(IHRI21.EQ.IHNAME(I).AND.IHRI22.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'F')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRI21,IHRI22
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3005)
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ISTRT2=IVSTAR(I4)
            ISTOP2=IVSTOP(I4)
            NLEN2=ISTOP2-ISTRT2+1
            GOTO3199
          ENDIF
        ENDIF
 3100 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRI21,IHRI22
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3199 CONTINUE
C
C               *****************************************************
C               **  STEP 3C-                                       **
C               **  EXTRACT THE THIRD  NAME ON THE RIGHT HAND SIDE **
C               *****************************************************
C
      ISTEPN='3C'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STMR')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRI31=IHARG(7)
      IHRI32=IHARG2(7)
      DO3200I=1,NUMNAM
        I4=I
        IF(IHRI31.EQ.IHNAME(I).AND.IHRI32.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'P')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRI31,IHRI32
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3215)
 3215       FORMAT('      ALREADY EXISTS, BUT NOT AS A PARAMETER.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ILISR1=I4
            NSTART=IVALUE(ILISR1)
            GOTO3299
          ENDIF
        ENDIF
 3200 CONTINUE
C
      IF(NUMARG.GE.7)THEN
        IF(IARGT(7).EQ.'NUMB')THEN
          NSTART=IARG(7)
          GOTO3299
        ENDIF
      ENDIF
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRI31,IHRI32
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3299 CONTINUE
C
C               *****************************************************
C               **  STEP 4--                                       **
C               **  CREATE THE SUBSTRING                           **
C               *****************************************************
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STMR')THEN
        ISTEPN='4'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,4011)ILISR1,ILISR2,NSTART,NSTOP
 4011   FORMAT('ILISR1,ILISR2,NSTART,NSTOP = ',4I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4013)ICASEL
 4013   FORMAT('ICASEL = ',A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(NSTART.LT.1 .OR. NSTART.GT.MAXCHF)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4021)MAXCHF
 4021   FORMAT('      THE START INDEX IS LESS THAN 1 OR GREATER ',
     1         'THAN ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4023)NSTART
 4023   FORMAT('      THE VALUE OF THE START INDEX IS ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      ICNT=0
      IF(NSTART.GT.1)THEN
        DO4100I=1,NSTART-1
          ICNT=ICNT+1
          IINDX=I+ISTRT1-1
          IFUNC2(ICNT)=IFUNC(IINDX)
 4100   CONTINUE
      ENDIF
      IF(NLEN2.GE.1)THEN
        DO4110I=1,NLEN2
          ICNT=ICNT+1
          IINDX=I+ISTRT2-1
          IFUNC2(ICNT)=IFUNC(IINDX)
 4110   CONTINUE
      ENDIF
      IF(NSTART.LT.NLEN1)THEN
        DO4120I=NSTART,NLEN1
          ICNT=ICNT+1
          IINDX=I+ISTRT1-1
          IFUNC2(ICNT)=IFUNC(IINDX)
 4120   CONTINUE
      ENDIF
C
 4199 CONTINUE
C
C               *****************************************************
C               **  STEP 5--                                       **
C               **  SAVE STRING AND PRINT FEEDBACK MESSAGE         **
C               *****************************************************
C
C
      IF(ICASEL.EQ.'STRI')THEN
C
        ISTEPN='5'
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STMR')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        CALL DPINFU(IFUNC2,ICNT,IHNAME,IHNAM2,IUSE,IVSTAR,IVSTOP,
     1              NUMNAM,IANS,IWIDTH,IHLEFT,IHLEF2,ILISTL,
     1              NEWNAM,MAXN3,
     1              IFUNC,NUMCHF,MAXCHF,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IF(IFEEDB.EQ.'ON' .AND. IPRINT.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,6606)IHLEFT,IHLEF2
 6606     FORMAT('THE NAME ',A4,A4,' HAS JUST BEEN EQUIVALENCED ')
          CALL DPWRST('XXX','BUG ')
          ILAB(1)='TO T'
          ILAB(2)='HE F'
          ILAB(3)='UNCT'
          ILAB(4)='ION '
          ILAB(5)='    '
          ILAB(6)=' -- '
          NUMWDL=6
          CALL DPPRIF(ILAB,NUMWDL,IFUNC2,ICNT,IBUGA3)
C
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
C
        ENDIF
C
      ENDIF
C
C
C               ****************
C               **  STEP 90-- **
C               **  EXIT.     **
C               ****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STMR')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTMR--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMNAM
 9013   FORMAT('NUMNAM,IVALUE = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,NUMNAM
          WRITE(ICOUT,9016)I,IHNAME(I),IHNAM2(I),IUSE(I),
     1                     IVSTAR(I),IVSTOP(I)
 9016     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTNW(ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--DETERMINE THE NUMBER OF WORDS IN A STRING
C     EXAMPLE--LET NWORD = NUMBER OF WORD STIN
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/10
C     ORIGINAL VERSION--OCTOBER   2010.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 NEWNAM
      CHARACTER*4 NEWNA2
      CHARACTER*4 NEWCOL
      CHARACTER*4 NEWCO2
      CHARACTER*4 ICASEL
      CHARACTER*4 ICASE2
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
      CHARACTER*4 IHRI21
      CHARACTER*4 IHRI22
      CHARACTER*4 IHRI31
      CHARACTER*4 IHRI32
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ILAB(10)
C
C---------------------------------------------------------------------
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='NW  '
C
      IERROR='NO'
C
      ILOC3=0
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STNW')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTNW--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMNAM
   52   FORMAT('IBUGA3,ISUBRO,NUMNAM = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMNAM
          WRITE(ICOUT,56)I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),
     1                   IVSTOP(I)
   56     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        WRITE(ICOUT,57)NUMCHF,MAXCHF,NUMARG
   57   FORMAT('NUMCHF,MAXCHF,NUMARG = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,60)(IFUNC(I),I=1,MIN(120,MAXCHF))
   60   FORMAT('IFUNC(.)  = ',120A1)
        CALL DPWRST('XXX','BUG ')
        IF(NUMARG.GE.1)THEN
          DO70I=1,NUMARG
            WRITE(ICOUT,76)I,IHARG(I),IHARG2(I),IARGT(I),IARG(I)
   76       FORMAT('I,IHARG(I),IHARG2(I),IARGT(I),IARG(I) = ',
     1             I8,2X,A4,A4,2X,A4,2X,I8)
            CALL DPWRST('XXX','BUG ')
   70     CONTINUE
        ENDIF
      ENDIF
C
C               **********************************
C               **  STEP 1--                    **
C               **  INITIALIZE SOME VARIABLES.  **
C               **********************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STNW')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NEWNAM='NO'
      NEWNA2='NO'
      NEWCOL='NO'
      NEWCO2='NO'
      ICASEL='UNKN'
      ICASE2='UNKN'
      NIOLD1=0
      NIOLD2=0
      ICOLL=0
      ICOL2=0
C
C               ******************************************************
C               **  STEP 2--                                         *
C               **  EXAMINE THE FIRST ARGUMENT ON THE                *
C               **  LEFT-HAND SIDE--                                 *
C               **  IF THIS IS A PREVIOUSLY DEFINED NAME, IT SHOULD  *
C               **  BE A PARAMETER (IF NOT, REPORT AN ERROR).        *
C               ******************************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STNW')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHLEFT=IHARG(1)
      IHLEF2=IHARG2(1)
C
      DO2000I=1,NUMNAM
        I2=I
        IF(IHLEFT.EQ.IHNAME(I).AND.IHLEF2.EQ.IHNAM2(I))THEN
          IF(IUSE(I2).EQ.'P')THEN
            ICASEL='PARA'
            ILISTL=I2
            NUMTMP=NUMNAM
            GOTO2299
          ELSE
            WRITE(ICOUT,999)
  999       FORMAT(1X)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
 2001       FORMAT('***** ERROR IN NUMBER OF WORDS--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2003)IHLEFT,IHLEF2
 2003       FORMAT('      THE FIRST NAME ON THE LEFT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2005)
 2005       FORMAT('      ALREADY EXISTS, BUT NOT AS A PARAMETER.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
        ENDIF
 2000 CONTINUE
C
      NEWNAM='YES'
      IF(ICASEL.EQ.'UNKN')ICASEL='PARA'
C
      ILISTL=NUMNAM+1
      NUMTMP=NUMNAM+1
      IF(ILISTL.GT.MAXNAM)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2202)
 2202   FORMAT('      THE NUMBER OF VARIABLE, PARAMETER, AND ',
     1         'FUNCTION')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2203)MAXNAM
 2203   FORMAT('      NAMES HAS JUST EXCEEDED THE ALLOWABLE ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2204)
 2204   FORMAT('      ENTER      STATUS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2205)
 2205   FORMAT('      TO FIND OUT THE FULL LIST OF USED NAMES, AND')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2206)
 2206   FORMAT('      THEN REDEFINE OR DELETE SOME OF THE ALREADY ',
     1         'USED NAMES.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
 2299 CONTINUE
C
C               *****************************************************
C               **  STEP 3--                                       **
C               **  EXTRACT THE FIRST NAME ON THE RIGHT HAND SIDE  **
C               *****************************************************
C
      ISTEPN='3A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STNW')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRIGH=IHARG(6)
      IHRIG2=IHARG2(6)
      DO3000I=1,NUMNAM
        I4=I
        IF(IHRIGH.EQ.IHNAME(I).AND.IHRIG2.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'F')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRIGH,IHRIG2
 3003       FORMAT('      THE NAME ON THE RIGHT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3005)
 3005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ISTRT1=IVSTAR(I4)
            ISTOP1=IVSTOP(I4)
            NLEN1=ISTOP1-ISTRT1+1
C
            IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STNW')THEN
              WRITE(ICOUT,999)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,3011)I4,ISTRT1,ISTOP1,NLEN1
 3011         FORMAT('I4,ISTRT1,ISTOP1,NLEN1 = ',4I8)
              CALL DPWRST('XXX','BUG ')
            ENDIF
C
            GOTO3099
          ENDIF
        ENDIF
 3000 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRIGH,IHRIG2
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
 3015 FORMAT('      WAS NOT FOUND IN THE CURRENT NAME LIST.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3099 CONTINUE
C
C               *****************************************************
C               **  STEP 4--                                       **
C               **  FIND THE NUMBER OF WORDS                       **
C               *****************************************************
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STNW')THEN
        ISTEPN='4'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,4012)ISTRT1,ISTOP1,NLEN1
 4012   FORMAT('ISTRT1,ISTOP1,NLEN1 = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4013)ICASEL
 4013   FORMAT('ICASEL = ',A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C     NOW EXTRACT NUMBER OF WORDS
C
C     WORD BOUNDARIES ARE DEFINED BY SPACES (NON-PRINTING CHARACTERS
C     ARE DEFINED AS SPACES).
C
C     STEP 1: DETERMINE START/STOP POSITION OF WORD
C
      NWORD=0
      IFLAG=0
C
      DO4100I=ISTRT1,ISTOP1
        IPOS=I
        IXTEMP=ICHAR(IFUNC(IPOS)(1:1))
C
        IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STNW')THEN
          WRITE(ICOUT,4111)I,IFLAG,NWORD,IPOS,IXTEMP,IFUNC(IPOS)
 4111     FORMAT('I,IFLAG,NWORD,IPOS,IXTEMP,IFUNC(IPOS) = ',5I8,2X,A4)
          CALL DPWRST('XXX','BUG ')
        ENDIF
C
C       CASE 1: WORD BOUNDARY DETECTED
C
        IF(IXTEMP.LE.32 .OR. IXTEMP.GE.127)THEN
          IF(IFLAG.EQ.1)THEN
            IFLAG=0
          ELSEIF(IFLAG.EQ.0)THEN
            CONTINUE
          ENDIF
C
C       CASE 2: NOT A WORD BOUNDARY DETECTED.  IS THIS START OF
C               NEW WORD OR CONTINUATION OF CURRENT WORD?
C
        ELSE
          IF(IFLAG.EQ.0)THEN
            ISTART=I
            ISTOP=I
            NWORD=NWORD+1
            IFLAG=1
          ELSEIF(IFLAG.EQ.1)THEN
            ISTOP=I
          ENDIF
        ENDIF
 4100 CONTINUE
C
C               *********************************
C               **  STEP 5--                   **
C               **  SAVE PARAMETER (NWORD)     **
C               *********************************
C
C
      IF(ICASEL.EQ.'PARA')THEN
C
        ISTEPN='5'
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STNW')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IHNAME(ILISTL)=IHLEFT
        IHNAM2(ILISTL)=IHLEF2
        IUSE(ILISTL)='P'
        VALUE(ILISTL)=REAL(NWORD)
        IVALUE(ILISTL)=VALUE(ILISTL)+0.5
        IN(ILISTL)=1
        IF(NEWNAM.EQ.'YES')NUMNAM=NUMNAM+1
C
        IF(IPRINT.EQ.'ON' .AND. IFEEDB.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,5011)IHLEFT,IHLEF2,NWORD
5011      FORMAT('NUMBER OF WORDS IN STRING ',A4,A4,'  = ',I8)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
        ENDIF
      ENDIF
C
C               ****************
C               **  STEP 90-- **
C               **  EXIT.     **
C               ****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STNW')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTNW--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMNAM
 9013   FORMAT('NUMNAM,IVALUE = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,NUMNAM
          WRITE(ICOUT,9016)I,IHNAME(I),IHNAM2(I),IUSE(I),
     1                     IVSTAR(I),IVSTOP(I)
 9016     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTRI(NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2,ISEED,
     1ISUBRO,IBUGG2,IBUGG3,IBUGQ,IFOUND,IERROR)
C
C     PURPOSE--GENERATE A STRIP PLOT (ALSO KNOWN AS A DOT PLOT)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATROY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/10
C     ORIGINAL VERSION--OCTOBER   2008.
C     UPDATED         --OCTOBER   2009. ADD A "BATCH MULTIPLE" OPTION
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IAND1
      CHARACTER*4 IAND2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGG2
      CHARACTER*4 IBUGG3
      CHARACTER*4 IBUGQ
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 ICASEQ
      CHARACTER*4 IDATSW
      CHARACTER*4 IMULT
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
      CHARACTER*4 IHBATC
      CHARACTER*4 IHBAT2
      CHARACTER*4 IERRO4
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      PARAMETER (MAXSPN=10)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
      CHARACTER*40 INAME
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
C
      DIMENSION Y1(MAXOBV)
      DIMENSION X1(MAXOBV)
      DIMENSION TAG1(MAXOBV)
      DIMENSION TAG2(MAXOBV)
      DIMENSION XIDTEM(MAXOBV)
      DIMENSION XIDTE2(MAXOBV)
      DIMENSION XTEMP(MAXOBV)
      DIMENSION YTEMP(MAXOBV)
      DIMENSION TEMP3(MAXOBV)
      DIMENSION TEMP4(MAXOBV)
      INCLUDE 'DPCOZZ.INC'
      EQUIVALENCE (GARBAG(IGARB1),X1(1))
      EQUIVALENCE (GARBAG(IGARB2),Y1(1))
      EQUIVALENCE (GARBAG(IGARB3),TAG1(1))
      EQUIVALENCE (GARBAG(IGARB4),XIDTEM(1))
      EQUIVALENCE (GARBAG(IGARB5),XTEMP(1))
      EQUIVALENCE (GARBAG(IGARB6),YTEMP(1))
      EQUIVALENCE (GARBAG(IGARB7),TEMP3(1))
      EQUIVALENCE (GARBAG(IGARB8),TAG2(1))
      EQUIVALENCE (GARBAG(IGARB9),XIDTE2(1))
      EQUIVALENCE (GARBAG(IGAR10),TEMP4(1))
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOST.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      ISUBN1='DPST'
      ISUBN2='RI  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      MINN2=2
C
C               **********************************************
C               **  TREAT THE STRIP    PLOT AND             **
C               **  RELATED STATISTICAL DISTRIBUTION PLOTS  **
C               **********************************************
C
      IF(IBUGG2.EQ.'ON' .OR. ISUBRO.EQ.'STRI')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTRI--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)IBUGG2,IBUGG3,IBUGQ
   53   FORMAT('IBUGG2,IBUGG3,IBUGQ = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ***************************
C               **  STEP 1--             **
C               **  EXTRACT THE COMMAND  **
C               ***************************
C
      ISTEPN='1'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'STRI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(ICOM.EQ.'STRI'.AND.IHARG(1).EQ.'PLOT')THEN
        ICASPL='STRI'
        ILASTC=1
        CALL ADJUST(ILASTC,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
        IFOUND='YES'
      ELSEIF(ICOM.EQ.'BATC'.AND.IHARG(1).EQ.'STRI'.AND.
     1       IHARG(2).EQ.'PLOT')THEN
        ICASPL='BSPL'
        ILASTC=2
        CALL ADJUST(ILASTC,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
        IFOUND='YES'
      ELSEIF(ICOM.EQ.'BATC'.AND.IHARG(1).EQ.'MULT'.AND.
     1       IHARG(2).EQ.'STRI'.AND.IHARG(3).EQ.'PLOT')THEN
        ICASPL='BMSP'
        ILASTC=3
        CALL ADJUST(ILASTC,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
        IFOUND='YES'
      ELSEIF(ICOM.EQ.'MULT'.AND.IHARG(1).EQ.'BATCH'.AND.
     1       IHARG(2).EQ.'STRI'.AND.IHARG(3).EQ.'PLOT')THEN
        ICASPL='BMSP'
        ILASTC=3
        CALL ADJUST(ILASTC,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
        IFOUND='YES'
      ELSE
        IFOUND='NO'
        GOTO9000
      ENDIF
C
      IF(IBUGG2.EQ.'ON' .OR. ISUBRO.EQ.'STRI')THEN
        WRITE(ICOUT,62)ICASPL,MAXV2
   62   FORMAT('ICASPL,MAXV2 = ',A4,2X,I5)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ****************************************
C               **  STEP 2--                          **
C               **  EXTRACT THE VARIABLE LIST         **
C               ****************************************
C
      ISTEPN='2'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'STRI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='STRIP PLOT'
      MINNA=1
      IF(ICASPL.EQ.'BSPL')MINNA=2
      IF(ICASPL.EQ.'BMSP')MINNA=3
      MAXNA=100
      MINN2=2
      IFLAGE=1
      IFLAGM=0
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
      MINNVA=1
      IF(ICASPL.EQ.'BSPL')MINNVA=2
      IF(ICASPL.EQ.'BMSP')MINNVA=3
      MAXNVA=2
      IF(ICASPL.EQ.'BSPL')MAXNVA=3
      IF(ICASPL.EQ.'BMSP')MAXNVA=3
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGG3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(NUMVAR.EQ.1)THEN
        IDATSW='RAW'
      ELSEIF(NUMVAR.EQ.2)THEN
        IF(ICASPL.EQ.'STRI')THEN
          IDATSW='FREQ'
        ELSE
          IDATSW='RAW'
        ENDIF
      ELSEIF(NUMVAR.EQ.3)THEN
        IF(ICASPL.EQ.'BSPL')IDATSW='FREQ'
        IF(ICASPL.EQ.'BMSP')IDATSW='RAW'
      ENDIF
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'STRI')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
      NLEFT=NRIGHT(1)
C
      IF(ICASPL.EQ.'STRI' .AND. IDATSW.EQ.'RAW')THEN
        J=0
        IMAX=NLEFT
        IF(NQ.LT.NLEFT)IMAX=NQ
        DO810I=1,IMAX
          IF(ISUB(I).EQ.0)GOTO810
          J=J+1
          IJ=MAXN*(ICOLR(1)-1)+I
          IF(ICOLR(1).LE.MAXCOL)Y1(J)=V(IJ)
          IF(ICOLR(1).EQ.MAXCP1)Y1(J)=PRED(I)
          IF(ICOLR(1).EQ.MAXCP2)Y1(J)=RES(I)
          IF(ICOLR(1).EQ.MAXCP3)Y1(J)=YPLOT(I)
          IF(ICOLR(1).EQ.MAXCP4)Y1(J)=XPLOT(I)
          IF(ICOLR(1).EQ.MAXCP5)Y1(J)=X2PLOT(I)
          IF(ICOLR(1).EQ.MAXCP6)Y1(J)=TAGPLO(I)
          TAG1(J)=1.0
          TAG2(J)=1.0
  810   CONTINUE
        NLOCAL=J
c
      ELSEIF(ICASPL.EQ.'STRI' .AND. IDATSW.EQ.'FREQ')THEN
        J=0
        IMAX=NLEFT
        IF(NQ.LT.NLEFT)IMAX=NQ
        DO820I=1,IMAX
          IF(ISUB(I).EQ.0)GOTO820
          J=J+1
          IJ=MAXN*(ICOLR(2)-1)+I
          IF(ICOLR(2).LE.MAXCOL)X1(J)=V(IJ)
          IF(ICOLR(2).EQ.MAXCP1)X1(J)=PRED(I)
          IF(ICOLR(2).EQ.MAXCP2)X1(J)=RES(I)
          IF(ICOLR(2).EQ.MAXCP3)X1(J)=YPLOT(I)
          IF(ICOLR(2).EQ.MAXCP4)X1(J)=XPLOT(I)
          IF(ICOLR(2).EQ.MAXCP5)X1(J)=X2PLOT(I)
          IF(ICOLR(2).EQ.MAXCP6)X1(J)=TAGPLO(I)
          IJ=MAXN*(ICOLR(1)-1)+I
          IF(ICOLR(1).LE.MAXCOL)Y1(J)=V(IJ)
          IF(ICOLR(1).EQ.MAXCP1)Y1(J)=PRED(I)
          IF(ICOLR(1).EQ.MAXCP2)Y1(J)=RES(I)
          IF(ICOLR(1).EQ.MAXCP3)Y1(J)=YPLOT(I)
          IF(ICOLR(1).EQ.MAXCP4)Y1(J)=XPLOT(I)
          IF(ICOLR(1).EQ.MAXCP5)Y1(J)=X2PLOT(I)
          IF(ICOLR(1).EQ.MAXCP6)Y1(J)=TAGPLO(I)
          TAG1(J)=1.0
          TAG2(J)=1.0
  820   CONTINUE
        NLOCAL=J
C
      ELSEIF(ICASPL.EQ.'BSPL' .AND. IDATSW.EQ.'RAW')THEN
        J=0
        IMAX=NLEFT
        IF(NQ.LT.NLEFT)IMAX=NQ
        DO830I=1,IMAX
          IF(ISUB(I).EQ.0)GOTO830
          J=J+1
          IJ=MAXN*(ICOLR(1)-1)+I
          IF(ICOLR(1).LE.MAXCOL)Y1(J)=V(IJ)
          IF(ICOLR(1).EQ.MAXCP1)Y1(J)=PRED(I)
          IF(ICOLR(1).EQ.MAXCP2)Y1(J)=RES(I)
          IF(ICOLR(1).EQ.MAXCP3)Y1(J)=YPLOT(I)
          IF(ICOLR(1).EQ.MAXCP4)Y1(J)=XPLOT(I)
          IF(ICOLR(1).EQ.MAXCP5)Y1(J)=X2PLOT(I)
          IF(ICOLR(1).EQ.MAXCP6)Y1(J)=TAGPLO(I)
          IJ=MAXN*(ICOLR(2)-1)+I
          IF(ICOLR(2).LE.MAXCOL)TAG1(J)=V(IJ)
          IF(ICOLR(2).EQ.MAXCP1)TAG1(J)=PRED(I)
          IF(ICOLR(2).EQ.MAXCP2)TAG1(J)=RES(I)
          IF(ICOLR(2).EQ.MAXCP3)TAG1(J)=YPLOT(I)
          IF(ICOLR(2).EQ.MAXCP4)TAG1(J)=XPLOT(I)
          IF(ICOLR(2).EQ.MAXCP5)TAG1(J)=X2PLOT(I)
          IF(ICOLR(2).EQ.MAXCP6)TAG1(J)=TAGPLO(I)
          TAG2(J)=1.0
  830   CONTINUE
        NLOCAL=J
C
      ELSEIF(ICASPL.EQ.'BSPL' .AND. IDATSW.EQ.'FREQ')THEN
        J=0
        IMAX=NLEFT
        IF(NQ.LT.NLEFT)IMAX=NQ
        DO840I=1,IMAX
          IF(ISUB(I).EQ.0)GOTO840
          J=J+1
          IJ=MAXN*(ICOLR(1)-1)+I
          IF(ICOLR(1).LE.MAXCOL)Y1(J)=V(IJ)
          IF(ICOLR(1).EQ.MAXCP1)Y1(J)=PRED(I)
          IF(ICOLR(1).EQ.MAXCP2)Y1(J)=RES(I)
          IF(ICOLR(1).EQ.MAXCP3)Y1(J)=YPLOT(I)
          IF(ICOLR(1).EQ.MAXCP4)Y1(J)=XPLOT(I)
          IF(ICOLR(1).EQ.MAXCP5)Y1(J)=X2PLOT(I)
          IF(ICOLR(1).EQ.MAXCP6)Y1(J)=TAGPLO(I)
          IJ=MAXN*(ICOLR(2)-1)+I
          IF(ICOLR(2).LE.MAXCOL)X1(J)=V(IJ)
          IF(ICOLR(2).EQ.MAXCP1)X1(J)=PRED(I)
          IF(ICOLR(2).EQ.MAXCP2)X1(J)=RES(I)
          IF(ICOLR(2).EQ.MAXCP3)X1(J)=YPLOT(I)
          IF(ICOLR(2).EQ.MAXCP4)X1(J)=XPLOT(I)
          IF(ICOLR(2).EQ.MAXCP5)X1(J)=X2PLOT(I)
          IF(ICOLR(2).EQ.MAXCP6)X1(J)=TAGPLO(I)
          IJ=MAXN*(ICOLR(3)-1)+I
          IF(ICOLR(3).LE.MAXCOL)TAG1(J)=V(IJ)
          IF(ICOLR(3).EQ.MAXCP1)TAG1(J)=PRED(I)
          IF(ICOLR(3).EQ.MAXCP2)TAG1(J)=RES(I)
          IF(ICOLR(3).EQ.MAXCP3)TAG1(J)=YPLOT(I)
          IF(ICOLR(3).EQ.MAXCP4)TAG1(J)=XPLOT(I)
          IF(ICOLR(3).EQ.MAXCP5)TAG1(J)=X2PLOT(I)
          IF(ICOLR(3).EQ.MAXCP6)TAG1(J)=TAGPLO(I)
          TAG2(J)=1.0
  840   CONTINUE
        NLOCAL=J
C
      ELSEIF(ICASPL.EQ.'BMSP')THEN
        J=0
        IMAX=NLEFT
        IF(NQ.LT.NLEFT)IMAX=NQ
        DO850I=1,IMAX
          IF(ISUB(I).EQ.0)GOTO850
          J=J+1
          IJ=MAXN*(ICOLR(1)-1)+I
          IF(ICOLR(1).LE.MAXCOL)Y1(J)=V(IJ)
          IF(ICOLR(1).EQ.MAXCP1)Y1(J)=PRED(I)
          IF(ICOLR(1).EQ.MAXCP2)Y1(J)=RES(I)
          IF(ICOLR(1).EQ.MAXCP3)Y1(J)=YPLOT(I)
          IF(ICOLR(1).EQ.MAXCP4)Y1(J)=XPLOT(I)
          IF(ICOLR(1).EQ.MAXCP5)Y1(J)=X2PLOT(I)
          IF(ICOLR(1).EQ.MAXCP6)Y1(J)=TAGPLO(I)
          IJ=MAXN*(ICOLR(2)-1)+I
          IF(ICOLR(2).LE.MAXCOL)TAG1(J)=V(IJ)
          IF(ICOLR(2).EQ.MAXCP1)TAG1(J)=PRED(I)
          IF(ICOLR(2).EQ.MAXCP2)TAG1(J)=RES(I)
          IF(ICOLR(2).EQ.MAXCP3)TAG1(J)=YPLOT(I)
          IF(ICOLR(2).EQ.MAXCP4)TAG1(J)=XPLOT(I)
          IF(ICOLR(2).EQ.MAXCP5)TAG1(J)=X2PLOT(I)
          IF(ICOLR(2).EQ.MAXCP6)TAG1(J)=TAGPLO(I)
          IJ=MAXN*(ICOLR(3)-1)+I
          IF(ICOLR(3).LE.MAXCOL)TAG2(J)=V(IJ)
          IF(ICOLR(3).EQ.MAXCP1)TAG2(J)=PRED(I)
          IF(ICOLR(3).EQ.MAXCP2)TAG2(J)=RES(I)
          IF(ICOLR(3).EQ.MAXCP3)TAG2(J)=YPLOT(I)
          IF(ICOLR(3).EQ.MAXCP4)TAG2(J)=XPLOT(I)
          IF(ICOLR(3).EQ.MAXCP5)TAG2(J)=X2PLOT(I)
          IF(ICOLR(3).EQ.MAXCP6)TAG2(J)=TAGPLO(I)
  850   CONTINUE
        NLOCAL=J
C
      ENDIF
C
C               *****************************************************
C               **  STEP 9--                                       **
C               **  FORM THE VERTICAL AND HORIZONTAL AXIS          **
C               **  VALUES Y(.) AND X(.) FOR THE PLOT.             **
C               **  RESET THE VECTOR D(.) TO ALL ONES.             **
C               **  DEFINE THE NUMBER OF PLOT POINTS    (NPLOTP).  **
C               **  DEFINE THE NUMBER OF PLOT VARIABLES (NPLOTV).  **
C               *****************************************************
C
      ISTEPN='9'
      IF(IBUGG2.EQ.'ON' .OR. ISUBRO.EQ.'STRI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPSTR2(Y1,X1,TAG1,TAG2,XIDTEM,XIDTE2,
     1            NLOCAL,ICASPL,IDATSW,
     1            PSTRIN,ISTRPL,ISEED,
     1            YTEMP,XTEMP,TEMP3,TEMP4,
     1            Y,X,D,NPLOTP,NPLOTV,ISUBRO,IBUGG3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG2.EQ.'ON' .OR. ISUBRO.EQ.'STRI')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTRI--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IFOUND,IERROR
 9012   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2
 9013   FORMAT('NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2 = ',
     1         I8,I8,I8,2X,A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        IF(NPLOTP.GE.1)THEN
          DO9015I=1,NPLOTP
            WRITE(ICOUT,9016)I,Y(I),X(I),D(I)
 9016       FORMAT('I,Y(I),X(I),D(I) = ',I8,3F12.5)
            CALL DPWRST('XXX','BUG ')
 9015     CONTINUE
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTR2(Y,X,TAG1,TAG2,XIDTEM,XIDTE2,
     1                  N,ICASPL,IDATSW,
     1                  PSTRIN,ISTRPL,ISEED,
     1                  YTEMP,XTEMP,TEMP3,TEMP4,
     1                  Y2,X2,D2,N2,NPLOTV,ISUBRO,IBUGG3,IERROR)
C
C     PURPOSE--GENERATE A PAIR OF COORDINATE VECTORS
C              THAT WILL DEFINE A STRIP PLOT (ALSO KNOWN AS
C              A DOT PLOT).
C
C              THE DATA CAN EITHER A SINGLE RESPONSE VARIABLE
C              OR A FREQUENCY TABLE.  NOTE THAT THE BINNING
C              SHOULD BE DONE BEFORE CALLING THE STRIP PLOT
C              (I.E., THE SINGLE VARIABLE CASE WILL NOT BE
C              BINNED).
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/10
C     ORIGINAL VERSION--OCTOBER   2008.
C     UPDATED         --OCTOBER   2009. SUPPORT FOR "BATCH MULTIPLE"
C                                       OPTION
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IDATSW
      CHARACTER*4 ISTRPL
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGG3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TAG1(*)
      DIMENSION TAG2(*)
      DIMENSION XIDTEM(*)
      DIMENSION XIDTE2(*)
      DIMENSION YTEMP(*)
      DIMENSION XTEMP(*)
      DIMENSION TEMP3(*)
      DIMENSION TEMP4(*)
      DIMENSION Y2(*)
      DIMENSION X2(*)
      DIMENSION D2(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='R2  '
C
      IERROR='NO'
      IWRITE='OFF'
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(N.LE.1)THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
   31   FORMAT('***** ERROR IN STRIP PLOT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,32)
   32   FORMAT('      THE NUMBER OF OBSERVATIONS MUST BE AT LEAST 2.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,33)
   33   FORMAT('      MUST BE AT LEAST 1;')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,34)N
   34   FORMAT('      THE ENTERED NUMBER OF OBSERVATIONS HERE = ',I6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(IBUGG3.EQ.'ON' .OR. ISUBRO.EQ.'STR2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,70)
   70   FORMAT('***** AT THE BEGINNING OF DPSTR2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,71)IDATSW,ICASPL,N
   71   FORMAT('IDATSW,ICASPL,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO73I=1,N
          WRITE(ICOUT,74)I,Y(I),X(I),TAG1(I),TAG2(I)
   74     FORMAT('I,Y(I),X(I),TAG1(I),TAG2(I) = ',I8,4G15.7)
          CALL DPWRST('XXX','BUG ')
   73   CONTINUE
      ENDIF
C
C               **********************************************
C               **  STEP 2--                                **
C               **  GENERATE THE STRIP PLOT                 **
C               **********************************************
C
      IF(ICASPL.EQ.'BMSP')THEN
        CALL DISTIN(TAG1,N,IWRITE,XIDTEM,NGROUP,IBUGG3,IERROR)
        CALL SORT(XIDTEM,NGROUP,XIDTEM)
        CALL DISTIN(TAG2,N,IWRITE,XIDTE2,NGROU2,IBUGG3,IERROR)
        CALL SORT(XIDTE2,NGROU2,XIDTE2)
      ELSEIF(ICASPL.EQ.'BSPL')THEN
        CALL DISTIN(TAG1,N,IWRITE,XIDTEM,NGROUP,IBUGG3,IERROR)
        CALL SORT(XIDTEM,NGROUP,XIDTEM)
        NGROU2=1
      ELSE
        NGROUP=1
        NGROU2=1
        XIDTEM(1)=1.0
        XIDTE2(1)=1.0
      ENDIF
C
      K1=0
      DO1000ISET=1,NGROUP
        HOLD=XIDTEM(ISET)
        NTEMP=0
        DO1010J=1,N
          IF(TAG1(J).EQ.HOLD)THEN
            NTEMP=NTEMP+1
            YTEMP(NTEMP)=Y(J)
            XTEMP(NTEMP)=X(J)
            TEMP4(NTEMP)=1.0
            DO1015ISET2=1,NGROU2
              HOLD2=XIDTE2(ISET2)
              IF(TAG2(J).EQ.XIDTE2(ISET2))THEN
                TEMP4(NTEMP)=REAL(ISET2)
                GOTO1019
              ENDIF
 1015       CONTINUE
 1019       CONTINUE
          ENDIF
 1010   CONTINUE
C
        IF(IDATSW.EQ.'RAW')THEN
          IF(ICASPL.NE.'BMSP')CALL SORT(YTEMP,NTEMP,YTEMP)
          IF(ISTRPL.EQ.'JITT')THEN
            DELTA=0.5
            DO1030J=1,NTEMP
              TEMP3(J)=HOLD
 1030       CONTINUE
            CALL JITTER(TEMP3,NTEMP,DELTA,IWRITE,TEMP3,NTEMP,
     1                  ISEED,IBUGG3,IERROR)
            DO1050I=1,NTEMP
              K1=K1+1
              IF(ICASPL.EQ.'BMSP')THEN
                D2(K1)=TEMP4(I)
              ELSE
                D2(K1)=REAL(ISET)
              ENDIF
              X2(K1)=YTEMP(I)
              Y2(K1)=TEMP3(I)
 1050       CONTINUE
            N2=K1
            NPLOTV=2
          ELSEIF(ISTRPL.EQ.'OVER')THEN
            DO1090I=1,NTEMP
              K1=K1+1
              IF(ICASPL.EQ.'BMSP')THEN
                D2(K1)=TEMP4(I)
              ELSE
                D2(K1)=REAL(ISET)
              ENDIF
              X2(K1)=YTEMP(I)
              Y2(K1)=HOLD
 1090       CONTINUE
            N2=K1
            NPLOTV=2
          ELSE
            K1=K1+1
            K2=1
            X2(K1)=YTEMP(1)
            Y2(K1)=HOLD
            IF(ICASPL.EQ.'BMSP')THEN
              D2(K1)=TEMP4(1)
            ELSE
              D2(K1)=REAL(ISET)
            ENDIF
            DO2000I=2,NTEMP
              K1=K1+1
              IF(ICASPL.EQ.'BMSP')THEN
                D2(K1)=TEMP4(I)
              ELSE
                D2(K1)=REAL(ISET)
              ENDIF
              X2(K1)=YTEMP(I)
              IF(YTEMP(I).EQ.YTEMP(I-1))THEN
                K2=K2+1
              ELSE
                K2=1
              ENDIF
              ATEMP=HOLD + (K2-1)*PSTRIN
              Y2(K1)=ATEMP
 2000       CONTINUE
            N2=K1
            NPLOTV=2
          ENDIF
        ELSE
C
C         NOTE: FOR FREQUENCY DATA, ONLY SUPPORT "STACKED" STYLE,
C               NOT THE JITTER FORMAT.  ALSO, "MULTIPLE" OPTION
C               IS NOT SUPPORTED.
C
          K2=0
          DO3000I=1,NTEMP
            IF(YTEMP(I).LT.0.0)THEN
              WRITE(ICOUT,999)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,31)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,3010)I,ISET,Y(I)
 3010         FORMAT('      ROW ',I8,' OF BATCH ',I8,' HAS A NEGATIVE ',
     1             'FREQUENCY (',G15.7,')')
              CALL DPWRST('XXX','BUG ')
              IERROR='YES'
              GOTO9000
            ENDIF
C
            IF(I.GE.2 .AND. (XTEMP(I).LE.XTEMP(I-1)))THEN
              WRITE(ICOUT,999)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,31)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,3020)I,ISET
 3020         FORMAT('      THE CLASS MID-POINT FOR ROW ',I8,' OF ',
     1               'BATCH ',I8,' IS ')
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,3022)I-1,ISET
 3022         FORMAT('      LESS THAN THE CLASS MID-POINT FOR ROW ',
     1               I8,' OF BATCH ',I8,'.')
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,3024)I,XTEMP(I)
 3024         FORMAT('      CLASS MID-POINT FOR ROW ',I8,' = ',G15.7)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,3024)I-1,X(I-1)
              CALL DPWRST('XXX','BUG ')
              IERROR='YES'
              GOTO9000
            ENDIF
C
            IFREQ=INT(YTEMP(I)+0.1)
            IF(IFREQ.GE.1)THEN
              ATEMP=REAL(ISET)
              DO3030J=1,IFREQ
                K1=K1+1
                X2(K1)=XTEMP(I)
                D2(K1)=REAL(ISET)
                Y2(K1)=ATEMP
                ATEMP=ATEMP+PSTRIN
 3030         CONTINUE
            ENDIF
C
 3000     CONTINUE
          N2=K1
          NPLOTV=2
        ENDIF
C
 1000 CONTINUE
C
      GOTO9000
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
      IF(IBUGG3.EQ.'ON' .OR. ISUBRO.EQ.'STR2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTR2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)ICASPL,IDATSW,PSTRIN,IERROR,N2
 9012   FORMAT('ICASPL,IDATSW,PSTRIN,IERROR,N2 = ',
     1         A4,2X,A4,2X,G15.7,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,N2
          WRITE(ICOUT,9016)I,Y2(I),X2(I),D2(I)
 9016     FORMAT('I,Y2(I),X2(I),D2(I) = ',I8,2E15.7,F9.2)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTRP(ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--INSERT A STRING INTO A PREVIOUSLY DEFINED STRING
C     EXAMPLE--LET SOUT = STRING REPLACE SOLD SNEW START
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/11
C     ORIGINAL VERSION--NOVEMBER  2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 NEWNAM
      CHARACTER*4 NEWNA2
      CHARACTER*4 NEWCOL
      CHARACTER*4 NEWCO2
      CHARACTER*4 ICASEL
      CHARACTER*4 ICASE2
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
      CHARACTER*4 IHRI21
      CHARACTER*4 IHRI22
      CHARACTER*4 IHRI31
      CHARACTER*4 IHRI32
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ILAB(10)
C
C---------------------------------------------------------------------
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='MR  '
C
      IERROR='NO'
C
      ILOC3=0
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STRP')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTRP--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMNAM
   52   FORMAT('IBUGA3,ISUBRO,NUMNAM = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMNAM
          WRITE(ICOUT,56)I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),
     1                   IVSTOP(I)
   56     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        WRITE(ICOUT,57)NUMCHF,MAXCHF
   57   FORMAT('NUMCHF,MAXCHF = ',2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,60)(IFUNC(I),I=1,MIN(120,MAXCHF))
   60   FORMAT('IFUNC(.)  = ',120A1)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               **********************************
C               **  STEP 1--                    **
C               **  INITIALIZE SOME VARIABLES.  **
C               **********************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STRP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NEWNAM='NO'
      NEWNA2='NO'
      NEWCOL='NO'
      NEWCO2='NO'
      ICASEL='UNKN'
      ICASE2='UNKN'
      NIOLD1=0
      NIOLD2=0
      ICOLL=0
      ICOL2=0
C
C               ******************************************************
C               **  STEP 2--                                         *
C               **  EXAMINE THE ARGUMENT ON THE                      *
C               **  LEFT-HAND SIDE--                                 *
C               **  IF THIS IS A PREVIOUSLY DEFINED NAME, IT SHOULD  *
C               **  BE A STRING    (IF NOT, REPORT AN ERROR).        *
C               ******************************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STRP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHLEFT=IHARG(1)
      IHLEF2=IHARG2(1)
C
      DO2000I=1,NUMNAM
        I2=I
        IF(IHLEFT.EQ.IHNAME(I).AND.IHLEF2.EQ.IHNAM2(I))THEN
          IF(IUSE(I2).EQ.'F')THEN
            ICASEL='STRI'
            ILISTL=I2
            GOTO2299
          ELSE
            WRITE(ICOUT,999)
  999       FORMAT(1X)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
 2001       FORMAT('***** ERROR IN STRING REPLACE--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2003)IHLEFT,IHLEF2
 2003       FORMAT('      THE FIRST NAME ON THE LEFT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2005)
 2005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
        ENDIF
 2000 CONTINUE
C
      NEWNAM='YES'
      IF(ICASEL.EQ.'UNKN')ICASEL='STRI'
C
      ILISTL=NUMNAM+1
      IF(ILISTL.GT.MAXNAM)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2202)
 2202   FORMAT('      THE NUMBER OF VARIABLE, PARAMETER, AND ',
     1         'FUNCTION')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2203)MAXNAM
 2203   FORMAT('      NAMES HAS JUST EXCEEDED THE ALLOWABLE ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2204)
 2204   FORMAT('      ENTER      STATUS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2205)
 2205   FORMAT('      TO FIND OUT THE FULL LIST OF USED NAMES, AND')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2206)
 2206   FORMAT('      THEN REDEFINE OR DELETE SOME OF THE ALREADY ',
     1         'USED NAMES.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
 2299 CONTINUE
C
C               *****************************************************
C               **  STEP 3--                                       **
C               **  EXTRACT THE FIRST NAME ON THE RIGHT HAND SIDE  **
C               *****************************************************
C
      ISTEPN='3A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STRP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRIGH=IHARG(5)
      IHRIG2=IHARG2(5)
      DO3000I=1,NUMNAM
        I4=I
        IF(IHRIGH.EQ.IHNAME(I).AND.IHRIG2.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'F')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRIGH,IHRIG2
 3003       FORMAT('      THE NAME ON THE RIGHT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3005)
 3005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ISTRT1=IVSTAR(I4)
            ISTOP1=IVSTOP(I4)
            NLEN1=ISTOP1-ISTRT1+1
            GOTO3099
          ENDIF
        ENDIF
 3000 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRIGH,IHRIG2
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
 3015 FORMAT('      WAS NOT FOUND IN THE CURRENT NAME LIST.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3099 CONTINUE
C
C               *****************************************************
C               **  STEP 3B-                                       **
C               **  EXTRACT THE SECOND NAME ON THE RIGHT HAND SIDE **
C               *****************************************************
C
      ISTEPN='3B'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STRP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRI21=IHARG(6)
      IHRI22=IHARG2(6)
      DO3100I=1,NUMNAM
        I4=I
        IF(IHRI21.EQ.IHNAME(I).AND.IHRI22.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'F')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRI21,IHRI22
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3005)
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ISTRT2=IVSTAR(I4)
            ISTOP2=IVSTOP(I4)
            NLEN2=ISTOP2-ISTRT2+1
            GOTO3199
          ENDIF
        ENDIF
 3100 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRI21,IHRI22
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3199 CONTINUE
C
C               *****************************************************
C               **  STEP 3C-                                       **
C               **  EXTRACT THE THIRD  NAME ON THE RIGHT HAND SIDE **
C               *****************************************************
C
      ISTEPN='3C'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STRP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRI31=IHARG(7)
      IHRI32=IHARG2(7)
      DO3200I=1,NUMNAM
        I4=I
        IF(IHRI31.EQ.IHNAME(I).AND.IHRI32.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'P')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRI31,IHRI32
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3215)
 3215       FORMAT('      ALREADY EXISTS, BUT NOT AS A PARAMETER.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ILISR1=I4
            NSTART=IVALUE(ILISR1)
            GOTO3299
          ENDIF
        ENDIF
 3200 CONTINUE
C
      IF(NUMARG.GE.7)THEN
        IF(IARGT(7).EQ.'NUMB')THEN
          NSTART=IARG(7)
          GOTO3299
        ENDIF
      ENDIF
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRI31,IHRI32
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3299 CONTINUE
C
C               *****************************************************
C               **  STEP 4--                                       **
C               **  CREATE THE SUBSTRING                           **
C               *****************************************************
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STRP')THEN
        ISTEPN='4'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,4011)ISTRT1,ISTOP1,NLEN1
 4011   FORMAT('ISTRT1,ISTOP1,NLEN1 = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4012)ISTRT2,ISTOP2,NLEN2
 4012   FORMAT('ISTRT2,ISTOP2,NLEN2 = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4013)ICASEL
 4013   FORMAT('ICASEL = ',A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(NSTART.LT.1 .OR. NSTART.GT.MAXCHF)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4021)MAXCHF
 4021   FORMAT('      THE START INDEX IS LESS THAN 1 OR GREATER ',
     1         'THAN ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4023)NSTART
 4023   FORMAT('      THE VALUE OF THE START INDEX IS ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      ICNT=0
      IF(NSTART.GT.1)THEN
        DO4100I=1,NLEN1-1
          ICNT=ICNT+1
          IINDX=I+ISTRT1-1
          IFUNC2(ICNT)=IFUNC(IINDX)
 4100   CONTINUE
        ICNT=NSTART-1
      ENDIF
      IF(NLEN2.GE.1)THEN
        DO4110I=1,NLEN2
          ICNT=ICNT+1
          IINDX=I+ISTRT2-1
          IFUNC2(ICNT)=IFUNC(IINDX)
 4110   CONTINUE
      ENDIF
      ICNT=MAX(ICNT,NLEN1)
C
 4199 CONTINUE
C
C               *****************************************************
C               **  STEP 5--                                       **
C               **  SAVE STRING AND PRINT FEEDBACK MESSAGE         **
C               *****************************************************
C
C
      IF(ICASEL.EQ.'STRI')THEN
C
        ISTEPN='5'
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STRP')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        CALL DPINFU(IFUNC2,ICNT,IHNAME,IHNAM2,IUSE,IVSTAR,IVSTOP,
     1              NUMNAM,IANS,IWIDTH,IHLEFT,IHLEF2,ILISTL,
     1              NEWNAM,MAXN3,
     1              IFUNC,NUMCHF,MAXCHF,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IF(IFEEDB.EQ.'ON' .AND. IPRINT.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,6606)IHLEFT,IHLEF2
 6606     FORMAT('THE NAME ',A4,A4,' HAS JUST BEEN EQUIVALENCED ')
          CALL DPWRST('XXX','BUG ')
          ILAB(1)='TO T'
          ILAB(2)='HE F'
          ILAB(3)='UNCT'
          ILAB(4)='ION '
          ILAB(5)='    '
          ILAB(6)=' -- '
          NUMWDL=6
          CALL DPPRIF(ILAB,NUMWDL,IFUNC2,ICNT,IBUGA3)
C
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
C
        ENDIF
C
      ENDIF
C
C
C               ****************
C               **  STEP 90-- **
C               **  EXIT.     **
C               ****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STRP')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTRP--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMNAM
 9013   FORMAT('NUMNAM,IVALUE = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,NUMNAM
          WRITE(ICOUT,9016)I,IHNAME(I),IHNAM2(I),IUSE(I),
     1                     IVSTAR(I),IVSTOP(I)
 9016     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTSB(ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--EXTRACT A SUBSET OF A STRING.
C     EXAMPLE--LET SOUT = STRING SUBSET SIN START STOP
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/11
C     ORIGINAL VERSION--NOVEMBER  2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 NEWNAM
      CHARACTER*4 NEWNA2
      CHARACTER*4 NEWCOL
      CHARACTER*4 NEWCO2
      CHARACTER*4 ICASEL
      CHARACTER*4 ICASE2
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
      CHARACTER*4 IHRI21
      CHARACTER*4 IHRI22
      CHARACTER*4 IHRI31
      CHARACTER*4 IHRI32
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ILAB(10)
C
C---------------------------------------------------------------------
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='SB  '
C
      IERROR='NO'
C
      ILOC3=0
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STSB')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTSB--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMNAM
   52   FORMAT('IBUGA3,ISUBRO,NUMNAM = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMNAM
          WRITE(ICOUT,56)I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),
     1                   IVSTOP(I)
   56     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        WRITE(ICOUT,57)NUMCHF,MAXCHF,NUMARG
   57   FORMAT('NUMCHF,MAXCHF,NUMARG = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,60)(IFUNC(I),I=1,MIN(120,MAXCHF))
   60   FORMAT('IFUNC(.)  = ',120A1)
        CALL DPWRST('XXX','BUG ')
        IF(NUMARG.GE.1)THEN
          DO70I=1,NUMARG
            WRITE(ICOUT,76)I,IHARG(I),IHARG2(I),IARGT(I),IARG(I)
   76       FORMAT('I,IHARG(I),IHARG2(I),IARGT(I),IARG(I) = ',
     1             I8,2X,A4,A4,2X,A4,2X,I8)
            CALL DPWRST('XXX','BUG ')
   70     CONTINUE
        ENDIF
      ENDIF
C
C               **********************************
C               **  STEP 1--                    **
C               **  INITIALIZE SOME VARIABLES.  **
C               **********************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STSB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NEWNAM='NO'
      NEWNA2='NO'
      NEWCOL='NO'
      NEWCO2='NO'
      ICASEL='UNKN'
      ICASE2='UNKN'
      NIOLD1=0
      NIOLD2=0
      ICOLL=0
      ICOL2=0
C
C               ******************************************************
C               **  STEP 2--                                         *
C               **  EXAMINE THE ARGUMENT ON THE                      *
C               **  LEFT-HAND SIDE--                                 *
C               **  IF THIS IS A PREVIOUSLY DEFINED NAME, IT SHOULD  *
C               **  BE A STRING    (IF NOT, REPORT AN ERROR).        *
C               ******************************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STSB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHLEFT=IHARG(1)
      IHLEF2=IHARG2(1)
C
      DO2000I=1,NUMNAM
        I2=I
        IF(IHLEFT.EQ.IHNAME(I).AND.IHLEF2.EQ.IHNAM2(I))THEN
          IF(IUSE(I2).EQ.'F')THEN
            ICASEL='STRI'
            ILISTL=I2
            GOTO2299
          ELSE
            WRITE(ICOUT,999)
  999       FORMAT(1X)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
 2001       FORMAT('***** ERROR IN STRING SUBSET--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2003)IHLEFT,IHLEF2
 2003       FORMAT('      THE FIRST NAME ON THE LEFT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2005)
 2005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
        ENDIF
 2000 CONTINUE
C
      NEWNAM='YES'
      IF(ICASEL.EQ.'UNKN')ICASEL='STRI'
C
      ILISTL=NUMNAM+1
      IF(ILISTL.GT.MAXNAM)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2202)
 2202   FORMAT('      THE NUMBER OF VARIABLE, PARAMETER, AND ',
     1         'FUNCTION')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2203)MAXNAM
 2203   FORMAT('      NAMES HAS JUST EXCEEDED THE ALLOWABLE ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2204)
 2204   FORMAT('      ENTER      STATUS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2205)
 2205   FORMAT('      TO FIND OUT THE FULL LIST OF USED NAMES, AND')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2206)
 2206   FORMAT('      THEN REDEFINE OR DELETE SOME OF THE ALREADY ',
     1         'USED NAMES.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
 2299 CONTINUE
C
C               *****************************************************
C               **  STEP 3--                                       **
C               **  EXTRACT THE FIRST NAME ON THE RIGHT HAND SIDE  **
C               *****************************************************
C
      ISTEPN='3A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STSB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRIGH=IHARG(4)
      IHRIG2=IHARG2(4)
      DO3000I=1,NUMNAM
        I4=I
        IF(IHRIGH.EQ.IHNAME(I).AND.IHRIG2.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'F')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRIGH,IHRIG2
 3003       FORMAT('      THE NAME ON THE RIGHT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3005)
 3005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ISTRT1=IVSTAR(I4)
            ISTOP1=IVSTOP(I4)
            NLEN1=ISTOP1-ISTRT1+1
            GOTO3099
          ENDIF
        ENDIF
 3000 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRIGH,IHRIG2
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
 3015 FORMAT('      WAS NOT FOUND IN THE CURRENT NAME LIST.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3099 CONTINUE
C
C               *****************************************************
C               **  STEP 3B-                                       **
C               **  EXTRACT THE SECOND NAME ON THE RIGHT HAND SIDE **
C               *****************************************************
C
      ISTEPN='3B'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STSB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRI21=IHARG(5)
      IHRI22=IHARG2(5)
      DO3100I=1,NUMNAM
        I4=I
        IF(IHRI21.EQ.IHNAME(I).AND.IHRI22.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'P')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRI21,IHRI22
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3115)
 3115       FORMAT('      ALREADY EXISTS, BUT NOT AS A PARAMETER.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ILISR1=I4
            NSTART=IVALUE(ILISR1)
            GOTO3199
          ENDIF
        ENDIF
 3100 CONTINUE
C
      IF(NUMARG.GE.5)THEN
        IF(IARGT(5).EQ.'NUMB')THEN
          NSTART=IARG(5)
          GOTO3199
        ENDIF
      ENDIF
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRI21,IHRI22
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3199 CONTINUE
C
C               *****************************************************
C               **  STEP 3C-                                       **
C               **  EXTRACT THE THIRD  NAME ON THE RIGHT HAND SIDE **
C               *****************************************************
C
      ISTEPN='3C'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STSB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRI31=IHARG(6)
      IHRI32=IHARG2(6)
      DO3200I=1,NUMNAM
        I4=I
        IF(IHRI31.EQ.IHNAME(I).AND.IHRI32.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'P')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRI31,IHRI32
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3115)
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ILISR2=I4
            NSTOP=IVALUE(ILISR2)
            GOTO3299
          ENDIF
        ENDIF
 3200 CONTINUE
C
      IF(NUMARG.GE.6)THEN
        IF(IARGT(6).EQ.'NUMB')THEN
          NSTOP=IARG(6)
          GOTO3299
        ENDIF
      ENDIF
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRI31,IHRI32
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3299 CONTINUE
C
C               *****************************************************
C               **  STEP 4--                                       **
C               **  CREATE THE SUBSTRING                           **
C               *****************************************************
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STSB')THEN
        ISTEPN='4'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,4011)ILISR1,ILISR2,NSTART,NSTOP
 4011   FORMAT('ILISR1,ILISR2,NSTART,NSTOP = ',4I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4012)ISTRT1,ISTOP1,NLEN1
 4012   FORMAT('ISTRT1,ISTOP1,NLEN1 = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4013)ICASEL
 4013   FORMAT('ICASEL = ',A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(NSTART.LT.1 .OR. NSTART.GT.MAXCHF)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4021)MAXCHF
 4021   FORMAT('      THE START INDEX IS LESS THAN 1 OR GREATER ',
     1         'THAN ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4023)NSTART
 4023   FORMAT('      THE VALUE OF THE START INDEX IS ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(NSTOP.LT.NSTART .OR. NSTOP.GT.MAXCHF)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4031)MAXCHF
 4031   FORMAT('      THE STOP INDEX IS LESS THAN THE START INDEX ',
     1        'OR GREATER THAN ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4033)NSTART
 4033   FORMAT('      THE VALUE OF THE START INDEX IS ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4035)NSTOP
 4035   FORMAT('      THE VALUE OF THE STOP INDEX IS ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      ICNT=0
      DO4100I=NSTART,NSTOP
        ICNT=ICNT+1
        IINDX=I+ISTRT1-1
        IFUNC2(ICNT)=IFUNC(IINDX)
 4100 CONTINUE
C
 4199 CONTINUE
C
C               *****************************************************
C               **  STEP 5--                                       **
C               **  SAVE STRING AND PRINT FEEDBACK MESSAGE         **
C               *****************************************************
C
C
      IF(ICASEL.EQ.'STRI')THEN
C
        ISTEPN='5'
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STSB')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        CALL DPINFU(IFUNC2,ICNT,IHNAME,IHNAM2,IUSE,IVSTAR,IVSTOP,
     1              NUMNAM,IANS,IWIDTH,IHLEFT,IHLEF2,ILISTL,
     1              NEWNAM,MAXN3,
     1              IFUNC,NUMCHF,MAXCHF,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IF(IFEEDB.EQ.'ON' .AND. IPRINT.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,6606)IHLEFT,IHLEF2
 6606     FORMAT('THE NAME ',A4,A4,' HAS JUST BEEN EQUIVALENCED ')
          CALL DPWRST('XXX','BUG ')
          ILAB(1)='TO T'
          ILAB(2)='HE F'
          ILAB(3)='UNCT'
          ILAB(4)='ION '
          ILAB(5)='    '
          ILAB(6)=' -- '
          NUMWDL=6
          CALL DPPRIF(ILAB,NUMWDL,IFUNC2,ICNT,IBUGA3)
C
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
C
        ENDIF
C
      ENDIF
C
C
C               ****************
C               **  STEP 90-- **
C               **  EXIT.     **
C               ****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STSB')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTSB--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMNAM
 9013   FORMAT('NUMNAM,IVALUE = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,NUMNAM
          WRITE(ICOUT,9016)I,IHNAME(I),IHNAM2(I),IUSE(I),
     1                     IVSTAR(I),IVSTOP(I)
 9016     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTUC(ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--CONVERT A STRING TO UPPER CASE
C     EXAMPLE--LET SOUT = UPPER CASE SOLD
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/11
C     ORIGINAL VERSION--NOVEMBER  2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 NEWNAM
      CHARACTER*4 NEWCOL
      CHARACTER*4 ICASEL
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
C
      CHARACTER*1 IC
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ILAB(10)
C
C---------------------------------------------------------------------
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='UC  '
C
      IERROR='NO'
C
      ILOC3=0
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STUC')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTUC--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMNAM
   52   FORMAT('IBUGA3,ISUBRO,NUMNAM = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMNAM
          WRITE(ICOUT,56)I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),
     1                   IVSTOP(I)
   56     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        WRITE(ICOUT,57)NUMCHF,MAXCHF
   57   FORMAT('NUMCHF,MAXCHF = ',2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,60)(IFUNC(I),I=1,MIN(120,MAXCHF))
   60   FORMAT('IFUNC(.)  = ',120A1)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               **********************************
C               **  STEP 1--                    **
C               **  INITIALIZE SOME VARIABLES.  **
C               **********************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STUC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NEWNAM='NO'
      NEWCOL='NO'
      ICASEL='UNKN'
      ICOLL=0
C
C               ******************************************************
C               **  STEP 2--                                         *
C               **  EXAMINE THE ARGUMENT ON THE                      *
C               **  LEFT-HAND SIDE--                                 *
C               **  IF THIS IS A PREVIOUSLY DEFINED NAME, IT SHOULD  *
C               **  BE A STRING    (IF NOT, REPORT AN ERROR).        *
C               ******************************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STUC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHLEFT=IHARG(1)
      IHLEF2=IHARG2(1)
C
      DO2000I=1,NUMNAM
        I2=I
        IF(IHLEFT.EQ.IHNAME(I).AND.IHLEF2.EQ.IHNAM2(I))THEN
          IF(IUSE(I2).EQ.'F')THEN
            ICASEL='STRI'
            ILISTL=I2
            GOTO2299
          ELSE
            WRITE(ICOUT,999)
  999       FORMAT(1X)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
 2001       FORMAT('***** ERROR IN UPPER CASE--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2003)IHLEFT,IHLEF2
 2003       FORMAT('      THE FIRST NAME ON THE LEFT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2005)
 2005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
        ENDIF
 2000 CONTINUE
C
      NEWNAM='YES'
      IF(ICASEL.EQ.'UNKN')ICASEL='STRI'
C
      ILISTL=NUMNAM+1
      IF(ILISTL.GT.MAXNAM)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2202)
 2202   FORMAT('      THE NUMBER OF VARIABLE, PARAMETER, AND ',
     1         'FUNCTION')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2203)MAXNAM
 2203   FORMAT('      NAMES HAS JUST EXCEEDED THE ALLOWABLE ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2204)
 2204   FORMAT('      ENTER      STATUS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2205)
 2205   FORMAT('      TO FIND OUT THE FULL LIST OF USED NAMES, AND')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2206)
 2206   FORMAT('      THEN REDEFINE OR DELETE SOME OF THE ALREADY ',
     1         'USED NAMES.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
 2299 CONTINUE
C
C               *****************************************************
C               **  STEP 3--                                       **
C               **  EXTRACT THE FIRST NAME ON THE RIGHT HAND SIDE  **
C               *****************************************************
C
      ISTEPN='3A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STUC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRIGH=IHARG(5)
      IHRIG2=IHARG2(5)
      DO3000I=1,NUMNAM
        I4=I
        IF(IHRIGH.EQ.IHNAME(I).AND.IHRIG2.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'F')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRIGH,IHRIG2
 3003       FORMAT('      THE NAME ON THE RIGHT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3005)
 3005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ISTRT1=IVSTAR(I4)
            ISTOP1=IVSTOP(I4)
            NLEN1=ISTOP1-ISTRT1+1
            GOTO3099
          ENDIF
        ENDIF
 3000 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRIGH,IHRIG2
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
 3015 FORMAT('      WAS NOT FOUND IN THE CURRENT NAME LIST.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3099 CONTINUE
C
C               *****************************************************
C               **  STEP 4--                                       **
C               **  PERFORM THE CASE CONVERSION                    **
C               *****************************************************
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STUC')THEN
        ISTEPN='4A'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,4011)ISTRT1,ISTOP1,NLEN1
 4011   FORMAT('ISTRT1,ISTOP1,NLEN1 = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4014)ICASEL
 4014   FORMAT('ICASEL = ',A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(NLEN1.GE.1)THEN
        ICNT=0
        DO4100I=ISTRT1,ISTOP1
          ICNT=ICNT+1
          IC=IFUNC(I)(1:1)
          CALL DPCOAN(IC,IJUNK)
          IF(IJUNK.GE.97 .AND. IJUNK.LE.122)THEN
            IJUNK=IJUNK-32
          ENDIF
          CALL DPCONA(IJUNK,IC)
          IFUNC2(ICNT)=' '
          IFUNC2(ICNT)(1:1)=IC
 4100   CONTINUE
      ENDIF
C
C               *****************************************************
C               **  STEP 5--                                       **
C               **  SAVE STRING AND PRINT FEEDBACK MESSAGE         **
C               *****************************************************
C
C
      IF(ICASEL.EQ.'STRI')THEN
C
        ISTEPN='5'
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STUC')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        CALL DPINFU(IFUNC2,ICNT,IHNAME,IHNAM2,IUSE,IVSTAR,IVSTOP,
     1              NUMNAM,IANS,IWIDTH,IHLEFT,IHLEF2,ILISTL,
     1              NEWNAM,MAXN3,
     1              IFUNC,NUMCHF,MAXCHF,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IF(IFEEDB.EQ.'ON' .AND. IPRINT.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,6606)IHLEFT,IHLEF2
 6606     FORMAT('THE NAME ',A4,A4,' HAS JUST BEEN EQUIVALENCED ')
          CALL DPWRST('XXX','BUG ')
          ILAB(1)='TO T'
          ILAB(2)='HE F'
          ILAB(3)='UNCT'
          ILAB(4)='ION '
          ILAB(5)='    '
          ILAB(6)=' -- '
          NUMWDL=6
          CALL DPPRIF(ILAB,NUMWDL,IFUNC2,ICNT,IBUGA3)
C
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
C
        ENDIF
C
      ENDIF
C
C
C               ****************
C               **  STEP 90-- **
C               **  EXIT.     **
C               ****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STUC')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTUC--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMNAM
 9013   FORMAT('NUMNAM,IVALUE = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,NUMNAM
          WRITE(ICOUT,9016)I,IHNAME(I),IHNAM2(I),IUSE(I),
     1                     IVSTAR(I),IVSTOP(I)
 9016     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPSTWD(ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--EXTRACT A SPECIFIED WORD OF A STRING.
C     EXAMPLE--LET SOUT = STRING WORD SIN INDEX
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/10
C     ORIGINAL VERSION--OCTOBER   2010.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 NEWNAM
      CHARACTER*4 NEWNA2
      CHARACTER*4 NEWCOL
      CHARACTER*4 NEWCO2
      CHARACTER*4 ICASEL
      CHARACTER*4 ICASE2
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
      CHARACTER*4 IHRI21
      CHARACTER*4 IHRI22
      CHARACTER*4 IHRI31
      CHARACTER*4 IHRI32
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ILAB(10)
C
C---------------------------------------------------------------------
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPST'
      ISUBN2='WD  '
C
      IERROR='NO'
C
      ILOC3=0
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STWD')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPSTWD--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,NUMNAM
   52   FORMAT('IBUGA3,ISUBRO,NUMNAM = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMNAM
          WRITE(ICOUT,56)I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),
     1                   IVSTOP(I)
   56     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        WRITE(ICOUT,57)NUMCHF,MAXCHF,NUMARG
   57   FORMAT('NUMCHF,MAXCHF,NUMARG = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,60)(IFUNC(I),I=1,MIN(120,MAXCHF))
   60   FORMAT('IFUNC(.)  = ',120A1)
        CALL DPWRST('XXX','BUG ')
        IF(NUMARG.GE.1)THEN
          DO70I=1,NUMARG
            WRITE(ICOUT,76)I,IHARG(I),IHARG2(I),IARGT(I),IARG(I)
   76       FORMAT('I,IHARG(I),IHARG2(I),IARGT(I),IARG(I) = ',
     1             I8,2X,A4,A4,2X,A4,2X,I8)
            CALL DPWRST('XXX','BUG ')
   70     CONTINUE
        ENDIF
      ENDIF
C
C               **********************************
C               **  STEP 1--                    **
C               **  INITIALIZE SOME VARIABLES.  **
C               **********************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STWD')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NEWNAM='NO'
      NEWNA2='NO'
      NEWCOL='NO'
      NEWCO2='NO'
      ICASEL='UNKN'
      ICASE2='UNKN'
      NIOLD1=0
      NIOLD2=0
      ICOLL=0
      ICOL2=0
C
C               ******************************************************
C               **  STEP 2--                                         *
C               **  EXAMINE THE ARGUMENT ON THE                      *
C               **  LEFT-HAND SIDE--                                 *
C               **  IF THIS IS A PREVIOUSLY DEFINED NAME, IT SHOULD  *
C               **  BE A STRING    (IF NOT, REPORT AN ERROR).        *
C               ******************************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STWD')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHLEFT=IHARG(1)
      IHLEF2=IHARG2(1)
C
      DO2000I=1,NUMNAM
        I2=I
        IF(IHLEFT.EQ.IHNAME(I).AND.IHLEF2.EQ.IHNAM2(I))THEN
          IF(IUSE(I2).EQ.'F')THEN
            ICASEL='STRI'
            ILISTL=I2
            GOTO2299
          ELSE
            WRITE(ICOUT,999)
  999       FORMAT(1X)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
 2001       FORMAT('***** ERROR IN STRING WORD--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2003)IHLEFT,IHLEF2
 2003       FORMAT('      THE FIRST NAME ON THE LEFT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2005)
 2005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
        ENDIF
 2000 CONTINUE
C
      NEWNAM='YES'
      IF(ICASEL.EQ.'UNKN')ICASEL='STRI'
C
      ILISTL=NUMNAM+1
      IF(ILISTL.GT.MAXNAM)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2202)
 2202   FORMAT('      THE NUMBER OF VARIABLE, PARAMETER, AND ',
     1         'FUNCTION')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2203)MAXNAM
 2203   FORMAT('      NAMES HAS JUST EXCEEDED THE ALLOWABLE ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2204)
 2204   FORMAT('      ENTER      STATUS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2205)
 2205   FORMAT('      TO FIND OUT THE FULL LIST OF USED NAMES, AND')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2206)
 2206   FORMAT('      THEN REDEFINE OR DELETE SOME OF THE ALREADY ',
     1         'USED NAMES.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
 2299 CONTINUE
C
C               *****************************************************
C               **  STEP 3--                                       **
C               **  EXTRACT THE FIRST NAME ON THE RIGHT HAND SIDE  **
C               *****************************************************
C
      ISTEPN='3A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STWD')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRIGH=IHARG(5)
      IHRIG2=IHARG2(5)
      DO3000I=1,NUMNAM
        I4=I
        IF(IHRIGH.EQ.IHNAME(I).AND.IHRIG2.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'F')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRIGH,IHRIG2
 3003       FORMAT('      THE NAME ON THE RIGHT HAND SIDE (',
     1             A4,A4,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3005)
 3005       FORMAT('      ALREADY EXISTS, BUT NOT AS A STRING.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ISTRT1=IVSTAR(I4)
            ISTOP1=IVSTOP(I4)
            NLEN1=ISTOP1-ISTRT1+1
            GOTO3099
          ENDIF
        ENDIF
 3000 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRIGH,IHRIG2
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
 3015 FORMAT('      WAS NOT FOUND IN THE CURRENT NAME LIST.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3099 CONTINUE
C
C               ******************************************************
C               **  STEP 3B-                                        **
C               **  EXTRACT THE SECOND NAME ON THE RIGHT HAND SIDE. **
C               **  THIS SHOULD BE A NUMERIC VALUE.                 **
C               ******************************************************
C
      ISTEPN='3B'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STWD')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IHRI21=IHARG(6)
      IHRI22=IHARG2(6)
      DO3100I=1,NUMNAM
        I4=I
        IF(IHRI21.EQ.IHNAME(I).AND.IHRI22.EQ.IHNAM2(I))THEN
          IF(IUSE(I4).NE.'P')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2001)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3003)IHRI21,IHRI22
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3115)
 3115       FORMAT('      ALREADY EXISTS, BUT NOT AS A PARAMETER.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            ILISR1=I4
            IINDX=IVALUE(ILISR1)
            GOTO3199
          ENDIF
        ENDIF
 3100 CONTINUE
C
      IF(NUMARG.GE.6)THEN
        IF(IARGT(6).EQ.'NUMB')THEN
          IINDX=IARG(6)
          GOTO3199
        ENDIF
      ENDIF
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2001)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3003)IHRI21,IHRI22
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3015)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 3199 CONTINUE
C
C               *****************************************************
C               **  STEP 4--                                       **
C               **  FIND THE WORD BASED ON THE INDEX               **
C               *****************************************************
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STWD')THEN
        ISTEPN='4'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,4012)IIDX,ISTRT1,ISTOP1,NLEN1
 4012   FORMAT('IINDX,ISTRT1,ISTOP1,NLEN1 = ',4I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4013)ICASEL
 4013   FORMAT('ICASEL = ',A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(IINDX.LT.1 .OR. IINDX.GT.NLEN1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2001)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4021)NLEN1
 4021   FORMAT('      THE WORD INDEX IS LESS THAN 1 OR GREATER ',
     1         'THAN ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4023)IINDX
 4023   FORMAT('      THE VALUE OF THE WORD INDEX IS ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C     NOW EXTRACT WORD BASED ON IINDX
C
C     WORD BOUNDARIES ARE DEFINED BY SPACES (NON-PRINTING CHARACTERS
C     ARE DEFINED AS SPACES).
C
C     STEP 1: DETERMINE START/STOP POSITION OF WORD
C
      NWORD=0
      IFLAG=0
C
      DO4100I=ISTRT1,ISTOP1
        IPOS=I
        IXTEMP=ICHAR(IFUNC(IPOS)(1:1))
C
C       CASE 1: WORD BOUNDARY DETECTED
C
        IF(IXTEMP.LE.32 .OR. IXTEMP.GE.127)THEN
          IF(IFLAG.EQ.1)THEN
            IF(NWORD.EQ.IINDX)GOTO4200
            IFLAG=0
          ELSEIF(IFLAG.EQ.0)THEN
            CONTINUE
          ENDIF
C
C       CASE 2: NOT A WORD BOUNDARY DETECTED.  IS THIS START OF
C               NEW WORD OR CONTINUATION OF CURRENT WORD?
C
        ELSE
          IF(IFLAG.EQ.0)THEN
            ISTART=I
            ISTOP=I
            NWORD=NWORD+1
            IFLAG=1
          ELSEIF(IFLAG.EQ.1)THEN
            ISTOP=I
          ENDIF
        ENDIF
 4100 CONTINUE
C
      IF(NWORD.EQ.IINDX)THEN
        ISTOP=ISTOP1
        GOTO4200
      ENDIF
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,4160)IINDX
 4160 FORMAT('     UNABLE TO EXTRACT WORD ',I8,' FROM STRING.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 4200 CONTINUE
      ICNT=0
      DO4210I=ISTART,ISTOP
        ICNT=ICNT+1
        IPOS=I
        IFUNC2(ICNT)=IFUNC(IPOS)
 4210 CONTINUE
C
C               *****************************************************
C               **  STEP 5--                                       **
C               **  SAVE STRING AND PRINT FEEDBACK MESSAGE         **
C               *****************************************************
C
C
      IF(ICASEL.EQ.'STRI')THEN
C
        ISTEPN='5'
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'STWD')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        CALL DPINFU(IFUNC2,ICNT,IHNAME,IHNAM2,IUSE,IVSTAR,IVSTOP,
     1              NUMNAM,IANS,IWIDTH,IHLEFT,IHLEF2,ILISTL,
     1              NEWNAM,MAXN3,
     1              IFUNC,NUMCHF,MAXCHF,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IF(IFEEDB.EQ.'ON' .AND. IPRINT.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,6606)IHLEFT,IHLEF2
 6606     FORMAT('THE NAME ',A4,A4,' HAS JUST BEEN EQUIVALENCED ')
          CALL DPWRST('XXX','BUG ')
          ILAB(1)='TO T'
          ILAB(2)='HE F'
          ILAB(3)='UNCT'
          ILAB(4)='ION '
          ILAB(5)='    '
          ILAB(6)=' -- '
          NUMWDL=6
          CALL DPPRIF(ILAB,NUMWDL,IFUNC2,ICNT,IBUGA3)
C
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
C
        ENDIF
C
      ENDIF
C
C
C               ****************
C               **  STEP 90-- **
C               **  EXIT.     **
C               ****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'STWD')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPSTWD--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMNAM
 9013   FORMAT('NUMNAM,IVALUE = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,NUMNAM
          WRITE(ICOUT,9016)I,IHNAME(I),IHNAM2(I),IUSE(I),
     1                     IVSTAR(I),IVSTOP(I)
 9016     FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IVSTAR(I),',
     1           'IVSTOP(I)=',I8,2X,A4,A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
