/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ConflictResolverDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.internal.component.model.ComponentResolveMetadata;

class LatestModuleConflictResolver
implements ModuleConflictResolver {
    private final Comparator<Version> versionComparator;
    private final VersionParser versionParser;

    LatestModuleConflictResolver(VersionComparator versionComparator, VersionParser versionParser) {
        this.versionComparator = versionComparator.asVersionComparator();
        this.versionParser = versionParser;
    }

    @Override
    public <T extends ComponentResolutionState> void select(ConflictResolverDetails<T> details) {
        Version baseVersion = null;
        LinkedHashMap<Version, ComponentResolutionState> matches = new LinkedHashMap<Version, ComponentResolutionState>();
        for (ComponentResolutionState candidate : details.getCandidates()) {
            Version version = this.versionParser.transform(candidate.getVersion());
            if (baseVersion == null || this.versionComparator.compare(version.getBaseVersion(), baseVersion) > 0) {
                matches.clear();
                baseVersion = version.getBaseVersion();
                matches.put(version, candidate);
                continue;
            }
            if (!version.getBaseVersion().equals(baseVersion)) continue;
            matches.put(version, candidate);
        }
        if (matches.size() == 1) {
            details.select((ComponentResolutionState)matches.values().iterator().next());
            return;
        }
        ArrayList sorted = new ArrayList(matches.keySet());
        Collections.sort(sorted, Collections.reverseOrder(this.versionComparator));
        for (Version version : sorted) {
            ComponentResolutionState component = (ComponentResolutionState)matches.get(version);
            if (!version.isQualified()) {
                details.select(component);
                return;
            }
            ComponentResolveMetadata metaData = component.getMetadata();
            if (metaData == null || !"release".equals(metaData.getStatus())) continue;
            details.select(component);
            return;
        }
        details.select((ComponentResolutionState)matches.get(sorted.get(0)));
    }
}

