/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ValidatingArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.VersionConflictException;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;

public class FailOnVersionConflictArtifactsVisitor
implements ValidatingArtifactsVisitor {
    private final Set<List<ModuleVersionIdentifier>> allConflicts = Sets.newLinkedHashSet();
    private final String projectPath;
    private final String configurationName;

    public FailOnVersionConflictArtifactsVisitor(String projectPath, String configurationName) {
        this.projectPath = projectPath;
        this.configurationName = configurationName;
    }

    @Override
    public void startArtifacts(RootGraphNode root) {
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        DependencyGraphComponent owner = node.getOwner();
        ComponentSelectionReason selectionReason = owner.getSelectionReason();
        if (selectionReason.isConflictResolution()) {
            this.allConflicts.add((List<ModuleVersionIdentifier>)ImmutableList.copyOf(owner.getAllVersions()));
        }
    }

    @Override
    public void visitArtifacts(DependencyGraphNode from, DependencyGraphNode to, int artifactSetId, ArtifactSet artifacts) {
    }

    @Override
    public void visitArtifacts(DependencyGraphNode from, LocalFileDependencyMetadata fileDependency, int artifactSetId, ArtifactSet artifactSet) {
    }

    @Override
    public void finishArtifacts() {
    }

    @Override
    public void complete() {
        if (!this.allConflicts.isEmpty()) {
            throw new VersionConflictException(this.projectPath, this.configurationName, this.allConflicts);
        }
    }
}

