/*
  Copyright (C) 2009 to 2013 Chris Vine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef MOUNT_ENTRY_H
#define MOUNT_ENTRY_H

#include "prog_defs.h"

#include <string>
#include <utility>

#include <gtk/gtk.h>

#include <c++-gtk-utils/window.h>
#include <c++-gtk-utils/gobj_handle.h>

namespace MountEntriesCB {
  extern "C" {
    void mount_entries_button_clicked(GtkWidget*, void*);
    void mount_entries_drag_n_drop(GtkTreeModel*, GtkTreePath*, void*);
  }
}

class TableEntry;

class MountEntries: public WinBase {

  bool changed;

  GtkWidget* ok_button;
  GtkWidget* cancel_button;
  GtkWidget* add_button;
  GtkWidget* modify_button;
  GtkWidget* delete_button;
  GtkWidget* up_button;
  GtkWidget* down_button;

  GobjHandle<GtkTreeModel> list_store;
  
  GtkTreeView* tree_view;

  void read_list();
  void save_list();
  void finish();
  void add_entry_prompt();
  void add_entry(const TableEntry&);
  void modify_entry_prompt();
  void modify_entry(const TableEntry&);
  void delete_entry_prompt();
  void delete_entry();
  void move_up_impl();
  void move_down_impl();
protected:
  virtual int get_exec_val() const;
  virtual void on_delete_event();
public:
  // Objects of this class are not for copying
  MountEntries(const MountEntries&) = delete;
  MountEntries& operator=(const MountEntries&) = delete;

  friend void MountEntriesCB::mount_entries_button_clicked(GtkWidget*, void*);
  friend void MountEntriesCB::mount_entries_drag_n_drop(GtkTreeModel*, GtkTreePath*, void*);

  MountEntries(GtkWindow* parent);
};

namespace TableEntryCB {
  extern "C" {
    void new_entry_selected(GtkWidget*, void*);
    gboolean new_entry_key_press_event(GtkWidget*, GdkEventKey*, void*);
  }
}

class TableEntry: public WinBase {

  bool accepted;

  GtkWidget* ok_button;
  GtkWidget* cancel_button;
  GtkWidget* device_entry;
  GtkWidget* label_entry;

  std::pair<std::string, std::string> result;

  bool selected_impl();
protected:
  virtual int get_exec_val() const;
public:
  // Objects of this class are not for copying
  TableEntry(const TableEntry&) = delete;
  TableEntry& operator=(const TableEntry&) = delete;

  friend void TableEntryCB::new_entry_selected(GtkWidget*, void*);
  friend gboolean TableEntryCB::new_entry_key_press_event(GtkWidget*, GdkEventKey*, void*);

  std::pair<std::string, std::string> get_result() const
    {return result;}
  // the last two parameters are NULL if a new entry is being created,
  // otherwise it is an entry to be modified
  TableEntry(GtkWindow* parent, const gchar* device, const gchar* label);
};

#endif
