/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef WIN32
#include "config.h"
#else
#define VERSION "0.3"
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "ipparser/ipparser.h"

#ifdef WIN32
#define snprintf _snprintf
#define vsnprintf _vsnprintf
#endif

static int bFirst = 1;

struct octet {
	char s[20];
	unsigned char nCur;
	unsigned char nMax;
	unsigned char nMin;
} octets[4];

struct octet orig[4];

int set_addr_filter( char *pFilter ) {

	char *p;
	char filter[255];
	int i;

	bFirst = 1;
	
	memset( (char *)octets, 0, sizeof( octets ) );
	memset( filter, 0, sizeof( filter ) );
	strncpy( filter, pFilter, sizeof( filter ) - 1 );
	
	if ( NULL == ( p = strtok( filter, "." ) ) )
		return -1;
	
	strncpy( octets[0].s, p, sizeof( octets[0].s ) );
	
	for ( i=1; i<4; i++ ) {
	
		if ( NULL == ( p = strtok( NULL, "." ) ) )
			return -1;

		if ( 1 == strlen( p ) && '*' == p[0] )
		  strcpy( octets[i].s, "0-255" );
		else
		  strncpy( octets[i].s, p, sizeof( octets[i].s ) );
		
	}
	
	for ( i=0; i<4; i++ ) {
		/* fprintf( stderr, "Octet %d = %s\n", i, octets[i].s ); */
		strncpy( filter, octets[i].s, sizeof( filter ) );
		
		if ( NULL == ( p = strtok( filter, "-" ) ) ) {
			return -1;
		}
		else {
			octets[i].nCur = atoi( p );
			octets[i].nMin = octets[i].nCur;
			
			if ( NULL != ( p = strtok( NULL, "-" ) ) )
				octets[i].nMax = atoi( p );
			else
				octets[i].nMax = octets[i].nCur;
		}
				    
		
	} /* end for loop */
	
	memcpy( orig, octets, sizeof( orig ) );
	
	return 0;
	
}

char *get_next_addr() {

	char *ip;
	int nIPSize = 20;
	
	if ( 1 == bFirst ) {
		bFirst = 0;

		ip = malloc( nIPSize );
		memset( ip, 0, nIPSize );
	
		snprintf( ip, nIPSize, "%d.%d.%d.%d", octets[0].nCur,
				octets[1].nCur, octets[2].nCur, octets[3].nCur );

		return ip;
	}
	
	if ( ( octets[3].nCur == octets[3].nMax ) && 
		 ( octets[2].nCur == octets[2].nMax ) &&
		 ( octets[1].nCur == octets[1].nMax ) &&
		 ( octets[0].nCur == octets[0].nMax ) )
		return NULL;

	ip = malloc( nIPSize );
	memset( ip, 0, nIPSize );
		
	if ( octets[3].nCur < octets[3].nMax ) {
		octets[3].nCur ++;
	}
	else {
		if ( octets[2].nCur < octets[2].nMax ) {
			octets[3].nCur = octets[3].nMin;
			octets[2].nCur ++;
		}
		else {
			if ( octets[1].nCur < octets[1].nMax ) {
				octets[1].nCur ++;
				
				if ( octets[2].nCur == octets[2].nMax )
					octets[2].nCur = octets[2].nMin;
				
				if ( octets[3].nCur == octets[3].nMax )
					octets[3].nCur = octets[3].nMin;
			}
			else {
				if ( octets[0].nCur < octets[0].nMax ) {
					octets[0].nCur ++;

				if ( octets[1].nCur == octets[1].nMax )
					octets[1].nCur = octets[1].nMin;

				if ( octets[2].nCur == octets[2].nMax )
					octets[2].nCur = octets[2].nMin;
				
				if ( octets[3].nCur == octets[3].nMax )
					octets[3].nCur = octets[3].nMin;
					
			}
		
		}
	
	}
	

	}
	snprintf( ip, nIPSize, "%d.%d.%d.%d", octets[0].nCur,
				octets[1].nCur, octets[2].nCur, octets[3].nCur );
	
	return ip;
	
}

long get_address_count( ) {
	
	struct octet o[4];
	long l = 0;

	memcpy( o, octets, sizeof( o ) );
	memcpy( octets, orig, sizeof( octets ) );
	
	while ( get_next_addr() )
		l ++;
	
	memcpy( octets, o, sizeof( octets ) );
	
	return l;
}

void reset_addresses( ) {
	memcpy( octets, orig, sizeof( octets ) );
}
