Minutes from 23rd OpenVDB TSC meeting, July 11, 2019

Attendees: *Dan* B., *Peter* C., *Ken* M.

Absent: *Nick* A., *Jeff* L.

Additional Attendees: Bruce Chernia (Intel), John Mertic (LF)

Agenda:

1) Quorum
2) Secretary
3) Round-Robin: Current and upcoming PRs
4) Graduation
5) Next Meeting


1) Quorum was confirmed.

2) Secretary was Dan Bailey

3) Round-Robin: Current and upcoming PRs

Ken:

Fast sweeping, value extension tool to be shared very soon. Initially this will
just be the core library implementation with subsequent discussion about the
right approach for a Houdini integration to follow.

Peter:

PR 455 - Some issues raised on the Sharpening PR that need consideration.
Optimization to repopulate stencil in Z-axis could be generalized to more axes
and extended to support jumps of more than one voxel. Also, Peter has been asked
by artists at DWA for a more generic convolution kernel and this PR could be
seen as a proof of concept of doing that.

Ken proposed (and has already implemented) an alternative technique which is
well established (actually dates back to the 1930s) and often referred to as
"unsharp masking". Peter wasn't able to get satisfactory results using this
technique, however that does not mean that it doesn't work - it certainly does
for Ken. However, it suggests that Peter might have found a better solution
which of course remains to be proven. Both methods are based on separable filter
kernels so Ken doesn't see why there should be a significant difference in the
computational efficiency, but cannot speak to the difference in quality since he
hasn't had a change to do a direct comparison.

The current implementation only works on level sets, but could be relatively
easily extended to support fog volumes and vector fields. Ken mentioned that
vector fields would be very useful to him. One option is to complete the current
PR and then introduce a new PR for the extension.

Peter didn't have access to his list of forthcoming work.

Dan:

PR 487 - Fixes CI issue where Houdini builds are skipped rather than fail when
run outside of ASWF Azure account. Trivial fix, anyone can approve.

PR 483 - Adds code coverage support to CMake, Nick currently reviewing. Minor
issue where code coverage takes a very long time to run (2 hours+) so can only
be run sporadically. A number of options to resolve this. Ken suggested running
the unit tests concurrently, though there may be issues if the tests themselves
run in parallel. Dan suggested using a smaller data set for some of the heavy
tests, perhaps with a flag that enables the more expensive tests for a less
frequent test run. Peter suggested using a mode that he added to the unit tests
where you can supply a file that defines which unit tests to execute. This
would allow for partitioning the tests into groups to be run concurrently
across multiple vdb_test processes.

All agreed there's lots of maintenance work to do around unit tests, improving
code coverage, breaking up some of the bigger tests like TestTools, etc.

PR 482 - An attempt to resolve the vulnerabilities reported by SonarCloud. Low
priority PR, merely included to start conversation. This adds a log or error to
empty catch statements based on whether they are expected to fail or not. Peter
commented that this might be problematic for the matrix inverse in particular,
Dan suggested we slightly refactor this one to not communicate with exceptions.

PR 479 - Meeting notes from last meeting, would quite like a meeting attendee to
approve before merge.

PR 464 - Unification PR. Peter to look into the spare data API and how to
retrieve a value previously inserted. Peter prefers exposing a non-const
OP_Table than communicating the labels to hide down into the OP_Factory, Dan to
change this.

PR 452 - Dan to address remaining feedback by adding syncNodeVersion support to
VDB Scatter SOP to be able to add position compression option now that spare
data API has been introduced.

PR 436 - Delay-loading PR. One remaining question from Peter about what happens
to the metadata when loading just the metadata in the VDB file as a preliminary
process to loading the rest of the file. Dan to investigate and reply to this
then Peter to do a final pass before we merge.

PR 402 - Peter to look into improving VDB SOP documentation, low priority item.

Main upcoming feature includes an extension to point moving to provide merging
grid functionality. Two options for exposing in Houdini, extending the VDB
Combine SOP and adding a new VDB Point Merge SOP. Dan presented Nick's argument
for the latter and all agreed that this is the better option considering compile
times and the existing node parameterization.

4) Graduation

Quick review of the graduation requirements. One remaining item needs looking at
before presenting for graduation - Steve Winslow has raised an issue in the
proprietary license notices included in the Houdini plugin, Dan to mail Jeff to
detail the specifics. Everything else seems in good shape, so hope to achieve
graduation before Siggraph.

Not necessarily a strict requirement for graduation but would be nice if all
could seek to sign the digital CCLA. Dreamworks and DNeg have already signed. If
the paper CLA that has been signed is not the Dreamworks-based CLA, but the more
recent one, this can be imported without needing to sign a new one. Send John
any signed paper CLAs to import if so.

5) Next Meeting

No meeting next week, next one scheduled for just before Siggraph.

July 25th 2019.  3pm-4pm EDT (GMT-4).
