/*
 * fslurp, Copyright (c) 2012, 2013 David Stone <ds.fslurp@asif.com>
 *
 * $RCSfile: fronius.h,v $
 * $Revision: 1.5 $
 * $Date: 2013/12/21 14:57:04 $
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both the
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 */

#ifndef _FRONIUS_H_
#define _FRONIUS_H_

#define FRONIUS_NUM_START_BYTES			3
#define FRONIUS_START_VALUE			((unsigned char)0x80)

struct FroniusRequest
{
	unsigned char startBytes[FRONIUS_NUM_START_BYTES];
	unsigned char length;
	unsigned char deviceOption;
	unsigned char deviceNumber;
	unsigned char command;
	unsigned char checksum;
};

struct FroniusResponseHeader
{
	unsigned char startBytes[FRONIUS_NUM_START_BYTES];
	unsigned char length;
	unsigned char deviceOption;
	unsigned char deviceNumber;
	unsigned char command;
};

// Inverters

#define FRONIUS_IG_15_INVERTER				0xFE
#define FRONIUS_IG_20_INVERTER				0xFD
#define FRONIUS_IG_30_INVERTER				0xFC
#define FRONIUS_IG_40_DUMMY_INVERTER			0xFB
#define FRONIUS_IG_40_INVERTER				0xFA
#define FRONIUS_IG_50_INVERTER				0x88
#define FRONIUS_IG_60_INVERTER				0xF9
#define FRONIUS_IG_300_INVERTER				0xF6
#define FRONIUS_IG_400_INVERTER				0xF5
#define FRONIUS_IG_500_INVERTER				0xF4
#define FRONIUS_IG_60_DUPLICATE_ID_INVERTER		0xF3
#define FRONIUS_IG_2000_INVERTER			0xEE
#define FRONIUS_IG_3000_INVERTER			0xED
#define FRONIUS_IG_4000_INVERTER			0xEB
#define FRONIUS_IG_5100_INVERTER			0xEA
#define FRONIUS_IG_2500_LV_INVERTER			0xE5
#define FRONIUS_IG_4500_LV_INVERTER			0xE3
#define FRONIUS_IG_PLUS_11_4_3_INVERTER			0xDF
#define FRONIUS_IG_PLUS_11_4_1_INVERTER			0xDE
#define FRONIUS_IG_PLUS_10_0_1_INVERTER			0xDD
#define FRONIUS_IG_PLUS_7_5_1_INVERTER			0xDC
#define FRONIUS_IG_PLUS_6_0_1_INVERTER			0xDB
#define FRONIUS_IG_PLUS_5_0_1_INVERTER			0xDA
#define FRONIUS_IG_PLUS_3_8_1_INVERTER			0xD9
#define FRONIUS_IG_PLUS_3_0_1_INVERTER			0xD8
#define FRONIUS_IG_PLUS_120_3_INVERTER			0xD7
#define FRONIUS_IG_PLUS_70_2_INVERTER			0xD6
#define FRONIUS_IG_PLUS_70_1_INVERTER			0xD5
#define FRONIUS_IG_PLUS_35_1_INVERTER			0xD4
#define FRONIUS_IG_PLUS_150_3_INVERTER			0xD3
#define FRONIUS_IG_PLUS_100_2_INVERTER			0xD2
#define FRONIUS_IG_PLUS_100_1_INVERTER			0xD1
#define FRONIUS_IG_PLUS_50_1_INVERTER			0xD0
#define FRONIUS_IG_PLUS_12_0_3_INVERTER			0xCF
#define FRONIUS_IG_TL_3_6_INVERTER			0xC1
#define FRONIUS_IG_TL_5_0_INVERTER			0xC0
#define FRONIUS_IG_TL_4_0_INVERTER			0xBF
#define FRONIUS_IG_TL_3_0_INVERTER			0xBE
#define FRONIUS_IG_TL_4_6_INVERTER			0xC3
#define FRONIUS_IG_TL_DUMMY_INVERTER			0xC2
#define FRONIUS_AGILO_75_0_3_OUTDOOR_INVERTER		0x74
#define FRONIUS_AGILO_100_0_3_OUTDOOR_INVERTER		0x75
#define FRONIUS_IG_PLUS_55V_1_INVERTER			0x76
#define FRONIUS_IG_PLUS_55V_2_INVERTER			0x77
#define FRONIUS_IG_PLUS_60V_2_INVERTER			0x80
#define FRONIUS_IG_PLUS_60V_1_INVERTER			0x81
#define FRONIUS_IG_PLUS_25V_1_INVERTER			0x83
#define FRONIUS_IG_PLUS_35V_1_INVERTER			0xB1
#define FRONIUS_IG_PLUS_50V_1_INVERTER			0xB0
#define FRONIUS_IG_PLUS_70V_1_INVERTER			0xAF
#define FRONIUS_IG_PLUS_70V_2_INVERTER			0xAE
#define FRONIUS_IG_PLUS_100V_1_INVERTER			0xAD
#define FRONIUS_IG_PLUS_100V_2_INVERTER			0xAC
#define FRONIUS_IG_PLUS_100V_3_INVERTER			0x84
#define FRONIUS_AGILO_100_0_3_INVERTER			0x85
#define FRONIUS_IG_PLUS_120V_3_INVERTER			0xAB
#define FRONIUS_IG_PLUS_150V_3_INVERTER			0xAA
#define FRONIUS_IG_PLUS_V_3_0_1_INVERTER		0xA9
#define FRONIUS_IG_PLUS_V_3_8_1_INVERTER		0xA8
#define FRONIUS_IG_PLUS_V_5_0_1_INVERTER		0xA7
#define FRONIUS_IG_PLUS_V_6_0_1_INVERTER		0xA6
#define FRONIUS_IG_PLUS_V_7_5_1_INVERTER		0xA5
#define FRONIUS_IG_PLUS_V_10_0_1_INVERTER		0xA4
#define FRONIUS_IG_PLUS_V_10_0_3_INVERTER		0x87
#define FRONIUS_IG_PLUS_30V_1_INVERTER			0x89
#define FRONIUS_IG_PLUS_V_11_4_1_INVERTER		0xA3
#define FRONIUS_IG_PLUS_V_11_4_3_INVERTER		0xA2
#define FRONIUS_IG_PLUS_V_12_0_3_INVERTER		0xA1
#define FRONIUS_IG_PLUS_50V_1_DUMMY_INVERTER		0xA0
#define FRONIUS_IG_PLUS_100V_2_DUMMY_INVERTER		0x9F
#define FRONIUS_IG_PLUS_150V_3_DUMMY_INVERTER		0x9E
#define FRONIUS_IG_PLUS_V_3_8_1_DUMMY_INVERTER		0x9D
#define FRONIUS_IG_PLUS_V_7_5_1_DUMMY_INVERTER		0x9C
#define FRONIUS_IG_PLUS_V_12_0_3_DUMMY_INVERTER		0x9B
#define FRONIUS_CL_36_0_INVERTER			0xBC
#define FRONIUS_CL_48_0_INVERTER			0xBD
#define FRONIUS_CL_60_0_INVERTER			0xC9
#define FRONIUS_CL_36_0_WYE277_INVERTER			0xB9
#define FRONIUS_CL_48_0_WYE277_INVERTER			0xBA
#define FRONIUS_CL_60_0_WYE277_INVERTER			0xBB
#define FRONIUS_CL_33_3_INVERTER			0xB6
#define FRONIUS_CL_44_4_INVERTER			0xB7
#define FRONIUS_CL_55_5_INVERTER			0xB8
#define FRONIUS_CL_60_0_DUMMY_INVERTER			0x9A
#define FRONIUS_CL_55_5_DUMMY_INVERTER			0x99
#define FRONIUS_CL_60_0_WYE277_DUMMY_INVERTER		0x98
#define FRONIUS_AGILO_75_0_3_INVERTER			0xE6
#define FRONIUS_AGILO_100_0_3_DUMMY_INVERTER		0xE7
#define FRONIUS_IG_PLUS_80V_3_INVERTER			0xF0
#define FRONIUS_IG_PLUS_60V_3_INVERTER			0xF1
#define FRONIUS_IG_PLUS_55V_3_INVERTER			0xF2
#define SUNPOWER_SPR_3501F_2_INVERTER			0x97

// Commands
#define FRONIUS_CMD_GET_VERSION				0x01
#define FRONIUS_CMD_GET_DEVICE_TYPE			0x02
#define FRONIUS_CMD_GET_DATE_TIME			0x03
#define FRONIUS_CMD_GET_ACTIVE_INVERTER_NUMBERS		0x04
#define FRONIUS_CMD_GET_ACTIVE_SENSOR_CARDS		0x05
#define FRONIUS_CMD_GET_SOLAR_NET_STATUS		0x06
#define FRONIUS_CMD_GET_POWER_NOW			0x10
#define FRONIUS_CMD_GET_ENERGY_TOTAL			0x11
#define FRONIUS_CMD_GET_ENERGY_DAY			0x12
#define FRONIUS_CMD_GET_ENERGY_YEAR			0x13
#define FRONIUS_CMD_GET_AC_CURRENT_NOW			0x14
#define FRONIUS_CMD_GET_AC_VOLTAGE_NOW			0x15
#define FRONIUS_CMD_GET_AC_FREQUENCY_NOW		0x16
#define FRONIUS_CMD_GET_DC_CURRENT_NOW			0x17
#define FRONIUS_CMD_GET_DC_VOLTAGE_NOW			0x18
#define FRONIUS_CMD_GET_YIELD_DAY			0x19
#define FRONIUS_CMD_GET_MAXIMUM_POWER_DAY		0x1a
#define FRONIUS_CMD_GET_MAXIMUM_AC_VOLTAGE_DAY		0x1b
#define FRONIUS_CMD_GET_MINIMUM_AC_VOLTAGE_DAY		0x1c
#define FRONIUS_CMD_GET_MAXIMUM_DC_VOLTAGE_DAY		0x1d
#define FRONIUS_CMD_GET_OPERATING_HOURS_DAY		0x1e
#define FRONIUS_CMD_GET_YIELD_YEAR			0x1f
#define FRONIUS_CMD_GET_MAXIMUM_POWER_YEAR		0x20
#define FRONIUS_CMD_GET_MAXIMUM_AC_VOLTAGE_YEAR		0x21
#define FRONIUS_CMD_GET_MINIMUM_AC_VOLTAGE_YEAR		0x22
#define FRONIUS_CMD_GET_MAXIMUM_DC_VOLTAGE_YEAR		0x23
#define FRONIUS_CMD_GET_OPERATING_HOURS_YEAR		0x24
#define FRONIUS_CMD_GET_YIELD_TOTAL			0x25
#define FRONIUS_CMD_GET_MAXIMUM_POWER_TOTAL		0x26
#define FRONIUS_CMD_GET_MAXIMUM_AC_VOLTAGE_TOTAL	0x27
#define FRONIUS_CMD_GET_MINIMUM_AC_VOLTAGE_TOTAL	0x28
#define FRONIUS_CMD_GET_MAXIMUM_DC_VOLTAGE_TOTAL	0x29
#define FRONIUS_CMD_GET_OPERATING_HOURS_TOTAL		0x2a

#define FRONIUS_CMD_GET_TEMPERATURE_CH1_NOW		0xe0
#define FRONIUS_CMD_GET_TEMPERATURE_CH2_NOW		0xe1
#define FRONIUS_CMD_GET_IRRADIANCE_NOW			0xe2
#define FRONIUS_CMD_GET_MINIMUM_TEMPERATURE_CH1_DAY	0xe3
#define FRONIUS_CMD_GET_MAXIMUM_TEMPERATURE_CH1_DAY	0xe4
#define FRONIUS_CMD_GET_MINIMUM_TEMPERATURE_CH1_YEAR	0xe5
#define FRONIUS_CMD_GET_MAXIMUM_TEMPERATURE_CH1_YEAR	0xe6
#define FRONIUS_CMD_GET_MINIMUM_TEMPERATURE_CH1_TOTAL	0xe7
#define FRONIUS_CMD_GET_MAXIMUM_TEMPERATURE_CH1_TOTAL	0xe8
#define FRONIUS_CMD_GET_MINIMUM_TEMPERATURE_CH2_DAY	0xe9
#define FRONIUS_CMD_GET_MAXIMUM_TEMPERATURE_CH2_DAY	0xea
#define FRONIUS_CMD_GET_MINIMUM_TEMPERATURE_CH2_YEAR	0xeb
#define FRONIUS_CMD_GET_MAXIMUM_TEMPERATURE_CH2_YEAR	0xec
#define FRONIUS_CMD_GET_MINIMUM_TEMPERATURE_CH2_TOTAL	0xed
#define FRONIUS_CMD_GET_MAXIMUM_TEMPERATURE_CH2_TOTAL	0xee
#define FRONIUS_CMD_GET_MAXIMUM_IRRADIANCE_DAY		0xef
#define FRONIUS_CMD_GET_MAXIMUM_IRRADIANCE_YEAR		0xf0
#define FRONIUS_CMD_GET_MAXIMUM_IRRADIANCE_TOTAL	0xf1
#define FRONIUS_CMD_GET_DIGITAL_CH1_NOW			0xf2
#define FRONIUS_CMD_GET_DIGITAL_CH2_NOW			0xf3
#define FRONIUS_CMD_GET_MAXIMUM_DIGITAL_CH1_DAY		0xf4
#define FRONIUS_CMD_GET_MAXIMUM_DIGITAL_CH1_YEAR	0xf5
#define FRONIUS_CMD_GET_MAXIMUM_DIGITAL_CH1_TOTAL	0xf6
#define FRONIUS_CMD_GET_MAXIMUM_DIGITAL_CH2_DAY		0xf7
#define FRONIUS_CMD_GET_MAXIMUM_DIGITAL_CH2_YEAR	0xf8
#define FRONIUS_CMD_GET_MAXIMUM_DIGITAL_CH2_TOTAL	0xf9

#define FRONIUS_ERROR					0x0e

// Protocol Error Info

#define FRONIUS_PROTOCOL_ERROR_UNKNOWN_COMMAND		0x01
#define FRONIUS_PROTOCOL_ERROR_TIMEOUT			0x02
#define FRONIUS_PROTOCOL_ERROR_INCORRECT_DATA_STRUCTURE	0x03
#define FRONIUS_PROTOCOL_ERROR_COMMAND_QUEUE_FULL	0x04
#define FRONIUS_PROTOCOL_ERROR_DEVICE_OR_OPTION_NA	0x05
#define FRONIUS_PROTOCOL_ERROR_NO_RESPONSE		0x06
#define FRONIUS_PROTOCOL_ERROR_SENSOR_ERROR		0x07
#define FRONIUS_PROTOCOL_ERROR_SENSOR_NOT_ACTIVE	0x08
#define FRONIUS_PROTOCOL_ERROR_INCORRECT_COMMAND	0x09
#define FRONIUS_PROTOCOL_ERROR_DEVICE_ID_COLLISION	0x0a

// values for the device/option byte
#define FRONIUS_INTERFACE_CARD			0
#define FRONIUS_INVERTER			1
#define FRONIUS_SENSOR_CARD			2
#define FRONIUS_IG_DATA_LOGGER			3
#define FRONIUS_OPTION_ID_RESERVED		4
#define FRONIUS_STRING_CONTROL			5

// Values for Inteface types
#define FRONIUS_INTERFACE_RS_232		1
#define FRONIUS_INTERFACE_CARD_EASY		2
#define FRONIUS_INTERFACE_RS_422		3

// values for the Solar Net Status
#define FRONIUS_SOLAR_NET_OK			1
#define FRONIUS_SOLAR_NET_ERROR			0

#define FRONIUS_MAXIMUM_INVERTERS		100

#endif /* _FRONIUS_H_ */

