#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <stdlib.h>
#include <string.h>
#include <linux/videodev2.h>
#include <linux/ivtv.h>

#define W 720
#define H 576

static unsigned char frame[W*H*3/2];

/*************************************************************************/
int main(int argc, char **argv)
{
	char *device = "/dev/video16";
	FILE *fin;
	int fd;
	struct ivtv_dma_frame df;

	if (argc > 1) device = argv[1];
	fin = stdin;

	fd = open(device, O_RDWR);

	if (fd == -1) {
		fprintf(stderr, "cannot open %s\n", device);
		exit(-1);
	}
	memset(&df, 0, sizeof(df));
	while (fread(frame, 1, sizeof(frame), fin)) {
		df.type = V4L2_BUF_TYPE_VIDEO_OUTPUT;
		df.y_source = frame;
		df.uv_source = frame + W*H;
		df.src.top = df.src.left = 0;
		df.src.height = H;
		df.src.width = W;
		df.dst.top = df.dst.left = 0;
		df.dst.height = H;
		df.dst.width = W;
		df.src_height = H;
		df.src_width = W;
		ioctl(fd, IVTV_IOC_DMA_FRAME, &df);
	}
	fclose(fin);
	return 0;
}
