/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include "stamp-pdbgen.h"

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpbase/gimpbase.h"

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimpcontext.h"
#include "core/gimpimage.h"
#include "core/gimpparamspecs.h"
#include "path/gimppath.h"
#include "path/gimpvectorlayer.h"

#include "gimppdb.h"
#include "gimppdberror.h"
#include "gimppdb-utils.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GimpValueArray *
vector_layer_new_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  GimpPath *path;
  GimpVectorLayer *layer = NULL;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  path = g_value_get_object (gimp_value_array_index (args, 1));

  if (success)
    {
      if (path == NULL)
        {
          g_set_error (error, GIMP_PDB_ERROR, GIMP_PDB_ERROR_INVALID_ARGUMENT,
                       _("Failed to create vector layer"));

          success = FALSE;
        }

      if (success)
        {
          layer = GIMP_VECTOR_LAYER (gimp_vector_layer_new (image, path, context));

          if (! layer)
            {
              g_set_error (error, GIMP_PDB_ERROR, GIMP_PDB_ERROR_INVALID_ARGUMENT,
                           _("Failed to create vector layer"));

              success = FALSE;
            }
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_object (gimp_value_array_index (return_vals, 1), layer);

  return return_vals;
}

static GimpValueArray *
vector_layer_refresh_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  GimpVectorLayer *layer;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      gimp_vector_layer_refresh (layer);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
vector_layer_discard_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  GimpVectorLayer *layer;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      gimp_vector_layer_discard (layer);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_vector_layer_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-vector-layer-new
   */
  procedure = gimp_procedure_new (vector_layer_new_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-vector-layer-new");
  gimp_procedure_set_static_help (procedure,
                                  "Creates a new vector layer.",
                                  "This procedure creates a new path layer displaying the specified @path. By default, the fill and stroke properties will be defined by the context.\n"
                                  "\n"
                                  "The new layer still needs to be added to the image as this is not automatic. Add the new layer with the [method@Image.insert_layer] method.\n"
                                  "\n"
                                  "The arguments are kept as simple as necessary for the basic case. All vector attributes, however, can be modified with the appropriate `gimp_vector_layer_set_*()` procedures.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_path ("path",
                                                     "path",
                                                     "The path to create the layer from",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_vector_layer ("layer",
                                                                 "layer",
                                                                 "The new vector layer. The object belongs to libgimp and you should not free it.",
                                                                 FALSE,
                                                                 GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-vector-layer-refresh
   */
  procedure = gimp_procedure_new (vector_layer_refresh_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-vector-layer-refresh");
  gimp_procedure_set_static_help (procedure,
                                  "Rerender the vector layer",
                                  "This procedure causes the vector layer to refresh itself after changes.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_vector_layer ("layer",
                                                             "layer",
                                                             "The vector layer",
                                                             FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-vector-layer-discard
   */
  procedure = gimp_procedure_new (vector_layer_discard_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-vector-layer-discard");
  gimp_procedure_set_static_help (procedure,
                                  "Discard the vector layer information.",
                                  "Discards the vector information. This makes the layer behave like a normal layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_vector_layer ("layer",
                                                             "layer",
                                                             "The vector layer",
                                                             FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
