/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.util.Map;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.utils.CommonUtils;

public class DatabaseProducerSettings
implements IDataTransferSettings {
    private static final int DEFAULT_SEGMENT_SIZE = 100000;
    private static final int DEFAULT_FETCH_SIZE = 10000;
    private int segmentSize = 100000;
    private boolean openNewConnections = true;
    private boolean queryRowCount = true;
    private boolean selectedRowsOnly = false;
    private boolean selectedColumnsOnly = false;
    private ExtractType extractType = ExtractType.SINGLE_QUERY;
    private int fetchSize = 10000;
    private boolean enableQmLogging = false;

    public int getSegmentSize() {
        return this.segmentSize;
    }

    public void setSegmentSize(int segmentSize) {
        if (segmentSize > 0) {
            this.segmentSize = segmentSize;
        }
    }

    public boolean isQueryRowCount() {
        return this.queryRowCount;
    }

    public void setQueryRowCount(boolean queryRowCount) {
        this.queryRowCount = queryRowCount;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public boolean isSelectedRowsOnly() {
        return this.selectedRowsOnly;
    }

    public void setSelectedRowsOnly(boolean selectedRowsOnly) {
        this.selectedRowsOnly = selectedRowsOnly;
    }

    public boolean isSelectedColumnsOnly() {
        return this.selectedColumnsOnly;
    }

    public void setSelectedColumnsOnly(boolean selectedColumnsOnly) {
        this.selectedColumnsOnly = selectedColumnsOnly;
    }

    public boolean isOpenNewConnections() {
        return this.openNewConnections;
    }

    public void setOpenNewConnections(boolean openNewConnections) {
        this.openNewConnections = openNewConnections;
    }

    public ExtractType getExtractType() {
        return this.extractType;
    }

    public void setExtractType(ExtractType extractType) {
        this.extractType = extractType;
    }

    public boolean isEnableQmLogging() {
        return this.enableQmLogging;
    }

    public void setEnableQmLogging(boolean enableQmLogging) {
        this.enableQmLogging = enableQmLogging;
    }

    @Override
    public void loadSettings(DBRRunnableContext runnableContext, DataTransferSettings dataTransferSettings, Map<String, Object> settings) {
        this.extractType = (ExtractType)CommonUtils.valueOf(ExtractType.class, (String)((String)settings.get("extractType")), (Enum)this.extractType);
        this.segmentSize = CommonUtils.toInt((Object)settings.get("segmentSize"), (int)100000);
        this.fetchSize = CommonUtils.toInt((Object)settings.get("fetchSize"), (int)this.fetchSize);
        this.openNewConnections = CommonUtils.toBoolean((Object)settings.get("openNewConnections"));
        this.queryRowCount = CommonUtils.toBoolean((Object)settings.get("queryRowCount"));
        this.selectedColumnsOnly = CommonUtils.toBoolean((Object)settings.get("selectedColumnsOnly"));
        this.selectedRowsOnly = CommonUtils.toBoolean((Object)settings.get("selectedRowsOnly"));
        this.enableQmLogging = CommonUtils.toBoolean((Object)settings.get("enableQmLogging"));
    }

    @Override
    public void saveSettings(Map<String, Object> settings) {
        settings.put("extractType", this.extractType.name());
        settings.put("segmentSize", this.segmentSize);
        settings.put("fetchSize", this.fetchSize);
        settings.put("openNewConnections", this.openNewConnections);
        settings.put("queryRowCount", this.queryRowCount);
        settings.put("selectedColumnsOnly", this.selectedColumnsOnly);
        settings.put("selectedRowsOnly", this.selectedRowsOnly);
        settings.put("enableQmLogging", this.enableQmLogging);
    }

    @Override
    public String getSettingsSummary() {
        StringBuilder summary = new StringBuilder();
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_checkbox_new_connection, this.openNewConnections);
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_extract_type, this.extractType.name());
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_checkbox_select_row_count, this.queryRowCount);
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_checkbox_selected_rows_only, this.selectedRowsOnly);
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_checkbox_selected_columns_only, this.selectedColumnsOnly);
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_checkbox_enable_qm_logging, this.enableQmLogging);
        return summary.toString();
    }

    public static enum ExtractType {
        SINGLE_QUERY,
        SEGMENTS;

    }
}

