/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.TextEditProcessor;
import org.eclipse.text.edits.UndoEdit;

public abstract class TextChange
extends TextEditBasedChange {
    private TextEdit fEdit;
    private TextEditCopier fCopier;

    protected TextChange(String name) {
        super(name);
    }

    public void setEdit(TextEdit edit) {
        Assert.isTrue((this.fEdit == null ? 1 : 0) != 0, (String)"Root edit can only be set once");
        Assert.isTrue((edit != null ? 1 : 0) != 0);
        this.fEdit = edit;
    }

    public TextEdit getEdit() {
        return this.fEdit;
    }

    @Override
    public void addTextEditGroup(TextEditGroup group) {
        this.addTextEditChangeGroup(new TextEditChangeGroup(this, group));
    }

    public void addTextEditChangeGroup(TextEditChangeGroup group) {
        Assert.isTrue((this.fEdit != null ? 1 : 0) != 0, (String)"Can only add a description if a root edit exists");
        this.addChangeGroup(group);
    }

    public TextEditChangeGroup[] getTextEditChangeGroups() {
        TextEditBasedChangeGroup[] groups = this.getChangeGroups();
        TextEditChangeGroup[] result = new TextEditChangeGroup[groups.length];
        System.arraycopy(groups, 0, result, 0, groups.length);
        return result;
    }

    public void addEdit(TextEdit edit) throws MalformedTreeException {
        Assert.isTrue((this.fEdit != null ? 1 : 0) != 0, (String)"root must exist to add an edit");
        this.fEdit.addChild(edit);
    }

    protected abstract IDocument acquireDocument(IProgressMonitor var1) throws CoreException;

    protected abstract void commit(IDocument var1, IProgressMonitor var2) throws CoreException;

    protected abstract void releaseDocument(IDocument var1, IProgressMonitor var2) throws CoreException;

    protected abstract Change createUndoChange(UndoEdit var1);

    @Override
    public Change perform(IProgressMonitor pm) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)pm, (int)3);
        IDocument document = null;
        try {
            document = this.acquireDocument((IProgressMonitor)subMon.newChild(1));
            UndoEdit undo = this.performEdits(document);
            this.commit(document, (IProgressMonitor)subMon.newChild(1));
            Change change = this.createUndoChange(undo);
            return change;
        }
        catch (BadLocationException e) {
            throw Changes.asCoreException(e);
        }
        catch (MalformedTreeException e) {
            throw Changes.asCoreException(e);
        }
        finally {
            this.releaseDocument(document, (IProgressMonitor)subMon.newChild(1));
            subMon.done();
        }
    }

    protected UndoEdit performEdits(IDocument document) throws BadLocationException, MalformedTreeException {
        DocumentRewriteSession session = null;
        try {
            if (document instanceof IDocumentExtension4) {
                session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
            }
            LinkedModeModel.closeAllModels((IDocument)document);
            TextEditProcessor processor = this.createTextEditProcessor(document, 1, false);
            UndoEdit undoEdit = processor.performEdits();
            return undoEdit;
        }
        finally {
            if (session != null) {
                ((IDocumentExtension4)document).stopRewriteSession(session);
            }
        }
    }

    public IDocument getCurrentDocument(IProgressMonitor pm) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)pm, (int)2);
        IDocument result = null;
        try {
            result = this.acquireDocument((IProgressMonitor)subMon.newChild(1));
        }
        finally {
            this.releaseDocument(result, (IProgressMonitor)subMon.newChild(1));
        }
        subMon.done();
        return result;
    }

    @Override
    public String getCurrentContent(IProgressMonitor pm) throws CoreException {
        return this.getCurrentDocument(pm).get();
    }

    @Override
    public String getCurrentContent(IRegion region, boolean expandRegionToFullLine, int surroundingLines, IProgressMonitor pm) throws CoreException {
        Assert.isNotNull((Object)region);
        Assert.isTrue((surroundingLines >= 0 ? 1 : 0) != 0);
        IDocument document = this.getCurrentDocument(pm);
        Assert.isTrue((document.getLength() >= region.getOffset() + region.getLength() ? 1 : 0) != 0);
        return this.getContent(document, region, expandRegionToFullLine, surroundingLines);
    }

    public TextEdit getPreviewEdit(TextEdit original) {
        Assert.isTrue((this.getKeepPreviewEdits() && this.fCopier != null && original != null ? 1 : 0) != 0);
        return this.fCopier.getCopy(original);
    }

    public TextEdit[] getPreviewEdits(TextEdit[] originals) {
        Assert.isTrue((this.getKeepPreviewEdits() && this.fCopier != null && originals != null ? 1 : 0) != 0);
        if (originals.length == 0) {
            return new TextEdit[0];
        }
        ArrayList<TextEdit> result = new ArrayList<TextEdit>(originals.length);
        TextEdit[] textEditArray = originals;
        int n = originals.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit original = textEditArray[n2];
            TextEdit copy = this.fCopier.getCopy(original);
            if (copy != null) {
                result.add(copy);
            }
            ++n2;
        }
        return result.toArray(new TextEdit[result.size()]);
    }

    public IDocument getPreviewDocument(IProgressMonitor pm) throws CoreException {
        TextEditBasedChange.PreviewAndRegion result = this.getPreviewDocument(ALL_EDITS, pm);
        return result.document;
    }

    @Override
    public String getPreviewContent(IProgressMonitor pm) throws CoreException {
        return this.getPreviewDocument(pm).get();
    }

    public String getPreviewContent(TextEditChangeGroup[] changeGroups, IRegion region, boolean expandRegionToFullLine, int surroundingLines, IProgressMonitor pm) throws CoreException {
        return this.getPreviewContent((TextEditBasedChangeGroup[])changeGroups, region, expandRegionToFullLine, surroundingLines, pm);
    }

    @Override
    public String getPreviewContent(TextEditBasedChangeGroup[] changeGroups, IRegion region, boolean expandRegionToFullLine, int surroundingLines, IProgressMonitor pm) throws CoreException {
        IRegion currentRegion = this.getRegion(changeGroups);
        Assert.isTrue((region.getOffset() <= currentRegion.getOffset() && currentRegion.getOffset() + currentRegion.getLength() <= region.getOffset() + region.getLength() ? 1 : 0) != 0);
        TextEdit root = this.getEdit();
        Assert.isNotNull((Object)root, (String)"No root edit");
        TextEditBasedChangeGroup[] textEditBasedChangeGroupArray = changeGroups;
        int n = changeGroups.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit[] edits;
            TextEditBasedChangeGroup group = textEditBasedChangeGroupArray[n2];
            TextEdit[] textEditArray = edits = group.getTextEdits();
            int n3 = edits.length;
            int n4 = 0;
            while (n4 < n3) {
                TextEdit edit = textEditArray[n4];
                Assert.isTrue((root == edit.getRoot() ? 1 : 0) != 0, (String)"Wrong root edit");
                ++n4;
            }
            ++n2;
        }
        TextEditBasedChange.PreviewAndRegion result = this.getPreviewDocument(changeGroups, pm);
        int delta = result.region == null ? -currentRegion.getLength() : result.region.getLength() - currentRegion.getLength();
        return this.getContent(result.document, (IRegion)new Region(region.getOffset(), region.getLength() + delta), expandRegionToFullLine, surroundingLines);
    }

    private TextEditBasedChange.PreviewAndRegion getPreviewDocument(TextEditBasedChangeGroup[] changes, IProgressMonitor pm) throws CoreException {
        Document document = new Document(this.getCurrentDocument(pm).get());
        boolean trackChanges = this.getKeepPreviewEdits();
        this.setKeepPreviewEdits(true);
        TextEditProcessor processor = changes == ALL_EDITS ? this.createTextEditProcessor((IDocument)document, 0, true) : this.createTextEditProcessor((IDocument)document, 0, changes);
        try {
            processor.performEdits();
            TextEditBasedChange.PreviewAndRegion previewAndRegion = new TextEditBasedChange.PreviewAndRegion((IDocument)document, this.getNewRegion(changes));
            return previewAndRegion;
        }
        catch (BadLocationException e) {
            throw Changes.asCoreException(e);
        }
        finally {
            this.setKeepPreviewEdits(trackChanges);
        }
    }

    private TextEditProcessor createTextEditProcessor(IDocument document, int flags, boolean preview) {
        TextEditBasedChangeGroup[] groups;
        if (this.fEdit == null) {
            return new TextEditProcessor(document, (TextEdit)new MultiTextEdit(0, 0), flags);
        }
        ArrayList<TextEdit> excludes = new ArrayList<TextEdit>(0);
        TextEditBasedChangeGroup[] textEditBasedChangeGroupArray = groups = this.getChangeGroups();
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            TextEditBasedChangeGroup edit = textEditBasedChangeGroupArray[n2];
            if (!edit.isEnabled()) {
                excludes.addAll(Arrays.asList(edit.getTextEditGroup().getTextEdits()));
            }
            ++n2;
        }
        if (preview) {
            this.fCopier = new TextEditCopier(this.fEdit);
            TextEdit copiedEdit = this.fCopier.perform();
            boolean keep = this.getKeepPreviewEdits();
            if (keep) {
                flags |= 2;
            }
            TextEditBasedChange.LocalTextEditProcessor result = new TextEditBasedChange.LocalTextEditProcessor(document, copiedEdit, flags);
            result.setExcludes(this.mapEdits(excludes.toArray(new TextEdit[excludes.size()]), this.fCopier));
            if (!keep) {
                this.fCopier = null;
            }
            return result;
        }
        TextEditBasedChange.LocalTextEditProcessor result = new TextEditBasedChange.LocalTextEditProcessor(document, this.fEdit, flags | 2);
        result.setExcludes(excludes.toArray(new TextEdit[excludes.size()]));
        return result;
    }

    private TextEditProcessor createTextEditProcessor(IDocument document, int flags, TextEditBasedChangeGroup[] changes) {
        if (this.fEdit == null) {
            return new TextEditProcessor(document, (TextEdit)new MultiTextEdit(0, 0), flags);
        }
        ArrayList<TextEdit> includes = new ArrayList<TextEdit>(0);
        TextEditBasedChangeGroup[] textEditBasedChangeGroupArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            TextEditBasedChangeGroup change = textEditBasedChangeGroupArray[n2];
            Assert.isTrue((change.getTextEditChange() == this ? 1 : 0) != 0);
            if (change.isEnabled()) {
                includes.addAll(Arrays.asList(change.getTextEditGroup().getTextEdits()));
            }
            ++n2;
        }
        this.fCopier = new TextEditCopier(this.fEdit);
        TextEdit copiedEdit = this.fCopier.perform();
        boolean keep = this.getKeepPreviewEdits();
        if (keep) {
            flags |= 2;
        }
        TextEditBasedChange.LocalTextEditProcessor result = new TextEditBasedChange.LocalTextEditProcessor(document, copiedEdit, flags);
        result.setIncludes(this.mapEdits(includes.toArray(new TextEdit[includes.size()]), this.fCopier));
        if (!keep) {
            this.fCopier = null;
        }
        return result;
    }

    private IRegion getRegion(TextEditBasedChangeGroup[] changes) {
        if (changes == ALL_EDITS) {
            if (this.fEdit == null) {
                return null;
            }
            return this.fEdit.getRegion();
        }
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        TextEditBasedChangeGroup[] textEditBasedChangeGroupArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            TextEditBasedChangeGroup change = textEditBasedChangeGroupArray[n2];
            edits.addAll(Arrays.asList(change.getTextEditGroup().getTextEdits()));
            ++n2;
        }
        if (edits.isEmpty()) {
            return null;
        }
        return TextEdit.getCoverage((TextEdit[])edits.toArray(new TextEdit[edits.size()]));
    }

    private IRegion getNewRegion(TextEditBasedChangeGroup[] changes) {
        if (changes == ALL_EDITS) {
            if (this.fEdit == null) {
                return null;
            }
            return this.fCopier.getCopy(this.fEdit).getRegion();
        }
        ArrayList<TextEdit> result = new ArrayList<TextEdit>();
        TextEditBasedChangeGroup[] textEditBasedChangeGroupArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit[] edits;
            TextEditBasedChangeGroup change = textEditBasedChangeGroupArray[n2];
            TextEdit[] textEditArray = edits = change.getTextEditGroup().getTextEdits();
            int n3 = edits.length;
            int n4 = 0;
            while (n4 < n3) {
                TextEdit edit = textEditArray[n4];
                TextEdit copy = this.fCopier.getCopy(edit);
                if (copy != null) {
                    result.add(copy);
                }
                ++n4;
            }
            ++n2;
        }
        if (result.isEmpty()) {
            return null;
        }
        return TextEdit.getCoverage((TextEdit[])result.toArray(new TextEdit[result.size()]));
    }

    @Override
    public void setKeepPreviewEdits(boolean keep) {
        super.setKeepPreviewEdits(keep);
        if (!keep) {
            this.fCopier = null;
        }
    }
}

