/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;
import sun.awt.dnd.SunDragSourceContextPeer;

class CMouseDragGestureRecognizer
extends MouseDragGestureRecognizer {
    private static final int fMotionThreshold = CMouseDragGestureRecognizer.getMotionThreshold();
    private static final int kDefaultMotionThreshold = 3;
    protected static final int ButtonMask = 7168;

    private static int getMotionThreshold() {
        try {
            return (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
        }
        catch (Exception exception) {
            return 3;
        }
    }

    protected CMouseDragGestureRecognizer(DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        super(dragSource, component, n, dragGestureListener);
    }

    protected CMouseDragGestureRecognizer(DragSource dragSource, Component component, int n) {
        this(dragSource, component, n, null);
    }

    protected CMouseDragGestureRecognizer(DragSource dragSource, Component component) {
        this(dragSource, component, 0);
    }

    protected CMouseDragGestureRecognizer(DragSource dragSource) {
        this(dragSource, null);
    }

    protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        int n2 = n & 0x1C00;
        return SunDragSourceContextPeer.convertModifiersToDropAction(n, this.getSourceActions());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.events.clear();
        if (this.mapDragOperationFromModifiers(mouseEvent) != 0) {
            this.appendEvent(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.events.clear();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.events.clear();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        int n;
        if (!this.events.isEmpty() && (n = this.mapDragOperationFromModifiers(mouseEvent)) == 0) {
            this.events.clear();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.events.isEmpty()) {
            int n = this.mapDragOperationFromModifiers(mouseEvent);
            if (n == 0) {
                return;
            }
            MouseEvent mouseEvent2 = (MouseEvent)this.events.get(0);
            Point point = mouseEvent2.getPoint();
            Point point2 = mouseEvent.getPoint();
            int n2 = Math.abs(point.x - point2.x);
            int n3 = Math.abs(point.y - point2.y);
            if (n2 >= fMotionThreshold || n3 >= fMotionThreshold) {
                this.fireDragGestureRecognized(n, ((MouseEvent)this.getTriggerEvent()).getPoint());
            } else {
                this.appendEvent(mouseEvent);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

