/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.awt.SelectionMouseEvent;
import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaBorder;
import com.apple.laf.AquaComboBoxRenderer;
import com.apple.laf.AquaFocusHandler;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class AquaListUI
extends BasicListUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaListUI();
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.list.getActionMap().put("aquaHome", new AquaHomeEndAction(true));
        this.list.getActionMap().put("aquaEnd", new AquaHomeEndAction(false));
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new AquaPropertyChangeHandler();
    }

    JList getComponent() {
        return this.list;
    }

    protected void repaintCell(Object object, int n, boolean bl) {
        AquaComboBoxRenderer aquaComboBoxRenderer;
        Rectangle rectangle = this.getCellBounds(this.list, n, n);
        if (rectangle == null) {
            return;
        }
        ListCellRenderer<Object> listCellRenderer = this.list.getCellRenderer();
        if (listCellRenderer == null) {
            return;
        }
        Component component = listCellRenderer.getListCellRendererComponent(this.list, object, n, bl, true);
        if (component == null) {
            return;
        }
        AquaComboBoxRenderer aquaComboBoxRenderer2 = aquaComboBoxRenderer = listCellRenderer instanceof AquaComboBoxRenderer ? (AquaComboBoxRenderer)listCellRenderer : null;
        if (aquaComboBoxRenderer != null) {
            aquaComboBoxRenderer.setDrawCheckedItem(false);
        }
        this.rendererPane.paintComponent(this.list.getGraphics().create(), component, this.list, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        if (aquaComboBoxRenderer != null) {
            aquaComboBoxRenderer.setDrawCheckedItem(true);
        }
    }

    public static Border getSourceListBackgroundPainter() {
        ComponentPainter componentPainter = new ComponentPainter();
        ((JRSUIState)componentPainter.painter.state).set(JRSUIConstants.Widget.GRADIENT);
        ((JRSUIState)componentPainter.painter.state).set(JRSUIConstants.Variant.GRADIENT_SIDE_BAR);
        return componentPainter;
    }

    public static Border getSourceListSelectionBackgroundPainter() {
        ComponentPainter componentPainter = new ComponentPainter();
        ((JRSUIState)componentPainter.painter.state).set(JRSUIConstants.Widget.GRADIENT);
        ((JRSUIState)componentPainter.painter.state).set(JRSUIConstants.Variant.GRADIENT_SIDE_BAR_SELECTION);
        return componentPainter;
    }

    public static Border getSourceListFocusedSelectionBackgroundPainter() {
        ComponentPainter componentPainter = new ComponentPainter();
        ((JRSUIState)componentPainter.painter.state).set(JRSUIConstants.Widget.GRADIENT);
        ((JRSUIState)componentPainter.painter.state).set(JRSUIConstants.Variant.GRADIENT_SIDE_BAR_FOCUSED_SELECTION);
        return componentPainter;
    }

    public static Border getListEvenBackgroundPainter() {
        ComponentPainter componentPainter = new ComponentPainter();
        ((JRSUIState)componentPainter.painter.state).set(JRSUIConstants.Widget.GRADIENT);
        ((JRSUIState)componentPainter.painter.state).set(JRSUIConstants.Variant.GRADIENT_LIST_BACKGROUND_EVEN);
        return componentPainter;
    }

    public static Border getListOddBackgroundPainter() {
        ComponentPainter componentPainter = new ComponentPainter();
        ((JRSUIState)componentPainter.painter.state).set(JRSUIConstants.Widget.GRADIENT);
        ((JRSUIState)componentPainter.painter.state).set(JRSUIConstants.Variant.GRADIENT_LIST_BACKGROUND_ODD);
        return componentPainter;
    }

    static class ComponentPainter
    extends AquaBorder.Default {
        ComponentPainter() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JComponent jComponent;
            JComponent jComponent2 = jComponent = component instanceof JComponent ? (JComponent)component : null;
            if (jComponent != null && !AquaFocusHandler.isActive(jComponent)) {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.State.INACTIVE);
            } else {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.State.ACTIVE);
            }
            super.paintBorder(component, graphics, n, n2, n3, n4);
        }
    }

    class MouseInputHandler
    extends BasicListUI.MouseInputHandler {
        MouseInputHandler() {
            super(AquaListUI.this);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(new SelectionMouseEvent(mouseEvent));
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(new SelectionMouseEvent(mouseEvent));
        }
    }

    class AquaPropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        AquaPropertyChangeHandler() {
            super(AquaListUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("Frame.active".equals(string)) {
                AquaBorder.repaintBorder(AquaListUI.this.getComponent());
                AquaFocusHandler.swapSelectionColors("List", AquaListUI.this.getComponent(), propertyChangeEvent.getNewValue());
            } else {
                super.propertyChange(propertyChangeEvent);
            }
        }
    }

    class FocusHandler
    extends BasicListUI.FocusHandler {
        FocusHandler() {
            super(AquaListUI.this);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            AquaBorder.repaintBorder(AquaListUI.this.getComponent());
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            super.focusLost(focusEvent);
            AquaBorder.repaintBorder(AquaListUI.this.getComponent());
        }
    }

    static class AquaHomeEndAction
    extends AbstractAction {
        private boolean fHomeAction = false;

        protected AquaHomeEndAction(boolean bl) {
            this.fHomeAction = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = (JList)actionEvent.getSource();
            if (this.fHomeAction) {
                jList.ensureIndexIsVisible(0);
            } else {
                int n = jList.getModel().getSize();
                jList.ensureIndexIsVisible(n - 1);
            }
        }
    }
}

