/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class AquaTableHeaderBorder
extends AbstractBorder {
    protected static final int SORT_NONE = 0;
    protected static final int SORT_ASCENDING = 1;
    protected static final int SORT_DECENDING = -1;
    protected final Insets editorBorderInsets = new Insets(1, 3, 1, 3);
    protected final AquaPainter<JRSUIState> painter = AquaPainter.create(JRSUIState.getInstance());
    protected boolean doPaint = true;
    static Border alternateBorder;
    private boolean selected = false;
    private int fHorizontalShift = 0;
    private int sortOrder = 0;

    protected static AquaTableHeaderBorder getListHeaderBorder() {
        return new AquaTableHeaderBorder();
    }

    protected AquaTableHeaderBorder() {
        ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentHorizontal.LEFT);
        ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentVertical.TOP);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (!this.doPaint) {
            return;
        }
        JComponent jComponent = (JComponent)component;
        Color color = jComponent.getBackground();
        if (!(color instanceof UIResource)) {
            this.doPaint = false;
            jComponent.paint(graphics);
            AquaTableHeaderBorder.getAlternateBorder().paintBorder(jComponent, graphics, n, n2, n3, n4);
            this.doPaint = true;
            return;
        }
        JRSUIConstants.State state = this.getState(jComponent);
        ((JRSUIState)this.painter.state).set(state);
        ((JRSUIState)this.painter.state).set(jComponent.hasFocus() ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        ((JRSUIState)this.painter.state).set(n4 > 16 ? JRSUIConstants.Widget.BUTTON_BEVEL : JRSUIConstants.Widget.BUTTON_LIST_HEADER);
        ((JRSUIState)this.painter.state).set(this.selected ? JRSUIConstants.BooleanValue.YES : JRSUIConstants.BooleanValue.NO);
        switch (this.sortOrder) {
            case 1: {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.Direction.UP);
                break;
            }
            case -1: {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.Direction.DOWN);
                break;
            }
            default: {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.Direction.NONE);
            }
        }
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        this.painter.paint(graphics, component, n5 - 1, n6 - 1, n7 + 1, n8);
        graphics.clipRect(n5, n2, n7, n4);
        graphics.translate(this.fHorizontalShift, -1);
        this.doPaint = false;
        jComponent.paint(graphics);
        this.doPaint = true;
    }

    protected JRSUIConstants.State getState(JComponent jComponent) {
        if (!jComponent.isEnabled()) {
            return JRSUIConstants.State.DISABLED;
        }
        JRootPane jRootPane = jComponent.getRootPane();
        if (jRootPane == null) {
            return JRSUIConstants.State.ACTIVE;
        }
        if (!AquaFocusHandler.isActive(jRootPane)) {
            return JRSUIConstants.State.INACTIVE;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    protected static Border getAlternateBorder() {
        if (alternateBorder == null) {
            alternateBorder = BorderFactory.createRaisedBevelBorder();
        }
        return alternateBorder;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.editorBorderInsets;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.left = this.editorBorderInsets.left;
        insets.top = this.editorBorderInsets.top;
        insets.right = this.editorBorderInsets.right;
        insets.bottom = this.editorBorderInsets.bottom;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    protected void setSelected(boolean bl) {
        this.selected = bl;
    }

    protected void setHorizontalShift(int n) {
        this.fHorizontalShift = n;
    }

    protected void setSortOrder(int n) {
        if (n < -1 || n > 1) {
            throw new IllegalArgumentException("Invalid sort order constant: " + n);
        }
        this.sortOrder = n;
    }
}

