/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaBorder;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.text.JTextComponent;

public class AquaTextFieldBorder
extends AquaBorder {
    protected static final AquaUtils.LazySingleton<AquaTextFieldBorder> instance = new AquaUtils.LazySingletonFromDefaultContructor<AquaTextFieldBorder>(AquaTextFieldBorder.class);

    public static AquaTextFieldBorder getTextFieldBorder() {
        return instance.get();
    }

    public AquaTextFieldBorder() {
        this(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant().alterMargins(6, 7, 6, 7).alterInsets(3, 3, 3, 3)));
        ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.FRAME_TEXT_FIELD);
        ((JRSUIState)this.painter.state).set(JRSUIConstants.FrameOnly.YES);
        ((JRSUIState)this.painter.state).set(JRSUIConstants.Size.LARGE);
    }

    public AquaTextFieldBorder(AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
        super(sizeDescriptor);
    }

    public AquaTextFieldBorder(AquaTextFieldBorder aquaTextFieldBorder) {
        super(aquaTextFieldBorder);
    }

    @Override
    protected void setSize(JRSUIConstants.Size size) {
        super.setSize(size);
        ((JRSUIState)this.painter.state).set(JRSUIConstants.Size.LARGE);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (!(component instanceof JTextComponent)) {
            ((JRSUIState)this.painter.state).set(JRSUIConstants.State.ACTIVE);
            ((JRSUIState)this.painter.state).set(JRSUIConstants.Focused.NO);
            this.painter.paint(graphics, component, n, n2, n3, n4);
            return;
        }
        JTextComponent jTextComponent = (JTextComponent)component;
        JRSUIConstants.State state = AquaTextFieldBorder.getStateFor(jTextComponent);
        ((JRSUIState)this.painter.state).set(state);
        ((JRSUIState)this.painter.state).set(JRSUIConstants.State.ACTIVE == state && jTextComponent.hasFocus() ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        if (jTextComponent.isOpaque()) {
            this.painter.paint(graphics, component, n, n2, n3, n4);
            return;
        }
        int n5 = AquaTextFieldBorder.getShrinkageFor(jTextComponent, n4);
        Insets insets = this.getSubInsets(n5);
        n += insets.left;
        n2 += insets.top;
        n3 -= insets.left + insets.right;
        n4 -= insets.top + insets.bottom;
        if (n5 > 0) {
            Rectangle rectangle = graphics.getClipBounds();
            rectangle.x += n5;
            rectangle.width -= n5 * 2;
            graphics.setClip(rectangle);
        }
        this.painter.paint(graphics, component, n, n2, n3, n4);
    }

    static int getShrinkageFor(JTextComponent jTextComponent, int n) {
        if (jTextComponent == null) {
            return 0;
        }
        TextUI textUI = jTextComponent.getUI();
        if (textUI == null) {
            return 0;
        }
        Dimension dimension = textUI.getPreferredSize(jTextComponent);
        if (dimension == null) {
            return 0;
        }
        int n2 = dimension.height - n;
        return n2 < 0 ? 0 : (n2 > 3 ? 3 : n2);
    }

    protected Insets getSubInsets(int n) {
        Insets insets = this.sizeVariant.insets;
        if (n > 0) {
            return new InsetsUIResource(insets.top - n, insets.left, insets.bottom - n, insets.right);
        }
        return insets;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        if (!(component instanceof JTextComponent) || component.isOpaque()) {
            return new InsetsUIResource(3, 7, 3, 7);
        }
        return new InsetsUIResource(6, 7, 6, 7);
    }

    protected static JRSUIConstants.State getStateFor(JTextComponent jTextComponent) {
        if (!AquaFocusHandler.isActive(jTextComponent)) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (!jTextComponent.isEnabled()) {
            return JRSUIConstants.State.DISABLED;
        }
        if (!jTextComponent.isEditable()) {
            return JRSUIConstants.State.DISABLED;
        }
        return JRSUIConstants.State.ACTIVE;
    }
}

